# BUG#33862 completely failed DROP USER statement gets replicated
--source include/master-slave.inc

#
# remove all users will be used in the test
#
connection master;
set session sql_log_bin=0;
delete from mysql.user where Host='fakehost';
set session sql_log_bin=1;

connection slave;
set session sql_log_bin=0;
delete from mysql.user where Host='fakehost';
set session sql_log_bin=1;

#
# Test create user
#
connection master;
create user 'foo'@'fakehost';
--error ER_CANNOT_USER
create user 'foo'@'fakehost', 'bar'@'fakehost';
--error ER_CANNOT_USER
create user 'foo'@'fakehost', 'bar'@'fakehost';

# In log event, Plaintext password 'foo1' is replaced by ciphertext.
create user 'foo1'@'fakehost' IDENTIFIED BY 'foo1', 'foo2'@'fakehost'
  IDENTIFIED BY PASSWORD'*1111111111111111111111111111111111111111',
  'foo3'@'fakehost';
--source include/sync_slave_sql_with_master.inc
select Host,User from mysql.user where Host='fakehost';
--let $diff_tables= master:mysql.user, slave:mysql.user
source include/diff_tables.inc;

#
# Test rename user
#
connection master;
rename user 'foo'@'fakehost' to 'foofoo'@'fakehost';
--error ER_CANNOT_USER
rename user 'not_exist_user1'@'fakehost' to 'foobar'@'fakehost', 'bar'@'fakehost' to 'barbar'@'fakehost';
--error ER_CANNOT_USER
rename user 'not_exist_user1'@'fakehost' to 'foobar'@'fakehost', 'not_exist_user2'@'fakehost' to 'barfoo'@'fakehost';

--source include/sync_slave_sql_with_master.inc
select Host,User from mysql.user where Host='fakehost';

#
# Test drop user
#
connection master;
drop user 'foofoo'@'fakehost';
drop user 'foo1'@'fakehost', 'foo2'@'fakehost', 'foo3'@'fakehost';
--error ER_CANNOT_USER
drop user 'not_exist_user1'@'fakehost', 'barbar'@'fakehost';
--error ER_CANNOT_USER
drop user 'not_exist_user1'@'fakehost', 'not_exist_user2'@'fakehost';

--source include/sync_slave_sql_with_master.inc
select Host,User from mysql.user where Host='fakehost';


--echo #
--echo # WL2392: "Change Password at next login" (initial default for root)
--echo #

connection master;
CREATE USER must_change2@localhost IDENTIFIED BY 'aha';
ALTER USER must_change2@localhost PASSWORD EXPIRE;
--source include/sync_slave_sql_with_master.inc
select Host,User,password_expired from mysql.user where user='must_change2';

connect(must_change_con_slave,localhost,must_change2,aha,test,$SLAVE_MYPORT,);
connection must_change_con_slave;
--echo # must throw an error
--error ER_MUST_CHANGE_PASSWORD
SELECT USER();
connection master;
disconnect must_change_con_slave;

connect(must_change_con_master,localhost,must_change2,aha);
connection must_change_con_master;
--echo # setting a password unlocks it
SET PASSWORD = 'aha2';
connection master;
disconnect must_change_con_master;

--source include/sync_slave_sql_with_master.inc
connection master;

connect(must_change_con_slave,localhost,must_change2,aha2,test,$SLAVE_MYPORT,);
connection must_change_con_slave;
--echo # must not throw an error
SELECT USER();
connection master;
disconnect must_change_con_slave;

DROP USER must_change2@localhost;

--source include/sync_slave_sql_with_master.inc
connection master;

#
# show the binlog events on the master
#
connection master;
source include/show_binlog_events.inc;
--source include/rpl_end.inc
