/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.CompositeEditor;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorContext;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.EditorVisitor;
import com.google.gwt.editor.client.HasEditorDelegate;
import com.google.gwt.editor.client.HasEditorErrors;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.ValueAwareEditor;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditorContext<T>
implements EditorContext<T> {
    private final String path;
    private final CompositeEditor<?, ?, ?> compositeEditor;
    private AbstractEditorDelegate<T, ?> delegate;
    private final Editor<T> editor;
    private final HasEditorDelegate<T> hasEditorDelegate;
    private final HasEditorErrors<T> hasEditorErrors;
    private boolean isHalted;
    private final LeafValueEditor<T> leafValueEditor;
    private final ValueAwareEditor<T> valueAwareEditor;

    public AbstractEditorContext(Editor<T> editor, String path) {
        this.editor = editor;
        this.path = path;
        this.compositeEditor = editor instanceof CompositeEditor ? (CompositeEditor)editor : null;
        this.hasEditorDelegate = editor instanceof HasEditorDelegate ? (HasEditorDelegate)editor : null;
        this.hasEditorErrors = editor instanceof HasEditorErrors ? (HasEditorErrors)editor : null;
        this.leafValueEditor = editor instanceof LeafValueEditor ? (LeafValueEditor)editor : null;
        this.valueAwareEditor = editor instanceof ValueAwareEditor ? (ValueAwareEditor)editor : null;
    }

    @Override
    public CompositeEditor<T, ?, ?> asCompositeEditor() {
        return this.compositeEditor;
    }

    @Override
    public HasEditorDelegate<T> asHasEditorDelegate() {
        return this.hasEditorDelegate;
    }

    @Override
    public HasEditorErrors<T> asHasEditorErrors() {
        return this.hasEditorErrors;
    }

    @Override
    public LeafValueEditor<T> asLeafValueEditor() {
        return this.leafValueEditor;
    }

    @Override
    public ValueAwareEditor<T> asValueAwareEditor() {
        return this.valueAwareEditor;
    }

    @Override
    public abstract boolean canSetInModel();

    @Override
    public abstract T checkAssignment(Object var1);

    public void doTraverseSyntheticCompositeEditor(EditorVisitor visitor) {
        Object sample = this.asCompositeEditor().createEditorForTraversal();
        AbstractEditorDelegate<?, ?> subDelegate = this.delegate.createComposedDelegate();
        this.delegate.addSubDelegate(subDelegate, this.path, sample);
        this.delegate.getEditorChain().traverse(visitor, subDelegate);
    }

    @Override
    public String getAbsolutePath() {
        return this.path;
    }

    @Override
    public abstract Class<T> getEditedType();

    @Override
    public Editor<T> getEditor() {
        return this.editor;
    }

    @Override
    public EditorDelegate<T> getEditorDelegate() {
        return this.delegate;
    }

    @Override
    public abstract T getFromModel();

    public void halt() {
        this.isHalted = true;
    }

    public boolean isHalted() {
        return this.isHalted;
    }

    public void setEditorDelegate(AbstractEditorDelegate<T, ?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public abstract void setInModel(T var1);

    public void traverse(EditorVisitor visitor, AbstractEditorDelegate<?, ?> next) {
        if (visitor.visit(this) && next != null) {
            next.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverseSyntheticCompositeEditor(EditorVisitor visitor) {
        if (this.asCompositeEditor() == null) {
            throw new IllegalStateException();
        }
        this.doTraverseSyntheticCompositeEditor(visitor);
    }
}

