/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public abstract class FormatterImpl
extends Formatter {
    protected String getRecordInfo(LogRecord event, String newline) {
        Date date = new Date(event.getMillis());
        StringBuilder s = new StringBuilder();
        s.append(date.toString());
        s.append(" ");
        s.append(event.getLoggerName());
        s.append(newline);
        s.append(event.getLevel().getName());
        s.append(": ");
        return s.toString();
    }

    protected String getStackTraceAsString(Throwable e, String newline, String indent) {
        if (e == null) {
            return "";
        }
        StringBuffer s = new StringBuffer(newline);
        String causedBy = "";
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        for (Throwable currentCause = e; currentCause != null && !seenCauses.contains(currentCause); currentCause = currentCause.getCause()) {
            seenCauses.add(currentCause);
            s.append(causedBy);
            causedBy = newline + "Caused by: ";
            s.append(currentCause.getClass().getName());
            s.append(": " + currentCause.getMessage());
            StackTraceElement[] stackElems = currentCause.getStackTrace();
            if (stackElems == null) continue;
            for (int i = 0; i < stackElems.length; ++i) {
                s.append(newline + indent + "at ");
                s.append(stackElems[i].toString());
            }
        }
        return s.toString();
    }
}

