/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Whitespace;

public class Id
extends SystemFunction {
    public static final int ID = 0;
    public static final int ELEMENT_WITH_ID = 1;
    private boolean isSingletonId = false;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Id id = (Id)super.simplify(visitor);
        if (this.argument.length == 1) {
            id.addContextDocumentArgument(1, this.getFunctionName().getLocalName());
        }
        return id;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.argument[1] instanceof RootExpression && contextItemType != null && contextItemType.isAtomicType()) {
            XPathException err = new XPathException(this.getFunctionName().getLocalName() + "() function called when the context item is not a node");
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            throw err;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], false);
        this.isSingletonId = !Cardinality.allowsMany(this.argument[0].getCardinality());
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public int computeSpecialProperties() {
        int prop = 0xC20000;
        if (this.getNumberOfArguments() == 1 || (this.argument[1].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        PathMap.PathMapNodeSet target = this.argument[1].addToPathMap(pathMap, pathMapNodeSet);
        AxisExpression allElements = new AxisExpression(4, NodeKindTest.ELEMENT);
        allElements.setContainer(this.getContainer());
        target = target.createArc(allElements);
        return target;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        NodeInfo arg1;
        try {
            arg1 = (NodeInfo)this.argument[1].evaluateItem(context);
        }
        catch (XPathException e) {
            if (context.getContextItem() instanceof AtomicValue) {
                XPathException e2 = new XPathException("id() function called when the context item is not a node");
                e2.setErrorCode("XPTY0004");
                e2.setXPathContext(context);
                e2.setLocator(this);
                throw e2;
            }
            throw e;
        }
        arg1 = arg1.getRoot();
        if (arg1.getNodeKind() != 9) {
            this.dynamicError("In the " + this.getFunctionName().getLocalName() + "() function," + " the tree being searched must be one whose root is a document node", "FODC0001", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)arg1;
        if (this.isSingletonId) {
            AtomicValue arg = (AtomicValue)this.argument[0].evaluateItem(context);
            if (arg == null) {
                return EmptyIterator.getInstance();
            }
            String idrefs = arg.getStringValue();
            return Id.getIdSingle(doc, idrefs, this.operation);
        }
        SequenceIterator idrefs = this.argument[0].iterate(context);
        return Id.getIdMultiple(doc, idrefs, this.operation);
    }

    public static SequenceIterator getIdSingle(DocumentInfo doc, String idrefs, int operation) throws XPathException {
        boolean white = false;
        for (int i = idrefs.length() - 1; i >= 0; --i) {
            char c = idrefs.charAt(i);
            if (c > ' ' || c != ' ' && c != '\t' && c != '\n' && c != '\r') continue;
            white = true;
            break;
        }
        if (white) {
            StringTokenIterator tokens = new StringTokenIterator(idrefs);
            IdMappingFunction map = new IdMappingFunction();
            map.document = doc;
            map.operation = operation;
            MappingIterator result = new MappingIterator(tokens, map);
            return new DocumentOrderIterator(result, LocalOrderComparer.getInstance());
        }
        return SingletonIterator.makeIterator(doc.selectID(idrefs, operation == 1));
    }

    public static SequenceIterator getIdSingle(DocumentInfo doc, String idrefs) throws XPathException {
        return Id.getIdSingle(doc, idrefs, 0);
    }

    public static SequenceIterator getIdMultiple(DocumentInfo doc, SequenceIterator idrefs, int operation) throws XPathException {
        IdMappingFunction map = new IdMappingFunction();
        map.document = doc;
        map.operation = operation;
        MappingIterator result = new MappingIterator(idrefs, map);
        return new DocumentOrderIterator(result, LocalOrderComparer.getInstance());
    }

    public static SequenceIterator getIdMultiple(DocumentInfo doc, SequenceIterator idrefs) throws XPathException {
        return Id.getIdMultiple(doc, idrefs, 0);
    }

    private static class IdMappingFunction
    implements MappingFunction {
        public DocumentInfo document;
        private int operation;

        private IdMappingFunction() {
        }

        public SequenceIterator map(Item item) throws XPathException {
            String idrefs = Whitespace.trim(item.getStringValueCS());
            boolean white = false;
            for (int i = idrefs.length() - 1; i >= 0; --i) {
                char c = idrefs.charAt(i);
                if (c > ' ' || c != ' ' && c != '\t' && c != '\n' && c != '\r') continue;
                white = true;
                break;
            }
            if (white) {
                StringTokenIterator tokens = new StringTokenIterator(idrefs);
                IdMappingFunction submap = new IdMappingFunction();
                submap.document = this.document;
                return new MappingIterator(tokens, submap);
            }
            return SingletonIterator.makeIterator(this.document.selectID(idrefs, this.operation == 1));
        }
    }
}

