/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.ModuleBase;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Stack;

public class J2Dump
extends Dump {
    private static final int[] sigByte = new int[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10, 135, 10};
    private static final boolean ENDIAN = true;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("usage: java J2Dump file");
            System.exit(-1);
        }
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            J2Dump j2Dump = new J2Dump();
            long l = 0L;
            boolean bl = true;
            for (int i = 0; i < 12; ++i) {
                n = dataInputStream.readUnsignedByte();
                if (n == sigByte[i]) continue;
                System.out.println("No JPEG 2000 header");
                System.exit(-2);
            }
            l += 12L;
            n = 0;
            Stack<Box> stack = new Stack<Box>();
            while (n == 0) {
                Box box;
                while (true) {
                    box = null;
                    if (stack.isEmpty()) break;
                    box = (Box)stack.peek();
                    if (box.bytesLeft > 0L) break;
                    stack.pop();
                }
                J2Dump j2Dump2 = j2Dump;
                j2Dump2.getClass();
                Box box2 = j2Dump2.new Box(dataInputStream);
                try {
                    box2.read();
                }
                catch (EOFException eOFException) {
                    n = 1;
                    break;
                }
                l += box2.length - box2.bytesLeft;
                if (box != null) {
                    box.bytesLeft -= box2.length;
                }
                System.out.println(J2Dump.leading(l, 8) + l + ": " + J2Dump.stackPrefix(stack) + box2.type + " " + box2.length);
                if (box2.isSuperbox()) {
                    stack.push(box2);
                } else {
                    l += box2.bytesLeft;
                    dataInputStream.skipBytes((int)box2.bytesLeft);
                }
                if (box2.length != 0L) continue;
                n = 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(-2);
        }
    }

    private static String stackPrefix(Stack stack) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            Box box = (Box)stack.elementAt(i);
            stringBuffer.append(box.type.trim() + "/");
        }
        return stringBuffer.toString();
    }

    class Box {
        public String type;
        public long length;
        public long bytesLeft;
        public boolean hasBoxes;
        DataInputStream dstream;

        public Box(DataInputStream dataInputStream) {
            this.dstream = dataInputStream;
        }

        public void read() throws IOException {
            this.length = ModuleBase.readUnsignedInt(this.dstream, true, null);
            long l = 8L;
            this.type = this.read4Chars();
            if (this.length == 1L) {
                this.length = ModuleBase.readSignedLong(this.dstream, true, null);
                l = 16L;
            }
            this.bytesLeft = this.length - l;
        }

        private String read4Chars() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(4);
            for (int i = 0; i < 4; ++i) {
                int n = ModuleBase.readUnsignedByte(this.dstream, null);
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }

        public boolean isSuperbox() {
            String[] stringArray = new String[]{"asoc", "cgrp", "comp", "drep", "ftbl", "jp2h", "jpch", "jplh", "res ", "uuid"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(this.type)) continue;
                return true;
            }
            return false;
        }
    }
}

