/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Utf8BlockMarker;
import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import edu.harvard.hul.ois.jhove.module.html.HtmlStack;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlTempTagDesc;
import edu.harvard.hul.ois.jhove.module.html.JHAttribute;
import edu.harvard.hul.ois.jhove.module.html.JHCloseTag;
import edu.harvard.hul.ois.jhove.module.html.JHDoctype;
import edu.harvard.hul.ois.jhove.module.html.JHElement;
import edu.harvard.hul.ois.jhove.module.html.JHErrorElement;
import edu.harvard.hul.ois.jhove.module.html.JHOpenTag;
import edu.harvard.hul.ois.jhove.module.html.JHPCData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HtmlDocDesc {
    private HtmlMetadata metadata;
    protected static HashMap commonTags;
    protected Map supportedElements;
    protected HtmlTagDesc htmlElement;
    protected HtmlTagDesc headElement;
    protected HtmlTagDesc bodyElement;
    protected HtmlTagDesc framesetElement;
    private HtmlStack elementStack;
    protected static String[] headings;

    public boolean validate(List list, RepInfo repInfo) {
        this.metadata = new HtmlMetadata();
        this.elementStack = new HtmlStack();
        this.elementStack.setHeadElement(this.headElement);
        this.elementStack.setBodyElement(this.bodyElement);
        this.elementStack.setFramesetElement(this.framesetElement);
        for (JHElement jHElement : list) {
            if (jHElement instanceof JHDoctype) continue;
            if (jHElement instanceof JHOpenTag) {
                this.doOpenTag((JHOpenTag)jHElement, repInfo);
                continue;
            }
            if (jHElement instanceof JHCloseTag) {
                this.doCloseTag((JHCloseTag)jHElement, repInfo);
                continue;
            }
            if (jHElement instanceof JHErrorElement) {
                this.doErrorElement((JHErrorElement)jHElement, repInfo);
                continue;
            }
            if (!(jHElement instanceof JHPCData)) continue;
            this.doPCData((JHPCData)jHElement, repInfo, this.metadata);
        }
        if (!this.elementStack.isHeadSeen()) {
            repInfo.setMessage((Message)new ErrorMessage("Document must have implicit or explicit HEAD element"));
            repInfo.setValid(false);
        }
        return true;
    }

    public HtmlMetadata getMetadata() {
        return this.metadata;
    }

    protected void init() {
        this.htmlElement = (HtmlTagDesc)this.supportedElements.get("html");
        this.headElement = (HtmlTagDesc)this.supportedElements.get("head");
        this.bodyElement = (HtmlTagDesc)this.supportedElements.get("body");
    }

    private void doOpenTag(JHOpenTag jHOpenTag, RepInfo repInfo) {
        Object object;
        Object object2;
        Object object3;
        String string = jHOpenTag.getName().toLowerCase();
        boolean bl = false;
        String string2 = jHOpenTag.getErrorMessage();
        if (string2 != null) {
            repInfo.setMessage((Message)new ErrorMessage(string2, "Name = " + string + ", Line = " + jHOpenTag.getLine() + ", Column = " + jHOpenTag.getColumn()));
            repInfo.setWellFormed(false);
        }
        if (this.elementStack.isEmpty() && !"html".equals(string)) {
            object3 = new JHOpenTag("html");
            ((JHOpenTag)object3).setElement(this.htmlElement);
            this.elementStack.push((JHOpenTag)object3);
        }
        if ((object3 = (HtmlTagDesc)this.supportedElements.get(string)) == null) {
            bl = true;
        }
        if (!bl && !this.checkElementContext(jHOpenTag, repInfo)) {
            object2 = null;
            if (!this.elementStack.isEmpty()) {
                object = this.elementStack.top();
                object2 = ((JHOpenTag)object).getName();
            }
            repInfo.setMessage((Message)new ErrorMessage("Tag illegal in context", "Name = " + string + ", " + (object2 != null ? "Container = " + (String)object2 + ", " : "") + "Line = " + jHOpenTag.getLine() + ", Column = " + jHOpenTag.getColumn()));
            repInfo.setValid(false);
        }
        if (bl) {
            repInfo.setMessage((Message)new ErrorMessage("Unknown tag", "Name = " + string + ", Line = " + jHOpenTag.getLine() + ", Column = " + jHOpenTag.getColumn()));
            repInfo.setValid(false);
            object3 = new HtmlTempTagDesc(string);
        }
        if (!bl && repInfo.getWellFormed() == 1) {
            String string3;
            Object object4;
            Object object5;
            object2 = jHOpenTag.getAttributes();
            object = object2.iterator();
            ArrayList<String> arrayList = new ArrayList<String>(object2.size());
            while (object.hasNext()) {
                object5 = (JHAttribute)object.next();
                object4 = ((JHAttribute)object5).getName();
                arrayList.add((String)object4);
                string3 = ((JHAttribute)object5).getValue();
                HtmlAttributeDesc htmlAttributeDesc = ((HtmlTagDesc)object3).namedAttDesc((String)object4);
                if (htmlAttributeDesc == null) {
                    repInfo.setMessage((Message)new ErrorMessage("Undefined attribute for element", "Name = " + string + ", Attribute = " + (String)object4 + ", Line = " + ((JHAttribute)object5).getLine() + ", Column = " + ((JHAttribute)object5).getColumn()));
                    repInfo.setValid(false);
                } else if (!htmlAttributeDesc.valueOK((String)object4, string3)) {
                    repInfo.setMessage((Message)new ErrorMessage("Improper value for attribute", "Element = " + string + ", Attribute = " + (String)object4 + ", Value = " + string3 + ", Line = " + ((JHAttribute)object5).getLine() + ", Column = " + ((JHAttribute)object5).getColumn()));
                    repInfo.setValid(false);
                }
                if (string3 == null) continue;
                Iterator iterator = jHOpenTag.getEntities(string3).iterator();
                Utf8BlockMarker utf8BlockMarker = this.metadata.getUtf8BlockMarker();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.metadata.addEntity(string4);
                    try {
                        if (string4.charAt(1) != '#') continue;
                        int n = Integer.parseInt(string4.substring(2, string4.length() - 1));
                        utf8BlockMarker.markBlock(n);
                    }
                    catch (Exception exception) {}
                }
            }
            object5 = ((HtmlTagDesc)object3).missingRequiredAttributes(arrayList);
            if (!object5.isEmpty()) {
                repInfo.setValid(false);
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    string3 = (String)object4.next();
                    repInfo.setMessage((Message)new ErrorMessage("Missing required attribute", "Tag = " + string + ", Attribute = " + string3 + ", Line = " + jHOpenTag.getLine() + ", Column = " + jHOpenTag.getColumn()));
                }
            }
        }
        jHOpenTag.processElement(this.metadata);
        if (((HtmlTagDesc)object3).isTemp() || !((HtmlTagDesc)object3).isContentEmpty()) {
            jHOpenTag.setElement((HtmlTagDesc)object3);
            this.elementStack.push(jHOpenTag);
        }
    }

    private void doCloseTag(JHCloseTag jHCloseTag, RepInfo repInfo) {
        String string = jHCloseTag.getName();
        int n = this.elementStack.search(string);
        if (n == -1) {
            repInfo.setMessage((Message)new ErrorMessage("Close tag without matching open tag", "Name = " + string + ", Line = " + jHCloseTag.getLine() + ", Column = " + jHCloseTag.getColumn()));
            repInfo.setValid(false);
        } else {
            this.elementStack.popTo(n);
        }
    }

    private void doErrorElement(JHErrorElement jHErrorElement, RepInfo repInfo) {
        jHErrorElement.reportError(repInfo);
    }

    private void doPCData(JHPCData jHPCData, RepInfo repInfo, HtmlMetadata htmlMetadata) {
        if (this.elementStack.isEmpty()) {
            repInfo.setMessage((Message)new ErrorMessage("Document must have implicit or explicit HEAD element"));
            repInfo.setValid(false);
            return;
        }
        HtmlTagDesc htmlTagDesc = this.elementStack.top().getElement();
        if (htmlTagDesc.isTemp() || htmlTagDesc.allowsPCData()) {
            jHPCData.processPCData(this.elementStack, htmlMetadata);
            return;
        }
        while (!htmlTagDesc.isCloseTagRequired() && this.elementStack.size() > 2) {
            this.elementStack.popp();
            htmlTagDesc = this.elementStack.top().getElement();
            if (!htmlTagDesc.allowsPCData()) continue;
            jHPCData.processPCData(this.elementStack, htmlMetadata);
            return;
        }
        repInfo.setMessage((Message)new ErrorMessage("PCData illegal in context", "Line = " + jHPCData.getLine() + ", Column = " + jHPCData.getColumn()));
        repInfo.setValid(false);
    }

    private boolean checkElementContext(JHOpenTag jHOpenTag, RepInfo repInfo) {
        String string = jHOpenTag.getName();
        if (this.elementStack.isEmpty()) {
            return "html".equals(string);
        }
        if (this.elementStack.excludesTag(string)) {
            return false;
        }
        JHOpenTag jHOpenTag2 = this.elementStack.top();
        while (true) {
            if (jHOpenTag2.canGetMore() && jHOpenTag2.allowsTag(string, this)) {
                jHOpenTag2.countComponent();
                return true;
            }
            if (!jHOpenTag2.canAdvance()) break;
            jHOpenTag2.advanceIndex();
        }
        HtmlTagDesc htmlTagDesc = jHOpenTag2.getElement();
        if (htmlTagDesc == this.htmlElement) {
            if (!this.elementStack.isHeadSeen() && this.headElement.allowsTag(string, this)) {
                JHOpenTag jHOpenTag3 = new JHOpenTag("head");
                jHOpenTag3.setElement(this.headElement);
                this.elementStack.push(jHOpenTag3);
                return true;
            }
            if (!this.elementStack.isBodySeen() && this.bodyElement != null && this.bodyElement.allowsTag(string, this)) {
                JHOpenTag jHOpenTag4 = new JHOpenTag("body");
                jHOpenTag4.setElement(this.bodyElement);
                this.elementStack.push(jHOpenTag4);
                return true;
            }
            return false;
        }
        if (htmlTagDesc == this.headElement) {
            if ("body".equals(string) || "frameset".equals(string)) {
                this.elementStack.popp();
                this.elementStack.push(jHOpenTag);
                return true;
            }
            if (!this.elementStack.isBodySeen() && this.bodyElement != null && this.bodyElement.allowsTag(string, this)) {
                this.elementStack.popp();
                JHOpenTag jHOpenTag5 = new JHOpenTag("body");
                jHOpenTag5.setElement(this.bodyElement);
                this.elementStack.push(jHOpenTag5);
                return true;
            }
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.elementStack.size() > 2) {
            Iterator iterator = this.elementStack.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                JHOpenTag jHOpenTag6 = (JHOpenTag)iterator.next();
                if (!jHOpenTag6.allowsTag(string, this)) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            while (this.elementStack.size() > 2) {
                if (!bl && (htmlTagDesc = (jHOpenTag2 = this.elementStack.top()).getElement()).isCloseTagRequired()) {
                    repInfo.setValid(false);
                    repInfo.setMessage((Message)new ErrorMessage("Tag illegal in context", "Name = " + string + ", " + "Container = " + jHOpenTag2.getName() + ", " + "Line = " + jHOpenTag.getLine() + ", Column = " + jHOpenTag.getColumn()));
                }
                this.elementStack.popp();
                jHOpenTag2 = this.elementStack.top();
                if (jHOpenTag2.allowsTag(string, this)) {
                    return true;
                }
                if (!this.elementStack.isEmpty()) continue;
                break;
            }
        }
        return false;
    }

    protected static void addStringsToList(String[] stringArray, List list) {
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(stringArray[i]);
        }
    }

    protected static void addSimpleAttribute(List list, String string) {
        list.add(new HtmlAttributeDesc(string));
    }

    protected static void addRequiredAttribute(List list, String string) {
        list.add(new HtmlAttributeDesc(string, null, 1));
    }

    protected static void addSelfAttribute(List list, String string) {
        list.add(new HtmlAttributeDesc(string, new String[]{string}, 4));
    }

    protected static void removeStringsFromList(List list, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            list.remove(stringArray[i]);
        }
    }

    protected void pushElementStack(JHOpenTag jHOpenTag) {
        this.elementStack.push(jHOpenTag);
    }

    static {
        headings = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
    }
}

