#ifndef __MARTIAN_MODEM_COMMON_H
#define __MARTIAN_MODEM_COMMON_H

#include <sys/types.h>


struct _config {
	/* box */
	char affinity_cpu;
	double freq; /* in MHz */
	
	/* user */
	char *symlink_name;
	unsigned debuglevel;
	char *logfilename;
	uid_t uid;
	gid_t gid;
	mode_t mode;
	unsigned char country_id;


	/*** flags ***/
	/* box */
	unsigned haveTSC	: 1;
	unsigned smp		: 1;
	/* user */
	unsigned realtime	: 1;
	unsigned syslog		: 1;
	unsigned daemon		: 1;
	unsigned logfile	: 1;
	unsigned check_carrier	: 1;
	unsigned hide_pty	: 1;
	unsigned true_smp	: 1;
	unsigned permissions	: 1;
};

extern struct _config config;
extern struct martian_common *Mcb;
extern int mfd;
extern int worker_tid;

struct core_stats {
	int rx_hdlc;
	int rx_hdlc_of;
};

extern struct core_stats core;
#endif /*** __MARTIAN_MODEM_COMMON_H */
