/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.SharedLibrary;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;

public class ChangedEvent
implements ICDIChangedEvent {
    Session session;
    ICDIObject source;

    public ChangedEvent(Session s, MIVarChangedEvent var) {
        this.session = s;
        VariableManager mgr = this.session.getVariableManager();
        String varName = var.getVarName();
        MISession miSession = var.getMISession();
        this.source = mgr.getVariable(miSession, varName);
        if (this.source == null) {
            ExpressionManager expMgr = this.session.getExpressionManager();
            this.source = expMgr.getVariable(miSession, varName);
        }
        if (this.source == null) {
            RegisterManager regMgr = this.session.getRegisterManager();
            this.source = regMgr.getRegister(miSession, varName);
        }
        if (this.source == null) {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public ChangedEvent(Session s, MIRegisterChangedEvent reg) {
        this.session = s;
        RegisterManager mgr = this.session.getRegisterManager();
        MISession miSession = reg.getMISession();
        int regno = reg.getNumber();
        this.source = mgr.getRegister(miSession, regno);
        if (this.source == null) {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public ChangedEvent(Session s, MIBreakpointChangedEvent bpoint) {
        this.session = s;
        BreakpointManager mgr = this.session.getBreakpointManager();
        MISession miSession = bpoint.getMISession();
        int number = bpoint.getNumber();
        Breakpoint breakpoint = mgr.getBreakpoint(miSession, number);
        if (breakpoint != null) {
            this.source = breakpoint;
        } else {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public ChangedEvent(Session s, MISharedLibChangedEvent slib) {
        this.session = s;
        SharedLibraryManager mgr = this.session.getSharedLibraryManager();
        MISession miSession = slib.getMISession();
        String name = slib.getName();
        SharedLibrary lib = mgr.getSharedLibrary(miSession, name);
        if (lib != null) {
            this.source = lib;
        } else {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public ChangedEvent(Session s, MISignalChangedEvent sig) {
        this.session = s;
        SignalManager mgr = this.session.getSignalManager();
        MISession miSession = sig.getMISession();
        String name = sig.getName();
        ICDISignal signal = mgr.getSignal(miSession, name);
        if (signal != null) {
            this.source = signal;
        } else {
            Target target = this.session.getTarget(miSession);
            this.source = new CObject(target);
        }
    }

    public ChangedEvent(Session s, ICDIObject src) {
        this.session = s;
        this.source = src;
    }

    public ICDIObject getSource() {
        return this.source;
    }
}

