/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.util;

import com.nvidia.common.internal.Activator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Control;

public final class DataBindingUtil {
    public static void bindBooleanToNotNull(DataBindingContext bindingContext, IObservableValue model, IObservableValue ... targets) {
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        modelToTarget.setConverter((IConverter)new NonNullToBooleanConverter());
        IObservableValue[] iObservableValueArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableValue target = iObservableValueArray[n2];
            bindingContext.bindValue(target, model, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
            ++n2;
        }
    }

    public static void bindEnablement(DataBindingContext bindingContext, IObservableValue value, Control ... control) {
        DataBindingUtil.bindEnablement(bindingContext, value, (IConverter)new NonNullToBooleanConverter(), control);
    }

    public static void bindEnablement(DataBindingContext bindingContext, IObservableValue value, IConverter modelToTargetConverter, Control ... control) {
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        modelToTarget.setConverter(modelToTargetConverter);
        bindingContext.bindValue((IObservableValue)new EnablementObserver(control), value, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public static UpdateValueStrategy booleanNotBinding() {
        UpdateValueStrategy strategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        strategy.setConverter(new IConverter(){

            public Object convert(Object fromObject) {
                return !Boolean.TRUE.equals(fromObject);
            }

            public Object getFromType() {
                return Boolean.TYPE;
            }

            public Object getToType() {
                return Boolean.TYPE;
            }
        });
        return strategy;
    }

    private static class EnablementObserver
    extends AbstractObservableValue {
        private final Control[] controls;

        public EnablementObserver(Control[] controls) {
            this.controls = controls;
        }

        protected Object doGetValue() {
            Activator.log(new Exception(), "Shouldn't be called!", new Object[0]);
            return true;
        }

        protected void doSetValue(Object value) {
            Control[] controlArray = this.controls;
            int n = this.controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(Boolean.TRUE.equals(value));
                ++n2;
            }
        }

        public Object getValueType() {
            return Boolean.class;
        }
    }

    private static final class NonNullToBooleanConverter
    extends Converter {
        public NonNullToBooleanConverter() {
            super(Object.class, Boolean.TYPE);
        }

        public Object convert(Object fromObject) {
            return fromObject != null && !Boolean.TRUE.equals(fromObject);
        }
    }
}

