/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.analysis.AnalysisControlComposite;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import com.nvidia.viper.ui.analysis.AnalysisViewMode;
import com.nvidia.viper.ui.analysis.AnalysisViewModeDelegate;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public final class UnguidedModeDelegate
implements AnalysisViewModeDelegate {
    private Session activeSession;
    private final Control buttonsControl;
    private final Composite resultsComposite;
    private final Group resultsGroup;
    private final ScrolledComposite scrolledResultsComposite;
    private final ScrolledComposite scrolledStageComposite;
    private final AnalysisControlComposite stageComposite;

    public UnguidedModeDelegate(Composite buttonsParent, Composite outlineParent, Composite resultsParent) {
        this.scrolledStageComposite = new ScrolledComposite(outlineParent, 768);
        this.scrolledStageComposite.setExpandHorizontal(true);
        this.scrolledStageComposite.setExpandVertical(true);
        this.stageComposite = new AnalysisControlComposite((Composite)this.scrolledStageComposite, buttonsParent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 2;
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        this.stageComposite.setLayout((Layout)gl);
        this.scrolledStageComposite.setContent((Control)this.stageComposite);
        this.scrolledStageComposite.setMinSize(this.stageComposite.computeSize(-1, -1));
        this.buttonsControl = this.stageComposite.getButtonsControl();
        this.resultsGroup = new Group(resultsParent, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.resultsGroup.setLayout((Layout)gl);
        this.resultsGroup.setText("Results");
        this.scrolledResultsComposite = new ScrolledComposite((Composite)this.resultsGroup, 768);
        this.scrolledResultsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledResultsComposite.setExpandHorizontal(true);
        this.scrolledResultsComposite.setExpandVertical(true);
        this.resultsComposite = new Composite((Composite)this.scrolledResultsComposite, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 2;
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        this.resultsComposite.setLayout((Layout)gl);
        this.scrolledResultsComposite.setContent((Control)this.resultsComposite);
    }

    @Override
    public void activate() {
        this.refreshAnalysisResults();
        this.refreshAnalysisControl();
    }

    @Override
    public AnalysisViewMode getAssociatedMode() {
        return AnalysisViewMode.unguided;
    }

    @Override
    public Control getButtons() {
        return this.buttonsControl;
    }

    @Override
    public Control getDetails() {
        return this.resultsGroup;
    }

    @Override
    public Control getOutline() {
        return this.scrolledStageComposite;
    }

    @Override
    public void handlePropertyChange(String propertyName) {
        if ("analysis:scopeinterval".equals(propertyName) || "analysis:result".equals(propertyName) || "analysis:visited".equals(propertyName) || "analysis:sstage".equals(propertyName)) {
            this.refreshAnalysisControl();
            this.refreshAnalysisResults();
        } else if ("session:timelines".equals(propertyName) || "session:timeline".equals(propertyName)) {
            this.refreshAnalysisResults();
        }
    }

    private void refreshAnalysisResults() {
        Control[] controlArray = this.resultsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (this.activeSession != null && this.activeSession.getAnalysis() != null) {
            Analysis analysis = this.activeSession.getAnalysis();
            analysis.setSelectedResult(null);
            int resultCnt = 0;
            List<AnalysisResult> results = analysis.getAnalysisResults(analysis.getSelectedStage());
            Object[] resultArray = results.toArray(new AnalysisResult[0]);
            Arrays.sort(resultArray);
            Object[] objectArray = resultArray;
            int n3 = resultArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object result = objectArray[n4];
                if (!AnalysisDescriptor.Severity.OK.equals((Object)((AnalysisResult)result).getSeverity())) {
                    IAnalysisResultGraphicFactory aicFactory = ((AnalysisResult)result).getAnalysisResultFactory();
                    AnalysisResultControl aic = aicFactory.construct(this.resultsComposite, (AnalysisResult)result, this.activeSession);
                    GridData layoutData = aic.grabsVerticalSpace() ? new GridData(1808) : new GridData(4, 128, true, false);
                    aic.setLayoutData(layoutData);
                    ++resultCnt;
                }
                ++n4;
            }
            if (!AnalysisStage.NONE.equals((Object)analysis.getSelectedStage()) && resultCnt == 0) {
                AnalysisResultControl aic = new AnalysisResultControl(this.resultsComposite, new AnalysisResult(AnalysisDescriptor.ANALYSIS_OK), this.activeSession);
                aic.setLayoutData(new GridData(4, 128, true, false));
            }
            this.resultsComposite.layout();
            this.scrolledResultsComposite.setMinSize(this.resultsComposite.computeSize(-1, -1));
        }
    }

    private void refreshAnalysisControl() {
        this.stageComposite.refresh();
        this.scrolledStageComposite.setMinSize(this.stageComposite.computeSize(-1, -1));
        this.stageComposite.layout(true);
    }

    @Override
    public void setFocus() {
        this.stageComposite.setFocus();
    }

    @Override
    public void setSession(Session session) {
        this.activeSession = session;
        this.stageComposite.setSession(session);
        this.refreshAnalysisControl();
        this.refreshAnalysisResults();
    }
}

