/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.activity.CuptiActivityPCSampling;
import com.nvidia.viper.activity.CuptiActivityPCSamplingStallReason;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResultPCSampling;
import com.nvidia.viper.chart.ui.AxesConfiguration;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.SWTColorsManager;
import com.nvidia.viper.chart.ui.ViperChartSeries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;

public class KernelPCSamplingStallReasonChart
implements IViperChart {
    private final AnalysisResultPCSampling pcSamplingResult;
    private Map<CuptiActivityPCSamplingStallReason, Double> stallReasonPercentMap;
    private SWTColorsManager.ColorTheme colorTheme = new SWTColorsManager.ColorTheme(0.0f, 360.0f, 0.5f, 1.0f);

    public KernelPCSamplingStallReasonChart(AnalysisResultPCSampling result) {
        this.pcSamplingResult = result;
        this.stallReasonPercentMap = new HashMap<CuptiActivityPCSamplingStallReason, Double>();
        this.computeValuesForEachReason();
    }

    private void computeValuesForEachReason() {
        long totalSamples = 0L;
        HashMap<CuptiActivityPCSamplingStallReason, Long> stallReasonValueMap = new HashMap<CuptiActivityPCSamplingStallReason, Long>();
        for (ICuptiActivitySourceLevelResult result : this.pcSamplingResult.getSourceLevelResults()) {
            if (!(result instanceof CuptiActivityPCSampling)) continue;
            Long numSamples = (Long)stallReasonValueMap.get((Object)CuptiActivityPCSamplingStallReason.valueOf(((CuptiActivityPCSampling)result).stallReason));
            if (numSamples == null) {
                numSamples = 0L;
            }
            totalSamples += ((CuptiActivityPCSampling)result).samples;
            numSamples = numSamples + ((CuptiActivityPCSampling)result).samples;
            stallReasonValueMap.put(CuptiActivityPCSamplingStallReason.valueOf(((CuptiActivityPCSampling)result).stallReason), numSamples);
        }
        for (CuptiActivityPCSamplingStallReason reason : stallReasonValueMap.keySet()) {
            double percent = 100.0 * (double)((Long)stallReasonValueMap.get((Object)reason)).longValue() / (double)totalSamples;
            this.stallReasonPercentMap.put(reason, percent);
        }
        List colors = SWTColorsManager.getColors((int)this.stallReasonPercentMap.size(), (SWTColorsManager.ColorTheme)this.colorTheme);
        int i = 0;
        for (CuptiActivityPCSamplingStallReason reason : this.stallReasonPercentMap.keySet()) {
            reason.setColor((Color)colors.get(i));
            ++i;
        }
    }

    public ViperChartSeries[] getSeries() {
        return new ViperChartSeries[]{new ViperChartSeries(this.stallReasonPercentMap.values().toArray(new Double[0]), ViperChartSeries.Type.PIE, null, this.colorTheme)};
    }

    public String getTitle() {
        return "Sample distribution";
    }

    public boolean isHighlighted() {
        return false;
    }

    public boolean showLegend() {
        return true;
    }

    public int getHeight() {
        return 500;
    }

    public int getWidth() {
        return 900;
    }

    public AxesConfiguration getAxesConfiguration() {
        return null;
    }

    public String[] getLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (CuptiActivityPCSamplingStallReason stallReason : this.stallReasonPercentMap.keySet()) {
            labels.add(String.valueOf(stallReason.getName()) + "\n" + String.format("%.2f", this.stallReasonPercentMap.get((Object)stallReason)) + " %");
        }
        return labels.toArray(new String[0]);
    }

    public boolean colorBySeries() {
        return false;
    }
}

