/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.jni.CpuSample;
import com.nvidia.viper.jni.CpuSampleInfo;
import com.nvidia.viper.jni.CpuThread;
import com.nvidia.viper.jni.NativeDemangler;
import com.nvidia.viper.model.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CallTree {
    private static final double EXPAND_FACTOR = 0.1;
    public static final int NUMBER_OF_ORIENTATIONS = 3;
    private CallTree parent;
    private List<HitInfo> hits;
    private String functionName;
    private String libName;
    private String fileName;
    private int lineNo;
    private int maxHit = 0;
    private int minHit = 0;
    private int avgHit = 0;
    private int totalHit = 0;
    private List<CpuThread> threadsWithMinValue;
    private List<CpuThread> threadsWithMaxValue;
    private DISPLAY_TYPE displayType = DISPLAY_TYPE.FUNCTION;
    private List<CallTree> children;
    private CallTree functionShadow;
    private int numThreads;
    private static CpuThread totalThread = new CpuThread(CpuThread.stats.TOTAL);
    private static CpuThread avgThread = new CpuThread(CpuThread.stats.AVG);
    private static CpuThread minThread = new CpuThread(CpuThread.stats.MIN);
    private static CpuThread maxThread = new CpuThread(CpuThread.stats.MAX);
    private int cumulativeHits;
    private Map<Integer, CpuThread> actualThreadsMap;
    private TreeMap<CpuThread, Integer> threadHitMap;
    private List<CpuSample> cpuSamples;
    private Session session;
    private double stddev;
    private Integer median;
    private Integer absdev;
    private int maxValue;
    private boolean isSelected;

    public int getLineNo() {
        if (this.lineNo != -1) {
            return this.lineNo;
        }
        return 0;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public static CpuThread getTotalThread() {
        return totalThread;
    }

    public static CpuThread getAvgThread() {
        return avgThread;
    }

    public static CpuThread getMinThread() {
        return minThread;
    }

    public static CpuThread getMaxThread() {
        return maxThread;
    }

    public CallTree(CallTree parent, String functionName, String fileName, int lineNo, String libName) {
        this.actualThreadsMap = new LinkedHashMap<Integer, CpuThread>();
        this.threadsWithMaxValue = new ArrayList<CpuThread>();
        this.threadsWithMinValue = new ArrayList<CpuThread>();
        this.parent = parent;
        this.functionName = functionName;
        String demangledName = NativeDemangler.demangle(functionName);
        if (demangledName != null) {
            this.functionName = demangledName;
        }
        this.fileName = fileName;
        this.lineNo = lineNo;
        this.libName = libName;
        this.session = parent.session;
        this.children = new ArrayList<CallTree>();
        this.hits = new ArrayList<HitInfo>();
        this.parent.addChild(this);
        this.numThreads = 0;
        this.cumulativeHits = 0;
        this.threadHitMap = new TreeMap();
        this.createStatThreads();
        this.setFunctionShadow();
        this.displayType = DISPLAY_TYPE.FUNCTION;
    }

    public CallTree(CallTree or) {
        this.actualThreadsMap = or.actualThreadsMap;
        this.threadsWithMaxValue = or.threadsWithMaxValue;
        this.threadsWithMinValue = or.threadsWithMinValue;
        this.functionName = or.functionName;
        this.fileName = or.fileName;
        this.lineNo = -1;
        this.libName = or.libName;
        this.session = or.session;
        this.children = new ArrayList<CallTree>();
        this.hits = new ArrayList<HitInfo>();
        this.cumulativeHits = 0;
        this.threadHitMap = new TreeMap();
        this.displayType = or.displayType;
    }

    public CallTree(DISPLAY_TYPE type, CallTree parent, CallTree or) {
        this.actualThreadsMap = or.actualThreadsMap;
        this.threadsWithMaxValue = or.threadsWithMaxValue;
        this.threadsWithMinValue = or.threadsWithMinValue;
        this.functionName = or.functionName;
        this.fileName = or.fileName;
        this.libName = or.libName;
        this.lineNo = or.lineNo;
        this.session = parent.session;
        this.children = new ArrayList<CallTree>();
        this.hits = new ArrayList<HitInfo>();
        this.cumulativeHits = or.cumulativeHits;
        this.numThreads = or.numThreads;
        this.threadHitMap = new TreeMap();
        this.displayType = type;
        this.parent = parent;
        parent.addChild(this);
        this.createStatThreads();
    }

    private void createStatThreads() {
        this.threadHitMap.put(totalThread, new Integer(0));
        this.threadHitMap.put(avgThread, new Integer(0));
        this.threadHitMap.put(minThread, new Integer(0));
        this.threadHitMap.put(maxThread, new Integer(0));
    }

    public CallTree clone() {
        CallTree newTree = new CallTree(this);
        newTree.actualThreadsMap = this.actualThreadsMap;
        newTree.hits = this.hits;
        newTree.threadHitMap = this.threadHitMap;
        newTree.cumulativeHits = this.cumulativeHits;
        newTree.session = this.session;
        newTree.functionShadow = this.functionShadow;
        for (CallTree child : this.children) {
            newTree.children.add(child.clone());
        }
        return newTree;
    }

    private void setFunctionShadow() {
        List<CallTree> shadows = this.parent.functionShadow.children;
        for (CallTree shadow : shadows) {
            if (this.functionName.compareTo(shadow.functionName) != 0) continue;
            this.functionShadow = shadow;
            return;
        }
        this.functionShadow = new CallTree(this);
        this.parent.functionShadow.children.add(this.functionShadow);
        this.functionShadow.parent = this.parent.functionShadow;
    }

    public CallTree(Session session) {
        this.actualThreadsMap = new HashMap<Integer, CpuThread>();
        this.parent = null;
        this.hits = new ArrayList<HitInfo>();
        this.functionName = "HEAD";
        this.fileName = "HEAD";
        this.lineNo = -1;
        this.libName = "HEAD";
        this.children = new ArrayList<CallTree>();
        this.numThreads = 0;
        this.session = session;
        this.functionShadow = new CallTree(this);
        this.cumulativeHits = 0;
        this.threadHitMap = new TreeMap();
        this.displayType = DISPLAY_TYPE.HEAD;
    }

    private void addChild(CallTree c) {
        this.children.add(c);
    }

    public void addHit(int tid, int hits) {
        CpuThread thread;
        this.hits.add(new HitInfo(tid, hits));
        if (!this.actualThreadsMap.containsKey(tid)) {
            CpuThread newThread = new CpuThread(this.numThreads);
            this.actualThreadsMap.put(tid, newThread);
            this.session.addThread(newThread);
            thread = newThread;
        } else {
            thread = this.actualThreadsMap.get(tid);
        }
        this.threadHitMap.put(thread, new Integer(hits));
        this.cumulativeHits += hits;
        ++this.numThreads;
    }

    public CallTree getParent() {
        return this.parent;
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public int getHits() {
        CpuThread thread = this.session.getCurrentThread();
        if (thread != null && this.threadHitMap.containsKey(thread)) {
            return this.threadHitMap.get(thread);
        }
        return 0;
    }

    public int getHits(CpuThread thread) {
        if (thread.isStat()) {
            switch (thread.getStat()) {
                case AVG: {
                    if (this.avgHit == 0) {
                        this.avgHit = this.threadHitMap.get(thread);
                    }
                    return this.avgHit;
                }
                case MAX: {
                    if (this.maxHit == 0) {
                        this.maxHit = this.threadHitMap.get(thread);
                        for (Map.Entry<CpuThread, Integer> i : this.threadHitMap.entrySet()) {
                            if (i.getValue() != this.maxHit || i.getKey().isStat()) continue;
                            this.threadsWithMaxValue.add(i.getKey());
                        }
                    }
                    return this.maxHit;
                }
                case MIN: {
                    if (this.minHit == 0) {
                        this.minHit = this.threadHitMap.get(thread);
                        for (Map.Entry<CpuThread, Integer> i : this.threadHitMap.entrySet()) {
                            if (i.getValue() != this.minHit || i.getKey().isStat()) continue;
                            this.threadsWithMinValue.add(i.getKey());
                        }
                    }
                    return this.minHit;
                }
                case TOTAL: {
                    if (this.totalHit == 0) {
                        this.totalHit = this.threadHitMap.get(thread);
                    }
                    return this.totalHit;
                }
            }
            return this.threadHitMap.get(thread);
        }
        if (thread != null && this.threadHitMap.containsKey(thread)) {
            return this.threadHitMap.get(thread);
        }
        return 0;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public CpuThread getCpuThread(int i) {
        return this.actualThreadsMap.get(i);
    }

    public Iterator<CpuThread> iterateAllThreads() {
        if (this.threadHitMap.size() == 0 && this.children.size() > 0) {
            return this.children.get((int)0).threadHitMap.navigableKeySet().iterator();
        }
        return this.threadHitMap.navigableKeySet().iterator();
    }

    public List<CpuThread> getActualThreads() {
        Collection<CpuThread> values = this.actualThreadsMap.isEmpty() && this.children.size() > 0 ? this.children.get((int)0).actualThreadsMap.values() : this.actualThreadsMap.values();
        return new ArrayList<CpuThread>(values);
    }

    public void setCurrentThread(CpuThread t) {
        this.session.setCurrentThread(t);
    }

    public int getCumulativeHits() {
        return this.cumulativeHits;
    }

    public void setCumulativeHits() {
        for (CallTree child : this.children) {
            this.cumulativeHits += child.getCumulativeHits();
        }
    }

    public void setFunctionShadowHits() {
        CallTree shadow = this.functionShadow;
        this.populateSortedHitList();
        this.accumulateHits(shadow.threadHitMap);
        shadow.cumulativeHits += this.cumulativeHits;
        for (CallTree child : this.children) {
            child.setFunctionShadowHits();
        }
    }

    public void accumulateAndCalcStats() {
        this.calculate_stat_threads();
        for (CallTree child : this.children) {
            child.accumulateAndCalcStats();
        }
    }

    private void accumulateHits(Map<CpuThread, Integer> threadHitMap2) {
        Iterator<Map.Entry<CpuThread, Integer>> thisIt = threadHitMap2.entrySet().iterator();
        for (Map.Entry<CpuThread, Integer> otherEntry : this.threadHitMap.entrySet()) {
            CpuThread otherKey = otherEntry.getKey();
            Integer otherValue = otherEntry.getValue();
            if (thisIt.hasNext()) {
                Map.Entry<CpuThread, Integer> thisEntry = thisIt.next();
                Integer thisValue = thisEntry.getValue();
                CpuThread thisKey = thisEntry.getKey();
                threadHitMap2.put(thisKey, new Integer(thisValue + otherValue));
                continue;
            }
            threadHitMap2.put(otherKey, new Integer(otherValue));
        }
    }

    public void populateCodeStructureTree(CpuSampleInfo samples) {
        HashMap<String, CallTree> libraryNameMap = new HashMap<String, CallTree>();
        HashMap<String, CallTree> fileNameMap = new HashMap<String, CallTree>();
        HashMap<String, CallTree> functionNameMap = new HashMap<String, CallTree>();
        HashMap<Integer, CallTree> lineNameMap = new HashMap<Integer, CallTree>();
        CallTree newHead = new CallTree(this);
        for (CallTree child : this.children) {
            CallTree lineNoNode;
            CallTree functionNameNode;
            CallTree fileNameNode;
            child.populateCodeStructureTree(samples);
            child.populateSortedHitList();
            if (this.cpuSamples == null) {
                this.cpuSamples = new ArrayList<CpuSample>();
            }
            this.cpuSamples.add(new CpuSample(child, this.fileName, this.functionName, this.lineNo, child.threadHitMap, this.cumulativeHits));
            child.accumulateHits(samples.getTotalHits());
            CallTree libraryNameNode = (CallTree)libraryNameMap.get(child.libName);
            if (libraryNameNode == null) {
                libraryNameNode = new CallTree(DISPLAY_TYPE.LIBRARY, newHead, child);
                libraryNameMap.put(child.libName, libraryNameNode);
            }
            if ((fileNameNode = (CallTree)fileNameMap.get(child.fileName)) == null || fileNameNode.parent != libraryNameNode) {
                fileNameNode = new CallTree(DISPLAY_TYPE.FILE, libraryNameNode, child);
                fileNameMap.put(child.fileName, fileNameNode);
            }
            if ((functionNameNode = (CallTree)functionNameMap.get(child.functionName)) == null || functionNameNode.parent != fileNameNode) {
                functionNameNode = new CallTree(DISPLAY_TYPE.FUNCTION, fileNameNode, child);
                functionNameMap.put(child.functionName, functionNameNode);
            }
            if ((lineNoNode = (CallTree)lineNameMap.get(new Integer(child.lineNo))) == null || lineNoNode.parent != functionNameNode) {
                lineNoNode = new CallTree(DISPLAY_TYPE.LINE, functionNameNode, child);
                lineNameMap.put(new Integer(child.lineNo), lineNoNode);
            }
            child.accumulateHits(libraryNameNode.threadHitMap);
            child.accumulateHits(fileNameNode.threadHitMap);
            child.accumulateHits(functionNameNode.threadHitMap);
            child.accumulateHits(lineNoNode.threadHitMap);
        }
        this.functionShadow = newHead;
    }

    private void calculate_stat_threads() {
        Collection<Integer> actualHits = this.threadHitMap.tailMap(maxThread, false).values();
        this.threadHitMap.put(totalThread, totalThread.computeStat(actualHits));
        this.threadHitMap.put(avgThread, avgThread.computeStat(actualHits));
        this.threadHitMap.put(minThread, minThread.computeStat(actualHits));
        this.threadHitMap.put(maxThread, maxThread.computeStat(actualHits));
        int elements = actualHits.size();
        if (elements > 1) {
            Object[] sortedArray = actualHits.toArray();
            Arrays.sort(actualHits.toArray());
            this.median = elements % 2 == 0 ? (Integer)sortedArray[elements / 2] : Integer.valueOf(((Integer)sortedArray[(elements - 1) / 2] + (Integer)sortedArray[(elements + 2) / 2]) / 2);
            int mean = this.getHits(avgThread);
            int sqsum = 0;
            this.absdev = 0;
            for (Integer value : actualHits) {
                sqsum += (value - mean) * (value - mean);
                this.absdev = this.absdev + Math.abs(value - this.median);
            }
            this.stddev = Math.sqrt(sqsum / (elements - 1));
            this.absdev = this.absdev / elements;
        } else {
            this.stddev = 0.0;
            this.absdev = 0;
            this.median = elements > 0 ? (Integer)actualHits.toArray()[0] : 0;
        }
    }

    public DISPLAY_TYPE getDisplayType() {
        return this.displayType;
    }

    private void populateSortedHitList() {
        if (this.threadHitMap.isEmpty()) {
            Collections.sort(this.hits);
            for (HitInfo hit : this.hits) {
                this.threadHitMap.put(this.actualThreadsMap.get(hit.tid), hit.hits);
            }
        }
    }

    public List<CallTree> getHotCalls() {
        return this.getHotCalls(this.cumulativeHits);
    }

    private List<CallTree> getHotCalls(int hits) {
        if ((double)this.cumulativeHits > (double)hits * 0.1) {
            ArrayList<CallTree> hotChildren = new ArrayList<CallTree>();
            hotChildren.add(this);
            for (CallTree child : this.children) {
                hotChildren.addAll(child.getHotCalls(hits));
            }
            return hotChildren;
        }
        return Collections.emptyList();
    }

    public List<CallTree> getLibraryAndFileNodes() {
        if (this.displayType != DISPLAY_TYPE.LINE && this.displayType != DISPLAY_TYPE.FUNCTION) {
            ArrayList<CallTree> nonLineChildren = new ArrayList<CallTree>();
            nonLineChildren.add(this);
            for (CallTree child : this.children) {
                nonLineChildren.addAll(child.getLibraryAndFileNodes());
            }
            return nonLineChildren;
        }
        return Collections.emptyList();
    }

    public CallTree getFunctionShadow() {
        return this.functionShadow;
    }

    public int getTotalNumberOfSamples(CpuSampleInfo samples) {
        Integer totalNumber = samples.getTotalHits().get(this.session.getCurrentThread());
        if (totalNumber == null) {
            return 0;
        }
        return totalNumber;
    }

    public double getSamplingPeriod(CpuSampleInfo samples) {
        if (samples != null) {
            return samples.getSamplingPeriod();
        }
        return 0.0;
    }

    public double getTimePercentage(CpuSampleInfo samples) {
        if (samples == null) {
            return 0.0;
        }
        return this.getTotalNumberOfSamples(samples) == 0 ? 0.0 : (double)this.getHits() / (double)this.getTotalNumberOfSamples(samples);
    }

    public List<CpuSample> getCpuSamples() {
        return this.cpuSamples;
    }

    public CpuSampleInfo getCpuSampleData() {
        return this.session.getSamples();
    }

    public String getDisplayName() {
        switch (this.displayType) {
            case LIBRARY: {
                return this.libName;
            }
            case FILE: {
                return this.fileName;
            }
            case FUNCTION: {
                return this.functionName;
            }
            case LINE: {
                return String.valueOf(this.functionName) + ":" + new Integer(this.lineNo).toString();
            }
        }
        return "";
    }

    public CpuThread getCurrentThread() {
        return this.session.getCurrentThread();
    }

    public Integer getMedian() {
        return this.median;
    }

    public double getStddev() {
        return this.stddev;
    }

    public Integer getAbsdev() {
        return this.absdev;
    }

    public boolean isMinThread(CpuThread thread) {
        return this.threadsWithMinValue.contains(thread);
    }

    public boolean isMaxThread(CpuThread thread) {
        return this.threadsWithMaxValue.contains(thread);
    }

    public int getMaxValue() {
        return this.session.getSamples().getMaxValue();
    }

    public int getThreadMaxValue() {
        return this.session.getSamples().getTotalHits().get(this.getCurrentThread());
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean select) {
        this.isSelected = select;
    }

    public String getRelativePath() {
        return FileUtils.getRelativePath(this.fileName);
    }

    public static enum DISPLAY_TYPE {
        LIBRARY,
        FILE,
        FUNCTION,
        LINE,
        HEAD;

    }

    public class HitInfo
    implements Comparable<HitInfo> {
        public Integer tid;
        public Integer hits;

        public HitInfo(int tid, int hits) {
            this.tid = new Integer(tid);
            this.hits = new Integer(hits);
        }

        @Override
        public int compareTo(HitInfo o) {
            return this.tid.compareTo(o.tid);
        }
    }
}

