/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.cuda.ide.debug.service.DebuggerFilesMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.mi.service.CSourceLookup;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CudaCSourceLookup
extends CSourceLookup
implements ISourceLookup {
    private final DebuggerFilesMap cudaGdbSourceFiles;
    private final Map<IPath, String> pathMaps = new HashMap<IPath, String>();

    private static String getLongestMatch(IPath path, Map<IPath, String> debuggerPaths) {
        String longestMatch = null;
        int matchLength = 0;
        for (Map.Entry<IPath, String> entry : debuggerPaths.entrySet()) {
            int length = CudaCSourceLookup.matchLenght(entry.getKey(), path);
            if (length == path.segmentCount()) {
                return entry.getValue();
            }
            if (length <= matchLength) continue;
            longestMatch = entry.getValue();
            matchLength = length;
        }
        if (matchLength == 0) {
            return null;
        }
        return longestMatch;
    }

    private static int matchLenght(IPath debuggerPath, IPath localPath) {
        int debuggerPathsSegmentCount = debuggerPath.segmentCount();
        int localPathSegments = localPath.segmentCount();
        int longestMatchLenght = Math.min(debuggerPathsSegmentCount, localPathSegments);
        int i = 1;
        while (i <= longestMatchLenght) {
            if (!debuggerPath.segment(debuggerPathsSegmentCount - i).equals(localPath.segment(localPathSegments - i))) {
                return i - 1;
            }
            ++i;
        }
        return longestMatchLenght;
    }

    public CudaCSourceLookup(DsfSession session) {
        super(session);
        this.cudaGdbSourceFiles = new DebuggerFilesMap(session);
        session.addServiceEventListener((Object)this, null);
    }

    private void adjustPaths(IDMContext ctx, final IPath path, final DataRequestMonitor<String> rm) {
        if (!this.pathMaps.containsKey(path)) {
            this.cudaGdbSourceFiles.getFiles(new DataRequestMonitor<Map<IPath, String>>(ImmediateExecutor.getInstance(), rm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    CudaCSourceLookup.this.pathMaps.put(path, CudaCSourceLookup.getLongestMatch(path, (Map)this.getData()));
                    rm.done((Object)CudaCSourceLookup.this.simpleNameIfNotResolved(path));
                }
            });
        } else {
            rm.done((Object)this.simpleNameIfNotResolved(path));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IContainerSuspendedDMEvent e) {
        this.cudaGdbSourceFiles.clear();
        Iterator<Map.Entry<IPath, String>> iterator = this.pathMaps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IPath, String> entry = iterator.next();
            if (entry.getValue() != null) continue;
            iterator.remove();
        }
    }

    public final void getDebuggerPath(final ISourceLookup.ISourceLookupDMContext sourceLookupCtx, Object source, final DataRequestMonitor<String> rm) {
        super.getDebuggerPath(sourceLookupCtx, source, (DataRequestMonitor)new DataRequestMonitor<String>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                CudaCSourceLookup.this.adjustPaths((IDMContext)sourceLookupCtx, (IPath)new Path((String)this.getData()), (DataRequestMonitor<String>)rm);
            }
        });
    }

    private String simpleNameIfNotResolved(IPath path) {
        String resolved = this.pathMaps.get(path);
        return resolved == null ? path.lastSegment() : resolved;
    }
}

