/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.ThreadVMNode;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.swt.graphics.RGB;

public class HostThreadVMNode
extends ThreadVMNode {
    private static final String PROP_IS_ERROR = "prop.is.error";

    public HostThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (!this.filtered(e)) {
            super.buildDelta(e, parentDelta, nodeOffset, rm);
        } else {
            rm.done();
        }
    }

    private boolean filtered(Object e) {
        if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
            return service != null && service.getFocus() != null;
        }
        return false;
    }

    protected IElementLabelProvider createLabelProvider() {
        IElementLabelProvider provider = super.createLabelProvider();
        if (provider instanceof PropertiesBasedLabelProvider) {
            PropertiesBasedLabelProvider p = (PropertiesBasedLabelProvider)provider;
            LabelColumnInfo info = p.getColumnInfo("ID_COLUMN_NO_COLUMNS");
            LabelAttribute[] attributes = info.getLabelAttributes();
            LabelAttribute[] newAttributes = new LabelAttribute[attributes.length + 2];
            newAttributes[0] = new LabelImage(CudaDebugImages.THREAD_PAUSED_ERROR.getDescriptor()){

                public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                    return Boolean.TRUE.equals(properties.get("is_suspended")) && Integer.valueOf(1).equals(properties.get(HostThreadVMNode.PROP_IS_ERROR));
                }

                public String[] getPropertyNames() {
                    return new String[]{"is_suspended", HostThreadVMNode.PROP_IS_ERROR};
                }
            };
            newAttributes[1] = new ConditionalLabelColors(null, new RGB(255, 192, 192), PROP_IS_ERROR, 1);
            System.arraycopy(attributes, 0, newAttributes, 2, attributes.length);
            LabelColumnInfo newInfo = new LabelColumnInfo(newAttributes);
            p.setColumnInfo("ID_COLUMN_NO_COLUMNS", newInfo);
        }
        return provider;
    }

    protected void fillExecutionDataProperties(IPropertiesUpdate update, IRunControl.IExecutionDMData data) {
        String details;
        IRunControl.StateChangeReason reason = data.getStateChangeReason();
        if (reason != null) {
            update.setProperty("state_change_reason", (Object)data.getStateChangeReason().name());
            update.setProperty(PROP_IS_ERROR, (Object)(DebugUtil.isInError(data) ? 1 : 0));
        }
        if (data instanceof IRunControl.IExecutionDMData2 && (details = ((IRunControl.IExecutionDMData2)data).getDetails()) != null) {
            update.setProperty("state_change_details", (Object)details);
        }
    }
}

