/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.DebugNewProcessSequence;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.StartOrRestartProcessSequence_7_0;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadGroupCreatedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadGroupExitedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIListThreadGroupsInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThread;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThreadInfoInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.osgi.framework.BundleContext;

public class GDBProcesses_7_0
extends AbstractDsfService
implements IGDBProcesses,
ICachingService,
IEventListener {
    private Map<String, String> fThreadToGroupMap = new HashMap<String, String>();
    private Map<String, String> fGroupToPidMap = new HashMap<String, String>();
    private IGDBControl fCommandControl;
    private IGDBBackend fBackend;
    private CommandFactory fCommandFactory;
    private CommandCache fContainerCommandCache;
    private CommandCache fThreadCommandCache;
    private CommandCache fListThreadGroupsAvailableCache;
    private Map<String, String> fDebuggedProcessesAndNames = new HashMap<String, String>();
    private static final String FAKE_THREAD_ID = "0";
    private int fNumConnected;
    private boolean fInitialProcess = true;
    private boolean fProcRestarting;

    public GDBProcesses_7_0(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBProcesses_7_0.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)this.fCommandControl, this.getExecutor(), 2);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fContainerCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fThreadCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fThreadCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fListThreadGroupsAvailableCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommandControl);
        this.fListThreadGroupsAvailableCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        this.fCommandControl.addEventListener(this);
        this.register(new String[]{IProcesses.class.getName(), IMIProcesses.class.getName(), IGDBProcesses.class.getName(), GDBProcesses_7_0.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fCommandControl.removeEventListener(this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    protected Map<String, String> getThreadToGroupMap() {
        return this.fThreadToGroupMap;
    }

    protected Map<String, String> getGroupToPidMap() {
        return this.fGroupToPidMap;
    }

    protected int getNumConnected() {
        return this.fNumConnected;
    }

    protected void setNumConnected(int num) {
        this.fNumConnected = num;
    }

    protected boolean isInitialProcess() {
        return this.fInitialProcess;
    }

    protected void setIsInitialProcess(boolean isInitial) {
        this.fInitialProcess = isInitial;
    }

    protected String getGroupFromPid(String pid) {
        if (pid == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.getGroupToPidMap().entrySet()) {
            if (!pid.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public IProcesses.IThreadDMContext createThreadContext(IProcesses.IProcessDMContext processDmc, String threadId) {
        return new MIThreadDMC(this.getSession().getId(), processDmc, threadId);
    }

    @Override
    public IProcesses.IProcessDMContext createProcessContext(ICommandControlService.ICommandControlDMContext controlDmc, String pid) {
        return new MIProcessDMC(this.getSession().getId(), controlDmc, pid);
    }

    @Override
    public IMIExecutionDMContext createExecutionContext(IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
        return new MIExecutionDMC(this.getSession().getId(), containerDmc, threadDmc, threadId);
    }

    @Override
    public IMIContainerDMContext createContainerContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new GDBContainerDMC(this.getSession().getId(), processDmc, groupId);
    }

    @Override
    public IMIContainerDMContext createContainerContextFromThreadId(ICommandControlService.ICommandControlDMContext controlDmc, String threadId) {
        String groupId = this.getThreadToGroupMap().get(threadId);
        if (groupId == null) {
            if (this.getThreadToGroupMap().isEmpty()) {
                groupId = "";
            } else {
                Collection<String> values = this.getThreadToGroupMap().values();
                Iterator<String> iterator = values.iterator();
                if (iterator.hasNext()) {
                    String value;
                    groupId = value = iterator.next();
                }
            }
        }
        return this.createContainerContextFromGroupId(controlDmc, groupId);
    }

    @Override
    public IMIContainerDMContext createContainerContextFromGroupId(ICommandControlService.ICommandControlDMContext controlDmc, String groupId) {
        String pid;
        if (groupId == null || groupId.length() == 0) {
            Iterator<String> iterator;
            assert (this.getGroupToPidMap().size() <= 1) : "More than one process in our map";
            if (this.getGroupToPidMap().size() == 1 && (iterator = this.getGroupToPidMap().keySet().iterator()).hasNext()) {
                String key;
                groupId = key = iterator.next();
            }
        }
        if ((pid = this.getGroupToPidMap().get(groupId)) == null) {
            pid = groupId;
        }
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(controlDmc, pid);
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    public IMIExecutionDMContext[] getExecutionContexts(IMIContainerDMContext containerDmc) {
        String groupId = containerDmc.getGroupId();
        ArrayList<IMIExecutionDMContext> execDmcList = new ArrayList<IMIExecutionDMContext>();
        for (Map.Entry<String, String> entry : this.getThreadToGroupMap().entrySet()) {
            if (!entry.getValue().equals(groupId)) continue;
            String threadId = entry.getKey();
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
            IMIExecutionDMContext execDmc = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
            execDmcList.add(execDmc);
        }
        return execDmcList.toArray(new IMIExecutionDMContext[0]);
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, final DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IMIProcessDMContext) {
            String id = ((IMIProcessDMContext)dmc).getProcId();
            String name = null;
            if (this.fBackend.getSessionType() == SessionType.CORE || "42000".equals(id)) {
                name = this.fBackend.getProgramPath().lastSegment();
                id = null;
            } else {
                name = this.fDebuggedProcessesAndNames.get(id);
                if (name == null) {
                    name = "Unknown name";
                } else if (name.length() == 0) {
                    name = this.fBackend.getProgramPath().toOSString();
                    this.fDebuggedProcessesAndNames.put(id, name);
                }
            }
            rm.setData((Object)new MIThreadDMData(name, id));
            rm.done();
        } else if (dmc instanceof MIThreadDMC) {
            final MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
            this.fThreadCommandCache.execute(this.fCommandFactory.createMIThreadInfo(controlDmc, threadDmc.getId()), (DataRequestMonitor)new DataRequestMonitor<MIThreadInfoInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIThread thread;
                    MIThreadDMData threadData = null;
                    if (((MIThreadInfoInfo)this.getData()).getThreadList().length != 0 && (thread = ((MIThreadInfoInfo)this.getData()).getThreadList()[0]).getThreadId().equals(threadDmc.getId())) {
                        String details;
                        String id = "";
                        if (thread.getOsId() != null) {
                            id = thread.getOsId();
                        }
                        if ((details = thread.getDetails()) != null && details.length() > 0) {
                            if (!id.isEmpty()) {
                                id = String.valueOf(id) + " ";
                            }
                            id = String.valueOf(id) + "(" + details + ")";
                        }
                        if (id.isEmpty()) {
                            id = null;
                        }
                        threadData = new MIThreadDMData("", id);
                    }
                    if (threadData != null) {
                        rm.setData(threadData);
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Could not get thread info", null));
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DMC type", null));
            rm.done();
        }
    }

    public void getDebuggingContext(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IDMContext> rm) {
        if (dmc instanceof MIProcessDMC) {
            MIProcessDMC procDmc = (MIProcessDMC)dmc;
            IMIContainerDMContext containerDmc = this.createContainerContext(procDmc, this.getGroupFromPid(procDmc.getProcId()));
            rm.setData((Object)containerDmc);
        } else if (dmc instanceof MIThreadDMC) {
            MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
            IMIContainerDMContext containerDmc = this.createContainerContext(procDmc, this.getGroupFromPid(procDmc.getProcId()));
            rm.setData((Object)this.createExecutionContext(containerDmc, threadDmc, threadDmc.getId()));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid thread context.", null));
        }
        rm.done();
    }

    protected boolean doIsDebuggerAttachSupported() {
        return this.fBackend.getIsAttachSession() && this.fNumConnected == 0;
    }

    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doIsDebuggerAttachSupported());
        rm.done();
    }

    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, DataRequestMonitor<IDMContext> rm) {
        this.attachDebuggerToProcess(procCtx, null, rm);
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, String binaryPath, DataRequestMonitor<IDMContext> dataRm) {
        if (procCtx instanceof IMIProcessDMContext) {
            if (!this.doIsDebuggerAttachSupported()) {
                dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Attach not supported.", null));
                dataRm.done();
                return;
            }
            ImmediateExecutor.getInstance().execute((Runnable)new Sequence(this.getExecutor(), (RequestMonitor)dataRm, procCtx, binaryPath, (DataRequestMonitor)dataRm){
                private IMIContainerDMContext fContainerDmc;
                private Sequence.Step[] steps;
                {
                    this.steps = new Sequence.Step[]{new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            if (GDBProcesses_7_0.this.isInitialProcess()) {
                                GDBProcesses_7_0.this.setIsInitialProcess(false);
                            }
                            fContainerDmc = GDBProcesses_7_0.this.createContainerContext(iProcessDMContext, "");
                            if (string != null) {
                                GDBProcesses_7_0.this.fCommandControl.queueCommand(GDBProcesses_7_0.this.fCommandFactory.createMIFileExecAndSymbols(fContainerDmc, string), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
                                return;
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            boolean shouldInterrupt = true;
                            IMIRunControl runControl = (IMIRunControl)GDBProcesses_7_0.this.getServicesTracker().getService(IMIRunControl.class);
                            if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.NON_STOP) {
                                shouldInterrupt = false;
                            }
                            GDBProcesses_7_0.this.fCommandControl.queueCommand(GDBProcesses_7_0.this.fCommandFactory.createMITargetAttach(fContainerDmc, ((IMIProcessDMContext)iProcessDMContext).getProcId(), shouldInterrupt), new DataRequestMonitor((Executor)this.getExecutor(), rm));
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            fContainerDmc = GDBProcesses_7_0.this.createContainerContext(iProcessDMContext, GDBProcesses_7_0.this.getGroupFromPid(((IMIProcessDMContext)iProcessDMContext).getProcId()));
                            dataRequestMonitor.setData((Object)fContainerDmc);
                            IGDBMemory memory = (IGDBMemory)GDBProcesses_7_0.this.getServicesTracker().getService(IGDBMemory.class);
                            IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)fContainerDmc, IMemory.IMemoryDMContext.class);
                            if (memory == null || memContext == null) {
                                rm.done();
                                return;
                            }
                            memory.initializeMemoryData(memContext, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)GDBProcesses_7_0.this.getServicesTracker().getService(MIBreakpointsManager.class));
                            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)fContainerDmc, IBreakpoints.IBreakpointsTargetDMContext.class);
                            bpmService.startTrackingBreakpoints(bpTargetDmc, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            ILaunch launch;
                            IReverseRunControl reverseService = (IReverseRunControl)GDBProcesses_7_0.this.getServicesTracker().getService(IReverseRunControl.class);
                            if (reverseService != null && (launch = (ILaunch)iProcessDMContext.getAdapter(ILaunch.class)) != null) {
                                try {
                                    boolean reverseEnabled = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
                                    if (reverseEnabled) {
                                        reverseService.enableReverseMode(GDBProcesses_7_0.this.fCommandControl.getContext(), true, rm);
                                        return;
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                            rm.done();
                        }
                    }};
                }

                public Sequence.Step[] getSteps() {
                    return this.steps;
                }
            });
        } else {
            dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            dataRm.done();
        }
    }

    protected boolean doCanDetachDebuggerFromProcess() {
        return this.fNumConnected > 0;
    }

    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doCanDetachDebuggerFromProcess());
        rm.done();
    }

    public void detachDebuggerFromProcess(IDMContext dmc, RequestMonitor rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
        if (controlDmc != null && procDmc != null) {
            if (!this.doCanDetachDebuggerFromProcess()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Detach not supported.", null));
                rm.done();
                return;
            }
            IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
            if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                this.fBackend.interrupt();
            }
            this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetDetach(controlDmc, procDmc.getProcId()), new DataRequestMonitor((Executor)this.getExecutor(), rm));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    public void canTerminate(IProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void isDebugNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doIsDebugNewProcessSupported());
        rm.done();
    }

    protected boolean doIsDebugNewProcessSupported() {
        return false;
    }

    public void debugNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        boolean isInitial = this.isInitialProcess();
        if (this.isInitialProcess()) {
            this.setIsInitialProcess(false);
        } else if (!this.doIsDebugNewProcessSupported()) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Not allowed to create a new process", null));
            rm.done();
            return;
        }
        ImmediateExecutor.getInstance().execute((Runnable)this.getDebugNewProcessSequence(this.getExecutor(), isInitial, dmc, file, attributes, rm));
    }

    protected Sequence getDebugNewProcessSequence(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        return new DebugNewProcessSequence(executor, isInitial, dmc, file, attributes, rm);
    }

    public void getProcessesBeingDebugged(IDMContext dmc, final DataRequestMonitor<IDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (containerDmc != null) {
            this.fThreadCommandCache.execute(this.fCommandFactory.createMIListThreadGroups(controlDmc, containerDmc.getGroupId()), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)GDBProcesses_7_0.this.makeExecutionDMCs(containerDmc, ((MIListThreadGroupsInfo)this.getData()).getThreadInfo().getThreadList()));
                    rm.done();
                }
            });
        } else {
            this.fContainerCommandCache.execute(this.fCommandFactory.createMIListThreadGroups(controlDmc), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)GDBProcesses_7_0.this.makeContainerDMCs(controlDmc, ((MIListThreadGroupsInfo)this.getData()).getGroupList()));
                    rm.done();
                }

                protected void handleFailure() {
                    IMIContainerDMContext[] containerDmcs = new IMIContainerDMContext[GDBProcesses_7_0.this.getGroupToPidMap().size()];
                    int i = 0;
                    for (String groupId : GDBProcesses_7_0.this.getGroupToPidMap().keySet()) {
                        containerDmcs[i++] = GDBProcesses_7_0.this.createContainerContextFromGroupId(controlDmc, groupId);
                    }
                    rm.setData((Object)containerDmcs);
                    rm.done();
                }
            });
        }
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(IRunControl.IContainerDMContext containerDmc, MIThread[] threadInfos) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
        if (threadInfos.length == 0) {
            return new IMIExecutionDMContext[]{this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, FAKE_THREAD_ID), FAKE_THREAD_ID)};
        }
        IRunControl.IExecutionDMContext[] executionDmcs = new IMIExecutionDMContext[threadInfos.length];
        int i = 0;
        while (i < threadInfos.length) {
            String threadId = threadInfos[i].getThreadId();
            executionDmcs[i] = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
            ++i;
        }
        return executionDmcs;
    }

    private IMIContainerDMContext[] makeContainerDMCs(ICommandControlService.ICommandControlDMContext controlDmc, MIListThreadGroupsInfo.IThreadGroupInfo[] groups) {
        if (groups.length == 0 && this.fBackend.getSessionType() == SessionType.CORE) {
            return new IMIContainerDMContext[]{this.createContainerContextFromGroupId(controlDmc, "")};
        }
        ArrayList<IMIContainerDMContext> containerDmcs = new ArrayList<IMIContainerDMContext>(groups.length);
        MIListThreadGroupsInfo.IThreadGroupInfo[] iThreadGroupInfoArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            MIListThreadGroupsInfo.IThreadGroupInfo group = iThreadGroupInfoArray[n2];
            if (group.getPid() != null && !group.getPid().equals("") && !group.getPid().equals(FAKE_THREAD_ID)) {
                String groupId = group.getGroupId();
                containerDmcs.add(this.createContainerContextFromGroupId(controlDmc, groupId));
            }
            ++n2;
        }
        return containerDmcs.toArray(new IMIContainerDMContext[containerDmcs.size()]);
    }

    public void getRunningProcesses(IDMContext dmc, final DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        final ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc != null) {
            this.fListThreadGroupsAvailableCache.execute(this.fCommandFactory.createMIListThreadGroups(controlDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    GDBProcesses_7_0.this.fListThreadGroupsAvailableCache.reset();
                    if (this.isSuccess()) {
                        rm.setData((Object)GDBProcesses_7_0.this.makeProcessDMCAndData(controlDmc, ((MIListThreadGroupsInfo)this.getData()).getGroupList()));
                    } else if (GDBProcesses_7_0.this.fBackend.getSessionType() == SessionType.LOCAL) {
                        IProcessList list = null;
                        try {
                            list = CCorePlugin.getDefault().getProcessList();
                        }
                        catch (CoreException coreException) {}
                        if (list == null) {
                            rm.setData((Object)new IProcesses.IProcessDMContext[0]);
                        } else {
                            IProcessInfo[] procInfos = list.getProcessList();
                            rm.setData((Object)GDBProcesses_7_0.this.makeProcessDMCAndData(controlDmc, procInfos));
                        }
                    } else {
                        rm.setData((Object)new IProcesses.IProcessDMContext[0]);
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    protected MIProcessDMCAndData[] makeProcessDMCAndData(ICommandControlService.ICommandControlDMContext controlDmc, IProcessInfo[] processes) {
        MIProcessDMCAndData[] procDmcs = new MIProcessDMCAndData[processes.length];
        int i = 0;
        while (i < procDmcs.length) {
            procDmcs[i] = new MIProcessDMCAndData(controlDmc.getSessionId(), controlDmc, Integer.toString(processes[i].getPid()), processes[i].getName(), null, null);
            ++i;
        }
        return procDmcs;
    }

    protected MIProcessDMCAndData[] makeProcessDMCAndData(ICommandControlService.ICommandControlDMContext controlDmc, MIListThreadGroupsInfo.IThreadGroupInfo[] processes) {
        MIProcessDMCAndData[] procDmcs = new MIProcessDMCAndData[processes.length];
        int i = 0;
        MIListThreadGroupsInfo.IThreadGroupInfo[] iThreadGroupInfoArray = processes;
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            MIListThreadGroupsInfo.IThreadGroupInfo process = iThreadGroupInfoArray[n2];
            procDmcs[i++] = new MIProcessDMCAndData(controlDmc.getSessionId(), controlDmc, process.getGroupId(), process.getName(), process.getCores(), process.getUser());
            ++n2;
        }
        return procDmcs;
    }

    public void isRunNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void runNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void terminate(IProcesses.IThreadDMContext thread, final RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            this.fCommandControl.terminate(rm);
        } else if (thread instanceof IMIProcessDMContext) {
            this.getDebuggingContext(thread, (DataRequestMonitor<IDMContext>)new ImmediateDataRequestMonitor<IDMContext>(rm){

                protected void handleSuccess() {
                    if (this.getData() instanceof IMIContainerDMContext) {
                        IMIRunControl runControl = (IMIRunControl)GDBProcesses_7_0.this.getServicesTracker().getService(IMIRunControl.class);
                        if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                            GDBProcesses_7_0.this.fBackend.interrupt();
                        }
                        GDBProcesses_7_0.this.fCommandControl.queueCommand(GDBProcesses_7_0.this.fCommandFactory.createMIInterpreterExecConsoleKill((IMIContainerDMContext)this.getData()), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
                        rm.done();
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    @Override
    public void canRestart(IRunControl.IContainerDMContext containerDmc, DataRequestMonitor<Boolean> rm) {
        if (this.fBackend.getIsAttachSession() || this.fBackend.getSessionType() == SessionType.CORE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (this.fBackend.getSessionType() == SessionType.REMOTE) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        rm.setData((Object)true);
        rm.done();
    }

    protected IMIContainerDMContext createContainerContextForRestart(String groupId) {
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(this.fCommandControl.getContext(), "");
        return this.createContainerContext(processDmc, "");
    }

    @Override
    public void restart(IRunControl.IContainerDMContext containerDmc, final Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        this.fProcRestarting = true;
        final String groupId = ((IMIContainerDMContext)containerDmc).getGroupId();
        ImmediateRequestMonitor restartRm = new ImmediateRequestMonitor((RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0);
            }

            protected void handleSuccess() {
                IMIContainerDMContext newContainerDmc = GDBProcesses_7_0.this.createContainerContextForRestart(groupId);
                GDBProcesses_7_0.this.startOrRestart(newContainerDmc, attributes, true, (DataRequestMonitor<IRunControl.IContainerDMContext>)new ImmediateDataRequestMonitor<IRunControl.IContainerDMContext>((RequestMonitor)this.val$rm){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            GDBProcesses_7_0.this.fProcRestarting = false;
                        }
                        this.setData((IRunControl.IContainerDMContext)this.getData());
                        super.handleCompleted();
                    }
                });
            }
        };
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        if (runControl != null && !runControl.isSuspended((IRunControl.IExecutionDMContext)containerDmc)) {
            runControl.suspend((IRunControl.IExecutionDMContext)containerDmc, (RequestMonitor)restartRm);
        } else {
            restartRm.done();
        }
    }

    @Override
    public void start(IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        this.startOrRestart(containerDmc, attributes, false, rm);
    }

    protected void startOrRestart(IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        ImmediateExecutor.getInstance().execute((Runnable)this.getStartOrRestartProcessSequence(this.getExecutor(), containerDmc, attributes, restart, rm));
    }

    protected Sequence getStartOrRestartProcessSequence(DsfExecutor executor, IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        return new StartOrRestartProcessSequence_7_0(executor, containerDmc, attributes, restart, rm);
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupCreatedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerStartedDMEvent(containerDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupExitedEvent e) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)e.getDMContext();
        IMIContainerDMContext containerDmc = e.getGroupId() != null ? this.createContainerContext(procDmc, e.getGroupId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerExitedDMEvent(containerDmc), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fContainerCommandCache.setContextAvailable(e.getDMContext(), false);
            this.fThreadCommandCache.setContextAvailable(e.getDMContext(), false);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
            this.fThreadCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        }
        try {
            if (this.fBackend.getUpdateThreadListOnSuspend()) {
                ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), ICommandControlService.ICommandControlDMContext.class);
                this.fThreadCommandCache.reset((IDMContext)controlDmc);
            }
        }
        catch (CoreException coreException) {}
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        if (e instanceof ContainerStartedDMEvent) {
            this.fContainerCommandCache.reset();
            ++this.fNumConnected;
        } else {
            this.fThreadCommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e instanceof ContainerExitedDMEvent) {
            this.fContainerCommandCache.reset();
            assert (this.fNumConnected > 0);
            --this.fNumConnected;
            if (Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "autoTerminateGdb", true, null) && this.fNumConnected == 0 && !this.fProcRestarting) {
                this.fCommandControl.terminate((RequestMonitor)new ImmediateRequestMonitor());
            }
            this.fProcRestarting = false;
        } else {
            this.fThreadCommandCache.reset();
        }
    }

    public void flushCache(IDMContext context) {
        this.fContainerCommandCache.reset(context);
        this.fThreadCommandCache.reset(context);
    }

    public void eventReceived(Object output) {
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            if (oobr instanceof MINotifyAsyncOutput) {
                String groupId;
                MIValue val;
                String var;
                MINotifyAsyncOutput exec = (MINotifyAsyncOutput)oobr;
                String miEvent = exec.getAsyncClass();
                if ("thread-created".equals(miEvent) || "thread-exited".equals(miEvent)) {
                    String threadId = null;
                    String groupId2 = null;
                    MIResult[] results = exec.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        var = results[i].getVariable();
                        val = results[i].getMIValue();
                        if (var.equals("group-id")) {
                            if (val instanceof MIConst) {
                                groupId2 = ((MIConst)val).getString();
                            }
                        } else if (var.equals("id") && val instanceof MIConst) {
                            threadId = ((MIConst)val).getString();
                        }
                        ++i;
                    }
                    if ("thread-created".equals(miEvent)) {
                        this.getThreadToGroupMap().put(threadId, groupId2);
                    } else {
                        this.getThreadToGroupMap().remove(threadId);
                    }
                } else if ("thread-group-created".equals(miEvent) || "thread-group-started".equals(miEvent)) {
                    groupId = null;
                    String pId = null;
                    MIResult[] results = exec.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        var = results[i].getVariable();
                        val = results[i].getMIValue();
                        if (var.equals("id")) {
                            if (val instanceof MIConst) {
                                groupId = ((MIConst)val).getString().trim();
                            }
                        } else if (var.equals("pid") && val instanceof MIConst) {
                            pId = ((MIConst)val).getString().trim();
                        }
                        ++i;
                    }
                    if (pId == null) {
                        pId = groupId;
                    }
                    if (groupId != null) {
                        this.getGroupToPidMap().put(groupId, pId);
                        this.fDebuggedProcessesAndNames.put(pId, "");
                        final String finalPId = pId;
                        this.fListThreadGroupsAvailableCache.execute(this.fCommandFactory.createMIListThreadGroups(this.fCommandControl.getContext(), true), (DataRequestMonitor)new DataRequestMonitor<MIListThreadGroupsInfo>((Executor)this.getExecutor(), null){

                            protected void handleCompleted() {
                                GDBProcesses_7_0.this.fListThreadGroupsAvailableCache.reset();
                                if (this.isSuccess()) {
                                    MIListThreadGroupsInfo.IThreadGroupInfo[] iThreadGroupInfoArray = ((MIListThreadGroupsInfo)this.getData()).getGroupList();
                                    int n = iThreadGroupInfoArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        MIListThreadGroupsInfo.IThreadGroupInfo groupInfo = iThreadGroupInfoArray[n2];
                                        if (groupInfo.getPid().equals(finalPId)) {
                                            GDBProcesses_7_0.this.fDebuggedProcessesAndNames.put(finalPId, groupInfo.getName());
                                        }
                                        ++n2;
                                    }
                                } else if (GDBProcesses_7_0.this.fBackend.getSessionType() == SessionType.LOCAL) {
                                    IProcessList list = null;
                                    try {
                                        list = CCorePlugin.getDefault().getProcessList();
                                        int pId_int = Integer.parseInt(finalPId);
                                        IProcessInfo[] iProcessInfoArray = list.getProcessList();
                                        int n = iProcessInfoArray.length;
                                        int n3 = 0;
                                        while (n3 < n) {
                                            IProcessInfo procInfo = iProcessInfoArray[n3];
                                            if (procInfo.getPid() == pId_int) {
                                                GDBProcesses_7_0.this.fDebuggedProcessesAndNames.put(finalPId, procInfo.getName());
                                                break;
                                            }
                                            ++n3;
                                        }
                                    }
                                    catch (CoreException coreException) {}
                                }
                            }
                        });
                    }
                } else if ("thread-group-exited".equals(miEvent)) {
                    groupId = null;
                    MIResult[] results = exec.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        String var2 = results[i].getVariable();
                        MIValue val2 = results[i].getMIValue();
                        if (var2.equals("id") && val2 instanceof MIConst) {
                            groupId = ((MIConst)val2).getString().trim();
                        }
                        ++i;
                    }
                    if (groupId != null) {
                        String pId = this.getGroupToPidMap().remove(groupId);
                        this.fDebuggedProcessesAndNames.remove(pId);
                        if (this.getThreadToGroupMap().containsValue(groupId)) {
                            Iterator<Map.Entry<String, String>> iterator = this.getThreadToGroupMap().entrySet().iterator();
                            while (iterator.hasNext()) {
                                if (!iterator.next().getValue().equals(groupId)) continue;
                                iterator.remove();
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public static class ContainerExitedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IExitedDMEvent {
        public ContainerExitedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    public static class ContainerStartedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IStartedDMEvent {
        public ContainerStartedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    private static class GDBContainerDMC
    extends MIContainerDMC
    implements IMemory.IMemoryDMContext,
    IBreakpoints.IBreakpointsTargetDMContext {
        public GDBContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            super(sessionId, processDmc, groupId);
        }
    }

    @Immutable
    static class MIContainerDMC
    extends AbstractDMContext
    implements IMIContainerDMContext,
    IDisassembly.IDisassemblyDMContext {
        private final String fId;

        public MIContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = groupId;
        }

        @Override
        public String getGroupId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".threadGroup[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (((MIContainerDMC)obj).fId == null ? this.fId == null : ((MIContainerDMC)obj).fId.equals(this.fId));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIExecutionDMC
    extends AbstractDMContext
    implements IMIExecutionDMContext,
    IDisassembly.IDisassemblyDMContext {
        private final String fThreadId;

        protected MIExecutionDMC(String sessionId, IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
            IDMContext[] iDMContextArray;
            if (containerDmc == null && threadDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else if (containerDmc == null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = threadDmc;
            } else if (threadDmc == null) {
                IDMContext[] iDMContextArray3 = new IDMContext[1];
                iDMContextArray = iDMContextArray3;
                iDMContextArray3[0] = containerDmc;
            } else {
                IDMContext[] iDMContextArray4 = new IDMContext[2];
                iDMContextArray4[0] = containerDmc;
                iDMContextArray = iDMContextArray4;
                iDMContextArray4[1] = threadDmc;
            }
            super(sessionId, iDMContextArray);
            this.fThreadId = threadId;
        }

        @Override
        public int getThreadId() {
            try {
                return Integer.parseInt(this.fThreadId);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && ((MIExecutionDMC)obj).fThreadId.equals(this.fThreadId);
        }

        public int hashCode() {
            return this.baseHashCode() ^ this.fThreadId.hashCode();
        }
    }

    @Immutable
    private static class MIProcessDMC
    extends AbstractDMContext
    implements IMIProcessDMContext {
        private final String fId;

        public MIProcessDMC(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String id) {
            IDMContext[] iDMContextArray;
            if (controlDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = controlDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        @Override
        public String getProcId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".proc[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            if (!this.baseEquals(obj)) {
                return false;
            }
            MIProcessDMC other = (MIProcessDMC)obj;
            if (this.fId == null || other.fId == null) {
                return this.fId == null && other.fId == null;
            }
            if (this.fId.equals("") || other.fId.equals("")) {
                return true;
            }
            return this.fId.equals(other.fId);
        }

        public int hashCode() {
            return this.baseHashCode();
        }
    }

    @Immutable
    protected static class MIProcessDMCAndData
    extends MIProcessDMC
    implements IGDBProcesses.IGdbThreadDMData {
        final String fName;
        final String[] fCores;
        final String fOwner;

        public MIProcessDMCAndData(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String id, String name, String[] cores, String owner) {
            super(sessionId, controlDmc, id);
            this.fName = name;
            this.fCores = cores;
            this.fOwner = owner;
        }

        public String getId() {
            return this.getProcId();
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }

        @Override
        public String[] getCores() {
            return this.fCores;
        }

        @Override
        public String getOwner() {
            return this.fOwner;
        }

        @Override
        public String toString() {
            return String.valueOf(this.baseToString()) + ".proc[" + this.getId() + "," + this.getName() + "," + this.getOwner() + "]";
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && (((MIProcessDMCAndData)obj).fName == null ? this.fName == null : ((MIProcessDMCAndData)obj).fName.equals(this.fName)) && (((MIProcessDMCAndData)obj).fOwner == null ? this.fOwner == null : ((MIProcessDMCAndData)obj).fOwner.equals(this.fOwner));
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (this.fName == null ? 0 : this.fName.hashCode()) ^ (this.fOwner == null ? 0 : this.fOwner.hashCode());
        }
    }

    @Immutable
    protected static class MIThreadDMC
    extends AbstractDMContext
    implements IProcesses.IThreadDMContext {
        private final String fId;

        public MIThreadDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String id) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".OSthread[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (((MIThreadDMC)((Object)obj)).fId == null ? this.fId == null : ((MIThreadDMC)((Object)obj)).fId.equals(this.fId));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    protected static class MIThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        public MIThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

