/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.DebugNewProcessSequence_7_2;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_1;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIAddInferiorInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;

public class GDBProcesses_7_2
extends GDBProcesses_7_1 {
    protected static final String TRACE_VISUALIZATION_THREAD_ID = "1";
    private CommandFactory fCommandFactory;
    private IGDBControl fCommandControl;
    private IGDBBackend fBackend;
    private static final String INVALID = "invalid";
    private boolean fNeedToReconnect;
    private Set<IRunControl.IContainerDMContext> fProcRestarting = new HashSet<IRunControl.IContainerDMContext>();
    private boolean fTraceVisualization;

    public GDBProcesses_7_2(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBProcesses_7_2.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        super.shutdown(requestMonitor);
    }

    protected boolean getTraceVisualization() {
        return this.fTraceVisualization;
    }

    protected void setTraceVisualization(boolean visualizing) {
        this.fTraceVisualization = visualizing;
    }

    @Override
    public IMIContainerDMContext createContainerContextFromGroupId(ICommandControlService.ICommandControlDMContext controlDmc, String groupId) {
        String pid = this.getGroupToPidMap().get(groupId);
        if (pid == null) {
            pid = "";
        }
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(controlDmc, pid);
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    protected boolean doIsDebuggerAttachSupported() {
        if (this.fBackend.getSessionType() == SessionType.CORE) {
            return false;
        }
        if (this.fBackend.getSessionType() == SessionType.REMOTE && !this.fBackend.getIsAttachSession()) {
            return false;
        }
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.ALL_STOP) {
            return this.getNumConnected() == 0;
        }
        return true;
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, DataRequestMonitor<IDMContext> rm) {
        this.attachDebuggerToProcess(procCtx, null, rm);
    }

    @Override
    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, String binaryPath, DataRequestMonitor<IDMContext> dataRm) {
        if (procCtx instanceof IMIProcessDMContext) {
            if (!this.doIsDebuggerAttachSupported()) {
                dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Attach not supported.", null));
                dataRm.done();
                return;
            }
            ImmediateExecutor.getInstance().execute((Runnable)new Sequence(this.getExecutor(), (RequestMonitor)dataRm, procCtx, binaryPath, (DataRequestMonitor)dataRm){
                private IMIContainerDMContext fContainerDmc;
                private Sequence.Step[] steps;
                {
                    this.steps = new Sequence.Step[]{new Sequence.Step(){

                        public void execute(final RequestMonitor rm) {
                            if (GDBProcesses_7_2.this.isInitialProcess()) {
                                fContainerDmc = GDBProcesses_7_2.this.createContainerContext(iProcessDMContext, "i1");
                                rm.done();
                                return;
                            }
                            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)iProcessDMContext, ICommandControlService.ICommandControlDMContext.class);
                            GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMIAddInferior(controlDmc), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIAddInferiorInfo>(rm){

                                protected void handleSuccess() {
                                    String groupId = ((MIAddInferiorInfo)this.getData()).getGroupId();
                                    if (groupId == null || groupId.trim().length() == 0) {
                                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid gdb group id.", null));
                                    } else {
                                        fContainerDmc = GDBProcesses_7_2.this.createContainerContext(iProcessDMContext, groupId);
                                    }
                                    rm.done();
                                }
                            });
                        }
                    }, new Sequence.Step(){

                        public void execute(final RequestMonitor rm) {
                            if (GDBProcesses_7_2.this.needFixForGDB72Bug352998() && GDBProcesses_7_2.this.fBackend.getSessionType() == SessionType.REMOTE) {
                                if (!$assertionsDisabled && !GDBProcesses_7_2.this.fBackend.getIsAttachSession()) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && string == null) {
                                    throw new AssertionError();
                                }
                                if (GDBProcesses_7_2.this.isInitialProcess()) {
                                    ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)iProcessDMContext, ICommandControlService.ICommandControlDMContext.class);
                                    GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMITargetDisconnect(controlDmc), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                                        protected void handleSuccess() {
                                            GDBProcesses_7_2.this.fNeedToReconnect = true;
                                            rm.done();
                                        }
                                    });
                                    return;
                                }
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(final RequestMonitor rm) {
                            if (string != null) {
                                GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMIFileExecAndSymbols(fContainerDmc, string), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                                    protected void handleCompleted() {
                                        if (GDBProcesses_7_2.this.fNeedToReconnect) {
                                            GDBProcesses_7_2.this.fNeedToReconnect = false;
                                            rm.setStatus(this.getStatus());
                                            GDBProcesses_7_2.this.connectToTarget(iProcessDMContext, rm);
                                        } else {
                                            super.handleCompleted();
                                        }
                                    }
                                });
                                return;
                            }
                            if (!$assertionsDisabled && GDBProcesses_7_2.this.fNeedToReconnect) {
                                throw new AssertionError();
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            boolean shouldInterrupt = true;
                            IMIRunControl runControl = (IMIRunControl)GDBProcesses_7_2.this.getServicesTracker().getService(IMIRunControl.class);
                            if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.NON_STOP) {
                                shouldInterrupt = false;
                            }
                            GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMITargetAttach(fContainerDmc, ((IMIProcessDMContext)iProcessDMContext).getProcId(), shouldInterrupt), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            IGDBMemory memory = (IGDBMemory)GDBProcesses_7_2.this.getServicesTracker().getService(IGDBMemory.class);
                            IMemory.IMemoryDMContext memContext = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)fContainerDmc, IMemory.IMemoryDMContext.class);
                            if (memory == null || memContext == null) {
                                rm.done();
                                return;
                            }
                            memory.initializeMemoryData(memContext, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)GDBProcesses_7_2.this.getServicesTracker().getService(MIBreakpointsManager.class));
                            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)fContainerDmc, IBreakpoints.IBreakpointsTargetDMContext.class);
                            bpmService.startTrackingBreakpoints(bpTargetDmc, rm);
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            ILaunch launch;
                            IReverseRunControl reverseService = (IReverseRunControl)GDBProcesses_7_2.this.getServicesTracker().getService(IReverseRunControl.class);
                            if (reverseService != null && (launch = (ILaunch)iProcessDMContext.getAdapter(ILaunch.class)) != null) {
                                try {
                                    boolean reverseEnabled = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
                                    if (reverseEnabled) {
                                        reverseService.enableReverseMode(GDBProcesses_7_2.this.fCommandControl.getContext(), true, rm);
                                        return;
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                            rm.done();
                        }
                    }, new Sequence.Step(){

                        public void execute(RequestMonitor rm) {
                            dataRequestMonitor.setData((Object)fContainerDmc);
                            GDBProcesses_7_2.this.setIsInitialProcess(false);
                            rm.done();
                        }
                    }};
                }

                public Sequence.Step[] getSteps() {
                    return this.steps;
                }
            });
        } else {
            dataRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            dataRm.done();
        }
    }

    private void connectToTarget(IProcesses.IProcessDMContext procCtx, RequestMonitor rm) {
        ILaunch launch = (ILaunch)procCtx.getAdapter(ILaunch.class);
        assert (launch != null);
        if (launch != null) {
            Map attributes = null;
            try {
                attributes = launch.getLaunchConfiguration().getAttributes();
            }
            catch (CoreException coreException) {}
            boolean isTcpConnection = (Boolean)CDebugUtils.getAttribute((Map)attributes, (String)"org.eclipse.cdt.dsf.gdb.REMOTE_TCP", (Object)false);
            if (isTcpConnection) {
                String remoteTcpHost = (String)CDebugUtils.getAttribute((Map)attributes, (String)"org.eclipse.cdt.dsf.gdb.HOST", (Object)INVALID);
                String remoteTcpPort = (String)CDebugUtils.getAttribute((Map)attributes, (String)"org.eclipse.cdt.dsf.gdb.PORT", (Object)INVALID);
                this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetSelect((IDMContext)this.fCommandControl.getContext(), remoteTcpHost, remoteTcpPort, true), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
            } else {
                String serialDevice = (String)CDebugUtils.getAttribute((Map)attributes, (String)"org.eclipse.cdt.dsf.gdb.DEV", (Object)INVALID);
                this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetSelect((IDMContext)this.fCommandControl.getContext(), serialDevice, true), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
            }
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Cannot reconnect to target.", null));
            rm.done();
        }
    }

    @Override
    public void detachDebuggerFromProcess(IDMContext dmc, final RequestMonitor rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        final IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (controlDmc != null && containerDmc != null) {
            if (!this.doCanDetachDebuggerFromProcess()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Detach not supported.", null));
                rm.done();
                return;
            }
            IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
            if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                this.fBackend.interrupt();
            }
            this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetDetach(controlDmc, containerDmc.getGroupId()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        rm.done();
                    } else {
                        GDBProcesses_7_2.this.fCommandControl.queueCommand(GDBProcesses_7_2.this.fCommandFactory.createMITargetDetach(containerDmc), new DataRequestMonitor((Executor)GDBProcesses_7_2.this.getExecutor(), rm));
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    @Override
    protected boolean doIsDebugNewProcessSupported() {
        SessionType type = this.fBackend.getSessionType();
        if (type == SessionType.CORE) {
            return false;
        }
        if (type == SessionType.REMOTE && !this.fBackend.getIsAttachSession()) {
            return false;
        }
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        if (runControl != null && runControl.getRunMode() == IMIRunControl.MIRunMode.ALL_STOP) {
            return this.getNumConnected() == 0;
        }
        return true;
    }

    @Override
    protected Sequence getDebugNewProcessSequence(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        return new DebugNewProcessSequence_7_2(executor, isInitial, dmc, file, attributes, rm);
    }

    @Override
    public void getProcessesBeingDebugged(IDMContext dmc, DataRequestMonitor<IDMContext[]> rm) {
        IMIContainerDMContext containerDmc;
        if (this.getTraceVisualization() && (containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class)) != null) {
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
            rm.setData((Object)new IMIExecutionDMContext[]{this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, TRACE_VISUALIZATION_THREAD_ID), TRACE_VISUALIZATION_THREAD_ID)});
            rm.done();
            return;
        }
        super.getProcessesBeingDebugged(dmc, rm);
    }

    @Override
    protected IMIContainerDMContext createContainerContextForRestart(String groupId) {
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(this.fCommandControl.getContext(), "");
        return this.createContainerContext(processDmc, groupId);
    }

    @Override
    public void restart(final IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        this.fProcRestarting.add(containerDmc);
        super.restart(containerDmc, attributes, (DataRequestMonitor<IRunControl.IContainerDMContext>)new ImmediateDataRequestMonitor<IRunControl.IContainerDMContext>(rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    GDBProcesses_7_2.this.fProcRestarting.remove(containerDmc);
                }
                this.setData((IRunControl.IContainerDMContext)this.getData());
                super.handleCompleted();
            }
        });
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        IDMContext dmc = e.getDMContext();
        if (dmc instanceof IBreakpoints.IBreakpointsTargetDMContext && !this.fProcRestarting.remove(dmc) && this.fBackend.getSessionType() != SessionType.CORE) {
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)dmc;
            MIBreakpointsManager bpmService = (MIBreakpointsManager)((Object)this.getServicesTracker().getService(MIBreakpointsManager.class));
            if (bpmService != null) {
                bpmService.stopTrackingBreakpoints(bpTargetDmc, (RequestMonitor)new ImmediateRequestMonitor(){

                    protected void handleCompleted() {
                    }
                });
            }
        }
        super.eventDispatched(e);
    }

    protected boolean needFixForGDB72Bug352998() {
        return true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        this.setTraceVisualization(e.isVisualizationModeEnabled());
    }
}

