/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.cdt.debug.internal.core.CBreakpointManager;
import org.eclipse.cdt.debug.internal.core.ListenerList;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

public class CSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private static final NoSourceElement gfNoSource = new NoSourceElement();
    private ListenerList fListeners;
    private Map<Object, Object[]> fCachedResults = Collections.synchronizedMap(new HashMap());

    public CSourceLookupParticipant() {
        this.fListeners = new ListenerList(1);
    }

    public String getSourceName(Object object) throws CoreException {
        ICStackFrame frame;
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IAdaptable && (frame = (ICStackFrame)((IAdaptable)object).getAdapter(ICStackFrame.class)) != null) {
            String name = frame.getFile();
            return name != null && name.trim().length() > 0 ? name : null;
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] foundElements;
        Object[] results = this.fCachedResults.get(object);
        if (results != null) {
            return results;
        }
        String name = null;
        IBreakpoint breakpoint = null;
        if (object instanceof IAdaptable) {
            ICStackFrame frame = (ICStackFrame)((IAdaptable)object).getAdapter(ICStackFrame.class);
            if (frame != null && ((name = frame.getFile().trim()) == null || name.length() == 0)) {
                results = object instanceof IDebugElement ? new Object[]{new CSourceNotFoundElement((IAdaptable)((IDebugElement)object), ((IDebugElement)object).getLaunch().getLaunchConfiguration(), name)} : new Object[]{gfNoSource};
                this.fCachedResults.put(object, results);
                return results;
            }
            ICDebugTarget target = (ICDebugTarget)((IAdaptable)object).getAdapter(ICDebugTarget.class);
            if (target != null) {
                CBreakpointManager bmanager = (CBreakpointManager)target.getAdapter(CBreakpointManager.class);
                Object stateInfo = target.getCurrentStateInfo();
                if (bmanager != null && stateInfo instanceof ICDIBreakpointHit) {
                    breakpoint = bmanager.getBreakpoint(((ICDIBreakpointHit)stateInfo).getBreakpoint());
                }
            }
        } else if (object instanceof String) {
            name = (String)object;
        }
        if ((foundElements = super.findSourceElements(object)).length == 0 && object instanceof IDebugElement) {
            foundElements = new File(name).exists() ? new AbsolutePathSourceContainer().findSourceElements(name) : new Object[]{new CSourceNotFoundElement((IAdaptable)((IDebugElement)object), ((IDebugElement)object).getLaunch().getLaunchConfiguration(), name)};
        }
        if (breakpoint != null && breakpoint.getMarker() != null && breakpoint.getMarker().getResource() != null) {
            IResource breakpointResource = breakpoint.getMarker().getResource();
            int i = 0;
            while (i < foundElements.length) {
                if (foundElements[i].equals(breakpointResource)) {
                    Object temp = foundElements[0];
                    foundElements[0] = foundElements[i];
                    foundElements[i] = temp;
                    break;
                }
                ++i;
            }
        }
        this.fCachedResults.put(object, foundElements);
        return foundElements;
    }

    public void dispose() {
        this.fListeners.removeAll();
        super.dispose();
    }

    public void addSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeSourceLookupChangeListener(ISourceLookupChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.fCachedResults.clear();
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISourceLookupChangeListener)listeners[i]).sourceContainersChanged(director);
            ++i;
        }
        super.sourceContainersChanged(director);
    }

    static class NoSourceElement {
        NoSourceElement() {
        }
    }
}

