/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Collection;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.BusyCursorJobRunner;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.refactoring.includes.IElementSelector;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AddIncludeAction
extends TextEditorAction {
    private IElementSelector fAmbiguityResolver;

    public AddIncludeAction(ITextEditor editor) {
        super(CEditorMessages.getBundleForConstructedKeys(), "AddInclude.", editor);
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.add_includes_on_selection_action_context");
        final Shell shell = editor.getEditorSite().getShell();
        this.fAmbiguityResolver = new IElementSelector(){

            @Override
            public <T> T selectElement(final Collection<T> elements) {
                final Object[] result = new Object[1];
                AddIncludeAction.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                        dialog.setElements(elements.toArray());
                        dialog.setTitle(CEditorMessages.AddInclude_label);
                        dialog.setMessage(CEditorMessages.AddInclude_description);
                        if (dialog.open() == 0) {
                            result[0] = dialog.getFirstResult();
                        }
                    }
                });
                return (T)result[0];
            }
        };
    }

    public void run() {
        MultiTextEdit[] holder;
        ITextEditor editor = this.getTextEditor();
        final ITranslationUnit tu = AddIncludeAction.getTranslationUnit(editor);
        if (tu == null) {
            return;
        }
        ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
        if (selection.isEmpty() || !(selection instanceof ITextSelection)) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        final String lineDelimiter = AddIncludeAction.getLineDelimiter(editor);
        SharedASTJob job = new SharedASTJob(CEditorMessages.AddInclude_action, tu, holder = new MultiTextEdit[1], selection){
            private final /* synthetic */ MultiTextEdit[] val$holder;
            private final /* synthetic */ ISelection val$selection;
            {
                this.val$holder = multiTextEditArray;
                this.val$selection = iSelection;
                super($anonymous0, $anonymous1);
            }

            @Override
            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                if (ast == null) {
                    return CUIPlugin.createErrorStatus(NLS.bind((String)CEditorMessages.AddInclude_ast_not_available, (Object)tu.getPath().toOSString()));
                }
                IIndex index = CCorePlugin.getIndexManager().getIndex(tu.getCProject(), 33);
                try {
                    index.acquireReadLock();
                    IncludeCreator creator = new IncludeCreator(tu, index, lineDelimiter, AddIncludeAction.this.fAmbiguityResolver);
                    this.val$holder[0] = creator.createInclude(ast, (ITextSelection)this.val$selection);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    index.releaseReadLock();
                }
            }
        };
        IStatus status = BusyCursorJobRunner.execute(job);
        if (status.isOK()) {
            MultiTextEdit edit = holder[0];
            if (edit.hasChildren()) {
                IEditorInput editorInput = editor.getEditorInput();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
                IDocumentUndoManager manager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
                manager.beginCompoundChange();
                try {
                    edit.apply(document);
                }
                catch (BadLocationException | MalformedTreeException e) {
                    CUIPlugin.log(e);
                }
                manager.endCompoundChange();
            }
        } else if (status.matches(4)) {
            ErrorDialog.openError((Shell)editor.getEditorSite().getShell(), (String)CEditorMessages.AddInclude_error_title, (String)CEditorMessages.AddInclude_insertion_failed, (IStatus)status);
        }
    }

    private static void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }

    private static String getLineDelimiter(ITextEditor editor) {
        try {
            IEditorInput editorInput = editor.getEditorInput();
            IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
            String delim = document.getLineDelimiter(0);
            if (delim != null) {
                return delim;
            }
        }
        catch (BadLocationException badLocationException) {}
        return System.getProperty("line.separator", "\n");
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        this.setEnabled(editor != null && AddIncludeAction.getTranslationUnit(editor) != null);
    }

    private static ITranslationUnit getTranslationUnit(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
    }

    public void setAmbiguityResolver(IElementSelector fAmbiguityResolver) {
        this.fAmbiguityResolver = fAmbiguityResolver;
    }
}

