/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.connection.toolkits;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.RemoteConnectionToolkitWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public final class RemoteConnectionToolkitWizard
extends Wizard {
    private static final PropertyDescriptor<IRemoteConnection> PROPERTY_CONNECTION = new PropertyDescriptor("connection", IRemoteConnection.class);
    private final IRemoteConnection connection;
    private ICudaToolkit cudaToolkit;
    private RemoteConnectionToolkitWizardPage page;
    private WizardContext wizardContext;

    public RemoteConnectionToolkitWizard(IRemoteConnection connection) {
        this.connection = connection;
        this.setWindowTitle(String.format("CUDA Toolkits on %s", connection.getName()));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.wizardContext = new WizardContext(this.getContainer());
        this.wizardContext.setProperty(PROPERTY_CONNECTION, (Object)this.connection);
        this.page = new RemoteConnectionToolkitWizardPage(this.wizardContext, PROPERTY_CONNECTION, "Select nvprof location", "nvprof");
        this.addPage((IWizardPage)this.page);
    }

    public ICudaToolkit getCudaToolkit() {
        return this.cudaToolkit;
    }

    public boolean performFinish() {
        IRemoteConnection connection = (IRemoteConnection)this.wizardContext.getProperty(PROPERTY_CONNECTION);
        this.cudaToolkit = connection.updateToolkit(this.page.getToolkit());
        return true;
    }

    public void setWarning(String format, Object ... args) {
        this.page.setMessage(String.format(format, args), 2);
    }
}

