/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.Map;
import org.eclipse.birt.core.script.BaseScriptable;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class ScriptablePageVariables
extends BaseScriptable {
    private Map<String, PageVariable> variables;
    private static final String JS_CLASS_NAME = "ScriptableVariables";

    public ScriptablePageVariables(Map<String, PageVariable> variables, Scriptable scope) {
        this.setParentScope(scope);
        this.variables = variables;
    }

    public Object get(String name, Scriptable start) {
        PageVariable variable = this.variables.get(name);
        if (variable != null) {
            return variable.getValue();
        }
        String errorMessage = "Report variable\"" + name + "\" does not exist";
        throw new JavaScriptException((Object)errorMessage, "<unknown>", -1);
    }

    public Object get(int index, Scriptable start) {
        return this.get(String.valueOf(index), start);
    }

    public boolean has(String name, Scriptable start) {
        return this.variables.get(name) != null;
    }

    public void put(String name, Scriptable start, Object value) {
        PageVariable variable = this.variables.get(name);
        if (variable != null) {
            if (value instanceof Wrapper) {
                value = ((Wrapper)value).unwrap();
            }
            variable.setValue(value);
            return;
        }
        String errorMessage = "Report variable\"" + name + "\" does not exist";
        throw new JavaScriptException((Object)errorMessage, "<unknown>", -1);
    }

    public String getClassName() {
        return JS_CLASS_NAME;
    }
}

