/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.aggregation.IProgressiveAggregationHelper;
import org.eclipse.birt.data.engine.executor.cache.RowResultSet;
import org.eclipse.birt.data.engine.executor.transform.IGroupCalculator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SimpleGroupCalculator
implements IGroupCalculator {
    private IResultObject previous;
    private IResultObject next;
    private IResultObject current;
    private GroupBy[] groupBys;
    private Integer[] groupInstanceIndex;
    private int[] latestAggrAvailableIndex;
    private StreamManager streamManager;
    private RAOutputStream[] groupOutput;
    private RAOutputStream[] aggrRAOutput;
    private DataOutputStream[] aggrOutput;
    private DataOutputStream[] aggrIndexOutput;
    private RAOutputStream combinedAggrIndexRAOutput;
    private DataOutputStream combinedAggrIndexOutput;
    private RAOutputStream combinedAggrRAOutput;
    private DataOutputStream combinedAggrOutput;
    private IProgressiveAggregationHelper aggrHelper;
    private List<List<String>> groupAggrs;
    private List<String> runningAggrs;
    private List<String> overallAggrs;
    private GroupInfo[] previousGroupInstances;
    private Object[][] previousGroupAggrs;
    private Object[] previousRunningAggrs;
    private Object[] previousOverallAggrs;

    public SimpleGroupCalculator(DataEngineSession session, IQuery.GroupSpec[] groups, IResultClass rsMeta) throws DataException {
        this.groupBys = new GroupBy[groups.length];
        this.latestAggrAvailableIndex = new int[groups.length];
        Arrays.fill(this.latestAggrAvailableIndex, -1);
        int i = 0;
        while (i < groups.length) {
            int keyIndex = groups[i].getKeyIndex();
            String keyColumn = groups[i].getKeyColumn();
            if (keyColumn != null) {
                keyIndex = rsMeta.getFieldIndex(keyColumn);
            }
            this.groupBys[i] = GroupBy.newInstance(groups[i], keyIndex, keyColumn, rsMeta.getFieldValueClass(keyIndex));
            ++i;
        }
        this.groupInstanceIndex = new Integer[this.groupBys.length];
        Arrays.fill((Object[])this.groupInstanceIndex, (Object)0);
        this.groupAggrs = new ArrayList<List<String>>();
        this.runningAggrs = new ArrayList<String>();
        this.overallAggrs = new ArrayList<String>();
        this.aggrOutput = new DataOutputStream[0];
        i = 0;
        while (i < groups.length) {
            this.groupAggrs.add(new ArrayList());
            ++i;
        }
    }

    @Override
    public void setAggrHelper(IProgressiveAggregationHelper aggrHelper) throws DataException {
        this.aggrHelper = aggrHelper;
        for (String aggrName : this.aggrHelper.getAggrNames()) {
            IAggrInfo aggrInfo = this.aggrHelper.getAggrInfo(aggrName);
            if (aggrInfo.getAggregation().getType() == 1) {
                this.runningAggrs.add(aggrName);
                continue;
            }
            if (aggrInfo.getGroupLevel() == 0) {
                this.overallAggrs.add(aggrName);
                continue;
            }
            if (this.aggrHelper.getAggrInfo(aggrName).getGroupLevel() > this.groupAggrs.size()) continue;
            this.groupAggrs.get(this.aggrHelper.getAggrInfo(aggrName).getGroupLevel() - 1).add(aggrName);
        }
    }

    private int getBreakingGroup(IResultObject obj1, IResultObject obj2) throws DataException {
        if (obj1 == null) {
            return 0;
        }
        if (obj2 == null) {
            return 0;
        }
        int i = 0;
        while (i < this.groupBys.length) {
            int columnIndex = this.groupBys[i].getColumnIndex();
            if (!this.groupBys[i].isInSameGroup(obj1.getFieldValue(columnIndex), obj2.getFieldValue(columnIndex))) {
                return i + 1;
            }
            ++i;
        }
        return this.groupBys.length + 1;
    }

    @Override
    public int getStartingGroup() throws DataException {
        return this.getBreakingGroup(this.previous, this.current);
    }

    @Override
    public int getEndingGroup() throws DataException {
        return this.getBreakingGroup(this.current, this.next);
    }

    @Override
    public void registerPreviousResultObject(IResultObject previous) {
        this.previous = previous;
    }

    @Override
    public void registerCurrentResultObject(IResultObject current) {
        this.current = current;
    }

    @Override
    public void registerNextResultObject(RowResultSet rowResultSet) throws DataException {
        this.next = rowResultSet.getNext();
    }

    private void saveGroupInfo(GroupInfo group, int level, int rowId) throws DataException {
        try {
            if (this.streamManager != null) {
                IOUtil.writeInt((OutputStream)this.groupOutput[level], (int)group.parent);
                IOUtil.writeInt((OutputStream)this.groupOutput[level], (int)group.firstChild);
                this.groupOutput[level].flush();
            }
        }
        catch (IOException ioex) {
            throw new DataException(ioex.getLocalizedMessage(), ioex);
        }
    }

    private void savePreviousGroupAggrs(int level, int rowId) throws DataException {
        try {
            if (this.streamManager != null && this.previous != null) {
                this.saveToAggrValuesToDocument(level, rowId);
            }
        }
        catch (IOException ioex) {
            throw new DataException(ioex.getLocalizedMessage(), ioex);
        }
    }

    private void savePreviousOverallAggrs() throws DataException {
        if (this.previousOverallAggrs != null && this.streamManager != null) {
            try {
                this.combinedAggrIndexRAOutput.seek(0L);
                IOUtil.writeLong((DataOutputStream)this.combinedAggrIndexOutput, (long)this.combinedAggrRAOutput.getOffset());
                int i = 0;
                while (i < this.previousOverallAggrs.length) {
                    IOUtil.writeObject((DataOutputStream)this.combinedAggrOutput, (Object)this.previousOverallAggrs[i]);
                    ++i;
                }
                this.previousOverallAggrs = null;
            }
            catch (IOException ioex) {
                throw new DataException(ioex.getLocalizedMessage(), ioex);
            }
        }
    }

    private void savePreviousRunningAggrs() throws DataException {
        if (this.previousRunningAggrs != null && this.streamManager != null) {
            try {
                int i = 0;
                while (i < this.previousRunningAggrs.length) {
                    IOUtil.writeObject((DataOutputStream)this.combinedAggrOutput, (Object)this.previousRunningAggrs[i]);
                    ++i;
                }
                IOUtil.writeLong((DataOutputStream)this.combinedAggrIndexOutput, (long)this.combinedAggrRAOutput.getOffset());
                this.previousRunningAggrs = null;
            }
            catch (IOException ioex) {
                throw new DataException(ioex.getLocalizedMessage(), ioex);
            }
        }
    }

    private void savePreviousGroupInfos() throws DataException {
        if (this.previousGroupInstances != null && this.streamManager != null) {
            int level = 0;
            while (level < this.groupInstanceIndex.length) {
                this.saveGroupInfo(this.previousGroupInstances[level], level, 0);
                ++level;
            }
            this.previousGroupInstances = null;
        }
    }

    private void savePreviousGroupAggrs() throws DataException {
        if (this.previousGroupAggrs != null && this.streamManager != null) {
            try {
                int i = 0;
                while (i < this.previousGroupAggrs.length) {
                    if (this.previousGroupAggrs[i] != null) {
                        int j = 0;
                        while (j < this.previousGroupAggrs[i].length) {
                            IOUtil.writeObject((DataOutputStream)this.aggrOutput[i], (Object)this.previousGroupAggrs[i][j]);
                            ++j;
                        }
                        if (this.aggrIndexOutput[i] != null) {
                            IOUtil.writeLong((DataOutputStream)this.aggrIndexOutput[i], (long)this.aggrRAOutput[i].getOffset());
                        }
                    }
                    ++i;
                }
                this.previousGroupAggrs = null;
            }
            catch (IOException ex) {
                throw new DataException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    @Override
    public void next(int rowId) throws DataException {
        int i;
        int breakLevel;
        this.savePreviousGroupInfos();
        this.savePreviousGroupAggrs();
        this.savePreviousRunningAggrs();
        this.savePreviousOverallAggrs();
        if (this.previous == null) {
            breakLevel = 0;
            if (this.streamManager == null) {
                this.previousGroupInstances = new GroupInfo[this.groupBys.length];
                this.previousRunningAggrs = this.runningAggrs.size() > 0 ? new Object[this.runningAggrs.size()] : null;
                Object[] objectArray = this.previousOverallAggrs = this.overallAggrs.size() > 0 && this.next == null ? new Object[this.overallAggrs.size()] : null;
                if (this.next == null) {
                    this.previousGroupAggrs = new Object[this.groupBys.length][];
                    i = 0;
                    while (i < this.groupBys.length) {
                        if (!this.groupAggrs.get(i).isEmpty()) {
                            this.previousGroupAggrs[i] = new Object[this.groupAggrs.get(i).size()];
                        }
                        ++i;
                    }
                }
            }
        } else {
            breakLevel = this.getBreakLevel(this.current, this.previous);
        }
        try {
            int level = breakLevel;
            while (level < this.groupInstanceIndex.length) {
                Iterator<String> group = new GroupInfo();
                if (this.previousGroupInstances != null) {
                    this.previousGroupInstances[level] = group;
                }
                if (level != 0) {
                    ((GroupInfo)((Object)group)).parent = this.groupInstanceIndex[level - 1] - 1;
                }
                ((GroupInfo)((Object)group)).firstChild = level == this.groupInstanceIndex.length - 1 ? rowId : this.groupInstanceIndex[level + 1];
                int n = level;
                this.groupInstanceIndex[n] = this.groupInstanceIndex[n] + 1;
                this.saveGroupInfo((GroupInfo)((Object)group), level, rowId);
                this.savePreviousGroupAggrs(level, rowId);
                ++level;
            }
            this.aggrHelper.onRow(this.getStartingGroup(), this.getEndingGroup(), this.current, rowId);
            i = 0;
            while (this.previousRunningAggrs != null && i < this.runningAggrs.size()) {
                this.previousRunningAggrs[i] = this.aggrHelper.getLatestAggrValue(this.runningAggrs.get(i));
                ++i;
            }
            if (this.runningAggrs.size() > 0 && this.combinedAggrOutput != null && this.combinedAggrRAOutput != null && this.combinedAggrIndexOutput != null) {
                for (String aggrName : this.runningAggrs) {
                    IOUtil.writeObject((DataOutputStream)this.combinedAggrOutput, (Object)this.aggrHelper.getLatestAggrValue(aggrName));
                }
                IOUtil.writeLong((DataOutputStream)this.combinedAggrIndexOutput, (long)this.combinedAggrRAOutput.getOffset());
            }
            if (this.next == null) {
                i = 0;
                while (i < this.aggrOutput.length) {
                    this.saveToAggrValuesToDocument(i, rowId);
                    ++i;
                }
                if (this.overallAggrs.size() > 0 && this.combinedAggrIndexOutput != null && this.combinedAggrIndexRAOutput != null && this.combinedAggrRAOutput != null && this.combinedAggrOutput != null) {
                    this.combinedAggrIndexRAOutput.seek(0L);
                    IOUtil.writeLong((DataOutputStream)this.combinedAggrIndexOutput, (long)this.combinedAggrRAOutput.getOffset());
                    for (String aggrName : this.overallAggrs) {
                        IOUtil.writeObject((DataOutputStream)this.combinedAggrOutput, (Object)this.aggrHelper.getLatestAggrValue(aggrName));
                    }
                }
                i = 0;
                while (this.previousOverallAggrs != null && i < this.overallAggrs.size()) {
                    this.previousOverallAggrs[i] = this.aggrHelper.getLatestAggrValue(this.overallAggrs.get(i));
                    ++i;
                }
                i = 0;
                while (this.previousGroupAggrs != null && i < this.previousGroupAggrs.length) {
                    if (this.previousGroupAggrs[i] != null) {
                        int j = 0;
                        while (j < this.groupAggrs.get(i).size()) {
                            this.previousGroupAggrs[i][j] = this.aggrHelper.getLatestAggrValue(this.groupAggrs.get(i).get(j));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private void saveToAggrValuesToDocument(int i, int rowId) throws IOException, DataException {
        if (this.aggrOutput[i] != null) {
            for (String aggrName : this.groupAggrs.get(i)) {
                IOUtil.writeObject((DataOutputStream)this.aggrOutput[i], (Object)this.aggrHelper.getLatestAggrValue(aggrName));
            }
            if (this.aggrIndexOutput[i] != null) {
                IOUtil.writeLong((DataOutputStream)this.aggrIndexOutput[i], (long)this.aggrRAOutput[i].getOffset());
            }
        }
        this.latestAggrAvailableIndex[i] = rowId - 1;
    }

    private int getBreakLevel(IResultObject currRow, IResultObject prevRow) throws DataException {
        assert (currRow != null);
        assert (prevRow != null);
        int breakLevel = 0;
        while (breakLevel < this.groupBys.length) {
            GroupBy groupBy;
            int colIndex = this.groupBys[breakLevel].getColumnIndex();
            Object currObjectValue = null;
            Object prevObjectValue = null;
            if (colIndex >= 0) {
                currObjectValue = currRow.getFieldValue(colIndex);
                prevObjectValue = prevRow.getFieldValue(colIndex);
            }
            if (!(groupBy = this.groupBys[breakLevel]).isInSameGroup(currObjectValue, prevObjectValue)) {
                int i = breakLevel + 1;
                while (i < this.groupBys.length) {
                    this.groupBys[i].reset();
                    ++i;
                }
                break;
            }
            ++breakLevel;
        }
        return breakLevel;
    }

    @Override
    public void close() throws DataException {
        try {
            int i;
            this.savePreviousGroupInfos();
            this.savePreviousGroupAggrs();
            this.savePreviousRunningAggrs();
            this.savePreviousOverallAggrs();
            if (this.groupOutput != null) {
                i = 0;
                while (i < this.groupOutput.length) {
                    this.groupOutput[i].seek(0L);
                    IOUtil.writeInt((OutputStream)this.groupOutput[i], (int)this.groupInstanceIndex[i]);
                    this.groupOutput[i].close();
                    ++i;
                }
                this.groupOutput = null;
            }
            if (this.aggrOutput != null) {
                i = 0;
                while (i < this.aggrOutput.length) {
                    if (this.aggrOutput[i] != null) {
                        this.aggrOutput[i].close();
                    }
                    ++i;
                }
                this.aggrOutput = null;
            }
            if (this.aggrIndexOutput != null) {
                i = 0;
                while (i < this.aggrIndexOutput.length) {
                    if (this.aggrIndexOutput[i] != null) {
                        this.aggrIndexOutput[i].close();
                    }
                    ++i;
                }
                this.aggrIndexOutput = null;
            }
            if (this.overallAggrs.size() > 0 && this.combinedAggrIndexOutput != null) {
                this.combinedAggrIndexRAOutput.close();
                this.combinedAggrOutput.close();
            }
            if (this.aggrHelper != null) {
                this.aggrHelper.close();
                this.aggrHelper = null;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void doSave(StreamManager manager) throws DataException {
        try {
            this.streamManager = manager;
            if (this.streamManager != null) {
                int i;
                this.groupOutput = new RAOutputStream[this.groupBys.length];
                this.aggrOutput = new DataOutputStream[this.groupBys.length];
                this.aggrRAOutput = new RAOutputStream[this.groupBys.length];
                this.aggrIndexOutput = new DataOutputStream[this.groupBys.length];
                if (this.overallAggrs.size() > 0 || this.runningAggrs.size() > 0) {
                    this.combinedAggrIndexRAOutput = (RAOutputStream)this.streamManager.getOutStream(105, 0, 0);
                    this.combinedAggrRAOutput = (RAOutputStream)this.streamManager.getOutStream(106, 0, 0);
                    this.combinedAggrOutput = new DataOutputStream((OutputStream)this.combinedAggrRAOutput);
                    this.combinedAggrIndexOutput = new DataOutputStream((OutputStream)this.combinedAggrIndexRAOutput);
                    IOUtil.writeLong((DataOutputStream)this.combinedAggrIndexOutput, (long)-1L);
                    IOUtil.writeInt((OutputStream)this.combinedAggrOutput, (int)this.overallAggrs.size());
                    i = 0;
                    while (i < this.overallAggrs.size()) {
                        IOUtil.writeString((DataOutputStream)this.combinedAggrOutput, (String)this.overallAggrs.get(i));
                        ++i;
                    }
                    IOUtil.writeInt((OutputStream)this.combinedAggrOutput, (int)this.runningAggrs.size());
                    i = 0;
                    while (i < this.runningAggrs.size()) {
                        IOUtil.writeString((DataOutputStream)this.combinedAggrOutput, (String)this.runningAggrs.get(i));
                        ++i;
                    }
                    IOUtil.writeLong((DataOutputStream)this.combinedAggrIndexOutput, (long)this.combinedAggrRAOutput.getOffset());
                }
                i = 0;
                while (i < this.groupBys.length) {
                    this.groupOutput[i] = this.streamManager.getOutStream(120, i);
                    IOUtil.writeInt((OutputStream)this.groupOutput[i], (int)Integer.MAX_VALUE);
                    if (!this.groupAggrs.get(i).isEmpty()) {
                        this.aggrRAOutput[i] = this.streamManager.getOutStream(104, i);
                        this.aggrIndexOutput[i] = new DataOutputStream((OutputStream)this.streamManager.getOutStream(103, i));
                        this.aggrOutput[i] = new DataOutputStream((OutputStream)this.aggrRAOutput[i]);
                        IOUtil.writeInt((OutputStream)this.aggrOutput[i], (int)(i + 1));
                        IOUtil.writeInt((OutputStream)this.aggrOutput[i], (int)this.groupAggrs.get(i).size());
                        for (String aggrName : this.groupAggrs.get(i)) {
                            IOUtil.writeString((DataOutputStream)new DataOutputStream(this.aggrOutput[i]), (String)aggrName);
                        }
                        IOUtil.writeLong((DataOutputStream)this.aggrIndexOutput[i], (long)this.aggrRAOutput[i].getOffset());
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public boolean isAggrAtIndexAvailable(String aggrName, int currentIndex) throws DataException {
        assert (this.aggrHelper != null);
        if (this.aggrHelper.getAggrInfo(aggrName).getAggregation().getType() == 1) {
            return true;
        }
        if (this.aggrHelper.getAggrInfo(aggrName).getGroupLevel() == 0) {
            return this.current == null;
        }
        return this.latestAggrAvailableIndex[this.aggrHelper.getAggrInfo(aggrName).getGroupLevel() - 1] >= currentIndex;
    }

    @Override
    public Integer[] getGroupInstanceIndex() {
        return this.groupInstanceIndex;
    }
}

