/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.List;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.INameContainer;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.IContainerDefn;
import org.eclipse.birt.report.model.metadata.NameConfig;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.util.LevelContentIterator;

class NameExecutorImpl {
    protected DesignElement focus;
    protected ContainerContext container;
    protected DesignElement nsContainer;
    protected Module module;
    protected INameHelper nameHelper;
    protected int namespaceId;
    public static final String NAME_SEPARATOR = "/";

    public NameExecutorImpl(Module module, DesignElement container, DesignElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element can not be null");
        }
        this.module = module;
        this.container = null;
        this.nsContainer = container;
        this.focus = element;
        this.findNameHelper();
    }

    public NameExecutorImpl(Module module, ContainerContext container, DesignElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element can not be null");
        }
        this.module = module;
        this.container = container;
        this.nsContainer = null;
        this.focus = element;
        this.findNameHelper();
    }

    protected void findNameHelper() {
        this.nameHelper = null;
        this.namespaceId = -1;
        ElementDefn focusDefn = (ElementDefn)this.focus.getDefn();
        if (focusDefn.getNameOption() == 0) {
            return;
        }
        NameConfig nameConfig = focusDefn.getNameConfig();
        this.namespaceId = nameConfig.getNameSpaceID();
        ElementPropertyDefn tgtProp = (ElementPropertyDefn)nameConfig.getNameProperty();
        if (tgtProp != null) {
            Object value = this.module.getProperty(this.module, tgtProp);
            if (value == null) {
                return;
            }
            if (value instanceof List) {
                List valueList = (List)value;
                if (valueList.isEmpty()) {
                    return;
                }
                value = valueList.get(0);
            }
            if (value instanceof INameContainer) {
                this.nameHelper = ((INameContainer)value).getNameHelper();
                return;
            }
            return;
        }
        IElementDefn holderDefn = nameConfig.getNameContainer();
        if (holderDefn != null) {
            DesignElement nsParent = this.nsContainer;
            if (nsParent == null) {
                if (this.container != null) {
                    nsParent = this.container.getElement();
                } else if (this.module == this.focus.getRoot() || this.focus.getRoot() == null) {
                    nsParent = this.focus.getContainer();
                }
            }
            while (nsParent != null) {
                if (nsParent.getDefn().isKindOf(holderDefn) && nsParent instanceof INameContainer) {
                    this.nameHelper = ((INameContainer)((Object)nsParent)).getNameHelper();
                    return;
                }
                nsParent = nsParent.getContainer();
            }
            if (this.module.getDefn().isKindOf(holderDefn)) {
                this.nameHelper = this.module.getNameHelper();
                return;
            }
            return;
        }
        ContainerContext context = this.container;
        if (context == null) {
            if (this.nsContainer != null) {
                context = this.getContext(this.nsContainer, this.focus);
            }
            if (context == null) {
                context = this.focus.getContainerInfo();
            }
        }
        while (context != null) {
            List<IElementDefn> allowElements;
            DesignElement parent = context.getElement();
            IContainerDefn propDefn = context.getContainerDefn();
            nameConfig = propDefn.getNameConfig();
            if (nameConfig != null && parent instanceof INameContainer && (allowElements = propDefn.getAllowedElements()) != null) {
                for (IElementDefn allowElement : allowElements) {
                    if (!focusDefn.isKindOf(allowElement)) continue;
                    this.nameHelper = ((INameContainer)((Object)parent)).getNameHelper();
                    this.namespaceId = nameConfig.getNameSpaceID();
                    return;
                }
            }
            context = parent.getContainerInfo();
        }
    }

    public boolean hasNamespace() {
        return this.nameHelper != null;
    }

    public INameHelper getNameHelper() {
        return this.nameHelper;
    }

    public final NameSpace getNameSpace() {
        if (this.nameHelper != null) {
            return this.nameHelper.getNameSpace(this.namespaceId);
        }
        return null;
    }

    public final int getNameSpaceId() {
        if (this.nameHelper != null) {
            return this.namespaceId;
        }
        return -1;
    }

    public String getUniqueName() {
        return this.getUniqueName(null);
    }

    public String getUniqueName(String prefix) {
        if (this.focus instanceof GroupElement) {
            return this.getUniqueGroupName((GroupElement)this.focus, prefix);
        }
        if (this.nameHelper != null) {
            return this.nameHelper.getUniqueName(this.namespaceId, this.focus, prefix);
        }
        return null;
    }

    public void makeUniqueName() {
        this.makeUniqueName(null);
    }

    public void makeUniqueName(String prefix) {
        if (this.focus instanceof GroupElement) {
            this.makeUniqueGroupName((GroupElement)this.focus, prefix);
            return;
        }
        if (this.nameHelper != null) {
            this.nameHelper.makeUniqueName(this.namespaceId, this.focus, prefix);
        }
    }

    public void rename() {
        if (this.focus instanceof GroupElement) {
            this.makeUniqueGroupName((GroupElement)this.focus, null);
        } else {
            ElementDefn defn = (ElementDefn)this.focus.getDefn();
            if (defn.getNameOption() == 2 || this.focus.getRoot() instanceof Library || this.module instanceof Library || this.focus.getName() != null) {
                this.makeUniqueName();
            }
        }
        LevelContentIterator iter = new LevelContentIterator(this.module, this.focus, 1);
        while (iter.hasNext()) {
            DesignElement innerElement = iter.next();
            new NameExecutor(this.module, innerElement).rename();
        }
    }

    public DesignElement getElement(String name) {
        if (this.nameHelper != null) {
            return this.nameHelper.getNameSpace(this.namespaceId).getElement(name);
        }
        return null;
    }

    public void dropElement() {
        if (this.nameHelper != null) {
            this.nameHelper.dropElement(this.namespaceId, this.focus);
        }
    }

    private void makeUniqueGroupName(GroupElement group, String prefix) {
        String name = this.getUniqueGroupName(group, prefix);
        if (name != null) {
            this.setUniqueGroupName(group, name);
        }
    }

    private String getUniqueGroupName(GroupElement group, String prefix) {
        if (group == null || group.getContainer() == null) {
            return null;
        }
        ListingHandle listing = (ListingHandle)group.getContainer().getHandle(this.module);
        String groupName = (String)group.getLocalProperty(this.module, "groupName");
        if (StringUtil.isBlank(groupName = NamePropertyType.validateName(groupName))) {
            GroupElement virtualGroup = (GroupElement)group.getVirtualParent();
            while (virtualGroup != null) {
                groupName = (String)virtualGroup.getLocalProperty(virtualGroup.getRoot(), "groupName");
                if (!StringUtil.isBlank(groupName)) break;
                virtualGroup = (GroupElement)virtualGroup.getVirtualParent();
            }
        }
        String namePrefix = groupName;
        int level = group.getGroupLevel();
        if (StringUtil.isBlank(namePrefix)) {
            namePrefix = ModelMessages.getMessage("New." + group.getDefn().getName());
            namePrefix = namePrefix.trim();
            groupName = String.valueOf(namePrefix) + level;
        }
        while (GroupNameValidator.getInstance().validateForRenamingGroup(listing, (GroupHandle)group.getHandle(this.module), groupName).size() != 0) {
            groupName = String.valueOf(namePrefix) + level;
            ++level;
        }
        return groupName;
    }

    private void setUniqueGroupName(GroupElement group, String groupName) {
        assert (groupName != null);
        String localGroupName = (String)group.getLocalProperty(this.module, "groupName");
        if (groupName.equals(localGroupName)) {
            return;
        }
        group.setProperty("groupName", (Object)groupName);
    }

    protected ContainerContext getContext(DesignElement container, DesignElement content) {
        if (content.getContainer() == container) {
            return content.getContainerInfo();
        }
        IElementDefn containerDefn = container.getDefn();
        IElementDefn contentDefn = content.getDefn();
        List<IElementPropertyDefn> props = containerDefn.getProperties();
        for (IElementPropertyDefn prop : props) {
            List<IElementDefn> elements = prop.getAllowedElements();
            if (elements == null) continue;
            for (IElementDefn element : elements) {
                if (!contentDefn.isKindOf(element)) continue;
                return new ContainerContext(container, prop.getName());
            }
        }
        int slotCount = containerDefn.getSlotCount();
        int i = 0;
        while (i < slotCount) {
            ISlotDefn slotDefn = containerDefn.getSlot(i);
            List<IElementDefn> elements = slotDefn.getAllowedElements();
            if (elements != null) {
                for (IElementDefn element : elements) {
                    if (!contentDefn.isKindOf(element)) continue;
                    return new ContainerContext(container, i);
                }
            }
            ++i;
        }
        return null;
    }
}

