/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTLOGICALIDENTITYACCESS_H_
#define OPENDRIM_BOOTLOGICALIDENTITYACCESS_H_

#include "Boot_Common.h"

#include "OpenDRIM_BootLogicalIdentity.h"
#include "assocOpenDRIM_BootLogicalIdentity.h"

int Boot_OpenDRIM_BootLogicalIdentity_load(const CMPIBroker* broker, string& errorMessage);

int Boot_OpenDRIM_BootLogicalIdentity_unload(string& errorMessage);

int Boot_OpenDRIM_BootLogicalIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootLogicalIdentity>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootLogicalIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootLogicalIdentity& instance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootLogicalIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootLogicalIdentity& newInstance, const OpenDRIM_BootLogicalIdentity& oldInstance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootLogicalIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootLogicalIdentity& instance, string& errorMessage);

int Boot_OpenDRIM_BootLogicalIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootLogicalIdentity& instance, string& errorMessage);

int Boot_OpenDRIM_BootLogicalIdentity_associatorSystemElementToSameElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SystemElement_instance, const char** properties, vector<Instance>& SameElement_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootLogicalIdentity_associatorSameElementToSystemElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SameElement_instance, const char** properties, vector<Instance>& SystemElement_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootLogicalIdentity_referenceSystemElementToSameElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SystemElement_instance, const vector<Instance>& SameElement_instances, vector<OpenDRIM_BootLogicalIdentity>& OpenDRIM_BootLogicalIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootLogicalIdentity_referenceSameElementToSystemElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SameElement_instance, const vector<Instance>& SystemElement_instances, vector<OpenDRIM_BootLogicalIdentity>& OpenDRIM_BootLogicalIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootLogicalIdentity_populate(OpenDRIM_BootLogicalIdentity& instance, string& errorMessage);

#endif /*OPENDRIM_BOOTLOGICALIDENTITYACCESS_H_*/
