#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Detective Grimoire
# send your bug reports to contact@dotslashplay.it
###

script_version=20230220.4

GAME_ID='detective-grimoire'
GAME_NAME='Detective Grimoire'

ARCHIVE_BASE_0='DetectiveGrimoire1423507440.tar.gz'
ARCHIVE_BASE_0_MD5='729f52439a86c52ef9fe9e2d3dceeb4a'
ARCHIVE_BASE_0_SIZE='170000'
ARCHIVE_BASE_0_VERSION='1.2.0-humble150209'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/detective-grimoire'

CONTENT_PATH_DEFAULT='.'
CONTENT_LIBS_BIN_FILES='
preload.c
libpreload.so'
CONTENT_GAME_BIN_FILES='
bin
runtimes'
CONTENT_GAME_DATA_FILES='
.appdata
share'
CONTENT_DOC_DATA_FILES='
*.txt'

USER_PERSISTENT_DIRECTORIES='
.adobe
.appdata
.macromedia'

APP_MAIN_EXE='bin/DetectiveGrimoire'
for res in 16 29 32 36 40 48 50 57 58 72 76 80 96 100 114 120 128 144 152 512 1024; do
	APP_MAIN_ICONS_LIST="$APP_MAIN_ICONS_LIST APP_MAIN_ICON_${res}"
	export APP_MAIN_ICON_${res}="share/icons/icon${res}.png"
done

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libdl.so.2
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libglib-2.0.so.0
libgmodule-2.0.so.0
libgobject-2.0.so.0
libgthread-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libnspr4.so
libnss3.so
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpthread.so.0
librt.so.1
libsmime3.so
libssl3.so
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libxml2.so.2
libXrender.so.1
libz.so.1'

# Use fake $HOME to fetch/store Adobe Air settings

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Use fake $HOME to fetch/store Adobe Air settings
export HOME="$USER_PERSISTENT_PATH"'

# Load common functions

target_version='2.21'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Load shipped preload shim

APP_MAIN_PRERUN="$APP_MAIN_PRERUN

# Load shipped preload shim
export LD_PRELOAD='$(path_libraries)/libpreload.so'"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	set_standard_permissions .
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
