#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Caesar 3
###

script_version=20240711.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='caesar-3'
GAME_NAME='Cæsar Ⅲ'

# Archives

## Base game installer

ARCHIVE_BASE_0_NAME='setup_caesar3_2.0.0.9.exe'
ARCHIVE_BASE_0_MD5='2ee16fab54493e1c2a69122fd2e56635'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='550000'
ARCHIVE_BASE_0_VERSION='1.1-gog2.0.0.9'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/caesar_3'

## Julius archives

ARCHIVE_REQUIRED_JULIUS_5_NAME='julius-1.7.0-linux-x86_64.zip'
ARCHIVE_REQUIRED_JULIUS_5_MD5='3678ed789e4fd822076fbc39b87268cb'
ARCHIVE_REQUIRED_JULIUS_5_SIZE='2400'
ARCHIVE_REQUIRED_JULIUS_5_URL='https://github.com/bvschaik/julius/releases/tag/v1.7.0'

ARCHIVE_REQUIRED_JULIUS_4_NAME='julius-1.6.0-linux-x86_64.zip'
ARCHIVE_REQUIRED_JULIUS_4_MD5='2ea82121f9752c0c7624b3a70bbf5bac'
ARCHIVE_REQUIRED_JULIUS_4_SIZE='2400'
ARCHIVE_REQUIRED_JULIUS_4_URL='https://github.com/bvschaik/julius/releases/tag/v1.6.0'

ARCHIVE_REQUIRED_JULIUS_3_NAME='julius-1.5.1-linux-x86_64.zip'
ARCHIVE_REQUIRED_JULIUS_3_MD5='ff01fea442f0d68de5f705411be84ae7'
ARCHIVE_REQUIRED_JULIUS_3_SIZE='2300'
ARCHIVE_REQUIRED_JULIUS_3_URL='https://github.com/bvschaik/julius/releases/tag/v1.5.1'

ARCHIVE_REQUIRED_JULIUS_2_NAME='julius-1.5.0-linux-x86_64.zip'
ARCHIVE_REQUIRED_JULIUS_2_MD5='57392aab52e820149a0416c31f02cd17'
ARCHIVE_REQUIRED_JULIUS_2_SIZE='2300'
ARCHIVE_REQUIRED_JULIUS_2_URL='https://github.com/bvschaik/julius/releases/tag/v1.5.0'

ARCHIVE_REQUIRED_JULIUS_1_NAME='julius-1.4.1-linux-x86_64.zip'
ARCHIVE_REQUIRED_JULIUS_1_MD5='6f09868205f502b8c006d88702d6455d'
ARCHIVE_REQUIRED_JULIUS_1_SIZE='2300'
ARCHIVE_REQUIRED_JULIUS_1_URL='https://github.com/bvschaik/julius/releases/tag/v1.4.1'

ARCHIVE_REQUIRED_JULIUS_0_NAME='julius-1.4.0-linux-x86_64.zip'
ARCHIVE_REQUIRED_JULIUS_0_MD5='a686cddb59e3b89d22baf3b73fdce9ef'
ARCHIVE_REQUIRED_JULIUS_0_SIZE='2200'
ARCHIVE_REQUIRED_JULIUS_0_URL='https://github.com/bvschaik/julius/releases/tag/v1.4.0'


CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_DATA_FILES='
555
smk
wavs
mission1.pak
c3_model.txt
*.555
*.emp
*.eng
*.map
*.sg2'
CONTENT_GAME_BIN_PATH='.'
CONTENT_GAME_BIN_FILES='
julius'
CONTENT_DOC_DATA_FILES='
readme.txt
*.pdf'

USER_PERSISTENT_FILES='
c3_model.txt
status.txt
*.ini
*.sav'

APP_MAIN_EXE='julius'
APP_MAIN_ICON='c3.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libm.so.6
libSDL2-2.0.so.0
libSDL2_mixer-2.0.so.0'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Check for the presence of the archive providing the Julius engine
# cf. https://github.com/bvschaik/julius

archive_initialize_required 'ARCHIVE_JULIUS' \
	'ARCHIVE_REQUIRED_JULIUS_5' \
	'ARCHIVE_REQUIRED_JULIUS_4' \
	'ARCHIVE_REQUIRED_JULIUS_3' \
	'ARCHIVE_REQUIRED_JULIUS_2' \
	'ARCHIVE_REQUIRED_JULIUS_1' \
	'ARCHIVE_REQUIRED_JULIUS_0'

# Extract game data

archive_extraction_default
archive_extraction 'ARCHIVE_JULIUS'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path 'GAME_BIN')"

	## Enforce minimal permissions on the Julius binary.
	chmod 755 "$(application_exe 'APP_MAIN')"
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
