/** BEGIN COPYRIGHT BLOCK
 * This Program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; version 2 of the License.
 * 
 * This Program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this Program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * In addition, as a special exception, Red Hat, Inc. gives You the additional
 * right to link the code of this Program with code not covered under the GNU
 * General Public License ("Non-GPL Code") and to distribute linked combinations
 * including the two, subject to the limitations in this paragraph. Non-GPL Code
 * permitted under this exception must only link to the code of this Program
 * through those well defined interfaces identified in the file named EXCEPTION
 * found in the source code files (the "Approved Interfaces"). The files of
 * Non-GPL Code may instantiate templates or use macros or inline functions from
 * the Approved Interfaces without causing the resulting work to be covered by
 * the GNU General Public License. Only Red Hat, Inc. may make changes or
 * additions to the list of Approved Interfaces. You must obey the GNU General
 * Public License in all respects for all of the Program code and other code used
 * in conjunction with the Program except the Non-GPL Code covered by this
 * exception. If you modify this file, you may extend this exception to your
 * version of the file, but you are not obligated to do so. If you do not wish to
 * provide this exception without modification, you must delete this exception
 * statement from your version and license this file solely under the GPL without
 * exception. 
 * 
 * 
 * Copyright (C) 2001 Sun Microsystems, Inc. Used by permission.
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 * END COPYRIGHT BLOCK **/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define BUCKET_MASK NUM_BUCKETS-1
typedef struct DATABIN {
  char*    pLibraryName;
  char**   pArrayOfLibraryStrings;
  unsigned numberOfStringsInLibrary;
  } DATABIN;

/* It is intended that this header file be generated by program dblink */
static char emptyString[] = "";

#define NUM_BUCKETS 32 /* must be a power of 2 */

/* strings in library libadmin */
static char* libadmin[] = {
  "",
  "  Help  ",
  "   OK   ",
  " Reset ",
  "  Done  ",
  " Cancel ",
  emptyString };

/* libraries in bucket for hashKey==0 */
static struct DATABIN bucket0[] = {
  {"libadmin",libadmin,5},
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==1 */
static struct DATABIN bucket1[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==2 */
static struct DATABIN bucket2[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==3 */
static struct DATABIN bucket3[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==4 */
static struct DATABIN bucket4[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==5 */
static struct DATABIN bucket5[] = {
  {emptyString,NULL,0} };

/* strings in library userforms */
static char* userforms[] = {
  "",
  "Error: could not open servers list file.<p>\n",
  "Error: could not open %s server list file.<p>\n",
  CAPBRAND " Server Account",
  "Server Account Management for %s",
  "Server Account Management",
  emptyString };

/* libraries in bucket for hashKey==6 */
static struct DATABIN bucket6[] = {
  {"userforms",userforms,5},
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==7 */
static struct DATABIN bucket7[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==8 */
static struct DATABIN bucket8[] = {
  {emptyString,NULL,0} };

/* strings in library libaccess */
static char* libaccess[] = {
  "",
  "basic-ncsa",
  "cannot open database %s",
  "basic-ncsa",
  "user %s password did not match database %s",
  "basic-ncsa",
  "cannot open connection to LDAP server on %s:%d",
  "basic-ncsa",
  "user %s password did not match LDAP on %s:%d",
  "acl-state",
  "missing realm",
  "Unable to allocate ACL List Hash\n",
  "ACLEvalBuildContext unable to PERM_MALLOC cache structure\n",
  "ACLEvalBuildContext unable to create hash table\n",
  "ACLEvalBuildContext unable to allocate ACE Entry\n",
  "ACLEvalBuildContext unable to allocate ACE entry\n",
  "ACLEvalBuildContext unable to allocate Boundary Entry\n",
  "ACLEvalBuildContext failed.\n",
  "ACL_EvalTestRights: an interim, absolute non-allow value was encountered. right=%s, value=%d\n",
  "LASDnsBuild unable to allocate hash table header\n",
  "LASDnsBuild unable to add key %s\n",
  "LASDnsBuild unable to add key %s\n",
  "LASDnsBuild unable to add key %s\n",
  "LASDnsBuild unable to add key %s\n",
  "LASDnsBuild unable to add key %s\n",
  "LAS DNS build received request for attribute %s\n",
  "LASDnsEval - illegal comparator %s\n",
  "LASDnsEval unable to allocate Context struct\n\n",
  "LASDnsEval unable to get session address %d\n",
  "LASDnsEval unable to get DNS - error=%s\n",
  "LAS Group Eval received request for attribute %s\n",
  "LASGroupEval - illegal comparator %s\n",
  "LASGroupEval - ran out of memory\n",
  "LASGroupEval unable to get session address %d\n",
  "LASGroupEval unable to get session address %d\n",
  "LASGroupEval - couldn't locate getter for auth-user\n",
  "LASGroupEval - Attribute getter for auth-user failed\n",
  "LASGroupEval - Attribute getter didn't set auth-user\n",
  "Check group membership of user \"%s\" for group \"%s\"\n",
  "LDAPU_SUCCESS for group \"%s\"\n",
  "LDAPU_FAILED for group \"%s\"\n",
  "LAS_EVAL_FALSE\n",
  "LAS_EVAL_TRUE\n",
  "LASIpTreeAlloc - no memory\n",
  "IP LAS unable to allocate tree node\n",
  "IP LAS unable to allocate tree node\n",
  "LAS IP build received request for attribute %s\n",
  "LASIpEval - illegal comparator %s\n",
  "LASIpEval unable to get session address - error=%s\n",
  "LASIpEval unable to allocate Context struct\n\n",
  "LASIpEval - reach 32 bits without conclusion value=%s",
  "LAS Program Eval received request for attribute %s\n",
  "LASProgramEval - illegal comparator %s\n",
  "LASProgram unable to get session address %d\n",
  "bin",
  "LASProgramEval: request not of type admin or bin, passing.\n",
  "LASProgramEval: check if program %s matches pattern %s.\n",
  "LASProgramEval: Invalid wildcard expression %s.\n",
  "LAS_EVAL_FALSE\n",
  "LAS_EVAL_TRUE\n",
  "Unexpected attribute in dayOfWeek - %s\n",
  "Illegal comparator for dayOfWeek - %s\n",
  "Unexpected attribute in timeOfDay - %s\n",
  "LAS User Eval received request for attribute %s\n",
  "LASUserEval - illegal comparator %s\n",
  "LASUserEval - ran out of memory\n",
  "LASUserEval unable to get session address %d\n",
  "LASUserEval unable to get session address %d\n",
  "LASGroupEval - couldn't locate getter for auth-user\n",
  "LASGroupEval - Attribute getter for auth-user failed\n",
  "LASGroupEval - Attribute getter didn't set auth-user\n",
  "Check if uid == user (i.e. check \"%s\" == \"%s)\"\n",
  "SUCCESS for user \"%s\"\n",
  "FAILED for user \"%s\"\n",
  "LAS_EVAL_FALSE\n",
  "LAS_EVAL_TRUE\n",
  "",
  "LASProgram unable to get request address - error=%s",
  "LASProgram rejecting request for program %s from pattern %s",
  "ACL_CacheFlush: unable to parse file \"%s\"\n",
  "ACL_CacheFlush: unable to concatenate ACL list \"%s\"\n",
  "ACL_CacheFlush: unable to open and process the magnus file \"%s\"\n",
  "Illegal comparator for timeOfDay - %s\n",
  "ACL_EvalBuildContext unable to create hash table\n",
  "ACL_EvalBuildContext unable to PERM_CALLOC cache structure\n",
  "ACL_EvalBuildContext unable to allocate ACE entry\n",
  "ACL_EvalBuildContext unable to allocate auth pointer array\n",
  "ACL_EvalBuildContext unable to allocate auth plist\n",
  "ACL_EvalTestRights: an interim, absolute non-allow value was encountered. right=%s, value=%s\n",
  "ACL_INTEvalTestRights: call to ACL_EvalBuildContext returned failure status\n",
  "ACL_ModuleRegister: module name is missing\n",
  "ACL_ModuleRegister: call to module init function returned a failed status\n",
  "ACL_GetAttribute: couldn't determine method for %s\n",
  "ACL_GetAttribute: couldn't locate getter for %s",
  "ACL_GetAttribute: attr getter failed to get %s",
  "ACL_GetAttribute: attr getter failed to get %s",
  "ACL_GetAttribute: All attribute getters declined for attr %s",
  "ACL_DatabaseRegister: dbtype for database \"%s\" is not defined yet!",
  "ACL_DatabaseRegister: database name is missing",
  "Error reading the DB Map File: %s. Reason: %s",
  "URL is missing for database %s",
  "Invalid property value pair for database %s",
  "\"default\" database must be an LDAP database",
  "Multiple \"default\" databases are being registered",
  "\"default\" LDAP database must be registered",
  "LASGroupEval unable to get database name - error= %s",
  "received invalid program expression %s",
  "parse_ldap_url: database url is missing",
  "parse_ldap_url: database name is missing",
  "parse_ldap_url: error in parsing ldap url. Reason: %s",
  "ldap password check: unable to get database name - error=%s",
  "ldap password check: unable to get parsed database %s",
  "ldap password check: couldn't initialize connection to LDAP. Reason: %s",
  "ldap password check: LDAP error: \"%s\"",
  "get_user_ismember_ldap unable to get database name - error=%s",
  "get_user_ismember_ldap unable to get parsed database %s",
  "ldap password check: couldn't initialize connection to LDAP. Reason: %s",
  "get_user_ismember_ldap: group %s does not exist",
  "get_user_ismember_ldap: LDAP error: \"%s\"",
  "ACL_LDAPDatabaseHandle: %s is not a registered database",
  "ACL_LDAPDatabaseHandle: %s is not an LDAP database",
  "ACL_LDAPDatabaseHandle: out of memory",
  "ACL_LDAPDatabaseHandle: couldn't initialize connection to LDAP. Reason: %s",
  "ACL_LDAPDatabaseHandle: couldn't bind to LDAP server. Reason: %s",
  "insufficient dynamic memory",
  "error opening file, %s: %s",
  "duplicate definition of %s",
  "file %s, line %s: duplicate definition of %s",
  "file %s, line %s: syntax error",
  "file %s, line %s: %s is undefined",
  "in acl %s, %s %s is undefined",
  "database %s: error accessing %s",
  "%s",
  "file %s, line %s: invalid syntax",
  "file %s, line %s: syntax error at \"%s\"",
  "realm %s is not defined",
  "error code = %d",
  "internal ACL error",
  "invalid argument",
  "ACL_DatabaseRegister: dbtype for database \"%s\" is not defined yet!",
  "couldn't determine dbtype from: %s",
  "Failed to register database %s",
  "ACL call returned failed status",
  "file %s: ACL IO error - %s",
  "acl_user_exists: out of memory",
  "acl_user_exists: user doesn't exist anymore",
  "acl_user_exists: plist error",
  "LASDnsBuild invalid attribute pattern\n",
  emptyString };

/* libraries in bucket for hashKey==9 */
static struct DATABIN bucket9[] = {
  {"libaccess",libaccess,146},
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==10 */
static struct DATABIN bucket10[] = {
  {emptyString,NULL,0} };

/* strings in library frame */
static char* frame[] = {
  "",
  "<TITLE>Not Found</TITLE><H1>Not Found</H1> The requested object does not exist on this server. The link you followed is either outdated, inaccurate, or the server has been instructed not to let you have it. ",
  "Please inform the site administrator of the <A HREF=\"%s\">referring page</A>.",
  "Your browser sent a request that this proxy could not understand.",
  "Proper authorization is required for the administration of this proxy.\nEither your browser does not perform authorization, or your authorization\nhas failed.",
  "Username authentication is required for using this proxy.\nEither your browser does not perform proxy authorization, or your\nauthorization has failed.",
  "The proxy's access control configuration denies access to\nthe requested object through this proxy.",
  "The proxy has encountered an internal error which prevents it from\nfulfilling your request. The most likely cause is a misconfiguration.\nPlease ask the administrator to look for messages in the proxy's error log.",
  "This proxy server does not implement the requested method.",
  "An error has occurred on the proxy server.",
  "Your browser sent a query this server could not understand.",
  "Proper authorization is required for this area. Either your browser does not perform authorization, or your authorization has failed.",
  "Your client is not allowed to access the requested object.",
  "This server has encountered an internal error which prevents it from fulfilling your request. The most likely cause is a misconfiguration. Please ask the administrator to look for messages in the server's error log.",
  "This server does not implement the requested method.",
  "An error has occurred.",
  "Your browser sent a message this server could not understand.",
  "<HTML><HEAD><TITLE>%s</TITLE></HEAD><BODY><H1>%s</H1>\nThis document has moved to a new <a href=\"%s\">location</a>. Please update your documents and hotlists accordingly.</BODY></HTML>",
  "<HTML><HEAD><TITLE>%s</TITLE></HEAD>\n<BODY><H1>%s</H1>\n%s\n</BODY></HTML>",
  "process-uri-objects",
  "cannot find template %s",
  "process-uri-objects",
  "no partial path after object processing",
  "find-service",
  "invalid shexp %s",
  "find-service",
  "invalid shexp %s",
  "handle-processed",
  "no way to service request for %s",
  "finish-socks-request",
  "close failed (%s), csd=%d",
  "This beta software has expired.\n",
  "mr_accept(%d)",
  "Error issuing read on accept socket",
  "acb_accept_connection(%d)",
  "Error getting accept socket (%d)",
  "Error in accept! (%d, %s)",
  "Error creating new accept request",
  "accepted connection: %d (NSPR %d)",
  "Error creating new session structure",
  "accel_read_request()",
  "Error allocating request read buffer",
  "Error issuing async read request",
  "acb_read_request(%d, bytes %d)",
  "acb_read_req(1 session = %d)",
  "Error reading request (%d, %s)",
  "Client aborted connection",
  "Error reading request",
  "Error creating new request",
  "error occurred, closing %d, io was for %d",
  "accel_async_scan_headers()",
  "out of memory: accel_async_scan_headers",
  "out of memory: accel_async_scan_headers",
  "Error during async read (%d, %s)",
  "scan-headers reports: line too long",
  "scan-headers reports: too many headers",
  "Error reading headers",
  "scan-headers reports: header missing terminator (an empty line)",
  "scan-headers reports: header was empty",
  "name without value: got line \"%s\"",
  "accel_send_plain_file()",
  "accel_send_plain_file() - found request %d",
  "Parse headers lost the URI!",
  "accel_send_plain_file() - found uri %s",
  "accel_send_plain_file() - found in cache?",
  "malloc died!",
  "Error writing back file\n",
  "acb_send_plain_file(%d)",
  "Error writing in acb_send_plain_file (%d, %s)",
  "acb_close_connection(%d)",
  "Errored IO in acb_close_connection (%d, %s)",
  "Unable to close socket %d",
  "accel-cache-insert: Error allocating entry",
  "cache-init: server cache disabled",
  "accel_file_cache: Error initializing file cache",
  "accel_file_cache: Error creating cache",
  "accel_file_cache_init: CacheHashSize < %d, using %d",
  "accel_file_cache_init: CacheHashSize > %d, using %d",
  "accel_file_cache_init: MaxNumberOfCachedFiles < %d, using %d",
  "accel_file_cache_init: MaxNumberOfCachedFiles > %d, using %d",
  "accel_file_cache_init: MaxNumberOfOpenCachedFiles < %d, using %d",
  "accel_file_cache_init: MaxNumberOfOpenCachedFiles > %d, using %d",
  "accel_file_cache: Error initializing file cache",
  "file-cache: enabled = %s ",
  "on",
  "off",
  "file-cache: MaxNumberOfCachedFiles %d (0x%x)",
  "file-cache: CacheHashSize %d (0x%x)",
  "file-cache: MaxNumberOfOpenCachedFiles %d (0x%x)",
  "accel-cache-insert: Error allocating entry",
  "file-cache-cleanup: munmap failed (%s)",
  "file-cache-cleanup: found mmapped file \non system without mmap",
  "file_cache_init: MaxTotalCachedFileSize < %d, using %d",
  "file_cache_init: MaxTotalCachedFileSize > %d, using %d",
  "file cache using mmap flags 0x%x",
  "file cache using mmap prots 0x%x",
  "file-cache-init: could not create lock",
  "file-cache: unable to create temporary directory %s.\n",
  "file-cache: unable to create temporary directory %s.\n",
  "file-cache: GetTempPath() Cannot find temp directory to store file!",
  "file-cache-init: set max cached file size to %d",
  "file-cache-init: could not create lock",
  "file_cache_destroy()",
  "file-cache: Unable to get temp file name. Error %s",
  "file-cache: Unable to get temp file name. Error %s",
  "file-cache-insert: Error allocating entry",
  "file-cache-create: Error opening file %s (%s)",
  "file-cache-create: Error stat()ing file %s (%s)",
  "file-cache-create: Error mmap()ing file %s (%s)",
  "file-cache-create: malloc failure",
  "file-cache-create: error case failed to munmap(%d, %d) (%s)",
  "file-cache-valid: cannot stat %s",
  "dir change: invalidating %s (%d)",
  "file-cache:  asynchronous file change notification failed.",
  "dir change: offset %d, action %d, len %d, name %s",
  "unable to check async file status",
  "ReadDirectoryChangesW failure- unable to continue watching %s. Error is %s",
  "file-cache-add-watch failure- unable to open directory %s.  Error %s",
  "ReadDirectoryChangesW failure- unable to start watching %s.  Error %s",
  "func_exec",
  "no handler function given for directive",
  "func_exec",
  "cannot find function named %s",
  "handle-request",
  "method without URI",
  "http-parse-request",
  "while scanning HTTP headers, %s",
  "handle-request",
  "read from %s failed, error is %s",
  "handle-request",
  "request too long",
  "start-http-response",
  "write failed (%s)",
  "start-http-response",
  "write failed (%s)",
  "http-status",
  "%d is not a valid HTTP status code",
  "finish-request",
  "close failed (%s)",
  "Unable to close socket for writing",
  "os has %d objects",
  "obj %d has no hash table at %d",
  "obj %d has no param",
  "obj %d name %s  value %s",
  ".....directives %d.......",
  ".....directive %d",
  ".......instance %d",
  "...........param name %s value %s",
  "ClearConfigurationParameters:RegCreateKey %s",
  "ClearConfigurationParameters:RegEnumKey %s failed",
  "obj.conf line %d: error in filter file \"%s\" at line %d: %s",
  "obj.conf line %d: error in filter file \"%s\" at line %d: %s",
  "Unable to allocate Subject property list.\n",
  "Unable to set session ptr in Subject property list - error=%d\n",
  "Unable to set request ptr in Subject property list - error=%d\n",
  "file-cache-valid: cannot stat %s",
  "file-cache-create: Error stat()ing file %s (%s)",
  emptyString };

/* libraries in bucket for hashKey==11 */
static struct DATABIN bucket11[] = {
  {"frame",frame,156},
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==12 */
static struct DATABIN bucket12[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==13 */
static struct DATABIN bucket13[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==14 */
static struct DATABIN bucket14[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==15 */
static struct DATABIN bucket15[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==16 */
static struct DATABIN bucket16[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==17 */
static struct DATABIN bucket17[] = {
  {emptyString,NULL,0} };

/* strings in library admserv */
static char* admserv[] = {
  "",
  "Unauthorized host",
  "Invalid URL",
  "no filename extension",
  "unrecognized type",
  "<title>Internal Error</title>\n<h1>Internal Error</h1>\nThe administration server was unable to fulfill your request.<p>\n",
  "Reason:",
  emptyString };

/* strings in library libir */
static char* libir[] = {
  "",
  "An I/O error occurred before all form data could be read.",
  emptyString };

/* libraries in bucket for hashKey==18 */
static struct DATABIN bucket18[] = {
  {"admserv",admserv,6},
  {"libir",libir,1},
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==19 */
static struct DATABIN bucket19[] = {
  {emptyString,NULL,0} };

/* strings in library httpdaemon */
static char* httpdaemon[] = {
  "",
  "Error in ConvertThreadToFiber",
  "Error in ConvertThreadToFiber",
  "Error in md_start_system",
  "Error in CreateFiber - idlefiber",
  "Error in GetQueuedCompletionStatus",
  "Error creating completion port",
  "Could not SetHandleNonInheritable (%s)",
  "Error accept/read new conn",
  "Error in Respond()",
  "Error in RespondCompleted()",
  "daemon: unable to fork new process (%s)\n",
  "daemon: setsid failed (%s)\n",
  "daemon: can't log pid to %s (%s)\n",
  "warning: could not set group id to %d (%s)\n",
  "warning: could not set user id to %d (%s)\n",
  "warning: daemon is running as super-user\n",
  "could not determine current user name\n",
  "error: chroot to %s failed (%s)\n",
  "WARNING! " CAPBRAND " executable and library have different versions.\n",
  "startup: listening to %s://%s, port %d as %s\n",
  "startup: listening to %s://%s, port %d as %s\n",
  "seminit failed (%s)\n",
  "Using single threaded accepts.",
  "Using multi threaded accepts.",
  "Using partial single threaded accepts.",
  "This machine has %d processors.",
  "Error calling thr_seconcurrency(%d)- (%s)",
  "Set conncurrency to %d.",
  "can't fork new process (%s)",
  "This beta software has expired.\n",
  "can't create IPC pipe (%s)",
  "write to wakeup pipe failed (%s)",
  "select thread miss",
  "startup failure: could not bind to port %d (%s)\n",
  "startup failure: could not bind to port %d, IP address %s (%s)\n",
  emptyString };

/* libraries in bucket for hashKey==20 */
static struct DATABIN bucket20[] = {
  {"httpdaemon",httpdaemon,35},
  {emptyString,NULL,0} };

/* strings in library dsgw */
static char* dsgw[] = {
  "",
  "Unknown HTTP request method",
  "Invalid or incomplete HTML form data",
  "Out of memory",
  "Required query/form input is missing",
  "Illegal character in file path",
  "Bad or missing configuration file",
  "Unable to initialize LDAP",
  "An error occurred while contacting the LDAP server",
  "Unknown search object type",
  "Unknown attribute label",
  "Unknown match prompt",
  "No search filters for object type",
  "Unable to open HTML template file",
  "Unknown search mode - use \"smart\", \"complex\", \"pattern\", or \"auth\"",
  "Distinguished Name missing in URL",
  "Unknown scope in URL (should be base, sub, or one)",
  "Unrecognized URL or unknown error",
  "Bad URL format",
  "Internal error",
  "Unable to write template index file",
  "Unable to open template index file",
  "Unable to read directory",
  "LDAP SSL initialization failed (check the security path)",
  "For the Users and Groups forms to work over SSL with the Administration Server, you must at least temporarily activate SSL through the <B>Admin Preferences|Encryption On/Off</B> form",
  "Authentication credentials not found in authentication database",
  "Error retrieving data from the authentication database",
  "Your authentication credentials have expired",
  "Unable to create authentication credentials",
  "No distinguished name was provided when retrieving credentials",
  "Cannot open authentication database",
  "Could not append data to the authentication database",
  "No Directory Manager is defined",
  "No search string was provided.  Please try again",
  "Too many arguments on one line in the config. file",
  "Failed to initialize Windows Sockets",
  "Authentication credentials could not be obtained from the Administration Server",
  "Distinguished Name missing in ldapdb:// URL",
  "Unrecognized URL or unknown error",
  "Bad URL format",
  "An error occurred while initializing the local LDAP database",
  "Unknown directory service type - use \"local\" or \"remote\"",
  "An error occurred while reading the db configuration file",
  "NSHOME/userdb path was NULL",
  "The directory service configuration could not be updated.",
  "The entry could not be read from the directory.",
  "The LDAP database could not be erased.",
  "You may not change entries besides your own.",
  "Problem",
  "Authentication Problem",
  ".\n<P>You must re-authenticate before continuing.\n",
  ".\n<P>You must re-authenticate before continuing.\n",
  "unknown error",
  "The operation was successful.",
  "An internal error occurred in the server.  This usually\nindicates a serious malfunction in the server and should be\nbrought to the attention of your server administrator.",
  "The server could not understand the request which was sent to\nit by the gateway.",
  "A time limit was exceeded in responding to your request.  If\nyou are searching for entries, you may achieve better results\nif you are more specific in your search.",
  "A size limit was exceeded in responding to your request.  If\nyou are searching for entries, you may achieve better results\nif you are more specific in your search, because too many entries\nmatched your search criteria.",
  "The gateway attempted to authenticate to the server using\na method the server does not understand.",
  "The gateway attempted to authenticate to the server using an\nauthentication method which the server does not support. ",
  "Your request could not be fulfilled, probably because the server\nthat was contacted does not contain the data you are looking\nfor.  It is possible that a referral to another server was\nreturned but could not be followed.  If you were trying to make\nchanges to the directory, it may be that the server that holds\nthe master copy of the data is not available.",
  "Your request exceeded an administrative limit in the server.",
  "A critical extension that the gateway requested is not available in this server.",
  "The server was unable to process the request, because the\nrequest referred to an attribute which does not exist in the\nentry.",
  "The server was unable to fulfill your request, because the\nrequest violates a database constraint.",
  "The server could not add a value to the entry, because that\nvalue is already contained in the entry.",
  "The server could not locate the entry.  If adding a new entry,\nbe sure that the parent of the entry you are trying to add exists.\nIf you received this error while searching or viewing an entry, it indicates that the\nentry which was being searched for does not exist.",
  "A distinguished name was not in the proper format. ",
  "The entry you attempted to authenticate as does not have a\npassword set, or is missing other required authentication\ncredentials.  You cannot authenticate as that entry until the\nappropriate attributes have been added by the directory manager. ",
  "The password (or other authentication credentials) you supplied\nis incorrect. If you just changed your password, you might try exiting your browser and connecting again.",
  "You do not have sufficient privileges to perform the operation. ",
  "The server is too busy to service your request.  Try again\nin a few minutes.",
  "The LDAP server could not be contacted.",
  "The server was unwilliing to process your request.  Usually,\nthis indicates that serving your request would put a heavy load\non the server.  It may also indicate that the server is not\nconfigured to process your request.  If searching, you may wish\nto limit the scope of your search.",
  "The directory server could not honor your request because it\nviolates the schema requirements.  Typically, this means that you\nhave not provided a value for a required field.  It could also mean\nthat the schema in the directory server needs to be updated.",
  "The directory server will not allow you to delete or rename\nan entry if that entry has children.  If you wish to do this, you\nmust first delete all the child entries.",
  "The server was unable to add a new entry, or rename an existing\nentry, because an entry by that name already exists.",
  "Your request would affect several directory servers.",
  "The directory server could not be contacted.  Contact your\ndirectory server administrator for assistance.",
  "An error occured while sending data to the server.",
  "An error occured while reading data from the server.",
  "The server did not respond to the request. \nThe request timed out.",
  "The server does not support the authentication method used\nby the gateway.",
  "The search filter constructed by the gateway was in error.",
  "The operation was cancelled at your request.",
  "An internal error occurred in the library - a parameter was\nincorrect.",
  "A connection to the directory server could not be opened. Contact your\ndirectory server administrator for assistance.",
  "An unknown error was encountered.",
  "Entry Already Exists",
  "An entry named ",
  "onMouseOver=\"window.status='Click here to view this entry'; return true\"",
  " already exists.<P>Please choose another name and/or location.\n<P>\n",
  "Parent entry does not exist",
  "You cannot add an entry by the name:<P><B>%s</B>,<P>\nbecause the parent of that entry does not exist.<P>\nBefore you can add this entry, you must first add\n",
  "its parent.\n",
  "an entry named:<P><B>%s</B>.\n",
  "Warning:  no authentication (continuing)...\n",
  "%s Directory Entry",
  "<PRE>Entry DN: %s</PRE><P>\n",
  "Changes to <B>%s</B> have been saved.",
  "<B>%s</B> has been added.",
  "<B>%s</B> has been deleted.",
  "Renamed <B>%s</B> to <B>%s</B>.",
  "<P><B>Note:</B>  because you %s the entry you were \nauthenticated as, it was necessary to discard your \nauthentication credentials. You will need to authenticate \nagain to make additional changes.\n",
  "deleted",
  "renamed",
  "changed the password of",
  "Attribute %s was changed<BR>\n",
  "	NOT ASCII (%ld bytes)\n",
  "No values were entered.  Please try again.\n",
  "No changes were made.\n",
  "<P>Sending %s to the directory server...\n",
  "information",
  "changes",
  "<P>Successfully added entry.\n",
  "<P>Successfully edited entry.  Your changes have been saved.\n",
  "<P>Successfully deleted entry.\n",
  "<PRE>The new name for the entry is: %s\n</PRE><HR>\n",
  "<P>Successfully renamed entry.\n",
  "You must provide the old password.",
  "You must provide a new password.  Please try again",
  "The new and confirming passwords do not match.  Please try again",
  "<BR>The %s <B>%s</B> is already in use. Please choose a different one.<BR>\n",
  "missing form data element \"%.100s\"",
  "Initializing config info",
  "Cannot open file.",
  "Malformed dbconf file.",
  "Missing property name in dbconf file.",
  "Out of memory.",
  "Missing directive in dbconf file.",
  "Cannot open config file \"%s\"",
  "Missing argument for \"authlifetime\" directive\n",
  "Missing argument for \"dirmgr\" directive\n",
  "Missing argument for \"baseurl\" directive\n",
  "Bad URL provided for \"baseurl\" directive - the base DN is missing\n",
  "parsing baseurl directive",
  "Bad URL provided for \"baseurl\" directive - not an \"ldap://\" URL\n",
  "\"ldaps://\" URLs are not yet supported\n",
  "Missing arguments for \"template\" directive\n",
  "Missing argument for \"sslrequired\" directive\n",
  "Unknown argument to \"sslrequired\" directive (should be \"never\", \"whenauthenticated\", \"always\")\n",
  "Missing argument for \"securitypath\" directive\n",
  "Missing argument for \"location-suffix\" directive\n",
  "Three arguments are required for the \"location\" directive\n",
  "At least two arguments are required for the \"newtype\" directive\n",
  "Unknown location in \"newtype\" directive\n",
  "Three or four arguments are required for the \"tmplset\" directive\n",
  "Four arguments are required for the \"attrvset\" directive\n",
  "Missing argument for \"charset\" directive\n",
  "Missing argument for \"ClientLanguage\" directive\n",
  "Missing argument for \"AdminLanguage\" directive\n",
  "Missing argument for \"DefaultLanguage\" directive\n",
  "Missing filename for \"include\" directive\n",
  "Unknown directive in config file\n",
  "<= erase_db could not open lcache.conf file \"%s\"\n",
  "<FONT SIZE=\"+1\">\n<P>The database has been deleted. Creating new database... \n</FONT>\n ",
  "<FONT SIZE=\"+1\">\n<P>The database could not be deleted \n</FONT>\n ",
  "<= app_suffix could not open ldif file \"%s\"\n",
  "<= app_suffix could not open tmp file \"%s\"\n",
  "Unable to rename %s to %s",
  "null pointer returned by dbconf_read_default_dbinfo().",
  "Bad \"ldapdb\" URL - the base DN is missing\n",
  "Bad \"ldapdb\" URL\n",
  "Bad URL provided for \"baseurl\" directive - the base DN is missing\n",
  "parsing baseurl directive",
  "Bad URL provided for \"baseurl\" directive - not an \"ldap:// or ldapdb://\" URL\n",
  "\"ldaps://\" URLs are not yet supported\n",
  "No value given for binddn",
  "No value given for bindpw",
  "There is no default directory service defined in the dbswitch.conf file",
  "Cannot open config file \"%s\" for writing",
  "Unable to rename %s to %s",
  "config file %s: ",
  "config file %s: line %d: ",
  "max %d",
  " OK ",
  "Close Window",
  "Go Back",
  "{crypt}LOCKED [%s GMT]",
  "Return to Main",
  "Return to Main",
  "  Help  ",
  "Help",
  " Help ",
  "Help is not yet available.",
  "Help",
  "Close Window",
  "Close Window",
  "missing ?template",
  "Authenticate...",
  "Discard authentication credentials (log out)?",
  "You did not supply a search string",
  "The first step in authenticating to the directory is identifying\nyourself.<br>Please type your name:",
  "Continue",
  "Continue",
  "Cancel",
  "Authenticate as directory manager\"> &nbsp(only available to Directory Administrators)\n",
  "Authenticate...",
  "Discard authentication credentials?",
  "Password for <b>%s</b>: ",
  "Continue",
  "Continue",
  "Cancel",
  "Authenticate (log in) to the directory",
  "You are about to authenticate to the directory as \n",
  "To complete the authentication process, you should\ntype your password.\n",
  "Before you can edit or add entries, you must authenticate\n(log in) to the directory.  This window will guide\nyou through the steps of the authentication\nprocess.\n",
  "From this screen you may authenticate, or log in, \nto the directory.  You will need to authenticate\nbefore you can modify directory entries.  If you\nattempt to modify an entry without authenticating,\nyou will be asked to log in.\n",
  "Authentication Status",
  "<form>\nYou are currently authenticated to the directory as ",
  ".\nIf you wish to discard your authentication credentials and log out of the directory, click on the button below.",
  "Discard Authentication Credentials (log out)",
  "Your authentication credentials for ",
  "have expired.\n<HR>\n",
  "Currently, you are not authenticated to the directory.<HR>\n",
  "missing \"%s=\"",
  "unknown \"%s=%s\"",
  "unknown option %s",
  "unknown syntax=%s\n",
  "** HTML type \"%s\" not supported **<BR>\n",
  "no entries",
  "1 entry",
  "%d entries",
  "where the ",
  "Edit",
  "Save Changes",
  "modify",
  "add",
  "Delete",
  "Delete this entry?",
  "Rename",
  "Enter a new name for this entry:",
  "Edit As",
  "missing %s=",
  "Close Window",
  "Edit...",
  "missing \"%s=\"\n",
  "unknown set \"%s\"\n",
  "unknown syntax \"%s\"\n",
  "Re-Authenticate",
  "Close Window",
  "Do you really want to ",
  "?",
  "   OK   ",
  "   OK   ",
  " Reset ",
  "  Done  ",
  " Cancel ",
  "found another IF (nested IFs are not supported)",
  "found ELSE but didn't see an IF",
  "found ELSE after ELSE (expecting ENDIF)",
  "found ELIF but didn't see an IF",
  "found ELIF after ELSE (expecting ENDIF)",
  "found ENDIF but didn't see an IF",
  "<BR><B>template error:</B> %s<BR>\n",
  "ldap_init/lcache_init attempted before config file read",
  "not running under the administration server",
  "Could not initialize permissions",
  "Could not map username to a DN (error from admin server)",
  "Could not get current username",
  "Could not get current user password",
  "Error: %s",
  "Note: there is no display template for this type of entry available, so it is\ndisplayed below using a default method.",
  "Invalid user id or NULL LDAP handle",
  "no match for user id",
  "more than one match for user id",
  "the entire directory",
  "Two arguments are required for the \"includeset\" directive\n",
  "An error occurred while trying to access the database",
  "All references to entry could not be changed",
  "<P>Successfully removed all references to deleted entry.",
  "<P>Successfully updated all references to renamed entry.",
  "<P>Removing references to <B>%s</B>...",
  "<P>Updating references to <B>%s</B>...",
  "<P>removing %s from %s \n",
  "The directory server could not be contacted.  One common configuration error when using LDAP over SSL is that the certificate used by the directory server must be marked as trusted.  Contact your directory server administrator for further assistance.",
  "A connection to the directory server could not be opened.  One common configuration error when using LDAP over SSL is that the certificate used by the directory server must be marked as trusted.  Contact your directory server administrator for further assistance.",
  "Editing",
  "Adding",
  "Deleting",
  "Renaming",
  "Servers are not configured for CAL",
  "Cannot update config file \"%s\"\n",
  "Missing argument for \"locationurl\" directive\n",
  "Invalid location url\n",
  "<= app_suffix could not parse LDIF \"%s\"\n",
  emptyString };

/* libraries in bucket for hashKey==21 */
static struct DATABIN bucket21[] = {
  {"dsgw",dsgw,285},
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==22 */
static struct DATABIN bucket22[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==23 */
static struct DATABIN bucket23[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==24 */
static struct DATABIN bucket24[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==25 */
static struct DATABIN bucket25[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==26 */
static struct DATABIN bucket26[] = {
  {emptyString,NULL,0} };

/* strings in library base */
static char* base[] = {
  "",
  "insufficient memory to create hash table",
  "insufficient memory to create hash table",
  "cache_destroy: cache tables appear corrupt.",
  "unable to allocate hash entry",
  "cache_insert: unable to create cache entry",
  "HTTP/1.0 200 OK\nContent-type: text/html\n\n",
  "<H2>" CAPBRAND " cache status report</H2>\n",
  "No caches on system<P>",
  "<H2>%s cache</H2>\n",
  "Cache hit ratio: %d/%d (%f)</P>\n</P>\n",
  "Cache size: %d/%d</P>\n</P>\n",
  "Hash table size: %d</P>\n</P>\n",
  "mru       : %d</P>\nlru       : %d</P>\n",
  "<UL><TABLE BORDER=4> <TH>Bucket</TH> <TH>Address</TH> <TH>Key</TH> <TH>Access Count</TH> <TH>Delete</TH> <TH>Next</TH> <TH>LRU</TH> <TH>MRU</TH> <TH>Data</TH>\n",
  "munmap failed (%s)",
  "munmap failed (%s)",
  "close failed (%s)",
  "daemon: unable to fork new process (%s)\n",
  "daemon: setsid failed (%s)\n",
  "daemon: can't log pid to %s (%s)\n",
  "warning: could not set group id to %d (%s)\n",
  "warning: could not set user id to %d (%s)\n",
  "warning: daemon is running as super-user\n",
  "could not determine current user name\n",
  "error: chroot to %s failed (%s)\n",
  "",
  ", address %s",
  "warning: statistics disabled (%s)\n",
  "security handshake timed out for pid %d",
  "warning: statistics disabled (%s)\n",
  "secure handshake failed (code %d)\n",
  "accept failed (%s)",
  "warning: statistics disabled (%s)\n",
  "select thread miss",
  "keepalive worker awoken with no work to do",
  "could not create new thread: %d (%s)",
  "wait for sema succeeded, but nothing to dequeue",
  "queue-sema creation failure",
  "error getting processor info for processor %d",
  "Error binding to processor %d",
  "bound process %d to processor %d",
  CAPBRAND " server is not explicitly binding to any processors.",
  "cache monitor exited",
  "cache batch update daemon exited",
  "Using single threaded accepts.",
  "Using multi threaded accepts.",
  "Using partial single threaded accepts.",
  "This machine has %d processors.",
  "Error calling thr_seconcurrency(%d)- (%s)",
  "Set conncurrency to %d.",
  "WARNING! " CAPBRAND " executable and library have different versions.\n",
  "",
  "",
  "seminit failed (%s)\n",
  "This beta software has expired.\n",
  "Cache monitor respawned",
  "Cache batch update daemon respawned",
  "can't find empty statistics slot",
  "can't fork new process (%s)",
  "assert failed! %s\n",
  "mr_table_init()",
  "malloc failed",
  "malloc failed!",
  "mr_add_io(%d, type %d, file %d)",
  "mr_add_io - stage 1",
  "mr_add_io - stage 2",
  "mr_add_io found invalid IO type %d",
  "mr_add_io - adding timeout",
  "Out of memory!\n",
  "done with mr_add_io",
  "mr_del_io(%d, type %d, file %d)",
  "mr_del_io found invalid IO type %d",
  "mr_lookup_io(%d)",
  "mr_async_io(%d, %d bytes, file %d)",
  "malloc failure adding async IO",
  "Error adding async io!",
  "Cannot seek for read!",
  "read failure! (%d, %s)",
  "do_read read %d bytes for file %d",
  "Cannot seek for write!",
  "writev failure! (%d, %s)",
  "write failure! (%d, %s)",
  "do_write wrote %d bytes for file %d",
  "do_timeout(mrp %d)",
  "do_timeout: found IO (timer=%d, time=%d)",
  "error deleting io",
  "timeout callback failure for %d\n",
  "mr_get_event(%d) - outstanding io %d",
  "mr_get_event: Waiting for reads on FD:",
  "mr_get_event: Waiting for writes on FD:",
  "	%d",
  "	%d",
  "mr_get_event set no timeout",
  "mr_get_event set timeout to: %d.%d sec",
  "error in select (%d, %s)",
  "mr_get_event() - select found %d",
  "error looking up IO fd %d",
  "read failed for fd %d",
  "error deleting io",
  "callback failure for %d\n",
  "error looking up IO fd %d",
  "writing: header len %d, writelen %d, total %d",
  "write failed for fd %d",
  "error deleting io",
  "callback failure for %d\n",
  "Error creating dns cache",
  "dns_cache_init: hash_size <= 0, using %d",
  "dns_cache_init: cache-size <= %d, using %d",
  "dns_cache_init: cache-size is %d is too large, using %d.",
  "dns_cache_init: expire_time <= 0, using %d",
  "dns_cache_init: expire is %d is too large, using %d seconds.",
  "Error creating dns cache",
  "dns-cache-insert: Error allocating entry",
  "dns-cache-insert: malloc failure",
  "successful server startup",
  "%s B%s",
  CAPBRAND " executable and shared library have different versions",
  "   executable version is %s",
  "   shared library version is %s",
  "error reporting shutting down",
  "warning",
  "config",
  "security",
  "failure",
  "catastrophe",
  "info",
  "verbose",
  "event_handler:Failed to wait on events %s",
  "could not wait on resume event event  (%s)",
  "dlopen of %s failed (%s)",
  "dlopen of %s failed (%s)",
  "The server is terminating due to an error. Check the event viewer for the error message. SERVER EXITING!",
  "Terminating the server %s",
  "kill_server:cannot open server event %s",
  "kill_server:cannot set server event %s",
  "error: could not get socket (%s)\n",
  "error: could not set socket option (%s)\n",
  "Terminating Service:error: could not bind to address %s port %d (%s)\n",
  "Terminating Service:error: could not bind to port %d (%s)\n",
  "SetHandleNonInheritable: could not duplicate socket (%s)",
  "SetHandleNonInheritable: closing the original socket failed (%s)",
  "Could not SetHandleInformation (%s)",
  "Terminating Service:Failure: Could not open statistics file (%s)\n",
  "Could not set Thread Local Storage Value for thread at slot %d",
  "secure handshake failed (code %d)\n",
  "accept failed %d (%s)",
  "Failed to pulse Event %d %s",
  "Failed to send MobGrowth Event to parent %s",
  "Pulsing MobRespawn Event %d",
  "respawn thread pool to %d (%d)",
  "Could not open event to signal rotate application. Could not create the MoveLog event:%s",
  "Failed to send MoveLog Event to rotate app %s",
  "growing thread pool from %d to %d",
  "Could not open the ServiceControlManager, Error %d",
  "StartNetsiteService:Could not open the service %s: Error %d",
  "StartNetsiteService:Could not start the service %s",
  "Service Startup: Could not allocate security descriptor",
  "Service Startup: Could not init security descriptor",
  "Service Startup: Could not set the security Dacl",
  "Terminating Service:WinSock init failed: %s",
  "Httpd Server Startup failed: %s",
  "can't find empty statistics slot",
  "NT daemon: could not create new thread %d",
  "Service Startup Failure. Terminating Service:Could not create event %d:%s",
  "Service Startup Error. Could not create the MoveLog event:%s",
  "Failed to wait on Event objects %s",
  "Failed to wait on Event objects %s",
  "pipebuf_buf2sd: pipebuf_grab IO_ERROR %d",
  "pool-init: memory pools disabled",
  "pool-init: free_size <= 0, using %d",
  "pool-create-block: out of memory",
  "pool-create: out of memory",
  "pool-create: out of memory",
  "pool-malloc: out of memory",
  "FREE() used where PERM_FREE() should have been used- problem corrected and supressing further warnings.",
  "regex error: %s (regex: '%s')",
  "can't create IPC pipe (%s)",
  "write to wakeup pipe failed (%s)",
  "flushing %d connections; current %d; tot %d",
  "accept failed (%s)",
  "Error creating time cache",
  "time-cache: cache disabled",
  "time_cache_init: hash_size < %d, using default, %d",
  "time_cache_init: hash_size > %d, using default, %d",
  "time_cache_init: cache_size < %d, using default, %d",
  "time_cache_init: cache_size > %d, using default, %d",
  "Error allocating memory for time_cache",
  "Error allocating memory for time_cache entry",
  "Error allocating memory for time_cache entry",
  "Error inserting new time_cache entry",
  "Error allocating memory for time_cache",
  "cs-terminate failure (%s)",
  "cs-init failure (%s)",
  "cs-wait failure (%s)",
  "cs-post failure (%s)",
  "Unable to create nonblocking socket (%s)",
  "error: could not set keepalive (%s)\n",
  "error: could not set recv timeout (%s)\n",
  "error: could not set send timeout (%s)\n",
  "Unable to create nonblocking socket (%s)",
  "sem_grab failed (%s)",
  "sem_release failed (%s)",
  "sem_release failed (%s)",
  "Could not remove temporary directory %s,  Error %d",
  "Could not remove temporary directory %s, Error %d",
  emptyString };

/* libraries in bucket for hashKey==27 */
static struct DATABIN bucket27[] = {
  {"base",base,205},
  {emptyString,NULL,0} };

/* strings in library cgiadmin */
static char* cgiadmin[] = {
  "",
  "Missing REQUEST_METHOD",
  "This should only be invoked as CGI program",
  "Missing ADMSERV_ROOT",
  "This should only be invoked as CGI program",
  "Unrecognized request type.",
  "Startup",
  "Failed to initialize WinSock",
  "Bad file",
  "Expected servers.lst",
  "Cluster: merge product.lst from %s",
  "<i>Obtaining product information from %s://%s:%d</i><br>\n",
  "Updated %s<BR>\n",
  "Bad file",
  "Expected servers-instance.lst",
  "Warning: %s already exists, information not added<BR>\n",
  "Error: failed to create file %s<BR>\n",
  "Warning: directory %s will be removed because of above error<BR>\n",
  "",
  "Error: %s %s (errno = %d)<BR>\n",
  "Error: %s %s, %s<BR>\n",
  "ALLOW ALL OPERATIONS",
  "ALLOW GET OPERATIONS",
  "ALLOW SET OPERATIONS",
  "You accessed this form with an invalid query string.",
  "community has been removed.",
  "Community Strings",
  "Edit a Community",
  "Add Another Community",
  "",
  "Edit",
  "Remove",
  "Do you really want to remove this entry?",
  "<b>Community:</b> %s\n",
  "<br><b>Operation:</b> %s\n",
  "No communities exist.",
  "You should enter a community string.",
  "You should enter operation you want for this community.",
  "the community entry has been changed",
  "%s has been added",
  "fails to start up master agent",
  "Please refer to documents to start it",
  "master agent start up",
  "can't open config file",
  "open temp file fails",
  "open CONFIG fails",
  "open CONFIG fails",
  "No permission to start master agent",
  "You must be running as super user. Please refer to documents",
  "can't get tcp protocol entry\n",
  "can't create a sockect",
  "Please refer to documents for its configuration",
  "a smux master agent is running or the smux port is not free yet",
  "Please refer to documents for its configuration",
  "can't get udp protocol entry\n",
  "can't create a socket",
  "Please refer to documents for its configuration",
  "a snmpd is running or snmp port is not free yet",
  "Please refer to documents for its configuration",
  "can't get udp protocol entry\n",
  "can't create a socket",
  "Please refer to documents for its configuration",
  "Fail to start",
  "Please refer to documents for its configuration",
  emptyString };

/* libraries in bucket for hashKey==28 */
static struct DATABIN bucket28[] = {
  {"cgiadmin",cgiadmin,63},
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==29 */
static struct DATABIN bucket29[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==30 */
static struct DATABIN bucket30[] = {
  {emptyString,NULL,0} };

/* libraries in bucket for hashKey==31 */
static struct DATABIN bucket31[] = {
  {emptyString,NULL,0} };

/* array of bucket pointers */
static struct DATABIN* buckets[32] = {
  bucket0,
  bucket1,
  bucket2,
  bucket3,
  bucket4,
  bucket5,
  bucket6,
  bucket7,
  bucket8,
  bucket9,
  bucket10,
  bucket11,
  bucket12,
  bucket13,
  bucket14,
  bucket15,
  bucket16,
  bucket17,
  bucket18,
  bucket19,
  bucket20,
  bucket21,
  bucket22,
  bucket23,
  bucket24,
  bucket25,
  bucket26,
  bucket27,
  bucket28,
  bucket29,
  bucket30,
  bucket31 };
