subroutine  inipos(pos,npart,ndim,cell,nvec,options,rcut,reall,nimage)

  !Definit les positions initiales
  !variables
  !  pos(npart,ndim):position des particules
  !  npart:nombre de particules
  !  posopt:type de reseau 
  !  nvec:nombre de vecteurs de base
  !  ndim: dimensionlite de l'espace
  !  cell(nvec,ndim): axes de la maille de la cellule
  !  trans(nvec,ndim): vecteur qui translate la maille elementaire
  !  nprim=nombre de mailles unitaires cubiques
  use  types_def
  implicit none
  !input
  TYPE(options_type) :: options
  integer :: nvec,ndim,npart,nimage
  double precision :: pos(npart,ndim),cell(nvec,ndim)
  double precision :: rcut,reall
  !local variables
  integer :: natpm,inatpm,nprim,ix,iy,iz,ipart=1
  double precision, allocatable :: motif(:,:),trans(:),rand_depl(:,:)
  !compute nimage
  nimage=int(rcut/reall)+1
  !compute the positions
  if(options%posopt=='fcc') then 
     natpm=4
     allocate(motif(natpm,ndim),trans(ndim))
     motif(1,:)=0.d0
     motif(2:4,:)=0.5d0
     do inatpm=2,natpm 
        motif(inatpm,inatpm-1)=0.d0 
     enddo !inelegant, je le sais
     nprim=nint((real(npart/natpm))**(1.d0/3.d0))
     if(npart/=nprim**3*natpm) print*,'incomptabilite entre natomes et type de reseau'
     do ix=1,nprim
        do iy=1,nprim
           do iz=1,nprim
              trans(:)=dfloat(ix-1)*cell(1,:)+&
                   &dfloat(iy-1)*cell(2,:)+dfloat(iz-1)*cell(3,:)
              do inatpm=1,natpm
                 pos(ipart,:)=motif(inatpm,:)+trans(:)
                 ipart=ipart+1
              enddo
           enddo
        enddo
     enddo
     pos(:,:)=pos(:,:)/nprim
  elseif(options%posopt=='fccrand') then
     natpm=4
     allocate(motif(natpm,ndim),trans(ndim))
     motif(1,:)=0.d0
     motif(2:4,:)=0.5d0
     do inatpm=2,natpm
        motif(inatpm,inatpm-1)=0.d0
     enddo !inelegant, je le sais
        nprim=nint((real(npart/natpm))**(1.d0/3.d0))
        if(npart/=nprim**3*natpm) print*,'incomptabilite entre natomes et type de reseau'
        do ix=1,nprim
           do iy=1,nprim
              do iz=1,nprim
                 trans(:)=dfloat(ix-1)*cell(1,:)+&
                      &dfloat(iy-1)*cell(2,:)+dfloat(iz-1)*cell(3,:)
                 do inatpm=1,natpm
                    pos(ipart,:)=motif(inatpm,:)+trans(:)
                    ipart=ipart+1
                 enddo
              enddo
           enddo
        enddo
        pos(:,:)=pos(:,:)/nprim
        allocate(rand_depl(npart,ndim))
        call random_number(rand_depl)
        pos(:,:)=pos(:,:)+(rand_depl(:,:)-.5d0)/20.d0
        deallocate(rand_depl)
     elseif(options%posopt=="file")then
        open(unit=19,file="posfile")
        read(19,*)(pos(ipart,:),ipart=1,npart)
     endif
     print*,'pos:'
     print*,(pos(ipart,:),ipart=1,npart)
     return
   end subroutine  inipos

  


























