#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
#
# HiddenFieldSession functionality tests
#
# $Id: ses_hiddenfield.py 5912 2002-07-30 07:33:51Z andrewm $
#

import os, sys

import unittest
import albatross

import request

class Vars:
    pass

class HiddenFieldSessionApp(albatross.PickleSignMixin):
    def module_path(self):
        pass

class HiddenFieldSession(albatross.HiddenFieldSessionMixin):
    """ 
    This corresponds to the object albatross users know as the ctx,
    although since we aren't using the normal set of mixins, we have to
    supply our own locals and request members.
    """
    def __init__(self, request):
        self.app = HiddenFieldSessionApp(secret="test")
        self.request = request
        self.locals = Vars()
        albatross.HiddenFieldSessionMixin.__init__(self)

    def test_save(self):
        self.form_close()
        self.request.flush_content()

    def write_content(self, text):
        self.request.write_content(text)

class Session:
    """
    This represents a virtual "user" - essentially just a place to store
    their session id while the ctx objects come and go.
    """
    def __init__(self):
        self.request = request.DummyFieldRequest()

    def new_context(self):
        return HiddenFieldSession(self.request)

class HiddenFieldCase(unittest.TestCase):
    def setUp(self):
        pass

    def tearDown(self):
        pass

    def new_session(self):
        return Session()
