/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass1;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.instrument.ContextMethodAwareMethodAdapter;
import net.sourceforge.cobertura.instrument.pass1.CodeFootstamp;
import net.sourceforge.cobertura.instrument.pass1.DetectDuplicatedCodeClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectDuplicatedCodeMethodVisitor
extends ContextMethodAwareMethodAdapter {
    private final Logger logger = LoggerFactory.getLogger(DetectDuplicatedCodeClassVisitor.class);
    private final Map<Integer, List<LineIdWithCodeFootstamp>> line2label2codefootstamp = new LinkedHashMap<Integer, List<LineIdWithCodeFootstamp>>();
    private final Map<Integer, Map<Integer, Integer>> duplicatesCollector;
    private CodeFootstamp currentLineFootstamp;

    public DetectDuplicatedCodeMethodVisitor(MethodVisitor mv, Map<Integer, Map<Integer, Integer>> duplicatesCollector, String className, String methodName, String methodSignature, AtomicInteger lineIdGenerator) {
        super(mv, className, methodName, methodSignature, lineIdGenerator);
        this.duplicatesCollector = duplicatesCollector;
    }

    @Override
    public void visitLineNumber(int lineNumber, Label label) {
        super.visitLineNumber(lineNumber, label);
        this.currentLineFootstamp = new CodeFootstamp();
        List<LineIdWithCodeFootstamp> footstamps = this.line2label2codefootstamp.get(lineNumber);
        if (footstamps == null) {
            footstamps = new LinkedList<LineIdWithCodeFootstamp>();
            this.line2label2codefootstamp.put(lineNumber, footstamps);
        }
        footstamps.add(new LineIdWithCodeFootstamp(this.lastLineId, this.currentLineFootstamp));
    }

    public void visitLabel(Label label) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitLabel(label);
        }
        super.visitLabel(label);
    }

    public void visitFieldInsn(int access, String name, String description, String signature) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitFieldInsn(access, name, description, signature);
        }
        super.visitFieldInsn(access, name, description, signature);
    }

    public void visitInsn(int opCode) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitInsn(opCode);
        }
        super.visitInsn(opCode);
    }

    public void visitIntInsn(int opCode, int variable) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitIntInsn(opCode, variable);
        }
        super.visitIntInsn(opCode, variable);
    }

    public void visitIincInsn(int opCode, int variable) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitIintInsn(opCode, variable);
        }
        super.visitIincInsn(opCode, variable);
    }

    public void visitJumpInsn(int opCode, Label label) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitJumpInsn(opCode, label);
        }
        super.visitJumpInsn(opCode, label);
    }

    public void visitLdcInsn(Object obj) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitLdcInsn(obj);
        }
        super.visitLdcInsn(obj);
    }

    public void visitMethodInsn(int opCode, String className, String methodName, String description) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitMethodInsn(opCode, className, methodName, description);
        }
        super.visitMethodInsn(opCode, className, methodName, description);
    }

    public void visitMultiANewArrayInsn(String type, int arg1) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitMultiANewArrayInsn(type, arg1);
        }
        super.visitMultiANewArrayInsn(type, arg1);
    }

    public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitLookupSwitchInsn(arg0, arg1, arg2);
        }
        super.visitLookupSwitchInsn(arg0, arg1, arg2);
    }

    public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label[] arg3) {
        if (this.currentLineFootstamp != null) {
            this.currentLineFootstamp.visitTableSwitchInsn(arg0, arg1, arg2, arg3);
        }
        super.visitTableSwitchInsn(arg0, arg1, arg2, arg3);
    }

    public void visitEnd() {
        super.visitEnd();
        this.putDuplicatedLinesIntoMap(this.duplicatesCollector);
    }

    public void putDuplicatedLinesIntoMap(Map<Integer, Map<Integer, Integer>> res) {
        for (Map.Entry<Integer, List<LineIdWithCodeFootstamp>> l : this.line2label2codefootstamp.entrySet()) {
            Map<Integer, Integer> r = this.putDuplicates(l.getValue());
            if (r != null) {
                res.put(l.getKey(), r);
            }
            if (!this.logger.isDebugEnabled()) continue;
            for (LineIdWithCodeFootstamp pair : l.getValue()) {
                this.logger.debug("SIGNATURE:" + l.getKey() + ":" + pair.lineId + ":" + pair.footstamp);
            }
        }
    }

    private Map<Integer, Integer> putDuplicates(List<LineIdWithCodeFootstamp> listOfFootstamps) {
        HashMap<CodeFootstamp, Integer> reversedMap = new HashMap<CodeFootstamp, Integer>();
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (LineIdWithCodeFootstamp lcf : listOfFootstamps) {
            lcf.footstamp.finalize();
            if (!lcf.footstamp.isMeaningful()) continue;
            Integer found = (Integer)reversedMap.get(lcf.footstamp);
            if (found != null) {
                result.put(lcf.lineId, found);
                continue;
            }
            reversedMap.put(lcf.footstamp, lcf.lineId);
        }
        return result.size() > 0 ? result : null;
    }

    private static class LineIdWithCodeFootstamp {
        private Integer lineId;
        private CodeFootstamp footstamp;

        public LineIdWithCodeFootstamp(Integer lineId, CodeFootstamp footstamp) {
            this.lineId = lineId;
            this.footstamp = footstamp;
        }
    }
}

