// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "SliceIncludes.h"
#include "Naming.h"

#include "Puma/Unit.h"
#include "Puma/CTree.h"
#include "Puma/CProject.h"
#include "Puma/Filename.h"

// this function declares that a unit 'iu' depends on the unit 'si' in
// which (a part of) a slice is defined
void SliceIncludes::insert (Unit *iu, Unit *su) {
  assert (iu && su);

  // don't generate self includes  
  if (iu == su)
    return;

  // check if there is already an entry for this unit
  iterator entry = find (iu);
  if (entry == end ()) {
    // there is no entry for the unit 'iu' yet => make a new one
    UnitSet new_set;
    new_set.insert (su);
    UnitUnitSetMap::insert (value_type (iu, new_set));
  }
  else {
    // entry found: add the unit reference to the stored set
    UnitSet &set = (*entry).second;
    set.insert (su);
  }
}


// generate the #include directive for a given unit
string SliceIncludes::generate (CProject &project, Unit *unit) {
  string include_directive;

  // get the name, which we have to use to include the file
  Filename include_file = project.getInclString (unit->name ());
    
  include_directive += "#include \"";
  include_directive += include_file.name ();
  include_directive += "\"";
  
  return include_directive;
}


// generate the #include directives for a given unit
string SliceIncludes::generate (CProject &prj, const_iterator entry) const {
  string includes;
  const UnitSet &set = (*entry).second;
  for (UnitSet::const_iterator iter = set.begin ();
    iter != set.end (); ++iter) {

    // add the #include directive for the current unit
    includes += generate (prj, *iter);
    includes += "\n";
  }
  return includes;
}
