//
// BAGEL - Parallel electron correlation program.
// Filename: _complex_eriroot_13.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot13(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[13] = {4.656008324502489e-02,4.200274064012138e-01,1.172310773277779e+00,2.314540864349432e+00,3.864585038228160e+00,
    5.848734811306344e+00,8.304553489985892e+00,1.128575099351763e+01,1.487096037752541e+01,1.918091948561044e+01,2.441669233305652e+01,3.096393827474679e+01,
    3.981042606874936e+01};
  static constexpr double aw[13] = {4.120436505903693e-01,2.846322411767841e-01,1.351133279117879e-01,4.359822721725099e-02,9.397901291159517e-03,
    1.319064722323857e-03,1.162297016031097e-04,6.103291717396045e-06,1.770106337397341e-07,2.524494034490568e-09,1.460999933981603e-11,2.383148659372180e-14,
    4.396916094753844e-18};
  static constexpr double xr[61620] = {   7.289873228091698e-03,  -1.396206883278476e-04,   1.997792965564928e-06,  -2.528154026600633e-08,   2.979919952607310e-10,
  -3.345463890814176e-12,   3.616812479376056e-14,  -3.787071467242461e-16,   3.850375463263490e-18,  -3.803204574744258e-20,   3.644268808120717e-22,  -3.375673772650880e-24,
   3.002605619982530e-26,  -2.534162906158513e-28,   7.290060857887695e-03,  -1.396278098179498e-04,   1.997960873570863e-06,  -2.528468292016820e-08,   2.980429765405905e-10,
  -3.346211519021102e-12,   3.617826390394654e-14,  -3.788359605354662e-16,   3.851918888976102e-18,  -3.804952396813721e-20,   3.646134533852281e-22,  -3.377534298630738e-24,
   3.004302625371246e-26,  -2.535508129006492e-28,   7.290391946451651e-03,  -1.396403765191436e-04,   1.998257173236062e-06,  -2.529022875342761e-08,   2.981329454167515e-10,
  -3.347530927177949e-12,   3.619615782116745e-14,  -3.790633025468277e-16,   3.854642928577635e-18,  -3.808037237100642e-20,   3.649427490577388e-22,  -3.380818025784820e-24,
   3.007297560109864e-26,  -2.537881794272856e-28,   7.290792324170448e-03,  -1.396555735360353e-04,   1.998615501769732e-06,  -2.529693580720599e-08,   2.982417565345789e-10,
  -3.349126721641896e-12,   3.621780096100924e-14,  -3.793382888203019e-16,   3.857937958933222e-18,  -3.811768790408024e-20,   3.653410825908027e-22,  -3.384790107457842e-24,
   3.010919990971373e-26,  -2.540752051681308e-28,   7.291181026853641e-03,  -1.396703278225558e-04,   1.998963402603695e-06,  -2.530344791791344e-08,   2.983474092130207e-10,
  -3.350676259987222e-12,   3.623881763706935e-14,  -3.796053265017842e-16,   3.861137861744824e-18,  -3.815392712364047e-20,   3.657279304759132e-22,  -3.388647563654668e-24,
   3.014437550959433e-26,  -2.543538442116799e-28,   7.291494177106736e-03,  -1.396822146051045e-04,   1.999243696869771e-06,  -2.530869471982038e-08,   2.984325364912645e-10,
  -3.351924812149468e-12,   3.625575261939619e-14,  -3.798205100504923e-16,   3.863716481962201e-18,  -3.818313096197145e-20,   3.660396794458806e-22,  -3.391756103405762e-24,
   3.017271943866400e-26,  -2.545783116757890e-28,   7.291701109258706e-03,  -1.396900696303357e-04,   1.999428924958212e-06,  -2.531216207062124e-08,   2.984887943543274e-10,
  -3.352749962565694e-12,   3.626694502128692e-14,  -3.799627296064869e-16,   3.865420789894000e-18,  -3.820243323241972e-20,   3.662457311564137e-22,  -3.393810672083846e-24,
   3.019145199028324e-26,  -2.547266354745416e-28,   7.291807381307643e-03,  -1.396941037011482e-04,   1.999524052969423e-06,  -2.531394283175411e-08,   2.985176877086300e-10,
  -3.353173756805442e-12,   3.627269349458510e-14,  -3.800357754634024e-16,   3.866296157788067e-18,  -3.821234738566863e-20,   3.663515651296512e-22,  -3.394865946342322e-24,
   3.020107309935827e-26,  -2.548028067389201e-28,   7.291844370663518e-03,  -1.396955078186478e-04,   1.999557163865285e-06,  -2.531456265958094e-08,   2.985277446633782e-10,
  -3.353321268643021e-12,   3.627469440515777e-14,  -3.800612012250944e-16,   3.866600857377820e-18,  -3.821579833851186e-20,   3.663884042498437e-22,  -3.395233268877704e-24,
   3.020442198121229e-26,  -2.548293188277330e-28,   7.291850240383670e-03,  -1.396957306338115e-04,   1.999562418142648e-06,  -2.531466101855652e-08,   2.985293405805947e-10,
  -3.353344677042558e-12,   3.627501192694148e-14,  -3.800652360136752e-16,   3.866649209945268e-18,  -3.821634596864280e-20,   3.663942502360323e-22,  -3.395291559076184e-24,
   3.020495341055569e-26,  -2.548335259302578e-28,   6.492340660819676e-02,  -1.206195458625360e-03,   1.622796780704687e-05,  -1.845685846756530e-07,   1.829689239361583e-09,
  -1.553651179632799e-11,   1.033181435398015e-13,  -3.298647818167128e-16,  -4.491188779817069e-18,   1.160877043078268e-19,  -1.649424793890970e-21,   1.776645055996445e-23,
  -1.459132395736759e-25,   7.008358005307801e-28,   6.492493004491653e-02,  -1.206247419762527e-03,   1.622899782446771e-05,  -1.845831555280736e-07,   1.829834388863282e-09,
  -1.553715494088451e-11,   1.033062097931958e-13,  -3.294705926815846e-16,  -4.498176245467440e-18,   1.161795078429858e-19,  -1.650326002626941e-21,   1.777148762487583e-23,
  -1.458784131947415e-25,   6.992495140394555e-28,   6.492761825162023e-02,  -1.206339109340549e-03,   1.623081537278378e-05,  -1.846088665150457e-07,   1.830090493745799e-09,
  -1.553828914746987e-11,   1.032851375794928e-13,  -3.287747876988881e-16,  -4.510508828297125e-18,   1.163415176528995e-19,  -1.651916022182896e-21,   1.778036613184136e-23,
  -1.458167565846792e-25,   6.964473120952110e-28,   6.493086899398931e-02,  -1.206449987042886e-03,   1.623301328479479e-05,  -1.846399573480672e-07,   1.830400155140456e-09,
  -1.553965956412786e-11,   1.032596313719907e-13,  -3.279329830694559e-16,  -4.525426787110846e-18,   1.165374574731250e-19,  -1.653838387568275e-21,   1.779108595160596e-23,
  -1.457418511781563e-25,   6.930534453586092e-28,   6.493402489884463e-02,  -1.206557631150334e-03,   1.623514709823191e-05,  -1.846701406623314e-07,   1.830700744578969e-09,
  -1.554098881160723e-11,   1.032348437184118e-13,  -3.271153235636130e-16,  -4.539914399243409e-18,   1.167277099418541e-19,  -1.655704268145025e-21,   1.780147562197540e-23,
  -1.456687680112838e-25,   6.897530667127006e-28,   6.493656735537934e-02,  -1.206644352109061e-03,   1.623686615549113e-05,  -1.846944565720992e-07,   1.830942877969047e-09,
  -1.554205882670927e-11,   1.032148559948313e-13,  -3.264563051372187e-16,  -4.551589382954576e-18,   1.168810016884349e-19,  -1.657207168458826e-21,   1.780983325256540e-23,
  -1.456096305559299e-25,   6.870902596250917e-28,   6.493824741463519e-02,  -1.206701657862313e-03,   1.623800211947379e-05,  -1.847105243976665e-07,   1.831102866801336e-09,
  -1.554276547723223e-11,   1.032016391036688e-13,  -3.260206795518378e-16,  -4.559305938954383e-18,   1.169823072715016e-19,  -1.658200145922695e-21,   1.781534987096452e-23,
  -1.455704249361918e-25,   6.853287332907081e-28,   6.493911022068843e-02,  -1.206731087754515e-03,   1.623858550418826e-05,  -1.847187760893860e-07,   1.831185026061855e-09,
  -1.554312825347759e-11,   1.031948487027935e-13,  -3.257969161195178e-16,  -4.563269357989395e-18,   1.170343365934556e-19,  -1.658710052581010e-21,   1.781818107582915e-23,
  -1.455502511770280e-25,   6.844234894314532e-28,   6.493941053066246e-02,  -1.206741331200839e-03,   1.623878855862719e-05,  -1.847216481812937e-07,   1.831213621921306e-09,
  -1.554325450155038e-11,   1.031924847806878e-13,  -3.257190254304289e-16,  -4.564648957528551e-18,   1.170524465212437e-19,  -1.658887524720861e-21,   1.781916620916905e-23,
  -1.455432231783819e-25,   6.841083129699481e-28,   6.493945818583456e-02,  -1.206742956699578e-03,   1.623882078066729e-05,  -1.847221039434382e-07,   1.831218159670263e-09,
  -1.554327453445402e-11,   1.031921096369252e-13,  -3.257066648815795e-16,  -4.564867885496932e-18,   1.170553203480245e-19,  -1.658915686842064e-21,   1.781932252233022e-23,
  -1.455421076309243e-25,   6.840582941514082e-28,   1.765976767462863e-01,  -3.085169122255068e-03,   3.641720169036036e-05,  -3.202214162086036e-07,   1.782400966084090e-09,
   2.411861509463770e-12,  -2.159678397456393e-13,   3.135786225256539e-15,  -2.559278593351050e-17,   4.206633641414088e-20,   2.484470289783973e-21,  -4.712029325170041e-23,
   4.742587223896004e-25,  -1.826096397687122e-27,   1.766010928614174e-01,  -3.085259176193091e-03,   3.641820256973358e-05,  -3.202191031668931e-07,   1.782096470356076e-09,
   2.418037219536779e-12,  -2.160348019836529e-13,   3.135921850321536e-15,  -2.558221074061580e-17,   4.182287357395096e-20,   2.487391366444898e-21,  -4.713319615414700e-23,
   4.739707905266500e-25,  -1.817941958736385e-27,   1.766071207264793e-01,  -3.085418077247910e-03,   3.641996849772314e-05,  -3.202150170606198e-07,   1.781559106374796e-09,
   2.428934571232087e-12,  -2.161529352820623e-13,   3.136160494485796e-15,  -2.556354063903581e-17,   4.139322592815977e-20,   2.492544195424554e-21,  -4.715591497677431e-23,
   4.734619714113943e-25,  -1.803547887035753e-27,   1.766144098151902e-01,  -3.085610221187354e-03,   3.642210363898685e-05,  -3.202100680699766e-07,   1.780909189721828e-09,
   2.442112129691136e-12,  -2.162957447383041e-13,   3.136447925787054e-15,  -2.554094749278731e-17,   4.087360009296429e-20,   2.498772564803998e-21,  -4.718330401307816e-23,
   4.728454083428522e-25,  -1.786133167334578e-27,   1.766214860723297e-01,  -3.085796750239882e-03,   3.642417614818814e-05,  -3.202052552692967e-07,   1.780278125369531e-09,
   2.454905055955488e-12,  -2.164343412562699e-13,   3.136725765432956e-15,  -2.551899659687940e-17,   4.036906088457093e-20,   2.504816350835394e-21,  -4.720980607290673e-23,
   4.722455053482406e-25,  -1.769217585950314e-27,   1.766271867104920e-01,  -3.085947014931951e-03,   3.642584555623571e-05,  -3.202013721165212e-07,   1.779769650336810e-09,
   2.465211143042106e-12,  -2.165459638276079e-13,   3.136948734076666e-15,  -2.550130044661285e-17,   3.996254240091376e-20,   2.509683275904048e-21,  -4.723109361717675e-23,
   4.717612612434304e-25,  -1.755583695750344e-27,   1.766309536383409e-01,  -3.086046306827018e-03,   3.642694858396989e-05,  -3.201988032492146e-07,   1.779433611215612e-09,
   2.472021354732604e-12,  -2.166197078390279e-13,   3.137095648940182e-15,  -2.548960088273452e-17,   3.969388885816076e-20,   2.512898336561614e-21,  -4.724512959891380e-23,
   4.714408065043875e-25,  -1.746571282015154e-27,   1.766328881507847e-01,  -3.086097297861930e-03,   3.642751501446931e-05,  -3.201974831008832e-07,   1.779261024242734e-09,
   2.475518765348611e-12,  -2.166575745262757e-13,   3.137170967213039e-15,  -2.548359066024647e-17,   3.955591209998760e-20,   2.514549140335998e-21,  -4.725232832901888e-23,
   4.712760908295217e-25,  -1.741941931532443e-27,   1.766335614779050e-01,  -3.086115045742008e-03,   3.642771216149005e-05,  -3.201970234659659e-07,   1.779200951409424e-09,
   2.476736077672991e-12,  -2.166707536743692e-13,   3.137197161804151e-15,  -2.548149843897869e-17,   3.950788638544894e-20,   2.515123672522543e-21,  -4.725483241342836e-23,
   4.712187366563858e-25,  -1.740330477467106e-27,   1.766336683257573e-01,  -3.086117862085361e-03,   3.642774344580287e-05,  -3.201969505213415e-07,   1.779191418566228e-09,
   2.476929248683716e-12,  -2.166728449904711e-13,   3.137201317545924e-15,  -2.548116641764296e-17,   3.950026528812183e-20,   2.515214840722526e-21,  -4.725522970594678e-23,
   4.712096342293998e-25,  -1.740074754010500e-27,   3.354194496132327e-01,  -5.333506343927347e-03,   5.052154750349247e-05,  -2.415734741122393e-07,  -1.347985655486465e-09,
   3.977660415526184e-11,  -3.463527107200993e-13,  -3.010198785781350e-16,   4.757338106201129e-17,  -5.936099476606836e-19,   1.526282146895520e-21,   6.246642206659175e-23,
  -1.082388868085595e-24,   5.926096545618991e-27,   3.354241844713348e-01,  -5.333574155004204e-03,   5.052078652292867e-05,  -2.415361888997390e-07,  -1.348471234500621e-09,
   3.977597980969888e-11,  -3.462277029311868e-13,  -3.030148628038873e-16,   4.757960588711739e-17,  -5.932862184358956e-19,   1.519616432551512e-21,   6.250867280792289e-23,
  -1.081709740476405e-24,   5.906444390859462e-27,   3.354325391447417e-01,  -5.333693800193308e-03,   5.051944353901814e-05,  -2.414703990403644e-07,  -1.349327903353274e-09,
   3.977487495310543e-11,  -3.460071115629437e-13,  -3.065341544312692e-16,   4.759056685445280e-17,  -5.927148171100729e-19,   1.507858104690526e-21,   6.258310818411762e-23,
  -1.080510158487967e-24,   5.871776069993616e-27,   3.354426416058426e-01,  -5.333838461902346e-03,   5.051781921049376e-05,  -2.413908460674826e-07,  -1.350363552719651e-09,
   3.977353351212929e-11,  -3.457403477211697e-13,  -3.107882025991025e-16,   4.760378204663593e-17,  -5.920235727348505e-19,   1.493645661673151e-21,   6.267291725006628e-23,
  -1.079057480969333e-24,   5.829868810112830e-27,   3.354524487962596e-01,  -5.333978881767751e-03,   5.051624194466642e-05,  -2.413136182876662e-07,  -1.351368687917887e-09,
   3.977222557256321e-11,  -3.454813545842265e-13,  -3.149163700516452e-16,   4.761657037317438e-17,  -5.913522111542138e-19,   1.479854602338453e-21,   6.275989400333733e-23,
  -1.077645019006993e-24,   5.789200720718214e-27,   3.354603492668372e-01,  -5.334091991281955e-03,   5.051497103626867e-05,  -2.412514052168060e-07,  -1.352178228846446e-09,
   3.977116783611806e-11,  -3.452726963328827e-13,  -3.182408293509367e-16,   4.762684329041872e-17,  -5.908111466702201e-19,   1.468749103364892e-21,   6.282981210501144e-23,
  -1.076505563878560e-24,   5.756449639846949e-27,   3.354655697205802e-01,  -5.334166726695479e-03,   5.051413110381800e-05,  -2.412102962341116e-07,  -1.352713069506529e-09,
   3.977046690669823e-11,  -3.451348104891683e-13,  -3.204370151683995e-16,   4.763361716073565e-17,  -5.904535111837551e-19,   1.461412942941995e-21,   6.287593968166120e-23,
  -1.075751852523284e-24,   5.734813513721009e-27,   3.354682506620865e-01,  -5.334205105255310e-03,   5.051369971538679e-05,  -2.411891848993424e-07,  -1.352987708077374e-09,
   3.977010632869088e-11,  -3.450639969810834e-13,  -3.215646891810300e-16,   4.763709144845140e-17,  -5.902698143450135e-19,   1.457646140470230e-21,   6.289960580773102e-23,
  -1.075364544724138e-24,   5.723703940094992e-27,   3.354691837865331e-01,  -5.334218463001685e-03,   5.051354955985881e-05,  -2.411818369210538e-07,  -1.353083294137185e-09,
   3.976998072795908e-11,  -3.450393492885952e-13,  -3.219571589854231e-16,   4.763830000268268e-17,  -5.902058715827544e-19,   1.456335176579900e-21,   6.290783942324816e-23,
  -1.075229700353228e-24,   5.719837408199626e-27,   3.354693318604464e-01,  -5.334220582679590e-03,   5.051352573192007e-05,  -2.411806708988150e-07,  -1.353098462119093e-09,
   3.976996079218843e-11,  -3.450354380201473e-13,  -3.220194372344082e-16,   4.763849175020194e-17,  -5.901957244909329e-19,   1.456127149707913e-21,   6.290914581390782e-23,
  -1.075208300588648e-24,   5.719223855041590e-27,   5.317377696778841e-01,  -7.430549022466187e-03,   4.915322662812254e-05,   6.502097909211393e-08,  -4.723787509224223e-09,
   3.286656869400764e-11,   2.631769977327948e-13,  -6.498457234639540e-15,   2.438836736331514e-17,   6.799147797812717e-19,  -9.965216706895367e-21,  -5.752830798265863e-24,
   1.575459591779844e-24,  -1.450402492348596e-26,   5.317423724540741e-01,  -7.430530627221738e-03,   4.915057159651253e-05,   6.505168421552962e-08,  -4.723416671729308e-09,
   3.285381136542207e-11,   2.632401562021733e-13,  -6.496163421456067e-15,   2.434663853158252e-17,   6.798810717937238e-19,  -9.955511322880175e-21,  -5.857074028042278e-24,
   1.574538718935592e-24,  -1.447103388817394e-26,   5.317504939230794e-01,  -7.430498161520714e-03,   4.914588692116224e-05,   6.510585417738260e-08,  -4.722762251255883e-09,
   3.283130452912913e-11,   2.633515114507735e-13,  -6.492116047405986e-15,   2.427304060086104e-17,   6.798211583850822e-19,  -9.938390665687351e-21,  -6.040817256098385e-24,
   1.572912607492363e-24,  -1.441286079875426e-26,   5.317603141457730e-01,  -7.430458891709305e-03,   4.914022245103876e-05,   6.517134051711496e-08,  -4.721970796535645e-09,
   3.280409528093194e-11,   2.634860119348566e-13,  -6.487222082936271e-15,   2.418410187861898e-17,   6.797479690715956e-19,  -9.917696109357157e-21,  -6.262668195393714e-24,
   1.570944225431694e-24,  -1.434258567046909e-26,   5.317698470873339e-01,  -7.430420756755833e-03,   4.913472378454167e-05,   6.523489618636240e-08,  -4.721202337809842e-09,
   3.277768756770888e-11,   2.636164241182437e-13,  -6.482471279173613e-15,   2.409782104941637e-17,   6.796761425026771e-19,  -9.897614496873898e-21,  -6.477688389980835e-24,
   1.569031190923148e-24,  -1.427443541246579e-26,   5.317775264426958e-01,  -7.430390026778163e-03,   4.913029434746976e-05,   6.528608338769817e-08,  -4.720583185672980e-09,
   3.275641855312400e-11,   2.637213689144096e-13,  -6.478644217578038e-15,   2.402835684451732e-17,   6.796177247060176e-19,  -9.881442964945336e-21,  -6.650656054593567e-24,
   1.567488528862667e-24,  -1.421958576607303e-26,   5.317826006974068e-01,  -7.430369716572254e-03,   4.912736756069047e-05,   6.531990089835669e-08,  -4.720174016057538e-09,
   3.274236666631109e-11,   2.637906589804493e-13,  -6.476115424526607e-15,   2.398247694496723e-17,   6.795788516064159e-19,  -9.870760021442890e-21,  -6.764827752786990e-24,
   1.566468409595215e-24,  -1.418336722197505e-26,   5.317852065308716e-01,  -7.430359284954005e-03,   4.912586454852299e-05,   6.533726592800455e-08,  -4.719963873997502e-09,
   3.273515106109351e-11,   2.638262255581202e-13,  -6.474816787247124e-15,   2.395892185598517e-17,   6.795588044396507e-19,  -9.865274721134700e-21,  -6.823422587409492e-24,
   1.565944296158756e-24,  -1.416477503672971e-26,   5.317861135088441e-01,  -7.430355653917924e-03,   4.912534141660947e-05,   6.534330968628301e-08,  -4.719890729919138e-09,
   3.273263971681345e-11,   2.638386020953839e-13,  -6.474364787672026e-15,   2.395072431589306e-17,   6.795518134753725e-19,  -9.863365655811925e-21,  -6.843811040254661e-24,
   1.565761836550673e-24,  -1.415830509340699e-26,   5.317862574334615e-01,  -7.430355077712260e-03,   4.912525840302804e-05,   6.534426873327657e-08,  -4.719879122856354e-09,
   3.273224120643671e-11,   2.638405659515243e-13,  -6.474293061708107e-15,   2.394942352780607e-17,   6.795507034712536e-19,  -9.863062720258941e-21,  -6.847046121353025e-24,
   1.565732880961777e-24,  -1.415727846123227e-26,   7.538642253256578e-01,  -8.903564063411128e-03,   3.040310062172878e-05,   4.114879737993981e-07,  -4.350753772939848e-09,
  -2.521816037547457e-11,   6.329174158251393e-13,   3.794900251401817e-16,  -8.884101617245679e-17,   3.675462157252724e-19,   1.147130793720136e-20,  -1.124112715230474e-22,
  -1.248791703403343e-24,   2.425095051035891e-26,   7.538670707081225e-01,  -8.903448415895967e-03,   3.040065833450127e-05,   4.114643382848746e-07,  -4.349866479161567e-09,
  -2.521739379519584e-11,   6.326852022397503e-13,   3.807155856908308e-16,  -8.879286891121688e-17,   3.669733897658752e-19,   1.146361385447362e-20,  -1.122363039230209e-22,
  -1.248084754170773e-24,   2.420794963928375e-26,   7.538720912447683e-01,  -8.903244359436348e-03,   3.039634928532799e-05,   4.114226336373055e-07,  -4.348301100403412e-09,
  -2.521603919791303e-11,   6.322755603118782e-13,   3.828765398126224e-16,  -8.870793867078387e-17,   3.659633603858869e-19,   1.145004108749280e-20,  -1.119278255239603e-22,
  -1.246836699983912e-24,   2.413214482459475e-26,   7.538781618150917e-01,  -8.902997621392822e-03,   3.039113942760672e-05,   4.113722049382563e-07,  -4.346408679573543e-09,
  -2.521439787383774e-11,   6.317803918131612e-13,   3.854869185573615e-16,  -8.860528505330127e-17,   3.647432678168941e-19,   1.143363483006377e-20,  -1.115552441167611e-22,
  -1.245326466426478e-24,   2.404060163512708e-26,   7.538840546885539e-01,  -8.902758102013264e-03,   3.038608251097522e-05,   4.113232506853091e-07,  -4.344572023301816e-09,
  -2.521280101928395e-11,   6.312998739075618e-13,   3.880182347364901e-16,  -8.850567774494277e-17,   3.635601266761361e-19,   1.141771428630677e-20,  -1.111940026166420e-22,
  -1.243859237984428e-24,   2.395185948485065e-26,   7.538888016735509e-01,  -8.902565155224281e-03,   3.038200924269500e-05,   4.112838145326868e-07,  -4.343092775804726e-09,
  -2.521151211817454e-11,   6.309129060886344e-13,   3.900554292433355e-16,  -8.842546909380659e-17,   3.626079369321210e-19,   1.140489346712957e-20,  -1.109033162502070e-22,
  -1.242676458206414e-24,   2.388046044583975e-26,   7.538919382805264e-01,  -8.902437662805797e-03,   3.037931795317177e-05,   4.112577561965376e-07,  -4.342115481320821e-09,
  -2.521065921387040e-11,   6.306572688513651e-13,   3.914005918912632e-16,  -8.837248514391719e-17,   3.619792036513929e-19,   1.139642393356304e-20,  -1.107113949450737e-22,
  -1.241894507986522e-24,   2.383332550459682e-26,   7.538935490423718e-01,  -8.902372190394664e-03,   3.037793592564788e-05,   4.112443741088848e-07,  -4.341613645144596e-09,
  -2.521022082909968e-11,   6.305260067509018e-13,   3.920910945567368e-16,  -8.834528045194333e-17,   3.616564602224870e-19,   1.139207511429277e-20,  -1.106128833426108e-22,
  -1.241492818630136e-24,   2.380913314176957e-26,   7.538941096770652e-01,  -8.902349402288923e-03,   3.037745491079592e-05,   4.112397163690119e-07,  -4.341438984634753e-09,
  -2.521006818516288e-11,   6.304803229350804e-13,   3.923313821492100e-16,  -8.833581242187409e-17,   3.615441488898069e-19,   1.139056157801791e-20,  -1.105786033033135e-22,
  -1.241352987807693e-24,   2.380071494639245e-26,   7.538941986417983e-01,  -8.902345786138291e-03,   3.037737858095620e-05,   4.112389772507097e-07,  -4.341411268805008e-09,
  -2.521004395981932e-11,   6.304730736927024e-13,   3.923695101935925e-16,  -8.833431001445014e-17,   3.615263276948703e-19,   1.139032140588285e-20,  -1.105731639046794e-22,
  -1.241330797672628e-24,   2.379937919811076e-26,   9.888849296637470e-01,  -9.434692741384733e-03,   6.298071276783926e-07,   5.600817328316596e-07,  -4.443426154825207e-11,
  -5.991547384618786e-11,   2.085694582983587e-15,   7.803561402508746e-15,   2.271917187094169e-19,  -1.127465130638846e-18,  -1.206340677834164e-22,   1.737262865168250e-22,
   3.302974825288157e-26,  -2.798937667307313e-26,   9.888849886579087e-01,  -9.434535416076362e-03,   6.297821500538370e-07,   5.600256907904534e-07,  -4.443132163187707e-11,
  -5.990017072176605e-11,   2.086280602375491e-15,   7.799779330366005e-15,   2.266892536804789e-19,  -1.126577208186330e-18,  -1.204327177718447e-22,   1.735240982645292e-22,
   3.296435808836480e-26,  -2.794425205049623e-26,   9.888850927521349e-01,  -9.434257825882622e-03,   6.297380779877918e-07,   5.599268153710115e-07,  -4.442613343718475e-11,
  -5.987317415978347e-11,   2.087313574409232e-15,   7.793108235064834e-15,   2.258033341703513e-19,  -1.125011300070310e-18,  -1.200777600016983e-22,   1.731676011114014e-22,
   3.284910685303495e-26,  -2.786470802582305e-26,   9.888852186207455e-01,  -9.433922182656965e-03,   6.296847878688998e-07,   5.598072740080481e-07,  -4.441985868197917e-11,
  -5.984053992770410e-11,   2.088560834517170e-15,   7.785045617956547e-15,   2.247332430574456e-19,  -1.123119227309209e-18,  -1.196490992269188e-22,   1.727369762199379e-22,
   3.270996652677920e-26,  -2.776865726052497e-26,   9.888853408084212e-01,  -9.433596368852533e-03,   6.296330571467166e-07,   5.596912461055386e-07,  -4.441376607100533e-11,
  -5.980886996183812e-11,   2.089769747687034e-15,   7.777222904907598e-15,   2.236956436917314e-19,  -1.121283942868872e-18,  -1.192335464775713e-22,   1.723194093795826e-22,
   3.257512443243713e-26,  -2.767555376164973e-26,   9.888854392387929e-01,  -9.433333913843947e-03,   6.295913852714184e-07,   5.595977904245341e-07,  -4.440885709293338e-11,
  -5.978336477186857e-11,   2.090742268137994e-15,   7.770924134363017e-15,   2.228606452751242e-19,  -1.119806540694577e-18,  -1.188992004099842e-22,   1.719833639779685e-22,
   3.246666408656851e-26,  -2.760065165410631e-26,   9.888855042786390e-01,  -9.433160496256993e-03,   6.295638500816676e-07,   5.595360438639668e-07,  -4.440561291184043e-11,
  -5.976651517695642e-11,   2.091384224704387e-15,   7.766763538885529e-15,   2.223093228783866e-19,  -1.118830827737037e-18,  -1.186784748992945e-22,   1.717614780164983e-22,
   3.239507695871753e-26,  -2.755120701560068e-26,   9.888855376793438e-01,  -9.433071440504540e-03,   6.295497097049686e-07,   5.595043363044700e-07,  -4.440394674108492e-11,
  -5.975786327262045e-11,   2.091713693726676e-15,   7.764627343948116e-15,   2.220263252717372e-19,  -1.118329915701763e-18,  -1.185651849706741e-22,   1.716475805346243e-22,
   3.235833874210388e-26,  -2.752583007729454e-26,   9.888855493047065e-01,  -9.433040444228548e-03,   6.295447880588778e-07,   5.594933005568073e-07,  -4.440336679463778e-11,
  -5.975485208415275e-11,   2.091828335586229e-15,   7.763883896538069e-15,   2.219278465036007e-19,  -1.118155594665761e-18,  -1.185257634291875e-22,   1.716079456818113e-22,
   3.234555567954615e-26,  -2.751699982841266e-26,   9.888855511494887e-01,  -9.433035525565150e-03,   6.295440070633960e-07,   5.594915493526727e-07,  -4.440327476415272e-11,
  -5.975437425884661e-11,   2.091846526111068e-15,   7.763765925223834e-15,   2.219122202828708e-19,  -1.118127933551628e-18,  -1.185195082507884e-22,   1.716016565661841e-22,
   3.234352737391490e-26,  -2.751559870472290e-26,   1.223483088307193e+00,  -8.924950709540646e-03,  -2.888031532527352e-05,   4.130847609068437e-07,   4.174867859691043e-09,
  -2.543049108176799e-11,  -6.060783062883883e-13,   4.505836350606811e-16,   8.417680590923132e-17,   3.413954858797464e-19,  -1.068216723197680e-20,  -1.044947751071581e-22,
   1.128820155112636e-24,   2.220493498263025e-26,   1.223480385487393e+00,  -8.924834613626791e-03,  -2.887797176152579e-05,   4.130609274964534e-07,   4.174018164458165e-09,
  -2.542958592108977e-11,  -6.058582680346000e-13,   4.517219840012164e-16,   8.413196416649958e-17,   3.408629082074673e-19,  -1.067520993677292e-20,  -1.043345227265212e-22,
   1.128232721557788e-24,   2.216640999987960e-26,   1.223475616497317e+00,  -8.924629766005658e-03,  -2.887383689432780e-05,   4.130188737637075e-07,   4.172519115032780e-09,
  -2.542798693558439e-11,  -6.054701026311180e-13,   4.537291618803558e-16,   8.405286404335163e-17,   3.399238361290995e-19,  -1.066293664226932e-20,  -1.040519830791985e-22,
   1.127195509621436e-24,   2.209849369995669e-26,   1.223469850087014e+00,  -8.924382071357951e-03,  -2.886883763006091e-05,   4.129680231264241e-07,   4.170706876659151e-09,
  -2.542605033166902e-11,  -6.050008917754715e-13,   4.561537802196796e-16,   8.395725596696165e-17,   3.387894412128366e-19,  -1.064810069675784e-20,  -1.037107219672871e-22,
   1.125940151756899e-24,   2.201647361128092e-26,   1.223464252473453e+00,  -8.924141623403988e-03,  -2.886398512328350e-05,   4.129186594508030e-07,   4.168948035335821e-09,
  -2.542416707259876e-11,  -6.045455605391794e-13,   4.585049595828728e-16,   8.386448384784516e-17,   3.376893843524946e-19,  -1.063370351241532e-20,  -1.033798384659236e-22,
   1.124720271318578e-24,   2.193695982094758e-26,   1.223459743336406e+00,  -8.923947928625116e-03,  -2.886007650298399e-05,   4.128788936069913e-07,   4.167531456790685e-09,
  -2.542264762534781e-11,  -6.041788737767229e-13,   4.603971786651131e-16,   8.378977831324323e-17,   3.368040478236054e-19,  -1.062210912367659e-20,  -1.031135743223799e-22,
   1.123736693720585e-24,   2.187298321851744e-26,   1.223456763890425e+00,  -8.923819941976422e-03,  -2.885749399917277e-05,   4.128526174825535e-07,   4.166595564140778e-09,
  -2.542164246718047e-11,  -6.039366334965497e-13,   4.616466128622446e-16,   8.374042914715620e-17,   3.362194515969092e-19,  -1.061444961747315e-20,  -1.029377742581132e-22,
   1.123086344203542e-24,   2.183074711383196e-26,   1.223455233836818e+00,  -8.923754215763142e-03,  -2.885616783499590e-05,   4.128391235705298e-07,   4.166114987099338e-09,
  -2.542112591963748e-11,  -6.038122500129682e-13,   4.622879756334054e-16,   8.371509060281423e-17,   3.359193627999317e-19,  -1.061051666973595e-20,  -1.028475365753790e-22,
   1.122752229259961e-24,   2.180906875241355e-26,   1.223454701293135e+00,  -8.923731339320626e-03,  -2.885570626336474e-05,   4.128344269123976e-07,   4.165947725598151e-09,
  -2.542094607470916e-11,  -6.037689601460003e-13,   4.625111630171922e-16,   8.370627202487421e-17,   3.358149347321981e-19,  -1.060914786284636e-20,  -1.028161355365391e-22,
   1.122635916921177e-24,   2.180152529408491e-26,   1.223454616786048e+00,  -8.923727709152231e-03,  -2.885563301887129e-05,   4.128336816184573e-07,   4.165921183868866e-09,
  -2.542091753314590e-11,  -6.037620907800462e-13,   4.625465776544809e-16,   8.370487267287296e-17,   3.357983644132592e-19,  -1.060893065639277e-20,  -1.028111529570332e-22,
   1.122617458778622e-24,   2.180032834103753e-26,   1.444708134933046e+00,  -7.504820172352169e-03,  -4.738719556835110e-05,   8.139330508668595e-08,   4.572236909719642e-09,
   2.932662778000241e-11,  -2.660934750666456e-13,  -5.928475628454794e-15,  -1.890160303831136e-17,   6.299275894555687e-19,   8.517593777443575e-21,  -1.071106075186443e-23,
  -1.362540629856691e-24,  -1.149317511945564e-26,   1.444703697550770e+00,  -7.504797184054356e-03,  -4.738462580589282e-05,   8.142070093142196e-08,   4.571862139587540e-09,
   2.931498990538156e-11,  -2.661423559372136e-13,  -5.926351162899957e-15,  -1.886593913018868e-17,   6.298691568157510e-19,   8.509202172067365e-21,  -1.079363155046321e-23,
  -1.361698095297972e-24,  -1.146643496760251e-26,   1.444695867915430e+00,  -7.504756614593347e-03,  -4.738009159106323e-05,   8.146903247130230e-08,   4.571200796188022e-09,
   2.929445809187777e-11,  -2.662285310554813e-13,  -5.922602672633579e-15,  -1.880303834990531e-17,   6.297657068680792e-19,   8.494399299850606e-21,  -1.093917049973110e-23,
  -1.360210580514857e-24,  -1.141928465566426e-26,   1.444686400570044e+00,  -7.504707546915869e-03,  -4.737460906240667e-05,   8.152746038193543e-08,   4.570400997930172e-09,
   2.926963659960493e-11,  -2.663326054755547e-13,  -5.918070236089749e-15,  -1.872702705975961e-17,   6.296400269082522e-19,   8.476506753823563e-21,  -1.111488759064223e-23,
  -1.358410416696937e-24,  -1.136232644096767e-26,   1.444677210184065e+00,  -7.504659901711272e-03,  -4.736928702466895e-05,   8.158416537191766e-08,   4.569624468477176e-09,
   2.924554639383706e-11,  -2.664335036119724e-13,  -5.913670517025811e-15,  -1.865328792030163e-17,   6.295174046715581e-19,   8.459144570687124e-21,  -1.128518796226690e-23,
  -1.356661339507633e-24,  -1.130709149775488e-26,   1.444669806778712e+00,  -7.504621511364440e-03,  -4.736499987966867e-05,   8.162983484516380e-08,   4.568998835461624e-09,
   2.922614398579475e-11,  -2.665146887845345e-13,  -5.910126370271666e-15,  -1.859392137952931e-17,   6.294181820517330e-19,   8.445163263143662e-21,  -1.142217726702217e-23,
  -1.355251227014892e-24,  -1.126263729172295e-26,   1.444664914862781e+00,  -7.504596139795722e-03,  -4.736216711805044e-05,   8.166000687305417e-08,   4.568585393574716e-09,
   2.921332534924682e-11,  -2.665682869953252e-13,  -5.907784564145261e-15,  -1.855471101760898e-17,   6.293524023682590e-19,   8.435927329492428e-21,  -1.151259827839921e-23,
  -1.354318922776932e-24,  -1.123328347672657e-26,   1.444662402667745e+00,  -7.504583109071662e-03,  -4.736071239264034e-05,   8.167549993789852e-08,   4.568373060645636e-09,
   2.920674302444289e-11,  -2.665957975530407e-13,  -5.906581966524386e-15,  -1.853458018361490e-17,   6.293185548532365e-19,   8.431185060133282e-21,  -1.155900316299509e-23,
  -1.353839977192452e-24,  -1.121821529962214e-26,   1.444661528281285e+00,  -7.504578573416270e-03,  -4.736020606742874e-05,   8.168089216795584e-08,   4.568299154516137e-09,
   2.920445209083472e-11,  -2.666053705165102e-13,  -5.906163396488580e-15,  -1.852757434805876e-17,   6.293067633318833e-19,   8.429534601134897e-21,  -1.157514993243614e-23,
  -1.353673249906973e-24,  -1.121297170327415e-26,   1.444661389528483e+00,  -7.504577853661085e-03,  -4.736012572084199e-05,   8.168174782764091e-08,   4.568287426550113e-09,
   2.920408855619844e-11,  -2.666068895029814e-13,  -5.906096975429758e-15,  -1.852646266048142e-17,   6.293048916774564e-19,   8.429272702255076e-21,  -1.157771197092717e-23,
  -1.353646791354378e-24,  -1.121213966520444e-26,   1.640649607047068e+00,  -5.494903814134822e-03,  -4.951701385489918e-05,  -2.121051326234573e-07,   1.537914035669254e-09,
   3.771789111768479e-11,   2.903131411331291e-13,  -7.225763077720566e-16,  -4.428701212271222e-17,  -4.788078725158489e-19,  -4.542904899227498e-22,   5.852094707920535e-23,
   8.447108834264013e-25,   3.152003905342475e-27,   1.640644966577372e+00,  -5.494963344081008e-03,  -4.951614648402142e-05,  -2.120697843707239e-07,   1.538320912446718e-09,
   3.771644298746411e-11,   2.901968523269704e-13,  -7.241843894240136e-16,  -4.428876176590519e-17,  -4.785052647220645e-19,  -4.490951062011912e-22,   5.854317193879716e-23,
   8.440374268785031e-25,   3.137054157748427e-27,   1.640636778461852e+00,  -5.495068377528647e-03,  -4.951461580869267e-05,  -2.120074129333666e-07,   1.539038719967056e-09,
   3.771388516886293e-11,   2.899916552631587e-13,  -7.270210438887009e-16,  -4.429183124697285e-17,  -4.779712161774055e-19,  -4.399311654523976e-22,   5.858229931251565e-23,
   8.428483865813987e-25,   3.110685185962127e-27,   1.640626877418067e+00,  -5.495195371320733e-03,  -4.951276458301921e-05,  -2.119319946200354e-07,   1.539906473789152e-09,
   3.771078784605110e-11,   2.897435226075567e-13,  -7.304497398362156e-16,  -4.429551256764127e-17,  -4.773252817918863e-19,  -4.288558225533167e-22,   5.862946128190257e-23,
   8.414093678627632e-25,   3.078816774069480e-27,   1.640617265774477e+00,  -5.495318640270986e-03,  -4.951096711357598e-05,  -2.118587818132090e-07,   1.540748636776349e-09,
   3.770777643186101e-11,   2.895026332888538e-13,  -7.337767744864559e-16,  -4.429905458036667e-17,  -4.766980555996832e-19,  -4.181101400111867e-22,   5.867508695070305e-23,
   8.400111195956517e-25,   3.047897541965784e-27,   1.640609522844185e+00,  -5.495417933799098e-03,  -4.950951885801144e-05,  -2.117998039524635e-07,   1.541426902226576e-09,
   3.770534719013022e-11,   2.893085714012738e-13,  -7.364559268814578e-16,  -4.430188523842581e-17,  -4.761926528645319e-19,  -4.094579082520617e-22,   5.871172897272857e-23,
   8.388837978372664e-25,   3.023002377057276e-27,   1.640604406495302e+00,  -5.495483540133332e-03,  -4.950856176023517e-05,  -2.117608331306068e-07,   1.541875004666660e-09,
   3.770374038207292e-11,   2.891803365274722e-13,  -7.382257422998481e-16,  -4.430374455498773e-17,  -4.758586343157221e-19,  -4.037427985766449e-22,   5.873588584802933e-23,
   8.381384382054585e-25,   3.006558451893193e-27,   1.640601779018182e+00,  -5.495517230560182e-03,  -4.950807020876829e-05,  -2.117408199648243e-07,   1.542105100953210e-09,
   3.770291471191143e-11,   2.891144810945960e-13,  -7.391344661376054e-16,  -4.430469596099637e-17,  -4.756870820692254e-19,  -4.008084755015963e-22,   5.874827439245979e-23,
   8.377555227288641e-25,   2.998115676883320e-27,   1.640600864502753e+00,  -5.495528956572637e-03,  -4.950789911405363e-05,  -2.117338542335836e-07,   1.542185183972278e-09,
   3.770262725067936e-11,   2.890915593985286e-13,  -7.394507301486828e-16,  -4.430502655865266e-17,  -4.756273689164070e-19,  -3.997872624461818e-22,   5.875258360609108e-23,
   8.376222235896676e-25,   2.995177405077888e-27,   1.640600719381846e+00,  -5.495530817317493e-03,  -4.950787196340698e-05,  -2.117327488696019e-07,   1.542197891849811e-09,
   3.770258163078243e-11,   2.890879220358476e-13,  -7.395009156742221e-16,  -4.430507899393731e-17,  -4.756178931274850e-19,  -3.996252149819287e-22,   5.875326728922202e-23,
   8.376010698126329e-25,   2.994711156687761e-27,   1.800995030544654e+00,  -3.330283808444589e-03,  -3.729304109153614e-05,  -3.039550635162943e-07,  -1.421467817306311e-09,
   5.993936177029065e-12,   2.243676979553120e-13,   2.759343027000686e-15,   1.785052303182829e-17,  -3.699617633189510e-20,  -2.712100958524897e-21,  -3.917214848162281e-23,
  -2.980906003639220e-25,   1.048827639285194e-28,   1.800991532727432e+00,  -3.330369275674719e-03,  -3.729383888122434e-05,  -3.039493985570419e-07,  -1.421151749897887e-09,
   5.999366541338371e-12,   2.244143177929270e-13,   2.759212901312486e-15,   1.783902267592345e-17,  -3.719811137215525e-20,  -2.713929198388068e-21,  -3.917102335251967e-23,
  -2.977417941352952e-25,   1.113731098057261e-28,   1.800985360713231e+00,  -3.330520082645835e-03,  -3.729524644902913e-05,  -3.039393985088420e-07,  -1.420593990768796e-09,
   6.008948293862795e-12,   2.244965546521779e-13,   2.758982738433169e-15,   1.781872386035555e-17,  -3.755442384920044e-20,  -2.717153396992003e-21,  -3.916899945293125e-23,
  -2.971258867758400e-25,   1.228258694758925e-28,   1.800977897344245e+00,  -3.330702437827680e-03,  -3.729694824840007e-05,  -3.039272992873704e-07,  -1.419919451754285e-09,
   6.020534291476765e-12,   2.245959544250221e-13,   2.758703478319687e-15,   1.779416765170860e-17,  -3.798527193384065e-20,  -2.721049130986580e-21,  -3.916648632833803e-23,
  -2.963803866619698e-25,   1.366754118316321e-28,   1.800970651926479e+00,  -3.330879462757196e-03,  -3.729860006745249e-05,  -3.039155461834108e-07,  -1.419264525982648e-09,
   6.031781399733247e-12,   2.246924060981945e-13,   2.758431388166978e-15,   1.777031774748908e-17,  -3.840352247158192e-20,  -2.724827897169048e-21,  -3.916397771943788e-23,
  -2.956558954044824e-25,   1.501210716984464e-28,   1.800964815034528e+00,  -3.331022070072295e-03,  -3.729993056630100e-05,  -3.039060727414700e-07,  -1.418736858267608e-09,
   6.040841652736283e-12,   2.247700748453280e-13,   2.758211487079843e-15,   1.775109658103949e-17,  -3.874045288483556e-20,  -2.727869767384031e-21,  -3.916190744068728e-23,
  -2.950717014517728e-25,   1.609532577620538e-28,   1.800960958082302e+00,  -3.331116301629723e-03,  -3.730080964560285e-05,  -3.038998102676398e-07,  -1.418388151539002e-09,
   6.046828373538878e-12,   2.248213815596919e-13,   2.758065833315918e-15,   1.773839166420363e-17,  -3.896308713945266e-20,  -2.729878676541350e-21,  -3.916051526094084e-23,
  -2.946854057804040e-25,   1.681112324018030e-28,   1.800958977341033e+00,  -3.331164693790894e-03,  -3.730126106685569e-05,  -3.038965933860390e-07,  -1.418209063651217e-09,
   6.049902799953107e-12,   2.248477252460253e-13,   2.757990925813417e-15,   1.773186587185705e-17,  -3.907741943408963e-20,  -2.730910005826954e-21,  -3.915979283311595e-23,
  -2.944869407818024e-25,   1.717872741317807e-28,   1.800958287924025e+00,  -3.331181537085567e-03,  -3.730141818369403e-05,  -3.038954735933170e-07,  -1.418146728832570e-09,
   6.050972875662505e-12,   2.248568936484171e-13,   2.757964836484903e-15,   1.772959431752113e-17,  -3.911721366869204e-20,  -2.731268915021762e-21,  -3.915954019514993e-23,
  -2.944178499012964e-25,   1.730667666611731e-28,   1.800958178522951e+00,  -3.331184209882554e-03,  -3.730144311576056e-05,  -3.038952958915754e-07,  -1.418136837077522e-09,
   6.051142681628802e-12,   2.248583485115793e-13,   2.757960695656635e-15,   1.772923384399206e-17,  -3.912352845769749e-20,  -2.731325866384879e-21,  -3.915950004847427e-23,
  -2.944068854977994e-25,   1.732698050979386e-28,   1.917468225203636e+00,  -1.467214281673926e-03,  -1.874364229914709e-05,  -1.998749644949233e-07,  -1.816992328120391e-09,
  -1.347826996314801e-11,  -6.618143090936132e-14,   1.204326966833490e-16,   8.435877294004480e-18,   1.345757161756697e-19,   1.495138775333289e-21,   1.227497262526756e-23,
   5.745275730150900e-26,  -3.266921645957494e-28,   1.917466465937832e+00,  -1.467270540897372e-03,  -1.874466487902945e-05,  -1.998875982865513e-07,  -1.817085131953089e-09,
  -1.347802560733762e-11,  -6.615915623860886e-14,   1.208885358074437e-16,   8.442196141454174e-18,   1.346389111620800e-19,   1.495489233806541e-21,   1.227247777833666e-23,
   5.734445392896423e-26,  -3.286091230944810e-28,   1.917463361607596e+00,  -1.467369814072143e-03,  -1.874646927972444e-05,  -1.999098906224842e-07,  -1.817248860260612e-09,
  -1.347759370723158e-11,  -6.611983873897519e-14,   1.216930444528808e-16,   8.453347044946607e-18,   1.347504091442749e-19,   1.496107076650396e-21,   1.226806416218341e-23,
   5.715318466125347e-26,  -3.319933277149649e-28,   1.917459607685223e+00,  -1.467489861183351e-03,  -1.874865125262139e-05,  -1.999368464320947e-07,  -1.817446798763282e-09,
  -1.347707020336706e-11,  -6.607227259044697e-14,   1.226661604417466e-16,   8.466832877589405e-18,   1.348852156478023e-19,   1.496853246169505e-21,   1.226270769226169e-23,
   5.692161629075784e-26,  -3.360884439415771e-28,   1.917455963302997e+00,  -1.467606406000991e-03,  -1.875076954983890e-05,  -1.999630143286354e-07,  -1.817638908452199e-09,
  -1.347656069021087e-11,  -6.602607210096194e-14,   1.236111540592440e-16,   8.479926826150666e-18,   1.350160645265105e-19,   1.497576637230107e-21,   1.225748731786133e-23,
   5.669651677113511e-26,  -3.400669475067680e-28,   1.917453027336210e+00,  -1.467700296687668e-03,  -1.875247607676142e-05,  -1.999840946041181e-07,  -1.817793636849656e-09,
  -1.347614929807810e-11,  -6.598883632125978e-14,   1.243726503376980e-16,   8.490476669877336e-18,   1.351214610805994e-19,   1.498158690847355e-21,   1.225326722499050e-23,
   5.651496672659756e-26,  -3.432741524985566e-28,   1.917451087252765e+00,  -1.467762339791069e-03,  -1.875360374590166e-05,  -1.999980239561618e-07,  -1.817895862618565e-09,
  -1.347587699963502e-11,  -6.596422312673981e-14,   1.248759420605721e-16,   8.497448566868461e-18,   1.351910985746550e-19,   1.498542958163496e-21,   1.225047149844864e-23,
   5.639489748636829e-26,  -3.453944806932326e-28,   1.917450090911964e+00,  -1.467794202453154e-03,  -1.875418286617256e-05,  -2.000051773082659e-07,  -1.817948355493337e-09,
  -1.347573701974630e-11,  -6.595158045884945e-14,   1.251344400097088e-16,   8.501029200853062e-18,   1.352268586941761e-19,   1.498740191589788e-21,   1.224903354292150e-23,
   5.633320395728105e-26,  -3.464836997456413e-28,   1.917449744124017e+00,  -1.467805292633608e-03,  -1.875438443559331e-05,  -2.000076670921344e-07,  -1.817966625331174e-09,
  -1.347568827591845e-11,  -6.594717964621943e-14,   1.252244179320620e-16,   8.502275510114121e-18,   1.352393050021668e-19,   1.498808823574574e-21,   1.224853269646580e-23,
   5.631172582834322e-26,  -3.468628647942685e-28,   1.917449689093432e+00,  -1.467807052496740e-03,  -1.875441642194638e-05,  -2.000080621862671e-07,  -1.817969524465415e-09,
  -1.347568053987394e-11,  -6.594648127810104e-14,   1.252386964428324e-16,   8.502473283976808e-18,   1.352412800442039e-19,   1.498819713722233e-21,   1.224845320227838e-23,
   5.630831730148431e-26,  -3.469230355521961e-28,   1.984170592227251e+00,  -2.908288100142987e-04,  -3.976683858057860e-06,  -4.782982370493780e-08,  -5.320935830823363e-10,
  -5.586934551095680e-12,  -5.583086338744345e-14,  -5.319586949941899e-16,  -4.816314881458890e-18,  -4.103585440538061e-20,  -3.222018548272112e-22,  -2.221509216944869e-24,
  -1.159335707729359e-26,  -9.767113969575618e-30,   1.984170218812136e+00,  -2.908422806079137e-04,  -3.976983604212575e-06,  -4.783507027194553e-08,  -5.321722449693351e-10,
  -5.587984051097546e-12,  -5.584353431666908e-14,  -5.320974893998643e-16,  -4.817676460740630e-18,  -4.104731137737723e-20,  -3.222732229767699e-22,  -2.221570829165207e-24,
  -1.158549563311621e-26,  -9.589782420866452e-30,   1.984169559892382e+00,  -2.908660508838241e-04,  -3.977512547034651e-06,  -4.784432872270836e-08,  -5.323110596061020e-10,
  -5.589836132690915e-12,  -5.586589527814454e-14,  -5.323424257541772e-16,  -4.820079233299861e-18,  -4.106752763321672e-20,  -3.223991134379887e-22,  -2.221678486542036e-24,
  -1.157160441535033e-26,  -9.276573964018120e-30,   1.984168763080511e+00,  -2.908947962043206e-04,  -3.978152211762477e-06,  -4.785552550573928e-08,  -5.324789404734963e-10,
  -5.592076068667549e-12,  -5.589293934960372e-14,  -5.326386590226096e-16,  -4.822985108344758e-18,  -4.109197376647369e-20,  -3.225512736647011e-22,  -2.221806861168108e-24,
  -1.155477360803908e-26,  -8.897320066164110e-30,   1.984167989508429e+00,  -2.909227038096191e-04,  -3.978773251527618e-06,  -4.786639657892089e-08,  -5.326419422087168e-10,
  -5.594250956800943e-12,  -5.591919845839452e-14,  -5.329262932941366e-16,  -4.825806517880665e-18,  -4.111570608613864e-20,  -3.226989170260518e-22,  -2.221929592407448e-24,
  -1.153839955175272e-26,  -8.528603211144195e-30,   1.984167366299506e+00,  -2.909451873510605e-04,  -3.979273599175393e-06,  -4.787515519882320e-08,  -5.327732728427494e-10,
  -5.596003302922012e-12,  -5.594035617557986e-14,  -5.331580479490090e-16,  -4.828079721266361e-18,  -4.113482484436380e-20,  -3.228178055563442e-22,  -2.222027105920924e-24,
  -1.152518372969358e-26,  -8.231179865900089e-30,   1.984166954479798e+00,  -2.909600448275832e-04,  -3.979604242555942e-06,  -4.788094324059921e-08,  -5.328600628724549e-10,
  -5.597161361345276e-12,  -5.595433864003718e-14,  -5.333112069924393e-16,  -4.829581966569252e-18,  -4.114745832995364e-20,  -3.228963399633643e-22,  -2.222090876152408e-24,
  -1.151643865535652e-26,  -8.034456837083996e-30,   1.984166742986234e+00,  -2.909676750855232e-04,  -3.979774050732362e-06,  -4.788391583218609e-08,  -5.329046365156618e-10,
  -5.597756122846417e-12,  -5.596151986802495e-14,  -5.333898675808550e-16,  -4.830353488721897e-18,  -4.115394627567679e-20,  -3.229366633974734e-22,  -2.222123419476006e-24,
  -1.151194383749887e-26,  -7.933371064277320e-30,   1.984166669373255e+00,  -2.909703309037446e-04,  -3.979833155134447e-06,  -4.788495049461689e-08,  -5.329201512277767e-10,
  -5.597963141893732e-12,  -5.596401944989466e-14,  -5.334172470887390e-16,  -4.830622031603650e-18,  -4.115620447196370e-20,  -3.229506971050416e-22,  -2.222134713714907e-24,
  -1.151037876928164e-26,  -7.898177827010267e-30,   1.984166657691856e+00,  -2.909707523472796e-04,  -3.979842534241813e-06,  -4.788511468246798e-08,  -5.329226132201573e-10,
  -5.597995993291106e-12,  -5.596441610337120e-14,  -5.334215918855997e-16,  -4.830664646018064e-18,  -4.115656281696315e-20,  -3.229529240026159e-22,  -2.222136504399538e-24,
  -1.151013038575273e-26,  -7.892592698261580e-30,   6.761541855095783e-03,  -1.247756003374297e-04,   1.720957200510360e-06,  -2.100514939981704e-08,   2.389710913921571e-10,
  -2.591922803886285e-12,   2.710195581370941e-14,  -2.748551502612602e-16,   2.711354918229638e-18,  -2.604442055672763e-20,   2.434257142588709e-22,  -2.208888663276634e-24,
   1.936921860741910e-26,  -1.628412709526265e-28,   6.761703464797552e-03,  -1.247815166001773e-04,   1.721091837137926e-06,  -2.100758388548285e-08,   2.390092878964859e-10,
  -2.592465327476015e-12,   2.710909440763011e-14,  -2.749433483091541e-16,   2.712385740983386e-18,  -2.605585668021675e-20,   2.435460747863634e-22,  -2.210084581556451e-24,
   1.938029844503418e-26,  -1.629344535029006e-28,   6.761988637950671e-03,  -1.247919564964832e-04,   1.721329423076654e-06,  -2.101187998774314e-08,   2.390766944001345e-10,
  -2.593422760216359e-12,   2.712169277136091e-14,  -2.750990065682181e-16,   2.714205057248112e-18,  -2.607604091895041e-20,   2.437585086213822e-22,  -2.212195352515112e-24,
   1.939985359464712e-26,  -1.630989000383705e-28,   6.762333489923954e-03,  -1.248045814814881e-04,   1.721616744359022e-06,  -2.101707558648450e-08,   2.391582169982933e-10,
  -2.594580739132191e-12,   2.713693060336824e-14,  -2.752872837746554e-16,   2.716405698754804e-18,  -2.610045647537050e-20,   2.440154810282548e-22,  -2.214748664606578e-24,
   1.942350773642670e-26,  -1.632977922154809e-28,   6.762668284629196e-03,  -1.248168385941937e-04,   1.721895702124011e-06,  -2.102212012320369e-08,   2.392373723189188e-10,
  -2.595705137453310e-12,   2.715172716090943e-14,  -2.754701161443833e-16,   2.718542781706497e-18,  -2.612416764014388e-20,   2.442650450465877e-22,  -2.217228365818536e-24,
   1.944647898324576e-26,  -1.634909168876448e-28,   6.762938004059278e-03,  -1.248267134783417e-04,   1.722120449255791e-06,  -2.102618446622615e-08,   2.393011492735991e-10,
  -2.596611119018165e-12,   2.716364989448517e-14,  -2.756174437398310e-16,   2.720264917027302e-18,  -2.614327547113240e-20,   2.444661619903351e-22,  -2.219226690311673e-24,
   1.946499020675774e-26,  -1.636465268110794e-28,   6.763116236302248e-03,  -1.248332389752701e-04,   1.722268969117518e-06,  -2.102887037114450e-08,   2.393432970701410e-10,
  -2.597209864082666e-12,   2.717152960503383e-14,  -2.757148148846519e-16,   2.721403132471363e-18,  -2.615590473188779e-20,   2.445990914569736e-22,  -2.220547494936885e-24,
   1.947722497512288e-26,  -1.637493663390727e-28,   6.763207769081431e-03,  -1.248365902382362e-04,   1.722345244562851e-06,  -2.103024979207984e-08,   2.393649435642251e-10,
  -2.597517375720884e-12,   2.717557664044044e-14,  -2.757648257179316e-16,   2.721987740703617e-18,  -2.616239143476035e-20,   2.446673679154809e-22,  -2.221225898754169e-24,
   1.948350900521676e-26,  -1.638021840746943e-28,   6.763239628220961e-03,  -1.248377566932051e-04,   1.722371793469806e-06,  -2.103072992494419e-08,   2.393724780768885e-10,
  -2.597624412324819e-12,   2.717698531616002e-14,  -2.757822334162605e-16,   2.722191231711853e-18,  -2.616464934604220e-20,   2.446911338843031e-22,  -2.221462040521331e-24,
   1.948569636130274e-26,  -1.638205685220180e-28,   6.763244683842706e-03,  -1.248379417943608e-04,   1.722376006441324e-06,  -2.103080611602377e-08,   2.393736737122525e-10,
  -2.597641397766821e-12,   2.717720885682364e-14,  -2.757849958242842e-16,   2.722223523538080e-18,  -2.616500765282205e-20,   2.446949052980045e-22,  -2.221499513779668e-24,
   1.948604347132349e-26,  -1.638234859162489e-28,   6.034491759404666e-02,  -1.084756089565380e-03,   1.417896809161969e-05,  -1.576480590965034e-07,   1.542938137248793e-09,
  -1.318050910805006e-11,   9.261563265675345e-14,  -4.180387129119571e-16,  -1.329002154236549e-18,   6.381878867957628e-20,  -1.008342716714600e-21,   1.168182962210817e-23,
  -1.074334856864866e-25,   7.275579262948317e-28,   6.034624861345358e-02,  -1.084800471545200e-03,   1.417983672752003e-05,  -1.576604226867734e-07,   1.543068335287850e-09,
  -1.318132866551598e-11,   9.261205566994958e-14,  -4.178217485573668e-16,  -1.333277490206260e-18,   6.387922882247745e-20,  -1.009008131391152e-21,   1.168712364897670e-23,
  -1.074480981245680e-25,   7.270848390583164e-28,   6.034859728446615e-02,  -1.084878787076204e-03,   1.418136950878590e-05,  -1.576822390602283e-07,   1.543298067655157e-09,
  -1.318277443952895e-11,   9.260573488324180e-14,  -4.174387455424708e-16,  -1.340823670762284e-18,   6.398589857290524e-20,  -1.010182338632664e-21,   1.169646220927526e-23,
  -1.074737963129184e-25,   7.262485138124123e-28,   6.035143743565036e-02,  -1.084973491877540e-03,   1.418322306581408e-05,  -1.577086207157698e-07,   1.543575855454771e-09,
  -1.318452209131309e-11,   9.259807613736032e-14,  -4.169753311225518e-16,  -1.349952485757851e-18,   6.411492256403911e-20,  -1.011602326028512e-21,   1.170774965865142e-23,
  -1.075047246289081e-25,   7.252345671153087e-28,   6.035419472369987e-02,  -1.085065434711621e-03,   1.418502257322684e-05,  -1.577342326839298e-07,   1.543845519667583e-09,
  -1.318621805956910e-11,   9.259062483674176e-14,  -4.165251599314013e-16,  -1.358818658096340e-18,   6.424021638329040e-20,  -1.012980954114207e-21,   1.171870224522566e-23,
  -1.075345960651300e-25,   7.242474651597422e-28,   6.035641604396284e-02,  -1.085139506283142e-03,   1.418647230918474e-05,  -1.577548661501611e-07,   1.544062752360360e-09,
  -1.318758386382821e-11,   9.258461046770636e-14,  -4.161622953995508e-16,  -1.365964052371276e-18,   6.434117979345037e-20,  -1.014091651063280e-21,   1.172752186540116e-23,
  -1.075585502197936e-25,   7.234502756548344e-28,   6.035788389437604e-02,  -1.085188453230588e-03,   1.418743030618296e-05,  -1.577685007676126e-07,   1.544206293261084e-09,
  -1.318848614465292e-11,   9.258063055084704e-14,  -4.159224169327550e-16,  -1.370687031947286e-18,   6.440790848873469e-20,  -1.014825624803930e-21,   1.173334792819556e-23,
  -1.075743248583875e-25,   7.229225307554728e-28,   6.035863771864876e-02,  -1.085213590378304e-03,   1.418792229501634e-05,  -1.577755029168300e-07,   1.544280007579385e-09,
  -1.318894944150395e-11,   9.257858490112061e-14,  -4.157991956811520e-16,  -1.373112950301649e-18,   6.444218115616381e-20,  -1.015202569327599e-21,   1.173633933765658e-23,
  -1.075824092316587e-25,   7.226512064803601e-28,   6.035890009613618e-02,  -1.085222339680036e-03,   1.418809353807188e-05,  -1.577779400982133e-07,   1.544305664395133e-09,
  -1.318911068546436e-11,   9.257787261187405e-14,  -4.157563022725376e-16,  -1.373957383825577e-18,   6.445411075476775e-20,  -1.015333770530039e-21,   1.173738043710339e-23,
  -1.075852204190620e-25,   7.225567214916016e-28,   6.035894173192705e-02,  -1.085223728077867e-03,   1.418812071207359e-05,  -1.577783268462460e-07,   1.544309735772372e-09,
  -1.318913627214977e-11,   9.257775956798654e-14,  -4.157494954360901e-16,  -1.374091387139409e-18,   6.445600385018476e-20,  -1.015354590458761e-21,   1.173754564106830e-23,
  -1.075856663898378e-25,   7.225417257419892e-28,   1.648160257999703e-01,  -2.808715345769034e-03,   3.274641238035437e-05,  -2.915705133473295e-07,   1.785447732689923e-09,
  -1.808294189616559e-12,  -1.392885687946080e-13,   2.356557527456971e-15,  -2.273106769359628e-17,   1.062877635865969e-19,   8.722386723964345e-22,  -2.715429582518757e-23,
   3.511985217177773e-25,  -2.601831993750659e-27,   1.648190977839563e-01,  -2.808797355640264e-03,   3.274741558273160e-05,  -2.915721695593262e-07,   1.785251153923649e-09,
  -1.803649086817322e-12,  -1.393481600773437e-13,   2.356912576094531e-15,  -2.272731807828996e-17,   1.061470173949376e-19,   8.744115988135863e-22,  -2.717314045381877e-23,
   3.511967995571604e-25,  -2.598555986567957e-27,   1.648245184244395e-01,  -2.808942063722302e-03,   3.274918565907073e-05,  -2.915750884293035e-07,   1.784904219493538e-09,
  -1.795452163248323e-12,  -1.394533017902291e-13,   2.357538678281063e-15,  -2.272069437027969e-17,   1.058985897103033e-19,   8.782457481001929e-22,  -2.720637254469420e-23,
   3.511933128422808e-25,  -2.592769698649716e-27,   1.648310732511147e-01,  -2.809117046918572e-03,   3.275132590074983e-05,  -2.915786119181188e-07,   1.784484586556244e-09,
  -1.785539390003940e-12,  -1.395804265480219e-13,   2.358295108197092e-15,  -2.271267220415110e-17,   1.055980539693237e-19,   8.828820177187773e-22,  -2.724652378162684e-23,
   3.511883327658018e-25,  -2.585763104796200e-27,   1.648374366998155e-01,  -2.809286918243268e-03,   3.275340344950900e-05,  -2.915820261347181e-07,   1.784077092575403e-09,
  -1.775915230613662e-12,  -1.397038226759717e-13,   2.359028746415844e-15,  -2.270487111687939e-17,   1.053061584765767e-19,   8.873828002115473e-22,  -2.728546694092786e-23,
   3.511826980674706e-25,  -2.578951016085290e-27,   1.648425631090834e-01,  -2.809423764850595e-03,   3.275507698052961e-05,  -2.915847720508532e-07,   1.783748733611059e-09,
  -1.768161409171993e-12,  -1.398032186743767e-13,   2.359619260699828e-15,  -2.269857712785288e-17,   1.050709105764052e-19,   8.910085507508900e-22,  -2.731681396933071e-23,
   3.511775854176602e-25,  -2.573455974506311e-27,   1.648459505968630e-01,  -2.809514190884373e-03,   3.275618276358195e-05,  -2.915865842840492e-07,   1.783531717206510e-09,
  -1.763037467856792e-12,  -1.398688927237499e-13,   2.360009219539359e-15,  -2.269441350366312e-17,   1.049154136760712e-19,   8.934043711242092e-22,  -2.733751524178889e-23,
   3.511739262635967e-25,  -2.569821370222537e-27,   1.648476902487238e-01,  -2.809560629051612e-03,   3.275675061863499e-05,  -2.915875142661552e-07,   1.783420255709372e-09,
  -1.760405969301903e-12,  -1.399026179261275e-13,   2.360209407061783e-15,  -2.269227383968803e-17,   1.048355433419657e-19,   8.946347360025717e-22,  -2.734814253451672e-23,
   3.511719602605095e-25,  -2.567953720525195e-27,   1.648482957528414e-01,  -2.809576792292473e-03,   3.275694826300760e-05,  -2.915878378456734e-07,   1.783381458414809e-09,
  -1.759490034698861e-12,  -1.399143560425373e-13,   2.360279072221021e-15,  -2.269152888020334e-17,   1.048077413156212e-19,   8.950629751949308e-22,  -2.735184085575622e-23,
   3.511712621471793e-25,  -2.567303491813145e-27,   1.648483918381175e-01,  -2.809579357176739e-03,   3.275697962631560e-05,  -2.915878891880991e-07,   1.783375301718807e-09,
  -1.759344687664305e-12,  -1.399162187081232e-13,   2.360290126555439e-15,  -2.269141065448145e-17,   1.048033294018153e-19,   8.951309308296309e-22,  -2.735242769966321e-23,
   3.511711507097314e-25,  -2.567200301110570e-27,   3.148749677996936e-01,  -4.941238619137873e-03,   4.751804783462455e-05,  -2.572286504405965e-07,  -6.354537605737919e-10,
   3.151581410836206e-11,  -3.365701546138117e-13,   8.957016397170132e-16,   2.783438790407556e-17,  -4.916570550962119e-19,   3.255080311818746e-21,   1.910371023257366e-23,
  -7.108741687955401e-25,   7.551869753438605e-27,   3.148794218849834e-01,  -4.941310860428693e-03,   4.751768772633751e-05,  -2.571990898441256e-07,  -6.359261936130965e-10,
   3.151755117135744e-11,  -3.364968092314474e-13,   8.940449320146690e-16,   2.784797870421486e-17,  -4.915564262037858e-19,   3.250678633541266e-21,   1.915841956720401e-23,
  -7.109439158359222e-25,   7.542574027987397e-27,   3.148872811609014e-01,  -4.941438324562978e-03,   4.751705209374447e-05,  -2.571469283899687e-07,  -6.367597251908469e-10,
   3.152061359595888e-11,  -3.363673612297314e-13,   8.911219228424343e-16,   2.787194478537348e-17,  -4.913786361199571e-19,   3.242911464871568e-21,   1.925489967504607e-23,
  -7.110658211499610e-25,   7.526163305465786e-27,   3.148967846341650e-01,  -4.941592444029769e-03,   4.751628311199625e-05,  -2.570838519586669e-07,  -6.377674973124644e-10,
   3.152431219369347e-11,  -3.362107820328395e-13,   8.875878627339444e-16,   2.790089908011029e-17,  -4.911632604528181e-19,   3.233518749040293e-21,   1.937147000190834e-23,
  -7.112112455242042e-25,   7.506305209987352e-27,   3.149060103921165e-01,  -4.941742048469866e-03,   4.751553621246718e-05,  -2.570226161032790e-07,  -6.387456750906355e-10,
   3.152789799668378e-11,  -3.360587260708929e-13,   8.841575550756136e-16,   2.792898044559970e-17,  -4.909537692841424e-19,   3.224399868708866e-21,   1.948453550719683e-23,
  -7.113503432906026e-25,   7.487012607137751e-27,   3.149134425073521e-01,  -4.941862559212690e-03,   4.751493424383472e-05,  -2.569732836136055e-07,  -6.395335749271645e-10,
   3.153078328299337e-11,  -3.359361948225585e-13,   8.813945001191840e-16,   2.795158310912779e-17,  -4.907847135928604e-19,   3.217053395023530e-21,   1.957554868039612e-23,
  -7.114609105428446e-25,   7.471460221244573e-27,   3.149183534993688e-01,  -4.941942186330092e-03,   4.751453633851701e-05,  -2.569406847607302e-07,  -6.400541524794382e-10,
   3.153268816909009e-11,  -3.358552102762928e-13,   8.795688972273917e-16,   2.796650908700457e-17,  -4.906728615288852e-19,   3.212198770780475e-21,   1.963565382381188e-23,
  -7.115332430285234e-25,   7.461178341682567e-27,   3.149208755233905e-01,  -4.941983077355282e-03,   4.751433195329706e-05,  -2.569239434357136e-07,  -6.403214776851236e-10,
   3.153366590599323e-11,  -3.358136152470607e-13,   8.786314168208253e-16,   2.797417136531998e-17,  -4.906153759072335e-19,   3.209705625764002e-21,   1.966650994460756e-23,
  -7.115701640097987e-25,   7.455896516847374e-27,   3.149217533360937e-01,  -4.941997309642574e-03,   4.751426080849507e-05,  -2.569181164237590e-07,  -6.404145200797152e-10,
   3.153400613456776e-11,  -3.357991368264761e-13,   8.783051267847795e-16,   2.797683782570690e-17,  -4.905953604690256e-19,   3.208837853778345e-21,   1.967724798897147e-23,
  -7.115829788458648e-25,   7.454057876746461e-27,   3.149218926328398e-01,  -4.941999568100658e-03,   4.751424951847892e-05,  -2.569171917552917e-07,  -6.404292845033130e-10,
   3.153406012027790e-11,  -3.357968392582934e-13,   8.782533494583517e-16,   2.797726093413642e-17,  -4.905921839603948e-19,   3.208700149839726e-21,   1.967895188749136e-23,
  -7.115850106820504e-25,   7.453766097896391e-27,   5.028052211815591e-01,  -7.035435185602506e-03,   4.950263373057477e-05,  -5.017803265951970e-09,  -4.017490402353305e-09,
   3.710740022946925e-11,   9.528058412379941e-14,  -5.402607977773168e-15,   4.181121292571744e-17,   2.956586414801390e-19,  -8.838448191029627e-21,   5.038456304886938e-23,
   7.552830844744478e-25,  -1.555568964940437e-26,   5.028098575094395e-01,  -7.035436474655861e-03,   4.950037466093964e-05,  -4.983104424052463e-09,  -4.017355126608020e-09,
   3.709677985837579e-11,   9.538957183649727e-14,  -5.401603491074994e-15,   4.177407679601296e-17,   2.959140547626365e-19,  -8.833754972594920e-21,   5.027179827177753e-23,
   7.557159688104562e-25,  -1.553782351440690e-26,   5.028180382109528e-01,  -7.035438741292198e-03,   4.949638855913573e-05,  -4.921885860539199e-09,  -4.017116306121009e-09,
   3.707804165726813e-11,   9.558180321117196e-14,  -5.399830360860260e-15,   4.170856562443576e-17,   2.963642638193739e-19,  -8.825471560793001e-21,   5.007292928129498e-23,
   7.564776562789799e-25,  -1.550629693347159e-26,   5.028279301094126e-01,  -7.035441468632494e-03,   4.949156862817945e-05,  -4.847873510827578e-09,  -4.016827309945655e-09,
   3.705538597152468e-11,   9.581411649433608e-14,  -5.397685084221187e-15,   4.162937629568592e-17,   2.969078574412201e-19,  -8.815451505286264e-21,   4.983263591451644e-23,
   7.573950442392230e-25,  -1.546817213337983e-26,   5.028375326861598e-01,  -7.035444102151179e-03,   4.948688963362287e-05,  -4.776038043998728e-09,  -4.016546535650155e-09,
   3.703339510183286e-11,   9.603950092111133e-14,  -5.395601243193258e-15,   4.155252944916148e-17,   2.974347271891234e-19,  -8.805720379821805e-21,   4.959955297025775e-23,
   7.582818068877433e-25,  -1.543115865292857e-26,   5.028452681771167e-01,  -7.035446213552280e-03,   4.948312037600856e-05,  -4.718178672341469e-09,  -4.016320188657816e-09,
   3.701568160584425e-11,   9.622096647378736e-14,  -5.393921637719567e-15,   4.149064325640938e-17,   2.978585639270846e-19,  -8.797878374832864e-21,   4.941192030357341e-23,
   7.589934354567360e-25,  -1.540133926216860e-26,   5.028503795440256e-01,  -7.035447603770377e-03,   4.948062975668848e-05,  -4.679951295755877e-09,  -4.016170544832370e-09,
   3.700397785345397e-11,   9.634082613152472e-14,  -5.392811348778925e-15,   4.144976006425994e-17,   2.981383327161676e-19,  -8.792695180266377e-21,   4.928800253304740e-23,
   7.594623283219374e-25,  -1.538163426857449e-26,   5.028530044421925e-01,  -7.035448316180636e-03,   4.947935071654897e-05,  -4.660321275246532e-09,  -4.016093671523009e-09,
   3.699796772907135e-11,   9.640236447987349e-14,  -5.392241027648531e-15,   4.142876771328899e-17,   2.982819161750582e-19,  -8.790032948824881e-21,   4.922438541120982e-23,
   7.597027134665457e-25,  -1.537151454542219e-26,   5.028539180567344e-01,  -7.035448563897464e-03,   4.947890553683446e-05,  -4.653489116221937e-09,  -4.016066911236163e-09,
   3.699587589999241e-11,   9.642378102661005e-14,  -5.392042500728430e-15,   4.142146163073244e-17,   2.983318771956410e-19,  -8.789106269088230e-21,   4.920224616617786e-23,
   7.597863158615656e-25,  -1.536799224104512e-26,   5.028540630345280e-01,  -7.035448603195125e-03,   4.947883489303600e-05,  -4.652404958517583e-09,  -4.016062664565492e-09,
   3.699554395788871e-11,   9.642717942184147e-14,  -5.392010996223243e-15,   4.142030227966763e-17,   2.983398046323970e-19,  -8.788959214658337e-21,   4.919873312845986e-23,
   7.597995792842298e-25,  -1.536743329785984e-26,   7.187659772905012e-01,  -8.641804215152267e-03,   3.490930976115882e-05,   3.386643508337423e-07,  -4.703953787175911e-09,
  -1.020674697121925e-11,   6.063024803990697e-13,  -2.173701088957634e-15,  -6.866902623306368e-17,   7.144078076868763e-19,   5.659398971557822e-21,  -1.416633339869369e-22,
   1.053561354226417e-26,   2.209757064144742e-26,   7.187692447299955e-01,  -8.641708999828085e-03,   3.490666859188311e-05,   3.386547464037334e-07,  -4.703103301076117e-09,
  -1.021098842698067e-11,   6.061227176572467e-13,  -2.171308821802443e-15,  -6.864515061060981e-17,   7.136835800115833e-19,   5.659409875153390e-21,  -1.415031871502168e-22,
   9.359618928530133e-27,   2.207142260100765e-26,   7.187750099777374e-01,  -8.641540993090431e-03,   3.490200859551474e-05,   3.386377960145310e-07,  -4.701602810276997e-09,
  -1.021846872272458e-11,   6.058055744202270e-13,  -2.167089611337383e-15,  -6.860302170874780e-17,   7.124063387337794e-19,   5.659423232716154e-21,  -1.412207607282834e-22,
   7.287616243759803e-27,   2.202530303793613e-26,   7.187819810348051e-01,  -8.641337841299442e-03,   3.489637434025230e-05,   3.386172939321037e-07,  -4.699788750790219e-09,
  -1.022750746557237e-11,   6.054221683015081e-13,  -2.161991076143137e-15,  -6.855207902055474e-17,   7.108630266362448e-19,   5.659429366026232e-21,  -1.408795122168088e-22,
   4.787338329830997e-27,   2.196956729460795e-26,   7.187887480581192e-01,  -8.641140628986209e-03,   3.489090539607249e-05,   3.385973851181051e-07,  -4.698028059727838e-09,
  -1.023627530550632e-11,   6.050500552496187e-13,  -2.157045043473075e-15,  -6.850262478971202e-17,   7.093660009782005e-19,   5.659424841950396e-21,  -1.405485109886256e-22,
   2.365561409181635e-27,   2.191549408087678e-26,   7.187941992274571e-01,  -8.640981760126759e-03,   3.488650018245008e-05,   3.385813427203363e-07,  -4.696609932454556e-09,
  -1.024333368224782e-11,   6.047503509946997e-13,  -2.153063117021259e-15,  -6.846278515196184e-17,   7.081608723972158e-19,   5.659413699267842e-21,  -1.402820590456858e-22,
   4.185097175344951e-28,   2.187195783692909e-26,   7.187978011373959e-01,  -8.640876783793256e-03,   3.488358953893214e-05,   3.385707401750350e-07,  -4.695672987752012e-09,
  -1.024799534273568e-11,   6.045523436761399e-13,  -2.150433170796712e-15,  -6.843645985728833e-17,   7.073649637705580e-19,   5.659402668897733e-21,  -1.401060894336694e-22,
  -8.661594048902121e-28,   2.184320183192982e-26,   7.187996508516373e-01,  -8.640822873849475e-03,   3.488209485941334e-05,   3.385652946378171e-07,  -4.695191861564135e-09,
  -1.025038858975801e-11,   6.044506673134631e-13,  -2.149082950906682e-15,  -6.842294056864819e-17,   7.069563561132594e-19,   5.659395870882687e-21,  -1.400157506365326e-22,
  -1.525308788191955e-27,   2.182843795036693e-26,   7.188002946554324e-01,  -8.640804110067736e-03,   3.488157463448996e-05,   3.385633991695680e-07,  -4.695024407516091e-09,
  -1.025122146371523e-11,   6.044152794955795e-13,  -2.148613055527757e-15,  -6.841823505808482e-17,   7.068141570905803e-19,   5.659393324405890e-21,  -1.399843121693362e-22,
  -1.754637922469084e-27,   2.182329983580970e-26,   7.188003968179343e-01,  -8.640801132517218e-03,   3.488149208252757e-05,   3.385630983801549e-07,  -4.694997835165272e-09,
  -1.025135362375984e-11,   6.044096640108439e-13,  -2.148538492499215e-15,  -6.841748835844422e-17,   7.067915930426484e-19,   5.659392911754015e-21,  -1.399793235444076e-22,
  -1.791024843247613e-27,   2.182248451578645e-26,   9.511986651606731e-01,  -9.402873133931450e-03,   7.307188808270624e-06,   5.498608555545668e-07,  -1.224698532466934e-09,
  -5.727976864750698e-11,   2.146645448217429e-13,   7.175249516396625e-15,  -3.863969383407167e-17,  -9.840480172813628e-19,   7.056949875224476e-21,   1.418126490800319e-22,
  -1.301898966387481e-24,  -2.101571082427745e-26,   9.511993488288173e-01,  -9.402718674574264e-03,   7.306501613283254e-06,   5.498072741534918e-07,  -1.224397852387065e-09,
  -5.726569488730720e-11,   2.145637246349386e-13,   7.171947244967415e-15,  -3.861017790873752e-17,  -9.833227009302639e-19,   7.048988213588757e-21,   1.416606571646139e-22,
  -1.299869185777526e-24,  -2.098510293847270e-26,   9.512005551198559e-01,  -9.402446140835703e-03,   7.305289184123939e-06,   5.497127396376726e-07,  -1.223867412675001e-09,
  -5.724086679197907e-11,   2.143858886627642e-13,   7.166122320843150e-15,  -3.855812381839324e-17,  -9.820435042330877e-19,   7.034949909007169e-21,   1.413926463638978e-22,
  -1.296291035343432e-24,  -2.093114213690872e-26,   9.512020136909437e-01,  -9.402116610973656e-03,   7.303823335742917e-06,   5.495984457485797e-07,  -1.223226195375604e-09,
  -5.721085338758683e-11,   2.141709546017619e-13,   7.159082145053898e-15,  -3.849522585193010e-17,  -9.804977688346516e-19,   7.017991974500954e-21,   1.410688738224164e-22,
  -1.291970139922303e-24,  -2.086597273784651e-26,   9.512034295533961e-01,  -9.401796730915847e-03,   7.302400560413548e-06,   5.494875103350268e-07,  -1.222603917978563e-09,
  -5.718172630953275e-11,   2.139624124357454e-13,   7.152251207165254e-15,  -3.843421414962093e-17,  -9.789983290221567e-19,   7.001547641547547e-21,   1.407548843618953e-22,
  -1.287781600991577e-24,  -2.080279171521076e-26,   9.512045700870675e-01,  -9.401539055339332e-03,   7.301254566551696e-06,   5.493981559022563e-07,  -1.222102766422100e-09,
  -5.715826865837509e-11,   2.137944938622419e-13,   7.146750829839288e-15,  -3.838509868355523e-17,  -9.777912113868144e-19,   6.988313284793381e-21,   1.405021700195178e-22,
  -1.284411742848449e-24,  -2.075195425110586e-26,   9.512053236987407e-01,  -9.401368795564921e-03,   7.300497400110311e-06,   5.493391187886763e-07,  -1.221771686369374e-09,
  -5.714277156169153e-11,   2.136835755547218e-13,   7.143117520435463e-15,  -3.835266107317176e-17,  -9.769939667390854e-19,   6.979574610662061e-21,   1.403352941549486e-22,
  -1.282187140580124e-24,  -2.071839128495436e-26,   9.512057107042943e-01,  -9.401281361391756e-03,   7.300108585472255e-06,   5.493088024790305e-07,  -1.221601683173699e-09,
  -5.713481408183070e-11,   2.136266258456786e-13,   7.141252026200703e-15,  -3.833600806824762e-17,  -9.765846662576787e-19,   6.975088847195055e-21,   1.402496304290213e-22,
  -1.281045362283454e-24,  -2.070116422182418e-26,   9.512058454035135e-01,  -9.401250929504005e-03,   7.299973259204753e-06,   5.492982509398353e-07,  -1.221542515546972e-09,
  -5.713204457058975e-11,   2.136068059117989e-13,   7.140602784972399e-15,  -3.833021267462984e-17,  -9.764422250219392e-19,   6.973527848704375e-21,   1.402198199578824e-22,
  -1.280648061153999e-24,  -2.069516963717205e-26,   9.512058667783482e-01,  -9.401246100400428e-03,   7.299951784990553e-06,   5.492965765715494e-07,  -1.221533126627642e-09,
  -5.713160509501213e-11,   2.136036608530592e-13,   7.140499762232549e-15,  -3.832929306522188e-17,  -9.764196224873578e-19,   6.973280154579111e-21,   1.402150897112186e-22,
  -1.280585019932944e-24,  -2.069421844808959e-26,   1.187354140637053e+00,  -9.135073344653331e-03,  -2.354182991952865e-05,   4.750333225938808e-07,   3.523431056975136e-09,
  -3.951238587171233e-11,  -5.545377666746875e-13,   3.250542173032202e-15,   8.784194863312256e-17,  -1.580143555966603e-19,  -1.371062359217484e-20,  -2.560291694137318e-23,
   2.068148881848685e-24,   1.179622511210439e-26,   1.187351937564519e+00,  -9.134939872069056e-03,  -2.353985237846429e-05,   4.749963335298090e-07,   3.522653950788645e-09,
  -3.950599492277578e-11,  -5.543083669563073e-13,   3.250005532841291e-15,   8.778451423095259e-17,  -1.581430873640069e-19,  -1.369794199604434e-20,  -2.551828718315735e-23,
   2.065661726911509e-24,   1.176658997953531e-26,   1.187348050358520e+00,  -9.134704366039269e-03,  -2.353636333083717e-05,   4.749310706118539e-07,   3.521282996480442e-09,
  -3.949471885325416e-11,  -5.539037098643123e-13,   3.249058271950729e-15,   8.768321371830247e-17,  -1.583698834896039e-19,  -1.367557759902900e-20,  -2.536913193106680e-23,
   2.061276028116627e-24,   1.171436464135383e-26,   1.187343350163484e+00,  -9.134419604030266e-03,  -2.353214494186304e-05,   4.748521622931933e-07,   3.519625670149081e-09,
  -3.948108517697341e-11,  -5.534146026874000e-13,   3.247912236425383e-15,   8.756079401634252e-17,  -1.586435262196272e-19,  -1.364855559863432e-20,  -2.518907041744893e-23,
   2.055977779552764e-24,   1.165132616884000e-26,   1.187338787563551e+00,  -9.134143177078115e-03,  -2.352805043599370e-05,   4.747755681534268e-07,   3.518017233638335e-09,
  -3.946785137723991e-11,  -5.529400041672583e-13,   3.246799060085507e-15,   8.744202850191229e-17,  -1.589085445287466e-19,  -1.362234536660787e-20,  -2.501458217604509e-23,
   2.050839548951138e-24,   1.159024765856043e-26,   1.187335112184416e+00,  -9.133920501922091e-03,  -2.352475240887071e-05,   4.747138711364927e-07,   3.516721832765496e-09,
  -3.945719150201309e-11,  -5.525578300973988e-13,   3.245901852565093e-15,   8.734640798789361e-17,  -1.591215893799472e-19,  -1.360124668341499e-20,  -2.487424028037291e-23,
   2.046703993225650e-24,   1.154112815339414e-26,   1.187332683653378e+00,  -9.133773367434360e-03,  -2.352257335334414e-05,   4.746731058950350e-07,   3.515866018770639e-09,
  -3.945014818594008e-11,  -5.523053727985893e-13,   3.245308775128091e-15,   8.728325078987903e-17,  -1.592621452508706e-19,  -1.358731284986567e-20,  -2.478161422041422e-23,
   2.043973120038304e-24,   1.150871221463798e-26,   1.187331436515563e+00,  -9.133697808470259e-03,  -2.352145437273010e-05,   4.746521719356622e-07,   3.515426567992134e-09,
  -3.944653127302521e-11,  -5.521757475551272e-13,   3.245004133905427e-15,   8.725082493598676e-17,  -1.593342593027605e-19,  -1.358015957121051e-20,  -2.473408010787324e-23,
   2.042571251237010e-24,   1.149207785959717e-26,   1.187331002442455e+00,  -9.133671509741219e-03,  -2.352106491221072e-05,   4.746448858294649e-07,   3.515273621188319e-09,
  -3.944527239993568e-11,  -5.521306340681958e-13,   3.244898089983609e-15,   8.723954015597115e-17,  -1.593593484186573e-19,  -1.357767019092474e-20,  -2.471754080405469e-23,
   2.042083407934073e-24,   1.148629015387988e-26,   1.187330933561250e+00,  -9.133667336507474e-03,  -2.352100311070894e-05,   4.746437296318815e-07,   3.515249351019785e-09,
  -3.944507263537542e-11,  -5.521234753579149e-13,   3.244881261763221e-15,   8.723774948019002e-17,  -1.593633292012638e-19,  -1.357727517877930e-20,  -2.471491649966011e-23,
   2.042005998191477e-24,   1.148537182123142e-26,   1.413938656329097e+00,  -7.878725171880164e-03,  -4.595346610851501e-05,   1.588369925460317e-07,   5.081205356701410e-09,
   2.090332793294836e-11,  -4.366920817952471e-13,  -6.106886320477759e-15,   9.605540484413157e-18,   9.400935444308452e-19,   6.430803059587074e-21,  -8.716701457233240e-23,
  -1.734503432717673e-24,  -1.228419368941725e-27,   1.413934353930673e+00,  -7.878680430413627e-03,  -4.595061140057844e-05,   1.588564887642011e-07,   5.080591565239064e-09,
   2.089135527890262e-11,  -4.366663150757153e-13,  -6.103725235981157e-15,   9.632329194732027e-18,   9.396438010594240e-19,   6.420175468226421e-21,  -8.717465895634587e-23,
  -1.732242979612999e-24,  -1.204075233987069e-27,   1.413926762498026e+00,  -7.878601478950399e-03,  -4.594557450406221e-05,   1.588908810384192e-07,   5.079508550207006e-09,
   2.087023439602575e-11,  -4.366207923290324e-13,  -6.098148686826399e-15,   9.679561937021923e-18,   9.388501911149669e-19,   6.401434268021807e-21,  -8.718800368958223e-23,
  -1.728256082252811e-24,  -1.161180853438192e-27,   1.413917583226639e+00,  -7.878506002425508e-03,  -4.593948431332426e-05,   1.589324530141366e-07,   5.078199007474508e-09,
   2.084470341412987e-11,  -4.365656486608118e-13,  -6.091407568421349e-15,   9.736614306032895e-18,   9.378904975728830e-19,   6.378791558607099e-21,  -8.720389516635661e-23,
  -1.723437996147488e-24,  -1.109416830837390e-27,   1.413908672536396e+00,  -7.878413307540326e-03,  -4.593357256248416e-05,   1.589727941093330e-07,   5.076927779118926e-09,
   2.081992739902396e-11,  -4.365120145522951e-13,  -6.084865611156658e-15,   9.791934900387214e-18,   9.369587898516968e-19,   6.356830663984517e-21,  -8.721906596974764e-23,
  -1.718763733070721e-24,  -1.059274356386369e-27,   1.413901494477861e+00,  -7.878338628067489e-03,  -4.592881049177505e-05,   1.590052807237113e-07,   5.075903732144991e-09,
   2.079997462515755e-11,  -4.364687348707833e-13,  -6.079597074518356e-15,   9.836454005279197e-18,   9.362081800193954e-19,   6.339153760724192e-21,  -8.723110390894085e-23,
  -1.715000394818388e-24,  -1.018958360249465e-27,   1.413896751480590e+00,  -7.878289278422226e-03,  -4.592566397600087e-05,   1.590267415978991e-07,   5.075227078797360e-09,
   2.078679335096018e-11,  -4.364401008314624e-13,  -6.076116492532031e-15,   9.865848704941164e-18,   9.357121718550468e-19,   6.327480279242711e-21,  -8.723896862663848e-23,
  -1.712514719261954e-24,  -9.923564936347491e-28,   1.413894315766586e+00,  -7.878263934158466e-03,  -4.592404814393696e-05,   1.590377610205092e-07,   5.074879590697792e-09,
   2.078002511414249e-11,  -4.364253848776498e-13,  -6.074329286256080e-15,   9.880937261751942e-18,   9.354574422218325e-19,   6.321487583629715e-21,  -8.724297980236777e-23,
  -1.711238537320762e-24,  -9.787069777267133e-28,   1.413893468000713e+00,  -7.878255112718524e-03,  -4.592348574744093e-05,   1.590415961507837e-07,   5.074758645201612e-09,
   2.077766952305528e-11,  -4.364202611035891e-13,  -6.073707270812608e-15,   9.886187853450826e-18,   9.353687803344032e-19,   6.319402120557322e-21,  -8.724437151537214e-23,
  -1.710794403274139e-24,  -9.739580192080331e-28,   1.413893333472263e+00,  -7.878253712871000e-03,  -4.592339650327317e-05,   1.590422047198156e-07,   5.074739452860696e-09,
   2.077729573058378e-11,  -4.364194479480660e-13,  -6.073608567335472e-15,   9.887020996937565e-18,   9.353547108709940e-19,   6.319071202881023e-21,  -8.724459215157298e-23,
  -1.710723927822719e-24,  -9.732045141569716e-28,   1.617862268766245e+00,  -5.900742914558084e-03,  -5.188854178506695e-05,  -1.810950413259006e-07,   2.359412970837709e-09,
   4.426656475267412e-11,   2.476568733904300e-13,  -2.413292181056019e-15,  -6.111887859224077e-17,  -4.331627328137193e-19,   3.045135920087710e-21,   1.005978626222612e-22,
   8.465109131803453e-25,  -4.048621964747350e-27,   1.617857406893171e+00,  -5.900793701412966e-03,  -5.188721266374872e-05,  -1.810535816656433e-07,   2.359759343925449e-09,
   4.426179058400733e-11,   2.474967058952081e-13,  -2.414740616688529e-15,  -6.110586619812335e-17,  -4.326452202068893e-19,   3.050302143096730e-21,   1.005673192354740e-22,
   8.449661090178339e-25,  -4.065669917751473e-27,   1.617848828143053e+00,  -5.900883306145664e-03,  -5.188486725028255e-05,  -1.809804290876894e-07,   2.360370341685895e-09,
   4.425336417643734e-11,   2.472141156964648e-13,  -2.417294985072307e-15,  -6.108288796713277e-17,  -4.317321900550487e-19,   3.059410258682527e-21,   1.005133240704466e-22,
   8.422407058360501e-25,  -4.095716164903935e-27,   1.617838454799667e+00,  -5.900991640996370e-03,  -5.188203088192905e-05,  -1.808919784247084e-07,   2.361108854694525e-09,
   4.424317093402550e-11,   2.468724521488363e-13,  -2.420381335215091e-15,  -6.105507235651694e-17,  -4.306283644577940e-19,   3.070410648858668e-21,   1.004478606766667e-22,
   8.389458513790410e-25,  -4.131988506797501e-27,   1.617828384718554e+00,  -5.901096793683346e-03,  -5.187927710266144e-05,  -1.808061185629056e-07,   2.361825463632204e-09,
   4.423327138642800e-11,   2.465408209072657e-13,  -2.423374977249043e-15,  -6.102803795842499e-17,  -4.295570206533136e-19,   3.081075773799924e-21,   1.003841301560453e-22,
   8.357480333853532e-25,  -4.167138347421262e-27,   1.617820272521917e+00,  -5.901181491204516e-03,  -5.187705849191699e-05,  -1.807369556407838e-07,   2.362402520408360e-09,
   4.422529348596457e-11,   2.462736988080011e-13,  -2.425784801488826e-15,  -6.100623685653797e-17,  -4.286941257710443e-19,   3.089657528008776e-21,   1.003326609863186e-22,
   8.331724663363130e-25,  -4.195409667459516e-27,   1.617814912190424e+00,  -5.901237451885579e-03,  -5.187559237458684e-05,  -1.806912562989543e-07,   2.362783714649781e-09,
   4.422002038583342e-11,   2.460972067803385e-13,  -2.427376281906199e-15,  -6.099182004606492e-17,  -4.281240214670782e-19,   3.095323336008253e-21,   1.002985881171835e-22,
   8.314708493747216e-25,  -4.214068853000510e-27,   1.617812159423368e+00,  -5.901266188538415e-03,  -5.187483942261358e-05,  -1.806677882070462e-07,   2.362979440693938e-09,
   4.421731194965448e-11,   2.460065750923724e-13,  -2.428193308488809e-15,  -6.098441291412684e-17,  -4.278312707819261e-19,   3.098231495918931e-21,   1.002810706090703e-22,
   8.305970718992320e-25,  -4.223644434586901e-27,   1.617811201300713e+00,  -5.901276190301543e-03,  -5.187457734591707e-05,  -1.806596200352679e-07,   2.363047559294340e-09,
   4.421636918249447e-11,   2.459750307653415e-13,  -2.428477638332308e-15,  -6.098183425128167e-17,  -4.277293802314736e-19,   3.099243468243792e-21,   1.002749703829595e-22,
   8.302929590761890e-25,  -4.226976220440270e-27,   1.617811049259992e+00,  -5.901277777429740e-03,  -5.187453575772368e-05,  -1.806583238642427e-07,   2.363058368510253e-09,
   4.421621957495292e-11,   2.459700251560004e-13,  -2.428522755486136e-15,  -6.098142502723890e-17,  -4.277132117946162e-19,   3.099404042951437e-21,   1.002740022140850e-22,
   8.302447011973283e-25,  -4.227504877555895e-27,   1.787053574795777e+00,  -3.643593472790959e-03,  -4.107198451612931e-05,  -3.254195368992932e-07,  -1.241157296508227e-09,
   1.236838038945380e-11,   3.092560889822040e-13,   3.284692881953750e-15,   1.411297562342895e-17,  -1.840429236167181e-19,  -4.735785957399502e-21,  -5.214688366375543e-23,
  -2.118957369333626e-25,   3.674020431355929e-27,   1.787049722908275e+00,  -3.643684955810602e-03,  -4.107268020825614e-05,  -3.254078872888310e-07,  -1.240721973412777e-09,
   1.237483710917547e-11,   3.092927218795220e-13,   3.284064761235030e-15,   1.409295574166816e-17,  -1.843107362895269e-19,  -4.737061211723316e-21,  -5.211948779660299e-23,
  -2.111224790686858e-25,   3.683631680958196e-27,   1.787042926139347e+00,  -3.643846376367180e-03,  -4.107390756879563e-05,  -3.253873264494280e-07,  -1.239953797231782e-09,
   1.238622908406505e-11,   3.093573184543227e-13,   3.282955698269032e-15,   1.405762600241259e-17,  -1.847831805840069e-19,  -4.739307525414489e-21,  -5.207109033662309e-23,
  -2.097577979762120e-25,   3.700582066985062e-27,   1.787034707323661e+00,  -3.644041563274276e-03,  -4.107539136667189e-05,  -3.253624556768562e-07,  -1.239024839265177e-09,
   1.240000266121122e-11,   3.094353564261602e-13,   3.281613356036625e-15,   1.401489750828797e-17,  -1.853542683770523e-19,  -4.742017153808141e-21,  -5.201247042068450e-23,
  -2.081071767053417e-25,   3.721063606111268e-27,   1.787026728545345e+00,  -3.644231042574481e-03,  -4.107683145632139e-05,  -3.253383027804132e-07,  -1.238122948516945e-09,
   1.241337200865518e-11,   3.095110379937274e-13,   3.280308923210766e-15,   1.397340969254167e-17,  -1.859084641251824e-19,  -4.744640661660010e-21,  -5.195546149035055e-23,
  -2.065043288828664e-25,   3.740930947509200e-27,   1.787020300877724e+00,  -3.644383681215938e-03,  -4.107799131898615e-05,  -3.253188392300881e-07,  -1.237396343756632e-09,
   1.242414088865367e-11,   3.095719513740162e-13,   3.279257150515236e-15,   1.393998211505664e-17,  -1.863547689840239e-19,  -4.746749143251781e-21,  -5.190946298023602e-23,
  -2.052127718463157e-25,   3.756924495010665e-27,   1.787016053556383e+00,  -3.644484540436908e-03,  -4.107875761079708e-05,  -3.253059749826887e-07,  -1.236916190188905e-09,
   1.243125613961229e-11,   3.096121750626171e-13,   3.278561698382570e-15,   1.391789106173183e-17,  -1.866496067459887e-19,  -4.748139950585898e-21,  -5.187903232446962e-23,
  -2.043591759240758e-25,   3.767487194944151e-27,   1.787013872343418e+00,  -3.644536335955010e-03,  -4.107915109971867e-05,  -3.252993676236165e-07,  -1.236669600292588e-09,
   1.243490996557651e-11,   3.096328235664345e-13,   3.278204408357138e-15,   1.390654541280344e-17,  -1.868009975984997e-19,  -4.748853442120302e-21,  -5.186339370138051e-23,
  -2.039207647930130e-25,   3.772909928550082e-27,   1.787013113150642e+00,  -3.644554363776974e-03,  -4.107928805099777e-05,  -3.252970677201472e-07,  -1.236583771137278e-09,
   1.243618168197811e-11,   3.096400091482688e-13,   3.278080027674132e-15,   1.390259632275986e-17,  -1.868536869965960e-19,  -4.749101659246790e-21,  -5.185794878040668e-23,
  -2.037681640261859e-25,   3.774797086973356e-27,   1.787012992677127e+00,  -3.644557224540123e-03,  -4.107930978298798e-05,  -3.252967027499428e-07,  -1.236570151171453e-09,
   1.243638348437606e-11,   3.096411493385257e-13,   3.278060289099033e-15,   1.390196965024346e-17,  -1.868620479087065e-19,  -4.749141042182889e-21,  -5.185708466312659e-23,
  -2.037439480180235e-25,   3.775096540030279e-27,   1.911283553870897e+00,  -1.627272679802165e-03,  -2.132574375761002e-05,  -2.311879086073827e-07,  -2.101989893923531e-09,
  -1.499073858107423e-11,  -5.821308267946376e-14,   4.805404923915103e-16,   1.449402314538309e-17,   2.059033147224097e-19,   2.085978782765116e-21,   1.425372713590785e-23,
   1.548302442297567e-26,  -1.439004770540054e-27,   1.911281552211872e+00,  -1.627337750745868e-03,  -2.132692658388938e-05,  -2.312019543387501e-07,  -2.102071303539319e-09,
  -1.498978143065757e-11,  -5.817485413148917e-14,   4.812373180228748e-16,   1.450282600137762e-17,   2.059763919033485e-19,   2.086063012136904e-21,   1.424300384593926e-23,
   1.523367610023217e-26,  -1.442637535865547e-27,   1.911278020162772e+00,  -1.627452572661697e-03,  -2.132901373662185e-05,  -2.312267375201357e-07,  -2.102214908311531e-09,
  -1.498809140738732e-11,  -5.810738046811075e-14,   4.824670780373674e-16,   1.451835905820608e-17,   2.061052925824601e-19,   2.086210378997043e-21,   1.422406081276504e-23,
   1.479343869389439e-26,  -1.449049235726847e-27,   1.911273749017355e+00,  -1.627591422025746e-03,  -2.133153760734454e-05,  -2.312567043581820e-07,  -2.102388482080776e-09,
  -1.498604590958368e-11,  -5.802575855608061e-14,   4.839544583028623e-16,   1.453714226915126e-17,   2.062610836035773e-19,   2.086386432073097e-21,   1.420111782529432e-23,
   1.426065845565864e-26,  -1.456805104049797e-27,   1.911269602502145e+00,  -1.627726220319802e-03,  -2.133398780366394e-05,  -2.312857943364353e-07,  -2.102556906293946e-09,
  -1.498405818200348e-11,  -5.794648786704265e-14,   4.853987386329220e-16,   1.455537717639605e-17,   2.064122420572146e-19,   2.086555094510888e-21,   1.417880655254878e-23,
   1.374298347237546e-26,  -1.464337264783463e-27,   1.911266262007933e+00,  -1.627834816181489e-03,  -2.133596169745444e-05,  -2.313092279059202e-07,  -2.102692530608397e-09,
  -1.498245546582288e-11,  -5.788260439219685e-14,   4.865624880232843e-16,   1.457006732981956e-17,   2.065339554123440e-19,   2.086689356123169e-21,   1.416080520602338e-23,
   1.332562089432804e-26,  -1.470407148305510e-27,   1.911264054612323e+00,  -1.627906576404167e-03,  -2.133726603455971e-05,  -2.313247119313632e-07,  -2.102782121294635e-09,
  -1.498139571991690e-11,  -5.784037955995501e-14,   4.873315981725567e-16,   1.457977449145151e-17,   2.066143530428525e-19,   2.086777284862567e-21,   1.414889668394214e-23,
   1.304967342072538e-26,  -1.474419032629276e-27,   1.911262920991569e+00,  -1.627943429334285e-03,  -2.133793588126340e-05,  -2.313326635770635e-07,  -2.102828121910113e-09,
  -1.498085127331083e-11,  -5.781869144816929e-14,   4.877266117732908e-16,   1.458475963574827e-17,   2.066556322894639e-19,   2.086822196420956e-21,   1.414277689615805e-23,
   1.290791118290453e-26,  -1.476479640288470e-27,   1.911262526421701e+00,  -1.627956256433151e-03,  -2.133816902868744e-05,  -2.313354311975183e-07,  -2.102844131494083e-09,
  -1.498066173923477e-11,  -5.781114212274566e-14,   4.878641060410876e-16,   1.458649476918363e-17,   2.066699985104911e-19,   2.086837789439882e-21,   1.414064618057607e-23,
   1.285856157723832e-26,  -1.477196903472345e-27,   1.911262463808765e+00,  -1.627958291921786e-03,  -2.133820602602701e-05,  -2.313358703796928e-07,  -2.102846671930409e-09,
  -1.498063166115178e-11,  -5.780994412126104e-14,   4.878859247805225e-16,   1.458677011135726e-17,   2.066722781654999e-19,   2.086840261992287e-21,   1.414030803367332e-23,
   1.285073009656964e-26,  -1.477310725625752e-27,   1.982939798830639e+00,  -3.250918334894156e-04,  -4.605660564432983e-06,  -5.731542997834086e-08,  -6.585343030441843e-10,
  -7.124488050820948e-12,  -7.312439156230594e-14,  -7.124058239916649e-16,  -6.550638399463303e-18,  -5.604211555986592e-20,  -4.320711471689662e-22,  -2.761572495638003e-24,
  -1.013390462262759e-26,   8.142154836902058e-29,   1.982939366306020e+00,  -3.251079769930434e-04,  -4.606031570959546e-06,  -5.732212099340839e-08,  -6.586373378741074e-10,
  -7.125893612304859e-12,  -7.314162464714711e-14,  -7.125953362231297e-16,  -6.552463173223306e-18,  -5.605633068229215e-20,  -4.321328032792152e-22,  -2.760953957027207e-24,
  -1.011136638188458e-26,   8.184003810687378e-29,   1.982938603081165e+00,  -3.251364639915968e-04,  -4.606686264989520e-06,  -5.733392846717048e-08,  -6.588191641723570e-10,
  -7.128374051208581e-12,  -7.317203659242446e-14,  -7.129297725287655e-16,  -6.555683225827152e-18,  -5.608141087311323e-20,  -4.322414826002079e-22,  -2.759860039161102e-24,
  -1.007155397926474e-26,   8.257912049315458e-29,   1.982937680133159e+00,  -3.251709133877238e-04,  -4.607478008453152e-06,  -5.734820801931702e-08,  -6.590390641021418e-10,
  -7.131373942060348e-12,  -7.320881768485475e-14,  -7.133342429623181e-16,  -6.559577306659132e-18,  -5.611173363958858e-20,  -4.323727045137540e-22,  -2.758533002157750e-24,
  -1.002333848718855e-26,   8.347393680984235e-29,   1.982936784100569e+00,  -3.252043590018019e-04,  -4.608246703554367e-06,  -5.736207227657942e-08,  -6.592525743655170e-10,
  -7.134286726280008e-12,  -7.324453108986174e-14,  -7.137269654682198e-16,  -6.563357988333694e-18,  -5.614116576813547e-20,  -4.324998888342663e-22,  -2.757240273363558e-24,
  -9.976454271997665e-27,   8.434377210610940e-29,   1.982936062232080e+00,  -3.252313043145111e-04,  -4.608866014703304e-06,  -5.737324251432548e-08,  -6.594246006934831e-10,
  -7.136633615826447e-12,  -7.327330632956463e-14,  -7.140433874830676e-16,  -6.566403925063865e-18,  -5.616487254255916e-20,  -4.326022008257054e-22,  -2.756195666853886e-24,
  -9.938629427944834e-27,   8.504533398195533e-29,   1.982935585216474e+00,  -3.252491102573350e-04,  -4.609275274039916e-06,  -5.738062428045703e-08,  -6.595382849840053e-10,
  -7.138184588845846e-12,  -7.329232293628372e-14,  -7.142524979301628e-16,  -6.568416757278434e-18,  -5.618053590628918e-20,  -4.326697352060306e-22,  -2.755503841219204e-24,
  -9.913608240801621e-27,   8.550932206476500e-29,   1.982935340240641e+00,  -3.252582547579219e-04,  -4.609485457434423e-06,  -5.738441537841079e-08,  -6.595966711287041e-10,
  -7.138981146531862e-12,  -7.330208962865123e-14,  -7.143598937009733e-16,  -6.569450483573183e-18,  -5.618857928204344e-20,  -4.327043951992366e-22,  -2.755148070447834e-24,
  -9.900750247680995e-27,   8.574772852064032e-29,   1.982935254973684e+00,  -3.252614376323722e-04,  -4.609558615145274e-06,  -5.738573493786103e-08,  -6.596169935695269e-10,
  -7.139258405095121e-12,  -7.330548913555459e-14,  -7.143972749845458e-16,  -6.569810287945073e-18,  -5.619137877123454e-20,  -4.327164554011316e-22,  -2.755024163909147e-24,
  -9.896273565253025e-27,   8.583072819375555e-29,   1.982935241442950e+00,  -3.252619427129567e-04,  -4.609570224335544e-06,  -5.738594433534340e-08,  -6.596202184898869e-10,
  -7.139302402655280e-12,  -7.330602859618693e-14,  -7.144032069364890e-16,  -6.569867384250622e-18,  -5.619182300774865e-20,  -4.327183690216578e-22,  -2.755004497979597e-24,
  -9.895563113777470e-27,   8.584390005416679e-29,   6.288465222487925e-03,  -1.119549121935562e-04,   1.490233694235261e-06,  -1.756342933758796e-08,   1.930609570651173e-10,
  -2.024826511368375e-12,   2.049211876955511e-14,  -2.013890165148073e-16,   1.927884708374171e-18,  -1.800520991941551e-20,   1.640064401722720e-22,  -1.455263458724585e-24,
   1.253533753372390e-26,  -1.042888201115679e-28,   6.288605149955481e-03,  -1.119598585972159e-04,   1.490342453844321e-06,  -1.756533095138135e-08,   1.930898340900116e-10,
  -2.025223965369063e-12,   2.049719380610208e-14,  -2.014499804805827e-16,   1.928579115300987e-18,  -1.801274343194656e-20,   1.640843320155605e-22,  -1.456029456011646e-24,
   1.254244564630297e-26,  -1.043501616526157e-28,   6.288852062486045e-03,  -1.119685870398204e-04,   1.490534375108426e-06,  -1.756868668212114e-08,   1.931407938633632e-10,
  -2.025925376892384e-12,   2.050615027154259e-14,  -2.015575730519427e-16,   1.929804674714135e-18,  -1.802603964809493e-20,   1.642218091939838e-22,  -1.457381435300614e-24,
   1.255499131509199e-26,  -1.044584238020457e-28,   6.289150645930830e-03,  -1.119791423085437e-04,   1.490766470899639e-06,  -1.757274498476510e-08,   1.932024248711678e-10,
  -2.026773697787023e-12,   2.051698305532753e-14,  -2.016877104310250e-16,   1.931287090388144e-18,  -1.804212305723043e-20,   1.643881091128043e-22,  -1.459016885598994e-24,
   1.257016728592405e-26,  -1.045893765246709e-28,   6.289440520415053e-03,  -1.119893899584836e-04,   1.490991809090638e-06,  -1.757668525637302e-08,   1.932622655610270e-10,
  -2.027597407503820e-12,   2.052750198428478e-14,  -2.018140825113585e-16,   1.932726671633757e-18,  -1.805774229498151e-20,   1.645496141364029e-22,  -1.460605204436718e-24,
   1.258490573524819e-26,  -1.047165460600955e-28,   6.289674050166604e-03,  -1.119976458893283e-04,   1.491173355528282e-06,  -1.757985987607673e-08,   1.933104798768032e-10,
  -2.028261102372366e-12,   2.053597779571187e-14,  -2.019159127069270e-16,   1.933886721960817e-18,  -1.807032906527045e-20,   1.646797663069272e-22,  -1.461885200679651e-24,
   1.259678305139306e-26,  -1.048190229145483e-28,   6.289828367674563e-03,  -1.120031015342530e-04,   1.491293326465993e-06,  -1.758195779828468e-08,   1.933423426781848e-10,
  -2.028699721345858e-12,   2.054157939088190e-14,  -2.019832132590589e-16,   1.934653430228645e-18,  -1.807864819428223e-20,   1.647657909833292e-22,  -1.462731228204777e-24,
   1.260463343327759e-26,  -1.048867528382258e-28,   6.289907618709496e-03,  -1.120059033533644e-04,   1.491354939845525e-06,  -1.758303524050264e-08,   1.933587068771987e-10,
  -2.028924992112879e-12,   2.054445636566048e-14,  -2.020177793252630e-16,   1.935047223472094e-18,  -1.808292108845726e-20,   1.648099757116647e-22,  -1.463165774589088e-24,
   1.260866561802397e-26,  -1.049215400466628e-28,   6.289935203014406e-03,  -1.120068785656012e-04,   1.491376385354494e-06,  -1.758341026349209e-08,   1.933644027657811e-10,
  -2.029003402681259e-12,   2.054545776887285e-14,  -2.020298109999843e-16,   1.935184295073850e-18,  -1.808440840765372e-20,   1.648253557160680e-22,  -1.463317033704833e-24,
   1.261006915842727e-26,  -1.049336487936643e-28,   6.289939580275872e-03,  -1.120070333189903e-04,   1.491379788480783e-06,  -1.758346977491990e-08,   1.933653066333641e-10,
  -2.029015845501704e-12,   2.054561667994515e-14,  -2.020317202913879e-16,   1.935206046841272e-18,  -1.808464442943831e-20,   1.648277963634129e-22,  -1.463341036978233e-24,
   1.261029188578162e-26,  -1.049355703202034e-28,   5.622134251125092e-02,  -9.784910422526382e-04,   1.242699448807536e-05,  -1.349532011199552e-07,   1.300590829076899e-09,
  -1.110113275082845e-11,   8.061044365113863e-14,  -4.306716467539315e-16,   3.534853532248285e-19,   3.237747952961723e-20,  -5.950196505383011e-22,   7.378585683376918e-24,
  -7.317083696432015e-26,   5.788470246658915e-28,   5.622250900960684e-02,  -9.785290344505450e-04,   1.242772670891393e-05,  -1.349636155237893e-07,   1.300704197565660e-09,
  -1.110197887773845e-11,   8.061131935886077e-14,  -4.305613762571230e-16,   3.509605172226376e-19,   3.241568988671192e-20,  -5.954735964782194e-22,   7.382816353551631e-24,
  -7.319682721172340e-26,   5.788092255702480e-28,   5.622456737022358e-02,  -9.785960746650129e-04,   1.242901877596967e-05,  -1.349819925478368e-07,   1.300904239031211e-09,
  -1.110347170501421e-11,   8.061285916173558e-14,  -4.303666972618659e-16,   3.465038462828814e-19,   3.248313039688031e-20,  -5.962747216519443e-22,   7.390281203840962e-24,
  -7.324265727979550e-26,   5.787418481076146e-28,   5.622705645721961e-02,  -9.786771444729532e-04,   1.243058124569663e-05,  -1.350042153407503e-07,   1.301146132981713e-09,
  -1.110527654584616e-11,   8.061471190290894e-14,  -4.301311103266866e-16,   3.411121351786599e-19,   3.256471041955050e-20,  -5.972436730470070e-22,   7.399307379164043e-24,
  -7.329802405858396e-26,   5.786592137489916e-28,   5.622947291963800e-02,  -9.787558498954281e-04,   1.243209815687319e-05,  -1.350257899942695e-07,   1.301380961188255e-09,
  -1.110702833783226e-11,   8.061650086976335e-14,  -4.299022191036806e-16,   3.358751726079295e-19,   3.264393855664508e-20,  -5.981845469205049e-22,   7.408069410033866e-24,
  -7.335171924770523e-26,   5.785777772170504e-28,   5.623141966188171e-02,  -9.788192570099456e-04,   1.243332022714719e-05,  -1.350431710790689e-07,   1.301570136985292e-09,
  -1.110843933197855e-11,   8.061793512753863e-14,  -4.297176929347680e-16,   3.316543495495294e-19,   3.270778639956602e-20,  -5.989426692636702e-22,   7.415127681942936e-24,
  -7.339493671338056e-26,   5.785113007077041e-28,   5.623270606950768e-02,  -9.788611567949203e-04,   1.243412778190422e-05,  -1.350546565939335e-07,   1.301695141591310e-09,
  -1.110937158073617e-11,   8.061887947505627e-14,  -4.295956955232305e-16,   3.288643283800941e-19,   3.274998702418647e-20,  -5.994437045298595e-22,   7.419791511342880e-24,
  -7.342347508729744e-26,   5.784669468473221e-28,   5.623336671220994e-02,  -9.788826748011485e-04,   1.243454250996001e-05,  -1.350605550802074e-07,   1.301759337625883e-09,
  -1.110985030073114e-11,   8.061936339583684e-14,  -4.295330236612436e-16,   3.274312170016508e-19,   3.277166249917600e-20,  -5.997010353176994e-22,   7.422186564001321e-24,
  -7.343812504107246e-26,   5.784440367936144e-28,   5.623359665667724e-02,  -9.788901644137938e-04,   1.243468686145745e-05,  -1.350626081222441e-07,   1.301781681673527e-09,
  -1.111001691814025e-11,   8.061953166221967e-14,  -4.295112069051651e-16,   3.269323613797870e-19,   3.277920739359932e-20,  -5.997906056669208e-22,   7.423020176527489e-24,
  -7.344322315729843e-26,   5.784360416842914e-28,   5.623363314577924e-02,  -9.788913529156624e-04,   1.243470976812799e-05,  -1.350629339126837e-07,   1.301785227367580e-09,
  -1.111004335776873e-11,   8.061955835586422e-14,  -4.295077447325951e-16,   3.268531975802737e-19,   3.278040469039517e-20,  -5.998048194382045e-22,   7.423152458998971e-24,
  -7.344403211376747e-26,   5.784347719708847e-28,   1.540836282864341e-01,  -2.560257612705819e-03,   2.941724521513251e-05,  -2.634533061346152e-07,   1.720788175378435e-09,
  -4.437888418705421e-12,  -8.287739935281847e-14,   1.695059207463119e-15,  -1.852297336633513e-17,   1.217677245743239e-19,   1.488263044436554e-24,  -1.344473559927881e-23,
   2.235446552190662e-25,  -2.208481757840566e-27,   1.540863880895091e-01,  -2.560331723352352e-03,   2.941821249516165e-05,  -2.634574385278453e-07,   1.720671054271862e-09,
  -4.434544773646579e-12,  -8.292602087506128e-14,   1.695468346770728e-15,  -1.852292245319687e-17,   1.216977737491211e-19,   2.875778321359610e-24,  -1.346084460684020e-23,
   2.236385144151707e-25,  -2.207753373233082e-27,   1.540912578791710e-01,  -2.560462493696033e-03,   2.941991922231917e-05,  -2.634647276503210e-07,   1.720464336645874e-09,
  -4.428644205281982e-12,  -8.301181418151313e-14,   1.696190087128593e-15,  -1.852282785337683e-17,   1.215742769277068e-19,   5.324540804225107e-24,  -1.348926482529166e-23,
   2.238039277352562e-25,  -2.206464499991760e-27,   1.540971466065579e-01,  -2.560620624198614e-03,   2.942198292350313e-05,  -2.634735373861347e-07,   1.720214276696782e-09,
  -4.421508059959394e-12,  -8.311555612814363e-14,   1.697062495118471e-15,  -1.852270534021512e-17,   1.214248281884800e-19,   8.286411165067799e-24,  -1.352362337609080e-23,
   2.240036014711928e-25,  -2.204899795468229e-27,   1.541028634127961e-01,  -2.560774136234347e-03,   2.942398623301801e-05,  -2.634820851705382e-07,   1.719971423566777e-09,
  -4.414579246246848e-12,  -8.321626675794142e-14,   1.697909069883572e-15,  -1.852257789982386e-17,   1.212796254624069e-19,   1.116258113206750e-23,  -1.355697020956813e-23,
   2.241970789055375e-25,  -2.203374329464758e-27,   1.541074688918651e-01,  -2.560897804738143e-03,   2.942560000440414e-05,  -2.634889678908137e-07,   1.719775713124050e-09,
  -4.408996647804634e-12,  -8.329739774179350e-14,   1.698590813052448e-15,  -1.852246913946608e-17,   1.211625657245894e-19,   1.348018568448978e-23,  -1.358382834510253e-23,
   2.243526820066997e-25,  -2.202140791890452e-27,   1.541105121565655e-01,  -2.560979523271837e-03,   2.942666632214093e-05,  -2.634935142716530e-07,   1.719646356328026e-09,
  -4.405307356844241e-12,  -8.335100755516644e-14,   1.699041176077927e-15,  -1.852239428737855e-17,   1.210851724801138e-19,   1.501191072906468e-23,  -1.360157295581660e-23,
   2.244553744903261e-25,  -2.201323419156054e-27,   1.541120750328839e-01,  -2.561021489831244e-03,   2.942721391691326e-05,  -2.634958485614944e-07,   1.719579914654778e-09,
  -4.403412602827872e-12,  -8.337853872940833e-14,   1.699272421698338e-15,  -1.852235492397030e-17,   1.210454142791564e-19,   1.579861546370742e-23,  -1.361068480566864e-23,
   2.245080726195389e-25,  -2.200902956126505e-27,   1.541126190085723e-01,  -2.561036096705578e-03,   2.942740451063157e-05,  -2.634966609537619e-07,   1.719556787307512e-09,
  -4.402753096190255e-12,  -8.338812120189239e-14,   1.699352902908395e-15,  -1.852234107618062e-17,   1.210315739930558e-19,   1.607244967523636e-23,  -1.361385613194818e-23,
   2.245264084162207e-25,  -2.200756498192352e-27,   1.541127053301302e-01,  -2.561038414616743e-03,   2.942743475515111e-05,  -2.634967898654906e-07,   1.719553117234626e-09,
  -4.402648440613160e-12,  -8.338964180807313e-14,   1.699365673885740e-15,  -1.852233887174862e-17,   1.210293776315129e-19,   1.611590407796457e-23,  -1.361435937127010e-23,
   2.245293177569564e-25,  -2.200733252021661e-27,   2.958505683221833e-01,  -4.573568953501014e-03,   4.438970645257397e-05,  -2.627821303321896e-07,  -8.342872246679843e-11,
   2.382430967410186e-11,  -3.014955806220348e-13,   1.529436053916826e-15,   1.259959934467627e-17,  -3.533236091419401e-19,   3.478660034442752e-21,  -6.081074350341077e-24,
  -3.528112442346794e-25,   5.932364528412705e-27,   2.958547297499410e-01,  -4.573642782064165e-03,   4.438965713325064e-05,  -2.627597699477323e-07,  -8.385230463282097e-11,
   2.382730176383605e-11,  -3.014622053241596e-13,   1.528242822249388e-15,   1.261420413349155e-17,  -3.533532815172866e-19,   3.476461169258759e-21,  -6.037800556511503e-24,
  -3.531542490498607e-25,   5.930448284997862e-27,   2.958620726507527e-01,  -4.573773048610033e-03,   4.438956991491044e-05,  -2.627203124223004e-07,  -8.459968376369238e-11,
   2.383257944306001e-11,  -3.014032829595090e-13,   1.526137265988462e-15,   1.263996695779780e-17,  -3.534054575951200e-19,   3.472579518704032e-21,  -5.961454791720026e-24,
  -3.537588369140234e-25,   5.927057096102811e-27,   2.958709517581541e-01,  -4.573930559586855e-03,   4.438946411943825e-05,  -2.626725960823959e-07,  -8.550335732532787e-11,
   2.383895801206047e-11,  -3.013319803443895e-13,   1.523591068432691e-15,   1.267110675374642e-17,  -3.534682403756976e-19,   3.467882857695426e-21,  -5.869156369055948e-24,
  -3.544888033255171e-25,   5.922939481419034e-27,   2.958795714348777e-01,  -4.574083459382313e-03,   4.438936106933856e-05,  -2.626262698252565e-07,  -8.638055959653428e-11,
   2.384514680551236e-11,  -3.012627054477364e-13,   1.521119121488291e-15,   1.270132322890855e-17,  -3.535288651785956e-19,   3.463320357502061e-21,  -5.779575330708101e-24,
  -3.551962818693262e-25,   5.918924429781127e-27,   2.958865153292974e-01,  -4.574206626924156e-03,   4.438927780584586e-05,  -2.625889470866275e-07,  -8.708717332304373e-11,
   2.385012997304546e-11,  -3.012068586988880e-13,   1.519127651430025e-15,   1.272565555223814e-17,  -3.535774718790108e-19,   3.459642674074244e-21,  -5.707424859419143e-24,
  -3.557653859219244e-25,   5.915677251142655e-27,   2.958911037285517e-01,  -4.574288010636941e-03,   4.438922266555047e-05,  -2.625642834621842e-07,  -8.755406707757665e-11,
   2.385342156470632e-11,  -3.011699366824249e-13,   1.517811673797946e-15,   1.274172917889186e-17,  -3.536094768117911e-19,   3.457211453635760e-21,  -5.659756398064175e-24,
  -3.561410325659777e-25,   5.913525355441600e-27,   2.958934600903487e-01,  -4.574329804076411e-03,   4.438919431086975e-05,  -2.625516170707250e-07,  -8.779383193397950e-11,
   2.385511158443218e-11,  -3.011509694368964e-13,   1.517135840974555e-15,   1.274998228934033e-17,  -3.536258777750499e-19,   3.455962574028015e-21,  -5.635278618310832e-24,
  -3.563338191540211e-25,   5.912418331714833e-27,   2.958942802435290e-01,  -4.574344350507962e-03,   4.438918443579338e-05,  -2.625472083471094e-07,  -8.787728310545881e-11,
   2.385569975235525e-11,  -3.011443667545328e-13,   1.516900608731146e-15,   1.275285462660542e-17,  -3.536315806925951e-19,   3.455527837270622e-21,  -5.626759262344166e-24,
  -3.564009002406995e-25,   5.912032715988572e-27,   2.958944103905375e-01,  -4.574346658818822e-03,   4.438918286847135e-05,  -2.625465087400631e-07,  -8.789052560092348e-11,
   2.385579308370716e-11,  -3.011433189542567e-13,   1.516863280497997e-15,   1.275331041588977e-17,  -3.536324854017958e-19,   3.455458848029523e-21,  -5.625407374952092e-24,
  -3.564115441333963e-25,   5.911971509558839e-27,   4.754536735917720e-01,  -6.640690761173206e-03,   4.908150060570110e-05,  -6.328482962311090e-08,  -3.263913579137762e-09,
   3.773756011973806e-11,  -3.611961609974652e-14,  -3.957721373743509e-15,   4.670234672648562e-17,  -5.607379377928137e-21,  -6.090951380440025e-21,   6.898002198217965e-23,
   6.389102155025450e-26,  -1.049832604372915e-26,   4.754582712873093e-01,  -6.640708435625772e-03,   4.907966438013199e-05,  -6.324951624222468e-08,  -3.263962929566530e-09,
   3.772976823665790e-11,  -3.599755303811343e-14,  -3.957731116354783e-15,   4.667666489973850e-17,  -5.254682551226074e-21,  -6.090512630572195e-21,   6.890339322367018e-23,
   6.483036397395416e-26,  -1.049581463071652e-26,   4.754663838535488e-01,  -6.640739614412580e-03,   4.907642430895036e-05,  -6.318721116410516e-08,  -3.264049869831424e-09,
   3.771601932510067e-11,  -3.578222564201725e-14,  -3.957747341776972e-15,   4.663135045470713e-17,  -4.632664529300154e-21,  -6.089733740782465e-21,   6.876819575781508e-23,
   6.648634809326066e-26,  -1.049136423982500e-26,   4.754761934168423e-01,  -6.640777302387916e-03,   4.907250634231612e-05,  -6.311188132271097e-08,  -3.264154761380082e-09,
   3.769939397616169e-11,  -3.552194288411343e-14,  -3.957765315959019e-15,   4.657655838436243e-17,  -3.881061110690074e-21,  -6.088783875289240e-21,   6.860473950456734e-23,
   6.848622398830004e-26,  -1.048595047938482e-26,   4.754857161213472e-01,  -6.640813874827666e-03,   4.906870280844951e-05,  -6.303876301920151e-08,  -3.264256339576040e-09,
   3.768325435750160e-11,  -3.526936272440133e-14,  -3.957781042317207e-15,   4.652336997036452e-17,  -3.151990718194931e-21,  -6.087853366627360e-21,   6.844608629384346e-23,
   7.042499096786749e-26,  -1.048066111269553e-26,   4.754933873093242e-01,  -6.640843326796881e-03,   4.906563870263862e-05,  -6.297986746144163e-08,  -3.264337991492904e-09,
   3.767025247886431e-11,  -3.506595752956175e-14,  -3.957792477524601e-15,   4.648052407710377e-17,  -2.565071744288790e-21,  -6.087097750117802e-21,   6.831829695313068e-23,
   7.198491812024632e-26,  -1.047637589325877e-26,   4.754984562060719e-01,  -6.640862783084468e-03,   4.906361398221822e-05,  -6.294095404558985e-08,  -3.264391858410252e-09,
   3.766166106371790e-11,  -3.493158532090455e-14,  -3.957799429851881e-15,   4.645221325802797e-17,  -2.177447192438528e-21,  -6.086595511000861e-21,   6.823386566890494e-23,
   7.301475110104992e-26,  -1.047353247230402e-26,   4.755010592999954e-01,  -6.640872773257715e-03,   4.906257418711210e-05,  -6.292097129490992e-08,  -3.264419494681102e-09,
   3.765724895937911e-11,  -3.486258937605460e-14,  -3.957802813503812e-15,   4.643767460294795e-17,  -1.978445611206622e-21,  -6.086336677993029e-21,   6.819050915041309e-23,
   7.354332922457463e-26,  -1.047206858540912e-26,   4.755019653263604e-01,  -6.640876250180433e-03,   4.906221227622044e-05,  -6.291401629866840e-08,  -3.264429109445107e-09,
   3.765571328581538e-11,  -3.483857639531443e-14,  -3.957803961495989e-15,   4.643261433956070e-17,  -1.909191186225091e-21,  -6.086246444085617e-21,   6.817541899298433e-23,
   7.372725945403879e-26,  -1.047155848464916e-26,   4.755021091000617e-01,  -6.640876801908383e-03,   4.906215484591385e-05,  -6.291291264524445e-08,  -3.264430634971934e-09,
   3.765546959555905e-11,  -3.483476594619909e-14,  -3.957804142255769e-15,   4.643181134776357e-17,  -1.898201932641822e-21,  -6.086232118338155e-21,   6.817302441542778e-23,
   7.375644445384116e-26,  -1.047147751108177e-26,   6.847812274290468e-01,  -8.347563821097460e-03,   3.851746037047018e-05,   2.625337854871132e-07,  -4.768683806253307e-09,
   3.390868484342080e-12,   5.187831038758753e-13,  -3.927946312025559e-15,  -4.034840866032128e-17,   8.200166904637451e-19,  -2.006343090691673e-22,  -1.176321559242766e-22,
   8.954537179504290e-25,   1.119021172046106e-26,   6.847848330575051e-01,  -8.347489972659555e-03,   3.851478210131971e-05,   2.625368998128761e-07,  -4.767955521656205e-09,
   3.383179091473022e-12,   5.186771761741277e-13,  -3.925194476805744e-15,  -4.034908014885054e-17,   8.194133321705472e-19,  -1.951801638430315e-22,  -1.175503843497120e-22,
   8.935837215905632e-25,   1.118922165346013e-26,   6.847911950420938e-01,  -8.347359665226249e-03,   3.851005658595845e-05,   2.625423892424410e-07,  -4.766670573118752e-09,
   3.369615433434838e-12,   5.184902637479853e-13,  -3.920340473403839e-15,  -4.035024636989878e-17,   8.183490396849238e-19,  -1.855656150932525e-22,  -1.174061033496467e-22,
   8.902868420798359e-25,   1.118744898828918e-26,   6.847988876747837e-01,  -8.347202094888075e-03,   3.850434300951663e-05,   2.625490171515879e-07,  -4.765117006089714e-09,
   3.353221608050126e-12,   5.182642450046121e-13,  -3.914473778714897e-15,  -4.035162483138179e-17,   8.170626701781580e-19,  -1.739555779079333e-22,  -1.172316479489299e-22,
   8.863049212307771e-25,   1.118526174590741e-26,   6.848063551860355e-01,  -8.347049127078406e-03,   3.849879696235032e-05,   2.625554409758667e-07,  -4.763609046326226e-09,
   3.337314612352632e-12,   5.180448276091979e-13,  -3.908781443314879e-15,  -4.035292980241977e-17,   8.158144968176683e-19,  -1.627014745630539e-22,  -1.170623010306953e-22,
   8.824442613064794e-25,   1.118309271028616e-26,   6.848123706556284e-01,  -8.346925897303282e-03,   3.849432956439823e-05,   2.625606084504489e-07,  -4.762394408469575e-09,
   3.324505763631617e-12,   5.178680661768653e-13,  -3.904197885207179e-15,  -4.035395729107469e-17,   8.148094229900503e-19,  -1.536472863987100e-22,  -1.169258855919650e-22,
   8.793376868478917e-25,   1.118131267767058e-26,   6.848163454433015e-01,  -8.346844468824293e-03,   3.849137779574753e-05,   2.625640193666086e-07,  -4.761591873264307e-09,
   3.316044655694604e-12,   5.177512645820199e-13,  -3.901170186138877e-15,  -4.035462460239301e-17,   8.141455027547011e-19,  -1.476702980979166e-22,  -1.168357487705786e-22,
   8.772866418685904e-25,   1.118012048307681e-26,   6.848183866475377e-01,  -8.346802651268475e-03,   3.848986198573415e-05,   2.625657699038640e-07,  -4.761179756494625e-09,
   3.311700322587895e-12,   5.176912811323282e-13,  -3.899615637668666e-15,  -4.035496370218847e-17,   8.138046143259730e-19,  -1.446026395068753e-22,  -1.167894604667290e-22,
   8.762338651379569e-25,   1.117950329682283e-26,   6.848190971010892e-01,  -8.346788096263630e-03,   3.848933440443402e-05,   2.625663790142821e-07,  -4.761036319213457e-09,
   3.310188373080965e-12,   5.176704033050132e-13,  -3.899074613757018e-15,  -4.035508115656173e-17,   8.136859755541747e-19,  -1.435352010723487e-22,  -1.167733496010719e-22,
   8.758675213946830e-25,   1.117928769390932e-26,   6.848192098399853e-01,  -8.346785786583790e-03,   3.848925068503456e-05,   2.625664756631669e-07,  -4.761013557869679e-09,
   3.309948453945480e-12,   5.176670902795364e-13,  -3.898988763130574e-15,  -4.035509976778174e-17,   8.136671497166862e-19,  -1.433658269757429e-22,  -1.167707930381974e-22,
   8.758093917152460e-25,   1.117925344341078e-26,   9.137452946886311e-01,  -9.318440339480394e-03,   1.375122983083800e-05,   5.214462354154815e-07,  -2.303353949285510e-09,
  -4.988716270169656e-11,   3.933883538657794e-13,   5.437408795082693e-15,  -6.767328508430535e-17,  -5.986945608633778e-19,   1.160700603060285e-20,   5.962540005626012e-23,
  -1.974285871660047e-24,  -4.012767820404887e-27,   9.137465812693069e-01,  -9.318293847414691e-03,   1.374993730649274e-05,   5.213995559954281e-07,  -2.302802835367948e-09,
  -4.987648981939474e-11,   3.932117139542156e-13,   5.435396184819441e-15,  -6.762470611832837e-17,  -5.983882659376347e-19,   1.159491892565680e-20,   5.959591846197138e-23,
  -1.971500941138480e-24,  -4.015302560763878e-27,   9.137488513630392e-01,  -9.318035370514273e-03,   1.374765687845853e-05,   5.213171975480720e-07,  -2.301830587731896e-09,
  -4.985766056784152e-11,   3.929001334857371e-13,   5.431845741888554e-15,  -6.753902911136282e-17,  -5.978479274431122e-19,   1.157360500207870e-20,   5.954388292097528e-23,
  -1.966591041762014e-24,  -4.019755399835958e-27,   9.137515962173626e-01,  -9.317722835649385e-03,   1.374489978929068e-05,   5.212176226834212e-07,  -2.300655279066359e-09,
  -4.983489752030379e-11,   3.925235433579414e-13,   5.427553939614859e-15,  -6.743549801917521e-17,  -5.971947553580200e-19,   1.154785577217886e-20,   5.948093582666006e-23,
  -1.960661017210540e-24,  -4.025106196826047e-27,   9.137542606992770e-01,  -9.317419451232887e-03,   1.374222370378166e-05,   5.211209716297417e-07,  -2.299514669432093e-09,
  -4.981280529005014e-11,   3.921581407272880e-13,   5.423389030755730e-15,  -6.733506557032413e-17,  -5.965608882104422e-19,   1.152288376437061e-20,   5.941980162953955e-23,
  -1.954911657572696e-24,  -4.030265514018811e-27,   9.137564070457755e-01,  -9.317175062319121e-03,   1.374006820569623e-05,   5.210431211863836e-07,  -2.298596066775778e-09,
  -4.979501219013904e-11,   3.918639092926450e-13,   5.420034907799071e-15,  -6.725421130299892e-17,  -5.960504114672070e-19,   1.150278446673826e-20,   5.937053398086822e-23,
  -1.950285349537839e-24,  -4.034396659116908e-27,   9.137578252518720e-01,  -9.317013581150082e-03,   1.373864404840070e-05,   5.209916840861769e-07,  -2.297989196618821e-09,
  -4.978325684042476e-11,   3.916695510955455e-13,   5.417819088609318e-15,  -6.720081008754173e-17,  -5.957131750950395e-19,   1.148951193236612e-20,   5.933796965234369e-23,
  -1.947230961363962e-24,  -4.037114158906400e-27,   9.137585535495631e-01,  -9.316930654906330e-03,   1.373791272417105e-05,   5.209652702467799e-07,  -2.297677578751224e-09,
  -4.977722052856832e-11,   3.915697588639953e-13,   5.416681321932634e-15,  -6.717339399822404e-17,  -5.955400120729737e-19,   1.148269854760221e-20,   5.932124348981410e-23,
  -1.945663188627882e-24,  -4.038505929129227e-27,   9.137588070372197e-01,  -9.316901791996221e-03,   1.373765818782596e-05,   5.209560769184569e-07,  -2.297569123506304e-09,
  -4.977511963407533e-11,   3.915350284479226e-13,   5.416285337690129e-15,  -6.716385284905774e-17,  -5.954797449170849e-19,   1.148032751586078e-20,   5.931542134710434e-23,
  -1.945117638571549e-24,  -4.038989743537907e-27,   9.137588472620761e-01,  -9.316897211865486e-03,   1.373761779678144e-05,   5.209546180757504e-07,  -2.297551913447290e-09,
  -4.977478625575907e-11,   3.915295173603532e-13,   5.416222501672469e-15,  -6.716233886045944e-17,  -5.954701815307991e-19,   1.147995128615234e-20,   5.931449743195156e-23,
  -1.945031073347991e-24,  -4.039066489556483e-27,   1.150474548623454e+00,  -9.299712591653079e-03,  -1.753150312158879e-05,   5.243996756466976e-07,   2.609071930089983e-09,
  -5.142053525769942e-11,  -4.257830590324087e-13,   5.864236949984195e-15,   7.228824484684721e-17,  -6.982444292341119e-19,  -1.252117018717094e-20,   8.062825312273824e-23,
   2.184482907391708e-24,  -8.143277707672014e-27,   1.150472907987543e+00,  -9.299565273971152e-03,  -1.753003888747837e-05,   5.243515657081169e-07,   2.608475403416935e-09,
  -5.140902735271869e-11,  -4.255943835518869e-13,   5.861891147879158e-15,   7.223585034998773e-17,  -6.978309955689046e-19,  -1.250780204865155e-20,   8.056897238040934e-23,
   2.181274578692252e-24,  -8.138451412063576e-27,   1.150470013170826e+00,  -9.299305340583782e-03,  -1.752745549559212e-05,   5.242666837230944e-07,   2.607423037987392e-09,
  -5.138872522242523e-11,  -4.252615742503029e-13,   5.857753075820139e-15,   7.214344515526079e-17,  -6.971017335855168e-19,  -1.248422984106158e-20,   8.046439936030976e-23,
   2.175618489283386e-24,  -8.129928558500476e-27,   1.150466512917041e+00,  -9.298991045074827e-03,  -1.752433209463918e-05,   5.241640584518091e-07,   2.606150873430946e-09,
  -5.136418206081299e-11,  -4.248593278256018e-13,   5.852751205683860e-15,   7.203178572388498e-17,  -6.962203253611963e-19,  -1.245575348147920e-20,   8.033799765068756e-23,
   2.168787701335747e-24,  -8.119611108335155e-27,   1.150463115129700e+00,  -9.298685952037148e-03,  -1.752130043699415e-05,   5.240644472489562e-07,   2.604916262271567e-09,
  -5.134036267564006e-11,  -4.244690329856630e-13,   5.847897498069125e-15,   7.192347022697297e-17,  -6.953651125352064e-19,  -1.242813780132803e-20,   8.021534051462012e-23,
   2.162165504219090e-24,  -8.109583081532051e-27,   1.150460378058575e+00,  -9.298440187097006e-03,  -1.751885852112935e-05,   5.239842129593058e-07,   2.603921950755508e-09,
  -5.132117888186092e-11,  -4.241547590798044e-13,   5.843988862191305e-15,   7.183627106494888e-17,  -6.946764815525162e-19,  -1.240591149973646e-20,   8.011656641313537e-23,
   2.156837200342556e-24,  -8.101496048554751e-27,   1.150458569520340e+00,  -9.298277796878210e-03,  -1.751724511704565e-05,   5.239312010531115e-07,   2.603265062121632e-09,
  -5.130850491908302e-11,  -4.239471622493303e-13,   5.841406813972452e-15,   7.177867998950754e-17,  -6.942216018186600e-19,  -1.239123480191549e-20,   8.005131631974159e-23,
   2.153319508632854e-24,  -8.096148090169143e-27,   1.150457640770946e+00,  -9.298194403856977e-03,  -1.751641660954843e-05,   5.239039785982969e-07,   2.602927760028546e-09,
  -5.130199695832089e-11,  -4.238405729149589e-13,   5.840081027813720e-15,   7.174911305155720e-17,  -6.939880473477460e-19,  -1.238370072090633e-20,   8.001781286610529e-23,
   2.151513981291017e-24,  -8.093400364160131e-27,   1.150457317514640e+00,  -9.298165378490731e-03,  -1.751612824831596e-05,   5.238945038435223e-07,   2.602810365576484e-09,
  -5.129973191847974e-11,  -4.238034769547243e-13,   5.839619610685462e-15,   7.173882341430998e-17,  -6.939067642224000e-19,  -1.238107890930858e-20,   8.000615257260069e-23,
   2.150885706245223e-24,  -8.092443787269292e-27,   1.150457266218480e+00,  -9.298160772580921e-03,  -1.751608248975799e-05,   5.238930003432417e-07,   2.602791737008477e-09,
  -5.129937249333460e-11,  -4.237975904997294e-13,   5.839546391798013e-15,   7.173719065734522e-17,  -6.938938660728782e-19,  -1.238066288737948e-20,   8.000430228688133e-23,
   2.150786015018901e-24,  -8.092291981930853e-27,   1.381702559860795e+00,  -8.237318848502919e-03,  -4.354783131659504e-05,   2.428542678426358e-07,   5.380933392831864e-09,
   8.438371270156733e-12,  -5.979905089213613e-13,  -5.217329210678286e-15,   4.693373053522580e-17,   1.096498238328179e-18,   8.174083503892201e-22,  -1.649632625232431e-22,
  -1.350202243439260e-24,   1.680420225587066e-26,   1.381698483326053e+00,  -8.237250518330106e-03,  -4.354480928518846e-05,   2.428620929885835e-07,   5.380093928158441e-09,
   8.428158137635437e-12,  -5.978672431442997e-13,  -5.213650566073650e-15,   4.693691540572526e-17,   1.095652423810385e-18,   8.091900533323012e-22,  -1.648405052310344e-22,
  -1.347259026811708e-24,   1.680203151194534e-26,   1.381691290446032e+00,  -8.237129946889027e-03,  -4.353947724670504e-05,   2.428758928155615e-07,   5.378612820466895e-09,
   8.410142781554373e-12,  -5.976497321007813e-13,  -5.207161857007604e-15,   4.694250709174241e-17,   1.094160485240603e-18,   7.947034925313109e-22,  -1.646239115338769e-22,
  -1.342070367647506e-24,   1.679815856306254e-26,   1.381682593130231e+00,  -8.236984147586859e-03,  -4.353303034261278e-05,   2.428925664749198e-07,   5.376822089525167e-09,
   8.388368438598543e-12,  -5.973867041408574e-13,  -5.199319590744963e-15,   4.694922079438227e-17,   1.092357294326708e-18,   7.772113284772422e-22,  -1.643620272716877e-22,
  -1.335804182781074e-24,   1.679340276890357e-26,   1.381674150336628e+00,  -8.236842604979398e-03,  -4.352677248432479e-05,   2.429087391150977e-07,   5.375083930574646e-09,
   8.367240770992124e-12,  -5.971313493880192e-13,  -5.191710589646441e-15,   4.695568830414384e-17,   1.090607706287881e-18,   7.602565442267350e-22,  -1.641078190264192e-22,
  -1.329729447847973e-24,   1.678871006694579e-26,   1.381667349225657e+00,  -8.236728577826209e-03,  -4.352173172554695e-05,   2.429217576560326e-07,   5.373683872638602e-09,
   8.350228108781548e-12,  -5.969256305288961e-13,  -5.185583839326584e-15,   4.696086262596543e-17,   1.089198918972810e-18,   7.466168240444963e-22,  -1.639030498526632e-22,
  -1.324841712590894e-24,   1.678487543918922e-26,   1.381662855316510e+00,  -8.236653229604009e-03,  -4.351840112207907e-05,   2.429303552162243e-07,   5.372758827582101e-09,
   8.338990121842997e-12,  -5.967896910778806e-13,  -5.181536841788348e-15,   4.696426419979433e-17,   1.088268339598812e-18,   7.376131554684992e-22,  -1.637677507509044e-22,
  -1.321614916510168e-24,   1.678231506645842e-26,   1.381660547523615e+00,  -8.236614534343231e-03,  -4.351669077209519e-05,   2.429347689720778e-07,   5.372283799987603e-09,
   8.333220014837864e-12,  -5.967198784024765e-13,  -5.179458963239851e-15,   4.696600565335406e-17,   1.087790542199897e-18,   7.329921895878957e-22,  -1.636982708985059e-22,
  -1.319958708819705e-24,   1.678099200030542e-26,   1.381659744282244e+00,  -8.236601066048696e-03,  -4.351609548094244e-05,   2.429363049810145e-07,   5.372118466630003e-09,
   8.331211857249083e-12,  -5.966955792607118e-13,  -5.178735809950359e-15,   4.696661091999982e-17,   1.087624256301611e-18,   7.313842735083756e-22,  -1.636740882322494e-22,
  -1.319382394849888e-24,   1.678053019159906e-26,   1.381659616819237e+00,  -8.236598928813246e-03,  -4.351600101699621e-05,   2.429365487131229e-07,   5.372092230709520e-09,
   8.330893198888649e-12,  -5.966917233120418e-13,  -5.178621058870687e-15,   4.696670692655334e-17,   1.087597869772694e-18,   7.311291408938945e-22,  -1.636702507967269e-22,
  -1.319290948609011e-24,   1.678045684705629e-26,   1.593416314425080e+00,  -6.323832797988751e-03,  -5.380498932935883e-05,  -1.359659640528096e-07,   3.297509024279813e-09,
   4.916511643322001e-11,   1.505802467290581e-13,  -4.585758980146669e-15,  -7.335270215549922e-17,  -2.120416167566278e-19,   8.238747767529794e-21,   1.313576194654003e-22,
   3.249781507883506e-25,  -1.675500600906056e-26,   1.593411273943114e+00,  -6.323870876273803e-03,  -5.380313330293068e-05,  -1.359199478573483e-07,   3.297718509877277e-09,
   4.915607717256054e-11,   1.503884155384048e-13,  -4.586457106610164e-15,  -7.331788411758447e-17,  -2.113690835918914e-19,   8.240657230221773e-21,   1.312348529387631e-22,
   3.227870611143778e-25,  -1.675953933580778e-26,   1.593402380074860e+00,  -6.323938055499117e-03,  -5.379985821978332e-05,  -1.358387584483535e-07,   3.298087931480292e-09,
   4.914012614588176e-11,   1.500500007225953e-13,  -4.587687119915777e-15,  -7.325644068080001e-17,  -2.101829031162109e-19,   8.244015516628957e-21,   1.310182032511527e-22,
   3.189237046382294e-25,  -1.676748397855966e-26,   1.593391625755563e+00,  -6.324019271420738e-03,  -5.379589779179438e-05,  -1.357405950991981e-07,   3.298534266624882e-09,
   4.912083610499698e-11,   1.496409126731799e-13,  -4.589171325655226e-15,  -7.318213162953142e-17,  -2.087494389875347e-19,   8.248057662468608e-21,   1.307561836479873e-22,
   3.142569622949947e-25,  -1.677699790252159e-26,   1.593381185901158e+00,  -6.324098095672145e-03,  -5.379205290682403e-05,  -1.356453121260057e-07,   3.298967170105575e-09,
   4.910210769164914e-11,   1.492439098315878e-13,  -4.590608880485378e-15,  -7.310998221203451e-17,  -2.073587763270659e-19,   8.251962106400714e-21,   1.305017732495547e-22,
   3.097316694229472e-25,  -1.678613674912695e-26,   1.593372775871211e+00,  -6.324161582023913e-03,  -5.378895539572477e-05,  -1.355685622202967e-07,   3.299315631456909e-09,
   4.908701891173041e-11,   1.489241846323553e-13,  -4.591764602131254e-15,  -7.305185137961532e-17,  -2.062391354588529e-19,   8.255093440261297e-21,   1.302967905636930e-22,
   3.060898066330141e-25,  -1.679342937743926e-26,   1.593367218761862e+00,  -6.324203526093967e-03,  -5.378690855597411e-05,  -1.355178515677686e-07,   3.299545751405141e-09,
   4.907704782331139e-11,   1.487129624965108e-13,  -4.592527130259959e-15,  -7.301343555554141e-17,  -2.054996193534947e-19,   8.257155701364834e-21,   1.301613255900907e-22,
   3.036851179404620e-25,  -1.679821421117010e-26,   1.593364364947721e+00,  -6.324225064345977e-03,  -5.378585738739898e-05,  -1.354918105566783e-07,   3.299663886612878e-09,
   4.907192697862895e-11,   1.486045042291930e-13,  -4.592918368702659e-15,  -7.299370595497994e-17,  -2.051199422322526e-19,   8.258212647722784e-21,   1.300917528927805e-22,
   3.024507486387462e-25,  -1.680066094172631e-26,   1.593363371655939e+00,  -6.324232560607878e-03,  -5.378549151561721e-05,  -1.354827469568931e-07,   3.299704997904598e-09,
   4.907014458773765e-11,   1.485667566295484e-13,  -4.593054486118744e-15,  -7.298683869010812e-17,  -2.049878080193829e-19,   8.258580189602442e-21,   1.300675366915725e-22,
   3.020212032038820e-25,  -1.680151087594005e-26,   1.593363214034420e+00,  -6.324233750146023e-03,  -5.378543345666509e-05,  -1.354813086985262e-07,   3.299711521380002e-09,
   4.906986174523668e-11,   1.485607667142361e-13,  -4.593076083386116e-15,  -7.298574894041525e-17,  -2.049668408937616e-19,   8.258638497393251e-21,   1.300636938766316e-22,
   3.019530444418285e-25,  -1.680164566939335e-26,   1.771796868943125e+00,  -3.988105502857691e-03,  -4.508661317767844e-05,  -3.428637465663246e-07,  -9.118859061790363e-10,
   2.093767277801865e-11,   4.062666737281433e-13,   3.589106055741541e-15,   3.503752748664764e-18,  -4.214637985891735e-19,  -7.159966630930565e-21,  -5.526371339877235e-23,
   1.404460771819977e-25,   1.044403321328261e-26,   1.771792641058292e+00,  -3.988201863735979e-03,  -4.508712288701907e-05,  -3.428440583409992e-07,  -9.113144943622558e-10,
   2.094471605785195e-11,   4.062752479358548e-13,   3.587676279978305e-15,   3.473576842352936e-18,  -4.217457585771383e-19,  -7.159038344492154e-21,  -5.518686560057525e-23,
   1.417263333209574e-25,   1.045270022955140e-26,   1.771785180850416e+00,  -3.988371889512066e-03,  -4.508802201584454e-05,  -3.428093127958540e-07,  -9.103062196494184e-10,
   2.095714174399751e-11,   4.062903128794723e-13,   3.585152646649358e-15,   3.420334216130313e-18,  -4.222429587835632e-19,  -7.157393935608962e-21,  -5.505121530942426e-23,
   1.439846937735611e-25,   1.046796471035897e-26,   1.771776159821577e+00,  -3.988577478807146e-03,  -4.508910880644403e-05,  -3.427672889702526e-07,  -9.090869868214602e-10,
   2.097216310768550e-11,   4.063084198004543e-13,   3.582099727395637e-15,   3.355958194977879e-18,  -4.228436283316829e-19,  -7.155394532583147e-21,  -5.488709844267722e-23,
   1.467143800656494e-25,   1.048637389765854e-26,   1.771767402294083e+00,  -3.988777053282105e-03,  -4.509016337733179e-05,  -3.427264833967696e-07,  -9.079033597210489e-10,
   2.098674149324128e-11,   4.063258827421530e-13,   3.579134630086893e-15,   3.293468879627981e-18,  -4.234261715245472e-19,  -7.153442065973273e-21,  -5.472768558314034e-23,
   1.493631081682756e-25,   1.050419411606080e-26,   1.771760347294498e+00,  -3.988937822112433e-03,  -4.509101259159521e-05,  -3.426936041008908e-07,  -9.069498330032627e-10,
   2.099848271675837e-11,   4.063398683083933e-13,   3.576745000798002e-15,   3.243132477407255e-18,  -4.238950476203200e-19,  -7.151860960434046e-21,  -5.459919952716895e-23,
   1.514960244751037e-25,   1.051851322821734e-26,   1.771755685452307e+00,  -3.989044052465442e-03,  -4.509157357355467e-05,  -3.426718746911849e-07,  -9.063197536193953e-10,
   2.100623967107921e-11,   4.063490694011941e-13,   3.575165494048000e-15,   3.209873130460365e-18,  -4.242046702619404e-19,  -7.150812168302423e-21,  -5.451426638351628e-23,
   1.529049934830723e-25,   1.052795710644983e-26,   1.771753291365815e+00,  -3.989098605960594e-03,  -4.509186161400763e-05,  -3.426607145615848e-07,  -9.059961758821421e-10,
   2.101022279380369e-11,   4.063537821335726e-13,   3.574354192650944e-15,   3.192793499838554e-18,  -4.243636137196945e-19,  -7.150272318538106e-21,  -5.447063931046887e-23,
   1.536284351700811e-25,   1.053280144209595e-26,   1.771752458080899e+00,  -3.989117593665011e-03,  -4.509196186106546e-05,  -3.426568300110330e-07,  -9.058835513971896e-10,
   2.101160908537730e-11,   4.063554204581814e-13,   3.574071788036602e-15,   3.186848879256474e-18,  -4.244189254813258e-19,  -7.150084220722629e-21,  -5.445545294245141e-23,
   1.538802147544069e-25,   1.053448667420592e-26,   1.771752325850002e+00,  -3.989120606745593e-03,  -4.509197776851029e-05,  -3.426562135785149e-07,  -9.058656794287454e-10,
   2.101182906739804e-11,   4.063556803434971e-13,   3.574026973187029e-15,   3.185905554650343e-18,  -4.244277022230673e-19,  -7.150054362782804e-21,  -5.445304300068368e-23,
   1.539201677134455e-25,   1.053475405539894e-26,   1.904414843176328e+00,  -1.809570642966414e-03,  -2.431191449724780e-05,  -2.672885636656041e-07,  -2.414383815852642e-09,
  -1.616652522297865e-11,  -3.702835066694229e-14,   1.080280177888521e-15,   2.355919732838595e-17,   3.017680213361403e-19,   2.694297766546623e-21,   1.237893392149862e-23,
  -1.138991824037693e-25,  -3.805602428312421e-27,   1.904412561211941e+00,  -1.809645871044762e-03,  -2.431327287485759e-05,  -2.673037017191225e-07,  -2.414435152386429e-09,
  -1.616438219595649e-11,  -3.696627370148513e-14,   1.081300273876146e-15,   2.357054035812924e-17,   3.018307525453265e-19,   2.693569960289026e-21,   1.235077741712514e-23,
  -1.143963363702640e-25,  -3.811549891764876e-27,   1.904408534546250e+00,  -1.809778615632765e-03,  -2.431566977685963e-05,  -2.673304114147081e-07,  -2.414525665445395e-09,
  -1.616059915743696e-11,  -3.685671372447667e-14,   1.083100420640445e-15,   2.359055279629771e-17,   3.019413243828704e-19,   2.692283230559350e-21,   1.230105947885634e-23,
  -1.152738625382005e-25,  -3.822043135587350e-27,   1.904403665282376e+00,  -1.809939137706736e-03,  -2.431856817614492e-05,  -2.673627062702236e-07,  -2.414634993616964e-09,
  -1.615602188118397e-11,  -3.672419137907289e-14,   1.085277469278674e-15,   2.361474775404002e-17,   3.020748271016231e-19,   2.690723032460276e-21,   1.224087975808889e-23,
  -1.163354708614919e-25,  -3.834729707131050e-27,   1.904398938100254e+00,  -1.810094975935457e-03,  -2.432138193362325e-05,  -2.673940546302424e-07,  -2.414741000584048e-09,
  -1.615157542327989e-11,  -3.659549778759025e-14,   1.087391215841387e-15,   2.363823129363075e-17,   3.022042176429186e-19,   2.689203945580632e-21,   1.218239523075967e-23,
  -1.173665788839951e-25,  -3.847043532029325e-27,   1.904395129811229e+00,  -1.810220521612203e-03,  -2.432364868986000e-05,  -2.674193063636792e-07,  -2.414826307456662e-09,
  -1.614799132417523e-11,  -3.649179295988849e-14,   1.089094241223144e-15,   2.365714609349804e-17,   3.023083012876220e-19,   2.687976982749878e-21,   1.213523565226062e-23,
  -1.181975961362408e-25,  -3.856961888852426e-27,   1.904392613296767e+00,  -1.810303482126033e-03,  -2.432514653658537e-05,  -2.674359912318828e-07,  -2.414882632174360e-09,
  -1.614562199173123e-11,  -3.642325150750345e-14,   1.090219677027834e-15,   2.366964307059111e-17,   3.023770035962454e-19,   2.687164657368649e-21,   1.210405131164726e-23,
  -1.187468985442049e-25,  -3.863515023415409e-27,   1.904391320926104e+00,  -1.810346086989593e-03,  -2.432591575705700e-05,  -2.674445593922457e-07,  -2.414911543834816e-09,
  -1.614440490957931e-11,  -3.638804750722469e-14,   1.090797675228100e-15,   2.367606037543725e-17,   3.024122625302213e-19,   2.686747003741093e-21,   1.208802981670435e-23,
  -1.190290475573546e-25,  -3.866880142127220e-27,   1.904390871101463e+00,  -1.810360916109212e-03,  -2.432618349200412e-05,  -2.674475415683246e-07,  -2.414921604609535e-09,
  -1.614398124259040e-11,  -3.637579368672376e-14,   1.090998858057214e-15,   2.367829389897234e-17,   3.024245310645381e-19,   2.686601558244146e-21,   1.208245229914084e-23,
  -1.191272610082953e-25,  -3.868051365902322e-27,   1.904390799720336e+00,  -1.810363269291331e-03,  -2.432622597788699e-05,  -2.674480147961948e-07,  -2.414923201011790e-09,
  -1.614391401008141e-11,  -3.637384913876695e-14,   1.091030783251249e-15,   2.367864832468426e-17,   3.024264777381769e-19,   2.686578474375779e-21,   1.208156717219558e-23,
  -1.191428465529341e-25,  -3.868237221245442e-27,   1.981561116976727e+00,  -3.648788641946365e-04,  -5.361695668346826e-06,  -6.909448447594389e-08,  -8.203204371644732e-10,
  -9.144518385662667e-12,  -9.633493708804486e-14,  -9.578875363986612e-16,  -8.909682577746080e-18,  -7.587671523957366e-20,  -5.619610959261724e-22,  -3.068073858717699e-24,
  -5.923975303500857e-28,   3.212942153967258e-28,   1.981560613390894e+00,  -3.648983272365867e-04,  -5.362157864089895e-06,  -6.910307333914881e-08,  -8.204561851426685e-10,
  -9.146408303822750e-12,  -9.635837392250128e-14,  -9.581440293806524e-16,  -8.912053367206216e-18,  -7.589244119848496e-20,  -5.619621483025867e-22,  -3.065672173134241e-24,
  -5.361418632525755e-28,   3.222387050196779e-28,   1.981559724770436e+00,  -3.649326720474864e-04,  -5.362973477906891e-06,  -6.911822996535705e-08,  -8.206957414036465e-10,
  -9.149743504942857e-12,  -9.639973364581594e-14,  -9.585966583704083e-16,  -8.916236663875808e-18,  -7.592017977920067e-20,  -5.619637212117635e-22,  -3.061428727703876e-24,
  -4.367844403636361e-28,   3.239066276010452e-28,   1.981558650180833e+00,  -3.649742055142415e-04,  -5.363959832840623e-06,  -6.913655997859786e-08,  -8.209854611247267e-10,
  -9.153777166259710e-12,  -9.644975489325097e-14,  -9.591440556304930e-16,  -8.921295152574230e-18,  -7.595370429372384e-20,  -5.619651385807967e-22,  -3.056287897144597e-24,
  -3.164810230010395e-28,   3.259258101805472e-28,   1.981557606924752e+00,  -3.650145289978708e-04,  -5.364917480140869e-06,  -6.915435701335927e-08,  -8.212667639087969e-10,
  -9.157693708447615e-12,  -9.649832368965335e-14,  -9.596755363064687e-16,  -8.926205846734687e-18,  -7.598623120262861e-20,  -5.619660066481774e-22,  -3.051287196215366e-24,
  -1.995255622140087e-28,   3.278884209301723e-28,   1.981556766446008e+00,  -3.650470155891965e-04,  -5.365689027894303e-06,  -6.916869591844111e-08,  -8.214934120928936e-10,
  -9.160849349569892e-12,  -9.653745655416728e-14,  -9.601037453027160e-16,  -8.930161838129128e-18,  -7.601242146747787e-20,  -5.619663417602903e-22,  -3.047251475324919e-24,
  -1.051880449367354e-28,   3.294712118253545e-28,   1.981556211050489e+00,  -3.650684833826413e-04,  -5.366198891854235e-06,  -6.917817171507855e-08,  -8.216431939805441e-10,
  -9.162934798406613e-12,  -9.656331802363457e-14,  -9.603867251386303e-16,  -8.932775886546019e-18,  -7.602972116180410e-20,  -5.619663847612450e-22,  -3.044581205125638e-24,
  -4.279284644092460e-29,   3.305179428125091e-28,   1.981555925821468e+00,  -3.650795085029897e-04,  -5.366460743439781e-06,  -6.918303826951484e-08,  -8.217201193441230e-10,
  -9.164005855775990e-12,  -9.657660010589848e-14,  -9.605320571604469e-16,  -8.934118325364894e-18,  -7.603860341256179e-20,  -5.619663516365760e-22,  -3.043208799106638e-24,
  -1.073178278786053e-29,   3.310557525072253e-28,   1.981555826543805e+00,  -3.650833459577841e-04,  -5.366551885199897e-06,  -6.918473216284526e-08,  -8.217468947488494e-10,
  -9.164378659775661e-12,  -9.658122321232382e-14,  -9.605826426285191e-16,  -8.934585573465635e-18,  -7.604169464753448e-20,  -5.619663313158633e-22,  -3.042730946338947e-24,
   4.302530980967527e-31,   3.312429840133500e-28,   1.981555810789756e+00,  -3.650839549118909e-04,  -5.366566348233047e-06,  -6.918500096250034e-08,  -8.217511436761056e-10,
  -9.164437819237740e-12,  -9.658195684305169e-14,  -9.605906699086203e-16,  -8.934659719302948e-18,  -7.604218516905469e-20,  -5.619663276738460e-22,  -3.042655109411179e-24,
   2.201651632419328e-30,   3.312726970648486e-28,   5.863224777509678e-03,  -1.008264878290404e-04,   1.296751614778880e-06,  -1.477350359559228e-08,   1.570594272280669e-10,
  -1.594267713906358e-12,   1.562782485058378e-14,  -1.489169637595068e-16,   1.383830671288033e-18,  -1.256618969659536e-20,   1.114943679580422e-22,  -9.663620616191431e-25,
   8.157099284914571e-27,  -6.688838569561665e-29,   5.863346525336825e-03,  -1.008306481425818e-04,   1.296840084850478e-06,  -1.477500068999187e-08,   1.570814469024644e-10,
  -1.594561570570739e-12,   1.563146715201079e-14,  -1.489595050322996e-16,   1.384302667859434e-18,  -1.257119162050957e-20,   1.115450497974748e-22,  -9.668533592948609e-25,
   8.161625613048178e-27,  -6.692781728732451e-29,   5.863561358054332e-03,  -1.008379894241370e-04,   1.296996201766034e-06,  -1.477764256083537e-08,   1.571203051329673e-10,
  -1.595080153441677e-12,   1.563789505856947e-14,  -1.490345835173158e-16,   1.385135687263822e-18,  -1.258001965585542e-20,   1.116345014955523e-22,  -9.677204964553661e-25,
   8.169614580048733e-27,  -6.699741313713645e-29,   5.863821147600702e-03,  -1.008468671648775e-04,   1.297184997201089e-06,  -1.478083752164237e-08,   1.571673000291162e-10,
  -1.595707345630086e-12,   1.564566947150576e-14,  -1.491253926551832e-16,   1.386143280015396e-18,  -1.259069812692352e-20,   1.117427063196995e-22,  -9.687694482026232e-25,
   8.179278658610151e-27,  -6.708160019232269e-29,   5.864073358869092e-03,  -1.008554861341957e-04,   1.297368294547137e-06,  -1.478393953473420e-08,   1.572129293059311e-10,
  -1.596316334694661e-12,   1.565321853813192e-14,  -1.492135731366296e-16,   1.387121744478544e-18,  -1.260106828499843e-20,   1.118477904092101e-22,  -9.697881716108297e-25,
   8.188664289973279e-27,  -6.716336000347763e-29,   5.864276545638351e-03,  -1.008624299025242e-04,   1.297515969407701e-06,  -1.478643876309131e-08,   1.572496929930703e-10,
  -1.596807015608924e-12,   1.565930125876353e-14,  -1.492846277737359e-16,   1.387910205505208e-18,  -1.260942498909926e-20,   1.119324739671823e-22,  -9.706091423694687e-25,
   8.196228035353094e-27,  -6.722924791385585e-29,   5.864410812071979e-03,  -1.008670184357653e-04,   1.297613556642626e-06,  -1.478809034917945e-08,   1.572739883951214e-10,
  -1.597131291538165e-12,   1.566332124426606e-14,  -1.493315880251141e-16,   1.388431315604114e-18,  -1.261494824297155e-20,   1.119884456447606e-22,  -9.711517723467668e-25,
   8.201227396073078e-27,  -6.727279686531802e-29,   5.864479765620169e-03,  -1.008693749335782e-04,   1.297663674311078e-06,  -1.478893856111859e-08,   1.572864660545718e-10,
  -1.597297835957293e-12,   1.566538589466381e-14,  -1.493557070251046e-16,   1.388698964317958e-18,  -1.261778509793601e-20,   1.120171941995697e-22,  -9.714304843095304e-25,
   8.203795231516320e-27,  -6.729516485945938e-29,   5.864503765742649e-03,  -1.008701951447998e-04,   1.297681118535625e-06,  -1.478923379597042e-08,   1.572908091468513e-10,
  -1.597355805371238e-12,   1.566610454626674e-14,  -1.493641022880563e-16,   1.388792127276301e-18,  -1.261877255494253e-20,   1.120272011011004e-22,  -9.715274998055898e-25,
   8.204689057742815e-27,  -6.730295080566790e-29,   5.864507574241453e-03,  -1.008703253015267e-04,   1.297683886708583e-06,  -1.478928064600382e-08,   1.572914983418891e-10,
  -1.597365004418734e-12,   1.566621858785631e-14,  -1.493654345208007e-16,   1.388806911209783e-18,  -1.261892925379208e-20,   1.120287890919666e-22,  -9.715428951726512e-25,
   8.204830898863527e-27,  -6.730418635473441e-29,   5.249643182659046e-02,  -8.852152903049353e-04,   1.092541542492367e-05,  -1.158188777762780e-07,   1.096948542832283e-09,
  -9.308982156367239e-12,   6.885586808103580e-14,  -4.047268901895148e-16,   1.160239301597547e-18,   1.413687005544076e-20,  -3.378014933846391e-22,   4.517165242735328e-24,
  -4.750767641586382e-26,   4.111197372032656e-28,   5.249745732204632e-02,  -8.852478950653847e-04,   1.092603300405250e-05,  -1.158276116220389e-07,   1.097045406827222e-09,
  -9.309778190866832e-12,   6.885888404596480e-14,  -4.046785676626853e-16,   1.158804712110698e-18,   1.416027885575975e-20,  -3.380965426962550e-22,   4.520176871780815e-24,
  -4.753134235376848e-26,   4.112165650058135e-28,   5.249926687207490e-02,  -8.853054286772174e-04,   1.092712277646307e-05,  -1.158430232370080e-07,   1.097216328309143e-09,
  -9.311182728639347e-12,   6.886420269624071e-14,  -4.045932374852814e-16,   1.156272343413134e-18,   1.420159668314299e-20,  -3.386172808288957e-22,   4.525491510784716e-24,
  -4.757309425716849e-26,   4.113871558590635e-28,   5.250145507972470e-02,  -8.853750023440856e-04,   1.092844061647987e-05,  -1.158616601609735e-07,   1.097423014252721e-09,
  -9.312880978293248e-12,   6.887062883352010e-14,  -4.044899456306973e-16,   1.153208448632738e-18,   1.425158017995841e-20,  -3.392471657904415e-22,   4.531919003584646e-24,
  -4.762356911856494e-26,   4.115929867661995e-28,   5.250357943805255e-02,  -8.854425468252682e-04,   1.092972003189847e-05,  -1.158797536474004e-07,   1.097623667523988e-09,
  -9.314529470893883e-12,   6.887686173612816e-14,  -4.043895567871629e-16,   1.150232263243983e-18,   1.430012585043512e-20,  -3.398588595969620e-22,   4.538159721483244e-24,
  -4.767255665917527e-26,   4.117923327815983e-28,   5.250529085384072e-02,  -8.854969623387126e-04,   1.093075076902787e-05,  -1.158943303008797e-07,   1.097785315583502e-09,
  -9.315857375606173e-12,   6.888187895351783e-14,  -4.043086024941168e-16,   1.147833390337563e-18,   1.433924977474446e-20,  -3.403517843270670e-22,   4.543187891914427e-24,
  -4.771201134993277e-26,   4.119525854798822e-28,   5.250642175645361e-02,  -8.855329203930219e-04,   1.093143188952654e-05,  -1.159039626738167e-07,   1.097892131891933e-09,
  -9.316734782646391e-12,   6.888519231765050e-14,  -4.042550690118889e-16,   1.146247622873779e-18,   1.436511008163263e-20,  -3.406775746976103e-22,   4.546510774031257e-24,
  -4.773807787468954e-26,   4.120583120451314e-28,   5.250700253819518e-02,  -8.855513869617644e-04,   1.093178168607985e-05,  -1.159089094757250e-07,   1.097946987842120e-09,
  -9.317185358065829e-12,   6.888689329362216e-14,  -4.042275645337795e-16,   1.145433059009347e-18,   1.437839303440242e-20,  -3.408449066762256e-22,   4.548217343212308e-24,
  -4.775146290996914e-26,   4.121125564638977e-28,   5.250720468605379e-02,  -8.855578144817903e-04,   1.093190343734061e-05,  -1.159106312741386e-07,   1.097966081063764e-09,
  -9.317342182565868e-12,   6.888748523914332e-14,  -4.042179893623329e-16,   1.145149511328411e-18,   1.438301667746186e-20,  -3.409031517707727e-22,   4.548811347783805e-24,
  -4.775612147542562e-26,   4.121314285718885e-28,   5.250723676420399e-02,  -8.855588344436245e-04,   1.093192275765381e-05,  -1.159109045007219e-07,   1.097969110900106e-09,
  -9.317367068340210e-12,   6.888757916824717e-14,  -4.042164698202123e-16,   1.145104514732080e-18,   1.438375040443837e-20,  -3.409123946391938e-22,   4.548905608961052e-24,
  -4.775686071522155e-26,   4.121344229281416e-28,   1.442939024045197e-01,  -2.337104727622448e-03,   2.641776342972157e-05,  -2.367238459993399e-07,   1.615655175089969e-09,
  -5.920359683772361e-12,  -4.306078674016621e-14,   1.171489680006255e-15,  -1.425493366432359e-17,   1.127695728236091e-19,  -3.915035315724202e-22,  -5.193777684039216e-24,
   1.261081880226069e-25,  -1.534098602258354e-27,   1.442963808886579e-01,  -2.337171325550887e-03,   2.641867188942671e-05,  -2.367293768775134e-07,   1.615594178013239e-09,
  -5.918047277019737e-12,  -4.309823938022638e-14,   1.171869565328892e-15,  -1.425656005467415e-17,   1.127423552716252e-19,  -3.907185793782422e-22,  -5.205011347648602e-24,
   1.262088358649415e-25,  -1.534383695030144e-27,   1.443007542821773e-01,  -2.337288839906383e-03,   2.642027485289305e-05,  -2.367391344348518e-07,   1.615486504877883e-09,
  -5.913966391171408e-12,  -4.316432860940551e-14,   1.172539803963610e-15,  -1.425942714970720e-17,   1.126942823643104e-19,  -3.893330132819086e-22,  -5.224834995139628e-24,
   1.263863651099056e-25,  -1.534884976600987e-27,   1.443060427544537e-01,  -2.337430941674012e-03,   2.642221312573053e-05,  -2.367509303690014e-07,   1.615356232334132e-09,
  -5.909030704209853e-12,  -4.324425030131532e-14,   1.173350135723597e-15,  -1.426288947300748e-17,   1.126360717621914e-19,  -3.876567100882077e-22,  -5.248808804035288e-24,
   1.266009236357542e-25,  -1.535488113863358e-27,   1.443111768354732e-01,  -2.337568893864898e-03,   2.642409471746820e-05,  -2.367623785068745e-07,   1.615229689515494e-09,
  -5.904238139759524e-12,  -4.332184305914715e-14,   1.174136657659727e-15,  -1.426624581936187e-17,   1.125794777915021e-19,  -3.860284817157685e-22,  -5.272085130202788e-24,
   1.268090961714440e-25,  -1.536070467254232e-27,   1.443153128729905e-01,  -2.337680027971116e-03,   2.642561046747977e-05,  -2.367715987200394e-07,   1.615127693460441e-09,
  -5.900376534848322e-12,  -4.338435518787467e-14,   1.174770173334578e-15,  -1.426894619578289e-17,   1.125338261445721e-19,  -3.847161558584841e-22,  -5.290838355566804e-24,
   1.269767131960281e-25,  -1.536537336978324e-27,   1.443180459362889e-01,  -2.337753464199501e-03,   2.642661203054069e-05,  -2.367776901670398e-07,   1.615060269448794e-09,
  -5.897824474550338e-12,  -4.342566424776862e-14,   1.175188742088081e-15,  -1.427072886552343e-17,   1.125036308330571e-19,  -3.838486779688822e-22,  -5.303231188053091e-24,
   1.270874303347571e-25,  -1.536844725922513e-27,   1.443194495084830e-01,  -2.337791177461108e-03,   2.642712637566865e-05,  -2.367808180745961e-07,   1.615025635693368e-09,
  -5.896513751788925e-12,  -4.344687909392772e-14,   1.175403682592020e-15,  -1.427164382871673e-17,   1.124881149671906e-19,  -3.834030887513418e-22,  -5.309595820109528e-24,
   1.271442761303146e-25,  -1.537002241397879e-27,   1.443199380367749e-01,  -2.337804303946106e-03,   2.642730539733661e-05,  -2.367819067170254e-07,   1.615013579776343e-09,
  -5.896057523993252e-12,  -4.345426322162693e-14,   1.175478492281213e-15,  -1.427196220676208e-17,   1.124827130746660e-19,  -3.832479817730470e-22,  -5.311811139413211e-24,
   1.271640597989067e-25,  -1.537057011414115e-27,   1.443200155595881e-01,  -2.337806386940342e-03,   2.642733380556876e-05,  -2.367820794670015e-07,   1.615011666605622e-09,
  -5.895985126035937e-12,  -4.345543498603864e-14,   1.175490363438366e-15,  -1.427201272501970e-17,   1.124818557997240e-19,  -3.832233676926077e-22,  -5.312162682488917e-24,
   1.271671990982051e-25,  -1.537065700065015e-27,   2.782465689507629e-01,  -4.231053802946925e-03,   4.124280370545712e-05,  -2.606830118952443e-07,   3.243563208249530e-10,
   1.713705573992459e-11,  -2.547517869733120e-13,   1.755184698418710e-15,   2.282255246359587e-18,  -2.235024305832365e-19,   2.936491378882743e-21,  -1.660032921466441e-23,
  -1.060187489196240e-25,   3.570478614093380e-27,   2.782504358181807e-01,  -4.231127063202424e-03,   4.124298413382642e-05,  -2.606669169970382e-07,   3.239981510923354e-10,
   1.714049921467281e-11,  -2.547455407255272e-13,   1.754428178523405e-15,   2.294621868189141e-18,  -2.235870063889212e-19,   2.935819649001344e-21,  -1.657414033337347e-23,
  -1.063587575022679e-25,   3.571934041998148e-27,   2.782572589801857e-01,  -4.231256328392470e-03,   4.124330233874872e-05,  -2.606385146746508e-07,   3.233661621966584e-10,
   1.714657406816063e-11,  -2.547344927440351e-13,   1.753093055930108e-15,   2.316440649515156e-18,  -2.237361318643784e-19,   2.934632663077327e-21,  -1.652792107168082e-23,
  -1.069584879023164e-25,   3.574495889399074e-27,   2.782655096437899e-01,  -4.231412630960704e-03,   4.124368683629506e-05,  -2.606041658140438e-07,   3.226019668234671e-10,
   1.715391777930150e-11,  -2.547210884317594e-13,   1.751478217183179e-15,   2.342820197584077e-18,  -2.239162686305894e-19,   2.933194435526197e-21,  -1.647201766189223e-23,
  -1.076833126814604e-25,   3.577582997477948e-27,   2.782735192694885e-01,  -4.231564360210747e-03,   4.124405980743712e-05,  -2.605708158557501e-07,   3.218601121445264e-10,
   1.716104476250818e-11,  -2.547080286643745e-13,   1.749910147097624e-15,   2.368424859015092e-18,  -2.240909460606407e-19,   2.931795181202595e-21,  -1.641773235900436e-23,
  -1.083865662272914e-25,   3.580568697451479e-27,   2.782799717371885e-01,  -4.231686586608257e-03,   4.124436005862288e-05,  -2.605439462111251e-07,   3.212624929676121e-10,
   1.716678461645036e-11,  -2.546974741466491e-13,   1.748646634799878e-15,   2.389048666231563e-18,  -2.242315233106494e-19,   2.930665776981592e-21,  -1.637398992827909e-23,
  -1.089528156638476e-25,   3.582965905267736e-27,   2.782842354214147e-01,  -4.231767349326528e-03,   4.124455835667393e-05,  -2.605261895876575e-07,   3.208676014250889e-10,
   1.717057665015906e-11,  -2.546904833911026e-13,   1.747811583807233e-15,   2.402675052521446e-18,  -2.243243453949684e-19,   2.929918418147710e-21,  -1.634508038327816e-23,
  -1.093268447696484e-25,   3.584546003979818e-27,   2.782864250299078e-01,  -4.231808824132969e-03,   4.124466016048657e-05,  -2.605170702044488e-07,   3.206648071359959e-10,
   1.717252380600114e-11,  -2.546868881954744e-13,   1.747382700471624e-15,   2.409672402633309e-18,  -2.243719926797223e-19,   2.929534283197569e-21,  -1.633023230350682e-23,
  -1.095188837727903e-25,   3.585356243754491e-27,   2.782871871436148e-01,  -4.231823259705534e-03,   4.124469558918523e-05,  -2.605138960388303e-07,   3.205942229516146e-10,
   1.717320149402384e-11,  -2.546856360415097e-13,   1.747233416584963e-15,   2.412107822552860e-18,  -2.243885733628556e-19,   2.929400528910858e-21,  -1.632506403163508e-23,
  -1.095857178839772e-25,   3.585638061452552e-27,   2.782873080805841e-01,  -4.231825550426695e-03,   4.124470121099201e-05,  -2.605133923386272e-07,   3.205830222243428e-10,
   1.717330903200424e-11,  -2.546854373033156e-13,   1.747209726950422e-15,   2.412494286740619e-18,  -2.243912043279465e-19,   2.929379301450687e-21,  -1.632424388564593e-23,
  -1.095963232130325e-25,   3.585682772845485e-27,   4.496702265940485e-01,  -6.251907332330624e-03,   4.803340549644318e-05,  -1.095511942178422e-07,  -2.525940863761392e-09,
   3.570804988705822e-11,  -1.263444205567642e-13,  -2.507579999175848e-15,   4.284183582697612e-17,  -1.893487826005858e-19,  -3.151984686696223e-21,   6.155970435196120e-23,
  -3.202354658991669e-25,  -4.416523898531491e-27,   4.496747268627125e-01,  -6.251938025785045e-03,   4.803198366280772e-05,  -1.095177595881414e-07,  -2.526117209011899e-09,
   3.570310308315444e-11,  -1.262322370629586e-13,  -2.508210813830932e-15,   4.282847612804819e-17,  -1.890326363277351e-19,  -3.153927912687655e-21,   6.152710334928712e-23,
  -3.194097275439928e-25,  -4.422079449510810e-27,   4.496826675491978e-01,  -6.251992177231218e-03,   4.802947473461925e-05,  -1.094587674306470e-07,  -2.526428244836204e-09,
   3.569437336408628e-11,  -1.260343160693876e-13,  -2.509323029695959e-15,   4.280489609736261e-17,  -1.884749282240172e-19,  -3.157352617511943e-21,   6.146954556059440e-23,
  -3.179532217907453e-25,  -4.431865804723055e-27,   4.496922693273570e-01,  -6.252057644717371e-03,   4.802644077484783e-05,  -1.093874399166066e-07,  -2.526804134203729e-09,
   3.568381558056228e-11,  -1.257950365723539e-13,  -2.510666455776598e-15,   4.277637157435065e-17,  -1.878007752621734e-19,  -3.161486736282619e-21,   6.139989019664349e-23,
  -3.161928911395302e-25,  -4.443671442441439e-27,   4.497015903738814e-01,  -6.252121185784832e-03,   4.802349531580620e-05,  -1.093182031380012e-07,  -2.527168812339294e-09,
   3.567356447344654e-11,  -1.255627991713131e-13,  -2.511969083952481e-15,   4.274866864246901e-17,  -1.871465640173655e-19,  -3.165492664955693e-21,   6.133221155322998e-23,
  -3.144849271907725e-25,  -4.455102708437651e-27,   4.497090991490985e-01,  -6.252172363873681e-03,   4.802112238958658e-05,  -1.092624317172844e-07,  -2.527462428420325e-09,
   3.566530503058874e-11,  -1.253757482859210e-13,  -2.513017356363514e-15,   4.272634306149635e-17,  -1.866197154150773e-19,  -3.168714486925529e-21,   6.127764871951753e-23,
  -3.131096838498319e-25,  -4.464290500628875e-27,   4.497140607461120e-01,  -6.252206176660256e-03,   4.801955435193262e-05,  -1.092255813199774e-07,  -2.527656364463011e-09,
   3.565984670941259e-11,  -1.252521662898046e-13,  -2.513709493731280e-15,   4.271158657693141e-17,  -1.862716691922806e-19,  -3.170840814108582e-21,   6.124157412959098e-23,
  -3.122012759349825e-25,  -4.470351308730141e-27,   4.497166087425876e-01,  -6.252223539664957e-03,   4.801874907402292e-05,  -1.092066576088532e-07,  -2.527755935089343e-09,
   3.565704340603000e-11,  -1.251887065571000e-13,  -2.514064771675105e-15,   4.270400713695772e-17,  -1.860929573909618e-19,  -3.171931982352788e-21,   6.122304178505188e-23,
  -3.117348666115170e-25,  -4.473460632470416e-27,   4.497174955927524e-01,  -6.252229582782280e-03,   4.801846878719719e-05,  -1.092000711542971e-07,  -2.527790587607873e-09,
   3.565606765969151e-11,  -1.251666196973083e-13,  -2.514188402718776e-15,   4.270136883990057e-17,  -1.860307593453279e-19,  -3.172311645705323e-21,   6.121659042768653e-23,
  -3.115725447556019e-25,  -4.474542353092079e-27,   4.497176363235009e-01,  -6.252230541730593e-03,   4.801842430942064e-05,  -1.091990259801952e-07,  -2.527796086297814e-09,
   3.565591282071785e-11,  -1.251631148586854e-13,  -2.514208019995316e-15,   4.270095016883035e-17,  -1.860208895730785e-19,  -3.172371886986218e-21,   6.121556663841455e-23,
  -3.115467872808276e-25,  -4.474713983142865e-27,   6.520253849978190e-01,  -8.028110244279338e-03,   4.121439372901138e-05,   1.874142046530399e-07,  -4.585906320332541e-09,
   1.440295919824799e-11,   3.950968028681106e-13,  -4.757610523250480e-15,  -1.209206932812243e-17,   7.227364066235848e-19,  -4.282080073754808e-21,  -6.575162028605609e-23,
   1.166553003228611e-24,  -2.803027857764716e-28,   6.520292436676901e-01,  -8.028057486869846e-03,   4.121181729560021e-05,   1.874276290124980e-07,  -4.585351096836101e-09,
   1.439363130957992e-11,   3.950646935948738e-13,  -4.755180131789589e-15,  -1.210990473596055e-17,   7.223973319382232e-19,  -4.274929332029957e-21,  -6.575286504586886e-23,
   1.165099303169326e-24,  -2.656643241010038e-28,   6.520360521554843e-01,  -8.027964392533470e-03,   4.120727139206773e-05,   1.874513094085761e-07,  -4.584371433081687e-09,
   1.437717598876377e-11,   3.950079983521822e-13,  -4.750892598169670e-15,  -1.214135112723681e-17,   7.217990249169752e-19,  -4.262319036969145e-21,  -6.575497488937922e-23,
   1.162535255416036e-24,  -2.398695583547505e-28,   6.520442847176650e-01,  -8.027851816655286e-03,   4.120177486960352e-05,   1.874799318969433e-07,  -4.583186876046757e-09,
   1.435728466306408e-11,   3.949393772294810e-13,  -4.745709653031986e-15,  -1.217933473938606e-17,   7.210755384115236e-19,  -4.247082979061134e-21,  -6.575737869393379e-23,
   1.159436536358750e-24,  -2.087379397505424e-28,   6.520522763967743e-01,  -8.027742524484915e-03,   4.119643939380010e-05,   1.875077054452152e-07,  -4.582036994429367e-09,
   1.433798144372985e-11,   3.948726933975706e-13,  -4.740679800802683e-15,  -1.221616492641268e-17,   7.203731829460030e-19,  -4.232305106176940e-21,  -6.575955804877746e-23,
   1.156430191959783e-24,  -1.785783546315819e-28,   6.520587141389563e-01,  -8.027654476225145e-03,   4.119214152848226e-05,   1.875300703797860e-07,  -4.581110711957818e-09,
   1.432243598948562e-11,   3.948189253424457e-13,  -4.736629007502002e-15,  -1.224580358921931e-17,   7.198073695161841e-19,  -4.220409575565449e-21,  -6.576120334063035e-23,
   1.154009637743073e-24,  -1.543268938182313e-28,   6.520629679616207e-01,  -8.027596293590242e-03,   4.118930173457396e-05,   1.875448442876396e-07,  -4.580498664125555e-09,
   1.431216626245487e-11,   3.947833726710975e-13,  -4.733952898228449e-15,  -1.226537299161815e-17,   7.194334877226397e-19,  -4.212553788559859e-21,  -6.576223653263362e-23,
   1.152410824041246e-24,  -1.383238360280062e-28,   6.520651524651564e-01,  -8.027566413431639e-03,   4.118784341367253e-05,   1.875524300225027e-07,  -4.580184355431806e-09,
   1.430689301833795e-11,   3.947651073470478e-13,  -4.732578768299084e-15,  -1.227541808639176e-17,   7.192414808217289e-19,  -4.208520878378898e-21,  -6.576275044100973e-23,
   1.151589956345900e-24,  -1.301122621149467e-28,   6.520659127955769e-01,  -8.027556013274621e-03,   4.118733583955250e-05,   1.875550700883048e-07,  -4.580074958551650e-09,
   1.430505773716075e-11,   3.947587487676515e-13,  -4.732100518486130e-15,  -1.227891362075802e-17,   7.191746509501356e-19,  -4.207117411878851e-21,  -6.576292665620532e-23,
   1.151304277614268e-24,  -1.272552248453246e-28,   6.520660334492565e-01,  -8.027554362908465e-03,   4.118725529490154e-05,   1.875554890200066e-07,  -4.580057598827487e-09,
   1.430476650899762e-11,   3.947577396933198e-13,  -4.732024628189526e-15,  -1.227946827818229e-17,   7.191640459646568e-19,  -4.206894711746641e-21,  -6.576295449309297e-23,
   1.151258945843103e-24,  -1.268019034647982e-28,   8.767302029494959e-01,  -9.184099851183982e-03,   1.975632916982237e-05,   4.771707433962940e-07,  -3.195689156557059e-09,
  -3.888019475805104e-11,   5.127383486342892e-13,   3.020074029003099e-15,  -8.049217301564496e-17,  -1.098990474071459e-19,   1.215505756049263e-20,  -3.275204101194427e-23,
  -1.732831936387218e-24,   1.229798563860579e-26,   8.767320515014398e-01,  -9.183965775377865e-03,   1.975453565282195e-05,   4.771343432194638e-07,  -3.194970604320782e-09,
  -3.887425497673861e-11,   5.125281080608504e-13,   3.019698821108034e-15,  -8.044123544252239e-17,  -1.100644959670728e-19,   1.214442359817674e-20,  -3.266367441169829e-23,
  -1.730931907265107e-24,   1.226958876003495e-26,   8.767353131642581e-01,  -9.183729204819632e-03,   1.975137129183127e-05,   4.770701190592402e-07,  -3.193702947528694e-09,
  -3.886377474168183e-11,   5.121572437566975e-13,   3.019036309408127e-15,  -8.035139168782511e-17,  -1.103560637178652e-19,   1.212566934122580e-20,  -3.250791818271402e-23,
  -1.727581165521008e-24,   1.221954081829241e-26,   8.767392569696275e-01,  -9.183443155343014e-03,   1.974754547185513e-05,   4.769924662326982e-07,  -3.192170492411928e-09,
  -3.885110295729897e-11,   5.117089756176562e-13,   3.018234424085218e-15,  -8.024281369282643e-17,  -1.107080021424977e-19,   1.210300774795012e-20,  -3.231986234828285e-23,
  -1.723532633630907e-24,   1.215912247215336e-26,   8.767430853045195e-01,  -9.183165478300429e-03,   1.974383201748086e-05,   4.769170902906925e-07,  -3.190683239725369e-09,
  -3.883880248532346e-11,   5.112739982674204e-13,   3.017455163185169e-15,  -8.013747298669715e-17,  -1.110490004167713e-19,   1.208102527883996e-20,  -3.213760046566972e-23,
  -1.719605760517820e-24,   1.210057415349564e-26,   8.767461691871635e-01,  -9.182941795916499e-03,   1.974084092632142e-05,   4.768563741994744e-07,  -3.189485435039306e-09,
  -3.882889415713558e-11,   5.109237248363462e-13,   3.016826824930727e-15,  -8.005265838711172e-17,  -1.113232335591752e-19,   1.206332867176401e-20,  -3.199098701531747e-23,
  -1.716444737435155e-24,   1.205348336900414e-26,   8.767482068766110e-01,  -9.182793995786656e-03,   1.973886467188589e-05,   4.768162569215745e-07,  -3.188694097196652e-09,
  -3.882234728858472e-11,   5.106923382680420e-13,   3.016411348525535e-15,  -7.999663717178203e-17,  -1.115042116744551e-19,   1.205164103239230e-20,  -3.189421232510726e-23,
  -1.714357171701317e-24,   1.202240329531755e-26,   8.767492533012741e-01,  -9.182718094957548e-03,   1.973784983416369e-05,   4.767956556561109e-07,  -3.188287753780818e-09,
  -3.881898527532911e-11,   5.105735311806557e-13,   3.016197894452847e-15,  -7.996787463456223e-17,  -1.115970814232745e-19,   1.204564071405393e-20,  -3.184454630352747e-23,
  -1.713285472281257e-24,   1.200645352602026e-26,   8.767496175147632e-01,  -9.182691677235136e-03,   1.973749662070817e-05,   4.767884853365083e-07,  -3.188146329624970e-09,
  -3.881781511445727e-11,   5.105321826266627e-13,   3.016123585952964e-15,  -7.995786469028830e-17,  -1.116293942623159e-19,   1.204355254178371e-20,  -3.182726474833853e-23,
  -1.712912515660419e-24,   1.200090386675831e-26,   8.767496753102286e-01,  -9.182687485118583e-03,   1.973744057107713e-05,   4.767873475121613e-07,  -3.188123887910037e-09,
  -3.881762942692714e-11,   5.105256213391960e-13,   3.016111793559775e-15,  -7.995627630316798e-17,  -1.116345213271646e-19,   1.204322119153461e-20,  -3.182452264839100e-23,
  -1.712853335342836e-24,   1.200002329789358e-26,   1.113035943234504e+00,  -9.414165235943467e-03,  -1.102380902266262e-05,   5.574225202972673e-07,   1.493013805008003e-09,
  -5.943402836546112e-11,  -2.336184415973359e-13,   7.687309554615581e-15,   3.925621898916558e-17,  -1.099565786402217e-18,  -6.911178648830042e-21,   1.668835095836149e-22,
   1.250410307440636e-24,  -2.637706006811980e-26,   1.113034911436570e+00,  -9.414008656954485e-03,  -1.102297105096268e-05,   5.573669276999486e-07,   1.492686490368561e-09,
  -5.941895263012156e-11,  -2.335159905734177e-13,   7.683620736322733e-15,   3.922730794138868e-17,  -1.098712697229240e-18,  -6.903531537117238e-21,   1.666929107139014e-22,
   1.248467808593907e-24,  -2.633558419345602e-26,   1.113033090876505e+00,  -9.413732383550632e-03,  -1.102149258609384e-05,   5.572688451584708e-07,   1.492109055425815e-09,
  -5.939235715094142e-11,  -2.333352756786786e-13,   7.677114093660615e-15,   3.917632009170682e-17,  -1.097208204605644e-18,  -6.890047823212175e-21,   1.663568416312631e-22,
   1.245043537194286e-24,  -2.626246994816329e-26,   1.113030889544295e+00,  -9.413398332426774e-03,  -1.101970506524370e-05,   5.571502622573733e-07,   1.491411014178630e-09,
  -5.936020765884225e-11,  -2.331168582045907e-13,   7.669250172128690e-15,   3.911470960238961e-17,  -1.095390313688615e-18,  -6.873759759965359e-21,   1.659508818240968e-22,
   1.240908490673672e-24,  -2.617417967555221e-26,   1.113028752642672e+00,  -9.413074064024401e-03,  -1.101797003758132e-05,   5.570351645046076e-07,   1.490733576415655e-09,
  -5.932900800469227e-11,  -2.329049321109814e-13,   7.661620179450069e-15,   3.905494584298668e-17,  -1.093626957461939e-18,  -6.857964946107520e-21,   1.655572209731893e-22,
   1.236900136971253e-24,  -2.608859480277509e-26,   1.113027031263887e+00,  -9.412812853840661e-03,  -1.101657251287088e-05,   5.569424579192107e-07,   1.490187990778965e-09,
  -5.930388150161325e-11,  -2.327342858497118e-13,   7.655476540310015e-15,   3.900683433045089e-17,  -1.092207437988543e-18,  -6.845253274793310e-21,   1.652404064092762e-22,
   1.233675266382512e-24,  -2.601973878049213e-26,   1.113025893847291e+00,  -9.412640258747679e-03,  -1.101564914694895e-05,   5.568812062395313e-07,   1.489827550649739e-09,
  -5.928728204320636e-11,  -2.326215643324338e-13,   7.651418393385776e-15,   3.897505944276725e-17,  -1.091269942685062e-18,  -6.836859708500154e-21,   1.650312143824373e-22,
   1.231546387421965e-24,  -2.597428399485201e-26,   1.113025309741765e+00,  -9.412551625365412e-03,  -1.101517498328281e-05,   5.568497527916107e-07,   1.489642470012527e-09,
  -5.927875856716715e-11,  -2.325636883409097e-13,   7.649334792283788e-15,   3.895874656994510e-17,  -1.090788647907834e-18,  -6.832551089907531e-21,   1.649238316833030e-22,
   1.230453742308799e-24,  -2.595095440145395e-26,   1.113025106440449e+00,  -9.412520776096075e-03,  -1.101500995087981e-05,   5.568388054844864e-07,   1.489578054601928e-09,
  -5.927579207476519e-11,  -2.325435459664605e-13,   7.648609647711332e-15,   3.895306952935888e-17,  -1.090621153352272e-18,  -6.831051734861091e-21,   1.648864636982298e-22,
   1.230073538404352e-24,  -2.594283648946943e-26,   1.113025074179423e+00,  -9.412515880760457e-03,  -1.101498376272884e-05,   5.568370683143944e-07,   1.489567832934311e-09,
  -5.927532134189175e-11,  -2.325403497389696e-13,   7.648494580666340e-15,   3.895216869937765e-17,  -1.090594575436038e-18,  -6.830813822062932e-21,   1.648805342718680e-22,
   1.230013210086163e-24,  -2.594154839148242e-26,   1.348077052613222e+00,  -8.572573352716243e-03,  -4.011409442823313e-05,   3.294734126636268e-07,   5.395381701610909e-09,
  -7.460382170355655e-12,  -7.171573867813980e-13,  -3.092746351863902e-15,   8.510065500992294e-17,   9.687867081473413e-19,  -7.470490890019865e-21,  -2.009893117285919e-22,
  -2.888356721091540e-27,   3.372260766657371e-26,   1.348073298005090e+00,  -8.572480713325821e-03,  -4.011106520831580e-05,   3.294663678598484e-07,   5.394375834080213e-09,
  -7.466419479864324e-12,  -7.169346488375461e-13,  -3.089503433787973e-15,   8.506914135706446e-17,   9.677598441263863e-19,  -7.470428160546121e-21,  -2.007451569460540e-22,
  -1.141647225271163e-27,   3.367830715545707e-26,   1.348066673170082e+00,  -8.572317251281217e-03,  -4.010572056141380e-05,   3.294539326068394e-07,   5.392601219368598e-09,
  -7.477067230167464e-12,  -7.165416914783269e-13,  -3.083784064372789e-15,   8.501353530579516e-17,   9.659489473898790e-19,  -7.470308741595979e-21,  -2.003146048134611e-22,
   1.935475486651975e-27,   3.360017836413566e-26,   1.348058662741135e+00,  -8.572119593988478e-03,  -4.009925854033400e-05,   3.294388879493622e-07,   5.390455769968039e-09,
  -7.489933778945540e-12,  -7.160666379017666e-13,  -3.076872932066528e-15,   8.494629638078506e-17,   9.637609318142532e-19,  -7.470149467551289e-21,  -1.997944245444923e-22,
   5.647893240234813e-27,   3.350577268153385e-26,   1.348050886766184e+00,  -8.571927714599286e-03,  -4.009298614203714e-05,   3.294242746741988e-07,   5.388373458894971e-09,
  -7.502415164610672e-12,  -7.156055841837860e-13,  -3.070168738365964e-15,   8.488102255253968e-17,   9.616386654291277e-19,  -7.469979295692246e-21,  -1.992899114446740e-22,
   9.242983423879082e-27,   3.341419701636716e-26,   1.348044622836208e+00,  -8.571773141129311e-03,  -4.008793376692808e-05,   3.294124965497328e-07,   5.386696301463697e-09,
  -7.512463390955881e-12,  -7.152342513342189e-13,  -3.064771517831742e-15,   8.482843922224176e-17,   9.599302994775565e-19,  -7.469831080294141e-21,  -1.988838180710019e-22,
   1.213280039645295e-26,   3.334047626412611e-26,   1.348040483886964e+00,  -8.571671002748065e-03,  -4.008459553503272e-05,   3.294047109066536e-07,   5.385588224961768e-09,
  -7.519099841849399e-12,  -7.149889233245489e-13,  -3.061206888070213e-15,   8.479369330582914e-17,   9.588020800116514e-19,  -7.469727700234517e-21,  -1.986156431701963e-22,
   1.403923840765608e-26,   3.329178808265148e-26,   1.348038358383048e+00,  -8.571618550115822e-03,  -4.008288128215400e-05,   3.294007117195780e-07,   5.385019223904322e-09,
  -7.522506975759596e-12,  -7.148629486797253e-13,  -3.059376823476511e-15,   8.477584968220741e-17,   9.582228826811183e-19,  -7.469672927967762e-21,  -1.984779733460362e-22,
   1.501732702381985e-26,   3.326679215957073e-26,   1.348037618589040e+00,  -8.571600293546765e-03,  -4.008228463489783e-05,   3.293993196247277e-07,   5.384821185715162e-09,
  -7.523692700552772e-12,  -7.148191041248112e-13,  -3.058739939224347e-15,   8.476963905640361e-17,   9.580213191590656e-19,  -7.469653596373542e-21,  -1.984300641923373e-22,
   1.535760718485962e-26,   3.325809333955687e-26,   1.348037501194256e+00,  -8.571597396483062e-03,  -4.008218995586750e-05,   3.293990987117459e-07,   5.384789760154135e-09,
  -7.523880851182181e-12,  -7.148121466962365e-13,  -3.058638878570492e-15,   8.476865351613849e-17,   9.579893352952671e-19,  -7.469650516014056e-21,  -1.984224620534661e-22,
   1.541159771967489e-26,   3.325671301548793e-26,   1.567251136080330e+00,  -6.759826386112808e-03,  -5.508706592407473e-05,  -7.519153861611715e-08,   4.305158557324010e-09,
   5.096848753336599e-11,  -1.131090430180678e-14,  -6.980141926454964e-15,  -7.364585203905571e-17,   2.340382878587096e-19,   1.398663342747713e-20,   1.199925090898005e-22,
  -9.189368290873367e-25,  -3.052710607384243e-26,   1.567245976539130e+00,  -6.759847365816632e-03,  -5.508464438096618e-05,  -7.514387117234436e-08,   4.305140381459715e-09,
   5.095475825785639e-11,  -1.150301004352652e-14,  -6.979336178931316e-15,  -7.358703166301637e-17,   2.346483851884582e-19,   1.398087216087321e-20,   1.197708994611857e-22,
  -9.205708016128657e-25,  -3.049779826023639e-26,   1.567236872631931e+00,  -6.759884373955197e-03,  -5.508037153883785e-05,  -7.505977167700006e-08,   4.305108090706452e-09,
   5.093053403235307e-11,  -1.184185823426055e-14,  -6.977912757018007e-15,  -7.348326200893823e-17,   2.357239842036037e-19,   1.397069815391244e-20,   1.193800403831306e-22,
  -9.234486893997464e-25,  -3.044605692017319e-26,   1.567225864404520e+00,  -6.759929106044016e-03,  -5.507520478752430e-05,  -7.495809550158005e-08,   4.305068670803563e-09,
   5.090124405356387e-11,  -1.225138327695473e-14,  -6.976188698150134e-15,  -7.335781645648355e-17,   2.370230293673233e-19,   1.395838173828223e-20,   1.189077072236445e-22,
  -9.269196606072783e-25,  -3.038344442823165e-26,   1.567215178137183e+00,  -6.759972511760600e-03,  -5.507018901062353e-05,  -7.485940870407222e-08,   4.305030011561048e-09,
   5.087281216945762e-11,  -1.264871923690373e-14,  -6.974512037874246e-15,  -7.323607152800368e-17,   2.382824653171168e-19,   1.394641064481081e-20,   1.184494863761507e-22,
  -9.302798002169507e-25,  -3.032261298599985e-26,   1.567206569655112e+00,  -6.760007464927861e-03,  -5.506614837738808e-05,  -7.477992128228785e-08,   4.304998588056502e-09,
   5.084990947747727e-11,  -1.296864754851768e-14,  -6.973159213028345e-15,  -7.313802080830589e-17,   2.392958654704409e-19,   1.393675649294835e-20,   1.180805732710540e-22,
  -9.329799411872768e-25,  -3.027357347174007e-26,   1.567200881439028e+00,  -6.760030554546275e-03,  -5.506347840453734e-05,  -7.472740396040404e-08,   4.304977686845146e-09,
   5.083477660206528e-11,  -1.317997196642103e-14,  -6.972264248621707e-15,  -7.307324308846166e-17,   2.399649221796469e-19,   1.393037211847411e-20,   1.178369116080767e-22,
  -9.347608463090958e-25,  -3.024115219476866e-26,   1.567197960303622e+00,  -6.760042410063630e-03,  -5.506210724746517e-05,  -7.470043582847768e-08,   4.304966910675193e-09,
   5.082700539878639e-11,  -1.328847288848800e-14,  -6.971804319509817e-15,  -7.303998048126775e-17,   2.403083354632765e-19,   1.392709186616824e-20,   1.177118135715648e-22,
  -9.356744061978562e-25,  -3.022449712067987e-26,   1.567196943581380e+00,  -6.760046536149668e-03,  -5.506163000396703e-05,  -7.469104964568712e-08,   4.304963153181439e-09,
   5.082430060050193e-11,  -1.332623376314001e-14,  -6.971644185709057e-15,  -7.302840373951059e-17,   2.404278350522670e-19,   1.392594989440759e-20,   1.176682774498239e-22,
  -9.359922167194730e-25,  -3.021869934319556e-26,   1.567196782241833e+00,  -6.760047190886777e-03,  -5.506155427200977e-05,  -7.468956020305666e-08,   4.304962556598540e-09,
   5.082387138817318e-11,  -1.333222571042057e-14,  -6.971618772246969e-15,  -7.302656669914867e-17,   2.404467966360067e-19,   1.392576866735534e-20,   1.176613691230495e-22,
  -9.360426411651247e-25,  -3.021777927654333e-26,   1.755096699813833e+00,  -4.365468464051715e-03,  -4.927289077318155e-05,  -3.535399253055549e-07,  -3.874899372579269e-10,
   3.189057206337331e-11,   5.056296924676760e-13,   3.398639762856172e-15,  -1.737575626789578e-17,  -7.522391740932773e-19,  -9.210018938966170e-21,  -3.170029419431871e-23,
   9.236631715506999e-25,   1.991640517085778e-26,   1.755092080059979e+00,  -4.365567791443429e-03,  -4.927310472567320e-05,  -3.535099720763738e-07,  -3.867794469724892e-10,
   3.189722266516702e-11,   5.055832831528915e-13,   3.396096869552884e-15,  -1.741442468716264e-17,  -7.523969730547822e-19,  -9.204236155110353e-21,  -3.155490720009616e-23,
   9.251267819084391e-25,   1.991192519159439e-26,   1.755083928415675e+00,  -4.365743049332618e-03,  -4.927348192342878e-05,  -3.534571140749127e-07,  -3.855258290406017e-10,
   3.190895368467179e-11,   5.055013107751765e-13,   3.391609465422675e-15,  -1.748263582883412e-17,  -7.526748026007429e-19,  -9.194025010334416e-21,  -3.129839690221578e-23,
   9.277065345376601e-25,   1.990396748898265e-26,   1.755074071333102e+00,  -4.365954961353828e-03,  -4.927393748122196e-05,  -3.533931889936888e-07,  -3.840100318803074e-10,
   3.192313201525800e-11,   5.054020484105511e-13,   3.386182518248973e-15,  -1.756508353470453e-17,  -7.530097183921869e-19,  -9.181665093520480e-21,  -3.098826874159199e-23,
   9.308212046825476e-25,   1.989425512009260e-26,   1.755064502219519e+00,  -4.366160669632191e-03,  -4.927437914896810e-05,  -3.533311226061612e-07,  -3.825386176509772e-10,
   3.193688882136334e-11,   5.053055391429807e-13,   3.380913368723343e-15,  -1.764508678162503e-17,  -7.533337612682030e-19,  -9.169653231674433e-21,  -3.068725100721948e-23,
   9.338398500574704e-25,   1.988473250634017e-26,   1.755056793445690e+00,  -4.366326376772930e-03,  -4.927473453529838e-05,  -3.532811162668701e-07,  -3.813533339052683e-10,
   3.194796591482509e-11,   5.052276871743677e-13,   3.376668064622065e-15,  -1.770951086378769e-17,  -7.535940268221004e-19,  -9.159967277126990e-21,  -3.044479056206115e-23,
   9.362680315535283e-25,   1.987699389040380e-26,   1.755051699615303e+00,  -4.366435868803721e-03,  -4.927496916483919e-05,  -3.532480698042018e-07,  -3.805701530458403e-10,
   3.195528290941966e-11,   5.051761924050293e-13,   3.373862576492649e-15,  -1.775206866126162e-17,  -7.537656241890445e-19,  -9.153562394047582e-21,  -3.028459449188061e-23,
   9.378707674417207e-25,   1.987184740377927e-26,   1.755049083686586e+00,  -4.366492096871945e-03,  -4.927508959542826e-05,  -3.532310978859210e-07,  -3.801679625734842e-10,
   3.195903974715895e-11,   5.051497314291387e-13,   3.372421741676614e-15,  -1.777392026311767e-17,  -7.538536296792911e-19,  -9.150271765437366e-21,  -3.020233156490010e-23,
   9.386933036089954e-25,   1.986919425079630e-26,   1.755048173188150e+00,  -4.366511667354493e-03,  -4.927513150238294e-05,  -3.532251904985776e-07,  -3.800279781482376e-10,
   3.196034722331073e-11,   5.051405189054312e-13,   3.371920232810013e-15,  -1.778152529806801e-17,  -7.538842420159422e-19,  -9.149126206861747e-21,  -3.017370006419407e-23,
   9.389795080158221e-25,   1.986826917529957e-26,   1.755048028704565e+00,  -4.366514772910502e-03,  -4.927513815196406e-05,  -3.532242530701700e-07,  -3.800057646262746e-10,
   3.196055469580515e-11,   5.051390568842783e-13,   3.371840649637370e-15,  -1.778273208316901e-17,  -7.538890988806241e-19,  -9.148944411805289e-21,  -3.016915668041601e-23,
   9.390249205907812e-25,   1.986812230159598e-26,   1.896766296195608e+00,  -2.017577351467765e-03,  -2.776195233649214e-05,  -3.085416807409651e-07,  -2.743665391502871e-09,
  -1.659623564622980e-11,   5.561035389311463e-15,   2.029729067374170e-15,   3.647333115361730e-17,   4.179827456110761e-19,   3.031785701781695e-21,   5.782203923262217e-25,
  -4.155397169710497e-25,  -8.191327215931489e-27,   1.896763690419680e+00,  -2.017664183322485e-03,  -2.776349559407597e-05,  -3.085572058728713e-07,  -2.743656435562711e-09,
  -1.659221718602634e-11,   5.657039857481426e-15,   2.031139763527144e-15,   3.648603732855735e-17,   4.179833777684080e-19,   3.029174842448911e-21,   5.179065778988479e-25,
  -4.163967326057955e-25,  -8.198862068849181e-27,   1.896759092369372e+00,  -2.017817403042513e-03,  -2.776621869203841e-05,  -3.085845971430215e-07,  -2.743640522801505e-09,
  -1.658512429171208e-11,   5.826468319982836e-15,   2.033628959124801e-15,   3.650844858466565e-17,   4.179842399571288e-19,   3.024563628740773e-21,   4.114372620915457e-25,
  -4.179089591877782e-25,  -8.212145918204931e-27,   1.896753532157143e+00,  -2.018002684011434e-03,  -2.776951148378569e-05,  -3.086177137249033e-07,  -2.743621093572370e-09,
  -1.657654363792935e-11,   6.031389167321526e-15,   2.036638920634761e-15,   3.653553317709816e-17,   4.179848505627964e-19,   3.018980348635430e-21,   2.826173575856664e-25,
  -4.197375736757584e-25,  -8.228189227411422e-27,   1.896748134189218e+00,  -2.018182557899965e-03,  -2.777270806121873e-05,  -3.086498572461737e-07,  -2.743602035796752e-09,
  -1.656820965588381e-11,   6.230371079527125e-15,   2.039560938136697e-15,   3.656181035596686e-17,   4.179849908184506e-19,   3.013552498801704e-21,   1.574816242612691e-25,
  -4.215127737615335e-25,  -8.243743170244265e-27,   1.896743785505890e+00,  -2.018327466501230e-03,  -2.777528317681220e-05,  -3.086757477191716e-07,  -2.743586542493198e-09,
  -1.656149301949506e-11,   6.390702915878937e-15,   2.041914876271128e-15,   3.658296738301772e-17,   4.179847794698744e-19,   3.009174377842825e-21,   5.661691417599688e-26,
  -4.229428597545788e-25,  -8.256258424183436e-27,   1.896740911899695e+00,  -2.018423221744203e-03,  -2.777698476456012e-05,  -3.086928537579832e-07,  -2.743576235941423e-09,
  -1.655705337137251e-11,   6.496664271261139e-15,   2.043470315912868e-15,   3.659694192222554e-17,   4.179844809642127e-19,   3.006278692857019e-21,  -1.006057641000259e-26,
  -4.238878384497909e-25,  -8.264521025176632e-27,   1.896739436142618e+00,  -2.018472397329930e-03,  -2.777785861042978e-05,  -3.087016379321392e-07,  -2.743570921738937e-09,
  -1.655477296220072e-11,   6.551085733331027e-15,   2.044269108327101e-15,   3.660411676948106e-17,   4.179842785314640e-19,   3.004790784861297e-21,  -4.431127888279924e-26,
  -4.243731311504504e-25,  -8.268762020209839e-27,   1.896738922488223e+00,  -2.018489513452205e-03,  -2.777816276035050e-05,  -3.087046952496217e-07,  -2.743569068691756e-09,
  -1.655397917526545e-11,   6.570028455071090e-15,   2.044547135296225e-15,   3.660661376253369e-17,   4.179842002495247e-19,   3.004272771892140e-21,  -5.623392163127366e-26,
  -4.245420418565723e-25,  -8.270237779637452e-27,   1.896738840978172e+00,  -2.018492229550274e-03,  -2.777821102474760e-05,  -3.087051803993005e-07,  -2.743568774477735e-09,
  -1.655385320890502e-11,   6.573034443694329e-15,   2.044591254344934e-15,   3.660700998773161e-17,   4.179841874558404e-19,   3.004190564055824e-21,  -5.812594596527405e-26,
  -4.245688456656850e-25,  -8.270471945347849e-27,   1.980010228793547e+00,  -4.113268555176072e-04,  -6.276048930546550e-06,  -8.381808778582684e-08,  -1.028681479179038e-09,
  -1.181331007562929e-11,  -1.275904206102324e-13,  -1.291302357287816e-15,  -1.207793076830087e-17,  -1.009878601928318e-19,  -6.896570486936369e-22,  -2.504207454848562e-24,
   2.898945833255583e-26,   8.957131035646872e-28,   1.980009639251480e+00,  -4.113504683983908e-04,  -6.276628577854877e-06,  -8.382918416792298e-08,  -1.028861278593621e-09,
  -1.181585774952060e-11,  -1.276221850633228e-13,  -1.291643519433737e-15,  -1.208083426000494e-17,  -1.010005125081007e-19,  -6.894715985712467e-22,  -2.497543615374869e-24,
   2.912034480499346e-26,   8.977742070047026e-28,   1.980008598950911e+00,  -4.113921362396319e-04,  -6.277651456978201e-06,  -8.384876585247961e-08,  -1.029178573833451e-09,
  -1.182035370647503e-11,  -1.276782401341479e-13,  -1.292245539941310e-15,  -1.208595687544934e-17,  -1.010228096656655e-19,  -6.891437083245478e-22,  -2.485772875596992e-24,
   2.935149162908846e-26,   9.014137667077350e-28,   1.980007340932779e+00,  -4.114425257724599e-04,  -6.278888473732348e-06,  -8.387244754926662e-08,  -1.029562312602469e-09,
  -1.182579119717663e-11,  -1.277460330844461e-13,  -1.292973568402008e-15,  -1.209215010167798e-17,  -1.010497237608849e-19,  -6.887460929020588e-22,  -2.471518604441535e-24,
   2.963133047857072e-26,   9.058193840128038e-28,   1.980006119591412e+00,  -4.114914475976012e-04,  -6.280089495213432e-06,  -8.389544080196077e-08,  -1.029934904462615e-09,
  -1.183107079454898e-11,  -1.278118563639535e-13,  -1.293680387368929e-15,  -1.209816122973381e-17,  -1.010758013287680e-19,  -6.883589136533101e-22,  -2.457658834357859e-24,
   2.990334276879159e-26,   9.101011240613609e-28,   1.980005135637982e+00,  -4.115308616361353e-04,  -6.281057127856196e-06,  -8.391396635481261e-08,  -1.030235106128953e-09,
  -1.183532466852725e-11,  -1.278648906632913e-13,  -1.294249835582230e-15,  -1.210300289184091e-17,  -1.010967730999639e-19,  -6.880461602385963e-22,  -2.446477832160410e-24,
   3.012272294187369e-26,   9.135539096244261e-28,   1.980004485431316e+00,  -4.115569073232431e-04,  -6.281696573858309e-06,  -8.392620892816759e-08,  -1.030433496816105e-09,
  -1.183813589493226e-11,  -1.278999386616978e-13,  -1.294626138363870e-15,  -1.210620177165657e-17,  -1.011106132439558e-19,  -6.878390834694273e-22,  -2.439081908642254e-24,
   3.026780821258358e-26,   9.158371491195574e-28,   1.980004151510494e+00,  -4.115702835223575e-04,  -6.282024975932194e-06,  -8.393249645208693e-08,  -1.030535386970032e-09,
  -1.183957970005357e-11,  -1.279179386851537e-13,  -1.294819394507074e-15,  -1.210784442436298e-17,  -1.011177153655076e-19,  -6.877326112810999e-22,  -2.435281360794345e-24,
   3.034235441777728e-26,   9.170102278085106e-28,   1.980004035284927e+00,  -4.115749393093707e-04,  -6.282139281821630e-06,  -8.393468494234212e-08,  -1.030570851892546e-09,
  -1.184008224649975e-11,  -1.279242039490788e-13,  -1.294886660137324e-15,  -1.210841614474727e-17,  -1.011201864553269e-19,  -6.876955322213101e-22,  -2.433958165183548e-24,
   3.036830695414647e-26,   9.174186123334161e-28,   1.980004016841465e+00,  -4.115756781223717e-04,  -6.282157420712630e-06,  -8.393503222845250e-08,  -1.030576479740553e-09,
  -1.184016199449958e-11,  -1.279251981692405e-13,  -1.294897334316752e-15,  -1.210850686795188e-17,  -1.011205785420074e-19,  -6.876896473147540e-22,  -2.433748174216012e-24,
   3.037242555133497e-26,   9.174834213090006e-28,   5.479601340276961e-03,  -9.112118049767645e-05,   1.133557403875057e-06,  -1.249658964015292e-08,   1.286112002666101e-10,
  -1.264621252958780e-12,   1.201578457202420e-14,  -1.110885177450681e-16,   1.002441068759699e-18,  -8.852933764164508e-21,   7.648557166792912e-23,  -6.472556794788157e-25,
   5.343420587269092e-27,  -4.310966601121883e-29,   5.479707756495140e-03,  -9.112469933952229e-05,   1.133629843105231e-06,  -1.249777706355543e-08,   1.286281286388433e-10,
  -1.264840434892777e-12,   1.201842266409241e-14,  -1.111184837074945e-16,   1.002764809641771e-18,  -8.856283498013328e-21,   7.651876729067510e-23,  -6.475723088903256e-25,
   5.346294693589510e-27,  -4.313484818875110e-29,   5.479895535121730e-03,  -9.113090866324437e-05,   1.133757671017348e-06,  -1.249987245806655e-08,   1.286580020371414e-10,
  -1.265227232875895e-12,   1.202307831067369e-14,  -1.111713683207748e-16,   1.003336169503394e-18,  -8.862195484928259e-21,   7.657735596356281e-23,  -6.481311563602285e-25,
   5.351367488534480e-27,  -4.317929539400117e-29,   5.480122608482260e-03,  -9.113841750751938e-05,   1.133912255111327e-06,  -1.250240651667646e-08,   1.286941304180470e-10,
  -1.265695035005256e-12,   1.202870914770920e-14,  -1.112353326514569e-16,   1.004027258336052e-18,  -8.869346588889795e-21,   7.664822669754376e-23,  -6.488071763229389e-25,
   5.357503935353804e-27,  -4.323306335311449e-29,   5.480343057254918e-03,  -9.114570744916576e-05,   1.134062336515709e-06,  -1.250486683557912e-08,   1.287292086170031e-10,
  -1.266149254966861e-12,   1.203417670215133e-14,  -1.112974445513882e-16,   1.004698359011826e-18,  -8.876291130541131e-21,   7.671705263505195e-23,  -6.494637125621227e-25,
   5.363463572968891e-27,  -4.328528331740267e-29,   5.480520655002264e-03,  -9.115158047931192e-05,   1.134183250061837e-06,  -1.250684905051020e-08,   1.287574710218655e-10,
  -1.266515230111303e-12,   1.203858217815963e-14,  -1.113474928680744e-16,   1.005239134898251e-18,  -8.881887264130555e-21,   7.677251644513390e-23,  -6.499928015158365e-25,
   5.368266357701755e-27,  -4.332736749399719e-29,   5.480638011898078e-03,  -9.115546144338812e-05,   1.134263152435841e-06,  -1.250815896762327e-08,   1.287761482076198e-10,
  -1.266757090058553e-12,   1.204149367172966e-14,  -1.113805696718197e-16,   1.005596541423977e-18,  -8.885585922598355e-21,   7.680917501725119e-23,  -6.503425080482280e-25,
   5.371440823078434e-27,  -4.335518402434445e-29,   5.480698281351995e-03,  -9.115745455683219e-05,   1.134304187630141e-06,  -1.250883170514992e-08,   1.287857404213663e-10,
  -1.266881306020875e-12,   1.204298899706595e-14,  -1.113975579771056e-16,   1.005780108876524e-18,  -8.887485618368069e-21,   7.682800375481625e-23,  -6.505221281528212e-25,
   5.373071332270320e-27,  -4.336947163521606e-29,   5.480719258858122e-03,  -9.115814828660787e-05,   1.134318470544442e-06,  -1.250906586276701e-08,   1.287890791723705e-10,
  -1.266924542005826e-12,   1.204350948008961e-14,  -1.114034711963504e-16,   1.005844004728078e-18,  -8.888146865902336e-21,   7.683455771622311e-23,  -6.505846512030613e-25,
   5.373638888806456e-27,  -4.337444496569370e-29,   5.480722587707544e-03,  -9.115825837236732e-05,   1.134320737057587e-06,  -1.250910302060094e-08,   1.287896089905958e-10,
  -1.266931403031526e-12,   1.204359207459067e-14,  -1.114044095562898e-16,   1.005854144286777e-18,  -8.888251798726809e-21,   7.683559776085069e-23,  -6.505945729697625e-25,
   5.373728954247936e-27,  -4.337523418357818e-29,   4.912197836239110e-02,  -8.030864881452475e-04,   9.635032536062374e-06,  -9.967112252493163e-08,   9.263997549233747e-10,
  -7.787848191686484e-12,   5.810328550545390e-14,  -3.617126851799300e-16,   1.468263661808884e-18,   3.999285267144523e-21,  -1.823539845431746e-22,   2.688759330973753e-24,
  -2.985856328835057e-26,   2.740710731503765e-28,   4.912288269193402e-02,  -8.031145463327401e-04,   9.635554096394796e-06,  -9.967842960355234e-08,   9.264815078731273e-10,
  -7.788560090840408e-12,   5.810712366017420e-14,  -3.616988238651618e-16,   1.467488386314618e-18,   4.013227415425938e-21,  -1.825395646313924e-22,   2.690769705273276e-24,
  -2.987648612616376e-26,   2.741841646948665e-28,   4.912447843547121e-02,  -8.031640571185805e-04,   9.636474435217802e-06,  -9.969132360146094e-08,   9.266257666230547e-10,
  -7.789816225750057e-12,   5.811389448649472e-14,  -3.616743270435623e-16,   1.466119763243850e-18,   4.037836989746000e-21,  -1.828671137968278e-22,   2.694317713577168e-24,
  -2.990811263683781e-26,   2.743836300786573e-28,   4.912640809352535e-02,  -8.032239289418437e-04,   9.637587382547050e-06,  -9.970691608688755e-08,   9.268002133185683e-10,
  -7.791335119358939e-12,   5.812207901395589e-14,  -3.616446398813582e-16,   1.464463722802090e-18,   4.067609533142976e-21,  -1.832633435170302e-22,   2.698609147270294e-24,
  -2.994635809781032e-26,   2.746246782240030e-28,   4.912828144328892e-02,  -8.032820544582143e-04,   9.638667879352427e-06,  -9.972205397087892e-08,   9.269695709757112e-10,
  -7.792809594983715e-12,   5.813002144882580e-14,  -3.616157516505480e-16,   1.462854929048728e-18,   4.096527267304241e-21,  -1.836481575027829e-22,   2.702776394500014e-24,
  -2.998348857481615e-26,   2.748585288904035e-28,   4.912979064046097e-02,  -8.033288817583811e-04,   9.639538361393341e-06,  -9.973424954767265e-08,   9.271060089072168e-10,
  -7.793997384675827e-12,   5.813641764745712e-14,  -3.615924306107104e-16,   1.461558089901439e-18,   4.119833813210745e-21,  -1.839582740286715e-22,   2.706134332495519e-24,
  -3.001340214829238e-26,   2.750468049551818e-28,   4.913078791602139e-02,  -8.033598254520071e-04,   9.640113583855907e-06,  -9.974230850751222e-08,   9.271961674058646e-10,
  -7.794782240879042e-12,   5.814064310145348e-14,  -3.615769964577662e-16,   1.460700762170350e-18,   4.135239649936568e-21,  -1.841632500009205e-22,   2.708353617986989e-24,
  -3.003316935540444e-26,   2.751711600206804e-28,   4.913130007245713e-02,  -8.033757168433572e-04,   9.640408995362047e-06,  -9.974644727412901e-08,   9.272424689573735e-10,
  -7.795185297740216e-12,   5.814281275252380e-14,  -3.615690628504669e-16,   1.460260359785610e-18,   4.143152919249277e-21,  -1.842685324428306e-22,   2.709493457101262e-24,
  -3.004332102445176e-26,   2.752350054592327e-28,   4.913147833442343e-02,  -8.033812480392389e-04,   9.640511817195994e-06,  -9.974788782648875e-08,   9.272585847714707e-10,
  -7.795325584678509e-12,   5.814356786822044e-14,  -3.615663003026157e-16,   1.460107054028037e-18,   4.145907465410446e-21,  -1.843051797425499e-22,   2.709890209209268e-24,
  -3.004685444753680e-26,   2.752572247670684e-28,   4.913150662220075e-02,  -8.033821257662977e-04,   9.640528133659736e-06,  -9.974811642310319e-08,   9.272611421356296e-10,
  -7.795347846250632e-12,   5.814368769224981e-14,  -3.615658618681467e-16,   1.460082725581631e-18,   4.146344586307980e-21,  -1.843109952963556e-22,   2.709953169285678e-24,
  -3.004741515509598e-26,   2.752607505378789e-28,   1.353507848474714e-01,  -2.136695218576431e-03,   2.372811919129321e-05,  -2.118664998970375e-07,   1.489319429200672e-09,
  -6.608110023344383e-12,  -1.605863744035163e-14,   7.769134157011326e-16,  -1.051790480014081e-17,   9.406047959595621e-20,  -5.120658952419899e-22,  -7.917410395916808e-25,
   6.243469989043111e-26,  -9.411628559143376e-28,   1.353530110357372e-01,  -2.136754827685536e-03,   2.372895680233493e-05,  -2.118726820805463e-07,   1.489296519685776e-09,
  -6.606575430628939e-12,  -1.608629120451784e-14,   7.772307546948006e-16,  -1.052005251947204e-17,   9.405612809259281e-20,  -5.116759953410049e-22,  -7.986524791933300e-25,
   6.251209585066959e-26,  -9.416929788699439e-28,   1.353569392438398e-01,  -2.136860010309249e-03,   2.373043476966348e-05,  -2.118835894695606e-07,   1.489256063852127e-09,
  -6.603867109723652e-12,  -1.613509128306507e-14,   7.777906922118485e-16,  -1.052384086362167e-17,   9.404842079335710e-20,  -5.109876215447161e-22,  -8.108509660442790e-25,
   6.264865681433730e-26,  -9.426277323804876e-28,   1.353616893839791e-01,  -2.136987200670689e-03,   2.373222192558157e-05,  -2.118967768039075e-07,   1.489207090283283e-09,
  -6.600591313119896e-12,  -1.619410866103922e-14,   7.784677539037624e-16,  -1.052841948344075e-17,   9.403905158307043e-20,  -5.101545688471569e-22,  -8.256068629832085e-25,
   6.281377847343591e-26,  -9.437569254670415e-28,   1.353663008518723e-01,  -2.137110677394390e-03,   2.373395684678387e-05,  -2.119095767482533e-07,   1.489159491097700e-09,
  -6.597410319601808e-12,  -1.625140987723490e-14,   7.791250118898622e-16,  -1.053286193283933e-17,   9.402990430859445e-20,  -5.093451606622766e-22,  -8.399372379535542e-25,
   6.297406588074306e-26,  -9.448519515872207e-28,   1.353700158721693e-01,  -2.137210150444466e-03,   2.373535446324446e-05,  -2.119198867181267e-07,   1.489121105332749e-09,
  -6.594847102826297e-12,  -1.629757684188324e-14,   7.796544747187350e-16,  -1.053643899513819e-17,   9.402249825536547e-20,  -5.086926139733345e-22,  -8.514856156852327e-25,
   6.310318422119804e-26,  -9.457332476424633e-28,   1.353724707314194e-01,  -2.137275881348716e-03,   2.373627797669151e-05,  -2.119266986285894e-07,   1.489095720881672e-09,
  -6.593153056705586e-12,  -1.632808601332426e-14,   7.800043266379872e-16,  -1.053880181308103e-17,   9.401758628526326e-20,  -5.082611789280853e-22,  -8.591185423579518e-25,
   6.318849981501959e-26,  -9.463151793909167e-28,   1.353737314314812e-01,  -2.137309637586779e-03,   2.373675224298934e-05,  -2.119301966435442e-07,   1.489082678621209e-09,
  -6.592282984579518e-12,  -1.634375481812393e-14,   7.801839899571291e-16,  -1.054001497296229e-17,   9.401505812991872e-20,  -5.080395409874966e-22,  -8.630390227257754e-25,
   6.323231236546697e-26,  -9.466139013932451e-28,   1.353741702316531e-01,  -2.137321386798127e-03,   2.373691731539176e-05,  -2.119314141235417e-07,   1.489078138167052e-09,
  -6.591980132345076e-12,  -1.634920863007703e-14,   7.802465230411980e-16,  -1.054043718293999e-17,   9.401417728694134e-20,  -5.079623858686977e-22,  -8.644036784848084e-25,
   6.324756155101954e-26,  -9.467178539699287e-28,   1.353742398632907e-01,  -2.137323251238223e-03,   2.373694351009313e-05,  -2.119316073191341e-07,   1.489077417613176e-09,
  -6.591932073122846e-12,  -1.635007408161401e-14,   7.802564461623975e-16,  -1.054050417988179e-17,   9.401403746678520e-20,  -5.079501418440819e-22,  -8.646202351480088e-25,
   6.324998137848881e-26,  -9.467343488458851e-28,   2.619625829676405e-01,  -3.913511959634613e-03,   3.815602597575938e-05,  -2.530668078851004e-07,   6.099517016718795e-10,
   1.161434678919118e-11,  -2.056407443387726e-13,   1.720655450184645e-15,  -3.834862065883009e-18,  -1.215679424413099e-19,   2.149841429360306e-21,  -1.810548598318442e-23,
   2.670260569369842e-26,   1.649310367582157e-27,   2.619661607734927e-01,  -3.913583096075829e-03,   3.815636743986690e-05,  -2.530558910365375e-07,   6.096624034052109e-10,
   1.161772775285404e-11,  -2.056506234024620e-13,   1.720242739838920e-15,  -3.825787536839676e-18,  -1.216608239941292e-19,   2.149995641216191e-21,  -1.809330518155013e-23,
   2.646500529247906e-26,   1.651493306754260e-27,   2.619724738941306e-01,  -3.913708614946193e-03,   3.815696982633785e-05,  -2.530366255103032e-07,   6.091519208339646e-10,
   1.162369285473978e-11,  -2.056680357968081e-13,   1.719514251423220e-15,  -3.809774868100109e-18,  -1.218246637721759e-19,   2.150266555158040e-21,  -1.807179902307356e-23,
   2.604574927939240e-26,   1.655342490472475e-27,   2.619801078312599e-01,  -3.913860389443516e-03,   3.815769801287721e-05,  -2.530133250395430e-07,   6.085346207240188e-10,
   1.163090479116728e-11,  -2.056890580236774e-13,   1.718632921569182e-15,  -3.790411295012968e-18,  -1.220226932738370e-19,   2.150592109078014e-21,  -1.804577148943798e-23,
   2.553876981832110e-26,   1.659992448879287e-27,   2.619875187715603e-01,  -3.914007725034856e-03,   3.815840468749580e-05,  -2.529907007485114e-07,   6.079353364487411e-10,
   1.163790483209589e-11,  -2.057094314517305e-13,   1.717776887572518e-15,  -3.771612552398399e-18,  -1.222148454102257e-19,   2.150906016870226e-21,  -1.802048132620251e-23,
   2.504659213641338e-26,   1.664501815836058e-27,   2.619934889618452e-01,  -3.914126413472843e-03,   3.815897380608975e-05,  -2.529724716201945e-07,   6.074525465034947e-10,
   1.164354312680446e-11,  -2.057258192390783e-13,   1.717086952349200e-15,  -3.756467872412160e-18,  -1.223695750969522e-19,   2.151157367656093e-21,  -1.800009136960832e-23,
   2.465009268192180e-26,   1.668131110229712e-27,   2.619974339734620e-01,  -3.914204839112172e-03,   3.815934978662866e-05,  -2.529604245243928e-07,   6.071335204990821e-10,
   1.164726839657784e-11,  -2.057366358631449e-13,   1.716630896170508e-15,  -3.746460216804951e-18,  -1.224717855965795e-19,   2.151322707009538e-21,  -1.798660995993086e-23,
   2.438808931589025e-26,   1.670527621048672e-27,   2.619994599307084e-01,  -3.914245113946124e-03,   3.815954284499078e-05,  -2.529542372655968e-07,   6.069696832144958e-10,
   1.164918137251242e-11,  -2.057421869645889e-13,   1.716396640251799e-15,  -3.741320707788627e-18,  -1.225242656421625e-19,   2.151407385113752e-21,  -1.797968411005476e-23,
   2.425353695988953e-26,   1.671757829746782e-27,   2.620001650844802e-01,  -3.914259131893792e-03,   3.815961003664060e-05,  -2.529520836541251e-07,   6.069126578024159e-10,
   1.164984718087087e-11,  -2.057441184788625e-13,   1.716315097494125e-15,  -3.739531838865594e-18,  -1.225425302204549e-19,   2.151436821237792e-21,  -1.797727310650107e-23,
   2.420670460817599e-26,   1.672185933258250e-27,   2.620002769827102e-01,  -3.914261356345368e-03,   3.815962069883630e-05,  -2.529517419018760e-07,   6.069036086385193e-10,
   1.164995283451758e-11,  -2.057444249552149e-13,   1.716302157409335e-15,  -3.739247969257214e-18,  -1.225454284823699e-19,   2.151441490595143e-21,  -1.797689049454537e-23,
   2.419927295081332e-26,   1.672253863501536e-27,   4.254219059798083e-01,  -5.873532503252774e-03,   4.649927576783353e-05,  -1.444388864235062e-07,  -1.847018579308364e-09,
   3.198111029053298e-11,  -1.785325250579188e-13,  -1.265039818919029e-15,   3.436261288045910e-17,  -2.664067780560402e-19,  -8.393970076028102e-22,   4.272284143485048e-23,
  -4.272131561940598e-25,  -8.430994244656658e-29,   4.254262631898755e-01,  -5.873573021081577e-03,   4.649823541136433e-05,  -1.444089252647023e-07,  -1.847268574467534e-09,
   3.197860555079004e-11,  -1.784423985060161e-13,  -1.265933198790717e-15,   3.435898751547431e-17,  -2.661865299087728e-19,  -8.420181298485733e-22,   4.272184507626896e-23,
  -4.267330537659241e-25,  -9.120469637707109e-29,   4.254339514762386e-01,  -5.873644508581833e-03,   4.649639957190478e-05,  -1.443560602413138e-07,  -1.847709591854621e-09,
   3.197418447092736e-11,  -1.782833765729481e-13,  -1.267508977348002e-15,   3.435258153132272e-17,  -2.657979031476600e-19,  -8.466407250280446e-22,   4.272004609894513e-23,
  -4.258857972545919e-25,  -1.033629634431225e-28,   4.254432480989568e-01,  -5.873730940358118e-03,   4.649417946069190e-05,  -1.442921385521764e-07,  -1.848242699166745e-09,
   3.196883602111702e-11,  -1.780910988405860e-13,  -1.269413395276281e-15,   3.434482005689323e-17,  -2.653279794075220e-19,  -8.522262962205083e-22,   4.271780107183581e-23,
  -4.248611018260927e-25,  -1.180518476839189e-28,   4.254522729576781e-01,  -5.873814834607114e-03,   4.649202401149459e-05,  -1.442300878997046e-07,  -1.848760046612969e-09,
   3.196364129185959e-11,  -1.779044528782725e-13,  -1.271261092285707e-15,   3.433726934762725e-17,  -2.648717939885858e-19,  -8.576443568529328e-22,   4.271554870515863e-23,
  -4.238661536949448e-25,  -1.322979199324540e-28,   4.254595431649774e-01,  -5.873882409965452e-03,   4.649028746375711e-05,  -1.441801031498314e-07,  -1.849176683226641e-09,
   3.195945466137193e-11,  -1.777541033121799e-13,  -1.272748799912931e-15,   3.433117513255741e-17,  -2.645043030811523e-19,  -8.620059838883623e-22,   4.271368199945650e-23,
  -4.230644998315995e-25,  -1.437645918779786e-28,   4.254643471387374e-01,  -5.873927058270569e-03,   4.648913991252521e-05,  -1.441470753168315e-07,  -1.849451924767360e-09,
   3.195668731761396e-11,  -1.776547598952996e-13,  -1.273731472105632e-15,   3.432714257382415e-17,  -2.642614746817829e-19,  -8.648865552023606e-22,   4.271242295247743e-23,
  -4.225347146268928e-25,  -1.513367749854974e-28,   4.254668141937514e-01,  -5.873949985985553e-03,   4.648855056797374e-05,  -1.441301143152047e-07,  -1.849593254518050e-09,
   3.195526587809105e-11,  -1.776037438130902e-13,  -1.274236004240344e-15,   3.432506992746511e-17,  -2.641367716307479e-19,  -8.663653981150431e-22,   4.271176846901288e-23,
  -4.222626240306872e-25,  -1.552239718103486e-28,   4.254676728723941e-01,  -5.873957965975614e-03,   4.648834543768971e-05,  -1.441242109423240e-07,  -1.849642442455964e-09,
   3.195477108909850e-11,  -1.775859874398883e-13,  -1.274411592634885e-15,   3.432434824782370e-17,  -2.640933677440388e-19,  -8.668800483791485e-22,   4.271153941215980e-23,
  -4.221679171412797e-25,  -1.565767103736855e-28,   4.254678091327526e-01,  -5.873959232280112e-03,   4.648831288617184e-05,  -1.441232741611543e-07,  -1.849650247753506e-09,
   3.195469257081341e-11,  -1.775831697594681e-13,  -1.274439455210177e-15,   3.432423371409739e-17,  -2.640864801522282e-19,  -8.669617127487826e-22,   4.271150300428004e-23,
  -4.221528883073254e-25,  -1.567913601544077e-28,   6.205848896151278e-01,  -7.690621566411949e-03,   4.303416701800618e-05,   1.168135994084574e-07,  -4.213942825454392e-09,
   2.226573756749947e-11,   2.601142493410936e-13,  -4.766002807523805e-15,   1.029374051139806e-17,   5.096943144465852e-19,  -5.987679165415921e-21,  -1.353222963949284e-23,
   9.506739552734207e-25,  -7.064307363667337e-27,   6.205889193062576e-01,  -7.690588639420407e-03,   4.303179874647784e-05,   1.168343948629750e-07,  -4.213576727881777e-09,
   2.225638184600253e-11,   2.601407531141268e-13,  -4.764284470612785e-15,   1.026866814738792e-17,   5.096225696806605e-19,  -5.981824481905249e-21,  -1.358298409789548e-23,
   9.500789772389033e-25,  -7.047910896037364e-27,   6.205960295794967e-01,  -7.690530534483591e-03,   4.302762006154105e-05,   1.168710816477485e-07,  -4.212930712847694e-09,
   2.223987627743272e-11,   2.601874660455335e-13,  -4.761252636359570e-15,   1.022444762244128e-17,   5.094957630695367e-19,  -5.971496798556443e-21,  -1.367244392636654e-23,
   9.490286802308039e-25,  -7.018998738560791e-27,   6.206046270907006e-01,  -7.690460265288354e-03,   4.302256743656231e-05,   1.169154315579346e-07,  -4.212149493271326e-09,
   2.221992225494592e-11,   2.602438608109769e-13,  -4.757586848430884e-15,   1.017100988092084e-17,   5.093420662292173e-19,  -5.959013566555287e-21,  -1.378045403258616e-23,
   9.477578861234413e-25,  -6.984071381184285e-27,   6.206129730841048e-01,  -7.690392040705050e-03,   4.301766273467202e-05,   1.169584729699561e-07,  -4.211391045167259e-09,
   2.220055614361999e-11,   2.602985126053268e-13,  -4.754028519885782e-15,   1.011916924060207e-17,   5.091924823888794e-19,  -5.946900417307088e-21,  -1.388513498380037e-23,
   9.465234235585006e-25,  -6.950199618732133e-27,   6.206196962774047e-01,  -7.690337073803859e-03,   4.301371178483636e-05,   1.169931374641634e-07,  -4.210780010826376e-09,
   2.218495857276114e-11,   2.603424711474679e-13,  -4.751162231339852e-15,   1.007743273494797e-17,   5.090717092878110e-19,  -5.937146060939354e-21,  -1.396934043528838e-23,
   9.455283865696257e-25,  -6.922938122330752e-27,   6.206241387309370e-01,  -7.690300749685998e-03,   4.301110117246115e-05,   1.170160386856195e-07,  -4.210376231426872e-09,
   2.217465369752709e-11,   2.603714847711275e-13,  -4.749268363759509e-15,   1.004986654699236e-17,   5.089917723268844e-19,  -5.930702436318725e-21,  -1.402492113387648e-23,
   9.448706053745186e-25,  -6.904936526740313e-27,   6.206264201084962e-01,  -7.690282094595402e-03,   4.300976053053295e-05,   1.170277981798096e-07,  -4.210168865576641e-09,
   2.216936218346768e-11,   2.603863743287855e-13,  -4.748295810774144e-15,   1.003571387159590e-17,   5.089506799954619e-19,  -5.927393908378071e-21,  -1.405344569650283e-23,
   9.445327172646394e-25,  -6.895695654566809e-27,   6.206272141572929e-01,  -7.690275601374139e-03,   4.300929391299712e-05,   1.170318909599539e-07,  -4.210096689069043e-09,
   2.216752050830530e-11,   2.603915551319168e-13,  -4.747957310954750e-15,   1.003078852114765e-17,   5.089363709274181e-19,  -5.926242437534658e-21,  -1.406337094161328e-23,
   9.444150985351198e-25,  -6.892479890682939e-27,   6.206273401616375e-01,  -7.690274570982413e-03,   4.300921986746572e-05,   1.170325404173760e-07,  -4.210085235607439e-09,
   2.216722826384501e-11,   2.603923771759916e-13,  -4.747903595987494e-15,   1.003000696519400e-17,   5.089340999665754e-19,  -5.926059719366604e-21,  -1.406494579937933e-23,
   9.443964334134831e-25,  -6.891969622025568e-27,   8.403448703480332e-01,  -9.004068882160496e-03,   2.515216272518552e-05,   4.205109965392186e-07,  -3.844894152178005e-09,
  -2.585118534603315e-11,   5.612910909779126e-13,   4.706815113516331e-16,  -7.624776398357642e-17,   3.256852637838496e-19,   9.158089872333930e-21,  -9.645177316035037e-23,
  -8.596377488239790e-25,   1.943481207954889e-26,   8.403472240260939e-01,  -9.003950699009956e-03,   2.515000441728580e-05,   4.204867690536601e-07,  -3.844107194462258e-09,
  -2.585024144192699e-11,   5.610917348819028e-13,   4.717678963401312e-16,  -7.620929897022091e-17,   3.251933871298213e-19,   9.152782161393458e-21,  -9.631138725371913e-23,
  -8.593956295959624e-25,   1.940337921892561e-26,   8.403513769641471e-01,  -9.003742168516852e-03,   2.514619640831770e-05,   4.204440199983469e-07,  -3.842718822780557e-09,
  -2.584857417568615e-11,   5.607400498950225e-13,   4.736834941207509e-16,  -7.614144504273845e-17,   3.243260497567868e-19,   9.143417850872283e-21,  -9.606386037440163e-23,
  -8.589674006656818e-25,   1.934796039227032e-26,   8.403563984617488e-01,  -9.003490020654452e-03,   2.514159233570845e-05,   4.203923286194443e-07,  -3.841040376900985e-09,
  -2.584655514678416e-11,   5.603149284086555e-13,   4.759975621269568e-16,  -7.605942636750666e-17,   3.232782560125765e-19,   9.132096525415899e-21,  -9.576486563576204e-23,
  -8.584478696478703e-25,   1.928102395638499e-26,   8.403612729520701e-01,  -9.003245249757432e-03,   2.513712342305151e-05,   4.203421488185691e-07,  -3.839411376914527e-09,
  -2.584459201826198e-11,   5.599023741471354e-13,   4.782416191760078e-16,  -7.597983653627618e-17,   3.222621223607331e-19,   9.121108180954583e-21,  -9.547493887315068e-23,
  -8.579417287601689e-25,   1.921612338482443e-26,   8.403651995684334e-01,  -9.003048072586972e-03,   2.513352378458075e-05,   4.203017255521973e-07,  -3.838099366706619e-09,
  -2.584300833464893e-11,   5.595701306118823e-13,   4.800476836673767e-16,  -7.591574327167731e-17,   3.214442875511868e-19,   9.112257694600275e-21,  -9.524161546651397e-23,
  -8.575327088744112e-25,   1.916389772552601e-26,   8.403677941039336e-01,  -9.002917784892320e-03,   2.513114543253696e-05,   4.202750150329061e-07,  -3.837232556190194e-09,
  -2.584196078181505e-11,   5.593506413119146e-13,   4.812402577950762e-16,  -7.587340297597884e-17,   3.209042435353566e-19,   9.106410226251300e-21,  -9.508755589407715e-23,
  -8.572618104415481e-25,   1.912941602788130e-26,   8.403691264903154e-01,  -9.002850876999272e-03,   2.512992410451942e-05,   4.202612980439848e-07,  -3.836787451565620e-09,
  -2.584142247852364e-11,   5.592379389200578e-13,   4.818524416348927e-16,  -7.585166273101242e-17,   3.206270184439236e-19,   9.103407511518339e-21,  -9.500847490905453e-23,
  -8.571224979503503e-25,   1.911171670931267e-26,   8.403695902345439e-01,  -9.002827589265065e-03,   2.512949902119139e-05,   4.202565237427939e-07,  -3.836632535837426e-09,
  -2.584123506384491e-11,   5.591987143461574e-13,   4.820654764358211e-16,  -7.584409640047255e-17,   3.205305457540392e-19,   9.102362427398261e-21,  -9.498095577433126e-23,
  -8.570739782264589e-25,   1.910555768146026e-26,   8.403696638241264e-01,  -9.002823893830473e-03,   2.512943156684725e-05,   4.202557661280121e-07,  -3.836607953177796e-09,
  -2.584120532118693e-11,   5.591924900663880e-13,   4.820992801599631e-16,  -7.584289575464430e-17,   3.205152377232346e-19,   9.102196588757438e-21,  -9.497658913847218e-23,
  -8.570662773557814e-25,   1.910458039416865e-26,   1.075245717629631e+00,  -9.475285274306054e-03,  -4.231417661222778e-06,   5.715719110181438e-07,   2.662722870319938e-10,
  -6.235409586165750e-11,  -7.030752885923562e-15,   8.272012098409743e-15,  -3.412169352596493e-18,  -1.216765104043268e-18,   1.222851980083671e-21,   1.902552447995842e-22,
  -3.175743455351401e-25,  -3.107720404917461e-26,   1.075245321235559e+00,  -9.475124725415314e-03,  -4.231267939810308e-06,   5.715135904827421e-07,   2.662622955371710e-10,
  -6.233787523084041e-11,  -7.039604739102885e-15,   8.267930835168976e-15,  -3.407072588519759e-18,  -1.215792819463196e-18,   1.220915202337003e-21,   1.900307751546889e-22,
  -3.169637612506700e-25,  -3.102665834101885e-26,   1.075244621803376e+00,  -9.474841447679339e-03,  -4.231003758612463e-06,   5.714106953222387e-07,   2.662446553081721e-10,
  -6.230926019217008e-11,  -7.055213133963210e-15,   8.260732043305613e-15,  -3.398085886114171e-18,  -1.214078146143451e-18,   1.217500785427426e-21,   1.896349942211885e-22,
  -3.158876043931035e-25,  -3.093755917776200e-26,   1.075243776061936e+00,  -9.474498927902643e-03,  -4.230684315714520e-06,   5.712862944349770e-07,   2.662233073773711e-10,
  -6.227466969519037e-11,  -7.074068499487123e-15,   8.252031723297905e-15,  -3.387230346603704e-18,  -1.212006343555605e-18,   1.213377245760176e-21,   1.891569216320082e-22,
  -3.145883970359728e-25,  -3.082997204221097e-26,   1.075242955051130e+00,  -9.474166439388955e-03,  -4.230374214281333e-06,   5.711655502357566e-07,   2.662025651984484e-10,
  -6.224110147373481e-11,  -7.092353630235540e-15,   8.243590351077548e-15,  -3.376703776843983e-18,  -1.209996746527049e-18,   1.209379635037160e-21,   1.886933505830053e-22,
  -3.133293381884452e-25,  -3.072568785945318e-26,   1.075242293670078e+00,  -9.473898607985818e-03,  -4.230124406479336e-06,   5.710682960595258e-07,   2.661858426958234e-10,
  -6.221406768434318e-11,  -7.107070051343562e-15,   8.236793491620798e-15,  -3.368232157422302e-18,  -1.208379039266149e-18,   1.206163113088360e-21,   1.883202857310417e-22,
  -3.123166234401914e-25,  -3.064179206809264e-26,   1.075241856648398e+00,  -9.473721638098400e-03,  -4.229959340813983e-06,   5.710040399576715e-07,   2.661747864640794e-10,
  -6.219620831703571e-11,  -7.116787626124449e-15,   8.232303912176572e-15,  -3.362638396131899e-18,  -1.207310673374243e-18,   1.204039601317119e-21,   1.880739580071080e-22,
  -3.116482059228989e-25,  -3.058641108415694e-26,   1.075241632219061e+00,  -9.473630758170273e-03,  -4.229874572587641e-06,   5.709710437636779e-07,   2.661691066124059e-10,
  -6.218703793866822e-11,  -7.121775971528331e-15,   8.229998812847662e-15,  -3.359767009953395e-18,  -1.206762197605604e-18,   1.202949666352663e-21,   1.879475147021631e-22,
  -3.113051783868597e-25,  -3.055798756372008e-26,   1.075241554104727e+00,  -9.473599126989246e-03,  -4.229845068372037e-06,   5.709595595164732e-07,   2.661671293780058e-10,
  -6.218384630527577e-11,  -7.123511877492488e-15,   8.229196583819216e-15,  -3.358767801092133e-18,  -1.206571324438711e-18,   1.202570398396650e-21,   1.879035141461348e-22,
  -3.111858222030219e-25,  -3.054809724475191e-26,   1.075241541709074e+00,  -9.473594107575924e-03,  -4.229840386466094e-06,   5.709577371426585e-07,   2.661668156034214e-10,
  -6.218333984654350e-11,  -7.123787326038510e-15,   8.229069285008819e-15,  -3.358609250061950e-18,  -1.206541036865225e-18,   1.202510218252062e-21,   1.878965323003069e-22,
  -3.111668838094990e-25,  -3.054652791776253e-26,   1.313172022743448e+00,  -8.876221378376715e-03,  -3.565047622558641e-05,   4.136471679597865e-07,   5.068760168655625e-09,
  -2.537385896771218e-11,  -7.608963526067460e-13,   1.137895969160259e-16,   1.125147035374047e-16,   4.996371907498905e-19,  -1.566010674918315e-20,  -1.560127009122130e-22,
   1.896781907780251e-24,   3.587916596169912e-26,   1.313168686229192e+00,  -8.876105124119739e-03,  -3.564763107190332e-05,   4.136233821457018e-07,   5.067693634908721e-09,
  -2.537360849756923e-11,  -7.606023576518870e-13,   1.154552004355789e-16,   1.124490125938054e-16,   4.988427887322236e-19,  -1.564843385388350e-20,  -1.557541506311154e-22,
   1.895413855218648e-24,   3.580983405467339e-26,   1.313162799113346e+00,  -8.875899997089744e-03,  -3.564261124031786e-05,   4.135814119009621e-07,   5.065812054892931e-09,
  -2.537316388325481e-11,  -7.600837388871613e-13,   1.183920117104790e-16,   1.123331398692408e-16,   4.974421338080917e-19,  -1.562784373265751e-20,  -1.552983450606552e-22,
   1.892999491466012e-24,   3.568762365951934e-26,   1.313155680718319e+00,  -8.875651964560992e-03,  -3.563654203634004e-05,   4.135306613722607e-07,   5.063537400280401e-09,
  -2.537262172487845e-11,  -7.594568581175336e-13,   1.219395332901409e-16,   1.121930934837169e-16,   4.957502871088501e-19,  -1.560295768095560e-20,  -1.547478794616736e-22,
   1.890079316316418e-24,   3.554006164783614e-26,   1.313148770689351e+00,  -8.875411188580401e-03,  -3.563065102722015e-05,   4.134813939949452e-07,   5.061329803858398e-09,
  -2.537209067036107e-11,  -7.588485428837742e-13,   1.253795317243855e-16,   1.120572102233235e-16,   4.941097971593066e-19,  -1.557881103154619e-20,  -1.542142286999265e-22,
   1.887243732570542e-24,   3.539703707577833e-26,   1.313143204336208e+00,  -8.875217229535029e-03,  -3.562590592945400e-05,   4.134417050938222e-07,   5.059551821901516e-09,
  -2.537165946816037e-11,  -7.583586709462057e-13,   1.281479757629506e-16,   1.119477955407558e-16,   4.927896183758347e-19,  -1.555936761808992e-20,  -1.537848503931785e-22,
   1.884958905263822e-24,   3.528198016200322e-26,   1.313139526324502e+00,  -8.875089068257642e-03,  -3.562277075816968e-05,   4.134154795014903e-07,   5.058377173113736e-09,
  -2.537137287767750e-11,  -7.580350598714758e-13,   1.299759567932221e-16,   1.118755212840990e-16,   4.919179423198888e-19,  -1.554652407257076e-20,  -1.535013811402792e-22,
   1.883448880060045e-24,   3.520603177055214e-26,   1.313137637531341e+00,  -8.875023252362294e-03,  -3.562116079195330e-05,   4.134020114442063e-07,   5.057773999697156e-09,
  -2.537122518664210e-11,  -7.578688971791978e-13,   1.309142928634969e-16,   1.118384127304188e-16,   4.914705034819624e-19,  -1.553992963218837e-20,  -1.533558853335504e-22,
   1.882673332258553e-24,   3.516705310706700e-26,   1.313136980126245e+00,  -8.875000344704813e-03,  -3.562060044347215e-05,   4.133973237697864e-07,   5.057564070003735e-09,
  -2.537117369975331e-11,  -7.578110670430614e-13,   1.312408225301374e-16,   1.118254979898408e-16,   4.913148014862796e-19,  -1.553763458933190e-20,  -1.533052567937046e-22,
   1.882403383418416e-24,   3.515349012064196e-26,   1.313136875805426e+00,  -8.874996709583017e-03,  -3.562051152459773e-05,   4.133965799007128e-07,   5.057530757543349e-09,
  -2.537116552561627e-11,  -7.578018904015360e-13,   1.312926351204643e-16,   1.118234486568304e-16,   4.912900952993740e-19,  -1.553727040772712e-20,  -1.532972233401752e-22,
   1.882360545670747e-24,   3.515133804634203e-26,   1.539326477700324e+00,  -7.202884076856586e-03,  -5.554267054472744e-05,   1.760104343978812e-09,   5.304654303360473e-09,
   4.809727808572903e-11,  -2.376568226589459e-13,  -9.084718514865265e-15,  -5.403970333803022e-17,   8.801196168908287e-19,   1.769627548739910e-20,   3.454968388013704e-23,
  -2.673772416994508e-24,  -3.406089404674818e-26,   1.539321276571247e+00,  -7.202883423563624e-03,  -5.553968857925389e-05,   1.805045521688171e-09,   5.304318442020549e-09,
   4.807943990823555e-11,  -2.377971473071299e-13,  -9.081743758700433e-15,  -5.396557747908235e-17,   8.802882502472287e-19,   1.767977947144138e-20,   3.430457258882700e-23,
  -2.672744553681203e-24,  -3.398904382669148e-26,   1.539312099324085e+00,  -7.202882260567832e-03,  -5.553442700816875e-05,   1.884331356448803e-09,   5.303725649563490e-09,
   4.804796892647501e-11,  -2.380445944870439e-13,  -9.076494298840674e-15,  -5.383483776954390e-17,   8.805847829942114e-19,   1.765067720927826e-20,   3.387249596226233e-23,
  -2.670926586859837e-24,  -3.386234053027992e-26,   1.539301002485665e+00,  -7.202880836785770e-03,  -5.552806492266392e-05,   1.980181481914597e-09,   5.303008566175040e-09,
   4.800992200096644e-11,  -2.383435411630801e-13,  -9.070145820615603e-15,  -5.367684229990945e-17,   8.809416096917456e-19,   1.761549535389975e-20,   3.335075051376903e-23,
  -2.668720985704335e-24,  -3.370926182524822e-26,   1.539290230272163e+00,  -7.202879436305719e-03,  -5.552188899510120e-05,   2.073206882075713e-09,   5.302312148920563e-09,
   4.797299521006392e-11,  -2.386334717302387e-13,  -9.063982018433053e-15,  -5.352356394955451e-17,   8.812861862695022e-19,   1.758135076791241e-20,   3.284500915587616e-23,
  -2.666572200326726e-24,  -3.356079424901744e-26,   1.539281552607331e+00,  -7.202878294989319e-03,  -5.551691394519233e-05,   2.148129567305860e-09,   5.301750920064697e-09,
   4.794325356232978e-11,  -2.388668342683194e-13,  -9.059015961332131e-15,  -5.340015719911469e-17,   8.815624664556300e-19,   1.755385104605464e-20,   3.243813481360810e-23,
  -2.664835713089945e-24,  -3.344129003793873e-26,   1.539275818703121e+00,  -7.202877534410576e-03,  -5.551362661732385e-05,   2.197628640383634e-09,   5.301379970111212e-09,
   4.792360379568702e-11,  -2.390209373209792e-13,  -9.055734196849964e-15,  -5.331864761002941e-17,   8.817443883621374e-19,   1.753568301171335e-20,   3.216954589443228e-23,
  -2.663685607142157e-24,  -3.336237244052879e-26,   1.539272874112905e+00,  -7.202877141832585e-03,  -5.551193844701288e-05,   2.223046153531173e-09,   5.301189438668075e-09,
   4.791351362328521e-11,  -2.391000460774812e-13,  -9.054048766569777e-15,  -5.327679948065688e-17,   8.818376164068310e-19,   1.752635387597577e-20,   3.203169499447434e-23,
  -2.663094149070626e-24,  -3.332185952946560e-26,   1.539271849228312e+00,  -7.202877004876315e-03,  -5.551135086862764e-05,   2.231892533174273e-09,   5.301123117537143e-09,
   4.791000179332017e-11,  -2.391275757440567e-13,  -9.053462123258169e-15,  -5.326223559832313e-17,   8.818700338382955e-19,   1.752310694720825e-20,   3.198372783623341e-23,
  -2.662888155627006e-24,  -3.330776103628869e-26,   1.539271686593574e+00,  -7.202876983128243e-03,  -5.551125762825574e-05,   2.233296311918482e-09,   5.301112593053630e-09,
   4.790944452124637e-11,  -2.391319440922610e-13,  -9.053369030385916e-15,  -5.325992459348622e-17,   8.818751765456644e-19,   1.752259171204009e-20,   3.197611673116076e-23,
  -2.662855461084929e-24,  -3.330552391336700e-26,   1.736819511368588e+00,  -4.776673991699833e-03,  -5.352930041975062e-05,  -3.539470528368044e-07,   3.789404166142029e-10,
   4.507718156956354e-11,   5.884179562773230e-13,   2.336438959832243e-15,  -5.127555177147014e-17,  -1.131444553364869e-18,  -9.221357364852214e-21,   4.123174237318706e-23,
   2.181278542959513e-24,   2.739168093993939e-26,   1.736814493443874e+00,  -4.776773390117968e-03,  -5.352908260537214e-05,  -3.539047549574225e-07,   3.797662753836671e-10,
   4.508172078955783e-11,   5.882825650725083e-13,   2.332626115135246e-15,  -5.131401959908454e-17,  -1.131224255630373e-18,  -9.207840798012941e-21,   4.142989651622546e-23,
   2.181716975608759e-24,   2.735283811244548e-26,   1.736805639253800e+00,  -4.776948770514804e-03,  -5.352869789116973e-05,  -3.538301162416363e-07,   3.812233610941014e-10,
   4.508972421478482e-11,   5.880435833262826e-13,   2.325898900707689e-15,  -5.138185030991055e-17,  -1.130834708337709e-18,  -9.183988459873095e-21,   4.177931106690406e-23,
   2.182484937636131e-24,   2.728425228650023e-26,   1.736794932701605e+00,  -4.777160825866184e-03,  -5.352823204735789e-05,  -3.537398564429633e-07,   3.829850202146671e-10,
   4.509939164198291e-11,   5.877544645769368e-13,   2.317765322837672e-15,  -5.146379285002327e-17,  -1.130362251636989e-18,  -9.155142322687951e-21,   4.220143186913846e-23,
   2.183403919530735e-24,   2.720123751630116e-26,   1.736784538996503e+00,  -4.777366668253070e-03,  -5.352777914066647e-05,  -3.536522276539749e-07,   3.846949313431650e-10,
   4.510876572294160e-11,   5.874736471362574e-13,   2.309870479066393e-15,  -5.154325843128582e-17,  -1.129902121117288e-18,  -9.127135210286188e-21,   4.261080554827856e-23,
   2.184285954589852e-24,   2.712056458438094e-26,   1.736776165984663e+00,  -4.777532479823331e-03,  -5.352741380234969e-05,  -3.535816306455214e-07,   3.860722149483117e-10,
   4.511630955860196e-11,   5.872473197365397e-13,   2.303511279998974e-15,  -5.160721552674820e-17,  -1.129530387763064e-18,  -9.104570352648701e-21,   4.294029493996523e-23,
   2.184989279544773e-24,   2.705551574311141e-26,   1.736770633258291e+00,  -4.777642039093515e-03,  -5.352717215703379e-05,  -3.535349792489116e-07,   3.869822021742450e-10,
   4.512129057097035e-11,   5.870977154708162e-13,   2.299309619169360e-15,  -5.164944817820493e-17,  -1.129284235108132e-18,  -9.089658585637961e-21,   4.315787030931002e-23,
   2.185450484941021e-24,   2.701250341767206e-26,   1.736767791941875e+00,  -4.777698301146322e-03,  -5.352704798753858e-05,  -3.535110208595741e-07,   3.874494940772320e-10,
   4.512384737788341e-11,   5.870208707081238e-13,   2.297151984361454e-15,  -5.167112767869430e-17,  -1.129157663835304e-18,  -9.082000275823700e-21,   4.326956070626574e-23,
   2.185686241724213e-24,   2.699040550945780e-26,   1.736766802996204e+00,  -4.777717883370583e-03,  -5.352700475757723e-05,  -3.535026818169154e-07,   3.876121345143676e-10,
   4.512473710988878e-11,   5.869941216676118e-13,   2.296401018774369e-15,  -5.167867199663151e-17,  -1.129113584060106e-18,  -9.079334666784426e-21,   4.330842841183608e-23,
   2.185768124849209e-24,   2.698271269508011e-26,   1.736766646064170e+00,  -4.777720990785714e-03,  -5.352699789702556e-05,  -3.535013585206683e-07,   3.876379430844593e-10,
   4.512487828917693e-11,   5.869898768437894e-13,   2.296281851778805e-15,  -5.167986910806332e-17,  -1.129106587997115e-18,  -9.078911668297356e-21,   4.331459584148384e-23,
   2.185781110304922e-24,   2.698149188328105e-26,   1.888227259746784e+00,  -2.255254320772618e-03,  -3.173871549424265e-05,  -3.550665910511959e-07,  -3.068908386008189e-09,
  -1.563415992485133e-11,   8.116076225093833e-14,   3.460668625204314e-15,   5.364369564689607e-17,   5.321455617581307e-19,   2.439620601053205e-21,  -3.220531640182660e-23,
  -1.009706450637814e-24,  -1.504465664188893e-26,   1.888224280784008e+00,  -2.255354234466907e-03,  -3.174044109726336e-05,  -3.550811904960779e-07,  -3.068792585870187e-09,
  -1.562731826029609e-11,   8.130178442763481e-14,   3.462460155313957e-15,   5.365378485031054e-17,   5.319752136595915e-19,   2.433317930766058e-21,  -3.231553504104506e-23,
  -1.010897801715479e-24,  -1.504842272083233e-26,   1.888219024225799e+00,  -2.255530537083205e-03,  -3.174348589763584e-05,  -3.551069462232059e-07,  -3.068588093391623e-09,
  -1.561524317005455e-11,   8.155064168917529e-14,   3.465620867852695e-15,   5.367156574303291e-17,   5.316741695059724e-19,   2.422190789757031e-21,  -3.251003945024842e-23,
  -1.012998779051359e-24,  -1.505503051817483e-26,   1.888212667715191e+00,  -2.255743729769233e-03,  -3.174716761184019e-05,  -3.551380814164270e-07,  -3.068340543832275e-09,
  -1.560063695651354e-11,   8.185159902672814e-14,   3.469442032074993e-15,   5.369302963311727e-17,   5.313093554554552e-19,   2.408725539414546e-21,  -3.274527342518894e-23,
  -1.015537287559869e-24,  -1.506295674727724e-26,   1.888206496689885e+00,  -2.255950699484109e-03,  -3.175074166096544e-05,  -3.551682975936076e-07,  -3.068099938933862e-09,
  -1.558645238195410e-11,   8.214380135937842e-14,   3.473150709997832e-15,   5.371382768886285e-17,   5.309543747702706e-19,   2.395643039147718e-21,  -3.297367321984583e-23,
  -1.017999512886224e-24,  -1.507058433834144e-26,   1.888201525223890e+00,  -2.256117435854223e-03,  -3.175362080013970e-05,  -3.551926326671425e-07,  -3.067905904339487e-09,
  -1.557502180852960e-11,   8.237922307088168e-14,   3.476137768517349e-15,   5.373055457874441e-17,   5.306678154088645e-19,   2.385096306930879e-21,  -3.315769673188552e-23,
  -1.019981531574097e-24,  -1.507668095004212e-26,   1.888198240085339e+00,  -2.256227614362510e-03,  -3.175552325054567e-05,  -3.552087095761087e-07,  -3.067777588662707e-09,
  -1.556746689512912e-11,   8.253479890527550e-14,   3.478111267433937e-15,   5.374159381572744e-17,   5.304781724327087e-19,   2.378123474839763e-21,  -3.327930965223462e-23,
  -1.021290469834513e-24,  -1.508068593009272e-26,   1.888196552984028e+00,  -2.256284196943175e-03,  -3.175650023950315e-05,  -3.552169648254497e-07,  -3.067711661163819e-09,
  -1.556358653080366e-11,   8.261469866992346e-14,   3.479124661904591e-15,   5.374725878701089e-17,   5.303806921071257e-19,   2.374541435819661e-21,  -3.334176785714184e-23,
  -1.021962441816522e-24,  -1.508273539246252e-26,   1.888195965768910e+00,  -2.256303891131192e-03,  -3.175684028780792e-05,  -3.552198379793542e-07,  -3.067688709517466e-09,
  -1.556223584614277e-11,   8.264250917193721e-14,   3.479477368533461e-15,   5.374922986258770e-17,   5.303467489249127e-19,   2.373294490310422e-21,  -3.336350766717825e-23,
  -1.022196291110174e-24,  -1.508344756634204e-26,   1.888195872585765e+00,  -2.256307016332470e-03,  -3.175689424871238e-05,  -3.552202939016549e-07,  -3.067685067171027e-09,
  -1.556202150689616e-11,   8.264692234679043e-14,   3.479533337524815e-15,   5.374954261334763e-17,   5.303413619322872e-19,   2.373096608495633e-21,  -3.336695750692889e-23,
  -1.022233398029352e-24,  -1.508356052344191e-26,   1.978257714286317e+00,  -4.658574180941550e-04,  -7.388990711155340e-06,  -1.023466228418917e-07,  -1.298738731619866e-09,
  -1.535658594393591e-11,  -1.697433991548531e-13,  -1.741472443838010e-15,  -1.623142556947840e-17,  -1.301652965404433e-19,  -7.481186205755595e-22,   4.445685028616777e-25,
   1.050015396167283e-25,   2.197937602953652e-27,   1.978257020100537e+00,  -4.658862538436680e-04,  -7.389722600769968e-06,  -1.023610485048036e-07,  -1.298977937544386e-09,
  -1.536002144739563e-11,  -1.697860712390857e-13,  -1.741911671984578e-15,  -1.623456029731336e-17,  -1.301623680599018e-19,  -7.474554262179132e-22,   4.608812044423866e-25,
   1.052922773507081e-25,   2.202285382558976e-27,   1.978255795142843e+00,  -4.659371382816500e-04,  -7.391014141039716e-06,  -1.023865054349995e-07,  -1.299400068979539e-09,
  -1.536608415037725e-11,  -1.698613734810767e-13,  -1.742686688466591e-15,  -1.624008928742486e-17,  -1.301571320795667e-19,  -7.462837424414749e-22,   4.896911389213570e-25,
   1.058056806473071e-25,   2.209962114564332e-27,   1.978254313815482e+00,  -4.659986739223116e-04,  -7.392576072108138e-06,  -1.024172926964630e-07,  -1.299910598065618e-09,
  -1.537341643440197e-11,  -1.699524411399637e-13,  -1.743623832067907e-15,  -1.624677109927306e-17,  -1.301506835812290e-19,  -7.448644273627962e-22,   5.245726287010973e-25,
   1.064271620101864e-25,   2.219253438544838e-27,   1.978252875668584e+00,  -4.660584175580897e-04,  -7.394092563360718e-06,  -1.024471851178267e-07,  -1.300406298044582e-09,
  -1.538053574417368e-11,  -1.700408599630398e-13,  -1.744533579390300e-15,  -1.625325359593730e-17,  -1.301443007748166e-19,  -7.434839584939983e-22,   5.584812966456569e-25,
   1.070311858204742e-25,   2.228282236977838e-27,   1.978251717044532e+00,  -4.661065504825725e-04,  -7.395314369159494e-06,  -1.024712694179015e-07,  -1.300805689969916e-09,
  -1.538627186699860e-11,  -1.701120975519924e-13,  -1.745266448806450e-15,  -1.625847287692900e-17,  -1.301390708763896e-19,  -7.423699905969787e-22,   5.858308861116793e-25,
   1.075182816350704e-25,   2.235562127464534e-27,   1.978250951411334e+00,  -4.661383579321251e-04,  -7.396121785300832e-06,  -1.024871855367677e-07,  -1.301069631627518e-09,
  -1.539006263517080e-11,  -1.701591742594372e-13,  -1.745750710332293e-15,  -1.626192024700154e-17,  -1.301355719420685e-19,  -7.416329794026061e-22,   6.039192743226167e-25,
   1.078403917925270e-25,   2.240375687288962e-27,   1.978250558211207e+00,  -4.661546932197582e-04,  -7.396536453350120e-06,  -1.024953597333271e-07,  -1.301205187757949e-09,
  -1.539200951220430e-11,  -1.701833516929859e-13,  -1.745999400077040e-15,  -1.626369019155495e-17,  -1.301337617337457e-19,  -7.412542039407650e-22,   6.132135593760715e-25,
   1.080058868420261e-25,   2.242848651083152e-27,   1.978250421352576e+00,  -4.661603789681615e-04,  -7.396680785741605e-06,  -1.024982049181675e-07,  -1.301252370816629e-09,
  -1.539268716226720e-11,  -1.701917670757660e-13,  -1.746085958545438e-15,  -1.626430616610823e-17,  -1.301331295501987e-19,  -7.411223222989814e-22,   6.164493216786000e-25,
   1.080635010218133e-25,   2.243709543291652e-27,   1.978250399634914e+00,  -4.661612812229675e-04,  -7.396703689464794e-06,  -1.024986564136564e-07,  -1.301259858189725e-09,
  -1.539279469702876e-11,  -1.701931024908758e-13,  -1.746099694169211e-15,  -1.626440390942218e-17,  -1.301330291305345e-19,  -7.411013923445145e-22,   6.169628306343400e-25,
   1.080726441737104e-25,   2.243846162364136e-27,   5.132350770466693e-03,  -8.261940074762774e-05,   9.951583675896316e-07,  -1.062647717565286e-08,   1.059681713909440e-10,
  -1.010218012033142e-12,   9.310395600547954e-15,  -8.357071848624819e-17,   7.325742620615525e-19,  -6.294938106917693e-21,   5.293700333209741e-23,  -4.375662373903413e-25,
   3.523189783469613e-27,  -2.804131865830482e-29,   5.132444186188770e-03,  -8.262239277958035e-05,   9.952180486142177e-07,  -1.062742563969379e-08,   1.059812869123436e-10,
  -1.010382880569633e-12,   9.312323233248808e-15,  -8.359202291594151e-17,   7.327982936582999e-19,  -6.297202322467952e-21,   5.295888710080082e-23,  -4.377721923543325e-25,
   3.525002955652290e-27,  -2.805767561366066e-29,   5.132609024260132e-03,  -8.262767248422485e-05,   9.953233627258724e-07,  -1.062909934520612e-08,   1.060044316621914e-10,
  -1.010673827829341e-12,   9.315725050066748e-15,  -8.362962113651174e-17,   7.331936760733554e-19,  -6.301198430786445e-21,   5.299751048592764e-23,  -4.381357004846959e-25,
   3.528203167643234e-27,  -2.808654568113446e-29,   5.132808355993046e-03,  -8.263405712984711e-05,   9.954507199144581e-07,  -1.063112342229683e-08,   1.060324223028053e-10,
  -1.011025702571581e-12,   9.319839379460003e-15,  -8.367509591246601e-17,   7.336719048525184e-19,  -6.306032041747912e-21,   5.304422986788503e-23,  -4.385754244329846e-25,
   3.532074332942420e-27,  -2.812146924274878e-29,   5.133001871932094e-03,  -8.264025562115695e-05,   9.955743667922282e-07,  -1.063308858594758e-08,   1.060595990720048e-10,
  -1.011367357443122e-12,   9.323834354021189e-15,  -8.371925314629158e-17,   7.341362952859266e-19,  -6.310725971605782e-21,   5.308960054572153e-23,  -4.390024747399717e-25,
   3.535833896363196e-27,  -2.815538662811920e-29,   5.133157771690899e-03,  -8.264524932306613e-05,   9.956739827931029e-07,  -1.063467185720464e-08,   1.060814951470564e-10,
  -1.011642633850399e-12,   9.327053266140072e-15,  -8.375483360029424e-17,   7.345104983623271e-19,  -6.314508446985329e-21,   5.312616226283782e-23,  -4.393466255485459e-25,
   3.538863629255100e-27,  -2.818272019615434e-29,   5.133260790331317e-03,  -8.264854920841224e-05,   9.957398110344966e-07,  -1.063571813347120e-08,   1.060959650658419e-10,
  -1.011824552988716e-12,   9.329180565893954e-15,  -8.377834842881110e-17,   7.347578121903515e-19,  -6.317008381221677e-21,   5.315032731852705e-23,  -4.395740953083492e-25,
   3.540866150541283e-27,  -2.820078670400091e-29,   5.133313696216027e-03,  -8.265024389951802e-05,   9.957736181498946e-07,  -1.063625547077527e-08,   1.061033964890649e-10,
  -1.011917983787038e-12,   9.330273128881737e-15,  -8.379042562412637e-17,   7.348848342427624e-19,  -6.318292384675067e-21,   5.316273900141007e-23,  -4.396909307925884e-25,
   3.541894704296392e-27,  -2.821006625748285e-29,   5.133332110734370e-03,  -8.265083375897732e-05,   9.957853852112690e-07,  -1.063644249982598e-08,   1.061059831320444e-10,
  -1.011950504285376e-12,   9.330653420205945e-15,  -8.379462939452031e-17,   7.349290477507601e-19,  -6.318739320520529e-21,   5.316705928319125e-23,  -4.397315994585385e-25,
   3.542252727844594e-27,  -2.821329633572209e-29,   5.133335032871501e-03,  -8.265092736186792e-05,   9.957872524906455e-07,  -1.063647217894478e-08,   1.061063935998930e-10,
  -1.011955664890590e-12,   9.330713767902875e-15,  -8.379529648409994e-17,   7.349360639356742e-19,  -6.318810244350761e-21,   5.316774486579268e-23,  -4.397380531584220e-25,
   3.542309542485031e-27,  -2.821380891626731e-29,   4.605655865543369e-02,  -7.305498229863371e-04,   8.523009714580338e-06,  -8.602236220590299e-08,   7.837950525517733e-10,
  -6.509507567076136e-12,   4.864594443996510e-14,  -3.136243255605798e-16,   1.505961264802548e-18,  -1.303995960436459e-21,  -9.105624951716937e-23,   1.552531477399954e-24,
  -1.833892922382934e-26,   1.748434101649841e-28,   4.605735857186201e-02,  -7.305740382432422e-04,   8.523450984862566e-06,  -8.602847004924650e-08,   7.838635074191863e-10,
  -6.510125079944619e-12,   4.864988955991155e-14,  -3.136285163577864e-16,   1.505573451877700e-18,  -1.295940765928481e-21,  -9.117030412919265e-23,   1.553814966497160e-24,
  -1.835149914099165e-26,   1.749331171369224e-28,   4.605877007068451e-02,  -7.306167678431507e-04,   8.524229644545662e-06,  -8.603924790575883e-08,   7.839843016187161e-10,
  -6.511214697736193e-12,   4.865684995635295e-14,  -3.136358889461860e-16,   1.504888758156642e-18,  -1.281721862760710e-21,  -9.137161856320320e-23,   1.556080236397848e-24,
  -1.837368269653047e-26,   1.750913951399394e-28,   4.606047692760622e-02,  -7.306684393159517e-04,   8.525171261572737e-06,  -8.605228140784636e-08,   7.841303749431192e-10,
  -6.512532286476363e-12,   4.866526512670360e-14,  -3.136447661995459e-16,   1.504060151139370e-18,  -1.264519028465988e-21,  -9.161515803288945e-23,   1.558820334065036e-24,
  -1.840051365872280e-26,   1.752827672518129e-28,   4.606213397493847e-02,  -7.307186035839628e-04,   8.526085423024634e-06,  -8.606493494679122e-08,   7.842721884475912e-10,
  -6.513811390583092e-12,   4.867343294549496e-14,  -3.136533445293376e-16,   1.503255054020488e-18,  -1.247809194669564e-21,  -9.185169494801404e-23,   1.561481325391502e-24,
  -1.842656735584949e-26,   1.754685277699273e-28,   4.606346891383974e-02,  -7.307590170548311e-04,   8.526821899685400e-06,  -8.607512907559749e-08,   7.843864373295921e-10,
  -6.514841828625567e-12,   4.868001177107508e-14,  -3.136602267707653e-16,   1.502605976734730e-18,  -1.234341075755428e-21,  -9.204232699628185e-23,   1.563625667422051e-24,
  -1.844756064490601e-26,   1.756181595699222e-28,   4.606435103879786e-02,  -7.307857224323764e-04,   8.527308569969464e-06,  -8.608186546925742e-08,   7.844619337790109e-10,
  -6.515522727835646e-12,   4.868435842113077e-14,  -3.136647605489506e-16,   1.502176832417149e-18,  -1.225438206604644e-21,  -9.216833291512872e-23,   1.565042944355967e-24,
  -1.846143496961401e-26,   1.757170265296420e-28,   4.606480405870159e-02,  -7.307994371924487e-04,   8.527558504516438e-06,  -8.608532502094175e-08,   7.845007056912928e-10,
  -6.515872403428480e-12,   4.868659047284138e-14,  -3.136670845663348e-16,   1.501956370307564e-18,  -1.220865113100786e-21,  -9.223305524901237e-23,   1.565770887140139e-24,
  -1.846856082038035e-26,   1.757677972604707e-28,   4.606496173746725e-02,  -7.308042107834155e-04,   8.527645497490672e-06,  -8.608652916410872e-08,   7.845142007494244e-10,
  -6.515994111422598e-12,   4.868736733323285e-14,  -3.136678927780845e-16,   1.501879624356046e-18,  -1.219273239777720e-21,  -9.225558440278548e-23,   1.566024270731985e-24,
  -1.847104115276924e-26,   1.757854681308513e-28,   4.606498675896512e-02,  -7.308049682886064e-04,   8.527659302123472e-06,  -8.608672024573496e-08,   7.845163422358915e-10,
  -6.516013424814651e-12,   4.868749060906025e-14,  -3.136680209976954e-16,   1.501867445256277e-18,  -1.219020623512358e-21,  -9.225915956191802e-23,   1.566064479998785e-24,
  -1.847143475280754e-26,   1.757882722381239e-28,   1.271681105524879e-01,  -1.956644908456474e-03,   2.132428531994879e-05,  -1.891088764591698e-07,   1.354881396385296e-09,
  -6.767520473903585e-12,   1.463624317124966e-15,   4.905442179847160e-16,  -7.501950045633143e-18,   7.360672465614782e-20,  -4.960693878460771e-22,   1.223296575409634e-24,
   2.512677743052505e-26,  -5.232579850098496e-28,   1.271701112302485e-01,  -1.956698117540715e-03,   2.132504744941281e-05,  -1.891152128401519e-07,   1.354883221143167e-09,
  -6.766550762490786e-12,   1.443888635413783e-15,   4.907928001119679e-16,  -7.504037748354785e-18,   7.361288219772937e-20,  -4.959115745784848e-22,   1.219443813269163e-24,
   2.517729246824190e-26,  -5.237374630219240e-28,   1.271736415157746e-01,  -1.956792007255787e-03,   2.132639223964147e-05,  -1.891263927439219e-07,   1.354886418376694e-09,
  -6.764839293462491e-12,   1.409060261684480e-15,   4.912314439779040e-16,  -7.507720989368882e-18,   7.362373109882130e-20,  -4.956328563195862e-22,   1.212642705272005e-24,
   2.526644039488956e-26,  -5.245833578620981e-28,   1.271779104738921e-01,  -1.956905542172743e-03,   2.132801837571123e-05,  -1.891399103407805e-07,   1.354890246000615e-09,
  -6.762769088210755e-12,   1.366937828316135e-15,   4.917618854283113e-16,  -7.512173876819927e-18,   7.363682211310136e-20,  -4.952953936330938e-22,   1.204413876354831e-24,
   2.537426175836894e-26,  -5.256059635472196e-28,   1.271820548083555e-01,  -1.957015762491596e-03,   2.132959700187131e-05,  -1.891530316677602e-07,   1.354893921465131e-09,
  -6.760758658123448e-12,   1.326038150167556e-15,   4.922768587183326e-16,  -7.516495691436418e-18,   7.364950173777732e-20,  -4.949673365888972e-22,   1.196420386841473e-24,
   2.547895665564697e-26,  -5.265984187778482e-28,   1.271853935046911e-01,  -1.957104556400433e-03,   2.133086872358233e-05,  -1.891636010907028e-07,   1.354896853474588e-09,
  -6.759138572584279e-12,   1.293084206624250e-15,   4.926917359083219e-16,  -7.519976592517285e-18,   7.365969556056418e-20,  -4.947027326909933e-22,   1.189977292930507e-24,
   2.556331452546740e-26,  -5.273977317121016e-28,   1.271875996921753e-01,  -1.957163230740996e-03,   2.133170905512410e-05,  -1.891705847131319e-07,   1.354898776744219e-09,
  -6.758067799593333e-12,   1.271306039788699e-15,   4.929658898339191e-16,  -7.522276368665172e-18,   7.366642131003327e-20,  -4.945277278032733e-22,   1.185718027912794e-24,
   2.561906502982690e-26,  -5.279258071534393e-28,   1.271887326862745e-01,  -1.957193363102956e-03,   2.133214060573020e-05,  -1.891741709939022e-07,   1.354899760058916e-09,
  -6.757517829319621e-12,   1.260121046919578e-15,   4.931066842278475e-16,  -7.523457308168259e-18,   7.366987216550470e-20,  -4.944378051370640e-22,   1.183530140061771e-24,
   2.564769815486512e-26,  -5.281969693137339e-28,   1.271891270370397e-01,  -1.957203850992154e-03,   2.133229081089466e-05,  -1.891754192089195e-07,   1.354900101613867e-09,
  -6.757326394853515e-12,   1.256227870472133e-15,   4.931556895208726e-16,  -7.523868328162977e-18,   7.367107276761247e-20,  -4.944064988834168e-22,   1.182768537869342e-24,
   2.565766458580505e-26,  -5.282913450296984e-28,   1.271891896151601e-01,  -1.957205515277849e-03,   2.133231464638674e-05,  -1.891756172823674e-07,   1.354900155780857e-09,
  -6.757296016257446e-12,   1.255610070472046e-15,   4.931634660104013e-16,  -7.523933550577176e-18,   7.367126326290653e-20,  -4.944015306396295e-22,   1.182647677922783e-24,
   2.565924614057523e-26,  -5.283063209301072e-28,   2.469000538670831e-01,  -3.620229059976592e-03,   3.518462054215802e-05,  -2.417013558079463e-07,   7.967005177972052e-10,
   7.239753827995725e-12,  -1.597288751961021e-13,   1.542988705362027e-15,  -6.850066968887703e-18,  -5.087810737505162e-20,   1.405160916724020e-21,  -1.533806222740974e-23,
   7.828069846440708e-26,   4.494706566679510e-28,   2.469033533158351e-01,  -3.620297014347221e-03,   3.518506741612209e-05,  -2.416945430373802e-07,   7.964756885039270e-10,
   7.242788812388328e-12,  -1.597467337928666e-13,   1.542814934432337e-15,  -6.844123613169967e-18,  -5.095706188436668e-20,   1.405639115774789e-21,  -1.533467913528536e-23,
   7.814784095305114e-26,   4.512173657638799e-28,   2.469091752790608e-01,  -3.620416919342820e-03,   3.518585582940636e-05,  -2.416825194839754e-07,   7.960789533038412e-10,
   7.248143811023892e-12,  -1.597782328750669e-13,   1.542508096343848e-15,  -6.833634833615143e-18,  -5.109636407946336e-20,   1.406482236294616e-21,  -1.532869923828656e-23,
   7.791332973715629e-26,   4.542989651206357e-28,   2.469162153171613e-01,  -3.620561907083647e-03,   3.518680901179019e-05,  -2.416679765317619e-07,   7.955991821295292e-10,
   7.254618656514433e-12,  -1.598163002572639e-13,   1.542136695241073e-15,  -6.820948903254876e-18,  -5.126478540605365e-20,   1.407500605264043e-21,  -1.532145059009154e-23,
   7.762961650116996e-26,   4.580244201793138e-28,   2.469230497249782e-01,  -3.620702655885706e-03,   3.518773416108106e-05,  -2.416538543566363e-07,   7.951333922205646e-10,
   7.260903825593500e-12,  -1.598532327439506e-13,   1.541775758883054e-15,  -6.808630706131824e-18,  -5.142826035012844e-20,   1.408488024638982e-21,  -1.531439520271101e-23,
   7.735404640362485e-26,   4.616401376813285e-28,   2.469285554785200e-01,  -3.620816039293111e-03,   3.518847931771585e-05,  -2.416424747578240e-07,   7.947581318858686e-10,
   7.265966718436486e-12,  -1.598829688305378e-13,   1.541484716276005e-15,  -6.798705239172097e-18,  -5.155993529560359e-20,   1.409282619955415e-21,  -1.530869820298636e-23,
   7.713194608160993e-26,   4.645522737714416e-28,   2.469321936036681e-01,  -3.620890960050892e-03,   3.518897163950719e-05,  -2.416349538732953e-07,   7.945101537947171e-10,
   7.269312012643552e-12,  -1.599026099522742e-13,   1.541292264903479e-15,  -6.792145645871376e-18,  -5.164693476157758e-20,   1.409807254726532e-21,  -1.530492722976461e-23,
   7.698513496015923e-26,   4.664762480367992e-28,   2.469340619615930e-01,  -3.620929435142362e-03,   3.518922445037510e-05,  -2.416310910913231e-07,   7.943828012382313e-10,
   7.271029927087453e-12,  -1.599126941478764e-13,   1.541193389980980e-15,  -6.788776665044548e-18,  -5.169161036687389e-20,   1.410076549979231e-21,  -1.530298864539107e-23,
   7.690972460513327e-26,   4.674642038445418e-28,   2.469347122617267e-01,  -3.620942826702136e-03,   3.518931244034014e-05,  -2.416297465433772e-07,   7.943384743872851e-10,
   7.271627854311827e-12,  -1.599162036528200e-13,   1.541158968982932e-15,  -6.787604010150335e-18,  -5.170715967712127e-20,   1.410170259990975e-21,  -1.530231358349519e-23,
   7.688347482288307e-26,   4.678080554519426e-28,   2.469348154554516e-01,  -3.620944951755954e-03,   3.518932640298515e-05,  -2.416295331787505e-07,   7.943314402967362e-10,
   7.271722736717813e-12,  -1.599167605443259e-13,   1.541153506527677e-15,  -6.787417923582663e-18,  -5.170962711745964e-20,   1.410185129498069e-21,  -1.530220644528530e-23,
   7.687930922445754e-26,   4.678626192323335e-28,   4.026601398908603e-01,  -5.508926705062868e-03,   4.460902098280582e-05,  -1.691169352301273e-07,  -1.252509296032355e-09,
   2.738652248524717e-11,  -2.000276527727155e-13,  -3.220484460731313e-16,   2.456621824329115e-17,  -2.683343781037352e-19,   6.000988786910587e-22,   2.318286425873176e-23,
  -3.693938833761570e-25,   1.962898849005154e-27,   4.026643205608488e-01,  -5.508974178693017e-03,   4.460831486465745e-05,  -1.690912658812818e-07,  -1.252789821082699e-09,
   2.738587410530721e-11,  -1.999631160249799e-13,  -3.229509403581600e-16,   2.456867670123273e-17,  -2.682142954754740e-19,   5.978209401650712e-22,   2.319694509547400e-23,
  -3.692285637697376e-25,   1.957953137267671e-27,   4.026716973649156e-01,  -5.509057940792996e-03,   4.460706877994906e-05,  -1.690459724093450e-07,  -1.253284738150866e-09,
   2.738472858569714e-11,  -1.998492347143104e-13,  -3.245430758520494e-16,   2.457300688277274e-17,  -2.680023490375431e-19,   5.938023168275618e-22,   2.322176156352069e-23,
  -3.689365421246886e-25,   1.949227267027285e-27,   4.026806173833067e-01,  -5.509159216815172e-03,   4.460556178256135e-05,  -1.689912039088864e-07,  -1.253883071324840e-09,
   2.738334095106178e-11,  -1.997115193547840e-13,  -3.264677405371388e-16,   2.457822967634768e-17,  -2.677459610487828e-19,   5.889443794161792e-22,   2.325171979339703e-23,
  -3.685828938064669e-25,   1.938677420975467e-27,   4.026892766865066e-01,  -5.509257523348353e-03,   4.460409858685989e-05,  -1.689380364874855e-07,  -1.254463791036985e-09,
   2.738199128366391e-11,  -1.995778184020530e-13,  -3.283355824442989e-16,   2.458328594022707e-17,  -2.674969593201816e-19,   5.842298713437331e-22,   2.328075025616549e-23,
  -3.682390208686688e-25,   1.928437466467838e-27,   4.026962524395887e-01,  -5.509336710307088e-03,   4.460291969157165e-05,  -1.688952061431402e-07,  -1.254931516864569e-09,
   2.738090216399495e-11,  -1.994701040247299e-13,  -3.298398692980037e-16,   2.458734921896529e-17,  -2.672962918192370e-19,   5.804329959852975e-22,   2.330409922958259e-23,
  -3.679616023618973e-25,   1.920189483915445e-27,   4.027008618591880e-01,  -5.509389031963676e-03,   4.460214061834481e-05,  -1.688669049276909e-07,  -1.255240535526989e-09,
   2.738018158980907e-11,  -1.993989250416823e-13,  -3.308336684458053e-16,   2.459002927458595e-17,  -2.671636576441616e-19,   5.779246131836724e-22,   2.331950941166568e-23,
  -3.677780939617180e-25,   1.914739950242082e-27,   4.027032290062611e-01,  -5.509415900501287e-03,   4.460174050215803e-05,  -1.688523709962807e-07,  -1.255399217098094e-09,
   2.737981126115726e-11,  -1.993623702265541e-13,  -3.313439678942100e-16,   2.459140410031404e-17,  -2.670955323164174e-19,   5.766366009744379e-22,   2.332741758632791e-23,
  -3.676837932820153e-25,   1.911941535856757e-27,   4.027040529118148e-01,  -5.509425252160918e-03,   4.460160123410583e-05,  -1.688473123437853e-07,  -1.255454445395783e-09,
   2.737968232041155e-11,  -1.993496468290213e-13,  -3.315215721062516e-16,   2.459188238044830e-17,  -2.670718188686499e-19,   5.761883223884363e-22,   2.333016919292167e-23,
  -3.676509614639787e-25,   1.910967551115903e-27,   4.027041836542003e-01,  -5.509426736131919e-03,   4.460157913399651e-05,  -1.688465096060358e-07,  -1.255463209257945e-09,
   2.737966185718005e-11,  -1.993476277934982e-13,  -3.315497549652055e-16,   2.459195826549917e-17,  -2.670680557854665e-19,   5.761171879783803e-22,   2.333060579198121e-23,
  -3.676457510507965e-25,   1.910812994529897e-27,   5.905182568271596e-01,  -7.341851544171828e-03,   4.404706388871858e-05,   5.324771928571799e-08,  -3.716751703473979e-09,
   2.695961178261616e-11,   1.337036315650614e-13,  -4.189661917790791e-15,   2.430005657387910e-17,   2.702897373999708e-19,  -5.721725020062333e-21,   2.222564625101630e-23,
   5.278055628547339e-25,  -8.427039054921381e-27,   5.905223820365721e-01,  -7.341836479513783e-03,   4.404497428592161e-05,   5.327292465873059e-08,  -3.716562935402909e-09,
   2.695137796492280e-11,   1.337669230534329e-13,  -4.188746775568466e-15,   2.427602328306201e-17,   2.704019651935132e-19,  -5.718454269228797e-21,   2.216457327528629e-23,
   5.279140388251059e-25,  -8.417076243538009e-27,   5.905296608744469e-01,  -7.341809891935909e-03,   4.404128723535988e-05,   5.331739366535676e-08,  -3.716229779001592e-09,
   2.693685073006131e-11,   1.338785506555788e-13,  -4.187131686498620e-15,   2.423362738522158e-17,   2.705997374458827e-19,  -5.712682442953999e-21,   2.205686825576107e-23,
   5.281044693745941e-25,  -8.399498271228223e-27,   5.905384622518220e-01,  -7.341777732146415e-03,   4.403682896184679e-05,   5.337115537221425e-08,  -3.715826799705195e-09,
   2.691928674241799e-11,   1.340134446187072e-13,  -4.185178181884325e-15,   2.418238094806636e-17,   2.708384503646945e-19,  -5.705702180134840e-21,   2.192673114162487e-23,
   5.283330753868752e-25,  -8.378245482974351e-27,   5.905470061926826e-01,  -7.341746501711694e-03,   4.403250110149866e-05,   5.342333511199799e-08,  -3.715435465609423e-09,
   2.690223854561321e-11,   1.341443059170277e-13,  -4.183281207759703e-15,   2.413265183403054e-17,   2.710697330024398e-19,  -5.698924914395697e-21,   2.180050198551138e-23,
   5.285532605245467e-25,  -8.357616473511134e-27,   5.905538888768922e-01,  -7.341721335523673e-03,   4.402901474413416e-05,   5.346536241159229e-08,  -3.715120119723348e-09,
   2.688850661631748e-11,   1.342496605854904e-13,  -4.181752639540911e-15,   2.409260506621244e-17,   2.712557249103854e-19,  -5.693464561442521e-21,   2.169888914783148e-23,
   5.287293920527325e-25,  -8.341000052569594e-27,   5.905584367324012e-01,  -7.341704702553633e-03,   4.402671107547992e-05,   5.349312937585371e-08,  -3.714911699636907e-09,
   2.687943372089291e-11,   1.343192450130886e-13,  -4.180742397850645e-15,   2.406614990680138e-17,   2.713784653085429e-19,  -5.689856127806687e-21,   2.163178227136586e-23,
   5.288451666326562e-25,  -8.330021222298831e-27,   5.905607722430082e-01,  -7.341696159613996e-03,   4.402552804815838e-05,   5.350738782631816e-08,  -3.714804651992313e-09,
   2.687477463915220e-11,   1.343549700324185e-13,  -4.180223531360021e-15,   2.405256609121747e-17,   2.714414489875903e-19,  -5.688002922781161e-21,   2.159733114509670e-23,
   5.289044338676263e-25,  -8.324383379501539e-27,   5.905615851339591e-01,  -7.341693185988330e-03,   4.402511628733348e-05,   5.351235041726682e-08,  -3.714767390857494e-09,
   2.687315304833021e-11,   1.343674028743891e-13,  -4.180042925729675e-15,   2.404783846601545e-17,   2.714633631723528e-19,  -5.687357881633781e-21,   2.158534194042113e-23,
   5.289250323623704e-25,  -8.322421126438504e-27,   5.905617141283248e-01,  -7.341692714106475e-03,   4.402505094668810e-05,   5.351313790292745e-08,  -3.714761477923097e-09,
   2.687289572634764e-11,   1.343693757202634e-13,  -4.180014265657459e-15,   2.404708827344168e-17,   2.714668402784791e-19,  -5.687255521720309e-21,   2.158343950541005e-23,
   5.289282996353388e-25,  -8.322109746265997e-27,   8.047614660074994e-01,  -8.783747399624665e-03,   2.981449460829531e-05,   3.555881063979477e-07,  -4.227510927211945e-09,
  -1.248461760746234e-11,   5.425268277607230e-13,  -1.719832240564842e-15,  -5.903613239545102e-17,   5.985787566451931e-19,   4.360602512255349e-21,  -1.138841067677481e-22,
   1.049981824190054e-25,   1.624108714776291e-26,   8.047642563459766e-01,  -8.783647431997594e-03,   2.981212093320731e-05,   3.555763739233684e-07,  -4.226749827922538e-09,
  -1.248797166194784e-11,   5.423722386034321e-13,  -1.717827211128437e-15,  -5.901771705079220e-17,   5.979961230227803e-19,   4.361203720542345e-21,  -1.137662516663471e-22,
   1.039488131723114e-25,   1.622463073101083e-26,   8.047691797617835e-01,  -8.783471040231907e-03,   2.980793289374059e-05,   3.555556692404635e-07,  -4.225407032822650e-09,
  -1.249388674215681e-11,   5.420995029115930e-13,  -1.714290900408064e-15,  -5.898522086539892e-17,   5.969685499394936e-19,   4.362259309057386e-21,  -1.135583922406243e-22,
   1.020995220127210e-25,   1.619559881359834e-26,   8.047751329013179e-01,  -8.783257750002582e-03,   2.980286926424672e-05,   3.555306285755983e-07,  -4.223783611675722e-09,
  -1.250103386293426e-11,   5.417697750255095e-13,  -1.710017474830912e-15,  -5.894592269877887e-17,   5.957268380997666e-19,   4.363526789258587e-21,  -1.133072130587826e-22,
   9.986732164006094e-26,   1.616050283497614e-26,   8.047809117841797e-01,  -8.783050696334959e-03,   2.979795420085492e-05,   3.555063149877920e-07,  -4.222207937729193e-09,
  -1.250796645134844e-11,   5.414497510945064e-13,  -1.705871753518741e-15,  -5.890776914056601e-17,   5.945222855574464e-19,   4.364747876342298e-21,  -1.130635471482742e-22,
   9.770450628342513e-26,   1.612644248487690e-26,   8.047855669464037e-01,  -8.782883900028819e-03,   2.979399513421776e-05,   3.554867250235105e-07,  -4.220938821101433e-09,
  -1.251354716284700e-11,   5.411919942731682e-13,  -1.702534052848848e-15,  -5.887703057743373e-17,   5.935525438277245e-19,   4.365724868486461e-21,  -1.128673780607988e-22,
   9.596515251672578e-26,   1.609901125471933e-26,   8.047886428817437e-01,  -8.782773685683504e-03,   2.979137927113707e-05,   3.554737787313887e-07,  -4.220100321994859e-09,
  -1.251723279487967e-11,   5.410216977845377e-13,  -1.700329557475754e-15,  -5.885671783703687e-17,   5.929120641963421e-19,   4.366367170036532e-21,  -1.127378142178128e-22,
   9.481727752473132e-26,   1.608088879224136e-26,   8.047902224867959e-01,  -8.782717085863952e-03,   2.979003596757890e-05,   3.554671296984963e-07,  -4.219669746769930e-09,
  -1.251912492405826e-11,   5.409342500056290e-13,  -1.699197752118635e-15,  -5.884628588869146e-17,   5.925832426223942e-19,   4.366696009652816e-21,  -1.126712959084551e-22,
   9.422823975369922e-26,   1.607158315775416e-26,   8.047907722772403e-01,  -8.782697385861271e-03,   2.978956842918746e-05,   3.554648153633239e-07,  -4.219519886562211e-09,
  -1.251978339837762e-11,   5.409038142179170e-13,  -1.698803866006293e-15,  -5.884265489245270e-17,   5.924688084422475e-19,   4.366810304082852e-21,  -1.126481466141985e-22,
   9.402329153503417e-26,   1.606834442447922e-26,   8.047908595211480e-01,  -8.782694259746092e-03,   2.978949423779239e-05,   3.554644481064847e-07,  -4.219496106069519e-09,
  -1.251988788450430e-11,   5.408989845351404e-13,  -1.698741364036095e-15,  -5.884207870045837e-17,   5.924506500344740e-19,   4.366828433382767e-21,  -1.126444732830261e-22,
   9.399077248212685e-26,   1.606783049056821e-26,   1.037320291004528e+00,  -9.481723187310944e-03,   2.612037528038552e-06,   5.659244598766527e-07,  -9.639690957622059e-10,
  -5.979551608636200e-11,   2.166316391248312e-13,   7.487283581852935e-15,  -4.439947910807725e-17,  -1.010410042794400e-18,   8.722823679193076e-21,   1.396563813034533e-22,
  -1.687983998797638e-24,  -1.931485763542643e-26,   1.037320534797544e+00,  -9.481564218362061e-03,   2.611497007591515e-06,   5.658685251186454e-07,  -9.636658263441060e-10,
  -5.978082943050910e-11,   2.165158428841407e-13,   7.483892063024633e-15,  -4.436301097176987e-17,  -1.009695375238454e-18,   8.712503543455592e-21,   1.395165044816847e-22,
  -1.685295938778434e-24,  -1.929011495388739e-26,   1.037320964933167e+00,  -9.481283727915103e-03,   2.610543389112514e-06,   5.657698385341397e-07,  -9.631308347695318e-10,
  -5.975492001412730e-11,   2.163115962200127e-13,   7.477909631583226e-15,  -4.429869765814392e-17,  -1.008434918050297e-18,   8.694306972457327e-21,   1.392698362997588e-22,
  -1.680557433771036e-24,  -1.924648749067461e-26,   1.037321484987879e+00,  -9.480944577631968e-03,   2.609390499320917e-06,   5.656505247148179e-07,  -9.624841423959597e-10,
  -5.972359930856732e-11,   2.160647512757755e-13,   7.470678947119171e-15,  -4.422098944715363e-17,  -1.006911756731218e-18,   8.672326437453433e-21,   1.389718124565980e-22,
  -1.674835452157681e-24,  -1.919378618435361e-26,   1.037321989774822e+00,  -9.480615359194736e-03,   2.608271540807604e-06,   5.655347168729316e-07,  -9.618565803361628e-10,
  -5.969320338051779e-11,   2.158252569589108e-13,   7.463663015363960e-15,  -4.414561459357235e-17,  -1.005434141580163e-18,   8.651012130540238e-21,   1.386827576592400e-22,
  -1.669288883377316e-24,  -1.914268064243030e-26,   1.037322396372201e+00,  -9.480350161428137e-03,   2.607370299274970e-06,   5.654414378720593e-07,  -9.613511933270889e-10,
  -5.966872374328893e-11,   2.156324226273969e-13,   7.458013572682662e-15,  -4.408493865428779e-17,  -1.004244541310032e-18,   8.633858795179157e-21,   1.384500861876801e-22,
  -1.664826531712879e-24,  -1.910155076050652e-26,   1.037322665018843e+00,  -9.480174931460833e-03,   2.606774861522253e-06,   5.653798077659731e-07,  -9.610173252338597e-10,
  -5.965255142602074e-11,   2.155050496766963e-13,   7.454281745611349e-15,  -4.404486712687992e-17,  -1.003458840378971e-18,   8.622532589195416e-21,   1.382964326918741e-22,
  -1.661880771641554e-24,  -1.907439247956111e-26,   1.037322802973812e+00,  -9.480084944959806e-03,   2.606469102523309e-06,   5.653481599209592e-07,  -9.608458935452363e-10,
  -5.964424721579524e-11,   2.154396525795115e-13,   7.452365652300789e-15,  -4.402429529766373e-17,  -1.003055458431041e-18,   8.616718640885195e-21,   1.382175526089551e-22,
  -1.660368873782284e-24,  -1.906045146578015e-26,   1.037322850989039e+00,  -9.480053624727527e-03,   2.606362684566438e-06,   5.653371449430694e-07,  -9.607862292436231e-10,
  -5.964135702628788e-11,   2.154168929098197e-13,   7.451698798719509e-15,  -4.401713616924583e-17,  -1.002915075648739e-18,   8.614695456811704e-21,   1.381901021844995e-22,
  -1.659842785670364e-24,  -1.905560013328967e-26,   1.037322858608334e+00,  -9.480048654656693e-03,   2.606345797704656e-06,   5.653353970341280e-07,  -9.607767615337584e-10,
  -5.964089840094086e-11,   2.154132813770915e-13,   7.451592981099979e-15,  -4.401600016567346e-17,  -1.002892799688972e-18,   8.614374425008964e-21,   1.381857463943151e-22,
  -1.659759309462392e-24,  -1.905483033944576e-26,   1.277130054272137e+00,  -9.140236400222972e-03,  -3.022004905211919e-05,   4.897038754066886e-07,   4.381082424842216e-09,
  -4.317828640465026e-11,  -7.055303208921248e-13,   3.869590195213197e-15,   1.178620038348855e-16,  -2.311032630320862e-19,  -1.992691585559070e-20,  -2.641556244362890e-23,
   3.326071253918372e-24,   1.549143402812120e-26,   1.277127226083810e+00,  -9.140098813621048e-03,  -3.021759027592867e-05,   4.896634597776498e-07,   4.380093910535278e-09,
  -4.317068063240669e-11,  -7.052226544580367e-13,   3.868806801659238e-15,   1.177785911788092e-16,  -2.312351706746073e-19,  -1.990654731104121e-20,  -2.630473571024337e-23,
   3.321497957981641e-24,   1.544679624284128e-26,   1.277122235887681e+00,  -9.139856049124023e-03,  -3.021325217780035e-05,   4.895921515565308e-07,   4.378350012537843e-09,
  -4.315726138300679e-11,  -7.046799498045294e-13,   3.867424132599826e-15,   1.176314779082779e-16,  -2.314674617043706e-19,  -1.987062962827096e-20,  -2.610944405795150e-23,
   3.313434704241409e-24,   1.536814427969632e-26,   1.277116202007459e+00,  -9.139562511431472e-03,  -3.020800727231500e-05,   4.895059347690506e-07,   4.376241870873936e-09,
  -4.314103682416280e-11,  -7.040240082763312e-13,   3.865751583465291e-15,   1.174537057147680e-16,  -2.317475633687579e-19,  -1.982723666575973e-20,  -2.587374475767286e-23,
   3.303695435080523e-24,   1.527322842481661e-26,   1.277110344754231e+00,  -9.139277566592930e-03,  -3.020291641413579e-05,   4.894222473447463e-07,   4.374195949928562e-09,
  -4.312528854571957e-11,  -7.033875484890109e-13,   3.864127263055696e-15,   1.172812518266059e-16,  -2.320186579033257e-19,  -1.978515242842650e-20,  -2.564540203901135e-23,
   3.294252129907651e-24,   1.518128542569709e-26,   1.277105626465947e+00,  -9.139048030537989e-03,  -3.019881586186877e-05,   4.893548372524112e-07,   4.372548231373818e-09,
  -4.311260354444838e-11,  -7.028750517230662e-13,   3.862818274835195e-15,   1.171424142148484e-16,  -2.322364589125512e-19,  -1.975127919871388e-20,  -2.546178851806158e-23,
   3.286652893902122e-24,   1.510736020684491e-26,   1.277102508821990e+00,  -9.138896362979848e-03,  -3.019610657239389e-05,   4.893102974913511e-07,   4.371459667976544e-09,
  -4.310422230857474e-11,  -7.025365140795625e-13,   3.861953095379005e-15,   1.170507163505067e-16,  -2.323800897141310e-19,  -1.972891070248590e-20,  -2.534062452182952e-23,
   3.281635450697353e-24,   1.505858161043228e-26,   1.277100907798790e+00,  -9.138818476218523e-03,  -3.019471530994457e-05,   4.892874253145564e-07,   4.370900706510633e-09,
  -4.309991838634052e-11,  -7.023626931488276e-13,   3.861508715321914e-15,   1.170036385755887e-16,  -2.324537619251532e-19,  -1.971742783953057e-20,  -2.527845186501406e-23,
   3.279059988955239e-24,   1.503355305861180e-26,   1.277100350553758e+00,  -9.138791367302434e-03,  -3.019423108221071e-05,   4.892794646225311e-07,   4.370706165666317e-09,
  -4.309842040554734e-11,  -7.023021986495725e-13,   3.861354033793147e-15,   1.169872548683396e-16,  -2.324793900367044e-19,  -1.971343182905690e-20,  -2.525682019515219e-23,
   3.278163772541370e-24,   1.502484507782149e-26,   1.277100262126920e+00,  -9.138787065504306e-03,  -3.019415424259822e-05,   4.892782013788202e-07,   4.370675295226881e-09,
  -4.309818269846587e-11,  -7.022925992652306e-13,   3.861329487443687e-15,   1.169846551013878e-16,  -2.324834561921672e-19,  -1.971279775070071e-20,  -2.525338793118551e-23,
   3.278021564673097e-24,   1.502346340428021e-26,   1.509628522731206e+00,  -7.645627438008874e-03,  -5.498180599751150e-05,   9.393065423725896e-08,   6.188090320424251e-09,
   3.917983023059116e-11,  -5.104964753792922e-13,  -1.016995928434747e-14,  -9.635681616702037e-18,   1.574701926183994e-18,   1.582274257390280e-20,  -1.307741680958752e-22,
  -4.040218622859771e-24,  -1.376519960372497e-26,   1.509623375176256e+00,  -7.645600891312452e-03,  -5.497832925747547e-05,   9.396721770695148e-08,   6.187372155237861e-09,
   3.915989237712836e-11,  -5.105204092051169e-13,  -1.016466236496593e-14,  -9.569724289337478e-18,   1.574023906819419e-18,   1.579798740736269e-20,  -1.308703747221466e-22,
  -4.034956047293426e-24,  -1.368424160783073e-26,   1.509614292498941e+00,  -7.645554040916891e-03,  -5.497219482338690e-05,   9.403171935489226e-08,   6.186104914620223e-09,
   3.912472019003541e-11,  -5.105625005375704e-13,  -1.015531773037191e-14,  -9.453426238458166e-18,   1.572827132210531e-18,   1.575433296374340e-20,  -1.310396542363485e-22,
  -4.025673340456255e-24,  -1.354159091635889e-26,   1.509603310079246e+00,  -7.645497374713440e-03,  -5.496477756010015e-05,   9.410968957585295e-08,   6.184572508056252e-09,
   3.908220404390271e-11,  -5.106131587614381e-13,  -1.014402127566363e-14,  -9.312941735677756e-18,   1.571379300993677e-18,   1.570159061065088e-20,  -1.312435336117974e-22,
  -4.014454038954408e-24,  -1.336943857808517e-26,   1.509592649008319e+00,  -7.645442349272157e-03,  -5.495757759568518e-05,   9.418535464105618e-08,   6.183084826605063e-09,
   3.904094522222438e-11,  -5.106620866993011e-13,  -1.013305820114423e-14,  -9.176712887502783e-18,   1.569973062662034e-18,   1.565043642640759e-20,  -1.314406035291301e-22,
  -4.003568247558454e-24,  -1.320267429434847e-26,   1.509584060926397e+00,  -7.645398010838712e-03,  -5.495177781813710e-05,   9.424629003798285e-08,   6.181886335706575e-09,
   3.900771848148360e-11,  -5.107013232613049e-13,  -1.012422887616754e-14,  -9.067076888136571e-18,   1.568839708692115e-18,   1.560926107457548e-20,  -1.315987503035894e-22,
  -3.994802894373124e-24,  -1.306858758870302e-26,   1.509578386240425e+00,  -7.645368707576355e-03,  -5.494794563417269e-05,   9.428654556774953e-08,   6.181094377630165e-09,
   3.898576814475608e-11,  -5.107271624114827e-13,  -1.011839578367927e-14,  -8.994684322595429e-18,   1.568090561001951e-18,   1.558206967789865e-20,  -1.317029524064525e-22,
  -3.989012914418579e-24,  -1.298011094356288e-26,   1.509575472068857e+00,  -7.645353657336298e-03,  -5.494597768796510e-05,   9.430721577236740e-08,   6.180687664126183e-09,
   3.897449723598435e-11,  -5.107404049479344e-13,  -1.011540057290712e-14,  -8.957523646731672e-18,   1.567705761357935e-18,   1.556811070964721e-20,  -1.317563729310849e-22,
  -3.986040104571283e-24,  -1.293471273265771e-26,   1.509574457772908e+00,  -7.645348418705688e-03,  -5.494529273639431e-05,   9.431440975898013e-08,   6.180546102949339e-09,
   3.897057455395476e-11,  -5.107450098199504e-13,  -1.011435811989689e-14,  -8.944592138952736e-18,   1.567571816154862e-18,   1.556325297715402e-20,  -1.317749517545987e-22,
  -3.985005489932482e-24,  -1.291891764160805e-26,   1.509574296818496e+00,  -7.645347587394971e-03,  -5.494518404449418e-05,   9.431555132339009e-08,   6.180523639101407e-09,
   3.896995209073024e-11,  -5.107457403449342e-13,  -1.011419269969224e-14,  -8.942540210459403e-18,   1.567550560318628e-18,   1.556248216056222e-20,  -1.317778992612576e-22,
  -3.984841315541533e-24,  -1.291641147116078e-26,   1.716829688862929e+00,  -5.221721184275920e-03,  -5.770799871180523e-05,  -3.398859590318819e-07,   1.425876574450402e-09,
   5.975878702699359e-11,   6.242663953899043e-13,  -2.167753174806298e-17,  -9.789154106553902e-17,  -1.428100971189989e-18,  -4.601078105707097e-21,   1.797222388852439e-22,
   3.538243953098443e-24,   2.119832309020062e-26,   1.716824280368762e+00,  -5.221816579684578e-03,  -5.770719172135853e-05,  -3.398299363541269e-07,   1.426751403362591e-09,
   5.975866812545497e-11,   6.240090462729506e-13,  -2.647303180683372e-17,  -9.791025289023092e-17,  -1.427168471242404e-18,  -4.579319433041231e-21,   1.798723055388451e-22,
   3.535357243151211e-24,   2.110861279545587e-26,   1.716814737057672e+00,  -5.221984893576657e-03,  -5.770576737464403e-05,  -3.397310835704970e-07,   1.428294758389948e-09,
   5.975845065813502e-11,   6.235549101907450e-13,  -3.493220430118591e-17,  -9.794319568884164e-17,  -1.425522436367515e-18,  -4.540940500032165e-21,   1.801365679310996e-22,
   3.530257592866902e-24,   2.095037323205186e-26,   1.716803197289588e+00,  -5.222188398695966e-03,  -5.770404435850111e-05,  -3.396115499243092e-07,   1.430160497856081e-09,
   5.975817462992057e-11,   6.230056967171895e-13,  -4.515675510964171e-17,  -9.798290346078013e-17,  -1.423530970884176e-18,  -4.494557177182288e-21,   1.804552089765228e-22,
   3.524080816574467e-24,   2.075912341117882e-26,   1.716791994793150e+00,  -5.222385935075310e-03,  -5.770237097136446e-05,  -3.394955089400232e-07,   1.431971199786075e-09,
   5.975789298917711e-11,   6.224724594774448e-13,  -5.507799334058899e-17,  -9.802131811645350e-17,  -1.421596579948023e-18,  -4.449555144229149e-21,   1.807635897746747e-22,
   3.518073820556297e-24,   2.057356134154684e-26,   1.716782970287008e+00,  -5.222545051429013e-03,  -5.770102240174762e-05,  -3.394020279863834e-07,   1.433429501061681e-09,
   5.975765630582656e-11,   6.220428402149109e-13,  -6.306713216585121e-17,  -9.805216922764792e-17,  -1.420037465314036e-18,  -4.413320806438475e-21,   1.810113365739447e-22,
   3.513227017560498e-24,   2.042414677767373e-26,   1.716777007092952e+00,  -5.222650184658663e-03,  -5.770013104094916e-05,  -3.393402575144803e-07,   1.434392936136206e-09,
   5.975749511372207e-11,   6.217589308822379e-13,  -6.834460556465845e-17,  -9.807250847482870e-17,  -1.419006841708174e-18,  -4.389386972199044e-21,   1.811747100100200e-22,
   3.510020598541234e-24,   2.032545155048852e-26,   1.716773944719488e+00,  -5.222704173121555e-03,  -5.769967320721536e-05,  -3.393085354456578e-07,   1.434887649106710e-09,
   5.975741085088561e-11,   6.216131222629740e-13,  -7.105434353662711e-17,  -9.808293923722458e-17,  -1.418477447165513e-18,  -4.377098640831074e-21,   1.812585070482440e-22,
   3.508372794092439e-24,   2.027477775033591e-26,   1.716772878834272e+00,  -5.222722963905501e-03,  -5.769951384168378e-05,  -3.392974942929677e-07,   1.435059829405651e-09,
   5.975738128636099e-11,   6.215623710297970e-13,  -7.199741350004809e-17,  -9.808656746507104e-17,  -1.418293167452049e-18,  -4.372822026473240e-21,   1.812876569725319e-22,
   3.507799076909267e-24,   2.025714201048353e-26,   1.716772709693058e+00,  -5.222725945725372e-03,  -5.769948855198446e-05,  -3.392957422142812e-07,   1.435087151616682e-09,
   5.975737658367135e-11,   6.215543174507186e-13,  -7.214706195726209e-17,  -9.808714310593753e-17,  -1.418263923893183e-18,  -4.372143408129584e-21,   1.812922818854201e-22,
   3.507708027172268e-24,   2.025434354410571e-26,   1.878670229246573e+00,  -2.527064881961736e-03,  -3.630400658761747e-05,  -4.065280891254091e-07,  -3.353184415608908e-09,
  -1.231125287933569e-11,   2.050853329814330e-13,   5.498867922111473e-15,   7.406367589345286e-17,   5.840337886169275e-19,  -3.569916966027598e-22,  -1.027965955487369e-22,
  -1.999805435131780e-24,  -2.284658922192836e-26,   1.878666821969602e+00,  -2.527179258074806e-03,  -3.630589110800250e-05,  -4.065395395887397e-07,  -3.352893716312780e-09,
  -1.230039590564692e-11,   2.052797091766445e-13,   5.500825021160466e-15,   7.406177032872097e-17,   5.834972854624121e-19,  -3.694100142615776e-22,  -1.029627468929377e-22,
  -2.000772987904049e-24,  -2.283014560511485e-26,   1.878660809632254e+00,  -2.527381079131038e-03,  -3.630921624043619e-05,  -4.065597358270682e-07,  -3.352380550612625e-09,
  -1.228123547886647e-11,   2.056226847269585e-13,   5.504276876422221e-15,   7.405836529766372e-17,   5.825499216194393e-19,  -3.913271517146918e-22,  -1.032558246819319e-22,
  -2.002476004499561e-24,  -2.280104774446337e-26,   1.878653539204967e+00,  -2.527625127749730e-03,  -3.631323679852004e-05,  -4.065841432071047e-07,  -3.351759646266720e-09,
  -1.225806115777001e-11,   2.060374070259438e-13,   5.508448377315947e-15,   7.405417519517328e-17,   5.814031733905636e-19,  -4.178377933443523e-22,  -1.036100485541192e-22,
  -2.004528067195216e-24,  -2.276572105751409e-26,   1.878646480943743e+00,  -2.527862050573352e-03,  -3.631713964830141e-05,  -4.066078226732755e-07,  -3.351156486301365e-09,
  -1.223555835030842e-11,   2.064400044251729e-13,   5.512495358248720e-15,   7.405003136844741e-17,   5.802886887214855e-19,  -4.435824386713996e-22,  -1.039537456341479e-22,
  -2.006512583745342e-24,  -2.273127862128263e-26,   1.878640794716680e+00,  -2.528052915848937e-03,  -3.632028356244868e-05,  -4.066268879406286e-07,  -3.350670304192742e-09,
  -1.221742638631539e-11,   2.067643259883923e-13,   5.515753660787375e-15,   7.404663858581115e-17,   5.793899852078696e-19,  -4.643281197264810e-22,  -1.042304961772213e-22,
  -2.008105842162890e-24,  -2.270342627856762e-26,   1.878637037269235e+00,  -2.528179037852884e-03,  -3.632236092121720e-05,  -4.066394807377298e-07,  -3.350348904524438e-09,
  -1.220544315207653e-11,   2.069786291029469e-13,   5.517905761884210e-15,   7.404436997262744e-17,   5.787957026847661e-19,  -4.780394920747556e-22,  -1.044133055271244e-22,
  -2.009155972704499e-24,  -2.268497006629936e-26,   1.878635107612384e+00,  -2.528243808040616e-03,  -3.632342771845455e-05,  -4.066459461358062e-07,  -3.350183807370229e-09,
  -1.219928858330537e-11,   2.070886831365238e-13,   5.519010681932878e-15,   7.404319666605009e-17,   5.784903755905602e-19,  -4.850818632077974e-22,  -1.045071675271496e-22,
  -2.009694440097919e-24,  -2.267547587423939e-26,   1.878634435973219e+00,  -2.528266351977830e-03,  -3.632379902288052e-05,  -4.066481962211617e-07,  -3.350126336940816e-09,
  -1.219714633303875e-11,   2.071269883118555e-13,   5.519395213800249e-15,   7.404278697004946e-17,   5.783840822754705e-19,  -4.875331721912936e-22,  -1.045398339732286e-22,
  -2.009881727253096e-24,  -2.267216877957403e-26,   1.878634329393124e+00,  -2.528269929393994e-03,  -3.632385794358354e-05,  -4.066485532665820e-07,  -3.350117216849831e-09,
  -1.219680638285622e-11,   2.071330668090302e-13,   5.519456231543256e-15,   7.404272189446488e-17,   5.783672139732416e-19,  -4.879221681538792e-22,  -1.045450175419437e-22,
  -2.009911440908950e-24,  -2.267164386794267e-26,   1.976267751011761e+00,  -5.302601054881004e-04,  -8.752729412556509e-06,  -1.258225339183771e-07,  -1.650880975758236e-09,
  -2.007878854877998e-11,  -2.265211986188281e-13,  -2.341482655241380e-15,  -2.143430521171361e-17,  -1.577263880704696e-19,  -5.670408061373611e-22,   9.193879488973393e-24,
   2.837641347135859e-25,   5.028956960326334e-27,   1.976266928577177e+00,  -5.302955594554222e-04,  -8.753659833483197e-06,  -1.258413965830643e-07,  -1.651200186596772e-09,
  -2.008340677780919e-11,  -2.265775116017058e-13,  -2.342013701346098e-15,  -2.143663988718590e-17,  -1.576775295962388e-19,  -5.652562479871949e-22,   9.231137467114465e-24,
   2.843839758932143e-25,   5.037713346273364e-27,   1.976265477307262e+00,  -5.303581228593033e-04,  -8.755301722007020e-06,  -1.258746835747237e-07,  -1.651763503552318e-09,
  -2.009155656506682e-11,  -2.266768816949371e-13,  -2.342950605434153e-15,  -2.144075331273058e-17,  -1.575911613649042e-19,  -5.621042408959951e-22,   9.296931918533029e-24,
   2.854784210985149e-25,   5.053171867507698e-27,   1.976263722294845e+00,  -5.304337825636063e-04,  -8.757287360390921e-06,  -1.259149405682816e-07,  -1.652444782260756e-09,
  -2.010141282318679e-11,  -2.267970495029340e-13,  -2.344083289185495e-15,  -2.144571682396011e-17,  -1.574864566659849e-19,  -5.582874673769396e-22,   9.376580245676551e-24,
   2.868030734798957e-25,   5.071877669898319e-27,   1.976262018432105e+00,  -5.305072394111484e-04,  -8.759215244788271e-06,  -1.259540276524360e-07,  -1.653106270852739e-09,
  -2.011098262440519e-11,  -2.269137151466726e-13,  -2.345182637019664e-15,  -2.145052432358523e-17,  -1.573845310400451e-19,  -5.545766219937685e-22,   9.453994675321879e-24,
   2.880903192555204e-25,   5.090050748848869e-27,   1.976260645731390e+00,  -5.305664208214592e-04,  -8.760768510430269e-06,  -1.259855202074827e-07,  -1.653639239871437e-09,
  -2.011869301821383e-11,  -2.270077057805252e-13,  -2.346068083720289e-15,  -2.145438930101502e-17,  -1.573022202436317e-19,  -5.515832073767687e-22,   9.516425547784304e-24,
   2.891282365767820e-25,   5.104700635235964e-27,   1.976259738630628e+00,  -5.306055295505672e-04,  -8.761794972284707e-06,  -1.260063321344166e-07,  -1.653991456656747e-09,
  -2.012378844096293e-11,  -2.270698162025068e-13,  -2.346653086011175e-15,  -2.145693934746049e-17,  -1.572477323457013e-19,  -5.496032500513412e-22,   9.557711481820578e-24,
   2.898145287142237e-25,   5.114385859984629e-27,   1.976259272777196e+00,  -5.306256145915966e-04,  -8.762322137887570e-06,  -1.260170207374601e-07,  -1.654172349308570e-09,
  -2.012640534882773e-11,  -2.271017138295951e-13,  -2.346953486333336e-15,  -2.145824772346163e-17,  -1.572197197633331e-19,  -5.485858401826246e-22,   9.578923907562216e-24,
   2.901671132484956e-25,   5.119361183000897e-27,   1.976259110630447e+00,  -5.306326055073710e-04,  -8.762505627212995e-06,  -1.260207411123302e-07,  -1.654235312639400e-09,
  -2.012731621375878e-11,  -2.271128162425533e-13,  -2.347058039220164e-15,  -2.145870292543586e-17,  -1.572099648804435e-19,  -5.482316247010858e-22,   9.586308698435752e-24,
   2.902898559227956e-25,   5.121093127980383e-27,   1.976259084899887e+00,  -5.306337148757526e-04,  -8.762534744655974e-06,  -1.260213314897445e-07,  -1.654245304147177e-09,
  -2.012746075672170e-11,  -2.271145780497871e-13,  -2.347074630124125e-15,  -2.145877515068603e-17,  -1.572084166847485e-19,  -5.481754109934084e-22,   9.587480639565870e-24,
   2.903093345581104e-25,   5.121367975105283e-27,   4.817026851157615e-03,  -7.514084178765289e-05,   8.771841044675985e-07,  -9.081231039584567e-09,   8.782161984493774e-11,
  -8.123949546700649e-13,   7.267249860924308e-15,  -6.338043218260828e-17,   5.398487490489454e-19,  -4.517525089075094e-21,   3.693975241697739e-23,  -2.990468796990681e-25,
   2.329392016594892e-27,  -1.862666939219753e-29,   4.817109186290383e-03,  -7.514339856548114e-05,   8.772335618217570e-07,  -9.081993709768028e-09,   8.783185619676543e-11,
  -8.125199779009259e-13,   7.268670190663905e-15,  -6.339571915551190e-17,   5.400050536736988e-19,  -4.519072372784288e-21,   3.695421729105189e-23,  -2.991836766202435e-25,
   2.330508708520262e-27,  -1.863735921228869e-29,   4.817254471706115e-03,  -7.514791021482286e-05,   8.773208347877320e-07,  -9.083339548691777e-09,   8.784992002598901e-11,
  -8.127406078501852e-13,   7.271176718729068e-15,  -6.342269750958966e-17,   5.402809053052397e-19,  -4.521803153335504e-21,   3.697974641406024e-23,  -2.994251204614455e-25,
   2.332479787004685e-27,  -1.865621906976409e-29,   4.817430158826377e-03,  -7.515336604720530e-05,   8.774263741820784e-07,  -9.084967114153678e-09,   8.787176577297651e-11,
  -8.130074377070290e-13,   7.274208208639063e-15,  -6.345532727110717e-17,   5.406145527369387e-19,  -4.525106221434582e-21,   3.701062609599091e-23,  -2.997171852335340e-25,
   2.334864359459087e-27,  -1.867902033407684e-29,   4.817600719589224e-03,  -7.515866278670791e-05,   8.775288383684205e-07,  -9.086547296878848e-09,   8.789297614882179e-11,
  -8.132665152549752e-13,   7.277151722923952e-15,  -6.348701126967667e-17,   5.409385405932217e-19,  -4.528313808284567e-21,   3.704061360593923e-23,  -3.000008300557688e-25,
   2.337180439105899e-27,  -1.870115090628083e-29,   4.817738125956643e-03,  -7.516292999463565e-05,   8.776113881814288e-07,  -9.087820393598385e-09,   8.791006503187389e-11,
  -8.134752561035041e-13,   7.279523407105664e-15,  -6.351254092673072e-17,   5.411996045657839e-19,  -4.530898533481117e-21,   3.706477835629853e-23,  -3.002294118753173e-25,
   2.339047087960601e-27,  -1.871897576752285e-29,   4.817828924003845e-03,  -7.516574979903767e-05,   8.776659385637746e-07,  -9.088661693002678e-09,   8.792135807993797e-11,
  -8.136132036867379e-13,   7.281090783032941e-15,  -6.352941313320482e-17,   5.413721421180090e-19,  -4.532606833760176e-21,   3.708074952013513e-23,  -3.003804944428782e-25,
   2.340280950587928e-27,  -1.873075252576408e-29,   4.817875553877778e-03,  -7.516719793736141e-05,   8.776939537034238e-07,  -9.089093758987353e-09,   8.792715791549426e-11,
  -8.136840511184957e-13,   7.281895770292129e-15,  -6.353807864245041e-17,   5.414607580349151e-19,  -4.533484239013640e-21,   3.708895256797796e-23,  -3.004580948697958e-25,
   2.340914726318843e-27,  -1.873679996080019e-29,   4.817891783948987e-03,  -7.516770198055423e-05,   8.777037047739197e-07,  -9.089244146453123e-09,   8.792917665152680e-11,
  -8.137087109717159e-13,   7.282175963784244e-15,  -6.354109488347561e-17,   5.414916031492311e-19,  -4.533789645670853e-21,   3.709180788760860e-23,  -3.004851063670433e-25,
   2.341135338189988e-27,  -1.873890474721198e-29,   4.817894359443297e-03,  -7.516778196552290e-05,   8.777052521413774e-07,  -9.089268011012488e-09,   8.792949699951366e-11,
  -8.137126241866815e-13,   7.282220427121761e-15,  -6.354157352561344e-17,   5.414964979168414e-19,  -4.533838110342649e-21,   3.709226099575664e-23,  -3.004893928125998e-25,
   2.341170347225402e-27,  -1.873923874408784e-29,   4.326447825318735e-02,  -6.662911231521933e-04,   7.561886974815251e-06,  -7.446261677384559e-08,   6.645965055866793e-10,
  -5.442002586031184e-12,   4.052776804756583e-14,  -2.667682748735613e-16,   1.407781057745813e-18,  -3.809617869147552e-21,  -3.925462792567019e-23,   8.591568194159606e-25,
  -1.114289376883985e-26,   1.061362397316990e-28,   4.326518792980739e-02,  -6.663120837090831e-04,   7.562261131587481e-06,  -7.446772305891611e-08,   6.646535413039907e-10,
  -5.442527987444006e-12,   4.053145999248573e-14,  -2.667810159155566e-16,   1.407613220830531e-18,  -3.805157497631867e-21,  -3.932397636085053e-23,   8.599363738941991e-25,
  -1.115156413420387e-26,   1.061983699042379e-28,   4.326644019394314e-02,  -6.663490701103776e-04,   7.562921363201738e-06,  -7.447673357990836e-08,   6.647541859455585e-10,
  -5.443455086852324e-12,   4.053797412793454e-14,  -2.668034854238449e-16,   1.407316831739768e-18,  -3.797283830347428e-21,  -3.944638640850537e-23,   8.613122804962347e-25,
  -1.116686540083888e-26,   1.063080788987682e-28,   4.326795449384069e-02,  -6.663937964551745e-04,   7.563719766834081e-06,  -7.448762988132696e-08,   6.648758937185473e-10,
  -5.444576180047489e-12,   4.054585047689203e-14,  -2.668306348815932e-16,   1.406958028608181e-18,  -3.787757328365042e-21,  -3.959448036842442e-23,   8.629766734522397e-25,
  -1.118537171635815e-26,   1.064408755919046e-28,   4.326942460099467e-02,  -6.664372181038022e-04,   7.564494889872323e-06,  -7.449820853754398e-08,   6.649940530541507e-10,
  -5.445664554219962e-12,   4.055349605751012e-14,  -2.668569691987855e-16,   1.406609283159422e-18,  -3.778503321115072e-21,  -3.973832536551862e-23,   8.645930995531709e-25,
  -1.120334135559814e-26,   1.065699343012837e-28,   4.327060893676146e-02,  -6.664721995148795e-04,   7.565119352310807e-06,  -7.450673107802681e-08,   6.650892460778535e-10,
  -5.446541360299927e-12,   4.055965477708924e-14,  -2.668781680808350e-16,   1.406328033342502e-18,  -3.771044225029198e-21,  -3.985426087836793e-23,   8.658957461772347e-25,
  -1.121782033973079e-26,   1.066740041754699e-28,   4.327139154264014e-02,  -6.664953153404712e-04,   7.565532002319358e-06,  -7.451236287194424e-08,   6.651521505757857e-10,
  -5.447120750863548e-12,   4.056372412355725e-14,  -2.668921682343847e-16,   1.406142039091202e-18,  -3.766113336177191e-21,  -3.993089635027757e-23,   8.667567444427331e-25,
  -1.122738919888402e-26,   1.067428216179387e-28,   4.327179345374169e-02,  -6.665071866494472e-04,   7.565743922900937e-06,  -7.451525514521416e-08,   6.651844558629028e-10,
  -5.447418299575301e-12,   4.056581385784786e-14,  -2.668993556044153e-16,   1.406046475937774e-18,  -3.763580454432294e-21,  -3.997026079091730e-23,   8.671989802026787e-25,
  -1.123230369937194e-26,   1.067781781178166e-28,   4.327193334346262e-02,  -6.665113186033073e-04,   7.565817684605252e-06,  -7.451626183976998e-08,   6.651957001440813e-10,
  -5.447521864755583e-12,   4.056654119788520e-14,  -2.669018568556397e-16,   1.406013206950336e-18,  -3.762698760743241e-21,  -3.998396329169853e-23,   8.673529158661135e-25,
  -1.123401430520361e-26,   1.067904867320877e-28,   4.327195554207657e-02,  -6.665119742891904e-04,   7.565829389610089e-06,  -7.451642158891821e-08,   6.651974844628244e-10,
  -5.447538299153100e-12,   4.056665661620409e-14,  -2.669022537517806e-16,   1.406007927270955e-18,  -3.762558843302620e-21,  -3.998613775379314e-23,   8.673773438798243e-25,
  -1.123428575806109e-26,   1.067924400564929e-28,   1.196688539631685e-01,  -1.794769577150595e-03,   1.918059868626141e-05,  -1.685074568574561e-07,   1.220864515366740e-09,
  -6.592383203650946e-12,   1.220974324941061e-14,   2.891725472595977e-16,  -5.193715581280551e-18,   5.510989953542489e-20,  -4.239341895327882e-22,   1.897870582284311e-24,
   5.179193781087386e-27,  -2.676143016514528e-28,   1.196706535195457e-01,  -1.794816991531108e-03,   1.918128551712206e-05,  -1.685136323901403e-07,   1.220881523562049e-09,
  -6.591810933228124e-12,   1.219607286140535e-14,   2.893587955901275e-16,  -5.195502970101435e-18,   5.511960840406341e-20,  -4.239008072424666e-22,   1.895894433349928e-24,
   5.207999854718781e-27,  -2.679628916000463e-28,   1.196738289174925e-01,  -1.794900656363941e-03,   1.918249744873899e-05,  -1.685245287777853e-07,   1.220911519147001e-09,
  -6.590800854815310e-12,   1.217194743247706e-14,   2.896874602876635e-16,  -5.198656730169901e-18,   5.513673155196839e-20,  -4.238417585462158e-22,   1.892405417062999e-24,
   5.258847701349567e-27,  -2.685778327495031e-28,   1.196776687319800e-01,  -1.795001827182108e-03,   1.918396294262291e-05,  -1.685377040609956e-07,   1.220947763452806e-09,
  -6.589578948637764e-12,   1.214276820262722e-14,   2.900849304712601e-16,  -5.202470093050748e-18,   5.515742288119430e-20,  -4.237701087245726e-22,   1.888182931699946e-24,
   5.320366008564067e-27,  -2.693211674532408e-28,   1.196813964509979e-01,  -1.795100044583078e-03,   1.918538563255944e-05,  -1.685504936173579e-07,   1.220982920858828e-09,
  -6.588392210666475e-12,   1.211443470127661e-14,   2.904708350837349e-16,  -5.206171832480994e-18,   5.517749482527548e-20,  -4.237002930467215e-22,   1.884080120642095e-24,
   5.380121026434675e-27,  -2.700425120763481e-28,   1.196843995200131e-01,  -1.795179169050971e-03,   1.918653174298443e-05,  -1.685607961582688e-07,   1.221011223187277e-09,
  -6.587435808353332e-12,   1.209160472178048e-14,   2.907817487965665e-16,  -5.209153756830099e-18,   5.519365388413494e-20,  -4.236438646182518e-22,   1.880772302257319e-24,
   5.428283350120470e-27,  -2.706234224988864e-28,   1.196863839273514e-01,  -1.795231453974516e-03,   1.918728907718835e-05,  -1.685676036198308e-07,   1.221029915058010e-09,
  -6.586803647872442e-12,   1.207651668906836e-14,   2.909872116689614e-16,  -5.211124086340572e-18,   5.520432629143272e-20,  -4.236064867084820e-22,   1.878585258906037e-24,
   5.460120138603301e-27,  -2.710071818091845e-28,   1.196874030256233e-01,  -1.795258305058099e-03,   1.918767800603942e-05,  -1.685710994923379e-07,   1.221039511195883e-09,
  -6.586478945424177e-12,   1.206876752353903e-14,   2.910927318266497e-16,  -5.212135922225373e-18,   5.520980547124715e-20,  -4.235872632127171e-22,   1.877461706781661e-24,
   5.476473560265457e-27,  -2.712042308482973e-28,   1.196877577337258e-01,  -1.795267650867192e-03,   1.918781337652655e-05,  -1.685723162492880e-07,   1.221042850736811e-09,
  -6.586365920562510e-12,   1.206607023789571e-14,   2.911294599023114e-16,  -5.212488097371582e-18,   5.521171229328661e-20,  -4.235805678168993e-22,   1.877070580385173e-24,
   5.482166108806863e-27,  -2.712728108330119e-28,   1.196878140210933e-01,  -1.795269133920450e-03,   1.918783485796984e-05,  -1.685725093312181e-07,   1.221043380653045e-09,
  -6.586347984636763e-12,   1.206564221022817e-14,   2.911352881809438e-16,  -5.212543982546115e-18,   5.521201486749721e-20,  -4.235795051370057e-22,   1.877008510984481e-24,
   5.483069465891035e-27,  -2.712836933070638e-28,   2.329640410763394e-01,  -3.350127335920956e-03,   3.236483008828351e-05,  -2.279898478664906e-07,   9.065262777223733e-10,
   3.898599187665251e-12,  -1.197993428586511e-13,   1.304077267085310e-15,  -7.822107659258293e-18,  -7.008927891074958e-21,   8.177169267765195e-22,  -1.132338429935240e-23,
   8.378537268949556e-26,  -1.586791029743781e-28,   2.329670762949117e-01,  -3.350191444985330e-03,   3.236533905587716e-05,  -2.279861713546670e-07,   9.063575683641459e-10,
   3.901166180839501e-12,  -1.198198042116307e-13,   1.304052088721038e-15,  -7.818641357213635e-18,  -7.067356463249045e-21,   8.182325678372447e-22,  -1.132448547759217e-23,
   8.372548812020357e-26,  -1.576080415270854e-28,   2.329724320245920e-01,  -3.350304565595258e-03,   3.236623706000645e-05,  -2.279796821352052e-07,   9.060598546779922e-10,
   3.905695639695903e-12,  -1.198559011838044e-13,   1.304007500748057e-15,  -7.812523246504208e-18,  -7.170459155109933e-21,   8.191421225479454e-22,  -1.132642214652108e-23,
   8.361974668131714e-26,  -1.557174048224396e-28,   2.329789082962311e-01,  -3.350441350808253e-03,   3.236732280456051e-05,  -2.279718319657039e-07,   9.056998162666244e-10,
   3.911172639686087e-12,  -1.198995373960241e-13,   1.303953311070800e-15,  -7.805122150821448e-18,  -7.295139783601165e-21,   8.202414505421491e-22,  -1.132875311030726e-23,
   8.349175662341766e-26,  -1.534299787789521e-28,   2.329851954178346e-01,  -3.350574138019907e-03,   3.236837668872444e-05,  -2.279642076636450e-07,   9.053502554952531e-10,
   3.916489542885856e-12,  -1.199418854438874e-13,   1.303900418332426e-15,  -7.797934143225683e-18,  -7.416185673842963e-21,   8.213081192080379e-22,  -1.133100457553647e-23,
   8.336737386547853e-26,  -1.512080784262089e-28,   2.329902602908173e-01,  -3.350681108591950e-03,   3.236922558532278e-05,  -2.279580631220697e-07,   9.050686240009801e-10,
   3.920772718080529e-12,  -1.199759909978129e-13,   1.303857603462595e-15,  -7.792141320009320e-18,  -7.513704451973173e-21,   8.221670265329441e-22,  -1.133281016015609e-23,
   8.326707807808293e-26,  -1.494172081805418e-28,   2.329936070929317e-01,  -3.350751792312023e-03,   3.236978647270511e-05,  -2.279540016929357e-07,   9.048825122973408e-10,
   3.923602937992774e-12,  -1.199985226963558e-13,   1.303829211700712e-15,  -7.788312420414769e-18,  -7.578145948238200e-21,   8.227343875749404e-22,  -1.133399925869454e-23,
   8.320075809663425e-26,  -1.482333746550532e-28,   2.329953258434631e-01,  -3.350788091620961e-03,   3.237007450025483e-05,  -2.279519155757408e-07,   9.047869305086017e-10,
   3.925056383298562e-12,  -1.200100923652845e-13,   1.303814600104077e-15,  -7.786345755525874e-18,  -7.611240612193891e-21,   8.230256959566023e-22,  -1.133460868054235e-23,
   8.316668529771355e-26,  -1.476252777458245e-28,   2.329959240715204e-01,  -3.350800725901839e-03,   3.237017474849970e-05,  -2.279511894232094e-07,   9.047536616715642e-10,
   3.925562266966269e-12,  -1.200141190658163e-13,   1.303809509457867e-15,  -7.785661185400399e-18,  -7.622759651786262e-21,   8.231270791659557e-22,  -1.133482059842123e-23,
   8.315482366967051e-26,  -1.474136014815875e-28,   2.329960190021309e-01,  -3.350802730786976e-03,   3.237019065640246e-05,  -2.279510741899390e-07,   9.047483823311252e-10,
   3.925642543676339e-12,  -1.200147580368770e-13,   1.303808701407610e-15,  -7.785552550967063e-18,  -7.624587571310130e-21,   8.231431668415425e-22,  -1.133485421751851e-23,
   8.315294128451345e-26,  -1.473800103024272e-28,   3.813248962922894e-01,  -5.160472908861715e-03,   4.247660228028828e-05,  -1.850376564793379e-07,  -7.530939261997801e-10,
   2.255776560691490e-11,  -1.994484510296885e-13,   3.158413912787860e-16,   1.553943491098731e-17,  -2.287544767316216e-19,   1.269573820570658e-21,   8.187084936948326e-24,
  -2.523786933857051e-25,   2.330609793103214e-27,   3.813288776123541e-01,  -5.160524876091749e-03,   4.247617708560267e-05,  -1.850165035027430e-07,  -7.533739161794242e-10,
   2.255837515840190e-11,  -1.994075506673287e-13,   3.150704666095030e-16,   1.554474066116149e-17,  -2.287116051479193e-19,   1.268011045942638e-21,   8.203991798188935e-24,
  -2.524046716598934e-25,   2.328152638691255e-27,   3.813359026817511e-01,  -5.160616568250396e-03,   4.247542669495011e-05,  -1.849791782813873e-07,  -7.538679161068711e-10,
   2.255944948821669e-11,  -1.993353700407231e-13,   3.137102759994813e-16,   1.555409737982825e-17,  -2.286358868276135e-19,   1.265253377940743e-21,   8.233809596036965e-24,
  -2.524502269330913e-25,   2.323815669595179e-27,   3.813443974153214e-01,  -5.160727435142003e-03,   4.247451909642039e-05,  -1.849340434388653e-07,  -7.544651862968653e-10,
   2.256074647643327e-11,  -1.992480692067898e-13,   3.120657204784294e-16,   1.556540248279404e-17,  -2.285442068561997e-19,   1.261918559761599e-21,   8.269840654139855e-24,
  -2.525048289584394e-25,   2.318569181279178e-27,   3.813526438976014e-01,  -5.160835054165724e-03,   4.247363778706796e-05,  -1.848902264926955e-07,  -7.550449222811260e-10,
   2.256200336819947e-11,  -1.991632989209838e-13,   3.104694256213934e-16,   1.557636770809222e-17,  -2.284550793213503e-19,   1.258680950459688e-21,   8.304792856416275e-24,
  -2.525573289335133e-25,   2.313473707228283e-27,   3.813592871149053e-01,  -5.160921744464327e-03,   4.247292765207238e-05,  -1.848549275420470e-07,  -7.555118901601294e-10,
   2.256301432629312e-11,  -1.990949946526174e-13,   3.091836226691253e-16,   1.558519429173345e-17,  -2.283831889502475e-19,   1.256072613790217e-21,   8.332931172768539e-24,
  -2.525992591683612e-25,   2.309367235742871e-27,   3.813636768141952e-01,  -5.160979024839794e-03,   4.247245832739953e-05,  -1.848316023363054e-07,  -7.558204248886074e-10,
   2.256368157701991e-11,  -1.990498533471279e-13,   3.083340611739886e-16,   1.559102338238156e-17,  -2.283356408325431e-19,   1.254348993047101e-21,   8.351515301676154e-24,
  -2.526267881577179e-25,   2.306652959662489e-27,   3.813659311285230e-01,  -5.161008440116452e-03,   4.247221728194743e-05,  -1.848196236380756e-07,  -7.559788631641290e-10,
   2.256402400334179e-11,  -1.990266689435212e-13,   3.078977936503998e-16,   1.559401586064599e-17,  -2.283112089202724e-19,   1.253463807172260e-21,   8.361056305008959e-24,
  -2.526408706366112e-25,   2.305258804287197e-27,   3.813667157622667e-01,  -5.161018678223711e-03,   4.247213337992609e-05,  -1.848154543282928e-07,  -7.560340076127779e-10,
   2.256414314993412e-11,  -1.990185990519983e-13,   3.077459503988495e-16,   1.559505725474653e-17,  -2.283027029920823e-19,   1.253155706284095e-21,   8.364376687049827e-24,
  -2.526457634204027e-25,   2.304773516821257e-27,   3.813668402727881e-01,  -5.161020302863251e-03,   4.247212006564358e-05,  -1.848147927155785e-07,  -7.560427582087599e-10,
   2.256416205505227e-11,  -1.990173184548567e-13,   3.077218551395942e-16,   1.559522250179757e-17,  -2.283013531150624e-19,   1.253106814734307e-21,   8.364903564513703e-24,
  -2.526465394223229e-25,   2.304696506537076e-27,   5.618582784872617e-01,  -6.987888178898379e-03,   4.434748150942464e-05,  -1.770625202545846e-09,  -3.154486054330444e-09,
   2.885610790799348e-11,   2.844041043594091e-14,  -3.298248330884910e-15,   3.020321797959274e-17,   6.692287970834079e-20,  -4.334783236941236e-21,   3.766525950743989e-23,
   1.333191477537589e-25,  -6.404025619157509e-27,   5.618624324939772e-01,  -6.987888581801993e-03,   4.434570734602339e-05,  -1.743627214824277e-09,  -3.154445127529918e-09,
   2.884961817786246e-11,   2.851931668874434e-14,  -3.298017458455681e-15,   3.018495790463685e-17,   6.711527516041375e-20,  -4.333938605365167e-21,   3.761857317419937e-23,
   1.337458552418033e-25,  -6.401446144843611e-27,   5.618697621690898e-01,  -6.987889286567972e-03,   4.434257682567989e-05,  -1.695993785318767e-09,  -3.154372821481342e-09,
   2.883816731877777e-11,   2.865850906237837e-14,  -3.297609553839355e-15,   3.015274062890242e-17,   6.745456440312043e-20,  -4.332446101511048e-21,   3.753620985232187e-23,
   1.344980268748413e-25,  -6.396886191149078e-27,   5.618786250602188e-01,  -6.987890128269530e-03,   4.433879139926677e-05,  -1.638403364093126e-09,  -3.154285234696655e-09,
   2.882432145219424e-11,   2.882675555777575e-14,  -3.297115413718506e-15,   3.011378812811366e-17,   6.786450318042790e-20,  -4.330637706795649e-21,   3.743664161713416e-23,
   1.354062647281754e-25,  -6.391357882928119e-27,   5.618872287603114e-01,  -6.987890934374900e-03,   4.433511660662169e-05,  -1.582504408321881e-09,  -3.154200046217394e-09,
   2.881088078983482e-11,   2.899001680472205e-14,  -3.296634771657554e-15,   3.007597892894816e-17,   6.826211557293782e-20,  -4.328878336820027e-21,   3.734001015982259e-23,
   1.362866096612389e-25,  -6.385976070412792e-27,   5.618941596164041e-01,  -6.987891575879320e-03,   4.433215626569123e-05,  -1.537479261722211e-09,  -3.154131304340616e-09,
   2.880005364418964e-11,   2.912148812196711e-14,  -3.296246899927684e-15,   3.004552407033512e-17,   6.858217687372202e-20,  -4.327458282537364e-21,   3.726218496484506e-23,
   1.369948324999504e-25,  -6.381629796116054e-27,   5.618987393180280e-01,  -6.987891995914282e-03,   4.433020013701711e-05,  -1.507730543867430e-09,  -3.154085824565681e-09,
   2.879289949306485e-11,   2.920833763462172e-14,  -3.295990271942062e-15,   3.002540187558000e-17,   6.879354525400955e-20,  -4.326518600864952e-21,   3.721076919409000e-23,
   1.374623379988504e-25,  -6.378752593193063e-27,   5.619010911877753e-01,  -6.987892210428735e-03,   4.432919557502059e-05,  -1.492454111562014e-09,  -3.154062451095358e-09,
   2.878922556650999e-11,   2.925293147193923e-14,  -3.295858379395130e-15,   3.001506873310797e-17,   6.890205517310920e-20,  -4.326035616674398e-21,   3.718436774790882e-23,
   1.377022774162716e-25,  -6.377273385303174e-27,   5.619019097734127e-01,  -6.987892284902438e-03,   4.432884592860345e-05,  -1.487137161872452e-09,  -3.154054312970331e-09,
   2.878794683425175e-11,   2.926845156456494e-14,  -3.295812456782625e-15,   3.001147227859929e-17,   6.893981701745295e-20,  -4.325867443921093e-21,   3.717517896257887e-23,
   1.377857671245539e-25,  -6.376758274586270e-27,   5.619020396714819e-01,  -6.987892296711368e-03,   4.432879044456025e-05,  -1.486293442421289e-09,  -3.154053021430253e-09,
   2.878774391760053e-11,   2.927091433251154e-14,  -3.295805168727285e-15,   3.001090157509020e-17,   6.894580901598432e-20,  -4.325840754103446e-21,   3.717372085167907e-23,
   1.377990146804590e-25,  -6.376676521322177e-27,   7.701288903086970e-01,  -8.529327572922551e-03,   3.366970921669213e-05,   2.866378991795283e-07,  -4.351912583765563e-09,
  -2.344367087254128e-13,   4.713470173493287e-13,  -3.240141370918545e-15,  -3.552144629849966e-17,   6.769831968272755e-19,  -2.780579189328230e-22,  -9.195954482089216e-23,
   7.321129974441466e-25,   7.482639038655843e-27,   7.701320419312241e-01,  -8.529246957145022e-03,   3.366726500528440e-05,   2.866376261018092e-07,  -4.351250856291588e-09,
  -2.407796047819077e-13,   4.712537529015021e-13,  -3.237868853573685e-15,  -3.552247614559948e-17,   6.765111637655920e-19,  -2.735937723634651e-22,  -9.190475186881293e-23,
   7.306904058470827e-25,   7.484050103406601e-27,   7.701376028329875e-01,  -8.529104709406895e-03,   3.366295245809630e-05,   2.866371394284937e-07,  -4.350083334371992e-09,
  -2.519681134893951e-13,   4.710891842024784e-13,  -3.233860254544632e-15,  -3.552427807341362e-17,   6.756784837613409e-19,  -2.657238512244236e-22,  -9.180806072196527e-23,
   7.281820711408901e-25,   7.486519942915442e-27,   7.701443268180853e-01,  -8.528932702041416e-03,   3.365773819535869e-05,   2.866365427155408e-07,  -4.348671736186957e-09,
  -2.654911877355761e-13,   4.708901823915844e-13,  -3.229015218991983e-15,  -3.552643099186200e-17,   6.746719899843612e-19,  -2.562196191079562e-22,  -9.169112698833659e-23,
   7.251521203718515e-25,   7.489472435403143e-27,   7.701508540147701e-01,  -8.528765720394342e-03,   3.365267681903046e-05,   2.866359548289527e-07,  -4.347301571479091e-09,
  -2.786126738020565e-13,   4.706969911559171e-13,  -3.224314051081921e-15,  -3.552849381068573e-17,   6.736953135462905e-19,  -2.470058014341616e-22,  -9.157759543185087e-23,
   7.222139985786577e-25,   7.492303054930518e-27,   7.701561120019218e-01,  -8.528631202241805e-03,   3.364859982672766e-05,   2.866354750692736e-07,  -4.346197921013153e-09,
  -2.891785304835246e-13,   4.705413561616873e-13,  -3.220528505162410e-15,  -3.553013611908714e-17,   6.729088097064209e-19,  -2.395923823917572e-22,  -9.148612570463181e-23,
   7.198494508368742e-25,   7.494557895273866e-27,   7.701595862698281e-01,  -8.528542315087689e-03,   3.364590601214267e-05,   2.866351550343275e-07,  -4.345468715233728e-09,
  -2.961579880944623e-13,   4.704385140419719e-13,  -3.218027893449117e-15,  -3.553121179946921e-17,   6.723892459371644e-19,  -2.346981866395474e-22,  -9.142567918245094e-23,
   7.182881574066786e-25,   7.496035400528322e-27,   7.701613704366589e-01,  -8.528496667294846e-03,   3.364452266799906e-05,   2.866349897477797e-07,  -4.345094253829585e-09,
  -2.997415709246316e-13,   4.703856992960535e-13,  -3.216743960025208e-15,  -3.553176126756217e-17,   6.721224696032289e-19,  -2.321861615867207e-22,  -9.139463547464055e-23,
   7.174867164462314e-25,   7.496790322710048e-27,   7.701619914265357e-01,  -8.528480779164732e-03,   3.364404119172102e-05,   2.866349320697150e-07,  -4.344963922396944e-09,
  -3.009887578997599e-13,   4.703673165770827e-13,  -3.216297115090723e-15,  -3.553195204619065e-17,   6.720296227452233e-19,  -2.313120477009132e-22,  -9.138383018539692e-23,
   7.172078245553578e-25,   7.497052468102618e-27,   7.701620899688050e-01,  -8.528478257937403e-03,   3.364396478850912e-05,   2.866349229099478e-07,  -4.344943240749644e-09,
  -3.011866639866474e-13,   4.703643994897658e-13,  -3.216226208845499e-15,  -3.553198229787968e-17,   6.720148895640642e-19,  -2.311733482823018e-22,  -9.138211552330822e-23,
   7.171635709578834e-25,   7.497094037910383e-27,   9.994777138480927e-01,  -9.434013425757658e-03,   9.272226943156025e-06,   5.412841452901821e-07,  -2.091869382675546e-09,
  -5.227211130700346e-11,   4.014584304827009e-13,   5.562311196697103e-15,  -7.325194464614894e-17,  -5.653092614980817e-19,   1.281942304311595e-20,   4.261392753771581e-23,
  -2.181669266594405e-24,   6.147109847612674e-28,   9.994785807620039e-01,  -9.433861362158458e-03,   9.271053441641633e-06,   5.412352320691274e-07,  -2.091307092012596e-09,
  -5.226119077212073e-11,   4.012672512846737e-13,   5.560409013749969e-15,  -7.319829176156441e-17,  -5.650893926088621e-19,   1.280606090104005e-20,   4.261767426168220e-23,
  -2.178708530184220e-24,   6.010838578449039e-28,   9.994801103561963e-01,  -9.433593054709801e-03,   9.268983036338968e-06,   5.411489322339998e-07,  -2.090315139414613e-09,
  -5.224192435804111e-11,   4.009300268197183e-13,   5.557053185361059e-15,  -7.310366611129528e-17,  -5.647014155463354e-19,   1.278249803853145e-20,   4.262420500794999e-23,
  -2.173488437158987e-24,   5.770836508345996e-28,   9.994819598060261e-01,  -9.433268633510957e-03,   9.266479917548621e-06,   5.410445917238987e-07,  -2.089116031562340e-09,
  -5.221863238966339e-11,   4.005224461113931e-13,   5.552996310599398e-15,  -7.298932166615962e-17,  -5.642322442782190e-19,   1.275403087512121e-20,   4.263196513818194e-23,
  -2.167183355008216e-24,   5.481391131212200e-28,   9.994837550609494e-01,  -9.432953710958234e-03,   9.264050391133830e-06,   5.409433146022111e-07,  -2.087952347676330e-09,
  -5.219602637917960e-11,   4.001269776364403e-13,   5.549059044169522e-15,  -7.287839959213879e-17,  -5.637767547748033e-19,   1.272642192303640e-20,   4.263935539236483e-23,
  -2.161069929512009e-24,   5.201205418060637e-28,   9.994852011810892e-01,  -9.432700027724689e-03,   9.262093524326582e-06,   5.408617377009545e-07,  -2.087015177894106e-09,
  -5.217781916054037e-11,   3.998085393532339e-13,   5.545888005486757e-15,  -7.278910059932389e-17,  -5.634097998186491e-19,   1.270419946833742e-20,   4.264520648572262e-23,
  -2.156150358937873e-24,   4.976065936558079e-28,   9.994861566957622e-01,  -9.432532405354290e-03,   9.260800622211255e-06,   5.408078383424364e-07,  -2.086396049283835e-09,
  -5.216579005893746e-11,   3.995981924586226e-13,   5.543793017592147e-15,  -7.273012199112785e-17,  -5.631673135283347e-19,   1.268952454331763e-20,   4.264902271280663e-23,
  -2.152902199994974e-24,   4.827578757527539e-28,   9.994866473810252e-01,  -9.432446325408621e-03,   9.260136704776959e-06,   5.407801600522926e-07,  -2.086078139321123e-09,
  -5.215961312850959e-11,   3.994901913549756e-13,   5.542717257961662e-15,  -7.269984248832872e-17,  -5.630427824524682e-19,   1.268199113509194e-20,   4.265096705715192e-23,
  -2.151234920386493e-24,   4.751410317123244e-28,   9.994868181657799e-01,  -9.432416364839415e-03,   9.259905630140249e-06,   5.407705266261528e-07,  -2.085967494565411e-09,
  -5.215746328504341e-11,   3.994526040983397e-13,   5.542342848580770e-15,  -7.268930483631839e-17,  -5.629994378327560e-19,   1.267936951985168e-20,   4.265164134228031e-23,
  -2.150654736640262e-24,   4.724913011751558e-28,   9.994868452668381e-01,  -9.432411610526045e-03,   9.259868962153144e-06,   5.407689979462613e-07,  -2.085949937085425e-09,
  -5.215712213894332e-11,   3.994466396853041e-13,   5.542283435851958e-15,  -7.268763272282487e-17,  -5.629925596177825e-19,   1.267895352728723e-20,   4.265174822520291e-23,
  -2.150562675555049e-24,   4.720708910177983e-28,   1.240124393917346e+00,  -9.357370746923010e-03,  -2.395437767368908e-05,   5.520170104285565e-07,   3.359115576669585e-09,
  -5.839783329234597e-11,  -5.467261053366356e-13,   7.354843185769262e-15,   9.535622280873080e-17,  -1.002791134336258e-18,  -1.744457392573025e-20,   1.386838800871198e-22,
   3.251001566218807e-24,  -1.914586380230031e-26,   1.240122151983122e+00,  -9.357215684829411e-03,  -2.395249249647711e-05,   5.519623838071704e-07,   3.358349684595963e-09,
  -5.838340697134940e-11,  -5.464773005592760e-13,   7.351477251291745e-15,   9.528326644473895e-17,  -1.002081437819590e-18,  -1.742470037446667e-20,   1.385451350682597e-22,
   3.245766150349531e-24,  -1.912301880985645e-26,   1.240118196198028e+00,  -9.356942087791434e-03,  -2.394916642114088e-05,   5.518660052520471e-07,   3.356998539826594e-09,
  -5.835795687903741e-11,  -5.460384359213227e-13,   7.345539950232040e-15,   9.515460174190816e-17,  -1.000829747469884e-18,  -1.738965941648280e-20,   1.383004528151736e-22,
   3.236537240896774e-24,  -1.908273044879778e-26,   1.240113413064424e+00,  -9.356611272582936e-03,  -2.394514509116354e-05,   5.517494819884785e-07,   3.355365204990093e-09,
  -5.832719152336199e-11,  -5.455080208222461e-13,   7.338363814713999e-15,   9.499913480599985e-17,  -9.993171792282267e-19,  -1.734733221887528e-20,   1.380048113960347e-22,
   3.225392986858871e-24,  -1.903405080354959e-26,   1.240108769936607e+00,  -9.356290145158734e-03,  -2.394124187749273e-05,   5.516363828158521e-07,   3.353780098337123e-09,
  -5.829733464640936e-11,  -5.449933801010408e-13,   7.331400813854009e-15,   9.484833137931121e-17,  -9.978498394448874e-19,  -1.730628848113267e-20,   1.377180495852585e-22,
   3.214590491504016e-24,  -1.898683266188187e-26,   1.240105029676259e+00,  -9.356031465025047e-03,  -2.393809794623315e-05,   5.515452856301187e-07,   3.352503519850900e-09,
  -5.827328920947353e-11,  -5.445789906631338e-13,   7.325793994226629e-15,   9.472693287221420e-17,  -9.966685110245590e-19,  -1.727325766447020e-20,   1.374872111404814e-22,
   3.205899703702677e-24,  -1.894882242141057e-26,   1.240102558268466e+00,  -9.355860541606458e-03,  -2.393602071125242e-05,   5.514850971044514e-07,   3.351660157130697e-09,
  -5.825740377844128e-11,  -5.443052666274346e-13,   7.322090323200033e-15,   9.464675736508972e-17,  -9.958882731303065e-19,  -1.725144787295397e-20,   1.373347619502991e-22,
   3.200162642157767e-24,  -1.892371967359585e-26,   1.240101289110024e+00,  -9.355772766666423e-03,  -2.393495401935326e-05,   5.514541895415646e-07,   3.351227104936139e-09,
  -5.824924689011441e-11,  -5.441647262663480e-13,   7.320188686734510e-15,   9.460559653347497e-17,  -9.954876958329409e-19,  -1.724025256585945e-20,   1.372564981970181e-22,
   3.197218134752324e-24,  -1.891083245981713e-26,   1.240100847372217e+00,  -9.355742216178993e-03,  -2.393458275823952e-05,   5.514434322195359e-07,   3.351076385895869e-09,
  -5.824640797608373e-11,  -5.441158146865322e-13,   7.319526864571713e-15,   9.459127221859333e-17,  -9.953482890950358e-19,  -1.723635674274854e-20,   1.372292619514802e-22,
   3.196193550210034e-24,  -1.890634762325455e-26,   1.240100777274721e+00,  -9.355737368255630e-03,  -2.393452384472515e-05,   5.514417251967411e-07,   3.351052469274902e-09,
  -5.824595748738890e-11,  -5.441080533193404e-13,   7.319421845349121e-15,   9.458899924628633e-17,  -9.953261680134349e-19,  -1.723573856753638e-20,   1.372249401323925e-22,
   3.196030975960397e-24,  -1.890563597355754e-26,   1.478175891521737e+00,  -8.079235306365647e-03,  -5.323714362948110e-05,   1.984464509918367e-07,   6.826159330970558e-09,
   2.353237120285322e-11,  -7.902612117693781e-13,  -9.463853566433391e-15,   5.652978490002490e-17,   2.034378714297336e-18,   5.734713915854271e-21,  -3.247155345913187e-22,
  -3.639268242431784e-24,   3.238651123261550e-26,   1.478170908244576e+00,  -8.079179416285059e-03,  -5.323331018440126e-05,   1.984683569129283e-07,   6.825049789631484e-09,
   2.351384770348519e-11,  -7.901123385409278e-13,  -9.457030919991108e-15,   5.655326794803103e-17,   2.032713644413675e-18,   5.712567283983972e-21,  -3.244781163672908e-22,
  -3.631235096810801e-24,   3.239748783325443e-26,   1.478162115464932e+00,  -8.079080792375204e-03,  -5.322654651714303e-05,   1.985069961708304e-07,   6.823092156847940e-09,
   2.348117359593062e-11,  -7.898495996971842e-13,  -9.444996814796061e-15,   5.659462852233467e-17,   2.029776598229680e-18,   5.673529460353923e-21,  -3.240591251617969e-22,
  -3.617074338783499e-24,   3.241668917783233e-26,   1.478151483638505e+00,  -8.078961526794711e-03,  -5.321836868266605e-05,   1.985536951647973e-07,   6.820725256893219e-09,
   2.344168229379582e-11,  -7.895318084644795e-13,  -9.430452822563720e-15,   5.664451330391858e-17,   2.026226788736202e-18,   5.626393100314906e-21,  -3.235523697513035e-22,
  -3.599974606176784e-24,   3.243962332506714e-26,   1.478141162965516e+00,  -8.078845736940621e-03,  -5.321043068746708e-05,   1.985990046044809e-07,   6.818427815670648e-09,
   2.340336426942226e-11,  -7.892232137686342e-13,  -9.416341907587124e-15,   5.669280575866780e-17,   2.022782473620699e-18,   5.580705707482680e-21,  -3.230603094263284e-22,
  -3.583399184496344e-24,   3.246159028588936e-26,   1.478132849138174e+00,  -8.078752451770067e-03,  -5.320403659011013e-05,   1.986354872956226e-07,   6.816577244950251e-09,
   2.337250969732229e-11,  -7.889745506066472e-13,  -9.404980169245547e-15,   5.673161301339225e-17,   2.020009052597023e-18,   5.543951917777596e-21,  -3.226638331430328e-22,
  -3.570063926659672e-24,   3.247907414667029e-26,   1.478127355691596e+00,  -8.078690807473100e-03,  -5.319981180191036e-05,   1.986595855947233e-07,   6.815354527562442e-09,
   2.335212836442866e-11,  -7.888102074713465e-13,  -9.397475389409167e-15,   5.675720893202404e-17,   2.018177049454991e-18,   5.519690807930819e-21,  -3.224018102986689e-22,
  -3.561260880236600e-24,   3.249052333406542e-26,   1.478124534600341e+00,  -8.078659149212910e-03,  -5.319764226918411e-05,   1.986719584992205e-07,   6.814726636703814e-09,
   2.334166368313496e-11,  -7.887257998455072e-13,  -9.393622208495078e-15,   5.677033906380112e-17,   2.017236421194355e-18,   5.507239338159706e-21,  -3.222672372136837e-22,
  -3.556742770012229e-24,   3.249637096529220e-26,   1.478123552702676e+00,  -8.078648130112057e-03,  -5.319688715907808e-05,   1.986762645681296e-07,   6.814508098798291e-09,
   2.333802169059715e-11,  -7.886964194767733e-13,  -9.392281214093358e-15,   5.677490680316899e-17,   2.016909057643027e-18,   5.502906726902853e-21,  -3.222203959424116e-22,
  -3.555170626187895e-24,   3.249840118399856e-26,   1.478123396889466e+00,  -8.078646381525223e-03,  -5.319676733424568e-05,   1.986769478613678e-07,   6.814473420092053e-09,
   2.333744377247201e-11,  -7.886917571446695e-13,  -9.392068423420111e-15,   5.677563153022003e-17,   2.016857111014779e-18,   5.502219259875590e-21,  -3.222129627887720e-22,
  -3.554921168827700e-24,   3.249872310956394e-26,   1.694994318734411e+00,  -5.699215768467665e-03,  -6.160768560926592e-05,  -3.067036767642835e-07,   2.768792878375704e-09,
   7.433158702853756e-11,   5.719267727285791e-13,  -3.993719031701119e-15,  -1.502316088935848e-16,  -1.400986397038387e-18,   7.314726160936784e-21,   3.646956267524099e-22,
   3.857162567500219e-24,  -1.510461678103375e-26,   1.694988546160849e+00,  -5.699301783501777e-03,  -6.160612365530914e-05,  -3.066340578435234e-07,   2.769592493959195e-09,
   7.432365008671480e-11,   5.715330706884204e-13,  -3.998398469441342e-15,  -1.501999971014215e-16,  -1.399110514697032e-18,   7.338201545128040e-21,   3.645789879110861e-22,
   3.848725884136518e-24,  -1.521715009669839e-26,   1.694978360483420e+00,  -5.699453542477700e-03,  -6.160336719835928e-05,  -3.065112202330879e-07,   2.771002978401509e-09,
   7.430963776196203e-11,   5.708384451539188e-13,  -4.006650267251820e-15,  -1.501441374222431e-16,  -1.395800986020346e-18,   7.379581817963902e-21,   3.643725117010374e-22,
   3.833841731486506e-24,  -1.541542893299711e-26,   1.694966044057106e+00,  -5.699637023934612e-03,  -6.160003343959531e-05,  -3.063626940366109e-07,   2.772707784308648e-09,
   7.429268118456094e-11,   5.699986124430182e-13,  -4.016619659837360e-15,  -1.500764546965519e-16,  -1.391799914887339e-18,   7.429546979001048e-21,   3.641217055155132e-22,
   3.815847953585396e-24,  -1.565469884085938e-26,   1.694954087696934e+00,  -5.699815116160189e-03,  -6.159679643357318e-05,  -3.062185182241576e-07,   2.774361977298037e-09,
   7.427620671485545e-11,   5.691834389105833e-13,  -4.026288591460830e-15,  -1.500106065538900e-16,  -1.387916632957819e-18,   7.477976584486896e-21,   3.638770422976413e-22,
   3.798384435379364e-24,  -1.588646381878272e-26,   1.694944455961505e+00,  -5.699958564595859e-03,  -6.159418827750349e-05,  -3.061023798406613e-07,   2.775693998306345e-09,
   7.426292555914968e-11,   5.685268328913959e-13,  -4.034071178922388e-15,  -1.499574578313709e-16,  -1.384788949971840e-18,   7.516936608338634e-21,   3.636790968583234e-22,
   3.784319317981114e-24,  -1.607280234537962e-26,   1.694938091557157e+00,  -5.700053342805498e-03,  -6.159246462626420e-05,  -3.060256414745465e-07,   2.776573892371532e-09,
   7.425414494045443e-11,   5.680930020576790e-13,  -4.039210553598631e-15,  -1.499222880422844e-16,  -1.382722546056968e-18,   7.542654145634550e-21,   3.635478832934837e-22,
   3.775026946076384e-24,  -1.619575119458998e-26,   1.694934823154145e+00,  -5.700102012870597e-03,  -6.159157937832598e-05,  -3.059862338299468e-07,   2.777025672964930e-09,
   7.424963422955461e-11,   5.678702223891829e-13,  -4.041848872515884e-15,  -1.499042111989448e-16,  -1.381661445805918e-18,   7.555853120683463e-21,   3.634803706766458e-22,
   3.770255367220282e-24,  -1.625883554558977e-26,   1.694933685560230e+00,  -5.700118952442046e-03,  -6.159127124844305e-05,  -3.059725178259568e-07,   2.777182905470009e-09,
   7.424806400561937e-11,   5.677926839912770e-13,  -4.042767005035647e-15,  -1.498979169253086e-16,  -1.381292135607140e-18,   7.560445837698152e-21,   3.634568518948596e-22,
   3.768594655056434e-24,  -1.628078375388668e-26,   1.694933505039918e+00,  -5.700121640495458e-03,  -6.159122235194110e-05,  -3.059703412939300e-07,   2.777207855444783e-09,
   7.424781482180258e-11,   5.677803798153950e-13,  -4.042912692495499e-15,  -1.498969179938669e-16,  -1.381233531899061e-18,   7.561174576584220e-21,   3.634531188199360e-22,
   3.768331126687531e-24,  -1.628426621081524e-26,   1.867948899713827e+00,  -2.837939044398901e-03,  -4.151135333461835e-05,  -4.618239955795624e-07,  -3.536252181439581e-09,
  -5.254695118185633e-12,   3.953149813772047e-13,   8.191835246411584e-15,   9.345209528919628e-17,   4.466042270185368e-19,  -7.434559290901908e-21,  -2.291986485458065e-22,
  -3.282017061072148e-24,  -2.429662194909445e-26,   1.867945004045414e+00,  -2.838068948986637e-03,  -4.151333931674576e-05,  -4.618287860292863e-07,  -3.535693378685500e-09,
  -5.238544061702136e-12,   3.955596294541762e-13,   8.193311523348684e-15,   9.342007981558277e-17,   4.454156880717408e-19,  -7.454814087338546e-21,  -2.293723784501924e-22,
  -3.280895062997990e-24,  -2.422541055691549e-26,   1.867938129926117e+00,  -2.838298168750520e-03,  -4.151684335727566e-05,  -4.618372265359365e-07,  -3.534707082979088e-09,
  -5.210042920385422e-12,   3.959912461211699e-13,   8.195913171111918e-15,   9.336351858351421e-17,   4.433177681304756e-19,  -7.490548243995833e-21,  -2.296785026794981e-22,
  -3.278905634463181e-24,  -2.409964066101278e-26,   1.867929817409997e+00,  -2.838575345569528e-03,  -4.152108004363372e-05,  -4.618474118836082e-07,  -3.533513967231101e-09,
  -5.175575035712710e-12,   3.965130443428296e-13,   8.199053541027997e-15,   9.329500577523670e-17,   4.407797072003717e-19,  -7.533748530070505e-21,  -2.300479463724860e-22,
  -3.276483550593188e-24,  -2.394736031210767e-26,   1.867921747493477e+00,  -2.838844425942893e-03,  -4.152519248779525e-05,  -4.618572776469692e-07,  -3.532355212259592e-09,
  -5.142110025647553e-12,   3.970194740973108e-13,   8.202096322830025e-15,   9.322837079670995e-17,   4.383145112022473e-19,  -7.575676275380137e-21,  -2.304058361042219e-22,
  -3.274115012294626e-24,  -2.379932206085865e-26,   1.867915246280402e+00,  -2.839061194963131e-03,  -4.152850509137227e-05,  -4.618652096165890e-07,  -3.531421376943191e-09,
  -5.115148053941281e-12,   3.974273591539227e-13,   8.204543366338343e-15,   9.317460174132222e-17,   4.363276579114356e-19,  -7.609445279987039e-21,  -2.306936025926319e-22,
  -3.272194610072655e-24,  -2.367991615618523e-26,   1.867910950299989e+00,  -2.839204432740570e-03,  -4.153069384019522e-05,  -4.618704432033432e-07,  -3.530804140238368e-09,
  -5.097330598315844e-12,   3.976968391270841e-13,   8.206158281015076e-15,   9.313902864173452e-17,   4.350143289483569e-19,  -7.631755580909328e-21,  -2.308834866299085e-22,
  -3.270919601353982e-24,  -2.360094236820617e-26,   1.867908744079229e+00,  -2.839277992400162e-03,  -4.153181781776710e-05,  -4.618731285137671e-07,  -3.530487105551876e-09,
  -5.088180029520854e-12,   3.978352166177336e-13,   8.206986983479705e-15,   9.312074671189838e-17,   4.343397320867718e-19,  -7.643211854795774e-21,  -2.309809185810966e-22,
  -3.270262955124244e-24,  -2.356036314641860e-26,   1.867907976179231e+00,  -2.839303595546296e-03,  -4.153220902054489e-05,  -4.618740627806625e-07,  -3.530376750112731e-09,
  -5.084995018192143e-12,   3.978833780414019e-13,   8.207275320099331e-15,   9.311438137905378e-17,   4.341049102554857e-19,  -7.647199135208045e-21,  -2.310148175126690e-22,
  -3.270034105966320e-24,  -2.354623561154331e-26,   1.867907854323855e+00,  -2.839307658414540e-03,  -4.153227109866251e-05,  -4.618742110179123e-07,  -3.530359237815490e-09,
  -5.084489597338510e-12,   3.978910204949547e-13,   8.207321070361379e-15,   9.311337118681745e-17,   4.340676462103934e-19,  -7.647831853116122e-21,  -2.310201961818451e-22,
  -3.269997776637078e-24,  -2.354399359710783e-26,   1.973996427671058e+00,  -6.068030174572569e-04,  -1.043535763205207e-05,  -1.557683732262211e-07,  -2.112555637725479e-09,
  -2.638492041971969e-11,  -3.025641615299627e-13,  -3.121533987503404e-15,  -2.737881644402973e-17,  -1.672035067970941e-19,   2.512101972665447e-22,   3.112795189763404e-23,
   6.805868465044068e-25,   1.091764405989443e-26,   1.973995446967843e+00,  -6.068469145476640e-04,  -1.043654834921540e-05,  -1.557931607941939e-07,  -2.112981967326201e-09,
  -2.639107482611472e-11,  -3.026360056334499e-13,  -3.122094019714380e-15,  -2.737761908522757e-17,  -1.670398567724445e-19,   2.554796379151530e-22,   3.120868738211427e-23,
   6.818437318361293e-25,   1.093395117528296e-26,   1.973993716410523e+00,  -6.069243773322985e-04,  -1.043864958358082e-05,  -1.558369035420654e-07,  -2.113734314753257e-09,
  -2.640193526745615e-11,  -3.027627730472716e-13,  -3.123081754021202e-15,  -2.737549163183722e-17,  -1.667507543547794e-19,   2.630194685007104e-22,   3.135124345381605e-23,
   6.840626627151022e-25,   1.096273201383113e-26,   1.973991623646832e+00,  -6.070180558414021e-04,  -1.044119075148227e-05,  -1.558898057446927e-07,  -2.114644201353534e-09,
  -2.641506935376125e-11,  -3.029160570406794e-13,  -3.124275362687979e-15,  -2.737289402145758e-17,  -1.664005896815471e-19,   2.721475184959707e-22,   3.152378926582601e-23,
   6.867477556499553e-25,   1.099754546754203e-26,   1.973989591865433e+00,  -6.071090074565926e-04,  -1.044365802189012e-05,  -1.559411706701324e-07,  -2.115527650174467e-09,
  -2.642782129330473e-11,  -3.030648577296252e-13,  -3.125433289947800e-15,  -2.737034603312634e-17,  -1.660600492610323e-19,   2.810201926633658e-22,   3.169146708408156e-23,
   6.893564261300060e-25,   1.103135362156224e-26,   1.973987954972226e+00,  -6.071822841610630e-04,  -1.044564587263725e-05,  -1.559825555928189e-07,  -2.116239450135161e-09,
  -2.643809523298798e-11,  -3.031847262007543e-13,  -3.126365522035383e-15,  -2.736827456883142e-17,  -1.657852794367643e-19,   2.881760187392831e-22,   3.182667036900130e-23,
   6.914593902159453e-25,   1.105859749975439e-26,   1.973986873285292e+00,  -6.072307076599310e-04,  -1.044695953131322e-05,  -1.560099049537135e-07,  -2.116709846317910e-09,
  -2.644488462878068e-11,  -3.032639314644483e-13,  -3.126981240638984e-15,  -2.736689655310884e-17,  -1.656035033966557e-19,   2.929084359496704e-22,   3.191607111989838e-23,
   6.928497026763110e-25,   1.107660390539899e-26,   1.973986317769647e+00,  -6.072555765439603e-04,  -1.044763419572850e-05,  -1.560239510687905e-07,  -2.116951433176299e-09,
  -2.644837148136487e-11,  -3.033046066339079e-13,  -3.127297353800298e-15,  -2.736618602078550e-17,  -1.655100867977311e-19,   2.953399881764836e-22,   3.196200149709162e-23,
   6.935639145667072e-25,   1.108585233323937e-26,   1.973986124414530e+00,  -6.072642325619761e-04,  -1.044786902487923e-05,  -1.560288400925924e-07,  -2.117035522227771e-09,
  -2.644958513987428e-11,  -3.033187639156748e-13,  -3.127407365898254e-15,  -2.736593825883082e-17,  -1.654775618009581e-19,   2.961865079697093e-22,   3.197799098088036e-23,
   6.938125375630061e-25,   1.108907153634161e-26,   1.973986093731602e+00,  -6.072656061611394e-04,  -1.044790628931724e-05,  -1.560296159202121e-07,  -2.117048866122396e-09,
  -2.644977773207208e-11,  -3.033210104773489e-13,  -3.127424822639192e-15,  -2.736589892083397e-17,  -1.654724000336870e-19,   2.963208482969665e-22,   3.198052843395139e-23,
   6.938519922702559e-25,   1.108958238917606e-26,   4.529840425647853e-03,  -6.853655669277126e-05,   7.761331555767852e-07,  -7.797161911494453e-09,   7.318360009504358e-11,
  -6.574653682924581e-13,   5.711894353662975e-15,  -4.844609264933889e-17,   4.009192107943399e-19,  -3.273386003562076e-21,   2.593017594614500e-23,  -2.077872169977992e-25,
   1.522710020080012e-27,  -1.283739465062407e-29,   4.529913270718576e-03,  -6.853875181433302e-05,   7.761743666881284e-07,  -7.797779087641204e-09,   7.319164490679819e-11,
  -6.575609225865492e-13,   5.712949031006932e-15,  -4.845716834461546e-17,   4.010289076963483e-19,  -3.274461065849116e-21,   2.593963128167321e-23,  -2.078812906123340e-25,
   1.523432995531825e-27,  -1.284105516570104e-29,   4.530041810140283e-03,  -6.854262528218201e-05,   7.762470880254649e-07,  -7.798868177562804e-09,   7.320584131060307e-11,
  -6.577295473858472e-13,   5.714810260092929e-15,  -4.847671453600930e-17,   4.012225020686503e-19,  -3.276358424761052e-21,   2.595631902097395e-23,  -2.080473064740705e-25,
   1.524709949590262e-27,  -1.284749374565475e-29,   4.530197246750961e-03,  -6.854730936186598e-05,   7.763350297238628e-07,  -7.800185241044849e-09,   7.322300981182551e-11,
  -6.579334805533402e-13,   5.717061277774156e-15,  -4.850035503506530e-17,   4.014566538128275e-19,  -3.278653404306745e-21,   2.597650424324278e-23,  -2.082480911853234e-25,
   1.526256192973726e-27,  -1.285524449917422e-29,   4.530348147544169e-03,  -6.855185683770328e-05,   7.764204085795549e-07,  -7.801463953665584e-09,   7.323967885104170e-11,
  -6.581314870328273e-13,   5.719246945275383e-15,  -4.852331009649228e-17,   4.016840222571228e-19,  -3.280882035432158e-21,   2.599610623671912e-23,  -2.084430476841464e-25,
   1.527759498640806e-27,  -1.286273234926621e-29,   4.530469715289266e-03,  -6.855552040592777e-05,   7.764891933882651e-07,  -7.802494161213726e-09,   7.325310875677973e-11,
  -6.582910211868788e-13,   5.721007990489006e-15,  -4.854180617505045e-17,   4.018672288723312e-19,  -3.282677896661367e-21,   2.601190202972856e-23,  -2.086001293832365e-25,
   1.528972147768204e-27,  -1.286873838017609e-29,   4.530550047062113e-03,  -6.855794131508912e-05,   7.765346474722000e-07,  -7.803174949689792e-09,   7.326198375555215e-11,
  -6.583964496340840e-13,   5.722171804649916e-15,  -4.855402990512698e-17,   4.019883088887090e-19,  -3.283864817042016e-21,   2.602234190235350e-23,  -2.087039394981207e-25,
   1.529774231328277e-27,  -1.287269429948270e-29,   4.530591301881246e-03,  -6.855918459516331e-05,   7.765579910329052e-07,  -7.803524581274706e-09,   7.326654172598384e-11,
  -6.584505956255694e-13,   5.722769524328170e-15,  -4.856030794785886e-17,   4.020504955642952e-19,  -3.284474433925578e-21,   2.602770398625093e-23,  -2.087572550741612e-25,
   1.530186382981578e-27,  -1.287472191015572e-29,   4.530605661095966e-03,  -6.855961733453833e-05,   7.765661160866081e-07,  -7.803646275998912e-09,   7.326812820657311e-11,
  -6.584694421813201e-13,   5.722977573367216e-15,  -4.856249316926476e-17,   4.020721412082480e-19,  -3.284686628840113e-21,   2.602957042168289e-23,  -2.087758127031813e-25,
   1.530329874891899e-27,  -1.287542701109529e-29,   4.530607939710195e-03,  -6.855968600452432e-05,   7.765674054261248e-07,  -7.803665587382416e-09,   7.326837996096118e-11,
  -6.584724328961536e-13,   5.723010588227713e-15,  -4.856283993813334e-17,   4.020755761214051e-19,  -3.284720301828672e-21,   2.602986660464733e-23,  -2.087787575743880e-25,
   1.530352646921771e-27,  -1.287553887111775e-29,   4.071488951016044e-02,  -6.091974034444719e-04,   6.728709583213314e-06,  -6.464939465391478e-08,   5.649038245744865e-10,
  -4.554015646815709e-12,   3.366654922023614e-14,  -2.241514033808431e-16,   1.250180735324985e-18,  -4.763509073733440e-21,  -1.151391066034707e-23,   4.351947688234114e-25,
  -6.925944013373505e-27,   5.935370198435591e-29,   4.071552096387104e-02,  -6.092156011031246e-04,   6.729027608469488e-06,  -6.465366774792722e-08,   5.649512068619773e-10,
  -4.554457198677258e-12,   3.366982990215501e-14,  -2.241674211842639e-16,   1.250130773758902e-18,  -4.761248041724211e-21,  -1.155701938483681e-23,   4.356326982965763e-25,
  -6.931445418788631e-27,   5.942416079893055e-29,   4.071663519816562e-02,  -6.092477121363032e-04,   6.729588790723326e-06,  -6.466120802627450e-08,   5.650348174052730e-10,
  -4.555236349504111e-12,   3.367561860963216e-14,  -2.241956786342351e-16,   1.250042467707816e-18,  -4.757256575272417e-21,  -1.163311301940966e-23,   4.364058537357382e-25,
  -6.941146981081727e-27,   5.954871640632369e-29,   4.071798258359470e-02,  -6.092865428086934e-04,   6.730267415278735e-06,  -6.467032638559935e-08,   5.651359265643073e-10,
  -4.556178550687663e-12,   3.368261819325650e-14,  -2.242298372421423e-16,   1.249935434530832e-18,  -4.752426912989452e-21,  -1.172517331630810e-23,   4.373414820231222e-25,
  -6.952868392110959e-27,   5.969972210688115e-29,   4.071929064541698e-02,  -6.093242407000540e-04,   6.730926250974809e-06,  -6.467917893228993e-08,   5.652340882842064e-10,
  -4.557093269018615e-12,   3.368941307564338e-14,  -2.242629867201446e-16,   1.249831264017988e-18,  -4.747735072387399e-21,  -1.181459311535310e-23,   4.382505294287352e-25,
  -6.964237036415034e-27,   5.984672565269589e-29,   4.072034443408682e-02,  -6.093546108826988e-04,   6.731457028191063e-06,  -6.468631085962236e-08,   5.653131708886202e-10,
  -4.557830186971104e-12,   3.369488680660274e-14,  -2.242896835471012e-16,   1.249747155994793e-18,  -4.743953029632085e-21,  -1.188666381673636e-23,   4.389833884642185e-25,
  -6.973388080093480e-27,   5.996544316101110e-29,   4.072104077408373e-02,  -6.093746795712091e-04,   6.731807769906444e-06,  -6.469102372111027e-08,   5.653654296147098e-10,
  -4.558317145264446e-12,   3.369850368289880e-14,  -2.243073204353845e-16,   1.249691486048434e-18,  -4.741452768669442e-21,  -1.193430411624270e-23,   4.394679145065992e-25,
  -6.979431305431630e-27,   6.004403310291949e-29,   4.072139838269673e-02,  -6.093849859925425e-04,   6.731987896761463e-06,  -6.469344406622809e-08,   5.653922676977673e-10,
  -4.558567226607573e-12,   3.370036110101198e-14,  -2.243163766152237e-16,   1.249662868143529e-18,  -4.740168407902402e-21,  -1.195877502702943e-23,   4.397168241009089e-25,
  -6.982533670074263e-27,   6.008443716186172e-29,   4.072152285239856e-02,  -6.093885732670451e-04,   6.732050592231845e-06,  -6.469428649989784e-08,   5.654016090540457e-10,
  -4.558654270498720e-12,   3.370100758906305e-14,  -2.243195285095000e-16,   1.249652902846348e-18,  -4.739721317511672e-21,  -1.196729320122405e-23,   4.398034724714055e-25,
  -6.983613298006115e-27,   6.009850722517917e-29,   4.072154260406158e-02,  -6.093891425195364e-04,   6.732060541171295e-06,  -6.469442018301213e-08,   5.654030914041282e-10,
  -4.558668083202935e-12,   3.370111017765492e-14,  -2.243200286625953e-16,   1.249651321273811e-18,  -4.739650367724408e-21,  -1.196864495848485e-23,   4.398172229968119e-25,
  -6.983784611614940e-27,   6.010074028559813e-29,   1.127843144130885e-01,  -1.649090975049699e-03,   1.727141955604574e-05,  -1.500100470182156e-07,   1.092513339000681e-09,
  -6.219247600699231e-12,   1.825567103585747e-14,   1.516100636949442e-16,  -3.494525491752200e-18,   3.985258980276421e-20,  -3.391057172279423e-22,   1.879476934568805e-24,
  -4.764401233779784e-27,  -1.295602718656107e-28,   1.127859348394392e-01,  -1.649133185820287e-03,   1.727203423782962e-05,  -1.500158750216936e-07,   1.092538902111484e-09,
  -6.218946974975492e-12,   1.824646835667725e-14,   1.517448174293110e-16,  -3.495957012246378e-18,   3.986224362778599e-20,  -3.391344756948404e-22,   1.878521831965569e-24,
  -4.748889808859573e-27,  -1.297004869097658e-28,   1.127887941541381e-01,  -1.649207668722337e-03,   1.727311886518836e-05,  -1.500261583958753e-07,   1.092583998090393e-09,
  -6.218416300337750e-12,   1.823022702863009e-14,   1.519826189787212e-16,  -3.498483050718440e-18,   3.987927394247866e-20,  -3.391851420337084e-22,   1.876835711871886e-24,
  -4.721483547286654e-27,  -1.299473723589085e-28,   1.127922517480104e-01,  -1.649297736516675e-03,   1.727443042809342e-05,  -1.500385927701428e-07,   1.092638510669164e-09,
  -6.217774234877600e-12,   1.821058263058389e-14,   1.522702162709475e-16,  -3.501537730410040e-18,   3.989986033878555e-20,  -3.392462744605037e-22,   1.874795430282081e-24,
  -4.688282005433414e-27,  -1.302450124086474e-28,   1.127956084040545e-01,  -1.649385175152952e-03,   1.727570369150829e-05,  -1.500506634351512e-07,   1.092691411725644e-09,
  -6.217150543420903e-12,   1.819150673228887e-14,   1.525494579813343e-16,  -3.504503335203992e-18,   3.991983808789598e-20,  -3.393054804351881e-22,   1.872813289395859e-24,
  -4.655985980932772e-27,  -1.305330183918771e-28,   1.127983125425299e-01,  -1.649455616286928e-03,   1.727672943089330e-05,  -1.500603871118382e-07,   1.092734014648364e-09,
  -6.216647829514275e-12,   1.817613552684292e-14,   1.527744453105412e-16,  -3.506892512812874e-18,   3.993592676476312e-20,  -3.393530753424352e-22,   1.871215450545039e-24,
  -4.629922452455929e-27,  -1.307643609919048e-28,   1.128000994184489e-01,  -1.649502163368543e-03,   1.727740722851812e-05,  -1.500668122001475e-07,   1.092762159299514e-09,
  -6.216315509884657e-12,   1.816597659369068e-14,   1.529231294953045e-16,  -3.508471299928608e-18,   3.994655535926578e-20,  -3.393844758801142e-22,   1.870159112818449e-24,
  -4.612677470810476e-27,  -1.309168996593992e-28,   1.128010170738205e-01,  -1.649526067780423e-03,   1.727775531229098e-05,  -1.500701117458740e-07,   1.092776610882872e-09,
  -6.216144806028813e-12,   1.816075890336607e-14,   1.529994910609491e-16,  -3.509282101540307e-18,   3.995201287265060e-20,  -3.394005862935169e-22,   1.869616473971559e-24,
  -4.603814335534489e-27,  -1.309951340608905e-28,   1.128013364736231e-01,  -1.649534387971006e-03,   1.727787646639572e-05,  -1.500712601758873e-07,   1.092781640563748e-09,
  -6.216085384329711e-12,   1.815894274420808e-14,   1.530260702186253e-16,  -3.509564311471689e-18,   3.995391228621579e-20,  -3.394061912393430e-22,   1.869427578272272e-24,
  -4.600728323603165e-27,  -1.310223481065524e-28,   1.128013871580416e-01,  -1.649535708272615e-03,   1.727789569190067e-05,  -1.500714424155772e-07,   1.092782438689402e-09,
  -6.216075954608314e-12,   1.815865454028750e-14,   1.530302880036055e-16,  -3.509609094443785e-18,   3.995421369110493e-20,  -3.394070805516236e-22,   1.869397601926517e-24,
  -4.600238563001388e-27,  -1.310266658340117e-28,   2.200643964987026e-01,  -3.101900662268973e-03,   2.971807817384891e-05,  -2.130059649080586e-07,   9.585576455117622e-10,
   1.433269886633773e-12,  -8.678771169766794e-14,   1.055140177314168e-15,  -7.595263279913077e-18,   1.687701822682030e-20,   4.035678507630076e-22,  -7.627490814289439e-24,
   6.819302772149185e-26,  -3.947053213660076e-28,   2.200671836440548e-01,  -3.101960565280851e-03,   2.971861667110916e-05,  -2.130046037463748e-07,   9.584353652268191e-10,
   1.435348077136046e-12,  -8.680761374139509e-14,   1.055196108589267e-15,  -7.593547192417620e-18,   1.683757849430419e-20,   4.039890454673849e-22,  -7.630338362239698e-24,
   6.817687966622742e-26,  -3.940059945864687e-28,   2.200721016469110e-01,  -3.102066264775005e-03,   2.971956680203473e-05,  -2.130022003708833e-07,   9.582195769973414e-10,
   1.439015166042839e-12,  -8.684272754060319e-14,   1.055294691906218e-15,  -7.590517685009437e-18,   1.676797456751706e-20,   4.047321688355109e-22,  -7.635358724391585e-24,
   6.814837772507376e-26,  -3.927702766058361e-28,   2.200780486184784e-01,  -3.102194077199306e-03,   2.972071561507543e-05,  -2.129992914821725e-07,   9.579586047887680e-10,
   1.443449600887082e-12,  -8.688518126194891e-14,   1.055413715227233e-15,  -7.586851910289588e-18,   1.668378847998450e-20,   4.056306228766564e-22,  -7.641422263898808e-24,
   6.811389853774258e-26,  -3.912730600849016e-28,   2.200838219087997e-01,  -3.102318154729531e-03,   2.972183076295104e-05,  -2.129964647544386e-07,   9.577052168840235e-10,
   1.447754632241124e-12,  -8.692638804183431e-14,   1.055529067584300e-15,  -7.583290661714439e-18,   1.660204086645133e-20,   4.065026812514474e-22,  -7.647301161250857e-24,
   6.808041180570579e-26,  -3.898164773526561e-28,   2.200884728488972e-01,  -3.102418109573704e-03,   2.972272903996606e-05,  -2.129941855523779e-07,   9.575010617944089e-10,
   1.451222823165619e-12,  -8.695957898721885e-14,   1.055621855336323e-15,  -7.580419919266221e-18,   1.653617086098289e-20,   4.072050960365299e-22,  -7.652031757421056e-24,
   6.805342468481162e-26,  -3.886408461601133e-28,   2.200915461329619e-01,  -3.102484157757879e-03,   2.972332257034994e-05,  -2.129926785037886e-07,   9.573661455064797e-10,
   1.453514597548588e-12,  -8.698150867034467e-14,   1.055683099956279e-15,  -7.578522079570352e-18,   1.649263770121072e-20,   4.076691882326134e-22,  -7.655155020660243e-24,
   6.803558688611549e-26,  -3.878629203102596e-28,   2.200931244193287e-01,  -3.102518076600040e-03,   2.972362736575661e-05,  -2.129919042552943e-07,   9.572968551329936e-10,
   1.454691550538403e-12,  -8.699276989975327e-14,   1.055714531006802e-15,  -7.577547168452567e-18,   1.647027904270984e-20,   4.079075060128156e-22,  -7.656758151741389e-24,
   6.802642472263869e-26,  -3.874630813217404e-28,   2.200936737576176e-01,  -3.102529882354007e-03,   2.972373345086257e-05,  -2.129916347221508e-07,   9.572727372828365e-10,
   1.455101202540058e-12,  -8.699668936038265e-14,   1.055725467529622e-15,  -7.577207797194589e-18,   1.646249654110707e-20,   4.079904521881040e-22,  -7.657316006551022e-24,
   6.802323549337820e-26,  -3.873238600884966e-28,   2.200937609300985e-01,  -3.102531755764111e-03,   2.972375028502589e-05,  -2.129915919486332e-07,   9.572689100788891e-10,
   1.455166208800737e-12,  -8.699731131942135e-14,   1.055727202846507e-15,  -7.577153941536578e-18,   1.646126154792312e-20,   4.080036144845799e-22,  -7.657404524270784e-24,
   6.802272939455062e-26,  -3.873017650513308e-28,   3.613483213433191e-01,  -4.829714122895896e-03,   4.019790948441783e-05,  -1.937340737336239e-07,  -3.488304815567643e-10,
   1.792607096912136e-11,  -1.848082602021162e-13,   6.916503801839772e-16,   8.275825330065808e-18,  -1.739123250436723e-19,   1.404540477946839e-21,  -1.168647669134715e-24,
  -1.416982533192723e-25,   1.848546811950238e-27,   3.613520894930741e-01,  -4.829768551259770e-03,   4.019771180228990e-05,  -1.937172567141149e-07,  -3.490901091280692e-10,
   1.792742331433365e-11,  -1.847864144991941e-13,   6.910632859241385e-16,   8.281722364508696e-18,  -1.739178258740414e-19,   1.403659180736423e-21,  -1.155151503722794e-24,
  -1.417966050611827e-25,   1.848160723300480e-27,   3.613587384374548e-01,  -4.829864587118224e-03,   4.019736287038953e-05,  -1.936875817903151e-07,  -3.495482010451963e-10,
   1.792980860899921e-11,  -1.847478548442842e-13,   6.900273341433312e-16,   8.292124748003398e-18,  -1.739274756211445e-19,   1.402103625837014e-21,  -1.131339602854792e-24,
  -1.419699068762414e-25,   1.847479438796302e-27,   3.613667783862183e-01,  -4.829980708146715e-03,   4.019694073586320e-05,  -1.936516968025159e-07,  -3.501020880203520e-10,
   1.793269133045056e-11,  -1.847012066717708e-13,   6.887746251829153e-16,   8.304698259599074e-18,  -1.739390477746976e-19,   1.400221793980567e-21,  -1.102549911723801e-24,
  -1.421790535547449e-25,   1.846655578424772e-27,   3.613745834022581e-01,  -4.830093429563821e-03,   4.019653072308925e-05,  -1.936168584425554e-07,  -3.506397472166290e-10,
   1.793548814855663e-11,  -1.846558990021262e-13,   6.875584909659154e-16,   8.316899000288971e-18,  -1.739501808554490e-19,   1.398394067442321e-21,  -1.074605476577059e-24,
  -1.423816581769500e-25,   1.845855741520817e-27,   3.613808710022959e-01,  -4.830184231551044e-03,   4.019620027032411e-05,  -1.935887917985062e-07,  -3.510728464432034e-10,
   1.793774002657189e-11,  -1.846193836647227e-13,   6.865787704917413e-16,   8.326723883395781e-18,  -1.739590771849362e-19,   1.396921047274822e-21,  -1.052096739794933e-24,
  -1.425445646255305e-25,   1.845211368150281e-27,   3.613850257268993e-01,  -4.830244229477363e-03,   4.019598183869804e-05,  -1.935702452167555e-07,  -3.513590150105145e-10,
   1.793922743877505e-11,  -1.845952471145750e-13,   6.859313796044201e-16,   8.333214093444534e-18,  -1.739649203059432e-19,   1.395947394881596e-21,  -1.037224805467739e-24,
  -1.426520588566894e-25,   1.844785560036842e-27,   3.613871593738435e-01,  -4.830275040538227e-03,   4.019586964062117e-05,  -1.935607204606802e-07,  -3.515059714106256e-10,
   1.793999111405748e-11,  -1.845828494089880e-13,   6.855989106163476e-16,   8.336546539884444e-18,  -1.739679100762454e-19,   1.395447282940643e-21,  -1.029587800306223e-24,
  -1.427072154393436e-25,   1.844566881635166e-27,   3.613879020087343e-01,  -4.830285764491498e-03,   4.019583058539380e-05,  -1.935574052504373e-07,  -3.515571201589788e-10,
   1.794025688924972e-11,  -1.845785338868455e-13,   6.854831912968043e-16,   8.337706334931892e-18,  -1.739689489496637e-19,   1.395273199305285e-21,  -1.026929741521680e-24,
  -1.427264057336615e-25,   1.844490767720866e-27,   3.613880198546416e-01,  -4.830287466229558e-03,   4.019582438769338e-05,  -1.935568791707264e-07,  -3.515652367242359e-10,
   1.794029906273647e-11,  -1.845778490545359e-13,   6.854648282134625e-16,   8.337890373996248e-18,  -1.739691137217982e-19,   1.395245573913409e-21,  -1.026507947561078e-24,
  -1.427294506149341e-25,   1.844478689448309e-27,   5.346149975363147e-01,  -6.634007382651471e-03,   4.404248748505588e-05,  -4.761775552610629e-08,  -2.577448835036551e-09,
   2.854079252472191e-11,  -5.023676765698203e-14,  -2.323353173886272e-15,   2.989990368793511e-17,  -7.251542534840250e-20,  -2.640617772657143e-21,   3.730917717593125e-23,
  -1.222745071265232e-25,  -3.425999723970809e-27,   5.346191236002088e-01,  -6.634020681016315e-03,   4.404103727988612e-05,  -4.759103707915921e-08,  -2.577518555257339e-09,
   2.853621462971037e-11,  -5.015851119639019e-14,  -2.323592927536336e-15,   2.988874002736342e-17,  -7.232402873780029e-20,  -2.641354159623623e-21,   3.728404272757402e-23,
  -1.218385677717455e-25,  -3.427499822633584e-27,   5.346264039943902e-01,  -6.634044140087970e-03,   4.403847833834498e-05,  -4.754389544887908e-08,  -2.577641488306839e-09,
   2.852813648052723e-11,  -5.002045027748299e-14,  -2.324015452179090e-15,   2.986903906439957e-17,  -7.198641185028060e-20,  -2.642651335536558e-21,   3.723968383079373e-23,
  -1.210695703192867e-25,  -3.430135521953431e-27,   5.346352073364610e-01,  -6.634072496643661e-03,   4.403538398486044e-05,  -4.748689723625206e-08,  -2.577789987887413e-09,
   2.851836764644878e-11,  -4.985354618677676e-14,  -2.324525479468310e-15,   2.984521217783187e-17,  -7.157834171639256e-20,  -2.644216160342767e-21,   3.718602967568672e-23,
  -1.201400729983306e-25,  -3.433303468071687e-27,   5.346437532713065e-01,  -6.634100013802380e-03,   4.403237998351458e-05,  -4.743157058951452e-08,  -2.577933989166498e-09,
   2.850888355171769e-11,  -4.969156115498824e-14,  -2.325019669172655e-15,   2.982207698211687e-17,  -7.118238262506262e-20,  -2.645731355780234e-21,   3.713392760253864e-23,
  -1.192381337586891e-25,  -3.436358793499251e-27,   5.346506376239536e-01,  -6.634122173462086e-03,   4.402995995860503e-05,  -4.738700462736892e-08,  -2.578049880428927e-09,
   2.850124280184507e-11,  -4.956109862466866e-14,  -2.325417111538489e-15,   2.980343637356902e-17,  -7.086353809105715e-20,  -2.646949177146128e-21,   3.709194375088675e-23,
  -1.185118303147395e-25,  -3.438805758494329e-27,   5.346551866123445e-01,  -6.634136812348874e-03,   4.402836082944036e-05,  -4.735755841973087e-08,  -2.578126403355369e-09,
   2.849619369245160e-11,  -4.947490624598252e-14,  -2.325679406183725e-15,   2.979111742865466e-17,  -7.065291739230418e-20,  -2.647752520953131e-21,   3.706419615180371e-23,
  -1.180320424986551e-25,  -3.440415639227018e-27,   5.346575227141441e-01,  -6.634144328935867e-03,   4.402753959397276e-05,  -4.734243705928730e-08,  -2.578165684236354e-09,
   2.849360065962995e-11,  -4.943064695513420e-14,  -2.325814005553970e-15,   2.978479057807102e-17,  -7.054477402630434e-20,  -2.648164652546274e-21,   3.704994476002144e-23,
  -1.177856919679058e-25,  -3.441240216634313e-27,   5.346583358123619e-01,  -6.634146944964662e-03,   4.402725375447254e-05,  -4.733717403894953e-08,  -2.578179353552135e-09,
   2.849269811910366e-11,  -4.941524283913740e-14,  -2.325860837942952e-15,   2.978258838293809e-17,  -7.050713699176893e-20,  -2.648308031242861e-21,   3.704498416673448e-23,
  -1.176999543301244e-25,  -3.441526872414855e-27,   5.346584648396892e-01,  -6.634147360083471e-03,   4.402720839563421e-05,  -4.733633887521560e-08,  -2.578181522553527e-09,
   2.849255489779648e-11,  -4.941279845299474e-14,  -2.325868268831220e-15,   2.978223892125215e-17,  -7.050116466723213e-20,  -2.648330780264042e-21,   3.704419697628307e-23,
  -1.176863492763439e-25,  -3.441572344317926e-27,   7.365704130740566e-01,  -8.247391524874775e-03,   3.669332741995235e-05,   2.175515536158462e-07,  -4.251395814618556e-09,
   9.883017240786241e-12,   3.683153860151952e-13,  -3.996281065960139e-15,  -1.222317713798196e-17,   5.963186413086563e-19,  -3.456247475203086e-21,  -5.126485741956004e-23,
   8.901049755488668e-25,  -9.696942663452069e-28,   7.365738482720842e-01,  -8.247330306231227e-03,   3.669093893572756e-05,   2.175607530766597e-07,  -4.250878255540202e-09,
   9.875181465212282e-12,   3.682830032523891e-13,  -3.994275392520052e-15,  -1.223758285648528e-17,   5.960540608175003e-19,  -3.450788051469830e-21,  -5.127129649385601e-23,
   8.890660550296577e-25,  -9.578552119457455e-28,   7.365799095514373e-01,  -8.247222282877898e-03,   3.668672465427102e-05,   2.175769797076977e-07,  -4.249965051529969e-09,
   9.861358322616053e-12,   3.682258327195829e-13,  -3.990737076286883e-15,  -1.226298329099475e-17,   5.955871780452152e-19,  -3.441160030219336e-21,  -5.128258820724896e-23,
   8.872336123437487e-25,  -9.369835268522217e-28,   7.365872386055496e-01,  -8.247091656315831e-03,   3.668162910340242e-05,   2.175965909587954e-07,  -4.248860858809676e-09,
   9.844648697743261e-12,   3.681566492867059e-13,  -3.986459744609345e-15,  -1.229366592496791e-17,   5.950225737088985e-19,  -3.429526618270748e-21,  -5.129612275780814e-23,
   8.850190809827281e-25,  -9.117768097514912e-28,   7.365943532001767e-01,  -8.246964842574228e-03,   3.667668285313569e-05,   2.176156185798309e-07,  -4.247788993975210e-09,
   9.828433006973499e-12,   3.680894325646575e-13,  -3.982308681662898e-15,  -1.232341876503771e-17,   5.944744190397556e-19,  -3.418242413961990e-21,  -5.130913681155518e-23,
   8.828705917029497e-25,  -8.873395783290483e-28,   7.366000843927833e-01,  -8.246862680396906e-03,   3.667269852081808e-05,   2.176309393604012e-07,  -4.246925561160700e-09,
   9.815373957738906e-12,   3.680352445204816e-13,  -3.978965568391670e-15,  -1.234736339635205e-17,   5.940327995923683e-19,  -3.409158674424232e-21,  -5.131953123112474e-23,
   8.811407572307469e-25,  -8.676769001130056e-28,   7.366038713490236e-01,  -8.246795172140052e-03,   3.667006589314426e-05,   2.176410593272170e-07,  -4.246355043432129e-09,
   9.806746778003861e-12,   3.679994188784713e-13,  -3.976756953604997e-15,  -1.236317389936040e-17,   5.937409691584432e-19,  -3.403159565393692e-21,  -5.132635586800998e-23,
   8.799981840826670e-25,  -8.546957196913263e-28,   7.366058160970791e-01,  -8.246760503014936e-03,   3.666871395868089e-05,   2.176462552603565e-07,  -4.246062062485887e-09,
   9.802316929147632e-12,   3.679810147775950e-13,  -3.975622864921762e-15,  -1.237128973709121e-17,   5.935910952817699e-19,  -3.400079745153935e-21,  -5.132984710264091e-23,
   8.794115637286750e-25,  -8.480328382469861e-28,   7.366064929788497e-01,  -8.246748436043966e-03,   3.666824341280381e-05,   2.176480635687549e-07,  -4.245960088931823e-09,
   9.800775178501966e-12,   3.679746081195390e-13,  -3.975228157367953e-15,  -1.237411395377402e-17,   5.935389295142089e-19,  -3.399007946178508e-21,  -5.133106010328626e-23,
   8.792074083329911e-25,  -8.457143304963614e-28,   7.366066003903987e-01,  -8.246746521178802e-03,   3.666816874399983e-05,   2.176483505136720e-07,  -4.245943907187667e-09,
   9.800530528598860e-12,   3.679735914264136e-13,  -3.975165523778484e-15,  -1.237456209077219e-17,   5.935306514877517e-19,  -3.398837874069017e-21,  -5.133125248746288e-23,
   8.791750127844381e-25,  -8.453464422644130e-28,   9.619302499210689e-01,  -9.334498769350748e-03,   1.553414615334542e-05,   5.000221812871329e-07,  -3.029781912586640e-09,
  -4.104826055600377e-11,   5.220446777665245e-13,   2.993445482583557e-15,  -8.419664228674759e-17,  -4.504061497684783e-20,   1.248669064881122e-20,  -5.385593041503387e-23,
  -1.701682163644958e-24,   1.628991535704754e-26,   9.619317028316196e-01,  -9.334358273751184e-03,   1.553244603214898e-05,   4.999837481440676e-07,  -3.029050387959894e-09,
  -4.104236976856480e-11,   5.218247420089483e-13,   2.993286368478253e-15,  -8.414429998440860e-17,  -4.531376006968123e-20,   1.247623482210738e-20,  -5.373872019271543e-23,
  -1.700098920020126e-24,   1.625520041758111e-26,   9.619342663860918e-01,  -9.334110375831171e-03,   1.552944647543166e-05,   4.999159367465985e-07,  -3.027759852253344e-09,
  -4.103197563946906e-11,   5.214367734008776e-13,   2.993004862991017e-15,  -8.405197696468299e-17,  -4.579523949075122e-20,   1.245779330703684e-20,  -5.353210627632470e-23,
  -1.697306032757407e-24,   1.619402070796431e-26,   9.619373660435251e-01,  -9.333810629980102e-03,   1.552581994861385e-05,   4.998339461326635e-07,  -3.026199750586100e-09,
  -4.101940738825637e-11,   5.209678276726257e-13,   2.992663192225459e-15,  -8.394039999959125e-17,  -4.637661568456033e-20,   1.243550719233745e-20,  -5.328261637911258e-23,
  -1.693930158432403e-24,   1.612016991949883e-26,   9.619403749069206e-01,  -9.333519657564130e-03,   1.552229997512888e-05,   4.997543590772686e-07,  -3.024685678872065e-09,
  -4.100720681011922e-11,   5.205127822371584e-13,   2.992330174013786e-15,  -8.383214688562790e-17,  -4.694013316287610e-20,   1.241388641694177e-20,  -5.304078188322512e-23,
  -1.690654295090999e-24,   1.604861114870373e-26,   9.619427986430890e-01,  -9.333285265194880e-03,   1.551946475720722e-05,   4.996902505218311e-07,  -3.023466283285788e-09,
  -4.099737851520344e-11,   5.201463460591035e-13,   2.992060946651747e-15,  -8.374498533229774e-17,  -4.739347092387307e-20,   1.239647917257692e-20,  -5.284622510501026e-23,
  -1.688016288936045e-24,   1.599106046361274e-26,   9.619444001239635e-01,  -9.333130388388651e-03,   1.551759150472562e-05,   4.996478915415334e-07,  -3.022660685492936e-09,
  -4.099088431594079e-11,   5.199042813167349e-13,   2.991882580106581e-15,  -8.368741292298756e-17,  -4.769272283706748e-20,   1.238498175468629e-20,  -5.271779359701272e-23,
  -1.686273624652967e-24,   1.595307902654309e-26,   9.619452225360312e-01,  -9.333050853437648e-03,   1.551662956457773e-05,   4.996261390476899e-07,  -3.022247021053976e-09,
  -4.098754928433477e-11,   5.197799910578827e-13,   2.991790836337939e-15,  -8.365785365968076e-17,  -4.784630854790553e-20,   1.237907882009102e-20,  -5.265187747887285e-23,
  -1.685378832601691e-24,   1.593358827787708e-26,   9.619455087801047e-01,  -9.333023170840163e-03,   1.551629476278924e-05,   4.996185680314037e-07,  -3.022103049090235e-09,
  -4.098638850408054e-11,   5.197367341284844e-13,   2.991758881158311e-15,  -8.364756638951125e-17,  -4.789975042609855e-20,   1.237702449473944e-20,  -5.262894107360897e-23,
  -1.685067415826222e-24,   1.592680665785206e-26,   9.619455542029079e-01,  -9.333018778006037e-03,   1.551624163484483e-05,   4.996173666219592e-07,  -3.022080203089478e-09,
  -4.098620430462241e-11,   5.197298700125213e-13,   2.991753809223400e-15,  -8.364593399373268e-17,  -4.790823020247668e-20,   1.237669851323373e-20,  -5.262530168117471e-23,
  -1.685017999402374e-24,   1.592573061796907e-26,   1.202354761668060e+00,  -9.521688297753052e-03,  -1.704834516918099e-05,   5.957820252930566e-07,   2.078249454909365e-09,
  -6.874105236108175e-11,  -3.043762918683087e-13,   9.708464257524732e-15,   4.855058003793324e-17,  -1.537390686771009e-18,  -8.410933008935018e-21,   2.576288253431024e-22,
   1.468970150043185e-24,  -4.618048056970020e-26,   1.202353165730671e+00,  -9.521520960783502e-03,  -1.704717856295861e-05,   5.957177406146537e-07,   2.077822924027629e-09,
  -6.872202077094927e-11,  -3.042495728530800e-13,   9.703309814189769e-15,   4.851538468992900e-17,  -1.536075228496556e-18,  -8.401952561969019e-21,   2.572956164224886e-22,
   1.466616094631168e-24,  -4.609898959023425e-26,   1.202350349762629e+00,  -9.521225706735144e-03,  -1.704512026260171e-05,   5.956043237670806e-07,   2.077070448156164e-09,
  -6.868844746361165e-11,  -3.040260500908939e-13,   9.694218317670977e-15,   4.845331264995571e-17,  -1.533755473884123e-18,  -8.386118216008602e-21,   2.567081465627039e-22,
   1.462466647817163e-24,  -4.595534143447175e-26,   1.202346944815025e+00,  -9.520868707391212e-03,  -1.704263167571013e-05,   5.954672035864035e-07,   2.076160792753820e-09,
  -6.864786429541675e-11,  -3.037558917019939e-13,   9.683230918346825e-15,   4.837830680339614e-17,  -1.530952774268013e-18,  -8.366991250565786e-21,   2.559985938883098e-22,
   1.457456454914981e-24,  -4.578188575377909e-26,   1.202343639508985e+00,  -9.520522164790898e-03,  -1.704021614612939e-05,   5.953341155310906e-07,   2.075277973052438e-09,
  -6.860848154920988e-11,  -3.034937603080179e-13,   9.672570962880062e-15,   4.830554718738502e-17,  -1.528234444635357e-18,  -8.348444147809360e-21,   2.553106326440681e-22,
   1.452600349784277e-24,  -4.561375442683803e-26,   1.202340976910731e+00,  -9.520243013336692e-03,  -1.703827047585052e-05,   5.952269200366760e-07,   2.074566969797131e-09,
  -6.857676584350736e-11,  -3.032826864165609e-13,   9.663988040092790e-15,   4.824697219849173e-17,  -1.526046371194121e-18,  -8.333517893443124e-21,   2.547570358247606e-22,
   1.448693849497763e-24,  -4.547849352620146e-26,   1.202339217568711e+00,  -9.520058564212210e-03,  -1.703698493346140e-05,   5.951560962260805e-07,   2.074097241981330e-09,
  -6.855581382083146e-11,  -3.031432594150230e-13,   9.658318848316750e-15,   4.820828607830495e-17,  -1.524601401082675e-18,  -8.323662254156622e-21,   2.543915302149897e-22,
   1.446115202059229e-24,  -4.538920529028612e-26,   1.202338314079557e+00,  -9.519963843601143e-03,  -1.703632478361964e-05,   5.951197276128727e-07,   2.073856042246181e-09,
  -6.854505554725368e-11,  -3.030716714686134e-13,   9.655408142927682e-15,   4.818842483676650e-17,  -1.523859608690266e-18,  -8.318603187951760e-21,   2.542039187322962e-22,
   1.444791777311908e-24,  -4.534337924729239e-26,   1.202337999614614e+00,  -9.519930875677140e-03,  -1.703609501842110e-05,   5.951070696300968e-07,   2.073772094922605e-09,
  -6.854131128512805e-11,  -3.030467569348372e-13,   9.654395156023708e-15,   4.818151289399612e-17,  -1.523601463854561e-18,  -8.316842695892701e-21,   2.541386336611332e-22,
   1.444331279963015e-24,  -4.532743348758839e-26,   1.202337949713488e+00,  -9.519925644143104e-03,  -1.703605855813328e-05,   5.951050610037365e-07,   2.073758773849889e-09,
  -6.854071713433017e-11,  -3.030428034509492e-13,   9.654234414211017e-15,   4.818041610869323e-17,  -1.523560501856010e-18,  -8.316563347244586e-21,   2.541282745230990e-22,
   1.444258211677375e-24,  -4.532490332465380e-26,   1.445024897374807e+00,  -8.493721665623968e-03,  -5.018851702920704e-05,   3.103141371238399e-07,   7.087027018739866e-09,
   1.659168916668919e-12,  -1.018773770957637e-12,  -6.469543963209487e-15,   1.300416222500177e-16,   1.934609582872475e-18,  -1.155636392335956e-20,  -4.370980347085049e-22,
  -6.190902502426387e-25,   8.082484064591704e-26,   1.445020200196740e+00,  -8.493634384862205e-03,  -5.018453864622345e-05,   3.103155864691129e-07,   7.085598394299740e-09,
   1.646534830117797e-12,  -1.018433421963108e-12,  -6.463072738464903e-15,   1.299927548210600e-16,   1.932378501046803e-18,  -1.155995080192915e-20,  -4.365135879119001e-22,
  -6.138073764114011e-25,   8.070533150913741e-26,   1.445011912254290e+00,  -8.493480376269683e-03,  -5.017751937913922e-05,   3.103181342637321e-07,   7.083077952681254e-09,
   1.624252114580781e-12,  -1.017832975157161e-12,  -6.451660265594697e-15,   1.299065153837206e-16,   1.928444165300296e-18,  -1.156625350329684e-20,  -4.354830309919116e-22,
  -6.045013161689736e-25,   8.049459136380165e-26,   1.445001890900869e+00,  -8.493294146897935e-03,  -5.016903271844750e-05,   3.103211987243386e-07,   7.080030870397491e-09,
   1.597325221891500e-12,  -1.017107086405309e-12,  -6.437870586403397e-15,   1.298022131816628e-16,   1.923690888363739e-18,  -1.157382983275161e-20,  -4.342380783024317e-22,
  -5.932749864930496e-25,   8.023999343506489e-26,   1.444992162883846e+00,  -8.493113358087896e-03,  -5.016079517953890e-05,   3.103241565246126e-07,   7.077073509478546e-09,
   1.571203487855835e-12,  -1.016402592530807e-12,  -6.424494694648579e-15,   1.297009369652254e-16,   1.919080847180404e-18,  -1.158113778448616e-20,  -4.330307638191264e-22,
  -5.824045335163407e-25,   7.999307650435664e-26,   1.444984326506292e+00,  -8.492967716573960e-03,  -5.015415995948703e-05,   3.103265270248517e-07,   7.074691595024590e-09,
   1.550173355692315e-12,  -1.015835194969337e-12,  -6.413727048797717e-15,   1.296193348530919e-16,   1.915370178466851e-18,  -1.158699133555406e-20,  -4.320590721526229e-22,
  -5.736673795100889e-25,   7.979433714221133e-26,   1.444979148556807e+00,  -8.492871479060908e-03,  -5.014977593266461e-05,   3.103280874057648e-07,   7.073117911721310e-09,
   1.536283478210779e-12,  -1.015460334160590e-12,  -6.406615796976365e-15,   1.295654061576416e-16,   1.912919761832567e-18,  -1.159084280633261e-20,  -4.314174386089905e-22,
  -5.679037757019030e-25,   7.966309879402899e-26,   1.444976489490501e+00,  -8.492822056432921e-03,  -5.014752465141089e-05,   3.103288868798289e-07,   7.072309825294536e-09,
   1.529152358573028e-12,  -1.015267845423299e-12,  -6.402965008912491e-15,   1.295377088856676e-16,   1.911661827770457e-18,  -1.159281563723210e-20,  -4.310880660421635e-22,
  -5.649469026816089e-25,   7.959572794160609e-26,   1.444975563987437e+00,  -8.492804854425072e-03,  -5.014674109245824e-05,   3.103291648486263e-07,   7.072028575392398e-09,
   1.526670624966264e-12,  -1.015200851175402e-12,  -6.401694506521199e-15,   1.295280682297443e-16,   1.911224067449729e-18,  -1.159350149014094e-20,  -4.309734467042017e-22,
  -5.639182154449235e-25,   7.957228309003955e-26,   1.444975417123289e+00,  -8.492802124702882e-03,  -5.014661675339822e-05,   3.103292089444199e-07,   7.071983945475035e-09,
   1.526276823112138e-12,  -1.015190220263781e-12,  -6.401492904205493e-15,   1.295265383730195e-16,   1.911154604483072e-18,  -1.159361028715569e-20,  -4.309552592286823e-22,
  -5.637549997064436e-25,   7.956856291393627e-26,   1.671189641212217e+00,  -6.205928319237012e-03,  -6.497097961021713e-05,  -2.498125084005051e-07,   4.380634029223097e-09,
   8.612895391638722e-11,   3.858164112115281e-13,  -9.517163328504930e-15,  -1.910720064607752e-16,  -7.381055126996238e-19,   2.686545077036554e-20,   5.039906588321375e-22,
   1.320117120913182e-24,  -8.725004778094376e-26,   1.671183555147509e+00,  -6.205998295045282e-03,  -6.496851248239816e-05,  -2.497319205604450e-07,   4.381170682449947e-09,
   8.611017862932545e-11,   3.853171946436622e-13,  -9.519587433788183e-15,  -1.909584268786485e-16,  -7.355316772542242e-19,   2.687304153183522e-20,   5.033518265888853e-22,
   1.307621278268520e-24,  -8.726554325093651e-26,   1.671172816378826e+00,  -6.206121750062161e-03,  -6.496415895245330e-05,  -2.495897363688572e-07,   4.382117045701691e-09,
   8.607704549237931e-11,   3.844365616817126e-13,  -9.523857761731221e-15,  -1.907579883876345e-16,  -7.309927828734658e-19,   2.688637294750373e-20,   5.022245112188411e-22,
   1.285595429141492e-24,  -8.729241674375875e-26,   1.671159831265972e+00,  -6.206271001820370e-03,  -6.495889420150174e-05,  -2.494178301439499e-07,   4.383260426874611e-09,
   8.603697399646577e-11,   3.833721044579550e-13,  -9.529009482395474e-15,  -1.905155726359390e-16,  -7.255088710258571e-19,   2.690238677567577e-20,   5.008612049872865e-22,
   1.259001200831765e-24,  -8.732411450265744e-26,   1.671147225879322e+00,  -6.206415859999081e-03,  -6.495378283697828e-05,  -2.492509721300886e-07,   4.384369384545547e-09,
   8.599806642976747e-11,   3.823391809367852e-13,  -9.533998118011246e-15,  -1.902801943732702e-16,  -7.201899679152883e-19,   2.691782112963384e-20,   4.995375820628549e-22,
   1.233225520442170e-24,  -8.735405166124347e-26,   1.671137071384612e+00,  -6.206532532333046e-03,  -6.494966487636183e-05,  -2.491165718091582e-07,   4.385262017932421e-09,
   8.596671809741859e-11,   3.815073815467139e-13,  -9.538007899289025e-15,  -1.900905444181704e-16,  -7.159085563682732e-19,   2.693017496039946e-20,   4.984711837160896e-22,
   1.212490728360969e-24,  -8.737757154661303e-26,   1.671130361593333e+00,  -6.206609615812317e-03,  -6.494694364873051e-05,  -2.490277714445167e-07,   4.385851497553126e-09,
   8.594600128020543e-11,   3.809578953042933e-13,  -9.540653087151966e-15,  -1.899652113505799e-16,  -7.130811542297172e-19,   2.693829906743559e-20,   4.977664759967330e-22,
   1.198804118961885e-24,  -8.739282103449599e-26,   1.671126915830930e+00,  -6.206649198304564e-03,  -6.494554612095205e-05,  -2.489821709835212e-07,   4.386154113270709e-09,
   8.593536146240395e-11,   3.806757548298330e-13,  -9.542010156045461e-15,  -1.899008419621203e-16,  -7.116296670054276e-19,   2.694245910415792e-20,   4.974045593344287e-22,
   1.191779896655046e-24,  -8.740056213095971e-26,   1.671125716507577e+00,  -6.206662974786310e-03,  -6.494505969110008e-05,  -2.489662997673029e-07,   4.386259423888148e-09,
   8.593165805848250e-11,   3.805775607371211e-13,  -9.542482279560982e-15,  -1.898784368340748e-16,  -7.111245462213249e-19,   2.694390512028172e-20,   4.972785884665304e-22,
   1.189335769198372e-24,  -8.740324212943571e-26,   1.671125526191754e+00,  -6.206665160897305e-03,  -6.494498250102527e-05,  -2.489637812448464e-07,   4.386276134399437e-09,
   8.593107037368832e-11,   3.805619790422162e-13,  -9.542557188772020e-15,  -1.898748814121502e-16,  -7.110443944325915e-19,   2.694413449185743e-20,   4.972585985082100e-22,
   1.188947953891506e-24,  -8.740366672664253e-26,   1.855896499528913e+00,  -3.193163509026101e-03,  -4.739429169133782e-05,  -5.186450591929400e-07,  -3.526091135160294e-09,
   7.335505497026272e-12,   6.684320932819982e-13,   1.135947809414157e-14,   1.012937677370610e-16,  -1.029058362355541e-19,  -2.137248956069725e-20,  -4.110799092209732e-22,
  -4.095174943766339e-24,  -4.141789655487428e-28,   1.855892052351992e+00,  -3.193309352736450e-03,  -4.739626978854076e-05,  -5.186379942010822e-07,  -3.525148035094649e-09,
   7.357862898654529e-12,   6.686961077319261e-13,   1.135907554272411e-14,   1.012028005116652e-16,  -1.050251577871377e-19,  -2.139749182399158e-20,  -4.110735366344767e-22,
  -4.087931606546069e-24,  -2.438159951634486e-28,   1.855884205088100e+00,  -3.193566694613465e-03,  -4.739975974019957e-05,  -5.186255108730667e-07,  -3.523483619064262e-09,
   7.397312214597026e-12,   6.691617707672281e-13,   1.135835941948327e-14,   1.010422019513318e-16,  -1.087646977134712e-19,  -2.144157212007569e-20,  -4.110612791887152e-22,
  -4.075136669625635e-24,   5.679949088329873e-29,   1.855874715836589e+00,  -3.193877872354493e-03,  -4.740397909038772e-05,  -5.186103868473477e-07,  -3.521470476120985e-09,
   7.445013598537326e-12,   6.697245235255990e-13,   1.135748356074559e-14,   1.008478588258946e-16,  -1.132865245591871e-19,  -2.149481204673377e-20,  -4.110447302221420e-22,
  -4.059641123906920e-24,   4.203188063374192e-28,   1.855865503567252e+00,  -3.194179955376958e-03,  -4.740807439098514e-05,  -5.185956742823595e-07,  -3.519515614475473e-09,
   7.491320063543397e-12,   6.702704863787006e-13,   1.135662290960002e-14,   1.006590414911106e-16,  -1.176761642313036e-19,  -2.154643099998230e-20,  -4.110268561053997e-22,
  -4.044573451654507e-24,   7.732286332382651e-28,   1.855858082090706e+00,  -3.194423307421134e-03,  -4.741137295900814e-05,  -5.185838002339581e-07,  -3.517940418502202e-09,
   7.528623074861045e-12,   6.707100576556231e-13,   1.135592214117587e-14,   1.005068235904068e-16,  -1.212123469803531e-19,  -2.158796762256512e-20,  -4.110111610257382e-22,
  -4.032417335377593e-24,   1.057535890059361e-27,   1.855853178017131e+00,  -3.194584109082581e-03,  -4.741355232325698e-05,  -5.185759434018591e-07,  -3.516899368684846e-09,
   7.553271809625281e-12,   6.710003964168752e-13,   1.135545544355768e-14,   1.004061873208276e-16,  -1.235489661064650e-19,  -2.161539128488544e-20,  -4.110001554702262e-22,
  -4.024376085251066e-24,   1.245404584006807e-27,   1.855850659511604e+00,  -3.194666688109776e-03,  -4.741467144734177e-05,  -5.185719052421169e-07,  -3.516364681544994e-09,
   7.565929980669858e-12,   6.711494614903661e-13,   1.135521464558351e-14,   1.003544892757012e-16,  -1.247489231197837e-19,  -2.162946753163592e-20,  -4.109943073561105e-22,
  -4.020243828160783e-24,   1.341885185659325e-27,   1.855849782918060e+00,  -3.194695430445459e-03,  -4.741506095539661e-05,  -5.185704991981929e-07,  -3.516178569517625e-09,
   7.570335751699886e-12,   6.712013389399830e-13,   1.135513065431701e-14,   1.003364926705672e-16,  -1.251665777402917e-19,  -2.163436576501360e-20,  -4.109922406254598e-22,
  -4.018805130078211e-24,   1.375466303292108e-27,   1.855849643814517e+00,  -3.194699991455866e-03,  -4.741512276432762e-05,  -5.185702760534420e-07,  -3.516149035661917e-09,
   7.571034885871932e-12,   6.712095708912327e-13,   1.135511731754656e-14,   1.003336367324812e-16,  -1.252328537093368e-19,  -2.163514299338717e-20,  -4.109919111806549e-22,
  -4.018576808183528e-24,   1.380795171709009e-27,   1.971389543968261e+00,  -6.983801989787498e-04,  -1.252616116850809e-05,  -1.942169624677370e-07,  -2.720483840389477e-09,
  -3.479971175966879e-11,  -4.031051622289687e-13,  -4.088678545703323e-15,  -3.278262904603697e-17,  -1.177765710575109e-19,   2.583532522037570e-21,   8.148742140041296e-23,
   1.516542679028954e-24,   2.243047763310025e-26,   1.971388366564512e+00,  -6.984349375606097e-04,  -1.252769464370819e-05,  -1.942496548698779e-07,  -2.721051720471368e-09,
  -3.480776745007637e-11,  -4.031909841127902e-13,  -4.089064894273152e-15,  -3.277142401433330e-17,  -1.173499557316299e-19,   2.593025472411788e-21,   8.165288067375944e-23,
   1.518901185685034e-24,   2.245653497780255e-26,   1.971386288899782e+00,  -6.985315321380341e-04,  -1.253040074480266e-05,  -1.943073472704859e-07,  -2.722053851851904e-09,
  -3.482198245563029e-11,  -4.033423940803874e-13,  -4.089745437082456e-15,  -3.275161990361657e-17,  -1.165964911814677e-19,   2.609787809388359e-21,   8.194499089228507e-23,
   1.523063901786283e-24,   2.250249955513800e-26,   1.971383776365379e+00,  -6.986483481027888e-04,  -1.253367343447763e-05,  -1.943771200118974e-07,  -2.723265806976025e-09,
  -3.483917243632305e-11,  -4.035254394965542e-13,  -4.090566351392237e-15,  -3.272761685222011e-17,  -1.156842081559592e-19,   2.630077260872872e-21,   8.229847745553570e-23,
   1.528099364388869e-24,   2.255805641524048e-26,   1.971381337031007e+00,  -6.987617643927986e-04,  -1.253685096924174e-05,  -1.944448651503648e-07,  -2.724442527046842e-09,
  -3.485586126374010e-11,  -4.037030936814669e-13,  -4.091361179165914e-15,  -3.270425673173155e-17,  -1.147973374280504e-19,   2.649795124273939e-21,   8.264191223148966e-23,
   1.532989649459042e-24,   2.261196479877163e-26,   1.971379371784864e+00,  -6.988531406640787e-04,  -1.253941108260743e-05,  -1.944994476123842e-07,  -2.725390602814267e-09,
  -3.486930634713079e-11,  -4.038461786322886e-13,  -4.091999975097103e-15,  -3.268539627277235e-17,  -1.140819955011501e-19,   2.665694782531408e-21,   8.291877662137203e-23,
   1.536930590000455e-24,   2.265537450907848e-26,   1.971378073111726e+00,  -6.989135251687720e-04,  -1.254110292281417e-05,  -1.945355185792599e-07,  -2.726017135775140e-09,
  -3.487819100067627e-11,  -4.039407114473924e-13,  -4.092421341732334e-15,  -3.267291311661423e-17,  -1.136088741735037e-19,   2.676208439068878e-21,   8.310182050532763e-23,
   1.539535372829525e-24,   2.268404993435144e-26,   1.971377406158200e+00,  -6.989445369524807e-04,  -1.254197181409311e-05,  -1.945540439368382e-07,  -2.726338909410883e-09,
  -3.488275381341041e-11,  -4.039892538755648e-13,  -4.092637505222453e-15,  -3.266649607638506e-17,  -1.133657688234647e-19,   2.681610007671326e-21,   8.319585223827776e-23,
   1.540873263319763e-24,   2.269877336559658e-26,   1.971377174015299e+00,  -6.989553311188464e-04,  -1.254227424768078e-05,  -1.945604920466699e-07,  -2.726450908693319e-09,
  -3.488434196094809e-11,  -4.040061487643502e-13,  -4.092712706527974e-15,  -3.266426155688132e-17,  -1.132811322991373e-19,   2.683490439741619e-21,   8.322858561016637e-23,
   1.541338961744435e-24,   2.270389754874387e-26,   1.971377137177246e+00,  -6.989570440153577e-04,  -1.254232224010674e-05,  -1.945615152818904e-07,  -2.726468681580414e-09,
  -3.488459397898137e-11,  -4.040088297150093e-13,  -4.092724638212363e-15,  -3.266390692146389e-17,  -1.132677006285273e-19,   2.683788855820124e-21,   8.323378017172859e-23,
   1.541412863255241e-24,   2.270471066504442e-26,   4.267546588288662e-03,  -6.268280242533765e-05,   6.891818378462134e-07,  -6.724406910820910e-09,   6.130232666016038e-11,
  -5.353102164184875e-13,   4.518629550656657e-15,  -3.731865481746049e-17,   2.997231038900208e-19,  -2.399726958893282e-21,   1.818085544842474e-23,  -1.488247177085772e-25,
   9.740653864365172e-28,  -8.116882543558749e-30,   4.267611268253899e-03,  -6.268469543107824e-05,   6.892163562629747e-07,  -6.724909382105432e-09,   6.130869029607387e-11,
  -5.353838165665004e-13,   4.519417910970244e-15,  -3.732677395248000e-17,   2.997999995293646e-19,  -2.400496616387675e-21,   1.818692331561191e-23,  -1.488834522353176e-25,
   9.749434747126158e-28,  -8.105664979798894e-30,   4.267725399707064e-03,  -6.268803578453966e-05,   6.892772674656865e-07,  -6.725796056742309e-09,   6.131991993387095e-11,
  -5.355136981928799e-13,   4.520809149391083e-15,  -3.734110240769547e-17,   2.999357039446991e-19,  -2.401854934746855e-21,   1.819763460636301e-23,  -1.489870233637627e-25,
   9.764952548100430e-28,  -8.085857959676424e-30,   4.267863413176108e-03,  -6.269207517181775e-05,   6.893509269105294e-07,  -6.726868328935309e-09,   6.133350047019336e-11,
  -5.356707746241834e-13,   4.522491729836868e-15,  -3.735843213341018e-17,   3.000998347351638e-19,  -2.403497846400091e-21,   1.821059439854119e-23,  -1.491121486098126e-25,
   9.783757375779284e-28,  -8.061884318210933e-30,   4.267997398971675e-03,  -6.269599674451751e-05,   6.894224394270504e-07,  -6.727909372494804e-09,   6.134668583084999e-11,
  -5.358232849353625e-13,   4.524125443147045e-15,  -3.737525930642244e-17,   3.002592073185026e-19,  -2.405093194682233e-21,   1.822318349377648e-23,  -1.492334985126828e-25,
   9.802055181043623e-28,  -8.038587465343640e-30,   4.268105339560200e-03,  -6.269915605970095e-05,   6.894800527082306e-07,  -6.728748095501569e-09,   6.135730894037422e-11,
  -5.359461619055458e-13,   4.525441751548306e-15,  -3.738881776355617e-17,   3.003876225002545e-19,  -2.406378700227501e-21,   1.823333081106168e-23,  -1.493311707329358e-25,
   9.816826005036198e-28,  -8.019803014192881e-30,   4.268176666430293e-03,  -6.270124375097684e-05,   6.895181243634596e-07,  -6.729302343907102e-09,   6.136432906720093e-11,
  -5.360273649700548e-13,   4.526311647623539e-15,  -3.739777827529224e-17,   3.004724900421625e-19,  -2.407228292925304e-21,   1.824003877427096e-23,  -1.493956688240953e-25,
   9.826601149506831e-28,  -8.007382409844392e-30,   4.268213296701888e-03,  -6.270231590263269e-05,   6.895376765446163e-07,  -6.729586987864661e-09,   6.136793441306059e-11,
  -5.360690691502385e-13,   4.526758412716490e-15,  -3.740238033655506e-17,   3.005160776308296e-19,  -2.407664646894051e-21,   1.824348449988468e-23,  -1.494287786957270e-25,
   9.831625742733062e-28,  -8.001001319505430e-30,   4.268226046284710e-03,  -6.270268907838415e-05,   6.895444819501979e-07,  -6.729686062533177e-09,   6.136918931453839e-11,
  -5.360835850734509e-13,   4.526913918466880e-15,  -3.740398219135658e-17,   3.005312493342915e-19,  -2.407816531444351e-21,   1.824468395409109e-23,  -1.494403008222805e-25,
   9.833375328716810e-28,  -7.998779923148321e-30,   4.268228069471774e-03,  -6.270274829640494e-05,   6.895455618786049e-07,  -6.729701784400835e-09,   6.136938845144155e-11,
  -5.360858885696032e-13,   4.526938595328425e-15,  -3.740423638674943e-17,   3.005336569052600e-19,  -2.407840633789350e-21,   1.824487429749989e-23,  -1.494421291269219e-25,
   9.833652998581317e-28,  -7.998427399199587e-30,   3.838105403929826e-02,  -5.583238910337414e-04,   6.004278532385578e-06,  -5.629772942742162e-08,   4.814177901632668e-10,
  -3.816973489473054e-12,   2.792416699739382e-14,  -1.869462779954128e-16,   1.074201570571750e-18,  -4.929146655742400e-21,   1.267093697986616e-24,   1.645352894727936e-25,
  -4.534755564958754e-27,   3.865624134493195e-29,   3.838161748336721e-02,  -5.583397373550073e-04,   6.004549551223974e-06,  -5.630131093000936e-08,   4.814570917937316e-10,
  -3.817341803443043e-12,   2.792698686002107e-14,  -1.869628913740277e-16,   1.074206014454010e-18,  -4.928286854436454e-21,   1.239048715206249e-24,   1.648272810648848e-25,
  -4.534484826933880e-27,   3.882488887298545e-29,   3.838261170998914e-02,  -5.583676992580689e-04,   6.005027786216211e-06,  -5.630763082857111e-08,   4.815264433639617e-10,
  -3.817991725827426e-12,   2.793196256100028e-14,  -1.869922035747654e-16,   1.074213759576867e-18,  -4.926768487880054e-21,   1.189564461659629e-24,   1.653435095299953e-25,
  -4.533989129230610e-27,   3.912262480946504e-29,   3.838381397473669e-02,  -5.584015124880539e-04,   6.005606103751168e-06,  -5.631527339641417e-08,   4.816103095225720e-10,
  -3.818777664254615e-12,   2.793797924701405e-14,  -1.870276441625111e-16,   1.074222961075820e-18,  -4.924930356494172e-21,   1.129730294807753e-24,   1.659694522348353e-25,
  -4.533359108862180e-27,   3.948291267561201e-29,   3.838498114950269e-02,  -5.584343392504928e-04,   6.006167556524853e-06,  -5.632269317058195e-08,   4.816917310960381e-10,
  -3.819540687147187e-12,   2.794382015741384e-14,  -1.870620450394901e-16,   1.074231722011915e-18,  -4.923143720955336e-21,   1.071647249738383e-24,   1.665789019655140e-25,
  -4.532715476551891e-27,   3.983294686094312e-29,   3.838592143679873e-02,  -5.584607851124721e-04,   6.006619878593866e-06,  -5.632867080356915e-08,   4.817573273826841e-10,
  -3.820155402478127e-12,   2.794852553004544e-14,  -1.870897549042206e-16,   1.074238656675108e-18,  -4.921702844966397e-21,   1.024858457575574e-24,   1.670711536849692e-25,
  -4.532174063130017e-27,   4.011512414837459e-29,   3.838654277486064e-02,  -5.584782605806166e-04,   6.006918776228897e-06,  -5.633262089294109e-08,   4.818006742605110e-10,
  -3.820561612070095e-12,   2.795163476187679e-14,  -1.871080636026343e-16,   1.074243178738284e-18,  -4.920749962363029e-21,   9.939423340441990e-25,   1.673970551952827e-25,
  -4.531805100867809e-27,   4.030167649253604e-29,   3.838686186569570e-02,  -5.584872352285385e-04,   6.007072277951541e-06,  -5.633464950726353e-08,   4.818229355811037e-10,
  -3.820770225281588e-12,   2.795323150285870e-14,  -1.871174655353935e-16,   1.074245482405038e-18,  -4.920260370904874e-21,   9.780657631071986e-25,   1.675646162013180e-25,
  -4.531612158163437e-27,   4.039750919969543e-29,   3.838697292882144e-02,  -5.584903589622260e-04,   6.007125706186709e-06,  -5.633535559372060e-08,   4.818306839370611e-10,
  -3.820842835840076e-12,   2.795378726344410e-14,  -1.871207378909553e-16,   1.074246281251605e-18,  -4.920089925782980e-21,   9.725398313979271e-25,   1.676229683902801e-25,
  -4.531544451617365e-27,   4.043086928234420e-29,   3.838699055304022e-02,  -5.584908546569420e-04,   6.007134184538146e-06,  -5.633546764032828e-08,   4.818319134991611e-10,
  -3.820854358174617e-12,   2.795387545500746e-14,  -1.871212571652383e-16,   1.074246407876761e-18,  -4.920062876669428e-21,   9.716629447216320e-25,   1.676322295529843e-25,
  -4.531533681364526e-27,   4.043616328768400e-29,   1.064532997264917e-01,  -1.517832229525674e-03,   1.557215611257507e-05,  -1.334998757378652e-07,   9.727935911823269e-10,
  -5.741570740127547e-12,   2.113313650195072e-14,   6.027929506377169e-17,  -2.284825921400345e-18,   2.785451445600386e-20,  -2.633863633485114e-22,   1.527829572048215e-24,
  -9.089189888447188e-27,  -3.471095620988089e-29,   1.064547607120682e-01,  -1.517869795248001e-03,   1.557270347520652e-05,  -1.335052574380016e-07,   9.728232383617199e-10,
  -5.741450566444551e-12,   2.112711585497741e-14,   6.037350894922490e-17,  -2.285938857698908e-18,   2.786238311377892e-20,  -2.634417685599537e-22,   1.527590818985502e-24,
  -9.071285149103522e-27,  -3.443833287524011e-29,   1.064573386858801e-01,  -1.517936081787410e-03,   1.557366931873656e-05,  -1.335147534406418e-07,   9.728755443845770e-10,
  -5.741238367187278e-12,   2.111648995228551e-14,   6.053977241876792e-17,  -2.287902840631490e-18,   2.787626649902184e-20,  -2.635394411445132e-22,   1.527171160729686e-24,
  -9.039627242634361e-27,  -3.395694741373275e-29,   1.064604560705946e-01,  -1.518016238278723e-03,   1.557483725016457e-05,  -1.335262359516964e-07,   9.729387816337052e-10,
  -5.740981516252111e-12,   2.110363694499313e-14,   6.074085678758587e-17,  -2.290278032379374e-18,   2.789305276164158e-20,  -2.636573928629900e-22,   1.526666478062877e-24,
  -9.001235916157753e-27,  -3.337427987442536e-29,   1.064634824483132e-01,  -1.518094055011671e-03,   1.557597108197792e-05,  -1.335373828103689e-07,   9.730001589509687e-10,
  -5.740731900310798e-12,   2.109115522419556e-14,   6.093610455158964e-17,  -2.292584164965376e-18,   2.790934682658584e-20,  -2.637717357363700e-22,   1.526179445990069e-24,
  -8.963850948189600e-27,  -3.280804340317854e-29,   1.064659205122986e-01,  -1.518156744735126e-03,   1.557688449947933e-05,  -1.335463624569698e-07,   9.730495948981615e-10,
  -5.740530619837737e-12,   2.108109707131720e-14,   6.109342122302162e-17,  -2.294442197048609e-18,   2.792247186501481e-20,  -2.638637321565993e-22,   1.525789181992308e-24,
  -8.933651551609116e-27,  -3.235146946607103e-29,   1.064675315677196e-01,  -1.518198169758951e-03,   1.557748807798058e-05,  -1.335522959897784e-07,   9.730822569715289e-10,
  -5.740397522723034e-12,   2.107444933405650e-14,   6.119738679586840e-17,  -2.295670069795936e-18,   2.793114404704872e-20,  -2.639244645265224e-22,   1.525532322723138e-24,
  -8.913655941941675e-27,  -3.204956877144337e-29,   1.064683589298585e-01,  -1.518219443729345e-03,   1.557779804704605e-05,  -1.335553431249349e-07,   9.730990291729231e-10,
  -5.740329141739609e-12,   2.107103494237646e-14,   6.125078227278899e-17,  -2.296300677755392e-18,   2.793559743932650e-20,  -2.639556357896619e-22,   1.525400728815000e-24,
  -8.903374756913867e-27,  -3.189446530319115e-29,   1.064686469021163e-01,  -1.518226848367538e-03,   1.557790593503577e-05,  -1.335564037053886e-07,   9.731048666784913e-10,
  -5.740305336455859e-12,   2.106984645876780e-14,   6.126936772307182e-17,  -2.296520172448282e-18,   2.793714745337097e-20,  -2.639664824115145e-22,   1.525354976605839e-24,
  -8.899794309685868e-27,  -3.184047011609399e-29,   1.064686925994088e-01,  -1.518228023383443e-03,   1.557792305539372e-05,  -1.335565720047651e-07,   9.731057930001305e-10,
  -5.740301558664128e-12,   2.106965785930657e-14,   6.127231700966459e-17,  -2.296555003509266e-18,   2.793739341783290e-20,  -2.639682034870321e-22,   1.525347718746339e-24,
  -8.899226047722743e-27,  -3.183190134914536e-29,   2.081164647377361e-01,  -2.874118104318155e-03,   2.725463377024560e-05,  -1.975433315958157e-07,   9.686478486537918e-10,
  -3.219150155372280e-13,  -6.053644579576605e-14,   8.243265951822124e-16,  -6.769786043003630e-18,   2.719536961804577e-20,   1.324592423775617e-22,  -4.865822983088909e-24,
   4.701755594721540e-26,  -3.765679648806242e-28,   2.081190209474456e-01,  -2.874173664283147e-03,   2.725517815176738e-05,  -1.975436197320773e-07,   9.685625094469270e-10,
  -3.202906777168806e-13,  -6.055420468552451e-14,   8.244177222065714e-16,  -6.769217834134975e-18,   2.717017565187967e-20,   1.327513340665098e-22,  -4.868520468984447e-24,
   4.704270871169011e-26,  -3.755520108204910e-28,   2.081235314611945e-01,  -2.874271700780418e-03,   2.725613868246478e-05,  -1.975441269145504e-07,   9.684119067727495e-10,
  -3.174243625019610e-13,  -6.058553930801685e-14,   8.245784480709335e-16,  -6.768214217765139e-18,   2.712570925120572e-20,   1.332668619014983e-22,  -4.873274168405126e-24,
   4.708717419850943e-26,  -3.737580774466042e-28,   2.081289856933770e-01,  -2.874390247671026e-03,   2.725730009983705e-05,  -1.975447380932053e-07,   9.682297617958274e-10,
  -3.139581353729043e-13,  -6.062342739030845e-14,   8.247726814842748e-16,  -6.766998923829039e-18,   2.707192083787416e-20,   1.338904612736488e-22,  -4.879012059960123e-24,
   4.714108372701250e-26,  -3.715866829421202e-28,   2.081342806416688e-01,  -2.874505331056002e-03,   2.725842751395669e-05,  -1.975453292032998e-07,   9.680529023587228e-10,
  -3.105929223169445e-13,  -6.066020630680144e-14,   8.249611163044224e-16,  -6.765817346120262e-18,   2.701968392850938e-20,   1.344960689876816e-22,  -4.884571479103379e-24,
   4.719356596700943e-26,  -3.694764887251298e-28,   2.081385462362479e-01,  -2.874598040817032e-03,   2.725933569412092e-05,  -1.975458038092585e-07,   9.679104007265249e-10,
  -3.078817643926592e-13,  -6.068983336182995e-14,   8.251128283561677e-16,  -6.764864198685851e-18,   2.697758820442423e-20,   1.349841024741774e-22,  -4.889042313051271e-24,
   4.723595069668503e-26,  -3.677749447709199e-28,   2.081413648911526e-01,  -2.874659301815989e-03,   2.725993577891663e-05,  -1.975461166445086e-07,   9.678162254714455e-10,
  -3.060901884663082e-13,  -6.070940962677503e-14,   8.252130335942242e-16,  -6.764233747149469e-18,   2.694976508042489e-20,   1.353066666060677e-22,  -4.891992758254036e-24,
   4.726400946114777e-26,  -3.666498149681976e-28,   2.081428124133532e-01,  -2.874690762282675e-03,   2.726024394360164e-05,  -1.975462770604142e-07,   9.677678580396525e-10,
  -3.051701003467439e-13,  -6.071946273874618e-14,   8.252644803603645e-16,  -6.763909785667506e-18,   2.693547440548882e-20,   1.354723435767927e-22,  -4.893506776776125e-24,
   4.727843494934574e-26,  -3.660717664387428e-28,   2.081433162379910e-01,  -2.874701712388199e-03,   2.726035120193706e-05,  -1.975463328564360e-07,   9.677510226860783e-10,
  -3.048498507686092e-13,  -6.072296177872743e-14,   8.252823847421070e-16,  -6.763796996947850e-18,   2.693050005994413e-20,   1.355300129225605e-22,  -4.894033557490353e-24,
   4.728345841368972e-26,  -3.658705331172181e-28,   2.081433961880830e-01,  -2.874703450019232e-03,   2.726036822230048e-05,  -1.975463417086826e-07,   9.677483511176081e-10,
  -3.047990313583364e-13,  -6.072351702639273e-14,   8.252852258194839e-16,  -6.763779097461621e-18,   2.692971068342569e-20,   1.355391644414788e-22,  -4.894117141442437e-24,
   4.728425568890175e-26,  -3.658385983464313e-28,   3.426578076567228e-01,  -4.517499247887528e-03,   3.785068258333661e-05,  -1.966811274649985e-07,  -3.296287380611574e-11,
   1.374759077294089e-11,  -1.625995015097943e-13,   8.669392012019050e-16,   2.997995309118098e-18,  -1.204435269743147e-19,   1.234348172154091e-21,  -5.938164887381409e-24,
  -6.242447724094460e-26,   1.234416186542385e-27,   3.426613561114160e-01,  -4.517554518895753e-03,   3.785066275166254e-05,  -1.966682248346136e-07,  -3.319143440469400e-11,
   1.374929107601256e-11,  -1.625915245371174e-13,   8.665319176050501e-16,   3.003190172183221e-18,  -1.204737902717666e-19,   1.233958853376024e-21,  -5.929047446535836e-24,
  -6.249107556264466e-26,   1.236061350119383e-27,   3.426676174139746e-01,  -4.517652042507983e-03,   3.785062765385936e-05,  -1.966454566460169e-07,  -3.359472402047795e-11,
   1.375229063529063e-11,  -1.625774379641981e-13,   8.658131765028015e-16,   3.012355251929809e-18,  -1.205271520232074e-19,   1.233271562158563e-21,  -5.912949796268940e-24,
  -6.260832501969894e-26,   1.238964392943570e-27,   3.426751886452447e-01,  -4.517769964069505e-03,   3.785058503503853e-05,  -1.966179229025428e-07,  -3.408237051239711e-11,
   1.375591662220399e-11,  -1.625603854408162e-13,   8.649439259935518e-16,   3.023435482353696e-18,  -1.205916122682488e-19,   1.232439916910729e-21,  -5.893467665250664e-24,
  -6.274965386131793e-26,   1.242474983404285e-27,   3.426825386626880e-01,  -4.517884435010102e-03,   3.785054347483796e-05,  -1.965911913107357e-07,  -3.455575291699425e-11,
   1.375943550271818e-11,  -1.625438113685211e-13,   8.640999249908349e-16,   3.034189587647135e-18,  -1.206541206834206e-19,   1.231631979215620e-21,  -5.874537281739124e-24,
  -6.288638206081036e-26,   1.245883194913565e-27,   3.426884597391365e-01,  -4.517976647535043e-03,   3.785050986079447e-05,  -1.965696550330190e-07,  -3.493709189031274e-11,
   1.376226943243223e-11,  -1.625304453424662e-13,   8.634199030292048e-16,   3.042851241466915e-18,  -1.207044275624940e-19,   1.230980692565715e-21,  -5.859274694911601e-24,
  -6.299619099310846e-26,   1.248628929682784e-27,   3.426923722799832e-01,  -4.518037578079846e-03,   3.785048758377796e-05,  -1.965554234341532e-07,  -3.518906814135830e-11,
   1.376414163399505e-11,  -1.625216063737698e-13,   8.629705048891737e-16,   3.048573868728622e-18,  -1.207376454073573e-19,   1.230550127387867e-21,  -5.849183321117318e-24,
  -6.306858560801874e-26,   1.250443317727181e-27,   3.426943815566095e-01,  -4.518068868258195e-03,   3.785047612322160e-05,  -1.965481145766411e-07,  -3.531846822422625e-11,
   1.376510297267554e-11,  -1.625170649953011e-13,   8.627397014452636e-16,   3.051512452030168e-18,  -1.207546969219072e-19,   1.230328947756347e-21,  -5.843999022558557e-24,
  -6.310571264535042e-26,   1.251375108826282e-27,   3.426950809036908e-01,  -4.518079759000280e-03,   3.785047213104740e-05,  -1.965455706219680e-07,  -3.536350682485294e-11,
   1.376543755528272e-11,  -1.625154839854449e-13,   8.626593656468746e-16,   3.052535211522622e-18,  -1.207606306733337e-19,   1.230251954007565e-21,  -5.842194278238698e-24,
  -6.311862692337975e-26,   1.251699429702913e-27,   3.426951918804388e-01,  -4.518081487206737e-03,   3.785047149739135e-05,  -1.965451669295040e-07,  -3.537065381704345e-11,
   1.376549064797915e-11,  -1.625152330847432e-13,   8.626466173412118e-16,   3.052697507405912e-18,  -1.207615722217345e-19,   1.230239735678161e-21,  -5.841907875846339e-24,
  -6.312067585564934e-26,   1.251750895073783e-27,   5.087790956506792e-01,  -6.284611346758975e-03,   4.324220822034827e-05,  -8.437612941355394e-08,  -2.023413045044851e-09,
   2.665951775971264e-11,  -1.024153026277172e-13,  -1.425625937483104e-15,   2.576397970191862e-17,  -1.475661315305778e-19,  -1.178305486127170e-21,   2.829838265833376e-23,
  -2.310690667118493e-25,  -8.601798413061903e-28,   5.087831473133048e-01,  -6.284634989553039e-03,   4.324106924473366e-05,  -8.435115983647535e-08,  -2.023556267879751e-09,
   2.665670321116251e-11,  -1.023477760529844e-13,  -1.426120175974918e-15,   2.575896336972115e-17,  -1.474204656389974e-19,  -1.179718948711598e-21,   2.829203437700258e-23,
  -2.307182823874560e-25,  -8.612455670750087e-28,   5.087902964489472e-01,  -6.284676701930384e-03,   4.323905943900347e-05,  -8.430710277188020e-08,  -2.023808909667561e-09,
   2.665173610668470e-11,  -1.022286350807625e-13,  -1.426991868073435e-15,   2.575010713885649e-17,  -1.471634625493273e-19,  -1.182211257838061e-21,   2.828082649607418e-23,
  -2.300990216465023e-25,  -8.631188253384011e-28,   5.087989411121481e-01,  -6.284727131256059e-03,   4.323662904905407e-05,  -8.425383215981674e-08,  -2.024114275265214e-09,
   2.664572848552191e-11,  -1.020845868488129e-13,  -1.428045246349783e-15,   2.573938985201712e-17,  -1.468527371555334e-19,  -1.185221969332997e-21,   2.826726319855946e-23,
  -2.293497005584873e-25,  -8.653716814547161e-28,   5.088073330465533e-01,  -6.284776076987236e-03,   4.323426955194884e-05,  -8.420212180620512e-08,  -2.024410581152829e-09,
   2.663989498260219e-11,  -1.019447664961194e-13,  -1.429067134545440e-15,   2.572897707417538e-17,  -1.465511379792753e-19,  -1.188141557017755e-21,   2.825408511267303e-23,
  -2.286217454559139e-25,  -8.675458555695382e-28,   5.088140933687260e-01,  -6.284815499734369e-03,   4.323236868823367e-05,  -8.416046736554087e-08,  -2.024649182633750e-09,
   2.663519457987138e-11,  -1.018321427851350e-13,  -1.429889843425986e-15,   2.572058250237017e-17,  -1.463082077672118e-19,  -1.190491274622799e-21,   2.824346111166573e-23,
  -2.280349373054950e-25,  -8.692881485302893e-28,   5.088185604148128e-01,  -6.284841546010517e-03,   4.323111259046270e-05,  -8.413294419870578e-08,  -2.024806797924224e-09,
   2.663208814378253e-11,  -1.017577297766014e-13,  -1.430433224636595e-15,   2.571503249771929e-17,  -1.461477005438129e-19,  -1.192042817145251e-21,   2.823643710046433e-23,
  -2.276470006425978e-25,  -8.704349315768595e-28,   5.088208544399029e-01,  -6.284854920914671e-03,   4.323046751151127e-05,  -8.411881015174319e-08,  -2.024887725975491e-09,
   2.663049268756624e-11,  -1.017195172190873e-13,  -1.430712199527173e-15,   2.571218137077777e-17,  -1.460652775808322e-19,  -1.192839265418539e-21,   2.823282874295459e-23,
  -2.274477196727662e-25,  -8.710224717656275e-28,   5.088216528936664e-01,  -6.284859575996644e-03,   4.323024298386200e-05,  -8.411389073351544e-08,  -2.024915891346121e-09,
   2.662993735012079e-11,  -1.017062173201535e-13,  -1.430809286976999e-15,   2.571118886127129e-17,  -1.460365903379431e-19,  -1.193116421912627e-21,   2.823157263156376e-23,
  -2.273783490482531e-25,  -8.712267497291825e-28,   5.088217795971550e-01,  -6.284860314685692e-03,   4.323020735432076e-05,  -8.411311009273938e-08,  -2.024920360689615e-09,
   2.662984922456296e-11,  -1.017041068251075e-13,  -1.430824692833519e-15,   2.571103135662467e-17,  -1.460320381067131e-19,  -1.193160400237993e-21,   2.823137329499264e-23,
  -2.273673404556302e-25,  -8.712591553506612e-28,   7.041828650984419e-01,  -7.944540859306896e-03,   3.890378528921896e-05,   1.515521907085983e-07,  -3.974551381595519e-09,
   1.735442350807687e-11,   2.539586631696957e-13,  -4.074299271183705e-15,   6.323910751206057e-18,   4.251209970020239e-19,  -4.817361943219120e-21,  -1.214674794994939e-23,
   7.002223578250471e-25,  -5.545031355705641e-27,   7.041865078372599e-01,  -7.944498178281040e-03,   3.890155162549780e-05,   1.515683932221576e-07,  -3.974194062185526e-09,
   1.734642503866257e-11,   2.539748469590819e-13,  -4.072866169566567e-15,   6.303726296646617e-18,   4.250568245836952e-19,  -4.813044283607787e-21,  -1.218647729337449e-23,
   6.998994044687174e-25,  -5.530185442907498e-27,   7.041929353373009e-01,  -7.944422863245199e-03,   3.889761045411494e-05,   1.515969767233201e-07,  -3.973563548116813e-09,
   1.733231390633169e-11,   2.540033605182677e-13,  -4.070337616391799e-15,   6.268125304318217e-18,   4.249434256312629e-19,  -4.805427328635356e-21,  -1.225649218414521e-23,
   6.993296521409646e-25,  -5.503996875072290e-27,   7.042007072493243e-01,  -7.944331785201044e-03,   3.889284502617212e-05,   1.516315298174357e-07,  -3.972801092515902e-09,
   1.731525448353039e-11,   2.540377661357306e-13,  -4.067280365282567e-15,   6.225101427378770e-18,   4.248060201086666e-19,  -4.796219592860153e-21,  -1.234100464670705e-23,
   6.986408792294780e-25,  -5.472341827564000e-27,   7.042082517836243e-01,  -7.944243361618223e-03,   3.888821912297180e-05,   1.516650624938501e-07,  -3.972060881132366e-09,
   1.729869758458229e-11,   2.540710897999767e-13,  -4.064312755899029e-15,   6.183361001184280e-18,   4.246723339091507e-19,  -4.787283780056495e-21,  -1.242289053698603e-23,
   6.979724170540985e-25,  -5.441624739180888e-27,   7.042143293449964e-01,  -7.944172124005982e-03,   3.888449276455804e-05,   1.516920681952052e-07,  -3.971464553079725e-09,
   1.728536249483754e-11,   2.540978799649267e-13,  -4.061922315831263e-15,   6.149754375029679e-18,   4.245644266937409e-19,  -4.780087281332589e-21,  -1.248874403487274e-23,
   6.974340467474776e-25,  -5.416888860401432e-27,   7.042183451828682e-01,  -7.944125049148289e-03,   3.888203055565733e-05,   1.517099092694395e-07,  -3.971070498686391e-09,
   1.727655234096180e-11,   2.541155555336917e-13,  -4.060342867100925e-15,   6.127556976698607e-18,   4.244930201365288e-19,  -4.775332979442779e-21,  -1.253220367805558e-23,
   6.970783670729141e-25,  -5.400548452425524e-27,   7.042204074748571e-01,  -7.944100873241301e-03,   3.888076612522951e-05,   1.517190703358787e-07,  -3.970868129365472e-09,
   1.727202834943752e-11,   2.541246244681465e-13,  -4.059531779104921e-15,   6.116160414474464e-18,   4.244563174974897e-19,  -4.772891732198829e-21,  -1.255450522322833e-23,
   6.968957289350058e-25,  -5.392158302762369e-27,   7.042211252692306e-01,  -7.944092458481638e-03,   3.888032603367938e-05,   1.517222587412820e-07,  -3.970797692307518e-09,
   1.727045380344867e-11,   2.541277796700883e-13,  -4.059249477994910e-15,   6.112194192540368e-18,   4.244435377222847e-19,  -4.772042083767654e-21,  -1.256226476431976e-23,
   6.968321633082762e-25,  -5.389238262522270e-27,   7.042212391730635e-01,  -7.944091123169765e-03,   3.888025619745067e-05,   1.517227646883991e-07,  -3.970786514889793e-09,
   1.727020394804114e-11,   2.541282802943428e-13,  -4.059204680957563e-15,   6.111564829386384e-18,   4.244415095065720e-19,  -4.771907258638141e-21,  -1.256349596769454e-23,
   6.968220764730907e-25,  -5.388774903189525e-27,   9.248775628882653e-01,  -9.187106487426318e-03,   2.121873123396377e-05,   4.456817289349349e-07,  -3.720234981700241e-09,
  -2.781603689199805e-11,   5.685512149166259e-13,   3.636662246992067e-16,  -7.759345245860629e-17,   3.863255800458550e-19,   8.655865352061763e-21,  -1.121319157062738e-22,
  -6.881705318601595e-25,   2.078188709745877e-26,   9.248795479487263e-01,  -9.186981231515968e-03,   2.121664310407702e-05,   4.456556576635029e-07,  -3.719437856804258e-09,
  -2.781530045646416e-11,   5.683482834304788e-13,   3.649551746518285e-16,  -7.755707270744374e-17,   3.857532489849002e-19,   8.651601906915740e-21,  -1.119813926914163e-22,
  -6.882908124466442e-25,   2.075564917736210e-26,   9.248830504605718e-01,  -9.186760221448620e-03,   2.121295892995828e-05,   4.456096550618198e-07,  -3.718031549077373e-09,
  -2.781399894859473e-11,   5.679902851814019e-13,   3.672279810382874e-16,  -7.749289469087676e-17,   3.847439913319957e-19,   8.644078414284172e-21,  -1.117159478434767e-22,
  -6.885004622212576e-25,   2.070939670408889e-26,   9.248872854649691e-01,  -9.186492983870779e-03,   2.120850460768479e-05,   4.455540291920297e-07,  -3.716331421741931e-09,
  -2.781242164780215e-11,   5.675575220825219e-13,   3.699736136853461e-16,  -7.741531488853487e-17,   3.835246591127688e-19,   8.634979952341593e-21,  -1.113952338509379e-22,
  -6.887495663368593e-25,   2.065354394716800e-26,   9.248913964508474e-01,  -9.186233564892243e-03,   2.120418107834623e-05,   4.455000295752262e-07,  -3.714681381109840e-09,
  -2.781088676477564e-11,   5.671375415778580e-13,   3.726362327634606e-16,  -7.734002787896192e-17,   3.823420754825471e-19,   8.626146314067504e-21,  -1.110841672744147e-22,
  -6.889867838178877e-25,   2.059940278869835e-26,   9.248947080048000e-01,  -9.186024587957368e-03,   2.120069856472087e-05,   4.454565289141475e-07,  -3.713352426091052e-09,
  -2.780964765731697e-11,   5.667993099034880e-13,   3.747792035467616e-16,  -7.727939635889567e-17,   3.813902057011303e-19,   8.619029335044862e-21,  -1.108337744033199e-22,
  -6.891745854726531e-25,   2.055584443631071e-26,   9.248968961213651e-01,  -9.185886503452787e-03,   2.119839760959378e-05,   4.454277848090629e-07,  -3.712474421321959e-09,
  -2.780882759221389e-11,   5.665758609812965e-13,   3.761942613856979e-16,  -7.723934129474776e-17,   3.807616207086860e-19,   8.614326215271697e-21,  -1.106684162904525e-22,
  -6.892970685718800e-25,   2.052708976474178e-26,   9.248980197932127e-01,  -9.185815591606481e-03,   2.119721602949468e-05,   4.454130234461791e-07,  -3.712023568710089e-09,
  -2.780840605228886e-11,   5.664611242787809e-13,   3.769206585961031e-16,  -7.721877393695553e-17,   3.804389339290993e-19,   8.611910831660563e-21,  -1.105835269825852e-22,
  -6.893594710728871e-25,   2.051233149128739e-26,   9.248984108926013e-01,  -9.185790910272685e-03,   2.119680478093669e-05,   4.454078856362352e-07,  -3.711866652469195e-09,
  -2.780825926822571e-11,   5.664211915083150e-13,   3.771734396155345e-16,  -7.721161573094501e-17,   3.803266392106567e-19,   8.611070118369948e-21,  -1.105539852556161e-22,
  -6.893811115168294e-25,   2.050719611186370e-26,   9.248984729544558e-01,  -9.185786993693650e-03,   2.119673952198680e-05,   4.454070703373914e-07,  -3.711841752361778e-09,
  -2.780823597261484e-11,   5.664148548410433e-13,   3.772135501947759e-16,  -7.721047984365664e-17,   3.803088205048971e-19,   8.610936707947907e-21,  -1.105492976170151e-22,
  -6.893845417924257e-25,   2.050638126303605e-26,   1.164041172002700e+00,  -9.629018833760990e-03,  -9.745845024877644e-06,   6.177334513481241e-07,   6.530805627526659e-10,
  -7.266137502756371e-11,  -1.943895966513657e-14,   1.033466471179088e-14,  -9.996106552489226e-18,  -1.635319290147251e-18,   3.583695863427558e-21,   2.671082601467213e-22,
  -1.078334447863897e-24,  -4.666799314085890e-26,   1.164040259068651e+00,  -9.628845335871957e-03,  -9.745477823978297e-06,   6.176655016905641e-07,   6.530529205713110e-10,
  -7.264111584181380e-11,  -1.946489214099631e-14,   1.032918103030286e-14,  -9.981198549627442e-18,  -1.633955084256616e-18,   3.577127238399745e-21,   2.667716658621976e-22,
  -1.076094714289001e-24,  -4.658327259881809e-26,   1.164038648210104e+00,  -9.628539211620315e-03,  -9.744829904918052e-06,   6.175456188635642e-07,   6.530041159791074e-10,
  -7.260537694901751e-11,  -1.951061871514739e-14,   1.031950872153732e-14,  -9.954915582200291e-18,  -1.631549327713683e-18,   3.565548025869976e-21,   2.661782419026919e-22,
  -1.072146023289665e-24,  -4.643390883442912e-26,   1.164036700390385e+00,  -9.628169069335847e-03,  -9.744046455937076e-06,   6.174006815436698e-07,   6.529450506211913e-10,
  -7.256217602902117e-11,  -1.956585778011902e-14,   1.030781922570335e-14,  -9.923172169753446e-18,  -1.628642657468100e-18,   3.551565454362766e-21,   2.654615226622116e-22,
  -1.067376936107808e-24,  -4.625351292309381e-26,   1.164034809530613e+00,  -9.627809769288861e-03,  -9.743285919931468e-06,   6.172600064118960e-07,   6.528876583273257e-10,
  -7.252025295410773e-11,  -1.961942640472624e-14,   1.029647792568250e-14,  -9.892396217640170e-18,  -1.625823419824353e-18,   3.538011440335589e-21,   2.647666390879306e-22,
  -1.062753161751924e-24,  -4.607861407817246e-26,   1.164033286314318e+00,  -9.627520341670755e-03,  -9.742673258290892e-06,   6.171467000614849e-07,   6.528413861283524e-10,
  -7.248649146560027e-11,  -1.966254013692700e-14,   1.028734629150434e-14,  -9.867632149340905e-18,  -1.623554073974709e-18,   3.527106839937707e-21,   2.642074907592547e-22,
  -1.059032582652479e-24,  -4.593787992281168e-26,   1.164032279817629e+00,  -9.627329102763701e-03,  -9.742268430364963e-06,   6.170718388906877e-07,   6.528107918270579e-10,
  -7.246418795553948e-11,  -1.969100912706687e-14,   1.028131460469429e-14,  -9.851282506785027e-18,  -1.622055409185273e-18,   3.519908289878014e-21,   2.638383290907470e-22,
  -1.056576180134807e-24,  -4.584496460889857e-26,   1.164031762938832e+00,  -9.627230895436279e-03,  -9.742060534320811e-06,   6.170333970806008e-07,   6.527950744835190e-10,
  -7.245273573039684e-11,  -1.970562319610817e-14,   1.027821776663673e-14,  -9.842890514529163e-18,  -1.621286044687035e-18,   3.516213658743099e-21,   2.636488438498054e-22,
  -1.055315345688558e-24,  -4.579727266580108e-26,   1.164031583035296e+00,  -9.627196713954490e-03,  -9.741988174591463e-06,   6.170200175314418e-07,   6.527896030099417e-10,
  -7.244874994829146e-11,  -1.971070878264786e-14,   1.027713999867229e-14,  -9.839970294172375e-18,  -1.621018303553750e-18,   3.514928053732508e-21,   2.635829072058074e-22,
  -1.054876603475183e-24,  -4.578067695036571e-26,   1.164031554487123e+00,  -9.627191289846772e-03,  -9.741976692117613e-06,   6.170178944038000e-07,   6.527887347193265e-10,
  -7.244811747236894e-11,  -1.971151574895636e-14,   1.027696897719304e-14,  -9.839506928144095e-18,  -1.620975818775169e-18,   3.514724062308697e-21,   2.635724447009105e-22,
  -1.054806986005875e-24,  -4.577804362411307e-26,   1.410273291856525e+00,  -8.878413429709832e-03,  -4.578774723765668e-05,   4.225912108179332e-07,   6.863720445252863e-09,
  -2.443470647729960e-11,  -1.132046002005402e-12,  -1.320587915944804e-15,   1.867692701514244e-16,   1.094976478009038e-18,  -2.983947767894128e-20,  -3.562801704487645e-22,
   4.066666040790755e-24,   8.968698623451918e-26,   1.410269006995859e+00,  -8.878294656932208e-03,  -4.578389535273689e-05,   4.225682820105184e-07,   6.862134272021056e-09,
  -2.443724845260122e-11,  -1.131558314482644e-12,  -1.316939514141801e-15,   1.866441883179906e-16,   1.093164456141146e-18,  -2.981447225589974e-20,  -3.556348756914775e-22,
   4.063276080614558e-24,   8.949530721796396e-26,   1.410261446584212e+00,  -8.878085085740950e-03,  -4.577709936511988e-05,   4.225278218488548e-07,   6.859336000909926e-09,
  -2.444172799162424e-11,  -1.130698048618226e-12,  -1.310506805272626e-15,   1.864235650788478e-16,   1.089969809339805e-18,  -2.977036683650864e-20,  -3.544973762655317e-22,
   4.057295288294815e-24,   8.915754725117907e-26,   1.410252304952207e+00,  -8.877831678957931e-03,  -4.576888281845160e-05,   4.224788937178690e-07,   6.855953250270658e-09,
  -2.444713478606474e-11,  -1.129658260123499e-12,  -1.302736746070063e-15,   1.861569310563119e-16,   1.086111399040077e-18,  -2.971706314877392e-20,  -3.531238303498680e-22,
   4.050064705800967e-24,   8.874990892442811e-26,   1.410243430936115e+00,  -8.877585685402332e-03,  -4.576090762936284e-05,   4.224313917135328e-07,   6.852670327694733e-09,
  -2.445237323566458e-11,  -1.128649326904930e-12,  -1.295202540084311e-15,   1.858982401547539e-16,   1.082370524357485e-18,  -2.966534727538775e-20,  -3.517924350140577e-22,
   4.043046922733317e-24,   8.835500126674086e-26,   1.410236282518139e+00,  -8.877387522901644e-03,  -4.575448384643651e-05,   4.223931222676339e-07,   6.850026359388970e-09,
  -2.445658583529365e-11,  -1.127836883972801e-12,  -1.289139405987110e-15,   1.856899515675574e-16,   1.079360362956980e-18,  -2.962370743626199e-20,  -3.507213253616038e-22,
   4.037394604277670e-24,   8.803745596553334e-26,   1.410231559153984e+00,  -8.877256583936153e-03,  -4.575023957829290e-05,   4.223678333015515e-07,   6.848279620491548e-09,
  -2.445936581147100e-11,  -1.127300202852323e-12,  -1.285136089683908e-15,   1.855523717493314e-16,   1.077372984379726e-18,  -2.959620324310905e-20,  -3.500142620743291e-22,
   4.033660204354167e-24,   8.782791487349681e-26,   1.410229133537108e+00,  -8.877189341528058e-03,  -4.574806008365653e-05,   4.223548458371831e-07,   6.847382694175344e-09,
  -2.446079233863578e-11,  -1.127024642960291e-12,  -1.283081151884252e-15,   1.854817344935365e-16,   1.076352890451214e-18,  -2.958208182368915e-20,  -3.496513697125909e-22,
   4.031742582870230e-24,   8.772039424570856e-26,   1.410228289287955e+00,  -8.877165937353864e-03,  -4.574730151289779e-05,   4.223503253723502e-07,   6.847070527899513e-09,
  -2.446128867563475e-11,  -1.126928740021157e-12,  -1.282366064233573e-15,   1.854571511864873e-16,   1.075997920190194e-18,  -2.957716725965006e-20,  -3.495250964703926e-22,
   4.031075164556028e-24,   8.768298482969067e-26,   1.410228155317670e+00,  -8.877162223441426e-03,  -4.574718113922464e-05,   4.223496080340412e-07,   6.847020992224539e-09,
  -2.446136742899123e-11,  -1.126913521935005e-12,  -1.282252596899772e-15,   1.854532502793932e-16,   1.075941595227537e-18,  -2.957638741095934e-20,  -3.495050602961914e-22,
   4.030969255764226e-24,   8.767704914093257e-26,   1.645309264784677e+00,  -6.736361940570081e-03,  -6.748999205300876e-05,  -1.655418935270896e-07,   6.170579674973857e-09,
   9.148381117582190e-11,   3.147313467771335e-14,  -1.580547893291794e-14,  -1.929249363911774e-16,   7.793888406635937e-19,   4.845328838600951e-20,   4.245815740267491e-22,
  -5.274484655222907e-24,  -1.605568317115305e-25,   1.645302944578478e+00,  -6.736408198018318e-03,  -6.748652089563622e-05,  -1.654563888432394e-07,   6.170618001178479e-09,
   9.145273705137063e-11,   3.097090424969501e-14,  -1.580279278395511e-14,  -1.927215854293558e-16,   7.815330492409996e-19,   4.842033990575480e-20,   4.234218725037562e-22,
  -5.281293440458961e-24,  -1.602966081681422e-25,   1.645291792739638e+00,  -6.736489800508829e-03,  -6.748039596762106e-05,  -1.653055381523314e-07,   6.170685055827339e-09,
   9.139791059592327e-11,   3.008514407905241e-14,  -1.579804718138020e-14,  -1.923628827344279e-16,   7.853116922691151e-19,   4.836216800367515e-20,   4.213771094158013e-22,
  -5.293265845261028e-24,  -1.598373295249419e-25,   1.645278308267823e+00,  -6.736588441858963e-03,  -6.747298961173749e-05,  -1.651231682402337e-07,   6.170765163132019e-09,
   9.133162124276196e-11,   2.901481209841904e-14,  -1.579229878158871e-14,  -1.919293288272734e-16,   7.898726081468976e-19,   4.829176844641730e-20,   4.189072007894396e-22,
  -5.307671793378243e-24,  -1.592817786728398e-25,   1.645265218248141e+00,  -6.736684166356420e-03,  -6.746579962109424e-05,  -1.649461689429611e-07,   6.170841908403221e-09,
   9.126727642526490e-11,   2.797652566752697e-14,  -1.578670790939765e-14,  -1.915086446416785e-16,   7.942916225890167e-19,   4.822336577416645e-20,   4.165122221675818e-22,
  -5.321582352229892e-24,  -1.587422664786535e-25,   1.645254673436797e+00,  -6.736761255823258e-03,  -6.746000743783315e-05,  -1.648036108854633e-07,   6.170903001789415e-09,
   9.121544662780911e-11,   2.714064955888862e-14,  -1.578219651403151e-14,  -1.911698920524629e-16,   7.978453339478640e-19,   4.816821860966136e-20,   4.145848406939493e-22,
  -5.332735209028950e-24,  -1.583075055312709e-25,   1.645247705778942e+00,  -6.736812182958018e-03,  -6.745618005644225e-05,  -1.647094258830507e-07,   6.170943013119761e-09,
   9.118120114106537e-11,   2.658858867914188e-14,  -1.577921181432003e-14,  -1.909461214591143e-16,   8.001905343218038e-19,   4.813175741177919e-20,   4.133122320242174e-22,
  -5.340078741318181e-24,  -1.580201567473350e-25,   1.645244127604466e+00,  -6.736838332702218e-03,  -6.745421450992406e-05,  -1.646610619615123e-07,   6.170963450135645e-09,
   9.116361528674483e-11,   2.630516284882587e-14,  -1.577767790010516e-14,  -1.908312265415046e-16,   8.013939705922472e-19,   4.811302637911864e-20,   4.126589868028126e-22,
  -5.343841937244873e-24,  -1.578725689515773e-25,   1.645242882196227e+00,  -6.736847433758998e-03,  -6.745353038297565e-05,  -1.646442291854469e-07,   6.170970545802261e-09,
   9.115749450314724e-11,   2.620652724039442e-14,  -1.577714382768291e-14,  -1.907912398144880e-16,   8.018126885717192e-19,   4.810650584374452e-20,   4.124316666200367e-22,
  -5.345150469465326e-24,  -1.578211964231582e-25,   1.645242684567478e+00,  -6.736848877942828e-03,  -6.745342182142800e-05,  -1.646415580903526e-07,   6.170971670950211e-09,
   9.115652322545159e-11,   2.619087576138795e-14,  -1.577705906922313e-14,  -1.907848946378429e-16,   8.018791262738112e-19,   4.810547107580404e-20,   4.123955963069599e-22,
  -5.345358054628213e-24,  -1.578130441565960e-25,   1.842324788302175e+00,  -3.598154525953580e-03,  -5.394856114013286e-05,  -5.729025781438220e-07,  -3.191340064802351e-09,
   2.755067732898529e-11,   1.029922109883495e-12,   1.433782644684005e-14,   7.732764423861348e-17,  -1.375315735348227e-18,  -4.351509343220625e-20,  -5.817427994092028e-22,
  -2.312682444415042e-24,   8.164491043759078e-26,   1.842319727047513e+00,  -3.598315562625150e-03,  -5.395034807556777e-05,  -5.728765128116727e-07,  -3.189889390078473e-09,
   2.757882963161050e-11,   1.030121293001751e-12,   1.433310728909608e-14,   7.714363749973078e-17,  -1.378291469770875e-18,  -4.352853379514900e-20,  -5.811315162659424e-22,
  -2.293926321176182e-24,   8.190399838292354e-26,   1.842310796248683e+00,  -3.598599708368653e-03,  -5.395350048733571e-05,  -5.728304986881722e-07,  -3.187329425441089e-09,
   2.762849722160487e-11,   1.030472361800362e-12,   1.432477211341638e-14,   7.681890937538264e-17,  -1.383539622949385e-18,  -4.355215513904148e-20,  -5.800513640678307e-22,
  -2.260827512849578e-24,   8.236065652823957e-26,   1.842299996800558e+00,  -3.598943290209205e-03,  -5.395731128522143e-05,  -5.727748213741317e-07,  -3.184233503355461e-09,
   2.768854285012374e-11,   1.030896207869777e-12,   1.431467924244939e-14,   7.642616757305295e-17,  -1.389881347416080e-18,  -4.358055737004810e-20,  -5.787426198556746e-22,
  -2.220798463848623e-24,   8.291198763707787e-26,   1.842289512641650e+00,  -3.599276822797230e-03,  -5.396100955622415e-05,  -5.727207325377150e-07,  -3.181227632492072e-09,
   2.774682053234417e-11,   1.031306968520000e-12,   1.430486672139640e-14,   7.604482019025064e-17,  -1.396033172158093e-18,  -4.360796120454532e-20,  -5.774693803484967e-22,
  -2.181933161509237e-24,   8.344630346582907e-26,   1.842281066566494e+00,  -3.599545504632254e-03,  -5.396398798569493e-05,  -5.726771318622415e-07,  -3.178805853332484e-09,
   2.779375854114193e-11,   1.031637369078528e-12,   1.429695147097655e-14,   7.573755426274198e-17,  -1.400985694031713e-18,  -4.362991659499954e-20,  -5.764417186385689e-22,
  -2.150619688892071e-24,   8.387609069518710e-26,   1.842275485465759e+00,  -3.599723041040707e-03,  -5.396595566284069e-05,  -5.726483078922785e-07,  -3.177205443571396e-09,
   2.782476957186825e-11,   1.031855445634922e-12,   1.429171611873679e-14,   7.553449037031779e-17,  -1.404256610916370e-18,  -4.364436518378115e-20,  -5.757617008767360e-22,
  -2.129926325929218e-24,   8.415976750544261e-26,   1.842272619277283e+00,  -3.599814213317645e-03,  -5.396696603055087e-05,  -5.726335012544738e-07,  -3.176383512927900e-09,
   2.784069374432509e-11,   1.031967362222079e-12,   1.428902593932321e-14,   7.543019869045162e-17,  -1.405935881489657e-18,  -4.365176693438816e-20,  -5.754121833527565e-22,
  -2.119298687433990e-24,   8.430535041144429e-26,   1.842271621669965e+00,  -3.599845946478292e-03,  -5.396731767780267e-05,  -5.726283470079244e-07,  -3.176097425492703e-09,
   2.784623606339188e-11,   1.032006303690055e-12,   1.428808934694851e-14,   7.539389763986340e-17,  -1.406520287080787e-18,  -4.365434026943333e-20,  -5.752904834898570e-22,
  -2.115599544448449e-24,   8.435600615363449e-26,   1.842271463363225e+00,  -3.599850982085055e-03,  -5.396737347840619e-05,  -5.726275290686189e-07,  -3.176052027027012e-09,
   2.784711554194088e-11,   1.032012482589086e-12,   1.428794071073229e-14,   7.538813709777325e-17,  -1.406613020405321e-18,  -4.365474848401903e-20,  -5.752711691625666e-22,
  -2.115012536850240e-24,   8.436404377579191e-26,   1.968379725152045e+00,  -8.087083868565658e-04,  -1.514271327394773e-05,  -2.438794054769473e-07,  -3.523122471571504e-09,
  -4.596957826182510e-11,  -5.327222634524241e-13,  -5.177132648584549e-15,  -3.406874224618447e-17,   8.349765571736159e-20,   8.262335778946845e-21,   1.897014624706426e-22,
   3.167098956523430e-24,   4.270690519686334e-26,   1.968378301538600e+00,  -8.087771299250247e-04,  -1.514469926156929e-05,  -2.439225875211663e-07,  -3.523872658539815e-09,
  -4.597976576971811e-11,  -5.328109587449697e-13,  -5.176824979253276e-15,  -3.403324888663238e-17,   8.448802193161399e-20,   8.282110189527653e-21,   1.900152871283079e-22,
   3.170942945776999e-24,   4.273479537147386e-26,   1.968375789398366e+00,  -8.088984380413858e-04,  -1.514820391134142e-05,  -2.439987906819477e-07,  -3.525196476381209e-09,
  -4.599774128270944e-11,  -5.329673868520579e-13,  -5.176279365424593e-15,  -3.397055231445542e-17,   8.623685585396868e-20,   8.317021769986797e-21,   1.905692001522507e-22,
   3.177724317444150e-24,   4.278390888803930e-26,   1.968372751432511e+00,  -8.090451419773734e-04,  -1.515244235679949e-05,  -2.440909495968998e-07,  -3.526797423441759e-09,
  -4.601947660109843e-11,  -5.331564114797219e-13,  -5.175614952045914e-15,  -3.389462299106678e-17,   8.835381085134889e-20,   8.359270166629274e-21,   1.912392777431283e-22,
   3.185922011663524e-24,   4.284312817919509e-26,   1.968369801956554e+00,  -8.091875772820056e-04,  -1.515655757946175e-05,  -2.441804297394085e-07,  -3.528351775576594e-09,
  -4.604057596337723e-11,  -5.333397771478927e-13,  -5.174965077072868e-15,  -3.382079062981643e-17,   9.041126705600078e-20,   8.400318667478721e-21,   1.918900702105306e-22,
   3.193877648795467e-24,   4.290043961795848e-26,   1.968367425702684e+00,  -8.093023339677426e-04,  -1.515987318869223e-05,  -2.442525237112435e-07,  -3.529604070674572e-09,
  -4.605757268155882e-11,  -5.334873964918764e-13,  -5.174438051835920e-15,  -3.376122515285956e-17,   9.207041331276607e-20,   8.433411512537093e-21,   1.924145495414847e-22,
   3.200284773764667e-24,   4.294648146305357e-26,   1.968365855421269e+00,  -8.093781693388404e-04,  -1.516206429934559e-05,  -2.443001669867381e-07,  -3.530431628220181e-09,
  -4.606880348899963e-11,  -5.335848928746187e-13,  -5.174088091091525e-15,  -3.372182269026739e-17,   9.316757342773065e-20,   8.455290770223721e-21,   1.927612185115691e-22,
   3.204517585894563e-24,   4.297684256842188e-26,   1.968365048977187e+00,  -8.094171163472117e-04,  -1.516318960604317e-05,  -2.443246355923253e-07,  -3.530856638174187e-09,
  -4.607457094644478e-11,  -5.336349471264142e-13,  -5.173907839904917e-15,  -3.370157444494649e-17,   9.373127307427528e-20,   8.466530556096022e-21,   1.929392812429928e-22,
   3.206691057571524e-24,   4.299241509164653e-26,   1.968364768282253e+00,  -8.094306725152945e-04,  -1.516358128993740e-05,  -2.443331523540093e-07,  -3.531004569893915e-09,
  -4.607657834695614e-11,  -5.336523666093488e-13,  -5.173845017498709e-15,  -3.369452475669009e-17,   9.392751456653955e-20,   8.470443261904771e-21,   1.930012626396912e-22,
   3.207447509649282e-24,   4.299783216746372e-26,   1.968364723739610e+00,  -8.094328237069574e-04,  -1.516364344527994e-05,  -2.443345038581604e-07,  -3.531028044768267e-09,
  -4.607689689301712e-11,  -5.336551307294396e-13,  -5.173835044444281e-15,  -3.369340596850397e-17,   9.395865731939050e-20,   8.471064182695055e-21,   1.930110984725716e-22,
   3.207567546054888e-24,   4.299869163636999e-26,   4.027353746561850e-03,  -5.747622209917863e-05,   6.140388342941267e-07,  -5.823663776193007e-09,   5.160123450008624e-11,
  -4.383934856835582e-13,   3.595926143299030e-15,  -2.898144125182965e-17,   2.249607252569841e-19,  -1.790958344762517e-21,   1.254285418240962e-23,  -1.093097162683902e-25,
   7.461727249056888e-28,   5.431145914817346e-31,   4.027411370915085e-03,  -5.747786145085557e-05,   6.140678885186212e-07,  -5.824075249908713e-09,   5.160629825944051e-11,
  -4.384506391958440e-13,   3.596517760490423e-15,  -2.898750041018355e-17,   2.250137921388392e-19,  -1.791521746614507e-21,   1.254756182673128e-23,  -1.093041714255067e-25,
   7.481288015992694e-28,   5.717482644345740e-31,   4.027513052212335e-03,  -5.748075420689317e-05,   6.141191574729701e-07,  -5.824801345355855e-09,   5.161523401943738e-11,
  -4.385514971744507e-13,   3.597561791691774e-15,  -2.899819343632147e-17,   2.251074457144931e-19,  -1.792515853209930e-21,   1.255587839076003e-23,  -1.092942183587311e-25,
   7.515813752008841e-28,   6.221894761066752e-31,   4.027636010107849e-03,  -5.748425231905129e-05,   6.141811563932223e-07,  -5.825679422079762e-09,   5.162604039025427e-11,
  -4.386734722728510e-13,   3.598824438687613e-15,  -2.901112619362130e-17,   2.252207203117195e-19,  -1.793717894696209e-21,   1.256595167010630e-23,  -1.092818950076395e-25,
   7.557580339451915e-28,   6.830412535047443e-31,   4.027755379467631e-03,  -5.748764839402198e-05,   6.142413480114848e-07,  -5.826531921630275e-09,   5.163653223692810e-11,
  -4.387919009233562e-13,   3.600050396999921e-15,  -2.902368385071090e-17,   2.253307143592313e-19,  -1.794884770295458e-21,   1.257574823392432e-23,  -1.092696305595346e-25,
   7.598144989875820e-28,   7.419659285651348e-31,   4.027851544711305e-03,  -5.749038434840445e-05,   6.142898405626703e-07,  -5.827218739977669e-09,   5.164498519845359e-11,
  -4.388873179271018e-13,   3.601038158160709e-15,  -2.903380211356677e-17,   2.254193449537615e-19,  -1.795824757091621e-21,   1.258365283081051e-23,  -1.092595350119382e-25,
   7.630836391853163e-28,   7.893278631498874e-31,   4.027915090381691e-03,  -5.749219227734867e-05,   6.143218850290818e-07,  -5.827672604627472e-09,   5.165057118903593e-11,
  -4.389503738666476e-13,   3.601690924186879e-15,  -2.904048904968579e-17,   2.254779206743179e-19,  -1.796445867282682e-21,   1.258888222428055e-23,  -1.092527586791652e-25,
   7.652444629664583e-28,   8.205713339037956e-31,   4.027947724554013e-03,  -5.749312075362312e-05,   6.143383418450566e-07,  -5.827905694291465e-09,   5.165343999367158e-11,
  -4.389827579901581e-13,   3.602026172748965e-15,  -2.904392341078505e-17,   2.255080052666085e-19,  -1.796764831994661e-21,   1.259156967850213e-23,  -1.092492461463640e-25,
   7.663543445047446e-28,   8.366001184952208e-31,   4.027959083245007e-03,  -5.749344392119950e-05,   6.143440698620784e-07,  -5.827986824628826e-09,   5.165443852828325e-11,
  -4.389940298804499e-13,   3.602142862579558e-15,  -2.904511881928813e-17,   2.255184769872263e-19,  -1.796875849769976e-21,   1.259250537572604e-23,  -1.092480183956448e-25,
   7.667406799158223e-28,   8.421764985005517e-31,   4.027960885716084e-03,  -5.749349520358111e-05,   6.143449788228873e-07,  -5.827999698959883e-09,   5.165459698296563e-11,
  -4.389958185884204e-13,   3.602161379814679e-15,  -2.904530851641724e-17,   2.255201387289404e-19,  -1.796893466723261e-21,   1.259265387242932e-23,  -1.092478233225789e-25,
   7.668019874936913e-28,   8.430612704571016e-31,   3.623972580702409e-02,  -5.128665819336899e-04,   5.372515937101274e-06,  -4.917105936871928e-08,   4.113755074037096e-10,
  -3.205886447285008e-12,   2.314437118302224e-14,  -1.553906048822286e-16,   8.988811039443006e-19,  -4.790127653618321e-21,   4.493112718643754e-24,   2.550947633030035e-27,
  -1.892640666396586e-27,   7.681832198688089e-29,   3.624022994429806e-02,  -5.128804218630597e-04,   5.372747519258226e-06,  -4.917406745592883e-08,   4.114080820209567e-10,
  -3.206192629071254e-12,   2.314673112438642e-14,  -1.554067705091273e-16,   8.988997048866443e-19,  -4.790091893173498e-21,   4.481999308514916e-24,   3.129371105840145e-27,
  -1.879761311478672e-27,   7.712186658373687e-29,   3.624111952013531e-02,  -5.129048433247967e-04,   5.373156164526953e-06,  -4.917937550666090e-08,   4.114655631446520e-10,
  -3.206732917532190e-12,   2.315089531759595e-14,  -1.554352948977262e-16,   8.989324889506562e-19,  -4.790026351472473e-21,   4.462454389706167e-24,   4.151803094191872e-27,
  -1.857028231884135e-27,   7.765673943482860e-29,   3.624219523490008e-02,  -5.129343751914868e-04,   5.373650328175102e-06,  -4.918579445651998e-08,   4.115350745358271e-10,
  -3.207386284243371e-12,   2.315593077189370e-14,  -1.554697866935628e-16,   8.989720678471986e-19,  -4.789942929081082e-21,   4.438931095027441e-24,   5.391195834246426e-27,
  -1.829526895903933e-27,   7.830225648645263e-29,   3.624323955175501e-02,  -5.129630454461604e-04,   5.374130080314623e-06,  -4.919202627894004e-08,   4.116025598106092e-10,
  -3.208020607550761e-12,   2.316081917424926e-14,  -1.555032705169759e-16,   8.990104235880115e-19,  -4.789857572129982e-21,   4.416210969157527e-24,   6.597574329348206e-27,
  -1.802816393412029e-27,   7.892759531767413e-29,   3.624408086246184e-02,  -5.129861427115903e-04,   5.374516581476080e-06,  -4.919704685283911e-08,   4.116569285235415e-10,
  -3.208531643270311e-12,   2.316475725807188e-14,  -1.555302444915325e-16,   8.990412747730457e-19,  -4.789785672587228e-21,   4.397990981383636e-24,   7.571705427416838e-27,
  -1.781289779270310e-27,   7.943041463309525e-29,   3.624463679666982e-02,  -5.130014054045538e-04,   5.374771983899174e-06,  -4.920036450493903e-08,   4.116928560912918e-10,
  -3.208869342782643e-12,   2.316735949839306e-14,  -1.555480683342887e-16,   8.990616373862715e-19,  -4.789736624784612e-21,   4.385992210232610e-24,   8.216513206706797e-27,
  -1.767061021551115e-27,   7.976220524319468e-29,   3.624492229891285e-02,  -5.130092436611104e-04,   5.374903148152811e-06,  -4.920206832328366e-08,   4.117113071392975e-10,
  -3.209042772654452e-12,   2.316869588094074e-14,  -1.555572217055612e-16,   8.990720873684716e-19,  -4.789710960395440e-21,   4.379842847205777e-24,   8.547998775599696e-27,
  -1.759752536025944e-27,   7.993245217156491e-29,   3.624502167112864e-02,  -5.130119718593276e-04,   5.374948801532366e-06,  -4.920266136006516e-08,   4.117177292787712e-10,
  -3.209103137307777e-12,   2.316916102233904e-14,  -1.555604076162730e-16,   8.990757234362299e-19,  -4.789701951855325e-21,   4.377704508017876e-24,   8.663430413849340e-27,
  -1.757208538567441e-27,   7.999168533131116e-29,   3.624503744015661e-02,  -5.130124047878197e-04,   5.374956046116786e-06,  -4.920275546717693e-08,   4.117187483878105e-10,
  -3.209112716384797e-12,   2.316923483393055e-14,  -1.555609131762361e-16,   8.990763003758067e-19,  -4.789700518724204e-21,   4.377365278127269e-24,   8.681750438087727e-27,
  -1.756804831152536e-27,   8.000108373338394e-29,   1.006213415905994e-01,  -1.399406920666827e-03,   1.405984685282036e-05,  -1.188258355929722e-07,   8.631318209003848e-10,
  -5.221526583851991e-12,   2.193432983331854e-14,   1.299411217986778e-18,  -1.456686396611153e-18,   1.853375985634854e-20,  -2.057550393195211e-22,   1.109288711354235e-24,
  -6.730218832282739e-27,   1.559593277063513e-28,   1.006226606736456e-01,  -1.399440357609848e-03,   1.406033253734622e-05,  -1.188307307336597e-07,   8.631626205309908e-10,
  -5.221523027949853e-12,   2.193048808195983e-14,   1.362113026214456e-18,  -1.457555684498343e-18,   1.853952583470613e-20,  -2.057945716706431e-22,   1.110470207926705e-24,
  -6.684709322483912e-27,   1.567063297538654e-28,   1.006249882535065e-01,  -1.399499358742027e-03,   1.406118954942011e-05,  -1.188393682835246e-07,   8.632169625652575e-10,
  -5.221516653069673e-12,   2.192370739521115e-14,   1.472767210244915e-18,  -1.459089690406745e-18,   1.854970498918504e-20,  -2.058640978656947e-22,   1.112559389034599e-24,
  -6.604377234775227e-27,   1.580222638272318e-28,   1.006278028511594e-01,  -1.399570705451491e-03,   1.406222588159548e-05,  -1.188498128961351e-07,   8.632826660325112e-10,
  -5.221508773229136e-12,   2.191550495145058e-14,   1.606598478832628e-18,  -1.460944854267806e-18,   1.856202226098155e-20,  -2.059477786746766e-22,   1.115093162836297e-24,
  -6.507188265732098e-27,   1.596098137321046e-28,   1.006305352800404e-01,  -1.399639969602205e-03,   1.406323196008308e-05,  -1.188599523399862e-07,   8.633464419641598e-10,
  -5.221500944244643e-12,   2.190753884653660e-14,   1.736547893154572e-18,  -1.462746052806959e-18,   1.857398860327037e-20,  -2.060286049667178e-22,   1.117560763556854e-24,
  -6.412786385093675e-27,   1.611471088899508e-28,   1.006327365366468e-01,  -1.399695769334412e-03,   1.406404246184853e-05,  -1.188681205402702e-07,   8.633978133944913e-10,
  -5.221494508781648e-12,   2.190111908101257e-14,   1.841253762165991e-18,  -1.464197244663951e-18,   1.858363495557924e-20,  -2.060934240177275e-22,   1.119554252141198e-24,
  -6.336700131809624e-27,   1.623827569658809e-28,   1.006341911110237e-01,  -1.399732641505128e-03,   1.406457803579895e-05,  -1.188735179396164e-07,   8.634317559629801e-10,
  -5.221490193401901e-12,   2.189687585138385e-14,   1.910451483285786e-18,  -1.465156249303362e-18,   1.859001224257852e-20,  -2.061361115216952e-22,   1.120874263121397e-24,
  -6.286405535809232e-27,   1.631978901470168e-28,   1.006349381117478e-01,  -1.399751577346071e-03,   1.406485308137707e-05,  -1.188762897618483e-07,   8.634491862430892e-10,
  -5.221487957781653e-12,   2.189469639027522e-14,   1.945990901361030e-18,  -1.465648769672064e-18,   1.859328825949904e-20,  -2.061579891275757e-22,   1.121553001460774e-24,
  -6.260571265245356e-27,   1.636160788202901e-28,   1.006351981133342e-01,  -1.399758168173468e-03,   1.406494881394367e-05,  -1.188772545198656e-07,   8.634552528759096e-10,
  -5.221487176554376e-12,   2.189393775161725e-14,   1.958361211256494e-18,  -1.465820199968542e-18,   1.859442866248181e-20,  -2.061655967482987e-22,   1.121789377742465e-24,
  -6.251578523298985e-27,   1.637615661326278e-28,   1.006352393720594e-01,  -1.399759214048646e-03,   1.406496400540415e-05,  -1.188774076136716e-07,   8.634562155605404e-10,
  -5.221487052437236e-12,   2.189381736339203e-14,   1.960324232332123e-18,  -1.465847403788841e-18,   1.859460963610328e-20,  -2.061668036367923e-22,   1.121826893819474e-24,
  -6.250151456916180e-27,   1.637846497801265e-28,   1.970414238826215e-01,  -2.665300606820165e-03,   2.497665622275075e-05,  -1.821679929045270e-07,   9.494278008738609e-10,
  -1.521364012166212e-12,  -4.033593485053480e-14,   6.239989299039924e-16,  -5.741393821931947e-18,   2.881478974873166e-20,  -3.779358271274068e-23,  -2.970510673273190e-24,
   3.515721712745903e-26,  -8.534391209533730e-31,   1.970437665109778e-01,  -2.665351846452824e-03,   2.497718995356041e-05,  -1.821694088371282e-07,   9.493709003049181e-10,
  -1.520133977043338e-12,  -4.035100910289396e-14,   6.240957804759616e-16,  -5.741546101639752e-18,   2.879947704106914e-20,  -3.757154727132958e-23,  -2.970423491798234e-24,
   3.525428921762545e-26,   8.454178061135361e-31,   1.970479001562707e-01,  -2.665442259914070e-03,   2.497813170392133e-05,  -1.821719063345200e-07,   9.492704811189494e-10,
  -1.517963405863223e-12,  -4.037760817935682e-14,   6.242666328233138e-16,  -5.741814036074165e-18,   2.877245798801959e-20,  -3.717927350621584e-23,  -2.970259612912740e-24,
   3.542561219231236e-26,   3.839075085857197e-30,   1.970528986737289e-01,  -2.665551589388606e-03,   2.497927043409855e-05,  -1.821749247356740e-07,   9.491490237756863e-10,
  -1.515338464005312e-12,  -4.040977261308073e-14,   6.244731576767934e-16,  -5.742136718855603e-18,   2.873978707435535e-20,  -3.670409841704542e-23,  -2.970044336240931e-24,
   3.563284142742412e-26,   7.452204850878220e-30,   1.970577512206309e-01,  -2.665657725126997e-03,   2.498037584711877e-05,  -1.821778532723110e-07,   9.490310843113318e-10,
  -1.512789939492493e-12,  -4.044099785918753e-14,   6.246735734202301e-16,  -5.742448604199345e-18,   2.870807160595241e-20,  -3.624193371392682e-23,  -2.969817450145892e-24,
   3.583408176459609e-26,   1.095260343816458e-29,   1.970616604213837e-01,  -2.665743227110919e-03,   2.498126632013336e-05,  -1.821802112631703e-07,   9.489360517600464e-10,
  -1.510736683292008e-12,  -4.046615291922176e-14,   6.248349719938478e-16,  -5.742698872689955e-18,   2.868252269987529e-20,  -3.586899426084092e-23,  -2.969621863663697e-24,
   3.599624487285059e-26,   1.376733796664400e-29,   1.970642435770979e-01,  -2.665799725501063e-03,   2.498185471251262e-05,  -1.821817687938592e-07,   9.488732451454832e-10,
  -1.509379831244837e-12,  -4.048277513405519e-14,   6.249415949824903e-16,  -5.742863764279301e-18,   2.866564077282979e-20,  -3.562225616943406e-23,  -2.969486357442355e-24,
   3.610342188675401e-26,   1.562474431323923e-29,   1.970655701590416e-01,  -2.665828740190313e-03,   2.498215687510368e-05,  -1.821825684786460e-07,   9.488409876044354e-10,
  -1.508682992823496e-12,  -4.049131149825948e-14,   6.249963428512433e-16,  -5.742948295042846e-18,   2.865697120132809e-20,  -3.549544960420811e-23,  -2.969414831916913e-24,
   3.615846932279177e-26,   1.657783137044649e-29,   1.970660318892909e-01,  -2.665838839028573e-03,   2.498226204475673e-05,  -1.821828467873244e-07,   9.488297595402477e-10,
  -1.508440447058208e-12,  -4.049428266778450e-14,   6.250153970528132e-16,  -5.742977693027074e-18,   2.865395369461546e-20,  -3.545129833286801e-23,  -2.969389628607013e-24,
   3.617763018251144e-26,   1.690943782098341e-29,   1.970661051595820e-01,  -2.665840441575595e-03,   2.498227873369408e-05,  -1.821828909497051e-07,   9.488279777758590e-10,
  -1.508401958159151e-12,  -4.049475415193309e-14,   6.250184206306812e-16,  -5.742982356955968e-18,   2.865347485867101e-20,  -3.544429141801415e-23,  -2.969385614560063e-24,
   3.618067079897158e-26,   1.696205329911561e-29,   3.251784870286910e-01,  -4.224123886847033e-03,   3.549575412239344e-05,  -1.952125484435223e-07,   2.049715021188138e-10,
   1.014365581760495e-11,  -1.375691846964576e-13,   9.024738415213397e-16,  -5.186390447692275e-19,  -7.696106906803566e-20,   9.283596190188041e-22,  -7.508209183107205e-24,
  -3.537913101304825e-27,   1.182079648619383e-27,   3.251818149783477e-01,  -4.224178756716757e-03,   3.549586832655059e-05,  -1.952030238854326e-07,   2.047780308144476e-10,
   1.014542840982280e-11,  -1.375704652480001e-13,   9.022130995865720e-16,  -5.147231170936026e-19,  -7.699943835439338e-20,   9.283410126040634e-22,  -7.499375957800213e-24,
  -3.467187486599618e-27,   1.185521581099611e-27,   3.251876872065345e-01,  -4.224275573286098e-03,   3.549606975310482e-05,  -1.951862163028175e-07,   2.044366462168853e-10,
   1.014855575888904e-11,  -1.375727164446035e-13,   9.017529113070768e-16,  -5.078134619256380e-19,  -7.706710434207385e-20,   9.283085382410624e-22,  -7.483769238010810e-24,
  -3.342284816159982e-27,   1.191586923603137e-27,   3.251947879823674e-01,  -4.224392641200635e-03,   3.549631316938410e-05,  -1.951658900926436e-07,   2.040238378696278e-10,
   1.015233667031628e-11,  -1.375754243667403e-13,   9.011962677015514e-16,  -4.994583359319775e-19,  -7.714886325298122e-20,   9.282698788804491e-22,  -7.464862751793720e-24,
  -3.191071214105716e-27,   1.198907542360353e-27,   3.252016813080906e-01,  -4.224506284814477e-03,   3.549654931571249e-05,  -1.951461553496180e-07,   2.036230881204318e-10,
   1.015600636743605e-11,  -1.375780382495288e-13,   9.006557003452534e-16,  -4.913474308870586e-19,  -7.722816679203230e-20,   9.282329872228373e-22,  -7.446472393827005e-24,
  -3.044088669564151e-27,   1.205999950527985e-27,   3.252072344927229e-01,  -4.224597831843757e-03,   3.549673943892974e-05,  -1.951302555706860e-07,   2.033002475117513e-10,
   1.015896209292782e-11,  -1.375801332686353e-13,   9.002200921190990e-16,  -4.848134669114957e-19,  -7.729200492335875e-20,   9.282037253572299e-22,  -7.431631403863409e-24,
  -2.925548484338609e-27,   1.211703227386191e-27,   3.252109039436227e-01,  -4.224658323124637e-03,   3.549686501354190e-05,  -1.951197484347040e-07,   2.030869192988256e-10,
   1.016091492179202e-11,  -1.375815123854327e-13,   8.999321842839902e-16,  -4.804959766487357e-19,  -7.733416461350193e-20,   9.281846138066163e-22,  -7.421812044865867e-24,
  -2.847154554654375e-27,   1.215466814856022e-27,   3.252127883839129e-01,  -4.224689387869549e-03,   3.549692948497369e-05,  -1.951143522562267e-07,   2.029773647793991e-10,
   1.016191771185356e-11,  -1.375822190090832e-13,   8.997843095282736e-16,  -4.782787501095776e-19,  -7.735580838746199e-20,   9.281748684645098e-22,  -7.416765409989410e-24,
  -2.806875603717618e-27,   1.217398038438337e-27,   3.252134442808799e-01,  -4.224700200171278e-03,   3.549695192211722e-05,  -1.951124740252768e-07,   2.029392332819538e-10,
   1.016226672922171e-11,  -1.375824646981991e-13,   8.997328371330125e-16,  -4.775070259002723e-19,  -7.736334054751046e-20,   9.281714875525520e-22,  -7.415008257994291e-24,
  -2.792852982994521e-27,   1.218069970248114e-27,   3.252135483627080e-01,  -4.224701915931463e-03,   3.549695548245334e-05,  -1.951121759739170e-07,   2.029331823363919e-10,
   1.016232211285905e-11,  -1.375825036734435e-13,   8.997246690193344e-16,  -4.773845639815944e-19,  -7.736453574279814e-20,   9.281709515727122e-22,  -7.414729392529574e-24,
  -2.790627636209569e-27,   1.218176584785321e-27,   4.843253882771002e-01,  -5.943234509552087e-03,   4.205257650323278e-05,  -1.126307263074144e-07,  -1.517576035536853e-09,
   2.381052550298165e-11,  -1.316409202874366e-13,  -6.930370957579174e-16,   1.987292232046227e-17,  -1.731352573073340e-19,  -1.826172394981578e-22,   1.706687510956619e-23,
  -2.175314954596567e-25,   1.405033266508991e-27,   4.843293289826804e-01,  -5.943266108298490e-03,   4.205172182726701e-05,  -1.126084155421496e-07,  -1.517760538529989e-09,
   2.380915183620522e-11,  -1.315887708899611e-13,  -6.936191199514516e-16,   1.987210927180693e-17,  -1.730468518412972e-19,  -1.839458961518542e-22,   1.707725615785504e-23,
  -2.171582071467596e-25,   1.406982780478200e-27,   4.843362823545091e-01,  -5.943321859684958e-03,   4.205021365382648e-05,  -1.125690488951041e-07,  -1.518086037353865e-09,
   2.380672704908011e-11,  -1.314967542172962e-13,  -6.946458679401662e-16,   1.987067009277807e-17,  -1.728908153767707e-19,  -1.862884507355155e-22,   1.709558513459590e-23,
  -2.164992426810535e-25,   1.410412616153405e-27,   4.843446903349086e-01,  -5.943389266163684e-03,   4.204838981074747e-05,  -1.125214481144215e-07,  -1.518479532370820e-09,
   2.380379338428734e-11,  -1.313854896803937e-13,  -6.958870084050453e-16,   1.986892208224838e-17,  -1.727020599930303e-19,  -1.891178845423423e-22,   1.711776821732907e-23,
  -2.157019211465070e-25,   1.414542745906962e-27,   4.843528525403811e-01,  -5.943454694102924e-03,   4.204661910506167e-05,  -1.124752399751066e-07,  -1.518861424088665e-09,
   2.380094377247699e-11,  -1.312774791511283e-13,  -6.970914522611166e-16,   1.986721704441183e-17,  -1.725187415564744e-19,  -1.918612890220731e-22,   1.713932352513520e-23,
  -2.149273799270285e-25,   1.418534097832984e-27,   4.843594278235928e-01,  -5.943507395477457e-03,   4.204519253984687e-05,  -1.124380166425590e-07,  -1.519168994832562e-09,
   2.379864697253371e-11,  -1.311904695414025e-13,  -6.980614256619522e-16,   1.986583768883982e-17,  -1.723710067080823e-19,  -1.940689310484767e-22,   1.715670274787554e-23,
  -2.143030523233380e-25,   1.421736486317259e-27,   4.843637726127832e-01,  -5.943542216413404e-03,   4.204424983821974e-05,  -1.124134207855401e-07,  -1.519372194763712e-09,
   2.379712870562181e-11,  -1.311329762541921e-13,  -6.987022145479870e-16,   1.986492339738326e-17,  -1.722733587701748e-19,  -1.955265217317600e-22,   1.716819373625063e-23,
  -2.138903287157262e-25,   1.423846198167200e-27,   4.843660038572983e-01,  -5.943560097642526e-03,   4.204376569951667e-05,  -1.124007898396278e-07,  -1.519476536104341e-09,
   2.379634882281632e-11,  -1.311034510449348e-13,  -6.990312432081016e-16,   1.986445298767909e-17,  -1.722232034111589e-19,  -1.962746993385925e-22,   1.717409710348101e-23,
  -2.136783201878735e-25,   1.424927664682826e-27,   4.843667804603750e-01,  -5.943566321210846e-03,   4.204359718801087e-05,  -1.123963935556388e-07,  -1.519512851225223e-09,
   2.379607734879361e-11,  -1.310931745803880e-13,  -6.991457571484937e-16,   1.986428911763779e-17,  -1.722057450303871e-19,  -1.965350512986383e-22,   1.717615217364824e-23,
  -2.136045199038843e-25,   1.425303764999323e-27,   4.843669036964923e-01,  -5.943567308797961e-03,   4.204357044743240e-05,  -1.123956959274549e-07,  -1.519518613847499e-09,
   2.379603426824398e-11,  -1.310915438496023e-13,  -6.991639285777594e-16,   1.986426310709073e-17,  -1.722029745617650e-19,  -1.965763628103751e-22,   1.717647830154998e-23,
  -2.135928083989599e-25,   1.425363432029828e-27,   6.730371912209993e-01,  -7.627088809861167e-03,   4.035327666432550e-05,   9.102903045174214e-08,  -3.575580049044173e-09,
   2.211613014134163e-11,   1.447436708395782e-13,  -3.664751414025204e-15,   1.811315902802238e-17,   2.305555387309686e-19,  -4.719179061321574e-21,   1.419548086266081e-23,
   4.010635040727798e-25,  -5.120204942849245e-27,   6.730409702981228e-01,  -7.627063135191776e-03,   4.035126655688036e-05,   9.104970373809147e-08,  -3.575375946846903e-09,
   2.210892758703904e-11,   1.447908085209531e-13,  -3.663971425248373e-15,   1.809333058459597e-17,   2.306273120405575e-19,  -4.716676924455296e-21,   1.415881377461335e-23,
   4.015078038456319e-25,  -5.106147340938567e-27,   6.730476383861884e-01,  -7.627017827116473e-03,   4.034771978408722e-05,   9.108617659173733e-08,  -3.575015751572580e-09,
   2.209621981583886e-11,   1.448739414349037e-13,  -3.662594926865306e-15,   1.805835158374617e-17,   2.307538042583958e-19,  -4.712259633792563e-21,   1.409419746361494e-23,
   4.022913904393405e-25,  -5.081359501779893e-27,   6.730557012487021e-01,  -7.626963032065259e-03,   4.034343114782889e-05,   9.113027060375149e-08,  -3.574580108006383e-09,
   2.208085557328677e-11,   1.449743945875704e-13,  -3.660930116546703e-15,   1.801606927029613e-17,   2.309064995040425e-19,  -4.706914396374944e-21,   1.401620476651256e-23,
   4.032382490297675e-25,  -5.051414854456293e-27,   6.730635282629401e-01,  -7.626909829557142e-03,   4.033926798082267e-05,   9.117306651453628e-08,  -3.574157096901228e-09,
   2.206594246352625e-11,   1.450718373299893e-13,  -3.659313598355235e-15,   1.797503769928419e-17,   2.310544609216088e-19,  -4.701721352354009e-21,   1.394063945647158e-23,
   4.041567461446912e-25,  -5.022375618924348e-27,   6.730698334081393e-01,  -7.626866964275686e-03,   4.033591430717457e-05,   9.120753532780663e-08,  -3.573816255993568e-09,
   2.205393025490018e-11,   1.451502818954045e-13,  -3.658011102412813e-15,   1.794199421435672e-17,   2.311734616965551e-19,  -4.697535053140288e-21,   1.387987146991555e-23,
   4.048961742022626e-25,  -4.999003894395642e-27,   6.730739996399551e-01,  -7.626838636707808e-03,   4.033369831791298e-05,   9.123030827063743e-08,  -3.573591000786660e-09,
   2.204599358425188e-11,   1.452020902116195e-13,  -3.657150314038493e-15,   1.792016506333858e-17,   2.312519998889624e-19,  -4.694767426016174e-21,   1.383976915959759e-23,
   4.053845288431743e-25,  -4.983571019398973e-27,   6.730761391697098e-01,  -7.626824088232945e-03,   4.033256031950173e-05,   9.124200220419063e-08,  -3.573475311069129e-09,
   2.204191796622960e-11,   1.452286880804019e-13,  -3.656708220233529e-15,   1.790895641871606e-17,   2.312923035238878e-19,  -4.693345685694834e-21,   1.381919080913866e-23,
   4.056352459913872e-25,  -4.975648826333323e-27,   6.730768838479171e-01,  -7.626819024357640e-03,   4.033216423161580e-05,   9.124607221574876e-08,  -3.573435042549499e-09,
   2.204049944859949e-11,   1.452379444099427e-13,  -3.656554339422278e-15,   1.790505541303858e-17,   2.313063268807377e-19,  -4.692850767291262e-21,   1.381203088922020e-23,
   4.057224982241301e-25,  -4.972891964449364e-27,   6.730770020178688e-01,  -7.626818220783468e-03,   4.033210137806017e-05,   9.124671806250201e-08,  -3.573428652411505e-09,
   2.204027435121768e-11,   1.452394132001394e-13,  -3.656529920371357e-15,   1.790443638977888e-17,   2.313085519716077e-19,  -4.692772227297192e-21,   1.381089483022090e-23,
   4.057363433739052e-25,  -4.972454513602610e-27,   8.885010302010189e-01,  -8.997013284766089e-03,   2.619381010966653e-05,   3.824473943704572e-07,  -4.140666261428302e-09,
  -1.431420142250723e-11,   5.464811289466423e-13,  -1.840054651350866e-15,  -5.870324484725665e-17,   6.279262138597394e-19,   3.365182144583978e-21,  -1.204047131057218e-22,
   3.070853679080481e-25,   1.671290097213603e-26,   8.885034811991173e-01,  -8.996905769028085e-03,   2.619148531605233e-05,   3.824339446890614e-07,  -4.139899592227635e-09,
  -1.431779060473218e-11,   5.463273278493043e-13,  -1.837951445652189e-15,  -5.868898834607261e-17,   6.273101322153822e-19,   3.367043806977310e-21,  -1.202825284116795e-22,
   3.062516020752904e-25,   1.671243504544808e-26,   8.885078058472078e-01,  -8.996716058894702e-03,   2.618738353126575e-05,   3.824102097889362e-07,  -4.138546968064277e-09,
  -1.432412041483062e-11,   5.460559738507801e-13,  -1.834241993016551e-15,  -5.866382617348146e-17,   6.262235586188665e-19,   3.370324579634703e-21,  -1.200669347746188e-22,
   3.047835110526837e-25,   1.671158245302511e-26,   8.885130349567657e-01,  -8.996486664622631e-03,   2.618242420620197e-05,   3.823815046482811e-07,  -4.136911660036661e-09,
  -1.433176876432564e-11,   5.457279016378867e-13,  -1.829759358609257e-15,  -5.863338898461424e-17,   6.249105354767840e-19,   3.374284642612876e-21,  -1.198062421876491e-22,
   3.030135611607719e-25,   1.671049953291027e-26,   8.885181109705024e-01,  -8.996263978130484e-03,   2.617761040430028e-05,   3.823536333317820e-07,  -4.135324444979346e-09,
  -1.433918765733033e-11,   5.454094692168498e-13,  -1.825410704534794e-15,  -5.860382976935352e-17,   6.236367897958807e-19,   3.378121600177948e-21,  -1.195531722993567e-22,
   3.013008455055042e-25,   1.670939381452576e-26,   8.885221999152594e-01,  -8.996084588726784e-03,   2.617373291586650e-05,   3.823311770790219e-07,  -4.134046029890808e-09,
  -1.434515992926066e-11,   5.451529831882526e-13,  -1.821909641019001e-15,  -5.858000914850939e-17,   6.226113320357407e-19,   3.381207308605310e-21,  -1.193493068722898e-22,
   2.999250530828320e-25,   1.670846403612260e-26,   8.885249017065143e-01,  -8.995966053333025e-03,   2.617117095980750e-05,   3.823163366826793e-07,  -4.133201385994826e-09,
  -1.434910419945359e-11,   5.449835208829277e-13,  -1.819597255732827e-15,  -5.856426494344228e-17,   6.219340486132404e-19,   3.383243701195617e-21,  -1.192145984214083e-22,
   2.990178847738999e-25,   1.670783053839476e-26,   8.885262891713974e-01,  -8.995905180333056e-03,   2.616985534057858e-05,   3.823087149020537e-07,  -4.132767654962472e-09,
  -1.435112912140395e-11,   5.448964997861424e-13,  -1.818410061474635e-15,  -5.855617831591212e-17,   6.215863303777602e-19,   3.384288686510060e-21,  -1.191454198737124e-22,
   2.985526069799268e-25,   1.670749929316397e-26,   8.885267720858112e-01,  -8.995883993022915e-03,   2.616939743805016e-05,   3.823060619876191e-07,  -4.132616696321011e-09,
  -1.435183381064066e-11,   5.448662122367140e-13,  -1.817996899570678e-15,  -5.855336349620675e-17,   6.214653196556975e-19,   3.384652275975138e-21,  -1.191213417569599e-22,
   2.983907577007691e-25,   1.670738305857624e-26,   8.885268487174193e-01,  -8.995880630893099e-03,   2.616932477573758e-05,   3.823056410026525e-07,  -4.132592741520776e-09,
  -1.435194563020929e-11,   5.448614060643836e-13,  -1.817931338931816e-15,  -5.855291681383285e-17,   6.214461176704903e-19,   3.384709966576626e-21,  -1.191175208966939e-22,
   2.983650789542079e-25,   1.670736456904144e-26,   1.125416216441294e+00,  -9.677266876922072e-03,  -2.318120724998594e-06,   6.166286250815274e-07,  -7.817855369442416e-10,
  -6.974446928307309e-11,   2.569275199602607e-13,   9.122255411142374e-15,  -6.365282207091551e-17,  -1.280059581240135e-18,   1.343572958480253e-20,   1.661446000649433e-22,
  -2.890635544539105e-24,  -1.936194623306383e-26,   1.125415998239240e+00,  -9.677093680207109e-03,  -2.318558451200246e-06,   6.165633901259958e-07,  -7.814261938157720e-10,
  -6.972657819387872e-11,   2.567615888727027e-13,   9.117957387802464e-15,  -6.359670573458580e-17,  -1.279208316315457e-18,   1.341810078728952e-20,   1.660050715558458e-22,
  -2.885078790993975e-24,  -1.932464354117801e-26,   1.125415613185157e+00,  -9.676788086764577e-03,  -2.319330662109405e-06,   6.164482956343538e-07,  -7.807923164550007e-10,
  -6.969501595356640e-11,   2.564689202713410e-13,   9.110375789688654e-15,  -6.349774781349255e-17,  -1.277706828748058e-18,   1.338702236603130e-20,   1.657590925771542e-22,
  -2.875281344728575e-24,  -1.925885883236475e-26,   1.125415147517168e+00,  -9.676418585287930e-03,  -2.320264148456003e-06,   6.163091453541420e-07,  -7.800261477585280e-10,
  -6.965686226335639e-11,   2.561152257928277e-13,   9.101212014866530e-15,  -6.337818948201463e-17,  -1.275892206999514e-18,   1.334948950051629e-20,   1.654620293029992e-22,
  -2.863447006428498e-24,  -1.917937362617390e-26,   1.125414695395615e+00,  -9.676059906224560e-03,  -2.321170068400709e-06,   6.161740849702671e-07,  -7.792827021348615e-10,
  -6.961983557858814e-11,   2.557720783290089e-13,   9.092320141686259e-15,  -6.326223172783279e-17,  -1.274131642730987e-18,   1.331310294606263e-20,   1.651740401592308e-22,
  -2.851971872755819e-24,  -1.910227628859591e-26,   1.125414331130011e+00,  -9.675770978073794e-03,  -2.321899656246835e-06,   6.160652994886409e-07,  -7.786840338743381e-10,
  -6.959001614282404e-11,   2.554957957390452e-13,   9.085159944495966e-15,  -6.316889456520511e-17,  -1.272714099002198e-18,   1.328382599876969e-20,   1.649423225450961e-22,
  -2.842737276891688e-24,  -1.904021477553268e-26,   1.125414090409051e+00,  -9.675580068819654e-03,  -2.322381652352834e-06,   6.159934245020546e-07,  -7.782885629426707e-10,
  -6.957031628886246e-11,   2.553133077833256e-13,   9.080430072539584e-15,  -6.310725665757982e-17,  -1.271777775386494e-18,   1.326449772886900e-20,   1.647893460337743e-22,
  -2.836639929899294e-24,  -1.899922875537947e-26,   1.125413966780908e+00,  -9.675482030665362e-03,  -2.322629148707338e-06,   6.159565158924963e-07,  -7.780855063026575e-10,
  -6.956020080024133e-11,   2.552196145682054e-13,   9.078001508034578e-15,  -6.307561427410249e-17,  -1.271297040938245e-18,   1.325457712129648e-20,   1.647108280530393e-22,
  -2.833510106478726e-24,  -1.897818763661234e-26,   1.125413923749980e+00,  -9.675447908046819e-03,  -2.322715287032380e-06,   6.159436699324348e-07,  -7.780148364066458e-10,
  -6.955668022335161e-11,   2.551870074607277e-13,   9.077156295720450e-15,  -6.306460270403900e-17,  -1.271129734821639e-18,   1.325112501991787e-20,   1.646835059599916e-22,
  -2.832420974535034e-24,  -1.897086522415926e-26,   1.125413916921516e+00,  -9.675442493278983e-03,  -2.322728955758628e-06,   6.159416314754049e-07,  -7.780036223440486e-10,
  -6.955612156632849e-11,   2.551818333362512e-13,   9.077022175575180e-15,  -6.306285540740098e-17,  -1.271103186495297e-18,   1.325057725965024e-20,   1.646791706433447e-22,
  -2.832248155296973e-24,  -1.896970331236878e-26,   1.374061725718410e+00,  -9.222610840688029e-03,  -4.007864847098248e-05,   5.270249554441619e-07,   6.103952858131209e-09,
  -5.134466930742471e-11,  -1.081224088979630e-12,   5.029795019519812e-15,   2.015639323245394e-16,  -3.393169618453722e-19,  -3.973934701540835e-20,  -6.519982691000162e-23,
   7.603732812338633e-24,   3.718141227109272e-26,   1.374057975227612e+00,  -9.222462784448094e-03,  -4.007522354830821e-05,   5.269769029952464e-07,   6.102438601023106e-09,
  -5.133478528696262e-11,  -1.080698411767263e-12,   5.028641374496995e-15,   2.013977753581352e-16,  -3.396427843206341e-19,  -3.969282840487368e-20,  -6.493273250996273e-23,
   7.592273610963985e-24,   3.709409428293125e-26,   1.374051357687524e+00,  -9.222201547852698e-03,  -4.006918090930828e-05,   5.268921212197483e-07,   6.099767270146505e-09,
  -5.131734662777233e-11,  -1.079771199739249e-12,   5.026604863258224e-15,   2.011047478603811e-16,  -3.402165884314656e-19,  -3.961080296831407e-20,  -6.446195528982568e-23,
   7.572077229519214e-24,   3.694032162654303e-26,   1.374043356130503e+00,  -9.221885676472448e-03,  -4.006187526358669e-05,   5.267896150233940e-07,   6.096538090421141e-09,
  -5.129626277081739e-11,  -1.078650607874960e-12,   5.024140782731418e-15,   2.007506869952188e-16,  -3.409085391855049e-19,  -3.951171469682109e-20,  -6.389356343020714e-23,
   7.547695678171035e-24,   3.675489080364211e-26,   1.374035588821480e+00,  -9.221579053587356e-03,  -4.005478430244760e-05,   5.266901172191082e-07,   6.093404328634379e-09,
  -5.127579823367315e-11,  -1.077563387668833e-12,   5.021747118067570e-15,   2.004072545746759e-16,  -3.415782859403494e-19,  -3.941562379113847e-20,  -6.334269526851081e-23,
   7.524068458810354e-24,   3.657541335909179e-26,   1.374029331910780e+00,  -9.221332056208703e-03,  -4.004907279982961e-05,   5.266099727083862e-07,   6.090880577289504e-09,
  -5.125931463844217e-11,  -1.076687989094480e-12,   5.019817684229365e-15,   2.001307930597195e-16,  -3.421164028167210e-19,  -3.933828741274095e-20,  -6.289957884393796e-23,
   7.505064710542814e-24,   3.643121147985098e-26,   1.374025197618409e+00,  -9.221168851610036e-03,  -4.004529917314376e-05,   5.265570193564471e-07,   6.089213302507839e-09,
  -5.124842373300352e-11,  -1.076109762481817e-12,   5.018542196829544e-15,   1.999482116476632e-16,  -3.424712849507258e-19,  -3.928722072568312e-20,  -6.260709606219207e-23,
   7.492522061552926e-24,   3.633611250842118e-26,   1.374023074511789e+00,  -9.221085040363791e-03,  -4.004336136901845e-05,   5.265298267339719e-07,   6.088357193127896e-09,
  -5.124283109096467e-11,  -1.075812883830203e-12,   5.017887002503765e-15,   1.998544780962705e-16,  -3.426533188033923e-19,  -3.926100660802173e-20,  -6.245699123155711e-23,
   7.486085350697027e-24,   3.628733240684361e-26,   1.374022335553100e+00,  -9.221055869430186e-03,  -4.004268691983695e-05,   5.265203623247214e-07,   6.088059234883113e-09,
  -5.124088457784941e-11,  -1.075709563381548e-12,   5.017658928986543e-15,   1.998218581682325e-16,  -3.427166431181346e-19,  -3.925188430604696e-20,  -6.240476163478283e-23,
   7.483845716949034e-24,   3.627036323581860e-26,   1.374022218290913e+00,  -9.221051240420827e-03,  -4.004257989505120e-05,   5.265188604643343e-07,   6.088011953889767e-09,
  -5.124057569573967e-11,  -1.075693168366002e-12,   5.017622735572685e-15,   1.998166820671659e-16,  -3.427266901897380e-19,  -3.925043680598232e-20,  -6.239647426529999e-23,
   7.483490352207328e-24,   3.626767089821809e-26,   1.617273948168017e+00,  -7.282410964608874e-03,  -6.882404721235149e-05,  -5.229671721789741e-08,   7.968518590651179e-09,
   8.627101231107868e-11,  -4.904413851143719e-13,  -2.112526361421873e-14,  -1.263831576543657e-16,   2.985787326241771e-18,   5.850194855064395e-20,  -3.682234344584296e-23,
  -1.382413624279951e-23,  -1.441532427768345e-25,   1.617267504916207e+00,  -7.282425389452610e-03,  -6.881956884630682e-05,  -5.221618647777937e-08,   7.967825052837233e-09,
   8.622958220593967e-11,  -4.907681075891351e-13,  -2.111519274124289e-14,  -1.261390773180998e-16,   2.985557813263318e-18,   5.841711127833081e-20,  -3.784606537759042e-23,
  -1.380907106921540e-23,  -1.436008308046422e-25,   1.617256136037721e+00,  -7.282450823963257e-03,  -6.881166701691988e-05,  -5.207412024609881e-08,   7.966600922875095e-09,
   8.615649424890035e-11,  -4.913440952948691e-13,  -2.109742318598032e-14,  -1.257086840824232e-16,   2.985148573576808e-18,   5.826749057512893e-20,  -3.964916914525260e-23,
  -1.378246873333616e-23,  -1.426271606844982e-25,   1.617242389249283e+00,  -7.282481548356729e-03,  -6.880211258264555e-05,  -5.190238598710912e-08,   7.965120058677907e-09,
   8.606814298741538e-11,  -4.920397008576733e-13,  -2.107593718072070e-14,  -1.251887428880676e-16,   2.984646461559365e-18,   5.808669727264470e-20,  -4.182393075367279e-23,
  -1.375026760291875e-23,  -1.414516118366838e-25,   1.617229044713312e+00,  -7.282511342307281e-03,  -6.879283787122237e-05,  -5.173572561302610e-08,   7.963681798819015e-09,
   8.598240188489031e-11,  -4.927140565527869e-13,  -2.105508013308183e-14,  -1.246845110079077e-16,   2.984151434465504e-18,   5.791132211786211e-20,  -4.392932361662121e-23,
  -1.371897258038138e-23,  -1.403123187307148e-25,   1.617218294964490e+00,  -7.282535320459260e-03,  -6.878536669137232e-05,  -5.160150649396480e-08,   7.962522681044129e-09,
   8.591335058260530e-11,  -4.932566455330032e-13,  -2.103827882963238e-14,  -1.242786793689646e-16,   2.983747220549228e-18,   5.777013957232153e-20,  -4.562122885807789e-23,
  -1.369373694468507e-23,  -1.393958869687491e-25,   1.617211191935349e+00,  -7.282551153306592e-03,  -6.878043006816966e-05,  -5.151283662536515e-08,   7.961756524566590e-09,
   8.586773280547347e-11,  -4.936148540996393e-13,  -2.102717725299557e-14,  -1.240106946411309e-16,   2.983477469616633e-18,   5.767689637424512e-20,  -4.673716862422468e-23,
  -1.367704959965776e-23,  -1.387909949261468e-25,   1.617207544256006e+00,  -7.282559280678775e-03,  -6.877789493760541e-05,  -5.146730650748880e-08,   7.961362994808124e-09,
   8.584430901557695e-11,  -4.937987109961048e-13,  -2.102147619436809e-14,  -1.238731278051740e-16,   2.983338119685410e-18,   5.762902629129616e-20,  -4.730962620482065e-23,
  -1.366847612076776e-23,  -1.384805610331093e-25,   1.617206274658311e+00,  -7.282562108919565e-03,  -6.877701257201349e-05,  -5.145146030445376e-08,   7.961226011752263e-09,
   8.583615664791936e-11,  -4.938626881009389e-13,  -2.101949190979983e-14,  -1.238252553451485e-16,   2.983289487197654e-18,   5.761236702093713e-20,  -4.750877490038108e-23,
  -1.366549145011347e-23,  -1.383725446457297e-25,   1.617206073191141e+00,  -7.282562557695579e-03,  -6.877687255321227e-05,  -5.144894577638615e-08,   7.961204273885792e-09,
   8.583486300303892e-11,  -4.938728396281989e-13,  -2.101917703216946e-14,  -1.238176590692982e-16,   2.983281763699180e-18,   5.760972353575651e-20,  -4.754037228956476e-23,
  -1.366501779585981e-23,  -1.383554054979491e-25,   1.827024294200227e+00,  -4.058059085124555e-03,  -6.110684335591430e-05,  -6.180720794468863e-07,  -2.359423868528990e-09,
   5.730691035631527e-11,   1.455889402604592e-12,   1.563294181354629e-14,  -9.837649373276217e-18,  -3.640181433563567e-18,  -6.940216633808737e-20,  -5.301886180232687e-22,
   5.897598574807244e-24,   2.475569729215440e-25,   1.827018562804143e+00,  -4.058232727357305e-03,  -6.110815897510909e-05,  -6.180180974047256e-07,  -2.357376913998949e-09,
   5.733749097789264e-11,   1.455857560946858e-12,   1.562058708539873e-14,  -1.012921386266567e-17,  -3.642844495494770e-18,  -6.936427470308990e-20,  -5.283720797159390e-22,
   5.927889424722642e-24,   2.476730412404306e-25,   1.827008449566540e+00,  -4.058539109425313e-03,  -6.111047946990264e-05,  -6.179228219930620e-07,  -2.353765069244718e-09,
   5.739143115763827e-11,   1.455800754349121e-12,   1.559877971777673e-14,  -1.064355280663041e-17,  -3.647535888887788e-18,  -6.929726247446862e-20,  -5.251660999308930e-22,
   5.981289759955444e-24,   2.478763091388617e-25,   1.826996220362734e+00,  -4.058909568777245e-03,  -6.111328384110264e-05,  -6.178075743160967e-07,  -2.349397654476807e-09,
   5.745662241692816e-11,   1.455731003701980e-12,   1.557239765903515e-14,  -1.126527291704205e-17,  -3.653195775100060e-18,  -6.921597183449988e-20,  -5.212882598492678e-22,
   6.045779488771215e-24,   2.481194835969025e-25,   1.826984348286620e+00,  -4.059269182184033e-03,  -6.111600460492827e-05,  -6.176956523780273e-07,  -2.345157914077858e-09,
   5.751987357632088e-11,   1.455662181727226e-12,   1.554677349143531e-14,  -1.186859297588867e-17,  -3.658676682134872e-18,  -6.913678555478683e-20,  -5.175225391646289e-22,
   6.108298460819335e-24,   2.483528110146003e-25,   1.826974784169895e+00,  -4.059558866216294e-03,  -6.111819521949336e-05,  -6.176054598033383e-07,  -2.341742485123794e-09,
   5.757080252626334e-11,   1.455605945036699e-12,   1.552612174981823e-14,  -1.235445102829112e-17,  -3.663082274552146e-18,  -6.907280028852981e-20,  -5.144880832360862e-22,
   6.158600842188540e-24,   2.485388123295268e-25,   1.826968464309973e+00,  -4.059750276501612e-03,  -6.111964215230435e-05,  -6.175458476102859e-07,  -2.339485655551692e-09,
   5.760444304858797e-11,   1.455568395845122e-12,   1.551247092525016e-14,  -1.267541462492261e-17,  -3.665988634547661e-18,  -6.903042512139640e-20,  -5.124825596430642e-22,
   6.191809325327637e-24,   2.486607571597406e-25,   1.826965218740348e+00,  -4.059848572440816e-03,  -6.112038504022785e-05,  -6.175152293990007e-07,  -2.338326673361608e-09,
   5.762171522466758e-11,   1.455548992255355e-12,   1.550545917642771e-14,  -1.284021917090276e-17,  -3.667479711997029e-18,  -6.900863412738285e-20,  -5.114525012605351e-22,
   6.208854051101848e-24,   2.487230843489663e-25,   1.826964089087068e+00,  -4.059882784860362e-03,  -6.112064358030837e-05,  -6.175045717341831e-07,  -2.337923280238729e-09,
   5.762772635205594e-11,   1.455542219510327e-12,   1.550301845069487e-14,  -1.289757682142888e-17,  -3.667998459929737e-18,  -6.900104490603269e-20,  -5.110939599821464e-22,
   6.214785123797102e-24,   2.487447305688352e-25,   1.826963909826505e+00,  -4.059888213882016e-03,  -6.112068460568819e-05,  -6.175028804755676e-07,  -2.337859267364782e-09,
   5.762868020614675e-11,   1.455541143859979e-12,   1.550263113058193e-14,  -1.290667849683959e-17,  -3.668080766915020e-18,  -6.899984037962245e-20,  -5.110370634693807e-22,
   6.215726232117357e-24,   2.487481632790241e-25,   1.964882622361320e+00,  -9.425892342969363e-04,  -1.844021591093124e-05,  -3.083506085346202e-07,  -4.582724242185110e-09,
  -6.061210504055049e-11,  -6.919288953445580e-13,  -6.136094067017998e-15,  -2.263045586866393e-17,   6.345999851316173e-19,   2.086298786837183e-20,   4.064793970250966e-22,
   6.116467147715867e-24,   7.160325851205762e-26,   1.964880888408560e+00,  -9.426761582662178e-04,  -1.844279918483521e-05,  -3.084075335109932e-07,  -4.583697943077154e-09,
  -6.062415038152401e-11,  -6.919864533811000e-13,  -6.133897049839667e-15,  -2.254121578034876e-17,   6.367162187235455e-19,   2.090104019000971e-20,   4.070020084387322e-22,
   6.120946873067287e-24,   7.158589855325970e-26,   1.964877828624041e+00,  -9.428295500137037e-04,  -1.844735785779326e-05,  -3.085079876988425e-07,  -4.585416118722107e-09,
  -6.064540103167677e-11,  -6.920878242498857e-13,  -6.130014556754947e-15,  -2.238361954287161e-17,   6.404525360228100e-19,   2.096820651200825e-20,   4.079240565230980e-22,
   6.128839301525343e-24,   7.155491233664517e-26,   1.964874128362964e+00,  -9.430150551829900e-04,  -1.845287101350268e-05,  -3.086294736124386e-07,  -4.587493865925915e-09,
  -6.067109149656020e-11,  -6.922100767977396e-13,  -6.125309874018268e-15,  -2.219282958567830e-17,   6.449742643548042e-19,   2.104946290127692e-20,   4.090388213625782e-22,
   6.138362215341703e-24,   7.151683877965048e-26,   1.964870535860689e+00,  -9.431951636704017e-04,  -1.845822388516874e-05,  -3.087474264062944e-07,  -4.589511022841352e-09,
  -6.069602501324914e-11,  -6.923284156281600e-13,  -6.120732244960187e-15,  -2.200738050907556e-17,   6.493677892607632e-19,   2.112838509945655e-20,   4.101208196121169e-22,
   6.147585180433980e-24,   7.147924365034954e-26,   1.964867641534720e+00,  -9.433402734071340e-04,  -1.846253665898985e-05,  -3.088424593718391e-07,  -4.591136101124497e-09,
  -6.071610658033234e-11,  -6.924235027611466e-13,  -6.117037108032631e-15,  -2.185781780360384e-17,   6.529099565105633e-19,   2.119199234781579e-20,   4.109923214795269e-22,
   6.154999492127808e-24,   7.144850272975843e-26,   1.964865728891867e+00,  -9.434361675043760e-04,  -1.846538674220565e-05,  -3.089052612045546e-07,  -4.592209964441984e-09,
  -6.072937389213806e-11,  -6.924862145727078e-13,  -6.114591774008442e-15,  -2.175890747854750e-17,   6.552519287186123e-19,   2.123403684887157e-20,   4.115681244073698e-22,
   6.159891092099582e-24,   7.142796679422214e-26,   1.964864746619953e+00,  -9.434854162378921e-04,  -1.846685048262555e-05,  -3.089375147262451e-07,  -4.592761457163020e-09,
  -6.073618660142967e-11,  -6.925183829404039e-13,  -6.113334847825446e-15,  -2.170808694497456e-17,   6.564550675350698e-19,   2.125563302729648e-20,   4.118638050074153e-22,
   6.162400795793824e-24,   7.141735163458238e-26,   1.964864404725122e+00,  -9.435025581127859e-04,  -1.846735996462517e-05,  -3.089487411425087e-07,  -4.592953411247958e-09,
  -6.073855771737245e-11,  -6.925295735200084e-13,  -6.112897183206059e-15,  -2.169039435691347e-17,   6.568738985217994e-19,   2.126315046169243e-20,   4.119667158746646e-22,
   6.163273944093244e-24,   7.141364594622876e-26,   1.964864350470831e+00,  -9.435052783113430e-04,  -1.846744081305418e-05,  -3.089505226335760e-07,  -4.592983871812193e-09,
  -6.073893397559809e-11,  -6.925313490300242e-13,  -6.112827723315154e-15,  -2.168758659524754e-17,   6.569403644357296e-19,   2.126434340759434e-20,   4.119830462468908e-22,
   6.163412482798425e-24,   7.141305738295480e-26,   3.806849854173674e-03,  -5.283004895660194e-05,   5.488337167488831e-07,  -5.063759893212835e-09,   4.363462030573707e-11,
  -3.610718980767310e-13,   2.876174576828710e-15,  -2.272621572533167e-17,   1.684580351129703e-19,  -1.374246373989739e-21,   8.599898220744959e-24,  -6.641263730636751e-26,
   1.194505900048263e-27,   1.822330824823618e-29,   3.806901356551719e-03,  -5.283147433001304e-05,   5.488582840375623e-07,  -5.064098774329828e-09,   4.363867015785447e-11,
  -3.611167141598805e-13,   2.876617533369184e-15,  -2.273086256811400e-17,   1.684945590255407e-19,  -1.374583608862249e-21,   8.607437827839433e-24,  -6.627894034968858e-26,
   1.197724337482572e-27,   1.823162877707801e-29,   3.806992235184600e-03,  -5.283398950141174e-05,   5.489016352588693e-07,  -5.064696769582188e-09,   4.364581669245840e-11,
  -3.611958002868803e-13,   2.877399215259976e-15,  -2.273906291693579e-17,   1.685590320349590e-19,  -1.375178104211736e-21,   8.620757689176934e-24,  -6.604298383565836e-26,
   1.203395695524192e-27,   1.824606274376150e-29,   3.807102129798346e-03,  -5.283703100584576e-05,   5.489540591801607e-07,  -5.065419930131836e-09,   4.365445922271145e-11,
  -3.612914447690251e-13,   2.878344566570827e-15,  -2.274898043674990e-17,   1.686370378415296e-19,  -1.375896017851827e-21,   8.636891643574358e-24,  -6.575758504755873e-26,
   1.210240549176834e-27,   1.826309433514897e-29,   3.807208816938103e-03,  -5.283998378425781e-05,   5.490049547261823e-07,  -5.066122022933008e-09,   4.366285014659490e-11,
  -3.613843080693152e-13,   2.879262436811282e-15,  -2.275860983647794e-17,   1.687128110242002e-19,  -1.376591954200540e-21,   8.652582904047580e-24,  -6.548044481347941e-26,
   1.216871773340955e-27,   1.827918665408558e-29,   3.807294765111578e-03,  -5.284236260342761e-05,   5.490459578884406e-07,  -5.066687663514426e-09,   4.366961041432552e-11,
  -3.614591270614420e-13,   2.880001961163605e-15,  -2.276636833204889e-17,   1.687738862628442e-19,  -1.377151873584624e-21,   8.665244116882370e-24,  -6.525712780758180e-26,
   1.222204017449223e-27,   1.829183424058757e-29,   3.807351559309190e-03,  -5.284393453337053e-05,   5.490730532091987e-07,  -5.067061450157334e-09,   4.367407779639245e-11,
  -3.615085707826836e-13,   2.880490674669406e-15,  -2.277149558331244e-17,   1.688142600343059e-19,  -1.377521506797204e-21,   8.673620466874939e-24,  -6.510953663998107e-26,
   1.225722674943157e-27,   1.830003684037334e-29,   3.807380726210768e-03,  -5.284474180964466e-05,   5.490869683121143e-07,  -5.067253414109140e-09,   4.367637210905969e-11,
  -3.615339639418300e-13,   2.880741667591658e-15,  -2.277412885009517e-17,   1.688349989545246e-19,  -1.377711222411144e-21,   8.677925228196487e-24,  -6.503373315819602e-26,
   1.227528190358835e-27,   1.830420144851177e-29,   3.807390878075851e-03,  -5.284502279193821e-05,   5.490918116483078e-07,  -5.067320229975356e-09,   4.367717068123130e-11,
  -3.615428024930683e-13,   2.880829030389403e-15,  -2.277504541103290e-17,   1.688422181309300e-19,  -1.377777237357612e-21,   8.679424033903752e-24,  -6.500734773892556e-26,
   1.228156380271934e-27,   1.830564336766662e-29,   3.807392489039774e-03,  -5.284506738007208e-05,   5.490925802217734e-07,  -5.067330832783199e-09,   4.367729740437917e-11,
  -3.615442050603259e-13,   2.880842893776765e-15,  -2.277519085797488e-17,   1.688433637530369e-19,  -1.377787712198648e-21,   8.679661897180817e-24,  -6.500316067359440e-26,
   1.228256054141920e-27,   1.830587181910784e-29,   3.427063451568555e-02,  -4.721394551307824e-04,   4.819933244478639e-06,  -4.307323569126955e-08,   3.524761282585993e-10,
  -2.699540541106625e-12,   1.917045244291416e-14,  -1.293515232514649e-16,   7.295833125774299e-19,  -4.616798594285395e-21,   4.506485768358021e-24,   5.384407161652869e-26,
   5.203234992540583e-27,   2.119315937024904e-28,   3.427108678186126e-02,  -4.721515783769488e-04,   4.820131664223151e-06,  -4.307576864901566e-08,   3.525031093085450e-10,
  -2.699795449100283e-12,   1.917236801361572e-14,  -1.293670958601893e-16,   7.296034043526595e-19,  -4.616460411826244e-21,   4.539889898160447e-24,   5.539939582668633e-26,
   5.229433761095789e-27,   2.120359299277734e-28,   3.427188482779681e-02,  -4.721729706154044e-04,   4.820481791333286e-06,  -4.308023828723887e-08,   3.525507199865641e-10,
  -2.700245263192988e-12,   1.917574811184186e-14,  -1.293945730012013e-16,   7.296389722381931e-19,  -4.615857157990695e-21,   4.598963019703504e-24,   5.814437994468980e-26,
   5.275591100536334e-27,   2.122177886592371e-28,   3.427284985930779e-02,  -4.721988393274809e-04,   4.820905189833401e-06,  -4.308564335307160e-08,   3.526082950628855e-10,
  -2.700789225702809e-12,   1.917983543722348e-14,  -1.294277969839752e-16,   7.296821787743170e-19,  -4.615116568726972e-21,   4.670618006195085e-24,   6.146464109013050e-26,
   5.331284227141281e-27,   2.124338703764741e-28,   3.427378672225317e-02,  -4.722239532608491e-04,   4.821316239820513e-06,  -4.309089084462004e-08,   3.526641918624584e-10,
  -2.701317339598583e-12,   1.918380342017718e-14,  -1.294600484871753e-16,   7.297243301101932e-19,  -4.614385961975480e-21,   4.740412781132882e-24,   6.468892557841363e-26,
   5.385223497736276e-27,   2.126396379766198e-28,   3.427454146624720e-02,  -4.722441854609222e-04,   4.821647392145702e-06,  -4.309511840435095e-08,   3.527092244003399e-10,
  -2.701742813173576e-12,   1.918700003184528e-14,  -1.294860286036837e-16,   7.297584353963193e-19,  -4.613789042081439e-21,   4.796805521550352e-24,   6.728709878049306e-26,
   5.428585435303342e-27,   2.128025375676718e-28,   3.427504019712672e-02,  -4.722575549015974e-04,   4.821866219439845e-06,  -4.309791202232478e-08,   3.527389824716163e-10,
  -2.702023974145465e-12,   1.918911232347056e-14,  -1.295031951730987e-16,   7.297810444892491e-19,  -4.613390517810564e-21,   4.834150507415316e-24,   6.900428022793337e-26,
   5.457193718071239e-27,   2.129087773563570e-28,   3.427529632223279e-02,  -4.722644208614419e-04,   4.821978600118660e-06,  -4.309934671649750e-08,   3.527542650895403e-10,
  -2.702168368585994e-12,   1.919019709483240e-14,  -1.295120108324854e-16,   7.297926779174136e-19,  -4.613184591460604e-21,   4.853354182036049e-24,   6.988624411106639e-26,
   5.471871666224130e-27,   2.129629033982749e-28,   3.427538546938889e-02,  -4.722668106395294e-04,   4.822017715624011e-06,  -4.309984608094060e-08,   3.527595844122364e-10,
  -2.702218627162025e-12,   1.919057466080012e-14,  -1.295150791722741e-16,   7.297967306350382e-19,  -4.613112715497114e-21,   4.860042213002601e-24,   7.019323701493524e-26,
   5.476978266976398e-27,   2.129816735198397e-28,   3.427539961583700e-02,  -4.722671898652484e-04,   4.822023922734086e-06,  -4.309992532348509e-08,   3.527604285186972e-10,
  -2.702226602542360e-12,   1.919063457538392e-14,  -1.295155660740582e-16,   7.297973739162864e-19,  -4.613101300209711e-21,   4.861103702033646e-24,   7.024195338070682e-26,
   5.477788510038929e-27,   2.129846488070544e-28,   9.523996190648235e-02,  -1.292404765287903e-03,   1.271344374538656e-05,  -1.058226433856933e-07,   7.639436695855396e-10,
  -4.699371446372990e-12,   2.140762929274630e-14,  -3.613619866035440e-17,  -9.264260213025000e-19,   1.122647769207462e-20,  -1.595644117050432e-22,   1.132893927404844e-24,
   1.140878432057212e-26,   5.820535220454332e-28,   9.524115465247475e-02,  -1.292434543368371e-03,   1.271387363260811e-05,  -1.058270496302474e-07,   7.639737450608813e-10,
  -4.699441983840536e-12,   2.140518358358408e-14,  -3.609815210596573e-17,  -9.270967770680384e-19,   1.123248534594122e-20,  -1.594901708057451e-22,   1.137162983766722e-24,
   1.148782316163072e-26,   5.822948212529308e-28,   9.524325930435998e-02,  -1.292487088268235e-03,   1.271463218913197e-05,  -1.058348245717748e-07,   7.640268109094712e-10,
  -4.699566387338415e-12,   2.140086666121247e-14,  -3.603100175461735e-17,  -9.282800783505154e-19,   1.124310385462670e-20,  -1.593587761310134e-22,   1.144697148639508e-24,
   1.162709298562880e-26,   5.827141505694299e-28,   9.524580432786474e-02,  -1.292550627842020e-03,   1.271554946724423e-05,  -1.058442262056630e-07,   7.640909739238803e-10,
  -4.699716713394437e-12,   2.139564415453086e-14,  -3.594977448129005e-17,  -9.297104983776483e-19,   1.125597440872927e-20,  -1.591992187033936e-22,   1.153809813159818e-24,
   1.179516598815513e-26,   5.832102231762129e-28,   9.524827505122857e-02,  -1.292612312760990e-03,   1.271643996952230e-05,  -1.058533532449003e-07,   7.641532572640826e-10,
  -4.699862538414317e-12,   2.139057168285445e-14,  -3.587089071850673e-17,  -9.310986628837243e-19,   1.126850090572098e-20,  -1.590436186070615e-22,   1.162658575794837e-24,
   1.195797868236825e-26,   5.836803084110166e-28,   9.525026547582775e-02,  -1.292662006619685e-03,   1.271715736417700e-05,  -1.058607059376320e-07,   7.642034283269869e-10,
  -4.699979935101568e-12,   2.138648353705540e-14,  -3.580732165194014e-17,  -9.322166179495754e-19,   1.127861500985522e-20,  -1.589177650238497e-22,   1.169788681019913e-24,
   1.208888767594786e-26,   5.840507748477977e-28,   9.525158073350366e-02,  -1.292694844067951e-03,   1.271763141440212e-05,  -1.058655644995907e-07,   7.642365787153893e-10,
  -4.700057470517979e-12,   2.138378126795495e-14,  -3.576530588769338e-17,  -9.329551797483465e-19,   1.128530945377134e-20,  -1.588343566091024e-22,   1.174500929408530e-24,
   1.217526710588058e-26,   5.842915465584063e-28,   9.525225618761111e-02,  -1.292711707864211e-03,   1.271787486454008e-05,  -1.058680596140142e-07,   7.642536024828149e-10,
  -4.700097276841946e-12,   2.138239324665861e-14,  -3.574372554568487e-17,  -9.333344160923345e-19,   1.128875084246958e-20,  -1.587914461834672e-22,   1.176921140392612e-24,
   1.221958904569962e-26,   5.844139498976641e-28,   9.525249128661106e-02,  -1.292717577494035e-03,   1.271795960001430e-05,  -1.058689280630919e-07,   7.642595276744793e-10,
  -4.700111129915287e-12,   2.138191008906871e-14,  -3.573621379450492e-17,  -9.334664047321871e-19,   1.128994920200237e-20,  -1.587764986882004e-22,   1.177763555966957e-24,
   1.223500964624345e-26,   5.844563554349977e-28,   9.525252859363258e-02,  -1.292718508924927e-03,   1.271797304638720e-05,  -1.058690658740785e-07,   7.642604679166873e-10,
  -4.700113328117879e-12,   2.138183341652142e-14,  -3.573502175856826e-17,  -9.334873491296158e-19,   1.129013939139422e-20,  -1.587741261508689e-22,   1.177897237563423e-24,
   1.223745639561180e-26,   5.844630752079924e-28,   1.867663643226453e-01,  -2.473975802517186e-03,   2.288062625634951e-05,  -1.672675853076254e-07,   9.106318412900158e-10,
  -2.299581396330979e-12,  -2.528357532489767e-14,   4.563547591769827e-16,  -4.758081147378769e-18,   2.521333439201451e-20,  -1.278869091119492e-22,  -9.567330332370351e-25,
   5.672554626736302e-26,   9.185009742162973e-28,   1.867685104050128e-01,  -2.474022853998627e-03,   2.288113828414531e-05,  -1.672697335943333e-07,   9.105961384814842e-10,
  -2.298681598305044e-12,  -2.529607613155392e-14,   4.564397333061095e-16,  -4.758609090499992e-18,   2.520866390279152e-20,  -1.275280223846049e-22,  -9.499870293532090e-25,
   5.689658841893700e-26,   9.190540052736021e-28,   1.867722972401714e-01,  -2.474105877568990e-03,   2.288204174889747e-05,  -1.672735235938487e-07,   9.105331260169469e-10,
  -2.297093754558232e-12,  -2.531813512154859e-14,   4.565896588739686e-16,  -4.759539416599241e-18,   2.520045105985600e-20,  -1.268939051703146e-22,  -9.380804859226351e-25,
   5.719798919258687e-26,   9.200168872948446e-28,   1.867768763883051e-01,  -2.474206271394715e-03,   2.288313420024881e-05,  -1.672781053316977e-07,   9.104569062927426e-10,
  -2.295173485099482e-12,  -2.534481099580460e-14,   4.567709290079974e-16,  -4.760662264228159e-18,   2.519056827990594e-20,  -1.261256658155218e-22,  -9.236777103045193e-25,
   5.756175370482413e-26,   9.211591493589777e-28,   1.867813218157897e-01,  -2.474303732859673e-03,   2.288419470390901e-05,  -1.672825519781269e-07,   9.103828879734563e-10,
  -2.293309077990921e-12,  -2.537070946835323e-14,   4.569468805068607e-16,  -4.761750090387988e-18,   2.518102481487873e-20,  -1.253783472884207e-22,  -9.096903080283668e-25,
   5.791416401355499e-26,   9.222449511353419e-28,   1.867849030443307e-01,  -2.474382247176531e-03,   2.288504901093991e-05,  -1.672861332606314e-07,   9.103232414847673e-10,
  -2.291806961946517e-12,  -2.539157436923837e-14,   4.570886087378284e-16,  -4.762624840240186e-18,   2.517337296208122e-20,  -1.247752257639741e-22,  -8.984183903256445e-25,
   5.819754046320193e-26,   9.231031316392804e-28,   1.867872694808201e-01,  -2.474434128345948e-03,   2.288561351155936e-05,  -1.672884992783787e-07,   9.102838191904211e-10,
  -2.290814305270773e-12,  -2.540536222267359e-14,   4.571822524092995e-16,  -4.763202080736261e-18,   2.516833450048043e-20,  -1.243761599179773e-22,  -8.909682427396629e-25,
   5.838453539779638e-26,   9.236621155194310e-28,   1.867884847667538e-01,  -2.474460771903963e-03,   2.288590340646830e-05,  -1.672897142087354e-07,   9.102635711858266e-10,
  -2.290304502237632e-12,  -2.541244316105266e-14,   4.572303405013870e-16,  -4.763498280399819e-18,   2.516575249826062e-20,  -1.241710555107725e-22,  -8.871416627206503e-25,
   5.848048728185793e-26,   9.239466808741915e-28,   1.867889077593569e-01,  -2.474470045453462e-03,   2.288600430654151e-05,  -1.672901370552032e-07,   9.102565232413825e-10,
  -2.290127056431114e-12,  -2.541490778086226e-14,   4.572470776182865e-16,  -4.763601337031725e-18,   2.516485468263977e-20,  -1.240996407849072e-22,  -8.858096956801894e-25,
   5.851387163873730e-26,   9.240453286179934e-28,   1.867889748825147e-01,  -2.474471517038769e-03,   2.288602031796955e-05,  -1.672902041541091e-07,   9.102554048087285e-10,
  -2.290098898026429e-12,  -2.541529888371372e-14,   4.572497335500121e-16,  -4.763617688877893e-18,   2.516471225315359e-20,  -1.240883070050644e-22,  -8.855983265507162e-25,
   5.851916867933287e-26,   9.240609637720425e-28,   3.088351850141043e-01,  -3.949458008662980e-03,   3.317901785309152e-05,  -1.904808822813816e-07,   3.768551508197311e-10,
   7.141031481216198e-12,  -1.129014000249329e-13,   8.480752399820704e-16,  -2.699128798913533e-18,  -4.623963968743899e-20,   6.192309383685981e-22,  -5.883415323850983e-24,
   8.036820459942278e-26,   2.232220044678928e-27,   3.088382959646470e-01,  -3.949511557672709e-03,   3.317922893699772e-05,  -1.904741735629917e-07,   3.766963004756310e-10,
   7.142698629762109e-12,  -1.129084308827641e-13,   8.479184098932536e-16,  -2.696500040486463e-18,  -4.626933698682667e-20,   6.197388255976564e-22,  -5.867005735652045e-24,
   8.059820780544954e-26,   2.233821362884532e-27,   3.088437853018845e-01,  -3.949606044207786e-03,   3.317960132521242e-05,  -1.904623346537587e-07,   3.764159985233625e-10,
   7.145640088241505e-12,  -1.129208313221119e-13,   8.476415997143201e-16,  -2.691859803537460e-18,  -4.632166946270831e-20,   6.206361498421302e-22,  -5.838041549911028e-24,
   8.100334779439704e-26,   2.236623826152220e-27,   3.088504230945117e-01,  -3.949720295718049e-03,   3.318005149712922e-05,  -1.904480167527335e-07,   3.760770407354776e-10,
   7.149196502590370e-12,  -1.129358164808943e-13,   8.473067398719913e-16,  -2.686245790554079e-18,  -4.638483298630415e-20,   6.217231610216021e-22,  -5.803002138370041e-24,
   8.149204548315156e-26,   2.239973254375853e-27,   3.088568669773707e-01,  -3.949831206365259e-03,   3.318048838649273e-05,  -1.904341149147501e-07,   3.757479720704430e-10,
   7.152648559064579e-12,  -1.129503537730799e-13,   8.469815193693762e-16,  -2.680792670567777e-18,  -4.644602800007510e-20,   6.227804590245333e-22,  -5.768970258577987e-24,
   8.196520477275267e-26,   2.243183658363182e-27,   3.088620581061476e-01,  -3.949920552576061e-03,   3.318084024592143e-05,  -1.904229141503078e-07,   3.754828683827079e-10,
   7.155429169072251e-12,  -1.129620576302703e-13,   8.467194226419015e-16,  -2.676397460564197e-18,  -4.649523772537656e-20,   6.236336685691251e-22,  -5.741543077496381e-24,
   8.234547204296792e-26,   2.245740448820861e-27,   3.088654883216255e-01,  -3.949979589998703e-03,   3.318107270284671e-05,  -1.904155120893221e-07,   3.753076875711210e-10,
   7.157266389039168e-12,  -1.129697878061497e-13,   8.465461832523266e-16,  -2.673492082702312e-18,  -4.652771144968568e-20,   6.241981701763458e-22,  -5.723414067924411e-24,
   8.259630302742329e-26,   2.247415511125845e-27,   3.088672499045138e-01,  -3.950009908242604e-03,   3.318119206652374e-05,  -1.904117105308628e-07,   3.752177222909434e-10,
   7.158209840656537e-12,  -1.129737565311694e-13,   8.464572009162931e-16,  -2.671999691330750e-18,  -4.654437490343117e-20,   6.244882899842224e-22,  -5.714102224233123e-24,
   8.272497970284144e-26,   2.248271278528868e-27,   3.088678630400652e-01,  -3.950020460737682e-03,   3.318123360990358e-05,  -1.904103873244699e-07,   3.751864088043565e-10,
   7.158538209871209e-12,  -1.129751377086828e-13,   8.464262273134833e-16,  -2.671480196569157e-18,  -4.655017264439954e-20,   6.245893040422506e-22,  -5.710860877013908e-24,
   8.276974497449548e-26,   2.248568426794974e-27,   3.088679603362565e-01,  -3.950022135271071e-03,   3.318124020215942e-05,  -1.904101773479800e-07,   3.751814397735692e-10,
   7.158590317174765e-12,  -1.129753568742917e-13,   8.464213121112984e-16,  -2.671397757327977e-18,  -4.655109256507810e-20,   6.246053352528878e-22,  -5.710346506820694e-24,
   8.277684757040660e-26,   2.248615546457842e-27,   4.612161950559767e-01,  -5.612597904095682e-03,   4.057046430723905e-05,  -1.332792973996616e-07,  -1.074184284177119e-09,
   2.048436702583883e-11,  -1.430822888746996e-13,  -1.569408741823083e-16,   1.366407489884726e-17,  -1.681372201880599e-19,   3.764073062446618e-22,   9.478619089928463e-24,
  -7.410763978268903e-26,   4.244027062525694e-27,   4.612199973142949e-01,  -5.612635321191659e-03,   4.056985894663647e-05,  -1.332600960256452e-07,  -1.074385068643236e-09,
   2.048404904667674e-11,  -1.430463882821504e-13,  -1.575070258566983e-16,   1.366564893652892e-17,  -1.680871379864359e-19,   3.759707333946811e-22,   9.509668085247146e-24,
  -7.363217408829639e-26,   4.244345969684509e-27,   4.612267064127397e-01,  -5.612701339857080e-03,   4.056879068659214e-05,  -1.332262151437448e-07,  -1.074739314940323e-09,
   2.048348706189942e-11,  -1.429830377700439e-13,  -1.585058710993665e-16,   1.366842487271275e-17,  -1.679986369811225e-19,   3.752027750047345e-22,   9.564455919977079e-24,
  -7.279415808250877e-26,   4.244871388598186e-27,   4.612348190475288e-01,  -5.612781162849013e-03,   4.056749877872491e-05,  -1.331852464369172e-07,  -1.075167603347965e-09,
   2.048280596002739e-11,  -1.429064279410086e-13,  -1.597134493928774e-16,   1.367177904975594e-17,  -1.678913986614409e-19,   3.742782084947558e-22,   9.630708180546044e-24,
  -7.178244305858588e-26,   4.245443179718458e-27,   4.612426945704979e-01,  -5.612858645791073e-03,   4.056624445315791e-05,  -1.331454751633691e-07,  -1.075583305014072e-09,
   2.048214314158367e-11,  -1.428320504652965e-13,  -1.608854979997389e-16,   1.367503260056679e-17,  -1.677870611203716e-19,   3.733848995639005e-22,   9.695026865459380e-24,
  -7.080198948307819e-26,   4.245931771807329e-27,   4.612490389303039e-01,  -5.612921059426602e-03,   4.056523386746188e-05,  -1.331134362567527e-07,  -1.075918136344283e-09,
   2.048160802555935e-11,  -1.427721286554978e-13,  -1.618295075647285e-16,   1.367765174213762e-17,  -1.677028416115353e-19,   3.726682995223962e-22,   9.746842556714265e-24,
  -7.001336988754975e-26,   4.246277773714910e-27,   4.612532311413147e-01,  -5.612962298495888e-03,   4.056456603299294e-05,  -1.330922656719953e-07,  -1.076139361203446e-09,
   2.048125386343919e-11,  -1.427325312949374e-13,  -1.624532052460387e-16,   1.367938150739320e-17,  -1.676471093157531e-19,   3.721962692774873e-22,   9.781082070586422e-24,
  -6.949286264511060e-26,   4.246483114945479e-27,   4.612553840333121e-01,  -5.612983475880966e-03,   4.056422305027435e-05,  -1.330813936114037e-07,  -1.076252962799798e-09,
   2.048107180891122e-11,  -1.427121955075468e-13,  -1.627734769168451e-16,   1.368026954150892e-17,  -1.676184628965432e-19,   3.719543185566879e-22,   9.798665881817973e-24,
  -6.922574251805088e-26,   4.246581368116588e-27,   4.612561333656630e-01,  -5.612990846728424e-03,   4.056410366917023e-05,  -1.330776094987417e-07,  -1.076292501609426e-09,
   2.048100841525331e-11,  -1.427051173473557e-13,  -1.628849461156297e-16,   1.368057858488223e-17,  -1.676084882331442e-19,   3.718701785063002e-22,   9.804786116366626e-24,
  -6.913279841604157e-26,   4.246614420191835e-27,   4.612562522743195e-01,  -5.612992016373977e-03,   4.056408472489890e-05,  -1.330770090125384e-07,  -1.076298775813860e-09,
   2.048099835422781e-11,  -1.427039941359183e-13,  -1.629026345386407e-16,   1.368062762367226e-17,  -1.676069052008375e-19,   3.718568301095873e-22,   9.805757314609439e-24,
  -6.911805086803093e-26,   4.246619610710426e-27,   6.431800792520447e-01,  -7.300831086194025e-03,   4.111748508641149e-05,   3.751345187957671e-08,  -3.106464207823241e-09,
   2.443052161343213e-11,   5.124194082571800e-14,  -2.987236304061259e-15,   2.321134031127239e-17,   5.913860857387134e-20,  -3.747097394740863e-21,   2.876178366977587e-23,
   2.499664601835239e-25,  -5.219464688633574e-29,   6.431839305017796e-01,  -7.300820455067433e-03,   4.111573811490031e-05,   3.753630603225555e-08,  -3.106391432789043e-09,
   2.442464374842755e-11,   5.130254521395900e-14,  -2.987032845767108e-15,   2.319558372890951e-17,   5.928690897434509e-20,  -3.745504322538945e-21,   2.876168249258105e-23,
   2.509711218114824e-25,  -4.703619196683220e-29,   6.431907259595231e-01,  -7.300801691059858e-03,   4.111265558958905e-05,   3.757662806574991e-08,  -3.106262950934140e-09,
   2.441427249056185e-11,   5.140944901670395e-14,  -2.986673433481957e-15,   2.316778649575640e-17,   5.954858722766350e-20,  -3.742688291372642e-21,   2.876153393323587e-23,
   2.527417175052637e-25,  -3.798580329274345e-29,   6.431989428728585e-01,  -7.300778992525912e-03,   4.110892822402348e-05,   3.762537826353409e-08,  -3.106107471401401e-09,
   2.440173201343381e-11,   5.153866096521721e-14,  -2.986238134466506e-15,   2.313418318150169e-17,   5.986501121999820e-20,  -3.739274546888411e-21,   2.876140518358770e-23,
   2.548790796836157e-25,  -2.713022091205457e-29,   6.432069194726170e-01,  -7.300756947867678e-03,   4.110530982174521e-05,   3.767269611561962e-08,  -3.105956411131080e-09,
   2.438955852094181e-11,   5.166403772385022e-14,  -2.985814827134446e-15,   2.310157152124489e-17,   6.017219010809730e-20,  -3.735951578385905e-21,   2.876133321863374e-23,
   2.569501566260610e-25,  -1.668414717649641e-29,   6.432133451475059e-01,  -7.300739182304579e-03,   4.110239492671304e-05,   3.771080903293317e-08,  -3.105834630527270e-09,
   2.437975213369934e-11,   5.176499665322614e-14,  -2.985473295658107e-15,   2.307530706388502e-17,   6.041964946841616e-20,  -3.733268221847822e-21,   2.876131304624419e-23,
   2.586158374706701e-25,  -8.335035679648144e-30,   6.432175910356974e-01,  -7.300727439869888e-03,   4.110046883696017e-05,   3.773599056474299e-08,  -3.105754116793142e-09,
   2.437327245350723e-11,   5.183168748534839e-14,  -2.985247362845586e-15,   2.305795544527401e-17,   6.058316625691155e-20,  -3.731491968740226e-21,   2.876131814906366e-23,
   2.597151413667670e-25,  -2.850440373031156e-30,   6.432197714766792e-01,  -7.300721408557499e-03,   4.109947970419497e-05,   3.774892161876276e-08,  -3.105712755755340e-09,
   2.436994489136825e-11,   5.186592991562287e-14,  -2.985131256706539e-15,   2.304904563196185e-17,   6.066713997422696e-20,  -3.730578807616675e-21,   2.876132645372862e-23,
   2.602792693252347e-25,  -4.383812020983680e-32,   6.432205303950292e-01,  -7.300719309143149e-03,   4.109913542851008e-05,   3.775342225243426e-08,  -3.105698357536967e-09,
   2.436878671303406e-11,   5.187784727182261e-14,  -2.985090832351837e-15,   2.304594466076313e-17,   6.069636779969492e-20,  -3.730260819125166e-21,   2.876133024771655e-23,
   2.604755527913369e-25,   9.314338878107125e-31,   6.432206508247247e-01,  -7.300718975987370e-03,   4.109908079674934e-05,   3.775413643445817e-08,  -3.105696072636874e-09,
   2.436860292656462e-11,   5.187973834297781e-14,  -2.985084416967702e-15,   2.304545258745688e-17,   6.070100585327286e-20,  -3.730210351402137e-21,   2.876133089263177e-23,
   2.605066971198400e-25,   1.086120572724307e-30,   8.529595310328419e-01,  -8.770248819507102e-03,   3.037847938587692e-05,   3.145980116577898e-07,  -4.300973898822124e-09,
  -2.007617495623176e-12,   4.721858790476464e-13,  -3.340876187962099e-15,  -3.489073471667853e-17,   6.638073620236756e-19,  -1.326513387426839e-21,  -8.700736555320187e-23,
   1.044971999098091e-24,   1.221146478967065e-26,   8.529623741607103e-01,  -8.770160345824975e-03,   3.037606383419557e-05,   3.145960745523791e-07,  -4.300310973323991e-09,
  -2.014159407445496e-12,   4.720941803811604e-13,  -3.338647432129219e-15,  -3.489612372353982e-17,   6.633622352166290e-19,  -1.320066021701604e-21,  -8.691741052443394e-23,
   1.044576351596137e-24,   1.222357100820856e-26,   8.529673907209721e-01,  -8.770004233071140e-03,   3.037180185809847e-05,   3.145926515240779e-07,  -4.299141335717022e-09,
  -2.025699152301787e-12,   4.719323652639021e-13,  -3.334715976139165e-15,  -3.490561061371516e-17,   6.625771797143616e-19,  -1.308691542139226e-21,  -8.675861302657262e-23,
   1.043877453704036e-24,   1.224481832883680e-26,   8.529734564862220e-01,  -8.769815460629458e-03,   3.036664874740774e-05,   3.145885038801859e-07,  -4.297727176235188e-09,
  -2.039647063811911e-12,   4.717366773275803e-13,  -3.329964094890827e-15,  -3.491704458980373e-17,   6.616285265102847e-19,  -1.294940810538387e-21,  -8.656647376315712e-23,
   1.043031017956340e-24,   1.227031607673410e-26,   8.529793446983593e-01,  -8.769632204416193e-03,   3.036164673741658e-05,   3.145844685399176e-07,  -4.296354521948055e-09,
  -2.053181098798721e-12,   4.715466866259523e-13,  -3.325353225293367e-15,  -3.492810505121051e-17,   6.607082653568863e-19,  -1.281595413331725e-21,  -8.637982360657415e-23,
   1.042207922848038e-24,   1.229486509735951e-26,   8.529840879306542e-01,  -8.769484576171712e-03,   3.035761757057166e-05,   3.145812113619017e-07,  -4.295248863682848e-09,
  -2.064079388481437e-12,   4.713936181142612e-13,  -3.321640326062564e-15,  -3.493698695736168e-17,   6.599673987213105e-19,  -1.270847098803705e-21,  -8.622937174814142e-23,
   1.041543847567837e-24,   1.231449560686601e-26,   8.529872220590846e-01,  -8.769387026340811e-03,   3.035495535854450e-05,   3.145790559631583e-07,  -4.294518330097858e-09,
  -2.071278555422549e-12,   4.712924660937894e-13,  -3.319187670657363e-15,  -3.494284212870105e-17,   6.594780841909608e-19,  -1.263746060381468e-21,  -8.612991247122512e-23,
   1.041104546663462e-24,   1.232739573033392e-26,   8.529888315484412e-01,  -8.769336929922681e-03,   3.035358824393388e-05,   3.145779481000255e-07,  -4.294143186466240e-09,
  -2.074974982960533e-12,   4.712405175058908e-13,  -3.317928350433525e-15,  -3.494584476140990e-17,   6.592268710593105e-19,  -1.260099726125807e-21,  -8.607882199715663e-23,
   1.040878792137449e-24,   1.233399850069608e-26,   8.529893917402906e-01,  -8.769319493419537e-03,   3.035311241651053e-05,   3.145775623448589e-07,  -4.294012617524670e-09,
  -2.076261448710948e-12,   4.712224359764392e-13,  -3.317490070013104e-15,  -3.494688917420116e-17,   6.591394456979280e-19,  -1.258830648003730e-21,  -8.606103736343191e-23,
   1.040800191894665e-24,   1.233629314431874e-26,   8.529894806347533e-01,  -8.769316726487291e-03,   3.035303690969488e-05,   3.145775011235512e-07,  -4.293991898185441e-09,
  -2.076465587900161e-12,   4.712195666702361e-13,  -3.317420522727391e-15,  -3.494705487579762e-17,   6.591255730511419e-19,  -1.258629265723138e-21,  -8.605821508611349e-23,
   1.040787717963716e-24,   1.233665710599678e-26,   1.086716486049491e+00,  -9.666529736728421e-03,   4.961651484280318e-06,   5.933781713638508e-07,  -2.095678764195919e-09,
  -6.078186381377488e-11,   4.777163685311631e-13,   6.463525929427626e-15,  -9.868871345237881e-17,  -6.393966653503548e-19,   1.751758990569424e-20,   1.952147818959041e-23,
  -2.873096756180899e-24,   2.034044772131559e-26,   1.086716948844663e+00,  -9.666363049758124e-03,   4.960476440458277e-06,   5.933212951451371e-07,  -2.095010020215071e-09,
  -6.076917304638492e-11,   4.774588241508466e-13,   6.461370765489046e-15,  -9.861537286294536e-17,  -6.392902916979846e-19,   1.750008173197501e-20,   1.966863679920009e-23,
  -2.867277065385623e-24,   2.031184375515141e-26,   1.086717765364926e+00,  -9.666068940958939e-03,   4.958403362227544e-06,   5.932209458231670e-07,  -2.093830304774854e-09,
  -6.074678343550856e-11,   4.770045392120313e-13,   6.457568240832692e-15,  -9.848602205151361e-17,  -6.391019784374889e-19,   1.746921746278549e-20,   1.992813005495667e-23,
  -2.857016851088524e-24,   2.026134372176629e-26,   1.086718752558048e+00,  -9.665713323590683e-03,   4.955897093973579e-06,   5.930996188213566e-07,  -2.092404281149865e-09,
  -6.071971555732150e-11,   4.764554792089860e-13,   6.452970693278499e-15,  -9.832971158497485e-17,  -6.388732194214112e-19,   1.743194578087569e-20,   2.024162136789052e-23,
  -2.844624964819311e-24,   2.020023092180402e-26,   1.086719710748989e+00,  -9.665368119582005e-03,   4.953464596654614e-06,   5.929818539136118e-07,  -2.091020446470528e-09,
  -6.069344468521636e-11,   4.759227399118033e-13,   6.448508004930033e-15,  -9.817807472870362e-17,  -6.386500466601034e-19,   1.739581510743829e-20,   2.054564873928823e-23,
  -2.832610716766868e-24,   2.014085371280293e-26,   1.086720482541203e+00,  -9.665090044326393e-03,   4.951505398510373e-06,   5.928869963900594e-07,  -2.089906022849136e-09,
  -6.067228562237597e-11,   4.754937716349806e-13,   6.444913302895214e-15,  -9.805599439415522e-17,  -6.384694756944343e-19,   1.736674595916375e-20,   2.079035091071941e-23,
  -2.822943361203859e-24,   2.009298434326652e-26,   1.086720992471964e+00,  -9.664906305280670e-03,   4.950210986229906e-06,   5.928243222768222e-07,  -2.089169815432273e-09,
  -6.065830624975984e-11,   4.752104147240235e-13,   6.442538175118841e-15,  -9.797536323954164e-17,  -6.383497730017571e-19,   1.734755581266265e-20,   2.095193880698586e-23,
  -2.816560813434417e-24,   2.006133553128699e-26,   1.086721254328558e+00,  -9.664811949003089e-03,   4.949546302634901e-06,   5.927921379912432e-07,  -2.088791794548260e-09,
  -6.065112784075174e-11,   4.750649275952369e-13,   6.441318491370629e-15,  -9.793396683088995e-17,  -6.382881810336150e-19,   1.733770638932506e-20,   2.103488884254555e-23,
  -2.813284761219192e-24,   2.004507690798260e-26,   1.086721345467397e+00,  -9.664779107836809e-03,   4.949314962822301e-06,   5.927809362536728e-07,  -2.088660229967650e-09,
  -6.064862943605805e-11,   4.750142942755105e-13,   6.440893978515853e-15,  -9.791956026963769e-17,  -6.382667244581428e-19,   1.733427910424328e-20,   2.106375509474592e-23,
  -2.812144770549363e-24,   2.003941707806007e-26,   1.086721359929745e+00,  -9.664773896415017e-03,   4.949278252826326e-06,   5.927791587063287e-07,  -2.088639352910256e-09,
  -6.064823297868810e-11,   4.750062596932327e-13,   6.440826614611261e-15,  -9.791727423401794e-17,  -6.382633186966659e-19,   1.733373528387719e-20,   2.106833552134497e-23,
  -2.811963882515514e-24,   2.003851889982154e-26,   1.336572307713348e+00,  -9.516369469292603e-03,  -3.320666223544187e-05,   6.151238819354336e-07,   4.832652156331133e-09,
  -7.489745376230047e-11,  -8.541128580655254e-13,   1.097861667644671e-14,   1.610549907513438e-16,  -1.874968126032203e-18,  -3.426793923323335e-20,   3.125297074216065e-22,
   7.437048440753564e-24,  -4.250499555994389e-26,   1.336569200038110e+00,  -9.516196712688021e-03,  -3.320395062299522e-05,   6.150538464974760e-07,   4.831456022617338e-09,
  -7.487593955230628e-11,  -8.536930406433683e-13,   1.097233032541500e-14,   1.609118847676630e-16,  -1.873368436563111e-18,  -3.422240654645861e-20,   3.122256746360535e-22,
   7.426571949985921e-24,  -4.238146039365538e-26,   1.336563716702054e+00,  -9.515891896919575e-03,  -3.319916648594465e-05,   6.149302842307389e-07,   4.829345904642313e-09,
  -7.483798743117754e-11,  -8.529525707084310e-13,   1.096124234067995e-14,   1.606595277504744e-16,  -1.870547026882796e-18,  -3.414211586110535e-20,   3.116899329821531e-22,
   7.408108082214546e-24,  -4.216388424921736e-26,   1.336557086544367e+00,  -9.515523337676942e-03,  -3.319338238673968e-05,   6.147808993165739e-07,   4.826795143563257e-09,
  -7.479211243651255e-11,  -8.520577055406783e-13,   1.094784209790512e-14,   1.603546403796898e-16,  -1.867137507351950e-18,  -3.404511687401566e-20,   3.110433497802914e-22,
   7.385818934889886e-24,  -4.190147657379497e-26,   1.336550650469433e+00,  -9.515165575267570e-03,  -3.318776825750325e-05,   6.146359082366078e-07,   4.824319763192749e-09,
  -7.474759570306627e-11,  -8.511895291164210e-13,   1.093484119034850e-14,   1.600589387974749e-16,  -1.863829863245949e-18,  -3.395104542477581e-20,   3.104169558173075e-22,
   7.364220266443163e-24,  -4.164745534932974e-26,   1.336545465914363e+00,  -9.514877386957792e-03,  -3.318324628583795e-05,   6.145191262314282e-07,   4.822326240868465e-09,
  -7.471174643486695e-11,  -8.504905264689215e-13,   1.092437342641607e-14,   1.598209243804063e-16,  -1.861166884457951e-18,  -3.387532960483536e-20,   3.099132693941309e-22,
   7.346848725219139e-24,  -4.144333434470589e-26,   1.336542040181591e+00,  -9.514686967260978e-03,  -3.318025858914302e-05,   6.144419690054939e-07,   4.821009256351305e-09,
  -7.468806415887590e-11,  -8.500288283489219e-13,   1.091745925461549e-14,   1.596637460515732e-16,  -1.859408026137502e-18,  -3.382533067643687e-20,   3.095808963568091e-22,
   7.335383638621904e-24,  -4.130870690894617e-26,   1.336540280943745e+00,  -9.514589180729170e-03,  -3.317872436957337e-05,   6.144023482453806e-07,   4.820333014397712e-09,
  -7.467590411933398e-11,  -8.497917831311969e-13,   1.091390934379205e-14,   1.595830575583509e-16,  -1.858505012578543e-18,  -3.379966395261041e-20,   3.094103471689552e-22,
   7.329500005690537e-24,  -4.123964720470904e-26,   1.336539668631246e+00,  -9.514555145723783e-03,  -3.317819038721908e-05,   6.143885583811805e-07,   4.820097656935147e-09,
  -7.467167201540247e-11,  -8.497092867411381e-13,   1.091267389968426e-14,   1.595549779803739e-16,  -1.858190749325858e-18,  -3.379073202465757e-20,   3.093510082822249e-22,
   7.327452827565804e-24,  -4.121562274500274e-26,   1.336539571465986e+00,  -9.514549744860547e-03,  -3.317810565237192e-05,   6.143863701435842e-07,   4.820060309647064e-09,
  -7.467100045347164e-11,  -8.496961961449296e-13,   1.091247785812126e-14,   1.595505223654953e-16,  -1.858140881921523e-18,  -3.378931472714091e-20,   3.093415930775027e-22,
   7.327128000589159e-24,  -4.121181098285592e-26,   1.587042371316509e+00,  -7.833220197714390e-03,  -6.863232900159072e-05,   8.815550047995362e-08,   9.526438306159211e-09,
   6.706048670090147e-11,  -1.119269367106243e-12,  -2.301388739603862e-14,   2.089095767282055e-17,   5.076397154454251e-18,   4.027534964596465e-20,  -8.187394691572043e-22,
  -1.706394993146061e-23,   5.126514480701950e-26,   1.587035947787341e+00,  -7.833195183998888e-03,  -6.862697927075806e-05,   8.821799116268494e-08,   9.524865031109155e-09,
   6.701544872966068e-11,  -1.119211097977462e-12,  -2.299686416993103e-14,   2.105754776581084e-17,   5.072191107151620e-18,   4.017174836553088e-20,  -8.183427070440525e-22,
  -1.702108544750003e-23,   5.166473895892697e-26,   1.587024613775592e+00,  -7.833151032680476e-03,  -6.861754030571668e-05,   8.832822271286137e-08,   9.522089030455071e-09,
   6.693600571310294e-11,  -1.119107927665224e-12,  -2.296683794859699e-14,   2.135114501186275e-17,   5.064771155939111e-18,   3.998915716368650e-20,  -8.176402658925986e-22,
  -1.694551711388268e-23,   5.236778982476705e-26,   1.587010909260600e+00,  -7.833097620186915e-03,  -6.860612783456475e-05,   8.846145750882388e-08,   9.518732376891644e-09,
   6.683998872103145e-11,  -1.118982570759011e-12,  -2.293054957554335e-14,   2.170556353564151e-17,   5.055801752134909e-18,   3.976873210232171e-20,  -8.167868710086534e-22,
  -1.685425285423627e-23,   5.321445345106420e-26,   1.586997605880442e+00,  -7.833045742877685e-03,  -6.859505008918443e-05,   8.859073843364617e-08,   9.515473917632883e-09,
   6.674682561080416e-11,  -1.118860246417962e-12,  -2.289534202915423e-14,   2.204899671540293e-17,   5.047097435127612e-18,   3.955513042536665e-20,  -8.159542364855283e-22,
  -1.676577424810548e-23,   5.403274829941347e-26,   1.586986889370366e+00,  -7.833003933008495e-03,  -6.858612692157169e-05,   8.869484169396738e-08,   9.512849032828388e-09,
   6.667180937637515e-11,  -1.118761252570487e-12,  -2.286699402882871e-14,   2.232521094396863e-17,   5.040087523909427e-18,   3.938333001600372e-20,  -8.152804940406736e-22,
  -1.669458241735593e-23,   5.468935776066956e-26,   1.586979808345994e+00,  -7.832976296890547e-03,  -6.858023110182343e-05,   8.876360984732765e-08,   9.511114598700825e-09,
   6.662225699771767e-11,  -1.118695618589568e-12,  -2.284826939172347e-14,   2.250750771005786e-17,   5.035456566012029e-18,   3.926994159871171e-20,  -8.148338395232675e-22,
  -1.664758193311306e-23,   5.512196295228526e-26,   1.586976171979893e+00,  -7.832962101669274e-03,  -6.857720345558204e-05,   8.879891895925796e-08,   9.510223897103181e-09,
   6.659681474063621e-11,  -1.118661844213971e-12,  -2.283865562615186e-14,   2.260105761498210e-17,   5.033078677906898e-18,   3.921175271589874e-20,  -8.146040109458670e-22,
  -1.662345786613126e-23,   5.534373378272529e-26,   1.586974906321903e+00,  -7.832957160454372e-03,  -6.857614967775861e-05,   8.881120756436418e-08,   9.509913882377218e-09,
   6.658796016743434e-11,  -1.118650077881495e-12,  -2.283530982224378e-14,   2.263360766090424e-17,   5.032251084815205e-18,   3.919150614681856e-20,  -8.145239454032653e-22,
  -1.661506332231902e-23,   5.542086067194530e-26,   1.586974705480007e+00,  -7.832956376330817e-03,  -6.857598245878373e-05,   8.881315754668718e-08,   9.509864687410574e-09,
   6.658655510836531e-11,  -1.118648210211483e-12,  -2.283477890610668e-14,   2.263877238964382e-17,   5.032119759689245e-18,   3.918829360864933e-20,  -8.145112367063238e-22,
  -1.661373132155834e-23,   5.543309668154293e-26,   1.809766600140352e+00,  -4.577122883992487e-03,  -6.870583943894232e-05,  -6.446088372529645e-07,  -8.291874273269322e-10,
   9.732410118477852e-11,   1.865453131876174e-12,   1.264707392675106e-14,  -1.953315986136793e-16,  -6.745900471697727e-18,  -8.101015228989003e-20,   1.470107887465803e-22,
   2.400989778083495e-23,   4.394012611166510e-25,   1.809760158074232e+00,  -4.577303857720864e-03,  -6.870629108652256e-05,  -6.445173901433507e-07,  -8.265702955947537e-10,
   9.734863834548344e-11,   1.864933443114910e-12,   1.262433002212966e-14,  -1.956685492616963e-16,  -6.745019069675412e-18,  -8.086068675797004e-20,   1.501874439321000e-22,
   2.402963594266741e-23,   4.387434046892272e-25,   1.809748790914384e+00,  -4.577623167770708e-03,  -6.870708683039757e-05,  -6.443560116868320e-07,  -8.219529222912135e-10,
   9.739189816008996e-11,   1.864015727928442e-12,   1.258420055308352e-14,  -1.962625905555051e-16,  -6.743450542719550e-18,  -8.059685481641983e-20,   1.557887642385133e-22,
   2.406431619165192e-23,   4.375806149012495e-25,   1.809735045567316e+00,  -4.578009245185842e-03,  -6.870804701434963e-05,  -6.441608394493320e-07,  -8.163705633266797e-10,
   9.744414634246981e-11,   1.862904796504296e-12,   1.253567987238147e-14,  -1.969800359749550e-16,  -6.741531232333768e-18,  -8.027766040642279e-20,   1.625552183602979e-22,
   2.410599955358086e-23,   4.361711673406772e-25,   1.809721701763828e+00,  -4.578384005059893e-03,  -6.870897701032990e-05,  -6.439713364650279e-07,  -8.109523728030888e-10,
   9.749480300143207e-11,   1.861825046459622e-12,   1.248858137226782e-14,  -1.976756022973900e-16,  -6.739644314740735e-18,  -7.996761880740059e-20,   1.691169251561720e-22,
   2.414620085285317e-23,   4.347993585450406e-25,   1.809710952127413e+00,  -4.578685879943142e-03,  -6.870972467417778e-05,  -6.438186515871606e-07,  -8.065883139297566e-10,
   9.753556479743005e-11,   1.860954299540249e-12,   1.245064270606472e-14,  -1.982352840559792e-16,  -6.738107278977076e-18,  -7.971772969460563e-20,   1.743978924754995e-22,
   2.417839726998733e-23,   4.336917155168566e-25,   1.809703848938697e+00,  -4.578885340366407e-03,  -6.871021796864691e-05,  -6.437177485239142e-07,  -8.037049963118683e-10,
   9.756247667515370e-11,   1.860378478082709e-12,   1.242557512286694e-14,  -1.986047898169680e-16,  -6.737083333440488e-18,  -7.955254707163049e-20,   1.778849819890192e-22,
   2.419957946366346e-23,   4.329585674772508e-25,   1.809700201105089e+00,  -4.578987768779304e-03,  -6.871047106749955e-05,  -6.436659263820357e-07,  -8.022243906891889e-10,
   9.757629016396829e-11,   1.860082627906255e-12,   1.241270221977490e-14,  -1.987944491143602e-16,  -6.736554922540308e-18,  -7.946769926700904e-20,   1.796750018411473e-22,
   2.421042889384306e-23,   4.325816787421601e-25,   1.809698931442190e+00,  -4.579023419280319e-03,  -6.871055912402549e-05,  -6.436478886394419e-07,  -8.017090708042173e-10,
   9.758109695320579e-11,   1.859979632529708e-12,   1.240822176779017e-14,  -1.988604459130813e-16,  -6.736370595875452e-18,  -7.943816425013591e-20,   1.802979124066480e-22,
   2.421420057835900e-23,   4.324504383739728e-25,   1.809698729964126e+00,  -4.579029076493170e-03,  -6.871057309563418e-05,  -6.436450262709821e-07,  -8.016272975120584e-10,
   9.758185967119084e-11,   1.859963287536987e-12,   1.240751078555894e-14,  -1.988709179433198e-16,  -6.736341326385261e-18,  -7.943347730920188e-20,   1.803967539304396e-22,
   2.421479887632558e-23,   4.324296094498895e-25,   1.960791898346870e+00,  -1.106256579071195e-03,  -2.262345387546857e-05,  -3.923339619384572e-07,  -5.975255217249858e-09,
  -7.933412021379923e-11,  -8.690647201759225e-13,  -6.292945835110052e-15,   2.043796907911775e-17,   1.927571041407359e-18,   4.664973407057671e-20,   8.005958289589829e-22,
   1.048482293900422e-23,   9.137776938944538e-26,   1.960789770641058e+00,  -1.106367185142873e-03,  -2.262682184410726e-05,  -3.924084407042307e-07,  -5.976476647584412e-09,
  -7.934640398041567e-11,  -8.690069566662843e-13,  -6.286331921708277e-15,   2.063685690045253e-17,   1.931724546391775e-18,   4.671457465823875e-20,   8.012516258314372e-22,
   1.048415170024358e-23,   9.115443280557189e-26,   1.960786016013096e+00,  -1.106562368347339e-03,  -2.263276523625696e-05,  -3.925398689900872e-07,  -5.978631812995649e-09,
  -7.936806824049448e-11,  -8.689046063254247e-13,  -6.274650151872859e-15,   2.098801995738394e-17,   1.939056207746748e-18,   4.682898302715780e-20,   8.024074488886488e-22,
   1.048292274565150e-23,   9.075938105507945e-26,   1.960781475437618e+00,  -1.106798415038424e-03,  -2.263995300181967e-05,  -3.926988093838200e-07,  -5.981237746390445e-09,
  -7.939424674173254e-11,  -8.687801169876973e-13,  -6.260504961313753e-15,   2.141302922293379e-17,   1.947926393029716e-18,   4.696732010000854e-20,   8.038027922742392e-22,
   1.048136065730308e-23,   9.028002404371394e-26,   1.960777067065546e+00,  -1.107027595528891e-03,  -2.264693175739150e-05,  -3.928531226165308e-07,  -5.983767419890169e-09,
  -7.941964135140133e-11,  -8.686585039966171e-13,  -6.246752660192482e-15,   2.182601788543514e-17,   1.956542292454892e-18,   4.710160807143949e-20,   8.051549641447970e-22,
   1.047976450442297e-23,   8.981293708818476e-26,   1.960773515408722e+00,  -1.107212242169410e-03,  -2.265255446658585e-05,  -3.929774472745258e-07,  -5.985805204587434e-09,
  -7.944008527523846e-11,  -8.685599886800081e-13,  -6.235659367706105e-15,   2.215900063889195e-17,   1.963486639919384e-18,   4.720978337140544e-20,   8.062425306733035e-22,
   1.047842149034950e-23,   8.943541368370101e-26,   1.960771168375765e+00,  -1.107334264063223e-03,  -2.265627020246846e-05,  -3.930596046303007e-07,  -5.987151693510263e-09,
  -7.945358757115878e-11,  -8.684946243178636e-13,  -6.228321958651428e-15,   2.237916898486276e-17,   1.968077048858339e-18,   4.728126101023901e-20,   8.069603289481314e-22,
   1.047750602997445e-23,   8.918534342551208e-26,   1.960769963012125e+00,  -1.107396931448198e-03,  -2.265817851881656e-05,  -3.931017981681472e-07,  -5.987843166705138e-09,
  -7.946051957788182e-11,  -8.684609739323619e-13,  -6.224551633636719e-15,   2.249227903627139e-17,   1.970434971356880e-18,   4.731796735947676e-20,   8.073286906705841e-22,
   1.047702722595803e-23,   8.905673181725901e-26,   1.960769543466324e+00,  -1.107418743931435e-03,  -2.265884274301975e-05,  -3.931164843026430e-07,  -5.988083838164185e-09,
  -7.946293199694167e-11,  -8.684492484460267e-13,  -6.223238984919741e-15,   2.253165488239756e-17,   1.971255751885767e-18,   4.733074320594009e-20,   8.074568605974551e-22,
   1.047685919284531e-23,   8.901193734348366e-26,   1.960769476889806e+00,  -1.107422205297089e-03,  -2.265894814707055e-05,  -3.931188148035627e-07,  -5.988122029309523e-09,
  -7.946331479898446e-11,  -8.684473871479666e-13,  -6.223030668908189e-15,   2.253790361240265e-17,   1.971386002439411e-18,   4.733277055041354e-20,   8.074771974173874e-22,
   1.047683246273418e-23,   8.900482765187649e-26,   3.603945586390502e-03,  -4.867118745573560e-05,   4.920323210593274e-07,  -4.419853404631986e-09,   3.705512100627278e-11,
  -2.991166346162374e-13,   2.308342151979312e-15,  -1.806553922733041e-17,   1.246587311421705e-19,  -1.067641567046844e-21,   3.604015669886927e-03,  -4.867307589410614e-05,
   4.920639883092911e-07,  -4.420279526217474e-09,   3.706005433068598e-11,  -2.991707099668081e-13,   2.308839866972544e-15,  -1.807100363678994e-17,   1.247067660231397e-19,
  -1.067450494674424e-21,   3.604130726553940e-03,  -4.867617620301020e-05,   4.921159782732292e-07,  -4.420979129442552e-09,   3.706815394981461e-11,  -2.992594952088720e-13,
   2.309657085720794e-15,  -1.807997362520688e-17,   1.247857396749200e-19,  -1.067134587826055e-21,   3.604252815008599e-03,  -4.867946604937881e-05,   4.921711477862525e-07,
  -4.421721538217225e-09,   3.707674931658665e-11,  -2.993537192528998e-13,   2.310524407124734e-15,  -1.808949048762708e-17,   1.248696953474353e-19,  -1.066796358808490e-21,
   3.604348902477797e-03,  -4.868205530537378e-05,   4.922145694828821e-07,  -4.422305872626028e-09,   3.708351467202378e-11,  -2.994278856836358e-13,   2.311207130723912e-15,
  -1.809697958907658e-17,   1.249358836995106e-19,  -1.066527982129499e-21,   3.604404357723532e-03,  -4.868354966759913e-05,   4.922396301957090e-07,  -4.422643125408862e-09,
   3.708741939426254e-11,  -2.994706932359385e-13,   2.311601198866366e-15,  -1.810130140647816e-17,   1.249741283146816e-19,  -1.066372220456079e-21,   3.604425181963261e-03,
  -4.868411082529573e-05,   4.922490409698929e-07,  -4.422769771335054e-09,   3.708888571362651e-11,  -2.994867687772917e-13,   2.311749185774303e-15,  -1.810292423703291e-17,
   1.249884982475879e-19,  -1.066313564908353e-21,   3.604428633891917e-03,  -4.868420384573435e-05,   4.922506009524098e-07,  -4.422790764929176e-09,   3.708912878007443e-11,
  -2.994894335747849e-13,   2.311773717271430e-15,  -1.810319324152895e-17,   1.249908807286177e-19,  -1.066303833184516e-21,   3.245608191448589e-02,  -4.355563558369733e-04,
   4.335200600963165e-06,  -3.784188807908365e-08,   3.028074743505920e-10,  -2.280441366730626e-12,   1.585089025681186e-14,  -1.086195468890565e-16,   5.681997221582391e-19,
  -4.270071984828606e-21,   3.245669936570654e-02,  -4.355725228483811e-04,   4.335459343204008e-06,  -3.784513605857581e-08,   3.028413367491222e-10,  -2.280766318355321e-12,
   1.585315672713750e-14,  -1.086412834655548e-16,   5.683154111674301e-19,  -4.264905743465270e-21,   3.245771303848979e-02,  -4.355990646177909e-04,   4.335884131387135e-06,
  -3.785046847711464e-08,   3.028969308565023e-10,  -2.281299825914202e-12,   1.585687784344784e-14,  -1.086769482772863e-16,   5.685062322330649e-19,  -4.256402317056403e-21,
   3.245878865991786e-02,  -4.356272288507871e-04,   4.336334892915270e-06,  -3.785612704004481e-08,   3.029559252583636e-10,  -2.281865982356534e-12,   1.586082669689198e-14,
  -1.087147651285482e-16,   5.687099299159162e-19,  -4.247349383052620e-21,   3.245963520588946e-02,  -4.356493952380131e-04,   4.336689665195597e-06,  -3.786058068806873e-08,
   3.030023576072539e-10,  -2.282311596546579e-12,   1.586393480052165e-14,  -1.087445081333587e-16,   5.688711258168512e-19,  -4.240202882538889e-21,   3.246012377464837e-02,
  -4.356621882895347e-04,   4.336894419469424e-06,  -3.786315110742471e-08,   3.030291560046172e-10,  -2.282568787680639e-12,   1.586572868264447e-14,  -1.087616657528890e-16,
   5.689645098250499e-19,  -4.236069770934593e-21,   3.246030723906501e-02,  -4.356669922824448e-04,   4.336971308295342e-06,  -3.786411635040184e-08,   3.030392193303151e-10,
  -2.282665368999525e-12,   1.586640232873113e-14,  -1.087681071622944e-16,   5.689996434967727e-19,  -4.234516098194960e-21,   3.246033765102309e-02,  -4.356677886169817e-04,
   4.336984053801107e-06,  -3.786427635455776e-08,   3.030408874843632e-10,  -2.282681378919699e-12,   1.586651399655933e-14,  -1.087691748417167e-16,   5.690054709429791e-19,
  -4.234258467775861e-21,   9.026607849729194e-02,  -1.195577812122440e-03,   1.151392613057272e-05,  -9.432421623677204e-08,   6.749982911491549e-10,  -4.200756670422574e-12,
   2.003326564072970e-14,  -6.043351376634054e-17,  -6.227852581860388e-19,   6.128308159102745e-21,   9.026771817306829e-02,  -1.195618102334580e-03,   1.151450271597310e-05,
  -9.433019574216823e-08,   6.750410247401111e-10,  -4.200936761331173e-12,   2.003077324882062e-14,  -6.040155341421831e-17,  -6.233098157545895e-19,   6.149277669712506e-21,
   9.027041002564981e-02,  -1.195684247085919e-03,   1.151544930061553e-05,  -9.434001225333027e-08,   6.751111749966976e-10,  -4.201232340308815e-12,   2.002668008700169e-14,
  -6.034900719723497e-17,  -6.241685711603532e-19,   6.183765757441998e-21,   9.027326637006809e-02,  -1.195754434290537e-03,   1.151645373595355e-05,  -9.435042858224984e-08,
   6.751856046086133e-10,  -4.201545878043166e-12,   2.002233489499561e-14,  -6.029314529058674e-17,  -6.250765271915101e-19,   6.220446129008614e-21,   9.027551438662694e-02,
  -1.195809673807706e-03,   1.151724425781559e-05,  -9.435862647019185e-08,   6.752441773151989e-10,  -4.201792565462338e-12,   2.001891373854490e-14,  -6.024910460486418e-17,
  -6.257887399198468e-19,   6.249375844310033e-21,   9.027681178438905e-02,  -1.195841554342130e-03,   1.151770049385141e-05,  -9.436335770471301e-08,   6.752779792503462e-10,
  -4.201934906143383e-12,   2.001693873498525e-14,  -6.022365693666666e-17,  -6.261988282819883e-19,   6.266096601818874e-21,   9.027729897458182e-02,  -1.195853525937593e-03,
   1.151787181698741e-05,  -9.436513434413540e-08,   6.752906719259386e-10,  -4.201988351292873e-12,   2.001619699062493e-14,  -6.021409523468729e-17,  -6.263526421844016e-19,
   6.272380106732396e-21,   9.027737973356360e-02,  -1.195855510408168e-03,   1.151790021635329e-05,  -9.436542884827874e-08,   6.752927759034473e-10,  -4.201997210317450e-12,
   2.001607403003323e-14,  -6.021250993703551e-17,  -6.263781296308911e-19,   6.273421935172011e-21,   1.772243272382965e-01,  -2.298718780046662e-03,   2.095925782720406e-05,
  -1.530945226045077e-07,   8.595201764451279e-10,  -2.769409107436113e-12,  -1.450880972241195e-14,   3.176106891183745e-16,  -3.943830329021104e-18,   2.026890288134536e-20,
   1.772273113701485e-01,  -2.298784153366001e-03,   2.095999154679173e-05,  -1.530984556476414e-07,   8.594890189782377e-10,  -2.768458269780617e-12,  -1.452453505159798e-14,
   3.177152635442830e-16,  -3.944352457636414e-18,   2.029618651119568e-20,   1.772322103811292e-01,  -2.298891475464824e-03,   2.096119604698964e-05,  -1.531049113959632e-07,
   8.594378446844943e-10,  -2.766897089472828e-12,  -1.455035219563332e-14,   3.178870413028819e-16,  -3.945203808239623e-18,   2.034109371538323e-20,   1.772374087131701e-01,
  -2.299005354158059e-03,   2.096247408862622e-05,  -1.531117601139040e-07,   8.593835118181035e-10,  -2.765240248663313e-12,  -1.457774817118501e-14,   3.180694495285745e-16,
  -3.946099261868596e-18,   2.038890213212769e-20,   1.772414999022050e-01,  -2.299094978483888e-03,   2.096347989515931e-05,  -1.531171491278729e-07,   8.593407276832091e-10,
  -2.763936083255522e-12,  -1.459931038179845e-14,   3.182131064036543e-16,  -3.946798271045033e-18,   2.042664212448516e-20,   1.772438610372225e-01,  -2.299146702914203e-03,
   2.096406035817915e-05,  -1.531202588471467e-07,   8.593160265482977e-10,  -2.763183334481394e-12,  -1.461175492758259e-14,   3.182960539991723e-16,  -3.947199390639292e-18,
   2.044846846003340e-20,   1.772447476725377e-01,  -2.299166126042722e-03,   2.096427832637875e-05,  -1.531214265046821e-07,   8.593067492168779e-10,  -2.762900652927260e-12,
  -1.461642808617934e-14,   3.183272092901194e-16,  -3.947349581725353e-18,   2.045667312512557e-20,   1.772448946453297e-01,  -2.299169345709072e-03,   2.096431445765201e-05,
  -1.531216200567823e-07,   8.593052112709341e-10,  -2.762853793521557e-12,  -1.461720273479300e-14,   3.183323741289766e-16,  -3.947374455187466e-18,   2.045803362244485e-20,
   2.935541104785714e-01,  -3.693060274403209e-03,   3.093370340909510e-05,  -1.834476551632102e-07,   4.944371828042654e-10,   4.705319142820277e-12,  -9.058394599024724e-14,
   7.394237350637227e-16,  -3.966385426207718e-18,  -2.503927062236066e-20,   2.935585134185732e-01,  -3.693138568524361e-03,   3.093412448465368e-05,  -1.834409405106642e-07,
   4.942436345472926e-10,   4.707526833137533e-12,  -9.059968317055463e-14,   7.392958017592434e-16,  -3.963152024196898e-18,  -2.502665122974178e-20,   2.935657416005190e-01,
  -3.693267098923048e-03,   3.093481562884459e-05,  -1.834299150515357e-07,   4.939258695052880e-10,   4.711150838091162e-12,  -9.062550892829044e-14,   7.390858269329140e-16,
  -3.957833563653563e-18,  -2.500571237230974e-20,   2.935734113191668e-01,  -3.693403476793557e-03,   3.093554882385144e-05,  -1.834182131018750e-07,   4.935886632793182e-10,
   4.714995812409912e-12,  -9.065289930150852e-14,   7.388630936398440e-16,  -3.952176254912115e-18,  -2.498319315450751e-20,   2.935794474707304e-01,  -3.693510804854995e-03,
   3.093612573458878e-05,  -1.834090013721982e-07,   4.933232563516469e-10,   4.718021555921432e-12,  -9.067444642372217e-14,   7.386878496705246e-16,  -3.947713777425199e-18,
  -2.496525241840227e-20,   2.935829310689407e-01,  -3.693572745160457e-03,   3.093645863392011e-05,  -1.834036842074900e-07,   4.931700752631944e-10,   4.719767662860836e-12,
  -9.068687797904030e-14,   7.385867324273540e-16,  -3.945134327024168e-18,  -2.495481117865461e-20,   2.935842391979431e-01,  -3.693596004206555e-03,   3.093658363201983e-05,
  -1.834016873900366e-07,   4.931125524344458e-10,   4.720423322815757e-12,  -9.069154544990103e-14,   7.385487655924740e-16,  -3.944164948917754e-18,  -2.495087390156693e-20,
   2.935844560392201e-01,  -3.693599859718218e-03,   3.093660435177403e-05,  -1.834013563800340e-07,   4.931030171069001e-10,   4.720532006753461e-12,  -9.069231911297105e-14,
   7.385424722414316e-16,  -3.944004220060588e-18,  -2.495022037199934e-20,   4.394046948982234e-01,  -5.294696877966433e-03,   3.888087545067179e-05,  -1.473748347880608e-07,
  -6.989751672477648e-10,   1.704162614225147e-11,  -1.422382647344887e-13,   1.871216035696800e-16,   7.979901867426322e-18,  -1.448898352760188e-19,   4.394102267287767e-01,
  -5.294759709836013e-03,   3.888027691692796e-05,  -1.473505786912400e-07,  -6.992784113389759e-10,   1.704217353357549e-11,  -1.422063590488443e-13,   1.863820365379812e-16,
   7.985141496448092e-18,  -1.447891935098496e-19,   4.394193080623461e-01,  -5.294862851036013e-03,   3.887929413986468e-05,  -1.473107578233391e-07,  -6.997761863229631e-10,
   1.704307056935424e-11,  -1.421539655543681e-13,   1.851682933713033e-16,   7.993752947745029e-18,  -1.446235523116082e-19,   4.394289439755054e-01,  -5.294972281651525e-03,
   3.887825108323094e-05,  -1.472685040453511e-07,  -7.003042970813452e-10,   1.704402022544123e-11,  -1.420983514043946e-13,   1.838809296694640e-16,   8.002903620833618e-18,
  -1.444472220194162e-19,   4.394365274292430e-01,  -5.295058396758159e-03,   3.887743000813375e-05,  -1.472352495508258e-07,  -7.007198745242561e-10,   1.704476604028176e-11,
  -1.420545678467967e-13,   1.828681387583335e-16,   8.010114850307473e-18,  -1.443080353589416e-19,   4.394409039644107e-01,  -5.295108092518732e-03,   3.887695607586904e-05,
  -1.472160575118376e-07,  -7.009596929488116e-10,   1.704519583559593e-11,  -1.420292935111177e-13,   1.822837862897665e-16,   8.014280441560009e-18,  -1.442275423042980e-19,
   4.394425473922977e-01,  -5.295126753213151e-03,   3.887677809564799e-05,  -1.472088506688127e-07,  -7.010497434764262e-10,   1.704535710913367e-11,  -1.420198016143916e-13,
   1.820643843103774e-16,   8.015845390238307e-18,  -1.441972850595363e-19,   4.394428198137515e-01,  -5.295129846460927e-03,   3.887674859214325e-05,  -1.472076560292334e-07,
  -7.010646704464309e-10,   1.704538383626005e-11,  -1.420182281368961e-13,   1.820280167792587e-16,   8.016104841276188e-18,  -1.441922678372431e-19,   6.146366246870343e-01,
  -6.970898247998555e-03,   4.128558516195036e-05,  -8.239493595468801e-09,  -2.611894393942918e-09,   2.474122533253982e-11,  -2.186837980702157e-14,  -2.236657823818249e-15,
   2.298043478700465e-17,  -6.168091276376094e-20,   6.146424954438223e-01,  -6.970901641442062e-03,   4.128335475358655e-05,  -8.204341494328592e-09,  -2.611939990517279e-09,
   2.473453629938728e-11,  -2.177709935029756e-14,  -2.236964587772334e-15,   2.296656200195440e-17,  -6.133745769061396e-20,   6.146521330120593e-01,  -6.970907201495197e-03,
   4.127969314937821e-05,  -8.146640511695614e-09,  -2.612014703995180e-09,   2.472355451197858e-11,  -2.162728754996474e-14,  -2.237466915807413e-15,   2.294380619674898e-17,
  -6.077323816202222e-20,   6.146623589054208e-01,  -6.970913086418696e-03,   4.127580786641724e-05,  -8.085424660763783e-09,  -2.612093789609426e-09,   2.471190109541844e-11,
  -2.146837977018354e-14,  -2.237998191552677e-15,   2.291968584583963e-17,  -6.017403878757992e-20,   6.146704065117730e-01,  -6.970917707225737e-03,   4.127275010090494e-05,
  -8.037254235200756e-09,  -2.612155892024285e-09,   2.470272915115765e-11,  -2.134335767288883e-14,  -2.238415052916789e-15,   2.290072134548658e-17,  -5.970209079805149e-20,
   6.146750508523909e-01,  -6.970920369711606e-03,   4.127098539366120e-05,  -8.009456854826652e-09,  -2.612191677081670e-09,   2.469743558493863e-11,  -2.127122066561622e-14,
  -2.238655128318849e-15,   2.288978391811758e-17,  -5.942957033228507e-20,   6.146767948313943e-01,  -6.970921368694064e-03,   4.127032272647034e-05,  -7.999019175097998e-09,
  -2.612205104244951e-09,   2.469544774949780e-11,  -2.124413546669234e-14,  -2.238745183839839e-15,   2.288567819633602e-17,  -5.932720785453668e-20,   6.146770839199759e-01,
  -6.970921534247109e-03,   4.127021287978887e-05,  -7.997289007344528e-09,  -2.612207329436532e-09,   2.469511823475273e-11,  -2.123964586365456e-14,  -2.238760106809738e-15,
   2.288499768757313e-17,  -5.931023831466352e-20,   8.183870808496859e-01,  -8.513284305031281e-03,   3.374116590357477e-05,   2.460436934445954e-07,  -4.235901341395033e-09,
   8.097104910022620e-12,   3.664887087466393e-13,  -4.091645924240542e-15,  -1.272192500715332e-17,   5.511499517956516e-19,   8.183918752011888e-01,  -8.513179223230612e-03,
   3.373755353296720e-05,   2.460551134023918e-07,  -4.235119639647115e-09,   8.084922253212151e-12,   3.664375190090653e-13,  -4.088826895658041e-15,  -1.274598517455797e-17,
   5.509799216927739e-19,   8.183997455344965e-01,  -8.513006710943164e-03,   3.373162372403339e-05,   2.460738485998637e-07,  -4.233836428920337e-09,   8.064928535979138e-12,
   3.663534138826072e-13,  -4.084199628421270e-15,  -1.278541267577004e-17,   5.507014577755368e-19,   8.184080960627927e-01,  -8.512823657310634e-03,   3.372533239354404e-05,
   2.460937110917142e-07,  -4.232474950859759e-09,   8.043721926729196e-12,   3.662640783309093e-13,  -4.079290587510842e-15,  -1.282715160331994e-17,   5.504068931399930e-19,
   8.184146676078324e-01,  -8.512679589693272e-03,   3.372038155766805e-05,   2.461093306709051e-07,  -4.231403538492061e-09,   8.027038200943777e-12,   3.661937031649961e-13,
  -4.075427758890774e-15,  -1.285993035454308e-17,   5.501757253732918e-19,   8.184184600288317e-01,  -8.512596444073066e-03,   3.371752452358028e-05,   2.461183401034073e-07,
  -4.230785236753079e-09,   8.017412096302878e-12,   3.661530612052722e-13,  -4.073198690077854e-15,  -1.287881955448331e-17,   5.500425767481785e-19,   8.184198840930063e-01,
  -8.512565221804911e-03,   3.371645171480160e-05,   2.461217223027908e-07,  -4.230553064217529e-09,   8.013797851844758e-12,   3.661377946311918e-13,  -4.072361698861374e-15,
  -1.288590733389830e-17,   5.499926277656185e-19,   8.184201201505698e-01,  -8.512560046253290e-03,   3.371627388328610e-05,   2.461222829015802e-07,  -4.230514578608622e-09,
   8.013198763018876e-12,   3.661352637083103e-13,  -4.072222958027642e-15,  -1.288708195504057e-17,   5.499843506254765e-19,   1.048174010007513e+00,  -9.599001154449836e-03,
   1.184292791283520e-05,   5.507967919723400e-07,  -3.183859138010210e-09,  -4.751777710217049e-11,   6.119640740286532e-13,   3.071887013551711e-15,  -1.092156949542400e-16,
   4.308671277173754e-20,   1.048175689891254e+00,  -9.598766245770388e-03,   1.184021676314326e-05,   5.507292482235349e-07,  -3.182557974687280e-09,  -4.750859366563830e-11,
   6.115309964057954e-13,   3.072091915722606e-15,  -1.091142737834718e-16,   4.249405867556716e-20,   1.048178447414692e+00,  -9.598380625967384e-03,   1.183576677338627e-05,
   5.506183736723254e-07,  -3.180422571506069e-09,  -4.749351713550818e-11,   6.108203212402598e-13,   3.072426124518727e-15,  -1.089478147152462e-16,   4.152419937937032e-20,
   1.048181372982963e+00,  -9.597971481834843e-03,   1.183104607903035e-05,   5.505007400389220e-07,  -3.178157649938175e-09,  -4.747751918607346e-11,   6.100666365356625e-13,
   3.072777801167005e-15,  -1.087712433491247e-16,   4.049928333978775e-20,   1.048183675147486e+00,  -9.597649503728064e-03,   1.182733165584000e-05,   5.504081710440644e-07,
  -3.176375800716681e-09,  -4.746492829370511e-11,   6.094737697925017e-13,   3.073052445377709e-15,  -1.086323202188947e-16,   3.969569200915908e-20,   1.048185003662197e+00,
  -9.597463692073689e-03,   1.182518830542426e-05,   5.503547513920555e-07,  -3.175347723563166e-09,  -4.745766167497105e-11,   6.091317298614356e-13,   3.073210096861571e-15,
  -1.085521607668203e-16,   3.923313444756682e-20,   1.048185502511995e+00,  -9.597393919500962e-03,   1.182438351572016e-05,   5.503346924856075e-07,  -3.174961720047515e-09,
  -4.745493295560007e-11,   6.090033122116413e-13,   3.073269135893692e-15,  -1.085220630805254e-16,   3.905966819517124e-20,   1.048185585202399e+00,  -9.597382353780154e-03,
   1.182425011345589e-05,   5.503313674718886e-07,  -3.174897737060210e-09,  -4.745448062963153e-11,   6.089820262951733e-13,   3.073278913987070e-15,  -1.085170741156400e-16,
   3.903092574338720e-20,   1.298023796070561e+00,  -9.751288922669384e-03,  -2.541384279439095e-05,   6.794568409247085e-07,   3.157278846516651e-09,  -9.119390232976463e-11,
  -4.863934273283696e-13,   1.481993529950385e-14,   7.307723609078906e-17,  -2.876144469038460e-18,   1.298020184903353e+00,  -9.750999304667123e-03,  -2.541115283195523e-05,
   6.793274370506761e-07,   3.156244021173010e-09,  -9.114984687294924e-11,  -4.861040383895480e-13,   1.480532414744063e-14,   7.299057501815849e-17,  -2.871539050734711e-18,
   1.298014256863508e+00,  -9.750523889673264e-03,  -2.540673746068251e-05,   6.791150448594832e-07,   3.154545633376375e-09,  -9.107755418829989e-11,  -4.856292082153501e-13,
   1.478135459035137e-14,   7.284847521340042e-17,  -2.863983659385546e-18,   1.298007967129515e+00,  -9.750019491742156e-03,  -2.540205327663538e-05,   6.788897417561571e-07,
   3.152744117891138e-09,  -9.100088882301773e-11,  -4.851257143081049e-13,   1.475594415030356e-14,   7.269792512908105e-17,  -2.855973795480717e-18,   1.298003017346889e+00,
  -9.749622567098744e-03,  -2.539836742615540e-05,   6.787124714906452e-07,   3.151326753776782e-09,  -9.094058372162811e-11,  -4.847297061846020e-13,   1.473596272642823e-14,
   7.257960704168358e-17,  -2.849675046554843e-18,   1.298000160839197e+00,  -9.749393509828229e-03,  -2.539624050105416e-05,   6.786101831714849e-07,   3.150508940764305e-09,
  -9.090579286705841e-11,  -4.845012599825077e-13,   1.472443775789519e-14,   7.251138973830795e-17,  -2.846041940431085e-18,   1.297999088212688e+00,  -9.749307499513186e-03,
  -2.539544186701963e-05,   6.785717762576413e-07,   3.150201877017124e-09,  -9.089273089807146e-11,  -4.844154946446315e-13,   1.472011128401939e-14,   7.248578600755505e-17,
  -2.844678055511561e-18,   1.297998910410575e+00,  -9.749293242228892e-03,  -2.539530948450219e-05,   6.785654099395424e-07,   3.150150978555562e-09,  -9.089056581332706e-11,
  -4.844012787870958e-13,   1.471939417584737e-14,   7.248154248447225e-17,  -2.844451992240571e-18,   1.554621396963608e+00,  -8.375359662730767e-03,  -6.662055079165874e-05,
   2.496354052069510e-07,   1.054779225781898e-08,   3.271613478550748e-11,  -1.725042431768185e-12,  -1.919320696661939e-14,   2.218995287887833e-16,   5.747711411480330e-18,
   1.554611934438730e+00,  -8.375252925181960e-03,  -6.661156542025202e-05,   2.496814827467597e-07,   1.054412044693039e-08,   3.265924194107354e-11,  -1.724159808451644e-12,
  -1.916405997691562e-14,   2.218246529860495e-16,   5.736557211738221e-18,   1.554596401093118e+00,  -8.375077684109694e-03,  -6.659681674114456e-05,   2.497570681626910e-07,
   1.053809393585808e-08,   3.256590589009952e-11,  -1.722711056493913e-12,  -1.911625160654435e-14,   2.217014772574268e-16,   5.718268406715989e-18,   1.554579920263590e+00,
  -8.374891720618392e-03,  -6.658117032679743e-05,   2.498371909005469e-07,   1.053170119100222e-08,   3.246695437459917e-11,  -1.721174114093899e-12,  -1.906557908429117e-14,
   2.215704328491207e-16,   5.698893292310903e-18,   1.554566950669582e+00,  -8.374745352501718e-03,  -6.656885874183561e-05,   2.499001905790394e-07,   1.052667140590895e-08,
   3.238914069593656e-11,  -1.719964746537431e-12,  -1.902573994664342e-14,   2.214670509658759e-16,   5.683667202804744e-18,   1.554559466026175e+00,  -8.374660875041432e-03,
  -6.656175437731849e-05,   2.499365259509160e-07,   1.052376915514700e-08,   3.234425761385211e-11,  -1.719266882832351e-12,  -1.900276418521988e-14,   2.214072876333321e-16,
   5.674888833474663e-18,   1.554556655536738e+00,  -8.374629151864836e-03,  -6.655908678636340e-05,   2.499501659030324e-07,   1.052267943253784e-08,   3.232740823982994e-11,
  -1.719004844331212e-12,  -1.899413961586266e-14,   2.213848271110423e-16,   5.671594150959691e-18,   1.554556189661503e+00,  -8.374623893238840e-03,  -6.655864460387156e-05,
   2.499524266913363e-07,   1.052249880076710e-08,   3.232461546121421e-11,  -1.718961408556952e-12,  -1.899271013130535e-14,   2.213811029671942e-16,   5.671048098915761e-18,
   1.790309198658735e+00,  -5.157785200402784e-03,  -7.644827573552091e-05,  -6.397568650399962e-07,   1.589218873526018e-09,   1.453922973812344e-10,   2.091188436172289e-12,
   1.919520586335190e-15,  -4.912538398056821e-16,  -9.434079419605051e-18,   1.790298322287265e+00,  -5.158057595582395e-03,  -7.644689364272427e-05,  -6.395499198458269e-07,
   1.593659425916278e-09,   1.453972686015267e-10,   2.089225906560625e-12,   1.871587609699794e-15,  -4.915004285246739e-16,  -9.419262396353670e-18,   1.790280467108896e+00,
  -5.158504712501155e-03,  -7.644462198060213e-05,  -6.392101810120213e-07,   1.600946280953174e-09,   1.454053263886646e-10,   2.086003398050157e-12,   1.792952909196788e-15,
  -4.919031984695023e-16,  -9.394914658241036e-18,   1.790261521582670e+00,  -5.158979051327763e-03,  -7.644220785798812e-05,  -6.388496853773953e-07,   1.608674078234290e-09,
   1.454137360284999e-10,   2.082583121305628e-12,   1.709590262659616e-15,  -4.923277900697808e-16,  -9.369048380883202e-18,   1.790246611497444e+00,  -5.159352295644794e-03,
  -7.644030524290543e-05,  -6.385659687764305e-07,   1.614752912503593e-09,   1.454202529329066e-10,   2.079890663025554e-12,   1.644037650712759e-15,  -4.926599352904409e-16,
  -9.348668780592519e-18,   1.790238006653248e+00,  -5.159567677052356e-03,  -7.643920612935686e-05,  -6.384022285322716e-07,   1.618259930823418e-09,   1.454239732859475e-10,
   2.078336519953011e-12,   1.606227706247995e-15,  -4.928508171960727e-16,  -9.336898234657225e-18,   1.790234775459568e+00,  -5.159648550152118e-03,  -7.643879319772301e-05,
  -6.383407420952768e-07,   1.619576625038280e-09,   1.454253626285853e-10,   2.077752872321750e-12,   1.592033808487840e-15,  -4.929223430255989e-16,  -9.332476563859400e-18,
   1.790234239843539e+00,  -5.159661955774865e-03,  -7.643872473765581e-05,  -6.383305498199743e-07,   1.619794874026323e-09,   1.454255925265437e-10,   2.077656121660698e-12,
   1.589681183746494e-15,  -4.929341914261674e-16,  -9.331743518286161e-18,   1.955972424141101e+00,  -1.307840083771734e-03,  -2.796159622956517e-05,  -5.018293828721138e-07,
  -7.784183383840892e-09,  -1.021538955833483e-10,  -1.022639631116954e-12,  -4.088905046729943e-15,   1.334069464849300e-16,   4.661599887335370e-18,   1.955968431609653e+00,
  -1.308054839754470e-03,  -2.796825503658083e-05,  -5.019748549179010e-07,  -7.786359837693338e-09,  -1.021657281265544e-10,  -1.022095394624420e-12,  -4.064727582397257e-15,
   1.340165591074687e-16,   4.672615337279755e-18,   1.955961876536038e+00,  -1.308407441379200e-03,  -2.797918788741853e-05,  -5.022136828408237e-07,  -7.789931992603866e-09,
  -1.021851007454573e-10,  -1.021200183133148e-12,  -4.024995563158318e-15,   1.350179443278224e-16,   4.690700125082270e-18,   1.955954920162383e+00,  -1.308781640012495e-03,
  -2.799079031004934e-05,  -5.024671140283036e-07,  -7.793721173336265e-09,  -1.022055853053690e-10,  -1.020247902667714e-12,  -3.982781368621921e-15,   1.360813163177406e-16,
   4.709891004937628e-18,   1.955949444783510e+00,  -1.309076180512659e-03,  -2.799992279725522e-05,  -5.026665774851244e-07,  -7.796702443440541e-09,  -1.022216551104713e-10,
  -1.019496720389276e-12,  -3.949518425584761e-15,   1.369187923516796e-16,   4.724995404804057e-18,   1.955946284564198e+00,  -1.309246183316795e-03,  -2.800519386310162e-05,
  -5.027816964610233e-07,  -7.798422657601379e-09,  -1.022309085923182e-10,  -1.019062503667291e-12,  -3.930305635985372e-15,   1.374023551508960e-16,   4.733712872438336e-18,
   1.955945097819178e+00,  -1.309310024409939e-03,  -2.800717330070077e-05,  -5.028249256713976e-07,  -7.799068551738449e-09,  -1.022343794495590e-10,  -1.018899319627582e-12,
  -3.923088000299007e-15,   1.375839829433236e-16,   4.736986447189007e-18,   1.955944901096501e+00,  -1.309320607161648e-03,  -2.800750142608912e-05,  -5.028320915787298e-07,
  -7.799175614591837e-09,  -1.022349545871410e-10,  -1.018872262607577e-12,  -3.921891413384134e-15,   1.376140927311893e-16,   4.737529093202559e-18,   3.416811098213450e-03,
  -4.493743878120892e-05,   4.423632539295148e-07,  -3.871984360182747e-09,   3.158800440807554e-11,  -2.493690624849680e-13,   1.853005591730732e-15,  -1.463000666389169e-17,
   9.216612658945015e-20,  -7.085212961113759e-22,   3.416874104038193e-03,  -4.493909307177457e-05,   4.423902475979239e-07,  -3.872339600353057e-09,   3.159196423654218e-11,
  -2.494128408572135e-13,   1.853374442525446e-15,  -1.463359540026349e-17,   9.224330088203845e-20,  -7.069926388965980e-22,   3.416977541079727e-03,  -4.494180896725788e-05,
   4.424345645198515e-07,  -3.872922829656223e-09,   3.159846550597736e-11,  -2.494847178675443e-13,   1.853980194139093e-15,  -1.463948122555768e-17,   9.237017913487953e-20,
  -7.044822997900226e-22,   3.417087299558584e-03,  -4.494469089150303e-05,   4.424815915246581e-07,  -3.873541742286227e-09,   3.160536463041483e-11,  -2.495609954262186e-13,
   1.854623247249251e-15,  -1.464571883859175e-17,   9.250505680682058e-20,  -7.018175587741668e-22,   3.417173682797676e-03,  -4.494695908908462e-05,   4.425186044324996e-07,
  -3.874028874138352e-09,   3.161079483894972e-11,  -2.496210338595478e-13,   1.855129553637132e-15,  -1.465062229476250e-17,   9.261138708065831e-20,  -6.997196225200878e-22,
   3.417223537352299e-03,  -4.494826815357917e-05,   4.425399662706612e-07,  -3.874310025238740e-09,   3.161392894354688e-11,  -2.496556862556978e-13,   1.855421841300871e-15,
  -1.465344993883322e-17,   9.267282478411308e-20,  -6.985085563136356e-22,   3.417242258440880e-03,  -4.494875972850171e-05,   4.425479880357659e-07,  -3.874415603633985e-09,
   3.161510587353439e-11,  -2.496686991498455e-13,   1.855531614932502e-15,  -1.465451132455437e-17,   9.269590893364840e-20,  -6.980537313877719e-22,   3.417245361740233e-03,
  -4.494884121451336e-05,   4.425493177677792e-07,  -3.874433104941550e-09,   3.161530096877078e-11,  -2.496708562536331e-13,   1.855549812364830e-15,  -1.465468724212722e-17,
   9.269973618339690e-20,  -6.979783346199326e-22,   3.078045558839767e-02,  -4.026121349959813e-04,   3.908726584132063e-06,  -3.334216839982841e-08,   2.607665500258726e-10,
  -1.934597132889353e-12,   1.304234768567155e-14,  -9.268909800062278e-17,   4.367443169672455e-19,  -2.666015356842915e-21,   3.078101227697704e-02,  -4.026263792376179e-04,
   3.908949395973458e-06,  -3.334492381433760e-08,   2.607944111601896e-10,  -1.934874340450075e-12,   1.304409797822654e-14,  -9.270232106714655e-17,   4.372265785259808e-19,
  -2.649818227042885e-21,   3.078192619434649e-02,  -4.026497643170812e-04,   3.909315194883466e-06,  -3.334944755854905e-08,   2.608401524284852e-10,  -1.935329449816872e-12,
   1.304697276474742e-14,  -9.272396883099293e-17,   4.380198592246151e-19,  -2.623219428509958e-21,   3.078289596253557e-02,  -4.026745788512158e-04,   3.909703359194424e-06,
  -3.335424798864840e-08,   2.608886911301765e-10,  -1.935812394412056e-12,   1.305002503795954e-14,  -9.274685716511485e-17,   4.388637232054105e-19,  -2.594984477052116e-21,
   3.078365919780603e-02,  -4.026941088580573e-04,   3.910008863487068e-06,  -3.335802623320105e-08,   2.609268940094462e-10,  -1.936192502080789e-12,   1.305242857244884e-14,
  -9.276481129840147e-17,   4.395293902814236e-19,  -2.572755124851951e-21,   3.078409968486874e-02,  -4.027053803428647e-04,   3.910185182779085e-06,  -3.336020684459296e-08,
   2.609489427070809e-10,  -1.936411880748228e-12,   1.305381625278788e-14,  -9.277514928283267e-17,   4.399141771504559e-19,  -2.559922831573844e-21,   3.078426509385409e-02,
  -4.027096129609946e-04,   3.910251393710101e-06,  -3.336102570713363e-08,   2.609572224143776e-10,  -1.936494261714977e-12,   1.305433744526385e-14,  -9.277902681929179e-17,
   4.400587850660756e-19,  -2.555103557360577e-21,   3.078429251285141e-02,  -4.027103145813844e-04,   3.910262369187360e-06,  -3.336116144644335e-08,   2.609585949050377e-10,
  -1.936507917649900e-12,   1.305442384590273e-14,  -9.277966934013607e-17,   4.400827620484499e-19,  -2.554304661021115e-21,   8.566107241761130e-02,  -1.107816584362714e-03,
   1.044414582859660e-05,  -8.417085467681627e-08,   5.956432409521578e-10,  -3.742328772634544e-12,   1.809221806176480e-14,  -7.720362142594544e-17,  -4.266333889351127e-19,
   6.018386503529288e-21,   8.566255971948701e-02,  -1.107852537577819e-03,   1.044465463374100e-05,  -8.417618222871791e-08,   5.956818407917042e-10,  -3.742558974760208e-12,
   1.809053309749725e-14,  -7.717141956071582e-17,  -4.259145827445184e-19,   6.069361034832688e-21,   8.566500141866709e-02,  -1.107911562245326e-03,   1.044548994357212e-05,
  -8.418492850421298e-08,   5.957452060856753e-10,  -3.742936818368178e-12,   1.808776905084437e-14,  -7.711836604228206e-17,  -4.247302252987580e-19,   6.153069380733616e-21,
   8.566759232150059e-02,  -1.107974194217100e-03,   1.044637630426740e-05,  -8.419420930037055e-08,   5.958124380424301e-10,  -3.743337643685554e-12,   1.808483903765985e-14,
  -7.706181531513710e-17,  -4.234676648116234e-19,   6.241924638892316e-21,   8.566963142726448e-02,  -1.108023487528224e-03,   1.044707389825463e-05,  -8.420151356873994e-08,
   5.958653474003730e-10,  -3.743653025667592e-12,   1.808253517356945e-14,  -7.701712359398085e-17,  -4.224697813112837e-19,   6.311878751096311e-21,   8.567080825576665e-02,
  -1.108051936311460e-03,   1.044747650279050e-05,  -8.420572909824544e-08,   5.958958814056380e-10,  -3.743835010799746e-12,   1.808120640074508e-14,  -7.699125655606761e-17,
  -4.218921846240734e-19,   6.352260405547504e-21,   8.567125017048262e-02,  -1.108062619235218e-03,   1.044762768657478e-05,  -8.420731208914581e-08,   5.959073470355425e-10,
  -3.743903342731697e-12,   1.808070759083894e-14,  -7.698152912973681e-17,  -4.216749704729463e-19,   6.367425955707276e-21,   8.567132342437860e-02,  -1.108064390089220e-03,
   1.044765274754481e-05,  -8.420757449347734e-08,   5.959092476176512e-10,  -3.743914669448011e-12,   1.808062491427122e-14,  -7.697991592590196e-17,  -4.216389471968412e-19,
   6.369939959432899e-21,   1.683534894277389e-01,  -2.138163783447554e-03,   1.920275606022113e-05,  -1.398014491724267e-07,   8.012993218040035e-10,  -3.024504648670780e-12,
  -7.275365220192930e-15,   2.028251828229352e-16,  -3.221642776929155e-18,   2.196089332100580e-20,   1.683562234966948e-01,  -2.138223482954188e-03,   1.920344015597478e-05,
  -1.398057481298714e-07,   8.012836396865786e-10,  -3.023896671099288e-12,  -7.288169214299546e-15,   2.029402385048385e-16,  -3.220062328496641e-18,   2.205577328749681e-20,
   1.683607119838584e-01,  -2.138321490684505e-03,   1.920456320017711e-05,  -1.398128049383578e-07,   8.012578752148654e-10,  -3.022898327306231e-12,  -7.309184437838631e-15,
   2.031294726981771e-16,  -3.217458371780076e-18,   2.221157883655367e-20,   1.683654747114644e-01,  -2.138425486266873e-03,   1.920575482369971e-05,  -1.398202919067954e-07,
   8.012305102972934e-10,  -3.021838666896906e-12,  -7.331476940909952e-15,   2.033307428436966e-16,  -3.214682617126835e-18,   2.237696076170605e-20,   1.683692230724979e-01,
  -2.138507332644060e-03,   1.920669262813138e-05,  -1.398261835742091e-07,   8.012089545466680e-10,  -3.021004461736256e-12,  -7.349016704286164e-15,   2.034894896905110e-16,
  -3.212488858693513e-18,   2.250716032234683e-20,   1.683713863527590e-01,  -2.138554568312846e-03,   1.920723384958049e-05,  -1.398295835236863e-07,   8.011965065193005e-10,
  -3.020522926567529e-12,  -7.359137415542184e-15,   2.035812443907555e-16,  -3.211219103377158e-18,   2.258231816436771e-20,   1.683721986912652e-01,  -2.138572305875231e-03,
   1.920743708289302e-05,  -1.398308601918346e-07,   8.011918306904500e-10,  -3.020342086587417e-12,  -7.362937497070886e-15,   2.036157254286979e-16,  -3.210741599747412e-18,
   2.261054390079675e-20,   1.683723333482776e-01,  -2.138575246135313e-03,   1.920747077168544e-05,  -1.398310718153910e-07,   8.011910555273014e-10,  -3.020312108783493e-12,
  -7.363567396703751e-15,   2.036214425384015e-16,  -3.210662409879341e-18,   2.261522289001775e-20,   2.792630649816638e-01,  -3.454255229139375e-03,   2.878253899297027e-05,
  -1.748951586417961e-07,   5.684032914359512e-10,   2.764718886721723e-12,  -7.176354489428084e-14,   6.022386401721890e-16,  -4.461867677385103e-18,  -4.845202004648730e-23,
   2.792671619226309e-01,  -3.454329881780651e-03,   2.878302345153227e-05,  -1.748912090476762e-07,   5.682498946300427e-10,   2.766518710366237e-12,  -7.178120508557066e-14,
   6.022420007372981e-16,  -4.456169015865855e-18,   8.587399375117436e-23,   2.792738877641787e-01,  -3.454452434954627e-03,   2.878381867395660e-05,  -1.748847232982350e-07,
   5.679980417555969e-10,   2.769473421866561e-12,  -7.181018063861779e-14,   6.022480156957037e-16,  -4.446796711469291e-18,   3.064788742030782e-22,   2.792810244697276e-01,
  -3.454582471688244e-03,   2.878466233768443e-05,  -1.748778389004358e-07,   5.677307694476624e-10,   2.772608612923881e-12,  -7.184090347579601e-14,   6.022550750936095e-16,
  -4.436828851022481e-18,   5.406749045267256e-22,   2.792866411436174e-01,  -3.454684810081910e-03,   2.878532621226407e-05,  -1.748724190212523e-07,   5.675203979998660e-10,
   2.775076035214274e-12,  -7.186506622439641e-14,   6.022611212241931e-16,  -4.428967370302486e-18,   7.250724643286229e-22,   2.792898826556398e-01,  -3.454743871089375e-03,
   2.878570930990117e-05,  -1.748692903726651e-07,   5.673989778097263e-10,   2.776500037210759e-12,  -7.187900448404232e-14,   6.022648071642339e-16,  -4.424423658962316e-18,
   8.315253299539770e-22,   2.792910998793589e-01,  -3.454766048994113e-03,   2.878585315981082e-05,  -1.748681153959695e-07,   5.673533812963222e-10,   2.777034764959840e-12,
  -7.188423720311899e-14,   6.022662284360559e-16,  -4.422716185064707e-18,   8.715057263110950e-22,   2.792913016518098e-01,  -3.454769725294479e-03,   2.878587700461979e-05,
  -1.748679206194816e-07,   5.673458229147700e-10,   2.777123403782945e-12,  -7.188510453598013e-14,   6.022664659929352e-16,  -4.422433080103123e-18,   8.781333801638643e-22,
   4.188365651461625e-01,  -4.990889278701759e-03,   3.705592846327906e-05,  -1.560150147311936e-07,  -3.917258482993230e-10,   1.371507054034440e-11,  -1.341561103364044e-13,
   3.665799013790140e-16,   3.516349839858822e-18,  -9.718889559007909e-20,   4.188418378011118e-01,  -4.990955815962096e-03,   3.705559236900271e-05,  -1.559954880021397e-07,
  -3.920120497723241e-10,   1.371615821074510e-11,  -1.341418670491995e-13,   3.660886520305512e-16,   3.527508831358412e-18,  -9.694120472269014e-20,   4.188504936829785e-01,
  -4.991065041619177e-03,   3.705504043926320e-05,  -1.559634305996917e-07,  -3.924818737244385e-10,   1.371794274102806e-11,  -1.341184521175138e-13,   3.652831054235970e-16,
   3.545851084155451e-18,  -9.653437305603606e-20,   4.188596781956879e-01,  -4.991180930296032e-03,   3.705445455915415e-05,  -1.559294137010954e-07,  -3.929803632086483e-10,
   1.371983483051893e-11,  -1.340935631703906e-13,   3.644296072230146e-16,   3.565344802461584e-18,  -9.610241351229758e-20,   4.188669064214633e-01,  -4.991272129365926e-03,
   3.705399329466946e-05,  -1.559026411252672e-07,  -3.933726552807293e-10,   1.372132287672292e-11,  -1.340739436285733e-13,   3.637588042956040e-16,   3.580709000163562e-18,
  -9.576225787138377e-20,   4.188710779582759e-01,  -4.991324759756327e-03,   3.705372702026564e-05,  -1.558871897082975e-07,  -3.935990459724382e-10,   1.372218124141775e-11,
  -1.340626080470885e-13,   3.633720335407081e-16,   3.589585004167344e-18,  -9.556586717293365e-20,   4.188726444092548e-01,  -4.991344522542146e-03,   3.705362701841483e-05,
  -1.558813874644431e-07,  -3.936840562766981e-10,   1.372250348732641e-11,  -1.340583490105846e-13,   3.632268658489660e-16,   3.592919736615092e-18,  -9.549210540011789e-20,
   4.188729040707905e-01,  -4.991347798483082e-03,   3.705361044098218e-05,  -1.558804256550868e-07,  -3.936981478642935e-10,   1.372255690005424e-11,  -1.340576428870008e-13,
   3.632028058439881e-16,   3.593472606152437e-18,  -9.547987753444805e-20,   5.874120211149122e-01,  -6.641682176025792e-03,   4.095215156486201e-05,  -4.611955357919077e-08,
  -2.126972158282634e-09,   2.354541076166692e-11,  -7.462981075490239e-14,  -1.549510749254734e-15,   1.971258513151228e-17,  -1.036123038630975e-19,   5.874178452529909e-01,
  -6.641701747249245e-03,   4.095033456543899e-05,  -4.608608590330112e-08,  -2.127130530186670e-09,   2.354077191151783e-11,  -7.455121846544443e-14,  -1.550026316553575e-15,
   1.971474278198946e-17,  -1.030446975081490e-19,   5.874274063314889e-01,  -6.641733866262918e-03,   4.094735156928790e-05,  -4.603114807001693e-08,  -2.127390402024208e-09,
   2.353315538431265e-11,  -7.442219009978549e-14,  -1.550870600395021e-15,   1.971831715045643e-17,  -1.021126711093919e-19,   5.874375511209702e-01,  -6.641767932998004e-03,
   4.094418624729315e-05,  -4.597286127034531e-08,  -2.127665981302285e-09,   2.352507216240726e-11,  -7.428527227772214e-14,  -1.551763591797396e-15,   1.972215359479094e-17,
  -1.011234380393427e-19,   5.874455349398755e-01,  -6.641794733546705e-03,   4.094169502632466e-05,  -4.592699395027041e-08,  -2.127882744298872e-09,   2.351870954174029e-11,
  -7.417751085427152e-14,  -1.552464310397903e-15,   1.972520454433469e-17,  -1.003447050041419e-19,   5.874501424842383e-01,  -6.641810196598682e-03,   4.094025725554781e-05,
  -4.590052490611332e-08,  -2.128007794622634e-09,   2.351503711563950e-11,  -7.411531705981770e-14,  -1.552867878808619e-15,   1.972697798040838e-17,  -9.989520288438899e-20,
   5.874518726490436e-01,  -6.641816002359451e-03,   4.093971735105942e-05,  -4.589058587278358e-08,  -2.128054743220208e-09,   2.351365800129949e-11,  -7.409196218427421e-14,
  -1.553019265869363e-15,   1.972764631720720e-17,  -9.972639531761337e-20,   5.874521594478909e-01,  -6.641816964706833e-03,   4.093962785377918e-05,  -4.588893835452284e-08,
  -2.128062525145232e-09,   2.351342938904276e-11,  -7.408809075361221e-14,  -1.553044352164618e-15,   1.972775722985147e-17,  -9.969841225510756e-20,   7.848908949174929e-01,
  -8.232681829155869e-03,   3.629382790044933e-05,   1.800031541265717e-07,  -3.995445688464343e-09,   1.548929194776105e-11,   2.489908814488718e-13,  -4.211355660806320e-15,
   4.346188640130664e-18,   4.030895418167732e-19,   7.848960529415534e-01,  -8.232604904363767e-03,   3.629041942541450e-05,   1.800250905789327e-07,  -3.994913989217641e-09,
   1.547673976133856e-11,   2.490078277803797e-13,  -4.209276324518174e-15,   4.328202503569500e-18,   4.036214526390185e-19,   7.849045203229849e-01,  -8.232478613119890e-03,
   3.628482419004182e-05,   1.800610899197861e-07,  -3.994041092877505e-09,   1.545613781593327e-11,   2.490355966285646e-13,  -4.205860787455598e-15,   4.298762779239956e-18,
   4.044947138090292e-19,   7.849135043936984e-01,  -8.232344599179741e-03,   3.627888765866946e-05,   1.800992704787677e-07,  -3.993114847131783e-09,   1.543428367780904e-11,
   2.490649919428926e-13,  -4.202233961127310e-15,   4.267643695501013e-18,   4.054213670609401e-19,   7.849205745603708e-01,  -8.232239122867151e-03,   3.627421590005925e-05,
   1.801293060934789e-07,  -3.992385861363075e-09,   1.541708878786250e-11,   2.490880759403086e-13,  -4.199377691084156e-15,   4.243238716440691e-18,   4.061506856493027e-19,
   7.849246547538483e-01,  -8.232178247764540e-03,   3.627151986619774e-05,   1.801466351495996e-07,  -3.991965139210533e-09,   1.540716705764668e-11,   2.491013780517500e-13,
  -4.197728504657864e-15,   4.229188538043393e-18,   4.065716038593201e-19,   7.849261868809965e-01,  -8.232155388055452e-03,   3.627050750312917e-05,   1.801531414215534e-07,
  -3.991807151930044e-09,   1.540344168523518e-11,   2.491063693291906e-13,  -4.197109071867265e-15,   4.223919057984739e-18,   4.067296654097676e-19,   7.849264408516262e-01,
  -8.232151598704943e-03,   3.627033969074996e-05,   1.801542198785672e-07,  -3.991780963175199e-09,   1.540282416915820e-11,   2.491071965046293e-13,  -4.197006384266740e-15,
   4.223045909165372e-18,   4.067558665075926e-19,   1.010008041638770e+00,  -9.478752420755411e-03,   1.811812506869993e-05,   4.930724017762960e-07,  -3.982395816500801e-09,
  -3.218777133534530e-11,   6.501138340600968e-13,  -2.827917011134203e-16,  -9.711503177407917e-17,   6.055931200612793e-19,   1.010010613158979e+00,  -9.478542079131669e-03,
   1.811473255808257e-05,   4.930265895396002e-07,  -3.981012651492861e-09,  -3.218856708054196e-11,   6.497285267318213e-13,  -2.797011119442267e-16,  -9.703521237895562e-17,
   6.051473385697453e-19,   1.010014834378021e+00,  -9.478196783441759e-03,   1.810916405484703e-05,   4.929513805385256e-07,  -3.978742555803377e-09,  -3.218986675709361e-11,
   6.490962126637658e-13,  -2.746290407729374e-16,  -9.690410481270477e-17,   6.044180857434624e-19,   1.010019312945377e+00,  -9.477830417226456e-03,   1.810325660023985e-05,
   4.928715768914589e-07,  -3.976334615271483e-09,  -3.219123675392356e-11,   6.484255916335721e-13,  -2.692493928885314e-16,  -9.676489305109827e-17,   6.036477771903983e-19,
   1.010022837259505e+00,  -9.477542098990139e-03,   1.809860824046982e-05,   4.928087702197678e-07,  -3.974440137154183e-09,  -3.219230839010838e-11,   6.478980361152711e-13,
  -2.650171789476375e-16,  -9.665526290845304e-17,   6.030440578616466e-19,   1.010024871073061e+00,  -9.477375710469993e-03,   1.809592591702981e-05,   4.927725229488451e-07,
  -3.973347030726569e-09,  -3.219292422381609e-11,   6.475936644338173e-13,  -2.625753244278314e-16,  -9.659196528596312e-17,   6.026966469059454e-19,   1.010025634764374e+00,
  -9.477313230979280e-03,   1.809491874138383e-05,   4.927589116792151e-07,  -3.972936602604231e-09,  -3.219315497874330e-11,   6.474793870298632e-13,  -2.616585043744734e-16,
  -9.656819112597019e-17,   6.025663807985261e-19,   1.010025761355774e+00,  -9.477302874164935e-03,   1.809475179095265e-05,   4.927566554133377e-07,  -3.972868570600357e-09,
  -3.219319320347090e-11,   6.474604448213012e-13,  -2.615065346858008e-16,  -9.656424994057172e-17,   6.025447973529950e-19,   1.258664682938737e+00,  -9.921268976855326e-03,
  -1.701911022359123e-05,   7.148926091721998e-07,   1.251228191311335e-09,  -9.772172236303655e-11,  -5.470512434482297e-14,   1.544987385413436e-14,  -3.364589843202203e-17,
  -2.863731139796926e-18,   1.258662263141385e+00,  -9.920964263302431e-03,  -1.701804254108307e-05,   7.147539316376120e-07,   1.251109851080937e-09,  -9.767578302787521e-11,
  -5.483720540664635e-14,   1.543534404340136e-14,  -3.355025265555063e-17,  -2.858465263545155e-18,   1.258658290761997e+00,  -9.920464069376239e-03,  -1.701628984092722e-05,
   7.145263171695843e-07,   1.250915373708152e-09,  -9.760039746466486e-11,  -5.505376245658358e-14,   1.541151047105061e-14,  -3.339324607499329e-17,  -2.849825066144591e-18,
   1.258654075909369e+00,  -9.919933382965438e-03,  -1.701443019052004e-05,   7.142848646877574e-07,   1.250708742886248e-09,  -9.752045005861321e-11,  -5.528317196440451e-14,
   1.538624765188033e-14,  -3.322666545592173e-17,  -2.840663390960756e-18,   1.258650758906017e+00,  -9.919515771961221e-03,  -1.701296670827490e-05,   7.140948866834675e-07,
   1.250545924202398e-09,  -9.745756178511058e-11,  -5.546344749198160e-14,   1.536638481868342e-14,  -3.309557681428651e-17,  -2.833457626147250e-18,   1.258648844641735e+00,
  -9.919274777314016e-03,  -1.701212213309159e-05,   7.139852652442005e-07,   1.250451878590608e-09,  -9.742128005497590e-11,  -5.556737941413585e-14,   1.535492925838670e-14,
  -3.301992746474333e-17,  -2.829300851644666e-18,   1.258648125824631e+00,  -9.919184284608260e-03,  -1.701180499220243e-05,   7.139441048153267e-07,   1.250416548458846e-09,
  -9.740765823285414e-11,  -5.560638635649508e-14,   1.535062903084468e-14,  -3.299152122487675e-17,  -2.827740284302393e-18,   1.258648006670837e+00,  -9.919169284314779e-03,
  -1.701175242185027e-05,   7.139372820703210e-07,   1.250410691188998e-09,  -9.740540034367007e-11,  -5.561285123260220e-14,   1.534991628302517e-14,  -3.298681252846024e-17,
  -2.827481616015175e-18,   1.520077098269958e+00,  -8.893438296326776e-03,  -6.259849107219421e-05,   4.212193163184748e-07,   1.074951099642404e-08,  -1.414655119249245e-11,
  -2.133303699958584e-12,  -8.997244278316319e-15,   4.049806273843139e-16,   4.008157648064579e-18,   1.520068208450178e+00,  -8.893258540475856e-03,  -6.258933834931888e-05,
   4.211989607504014e-07,   1.074497626443253e-08,  -1.417311531908077e-11,  -2.131699692118124e-12,  -8.976955612771815e-15,   4.045134167168596e-16,   3.998989763790239e-18,
   1.520053615309132e+00,  -8.892963448479172e-03,  -6.257431546551550e-05,   4.211655166013536e-07,   1.073753423735657e-08,  -1.421668096881337e-11,  -2.129067794756216e-12,
  -8.943682204173035e-15,   4.037471795646720e-16,   3.983969293009150e-18,   1.520038132131662e+00,  -8.892650341662369e-03,  -6.255837881849599e-05,   4.211299928456174e-07,
   1.072964102640723e-08,  -1.426284818811535e-11,  -2.126276969697588e-12,  -8.908422312610685e-15,   4.029351817052448e-16,   3.968072253650341e-18,   1.520025947711222e+00,
  -8.892403931181250e-03,  -6.254583933968790e-05,   4.211020087449326e-07,   1.072343145610325e-08,  -1.429913912708960e-11,  -2.124081893547521e-12,  -8.880705681182013e-15,
   4.022968870517331e-16,   3.955590722644835e-18,   1.520018916213304e+00,  -8.892261725372226e-03,  -6.253860366183881e-05,   4.210858478695398e-07,   1.071984876470334e-08,
  -1.432006614933405e-11,  -2.122815600120325e-12,  -8.864723119016956e-15,   4.019288160301074e-16,   3.948399205482218e-18,   1.520016275885727e+00,  -8.892208326149150e-03,
  -6.253588680084982e-05,   4.210797772777739e-07,   1.071850361233809e-08,  -1.432792120673681e-11,  -2.122340194096069e-12,  -8.858724010102690e-15,   4.017906586384822e-16,
   3.945700951226350e-18,   1.520015838217320e+00,  -8.892199474488499e-03,  -6.253543645322435e-05,   4.210787708836258e-07,   1.071828064377905e-08,  -1.432922312364401e-11,
  -2.122261394004022e-12,  -8.857729703882055e-15,   4.017677600766423e-16,   3.945253794661218e-18,   1.768407187806593e+00,  -5.799408808715074e-03,  -8.386803693442472e-05,
  -5.883574626681302e-07,   4.992765727098165e-09,   1.941291789511191e-10,   1.872706062737580e-12,  -1.934418827287547e-14,  -8.337411334299914e-16,  -8.691631071515847e-18,
   1.768395261387105e+00,  -5.799659017327901e-03,  -8.386375148412350e-05,  -5.880816971696389e-07,   4.996723937633677e-09,   1.940706747734646e-10,   1.869397148669031e-12,
  -1.938779299460384e-14,  -8.331063547566208e-16,  -8.657227753493072e-18,   1.768375682683108e+00,  -5.800069690294982e-03,  -8.385671379336977e-05,  -5.876290439243426e-07,
   5.003216882884403e-09,   1.939745371085785e-10,   1.863966871215085e-12,  -1.945925000393613e-14,  -8.320620841817262e-16,  -8.600774345306231e-18,   1.768354908768146e+00,
  -5.800505330590526e-03,  -8.384924295794890e-05,  -5.871488260547110e-07,   5.010099472662655e-09,   1.938724005706230e-10,   1.858207431960216e-12,  -1.953489859176565e-14,
  -8.309510763533138e-16,  -8.540907276069458e-18,   1.768338560024712e+00,  -5.800848098202535e-03,  -8.384336098210524e-05,  -5.867709516298434e-07,   5.015511092902473e-09,
   1.937919267123688e-10,   1.853676539249794e-12,  -1.959430934061431e-14,  -8.300745709750634e-16,  -8.493816536195159e-18,   1.768329125020311e+00,  -5.801045882589786e-03,
  -8.383996542159676e-05,  -5.865528967990742e-07,   5.018632235274778e-09,   1.937454468895172e-10,   1.851062401395073e-12,  -1.962854631768189e-14,  -8.295678674904485e-16,
  -8.466649580366401e-18,   1.768325582115442e+00,  -5.801120146261609e-03,  -8.383869017398688e-05,  -5.864710195586757e-07,   5.019803875505490e-09,   1.937279863056047e-10,
   1.850080904516130e-12,  -1.964139316992619e-14,  -8.293774338239875e-16,  -8.456450017419783e-18,   1.768324994829994e+00,  -5.801132456194156e-03,  -8.383847877390132e-05,
  -5.864574474724317e-07,   5.019998071611125e-09,   1.937250915974565e-10,   1.849918214635885e-12,  -1.964352221986348e-14,  -8.293458582034193e-16,  -8.454759394130651e-18,
   1.950252334292151e+00,  -1.557902049839620e-03,  -3.480265219797768e-05,  -6.440824420086468e-07,  -1.007871179655727e-08,  -1.274042983016790e-10,  -1.046163326345981e-12,
   3.728820700391746e-15,   3.860662678404797e-16,   9.877258065066367e-18,   1.950247364287928e+00,  -1.558177662985620e-03,  -3.481127038440218e-05,  -6.442636459619402e-07,
  -1.008092637099958e-08,  -1.273923387203596e-10,  -1.044602253213422e-12,   3.779841237434497e-15,   3.871623431495487e-16,   9.892874845369076e-18,   1.950239204332940e+00,
  -1.558630182474584e-03,  -3.482541989341615e-05,  -6.445611089446842e-07,  -1.008455953281610e-08,  -1.273725946541854e-10,  -1.042036340485863e-12,   3.863657360088835e-15,
   3.889620323337917e-16,   9.918489086533469e-18,   1.950230544782087e+00,  -1.559110416605403e-03,  -3.484043546532685e-05,  -6.448767229293210e-07,  -1.008841130591258e-08,
  -1.273514944563656e-10,  -1.039309415555232e-12,   3.952671053646486e-15,   3.908720523105707e-16,   9.945636115192529e-18,   1.950223728795408e+00,  -1.559488418399422e-03,
  -3.485225413760873e-05,  -6.451251002695604e-07,  -1.009144028569171e-08,  -1.273347796741897e-10,  -1.037160202521664e-12,   4.022781959140347e-15,   3.923755432376984e-16,
   9.966977977015290e-18,   1.950219794805587e+00,  -1.559706592676424e-03,  -3.485907546072983e-05,  -6.452684386530258e-07,  -1.009318741207608e-08,  -1.273250896101349e-10,
  -1.035918603375256e-12,   4.063267033865449e-15,   3.932433548582101e-16,   9.979285543583338e-18,   1.950218317487015e+00,  -1.559788523454578e-03,  -3.486163703672220e-05,
  -6.453222626874912e-07,  -1.009384329442664e-08,  -1.273214426448772e-10,  -1.035452134975181e-12,   4.078473871108516e-15,   3.935692488952332e-16,   9.983905408199065e-18,
   1.950218072596820e+00,  -1.559802104873656e-03,  -3.486206165995375e-05,  -6.453311847412612e-07,  -1.009395200676488e-08,  -1.273208376729161e-10,  -1.035374798732992e-12,
   4.080994848282378e-15,   3.936232716627741e-16,   9.984671124552360e-18,   3.243856533358257e-03,  -4.157616007223426e-05,   3.987747668364072e-07,  -3.404192567958971e-09,
   2.701379950809238e-11,  -2.094991458597618e-13,   1.481589769363057e-15,  -1.197676452402718e-17,   7.782162816733769e-20,  -2.479799353182270e-24,   3.243913328357778e-03,
  -4.157761445147231e-05,   3.987978503509827e-07,  -3.404491002815822e-09,   2.701696585246133e-11,  -2.095349366485136e-13,   1.481903180182985e-15,  -1.197669790377789e-17,
   7.798163375504895e-20,   4.810404098504964e-25,   3.244006568921319e-03,  -4.158000214260299e-05,   3.988357476324688e-07,  -3.404980968760383e-09,   2.702216440466911e-11,
  -2.095936928270396e-13,   1.482418156168221e-15,  -1.197657762319766e-17,   7.824440782691517e-20,   5.334993885098775e-24,   3.244105507600866e-03,  -4.158253579280268e-05,
   3.988759622364584e-07,  -3.405500910550710e-09,   2.702768113057525e-11,  -2.096560373978018e-13,   1.482965212732248e-15,  -1.197643517871296e-17,   7.852336526988675e-20,
   1.047623561422591e-23,   3.244183375204178e-03,  -4.158452987960280e-05,   3.989076132667197e-07,  -3.405910143713341e-09,   2.703202330119027e-11,  -2.097051026928418e-13,
   1.483396203385830e-15,  -1.197631235668452e-17,   7.874300259034643e-20,   1.451576516941510e-23,   3.244228315059781e-03,  -4.158568074247916e-05,   3.989258804671273e-07,
  -3.406146334701244e-09,   2.703452944460459e-11,  -2.097334191466467e-13,   1.483645118650892e-15,  -1.197623718115681e-17,   7.886979801938632e-20,   1.684438599846510e-23,
   3.244245190599937e-03,  -4.158611290981178e-05,   3.989327401284356e-07,  -3.406235029511704e-09,   2.703547056265017e-11,  -2.097440522397101e-13,   1.483738623237543e-15,
  -1.197620814108902e-17,   7.891741820682023e-20,   1.771830111848353e-23,   3.244247987971635e-03,  -4.158618454809599e-05,   3.989338772231826e-07,  -3.406249732090951e-09,
   2.703562656835102e-11,  -2.097458148261830e-13,   1.483754124777606e-15,  -1.197620328451336e-17,   7.892531231607739e-20,   1.786313840028054e-23,   2.923010906036399e-02,
  -3.728746522660669e-04,   3.532430064273056e-06,  -2.946328680338020e-08,   2.250024276214423e-10,  -1.651208379604063e-12,   1.063353135209582e-14,  -7.947043388925453e-17,
   4.205009800506805e-19,   2.614809088700043e-21,   2.923061213771603e-02,  -3.728872391016380e-04,   3.532622309993993e-06,  -2.946563859724394e-08,   2.250251463299240e-10,
  -1.651445645550243e-12,   1.063523396261670e-14,  -7.945627443608496e-17,   4.218051460404001e-19,   2.643307416429171e-21,   2.923143804042797e-02,  -3.729079031560989e-04,
   3.532937926495088e-06,  -2.946949969155712e-08,   2.250624454091980e-10,  -1.651835124931456e-12,   1.063803283422351e-14,  -7.943292433265775e-17,   4.239469801681038e-19,
   2.690031558479044e-21,   2.923231441397941e-02,  -3.729298303028928e-04,   3.533272839075890e-06,  -2.947359694275093e-08,   2.251020262098085e-10,  -1.652248350309177e-12,
   1.064100776600399e-14,  -7.940800539297184e-17,   4.262207594915785e-19,   2.739527183172001e-21,   2.923300414407764e-02,  -3.729470877979852e-04,   3.533536430852241e-06,
  -2.947682174112949e-08,   2.251331791131149e-10,  -1.652573530094616e-12,   1.064335275570160e-14,  -7.938829085250198e-17,   4.280110471996817e-19,   2.778420824856279e-21,
   2.923340220862474e-02,  -3.729570477226224e-04,   3.533688560358928e-06,  -2.947868293159647e-08,   2.251511591079307e-10,  -1.652761185345999e-12,   1.064470757969423e-14,
  -7.937687186833131e-17,   4.290445808248529e-19,   2.800843156810769e-21,   2.923355168729863e-02,  -3.729607878275663e-04,   3.533745687548256e-06,  -2.947938184531868e-08,
   2.251579109724169e-10,  -1.652831649418650e-12,   1.064521661021733e-14,  -7.937257611683510e-17,   4.294327439384615e-19,   2.809258435386464e-21,   2.923357646560640e-02,
  -3.729614078063552e-04,   3.533755157252817e-06,  -2.947949770123206e-08,   2.251590302010290e-10,  -1.652843329723746e-12,   1.064530100411876e-14,  -7.937186362264873e-17,
   4.294970907416511e-19,   2.810653149202375e-21,   8.139073684434897e-02,  -1.028147142610886e-03,   9.488881739526705e-06,  -7.521650292808026e-08,   5.249567348956579e-10,
  -3.335353125623629e-12,   1.578157516015352e-14,  -8.590943856840421e-17,  -5.022831483925763e-20,   1.747348684115167e-20,   8.139208808369784e-02,  -1.028179270970557e-03,
   9.489330161584980e-06,  -7.522125153446804e-08,   5.249904209180232e-10,  -3.335608390589491e-12,   1.578144173105928e-14,  -8.581764598500755e-17,  -4.701572848990969e-20,
   1.755837297624900e-20,   8.139430640799743e-02,  -1.028232016340061e-03,   9.490066339778118e-06,  -7.522904740255618e-08,   5.250457218069188e-10,  -3.336027249604745e-12,
   1.578123195091807e-14,  -8.566664056497795e-17,  -4.173947471944488e-20,   1.769755675341757e-20,   8.139666028436082e-02,  -1.028287985248322e-03,   9.490847510026618e-06,
  -7.523731977737676e-08,   5.251044001031090e-10,  -3.336471419561696e-12,   1.578102195388669e-14,  -8.550598704403925e-17,  -3.613789048005307e-20,   1.784500938906471e-20,
   8.139851284292321e-02,  -1.028332034517493e-03,   9.491462315599055e-06,  -7.524383043768604e-08,   5.251505800767622e-10,  -3.336820786547842e-12,   1.578086580769306e-14,
  -8.537924436815979e-17,  -3.172720513640437e-20,   1.796088708745471e-20,   8.139958200893270e-02,  -1.028357456791042e-03,   9.491817140127377e-06,  -7.524758797039595e-08,
   5.251772313829742e-10,  -3.337022333962416e-12,   1.578077935036338e-14,  -8.530597551599316e-17,  -2.918083163361969e-20,   1.802769482857448e-20,   8.139998349484807e-02,
  -1.028367003216987e-03,   9.491950381817946e-06,  -7.524899898082076e-08,   5.251872392024517e-10,  -3.337098002057726e-12,   1.578074757622672e-14,  -8.527843906268294e-17,
  -2.822447716174151e-20,   1.805276902340231e-20,   8.140005004706717e-02,  -1.028368585679505e-03,   9.491972468617217e-06,  -7.524923287702565e-08,   5.251888981412042e-10,
  -3.337110544337975e-12,   1.578074234568849e-14,  -8.527387327402213e-17,  -2.806593898085991e-20,   1.805692475585917e-20,   1.600977550516813e-01,  -1.991038901224272e-03,
   1.760004129433781e-05,  -1.274723363063512e-07,   7.394663751438370e-10,  -3.141788177362834e-12,  -2.900667342795370e-15,   1.154437895609898e-16,  -2.103551916032860e-18,
   4.516659830203700e-20,   1.601002609364890e-01,  -1.991093337758707e-03,   1.760067264763977e-05,  -1.274768043535323e-07,   7.394600855589931e-10,  -3.141439400029780e-12,
  -2.908915859854688e-15,   1.156796891773600e-16,  -2.097132721772676e-18,   4.533483889826404e-20,   1.601043748170160e-01,  -1.991182705520816e-03,   1.760170911238303e-05,
  -1.274841390159939e-07,   7.394497475319647e-10,  -3.140866313097920e-12,  -2.922438619615658e-15,   1.160675769185512e-16,  -2.086589517040763e-18,   4.561068329445707e-20,
   1.601087400506497e-01,  -1.991277533500404e-03,   1.760280887630805e-05,  -1.274919211700822e-07,   7.394387609018786e-10,  -3.140257526310040e-12,  -2.936762140250762e-15,
   1.164799981788135e-16,  -2.075395524452578e-18,   4.590289950586284e-20,   1.601121755764958e-01,  -1.991352164977643e-03,   1.760367439247539e-05,  -1.274980454114902e-07,
   7.394301019365893e-10,  -3.139777902495050e-12,  -2.948016594395387e-15,   1.168051852300328e-16,  -2.066580872294358e-18,   4.613253004792881e-20,   1.601141583113116e-01,
  -1.991395236807286e-03,   1.760417389724776e-05,  -1.275015796886855e-07,   7.394250997000221e-10,  -3.139500899427722e-12,  -2.954504449690790e-15,   1.169931011101396e-16,
  -2.061491801187562e-18,   4.626491580383553e-20,   1.601149028528030e-01,  -1.991411410810583e-03,   1.760436146596704e-05,  -1.275029068180161e-07,   7.394232203699667e-10,
  -3.139396843670364e-12,  -2.956939321910851e-15,   1.170637115022882e-16,  -2.059580434508587e-18,   4.631460177006805e-20,   1.601150262714684e-01,  -1.991414091888572e-03,
   1.760439255815179e-05,  -1.275031268072795e-07,   7.394229087945067e-10,  -3.139379592915408e-12,  -2.957342863923204e-15,   1.170754186174891e-16,  -2.059263578638287e-18,
   4.632283654743429e-20,   2.658934957317495e-01,  -3.232231657429812e-03,   2.673990036252305e-05,  -1.654464849006316e-07,   6.077579193984839e-10,   1.228894064113169e-12,
  -5.684179060211205e-14,   4.679804414874672e-16,  -3.602465318484172e-18,   5.549833475505024e-20,   2.658973020581739e-01,  -3.232302283957996e-03,   2.674041860453327e-05,
  -1.654447242424425e-07,   6.076364174510282e-10,   1.230297275546111e-12,  -5.685587231083329e-14,   4.682719716274273e-16,  -3.589333613863949e-18,   5.576739156796651e-20,
   2.659035508124058e-01,  -3.232418228291767e-03,   2.674126930765461e-05,  -1.654418323917217e-07,   6.074369307533586e-10,   1.232601508673142e-12,  -5.687895184011840e-14,
   4.687515572720636e-16,  -3.567766061528642e-18,   5.620848843354554e-20,   2.659101812961805e-01,  -3.232541253453961e-03,   2.674217186746517e-05,  -1.654387619498595e-07,
   6.072252306419064e-10,   1.235047341585424e-12,  -5.690338951447662e-14,   4.692617813367302e-16,  -3.544868057539671e-18,   5.667570505611944e-20,   2.659153995743072e-01,
  -3.232638074369369e-03,   2.674288211295900e-05,  -1.654363440731611e-07,   6.070586003474466e-10,   1.236972851044342e-12,  -5.692258480049527e-14,   4.696643043874228e-16,
  -3.526837728200984e-18,   5.704281151071207e-20,   2.659184111657206e-01,  -3.232693951398942e-03,   2.674329197992947e-05,  -1.654349480988072e-07,   6.069624262586962e-10,
   1.238084351482766e-12,  -5.693364782296022e-14,   4.698969984323411e-16,  -3.516428289435304e-18,   5.725443683614349e-20,   2.659195420522250e-01,  -3.232714933738732e-03,
   2.674344588345905e-05,  -1.654344237887270e-07,   6.069263103287913e-10,   1.238501778480254e-12,  -5.693779927127043e-14,   4.699844510591460e-16,  -3.512518728625237e-18,
   5.733385904458773e-20,   2.659197295130604e-01,  -3.232718411859754e-03,   2.674347139487694e-05,  -1.654343368711377e-07,   6.069203235119005e-10,   1.238570975488357e-12,
  -5.693848728412178e-14,   4.699989514708443e-16,  -3.511870625393178e-18,   5.734702202683098e-20,   3.994539213982910e-01,  -4.702017392669519e-03,   3.515463788255440e-05,
  -1.602594741310048e-07,  -1.487365337724624e-10,   1.062852782228366e-11,  -1.227298263111782e-13,   4.395806919691466e-16,   1.660953630991599e-18,   7.064737532092784e-21,
   3.994589239031280e-01,  -4.702085757493805e-03,   3.515450940093891e-05,  -1.602443378563328e-07,  -1.489984289434925e-10,   1.062984227790169e-11,  -1.227227162043518e-13,
   4.396285790432805e-16,   1.684643126371011e-18,   7.501140909238677e-21,   3.994671363112269e-01,  -4.702197984747298e-03,   3.515429831596683e-05,  -1.602194878586633e-07,
  -1.494283610331779e-10,   1.063200028063312e-11,  -1.227109755090377e-13,   4.397088025144895e-16,   1.723546845209918e-18,   8.216659845672281e-21,   3.994758502930265e-01,
  -4.702317060190673e-03,   3.515407411886228e-05,  -1.601931182513319e-07,  -1.498845369053728e-10,   1.063429024122987e-11,  -1.226984248711846e-13,   4.397961108570317e-16,
   1.764845046380446e-18,   8.974645104748552e-21,   3.994827082295245e-01,  -4.702410768595284e-03,   3.515389751554366e-05,  -1.601723639000825e-07,  -1.502435385886082e-10,
   1.063609256446161e-11,  -1.226884802086161e-13,   4.398664035555536e-16,   1.797360149912396e-18,   9.570287434498555e-21,   3.994866660735807e-01,  -4.702464847706030e-03,
   3.515379553057319e-05,  -1.601603856242986e-07,  -1.504507210055684e-10,   1.063713276591290e-11,  -1.226827139889385e-13,   4.399076039394649e-16,   1.816130516827594e-18,
   9.913684621703269e-21,   3.994881522823974e-01,  -4.702485154601716e-03,   3.515375722215486e-05,  -1.601558875617272e-07,  -1.505285192158312e-10,   1.063752338055453e-11,
  -1.226805436196552e-13,   4.399231946974101e-16,   1.823179968124482e-18,   1.004256564733865e-20,   3.994883986427301e-01,  -4.702488520741978e-03,   3.515375087135061e-05,
  -1.601551419381486e-07,  -1.505414153380153e-10,   1.063758813098047e-11,  -1.226801835810036e-13,   4.399257853969585e-16,   1.824348567827645e-18,   1.006392593172067e-20,
   5.614962512977497e-01,  -6.316822149919890e-03,   4.020971501861932e-05,  -7.649467057205321e-08,  -1.677134779376378e-09,   2.130174576660704e-11,  -1.096893475593788e-13,
  -9.691373915220376e-16,   1.706885160243402e-17,  -1.707178792220464e-20,   5.615019705531868e-01,  -6.316854700175558e-03,   4.020828168543048e-05,  -7.646438108507305e-08,
  -1.677368107854776e-09,   2.129884854211028e-11,  -1.096207634607992e-13,  -9.692028514022883e-16,   1.709637425252231e-17,  -1.625108133873815e-20,   5.615113594892440e-01,
  -6.316908127349057e-03,   4.020592849321873e-05,  -7.641465896899742e-08,  -1.677751048205222e-09,   2.129409215197124e-11,  -1.095080922018825e-13,  -9.693072859153702e-16,
   1.714157325538865e-17,  -1.490514758587830e-20,   5.615213216758212e-01,  -6.316964805017437e-03,   4.020343137898320e-05,  -7.636190400932373e-08,  -1.678157233236630e-09,
   2.128904508505869e-11,  -1.093884314034115e-13,  -9.694139858799325e-16,   1.718955464076613e-17,  -1.347889840367625e-20,   5.615291618240370e-01,  -6.317009401451365e-03,
   4.020146599549018e-05,  -7.632038851000518e-08,  -1.678476798477396e-09,   2.128507289706289e-11,  -1.092941795949555e-13,  -9.694949835212055e-16,   1.722733186792663e-17,
  -1.235780387952299e-20,   5.615336864687699e-01,  -6.317035135242201e-03,   4.020033167754601e-05,  -7.629643027850285e-08,  -1.678661183915175e-09,   2.128278042259440e-11,
  -1.092397537079105e-13,  -9.695405367323692e-16,   1.724914006716374e-17,  -1.171134864699769e-20,   5.615353855068758e-01,  -6.317044797840398e-03,   4.019990571916290e-05,
  -7.628743394641766e-08,  -1.678730414556768e-09,   2.128191956684265e-11,  -1.092193103245350e-13,  -9.695574171819628e-16,   1.725733043418372e-17,  -1.146870238736727e-20,
   5.615356671461820e-01,  -6.317046399517632e-03,   4.019983510989856e-05,  -7.628594268731892e-08,  -1.678741890108497e-09,   2.128177686721853e-11,  -1.092159212287098e-13,
  -9.695602034781292e-16,   1.725868816642876e-17,  -1.142848579099481e-20,   7.525530482929651e-01,  -7.934752359927615e-03,   3.808146913039320e-05,   1.188393498056310e-07,
  -3.635317623303153e-09,   2.007855895528128e-11,   1.350843468353968e-13,  -3.854923460176535e-15,   1.774783505512293e-17,   3.747343280131483e-19,   7.525584613270779e-01,
  -7.934701524205168e-03,   3.807836677492095e-05,   1.188678260968040e-07,  -3.635028426927435e-09,   2.006706995059997e-11,   1.351553578537881e-13,  -3.852971502443115e-15,
   1.776190052781514e-17,   3.759347957307919e-19,   7.525673473800604e-01,  -7.934618060372602e-03,   3.807327393491379e-05,   1.189145627345641e-07,  -3.634553554541087e-09,
   2.004821312660266e-11,   1.352719747403062e-13,  -3.849762621039267e-15,   1.778504272566529e-17,   3.779031223129928e-19,   7.525767757361527e-01,  -7.934529486882173e-03,
   3.806787028078309e-05,   1.189641378809309e-07,  -3.634049529065054e-09,   2.002821034197623e-11,   1.353957698119005e-13,  -3.846351738302551e-15,   1.780966807431209e-17,
   3.799883548438887e-19,   7.525841955885212e-01,  -7.934459770455650e-03,   3.806361775235635e-05,   1.190031421712389e-07,  -3.633652750333940e-09,   2.001247222206809e-11,
   1.354932374610100e-13,  -3.843663007025880e-15,   1.782909862530175e-17,   3.816270410825658e-19,   7.525884776047831e-01,  -7.934419532286165e-03,   3.806116360551163e-05,
   1.190256476564827e-07,  -3.633423718255319e-09,   2.000339112090226e-11,   1.355495041131332e-13,  -3.842109545763612e-15,   1.784033246729475e-17,   3.825717947664817e-19,
   7.525900855207244e-01,  -7.934404421800148e-03,   3.806024206228756e-05,   1.190340978105167e-07,  -3.633337706244413e-09,   1.999998139397671e-11,   1.355706358585094e-13,
  -3.841525876534285e-15,   1.784455467688777e-17,   3.829263768018328e-19,   7.525903520545543e-01,  -7.934401916986342e-03,   3.806008930401011e-05,   1.190354984981074e-07,
  -3.633323448090472e-09,   1.999941619965264e-11,   1.355741389091637e-13,  -3.841429107648418e-15,   1.784525476833865e-17,   3.829851442258298e-19,   9.724188086074458e-01,
  -9.311266612259353e-03,   2.363416410758517e-05,   4.250430543682176e-07,  -4.472482572901127e-09,  -1.700775963222517e-11,   6.026257590114115e-13,  -2.949453069509369e-15,
  -6.676033835494223e-17,   1.078836695069224e-18,   9.724221642578815e-01,  -9.311085237794234e-03,   2.363035257381429e-05,   4.250187774856645e-07,  -4.471199340079677e-09,
  -1.701648542273944e-11,   6.023613716051786e-13,  -2.943915419531470e-15,  -6.668206339991092e-17,   1.079237041764458e-18,   9.724276727104438e-01,  -9.310787489755175e-03,
   2.362409611502018e-05,   4.249789141144790e-07,  -4.469093112705715e-09,  -1.703079825217579e-11,   6.019275628591113e-13,  -2.934823002653143e-15,  -6.655346643980057e-17,
   1.079892359486311e-18,   9.724335170734097e-01,  -9.310471566265698e-03,   2.361745860322834e-05,   4.249366038537331e-07,  -4.466858795599168e-09,  -1.704596900333601e-11,
   6.014675655129945e-13,  -2.925173254058410e-15,  -6.641688513897391e-17,   1.080585091097562e-18,   9.724381162333996e-01,  -9.310222940199767e-03,   2.361223562445177e-05,
   4.249032966696080e-07,  -4.465100776475168e-09,  -1.705789668502970e-11,   6.011057677682652e-13,  -2.917577412347726e-15,  -6.630930115453924e-17,   1.081128378566154e-18,
   9.724407703444989e-01,  -9.310079456194163e-03,   2.360922165304547e-05,   4.248840709219849e-07,  -4.464086349623892e-09,  -1.706477566123826e-11,   6.008970564764800e-13,
  -2.913193127815591e-15,  -6.624717484955998e-17,   1.081441158618375e-18,   9.724417669604906e-01,  -9.310025577082550e-03,   2.360808993573681e-05,   4.248768507973951e-07,
  -4.463705452558108e-09,  -1.706735789262145e-11,   6.008187001869694e-13,  -2.911546676675679e-15,  -6.622383873240803e-17,   1.081558466444227e-18,   9.724419321623203e-01,
  -9.310016645878093e-03,   2.360790234050221e-05,   4.248756539233110e-07,  -4.463642315015918e-09,  -1.706778588734543e-11,   6.008057124008033e-13,  -2.911273748100793e-15,
  -6.621997006420688e-17,   1.081577904283441e-18,   1.218761918034515e+00,  -1.002291496256602e-02,  -8.384614363987526e-06,   7.193491753043442e-07,  -6.823084453672624e-10,
  -9.405483217218612e-11,   3.484797392808273e-13,   1.289695399505446e-14,  -1.189096683829282e-16,  -1.687244209978504e-18,   1.218760723679214e+00,  -1.002260832820820e-02,
  -8.385192768620568e-06,   7.192156525071850e-07,  -6.815701293267851e-10,  -9.401642619553691e-11,   3.480116326426124e-13,   1.288842966671700e-14,  -1.186347447260104e-16,
  -1.682786828438768e-18,   1.218758762892807e+00,  -1.002210497939397e-02,  -8.386141859577242e-06,   7.189964926664564e-07,  -6.803587832102055e-10,  -9.395339490217691e-11,
   3.472439505511962e-13,   1.287445206382288e-14,  -1.181835952733431e-16,  -1.675475010945221e-18,   1.218756682266872e+00,  -1.002157094326267e-02,  -8.387148301849103e-06,
   7.187640007285379e-07,  -6.790744280765564e-10,  -9.388653872470572e-11,   3.464304548774261e-13,   1.285964310799570e-14,  -1.177051387427311e-16,  -1.667724360416139e-18,
   1.218755044745415e+00,  -1.002115069446207e-02,  -8.387939930970299e-06,   7.185810671452077e-07,  -6.780643404833435e-10,  -9.383394057203154e-11,   3.457910071460178e-13,
   1.284800456289917e-14,  -1.173287706272384e-16,  -1.661630180508171e-18,   1.218754099676553e+00,  -1.002090817687051e-02,  -8.388396616805147e-06,   7.184755081448044e-07,
  -6.774816822677183e-10,  -9.380359236398975e-11,   3.454222809979027e-13,   1.284129421406260e-14,  -1.171116333209372e-16,  -1.658115367109392e-18,   1.218753744789411e+00,
  -1.002081711216677e-02,  -8.388568073087680e-06,   7.184358726288451e-07,  -6.772629417995389e-10,  -9.379219767308726e-11,   3.452838795573936e-13,   1.283877563636746e-14,
  -1.170301097372459e-16,  -1.656795946691697e-18,   1.218753685961556e+00,  -1.002080201705025e-02,  -8.388596492638322e-06,   7.184293026297448e-07,  -6.772266852570435e-10,
  -9.379030891185868e-11,   3.452609406443236e-13,   1.283835821068067e-14,  -1.170165967557825e-16,  -1.656577256404859e-18,   1.483537858206435e+00,  -9.371123719808505e-03,
  -5.653042134518583e-05,   5.881083976246318e-07,   9.942233770282167e-09,  -6.679380610922441e-11,  -2.186678789207765e-12,   5.615975732700626e-15,   4.863177021497361e-16,
   3.362839738579160e-19,   1.483529830530156e+00,  -9.370872978653744e-03,  -5.652195853326242e-05,   5.880134870955086e-07,   9.937588909052677e-09,  -6.677699483156516e-11,
  -2.184753999877483e-12,   5.617735171952449e-15,   4.856900486300242e-16,   3.376431032250007e-19,   1.483516652666180e+00,  -9.370461375708903e-03,  -5.650806831673499e-05,
   5.878576934002447e-07,   9.929966580170249e-09,  -6.674939257328554e-11,  -2.181595945547774e-12,   5.620628651303960e-15,   4.846611679042766e-16,   3.398799544804808e-19,
   1.483502671110548e+00,  -9.370024672908640e-03,  -5.649333360785238e-05,   5.876924077605357e-07,   9.921882724933006e-09,  -6.672009923889312e-11,  -2.178247448241288e-12,
   5.623705765207808e-15,   4.835715010896073e-16,   3.422610142021359e-19,   1.483491668404503e+00,  -9.369681014277468e-03,  -5.648174012615283e-05,   5.875623441184310e-07,
   9.915523601271753e-09,  -6.669704145740543e-11,  -2.175613929771257e-12,   5.626132480862022e-15,   4.827154134962950e-16,   3.441403743962053e-19,   1.483485318869057e+00,
  -9.369482693691986e-03,  -5.647505042793786e-05,   5.874872886722271e-07,   9.911854793897466e-09,  -6.668373284668940e-11,  -2.174094782253424e-12,   5.627534997384254e-15,
   4.822219435526166e-16,   3.452271628742925e-19,   1.483482934619875e+00,  -9.369408224519369e-03,  -5.647253859267846e-05,   5.874591058958913e-07,   9.910477340820156e-09,
  -6.667873504465034e-11,  -2.173524460903724e-12,   5.628062036813452e-15,   4.820367530517454e-16,   3.456356719035778e-19,   1.483482539399848e+00,  -9.369395880303040e-03,
  -5.647212223126326e-05,   5.874544342653696e-07,   9.910249019891167e-09,  -6.667790657231276e-11,  -2.173429929025383e-12,   5.628149421225648e-15,   4.820060610014904e-16,
   3.457034096687945e-19,   1.743825273665344e+00,  -6.496926434619230e-03,  -9.031362655678616e-05,  -4.752122891837272e-07,   9.264248711757354e-09,   2.293075632895728e-10,
   9.182616284834267e-13,  -4.986124800812576e-14,  -1.024147109627773e-15,  -3.255411683955931e-19,   1.743812437301935e+00,  -6.497128165050548e-03,  -9.030570552236150e-05,
  -4.748872257977417e-07,   9.266160954350948e-09,   2.291585501588625e-10,   9.142249115967609e-13,  -4.986171641979469e-14,  -1.022021306686868e-15,  -2.807536307118675e-19,
   1.743791365149762e+00,  -6.497459238201145e-03,  -9.029270069707248e-05,  -4.743537348968898e-07,   9.269294005520727e-09,   2.289139207477424e-10,   9.076041072669732e-13,
  -4.986232048583837e-14,  -1.018531872213385e-15,  -2.073514902062370e-19,   1.743769007076412e+00,  -6.497810396519613e-03,  -9.027889999056828e-05,  -4.737878681041871e-07,
   9.272609987657346e-09,   2.286543499024562e-10,   9.005872387317486e-13,  -4.986273757445359e-14,  -1.014829883379332e-15,  -1.296344270484839e-19,   1.743751411957977e+00,
  -6.498086661599484e-03,  -9.026803761842168e-05,  -4.733426787688344e-07,   9.275213585484910e-09,   2.284500663395300e-10,   8.950709472165292e-13,  -4.986290393305933e-14,
  -1.011916817262836e-15,  -6.859249619254812e-20,   1.743741257792874e+00,  -6.498246060157592e-03,  -9.026176827317181e-05,  -4.730858117476404e-07,   9.276713729843517e-09,
   2.283321703735706e-10,   8.918898008130604e-13,  -4.986293511233354e-14,  -1.010235799345388e-15,  -3.341281903942263e-20,   1.743737444863733e+00,  -6.498305908450889e-03,
  -9.025941398520932e-05,  -4.729893670525308e-07,   9.277276587400527e-09,   2.282878992857601e-10,   8.906957048231524e-13,  -4.986293457473189e-14,  -1.009604592644470e-15,
  -2.021172561293895e-20,   1.743736812819359e+00,  -6.498315828769140e-03,  -9.025902372372018e-05,  -4.729733805665803e-07,   9.277369864751382e-09,   2.282805607204571e-10,
   8.904977903825320e-13,  -4.986293383978839e-14,  -1.009499962804810e-15,  -1.802394205615080e-20,   1.943410797038901e+00,  -1.870182857486937e-03,  -4.358753602575511e-05,
  -8.270253951025006e-07,  -1.286062488819925e-08,  -1.494831754737724e-10,  -7.049069184823316e-13,   2.326881663230296e-14,   8.864469871217979e-16,   1.850127315814545e-17,
   1.943404572113153e+00,  -1.870536682149879e-03,  -4.359852525794722e-05,  -8.272375193059016e-07,  -1.286208717985856e-08,  -1.494121173793563e-10,  -7.013408212590568e-13,
   2.336391300780957e-14,   8.880848695563019e-16,   1.851303068564296e-17,   1.943394351758135e+00,  -1.871117607929304e-03,  -4.361656675057967e-05,  -8.275856818042449e-07,
  -1.286448224827119e-08,  -1.492952584024260e-10,  -6.954817878609385e-13,   2.352007189463399e-14,   8.907720422875504e-16,   1.853223392375243e-17,   1.943383505633030e+00,
  -1.871734103861605e-03,  -4.363571137573863e-05,  -8.279550088279547e-07,  -1.286701609481719e-08,  -1.491709824965924e-10,  -6.892585051098942e-13,   2.368582650545025e-14,
   8.936210545978820e-16,   1.855247581016925e-17,   1.943374968561595e+00,  -1.872219353671122e-03,  -4.365077916884739e-05,  -8.282455984282304e-07,  -1.286900480756474e-08,
  -1.490729743003366e-10,  -6.843561204669237e-13,   2.381631806366086e-14,   8.958615816274682e-16,   1.856830896302050e-17,   1.943370041204179e+00,  -1.872499426584915e-03,
  -4.365947543615362e-05,  -8.284132741937583e-07,  -1.287015035180706e-08,  -1.490163307066205e-10,  -6.815250038188107e-13,   2.389164400039086e-14,   8.971539660288666e-16,
   1.857740753263610e-17,   1.943368190848067e+00,  -1.872604601617583e-03,  -4.366274103695841e-05,  -8.284762325930831e-07,  -1.287058010274946e-08,  -1.489950451347046e-10,
  -6.804615409073230e-13,   2.391993279021771e-14,   8.976391428212958e-16,   1.858081674960370e-17,   1.943367884120603e+00,  -1.872622036141527e-03,  -4.366328236051297e-05,
  -8.284866685577580e-07,  -1.287065131836523e-08,  -1.489915159372324e-10,  -6.802852382213724e-13,   2.392462222815775e-14,   8.977195611455887e-16,   1.858138148632571e-17,
   3.083683539312309e-03,  -3.854232185929722e-05,   3.603854703672016e-07,  -3.003668528953204e-09,   2.315371658970796e-11,  -1.776761407502429e-13,   1.182660083479112e-15,
  -9.261442305474913e-18,   9.986826592131195e-20,   1.339688078058388e-21,   3.083734864597618e-03,  -3.854360508574299e-05,   3.604052543640973e-07,  -3.003921607799595e-09,
   2.315624590778746e-11,  -1.777037074484926e-13,   1.183063486422089e-15,  -9.254522221769101e-18,   1.001320890649829e-19,   1.341821940777821e-21,   3.083819125399818e-03,
  -3.854571178784494e-05,   3.604377345603526e-07,  -3.004337106005533e-09,   2.316039881819442e-11,  -1.777489476624663e-13,   1.183726495302908e-15,  -9.243154035668247e-18,
   1.005648194827735e-19,   1.345304756462095e-21,   3.083908535396082e-03,  -3.854794726791006e-05,   3.604722006841897e-07,  -3.004778020199274e-09,   2.316480622778361e-11,
  -1.777969306544339e-13,   1.184431028100724e-15,  -9.231081021515839e-18,   1.010234653138292e-19,   1.348972756603458e-21,   3.083978903540706e-03,  -3.854970667944742e-05,
   3.604993272437302e-07,  -3.005125049844142e-09,   2.316827549871315e-11,  -1.778346787645701e-13,   1.184986243765062e-15,  -9.221571933156255e-18,   1.013840487156423e-19,
   1.351839559394150e-21,   3.084019515177813e-03,  -3.855072210110854e-05,   3.605149831286408e-07,  -3.005325338602701e-09,   2.317027793006553e-11,  -1.778564580195253e-13,
   1.185306967919477e-15,  -9.216081031422650e-18,   1.015919985888791e-19,   1.353486058883519e-21,   3.084034765403511e-03,  -3.855110340787233e-05,   3.605208621857236e-07,
  -3.005400551133155e-09,   2.317102990970475e-11,  -1.778646352275757e-13,   1.185427459399152e-15,  -9.214018573506378e-18,   1.016700574817336e-19,   1.354102826092412e-21,
   3.084037293354735e-03,  -3.855116661523409e-05,   3.605218367297389e-07,  -3.005413018797957e-09,   2.317115456356061e-11,  -1.778659906578306e-13,   1.185447435559938e-15,
  -9.213676661561127e-18,   1.016829953641570e-19,   1.354204984445380e-21,   2.779297332348183e-02,  -3.459706722468354e-04,   3.199423976522949e-06,  -2.611430265096539e-08,
   1.943585263384797e-10,  -1.421034023374402e-12,   8.623965744611160e-15,  -6.261408280607653e-17,   7.009742511961345e-19,   1.403788065974578e-20,   2.779342895895474e-02,
  -3.459818281684184e-04,   3.199590032909477e-06,  -2.611632645578372e-08,   1.943769689560174e-10,  -1.421219983618892e-12,   8.626806429300785e-15,  -6.254161954203675e-17,
   7.032703379409748e-19,   1.405840224963530e-20,   2.779417697544398e-02,  -3.460001430446045e-04,   3.199862652743664e-06,  -2.611964904982056e-08,   1.944072499065058e-10,
  -1.421525110592123e-12,   8.631476465867430e-15,  -6.242258476240394e-17,   7.070362561498274e-19,   1.409190790626237e-20,   2.779497070202336e-02,  -3.460195773938770e-04,
   3.200151938955645e-06,  -2.612317483825693e-08,   1.944393863333012e-10,  -1.421848660615125e-12,   8.636440690436613e-15,  -6.229617864085884e-17,   7.110274489534906e-19,
   1.412721017675235e-20,   2.779559538586281e-02,  -3.460348729444341e-04,   3.200379619946856e-06,  -2.612594984000647e-08,   1.944646822171772e-10,  -1.422103141695541e-12,
   8.640354040474946e-15,  -6.219662351063146e-17,   7.141651021947845e-19,   1.415481241374866e-20,   2.779595590987674e-02,  -3.460437005525128e-04,   3.200511023597921e-06,
  -2.612755142300592e-08,   1.944792827103959e-10,  -1.422249945754328e-12,   8.642615107067789e-15,  -6.213913919354179e-17,   7.159745236222579e-19,   1.417066973047700e-20,
   2.779609129150575e-02,  -3.460470154537682e-04,   3.200560367825945e-06,  -2.612815284756407e-08,   1.944847656705894e-10,  -1.422305060426528e-12,   8.643464650513240e-15,
  -6.211754777125646e-17,   7.166537183490904e-19,   1.417661061389680e-20,   2.779611373301594e-02,  -3.460475649485606e-04,   3.200568547382906e-06,  -2.612825254304313e-08,
   1.944856745671262e-10,  -1.422314195854436e-12,   8.643605500369090e-15,  -6.211396839463735e-17,   7.167662908212480e-19,   1.417759467783844e-20,   7.742444899034383e-02,
  -9.557086326817054e-04,   8.634542656051951e-06,  -6.733108463059396e-08,   4.618445161472492e-10,  -2.984899155202942e-12,   1.348132488649602e-14,  -7.262200604844171e-17,
   1.057966380815069e-18,   4.726615417448802e-20,   7.742567854254177e-02,  -9.557373928192368e-04,   8.634937162624538e-06,  -6.733533415725756e-08,   4.618733452960028e-10,
  -2.985112283667433e-12,   1.348566807583411e-14,  -7.237821891634182e-17,   1.064125280719750e-18,   4.732771594933768e-20,   7.742769709213297e-02,  -9.557846085527237e-04,
   8.635584826839060e-06,  -6.734231066083030e-08,   4.619206797796887e-10,  -2.985461640905461e-12,   1.349281580483097e-14,  -7.197777885437811e-17,   1.074226167210485e-18,
   4.742825807164470e-20,   7.742983898453820e-02,  -9.558347098801135e-04,   8.636272072862813e-06,  -6.734971356607242e-08,   4.619709145418254e-10,  -2.985831618579922e-12,
   1.350042411170850e-14,  -7.155257758155037e-17,   1.084930449871228e-18,   4.753423242930640e-20,   7.743152470514310e-02,  -9.558741411804770e-04,   8.636812956644558e-06,
  -6.735553990530420e-08,   4.620104562484441e-10,  -2.986122273361449e-12,   1.350642926359877e-14,  -7.121772309418356e-17,   1.093344956038336e-18,   4.761712187463143e-20,
   7.743249758351277e-02,  -9.558968982730624e-04,   8.637125118287174e-06,  -6.735890248527333e-08,   4.620332792240374e-10,  -2.986289807573142e-12,   1.350990191461724e-14,
  -7.102438456897293e-17,   1.098197189536088e-18,   4.766475342533340e-20,   7.743286291204757e-02,  -9.559054438855487e-04,   8.637242339417948e-06,  -6.736016518367193e-08,
   4.620418499859903e-10,  -2.986352678947871e-12,   1.351120724471478e-14,  -7.095176753334168e-17,   1.100018505567861e-18,   4.768260069623418e-20,   7.743292347064144e-02,
  -9.559068604483044e-04,   8.637261770568409e-06,  -6.736037449485898e-08,   4.620432707392570e-10,  -2.986363098700084e-12,   1.351142369122861e-14,  -7.093972935077314e-17,
   1.100320375403254e-18,   4.768555708744912e-20,   1.524057898440033e-01,  -1.856160903273951e-03,   1.613927891972745e-05,  -1.161463583775275e-07,   6.761645010103028e-10,
  -3.178395500843099e-12,  -3.000236354999244e-16,   8.378720427719828e-17,   4.789877735120657e-19,   1.046649336382906e-19,   1.524080877429661e-01,  -1.856210504685641e-03,
   1.613985625531599e-05,  -1.161508792729910e-07,   6.761638866461109e-10,  -3.178136478380460e-12,  -2.978598657946339e-16,   8.432671822163129e-17,   4.913041570572141e-19,
   1.047891766507343e-19,   1.524118601755067e-01,  -1.856291934827482e-03,   1.614080404477962e-05,  -1.161583007847645e-07,   6.761628815419312e-10,  -3.177710083585063e-12,
  -2.942723302393089e-16,   8.521286974573739e-17,   5.115036437023384e-19,   1.049920803027277e-19,   1.524158630988772e-01,  -1.856378340400529e-03,   1.614180972219463e-05,
  -1.161661752150459e-07,   6.761618198001729e-10,  -3.177256058480500e-12,  -2.904176554656565e-16,   8.615375724918559e-17,   5.329098349264387e-19,   1.052059345837192e-19,
   1.524190134791687e-01,  -1.856446343415530e-03,   1.614260119527479e-05,  -1.161723721666053e-07,   6.761609876674891e-10,  -3.176897588690478e-12,  -2.873492614465967e-16,
   8.689468225019385e-17,   5.497370158474433e-19,   1.053731950905604e-19,   1.524208316487148e-01,  -1.856485589836401e-03,   1.614305796973428e-05,  -1.161759484415515e-07,
   6.761605088235737e-10,  -3.176690247792264e-12,  -2.855645120083088e-16,   8.732246101123238e-17,   5.594404405547034e-19,   1.054693060174138e-19,   1.524215143938964e-01,
  -1.856500327361876e-03,   1.614322949306107e-05,  -1.161772913481159e-07,   6.761603292777239e-10,  -3.176612302078227e-12,  -2.848916909349313e-16,   8.748312947522245e-17,
   5.630826839772974e-19,   1.055053175569550e-19,   1.524216275689170e-01,  -1.856502770323168e-03,   1.614325792550632e-05,  -1.161775139530327e-07,   6.761602995294211e-10,
  -3.176599376862743e-12,  -2.847800224955233e-16,   8.750976432723791e-17,   5.636863593697613e-19,   1.055112828140712e-19,   2.533800688360610e-01,  -3.026087168027815e-03,
   2.481346994720356e-05,  -1.555956062303949e-07,   6.196979645410031e-10,   1.139324858462450e-14,  -4.492137991096473e-14,   4.035581311726115e-16,   2.503810186118069e-19,
   1.688915339761553e-19,   2.533836010380813e-01,  -3.026153595125614e-03,   2.481399852946097e-05,  -1.555955797042385e-07,   6.196020930177622e-10,   1.261318674767894e-14,
  -4.491991197490803e-14,   4.044287284008289e-16,   2.730746052595672e-19,   1.690927351888591e-19,   2.533893997738124e-01,  -3.026262645950019e-03,   2.481486622364881e-05,
  -1.555955348966493e-07,   6.194447069065090e-10,   1.461779668947785e-14,  -4.491743695476289e-14,   4.058586857850481e-16,   3.102963217058434e-19,   1.694211947044245e-19,
   2.533955527546342e-01,  -3.026378357293442e-03,   2.481578683388103e-05,  -1.555954856379857e-07,   6.192777115442426e-10,   1.674740417375738e-14,  -4.491472225461535e-14,
   4.073769710217995e-16,   3.497458569455075e-19,   1.697672088743299e-19,   2.534003952364831e-01,  -3.026469422721759e-03,   2.481651130078760e-05,  -1.555954456290819e-07,
   6.191462878690661e-10,   1.842527165915736e-14,  -4.491252172757143e-14,   4.085725832785616e-16,   3.807597807978298e-19,   1.700377092962499e-19,   2.534031899489393e-01,
  -3.026521978358326e-03,   2.481692938148329e-05,  -1.555954220409983e-07,   6.190704417335700e-10,   1.939434567455064e-14,  -4.491122610222445e-14,   4.092628796481353e-16,
   3.986452463190855e-19,   1.701930931562118e-19,   2.534042393953188e-01,  -3.026541713521922e-03,   2.481708637053370e-05,  -1.555954130892474e-07,   6.190419609532487e-10,
   1.975838323114527e-14,  -4.491073473400147e-14,   4.095221465814392e-16,   4.053589045709457e-19,   1.702513039044365e-19,   2.534044133562919e-01,  -3.026544984907745e-03,
   2.481711239348336e-05,  -1.555954116003968e-07,   6.190372398667172e-10,   1.981873508627168e-14,  -4.491065302697038e-14,   4.095651266211659e-16,   4.064716569483006e-19,
   1.702609459191923e-19,   3.811961092145728e-01,  -4.428498063850254e-03,   3.322375362643205e-05,  -1.610944270523664e-07,   3.541198096213401e-11,   7.838094920866096e-12,
  -1.094070776168563e-13,   5.302991843009974e-16,   5.188724362683862e-18,   2.054524661863029e-19,   3.812008372569169e-01,  -4.428566799154373e-03,   3.322378254112131e-05,
  -1.610832593283099e-07,   3.517869585278357e-11,   7.839696668279754e-12,  -1.093855945135512e-13,   5.313602133190004e-16,   5.227716350552569e-18,   2.057711761798329e-19,
   3.812085991066163e-01,  -4.428679635834496e-03,   3.322382986537592e-05,  -1.610649240467085e-07,   3.479575415427947e-11,   7.842328493267597e-12,  -1.093502145332225e-13,
   5.331032223755391e-16,   5.291674210475945e-18,   2.062914779876543e-19,   3.812168350331498e-01,  -4.428799359590136e-03,   3.322387988452368e-05,  -1.610454666449286e-07,
   3.438946912425492e-11,   7.845124186699896e-12,  -1.093125215215539e-13,   5.349542578884382e-16,   5.359465193354077e-18,   2.068396013041407e-19,   3.812233167535836e-01,
  -4.428893579424296e-03,   3.322391910828537e-05,  -1.610301519367207e-07,   3.406975383920786e-11,   7.847326674846562e-12,  -1.092827468525950e-13,   5.364121633321680e-16,
   5.412763914073824e-18,   2.072681128432986e-19,   3.812270574823832e-01,  -4.428947954173801e-03,   3.322394168833969e-05,  -1.610213128651129e-07,   3.388525321638556e-11,
   7.848598681187484e-12,  -1.092655192092113e-13,   5.372540008111655e-16,   5.443502312983213e-18,   2.075142672629864e-19,   3.812284621634699e-01,  -4.428968372176027e-03,
   3.322395015664946e-05,  -1.610179935821701e-07,   3.381597391839289e-11,   7.849076503760023e-12,  -1.092590417251386e-13,   5.375702043570333e-16,   5.455040850807952e-18,
   2.076064837435792e-19,   3.812286950094782e-01,  -4.428971756738601e-03,   3.322395155982723e-05,  -1.610174433569863e-07,   3.380449001614259e-11,   7.849155718741533e-12,
  -1.092579675499149e-13,   5.376226241111385e-16,   5.456953315562932e-18,   2.076217585006745e-19,   5.368659019912768e-01,  -5.999240946532767e-03,   3.914434733232922e-05,
  -1.000716921958901e-07,  -1.279301681088985e-09,   1.840613894542198e-11,  -1.289808386557702e-13,  -3.903870953481848e-16,   2.067990689584790e-17,   2.478974730999333e-19,
   5.368714703196954e-01,  -5.999283576841246e-03,   3.914325345436161e-05,  -1.000455085653699e-07,  -1.279576010691901e-09,   1.840499287569871e-11,  -1.288972822287686e-13,
  -3.891010115913169e-16,   2.073565447711420e-17,   2.485009001168439e-19,   5.368806115194961e-01,  -5.999353553316780e-03,   3.914145750760403e-05,  -1.000025250671903e-07,
  -1.280026237616027e-09,   1.840311420505204e-11,  -1.287599507670154e-13,  -3.869874957843584e-16,   2.082708717671989e-17,   2.494871132970981e-19,   5.368903108861480e-01,
  -5.999427792791312e-03,   3.913955163958558e-05,  -9.995691784038168e-08,  -1.280503787021479e-09,   1.840112458240096e-11,  -1.286140140670331e-13,  -3.847419095239893e-16,
   2.092398728542684e-17,   2.505275694725944e-19,   5.368979442280118e-01,  -5.999486211702354e-03,   3.913805154516079e-05,  -9.992102586087764e-08,  -1.280879493263519e-09,
   1.839956148653825e-11,  -1.284990038170543e-13,  -3.829724688565567e-16,   2.100016327264977e-17,   2.513420763818429e-19,   5.369023495345079e-01,  -5.999519923213356e-03,
   3.913718574469284e-05,  -9.990031235728004e-08,  -1.281096269479293e-09,   1.839866049539951e-11,  -1.284325661344038e-13,  -3.819504295413773e-16,   2.104409183719223e-17,
   2.518104058554532e-19,   5.369040037625186e-01,  -5.999532581618988e-03,   3.913686061541297e-05,  -9.989253431752998e-08,  -1.281177661421807e-09,   1.839832237264567e-11,
  -1.284076062169826e-13,  -3.815664812465254e-16,   2.106058100094980e-17,   2.519859396941085e-19,   5.369042779740473e-01,  -5.999534679899154e-03,   3.913680671991662e-05,
  -9.989124500068743e-08,  -1.281191152790429e-09,   1.839826633495423e-11,  -1.284034681253580e-13,  -3.815028277619413e-16,   2.106331397549740e-17,   2.520150196096281e-19,
   7.214310196511158e-01,  -7.625353637572429e-03,   3.917227615199617e-05,   6.402761121661724e-08,  -3.209681314951120e-09,   2.210291225711169e-11,   3.732546835001703e-14,
  -3.040441838033725e-15,   3.452977234430374e-17,   6.056179599840717e-19,   7.214365886435334e-01,  -7.625326191934230e-03,   3.916953604621556e-05,   6.405898903813441e-08,
  -3.209599989005740e-09,   2.209387612390335e-11,   3.746427578270710e-14,  -3.037311011958491e-15,   3.458866666846066e-17,   6.066750716509261e-19,   7.214457307643927e-01,
  -7.625281125811408e-03,   3.916503776969325e-05,   6.411049153849736e-08,  -3.209466264490697e-09,   2.207904862921877e-11,   3.769231961853539e-14,  -3.032167391961906e-15,
   3.468523758867400e-17,   6.084035771518844e-19,   7.214554308786811e-01,  -7.625233294036585e-03,   3.916026481943309e-05,   6.416512707468175e-08,  -3.209324080350498e-09,
   2.206332473100213e-11,   3.793452121920957e-14,  -3.026704378436355e-15,   3.478755204897301e-17,   6.102282597868952e-19,   7.214630646426549e-01,  -7.625195640669191e-03,
   3.915650853235814e-05,   6.420811641106807e-08,  -3.209211969087827e-09,   2.205095661930821e-11,   3.812530114966112e-14,  -3.022401178702095e-15,   3.486796179023914e-17,
   6.116574936852781e-19,   7.214674701261072e-01,  -7.625173906363185e-03,   3.915434072564012e-05,   6.423292274390048e-08,  -3.209147182630184e-09,   2.204382141857636e-11,
   3.823547047161937e-14,  -3.019916206654492e-15,   3.491432274147140e-17,   6.124796068736928e-19,   7.214691244079693e-01,  -7.625165744194810e-03,   3.915352669644439e-05,
   6.424223707805743e-08,  -3.209122838628088e-09,   2.204114258613071e-11,   3.827685270992711e-14,  -3.018982789714371e-15,   3.493172320940939e-17,   6.127878034363545e-19,
   7.214693986277601e-01,  -7.625164391160569e-03,   3.915339175965301e-05,   6.424378102584352e-08,  -3.209118802414838e-09,   2.204069855802589e-11,   3.828371307084951e-14,
  -3.018828047459425e-15,   3.493460713580446e-17,   6.128388642549477e-19,   9.355824467816510e-01,  -9.103028649739449e-03,   2.829655669787533e-05,   3.515159872511310e-07,
  -4.675779629983673e-09,  -3.737785557228443e-12,   4.966730485493598e-13,  -4.364602819799689e-15,  -1.839839616425528e-17,   1.633581082110273e-18,   9.355864655731618e-01,
  -9.102878599015466e-03,   2.829257031284566e-05,   3.515105592357492e-07,  -4.674720269654068e-09,  -3.750694969742913e-12,   4.966018272511205e-13,  -4.356219129556229e-15,
  -1.829762107738180e-17,   1.634139754202408e-18,   9.355930626609681e-01,  -9.102632268160517e-03,   2.828602666997187e-05,   3.515016350472756e-07,  -4.672981266945114e-09,
  -3.771869742036345e-12,   4.964851955579056e-13,  -4.342453950275287e-15,  -1.813229300560671e-17,   1.635047079546274e-18,   9.356000621253905e-01,  -9.102370894386817e-03,
   2.827908424698202e-05,   3.514921478328882e-07,  -4.671136198174113e-09,  -3.794313186329283e-12,   4.963618337243263e-13,  -4.327845339812946e-15,  -1.795701789848645e-17,
   1.635996471971877e-18,   9.356055703384255e-01,  -9.102165193521517e-03,   2.827362116639793e-05,   3.514846683492839e-07,  -4.669684225961237e-09,  -3.811958463435978e-12,
   4.962650320121608e-13,  -4.316346353657288e-15,  -1.781918502539590e-17,   1.636733985903447e-18,   9.356087490746479e-01,  -9.102046480198977e-03,   2.827046857341775e-05,
   3.514803465862243e-07,  -4.668846307073963e-09,  -3.822134749552654e-12,   4.962092799269767e-13,  -4.309709294223917e-15,  -1.773968302876842e-17,   1.637155747169465e-18,
   9.356099426912354e-01,  -9.102001902292439e-03,   2.826928479210243e-05,   3.514787227373917e-07,  -4.668531668256990e-09,  -3.825954694998211e-12,   4.961883660206675e-13,
  -4.307216867547340e-15,  -1.770983758023070e-17,   1.637313390896093e-18,   9.356101405486624e-01,  -9.101994512873029e-03,   2.826908856597404e-05,   3.514784535093106e-07,
  -4.668479512794287e-09,  -3.826587834350964e-12,   4.961849003783858e-13,  -4.306803704522573e-15,  -1.770489071038740e-17,   1.637339483996027e-18,   1.178590328821770e+00,
  -1.005578813995512e-02,   1.217854567224671e-07,   6.939523353903209e-07,  -2.452932844990513e-09,  -8.183097125754152e-11,   6.498345840493902e-13,   8.498494238034420e-15,
  -1.431516367048646e-16,   4.664497930300924e-19,   1.178590341956779e+00,  -1.005549228701941e-02,   1.196988527394706e-07,   6.938360987023329e-07,  -2.451552368444006e-09,
  -8.180553488486632e-11,   6.492723476326905e-13,   8.500929702022027e-15,  -1.427576322762049e-16,   4.681680501281337e-19,   1.178590363306653e+00,  -1.005500663234651e-02,
   1.162742043397779e-07,   6.936453035408679e-07,  -2.449286955817043e-09,  -8.176377167098554e-11,   6.483504774192313e-13,   8.504934177572019e-15,  -1.421113068988230e-16,
   4.709762210769718e-19,   1.178590385670580e+00,  -1.005449136385505e-02,   1.126415422644728e-07,   6.934428907029423e-07,  -2.446884349913294e-09,  -8.171945047411391e-11,
   6.473738393758161e-13,   8.509191727708984e-15,  -1.414261812814040e-16,   4.739387466125520e-19,   1.178590403061220e+00,  -1.005408588006594e-02,   1.097834538266339e-07,
   6.932836164950512e-07,  -2.444994334237762e-09,  -8.168456424106901e-11,   6.466063326806547e-13,   8.512548570381361e-15,  -1.408874733860078e-16,   4.762578441734834e-19,
   1.178590413013578e+00,  -1.005385188155950e-02,   1.081343300176934e-07,   6.931917065614959e-07,  -2.443903908824889e-09,  -8.166442862017802e-11,   6.461638353315663e-13,
   8.514488319835208e-15,  -1.405767709126245e-16,   4.775912597181760e-19,   1.178590416734889e+00,  -1.005376401546164e-02,   1.075151309225798e-07,   6.931571954193798e-07,
  -2.443494507396250e-09,  -8.165686709836429e-11,   6.459977574083645e-13,   8.515217177311582e-15,  -1.404601361807474e-16,   4.780910290278905e-19,   1.178590417350911e+00,
  -1.005374945053898e-02,   1.074124931483045e-07,   6.931514748065619e-07,  -2.443426646633223e-09,  -8.165561364699647e-11,   6.459702320583907e-13,   8.515338020238403e-15,
  -1.404408042639908e-16,   4.781738232763438e-19,   1.445197233926810e+00,  -9.792553258409487e-03,  -4.857176455114378e-05,   7.337306816335591e-07,   8.103330176683846e-09,
  -1.156440015031112e-10,  -1.814992891208338e-12,   2.064724348603968e-14,   4.330298735832074e-16,  -3.006944458519769e-18,   1.445190335677455e+00,  -9.792240592084963e-03,
  -4.856486739595804e-05,   7.335666304426458e-07,   8.099476273391239e-09,  -1.155825380944447e-10,  -1.813274748552183e-12,   2.063218550485642e-14,   4.326767762305164e-16,
  -2.993986482498571e-18,   1.445179011790298e+00,  -9.791727350195558e-03,  -4.855354697106876e-05,   7.332973769745965e-07,   8.093152114203016e-09,  -1.154816682591822e-10,
  -1.810455151296905e-12,   2.060751304012419e-14,   4.320979570235500e-16,  -2.972757928499680e-18,   1.445166997229583e+00,  -9.791182829483427e-03,  -4.854153834758323e-05,
   7.330117639904585e-07,   8.086445288856904e-09,  -1.153746814061846e-10,  -1.807464714717098e-12,   2.058139831692283e-14,   4.314849334428767e-16,  -2.950292641377666e-18,
   1.445157542401221e+00,  -9.790754338481106e-03,  -4.853208983008937e-05,   7.327870471461237e-07,   8.081169585241221e-09,  -1.152905138865996e-10,  -1.805112219206953e-12,
   2.056089264434645e-14,   4.310033096255627e-16,  -2.932655649117872e-18,   1.445152086113065e+00,  -9.790507067847964e-03,  -4.852663784055037e-05,   7.326573835391281e-07,
   8.078125916783280e-09,  -1.152419518559854e-10,  -1.803754946065524e-12,   2.054907713708581e-14,   4.307256865818997e-16,  -2.922494346987159e-18,   1.445150037275180e+00,
  -9.790414219027961e-03,  -4.852459074089875e-05,   7.326086982670012e-07,   8.076983186172710e-09,  -1.152237187275589e-10,  -1.803245351693451e-12,   2.054464383164660e-14,
   4.306214989250386e-16,  -2.918681955498048e-18,   1.445149697653747e+00,  -9.790398828205461e-03,  -4.852425141414735e-05,   7.326006282342962e-07,   8.076793772617723e-09,
  -1.152206964519457e-10,  -1.803160883097631e-12,   2.054390913423428e-14,   4.306042316273903e-16,  -2.918050169970015e-18,   1.716360457379097e+00,  -7.239372058983587e-03,
  -9.497304009889190e-05,  -2.896381316281261e-07,   1.393888625012820e-08,   2.309823269625100e-10,  -9.173021164650625e-13,  -7.977325779916666e-14,  -7.385237429220347e-16,
   1.757412462803311e-17,   1.716346965928647e+00,  -7.239494558062022e-03,  -9.496114976718848e-05,  -2.893114260726417e-07,   1.393689414873395e-08,   2.307453752677087e-10,
  -9.201744480558806e-13,  -7.968276405324385e-14,  -7.351254454586236e-16,   1.759145035786134e-17,   1.716324818749767e+00,  -7.239695559786268e-03,  -9.494163110293907e-05,
  -2.887753291321432e-07,   1.393361939758736e-08,   2.303565764637064e-10,  -9.248800948112586e-13,  -7.953414118737752e-14,  -7.295529627820089e-16,   1.761970474652935e-17,
   1.716301320539866e+00,  -7.239908701823896e-03,  -9.492092197770355e-05,  -2.882068191299796e-07,   1.393013866949751e-08,   2.299442969983946e-10,  -9.298599081383443e-13,
  -7.937635595705271e-14,  -7.236487883550515e-16,   1.764942887714177e-17,   1.716282828525992e+00,  -7.240076347055324e-03,  -9.490462500923662e-05,  -2.877596378197532e-07,
   1.392739500653464e-08,   2.296200236249730e-10,  -9.337694680304890e-13,  -7.925211699350858e-14,  -7.190084420066850e-16,   1.767263688893502e-17,   1.716272156904503e+00,
  -7.240173058854430e-03,  -9.489522020023940e-05,  -2.875016565353460e-07,   1.392580985878255e-08,   2.294329563957415e-10,  -9.360219142088834e-13,  -7.918039184149516e-14,
  -7.163329205625181e-16,   1.768595660935169e-17,   1.716268149695487e+00,  -7.240209367624061e-03,  -9.489168869363518e-05,  -2.874048001003989e-07,   1.392521429402095e-08,
   2.293627253991222e-10,  -9.368670051695092e-13,  -7.915345373038590e-14,  -7.153287106548559e-16,   1.769094430670676e-17,   1.716267485448034e+00,  -7.240215385928160e-03,
  -9.489110330075750e-05,  -2.873887457148398e-07,   1.392511555344419e-08,   2.293510843768610e-10,  -9.370070528544248e-13,  -7.914898811032457e-14,  -7.151622735465865e-16,
   1.769177035116889e-17,   1.935164567189624e+00,  -2.262310277427902e-03,  -5.484733443279420e-05,  -1.057344109991704e-06,  -1.594724700526972e-08,  -1.546880271259294e-10,
   4.586461359491192e-13,   6.437360345585799e-14,   1.747648732833193e-15,   2.933573829967696e-17,   1.935156734641018e+00,  -2.262762452492315e-03,  -5.486094483541626e-05,
  -1.057562595811886e-06,  -1.594618482658144e-08,  -1.544932601237073e-10,   4.656419504056328e-13,   6.452321357131653e-14,   1.749204231139320e-15,   2.931070662454514e-17,
   1.935143874845527e+00,  -2.263504838095289e-03,  -5.488328783272627e-05,  -1.057921074328912e-06,  -1.594443027768879e-08,  -1.541731958465980e-10,   4.771311469590343e-13,
   6.476872813379935e-14,   1.751749950265569e-15,   2.926935183062006e-17,   1.935130227706777e+00,  -2.264292657699168e-03,  -5.490699455017732e-05,  -1.058301173953688e-06,
  -1.594255386931100e-08,  -1.538331444165917e-10,   4.893280874508351e-13,   6.502910888438646e-14,   1.754440428303246e-15,   2.922511605445071e-17,   1.935119485959912e+00,
  -2.264912741801243e-03,  -5.492565118550900e-05,  -1.058600115982609e-06,  -1.594106648250860e-08,  -1.535652047604898e-10,   4.989314888981876e-13,   6.523393595888776e-14,
   1.756550072079718e-15,   2.919004506619083e-17,   1.935113286135803e+00,  -2.265270630882791e-03,  -5.493641802270664e-05,  -1.058772561708193e-06,  -1.594020381506909e-08,
  -1.534104443477263e-10,   5.044755381922152e-13,   6.535210787367789e-14,   1.757764468182474e-15,   2.916970179299774e-17,   1.935110957935877e+00,  -2.265405026784500e-03,
  -5.494046102563925e-05,  -1.058837301748710e-06,  -1.593987906816295e-08,  -1.533523062355926e-10,   5.065577120463007e-13,   6.539647544270410e-14,   1.758219895776906e-15,
   2.916204319829550e-17,   1.935110571997911e+00,  -2.265427305092287e-03,  -5.494113120852639e-05,  -1.058848032543313e-06,  -1.593982519415483e-08,  -1.533426677432925e-10,
   5.069028794717655e-13,   6.540382962421227e-14,   1.758295358273251e-15,   2.916077264817798e-17,   2.935060687678731e-03,  -3.579737683207904e-05,   3.264517103278699e-07,
  -2.660176041797856e-09,   1.986512606024425e-11,  -1.519865136237956e-13,   9.777210449962614e-16,  -4.957434617981897e-18,   1.795714733626936e-19,   3.073702671818417e-21,
   2.935107178289019e-03,  -3.579851328444443e-05,   3.264686839258331e-07,  -2.660392452524622e-09,   1.986722167849978e-11,  -1.520010794390693e-13,   9.784414802710774e-16,
  -4.941820356796945e-18,   1.798095110365561e-19,   3.068795164413591e-21,   2.935183501900015e-03,  -3.580037902179132e-05,   3.264965501308024e-07,  -2.660747740646021e-09,
   1.987066308926506e-11,  -1.520249579428925e-13,   9.796248694215465e-16,  -4.916205413447789e-18,   1.801989758707072e-19,   3.060709245245394e-21,   2.935264489529171e-03,
  -3.580235880420124e-05,   3.265261200910898e-07,  -2.661124749020835e-09,   1.987431620700532e-11,  -1.520502491843068e-13,   9.808814562313476e-16,  -4.889051036706728e-18,
   1.806104442876558e-19,   3.052089478054936e-21,   2.935328228941490e-03,  -3.580391696916910e-05,   3.265493930820780e-07,  -2.661421471217199e-09,   1.987719232717350e-11,
  -1.520701204558105e-13,   9.818710607394046e-16,  -4.867698588993325e-18,   1.809329804972277e-19,   3.045276763379323e-21,   2.935365014893259e-03,  -3.580481624302110e-05,
   3.265628248921978e-07,  -2.661592721256251e-09,   1.987885263236778e-11,  -1.520815753054037e-13,   9.824424465143146e-16,  -4.855382980546250e-18,   1.811186047074974e-19,
   3.041333434602348e-21,   2.935378828514466e-03,  -3.580515393428103e-05,   3.265678687672349e-07,  -2.661657028455323e-09,   1.987947617666117e-11,  -1.520858742116659e-13,
   9.826570577036768e-16,  -4.850759729979936e-18,   1.811882105845512e-19,   3.039850488478204e-21,   2.935381118326792e-03,  -3.580520991170404e-05,   3.265687048668247e-07,
  -2.661667688352408e-09,   1.987957954244177e-11,  -1.520865866848494e-13,   9.826926352242403e-16,  -4.849993433019771e-18,   1.811997435924376e-19,   3.039604553593805e-21,
   2.645836860571416e-02,  -3.215779911024826e-04,   2.903807804582623e-06,  -2.322122950532063e-08,   1.678810495004879e-10,  -1.231991029807046e-12,   7.281699381422643e-15,
  -2.914879284662514e-17,   1.482402472329723e-18,   2.927732086303185e-20,   2.645878212733830e-02,  -3.215879109537519e-04,   2.903951237326248e-06,  -2.322298343231036e-08,
   1.678966638315425e-10,  -1.232075764081852e-12,   7.287649426270980e-15,  -2.899998689035494e-17,   1.484498297698945e-18,   2.923349085599586e-20,   2.645946100479734e-02,
  -3.216041965369305e-04,   2.904186715054315e-06,  -2.322586287357708e-08,   1.679223064868090e-10,  -1.232214548465898e-12,   7.297423355423805e-15,  -2.875586214053434e-17,
   1.487926965119264e-18,   2.916126910025894e-20,   2.646018136635265e-02,  -3.216214775359157e-04,   2.904436588264690e-06,  -2.322891830036883e-08,   1.679495278398243e-10,
  -1.232361373840767e-12,   7.307802341224679e-15,  -2.849705076702366e-17,   1.491548778910474e-18,   2.908427281153805e-20,   2.646074830923776e-02,  -3.216350783062396e-04,
   2.904633249311682e-06,  -2.323132302192672e-08,   1.679709602520828e-10,  -1.232476610962279e-12,   7.315976501253291e-15,  -2.829352735858116e-17,   1.494387387172158e-18,
   2.902341352167830e-20,   2.646107550889791e-02,  -3.216429277905338e-04,   2.904746750063386e-06,  -2.323271086763321e-08,   1.679833329510546e-10,  -1.232542990253467e-12,
   7.320696306386255e-15,  -2.817613529901446e-17,   1.496020882141807e-18,   2.898818519612511e-20,   2.646119837672682e-02,  -3.216458753903492e-04,   2.904789371445636e-06,
  -2.323323202389336e-08,   1.679879797097136e-10,  -1.232567892470458e-12,   7.322469081384094e-15,  -2.813206576844807e-17,   1.496633383350765e-18,   2.897493673091105e-20,
   2.646121874388635e-02,  -3.216463639993416e-04,   2.904796436587874e-06,  -2.323331841334051e-08,   1.679887500127286e-10,  -1.232572019110430e-12,   7.322762967478113e-15,
  -2.812476126515081e-17,   1.496734867115315e-18,   2.897273955978714e-20,   7.373482148634980e-02,  -8.897429876945635e-04,   7.868991951836133e-06,  -6.040217623759326e-08,
   4.052448106795513e-10,  -2.680068491717682e-12,   1.223418840699953e-14,  -3.569344366589374e-18,   3.507204568947564e-18,   8.863779939221620e-20,   7.373594199784445e-02,
  -8.897687881892071e-04,   7.869338116716100e-06,  -6.040599019467048e-08,   4.052710934722155e-10,  -2.680071961117220e-12,   1.224828083667187e-14,  -3.118533313087499e-18,
   3.512904092869321e-18,   8.851613218944360e-20,   7.373778153449385e-02,  -8.898111450549301e-04,   7.869906418681441e-06,  -6.041225142323314e-08,   4.053142627362821e-10,
  -2.680076685098027e-12,   1.227143206063317e-14,  -2.378910243740987e-18,   3.522226740233352e-18,   8.831563549990843e-20,   7.373973347356302e-02,  -8.898560905645921e-04,
   7.870509453140775e-06,  -6.041889507117711e-08,   4.053600983123895e-10,  -2.680080377662375e-12,   1.229601928910475e-14,  -1.594734604769502e-18,   3.532072520647174e-18,
   8.810186089136937e-20,   7.374126969499287e-02,  -8.898914640764188e-04,   7.870984060473637e-06,  -6.042412365697390e-08,   4.053961926301689e-10,  -2.680082328480977e-12,
   1.231538544662221e-14,  -9.780355228693326e-19,   3.539787700905052e-18,   8.793287278213896e-20,   7.374215629250047e-02,  -8.899118792866115e-04,   7.871257972079565e-06,
  -6.042714117592002e-08,   4.054170319799489e-10,  -2.680083071566354e-12,   1.232656838620238e-14,  -6.223077116116979e-19,   3.544226853366009e-18,   8.783504756051437e-20,
   7.374248922134224e-02,  -8.899195454889001e-04,   7.871360829827570e-06,  -6.042827428424336e-08,   4.054248589914174e-10,  -2.680083278271534e-12,   1.233076889003827e-14,
  -4.887626938762218e-19,   3.545891261025503e-18,   8.779825676171691e-20,   7.374254440920364e-02,  -8.899208162762965e-04,   7.871377880035752e-06,  -6.042846211316414e-08,
   4.054261565165181e-10,  -2.680083308720514e-12,   1.233146524687691e-14,  -4.666275069575608e-19,   3.546167026515372e-18,   8.779215518280954e-20,   1.452308008500277e-01,
  -1.732442609818452e-03,   1.480833776584357e-05,  -1.058357819661272e-07,   6.127403873067107e-10,  -3.151665734367551e-12,   2.940123792942279e-15,   1.753569460934511e-16,
   5.743444836863751e-18,   1.874931249876747e-19,   1.452329092374665e-01,  -1.732487809274585e-03,   1.480886098785041e-05,  -1.058402624509704e-07,   6.127469383070978e-10,
  -3.151126457744496e-12,   2.963244466227167e-15,   1.763108616252583e-16,   5.754849717732689e-18,   1.872478923681602e-19,   1.452363705506008e-01,  -1.732562012880710e-03,
   1.480971994561043e-05,  -1.058476173311665e-07,   6.127577286313672e-10,  -3.150239091742808e-12,   3.001233245172586e-15,   1.778759486642065e-16,   5.773503802863432e-18,
   1.868437571206415e-19,   1.452400433446656e-01,  -1.732640750522746e-03,   1.481063137184675e-05,  -1.058554206641949e-07,   6.127692266778352e-10,  -3.149294734442043e-12,
   3.041586271857244e-15,   1.795353739078493e-16,   5.793203623474792e-18,   1.864128393231406e-19,   1.452429339059778e-01,  -1.732702718822600e-03,   1.481134867319680e-05,
  -1.058615613747363e-07,   6.127783109668155e-10,  -3.148549498652406e-12,   3.073376084852231e-15,   1.808404405787246e-16,   5.808639711563367e-18,   1.860721868352085e-19,
   1.452446021267134e-01,  -1.732738482486071e-03,   1.481176264348417e-05,  -1.058651050766757e-07,   6.127835678310219e-10,  -3.148118598419373e-12,   3.091735313986027e-15,
   1.815932546055871e-16,   5.817521012151287e-18,   1.858749817808031e-19,   1.452452285642103e-01,  -1.732751912200509e-03,   1.481191809375617e-05,  -1.058664357299600e-07,
   6.127855445098926e-10,  -3.147956638016123e-12,   3.098631785383969e-15,   1.818758745848407e-16,   5.820850893811472e-18,   1.858008145064365e-19,   1.452453324054042e-01,
  -1.732754138373350e-03,   1.481194386188033e-05,  -1.058666563025703e-07,   6.127858723137997e-10,  -3.147929782686143e-12,   3.099775100671781e-15,   1.819227192401872e-16,
   5.821402598463155e-18,   1.857885141638526e-19,   2.416611479481433e-01,  -2.834879783538244e-03,   2.300564216255921e-05,  -1.457332531701856e-07,   6.100922342753414e-10,
  -9.235688170759341e-13,  -3.238886482370658e-14,   5.379824094841415e-16,   9.058392595183609e-18,   3.195182617674710e-19,   2.416644228668078e-01,  -2.834942004867675e-03,
   2.300616269716020e-05,  -1.457345536595287e-07,   6.100235311243096e-10,  -9.219351332085242e-13,  -3.235234274962131e-14,   5.396076446265277e-16,   9.079128111904757e-18,
   3.190858949145609e-19,   2.416697992294556e-01,  -2.835044151651079e-03,   2.300701719671649e-05,  -1.457366869321549e-07,   6.099108003545792e-10,  -9.192496737984979e-13,
  -3.229232681579715e-14,   5.422741099111981e-16,   9.113050060466397e-18,   3.183734037686418e-19,   2.416755040386818e-01,  -2.835152537828403e-03,   2.300792382941019e-05,
  -1.457389481989628e-07,   6.097912612301330e-10,  -9.163954349269103e-13,  -3.222856522069872e-14,   5.451012268228249e-16,   9.148882464300635e-18,   3.176137424463218e-19,
   2.416799938063269e-01,  -2.835237838714279e-03,   2.300863731257696e-05,  -1.457407261607714e-07,   6.096972390529602e-10,  -9.141456898884311e-13,  -3.217832669870214e-14,
   5.473245791436981e-16,   9.176965890088629e-18,   3.170132432550859e-19,   2.416825849601973e-01,  -2.835287067681712e-03,   2.300904906102310e-05,  -1.457417515885500e-07,
   6.096429993728832e-10,  -9.128459379894698e-13,  -3.214930994004865e-14,   5.486070750554092e-16,   9.193126538504245e-18,   3.166656255574932e-19,   2.416835579682427e-01,
  -2.835305553678402e-03,   2.300920367351426e-05,  -1.457421365204163e-07,   6.096226360608734e-10,  -9.123576074435503e-13,  -3.213840949350328e-14,   5.490885430971506e-16,
   9.199186168258942e-18,   3.165348918336796e-19,   2.416837192584647e-01,  -2.835308617998535e-03,   2.300922930258188e-05,  -1.457422003217101e-07,   6.096192607734733e-10,
  -9.122766459096841e-13,  -3.213660235832264e-14,   5.491683468804576e-16,   9.200190171514394e-18,   3.165132103092803e-19,   3.640014820114963e-01,  -4.170419921478910e-03,
   3.129874589164015e-05,  -1.594109162188424e-07,   1.672512802318891e-10,   5.417868299380659e-12,  -9.076871978458052e-14,   8.644851214175266e-16,   1.724685897327545e-17,
   4.628634748248335e-19,   3.640059363379376e-01,  -4.170487950190848e-03,   3.129888760546636e-05,  -1.594031840304915e-07,   1.670583505615773e-10,   5.420489330874330e-12,
  -9.069925923392272e-14,   8.668377170944421e-16,   1.728263217582900e-17,   4.621716767360145e-19,   3.640132488503092e-01,  -4.170599627943597e-03,   3.129912013285194e-05,
  -1.593904876799772e-07,   1.667417328335053e-10,   5.424797247764857e-12,  -9.058512655382254e-14,   8.706972897901587e-16,   1.734117052825987e-17,   4.610316950529457e-19,
   3.640210080110092e-01,  -4.170718123425512e-03,   3.129936670096402e-05,  -1.593770121821082e-07,   1.664059232070294e-10,   5.429375167355003e-12,  -9.046388470620113e-14,
   8.747890607739873e-16,   1.740302716884926e-17,   4.598162718067832e-19,   3.640271145256665e-01,  -4.170811377642655e-03,   3.129956063452327e-05,  -1.593664042214910e-07,
   1.661417452252257e-10,   5.432982997950263e-12,  -9.036836687078401e-14,   8.780067405493439e-16,   1.745152253563917e-17,   4.588555226052070e-19,   3.640306387204616e-01,
  -4.170865195532879e-03,   3.129967251054648e-05,  -1.593602810877800e-07,   1.659893254417417e-10,   5.435067144497683e-12,  -9.031320170692127e-14,   8.798626958493539e-16,
   1.747943554678917e-17,   4.582993717037600e-19,   3.640319620917433e-01,  -4.170885404507754e-03,   3.129971451225618e-05,  -1.593579815874371e-07,   1.659320983321504e-10,
   5.435850139601993e-12,  -9.029247909695415e-14,   8.805594304554739e-16,   1.748990305717597e-17,   4.580902134671450e-19,   3.640321814595333e-01,  -4.170888754425212e-03,
   3.129972147417395e-05,  -1.593576004016428e-07,   1.659226125435329e-10,   5.435979952152781e-12,  -9.028904363006360e-14,   8.806749138923094e-16,   1.749163745285908e-17,
   4.580555257223708e-19,   5.134871865559497e-01,  -5.691210707094887e-03,   3.783227066593900e-05,  -1.177659684064669e-07,  -9.425889408716362e-10,   1.526501878848621e-11,
  -1.287908461112160e-13,   4.868919773104103e-16,   3.644725427797770e-17,   6.294092417105241e-19,   5.134925687443878e-01,  -5.691260907188415e-03,   3.783146429504861e-05,
  -1.177442324005132e-07,  -9.428621190107035e-10,   1.526652490099709e-11,  -1.286444926668315e-13,   4.900903647981688e-16,   3.650176836499259e-17,   6.284427145586447e-19,
   5.135014043948495e-01,  -5.691343312058735e-03,   3.783014033865116e-05,  -1.177085476574698e-07,  -9.433103587515240e-10,   1.526900431991192e-11,  -1.284040744654367e-13,
   4.953374076657493e-16,   3.659097085527314e-17,   6.268495049448326e-19,   5.135107795902167e-01,  -5.691430740878876e-03,   3.782873529022698e-05,  -1.176706812472528e-07,
  -9.437856679531342e-10,   1.527164453680420e-11,  -1.281487615161003e-13,   5.008999819946554e-16,   3.668522580879180e-17,   6.251501639647455e-19,   5.135181578366668e-01,
  -5.691499541219240e-03,   3.782762934445325e-05,  -1.176408786310325e-07,  -9.441595158293201e-10,   1.527372917617042e-11,  -1.279476767237307e-13,   5.052741675132731e-16,
   3.675911838780350e-17,   6.238063939097279e-19,   5.135224159342724e-01,  -5.691539244595140e-03,   3.782699101528803e-05,  -1.176236783351505e-07,  -9.443751813406392e-10,
   1.527493497686550e-11,  -1.278315658838209e-13,   5.077971531753073e-16,   3.680164836855827e-17,   6.230283232126608e-19,   5.135240148860849e-01,  -5.691554153107492e-03,
   3.782675130382260e-05,  -1.176172193350806e-07,  -9.444561489815598e-10,   1.527538827996201e-11,  -1.277879536171576e-13,   5.087442863583806e-16,   3.681759708707381e-17,
   6.227356673702823e-19,   5.135242799349088e-01,  -5.691556624380428e-03,   3.782671156755579e-05,  -1.176161486571422e-07,  -9.444695696351812e-10,   1.527546344849561e-11,
  -1.277807236538100e-13,   5.089012728275553e-16,   3.682023967003396e-17,   6.226871300258547e-19,   6.915600396294422e-01,  -7.309741357287416e-03,   3.964715060295169e-05,
   1.623143526757509e-08,  -2.764819692911485e-09,   2.212496530920179e-11,  -2.849026657993148e-14,  -1.505525236102656e-15,   6.405266265758468e-17,   1.044188328419106e-18,
   6.915656769622371e-01,  -7.309734316633482e-03,   3.964478955226339e-05,   1.626288352614264e-08,  -2.764877459095608e-09,   2.212055101313502e-11,  -2.823371454331645e-14,
  -1.500208456730996e-15,   6.411703971981803e-17,   1.042981189909786e-18,   6.915749313137521e-01,  -7.309722748564811e-03,   3.964091347064581e-05,   1.631450642867561e-08,
  -2.764971895111558e-09,   2.211331569431871e-11,  -2.781235990669530e-14,  -1.491484647559693e-15,   6.422229463736446e-17,   1.040989537394027e-18,   6.915847505662589e-01,
  -7.309710460773167e-03,   3.963680060129871e-05,   1.636927620410596e-08,  -2.765071559958763e-09,   2.210565403504157e-11,  -2.736502210851960e-14,  -1.482234208465929e-15,
   6.433339321756292e-17,   1.038862746942377e-18,   6.915924781308750e-01,  -7.309700780676822e-03,   3.963356371745501e-05,   1.641237588359771e-08,  -2.765149606298600e-09,
   2.209963554007697e-11,  -2.701278591264891e-14,  -1.474958566675008e-15,   6.442040480767158e-17,   1.037179194127995e-18,   6.915969377638388e-01,  -7.309695190280114e-03,
   3.963169563487667e-05,   1.643724778070925e-08,  -2.765194491828573e-09,   2.209616666557021e-11,  -2.680943194084241e-14,  -1.470761461508747e-15,   6.447045110621590e-17,
   1.036203675484976e-18,   6.915986123822777e-01,  -7.309693090307841e-03,   3.963099414872286e-05,   1.644658709091441e-08,  -2.765211317199198e-09,   2.209486492222026e-11,
  -2.673305699474060e-14,  -1.469185749507938e-15,   6.448921189646104e-17,   1.035836620462447e-18,   6.915988899733000e-01,  -7.309692742169252e-03,   3.963087786721649e-05,
   1.644813519762106e-08,  -2.765214104683977e-09,   2.209464918465011e-11,  -2.672039604213736e-14,  -1.468924570784780e-15,   6.449232007295533e-17,   1.035775736913327e-18,
   8.996479943611561e-01,  -8.861056923044076e-03,   3.206538990297452e-05,   2.767111210959337e-07,  -4.641329627670665e-09,   6.708165376173024e-12,   3.759601197136220e-13,
  -3.886409264956821e-15,   5.212949456984246e-17,   2.271312817749248e-18,   8.996525495415524e-01,  -8.860938755601339e-03,   3.206143149348776e-05,   2.767205709771525e-07,
  -4.640524609488005e-09,   6.696735855608417e-12,   3.761695235559602e-13,  -3.874834943765277e-15,   5.221140998180861e-17,   2.269027029909185e-18,   8.996600272011985e-01,
  -8.860744761720296e-03,   3.205493362109041e-05,   2.767360728078250e-07,  -4.639202717841515e-09,   6.677997407373405e-12,   3.765135264309061e-13,  -3.855842400650182e-15,
   5.234530396213234e-17,   2.265259314932338e-18,   8.996679610240308e-01,  -8.860538915279582e-03,   3.204803955237191e-05,   2.767525055900026e-07,  -4.637799648072775e-09,
   6.658148377403213e-12,   3.768788552402265e-13,  -3.835701533987522e-15,   5.248658285682135e-17,   2.261240810984599e-18,   8.996742045846668e-01,  -8.860376910198052e-03,
   3.204261437366147e-05,   2.767654268051453e-07,  -4.636695105655541e-09,   6.642551631598695e-12,   3.771665984016439e-13,  -3.819859053812645e-15,   5.259719592717875e-17,
   2.258063282504187e-18,   8.996778077054183e-01,  -8.860283412755235e-03,   3.203948359322457e-05,   2.767728792966453e-07,  -4.636057524651626e-09,   6.633560280846460e-12,
   3.773327515490111e-13,  -3.810719458982885e-15,   5.266080272999100e-17,   2.256223484286438e-18,   8.996791606828145e-01,  -8.860248303319869e-03,   3.203830799114124e-05,
   2.767756769133483e-07,  -4.635818082449756e-09,   6.630185798065732e-12,   3.773951608687017e-13,  -3.807288095765968e-15,   5.268464421249544e-17,   2.255531491385761e-18,
   8.996793849565871e-01,  -8.860242483417023e-03,   3.203811312022605e-05,   2.767761406125829e-07,  -4.635778390200940e-09,   6.629626527297422e-12,   3.774055070113612e-13,
  -3.806719332274453e-15,   5.268859398439828e-17,   2.255416724043121e-18,   1.138420766672460e+00,  -1.002228985455080e-02,   8.162667811027669e-06,   6.425318011442127e-07,
  -3.916863331144064e-09,  -6.386413716143265e-11,   8.296633570208589e-13,   4.674259211359609e-15,  -8.097094345412338e-17,   2.951574924664031e-18,   1.138421921574903e+00,
  -1.002201586419757e-02,   8.159333431645452e-06,   6.424410379625361e-07,  -3.915096059134324e-09,  -6.384992911368133e-11,   8.293479843609046e-13,   4.689246914714623e-15,
  -8.061983253017920e-17,   2.946624269102471e-18,   1.138423817192873e+00,  -1.002156609265485e-02,   8.153860597565114e-06,   6.422920502196376e-07,  -3.912195278745805e-09,
  -6.382657201682992e-11,   8.288312540357659e-13,   4.713833181702643e-15,  -8.004451592261693e-17,   2.938478049570132e-18,   1.138425828126258e+00,  -1.002108888828838e-02,
   8.148054977910298e-06,   6.421339827178561e-07,  -3.909117981637961e-09,  -6.380174447285688e-11,   8.282843272959261e-13,   4.739895965583511e-15,  -7.943554033473854e-17,
   2.929808603628020e-18,   1.138427410405653e+00,  -1.002071335345668e-02,   8.143486996374427e-06,   6.420095972641396e-07,  -3.906696606272686e-09,  -6.378217332738959e-11,
   8.278548793523524e-13,   4.760389277231120e-15,  -7.895734478386511e-17,   2.922967138653246e-18,   1.138428323435464e+00,  -1.002049663598955e-02,   8.140851154430457e-06,
   6.419378178038440e-07,  -3.905299372836136e-09,  -6.377086572019821e-11,   8.276074314495429e-13,   4.772209048233905e-15,  -7.868179827268127e-17,   2.919011361938815e-18,
   1.138428666261804e+00,  -1.002041525850988e-02,   8.139861450749631e-06,   6.419108650028298e-07,  -3.904774733603806e-09,  -6.376661719839301e-11,   8.275145868892957e-13,
   4.776646105067184e-15,  -7.857840899703342e-17,   2.917524524445439e-18,   1.138428723088835e+00,  -1.002040176913776e-02,   8.139697397480606e-06,   6.419063972483139e-07,
  -3.904687769030354e-09,  -6.376591281834616e-11,   8.274992005080293e-13,   4.777381537669802e-15,  -7.856127502729480e-17,   2.917277985805892e-18,   1.405308498071118e+00,
  -1.014389426633833e-02,  -3.907246639697165e-05,   8.427375045116402e-07,   5.409304025976857e-09,  -1.508121200043448e-10,  -1.061319576289833e-12,   3.249729178257971e-14,
   3.039407405331394e-16,  -3.627105616227102e-18,   1.405302947034308e+00,  -1.014353523829539e-02,  -3.906786044172378e-05,   8.425237050173615e-07,   5.407052947694248e-09,
  -1.507152948512694e-10,  -1.060105555671085e-12,   3.247901172723250e-14,   3.040836113461210e-16,  -3.615792811689673e-18,   1.405293834580435e+00,  -1.014294590142066e-02,
  -3.906030040517263e-05,   8.421728180062584e-07,   5.403359312880660e-09,  -1.505563799774634e-10,  -1.058112141017850e-12,   3.244904338461243e-14,   3.043167287297881e-16,
  -3.597295518217792e-18,   1.405284166203196e+00,  -1.014232065880646e-02,  -3.905228050297171e-05,   8.418006349197885e-07,   5.399442628806444e-09,  -1.503878123569697e-10,
  -1.055996428095194e-12,   3.241730067240208e-14,   3.045621431361691e-16,  -3.577769593634238e-18,   1.405276557603249e+00,  -1.014182865426795e-02,  -3.904597015910133e-05,
   8.415078227110685e-07,   5.396362022899020e-09,  -1.502551873373772e-10,  -1.054330957426830e-12,   3.239235942945415e-14,   3.047538800061170e-16,  -3.562475712385678e-18,
   1.405272166717309e+00,  -1.014154473475224e-02,  -3.904232888177249e-05,   8.413388742715149e-07,   5.394584884661241e-09,  -1.501786622988488e-10,  -1.053369624594092e-12,
   3.237798152120025e-14,   3.048639716510832e-16,  -3.553678593487402e-18,   1.405270517931105e+00,  -1.014143812505027e-02,  -3.904096164901525e-05,   8.412754398632348e-07,
   5.393917691397168e-09,  -1.501499293053453e-10,  -1.053008604923896e-12,   3.237258552548896e-14,   3.049052056560805e-16,  -3.550380718016659e-18,   1.405270244623045e+00,
  -1.014142045322463e-02,  -3.904073501605337e-05,   8.412649250930117e-07,   5.393807101939759e-09,  -1.501451665543707e-10,  -1.052948759184477e-12,   3.237169122284639e-14,
   3.049120351640444e-16,  -3.549834339597732e-18,   1.685867188841285e+00,  -8.008928246255634e-03,  -9.696416234115579e-05,  -3.165346068689766e-08,   1.814668318055367e-08,
   1.802282482694244e-10,  -3.356621813841394e-12,  -8.907401228842126e-14,   2.835531393109393e-16,   3.855951266378204e-17,   1.685853421205277e+00,  -8.008940861978708e-03,
  -9.694870841174847e-05,  -3.139920088399467e-08,   1.813953226515953e-08,   1.799651805810246e-10,  -3.355436175892695e-12,  -8.887818467633155e-14,   2.862526314716379e-16,
   3.849568350594383e-17,   1.685830820984961e+00,  -8.008961494791220e-03,  -9.692334269337778e-05,  -3.098206154007265e-08,   1.812779473872228e-08,   1.795337342535187e-10,
  -3.353482051119700e-12,  -8.855693873769912e-14,   2.906727084293617e-16,   3.839083947327604e-17,   1.685806842554695e+00,  -8.008983281919770e-03,  -9.689643369559626e-05,
  -3.053981018144422e-08,   1.811534284829381e-08,   1.790765094137079e-10,  -3.351398115837443e-12,  -8.821639388764923e-14,   2.953470349616840e-16,   3.827951325411706e-17,
   1.685787972960675e+00,  -8.009000351879588e-03,  -9.687526050925441e-05,  -3.019202064692507e-08,   1.810554498362335e-08,   1.787170857524796e-10,  -3.349750490344039e-12,
  -8.794861647088925e-14,   2.990143880596309e-16,   3.819184235732349e-17,   1.685777083572879e+00,  -8.009010172583793e-03,  -9.686304278742951e-05,  -2.999141051272005e-08,
   1.809989118297637e-08,   1.785098214851864e-10,  -3.348796588750189e-12,  -8.779417038340551e-14,   3.011263372565419e-16,   3.814122319766042e-17,   1.685772994617394e+00,
  -8.009013854553998e-03,  -9.685845523988076e-05,  -2.991609944161544e-08,   1.809776826442335e-08,   1.784320230883761e-10,  -3.348437818075811e-12,  -8.773619201703347e-14,
   3.019185353127522e-16,   3.812221094661112e-17,   1.685772316820714e+00,  -8.009014464587221e-03,  -9.685769480553816e-05,  -2.990361661004259e-08,   1.809741636766670e-08,
   1.784191285466148e-10,  -3.348378316584626e-12,  -8.772658220545442e-14,   3.020498081303474e-16,   3.811905916979871e-17,   1.925150986045652e+00,  -2.756406811852661e-03,
  -6.916457954676440e-05,  -1.335912434283833e-06,  -1.874790958695736e-08,  -1.146959526872775e-10,   3.214277705154419e-12,   1.386949062231932e-13,   2.923997392141442e-15,
   3.340254073036976e-17,   1.925141111307322e+00,  -2.756977705801841e-03,  -6.918054761246831e-05,  -1.336072130632184e-06,  -1.874091028223223e-08,  -1.142788044968524e-10,
   3.225904327041472e-12,   1.388621535381027e-13,   2.922843532354501e-15,   3.325859077625785e-17,   1.925124898689709e+00,  -2.757914969092391e-03,  -6.920675741390647e-05,
  -1.336333867866530e-06,  -1.872940186531612e-08,  -1.135936294878708e-10,   3.244987866567239e-12,   1.391361807769528e-13,   2.920928492539786e-15,   3.302183962103505e-17,
   1.925107693625404e+00,  -2.758909543700986e-03,  -6.923456210368099e-05,  -1.336611006466220e-06,  -1.871716618620158e-08,  -1.128661189204930e-10,   3.265232266164103e-12,
   1.394262151045975e-13,   2.918868225418200e-15,   3.277003934082558e-17,   1.925094151539346e+00,  -2.759692326741928e-03,  -6.925644023860146e-05,  -1.336828692404976e-06,
  -1.870751900794747e-08,  -1.122932122332036e-10,   3.281161278459979e-12,   1.396539445933574e-13,   2.917226319338269e-15,   3.257144540840567e-17,   1.925086335491353e+00,
  -2.760144105202457e-03,  -6.926906481203831e-05,  -1.336954153366655e-06,  -1.870194436472144e-08,  -1.119624356280232e-10,   3.290352836882414e-12,   1.397851594373709e-13,
   2.916270538977584e-15,   3.245666250990355e-17,   1.925083400365644e+00,  -2.760313756107266e-03,  -6.927380513847489e-05,  -1.337001233095640e-06,  -1.869984969492029e-08,
  -1.118381991016334e-10,   3.293804095477631e-12,   1.398343917626949e-13,   2.915910083157051e-15,   3.241352819832221e-17,   1.925082913820111e+00,  -2.760341878362968e-03,
  -6.927459089820871e-05,  -1.337009035540526e-06,  -1.869950240294904e-08,  -1.118176037151446e-10,   3.294376177091584e-12,   1.398425506063878e-13,   2.915850250631719e-15,
   3.240637637114350e-17,   2.796899568174560e-03,  -3.330827120344887e-05,   2.963403709351173e-07,  -2.365411031193387e-09,   1.705262815408871e-11,  -1.294265037583175e-13,
   9.376763475688478e-16,   2.776073558923002e-18,   3.070914953958834e-19,   3.577304404596174e-21,   2.796941768889917e-03,  -3.330928169998277e-05,   2.963549426505456e-07,
  -2.365595141925825e-09,   1.705464420820415e-11,  -1.294179246241953e-13,   9.388958800820223e-16,   2.793850251404771e-18,   3.068957049972742e-19,   3.556828811445429e-21,
   2.797011049696767e-03,  -3.331094065042835e-05,   2.963788657292618e-07,  -2.365897380557523e-09,   1.705795576677684e-11,  -1.294038025473902e-13,   9.408973637242761e-16,
   2.822957659568782e-18,   3.065721005388416e-19,   3.523202613460061e-21,   2.797084564030209e-03,  -3.331270100233198e-05,   2.964042516637263e-07,  -2.366218066945508e-09,
   1.706147214023901e-11,  -1.293887663232329e-13,   9.430203058142425e-16,   2.853739677280353e-18,   3.062257671201885e-19,   3.487506144340701e-21,   2.797142421676110e-03,
  -3.331408646447232e-05,   2.964242317581844e-07,  -2.366470439997657e-09,   1.706424139332221e-11,  -1.293768954400373e-13,   9.446905000661242e-16,   2.877890553930530e-18,
   3.059510568531334e-19,   3.459400989622825e-21,   2.797175813047889e-03,  -3.331488606418958e-05,   2.964357631548642e-07,  -2.366616085879978e-09,   1.706584032434695e-11,
  -1.293700295945081e-13,   9.456541715212705e-16,   2.891798534108022e-18,   3.057916574141773e-19,   3.443176233755432e-21,   2.797188351952111e-03,  -3.331518632607293e-05,
   2.964400934022753e-07,  -2.366670776687127e-09,   1.706644087887263e-11,  -1.293674485827071e-13,   9.460159960989673e-16,   2.897015454898861e-18,   3.057316391024980e-19,
   3.437082787385525e-21,   2.797190430460878e-03,  -3.331523609900157e-05,   2.964408112076879e-07,  -2.366679842435886e-09,   1.706654043676811e-11,  -1.293670205944346e-13,
   9.460759713972004e-16,   2.897879935370837e-18,   3.057216816514488e-19,   3.436072664598288e-21,   2.521681482669813e-02,  -2.994182959125833e-04,   2.640486777874707e-06,
  -2.072292372931147e-08,   1.449548537784874e-10,  -1.060612452668043e-12,   7.302839657883904e-15,   3.704855121597328e-17,   2.683042404217430e-18,   3.350758657584869e-20,
   2.521719083644136e-02,  -2.994271483141902e-04,   2.640610635821131e-06,  -2.072443209914302e-08,   1.449705689789055e-10,  -1.060499081357192e-12,   7.313492247705535e-15,
   3.721522455874296e-17,   2.681216801813095e-18,   3.332190817458472e-20,   2.521780813006174e-02,  -2.994416814297720e-04,   2.640813978430520e-06,  -2.072690821470286e-08,
   1.449963844394247e-10,  -1.060312607232183e-12,   7.330974826567706e-15,   3.748815745456215e-17,   2.678199898609075e-18,   3.301697611489456e-20,   2.521846314366544e-02,
  -2.994571028215620e-04,   2.641029753905876e-06,  -2.072953540462124e-08,   1.450237989440917e-10,  -1.060114259707980e-12,   7.349517862482305e-15,   3.777682457429853e-17,
   2.674971734054565e-18,   3.269326983643530e-20,   2.521897865538600e-02,  -2.994692399961908e-04,   2.641199579937425e-06,  -2.073160290084679e-08,   1.450453904497765e-10,
  -1.059957809328640e-12,   7.364105996389917e-15,   3.800332941150708e-17,   2.672411623382833e-18,   3.243840358175032e-20,   2.521927617232038e-02,  -2.994762447806925e-04,
   2.641297593710142e-06,  -2.073279604677917e-08,   1.450578578010262e-10,  -1.059867378735152e-12,   7.372522947977920e-15,   3.813377806815613e-17,   2.670926311654812e-18,
   3.229127235079377e-20,   2.521938789384034e-02,  -2.994788751816464e-04,   2.641334399584125e-06,  -2.073324407613336e-08,   1.450625406383600e-10,  -1.059833394707909e-12,
   7.375683190462505e-15,   3.818271147230968e-17,   2.670367084653186e-18,   3.223601502515255e-20,   2.521940641333169e-02,  -2.994793112100870e-04,   2.641340500722962e-06,
  -2.073331834294699e-08,   1.450633169501906e-10,  -1.059827759974730e-12,   7.376207024419313e-15,   3.819082017464588e-17,   2.670274306836564e-18,   3.222685490665952e-20,
   7.029731321617802e-02,  -8.295840991108476e-04,   7.181352714055886e-06,  -5.433088273388177e-08,   3.546503935759735e-10,  -2.371806675547493e-12,   1.422505535042814e-14,
   1.648292811197200e-16,   7.089974870636706e-18,   9.937528989977945e-20,   7.029833578473495e-02,  -8.296073060707886e-04,   7.181655704297000e-06,  -5.433425375641265e-08,
   3.546810926159533e-10,  -2.371306208986639e-12,   1.425319408722156e-14,   1.653242837508934e-16,   7.084630565893539e-18,   9.885031218646418e-20,   7.030001452775922e-02,
  -8.296454050917503e-04,   7.182153130881322e-06,  -5.433978731760090e-08,   3.547315334139023e-10,  -2.370483552088772e-12,   1.429937266294435e-14,   1.661349644035349e-16,
   7.075800503323665e-18,   9.798816082484395e-20,   7.030179584632748e-02,  -8.296858325116415e-04,   7.182680964863463e-06,  -5.434565814930501e-08,   3.547851139095791e-10,
  -2.369609211155529e-12,   1.434835025412309e-14,   1.669925134414923e-16,   7.066354373543219e-18,   9.707292550896934e-20,   7.030319778415538e-02,  -8.297176501273209e-04,
   7.183096391767977e-06,  -5.435027801424386e-08,   3.548273246836059e-10,  -2.368920060629888e-12,   1.438688027772728e-14,   1.676654929192668e-16,   7.058864702256007e-18,
   9.635232411468885e-20,   7.030400688221829e-02,  -8.297360131058724e-04,   7.183336150292605e-06,  -5.435294402386749e-08,   3.548517024363963e-10,  -2.368521922252596e-12,
   1.440911043228385e-14,   1.680531142966248e-16,   7.054520029560507e-18,   9.593632883644133e-20,   7.030431070891677e-02,  -8.297429086644798e-04,   7.183426183427317e-06,
  -5.435394509826958e-08,   3.548608597546940e-10,  -2.368372338750457e-12,   1.441745688749786e-14,   1.681985247537884e-16,   7.052884360799052e-18,   9.578009547305031e-20,
   7.030436107266387e-02,  -8.297440517061121e-04,   7.183441107783275e-06,  -5.435411103863768e-08,   3.548623778816493e-10,  -2.368347539000033e-12,   1.441884036913344e-14,
   1.682226209567243e-16,   7.052613003719869e-18,   9.575419634545452e-20,   1.385301493155762e-01,  -1.618894115367157e-03,   1.359506942313749e-05,  -9.653024111953744e-08,
   5.509457872281510e-10,  -2.994757889209681e-12,   1.151753836602316e-14,   4.773447838496229e-16,   1.327286104219494e-17,   2.085156203412014e-19,   1.385320849401268e-01,
  -1.618935341265457e-03,   1.359553998808760e-05,  -9.653449068101160e-08,   5.509709978674640e-10,  -2.993314809118715e-12,   1.157019662398581e-14,   4.783844827976709e-16,
   1.326194141728461e-17,   2.074532657159917e-19,   1.385352626296121e-01,  -1.619003021560068e-03,   1.359631251239102e-05,  -9.654146553295466e-08,   5.510124663345482e-10,
  -2.990943532371535e-12,   1.165661157274714e-14,   4.800873783212225e-16,   1.324390047709057e-17,   2.057085945606038e-19,   1.385386344697144e-01,  -1.619074837364676e-03,
   1.359713224186270e-05,  -9.654886436236137e-08,   5.510565778083559e-10,  -2.988424402138678e-12,   1.174826069959194e-14,   4.818889279475423e-16,   1.322460201694256e-17,
   2.038564936475050e-19,   1.385412881733551e-01,  -1.619131358069758e-03,   1.359777738883815e-05,  -9.655468581098642e-08,   5.510913735545765e-10,  -2.986439648822150e-12,
   1.182035718049777e-14,   4.833028794139385e-16,   1.320930145417950e-17,   2.023982548722078e-19,   1.385428196967639e-01,  -1.619163977790722e-03,   1.359814972202309e-05,
  -9.655804489365397e-08,   5.511114868345956e-10,  -2.985293334389982e-12,   1.186195265024062e-14,   4.841173438054478e-16,   1.320042611020314e-17,   2.015564273823745e-19,
   1.385433948026521e-01,  -1.619176226917990e-03,   1.359828953801864e-05,  -9.655930615120059e-08,   5.511190456139045e-10,  -2.984862716779336e-12,   1.187756973422920e-14,
   4.844228893991291e-16,   1.319708481195989e-17,   2.012402658210776e-19,   1.385434901348759e-01,  -1.619178257391320e-03,   1.359831271458359e-05,  -9.655951521681465e-08,
   5.511202989085261e-10,  -2.984791327038111e-12,   1.188015836118877e-14,   4.844735224501236e-16,   1.319653049467131e-17,   2.011878550431442e-19,   2.306788754747135e-01,
  -2.657665547206893e-03,   2.131468133881334e-05,  -1.361559286040121e-07,   5.852849367424125e-10,  -1.475988400968716e-12,  -1.139205189730778e-14,   1.030667590664478e-15,
   2.201248854380529e-17,   3.613274101210761e-19,   2.306819097151576e-01,  -2.657723682496230e-03,   2.131518094950544e-05,  -1.361580027702486e-07,   5.852616559818030e-10,
  -1.472879609077088e-12,  -1.130472130594657e-14,   1.032469126600509e-15,   2.199434137444371e-17,   3.594823445370539e-19,   2.306868909634321e-01,  -2.657819121619138e-03,
   2.131600112730112e-05,  -1.361614046403877e-07,   5.852235713784940e-10,  -1.467772164876788e-12,  -1.116140740539471e-14,   1.035419798949818e-15,   2.196435142590121e-17,
   3.564522429281479e-19,   2.306921765228856e-01,  -2.657920390770176e-03,   2.131687138033677e-05,  -1.361650099234908e-07,   5.851833434669290e-10,  -1.462347534970832e-12,
  -1.100941316679216e-14,   1.038541391345085e-15,   2.193226031839323e-17,   3.532355474520250e-19,   2.306963363366684e-01,  -2.658000090750392e-03,   2.131755626033215e-05,
  -1.361678441388526e-07,   5.851518162024992e-10,  -1.458074537461736e-12,  -1.088984591982580e-14,   1.040991366443004e-15,   2.190680953928061e-17,   3.507028955290275e-19,
   2.306987370668762e-01,  -2.658046087418345e-03,   2.131795151248346e-05,  -1.361694785521598e-07,   5.851336742275629e-10,  -1.455606991817799e-12,  -1.082086265646202e-14,
   1.042402594868726e-15,   2.189204332829758e-17,   3.492408158009692e-19,   2.306996385687847e-01,  -2.658063359671952e-03,   2.131809993256104e-05,  -1.361700920509151e-07,
   5.851268717565968e-10,  -1.454680117747768e-12,  -1.079496279687858e-14,   1.042932014757423e-15,   2.188648372064442e-17,   3.486917080572504e-19,   2.306997880058326e-01,
  -2.658066222797719e-03,   2.131812453525876e-05,  -1.361701937344687e-07,   5.851257446782842e-10,  -1.454526460014327e-12,  -1.079066973788421e-14,   1.043019746753445e-15,
   2.188556135821841e-17,   3.486006812560145e-19,   3.478085411995199e-01,  -3.927628673664644e-03,   2.940508905223456e-05,  -1.559768363929239e-07,   2.561774618179233e-10,
   3.608987276208765e-12,  -5.607571831822613e-14,   1.716172990117055e-15,   3.652629650847532e-17,   5.462615828006613e-19,   3.478127261982349e-01,  -3.927695245306119e-03,
   2.940530712026147e-05,  -1.559716568321847e-07,   2.560594835408799e-10,   3.614159279397374e-12,  -5.593072679814204e-14,   1.718892488153653e-15,   3.650002697056962e-17,
   5.433196457843965e-19,   3.478195965734645e-01,  -3.927804531824434e-03,   2.940566504196838e-05,  -1.559631484069520e-07,   2.558660265041970e-10,   3.622655782555323e-12,
  -5.569277721648098e-14,   1.723346077231206e-15,   3.645658514101529e-17,   5.384881762353723e-19,   3.478268866032339e-01,  -3.927920491084892e-03,   2.940604472644339e-05,
  -1.559541130520463e-07,   2.556610571872988e-10,   3.631679129977807e-12,  -5.544040009824357e-14,   1.728056852187116e-15,   3.641006072293339e-17,   5.333591769255752e-19,
   3.478326239171681e-01,  -3.928011750051776e-03,   2.940634346913904e-05,  -1.559469969225857e-07,   2.554999649846591e-10,   3.638786262127580e-12,  -5.524185495815930e-14,
   1.731753518644660e-15,   3.637313524259886e-17,   5.293208749376922e-19,   3.478359350421275e-01,  -3.928064416752341e-03,   2.940651585095713e-05,  -1.559428879567409e-07,
   2.554070835845690e-10,   3.642890212698654e-12,  -5.512730166089366e-14,   1.733882631815612e-15,   3.635170045050534e-17,   5.269895932139926e-19,   3.478371784041570e-01,
  -3.928084193502306e-03,   2.940658057667211e-05,  -1.559413446006002e-07,   2.553722223374527e-10,   3.644431718557387e-12,  -5.508429163058415e-14,   1.734681321120557e-15,
   3.634362797612612e-17,   5.261140421443105e-19,   3.478373845092994e-01,  -3.928087471775372e-03,   2.940659130560250e-05,  -1.559410887461979e-07,   2.553664444646482e-10,
   3.644687267977882e-12,  -5.507716241256854e-14,   1.734813672367540e-15,   3.634228860866799e-17,   5.259689000907225e-19,   4.913183771477948e-01,  -5.394439547089869e-03,
   3.633814040778240e-05,  -1.305656361389508e-07,  -6.663164114639520e-10,   1.249243007376212e-11,  -9.502777475735429e-14,   2.067243967684041e-15,   6.320611081660404e-17,
   7.655876347684664e-19,   4.913235471857397e-01,  -5.394495225433927e-03,   3.633757034654690e-05,  -1.305478057671825e-07,  -6.665162774716621e-10,   1.249866847905645e-11,
  -9.477670655724674e-14,   2.071047464867374e-15,   6.316882746472825e-17,   7.611708529385253e-19,   4.913320345811953e-01,  -5.394586624935173e-03,   3.633663437634210e-05,
  -1.305185278835735e-07,  -6.668440029386867e-10,   1.250891796953071e-11,  -9.436464761469934e-14,   2.077275145883551e-15,   6.310713704209606e-17,   7.539172597061906e-19,
   4.913410402841975e-01,  -5.394683599378688e-03,   3.633564107335256e-05,  -1.304874530253924e-07,  -6.671912192115652e-10,   1.251980451269658e-11,  -9.392757168267919e-14,
   2.083860936031013e-15,   6.304102181729148e-17,   7.462169473011010e-19,   4.913481277621906e-01,  -5.394759913350561e-03,   3.633485921840279e-05,  -1.304629906019993e-07,
  -6.674640996404416e-10,   1.252838025855770e-11,  -9.358370015887812e-14,   2.089027865799056e-15,   6.298851360244846e-17,   7.401541073442227e-19,   4.913522180612453e-01,
  -5.394803953461216e-03,   3.633440794644305e-05,  -1.304488703138501e-07,  -6.676214317322294e-10,   1.253333268261762e-11,  -9.338528928108596e-14,   2.092003338225419e-15,
   6.295801975252306e-17,   7.366540659315788e-19,   4.913537540048502e-01,  -5.394820490549608e-03,   3.633423848023234e-05,  -1.304435675240177e-07,  -6.676804826685181e-10,
   1.253519297009214e-11,  -9.331079238285303e-14,   2.093119435820236e-15,   6.294653305117605e-17,   7.353395663087981e-19,   4.913540086092577e-01,  -5.394823231787030e-03,
   3.633421038830212e-05,  -1.304426884853100e-07,  -6.676902696856803e-10,   1.253550137116479e-11,  -9.329844389720485e-14,   2.093304380507963e-15,   6.294462706951553e-17,
   7.351216586854006e-19,   6.629556444779101e-01,  -6.992503738558947e-03,   3.959095916081300e-05,  -2.451253258042075e-08,  -2.331219113762763e-09,   2.120410744407576e-11,
  -3.583885832921610e-14,   1.204640974421958e-15,   1.061793753754623e-16,   1.168493447053266e-18,   6.629612745586104e-01,  -6.992514096777074e-03,   3.958896826060800e-05,
  -2.448232631687374e-08,  -2.331290607904269e-09,   2.120780004928075e-11,  -3.541711566068957e-14,   1.210456608963515e-15,   1.061154769045168e-16,   1.162142257093461e-18,
   6.629705170426994e-01,  -6.992531092140811e-03,   3.958569983308170e-05,  -2.443273400861990e-08,  -2.331407327142563e-09,   2.121387450911456e-11,  -3.472494497934228e-14,
   1.219980365285987e-15,   1.060098530824476e-16,   1.151711554242093e-18,   6.629803237546773e-01,  -6.992549112857511e-03,   3.958223172113274e-05,  -2.438010751325198e-08,
  -2.331530292077444e-09,   2.122033687423937e-11,  -3.399075526184316e-14,   1.230053793313296e-15,   1.058967947161707e-16,   1.140638101573904e-18,   6.629880414872835e-01,
  -6.992563286076675e-03,   3.957950225717340e-05,  -2.433868639742327e-08,  -2.331626426794177e-09,   2.122543499916224e-11,  -3.341313097532991e-14,   1.237958448837717e-15,
   1.058071058930506e-16,   1.131919156153819e-18,   6.629924954610148e-01,  -6.992571462038797e-03,   3.957792701351789e-05,  -2.431477994151377e-08,  -2.331681651784436e-09,
   2.122838211373966e-11,  -3.307984791005767e-14,   1.242511084141591e-15,   1.057550598152323e-16,   1.126885655301590e-18,   6.629941679571931e-01,  -6.992574531498333e-03,
   3.957733549072436e-05,  -2.430580254208559e-08,  -2.331702340891392e-09,   2.122948970740204e-11,  -3.295471105468149e-14,   1.244218886676370e-15,   1.057354621715710e-16,
   1.124995219179710e-18,   6.629944451965700e-01,  -6.992575040268493e-03,   3.957723743718910e-05,  -2.430431439445716e-08,  -2.331705767852441e-09,   2.122967335556799e-11,
  -3.293396858231778e-14,   1.244501886680299e-15,   1.057322107428006e-16,   1.124681836188736e-18,   8.647360779339194e-01,  -8.592500896577071e-03,   3.494628040031229e-05,
   2.039807958195565e-07,  -4.424444601721414e-09,   1.469229390994619e-11,   3.033217769353277e-13,  -8.436942662892531e-16,   1.385386024765575e-16,   2.329481749331137e-18,
   8.647410434568703e-01,  -8.592413738885656e-03,   3.494250632318124e-05,   2.040016844860011e-07,  -4.423790603707685e-09,   1.468995866868209e-11,   3.038713151925745e-13,
  -8.320162691811622e-16,   1.384199168280602e-16,   2.319950329272237e-18,   8.647491947790750e-01,  -8.592270648983913e-03,   3.493631097026624e-05,   2.040359742889262e-07,
  -4.422716113563740e-09,   1.468615004972703e-11,   3.047731234142773e-13,  -8.128802917419111e-16,   1.382240340008008e-16,   2.304296096549840e-18,   8.647578434355581e-01,
  -8.592118810778617e-03,   3.492973777336057e-05,   2.040723552761463e-07,  -4.421574846219019e-09,   1.468214282403362e-11,   3.057295373532485e-13,  -7.926235910573113e-16,
   1.380147734541985e-16,   2.287676465696524e-18,   8.647646495925728e-01,  -8.591999306970511e-03,   3.492456503227684e-05,   2.041009850390791e-07,  -4.420675830236144e-09,
   1.467901371005578e-11,   3.064818954652848e-13,  -7.767162617772348e-16,   1.378490617120354e-16,   2.274590048302243e-18,   8.647685774061259e-01,  -8.591930336443643e-03,
   3.492157990242901e-05,   2.041175069307407e-07,  -4.420156656868087e-09,   1.467721768472461e-11,   3.069159574530013e-13,  -7.675497843463351e-16,   1.377530166442280e-16,
   2.267034955676543e-18,   8.647700523103022e-01,  -8.591904436844440e-03,   3.492045898677205e-05,   2.041237108948495e-07,  -4.419961639048844e-09,   1.467654511934929e-11,
   3.070789258000703e-13,  -7.641103186719882e-16,   1.377168733897870e-16,   2.264197441015650e-18,   8.647702967952579e-01,  -8.591900143589801e-03,   3.492027318055524e-05,
   2.041247392817184e-07,  -4.419929308727553e-09,   1.467643373010298e-11,   3.071059387504853e-13,  -7.635403171681731e-16,   1.377108780470092e-16,   2.263727055885760e-18,
   1.098509419400546e+00,  -9.927302212685405e-03,   1.545849664374020e-05,   5.707662339212075e-07,  -4.985471441705312e-09,  -4.256257291005421e-11,   9.429001032056411e-13,
   4.138861770706534e-15,   5.542600672395927e-17,   4.242074289744455e-18,   1.098511610721033e+00,  -9.927058753585873e-03,   1.545425124831677e-05,   5.707057718543480e-07,
  -4.983456102965556e-09,  -4.254986506231271e-11,   9.431202919159977e-13,   4.160136294788847e-15,   5.539565430094789e-17,   4.225026225682542e-18,   1.098515207693532e+00,
  -9.926659094691613e-03,   1.544728298902663e-05,   5.706065267950391e-07,  -4.980147258809997e-09,  -4.252895741816410e-11,   9.434816705394543e-13,   4.194998694513513e-15,
   5.534419262814083e-17,   4.197032577498276e-18,   1.098519023768613e+00,  -9.926235051017135e-03,   1.543989081865841e-05,   5.705012380936165e-07,  -4.976635858158502e-09,
  -4.250671081696139e-11,   9.438649870797000e-13,   4.231904522400602e-15,   5.528736992173453e-17,   4.167320401735886e-18,   1.098522026612097e+00,  -9.925901344733631e-03,
   1.543407436636922e-05,   5.704183883681793e-07,  -4.973872033489253e-09,  -4.248915781219459e-11,   9.441665600887805e-13,   4.260887418526823e-15,   5.524104578533929e-17,
   4.143930483325158e-18,   1.098523759440382e+00,  -9.925708763653543e-03,   1.543071806893983e-05,   5.703705794035777e-07,  -4.972276842404864e-09,  -4.247900968610468e-11,
   9.443405633705782e-13,   4.277589084722372e-15,   5.521366858757126e-17,   4.130429205274335e-18,   1.098524410102239e+00,  -9.925636448930521e-03,   1.542945783867373e-05,
   5.703526276516566e-07,  -4.971677806999096e-09,  -4.247519557458500e-11,   9.444058956181412e-13,   4.283856014051035e-15,   5.520326677011055e-17,   4.125358871028950e-18,
   1.098524517957046e+00,  -9.925624461803281e-03,   1.542924894236381e-05,   5.703496519440484e-07,  -4.971578506971976e-09,  -4.247456315226385e-11,   9.444167249643913e-13,
   4.284894598680506e-15,   5.520153611657872e-17,   4.124518365807153e-18,   1.364173575174945e+00,  -1.041478788137332e-02,  -2.854345244967285e-05,   9.041001578848890e-07,
   2.217249562374332e-09,  -1.643770923955338e-10,  -3.296112633829447e-14,   4.041238636903127e-14,   2.007625736755137e-16,  -2.023970480329220e-18,   1.364169517038416e+00,
  -1.041440272371068e-02,  -2.854155960397407e-05,   9.038672552706780e-07,   2.217188758168688e-09,  -1.642564932408488e-10,  -3.215722292151050e-14,   4.040170012632755e-14,
   2.009561120488939e-16,  -2.035753578355044e-18,   1.364162855144969e+00,  -1.041377049668262e-02,  -2.853845222580580e-05,   9.034850318982768e-07,   2.217090180590885e-09,
  -1.640585334944112e-10,  -3.083694903044120e-14,   4.038411301902473e-14,   2.012701595501971e-16,  -2.055134377532707e-18,   1.364155786625364e+00,  -1.041309975224202e-02,
  -2.853515510370406e-05,   9.030796318192537e-07,   2.216987271087021e-09,  -1.638485145998202e-10,  -2.943531326912172e-14,   4.036539198618513e-14,   2.015983958056548e-16,
  -2.075748956245061e-18,   1.364150223854592e+00,  -1.041257194327338e-02,  -2.853256028447036e-05,   9.027607017861972e-07,   2.216907503941149e-09,  -1.636832516161534e-10,
  -2.833169954962602e-14,   4.035061511386183e-14,   2.018531087617910e-16,  -2.092008861927373e-18,   1.364147013547483e+00,  -1.041226736262323e-02,  -2.853106277674346e-05,
   9.025766899116122e-07,   2.216861959183603e-09,  -1.635878843457255e-10,  -2.769457594353285e-14,   4.034206970744127e-14,   2.019986625399528e-16,  -2.101407213598577e-18,
   1.364145808059735e+00,  -1.041215299489487e-02,  -2.853050045018152e-05,   9.025076008620894e-07,   2.216844949382588e-09,  -1.635520747333612e-10,  -2.745529083233803e-14,
   4.033885753422981e-14,   2.020530462671269e-16,  -2.104939113288226e-18,   1.364145608233650e+00,  -1.041213403708826e-02,  -2.853040723663541e-05,   9.024961488506039e-07,
   2.216842134655701e-09,  -1.635461388696900e-10,  -2.741562385430550e-14,   4.033832489702269e-14,   2.020620467414982e-16,  -2.105524719871387e-18,   1.652284932303923e+00,
  -8.780983578469842e-03,  -9.549938469196656e-05,   2.823408513324847e-07,   2.075474812319141e-08,   7.214642451544176e-11,  -5.496309294864316e-12,  -5.537301512939399e-14,
   1.862758120741686e-15,   4.495091009051196e-17,   1.652271377543152e+00,  -8.780862683301029e-03,  -9.548172930594398e-05,   2.824421575558960e-07,   2.074310343150467e-08,
   7.198454884741682e-11,  -5.488915651874949e-12,  -5.514695197951565e-14,   1.861381987074220e-15,   4.479335554132231e-17,   1.652249127014377e+00,  -8.780664183366925e-03,
  -9.545275229010529e-05,   2.826083031172586e-07,   2.072399817692925e-08,   7.171928928592124e-11,  -5.476781798847887e-12,  -5.477641405966463e-14,   1.859114889288298e-15,
   4.453497802392952e-17,   1.652225519935960e+00,  -8.780453517559763e-03,  -9.542201516066338e-05,   2.827843724230729e-07,   2.070374150364623e-08,   7.143848759996459e-11,
  -5.463912303392590e-12,  -5.438403420583467e-14,   1.856698537883102e-15,   4.426119135976686e-17,   1.652206942816405e+00,  -8.780287692049022e-03,  -9.539783191563467e-05,
   2.829227779411349e-07,   2.068781059944677e-08,   7.121797194462028e-11,  -5.453787906134742e-12,  -5.407580039595326e-14,   1.854789064580982e-15,   4.404598886645125e-17,
   1.652196222308933e+00,  -8.780191978719962e-03,  -9.538387811196658e-05,   2.830025896244571e-07,   2.067862105339603e-08,   7.109089897430686e-11,  -5.447946510409922e-12,
  -5.389814145778950e-14,   1.853683952318533e-15,   4.392189908866103e-17,   1.652192196786239e+00,  -8.780156035111036e-03,  -9.537863885281132e-05,   2.830325474566790e-07,
   2.067517113607907e-08,   7.104321787633416e-11,  -5.445753309500175e-12,  -5.383147199237819e-14,   1.853268383023846e-15,   4.387532250940156e-17,   1.652191529505325e+00,
  -8.780150076821942e-03,  -9.537777039872152e-05,   2.830375127502203e-07,   2.067459930766757e-08,   7.103531595397525e-11,  -5.445389770959155e-12,  -5.382042285448589e-14,
   1.853199465427038e-15,   4.386760284894039e-17,   1.912909810402291e+00,  -3.379086407961896e-03,  -8.705335514148113e-05,  -1.648514886198068e-06,  -1.989679170122939e-08,
   2.064177041148393e-11,   8.568496331892760e-12,   2.482681789011225e-13,   3.750326881355855e-15,   3.233505029460293e-18,   1.912897388118947e+00,  -3.379790068138847e-03,
  -8.707023919263988e-05,  -1.648479246537682e-06,  -1.987832666048360e-08,   2.138378702443298e-11,   8.583224419120774e-12,   2.482744003750939e-13,   3.739973752134465e-15,
   2.848273179321003e-18,   1.912876993210004e+00,  -3.380945227769302e-03,  -8.709794564497640e-05,  -1.648419975023607e-06,  -1.984799069851083e-08,   2.260193411961154e-11,
   8.607372954347153e-12,   2.482831872491001e-13,   3.722944804356130e-15,   2.215822628581980e-18,   1.912855350297725e+00,  -3.382170924398061e-03,  -8.712732876298985e-05,
  -1.648356046050222e-06,  -1.981577119579570e-08,   2.389448980296364e-11,   8.632955587860105e-12,   2.482905717697193e-13,   3.704831526544590e-15,   1.544706482523465e-18,
   1.912838315520028e+00,  -3.383135541662924e-03,  -8.715044215269391e-05,  -1.648304982565273e-06,  -1.979039206843686e-08,   2.491174199572210e-11,   8.653059653389897e-12,
   2.482949794786893e-13,   3.690544301968047e-15,   1.016510506497060e-18,   1.912828483738642e+00,  -3.383692236136052e-03,  -8.716377681887799e-05,  -1.648275211772430e-06,
  -1.977573638172988e-08,   2.549881932496775e-11,   8.664650223728976e-12,   2.482969604715293e-13,   3.682286065038112e-15,   7.116696019673766e-19,   1.912824791678822e+00,
  -3.383901279494959e-03,  -8.716878326350294e-05,  -1.648263975640700e-06,  -1.977023134497954e-08,   2.571927287409003e-11,   8.669000351313466e-12,   2.482975979811609e-13,
   3.679182597814755e-15,   5.971972849496600e-19,   1.912824179660300e+00,  -3.383935931373607e-03,  -8.716961310824323e-05,  -1.648262110089147e-06,  -1.976931871769732e-08,
   2.575581621329578e-11,   8.669721328658365e-12,   2.482976980458358e-13,   3.678668026240153e-15,   5.782217821534791e-19,   2.668234457165009e-03,  -3.104663821762714e-05,
   2.695111534964579e-07,  -2.112006687969476e-09,   1.470163146182400e-11,  -1.047743049275704e-13,   1.169262851241018e-15,   1.417611285171506e-17,   3.811593589122614e-19,
  -5.736621202651146e-22,   2.668272835854557e-03,  -3.104754040525973e-05,   2.695237206479058e-07,  -2.112155432432804e-09,   1.470414507155116e-11,  -1.047320057395060e-13,
   1.170755202398756e-15,   1.417214529489441e-17,   3.798876598070215e-19,  -6.120365186662733e-22,   2.668335841981557e-03,  -3.104902153812995e-05,   2.695443532183936e-07,
  -2.112399577070343e-09,   1.470827385725580e-11,  -1.046625740131103e-13,   1.173201467513539e-15,   1.416549030949469e-17,   3.777984951763444e-19,  -6.749685560330626e-22,
   2.668402698114842e-03,  -3.105059319690670e-05,   2.695662480879831e-07,  -2.112658574324671e-09,   1.471265792521301e-11,  -1.045889143058083e-13,   1.175792152598508e-15,
   1.415823654500301e-17,   3.755797472071738e-19,  -7.416547619578372e-22,   2.668455315519598e-03,  -3.105183014574559e-05,   2.695834809992715e-07,  -2.112862363757064e-09,
   1.471611045700573e-11,  -1.045309530707376e-13,   1.177827419757306e-15,   1.415238866158397e-17,   3.738321514637136e-19,  -7.940721690148596e-22,   2.668485682564520e-03,
  -3.105254403119414e-05,   2.695934270644091e-07,  -2.112979957481526e-09,   1.471810388062975e-11,  -1.044975062964644e-13,   1.179000562323643e-15,   1.414895799725794e-17,
   3.728230088381048e-19,  -8.242971797437211e-22,   2.668497085788583e-03,  -3.105281210569710e-05,   2.695971620270465e-07,  -2.113024111854569e-09,   1.471885260103931e-11,
  -1.044849474212356e-13,   1.179440814904613e-15,   1.414765921806524e-17,   3.724439580748460e-19,  -8.356420327631996e-22,   2.668498976041298e-03,  -3.105285654306344e-05,
   2.695977811566997e-07,  -2.113031430903006e-09,   1.471897672113100e-11,  -1.044828656460686e-13,   1.179513778608908e-15,   1.414744337138741e-17,   3.723811193109058e-19,
  -8.375223438368918e-22,   2.405986810745522e-02,  -2.792512220634932e-04,   2.405059614800626e-06,  -1.856328080578897e-08,   1.256337310117701e-10,  -8.622107398959014e-13,
   9.695172606290830e-15,   1.377248588901115e-16,   3.387316731461080e-18,  -4.472311352109128e-21,   2.406021058106724e-02,  -2.792591514590890e-04,   2.405167004642950e-06,
  -1.856450432502744e-08,   1.256545835474740e-10,  -8.617996898210351e-13,   9.708428834107655e-15,   1.376925992156192e-16,   3.375720946126511e-18,  -4.821034659307968e-21,
   2.406077281800985e-02,  -2.792721692223926e-04,   2.405343315373483e-06,  -1.856651250737176e-08,   1.256888366847641e-10,  -8.611249603358372e-13,   9.730157605541180e-15,
   1.376383529760720e-16,   3.356671232819493e-18,  -5.392922826232907e-21,   2.406136940992510e-02,  -2.792859825879176e-04,   2.405530412258159e-06,  -1.856864276988623e-08,
   1.257252095061717e-10,  -8.604091246579980e-13,   9.753167999298646e-15,   1.375790459222198e-16,   3.336439935647520e-18,  -5.998926462422571e-21,   2.406183894180603e-02,
  -2.792968541502260e-04,   2.405677671218388e-06,  -1.857031888200838e-08,   1.257538550653248e-10,  -8.598458350412131e-13,   9.771244331663681e-15,   1.375311066071730e-16,
   3.320504764997446e-18,  -6.475263843166126e-21,   2.406210992220896e-02,  -2.793031284901416e-04,   2.405762662348045e-06,  -1.857128603248015e-08,   1.257703949703102e-10,
  -8.595207807765191e-13,   9.781663315769917e-15,   1.375029333924465e-16,   3.311303060482037e-18,  -6.749930240474717e-21,   2.406221167887143e-02,  -2.793054845952791e-04,
   2.405794578327326e-06,  -1.857164917561011e-08,   1.257766073789247e-10,  -8.593987256094894e-13,   9.785573248402088e-15,   1.374922583743396e-16,   3.307846747166882e-18,
  -6.853025313175433e-21,   2.406222854653837e-02,  -2.793058751549131e-04,   2.405799868908641e-06,  -1.857170937012067e-08,   1.257776372542040e-10,  -8.593784935330759e-13,
   9.786221243826094e-15,   1.374904837898267e-16,   3.307273762023158e-18,  -6.870112427656543e-21,   6.708988091242003e-02,  -7.746481696930922e-04,   6.561928736860852e-06,
  -4.901534666894209e-08,   3.111473248612335e-10,  -1.946458665050692e-12,   2.247260248031143e-14,   4.360543592386990e-16,   9.226924879556863e-18,  -9.238145087007656e-21,
   6.709081525790082e-02,  -7.746691051698434e-04,   6.562194682588289e-06,  -4.901810563189879e-08,   3.111957227043937e-10,  -1.945156769814065e-12,   2.250868221533932e-14,
   4.359805285507979e-16,   9.193906987233126e-18,  -1.022685825376907e-20,   6.709234916466890e-02,  -7.747034749929705e-04,   6.562631305558257e-06,  -4.902263357769041e-08,
   3.112752308994475e-10,  -1.943019674722106e-12,   2.256781763121502e-14,   4.358556752415066e-16,   9.139664721344825e-18,  -1.184829790810873e-20,   6.709397679561253e-02,
  -7.747399451865946e-04,   6.563094637092067e-06,  -4.902743625923647e-08,   3.113596703201724e-10,  -1.940752296035868e-12,   2.263043528616928e-14,   4.357182413535074e-16,
   9.082057971847349e-18,  -1.356646478446308e-20,   6.709525777673465e-02,  -7.747686482566686e-04,   6.563459311011625e-06,  -4.903121467800893e-08,   3.114261788851517e-10,
  -1.938968037420459e-12,   2.267962183488021e-14,   4.356064954118231e-16,   9.036684019804620e-18,  -1.491699770867600e-20,   6.709599706681936e-02,  -7.747852136947566e-04,
   6.563669783318686e-06,  -4.903339474954061e-08,   3.114645840226422e-10,  -1.937938380281969e-12,   2.270797070893070e-14,   4.355405685947357e-16,   9.010482990788258e-18,
  -1.569574459204770e-20,   6.709627467964471e-02,  -7.747914342448104e-04,   6.563748820004599e-06,  -4.903421328831784e-08,   3.114790096410426e-10,  -1.937551747793504e-12,
   2.271860887590631e-14,   4.355155410978903e-16,   9.000641446318422e-18,  -1.598804460879334e-20,   6.709632069805219e-02,  -7.747924653933619e-04,   6.563761921584876e-06,
  -4.903434896757378e-08,   3.114814011103992e-10,  -1.937487658666479e-12,   2.272037192885002e-14,   4.355113781212387e-16,   8.999009922023085e-18,  -1.603649080736415e-20,
   1.322649633831734e-01,  -1.514621582400502e-03,   1.248768411074126e-05,  -8.817376119194946e-08,   4.951722734666502e-10,  -2.503789721465216e-12,   3.179147808334361e-14,
   9.959590844855229e-16,   1.785192589823833e-17,  -1.200747405889738e-20,   1.322667413233925e-01,  -1.514659238216783e-03,   1.248810730024521e-05,  -8.817729915744352e-08,
   4.952409623253585e-10,  -2.500815292869580e-12,   3.186121978979538e-14,   9.958438617711248e-16,   1.778495966270535e-17,  -1.401105967408867e-20,   1.322696601436867e-01,
  -1.514721057421197e-03,   1.248880207697960e-05,  -8.818310424201518e-08,   4.953538330670837e-10,  -2.495932570592993e-12,   3.197551878388519e-14,   9.956473118567228e-16,
   1.767494632429539e-17,  -1.729685001236612e-20,   1.322727572969904e-01,  -1.514786653853051e-03,   1.248953934682983e-05,  -8.818925972901308e-08,   4.954737427208648e-10,
  -2.490752019115875e-12,   3.209653601253484e-14,   9.954287162220541e-16,   1.755810885253132e-17,  -2.077866982530522e-20,   1.322751948159145e-01,  -1.514838279659453e-03,
   1.249011962412568e-05,  -8.819410112042286e-08,   4.955682171569330e-10,  -2.486675190183606e-12,   3.219158681022677e-14,   9.952494158494167e-16,   1.746608158029063e-17,
  -2.351550015639933e-20,   1.322766015729873e-01,  -1.514868074350560e-03,   1.249045453036503e-05,  -8.819689397588458e-08,   4.956227822115095e-10,  -2.484322491916308e-12,
   3.224636613235605e-14,   9.951430279532965e-16,   1.741294065671745e-17,  -2.509362093557748e-20,   1.322771298275149e-01,  -1.514879262634363e-03,   1.249058029417695e-05,
  -8.819794249290510e-08,   4.956432798674001e-10,  -2.483439053164358e-12,   3.226692187751705e-14,   9.951025284083312e-16,   1.739298001880935e-17,  -2.568596408705495e-20,
   1.322772173934360e-01,  -1.514881117256824e-03,   1.249060114149718e-05,  -8.819811628758280e-08,   4.956466780657627e-10,  -2.483292611757480e-12,   3.227032852490553e-14,
   9.950957860282213e-16,   1.738967095735835e-17,  -2.578413988327223e-20,   2.203791220735925e-01,  -2.493526668552083e-03,   1.973600584718718e-05,  -1.270309967173468e-07,
   5.558265124881399e-10,  -1.312781321945808e-12,   2.900171672817860e-14,   1.898641976177305e-15,   3.002903891963191e-17,  -1.641384730770913e-20,   2.203819316073304e-01,
  -2.493580907305744e-03,   1.973648079568357e-05,  -1.270328170244110e-07,   5.558898092593953e-10,  -1.307110338320276e-12,   2.911897287434234e-14,   1.898464684571492e-15,
   2.991362201785698e-17,  -1.989076343936158e-20,   2.203865439607108e-01,  -2.493669949551140e-03,   1.973726054003397e-05,  -1.270357995214743e-07,   5.559939007881096e-10,
  -1.297800944158792e-12,   2.931113464670929e-14,   1.898160801678880e-15,   2.972401185006547e-17,  -2.559278873374614e-20,   2.203914380908163e-01,  -2.493764431006676e-03,
   1.973808796283980e-05,  -1.270389562560297e-07,   5.561045938020257e-10,  -1.287923575024873e-12,   2.951458012382902e-14,   1.897820933371101e-15,   2.952263852229343e-17,
  -3.163504886173438e-20,   2.203952898452187e-01,  -2.493838788951927e-03,   1.973873918792618e-05,  -1.270414348847638e-07,   5.561918861230295e-10,  -1.280150492670211e-12,
   2.967436462234301e-14,   1.897540848458621e-15,   2.936402523233636e-17,  -3.638451225317189e-20,   2.203975127873621e-01,  -2.493881702593681e-03,   1.973911503830279e-05,
  -1.270428630498920e-07,   5.562423348401425e-10,  -1.275664682780084e-12,   2.976644778335518e-14,   1.897374155682163e-15,   2.927243390366177e-17,  -3.912318020267175e-20,
   2.203983475279009e-01,  -2.493897817133975e-03,   1.973925617681556e-05,  -1.270433989053871e-07,   5.562612921727281e-10,  -1.273980252548337e-12,   2.980100104620308e-14,
   1.897310606700122e-15,   2.923803054823509e-17,  -4.015113438832734e-20,   2.203984858982866e-01,  -2.493900488351855e-03,   1.973927957270041e-05,  -1.270434877081727e-07,
   5.562644353253637e-10,  -1.273701036036807e-12,   2.980672743143083e-14,   1.897300022218181e-15,   2.923232717785604e-17,  -4.032150913257090e-20,   3.325567588075147e-01,
  -3.699800067015026e-03,   2.756015595461949e-05,  -1.513547522899441e-07,   3.195442847704075e-10,   2.988089262682605e-12,   1.087051492511644e-14,   3.131843548329751e-15,
   4.853347610472737e-17,  -3.933510365754547e-20,   3.325606813691500e-01,  -3.699864668376991e-03,   2.756042894093641e-05,  -1.513504210536251e-07,   3.195697361080174e-10,
   2.997442738774776e-12,   1.106013413769180e-14,   3.131493402000732e-15,   4.835212558608259e-17,  -4.487967495131345e-20,   3.325671209172063e-01,  -3.699970720616046e-03,
   2.756087710858882e-05,  -1.513433010098782e-07,   3.196118091463109e-10,   3.012797131080343e-12,   1.137090124485730e-14,   3.130898119748411e-15,   4.805419380708197e-17,
  -5.397266198487316e-20,   3.325739538138873e-01,  -3.700083248399938e-03,   2.756135267153936e-05,  -1.513357330214723e-07,   3.196568463283729e-10,   3.029088145279087e-12,
   1.169993732033432e-14,   3.130238690889321e-15,   4.773777332900891e-17,  -6.360832447657035e-20,   3.325793313673586e-01,  -3.700171807025014e-03,   2.756172695839992e-05,
  -1.513297675109550e-07,   3.196925760617844e-10,   3.041908383715494e-12,   1.195837478113061e-14,   3.129699612326466e-15,   4.748853833516303e-17,  -7.118242522843756e-20,
   3.325824348697980e-01,  -3.700222915404854e-03,   2.756194297323305e-05,  -1.513263209047280e-07,   3.197133106109173e-10,   3.049306836873576e-12,   1.210731730437844e-14,
   3.129380445568243e-15,   4.734461589200983e-17,  -7.554988548580996e-20,   3.325836002679374e-01,  -3.700242107008644e-03,   2.756202409019515e-05,  -1.513250259528304e-07,
   3.197211182156493e-10,   3.052084961357070e-12,   1.216320760730554e-14,   3.129259073578939e-15,   4.729055573081848e-17,  -7.718920979976835e-20,   3.325837934494718e-01,
  -3.700245288286345e-03,   2.756203753655842e-05,  -1.513248112581938e-07,   3.197224135757524e-10,   3.052545471637173e-12,   1.217247016229605e-14,   3.129238874172423e-15,
   4.728159364984182e-17,  -7.746091429776972e-20,   4.703118745130442e-01,  -5.110164513541674e-03,   3.471529433905704e-05,  -1.393277331588283e-07,  -4.333064866760533e-10,
   1.115751978359940e-11,  -5.307749518068923e-15,   4.431498692842934e-15,   7.949206251248260e-17,  -1.027050574494903e-19,   4.703168140103728e-01,  -5.110223939109408e-03,
   3.471492432141412e-05,  -1.393117434920261e-07,  -4.333141292395080e-10,   1.117075065301513e-11,  -4.996646321720677e-15,   4.430747292584499e-15,   7.922052683678472e-17,
  -1.111073002155642e-19,   4.703249229568354e-01,  -5.110321490839165e-03,   3.471431687400259e-05,  -1.392854802618703e-07,  -4.333261987635902e-10,   1.119246949766052e-11,
  -4.486703989966429e-15,   4.429482741287524e-15,   7.877442513008314e-17,  -1.248868763780205e-19,   4.703335271243987e-01,  -5.110424994024915e-03,   3.471367232066087e-05,
  -1.392575944563343e-07,  -4.333383578684106e-10,   1.121551242986582e-11,  -3.946681689741337e-15,   4.428098843302936e-15,   7.830062728096236e-17,  -1.394889148979662e-19,
   4.703402986123081e-01,  -5.110506446694975e-03,   3.471316505052372e-05,  -1.392356347954498e-07,  -4.333474587945246e-10,   1.123364554275832e-11,  -3.522453469979601e-15,
   4.426979241135678e-15,   7.792742178943396e-17,  -1.509668936687994e-19,   4.703442065554924e-01,  -5.110553452666489e-03,   3.471287229373865e-05,  -1.392229560804875e-07,
  -4.333525235496435e-10,   1.124410978745064e-11,  -3.277932726180451e-15,   4.426320891521056e-15,   7.771190812630322e-17,  -1.575854763346417e-19,   4.703456740242020e-01,
  -5.110571103506226e-03,   3.471276236041967e-05,  -1.392181940828861e-07,  -4.333543899838421e-10,   1.124803907640683e-11,  -3.186171299807135e-15,   4.426071368650192e-15,
   7.763095618244740e-17,  -1.600697633702815e-19,   4.703459172779971e-01,  -5.110574029366042e-03,   3.471274413738621e-05,  -1.392174046601262e-07,  -4.333546975033447e-10,
   1.124869040493488e-11,  -3.170963618801099e-15,   4.426029885030269e-15,   7.761753595201527e-17,  -1.604815137363790e-19,   6.356163689448733e-01,  -6.677554745217345e-03,
   3.908690403247490e-05,  -5.844728218776163e-08,  -1.910872626066432e-09,   2.116699360222851e-11,   5.079873613733436e-14,   5.119887370507788e-15,   1.308103519086272e-16,
  -1.527520018923941e-19,   6.356219280187234e-01,  -6.677579590749849e-03,   3.908527309704676e-05,  -5.841703099168271e-08,  -1.910758111184199e-09,   2.118227569320192e-11,
   5.131154084049147e-14,   5.118774042606864e-15,   1.304049344170457e-16,  -1.650911205113400e-19,   6.356310539707674e-01,  -6.677620369348781e-03,   3.908259572510681e-05,
  -5.836735304518536e-08,  -1.910569329770544e-09,   2.120736109973142e-11,   5.215222228275157e-14,   5.116900800661380e-15,   1.297388722614926e-16,  -1.853271106978920e-19,
   6.356407370837915e-01,  -6.677663625865370e-03,   3.907975492536034e-05,  -5.831461955147968e-08,  -1.910367949896870e-09,   2.123397504150474e-11,   5.304265870925438e-14,
   5.114851303743973e-15,   1.290314467081595e-16,  -2.067709080962055e-19,   6.356483575799780e-01,  -6.677697659753320e-03,   3.907751927277877e-05,  -5.827310255587396e-08,
  -1.910208690248433e-09,   2.125491769506182e-11,   5.374228390417679e-14,   5.113193596451928e-15,   1.284742071543788e-16,  -2.236268593062273e-19,   6.356527554513455e-01,
  -6.677717297679885e-03,   3.907622906278475e-05,  -5.824913608955723e-08,  -1.910116468939426e-09,   2.126700303038324e-11,   5.414558892118327e-14,   5.112218977108584e-15,
   1.281524167664416e-16,  -2.333465535034572e-19,   6.356544068833023e-01,  -6.677724671217983e-03,   3.907574458155911e-05,  -5.824013527201582e-08,  -1.910081780461811e-09,
   2.127154098826525e-11,   5.429694654972095e-14,   5.111849611324784e-15,   1.280315442034832e-16,  -2.369948426793651e-19,   6.356546806311293e-01,  -6.677725893450609e-03,
   3.907566427214928e-05,  -5.823864319589204e-08,  -1.910076027266892e-09,   2.127229320884714e-11,   5.432203163098788e-14,   5.111788205036404e-15,   1.280115058921631e-16,
  -2.375995168770271e-19,   8.309390510668958e-01,  -8.304318122109933e-03,   3.698028318969919e-05,   1.359378832660572e-07,  -4.056824277707150e-09,   2.225916486582572e-11,
   3.526988622556574e-13,   4.670892499540089e-15,   1.937645405931979e-16,   2.157993647142376e-19,   8.309443066758541e-01,  -8.304259974881434e-03,   3.697682361542487e-05,
   1.359696776284502e-07,  -4.056062404795083e-09,   2.227313248863643e-11,   3.534579472536195e-13,   4.671509467180823e-15,   1.931392495577456e-16,   1.975736035740407e-19,
   8.309529342536505e-01,  -8.304164506953763e-03,   3.697114463721766e-05,   1.360218875914440e-07,  -4.054810502832302e-09,   2.229606361772219e-11,   3.547023030914991e-13,
   4.672455057764743e-15,   1.921119957140442e-16,   1.676829676565761e-19,   8.309620882982512e-01,  -8.304063194725665e-03,   3.696511944545468e-05,   1.360773059301478e-07,
  -4.053480557267024e-09,   2.232039661887507e-11,   3.560202064547983e-13,   4.673367049160792e-15,   1.910210014366345e-16,   1.360074172132052e-19,   8.309692922303227e-01,
  -8.303983451781464e-03,   3.696037805375140e-05,   1.361209345965615e-07,  -4.052432739757340e-09,   2.233954769803770e-11,   3.570556253993830e-13,   4.674018696873914e-15,
   1.901616630961243e-16,   1.111081464801491e-19,   8.309734496204483e-01,  -8.303937426684832e-03,   3.695764189073092e-05,   1.361461192222615e-07,  -4.051827565862741e-09,
   2.235060049224966e-11,   3.576524729398114e-13,   4.674368297464586e-15,   1.896654344249539e-16,   9.675015959714085e-20,   8.309750107353318e-01,  -8.303920143069146e-03,
   3.695661446963654e-05,   1.361555773711917e-07,  -4.051600230542909e-09,   2.235475098667653e-11,   3.578764603302346e-13,   4.674494573221231e-15,   1.894790413566667e-16,
   9.136083881657293e-20,   8.309752695110738e-01,  -8.303917278023716e-03,   3.695644416174788e-05,   1.361571452512879e-07,  -4.051562541897264e-09,   2.235543899365801e-11,
   3.579135823343478e-13,   4.674515241364456e-15,   1.894481411774871e-16,   9.046760031108642e-20,   1.059088935339193e+00,  -9.777649998995377e-03,   2.180509789355084e-05,
   4.854629861734834e-07,  -5.599425292261329e-09,  -1.820690518840952e-11,   1.105159248778606e-12,   8.112246950472905e-15,   1.779432584777793e-16,   1.672710101632249e-18,
   1.059092028777525e+00,  -9.777442834915650e-03,   2.180033027393809e-05,   4.854372822373837e-07,  -5.597058032849436e-09,  -1.818253971909486e-11,   1.105849717403785e-12,
   8.120007779243302e-15,   1.770496277994292e-16,   1.642549886590435e-18,   1.059097106669118e+00,  -9.777102749423904e-03,   2.179250491803870e-05,   4.853951101768260e-07,
  -5.593170737888707e-09,  -1.814252361890504e-11,   1.106980653691560e-12,   8.132637114653741e-15,   1.755815294300931e-16,   1.593084385207910e-18,   1.059102494041332e+00,
  -9.776741903126617e-03,   2.178420359968427e-05,   4.853503964972645e-07,  -5.589044585127509e-09,  -1.810004150528252e-11,   1.108177156798504e-12,   8.145886617499833e-15,
   1.740223296802513e-16,   1.540662175823132e-18,   1.059106733451448e+00,  -9.776457922933517e-03,   2.177767185892543e-05,   4.853152313189154e-07,  -5.585796245864122e-09,
  -1.806659207790522e-11,   1.109116270054590e-12,   8.156204650250893e-15,   1.727941972874290e-16,   1.499452428941503e-18,   1.059109179905489e+00,  -9.776294035512055e-03,
   2.177390284108716e-05,   4.852949467191177e-07,  -5.583921151298417e-09,  -1.804728146761465e-11,   1.109657231701297e-12,   8.162115562586507e-15,   1.720850049733225e-16,
   1.475688273770524e-18,   1.059110098536939e+00,  -9.776232494741608e-03,   2.177248764657041e-05,   4.852873315239784e-07,  -5.583216956373799e-09,  -1.804002895628695e-11,
   1.109860175530703e-12,   8.164326888335278e-15,   1.718186182926150e-16,   1.466768153671502e-18,   1.059110250811332e+00,  -9.776222293508937e-03,   2.177225306358144e-05,
   4.852860692952395e-07,  -5.583100221857935e-09,  -1.803882668630089e-11,   1.109893806211027e-12,   8.164693010464226e-15,   1.717744567809614e-16,   1.465289703799991e-18,
   1.322126964071354e+00,  -1.059938377364774e-02,  -1.758894181736161e-05,   9.136298173137324e-07,  -9.830614836773868e-10,  -1.509261034378045e-10,   1.178342323370143e-12,
   4.573146802560256e-14,   1.252483580405313e-16,  -3.227150480029002e-18,   1.322124459376736e+00,  -1.059899447944060e-02,  -1.758976691224281e-05,   9.134161895826893e-07,
  -9.805404841056403e-10,  -1.507897226169449e-10,   1.178824106597956e-12,   4.571374716660539e-14,   1.244184751201557e-16,  -3.271475336126722e-18,   1.322120347432462e+00,
  -1.059835545562621e-02,  -1.759111988144134e-05,   9.130656252354930e-07,  -9.764011210992669e-10,  -1.505658704700127e-10,   1.179612624009666e-12,   4.568449201022335e-14,
   1.230530061276103e-16,  -3.344158138059186e-18,   1.322115984229461e+00,  -1.059767749114114e-02,  -1.759255336919673e-05,   9.126938398168643e-07,  -9.720079412076735e-10,
  -1.503283992958086e-10,   1.180446024771712e-12,   4.565322799020397e-14,   1.215999598187648e-16,  -3.421166396820392e-18,   1.322112550284512e+00,  -1.059714399407188e-02,
  -1.759367999853593e-05,   9.124013806107371e-07,  -9.685497661559607e-10,  -1.501415469435409e-10,   1.181099539000199e-12,   4.562846241440345e-14,   1.204533877588238e-16,
  -3.481689771808055e-18,   1.322110568455183e+00,  -1.059683612834685e-02,  -1.759432958376882e-05,   9.122326519441476e-07,  -9.665536978740210e-10,  -1.500337263639925e-10,
   1.181475740952635e-12,   4.561410537290024e-14,   1.197904719257099e-16,  -3.516585871479929e-18,   1.322109824252413e+00,  -1.059672052659391e-02,  -1.759457339331174e-05,
   9.121693030960759e-07,  -9.658041000445031e-10,  -1.499932416124380e-10,   1.181616828083417e-12,   4.560870200472729e-14,   1.195413126827689e-16,  -3.529683438250229e-18,
   1.322109700889827e+00,  -1.059670136420651e-02,  -1.759461380210456e-05,   9.121588026687004e-07,  -9.656798406095014e-10,  -1.499865308410552e-10,   1.181640205772024e-12,
   4.560780567793798e-14,   1.194999989644961e-16,  -3.531854216755282e-18,   1.615662518956882e+00,  -9.525719966970566e-03,  -9.009554710344647e-05,   6.184053155052796e-07,
   2.079377554223140e-08,  -7.024276014517392e-11,  -5.991200468307555e-12,   2.664879273522913e-14,   3.098535111892695e-15,   1.709796911073269e-17,   1.615649733257488e+00,
  -9.525456306707050e-03,  -9.007786402963465e-05,   6.183060396094008e-07,   2.078113121736334e-08,  -7.016180319634426e-11,  -5.979012376822918e-12,   2.673185540365825e-14,
   3.090898106429459e-15,   1.692873942986830e-17,   1.615628745269432e+00,  -9.525023496172770e-03,  -9.004884215877223e-05,   6.181431459687419e-07,   2.076039223140703e-08,
  -7.002872278370859e-11,  -5.959025608137470e-12,   2.686759324814955e-14,   3.078367353697835e-15,   1.665140690690287e-17,   1.615606477846993e+00,  -9.524564292125426e-03,
  -9.001805824627224e-05,   6.179704172279304e-07,   2.073841198746471e-08,  -6.988727506561117e-11,  -5.937847931414365e-12,   2.701077590778442e-14,   3.065080267003261e-15,
   1.635779474619805e-17,   1.615588955045660e+00,  -9.524202926076152e-03,  -8.999383876841912e-05,   6.178345614184792e-07,   2.072113181239034e-08,  -6.977578241973724e-11,
  -5.921202577783113e-12,   2.712284988599907e-14,   3.054629785992178e-15,   1.612719715552565e-17,   1.615578843006615e+00,  -9.523994386664101e-03,  -8.997986428821954e-05,
   6.177561895166192e-07,   2.071116645324989e-08,  -6.971136885754777e-11,  -5.911604870046218e-12,   2.718728509369841e-14,   3.048601225749420e-15,   1.599430571662857e-17,
   1.615575045970010e+00,  -9.523916080309103e-03,  -8.997461730900070e-05,   6.177267663554054e-07,   2.070742575381891e-08,  -6.968716790981724e-11,  -5.908002470223372e-12,
   2.721143490087537e-14,   3.046337936103571e-15,   1.594443973118213e-17,   1.615574416563944e+00,  -9.523903100029535e-03,  -8.997374757752870e-05,   6.177218893759769e-07,
   2.070680575276610e-08,  -6.968315557029646e-11,  -5.907405407127696e-12,   2.721543563771865e-14,   3.045962789546915e-15,   1.593617563280078e-17,   1.897867831871643e+00,
  -4.159937209048862e-03,  -1.086887710015366e-04,  -1.949783895065904e-06,  -1.679587134196945e-08,   3.228177038787048e-10,   1.710266785238413e-11,   3.530319315507353e-13,
   2.108610629751338e-15,  -1.135935160763602e-16,   1.897852336242513e+00,  -4.160767958868580e-03,  -1.087029046462446e-04,  -1.949315683901213e-06,  -1.675927192014625e-08,
   3.238631428617995e-10,   1.711047563130314e-11,   3.524343598145351e-13,   2.079974114162059e-15,  -1.141778038236299e-16,   1.897826896238286e+00,  -4.162131622648925e-03,
  -1.087260846961945e-04,  -1.948545968171038e-06,  -1.669917631424856e-08,   3.255780993119794e-10,   1.712321090510232e-11,   3.514512041299296e-13,   2.032965038387624e-15,
  -1.151345450807048e-16,   1.897799900497250e+00,  -4.163578376036550e-03,  -1.087506497808750e-04,  -1.947727784999858e-06,  -1.663539435694350e-08,   3.273960301775170e-10,
   1.713661195066095e-11,   3.504050897901823e-13,   1.983088292491238e-15,  -1.161463705422683e-16,   1.897778653310552e+00,  -4.164716834131567e-03,  -1.087699603720596e-04,
  -1.947082817452379e-06,  -1.658518618240031e-08,   3.288254674634531e-10,   1.714707751000095e-11,   3.495796892137753e-13,   1.943837778744033e-15,  -1.169402521025576e-16,
   1.897766390584114e+00,  -4.165373802621497e-03,  -1.087810959681109e-04,  -1.946710172128145e-06,  -1.655620549581690e-08,   3.296499083857629e-10,   1.715308486770240e-11,
   3.491024926789021e-13,   1.921186707207184e-15,  -1.173974410709408e-16,   1.897761785702682e+00,  -4.165620489865757e-03,  -1.087852758083626e-04,  -1.946570160374911e-06,
  -1.654532209871215e-08,   3.299593966778627e-10,   1.715533454355565e-11,   3.489231416957710e-13,   1.912681233146293e-15,  -1.175689355114000e-16,   1.897761022372095e+00,
  -4.165661381229378e-03,  -1.087859685877246e-04,  -1.946546947217240e-06,  -1.654351797448448e-08,   3.300106936482250e-10,   1.715570713526762e-11,   3.488934033221679e-13,
   1.911271341324009e-15,  -1.175973534290965e-16,   2.548205019112915e-03,  -2.898807504987256e-05,   2.455146444486378e-07,  -1.891860868333828e-09,   1.292572795845502e-11,
  -7.065516422179734e-14,   1.720398503378494e-15,   2.407163747539517e-17,   1.631036132954738e-19,  -1.306259006705949e-20,   2.548239979887000e-03,  -2.898888307997034e-05,
   2.455257018548882e-07,  -1.891960818616273e-09,   1.292940731577358e-11,  -7.058431256131196e-14,   1.720992605592179e-15,   2.400383190346907e-17,   1.604109568659080e-19,
  -1.309578831684554e-20,   2.548297374798203e-03,  -2.899020962289153e-05,   2.455438566502242e-07,  -1.892124830762886e-09,   1.293544846341058e-11,  -7.046814512251221e-14,
   1.721960187625028e-15,   2.389239700530883e-17,   1.559943447172044e-19,  -1.315004311989633e-20,   2.548358276788013e-03,  -2.899161722923346e-05,   2.455631233813924e-07,
  -1.892298761988195e-09,   1.294185978713428e-11,  -7.034508245815902e-14,   1.722976363344732e-15,   2.377399190923854e-17,   1.513131827755009e-19,  -1.320727793401958e-20,
   2.548406208098664e-03,  -2.899272505306069e-05,   2.455782886376826e-07,  -1.892435575642295e-09,   1.294690639570409e-11,  -7.024837638762158e-14,   1.723768498856527e-15,
   2.368068808715059e-17,   1.476328634710156e-19,  -1.325208034992441e-20,   2.548433870646164e-03,  -2.899336441197279e-05,   2.455870417006617e-07,  -1.892514504984833e-09,
   1.294981923648257e-11,  -7.019262354026068e-14,   1.724222610821160e-15,   2.362679329976383e-17,   1.455103980416956e-19,  -1.327783980289954e-20,   2.548444258293045e-03,
  -2.899360449989218e-05,   2.455903287324065e-07,  -1.892544138354997e-09,   1.295091310203331e-11,  -7.017169878075436e-14,   1.724392559043932e-15,   2.360654634122427e-17,
   1.447136786780925e-19,  -1.328749441684625e-20,   2.548445980198698e-03,  -2.899364429802220e-05,   2.455908736139131e-07,  -1.892549050226361e-09,   1.295109442932315e-11,
  -7.016823078218323e-14,   1.724420700047520e-15,   2.360318964731628e-17,   1.445816262177215e-19,  -1.328909384095612e-20,   2.297997999162030e-02,  -2.608688312911214e-04,
   2.193837074095804e-06,  -1.667692839698586e-08,   1.110892554815476e-10,  -5.717484846060703e-13,   1.492221493604882e-14,   2.255824383165540e-16,   1.427906489574608e-18,
  -1.182221210129835e-19,   2.298029238186642e-02,  -2.608759538930326e-04,   2.193932107846956e-06,  -1.667773643722764e-08,   1.111211694157133e-10,  -5.710841652471730e-13,
   1.492739653703830e-14,   2.249687262524130e-16,   1.403391304837615e-18,  -1.185241589265133e-19,   2.298080523083276e-02,  -2.608876470451897e-04,   2.194088140849130e-06,
  -1.667906228689838e-08,   1.111735690295508e-10,  -5.699949082952438e-13,   1.493583256919043e-14,   2.239601169927716e-16,   1.363180335041524e-18,  -1.190177712527391e-19,
   2.298134941657251e-02,  -2.609000547208932e-04,   2.194253730727403e-06,  -1.668046819359349e-08,   1.112291795105994e-10,  -5.688409324329094e-13,   1.494468822076044e-14,
   2.228884120062141e-16,   1.320560642898524e-18,  -1.195384982050574e-19,   2.298177770327607e-02,  -2.609098198711722e-04,   2.194384070240383e-06,  -1.668157398238870e-08,
   1.112729527642455e-10,  -5.679340588351323e-13,   1.495158846929107e-14,   2.220438974256193e-16,   1.287053037243208e-18,  -1.199461159147225e-19,   2.298202487978289e-02,
  -2.609154556282504e-04,   2.194459299502660e-06,  -1.668221188748908e-08,   1.112982181610384e-10,  -5.674112103843684e-13,   1.495554301485089e-14,   2.215560809562256e-16,
   1.267728932017293e-18,  -1.201804791727280e-19,   2.298211769775161e-02,  -2.609175719295755e-04,   2.194487550309416e-06,  -1.668245137671029e-08,   1.113077061332461e-10,
  -5.672149750579250e-13,   1.495702274783883e-14,   2.213728197747658e-16,   1.260475148658729e-18,  -1.202683183884675e-19,   2.298213308369714e-02,  -2.609179227377884e-04,
   2.194492233362600e-06,  -1.668249107281384e-08,   1.113092789301822e-10,  -5.671824514919405e-13,   1.495726775846567e-14,   2.213424373280796e-16,   1.259272868041233e-18,
  -1.202828702107235e-19,   6.409266977474529e-02,  -7.244235896101700e-04,   6.002437728326691e-06,  -4.431438716408133e-08,   2.787656064440478e-10,  -1.229244002299890e-12,
   3.841706280741489e-14,   6.749002792805377e-16,   3.779153422121562e-18,  -3.326828040701681e-19,   6.409352444533194e-02,  -7.244425145162914e-04,   6.002676216299137e-06,
  -4.431611969857974e-08,   2.788477715482897e-10,  -1.227254741293043e-12,   3.843067722253329e-14,   6.731730428865781e-16,   3.709473915490645e-18,  -3.335410206497075e-19,
   6.409492755006897e-02,  -7.244735833441660e-04,   6.003067783672583e-06,  -4.431896189988026e-08,   2.789826791059346e-10,  -1.223992792927245e-12,   3.845282737486139e-14,
   6.703343746440323e-16,   3.595181794613832e-18,  -3.349435946865458e-19,   6.409641638614658e-02,  -7.245065504941482e-04,   6.003483335927887e-06,  -4.432197493223612e-08,
   2.791258537924850e-10,  -1.220536707758208e-12,   3.847605858307698e-14,   6.673180869439363e-16,   3.474042671547962e-18,  -3.364232327186864e-19,   6.409758813222803e-02,
  -7.245324963371945e-04,   6.003810427706249e-06,  -4.432434420579073e-08,   2.792385526862452e-10,  -1.217820441765659e-12,   3.849414498685770e-14,   6.649411919641479e-16,
   3.378802602486350e-18,  -3.375814864208348e-19,   6.409826437953198e-02,  -7.245474704000430e-04,   6.003999218799769e-06,  -4.432571075924266e-08,   2.793036012598603e-10,
  -1.216254312109365e-12,   3.850450420585115e-14,   6.635682158367532e-16,   3.323876697233668e-18,  -3.382474398093627e-19,   6.409851831895785e-02,  -7.245530933491255e-04,
   6.004070115519198e-06,  -4.432622376238757e-08,   2.793280291224047e-10,  -1.215666494804646e-12,   3.850837930671509e-14,   6.630524187796669e-16,   3.303258856593380e-18,
  -3.384970398219548e-19,   6.409856041314953e-02,  -7.245540254355094e-04,   6.004081867865003e-06,  -4.432630879202353e-08,   2.793320784680317e-10,  -1.215569070444112e-12,
   3.850902087481348e-14,   6.629669058647770e-16,   3.299841544149522e-18,  -3.385383896895858e-19,   1.263997643242023e-01,  -1.418821247943415e-03,   1.147564592662378e-05,
  -8.059955004342968e-08,   4.553048818613762e-10,  -1.345444922782870e-12,   6.690382917291650e-14,   1.456691022162512e-15,   7.046693544039264e-18,  -6.679262411895675e-19,
   1.264013981763533e-01,  -1.418855664296867e-03,   1.147603549696829e-05,  -8.060142847542223e-08,   4.554479899959658e-10,  -1.341147186567176e-12,   6.692897842752348e-14,
   1.453222684628616e-15,   6.905357318665961e-18,  -6.696706135148561e-19,   1.264040804493665e-01,  -1.418912164883940e-03,   1.147667512816689e-05,  -8.060450782827515e-08,
   4.556829624109594e-10,  -1.334099278476135e-12,   6.696985908699808e-14,   1.447522484554588e-15,   6.673528775951674e-18,  -6.725214838162667e-19,   1.264069266031064e-01,
  -1.418972117151784e-03,   1.147735394650300e-05,  -8.060776928765100e-08,   4.559323365893959e-10,  -1.326631133040931e-12,   6.701268527144229e-14,   1.441465510291718e-15,
   6.427810277849053e-18,  -6.755290781937511e-19,   1.264091665807144e-01,  -1.419019300464493e-03,   1.147788826713790e-05,  -8.061033175277232e-08,   4.561286315172427e-10,
  -1.320761075841526e-12,   6.704599075484443e-14,   1.436692418015318e-15,   6.234624245801910e-18,  -6.778834699299067e-19,   1.264104593314922e-01,  -1.419046531102347e-03,
   1.147819666891673e-05,  -8.061180887071392e-08,   4.562419315562369e-10,  -1.317376324272285e-12,   6.706505216371813e-14,   1.433935285893612e-15,   6.123211456003524e-18,
  -6.792371833483265e-19,   1.264109447752695e-01,  -1.419056756520230e-03,   1.147831248344675e-05,  -8.061236321618356e-08,   4.562844795582933e-10,  -1.316105878600447e-12,
   6.707217971118160e-14,   1.432899486053763e-15,   6.081389733705046e-18,  -6.797445611764957e-19,   1.264110252446827e-01,  -1.419058451531855e-03,   1.147833168171079e-05,
  -8.061245508963212e-08,   4.562915326414045e-10,  -1.315895313709619e-12,   6.707335961118959e-14,   1.432727762665386e-15,   6.074457970585997e-18,  -6.798286159293516e-19,
   2.107113483718924e-01,  -2.341586577054257e-03,   1.826430326131542e-05,  -1.182900341371845e-07,   5.413750480045559e-10,   1.232966252739594e-13,   9.430746572876281e-14,
   2.671262458948573e-15,   1.152541980270901e-17,  -1.149890913540133e-18,   2.107139484483175e-01,  -2.341637076808883e-03,   1.826476665471747e-05,  -1.182897921716196e-07,
   5.415768357103644e-10,   1.311839743081255e-13,   9.434832043148593e-14,   2.665290464990907e-15,   1.128079852359647e-17,  -1.152929848592168e-18,   2.107182169425468e-01,
  -2.341719980241370e-03,   1.826552751468686e-05,  -1.182893868731546e-07,   5.419081632341533e-10,   1.441193827520062e-13,   9.441468748372801e-14,   2.655475384302506e-15,
   1.087955338705522e-17,  -1.157896642011709e-18,   2.107227462100610e-01,  -2.341807947070559e-03,   1.826633501542610e-05,  -1.182889458558140e-07,   5.422598087690025e-10,
   1.578272356731302e-13,   9.448415376538674e-14,   2.645045803099800e-15,   1.045426506038737e-17,  -1.163136736334277e-18,   2.107263108146362e-01,  -2.341877177339431e-03,
   1.826697064549462e-05,  -1.182885908401156e-07,   5.425366141403871e-10,   1.686026238476773e-13,   9.453813358729720e-14,   2.636826826867075e-15,   1.011989771974080e-17,
  -1.167238949844776e-18,   2.107283680365794e-01,  -2.341917131445763e-03,   1.826733752924335e-05,  -1.182883827756766e-07,   5.426963872243499e-10,   1.748161912236674e-13,
   9.456900974912289e-14,   2.632079160979318e-15,   9.927063134080126e-18,  -1.169597689769033e-18,   2.107291405474559e-01,  -2.341932134603222e-03,   1.826747530704047e-05,
  -1.182883040449731e-07,   5.427563879902023e-10,   1.771484794565980e-13,   9.458055178211258e-14,   2.630295547444413e-15,   9.854677451220663e-18,  -1.170481770211916e-18,
   2.107292686023800e-01,  -2.341934621590965e-03,   1.826749814617316e-05,  -1.182882909625618e-07,   5.427663342068131e-10,   1.775350385335148e-13,   9.458246228207533e-14,
   2.629999844862810e-15,   9.842679840802121e-18,  -1.170628232157225e-18,   3.181871470780631e-01,  -3.486492136932221e-03,   2.577668208616266e-05,  -1.457169074597030e-07,
   3.898860160525670e-10,   4.466104192199460e-12,   1.181692904506368e-13,   4.380287509787186e-15,   1.885329527622314e-17,  -1.830430893098021e-18,   3.181908159616597e-01,
  -3.486554323830778e-03,   2.577701642203401e-05,  -1.457104427682309e-07,   3.901390468088737e-10,   4.479042290093220e-12,   1.182363779094944e-13,   4.370780146065283e-15,
   1.846556145266777e-17,  -1.835304121605102e-18,   3.181968390626640e-01,  -3.486656411671954e-03,   2.577756544489329e-05,  -1.456998166863378e-07,   3.905545369919682e-10,
   4.500261652430687e-12,   1.183453992380103e-13,   4.355154488992178e-15,   1.782956981602192e-17,  -1.843269284800255e-18,   3.182032300856820e-01,  -3.486764732018295e-03,
   2.577814821319900e-05,  -1.456885236032620e-07,   3.909955381325913e-10,   4.522748991664378e-12,   1.184595666786598e-13,   4.338550364686747e-15,   1.715546432777380e-17,
  -1.851673316812399e-18,   3.182082598886687e-01,  -3.486849978712190e-03,   2.577860700888587e-05,  -1.456796228722143e-07,   3.913427045881062e-10,   4.540426324628830e-12,
   1.185483225501147e-13,   4.325465442511697e-15,   1.662547050587962e-17,  -1.858252844711747e-18,   3.182111627000747e-01,  -3.486899175448784e-03,   2.577887185057456e-05,
  -1.456744808721073e-07,   3.915430994730499e-10,   4.550620108027820e-12,   1.185991067887977e-13,   4.317906926075299e-15,   1.631981398885367e-17,  -1.862036190590389e-18,
   3.182122527372218e-01,  -3.486917649161798e-03,   2.577897131293013e-05,  -1.456725490147620e-07,   3.916183569617984e-10,   4.554446433771564e-12,   1.186180939187606e-13,
   4.315067316189710e-15,   1.620507730328571e-17,  -1.863454260506784e-18,   3.182124334266185e-01,  -3.486920711436203e-03,   2.577898780085480e-05,  -1.456722287297913e-07,
   3.916308323477869e-10,   4.555080620707279e-12,   1.186212369369147e-13,   4.314596541055738e-15,   1.618606018690283e-17,  -1.863689187979544e-18,   4.504159284536440e-01,
  -4.839230605024212e-03,   3.300923302043987e-05,  -1.444351729327579e-07,  -1.999584207660264e-10,   1.278909305834227e-11,   1.509447911039876e-13,   6.492685177523427e-15,
   3.331985883525799e-17,  -2.798102824239169e-18,   4.504206255703903e-01,  -4.839292202681432e-03,   3.300906412140711e-05,  -1.444168114706172e-07,  -1.996347968768297e-10,
   1.280826350225838e-11,   1.510654271463076e-13,   6.478151628084386e-15,   3.273453935841207e-17,  -2.805553224355193e-18,   4.504283366308750e-01,  -4.839393319504256e-03,
   3.300878704646532e-05,  -1.443866485368440e-07,  -1.991033361974804e-10,   1.283970336853536e-11,   1.512617896198352e-13,   6.454265265170065e-15,   3.177444423759129e-17,
  -2.817731405306696e-18,   4.504365186391803e-01,  -4.839500604518027e-03,   3.300849332062318e-05,  -1.443546166825475e-07,  -1.985391725465159e-10,   1.287302062633511e-11,
   1.514678618783215e-13,   6.428883142741923e-15,   3.075680159594970e-17,  -2.830581538775381e-18,   4.504429579061905e-01,  -4.839585032773652e-03,   3.300826235388515e-05,
  -1.443293881632938e-07,  -1.980949981137595e-10,   1.289921041897879e-11,   1.516283895126277e-13,   6.408880686495821e-15,   2.995670494369497e-17,  -2.840642617952859e-18,
   4.504466741264799e-01,  -4.839633755719720e-03,   3.300812913746391e-05,  -1.443148205670914e-07,  -1.978385867117222e-10,   1.291431260007806e-11,   1.517203711500626e-13,
   6.397326246072587e-15,   2.949527238656923e-17,  -2.846428196582688e-18,   4.504480696029019e-01,  -4.839652051244864e-03,   3.300807912830660e-05,  -1.443093488304129e-07,
  -1.977422885593857e-10,   1.291998126313681e-11,   1.517547860842132e-13,   6.392985432590179e-15,   2.932206023842822e-17,  -2.848596794197116e-18,   4.504483009230274e-01,
  -4.839655083967579e-03,   3.300807083936080e-05,  -1.443084417347583e-07,  -1.977263250711127e-10,   1.292092080085909e-11,   1.517604842543075e-13,   6.392265774866455e-15,
   2.929335103245588e-17,  -2.848956062177093e-18,   6.095264079559850e-01,  -6.368151859937865e-03,   3.821643078864185e-05,  -8.551129613092340e-08,  -1.461380835694463e-09,
   2.455345186435811e-11,   2.476358839433973e-13,   8.587847287644508e-15,   6.215168933090244e-17,  -4.157143178495535e-18,   6.095318439316871e-01,  -6.368188242353787e-03,
   3.821518600888338e-05,  -8.547614131537050e-08,  -1.460849527531476e-09,   2.457877060348175e-11,   2.478655302574695e-13,   8.566254606122219e-15,   6.128300055204762e-17,
  -4.168218201217810e-18,   6.095407678382896e-01,  -6.368247959081824e-03,   3.821314283013061e-05,  -8.541840309647571e-08,  -1.459976954430317e-09,   2.462028858144153e-11,
   2.482400367133779e-13,   8.530766302228135e-15,   5.985807078251323e-17,  -4.186321809601240e-18,   6.095502366199850e-01,  -6.368311308333130e-03,   3.821097530636564e-05,
  -8.535710321011799e-08,  -1.459050620472022e-09,   2.466427867157177e-11,   2.486340277576539e-13,   8.493055689457370e-15,   5.834769604663427e-17,  -4.205425320253339e-18,
   6.095576884757603e-01,  -6.368361153798741e-03,   3.820926977735872e-05,  -8.530883443150535e-08,  -1.458321254705213e-09,   2.469885295064062e-11,   2.489416483249132e-13,
   8.463337701543365e-15,   5.716017506562507e-17,  -4.220383242420366e-18,   6.095619890372743e-01,  -6.368389916290186e-03,   3.820828561295644e-05,  -8.528096738235889e-08,
  -1.457900189288492e-09,   2.471878793049583e-11,   2.491181995843924e-13,   8.446171061969175e-15,   5.647529641508926e-17,  -4.228985021565658e-18,   6.095636039314052e-01,
  -6.368400716078582e-03,   3.820791607396227e-05,  -8.527050110250267e-08,  -1.457742049742713e-09,   2.472627021311645e-11,   2.491843106763092e-13,   8.439721835175446e-15,
   5.621820531275848e-17,  -4.232209265809503e-18,   6.095638716227224e-01,  -6.368402506255193e-03,   3.820785481887839e-05,  -8.526876606523016e-08,  -1.457715834516596e-09,
   2.472751032385554e-11,   2.491952597430115e-13,   8.438652626277718e-15,   5.617559340955932e-17,  -4.232743423949392e-18,   7.983222852688666e-01,  -8.003017201044918e-03,
   3.823841494217320e-05,   7.510694018766861e-08,  -3.512862633386007e-09,   3.296914416864209e-11,   5.648854795867051e-13,   1.003326952437761e-14,   1.052732906788447e-16,
  -5.863872269472374e-18,   7.983277208583796e-01,  -8.002984969554103e-03,   3.823542236556236e-05,   7.515410628995300e-08,  -3.511652201726127e-09,   3.299864019364572e-11,
   5.652778026024939e-13,   1.000279050767386e-14,   1.039633646762060e-16,  -5.880294688752654e-18,   7.983366439518346e-01,  -8.002932041731704e-03,   3.823051031504491e-05,
   7.523156721774084e-08,  -3.509664491337626e-09,   3.304699657589856e-11,   5.659181014820871e-13,   9.952694317892541e-15,   1.018146032542598e-16,  -5.907140817405963e-18,
   7.983461116272532e-01,  -8.002875861354645e-03,   3.822529926699609e-05,   7.531380017125097e-08,  -3.507554577048802e-09,   3.309821650647403e-11,   5.665923967490399e-13,
   9.899457141684627e-15,   9.953691063752535e-17,  -5.935471737145289e-18,   7.983535624361263e-01,  -8.002831632714511e-03,   3.822119888142297e-05,   7.537854753734521e-08,
  -3.505893486732431e-09,   3.313846169504185e-11,   5.671193720421808e-13,   9.857500561271389e-15,   9.774603200062003e-17,  -5.957656125679352e-18,   7.983578623228063e-01,
  -8.002806101732610e-03,   3.821883276405336e-05,   7.541592636371010e-08,  -3.504934608687123e-09,   3.316166184041461e-11,   5.674220178956123e-13,   9.833263151228203e-15,
   9.671315509130568e-17,  -5.970414182769546e-18,   7.983594769501779e-01,  -8.002796513504506e-03,   3.821794431927813e-05,   7.542996472432347e-08,  -3.504574497006831e-09,
   3.317036878282202e-11,   5.675353844131768e-13,   9.824157338145582e-15,   9.632542717807880e-17,  -5.975196455297710e-18,   7.983597445965717e-01,  -8.002794924060920e-03,
   3.821779704978482e-05,   7.543229190165902e-08,  -3.504514801052034e-09,   3.317181182234356e-11,   5.675541617664299e-13,   9.822647686045563e-15,   9.626116246519592e-17,
  -5.975988736715539e-18,   1.020361937749547e+00,  -9.581447916210658e-03,   2.708600008417675e-05,   3.944892771852937e-07,  -5.676532405359331e-09,   1.169478145217419e-11,
   1.411415358073682e-12,   1.334914635565610e-14,   9.504874611928492e-17,  -7.469249675452138e-18,   1.020365782574122e+00,  -9.581279440012450e-03,   2.708117030493383e-05,
   3.945062506940329e-07,  -5.673515639844735e-09,   1.173405041890962e-11,   1.411752407097099e-12,   1.331016628428434e-14,   9.303758098404569e-17,  -7.496028598746756e-18,
   1.020372093982073e+00,  -9.581002853743394e-03,   2.707324330341358e-05,   3.945341555866509e-07,  -5.668562633014326e-09,   1.179843212583047e-11,   1.412299950602538e-12,
   1.324607632074654e-14,   8.973856331160140e-17,  -7.539819343654430e-18,   1.020378790202668e+00,  -9.580709367092257e-03,   2.706483467392256e-05,   3.945638193280528e-07,
  -5.663306437994912e-09,   1.186663092121104e-11,   1.412873089313997e-12,   1.317793925351990e-14,   8.624164258921939e-17,  -7.586051945866790e-18,   1.020384059677703e+00,
  -9.580478386305980e-03,   2.705821887152971e-05,   3.945872042656215e-07,  -5.659169302203187e-09,   1.192022025376758e-11,   1.413318474150411e-12,   1.312421924590371e-14,
   8.349215639436179e-17,  -7.622268643239857e-18,   1.020387100600098e+00,  -9.580345080671435e-03,   2.705440149747996e-05,   3.946007159583233e-07,  -5.656781488013027e-09,
   1.195111421376691e-11,   1.413573239375540e-12,   1.309317807673473e-14,   8.190642253665733e-17,  -7.643102397718082e-18,   1.020388242459901e+00,  -9.580295022681803e-03,
   2.705296817446944e-05,   3.946057927159005e-07,  -5.655884803857917e-09,   1.196270886913531e-11,   1.413668476367947e-12,   1.308151458023651e-14,   8.131116217764246e-17,
  -7.650912897764338e-18,   1.020388431737567e+00,  -9.580286724832486e-03,   2.705273058799215e-05,   3.946066344184464e-07,  -5.655736163719145e-09,   1.196463051500263e-11,
   1.413684240587556e-12,   1.307958080765340e-14,   8.121249973076140e-17,  -7.652206925568510e-18,   1.279516777065218e+00,  -1.069672570601659e-02,  -6.813186531903203e-06,
   8.757309043267960e-07,  -3.613347293852816e-09,  -1.069827993436451e-10,   2.487376591479829e-12,   4.635914958494069e-14,  -1.500064008324776e-16,  -1.402960847882431e-17,
   1.279515801355352e+00,  -1.069635237073438e-02,  -6.816241732412058e-06,   8.755798186889209e-07,  -3.608045550632423e-09,  -1.068454290510145e-10,   2.486723594341182e-12,
   4.628597803570008e-14,  -1.526736325949786e-16,  -1.407819621158567e-17,   1.279514199260218e+00,  -1.069573952677875e-02,  -6.821254069244546e-06,   8.753319279609879e-07,
  -3.599342917721880e-09,  -1.066200723665390e-10,   2.485643932074206e-12,   4.616567742163750e-14,  -1.570488624775504e-16,  -1.415766373822843e-17,   1.279512498893028e+00,
  -1.069508931491788e-02,  -6.826568103190528e-06,   8.750690880059120e-07,  -3.590110166902102e-09,  -1.063811676510921e-10,   2.484487919456403e-12,   4.603778830247140e-14,
  -1.616865966343991e-16,  -1.424158100023658e-17,   1.279511160390853e+00,  -1.069457764031890e-02,  -6.830747059384970e-06,   8.748623699912832e-07,  -3.582844973293412e-09,
  -1.061933050430003e-10,   2.483570600468785e-12,   4.593696497201979e-14,  -1.653330851074991e-16,  -1.430733176296772e-17,   1.279510387793159e+00,  -1.069428236115576e-02,
  -6.833157527504171e-06,   8.747431244415590e-07,  -3.578652502464702e-09,  -1.060849487086930e-10,   2.483038180384993e-12,   4.587870829641196e-14,  -1.674361645904275e-16,
  -1.434516050397682e-17,   1.279510097652004e+00,  -1.069417148434312e-02,  -6.834062438587846e-06,   8.746983570313847e-07,  -3.577078266517287e-09,  -1.060442717134661e-10,
   2.482837681207779e-12,   4.585681920646120e-14,  -1.682256304386363e-16,  -1.435934339534051e-17,   1.279510049555739e+00,  -1.069415310510632e-02,  -6.834212427698536e-06,
   8.746909367451311e-07,  -3.576817318523848e-09,  -1.060375295464507e-10,   2.482804415525921e-12,   4.585319008432929e-14,  -1.683564819000677e-16,  -1.436169324255274e-17,
   1.576172891771274e+00,  -1.021130041559118e-02,  -8.074896082784724e-05,   9.325133035967493e-07,   1.807043935222467e-08,  -1.936801473375588e-10,  -3.840612269818116e-12,
   1.246661421649288e-13,   2.645897323288569e-15,  -4.671561355777267e-17,   1.576161431536148e+00,  -1.021090326725097e-02,  -8.073357718795294e-05,   9.322407920859456e-07,
   1.806236312770022e-08,  -1.933114306906622e-10,  -3.830313619979192e-12,   1.244258196307058e-13,   2.634106829808356e-15,  -4.675310682257279e-17,   1.576142619279902e+00,
  -1.021025136731826e-02,  -8.070832739818823e-05,   9.317937979750300e-07,   1.804912045731477e-08,  -1.927066423613708e-10,  -3.813440540856164e-12,   1.240311557732914e-13,
   2.614774328301966e-15,  -4.681421849404670e-17,   1.576122660161521e+00,  -1.020955976430915e-02,  -8.068154213479655e-05,   9.313200156229466e-07,   1.803509035010021e-08,
  -1.920656217021781e-10,  -3.795582828745287e-12,   1.236122036244879e-13,   2.594292989540834e-15,  -4.687846474631884e-17,   1.576106953779273e+00,  -1.020901555101888e-02,
  -8.066046684947800e-05,   9.309475175794099e-07,   1.802406404622999e-08,  -1.915616467256491e-10,  -3.781561940149538e-12,   1.232823540764170e-13,   2.578197192413234e-15,
  -4.692859354749372e-17,   1.576097889939712e+00,  -1.020870150770529e-02,  -8.064830583605724e-05,   9.307326903768737e-07,   1.801770674211664e-08,  -1.912709980476083e-10,
  -3.773483519677841e-12,   1.230919387698123e-13,   2.568917262121086e-15,  -4.695735002433074e-17,   1.576094486495149e+00,  -1.020858358751921e-02,  -8.064373962221386e-05,
   9.306520487233774e-07,   1.801532068058016e-08,  -1.911618953565025e-10,  -3.770452506765232e-12,   1.230204259988132e-13,   2.565434307914432e-15,  -4.696811549515721e-17,
   1.576093922331685e+00,  -1.020856404088757e-02,  -8.064298272629942e-05,   9.306386826970604e-07,   1.801492521839527e-08,  -1.911438120695946e-10,  -3.769950205602728e-12,
   1.230085712102301e-13,   2.564857050819963e-15,  -4.696989829150625e-17,   1.879335279719313e+00,  -5.126952870514869e-03,  -1.334038993048848e-04,  -2.141128902103043e-06,
  -5.415852581646022e-09,   8.543501493895775e-10,   2.703390887167962e-11,   3.142238404460560e-13,  -5.955119221554079e-15,  -3.509438399739377e-16,   1.879316286724783e+00,
  -5.127862641746086e-03,  -1.334081984542095e-04,  -2.139905439294705e-06,  -5.358439332958299e-09,   8.552604894502317e-10,   2.700929807511954e-11,   3.124274408027883e-13,
  -5.997788100737858e-15,  -3.508943992569845e-16,   1.879285106259391e+00,  -5.129355799197688e-03,  -1.334152208655767e-04,  -2.137896002629833e-06,  -5.264224629320402e-09,
   8.567510809268334e-10,   2.696877358569572e-11,   3.094785965006646e-13,  -6.067661146005241e-15,  -3.508061503807825e-16,   1.879252020846135e+00,  -5.130939639058979e-03,
  -1.334226241725388e-04,  -2.135762580784550e-06,  -5.164307887069544e-09,   8.583274420283453e-10,   2.692560859667417e-11,   3.063499804714752e-13,  -6.141564026948155e-15,
  -3.507028971694846e-16,   1.879225982070121e+00,  -5.132185755925956e-03,  -1.334284158607075e-04,  -2.134082660194915e-06,  -5.085710861936467e-09,   8.595642299247971e-10,
   2.689151800603637e-11,   3.038879975182902e-13,  -6.199553623935568e-15,  -3.506146858172201e-16,   1.879210954430722e+00,  -5.132904764609544e-03,  -1.334317444297573e-04,
  -2.133112782413535e-06,  -5.040366230974088e-09,   8.602764746181490e-10,   2.687179582274180e-11,   3.024672446522616e-13,  -6.232951408742904e-15,  -3.505609946727916e-16,
   1.879205311373914e+00,  -5.133174731215225e-03,  -1.334329917085072e-04,  -2.132748515164295e-06,  -5.023341756545568e-09,   8.605436404477518e-10,   2.686438091368146e-11,
   3.019337582305485e-13,  -6.245479533206340e-15,  -3.505403075785362e-16,   1.879204375954957e+00,  -5.133219480551040e-03,  -1.334331983239720e-04,  -2.132688129041762e-06,
  -5.020519858519103e-09,   8.605879117552401e-10,   2.686315131004048e-11,   3.018453263072642e-13,  -6.247555559191467e-15,  -3.505368506823142e-16,   2.436042013456916e-03,
  -2.711134308083310e-05,   2.240144555693844e-07,  -1.693877655871492e-09,   1.198086601362166e-11,  -2.124732690981219e-14,   2.371652138706544e-15,   1.820672848019464e-17,
  -6.434339953136265e-19,  -3.194612745409339e-20,   2.436073912989288e-03,  -2.711206633973778e-05,   2.240247138518588e-07,  -1.693907457239823e-09,   1.198589736063423e-11,
  -2.119550847226274e-14,   2.369031900028807e-15,   1.804438904018338e-17,  -6.461677303331250e-19,  -3.189725450288755e-20,   2.436126282295648e-03,  -2.711325369541448e-05,
   2.240415575783717e-07,  -1.693956328789508e-09,   1.199415305876752e-11,  -2.111078990275816e-14,   2.364722574387670e-15,   1.777806661961192e-17,  -6.506393094287810e-19,
  -3.181661317863232e-20,   2.436181851620050e-03,  -2.711451358396350e-05,   2.240594342799252e-07,  -1.694008114507373e-09,   1.200290745149203e-11,  -2.102137211631597e-14,
   2.360139499151555e-15,   1.749572890298898e-17,  -6.553618638592593e-19,  -3.173049265682152e-20,   2.436225586015209e-03,  -2.711550513185015e-05,   2.240735063821080e-07,
  -1.694048819052187e-09,   1.200979318756863e-11,  -2.095134370690212e-14,   2.356524978264995e-15,   1.727370998183137e-17,  -6.590625131738109e-19,  -3.166231537343033e-20,
   2.436250826408735e-03,  -2.711607737712153e-05,   2.240816288873283e-07,  -1.694072290013548e-09,   1.201376546860883e-11,  -2.091106672082959e-14,   2.354435921127743e-15,
   1.714565182673526e-17,  -6.611918068739427e-19,  -3.162280893371941e-20,   2.436260304506671e-03,  -2.711629226159089e-05,   2.240846791993353e-07,  -1.694081099737998e-09,
   1.201525679477397e-11,  -2.089596834678994e-14,   2.353650884379879e-15,   1.709757859694270e-17,  -6.619901638143634e-19,  -3.160794367177239e-20,   2.436261875641248e-03,
  -2.711632788180334e-05,   2.240851848443722e-07,  -1.694082559872709e-09,   1.201550398734446e-11,  -2.089346694846072e-14,   2.353520722986564e-15,   1.708961050388835e-17,
  -6.621224388616053e-19,  -3.160547794956577e-20,   2.197038029802874e-02,  -2.440891427902850e-04,   2.004070138562798e-06,  -1.496934249695057e-08,   1.037531112491593e-10,
  -1.377274587820659e-13,   2.100964128643969e-14,   1.707671842801614e-16,  -5.889742866457354e-18,  -2.901574974942449e-19,   2.197066567059422e-02,  -2.440955342097130e-04,
   2.004158979877500e-06,  -1.496953440473385e-08,   1.037976730307415e-10,  -1.372406670910383e-13,   2.098565912674533e-14,   1.692926997684366e-16,  -5.914645982993868e-18,
  -2.897136817566874e-19,   2.197113416503827e-02,  -2.441060268176918e-04,   2.004304854688086e-06,  -1.496984896151890e-08,   1.038707911362605e-10,  -1.364446967221837e-13,
   2.094621765824148e-14,   1.668737661793190e-16,  -5.955380372869607e-18,  -2.889813679566835e-19,   2.197163128634997e-02,  -2.441171603653115e-04,   2.004459676382905e-06,
  -1.497018206519550e-08,   1.039483243838106e-10,  -1.356044264221806e-13,   2.090427112452584e-14,   1.643093697253529e-16,  -5.998401437821995e-18,  -2.881992844976983e-19,
   2.197202253248483e-02,  -2.441259225833748e-04,   2.004581548827914e-06,  -1.497044373918828e-08,   1.040093066924034e-10,  -1.349462524524161e-13,   2.087118959600831e-14,
   1.622928322177245e-16,  -6.032113530908116e-18,  -2.875801394643601e-19,   2.197224833190813e-02,  -2.441309794538219e-04,   2.004651894601767e-06,  -1.497059456428019e-08,
   1.040444860227354e-10,  -1.345676587875521e-13,   2.085206984613852e-14,   1.611297147235094e-16,  -6.051511035817245e-18,  -2.872213622158139e-19,   2.197233312252275e-02,
  -2.441328783633166e-04,   2.004678312180794e-06,  -1.497065116435072e-08,   1.040576934209074e-10,  -1.344257295681522e-13,   2.084488495155711e-14,   1.606930785993564e-16,
  -6.058783953586308e-18,  -2.870863628526179e-19,   2.197234717781697e-02,  -2.441331931349757e-04,   2.004682691380338e-06,  -1.497066054471150e-08,   1.040598825889628e-10,
  -1.344022152416452e-13,   2.084369367626503e-14,   1.606207065677535e-16,  -6.059988961509584e-18,  -2.870639702804357e-19,   6.128775155850383e-02,  -6.784568647957552e-04,
   5.496795327905320e-06,  -3.999422294311200e-08,   2.649434384481848e-10,  -8.110514209021293e-14,   5.655662907125623e-14,   5.120791662387543e-16,  -1.690046850623115e-17,
  -8.215171913182791e-19,   6.128853424916145e-02,  -6.784739395729105e-04,   5.497022227249507e-06,  -3.999432606462266e-08,   2.650633454052377e-10,  -7.964146087855360e-14,
   5.648782482915874e-14,   5.079044519663992e-16,  -1.697134635000346e-17,  -8.202619852159713e-19,   6.128981918603400e-02,  -6.785019706128440e-04,   5.497394792994302e-06,
  -3.999449387749595e-08,   2.652600851576360e-10,  -7.724758628629067e-14,   5.637466980984455e-14,   5.010557102588572e-16,  -1.708728374373547e-17,  -8.181907889862309e-19,
   6.129118263529630e-02,  -6.785317137531081e-04,   5.497790214241861e-06,  -3.999466993656795e-08,   2.654686957537003e-10,  -7.471971964242740e-14,   5.625433009678072e-14,
   4.937951122767078e-16,  -1.720973143242566e-17,  -8.159787543493222e-19,   6.129225570015349e-02,  -6.785551217899039e-04,   5.498101485359106e-06,  -3.999480704947479e-08,
   2.656327679197570e-10,  -7.273911798497279e-14,   5.615942461569453e-14,   4.880856675550110e-16,  -1.730568513693209e-17,  -8.142275184246651e-19,   6.129287499613587e-02,
  -6.785686310372812e-04,   5.498281155066859e-06,  -3.999488560149121e-08,   2.657274148541647e-10,  -7.159961715382533e-14,   5.610457381273189e-14,   4.847925184626192e-16,
  -1.736089625031871e-17,  -8.132127045352667e-19,   6.129310754968778e-02,  -6.785737038961937e-04,   5.498348628320127e-06,  -3.999491498936333e-08,   2.657629477148990e-10,
  -7.117239277143844e-14,   5.608396188052391e-14,   4.835562648121492e-16,  -1.738159726524288e-17,  -8.128308500890820e-19,   6.129314609886018e-02,  -6.785745447952855e-04,
   5.498359813267321e-06,  -3.999491985506726e-08,   2.657688373727861e-10,  -7.110160953027673e-14,   5.608054437164123e-14,   4.833513569013021e-16,  -1.738502710322353e-17,
  -8.127675110336692e-19,   1.209021370410348e-01,  -1.330762424744830e-03,   1.055159344840187e-05,  -7.342872278878630e-08,   4.477703057354581e-10,   7.463928205885365e-13,
   1.059141071231587e-13,   1.110533687028270e-15,  -3.465955929353126e-17,  -1.660272962638556e-18,   1.209036393817245e-01,  -1.330793769232609e-03,   1.055197704501861e-05,
  -7.342763385657196e-08,   4.479947109731026e-10,   7.495769092910991e-13,   1.057730281833738e-13,   1.102096430231669e-15,  -3.480369487462205e-17,  -1.657744766704526e-18,
   1.209061057568420e-01,  -1.330845225941485e-03,   1.055260691891991e-05,  -7.342584297901237e-08,   4.483628892604355e-10,   7.547859268386935e-13,   1.055410140347631e-13,
   1.088254830922373e-15,  -3.503946640100443e-17,  -1.653572841676803e-18,   1.209087228254854e-01,  -1.330899825023336e-03,   1.055327545125662e-05,  -7.342393835471238e-08,
   4.487532565858622e-10,   7.602884011288920e-13,   1.052942728876564e-13,   1.073580810495469e-15,  -3.528848259041934e-17,  -1.649116977620066e-18,   1.209107825113825e-01,
  -1.330942794451892e-03,   1.055380172537654e-05,  -7.342243625318290e-08,   4.490602614797289e-10,   7.646010057411022e-13,   1.050996846568386e-13,   1.062041715731872e-15,
  -3.548362300722741e-17,  -1.645589151589182e-18,   1.209119712120743e-01,  -1.330967592814632e-03,   1.055410550282132e-05,  -7.342156810010548e-08,   4.492373532377585e-10,
   7.670827333392957e-13,   1.049872233293452e-13,   1.055386072275011e-15,  -3.559590701770159e-17,  -1.643544758661251e-18,   1.209124175839692e-01,  -1.330976904820954e-03,
   1.055421958454474e-05,  -7.342124186198133e-08,   4.493038365429746e-10,   7.680132936067141e-13,   1.049449626585573e-13,   1.052887530366657e-15,  -3.563800740036398e-17,
  -1.642775480232532e-18,   1.209124915766565e-01,  -1.330978448417947e-03,   1.055423849576518e-05,  -7.342118777079410e-08,   4.493148562364352e-10,   7.681674759161546e-13,
   1.049379557487465e-13,   1.052473399212644e-15,  -3.564498279791041e-17,  -1.642647877568856e-18,   2.016284501700033e-01,  -2.201001704946129e-03,   1.689734458504905e-05,
  -1.094597491676883e-07,   5.725450953386411e-10,   3.276277300714717e-12,   1.657584498069041e-13,   2.053968437792760e-15,  -6.046946339734387e-17,  -2.870279537907290e-18,
   2.016308557733970e-01,  -2.201048419068625e-03,   1.689783543593967e-05,  -1.094550371381757e-07,   5.728959940614758e-10,   3.282182622719906e-12,   1.655123330210462e-13,
   2.039381223309505e-15,  -6.071999075276432e-17,  -2.865942019015113e-18,   2.016348050116203e-01,  -2.201125106397796e-03,   1.689864146276033e-05,  -1.094472956017037e-07,
   5.734716686619036e-10,   3.291845733548847e-12,   1.651075793963545e-13,   2.015450292204074e-15,  -6.112980116173268e-17,  -2.858783933093300e-18,   2.016389955278486e-01,
  -2.201206475591846e-03,   1.689949701246520e-05,  -1.094390731270099e-07,   5.740819835360422e-10,   3.302056343181039e-12,   1.646771376922467e-13,   1.990080010675678e-15,
  -6.156264286928588e-17,  -2.851138008574328e-18,   2.016422935362893e-01,  -2.201270512134206e-03,   1.690017054658252e-05,  -1.094325961410160e-07,   5.745619273175892e-10,
   3.310061247610910e-12,   1.643376796259542e-13,   1.970129660609761e-15,  -6.190184447310171e-17,  -2.845084050100936e-18,   2.016441969015568e-01,  -2.201307468297156e-03,
   1.690055934124025e-05,  -1.094288558032615e-07,   5.748387608915028e-10,   3.314668653710277e-12,   1.641414924724111e-13,   1.958622434601934e-15,  -6.209702431868039e-17,
  -2.841575560790392e-18,   2.016449116379423e-01,  -2.201321345594585e-03,   1.690070535355242e-05,  -1.094274508270314e-07,   5.749426860229265e-10,   3.316396441024689e-12,
   1.640677695328115e-13,   1.954302589794403e-15,  -6.217020666350476e-17,  -2.840255326218980e-18,   2.016450301159293e-01,  -2.201323645949506e-03,   1.690072955802987e-05,
  -1.094272179087955e-07,   5.749599115902981e-10,   3.316682723099360e-12,   1.640555461212406e-13,   1.953586578786140e-15,  -6.218233190141170e-17,  -2.840036332823035e-18,
   3.046426911407263e-01,  -3.287159044430676e-03,   2.406906986794279e-05,  -1.385680900434580e-07,   5.175318642290536e-10,   8.763194313466314e-12,   2.357324879375695e-13,
   3.415416123567857e-15,  -9.562616891644597e-17,  -4.564532345781685e-18,   3.046461172405501e-01,  -3.287218157836170e-03,   2.406951458188000e-05,  -1.385555366628940e-07,
   5.180304252762251e-10,   8.773030757359808e-12,   2.353432102928864e-13,   3.392215903936117e-15,  -9.602571045661293e-17,  -4.557729534867953e-18,   3.046517417842614e-01,
  -3.287315198168407e-03,   2.407024495800674e-05,  -1.385349182929747e-07,   5.188482889820123e-10,   8.789128880962405e-12,   2.347030107350590e-13,   3.354154627584336e-15,
  -9.667928871158787e-17,  -4.546501949186674e-18,   3.046577099229079e-01,  -3.287418160173108e-03,   2.407102035951092e-05,  -1.385130270949719e-07,   5.197152824659692e-10,
   8.806142322980545e-12,   2.340221675189332e-13,   3.313803637655154e-15,  -9.736961398994886e-17,  -4.534507696752781e-18,   3.046624069250600e-01,  -3.287499187982102e-03,
   2.407163090559230e-05,  -1.384957888447048e-07,   5.203970141839666e-10,   8.819482845718987e-12,   2.334852267720369e-13,   3.282072607417056e-15,  -9.791060727729931e-17,
  -4.525009713932504e-18,   3.046651176751636e-01,  -3.287545949179559e-03,   2.407198338428642e-05,  -1.384858364074060e-07,   5.207902154522244e-10,   8.827162230255626e-12,
   2.331749023517057e-13,   3.263770226401468e-15,  -9.822190463682027e-17,  -4.519504862381569e-18,   3.046661355922452e-01,  -3.287563508183905e-03,   2.407211576633160e-05,
  -1.384820984308275e-07,   5.209378211530186e-10,   8.830042194467469e-12,   2.330582883713284e-13,   3.256899435152186e-15,  -9.833862592192493e-17,  -4.517433322428443e-18,
   3.046663043267543e-01,  -3.287566418824896e-03,   2.407213771175262e-05,  -1.384814787688246e-07,   5.209622865209994e-10,   8.830519393480199e-12,   2.330389535023480e-13,
   3.255760605316138e-15,  -9.835796496813925e-17,  -4.517089702336766e-18,   4.315761275237920e-01,  -4.582122988904469e-03,   3.126606430035245e-05,  -1.453288996648353e-07,
   1.069046353567012e-10,   1.859346608196893e-11,   3.270455855482915e-13,   5.170384264760100e-15,  -1.408986254405353e-16,  -6.938213146892891e-18,   4.315805771059404e-01,
  -4.582184939067645e-03,   3.126615949345610e-05,  -1.453023146076455e-07,   1.075959142835209e-10,   1.860835446336371e-11,   3.264716211147583e-13,   5.135113658149126e-15,
  -1.415062203459447e-16,  -6.928083148694817e-18,   4.315878818258040e-01,  -4.582286632057210e-03,   3.126631619278182e-05,  -1.452586558528160e-07,   1.087298683688653e-10,
   1.863272014745296e-11,   3.255276359463984e-13,   5.077249444107668e-15,  -1.425001591760593e-16,  -6.911362101832497e-18,   4.315956327126664e-01,  -4.582394524992321e-03,
   3.126648303942418e-05,  -1.452123100860183e-07,   1.099318673364887e-10,   1.865847077192536e-11,   3.245236495395014e-13,   5.015903134775889e-15,  -1.435500123030775e-16,
  -6.893496351575068e-18,   4.316017327118958e-01,  -4.582479429198040e-03,   3.126661476580546e-05,  -1.451758209485783e-07,   1.108769667620622e-10,   1.867866192915998e-11,
   3.237318133602557e-13,   4.967661128690192e-15,  -1.443727821907145e-16,  -6.879346760278193e-18,   4.316052531449647e-01,  -4.582528425827429e-03,   3.126669095483043e-05,
  -1.451547564421642e-07,   1.114220489679729e-10,   1.869028470139823e-11,   3.232741517789942e-13,   4.939834947903109e-15,  -1.448462278459570e-16,  -6.871145088054254e-18,
   4.316065751033896e-01,  -4.582546823935004e-03,   3.126671959615149e-05,  -1.451468453944897e-07,   1.116266659623029e-10,   1.869464351049948e-11,   3.231021674329217e-13,
   4.929388823501876e-15,  -1.450237484997486e-16,  -6.868058545612455e-18,   4.316067942369630e-01,  -4.582549873652289e-03,   3.126672434552643e-05,  -1.451455339662561e-07,
   1.116605806331747e-10,   1.869536574707782e-11,   3.230736518242149e-13,   4.927657381097296e-15,  -1.450531612201762e-16,  -6.867546552032702e-18,   5.846582557338663e-01,
  -6.066882617250908e-03,   3.706748243132098e-05,  -1.045582845109234e-07,  -8.909737272102333e-10,   3.342823420719980e-11,   4.853083987184821e-13,   7.028759066691423e-15,
  -1.966579878963910e-16,  -1.031223543612175e-17,   5.846635291908732e-01,  -6.066927086791567e-03,   3.706672748917828e-05,  -1.045105441624757e-07,  -8.899473404510519e-10,
   3.344840227376193e-11,   4.845060658799472e-13,   6.976327529401730e-15,  -1.975654330415808e-16,  -1.029751477154689e-17,   5.846721863475558e-01,  -6.067000075971102e-03,
   3.706548875980711e-05,  -1.044321502556354e-07,  -8.882636082255496e-10,   3.348139842998510e-11,   4.831863230444331e-13,   6.890308207042172e-15,  -1.990499505572367e-16,
  -1.027321247853631e-17,   5.846813721560548e-01,  -6.067077503057118e-03,   3.706417522845583e-05,  -1.043489406015297e-07,  -8.864787361675899e-10,   3.351625640669012e-11,
   4.817824707370699e-13,   6.799110804601403e-15,  -2.006180702633467e-16,  -1.024724150614717e-17,   5.846886013604696e-01,  -6.067138424043483e-03,   3.706314209199330e-05,
  -1.042834341897468e-07,  -8.850752635543838e-10,   3.354357873502753e-11,   4.806751016663057e-13,   6.727393027953439e-15,  -2.018470711260151e-16,  -1.022666904050273e-17,
   5.846927734455893e-01,  -6.067173576907897e-03,   3.706254609699975e-05,  -1.042456211673260e-07,  -8.842657861007284e-10,   3.355930247487001e-11,   4.800350053264475e-13,
   6.686025437582419e-15,  -2.025543001551297e-16,  -1.021474298737350e-17,   5.846943400993485e-01,  -6.067186776056367e-03,   3.706232234186399e-05,  -1.042314204929258e-07,
  -8.839619127119258e-10,   3.356519848471751e-11,   4.797944517611447e-13,   6.670495689335418e-15,  -2.028194839502064e-16,  -1.021025457731083e-17,   5.846945997943337e-01,
  -6.067188963946035e-03,   3.706228525372189e-05,  -1.042290664483477e-07,  -8.839115462793886e-10,   3.356617538908590e-11,   4.797545664932373e-13,   6.667921632694510e-15,
  -2.028634215050772e-16,  -1.020951002876110e-17,   7.669264629896654e-01,  -7.694404856669639e-03,   3.882687995142305e-05,   2.501208690386113e-08,  -2.694232753734867e-09,
   5.002226023030910e-11,   8.489960678878467e-13,   8.287380608309946e-15,  -2.702194660231138e-16,  -1.513898790018885e-17,   7.669319837344504e-01,  -7.694393926230577e-03,
   3.882458968350846e-05,   2.508346986078672e-08,  -2.692433645795816e-09,   5.004579772560616e-11,   8.478909735751719e-13,   8.210401803800983e-15,  -2.715941751052210e-16,
  -1.511760845129106e-17,   7.669410466968363e-01,  -7.694375960072767e-03,   3.882083094405227e-05,   2.520068023961487e-08,  -2.689481838885455e-09,   5.008427244122145e-11,
   8.460728671453953e-13,   8.084109331242693e-15,  -2.738433256370794e-16,  -1.508230758415947e-17,   7.669506628829220e-01,  -7.694356866587520e-03,   3.881684413350855e-05,
   2.532508163108559e-08,  -2.686352084440789e-09,   5.012487172304682e-11,   8.441384066235575e-13,   7.950213336334999e-15,  -2.762194411396805e-16,  -1.504457524889269e-17,
   7.669582306421074e-01,  -7.694341818188021e-03,   3.881370758006540e-05,   2.542300936281139e-08,  -2.683890648648201e-09,   5.015666047666426e-11,   8.426121416119655e-13,
   7.844916507204631e-15,  -2.780819210544076e-16,  -1.501468075887560e-17,   7.669625980518202e-01,  -7.694333124752427e-03,   3.881189784947313e-05,   2.547953464044975e-08,
  -2.682470787170926e-09,   5.017494103670880e-11,   8.417297703344381e-13,   7.784179830904055e-15,  -2.791537738923362e-16,  -1.499734846389620e-17,   7.669642380401913e-01,
  -7.694329858634516e-03,   3.881121835997993e-05,   2.550076219330111e-08,  -2.681937743931569e-09,   5.018179321970267e-11,   8.413981415961140e-13,   7.761378700469536e-15,
  -2.795556943227832e-16,  -1.499082498695171e-17,   7.669645098908201e-01,  -7.694329317141864e-03,   3.881110572921373e-05,   2.550428105623102e-08,  -2.681849391185412e-09,
   5.018292841571829e-11,   8.413431541199451e-13,   7.757599408600321e-15,  -2.796222882655798e-16,  -1.498974283491342e-17,   9.824973627646929e-01,  -9.347338071267081e-03,
   3.128895801621688e-05,   3.075055820538536e-07,  -5.073239375532765e-09,   5.005533039093581e-11,   1.768445033030953e-12,   9.404363167460657e-15,  -4.283460862200931e-16,
  -2.188513073978908e-17,   9.825018067453913e-01,  -9.347206537876972e-03,   3.128464752015439e-05,   3.075770351315586e-07,  -5.069485305459655e-09,   5.008165829653129e-11,
   1.766693447999171e-12,   9.293081566931320e-15,  -4.305157876255307e-16,  -2.185423988435117e-17,   9.825091018191904e-01,  -9.346990582423683e-03,   3.127757345316946e-05,
   3.076943632672693e-07,  -5.063325117858863e-09,   5.012463999843447e-11,   1.763811755751875e-12,   9.110511534866243e-15,  -4.340660509382418e-16,  -2.180321663500338e-17,
   9.825168418588354e-01,  -9.346761406947842e-03,   3.127007045977300e-05,   3.078188931572964e-07,  -5.056792392728121e-09,   5.016992111547196e-11,   1.760745674188179e-12,
   8.916949888137154e-15,  -4.378173158176684e-16,  -2.174865528831257e-17,   9.825229328782261e-01,  -9.346581022884074e-03,   3.126416783610602e-05,   3.079169245552102e-07,
  -5.051653793952159e-09,   5.020532182114580e-11,   1.758326596564749e-12,   8.764731662490297e-15,  -4.407581117542491e-16,  -2.170541051777355e-17,   9.825264479512967e-01,
  -9.346476910989941e-03,   3.126076222687905e-05,   3.079735106668822e-07,  -5.048689287832968e-09,   5.022565778810467e-11,   1.756928077055791e-12,   8.676930131445073e-15,
  -4.424507046962323e-16,  -2.168033118710738e-17,   9.825277678634319e-01,  -9.346437814289423e-03,   3.125948355877934e-05,   3.079947612524282e-07,  -5.047576290543486e-09,
   5.023327629395436e-11,   1.756402461761159e-12,   8.643968607505404e-15,  -4.430854210724501e-16,  -2.167089062873142e-17,   9.825279866560332e-01,  -9.346431333364696e-03,
   3.125927161031390e-05,   3.079982839432916e-07,  -5.047391806089860e-09,   5.023453822868359e-11,   1.756315309391108e-12,   8.638505229087344e-15,  -4.431905885465624e-16,
  -2.166932450724430e-17,   1.236685846027601e+00,  -1.071031835919731e-02,   3.289767877967249e-06,   8.044680026614030e-07,  -5.056136879047991e-09,  -3.284644826117784e-11,
   3.616392191930245e-12,   2.977639360328712e-14,  -1.009516485911537e-15,  -3.446104563140741e-17,   1.236686305592208e+00,  -1.070997507651113e-02,   3.285494163005725e-06,
   8.044219848502728e-07,  -5.048465952662851e-09,  -3.276026402610531e-11,   3.612303650028078e-12,   2.960096260786023e-14,  -1.012715691507154e-15,  -3.442001548445581e-17,
   1.236687059609288e+00,  -1.070941153643857e-02,   3.278482886567202e-06,   8.043465266447241e-07,  -5.035879228145973e-09,  -3.261915684687524e-11,   3.605582541037867e-12,
   2.931312015720601e-14,  -1.017948865187400e-15,  -3.435212779458947e-17,   1.236687859092011e+00,  -1.070881359589598e-02,   3.271049790814057e-06,   8.042665783346637e-07,
  -5.022532368391227e-09,  -3.246994502966960e-11,   3.598438579197932e-12,   2.900791005109577e-14,  -1.023476057278584e-15,  -3.427937456851551e-17,   1.236688487863829e+00,
  -1.070834302731272e-02,   3.265204545031823e-06,   8.042037443533727e-07,  -5.012034572358880e-09,  -3.235288640745654e-11,   3.592807328431944e-12,   2.876786313911103e-14,
  -1.027807441029010e-15,  -3.422159771285926e-17,   1.236688850569933e+00,  -1.070807145849585e-02,   3.261832998628165e-06,   8.041675159554243e-07,  -5.005978597365679e-09,
  -3.228547859953554e-11,   3.589553857526444e-12,   2.862938979872833e-14,  -1.030299732257480e-15,  -3.418804557204011e-17,   1.236688986737481e+00,  -1.070796948274645e-02,
   3.260567300776188e-06,   8.041539183122812e-07,  -5.003704992879349e-09,  -3.226019445636780e-11,   3.588331473760490e-12,   2.857740351461896e-14,  -1.031234206970664e-15,
  -3.417540713676480e-17,   1.236689009307502e+00,  -1.070795257886128e-02,   3.260357511773911e-06,   8.041516646500141e-07,  -5.003328135421338e-09,  -3.225600473309728e-11,
   3.588128810668302e-12,   2.856878666891020e-14,  -1.031389035384641e-15,  -3.417331006435520e-17,   1.534113095590769e+00,  -1.080793672908687e-02,  -6.796448716835950e-05,
   1.186977315950641e-06,   1.359879855025661e-08,  -2.364706274019581e-10,   4.796985253785378e-13,   1.680772774468635e-13,  -3.558787435517350e-16,  -1.170330610035978e-16,
   1.534103447106344e+00,  -1.080743115569709e-02,  -6.795287023194711e-05,   1.186644953174002e-06,   1.359980330066946e-08,  -2.359778024987560e-10,   4.781020707488580e-13,
   1.674840929857475e-13,  -3.645155352819103e-16,  -1.167958544771525e-16,   1.534087608752952e+00,  -1.080660127671943e-02,  -6.793379853632634e-05,   1.186099828841238e-06,
   1.360145020349192e-08,  -2.351700277508262e-10,   4.754565933385904e-13,   1.665111673224525e-13,  -3.786532372230579e-16,  -1.164058699042415e-16,   1.534070804660385e+00,
  -1.080572084893133e-02,  -6.791356115905308e-05,   1.185522092631213e-06,   1.360319419797055e-08,  -2.343146509357195e-10,   4.726161159652331e-13,   1.654800187258738e-13,
  -3.935987145547479e-16,  -1.159912903017732e-16,   1.534057580927425e+00,  -1.080502804744639e-02,  -6.789763363350147e-05,   1.185067905028022e-06,   1.360456418282928e-08,
  -2.336427199792199e-10,   4.703564982526230e-13,   1.646693696314342e-13,  -4.053205361535752e-16,  -1.156644531414734e-16,   1.534049949724035e+00,  -1.080462825814946e-02,
  -6.788844130545532e-05,   1.184805982246884e-06,   1.360535380118953e-08,  -2.332554383167977e-10,   4.690427660930589e-13,   1.642018773336372e-13,  -4.120692530809014e-16,
  -1.154756045094588e-16,   1.534047084220394e+00,  -1.080447814084844e-02,  -6.788498944922998e-05,   1.184707664995806e-06,   1.360565011604494e-08,  -2.331101052096327e-10,
   4.685476222680734e-13,   1.640263953550337e-13,  -4.146004057918369e-16,  -1.154046475697258e-16,   1.534046609226851e+00,  -1.080445325715557e-02,  -6.788441725224468e-05,
   1.184691369474399e-06,   1.360569922418731e-08,  -2.330860191781715e-10,   4.684654488985510e-13,   1.639973101894064e-13,  -4.150198192754916e-16,  -1.153928832053508e-16,
   1.856530216553324e+00,  -6.296891018034640e-03,  -1.589324275566742e-04,  -2.053397891772090e-06,   1.870444876092953e-08,   1.573719505439667e-09,   3.090823932919879e-11,
  -1.271105130274723e-13,  -2.284649867483113e-14,  -5.466940464078478e-16,   1.856507632162596e+00,  -6.297759760357665e-03,  -1.589160897274067e-04,  -2.051161986922725e-06,
   1.876934459310432e-08,   1.573296183570296e-09,   3.081721653028678e-11,  -1.298391080433656e-13,  -2.284633219841640e-14,  -5.440089534322306e-16,   1.856470557968076e+00,
  -6.299185252453118e-03,  -1.588892288294703e-04,  -2.047491840579297e-06,   1.887574118301755e-08,   1.572595385448376e-09,   3.066779068916303e-11,  -1.343085779600870e-13,
  -2.284565108486456e-14,  -5.395985351495443e-16,   1.856431221746327e+00,  -6.300696873381305e-03,  -1.588606734228041e-04,  -2.043598151024456e-06,   1.898844534750699e-08,
   1.571843850042071e-09,   3.050924278886201e-11,  -1.390374893243432e-13,  -2.284437523444032e-14,  -5.349155344249730e-16,   1.856400265646400e+00,  -6.301885849110323e-03,
  -1.588381611668945e-04,  -2.040534247896376e-06,   1.907700594652734e-08,   1.571246652259392e-09,   3.038446849452358e-11,  -1.427493592986215e-13,  -2.284297152775600e-14,
  -5.312277145341672e-16,   1.856382400963136e+00,  -6.302571758544597e-03,  -1.588251532826097e-04,  -2.038766191121574e-06,   1.912806061542689e-08,   1.570899701737337e-09,
   3.031246047239688e-11,  -1.448876192988789e-13,  -2.284200152942469e-14,  -5.290985057751237e-16,   1.856375692726905e+00,  -6.302829273004519e-03,  -1.588202657416054e-04,
  -2.038102302652403e-06,   1.914722168316033e-08,   1.570768984761462e-09,   3.028542107803882e-11,  -1.456898137242828e-13,  -2.284160709874189e-14,  -5.282987992589499e-16,
   1.856374580747588e+00,  -6.302871957003203e-03,  -1.588194554060764e-04,  -2.037992255454736e-06,   1.915039735216766e-08,   1.570747293685947e-09,   3.028093892948715e-11,
  -1.458227497081688e-13,  -2.284154012457238e-14,  -5.281662276684198e-16,   2.331056721891951e-03,  -2.539728633159579e-05,   2.048344224245848e-07,  -1.502373937574582e-09,
   1.214948832208213e-11,   3.829708740574558e-14,   2.400560191569001e-15,  -2.333928190662792e-17,  -1.993848791007142e-18,  -3.809685768924532e-20,   2.331085892254145e-03,
  -2.539792753790469e-05,   2.048448246483403e-07,  -1.502320054975577e-09,   1.215451883254306e-11,   3.822433570047961e-14,   2.392662267367666e-15,  -2.352803188336250e-17,
  -1.991617327341617e-18,  -3.785743560468702e-20,   2.331133781200606e-03,  -2.539898016538610e-05,   2.048619046574379e-07,  -1.502231674040659e-09,   1.216276506964474e-11,
   3.810449847550096e-14,   2.379703109902811e-15,  -2.383701064866062e-17,  -1.987930117509898e-18,  -3.746460556685045e-20,   2.331184596536752e-03,  -2.540009706216295e-05,
   2.048800320427359e-07,  -1.502137998651476e-09,   1.217149844377747e-11,   3.797679453773185e-14,   2.365961399824277e-15,  -2.416365884826183e-17,  -1.983985310637814e-18,
  -3.704808493854153e-20,   2.331224589532550e-03,  -2.540097604963476e-05,   2.048943014102432e-07,  -1.502064350824099e-09,   1.217835969805889e-11,   3.787589537165098e-14,
   2.355153116712753e-15,  -2.441986267217877e-17,  -1.980857345751218e-18,  -3.672050256458239e-20,   2.331247670697106e-03,  -2.540148332401842e-05,   2.049025377507775e-07,
  -1.502021877423346e-09,   1.218231467055722e-11,   3.781750622612373e-14,   2.348918066345327e-15,  -2.456737428038235e-17,  -1.979042787342287e-18,  -3.653153803299418e-20,
   2.331256337984182e-03,  -2.540167380937047e-05,   2.049056308070348e-07,  -1.502005933954161e-09,   1.218379889658635e-11,   3.779555064007206e-14,   2.346577239507764e-15,
  -2.462270047614139e-17,  -1.978359638424069e-18,  -3.646059702092872e-20,   2.331257774715311e-03,  -2.540170538497961e-05,   2.049061435374334e-07,  -1.502003291397600e-09,
   1.218404488053214e-11,   3.779190961183102e-14,   2.346189240177975e-15,  -2.463186810990695e-17,  -1.978246303712033e-18,  -3.644883843460893e-20,   2.102499097591190e-02,
  -2.287469145722199e-04,   1.834399402048454e-06,  -1.330282326168029e-08,   1.062736275699698e-10,   3.919904063702278e-13,   2.140235807882808e-14,  -2.081303223803150e-16,
  -1.816308545678890e-17,  -3.464261672490746e-19,   2.102525220741533e-02,  -2.287525918904686e-04,   1.834490396737096e-06,  -1.330227093735544e-08,   1.063184592167077e-10,
   3.913411084695365e-13,   2.133040954182567e-14,  -2.098466705099959e-16,  -1.814285034275724e-17,  -3.442485931649205e-19,   2.102568107061931e-02,  -2.287619119583564e-04,
   1.834639806646073e-06,  -1.330136488672216e-08,   1.063919468444752e-10,   3.902715115291063e-13,   2.121235389618991e-14,  -2.126562856380812e-16,  -1.810941346405382e-17,
  -3.406757401814157e-19,   2.102613614042141e-02,  -2.287718010414067e-04,   1.834798379310557e-06,  -1.330040442202576e-08,   1.064697723946011e-10,   3.891316090664550e-13,
   2.108716896868417e-14,  -2.156265705517677e-16,  -1.807363935788971e-17,  -3.368873981870556e-19,   2.102649429201379e-02,  -2.287795836358097e-04,   1.834923203737922e-06,
  -1.329964920263618e-08,   1.065309125836892e-10,   3.882309035121788e-13,   2.098870685830701e-14,  -2.179562872456169e-16,  -1.804527201717711e-17,  -3.339079542738313e-19,
   2.102670099201626e-02,  -2.287840750567458e-04,   1.834995253131905e-06,  -1.329921362040777e-08,   1.065661541319839e-10,   3.877096495998198e-13,   2.093190622135726e-14,
  -2.192976414188526e-16,  -1.802881553150504e-17,  -3.321892688729837e-19,   2.102677861062483e-02,  -2.287857616174083e-04,   1.835022310431442e-06,  -1.329905010597910e-08,
   1.065793794350111e-10,   3.875136418559129e-13,   2.091058152103762e-14,  -2.198007340491108e-16,  -1.802261989096455e-17,  -3.315440394274268e-19,   2.102679147705726e-02,
  -2.287860411883165e-04,   1.835026795673494e-06,  -1.329902300381561e-08,   1.065815712831698e-10,   3.874811364396374e-13,   2.090704688456661e-14,  -2.198840972464488e-16,
  -1.802159202790455e-17,  -3.314370915585781e-19,   5.865893546562020e-02,  -6.363297859552550e-04,   5.042494442109076e-06,  -3.569095685772380e-08,   2.776144889276576e-10,
   1.357189609990617e-12,   5.836500333369890e-14,  -5.683356644598250e-16,  -5.169101747842983e-17,  -9.829785104552275e-19,   5.865965352770496e-02,  -6.363450164442509e-04,
   5.042732172494212e-06,  -3.568904054179607e-08,   2.777366447624216e-10,   1.355413673757830e-12,   5.816023195400822e-14,  -5.732057496879433e-16,  -5.163392560538429e-17,
  -9.767988578030875e-19,   5.866083236742776e-02,  -6.363700191698734e-04,   5.043122520023579e-06,  -3.568589645774344e-08,   2.779368680518623e-10,   1.352487775355902e-12,
   5.782423456094667e-14,  -5.811779427529740e-16,  -5.153958069196366e-17,  -9.666595152211120e-19,   5.866208324092512e-02,  -6.363965481968475e-04,   5.043536810242141e-06,
  -3.568256287348498e-08,   2.781488920849273e-10,   1.349369047710443e-12,   5.746794461092723e-14,  -5.896060258896186e-16,  -5.143863403419214e-17,  -9.559085282594165e-19,
   5.866306770915759e-02,  -6.364174261034783e-04,   5.043862932097044e-06,  -3.567994116290504e-08,   2.783154460880955e-10,   1.346904388228868e-12,   5.718770929501343e-14,
  -5.962165143497800e-16,  -5.135858257610828e-17,  -9.474530435678370e-19,   5.866363587473383e-02,  -6.364294749204464e-04,   5.044051172741800e-06,  -3.567842886062614e-08,
   2.784114434242846e-10,   1.345477901589237e-12,   5.702604710512981e-14,  -6.000225575800898e-16,  -5.131214104537371e-17,  -9.425754843734142e-19,   5.866384922839266e-02,
  -6.364339993273407e-04,   5.044121864519029e-06,  -3.567786111578138e-08,   2.784474679011966e-10,   1.344941470686542e-12,   5.696535405589256e-14,  -6.014500641351005e-16,
  -5.129465606992237e-17,  -9.407443433975013e-19,   5.866388459491233e-02,  -6.364347493102401e-04,   5.044133582985324e-06,  -3.567776701132090e-08,   2.784534382354617e-10,
   1.344852508933471e-12,   5.695529398550219e-14,  -6.016866040782721e-16,  -5.129175527486087e-17,  -9.404408283718500e-19,   1.157425068742136e-01,  -1.249750389809232e-03,
   9.714396526305540e-06,  -6.599930883683130e-08,   4.897337339402665e-10,   3.475449510143764e-12,   1.114524902554610e-13,  -1.090244514926829e-15,  -1.050779660074998e-16,
  -1.992417540067767e-18,   1.157438901477785e-01,  -1.249778549003924e-03,   9.714816000027558e-06,  -6.599439199414845e-08,   4.899667000462126e-10,   3.472034293331464e-12,
   1.110362010266994e-13,  -1.100115938342252e-15,  -1.049632654774335e-16,  -1.979897967593258e-18,   1.157461610586316e-01,  -1.249824775370416e-03,   9.715504776255406e-06,
  -6.598632377874982e-08,   4.903485106430367e-10,   3.466406558205532e-12,   1.103531324304211e-13,  -1.116275203142551e-15,  -1.047737057954157e-16,  -1.959356062498835e-18,
   1.157485707295984e-01,  -1.249873823068105e-03,   9.716235814150152e-06,  -6.597776765269407e-08,   4.907527703542844e-10,   3.460406468892012e-12,   1.096288045854103e-13,
  -1.133358564362351e-15,  -1.045708603729360e-16,  -1.937574638438499e-18,   1.157504671960651e-01,  -1.249912422380274e-03,   9.716811284442981e-06,  -6.597103747473689e-08,
   4.910702945864532e-10,   3.455663683059143e-12,   1.090590898954954e-13,  -1.146757759765477e-15,  -1.044099871023807e-16,  -1.920443631924800e-18,   1.157515617010873e-01,
  -1.249934698203562e-03,   9.717143455516060e-06,  -6.596715477876694e-08,   4.912532914557490e-10,   3.452918251589053e-12,   1.087304312536762e-13,  -1.154472464991659e-15,
  -1.043166510347664e-16,  -1.910561483237616e-18,   1.157519727018467e-01,  -1.249943062884358e-03,   9.717268199618783e-06,  -6.596569705683012e-08,   4.913219608697136e-10,
   3.451885752012573e-12,   1.086070422134158e-13,  -1.157365968119141e-15,  -1.042815093859301e-16,  -1.906851492205280e-18,   1.157520408312765e-01,  -1.249944449444004e-03,
   9.717288878296384e-06,  -6.596545543275386e-08,   4.913333412902371e-10,   3.451714518027381e-12,   1.085865900630714e-13,  -1.157845425937027e-15,  -1.042756792506004e-16,
  -1.906236553274670e-18,   1.930867102086395e-01,  -2.070914823164851e-03,   1.564169552165286e-05,  -9.954437453779719e-08,   6.809403000884279e-10,   7.620963959788427e-12,
   1.788273057769379e-13,  -1.770310522113336e-15,  -1.824007552845770e-16,  -3.455854742727216e-18,   1.930889373103160e-01,  -2.070957282713633e-03,   1.564227904839628e-05,
  -9.953357656159529e-08,   6.813134481658106e-10,   7.615401007691683e-12,   1.781046308679148e-13,  -1.787433652533750e-15,  -1.822042906665574e-16,  -3.434181638541931e-18,
   1.930925935186230e-01,  -2.071026983616046e-03,   1.564323722957459e-05,  -9.951585577031747e-08,   6.819249183765119e-10,   7.606231913443122e-12,   1.769188214202332e-13,
  -1.815463930318282e-15,  -1.818795670220170e-16,  -3.398620138108817e-18,   1.930964731204287e-01,  -2.071100937151607e-03,   1.564425424280421e-05,  -9.949706059077407e-08,
   6.825722237070146e-10,   7.596453137100111e-12,   1.756613754485337e-13,  -1.845097381126442e-15,  -1.815320349494613e-16,  -3.360911962784446e-18,   1.930995264469730e-01,
  -2.071159135708976e-03,   1.564505486094986e-05,  -9.948227445749575e-08,   6.830805621936925e-10,   7.588721308931667e-12,   1.746723331820535e-13,  -1.868340289855763e-15,
  -1.812563777402328e-16,  -3.331254007716801e-18,   1.931012886052969e-01,  -2.071192721926481e-03,   1.564551700278609e-05,  -9.947374340974484e-08,   6.833734957901737e-10,
   7.584244761807807e-12,   1.741017686534885e-13,  -1.881722661113695e-15,  -1.810964318252137e-16,  -3.314145347649449e-18,   1.931019503177821e-01,  -2.071205333637941e-03,
   1.564569055853630e-05,  -9.947054035540654e-08,   6.834834124058112e-10,   7.582561062972932e-12,   1.738875597858593e-13,  -1.886741909530928e-15,  -1.810362084848896e-16,
  -3.307722307517839e-18,   1.931020600063362e-01,  -2.071207424196597e-03,   1.564571932877715e-05,  -9.947000942647268e-08,   6.835016282871711e-10,   7.582281822851335e-12,
   1.738520539124168e-13,  -1.887573607146534e-15,  -1.810262170610785e-16,  -3.306657672443858e-18,   2.918688478737764e-01,  -3.101101539044804e-03,   2.246278459384785e-05,
  -1.285538803629456e-07,   7.546295259382592e-10,   1.505552796524442e-11,   2.609132175637704e-13,  -2.651521207379317e-15,  -2.897939014892811e-16,  -5.514063482737446e-18,
   2.918720457950180e-01,  -3.101156346101831e-03,   2.246343200132374e-05,  -1.285325262083250e-07,   7.551728435129482e-10,   1.504716921261346e-11,   2.597649660089978e-13,
  -2.678846462131408e-15,  -2.894857985978495e-16,  -5.479635689091795e-18,   2.918772957675319e-01,  -3.101246314186287e-03,   2.246449515648019e-05,  -1.284974786841494e-07,
   7.560630191594906e-10,   1.503338854519062e-11,   2.578808326993244e-13,  -2.723578021693510e-15,  -2.889764811129326e-16,  -5.423144772909960e-18,   2.918828664855569e-01,
  -3.101341768350517e-03,   2.246562369554593e-05,  -1.284603025129575e-07,   7.570051621261725e-10,   1.501868694185248e-11,   2.558828604551498e-13,  -2.770868753724540e-15,
  -2.884312894490696e-16,  -5.363241929631372e-18,   2.918872507361318e-01,  -3.101416884817379e-03,   2.246651218654126e-05,  -1.284310533563719e-07,   7.577448949507986e-10,
   1.500705944178842e-11,   2.543113470649607e-13,  -2.807961663314788e-15,  -2.879987799795183e-16,  -5.316126256856347e-18,   2.918897809994180e-01,  -3.101460233409391e-03,
   2.246702508211859e-05,  -1.284141765861585e-07,   7.581711124981290e-10,   1.500032607002652e-11,   2.534047586507275e-13,  -2.829318557878422e-15,  -2.877477944604728e-16,
  -5.288946303998375e-18,   2.918907311434612e-01,  -3.101476510747281e-03,   2.246721770407051e-05,  -1.284078398517716e-07,   7.583310297601829e-10,   1.499779329560281e-11,
   2.530643944080028e-13,  -2.837328807342013e-15,  -2.876532872556155e-16,  -5.278742135677312e-18,   2.918908886437013e-01,  -3.101479208923206e-03,   2.246724963521153e-05,
  -1.284067894822210e-07,   7.583575313900493e-10,   1.499737322386617e-11,   2.530079777923792e-13,  -2.838656120948407e-15,  -2.876376076459602e-16,  -5.277050763788577e-18,
   4.137369296443449e-01,  -4.338909954693250e-03,   2.954613897008784e-05,  -1.401801405213218e-07,   5.652922558058060e-10,   2.741634013907303e-11,   3.667084711427872e-13,
  -3.911829285744878e-15,  -4.363965347122894e-16,  -8.411540039216073e-18,   4.137411352563587e-01,  -4.338969663238742e-03,   2.954662595005258e-05,  -1.401412299606920e-07,
   5.660545081726850e-10,   2.740398634251211e-11,   3.649792308705140e-13,  -3.953523992436837e-15,  -4.359376849673350e-16,  -8.359428209932947e-18,   4.137480395001068e-01,
  -4.339067672500667e-03,   2.954742587040073e-05,  -1.400773649577451e-07,   5.673032060462456e-10,   2.738361643439486e-11,   3.621417553749570e-13,  -4.021779940015585e-15,
  -4.351790268854626e-16,  -8.273917655284786e-18,   4.137553655056904e-01,  -4.339171651624995e-03,   2.954827527732938e-05,  -1.400096169436959e-07,   5.686245532599391e-10,
   2.736188145077672e-11,   3.591328208658554e-13,  -4.093943016020233e-15,  -4.343667372410324e-16,  -8.183238722334496e-18,   4.137611311608211e-01,  -4.339253471958735e-03,
   2.954894422019923e-05,  -1.399563117478133e-07,   5.696618420325920e-10,   2.734468852199548e-11,   3.567661169857506e-13,  -4.150546280811820e-15,  -4.337221949229599e-16,
  -8.111913891988564e-18,   4.137644586532870e-01,  -4.339300687350473e-03,   2.954933046242605e-05,  -1.399255534395586e-07,   5.702594323733280e-10,   2.733473117832165e-11,
   3.554007865702392e-13,  -4.183137210663037e-15,  -4.333481111452874e-16,  -8.070767154517333e-18,   4.137657081636049e-01,  -4.339318416306987e-03,   2.954947553463604e-05,
  -1.399140043662739e-07,   5.704836351972486e-10,   2.733098549440389e-11,   3.548881938741098e-13,  -4.195361081650039e-15,  -4.332072415568700e-16,  -8.055319233925136e-18,
   4.137659152880263e-01,  -4.339321355088211e-03,   2.954949958424614e-05,  -1.399120899936615e-07,   5.705207895646254e-10,   2.733036424554719e-11,   3.548032297086773e-13,
  -4.197386606418579e-15,  -4.331838694559093e-16,  -8.052758683469273e-18,   5.609755889137573e-01,  -5.775548713990253e-03,   3.575150383997339e-05,  -1.127831325355234e-07,
  -9.525426599841140e-11,   4.634841013717044e-11,   5.315475826180471e-13,  -6.071226131191563e-15,  -6.368811377234994e-16,  -1.257597139110098e-17,   5.609806764645111e-01,
  -5.775596631181641e-03,   3.575142875165851e-05,  -1.127173378085730e-07,  -9.414957872240322e-11,   4.632927422063126e-11,   5.290237685807295e-13,  -6.133584699911707e-15,
  -6.362186720801304e-16,  -1.249886320697935e-17,   5.609890284959738e-01,  -5.775675274744822e-03,   3.575130615426656e-05,  -1.126093452064548e-07,  -9.233994211578751e-11,
   4.629772616710754e-11,   5.248824734589109e-13,  -6.235671266913098e-15,  -6.351230558383551e-16,  -1.237233057536138e-17,   5.609978906381424e-01,  -5.775758694110345e-03,
   3.575117698126247e-05,  -1.124947840878953e-07,  -9.042505799632673e-11,   4.626407034809279e-11,   5.204909076790397e-13,  -6.343605620583704e-15,  -6.339495813968885e-16,
  -1.223814276747900e-17,   5.610048651843180e-01,  -5.775824325657366e-03,   3.575107598093225e-05,  -1.124046437670546e-07,  -8.892185580676124e-11,   4.623745233307632e-11,
   5.170366642734949e-13,  -6.428270136565959e-15,  -6.330181522185543e-16,  -1.213259008453222e-17,   5.610088903287924e-01,  -5.775862194917719e-03,   3.575101795568892e-05,
  -1.123526300139623e-07,  -8.805585990857066e-11,   4.622203824886835e-11,   5.150439345482559e-13,  -6.477019320737813e-15,  -6.324774476079919e-16,  -1.207169544100140e-17,
   5.610104018100955e-01,  -5.775876413691687e-03,   3.575099621649564e-05,  -1.123330998446933e-07,  -8.773095925095174e-11,   4.621624023074144e-11,   5.142957928565611e-13,
  -6.495303889818660e-15,  -6.322738115362858e-16,  -1.204883306654409e-17,   5.610106523597317e-01,  -5.775878770577348e-03,   3.575099261554268e-05,  -1.123298625194195e-07,
  -8.767711758297932e-11,   4.621527860548344e-11,   5.141717854867094e-13,  -6.498333698746247e-15,  -6.322400245168538e-16,  -1.204504352156367e-17,   7.367710496450707e-01,
  -7.383238545463961e-03,   3.890513758001277e-05,  -8.930657104486769e-09,  -1.478616811887044e-09,   7.164912098919273e-11,   8.679050238619655e-13,  -1.040605493590855e-14,
  -9.214908239494520e-16,  -1.873788719078333e-17,   7.367765836138493e-01,  -7.383241998968720e-03,   3.890388530120029e-05,  -8.828971531916360e-09,  -1.476807527218843e-09,
   7.161654404588087e-11,   8.642528947237336e-13,  -1.049898823877496e-14,  -9.205555030007434e-16,  -1.862377475833293e-17,   7.367856683923235e-01,  -7.383247637144031e-03,
   3.890183058561224e-05,  -8.662072322988337e-09,  -1.473842917653014e-09,   7.156286497580615e-11,   8.582600968515441e-13,  -1.065113127286404e-14,  -9.190078840195243e-16,
  -1.843650843419559e-17,   7.367953078720624e-01,  -7.383253577134462e-03,   3.889965187039541e-05,  -8.485025839218942e-09,  -1.470704878928910e-09,   7.150563772138259e-11,
   8.519050495659313e-13,  -1.081199337088774e-14,  -9.173492866606839e-16,  -1.823789816359223e-17,   7.368028940685285e-01,  -7.383258221135873e-03,   3.889793829232199e-05,
  -8.345723063317440e-09,  -1.468240756495009e-09,   7.146040475704984e-11,   8.469063416874802e-13,  -1.093817763064328e-14,  -9.160320824022253e-16,  -1.808166011081981e-17,
   7.368072721608666e-01,  -7.383260888934346e-03,   3.889694978623659e-05,  -8.265342259556599e-09,  -1.466820879546196e-09,   7.143422196672398e-11,   8.440225959598754e-13,
  -1.101083469749633e-14,  -9.152671473143768e-16,  -1.799152029706216e-17,   7.368089161686289e-01,  -7.383261888385945e-03,   3.889657867421715e-05,  -8.235161033362754e-09,
  -1.466288120461359e-09,   7.142437534831903e-11,   8.429399304562874e-13,  -1.103808671378788e-14,  -9.149790099631538e-16,  -1.795767728871983e-17,   7.368091886859492e-01,
  -7.383262053936268e-03,   3.889651716140420e-05,  -8.230158198507817e-09,  -1.466199830110526e-09,   7.142274235419077e-11,   8.427604742285024e-13,  -1.104260246735399e-14,
  -9.149311998044602e-16,  -1.795206761122390e-17,   9.456301756583293e-01,  -9.083554697702440e-03,   3.453265590199040e-05,   2.367001393510506e-07,  -3.637784904141000e-09,
   9.329667104550979e-11,   1.705210228840131e-12,  -1.903875671078510e-14,  -1.388859545640029e-15,  -2.802314968099101e-17,   9.456350837037015e-01,  -9.083453178010641e-03,
   3.452957002114362e-05,   2.368324063200716e-07,  -3.634210318652410e-09,   9.323756406506556e-11,   1.699703480016379e-12,  -1.917767201699046e-14,  -1.387561476823459e-15,
  -2.784991522504944e-17,   9.456431407405697e-01,  -9.083286476306017e-03,   3.452450623342146e-05,   2.370494822510044e-07,  -3.628350539266065e-09,   9.314023335590342e-11,
   1.690667107072276e-12,  -1.940508314876550e-14,  -1.385411606982970e-15,  -2.756560557186680e-17,   9.456516894528914e-01,  -9.083109537607780e-03,   3.451913613014391e-05,
   2.372797325634408e-07,  -3.622144383794205e-09,   9.303655501392783e-11,   1.681084074276349e-12,  -1.964551317940111e-14,  -1.383104834478287e-15,  -2.726404629455999e-17,
   9.456584170257086e-01,  -9.082970245887884e-03,   3.451491197648546e-05,   2.374608798006833e-07,  -3.617268447430184e-09,   9.295466847236063e-11,   1.673546006782987e-12,
  -1.983410256868235e-14,  -1.381270912235853e-15,  -2.702680317710884e-17,   9.456622995158241e-01,  -9.082889841867441e-03,   3.451247499422675e-05,   2.375653989314540e-07,
  -3.614457791671853e-09,   9.290729364014908e-11,   1.669197183391802e-12,  -1.994268858213214e-14,  -1.380205128855071e-15,  -2.688992057203494e-17,   9.456637574060905e-01,
  -9.082859646325863e-03,   3.451156004550643e-05,   2.376046422719218e-07,  -3.613402994143115e-09,   9.288948192171667e-11,   1.667564449470534e-12,  -1.998341596962558e-14,
  -1.379803521619753e-15,  -2.683852650031838e-17,   9.456639990710369e-01,  -9.082854640822671e-03,   3.451140838822226e-05,   2.376111471728172e-07,  -3.613228179674821e-09,
   9.288652821451862e-11,   1.667293815905662e-12,  -1.999016459869148e-14,  -1.379736875929415e-15,  -2.683000755322425e-17,   1.193956380992824e+00,  -1.064677922418095e-02,
   1.245217356402570e-05,   7.232319958267664e-07,  -4.801796143948697e-09,   5.902961766233117e-11,   3.787228978660184e-12,  -2.554702754384549e-14,  -2.506291482853582e-15,
  -4.339217965275566e-17,   1.193958144875098e+00,  -1.064647016625327e-02,   1.244811865500533e-05,   7.233153227506035e-07,  -4.793829911526568e-09,   5.894985279439889e-11,
   3.777287629901645e-12,  -2.576190068115797e-14,  -2.504142001462993e-15,  -4.311544802198462e-17,   1.193961040163531e+00,  -1.064596277207916e-02,   1.244146674421101e-05,
   7.234520339260572e-07,  -4.780767365007051e-09,   5.881844655886883e-11,   3.760973670325524e-12,  -2.611362569193944e-14,  -2.500581324681524e-15,  -4.266123543504436e-17,
   1.193964111731672e+00,  -1.064542435290866e-02,   1.243441517800119e-05,   7.235969813693927e-07,  -4.766927800061526e-09,   5.867839137763353e-11,   3.743672010386034e-12,
  -2.648544158087056e-14,  -2.496759847644100e-15,  -4.217940407002892e-17,   1.193966528669115e+00,  -1.064500058905301e-02,   1.242887035114416e-05,   7.237109732600752e-07,
  -4.756051049858450e-09,   5.856771709077234e-11,   3.730061860208247e-12,  -2.677705529076590e-14,  -2.493721040890874e-15,  -4.180029330303968e-17,   1.193967923369574e+00,
  -1.064475601657213e-02,   1.242567224299652e-05,   7.237767270693344e-07,  -4.749779900043126e-09,   5.850366467751471e-11,   3.722209733572252e-12,  -2.694494752340803e-14,
  -2.491954773275124e-15,  -4.158153960696701e-17,   1.193968447062966e+00,  -1.064466417527003e-02,   1.242447168429949e-05,   7.238014120068937e-07,  -4.747426161513436e-09,
   5.847957835252404e-11,   3.719261666809504e-12,  -2.700791642135378e-14,  -2.491289160439325e-15,  -4.149940285113447e-17,   1.193968533871034e+00,  -1.064464895115920e-02,
   1.242427269364183e-05,   7.238055035575781e-07,  -4.747036055828066e-09,   5.847558390628644e-11,   3.718773008162162e-12,  -2.701835039224551e-14,  -2.491178701069606e-15,
  -4.148578790385641e-17,   1.489888889687012e+00,  -1.129132654660254e-02,  -5.256511805031802e-05,   1.368872250753280e-06,   9.341396191383792e-09,  -1.739680676568591e-10,
   4.335596505310741e-12,   8.197187889615797e-14,  -5.121117928919964e-15,  -1.315467279366418e-16,   1.489881425427567e+00,  -1.129074301216249e-02,  -5.255709100037183e-05,
   1.368626652007103e-06,   9.350410640597657e-09,  -1.737335442834435e-10,   4.315343566676239e-12,   8.131593903322315e-14,  -5.113810543344362e-15,  -1.308766168671305e-16,
   1.489869172471035e+00,  -1.128978512123863e-02,  -5.254390781148838e-05,   1.368223698799395e-06,   9.365178152799455e-09,  -1.733499413299707e-10,   4.282116442390065e-12,
   8.024158606801464e-14,  -5.101760608537523e-15,  -1.297768914311630e-16,   1.489856172270012e+00,  -1.128876882723019e-02,  -5.252991198193862e-05,   1.367796455457064e-06,
   9.380805286866766e-09,  -1.729448156893868e-10,   4.246888999188858e-12,   7.910498220180425e-14,  -5.088901930688601e-15,  -1.286105113609197e-16,   1.489845941863939e+00,
  -1.128796907253842e-02,  -5.251889180676967e-05,   1.367460444608751e-06,   9.393073284166354e-09,  -1.726273579097767e-10,   4.219185954264461e-12,   7.821290663548923e-14,
  -5.078729547367820e-15,  -1.276929440588622e-16,   1.489840038025496e+00,  -1.128750754813320e-02,  -5.251252969282031e-05,   1.367266618934599e-06,   9.400141108273973e-09,
  -1.724446985212149e-10,   4.203206480194148e-12,   7.769904930167495e-14,  -5.072837855702666e-15,  -1.271635529786412e-16,   1.489837821137637e+00,  -1.128733424673570e-02,
  -5.251014024870449e-05,   1.367193852974451e-06,   9.402792826585884e-09,  -1.723762122919521e-10,   4.197207636984686e-12,   7.750627538573085e-14,  -5.070621501539428e-15,
  -1.269647909668104e-16,   1.489837453660023e+00,  -1.128730551984418e-02,  -5.250974414267378e-05,   1.367181791898030e-06,   9.403232264479701e-09,  -1.723648652133080e-10,
   4.196213327759443e-12,   7.747433008888820e-14,  -5.070253900064203e-15,  -1.269318448876957e-16,   1.828654326060896e+00,  -7.659184857176894e-03,  -1.806157457432504e-04,
  -1.464950742454877e-06,   5.680682102847104e-08,   2.172785896429083e-09,   1.434476331735409e-11,  -1.138522306870346e-12,  -3.795608002623766e-14,  -1.299115562904715e-16,
   1.828628720983481e+00,  -7.659799460565479e-03,  -1.805670788961369e-04,  -1.461887510613371e-06,   5.683568748019260e-08,   2.169375369724868e-09,   1.419671682633647e-11,
  -1.139047130170361e-12,  -3.780215884395935e-14,  -1.246407806257701e-16,   1.828586691134950e+00,  -7.660807493053588e-03,  -1.804871671284861e-04,  -1.456862230833935e-06,
   5.688284971889243e-08,   2.163775395379597e-09,   1.395411767152475e-11,  -1.139889430680044e-12,  -3.754950054608486e-14,  -1.160190911167072e-16,   1.828542101054146e+00,
  -7.661875818606769e-03,  -1.804023511822216e-04,  -1.451534792930421e-06,   5.693258475111709e-08,   2.157831995202302e-09,   1.369730340275070e-11,  -1.140757034116187e-12,
  -3.728145160308114e-14,  -1.069131164102743e-16,   1.828507013376990e+00,  -7.662715673889049e-03,  -1.803355837153642e-04,  -1.447345527029435e-06,   5.697150395906198e-08,
   2.153153516094268e-09,   1.349562517861521e-11,  -1.141420964305547e-12,  -3.707052747797501e-14,  -9.977727986321793e-17,   1.828486765577110e+00,  -7.663200001148387e-03,
  -1.802970441613494e-04,  -1.444929205122171e-06,   5.699387589334671e-08,   2.150453082542904e-09,   1.337940746932256e-11,  -1.141796580381044e-12,  -3.694881247408067e-14,
  -9.567131506838722e-17,   1.828479162702073e+00,  -7.663381801001513e-03,  -1.802825709033655e-04,  -1.444022114082638e-06,   5.700225994752332e-08,   2.149438969537263e-09,
   1.333579958924550e-11,  -1.141936202674305e-12,  -3.690310990025933e-14,  -9.413180221915696e-17,   1.828477902436502e+00,  -7.663411933245018e-03,  -1.802801716866295e-04,
  -1.443871764573844e-06,   5.700364883695478e-08,   2.149270861937973e-09,   1.332857270112304e-11,  -1.141959271925558e-12,  -3.689553418469809e-14,  -9.387672818455844e-17,
   2.232635512642056e-03,  -2.382734337328493e-05,   1.880067502015281e-07,  -1.299090927900752e-09,   1.339655679673865e-11,   7.975552708835997e-14,   6.830992618591405e-16,
  -1.034901463690888e-16,  -2.740987619283756e-18,   8.537764071724587e-21,   2.232662290401591e-03,  -2.382789759257090e-05,   1.880181962570422e-07,  -1.298980033148630e-09,
   1.339788889768619e-11,   7.944710341767301e-14,   6.724544969329360e-16,  -1.034379017626225e-16,  -2.727621370569022e-18,   8.856727505745419e-21,   2.232706251607432e-03,
  -2.382880739964298e-05,   1.880369875924099e-07,  -1.298798298332590e-09,   1.340005948091276e-11,   7.894089437080460e-14,   6.550177763166067e-16,  -1.033509701145846e-16,
  -2.705697738867177e-18,   9.378050332700862e-21,   2.232752899448225e-03,  -2.382977272968148e-05,   1.880569277101042e-07,  -1.298605894226232e-09,   1.340234054932694e-11,
   7.840392962585555e-14,   6.365682040724552e-16,  -1.032571520614428e-16,  -2.682461335245050e-18,   9.928082136415040e-21,   2.232789612705272e-03,  -2.383053241653464e-05,
   1.880726214496539e-07,  -1.298454782880169e-09,   1.340411979516704e-11,   7.798145404199258e-14,   6.220860173932975e-16,  -1.031821787401220e-16,  -2.664193281530066e-18,
   1.035869536688026e-20,   2.232810801109310e-03,  -2.383097083347488e-05,   1.880816789177307e-07,  -1.298367698492858e-09,   1.340514024074456e-11,   7.773768297065078e-14,
   6.137431777573297e-16,  -1.031384552012736e-16,  -2.653658127465003e-18,   1.060630386395749e-20,   2.232818757653706e-03,  -2.383113546090263e-05,   1.880850801443713e-07,
  -1.298335021049511e-09,   1.340552222104971e-11,   7.764615359518979e-14,   6.106132141647181e-16,  -1.031219507272330e-16,  -2.649703531135073e-18,   1.069911203570179e-20,
   2.232820076569469e-03,  -2.383116275012375e-05,   1.880856439493907e-07,  -1.298329605541021e-09,   1.340558547609428e-11,   7.763098177141588e-14,   6.100945285226380e-16,
  -1.031192103489261e-16,  -2.649048077242337e-18,   1.071448728562172e-20,   2.013838449825766e-02,  -2.146805864094723e-04,   1.685308354061816e-06,  -1.151511539520612e-08,
   1.183947541449590e-10,   7.600030352763977e-13,   5.884825438338611e-15,  -9.380623485381010e-16,  -2.496189128096378e-17,   7.745469719283441e-20,   2.013862453343773e-02,
  -2.146854987331027e-04,   1.685409508820032e-06,  -1.151405745123976e-08,   1.184061679905587e-10,   7.572074128436434e-13,   5.787881569912842e-15,  -9.375880757465889e-16,
  -2.484031600336449e-17,   8.035991234673770e-20,   2.013901860045989e-02,  -2.146935627866809e-04,   1.685575577412561e-06,  -1.151232353714573e-08,   1.184247574344266e-10,
   7.526190204798484e-13,   5.629081650394216e-15,  -9.367988810002129e-16,  -2.464090487259747e-17,   8.510829571165745e-20,   2.013943675019976e-02,  -2.147021189354765e-04,
   1.685751798062184e-06,  -1.151048762313818e-08,   1.184442811074905e-10,   7.477518540610795e-13,   5.461056880242447e-15,  -9.359471216831955e-16,  -2.442955241644411e-17,
   9.011819424338397e-20,   2.013976584650445e-02,  -2.147088523547556e-04,   1.685890491144302e-06,  -1.150904557444647e-08,   1.184595009241796e-10,   7.439224444039273e-13,
   5.329163629934002e-15,  -9.352664170056396e-16,  -2.426339029360109e-17,   9.404040052366043e-20,   2.013995577853088e-02,  -2.147127382166352e-04,   1.685970536228737e-06,
  -1.150821447229592e-08,   1.184682263639677e-10,   7.417128516842296e-13,   5.253182925630647e-15,  -9.348694249467318e-16,  -2.416756468462909e-17,   9.629572977055830e-20,
   2.014002710067302e-02,  -2.147141973726010e-04,   1.686000594442803e-06,  -1.150790259917996e-08,   1.184714918593736e-10,   7.408832101474199e-13,   5.224677390130929e-15,
  -9.347195685126113e-16,  -2.413159444505810e-17,   9.714106954536573e-20,   2.014003892337999e-02,  -2.147144392473326e-04,   1.686005577047786e-06,  -1.150785091303620e-08,
   1.184720325822172e-10,   7.407456895489977e-13,   5.219953559659645e-15,  -9.346946864431721e-16,  -2.412563256177762e-17,   9.728111450614782e-20,   5.619169361622044e-02,
  -5.976249696746373e-04,   4.641972510860679e-06,  -3.096502129970365e-08,   3.163866302691973e-10,   2.351587893708318e-12,   1.488525453954412e-14,  -2.644779065883133e-15,
  -7.101308118115224e-17,   2.185060442847058e-19,   5.619235474658811e-02,  -5.976381777501518e-04,   4.642242815611162e-06,  -3.096174134415464e-08,   3.164151384764450e-10,
   2.343705945866698e-12,   1.460944661615201e-14,  -2.643439145798521e-15,  -7.066800168350234e-17,   2.267752153383287e-19,   5.619344012694547e-02,  -5.976598599478647e-04,
   4.642686581179552e-06,  -3.095636486394804e-08,   3.164615175824870e-10,   2.330769489062264e-12,   1.415765426201726e-14,  -2.641209280640639e-15,  -7.010198962067517e-17,
   2.402907343533134e-19,   5.619459183726249e-02,  -5.976828650834284e-04,   4.643157473131657e-06,  -3.095067100652619e-08,   3.165101570684173e-10,   2.317047070406353e-12,
   1.367961370601792e-14,  -2.638802339297567e-15,  -6.950207885220073e-17,   2.545507530067815e-19,   5.619549826675544e-02,  -5.977009692682270e-04,   4.643528083670311e-06,
  -3.094619787633141e-08,   3.165480228734702e-10,   2.306250495873885e-12,   1.330436723297713e-14,  -2.636878558886704e-15,  -6.903043497397057e-17,   2.657148982996258e-19,
   5.619602139593276e-02,  -5.977114171557060e-04,   4.643741976675689e-06,  -3.094361953793588e-08,   3.165697103442738e-10,   2.300020809720622e-12,   1.308819536073081e-14,
  -2.635756511743677e-15,  -6.875843697803154e-17,   2.721344944244348e-19,   5.619621783821849e-02,  -5.977153403673759e-04,   4.643822296834586e-06,  -3.094265194959178e-08,
   3.165778229259464e-10,   2.297681733836718e-12,   1.300709440148677e-14,  -2.635332946055774e-15,  -6.865633634742773e-17,   2.745406872182724e-19,   5.619625040144878e-02,
  -5.977159906919648e-04,   4.643835611114253e-06,  -3.094249158980259e-08,   3.165791660529865e-10,   2.297294010857477e-12,   1.299365464553465e-14,  -2.635262616648310e-15,
  -6.863941367786785e-17,   2.749393145186752e-19,   1.108941158248513e-01,  -1.175063831959116e-03,   8.972137311636047e-06,  -5.748015131615705e-08,   5.813029097521169e-10,
   5.346240400962736e-12,   2.490552478514495e-14,  -5.310000861833061e-15,  -1.443512763933043e-16,   4.377746634083283e-19,   1.108953936245606e-01,  -1.175088345122335e-03,
   8.972633913981554e-06,  -5.747267679074736e-08,   5.813494338271383e-10,   5.330415616145909e-12,   2.434483643882527e-14,  -5.307309296798677e-15,  -1.436518540998530e-16,
   4.546059018870521e-19,   1.108974913907672e-01,  -1.175128585173089e-03,   8.973449193738914e-06,  -5.746042240540857e-08,   5.814249532700310e-10,   5.304442773546881e-12,
   2.342638441351170e-14,  -5.302829247244460e-15,  -1.425046259734442e-16,   4.821159778385415e-19,   1.108997173524178e-01,  -1.175171279889504e-03,   8.974314304490590e-06,
  -5.744744164757804e-08,   5.815039217122409e-10,   5.276891946397762e-12,   2.245456415562608e-14,  -5.297992352385266e-15,  -1.412886763345521e-16,   5.111418668124400e-19,
   1.109014692463100e-01,  -1.175204878622432e-03,   8.974995176979077e-06,  -5.743724171544019e-08,   5.815652291995058e-10,   5.255215414565047e-12,   2.169171064356468e-14,
  -5.294125632524047e-15,  -1.403326990780129e-16,   5.338664955670945e-19,   1.109024803187264e-01,  -1.175224268213728e-03,   8.975388132066522e-06,  -5.743136154479642e-08,
   5.816002742360874e-10,   5.242707933500743e-12,   2.125224388532557e-14,  -5.291870061900498e-15,  -1.397813811333576e-16,   5.469337129923300e-19,   1.109028599902897e-01,
  -1.175231549029087e-03,   8.975535692539860e-06,  -5.742915469362647e-08,   5.816133704056426e-10,   5.238011718924583e-12,   2.108736919077264e-14,  -5.291018541909800e-15,
  -1.395744306768566e-16,   5.518315902388851e-19,   1.109029229264872e-01,  -1.175232755919536e-03,   8.975560152902091e-06,  -5.742878894035958e-08,   5.816155379298087e-10,
   5.237233278930349e-12,   2.106004673276657e-14,  -5.290877151447101e-15,  -1.395401296336740e-16,   5.526430092337177e-19,   1.850460311688987e-01,  -1.950361210917983e-03,
   1.451824092682031e-05,  -8.722684643294411e-08,   8.684167690647693e-10,   1.055808767636506e-11,   3.200394234167487e-14,  -9.097382465806418e-15,  -2.508277528921135e-16,
   7.432326847412948e-19,   1.850480987129992e-01,  -1.950398397753481e-03,   1.451898273529760e-05,  -8.721205033647296e-08,   8.684735471056731e-10,   1.053097547571569e-11,
   3.102960746721497e-14,  -9.092792690236737e-15,  -2.496158837306034e-16,   7.725635090792645e-19,   1.850514929977055e-01,  -1.950459441452123e-03,   1.452020056539544e-05,
  -8.718778800360178e-08,   8.685652675410778e-10,   1.048647682806697e-11,   2.943355953395892e-14,  -9.085150809695616e-15,  -2.476280894214335e-16,   8.205044670720468e-19,
   1.850550947000374e-01,  -1.950524207409575e-03,   1.452149281947148e-05,  -8.716208164314784e-08,   8.686605680391246e-10,   1.043927460764345e-11,   2.774475684534219e-14,
  -9.076897159012342e-15,  -2.455211884188725e-16,   8.710879908810877e-19,   1.850579293339453e-01,  -1.950575174127686e-03,   1.452250986039683e-05,  -8.714187800193468e-08,
   8.687341083747160e-10,   1.040213665260638e-11,   2.641908098416407e-14,  -9.070296824919740e-15,  -2.438647228546832e-16,   9.106910112381865e-19,   1.850595652867665e-01,
  -1.950604586242497e-03,   1.452309682657028e-05,  -8.713022906701888e-08,   8.687759647949255e-10,   1.038070782996903e-11,   2.565537801652753e-14,  -9.066445797039658e-15,
  -2.429094193980000e-16,   9.334640072580208e-19,   1.850601796090198e-01,  -1.950615630448763e-03,   1.452331724045188e-05,  -8.712585685154940e-08,   8.687915717886627e-10,
   1.037266189496792e-11,   2.536885891189861e-14,  -9.064991801527350e-15,  -2.425508214464958e-16,   9.419998762600668e-19,   1.850602814420274e-01,  -1.950617461166350e-03,
   1.452335377732586e-05,  -8.712513220373581e-08,   8.687941530436690e-10,   1.037132820842313e-11,   2.532137792806103e-14,  -9.064750364715753e-15,  -2.424913854646082e-16,
   9.434139950864191e-19,   2.798143986569293e-01,  -2.927339703914057e-03,   2.100350213075216e-05,  -1.137769320231665e-07,   1.106230743233329e-09,   1.921825660487408e-11,
   3.199376659225427e-14,  -1.431066517960133e-14,  -3.997353335407531e-16,   1.142607095002089e-18,   2.798173895095956e-01,  -2.927388182515945e-03,   2.100444695294189e-05,
  -1.137499430227049e-07,   1.106280648994417e-09,   1.917560592090519e-11,   3.044093467344841e-14,  -1.430355791116243e-14,  -3.978073922793157e-16,   1.189616863412684e-18,
   2.798222995756606e-01,  -2.927467759745485e-03,   2.100599805650617e-05,  -1.137056800288193e-07,   1.106360202820484e-09,   1.910560407958609e-11,   2.789724705905008e-14,
  -1.429171864096385e-14,  -3.946449921289166e-16,   1.266455415982705e-18,   2.798275096676028e-01,  -2.927552186143525e-03,   2.100764393049701e-05,  -1.136587731144698e-07,
   1.106441393027869e-09,   1.903134887843151e-11,   2.520571933532615e-14,  -1.427892380418428e-14,  -3.912930319870029e-16,   1.347531472462396e-18,   2.798316101331756e-01,
  -2.927618622064367e-03,   2.100893926541135e-05,  -1.136219002297669e-07,   1.106502960602549e-09,   1.897292584929442e-11,   2.309291527577404e-14,  -1.426868642927374e-14,
  -3.886576371836412e-16,   1.411009299350711e-18,   2.798339766304568e-01,  -2.927656960289218e-03,   2.100968683770867e-05,  -1.136006374424640e-07,   1.106537559864472e-09,
   1.893921532414584e-11,   2.187575522573964e-14,  -1.426271116451539e-14,  -3.871377528178600e-16,   1.447511665107844e-18,   2.798348652809794e-01,  -2.927671356060925e-03,
   2.100996756025247e-05,  -1.135926563193476e-07,   1.106550376105992e-09,   1.892655793043228e-11,   2.141911152757125e-14,  -1.426045473608711e-14,  -3.865672208558607e-16,
   1.461193746234840e-18,   2.798350125879066e-01,  -2.927673742333812e-03,   2.101001409412204e-05,  -1.135913335061846e-07,   1.106552491293579e-09,   1.892445985200993e-11,
   2.134343803015214e-14,  -1.426008003356813e-14,  -3.864726575681734e-16,   1.463460432759837e-18,   3.968436499103737e-01,  -4.109071262339064e-03,   2.793771178659772e-05,
  -1.263395693507158e-07,   1.183532961647198e-09,   3.307970719488131e-11,   2.364371950410063e-14,  -2.153350133831201e-14,  -6.058363097520122e-16,   1.639922730747033e-18,
   3.968476276844232e-01,  -4.109125035196324e-03,   2.793872245341650e-05,  -1.262930362361468e-07,   1.183555563047290e-09,   3.301552408922485e-11,   2.129031012648051e-14,
  -2.152318006787583e-14,  -6.029118908799447e-16,   1.711912540852060e-18,   3.968541579484564e-01,  -4.109213297814948e-03,   2.794038163174885e-05,  -1.262167105399381e-07,
   1.183589068147236e-09,   3.291018066428992e-11,   1.743520766594017e-14,  -2.150597331901195e-14,  -5.981148632535953e-16,   1.829584474958180e-18,   3.968610872049033e-01,
  -4.109306931947732e-03,   2.794214215403790e-05,  -1.261358126843157e-07,   1.183619735724117e-09,   3.279843543681464e-11,   1.335605596072561e-14,  -2.148735961441211e-14,
  -5.930301493940115e-16,   1.953749759868569e-18,   3.968665406686647e-01,  -4.109380608517642e-03,   2.794352769761706e-05,  -1.260722105138813e-07,   1.183640340740967e-09,
   3.271051497495215e-11,   1.015399834934944e-14,  -2.147245357941644e-14,  -5.890323167860486e-16,   2.050966799868429e-18,   3.968696880103387e-01,  -4.109423123103996e-03,
   2.794432732291651e-05,  -1.260355304559192e-07,   1.183650818921151e-09,   3.265978390444970e-11,   8.309336165948082e-15,  -2.146374828341311e-14,  -5.867266462176262e-16,
   2.106871746596664e-18,   3.968708698762022e-01,  -4.109439086695280e-03,   2.794462759032108e-05,  -1.260217616429284e-07,   1.183654486656878e-09,   3.264073569699226e-11,
   7.617272202927367e-15,  -2.146045997262635e-14,  -5.858611391887966e-16,   2.127826659546799e-18,   3.968710657877959e-01,  -4.109441732833194e-03,   2.794467736394852e-05,
  -1.260194795242909e-07,   1.183655080560401e-09,   3.263757827988033e-11,   7.502585663400121e-15,  -2.145991386614535e-14,  -5.857176846060661e-16,   2.131298234824720e-18,
   5.384369080080955e-01,  -5.494901702473354e-03,   3.442152856837318e-05,  -1.063024583695215e-07,   9.320115215059182e-10,   5.439474860600748e-11,   1.912274963001368e-14,
  -3.195564771364891e-14,  -8.938116317514770e-16,   2.236107263450680e-18,   5.384418080447512e-01,  -5.494946814862151e-03,   3.442232433882243e-05,  -1.062258547305201e-07,
   9.320112315637617e-10,   5.429948552333319e-11,   1.565114334847011e-14,  -3.194130881268491e-14,  -8.894750614731472e-16,   2.344214944855207e-18,   5.384498523300287e-01,
  -5.495020850702261e-03,   3.442363071165812e-05,  -1.061001953397493e-07,   9.320054471633706e-10,   5.414312858481102e-11,   9.964397025793184e-15,  -3.191737462669029e-14,
  -8.823614306604728e-16,   2.520929323427929e-18,   5.384583880500227e-01,  -5.495099376600861e-03,   3.442501685456496e-05,  -1.059669940219517e-07,   9.319921054003912e-10,
   5.397726686915659e-11,   3.947241172052715e-15,  -3.189144390938474e-14,  -8.748209105585026e-16,   2.707402540067531e-18,   5.384651057873102e-01,  -5.495161153848559e-03,
   3.442610774070294e-05,  -1.058622601708031e-07,   9.319763976780048e-10,   5.384676583022380e-11,  -7.760474970253395e-16,  -3.187065037540172e-14,  -8.688920156257681e-16,
   2.853409844613656e-18,   5.384689827572487e-01,  -5.495196797472062e-03,   3.442673730570728e-05,  -1.058018548083759e-07,   9.319652476638165e-10,   5.377146447731635e-11,
  -3.497043828776728e-15,  -3.185849572172297e-14,  -8.654725649332990e-16,   2.937373917086028e-18,   5.384704386041347e-01,  -5.495210180262280e-03,   3.442697371230246e-05,
  -1.057791792876297e-07,   9.319606670007774e-10,   5.374319060771177e-11,  -4.517878016043099e-15,  -3.185390241177366e-14,  -8.641889502342752e-16,   2.968846667064518e-18,
   5.384706799319177e-01,  -5.495212398559281e-03,   3.442701290000829e-05,  -1.057754208802440e-07,   9.319598869276172e-10,   5.373850394331362e-11,  -4.687046998357069e-15,
  -3.185313947002651e-14,  -8.639761950770246e-16,   2.974060741079216e-18,   7.078594830732250e-01,  -7.072712801751723e-03,   3.870654577613967e-05,  -2.015927259841447e-08,
   1.194448949038356e-10,   8.509968071032318e-11,   7.812870071770734e-14,  -4.816411807167507e-14,  -1.310791760121005e-15,   2.978618835830061e-18,   7.078649915052924e-01,
  -7.072720984867413e-03,   3.870664833693789e-05,  -2.003938173100092e-08,   1.195513982404632e-10,   8.495606645844830e-11,   7.303879705642949e-14,  -4.814451179525119e-14,
  -1.304371025802012e-15,   3.141589992239631e-18,   7.078740344989193e-01,  -7.072734382065561e-03,   3.870681675375262e-05,  -1.984270904183536e-08,   1.197184584661548e-10,
   8.472034557085119e-11,   6.470134275367044e-14,  -4.811173004886067e-14,  -1.293838203211481e-15,   3.407995189022152e-18,   7.078836298289238e-01,  -7.072748547660288e-03,
   3.870699551782515e-05,  -1.963422465491907e-08,   1.198851611317185e-10,   8.447028955088700e-11,   5.587971680522120e-14,  -4.807613990961407e-14,  -1.282672809459119e-15,
   3.689126074566017e-18,   7.078911814148205e-01,  -7.072759659971535e-03,   3.870713624807580e-05,  -1.947029151970939e-08,   1.200087226754301e-10,   8.427353963014952e-11,
   4.895518314406223e-14,  -4.804754840242233e-14,  -1.273893423279240e-15,   3.909259650723924e-18,   7.078955395870232e-01,  -7.072766058644927e-03,   3.870721748241274e-05,
  -1.937574068720217e-08,   1.200769762655518e-10,   8.416000981455154e-11,   4.496616439753321e-14,  -4.803081503359789e-14,  -1.268829828357115e-15,   4.035855313844745e-18,
   7.078971761248383e-01,  -7.072768458678329e-03,   3.870724798968791e-05,  -1.934024690620746e-08,   1.201020289939856e-10,   8.411738174113011e-11,   4.346962096556547e-14,
  -4.802448758462997e-14,  -1.266928997728523e-15,   4.083308664866202e-18,   7.078974474044492e-01,  -7.072768856374107e-03,   3.870725304686038e-05,  -1.933436388406816e-08,
   1.201061514055358e-10,   8.411031571302080e-11,   4.322161988085374e-14,  -4.802343640506564e-14,  -1.266613939530935e-15,   4.091170276221655e-18,   9.098652752485507e-01,
  -8.796766369416521e-03,   3.709187184691001e-05,   1.953640253552788e-07,  -1.435333040643801e-09,   1.219755277048419e-10,   4.212579789169205e-13,  -7.593482600270074e-14,
  -1.977087976016929e-15,   4.354430087583087e-18,   9.098705512390481e-01,  -8.796682358099241e-03,   3.709065083095971e-05,   1.955356940315367e-07,  -1.434524714343568e-09,
   1.217490780789619e-10,   4.135817260482622e-13,  -7.590575328127974e-14,  -1.967359266440765e-15,   4.608049005638062e-18,   9.098792125066933e-01,  -8.796544387396814e-03,
   3.708864680570606e-05,   1.958172832416536e-07,  -1.433209452004673e-09,   1.213773915241302e-10,   4.010078683174058e-13,  -7.585709983635405e-14,  -1.951399249035771e-15,
   5.022649786572678e-18,   9.098884026117567e-01,  -8.796397918465749e-03,   3.708652101490738e-05,   1.961157549320446e-07,  -1.431829783757371e-09,   1.209830957183748e-10,
   3.877040067417495e-13,  -7.580421999740395e-14,  -1.934479823693128e-15,   5.460189135811817e-18,   9.098956351501668e-01,  -8.796282595016941e-03,   3.708484846296419e-05,
   1.963504247968726e-07,  -1.430755490463691e-09,   1.206728505679845e-10,   3.772612771712361e-13,  -7.576169758930842e-14,  -1.921175380446791e-15,   5.802810351639529e-18,
   9.098998091403868e-01,  -8.796216018913651e-03,   3.708388338253975e-05,   1.964857656111239e-07,  -1.430140103623809e-09,   1.204938294509674e-10,   3.712455841064852e-13,
  -7.573679494693858e-14,  -1.913501659523154e-15,   5.999853006235944e-18,   9.099013765059359e-01,  -8.796191015016193e-03,   3.708352101952439e-05,   1.965365700915595e-07,
  -1.429909890136490e-09,   1.204266104584522e-10,   3.689887120510732e-13,  -7.572737542027436e-14,  -1.910620961501695e-15,   6.073713987888443e-18,   9.099016363187208e-01,
  -8.796186870056120e-03,   3.708346095447333e-05,   1.965449907466041e-07,  -1.429871774855011e-09,   1.204154682243221e-10,   3.686147129458897e-13,  -7.572581039649599e-14,
  -1.910143490054112e-15,   6.085950620229640e-18,   1.151621776997676e+00,  -1.051363290751064e-02,   2.072384746093046e-05,   6.603633069546393e-07,  -2.822587609018538e-09,
   1.310044545490232e-10,   1.751723755649982e-12,  -1.247360307921394e-13,  -3.383537988247466e-15,   9.388671376505011e-18,   1.151624721347888e+00,  -1.051335033693586e-02,
   2.072145763723626e-05,   6.605465977531311e-07,  -2.819004112801135e-09,   1.306326577891099e-10,   1.738572138905557e-12,  -1.246766687153519e-13,  -3.367597737528453e-15,
   9.810975207293781e-18,   1.151629554732811e+00,  -1.051288639576833e-02,   2.071753651700768e-05,   6.608471172684605e-07,  -2.813141338987769e-09,   1.300224287134756e-10,
   1.717027441086032e-12,  -1.245776747818904e-13,  -3.341446218645233e-15,   1.050130600536610e-17,   1.151634682998376e+00,  -1.051239404250685e-02,   2.071337883716273e-05,
   6.611654726186250e-07,  -2.806947782378180e-09,   1.293751144356821e-10,   1.694229083061321e-12,  -1.244705455496556e-13,  -3.313720727812968e-15,   1.122979500821958e-17,
   1.151638718731921e+00,  -1.051200650305312e-02,   2.071010883867140e-05,   6.614156441854398e-07,  -2.802093156005361e-09,   1.288658107387671e-10,   1.676331691094145e-12,
  -1.243847264693254e-13,  -3.291917650243271e-15,   1.180022209247823e-17,   1.151641047737132e+00,  -1.051178282448636e-02,   2.070822250561683e-05,   6.615598724835918e-07,
  -2.799299357053236e-09,   1.285719366145475e-10,   1.666020801522509e-12,  -1.243345957389442e-13,  -3.279341548337812e-15,   1.212826600995052e-17,   1.151641922283695e+00,
  -1.051169882680974e-02,   2.070751432868565e-05,   6.616140031803135e-07,  -2.798251749919894e-09,   1.284615944093643e-10,   1.662152369849142e-12,  -1.243156573879887e-13,
  -3.274620403950652e-15,   1.225123047187261e-17,   1.151642067251354e+00,  -1.051168490277360e-02,   2.070739694665240e-05,   6.616229746165980e-07,  -2.798078172731107e-09,
   1.284433041621152e-10,   1.661511301793374e-12,  -1.243125120882057e-13,  -3.273837875794745e-15,   1.227160202525426e-17,   1.443989863538512e+00,  -1.164382612358551e-02,
  -3.533716544775770e-05,   1.496549040435730e-06,   6.975964509107231e-09,  -6.476104063312073e-11,   3.732535500213294e-12,  -1.408660478779180e-13,  -8.014585221136629e-15,
   2.723119886577609e-18,   1.443984846865275e+00,  -1.164318755265117e-02,  -3.533116619387423e-05,   1.496453332430982e-06,   6.983562944178716e-09,  -6.518138040622050e-11,
   3.701372370581780e-12,  -1.408293488335626e-13,  -7.977344609497755e-15,   3.576190562832726e-18,   1.443976611807829e+00,  -1.164213926544790e-02,  -3.532131287484518e-05,
   1.496295780185441e-06,   6.995989335479026e-09,  -6.587134223577490e-11,   3.650320020182879e-12,  -1.407659887553617e-13,  -7.916256990738842e-15,   4.970529958293226e-18,
   1.443967874623102e+00,  -1.164102699299806e-02,  -3.531085154284048e-05,   1.496128017920385e-06,   7.009110000371443e-09,  -6.660331374158436e-11,   3.596294833729909e-12,
  -1.406945408528410e-13,  -7.851505177910146e-15,   6.441727532782312e-18,   1.443960999026740e+00,  -1.164015165868885e-02,  -3.530261394387445e-05,   1.495995563067174e-06,
   7.019389261319909e-09,  -6.717928121786399e-11,   3.553881869469867e-12,  -1.406352667938753e-13,  -7.800593930681998e-15,   7.593559516598619e-18,   1.443957031231786e+00,
  -1.163964649816802e-02,  -3.529785807446437e-05,   1.495918950408637e-06,   7.025302898911303e-09,  -6.751164310860165e-11,   3.529446643793609e-12,  -1.405998415191628e-13,
  -7.771231719328691e-15,   8.255897310271148e-18,   1.443955541331858e+00,  -1.163945680764439e-02,  -3.529607186037694e-05,   1.495890149393248e-06,   7.027519992205648e-09,
  -6.763644059295141e-11,   3.520278933254034e-12,  -1.405863093211801e-13,  -7.760209647605446e-15,   8.504156968026470e-18,   1.443955294362074e+00,  -1.163942536384499e-02,
  -3.529577575201429e-05,   1.495885373514035e-06,   7.027887320659653e-09,  -6.765712715280921e-11,   3.518759673856512e-12,  -1.405840540596387e-13,  -7.758382778590999e-15,
   8.545285572904176e-18,   1.795042642113539e+00,  -9.155616639259389e-03,  -1.912825950362150e-04,  -2.029766375911108e-07,   1.004243905653308e-07,   2.001043835169224e-09,
  -3.358197798242853e-11,  -2.185804721727795e-12,  -1.865438929245641e-14,   1.336951467017804e-15,   1.795015592794678e+00,  -9.155693435990656e-03,  -1.911972594019773e-04,
  -2.001831391128636e-07,   1.003518959686006e-07,   1.994620402450810e-09,  -3.365083725641566e-11,  -2.178994668247779e-12,  -1.838922826161708e-14,   1.335527840557169e-15,
   1.794971195669816e+00,  -9.155818660894476e-03,  -1.910572121363605e-04,  -1.956037208515100e-07,   1.002327810054537e-07,   1.984089981123418e-09,  -3.376312637635971e-11,
  -2.167820433792690e-12,  -1.795551672331112e-14,   1.333150969718048e-15,   1.794924098723487e+00,  -9.155950380940189e-03,  -1.909086723404893e-04,  -1.907535136255484e-07,
   1.001062509940699e-07,   1.972936338891656e-09,  -3.388125085767969e-11,  -2.155971357559840e-12,  -1.749747706335043e-14,   1.330575203667234e-15,   1.794887041745695e+00,
  -9.156053211179580e-03,  -1.907918150607934e-04,  -1.869428192723487e-07,   1.000065704658129e-07,   1.964172801839595e-09,  -3.397347676488529e-11,  -2.146651673352108e-12,
  -1.713855989607096e-14,   1.328509409831120e-15,   1.794865658872374e+00,  -9.156112222444356e-03,  -1.907243922140329e-04,  -1.847461740724721e-07,   9.994900266338892e-08,
   1.959120978918204e-09,  -3.402640668619483e-11,  -2.141275366903740e-12,  -1.693204718139134e-14,   1.327301786148167e-15,   1.794857630039641e+00,  -9.156134318650675e-03,
  -1.906990776252142e-04,  -1.839217995436367e-07,   9.992737779843898e-08,   1.957225062516173e-09,  -3.404622663114636e-11,  -2.139256941001320e-12,  -1.685461770270542e-14,
   1.326845407626410e-15,   1.794856299179920e+00,  -9.156137978084618e-03,  -1.906948815470812e-04,  -1.837851733817579e-07,   9.992379276799174e-08,   1.956910844908142e-09,
  -3.404950913064652e-11,  -2.138922380793273e-12,  -1.684178888592728e-14,   1.326769603396560e-15,   2.140240820851001e-03,  -2.238188044066783e-05,   1.737561520862518e-07,
  -1.072247894778710e-09,   1.487326541022396e-11,   5.241341025856648e-14,  -3.261822046211496e-15,  -1.669605585460022e-16,  -5.700256959305358e-19,   1.169532713735554e-19,
   2.140265573085827e-03,  -2.238233795879864e-05,   1.737688119492382e-07,  -1.072177430947263e-09,   1.486628035204229e-11,   5.192390365750983e-14,  -3.263744517538627e-15,
  -1.663684683495297e-16,  -5.531080160365595e-19,   1.166916293455362e-19,   2.140306209182266e-03,  -2.238308902809742e-05,   1.737895908462265e-07,  -1.072062252727874e-09,
   1.485481046651330e-11,   5.112157360446908e-14,  -3.266852486447052e-15,  -1.653974382930265e-16,  -5.254471893309960e-19,   1.162603695477977e-19,   2.140349328984011e-03,
  -2.238388594254683e-05,   1.738116329939495e-07,  -1.071940717968780e-09,   1.484263629066545e-11,   5.027197005356860e-14,  -3.270085114828426e-15,  -1.643684381790348e-16,
  -4.962492191361444e-19,   1.158004332225959e-19,   2.140383265770695e-03,  -2.238451309810895e-05,   1.738289760308214e-07,  -1.071845559972504e-09,   1.483305247340878e-11,
   4.960457970722577e-14,  -3.272582166174122e-15,  -1.635595809937967e-16,  -4.733803027556555e-19,   1.154367831770523e-19,   2.140402851865382e-03,  -2.238487503373303e-05,
   1.738389833330180e-07,  -1.071790838862983e-09,   1.482752040240557e-11,   4.921991729261019e-14,  -3.274004451197148e-15,  -1.630931639260945e-16,  -4.602262364620961e-19,
   1.152262456458603e-19,   2.140410206735367e-03,  -2.238501094262778e-05,   1.738427408524961e-07,  -1.071770327647701e-09,   1.482544285511317e-11,   4.907556750315603e-14,
  -3.274534983087478e-15,  -1.629180935412944e-16,  -4.552950672349084e-19,   1.151470609940086e-19,   2.140411425915443e-03,  -2.238503347139174e-05,   1.738433636981458e-07,
  -1.071766929577118e-09,   1.482509846141111e-11,   4.905164445813946e-14,  -3.274622739181112e-15,  -1.628890770181958e-16,  -4.544780937014237e-19,   1.151339283856398e-19,
   1.930579892538022e-02,  -2.017174873226495e-04,   1.558991203715284e-06,  -9.501988221183881e-09,   1.324458199690938e-10,   5.044012151932969e-13,  -2.992047826071669e-14,
  -1.516418942103101e-15,  -5.216336482896172e-18,   1.064126894814352e-18,   1.930602100796154e-02,  -2.017215415346542e-04,   1.559103928670688e-06,  -9.501307878709215e-09,
   1.323817467713809e-10,   4.999554277840590e-13,  -2.993808661012612e-14,  -1.511031562905852e-15,  -5.062283670233720e-18,   1.061750333139436e-18,   1.930638560400826e-02,
  -2.017281969788039e-04,   1.559288945329120e-06,  -9.500195523491084e-09,   1.322765347563791e-10,   4.926685426488390e-13,  -2.996655575755714e-14,  -1.502196226930443e-15,
  -4.810403471133338e-18,   1.057832996318786e-18,   1.930677248428612e-02,  -2.017352586470529e-04,   1.559485208477125e-06,  -9.499021388368002e-09,   1.321648623983628e-10,
   4.849523414451778e-13,  -2.999617031224181e-14,  -1.492833405544434e-15,  -4.544525972491452e-18,   1.053655051249573e-18,   1.930707697245886e-02,  -2.017408160204637e-04,
   1.559639629628228e-06,  -9.498101792560266e-09,   1.320769511346422e-10,   4.788910435137917e-13,  -3.001904873677946e-14,  -1.485473639560159e-15,  -4.336280986807188e-18,
   1.050351656276379e-18,   1.930725270309100e-02,  -2.017440232107161e-04,   1.559728733467933e-06,  -9.497572859820907e-09,   1.320262060864473e-10,   4.753975140536383e-13,
  -3.003208101909294e-14,  -1.481229719697690e-15,  -4.216499687413763e-18,   1.048439098755615e-18,   1.930731869255143e-02,  -2.017452275277124e-04,   1.559762189892025e-06,
  -9.497374577308896e-09,   1.320071489867320e-10,   4.740865213355526e-13,  -3.003694244175083e-14,  -1.479636756585355e-15,  -4.171596319734546e-18,   1.047719765650773e-18,
   1.930732963129445e-02,  -2.017454271597108e-04,   1.559767735617377e-06,  -9.497341726917268e-09,   1.320039899034339e-10,   4.738692510111781e-13,  -3.003774658784724e-14,
  -1.479372735569504e-15,  -4.164156935359737e-18,   1.047600465411208e-18,   5.387323814619684e-02,  -5.618858958660963e-04,   4.302300912058799e-06,  -2.553671089271568e-08,
   3.597579320818847e-10,   1.587815534851213e-12,  -8.632354140323074e-14,  -4.292032106708139e-15,  -1.497861959575399e-17,   3.022288426478462e-18,   5.387385101082175e-02,
  -5.618967904633830e-04,   4.302607041601003e-06,  -2.553455732533559e-08,   3.595730762292285e-10,   1.575233147647187e-12,  -8.637418777479284e-14,  -4.276730489762989e-15,
  -1.454034795957785e-17,   3.015561676883328e-18,   5.387485715864034e-02,  -5.619146750687657e-04,   4.303109488541193e-06,  -2.553103473628137e-08,   3.592695320573802e-10,
   1.554610054361270e-12,  -8.645608645064571e-14,  -4.251635657674958e-15,  -1.382376272979119e-17,   3.004473290561978e-18,   5.387592480184479e-02,  -5.619336511507632e-04,
   4.303642468284609e-06,  -2.552731442963647e-08,   3.589473495535480e-10,   1.532772085172011e-12,  -8.654129905296175e-14,  -4.225042506307097e-15,  -1.306735576873789e-17,
   2.992646497507573e-18,   5.387676507350073e-02,  -5.619485848012849e-04,   4.304061813689246e-06,  -2.552439913591109e-08,   3.586937196026993e-10,   1.515617848303456e-12,
  -8.660714308459270e-14,  -4.204138537022801e-15,  -1.247491003493916e-17,   2.983294829473962e-18,   5.387725002306661e-02,  -5.619572030527539e-04,   4.304303781039306e-06,
  -2.552272171168780e-08,   3.585473167562519e-10,   1.505730766289071e-12,  -8.664465561242586e-14,  -4.192084484098782e-15,  -1.213413866364128e-17,   2.977880312082011e-18,
   5.387743212878730e-02,  -5.619604392446428e-04,   4.304394633663502e-06,  -2.552209277591758e-08,   3.584923357632694e-10,   1.502020517985539e-12,  -8.665864996552376e-14,
  -4.187559967102532e-15,  -1.200639098319676e-17,   2.975843815807889e-18,   5.387746231554037e-02,  -5.619609756872801e-04,   4.304409693336824e-06,  -2.552198857110959e-08,
   3.584832215995481e-10,   1.501405620410793e-12,  -8.666096488123448e-14,  -4.186810063933887e-15,  -1.198522633195208e-17,   2.975506064120065e-18,   1.063332800530168e-01,
  -1.105879616500010e-03,   8.341654642700502e-06,  -4.735085068783291e-08,   6.796512210437992e-10,   3.687165593743973e-12,  -1.790237361931957e-13,  -8.664180628808851e-15,
  -3.084727232343903e-17,   6.130589422512367e-18,   1.063344682943442e-01,  -1.105899813882448e-03,   8.342232786240163e-06,  -4.734581755800832e-08,   6.792678596325849e-10,
   3.661768376955350e-12,  -1.791282678716843e-13,  -8.633140060836277e-15,  -2.995581756889004e-17,   6.117014899305056e-18,   1.063364190439663e-01,  -1.105932969652324e-03,
   8.343181665495106e-06,  -4.733758077764909e-08,   6.786383582521908e-10,   3.620141541018696e-12,  -1.792973400799942e-13,  -8.582232909166586e-15,  -2.849826598662202e-17,
   6.094636913160693e-18,   1.063384890205070e-01,  -1.105968148449617e-03,   8.344188177666039e-06,  -4.732887610267744e-08,   6.779702047440431e-10,   3.576062984507348e-12,
  -1.794733048721571e-13,  -8.528285936740167e-15,  -2.695971545477209e-17,   6.070766402303959e-18,   1.063401181611414e-01,  -1.105995832876467e-03,   8.344980074820098e-06,
  -4.732205092360335e-08,   6.774442184628124e-10,   3.541438574681673e-12,  -1.796093111511779e-13,  -8.485879814454345e-15,  -2.575466573919426e-17,   6.051889884292829e-18,
   1.063410583933926e-01,  -1.106011809511835e-03,   8.345437000657209e-06,  -4.731812216956683e-08,   6.771406035333887e-10,   3.521482448996206e-12,  -1.796868117508532e-13,
  -8.461426673709643e-15,  -2.506152794509691e-17,   6.040959921692154e-18,   1.063414114643624e-01,  -1.106017808786145e-03,   8.345608563179596e-06,  -4.731664880827253e-08,
   6.770265822179887e-10,   3.513993694127790e-12,  -1.797157269188846e-13,  -8.452248111488122e-15,  -2.480168582919455e-17,   6.036848844939516e-18,   1.063414699911621e-01,
  -1.106018803245874e-03,   8.345637001191021e-06,  -4.731640467906829e-08,   6.770076809799587e-10,   3.512752587894745e-12,  -1.797205101596343e-13,  -8.450726835885492e-15,
  -2.475863637490538e-17,   6.036167018828101e-18,   1.774706033119142e-01,  -1.838150136729328e-03,   1.356171623390661e-05,  -7.170317944144042e-08,   1.062260958660099e-09,
   7.447476071511280e-12,  -3.188426207595521e-13,  -1.493862919383382e-14,  -5.443957332827229e-17,   1.063090094091773e-17,   1.774725350598740e-01,  -1.838180712330223e-03,
   1.356261936974834e-05,  -7.169295002589479e-08,   1.061578203005799e-09,   7.403691609989359e-12,  -3.190275342018560e-13,  -1.488479821573555e-14,  -5.288741605847593e-17,
   1.060752513735108e-17,   1.774757064291557e-01,  -1.838230904058536e-03,   1.356410159142396e-05,  -7.167620146278580e-08,   1.060457080689818e-09,   7.331928188484443e-12,
  -3.193266884035651e-13,  -1.479651374702494e-14,  -5.034959780231268e-17,   1.056898526341143e-17,   1.774790716226012e-01,  -1.838284157198224e-03,   1.356567376960402e-05,
  -7.165849059897646e-08,   1.059267122159958e-09,   7.255939007864467e-12,  -3.196381352070647e-13,  -1.470295674907867e-14,  -4.767074689554131e-17,   1.052786927687205e-17,
   1.774817201383973e-01,  -1.838326064690574e-03,   1.356691066674379e-05,  -7.164459592167574e-08,   1.058330359990969e-09,   7.196248970975648e-12,  -3.198789292677989e-13,
  -1.462941378344743e-14,  -4.557257094942077e-17,   1.049535119315329e-17,   1.774832486850734e-01,  -1.838350249119894e-03,   1.356762433775590e-05,  -7.163659459838656e-08,
   1.057789633536180e-09,   7.161846292014192e-12,  -3.200161702518110e-13,  -1.458700561085737e-14,  -4.436571170816949e-17,   1.047652082577589e-17,   1.774838226764331e-01,
  -1.838359330386254e-03,   1.356789229684219e-05,  -7.163359334021259e-08,   1.057586566079283e-09,   7.148936361212303e-12,  -3.200673798747527e-13,  -1.457108752882408e-14,
  -4.391328666970527e-17,   1.046943787529015e-17,   1.774839178240800e-01,  -1.838360835724153e-03,   1.356793671323571e-05,  -7.163309601371649e-08,   1.057552903726438e-09,
   7.146796809910988e-12,  -3.200758514310851e-13,  -1.456844922774788e-14,  -4.383833095438202e-17,   1.046826314513434e-17,   2.684329115308012e-01,  -2.764443379540646e-03,
   1.975676435306027e-05,  -9.312143197164233e-08,   1.458854214872579e-09,   1.386629407943988e-11,  -5.221238693353116e-13,  -2.364425247369837e-14,  -8.816630775272177e-17,
   1.692275351525530e-17,   2.684357255555871e-01,  -2.764483067596083e-03,   1.975800365092772e-05,  -9.310228300607859e-08,   1.457736192583441e-09,   1.379700177998647e-11,
  -5.224239309593244e-13,  -2.355855327676209e-14,  -8.568113609264678e-17,   1.688586906055003e-17,   2.684403453592919e-01,  -2.764548216191541e-03,   1.976003746795626e-05,
  -9.307091758295352e-08,   1.455900342132687e-09,   1.368343170849879e-11,  -5.229094679606707e-13,  -2.341800277221644e-14,  -8.161781378550735e-17,   1.682504836571725e-17,
   2.684452475001124e-01,  -2.764617336055746e-03,   1.976219456576940e-05,  -9.303773243239367e-08,   1.453951776370410e-09,   1.356317560557047e-11,  -5.234150873332463e-13,
  -2.326905672341537e-14,  -7.732868206473850e-17,   1.676015013327559e-17,   2.684491056352299e-01,  -2.764671728091709e-03,   1.976389153293932e-05,  -9.301168496076805e-08,
   1.452417824837913e-09,   1.346871467404423e-11,  -5.238061017128534e-13,  -2.315197258651632e-14,  -7.396927371179169e-17,   1.670881431856576e-17,   2.684513322903591e-01,
  -2.764703116533362e-03,   1.976487061320591e-05,  -9.299668025424635e-08,   1.451532384564476e-09,   1.341427203569417e-11,  -5.240290002798287e-13,  -2.308445616947121e-14,
  -7.203696043965608e-17,   1.667908365613272e-17,   2.684521684309340e-01,  -2.764714902777410e-03,   1.976523821604020e-05,  -9.299105108879997e-08,   1.451199861582112e-09,
   1.339384200299319e-11,  -5.241121793769148e-13,  -2.305911351946974e-14,  -7.131257859759374e-17,   1.666789996670098e-17,   2.684523070337002e-01,  -2.764716856493501e-03,
   1.976529914875261e-05,  -9.299011825099164e-08,   1.451144739488429e-09,   1.339045615627513e-11,  -5.241259400091415e-13,  -2.305491316342250e-14,  -7.119256631995306e-17,
   1.666604508178961e-17,   3.808452860393911e-01,  -3.891262636089055e-03,   2.655653792593918e-05,  -1.023217691835311e-07,   1.791397759360722e-09,   2.442157066179328e-11,
  -8.122394932519851e-13,  -3.572010845418259e-14,  -1.354635662912975e-16,   2.567463411403666e-17,   3.808490682857630e-01,  -3.891306200015567e-03,   2.655805764386366e-05,
  -1.022878973584714e-07,   1.789658575531122e-09,   2.431689770763374e-11,  -8.127008865130022e-13,  -3.559007288460323e-14,  -1.316627655053893e-16,   2.561926903984627e-17,
   3.808552776102252e-01,  -3.891377707007302e-03,   2.656055143189042e-05,  -1.022323980755290e-07,   1.786802753278959e-09,   2.414534000164870e-11,  -8.134475365919591e-13,
  -3.537680662701011e-14,  -1.254483590892160e-16,   2.552795669909628e-17,   3.808618663939032e-01,  -3.891453567547738e-03,   2.656319607264543e-05,  -1.021736540393498e-07,
   1.783771602885967e-09,   2.396368415931674e-11,  -8.142251493493152e-13,  -3.515079841045779e-14,  -1.188886089200672e-16,   2.543049839224925e-17,   3.808670519536599e-01,
  -3.891513260138557e-03,   2.656527636079013e-05,  -1.021275270292141e-07,   1.781385425426257e-09,   2.382099509499208e-11,  -8.148265655151589e-13,  -3.497313486588116e-14,
  -1.137507727619514e-16,   2.535338957473763e-17,   3.808700447026625e-01,  -3.891547705874784e-03,   2.656647651159395e-05,  -1.021009482201366e-07,   1.780008059066282e-09,
   2.373875663009367e-11,  -8.151694281249228e-13,  -3.487068459373248e-14,  -1.107955198876316e-16,   2.530872584068269e-17,   3.808711685212130e-01,  -3.891560639831007e-03,
   2.656692709997729e-05,  -1.020909755448312e-07,   1.779490796062116e-09,   2.370789608704143e-11,  -8.152973788226960e-13,  -3.483222917964850e-14,  -1.096876608915433e-16,
   2.529192353391315e-17,   3.808713548108326e-01,  -3.891562783779292e-03,   2.656700178722156e-05,  -1.020893228494726e-07,   1.779405049777089e-09,   2.370278160836928e-11,
  -8.153185464338604e-13,  -3.482585547223011e-14,  -1.095041158935313e-16,   2.528913669825436e-17,   5.170004316606468e-01,  -5.224297379645255e-03,   3.327038852997285e-05,
  -8.302150949202906e-08,   1.936411663898996e-09,   4.117558666009108e-11,  -1.219981752763918e-12,  -5.294207193674818e-14,  -2.011442159844688e-16,   3.806886495890780e-17,
   5.170051695762407e-01,  -5.224332621219261e-03,   3.327202711990444e-05,  -8.296422063376307e-08,   1.933799520361272e-09,   4.102044880805261e-11,  -1.220665778262806e-12,
  -5.274923574204349e-14,  -1.954482433080361e-16,   3.798780255789469e-17,   5.170129477978765e-01,  -5.224390458595330e-03,   3.327471551603936e-05,  -8.287032999011379e-08,
   1.929510270589470e-09,   4.076617999420264e-11,  -1.221772529451440e-12,  -5.243296897976608e-14,  -1.861352199431426e-16,   3.785407336913013e-17,   5.170212013182907e-01,
  -5.224451804939184e-03,   3.327756591766933e-05,  -8.277091965502178e-08,   1.924957708498509e-09,   4.049694489132044e-11,  -1.222924937472798e-12,  -5.209780140089000e-14,
  -1.763047100807582e-16,   3.771129639698847e-17,   5.170276970458632e-01,  -5.224500067780703e-03,   3.327980760964515e-05,  -8.269283860523929e-08,   1.921373861118603e-09,
   4.028546334147879e-11,  -1.223816049747470e-12,  -5.183432489171269e-14,  -1.686051337846837e-16,   3.759829801752861e-17,   5.170314459228362e-01,  -5.224527914381243e-03,
   3.328110069685543e-05,  -8.264783873887123e-08,   1.919305172557939e-09,   4.016357661182061e-11,  -1.224323994390159e-12,  -5.168238888959265e-14,  -1.641763988581358e-16,
   3.753283267614978e-17,   5.170328536758091e-01,  -5.224538369766700e-03,   3.328158614354002e-05,  -8.263095259733573e-08,   1.918528287993987e-09,   4.011783780735922e-11,
  -1.224513537347649e-12,  -5.162535840343840e-14,  -1.625161669982315e-16,   3.750820239666139e-17,   5.170330870316682e-01,  -5.224540102828464e-03,   3.328166660692358e-05,
  -8.262815409766568e-08,   1.918399504498778e-09,   4.011025757431963e-11,  -1.224544893792641e-12,  -5.161590599800465e-14,  -1.622411075561081e-16,   3.750411707982333e-17,
   6.801866185625661e-01,  -6.763868187165947e-03,   3.853114785955172e-05,  -5.069765444703059e-09,   1.708033607401209e-09,   6.647246049340684e-11,  -1.776264469924172e-12,
  -7.898939413139099e-14,  -2.926123946483547e-16,   5.642413635127365e-17,   6.801921047170264e-01,  -6.763870024640012e-03,   3.853258470061192e-05,  -4.977120604564357e-09,
   1.704230470729645e-09,   6.624096588747782e-11,  -1.777254101251435e-12,  -7.870353434894557e-14,  -2.840618801830180e-16,   5.630574299422572e-17,   6.802011112720578e-01,
  -6.763873013018337e-03,   3.853494115721548e-05,  -4.825265314344996e-09,   1.697985572519530e-09,   6.586154536571020e-11,  -1.778854442661671e-12,  -7.823469530266267e-14,
  -2.700818201455418e-16,   5.611036174294211e-17,   6.802106681194768e-01,  -6.763876145723310e-03,   3.853743834477452e-05,  -4.664455796021796e-09,   1.691357324454555e-09,
   6.545978663065766e-11,  -1.780519594359332e-12,  -7.773782908713193e-14,  -2.553252102587242e-16,   5.590167149385509e-17,   6.802181895507422e-01,  -6.763878583554964e-03,
   3.853940133086975e-05,  -4.538129770517228e-09,   1.686139478126623e-09,   6.514420509020120e-11,  -1.781806302485484e-12,  -7.734723473841333e-14,  -2.437675449880587e-16,
   5.573644284690864e-17,   6.802225303727411e-01,  -6.763879979412532e-03,   3.854053328099545e-05,  -4.465317422820404e-09,   1.683127608939562e-09,   6.496231906533404e-11,
  -1.782539379807706e-12,  -7.712199278627104e-14,  -2.371197461651821e-16,   5.564069251476679e-17,   6.802241604053244e-01,  -6.763880501481163e-03,   3.854095816419623e-05,
  -4.437993205340264e-09,   1.681996519148139e-09,   6.489406482618359e-11,  -1.782812863438913e-12,  -7.703744583926250e-14,  -2.346276526353353e-16,   5.560466320857760e-17,
   6.802244306071245e-01,  -6.763880587911296e-03,   3.854102858541881e-05,  -4.433464750398720e-09,   1.681809019408536e-09,   6.488275312333401e-11,  -1.782858102680690e-12,
  -7.702343274907629e-14,  -2.342147750312964e-16,   5.559868693332435e-17,   8.752862201795013e-01,  -8.490859450973689e-03,   3.937846004096330e-05,   1.916191299060811e-07,
   8.984837798869078e-10,   1.000564723829830e-10,  -2.467664699655495e-12,  -1.223639984509073e-13,  -4.300227907484540e-16,   8.617048952926602e-17,   8.752918255056341e-01,
  -8.490777152775486e-03,   3.937919725859239e-05,   1.917584953624202e-07,   8.931995408951603e-10,   9.969776096976965e-11,  -2.469106270257859e-12,  -1.219273584496506e-13,
  -4.168358213363494e-16,   8.599265241949621e-17,   8.753010276269469e-01,  -8.490642004660270e-03,   3.938040425442679e-05,   1.919869202561338e-07,   8.845225266829384e-10,
   9.910981808651552e-11,  -2.471435372594878e-12,  -1.212112141820327e-13,  -3.952760794256645e-16,   8.569904596299344e-17,   8.753107918856249e-01,  -8.490498544630855e-03,
   3.938168053057817e-05,   1.922287997481455e-07,   8.753127474754377e-10,   9.848724192058054e-11,  -2.473855946100713e-12,  -1.204522449560898e-13,  -3.725199940152805e-16,
   8.538526920210231e-17,   8.753184764784285e-01,  -8.490385599297920e-03,   3.938268175163131e-05,   1.924188007708520e-07,   8.680626026944239e-10,   9.799819492066333e-11,
  -2.475724290599537e-12,  -1.198555973898804e-13,  -3.546978813626833e-16,   8.513671753928256e-17,   8.753229114351820e-01,  -8.490320399703781e-03,   3.938325828698831e-05,
   1.925283101441416e-07,   8.638776086916948e-10,   9.771632639557010e-11,  -2.476787889773370e-12,  -1.195115279034617e-13,  -3.444472263138558e-16,   8.499263313597168e-17,
   8.753245768108265e-01,  -8.490295913465732e-03,   3.938347453811433e-05,   1.925694048142998e-07,   8.623059527760531e-10,   9.761055188212986e-11,  -2.477184515422828e-12,
  -1.193823770487645e-13,  -3.406045806498101e-16,   8.493840745497156e-17,   8.753248528709560e-01,  -8.490291854355569e-03,   3.938351037198060e-05,   1.925762154101818e-07,
   8.620454204719482e-10,   9.759302193051049e-11,  -2.477250115965026e-12,  -1.193609711208829e-13,  -3.399679539390805e-16,   8.492941242414920e-17,   1.109948203683169e+00,
  -1.031670521776137e-02,   2.846735061600129e-05,   6.370509651882635e-07,  -1.240062840835083e-10,   1.200154161095679e-10,  -3.042513667451810e-12,  -2.040355962397085e-13,
  -7.564447840014881e-16,   1.443641641628008e-16,   1.109952254508326e+00,  -1.031643266207322e-02,   2.846720775377206e-05,   6.372167170093026e-07,  -1.305306861769271e-10,
   1.194173389780822e-10,  -3.045078063866409e-12,  -2.033040487002963e-13,  -7.346291205202927e-16,   1.440675202560978e-16,   1.109958904572970e+00,  -1.031598516781544e-02,
   2.846696918666116e-05,   6.374882151432673e-07,  -1.412452673145551e-10,   1.184370733939889e-10,  -3.049225971567077e-12,  -2.021042155159334e-13,  -6.989659946154335e-16,
   1.435775939347336e-16,   1.109965960777546e+00,  -1.031551027398792e-02,   2.846671056256454e-05,   6.377754670755871e-07,  -1.526192688559753e-10,   1.173990748152205e-10,
  -3.053543244949170e-12,  -2.008326284663749e-13,  -6.613292522026956e-16,   1.430537804921434e-16,   1.109971514027194e+00,  -1.031513648101588e-02,   2.846650305114620e-05,
   6.380009366422323e-07,  -1.615742493764393e-10,   1.165837120934023e-10,  -3.056880345903474e-12,  -1.998329941588744e-13,  -6.318567673449440e-16,   1.426386888934579e-16,
   1.109974718907907e+00,  -1.031492073815324e-02,   2.846638169941753e-05,   6.381308195722337e-07,  -1.667437660430452e-10,   1.161137703340314e-10,  -3.058782015409260e-12,
  -1.992565326460669e-13,  -6.149067784756132e-16,   1.423979972157405e-16,   1.109975922370918e+00,  -1.031483972085600e-02,   2.846633582953961e-05,   6.381795465751518e-07,
  -1.686852381975789e-10,   1.159374196773204e-10,  -3.059491537499210e-12,  -1.990401502796188e-13,  -6.085530589039944e-16,   1.423074015875880e-16,   1.109976121862055e+00,
  -1.031482629088384e-02,   2.846632821006570e-05,   6.381876213827178e-07,  -1.690070790564277e-10,   1.159081932107367e-10,  -3.059608909834766e-12,  -1.990042862758509e-13,
  -6.075004279087529e-16,   1.422923728229626e-16,   1.396965480376191e+00,  -1.185286716322968e-02,  -1.674074169927126e-05,   1.600826360332030e-06,   6.114298260201164e-09,
  -4.956184137734542e-11,  -3.414668451568579e-12,  -3.422520790867926e-13,  -2.759816360543266e-15,   3.023202458683275e-16,   1.396963108458943e+00,  -1.185218401571117e-02,
  -1.673556306531328e-05,   1.600747422678972e-06,   6.106891371213851e-09,  -5.056026720796958e-11,  -3.424708609015167e-12,  -3.407238919872984e-13,  -2.713407397267318e-15,
   3.015578075031974e-16,   1.396959215098657e+00,  -1.185106254478028e-02,  -1.672706610716387e-05,   1.600616816917154e-06,   6.094716778662075e-09,  -5.219605750106787e-11,
  -3.441059368627187e-12,  -3.382179924825997e-13,  -2.637546278541585e-15,   3.003003150059825e-16,   1.396955084656742e+00,  -1.184987261333017e-02,  -1.671805644482800e-05,
   1.600476853998366e-06,   6.081778338647671e-09,  -5.392729315024679e-11,  -3.458230196477306e-12,  -3.355629473995841e-13,  -2.557494901145965e-15,   2.989581647282761e-16,
   1.396951834494179e+00,  -1.184893615713865e-02,  -1.671097033449498e-05,   1.600365704656562e-06,   6.071581138642791e-09,  -5.528655514124049e-11,  -3.471614825503952e-12,
  -3.334762514649017e-13,  -2.494814189365906e-15,   2.978962502660514e-16,   1.396949958968951e+00,  -1.184839572046941e-02,  -1.670688262327270e-05,   1.600301158711485e-06,
   6.065690319244326e-09,  -5.606971813718985e-11,  -3.479287818412541e-12,  -3.322731191999656e-13,  -2.458768024335774e-15,   2.972811565729671e-16,   1.396949254729722e+00,
  -1.184819278311789e-02,  -1.670534799151375e-05,   1.600276845616908e-06,   6.063477162097594e-09,  -5.636355921717655e-11,  -3.482159378027465e-12,  -3.318215470368445e-13,
  -2.445256515697041e-15,   2.970497609859350e-16,   1.396949137994054e+00,  -1.184815914345228e-02,  -1.670509362250837e-05,   1.600272811394510e-06,   6.063110241891379e-09,
  -5.641225469088937e-11,  -3.482634867455677e-12,  -3.317467038888057e-13,  -2.443018064926316e-15,   2.970113816524858e-16,   1.755386313357331e+00,  -1.066565368230990e-02,
  -1.829570467297012e-04,   1.658846897604799e-06,   1.273087389327890e-07,   4.486004230186474e-10,  -9.378084699924667e-11,  -1.728340072080136e-12,   5.343506431187005e-14,
   2.319761642989819e-15,   1.755360493551948e+00,  -1.066494338489686e-02,  -1.828494636568889e-04,   1.659443381672834e-06,   1.271110632081406e-07,   4.436173472972321e-10,
  -9.356938167800564e-11,  -1.716896442288122e-12,   5.336606429551658e-14,   2.303264762783460e-15,   1.755318117048300e+00,  -1.066377714237290e-02,  -1.826729698236219e-04,
   1.660417556661407e-06,   1.267868719798644e-07,   4.354612550257659e-10,  -9.322243181133456e-11,  -1.698170285111245e-12,   5.325174614815027e-14,   2.276271540651287e-15,
   1.755273167090330e+00,  -1.066253943276864e-02,  -1.824858608256747e-04,   1.661444381672826e-06,   1.264433221881502e-07,   4.268401461681852e-10,  -9.285457098397773e-11,
  -1.678382311436417e-12,   5.312903739343266e-14,   2.247750524282467e-15,   1.755237801938559e+00,  -1.066156517847897e-02,  -1.823387241497621e-04,   1.662247549493226e-06,
   1.261732666913782e-07,   4.200792234088535e-10,  -9.256526642372741e-11,  -1.662868247778457e-12,   5.303145291380474e-14,   2.225391708995505e-15,   1.755217396305834e+00,
  -1.066100284921633e-02,  -1.822538564052149e-04,   1.662709093113037e-06,   1.260175406069920e-07,   4.161869387796181e-10,  -9.239838522960444e-11,  -1.653938452306021e-12,
   5.297473183386977e-14,   2.212522975656751e-15,   1.755209734598087e+00,  -1.066079167614772e-02,  -1.822219967372127e-04,   1.662882033464546e-06,   1.259590881438733e-07,
   4.147271550016008e-10,  -9.233573525332282e-11,  -1.650589694419319e-12,   5.295335659919335e-14,   2.207697243478810e-15,   1.755208464603100e+00,  -1.066075667051223e-02,
  -1.822167160166553e-04,   1.662910681090258e-06,   1.259494000895471e-07,   4.144852702620339e-10,  -9.232535094566193e-11,  -1.650034825496897e-12,   5.294980935100897e-14,
   2.206897657607949e-15,   2.053417678667104e-03,  -2.103920940847991e-05,   1.623335157692494e-07,  -8.317129985085945e-10,   1.476831247000573e-11,  -7.949023091380357e-14,
  -7.434865082338779e-15,  -1.016661986882877e-16,   4.924815768266813e-18,   1.595156004731681e-19,   2.053440805097458e-03,  -2.103956489386179e-05,   1.623460371052081e-07,
  -8.318285672514737e-10,   1.475267216248757e-11,  -7.978155240697646e-14,  -7.415457185335322e-15,  -1.008799033918786e-16,   4.914467430501737e-18,   1.583581789285165e-19,
   2.053478772150633e-03,  -2.104014851689505e-05,   1.623665833259962e-07,  -8.320185865263021e-10,   1.472702589410021e-11,  -8.025812539347120e-14,  -7.383626019410911e-15,
  -9.959331004515345e-17,   4.897437741244523e-18,   1.564644614312988e-19,   2.053519059860857e-03,  -2.104076783535396e-05,   1.623883714461458e-07,  -8.322206109506951e-10,
   1.469985373386022e-11,  -8.076153007399772e-14,  -7.349891579770008e-15,  -9.823388148560857e-17,   4.879312423777960e-18,   1.544637317501669e-19,   2.053550767754448e-03,
  -2.104125527797852e-05,   1.624055094008825e-07,  -8.323798935956191e-10,   1.467849841315347e-11,  -8.115606815876575e-14,  -7.323372051743448e-15,  -9.716815452511759e-17,
   4.865007924603164e-18,   1.528953976736113e-19,   2.053569067502380e-03,  -2.104153660498895e-05,   1.624153962801587e-07,  -8.324719340729290e-10,   1.466618558313901e-11,
  -8.138310607280162e-14,  -7.308079016228451e-15,  -9.655476304390897e-17,   4.856736705854530e-18,   1.519927827749562e-19,   2.053575939334664e-03,  -2.104164224879079e-05,
   1.624191081894702e-07,  -8.325065179607322e-10,   1.466156421182162e-11,  -8.146823690215891e-14,  -7.302338580970709e-15,  -9.632474187861318e-17,   4.853627808002356e-18,
   1.516543141860581e-19,   2.053577078444236e-03,  -2.104165976090620e-05,   1.624197234540074e-07,  -8.325122518831026e-10,   1.466079827040835e-11,  -8.148234200913493e-14,
  -7.301387140490756e-15,  -9.628662910347504e-17,   4.853112307230457e-18,   1.515982330753441e-19,   1.852320214797604e-02,  -1.896651859471320e-04,   1.457849515144011e-06,
  -7.355429022806442e-09,   1.319885191189721e-10,  -7.007542072014274e-13,  -6.782605979566520e-14,  -9.230957232864045e-16,   4.479656265639177e-17,   1.452250967525109e-18,
   1.852340983566583e-02,  -1.896683297478650e-04,   1.457961405360827e-06,  -7.356448474485334e-09,   1.318458311272540e-10,  -7.033990068862268e-13,  -6.764952362511443e-14,
  -9.159372958309401e-16,   4.470244513794109e-17,   1.441709593305859e-18,   1.852375080001126e-02,  -1.896734911254494e-04,   1.458145003871109e-06,  -7.358124742744080e-09,
   1.316118570114065e-10,  -7.077255936049429e-13,  -6.735998413465875e-14,  -9.042241734341042e-16,   4.454755929527082e-17,   1.424462311208096e-18,   1.852411260501133e-02,
  -1.896789681811936e-04,   1.458339697403390e-06,  -7.359907017701862e-09,   1.313639608984809e-10,  -7.122957150999081e-13,  -6.705313224445316e-14,  -8.918479814891795e-16,
   4.438270619949081e-17,   1.406240412206607e-18,   1.852439735865006e-02,  -1.896832789683030e-04,   1.458492836382717e-06,  -7.361312295218284e-09,   1.311691319816256e-10,
  -7.158774574625455e-13,  -6.681190790342281e-14,  -8.821456541851074e-16,   4.425260238518705e-17,   1.391956618858066e-18,   1.852456170003249e-02,  -1.896857669344039e-04,
   1.458581181491433e-06,  -7.362124355483515e-09,   1.310567992209022e-10,  -7.179385630963348e-13,  -6.667280087997097e-14,  -8.765613735408675e-16,   4.417737240919351e-17,
   1.383735947119890e-18,   1.852462341270417e-02,  -1.896867012143506e-04,   1.458614349460840e-06,  -7.362429489845674e-09,   1.310146373345730e-10,  -7.187113983686881e-13,
  -6.662058528935301e-14,  -8.744672752773813e-16,   4.414909563321333e-17,   1.380653305109877e-18,   1.852463364250759e-02,  -1.896868560858879e-04,   1.458619847183829e-06,
  -7.362480080654774e-09,   1.310076494629520e-10,  -7.188394472781524e-13,  -6.661193088864170e-14,  -8.741202990234080e-16,   4.414440692291521e-17,   1.380142539909098e-18,
   5.169273074887236e-02,  -5.285939161931637e-04,   4.030969641236710e-06,  -1.967947420279356e-08,   3.612718702066223e-10,  -1.862855648749018e-12,  -1.936315288163696e-13,
  -2.611056707178696e-15,   1.271648514825693e-16,   4.129660175782939e-18,   5.169330500111326e-02,  -5.286023273944406e-04,   4.031275805894111e-06,  -1.968218803824022e-08,
   3.608644872542370e-10,  -1.870334995016311e-12,  -1.931303908610811e-13,  -2.590701467354919e-15,   1.268977545859803e-16,   4.099659743600434e-18,   5.169424776025637e-02,
  -5.286161365950213e-04,   4.031778175216623e-06,  -1.968665079764757e-08,   3.601964723972083e-10,  -1.882570103599376e-12,  -1.923084671919635e-13,  -2.557394886133585e-15,
   1.264581921959282e-16,   4.050574548712897e-18,   5.169524814290016e-02,  -5.286307903839231e-04,   4.032310889047315e-06,  -1.969139637983070e-08,   3.594887030968917e-10,
  -1.895493578092142e-12,  -1.914373981341410e-13,  -2.522202975904593e-15,   1.259903287645225e-16,   3.998715693202452e-18,   5.169603547993527e-02,  -5.286423238335085e-04,
   4.032729892500242e-06,  -1.969513857989249e-08,   3.589324418192135e-10,  -1.905621861071258e-12,  -1.907526277018423e-13,  -2.494614337018298e-15,   1.256210757954141e-16,
   3.958064591219252e-18,   5.169648987981185e-02,  -5.286489803501174e-04,   4.032971609392586e-06,  -1.969730123754601e-08,   3.586117157829308e-10,  -1.911450064631035e-12,
  -1.903577405670660e-13,  -2.478735431030551e-15,   1.254075584729567e-16,   3.934668909893418e-18,   5.169666051380422e-02,  -5.286514800020919e-04,   4.033062357937605e-06,
  -1.969811389588359e-08,   3.584913372592639e-10,  -1.913635398777241e-12,  -1.902095146491295e-13,  -2.472780868128034e-15,   1.253273027162217e-16,   3.925895845994489e-18,
   5.169668879895327e-02,  -5.286518943585525e-04,   4.033077399829408e-06,  -1.969824863510074e-08,   3.584713858178187e-10,  -1.913997479723101e-12,  -1.901849471492881e-13,
  -2.471794242432299e-15,   1.253139950773468e-16,   3.924442230848843e-18,   1.020398953641116e-01,  -1.041230674741753e-03,   7.840144495290754e-06,  -3.620145909366578e-08,
   6.911954336460025e-10,  -3.393889674186913e-12,  -3.956996850139385e-13,  -5.265745888755938e-15,   2.578048091674429e-16,   8.392953464470824e-18,   1.020410122515341e-01,
  -1.041246147478003e-03,   7.840729957006196e-06,  -3.620641556138975e-08,   6.903628213562527e-10,  -3.408968326732149e-12,  -3.946837091168924e-13,  -5.224378970637909e-15,
   2.572635923844032e-16,   8.331897627972022e-18,   1.020428458625190e-01,  -1.041271550038257e-03,   7.841690577174990e-06,  -3.621456764299258e-08,   6.889975149702623e-10,
  -3.433634077984470e-12,  -3.930173916102387e-13,  -5.156692019419515e-15,   2.563728768663271e-16,   8.232001318629138e-18,   1.020447915463673e-01,  -1.041298506240216e-03,
   7.842709176829668e-06,  -3.622323829171575e-08,   6.875509401588663e-10,  -3.459686605997619e-12,  -3.912514389692810e-13,  -5.085174061675614e-15,   2.554247686095016e-16,
   8.126460399972270e-18,   1.020463228683174e-01,  -1.041319722451342e-03,   7.843510319070301e-06,  -3.623007705768409e-08,   6.864140126364807e-10,  -3.480103593268030e-12,
  -3.898631763383787e-13,  -5.029107993109061e-15,   2.546764590803260e-16,   8.043729196556247e-18,   1.020472066476166e-01,  -1.041331967359023e-03,   7.843972473217338e-06,
  -3.623402981117953e-08,   6.857584842707879e-10,  -3.491852034484596e-12,  -3.890626055690492e-13,  -4.996838755156871e-15,   2.542437429660660e-16,   7.996115482142427e-18,
   1.020475385199645e-01,  -1.041336565560386e-03,   7.844145978775815e-06,  -3.623551523591402e-08,   6.855124430018692e-10,  -3.496257159023174e-12,  -3.887621010924647e-13,
  -4.984737869331736e-15,   2.540810935594306e-16,   7.978260997225002e-18,   1.020475935327904e-01,  -1.041337327784241e-03,   7.844174737805630e-06,  -3.623576152571644e-08,
   6.854716642662383e-10,  -3.496987027075653e-12,  -3.887122943915369e-13,  -4.982732846025495e-15,   2.540541236612967e-16,   7.975302675749111e-18,   1.703299593559314e-01,
  -1.732801308361372e-03,   1.280643769518225e-05,  -5.407179613764292e-08,   1.101513902316250e-09,  -5.007568718959490e-12,  -6.925368813124826e-13,  -9.067017862176899e-15,
   4.469079638635080e-16,   1.459383508170577e-17,   1.703317836807283e-01,  -1.732824418791913e-03,   1.280736996935396e-05,  -5.407914035880847e-08,   1.100056499023571e-09,
  -5.033521420890519e-12,  -6.907756594173151e-13,  -8.995094302241032e-15,   4.459705311792322e-16,   1.448744247576611e-17,   1.703347786997989e-01,  -1.732862360621785e-03,
   1.280889955553418e-05,  -5.409122330803633e-08,   1.097666642453279e-09,  -5.075973465304267e-12,  -6.878870508082902e-13,  -8.877409662923463e-15,   4.444276585059940e-16,
   1.431336905674065e-17,   1.703379567751357e-01,  -1.732902622990463e-03,   1.281052135228000e-05,  -5.410407980283574e-08,   1.095134496374682e-09,  -5.120810182475755e-12,
  -6.848257195169286e-13,  -8.753065374850839e-15,   4.427852654236427e-16,   1.412946036189877e-17,   1.703404580302179e-01,  -1.732934311973717e-03,   1.281179683773914e-05,
  -5.411422360515635e-08,   1.093144344133359e-09,  -5.155946543579036e-12,  -6.824191234476176e-13,  -8.655587274436267e-15,   4.414889044269259e-16,   1.398529888896948e-17,
   1.703419015907401e-01,  -1.732952601223685e-03,   1.281253259398844e-05,  -5.412008806091746e-08,   1.091996854029586e-09,  -5.176164266614638e-12,  -6.810313087202464e-13,
  -8.599483377764001e-15,   4.407392428338463e-16,   1.390233084381884e-17,   1.703424436691202e-01,  -1.732959469192572e-03,   1.281280881139542e-05,  -5.412229216071158e-08,
   1.091566161436534e-09,  -5.183744866204002e-12,  -6.805103746005431e-13,  -8.578444617280784e-15,   4.404574542276721e-16,   1.387121901256261e-17,   1.703425335267427e-01,
  -1.732960607665887e-03,   1.281285459488313e-05,  -5.412265762399357e-08,   1.091494778594841e-09,  -5.185000860331697e-12,  -6.804240330858693e-13,  -8.574958660587381e-15,
   4.404107288276239e-16,   1.386606407462973e-17,   2.576847500718970e-01,  -2.610446744481094e-03,   1.878569236435482e-05,  -6.846464715508999e-08,   1.558344181666038e-09,
  -6.269165934520823e-12,  -1.113721355369555e-12,  -1.432620784445467e-14,   7.116706391931155e-16,   2.331709276377528e-17,   2.576874260627838e-01,  -2.610476006350624e-03,
   1.878700968273049e-05,  -6.847391303086005e-08,   1.556000091842177e-09,  -6.310152138975856e-12,  -1.110916693998660e-12,  -1.421130768571025e-14,   7.101796698087558e-16,
   2.314655429102671e-17,   2.576918192684216e-01,  -2.610524047385685e-03,   1.878917083802025e-05,  -6.848916586765377e-08,   1.552156199494820e-09,  -6.377192389975874e-12,
  -1.106316718946186e-12,  -1.402330484486304e-14,   7.077255956239931e-16,   2.286753044009357e-17,   2.576964809805406e-01,  -2.610575026640230e-03,   1.879146204059968e-05,
  -6.850540643864808e-08,   1.548083387221509e-09,  -6.447994714599295e-12,  -1.101441685261857e-12,  -1.382466596037176e-14,   7.051130052770045e-16,   2.257274335034734e-17,
   2.577001499037526e-01,  -2.610615150485358e-03,   1.879326381820082e-05,  -6.851822838745305e-08,   1.544882298548134e-09,  -6.503476307196014e-12,  -1.097609284244032e-12,
  -1.366894762550575e-14,   7.030506980265506e-16,   2.234166837784003e-17,   2.577022673636850e-01,  -2.610638307906771e-03,   1.879430309411589e-05,  -6.852564439765584e-08,
   1.543036584717888e-09,  -6.535399720828563e-12,  -1.095399247271509e-12,  -1.357932416220843e-14,   7.018580412849679e-16,   2.220868027256175e-17,   2.577030625008856e-01,
  -2.610647003969343e-03,   1.879469324577779e-05,  -6.852843224343176e-08,   1.542343821465277e-09,  -6.547369139003741e-12,  -1.094569681164863e-12,  -1.354571584025497e-14,
   7.014097244737179e-16,   2.215881173602699e-17,   2.577031943067823e-01,  -2.610648445477828e-03,   1.879475791336833e-05,  -6.852889453011074e-08,   1.542229002952737e-09,
  -6.549352284919298e-12,  -1.094432185847894e-12,  -1.354014721459108e-14,   7.013353852131512e-16,   2.215054899379747e-17,   3.656980897654298e-01,  -3.683205959297922e-03,
   2.551241477874476e-05,  -7.114754393292955e-08,   2.005519366723879e-09,  -6.563012063325330e-12,  -1.706002202073205e-12,  -2.159724887041016e-14,   1.081625298302249e-15,
   3.554650256088072e-17,   3.657017237718435e-01,  -3.683236368683110e-03,   2.551410685840849e-05,  -7.115740248041446e-08,   2.001928284736725e-09,  -6.624769814035746e-12,
  -1.701739496879177e-12,  -2.142211944988194e-14,   1.079362889052658e-15,   3.528524806262684e-17,   3.657076897524824e-01,  -3.683286293774188e-03,   2.551688248093643e-05,
  -7.117364925279288e-08,   1.996039493830506e-09,  -6.725781392403925e-12,  -1.694748149323562e-12,  -2.113557262659437e-14,   1.075638747333651e-15,   3.485780401524334e-17,
   3.657140203513212e-01,  -3.683339272464776e-03,   2.551982464306939e-05,  -7.119097289331113e-08,   1.989799929785521e-09,  -6.832455631880111e-12,  -1.687338737783744e-12,
  -2.083282128970699e-14,   1.071673635887867e-15,   3.440621651308937e-17,   3.657190027339637e-01,  -3.683380970101544e-03,   2.552213797854517e-05,  -7.120466774928972e-08,
   1.984895798262365e-09,  -6.916042726191006e-12,  -1.681513983030121e-12,  -2.059549115815906e-14,   1.068543387850560e-15,   3.405223369880041e-17,   3.657218782317629e-01,
  -3.683405035879950e-03,   2.552347218378408e-05,  -7.121259574056399e-08,   1.982068107349508e-09,  -6.964136014664852e-12,  -1.678155009046208e-12,  -2.045889804450711e-14,
   1.066733010144592e-15,   3.384851113803711e-17,   3.657229580225062e-01,  -3.683414073056922e-03,   2.552397302752211e-05,  -7.121557738976496e-08,   1.981006768632813e-09,
  -6.982167875080161e-12,  -1.676894173920690e-12,  -2.040767671327753e-14,   1.066052471316901e-15,   3.377211850804839e-17,   3.657231370139490e-01,  -3.683415571110917e-03,
   2.552405604091187e-05,  -7.121607188382212e-08,   1.980830862253867e-09,  -6.985155456352148e-12,  -1.676685198471006e-12,  -2.039918977418275e-14,   1.065939624162661e-15,
   3.375946098964829e-17,   4.966300687618265e-01,  -4.961542840702526e-03,   3.248067997312711e-05,  -4.754030848097405e-08,   2.349493246085683e-09,  -5.132825622273336e-12,
  -2.544157408092774e-12,  -3.193269496102146e-14,   1.610379915525450e-15,   5.302138087838229e-17,   4.966346949739373e-01,  -4.961563165372723e-03,   3.248265576834743e-05,
  -4.754837976269831e-08,   2.344137750778574e-09,  -5.224102822051718e-12,  -2.537810778971957e-12,  -3.167154800664212e-14,   1.607016458737368e-15,   5.262879437484119e-17,
   4.966422898484444e-01,  -4.961596534277434e-03,   3.248589607483785e-05,  -4.756172224638574e-08,   2.335355592682678e-09,  -5.373391825026037e-12,  -2.527401534952078e-12,
  -3.124427022442050e-14,   1.601479347200595e-15,   5.198648423097440e-17,   4.966503488670800e-01,  -4.961631944907306e-03,   3.248932983442243e-05,  -4.757600460687265e-08,
   2.326050292606438e-09,  -5.531043278042027e-12,  -2.516369831135183e-12,  -3.079284434594399e-14,   1.595583231765628e-15,   5.130790657609686e-17,   4.966566915522976e-01,
  -4.961659815908574e-03,   3.249202899754297e-05,  -4.758733512614826e-08,   2.318736558220044e-09,  -5.654569965378875e-12,  -2.507697476628031e-12,  -3.043897738199786e-14,
   1.590928037727709e-15,   5.077600349891249e-17,   4.966603521181656e-01,  -4.961675901874349e-03,   3.249358544598314e-05,  -4.759391027754985e-08,   2.314519499344519e-09,
  -5.725641270239543e-12,  -2.502696367284351e-12,  -3.023531692481194e-14,   1.588235502112056e-15,   5.046988869941863e-17,   4.966617267118248e-01,  -4.961681942516392e-03,
   3.249416966386671e-05,  -4.759638612361055e-08,   2.312936677393996e-09,  -5.752288031068109e-12,  -2.500819134324689e-12,  -3.015894669196953e-14,   1.587223312759958e-15,
   5.035510133919931e-17,   4.966619545711788e-01,  -4.961682943849939e-03,   3.249426649347455e-05,  -4.759679688962948e-08,   2.312674340271444e-09,  -5.756702939769289e-12,
  -2.500507994795260e-12,  -3.014629283691170e-14,   1.587055469182117e-15,   5.033608222234823e-17,   6.537480244825827e-01,  -6.455315494836814e-03,   3.866860964877069e-05,
   2.983452905122341e-08,   2.435766753384449e-09,  -1.547310130905611e-12,  -3.750011288469319e-12,  -4.753653384549055e-14,   2.404261278738809e-15,   7.909797119157220e-17,
   6.537535314015617e-01,  -6.455302769853743e-03,   3.867064475294942e-05,   2.983118557284118e-08,   2.427874344244324e-09,  -1.683179788651117e-12,  -3.740536034807499e-12,
  -4.714712970717822e-14,   2.399234638731273e-15,   7.850560857828065e-17,   6.537625721027790e-01,  -6.455281881030047e-03,   3.867398087082932e-05,   2.982555952012554e-08,
   2.414932239853778e-09,  -1.905400944212246e-12,  -3.724995485520770e-12,  -4.651002816306217e-14,   2.390958672291852e-15,   7.753647042708241e-17,   6.537721652604547e-01,
  -6.455259718156651e-03,   3.867751418348652e-05,   2.981940385123331e-08,   2.401219446048908e-09,  -2.140068084045065e-12,  -3.708525658861582e-12,  -4.583695447026757e-14,
   2.382145012682665e-15,   7.651264527865169e-17,   6.537797153248254e-01,  -6.455242277167374e-03,   3.868029016881291e-05,   2.981442500729334e-08,   2.390441716174975e-09,
  -2.323938607809269e-12,  -3.695578253632474e-12,  -4.530936552030276e-14,   2.375185518616675e-15,   7.571014511189781e-17,   6.537840726942603e-01,  -6.455232212161732e-03,
   3.868189034133704e-05,   2.981149790432688e-08,   2.384227410807550e-09,  -2.429728349124176e-12,  -3.688111848524611e-12,  -4.500573312710073e-14,   2.371159875321665e-15,
   7.524830947869083e-17,   6.537857089448590e-01,  -6.455228432752952e-03,   3.868249086251624e-05,   2.981038860960123e-08,   2.381894960615951e-09,  -2.469391997887294e-12,
  -3.685309235710565e-12,  -4.489187650390330e-14,   2.369646479479739e-15,   7.507513161822032e-17,   6.537859801776102e-01,  -6.455227806267189e-03,   3.868259038853504e-05,
   2.981020419361967e-08,   2.381508380748384e-09,  -2.475963575494006e-12,  -3.684844720395658e-12,  -4.487301159356224e-14,   2.369395521580882e-15,   7.504643788114795e-17,
   8.419679129670873e-01,  -8.166264238180015e-03,   4.181659840642095e-05,   2.176351393674256e-07,   2.035894730291165e-09,   1.543234219791487e-12,  -5.521679360117421e-12,
  -7.362668283024694e-14,   3.702048801374070e-15,   1.212449514403188e-16,   8.419738671386842e-01,  -8.166171323778865e-03,   4.181827102900896e-05,   2.176355664329223e-07,
   2.024281145986429e-09,   1.332686607718415e-12,  -5.507091603505480e-12,  -7.303021142333334e-14,   3.694208269783810e-15,   1.203209645180227e-16,   8.419836420368346e-01,
  -8.166018790025315e-03,   4.182100979741215e-05,   2.176360548871622e-07,   2.005237986611898e-09,   9.883110420341878e-13,  -5.483166237505572e-12,  -7.205438876322048e-14,
   3.681298760312798e-15,   1.188093513121572e-16,   8.419940141788695e-01,  -8.165856940329373e-03,   4.182390618372727e-05,   2.176362848843743e-07,   1.985062172298651e-09,
   6.246272924275154e-13,  -5.457810617060982e-12,  -7.102355086684368e-14,   3.667549592598329e-15,   1.172125499565972e-16,   8.420021772678653e-01,  -8.165729564089012e-03,
   4.182617866778152e-05,   2.176362577192840e-07,   1.969205731475917e-09,   3.396523468601826e-13,  -5.437878131467306e-12,  -7.021558761619282e-14,   3.656692241388628e-15,
   1.159610162203298e-16,   8.420068884096689e-01,  -8.165656052907493e-03,   4.182748736390049e-05,   2.176361587780716e-07,   1.960063495520773e-09,   1.756861975824607e-13,
  -5.426383746703699e-12,  -6.975062093273598e-14,   3.650411668944841e-15,   1.152407956010359e-16,   8.420086575022572e-01,  -8.165628448754911e-03,   4.182797826352369e-05,
   2.176361059086878e-07,   1.956632162636832e-09,   1.142093711645181e-13,  -5.422069201811310e-12,  -6.957627137699718e-14,   3.648050509729590e-15,   1.149707353114751e-16,
   8.420089507553086e-01,  -8.165623872972956e-03,   4.182805960927285e-05,   2.176360963162728e-07,   1.956063458056105e-09,   1.040236680799721e-13,  -5.421354094537873e-12,
  -6.954738362622896e-14,   3.647658969502677e-15,   1.149259895023852e-16,   1.069185425002712e+00,  -1.005827465163933e-02,   3.616114222127070e-05,   6.483804290939341e-07,
   1.092754214605965e-09,  -1.864530246304092e-11,  -8.150515070461468e-12,  -1.238871641128266e-13,   6.130413755387314e-15,   2.006825165296384e-16,   1.069190572678848e+00,
  -1.005799794859229e-02,   3.616197845327071e-05,   6.483509161350866e-07,   1.075642367863388e-09,  -1.899985764506299e-11,  -8.126376063214758e-12,  -1.229009583180532e-13,
   6.116581429854005e-15,   1.991130356906433e-16,   1.069199023493151e+00,  -1.005754370554189e-02,   3.616334079382458e-05,   6.483021076295447e-07,   1.047587590063876e-09,
  -1.957981425705279e-11,  -8.086788171629284e-12,  -1.212876836568085e-13,   6.093810534571073e-15,   1.965457287474224e-16,   1.069207990555986e+00,  -1.005706173191082e-02,
   3.616477212583078e-05,   6.482498323704994e-07,   1.017869673978990e-09,  -2.019234150594451e-11,  -8.044837084622452e-12,  -1.195836593969409e-13,   6.069564217391922e-15,
   1.938341654896472e-16,   1.069215047750414e+00,  -1.005668242584401e-02,   3.616588830821398e-05,   6.482083407528112e-07,   9.945179612542697e-10,  -2.067234436904821e-11,
  -8.011861056938822e-12,  -1.182482051299664e-13,   6.050421616604971e-15,   1.917092174440402e-16,   1.069219120622773e+00,  -1.005646352480448e-02,   3.616652836000910e-05,
   6.481842548472780e-07,   9.810558306595216e-10,  -2.094853967729860e-11,  -7.992845884198155e-12,  -1.174797370269020e-13,   6.039349962901098e-15,   1.904864965783950e-16,
   1.069220650032015e+00,  -1.005638132602799e-02,   3.616676792769407e-05,   6.481751838714585e-07,   9.760034251464240e-10,  -2.105209827521789e-11,  -7.985708513052843e-12,
  -1.171915940612429e-13,   6.035187920231754e-15,   1.900280377769552e-16,   1.069220903553761e+00,  -1.005636770044332e-02,   3.616680759842655e-05,   6.481736788313779e-07,
   9.751660621052924e-10,  -2.106925639755812e-11,  -7.984525550764534e-12,  -1.171438526178525e-13,   6.034497763909715e-15,   1.899520777896485e-16,   1.349410014783498e+00,
  -1.190841100667484e-02,   2.999996083674252e-06,   1.682981662202468e-06,   3.525030350986177e-09,  -2.446650515141120e-10,  -1.226076611108180e-11,  -2.128302991541105e-13,
   1.153338094848042e-14,   4.070374179862993e-16,   1.349410447463585e+00,  -1.190769375369749e-02,   3.002860932233474e-06,   1.682628412201854e-06,   3.499394998220353e-09,
  -2.452693788885407e-10,  -1.221550815049701e-11,  -2.108349535341073e-13,   1.149983225505824e-14,   4.036672916258746e-16,   1.349411158049561e+00,  -1.190651637699436e-02,
   3.007548394327583e-06,   1.682047886644106e-06,   3.457379870455481e-09,  -2.462572282559735e-10,  -1.214130703560278e-11,  -2.075715863952001e-13,   1.144466308146564e-14,
   3.981563513061283e-16,   1.349411912404466e+00,  -1.190526723909930e-02,   3.012500906933485e-06,   1.681431079506061e-06,   3.412892882014314e-09,  -2.472996486680701e-10,
  -1.206270609750451e-11,  -2.041255958744809e-13,   1.138599894306894e-14,   3.923382000446763e-16,   1.349412506351707e+00,  -1.190428426953647e-02,   3.016383195314682e-06,
   1.680945053830945e-06,   3.377949606044737e-09,  -2.481158769748193e-10,  -1.200094255831358e-11,  -2.014256360143510e-13,   1.133974056967599e-14,   3.877805064732723e-16,
   1.349412849236667e+00,  -1.190371702210783e-02,   3.018617586803370e-06,   1.680664320927630e-06,   3.357810481853226e-09,  -2.485852736686885e-10,  -1.196533605433410e-11,
  -1.998722564655438e-13,   1.131300858250538e-14,   3.851586622489545e-16,   1.349412978013462e+00,  -1.190350402328789e-02,   3.019455460751993e-06,   1.680558858022245e-06,
   3.350253202371007e-09,  -2.487612226068969e-10,  -1.195197272826045e-11,  -1.992898567038817e-13,   1.130296382328736e-14,   3.841757363201277e-16,   1.349412999361118e+00,
  -1.190346871611892e-02,   3.019594289054468e-06,   1.680541373668743e-06,   3.349000747375481e-09,  -2.487903720978837e-10,  -1.194975794932496e-11,  -1.991933635653943e-13,
   1.130129841210679e-14,   3.840128867755448e-16,   1.709971163955951e+00,  -1.201523439179497e-02,  -1.509638593542911e-04,   3.633217588395349e-06,   1.111537914393126e-07,
  -2.120097238889785e-09,  -1.073677600064024e-10,   1.044658123143495e-12,   1.057598131633690e-13,  -2.422542397324548e-17,   1.709949868973443e+00,  -1.201369385191731e-02,
  -1.508702200673187e-04,   3.630226844140925e-06,   1.109294423576482e-07,  -2.116980449823947e-09,  -1.069588724200744e-10,   1.044359132224322e-12,   1.051530675041156e-13,
  -3.083102458186600e-17,   1.709914919241557e+00,  -1.201116572300507e-02,  -1.507166329451147e-04,   3.625320256787934e-06,   1.105617612507096e-07,  -2.111864493638942e-09,
  -1.062893450693755e-10,   1.043844562607136e-12,   1.041604174399545e-13,  -4.157794337807009e-17,   1.709877847681124e+00,  -1.200848442804854e-02,  -1.505538510176944e-04,
   3.620118341530776e-06,   1.101724700962948e-07,  -2.106437125767809e-09,  -1.055812676608014e-10,   1.043266510863882e-12,   1.031117759043406e-13,  -5.284984132592092e-17,
   1.709848681434513e+00,  -1.200637513597073e-02,  -1.504258752038406e-04,   3.616027558296228e-06,   1.098667079675415e-07,  -2.102166545616009e-09,  -1.050256991077107e-10,
   1.042788525360065e-12,   1.022898367928408e-13,  -6.162632281257575e-17,   1.709831852735719e+00,  -1.200515818334945e-02,  -1.503520716869670e-04,   3.613667950409893e-06,
   1.096904916328298e-07,  -2.099702232789483e-09,  -1.047057465233013e-10,   1.042503478518253e-12,   1.018168181461970e-13,  -6.665368893179765e-17,   1.709825534093443e+00,
  -1.200470127377069e-02,  -1.503243679001067e-04,   3.612782132910547e-06,   1.096243669041343e-07,  -2.098776920610501e-09,  -1.045857289215950e-10,   1.042394709113707e-12,
   1.016394475398508e-13,  -6.853440953639872e-17,   1.709824486725041e+00,  -1.200462553806703e-02,  -1.503197761371202e-04,   3.612635308574102e-06,   1.096134082230534e-07,
  -2.098623540152370e-09,  -1.045658410229218e-10,   1.042376587828720e-12,   1.016100591392553e-13,  -6.884579161190421e-17,   1.971800395427796e-03,  -1.977663362689673e-05,
   1.536851106703687e-07,  -6.184199733548287e-10,   1.127544322702199e-11,  -2.697424441882825e-13,  -7.376380992854342e-15,   1.223685338742179e-16,   7.928768546598057e-18,
  -3.088663906141126e-20,   1.971822285132248e-03,  -1.977689898873911e-05,   1.536946511665606e-07,  -6.188007741250333e-10,   1.126006071343079e-11,  -2.693794213067541e-13,
  -7.345697569520264e-15,   1.222024308696842e-16,   7.884713713838730e-18,  -3.118467530652750e-20,   1.971858221593330e-03,  -1.977733473995142e-05,   1.537103040571325e-07,
  -6.194255479623637e-10,   1.123485468591328e-11,  -2.687838242737202e-13,  -7.295451297460833e-15,   1.219286817613553e-16,   7.812624899688717e-18,  -3.166870963882738e-20,
   1.971896354272023e-03,  -1.977779726434896e-05,   1.537269002540693e-07,  -6.200879755734280e-10,   1.120817272129174e-11,  -2.681523454254297e-13,  -7.242306361945423e-15,
   1.216367770104026e-16,   7.736450735849237e-18,  -3.217522473988941e-20,   1.971926365843016e-03,  -1.977816138832263e-05,   1.537399523438783e-07,  -6.206089435942388e-10,
   1.118721982506354e-11,  -2.676557280699112e-13,  -7.200603990612742e-15,   1.214060150794648e-16,   7.676730600953410e-18,  -3.256875751385959e-20,   1.971943686489172e-03,
  -1.977837157740649e-05,   1.537474812745970e-07,  -6.209094577731954e-10,   1.117514589087622e-11,  -2.673692650303908e-13,  -7.176585935324603e-15,   1.212724271240309e-16,
   7.642356658353038e-18,  -3.279383983956733e-20,   1.971950190636164e-03,  -1.977845051419363e-05,   1.537503077668244e-07,  -6.210222761231294e-10,   1.117061548156922e-11,
  -2.672617226688484e-13,  -7.167576204538316e-15,   1.212221862045765e-16,   7.629466210907657e-18,  -3.287797740717379e-20,   1.971951268795432e-03,  -1.977846359955470e-05,
   1.537507762616570e-07,  -6.210409759176835e-10,   1.116986468451910e-11,  -2.672438974272713e-13,  -7.166083202396128e-15,   1.212138539821611e-16,   7.627330347285979e-18,
  -3.289190423316339e-20,   1.778735650244619e-02,  -1.783212191406520e-04,   1.381490498924892e-06,  -5.449496773978065e-09,   1.006194584158489e-10,  -2.435453882334972e-12,
  -6.724122570484597e-14,   1.115333618003779e-15,   7.214753859332650e-17,  -2.813415968437683e-19,   1.778755326985436e-02,  -1.783235577912280e-04,   1.381575619381403e-06,
  -5.452934689936715e-09,   1.004792292995307e-10,  -2.432145079290939e-12,  -6.696203010663524e-14,   1.113820561651222e-15,   7.174631864511307e-17,  -2.840582957579820e-19,
   1.778787630403889e-02,  -1.783273981190725e-04,   1.381715272893828e-06,  -5.458575192410577e-09,   1.002494468788260e-10,  -2.426716457338832e-12,  -6.650482860522914e-14,
   1.111326935088499e-15,   7.108978664868683e-17,  -2.884703834545949e-19,   1.778821908001333e-02,  -1.783314744362419e-04,   1.381863340014920e-06,  -5.464555592058086e-09,
   1.000062084822980e-10,  -2.420960784749473e-12,  -6.602125291046045e-14,   1.108667917433138e-15,   7.039605022642040e-17,  -2.930873271527287e-19,   1.778848885500178e-02,
  -1.783346835560126e-04,   1.381979785706366e-06,  -5.469258862149740e-09,   9.981519669197829e-11,  -2.416434317835429e-12,  -6.564179622899104e-14,   1.106565855864603e-15,
   6.985216600448017e-17,  -2.966743792280762e-19,   1.778864455082712e-02,  -1.783365360172143e-04,   1.382046955193028e-06,  -5.471971874603249e-09,   9.970512740302255e-11,
  -2.413823321987669e-12,  -6.542325241929221e-14,   1.105348971275079e-15,   6.953911561568457e-17,  -2.987259871507384e-19,   1.778870301680105e-02,  -1.783372317133193e-04,
   1.382072171657025e-06,  -5.472990385168284e-09,   9.966382689207124e-11,  -2.412843116298096e-12,  -6.534127163124903e-14,   1.104891314312702e-15,   6.942171983195371e-17,
  -2.994928911426519e-19,   1.778871270840704e-02,  -1.783373470390477e-04,   1.382076351312193e-06,  -5.473159204549390e-09,   9.965698240762192e-11,  -2.412680646330093e-12,
  -6.532768660194756e-14,   1.104815414015289e-15,   6.940226811682942e-17,  -2.996198323368647e-19,   4.964148778315450e-02,  -4.971970640899632e-04,   3.827406147034028e-06,
  -1.446468163889561e-08,   2.745116780148360e-10,  -6.810037349151521e-12,  -1.916755158978414e-13,   3.178731709225192e-15,   2.049529426223701e-16,  -8.010630802030878e-19,
   4.964203291793452e-02,  -4.972032733225507e-04,   3.827638276867175e-06,  -1.447429326655134e-08,   2.741119127479986e-10,  -6.800607106397656e-12,  -1.908824326961872e-13,
   3.174423364555224e-15,   2.038111838738791e-16,  -8.088070727374415e-19,   4.964292786844504e-02,  -4.972134697303381e-04,   3.828019111821900e-06,  -1.449006263875122e-08,
   2.734568444845478e-10,  -6.785135272552168e-12,  -1.895837116094651e-13,   3.167322872473749e-15,   2.019428875581576e-16,  -8.213835222966025e-19,   4.964387751209481e-02,
  -4.972242929115075e-04,   3.828422876293056e-06,  -1.450678202432116e-08,   2.727634097124078e-10,  -6.768731317102521e-12,  -1.882100801806234e-13,   3.159751399830329e-15,
   1.999687299239696e-16,  -8.345435304118427e-19,   4.964462490978905e-02,  -4.972328137100299e-04,   3.828740401826899e-06,  -1.451993076123109e-08,   2.722188605455537e-10,
  -6.755830651089489e-12,  -1.871322119691082e-13,   3.153765817074119e-15,   1.984210132627925e-16,  -8.447676927086853e-19,   4.964505625689041e-02,  -4.972377323907484e-04,
   3.828923556232003e-06,  -1.452751534478134e-08,   2.719050659355952e-10,  -6.748389173835034e-12,  -1.865114281724897e-13,   3.150300749871088e-15,   1.975301775471620e-16,
  -8.506152746411564e-19,   4.964521823376931e-02,  -4.972395796237119e-04,   3.828992314439590e-06,  -1.453036271143017e-08,   2.717873227040528e-10,  -6.745595534769350e-12,
  -1.862785583846468e-13,   3.148997574184164e-15,   1.971961094112416e-16,  -8.528011169897585e-19,   4.964524508384797e-02,  -4.972398858405919e-04,   3.829003711142513e-06,
  -1.453083466523519e-08,   2.717678098115308e-10,  -6.745132486567051e-12,  -1.862399695749813e-13,   3.148781448406032e-15,   1.971407565348071e-16,  -8.531629257721779e-19,
   9.799791785182317e-02,  -9.800678641532813e-04,   7.468080830222326e-06,  -2.623149446270642e-08,   5.222694831164072e-10,  -1.348898114305337e-11,  -3.908594039358492e-13,
   6.481468165770733e-15,   4.159200230480836e-16,  -1.632341124432014e-18,   9.799898150200544e-02,  -9.800791301681304e-04,   7.468522157130663e-06,  -2.625052805794474e-08,
   5.214541988813779e-10,  -1.346975269312300e-11,  -3.892500941135712e-13,   6.472688632223453e-15,   4.135967366441496e-16,  -1.648134963253581e-18,   9.800072770063536e-02,
  -9.800976309906728e-04,   7.469246169569398e-06,  -2.628175506725056e-08,   5.201182353764391e-10,  -1.343820530911536e-11,  -3.866147714318465e-13,   6.458219228038662e-15,
   4.097950965907067e-16,  -1.673783639893466e-18,   9.800258061309254e-02,  -9.801172697214979e-04,   7.470013727938784e-06,  -2.631486255066030e-08,   5.187040092555144e-10,
  -1.340475729476065e-11,  -3.838274678447797e-13,   6.442790006513692e-15,   4.057780857897930e-16,  -1.700621164232722e-18,   9.800403890889899e-02,  -9.801327312435265e-04,
   7.470617312490062e-06,  -2.634089892824485e-08,   5.175934157176405e-10,  -1.337845255096098e-11,  -3.816403299414466e-13,   6.430592491547988e-15,   4.026288231653570e-16,
  -1.721470622159611e-18,   9.800488053754207e-02,  -9.801416566893215e-04,   7.470965457567133e-06,  -2.635591726291951e-08,   5.169534350261667e-10,  -1.336327920949645e-11,
  -3.803806842509252e-13,   6.423531309370480e-15,   4.008161795284426e-16,  -1.733394837241059e-18,   9.800519658079564e-02,  -9.801450087174224e-04,   7.471096152603674e-06,
  -2.636155532904508e-08,   5.167132980536086e-10,  -1.335758291501950e-11,  -3.799081645336917e-13,   6.420875669807519e-15,   4.001364305742650e-16,  -1.737852071388912e-18,
   9.800524896966428e-02,  -9.801455643869770e-04,   7.471117815230599e-06,  -2.636248984177817e-08,   5.166735015177410e-10,  -1.335663874901224e-11,  -3.798298634497947e-13,
   6.420435243899287e-15,   4.000238007855509e-16,  -1.738589845690483e-18,   1.635999528655759e-01,  -1.632659410636354e-03,   1.225693766203200e-05,  -3.820351307413743e-08,
   8.247582726153080e-10,  -2.264368639247391e-11,  -6.822224044345894e-13,   1.131674265617072e-14,   7.218343460285316e-16,  -2.852613084311323e-18,   1.636016985176846e-01,
  -1.632675833344329e-03,   1.225763382967404e-05,  -3.823545347389873e-08,   8.233350480088381e-10,  -2.261011343239908e-11,  -6.794297395393596e-13,   1.130140044530861e-14,
   7.177870641040242e-16,  -2.880195535548512e-18,   1.636045643585518e-01,  -1.632702803667838e-03,   1.225877583367270e-05,  -3.828785438221293e-08,   8.210028588794179e-10,
  -2.255503158632858e-11,  -6.748566598406814e-13,   1.127611528172543e-14,   7.111644867864491e-16,  -2.924985986227242e-18,   1.636076053328703e-01,  -1.632731434566037e-03,
   1.225998641011979e-05,  -3.834340902581990e-08,   8.185340119613021e-10,  -2.249663127132702e-11,  -6.700199073547413e-13,   1.124915295891444e-14,   7.041668233116951e-16,
  -2.971849067077650e-18,   1.636099986648679e-01,  -1.632753976858776e-03,   1.226093828831631e-05,  -3.838709697455372e-08,   8.165951980992125e-10,  -2.245070315209782e-11,
  -6.662246537802388e-13,   1.122783807794926e-14,   6.986808535773015e-16,  -3.008253407314289e-18,   1.636113799313026e-01,  -1.632766990313568e-03,   1.226148729474931e-05,
  -3.841229658119355e-08,   8.154779444205252e-10,  -2.242421048799568e-11,  -6.640388579812599e-13,   1.121549885727974e-14,   6.955232826619013e-16,  -3.029072754034856e-18,
   1.636118986158256e-01,  -1.632771877724055e-03,   1.226169338769876e-05,  -3.842175672113829e-08,   8.150587206071599e-10,  -2.241426475623418e-11,  -6.632189230675617e-13,
   1.121085820730817e-14,   6.943391856315231e-16,  -3.036854768637835e-18,   1.636119845954861e-01,  -1.632772687920744e-03,   1.226172754715743e-05,  -3.842332473955287e-08,
   8.149892449253882e-10,  -2.241261624223104e-11,  -6.630830521010151e-13,   1.121008857668765e-14,   6.941429890680815e-16,  -3.038142860088423e-18,   2.475389042487546e-01,
  -2.463043061130842e-03,   1.810463411742873e-05,  -4.606766355959780e-08,   1.149378895167262e-09,  -3.457506736546564e-11,  -1.093791488364271e-12,   1.816661823178474e-14,
   1.150726404067638e-15,  -4.599774225011358e-18,   2.475414826185699e-01,  -2.463062900564396e-03,   1.810560260379010e-05,  -4.611641177160470e-08,   1.147096762033370e-09,
  -3.452117480899026e-11,  -1.089340170304319e-12,   1.814188470790743e-14,   1.144242055761689e-15,  -4.644050065852634e-18,   2.475457155275994e-01,  -2.463095485142407e-03,
   1.810719113918522e-05,  -4.619638458789862e-08,   1.143357067951891e-09,  -3.443275562161310e-11,  -1.082051085863108e-12,   1.810112265274187e-14,   1.133631863623633e-15,
  -4.715942214439448e-18,   2.475502071039477e-01,  -2.463130080189608e-03,   1.810887480884115e-05,  -4.628116685076292e-08,   1.139398185418205e-09,  -3.433900982885646e-11,
  -1.074341857627484e-12,   1.805765784925851e-14,   1.122420957806432e-15,  -4.791152554755916e-18,   2.475537420941711e-01,  -2.463157321357933e-03,   1.811019849967637e-05,
  -4.634783660429256e-08,   1.136289188831803e-09,  -3.426528497243158e-11,  -1.068292751147456e-12,   1.802329776181950e-14,   1.113632085349767e-15,  -4.849571507784482e-18,
   2.475557822446305e-01,  -2.463173048652699e-03,   1.811096188055398e-05,  -4.638629125145770e-08,   1.134497593683272e-09,  -3.422275843844717e-11,  -1.064808933441101e-12,
   1.800340693677035e-14,   1.108573519922427e-15,  -4.882978336145994e-18,   2.475565483486853e-01,  -2.463178955520096e-03,   1.811124843434784e-05,  -4.640072723981229e-08,
   1.133825335614326e-09,  -3.420679337554247e-11,  -1.063502091995109e-12,   1.799592626290341e-14,   1.106676557270918e-15,  -4.895464922324115e-18,   2.475566753417817e-01,
  -2.463179934726563e-03,   1.811129592929213e-05,  -4.640311999450463e-08,   1.133713925778997e-09,  -3.420414715287529e-11,  -1.063285536380644e-12,   1.799468563014901e-14,
   1.106362244517989e-15,  -4.897531696921956e-18,   3.513687952637128e-01,  -3.482001337838992e-03,   2.483927398793390e-05,  -4.245557788698769e-08,   1.440475974364065e-09,
  -4.984083061258613e-11,  -1.670301630015953e-12,   2.782798338253879e-14,   1.750014169630998e-15,  -7.128600260235798e-18,   3.513723325082884e-01,  -3.482019711041521e-03,
   2.484048422228448e-05,  -4.252580867322503e-08,   1.436990637258573e-09,  -4.975828365362281e-11,  -1.663533428733964e-12,   2.778967523557081e-14,   1.740088439319087e-15,
  -7.196354295768563e-18,   3.513781395892524e-01,  -3.482049895136315e-03,   2.484246889225414e-05,  -4.264101923132011e-08,   1.431279226104779e-09,  -4.962285334101520e-11,
  -1.652450608324005e-12,   2.772654458433775e-14,   1.723847547707056e-15,  -7.306353709546290e-18,   3.513843015160431e-01,  -3.482081952012680e-03,   2.484457189509458e-05,
  -4.276315154807824e-08,   1.425232998188521e-09,  -4.947926559125238e-11,  -1.640729226234861e-12,   2.765923214757858e-14,   1.706687633813272e-15,  -7.421409672598804e-18,
   3.513891511042383e-01,  -3.482107202087019e-03,   2.484622488298860e-05,  -4.285918710507952e-08,   1.420484717848594e-09,  -4.936634423707483e-11,  -1.631532135029466e-12,
   2.760602284077555e-14,   1.693235341632134e-15,  -7.510763465985497e-18,   3.513919499442618e-01,  -3.482121782870643e-03,   2.484717801918632e-05,  -4.291457775743057e-08,
   1.417748448030448e-09,  -4.930120844119046e-11,  -1.626235394886158e-12,   2.757522151445608e-14,   1.685492815916713e-15,  -7.561854362066962e-18,   3.513930009455618e-01,
  -3.482127259700739e-03,   2.484753577350562e-05,  -4.293537119701588e-08,   1.416721717331359e-09,  -4.927675560951971e-11,  -1.624248508139671e-12,   2.756363777013018e-14,
   1.682589394259478e-15,  -7.580949646404587e-18,   3.513931751645479e-01,  -3.482128167648163e-03,   2.484759506808274e-05,  -4.293881767488094e-08,   1.416551562404652e-09,
  -4.927270253560721e-11,  -1.623919263512897e-12,   2.756171667520932e-14,   1.682108320049444e-15,  -7.584110229878407e-18,   4.773008387330176e-01,  -4.703370641610202e-03,
   3.212107977045185e-05,  -1.426619322892048e-08,   1.600512131005125e-09,  -6.959007872341831e-11,  -2.484455111802937e-12,   4.167211250873140e-14,   2.604001616716454e-15,
  -1.094793881212843e-17,   4.773054124873597e-01,  -4.703377078142256e-03,   3.212241704476342e-05,  -1.436418241283581e-08,   1.595327949806681e-09,  -6.946648765817753e-11,
  -2.474386698880658e-12,   4.161335956565938e-14,   2.589105788981054e-15,  -1.104900450784466e-17,   4.773129211784448e-01,  -4.703387674744510e-03,   3.212460923530293e-05,
  -1.452492079541645e-08,   1.586832648531025e-09,  -6.926372151958578e-11,  -2.457900201793421e-12,   4.151654695238278e-14,   2.564733395142673e-15,  -1.121304882429276e-17,
   4.773208886607908e-01,  -4.703398959300584e-03,   3.212693102705928e-05,  -1.469530449110679e-08,   1.577839332408801e-09,  -6.904874616514945e-11,  -2.440464295264124e-12,
   4.141333555209030e-14,   2.538982896610988e-15,  -1.138458378558243e-17,   4.773271592420228e-01,  -4.703407869787227e-03,   3.212875518599201e-05,  -1.482927277036756e-08,
   1.570776617131393e-09,  -6.887968659900364e-11,  -2.426783706324079e-12,   4.133175887545898e-14,   2.518796889178444e-15,  -1.151776326398911e-17,   4.773307781694408e-01,
  -4.703413024015547e-03,   3.212980670111792e-05,  -1.490653856334706e-08,   1.566706618377009e-09,  -6.878217009899566e-11,  -2.418904997761804e-12,   4.128454053750926e-14,
   2.507179049461794e-15,  -1.159389817397158e-17,   4.773321371225661e-01,  -4.703414961711516e-03,   3.213020132078475e-05,  -1.493554320367528e-08,   1.565179432457551e-09,
  -6.874556135110681e-11,  -2.415949603081846e-12,   4.126678345313661e-14,   2.502822455505325e-15,  -1.162235089421489e-17,   4.773323623890201e-01,  -4.703415283030091e-03,
   3.213026672226438e-05,  -1.494035064038438e-08,   1.564926339596802e-09,  -6.873949343744909e-11,  -2.415459869597389e-12,   4.126383858658420e-14,   2.502100605079711e-15,
  -1.162706013940001e-17,   6.285486180367663e-01,  -6.143907658273872e-03,   3.924280308989705e-05,   6.340332844109451e-08,   1.451776876160711e-09,  -9.657755053582489e-11,
  -3.657813107517518e-12,   6.223649702054632e-14,   3.875514875944808e-15,  -1.719987543291275e-17,   6.285542049812142e-01,  -6.143881069739757e-03,   3.924399953463397e-05,
   6.326744796861594e-08,   1.444146148554031e-09,  -9.639303826190103e-11,  -3.642833659813785e-12,   6.214445100669897e-14,   3.853087544621194e-15,  -1.734895300051708e-17,
   6.285633769711971e-01,  -6.143837461921447e-03,   3.924595903911395e-05,   6.304456733955163e-08,   1.431641940082596e-09,  -9.609033281216951e-11,  -3.618306348411249e-12,
   6.199281207216423e-14,   3.816393955990074e-15,  -1.759082992675661e-17,   6.285731093195429e-01,  -6.143791247112339e-03,   3.924803190837328e-05,   6.280833073180484e-08,
   1.418405031506873e-09,  -9.576941314292429e-11,  -3.592367593354015e-12,   6.183119614582408e-14,   3.777627978392264e-15,  -1.784361852697767e-17,   6.285807688431057e-01,
  -6.143754916665804e-03,   3.924965870008520e-05,   6.262259724003758e-08,   1.408009934426224e-09,  -9.551704668958326e-11,  -3.572016217608169e-12,   6.170349013055969e-14,
   3.747240775746918e-15,  -1.803978646195234e-17,   6.285851893496737e-01,  -6.143733966021617e-03,   3.925059572456686e-05,   6.251548132222564e-08,   1.402019693682378e-09,
  -9.537148100525130e-11,  -3.560296067889422e-12,   6.162958414605378e-14,   3.729752442792392e-15,  -1.815189108550461e-17,   6.285868493024853e-01,  -6.143726101938937e-03,
   3.925094724114433e-05,   6.247527230997674e-08,   1.399771993075555e-09,  -9.531683476961505e-11,  -3.555899759547563e-12,   6.160179326411758e-14,   3.723194593678373e-15,
  -1.819377880752961e-17,   6.285871244638795e-01,  -6.143724798517790e-03,   3.925100549183114e-05,   6.246860783335215e-08,   1.399399493871860e-09,  -9.530777717229743e-11,
  -3.555171257600730e-12,   6.159718450347343e-14,   3.722108020993497e-15,  -1.820071130516774e-17,   8.099891849205357e-01,  -7.820777972910193e-03,   4.460012766181956e-05,
   2.428422954285152e-07,   6.588038911355751e-10,  -1.388928203770456e-10,  -5.396404036574598e-12,   9.482558081664970e-14,   5.919908306834929e-15,  -2.890971640668104e-17,
   8.099955328485710e-01,  -7.820674987636538e-03,   4.460062657942750e-05,   2.426470102118478e-07,   6.475553033391051e-10,  -1.386119083309534e-10,  -5.373534956398879e-12,
   9.467172949933626e-14,   5.885052284486073e-15,  -2.912793256229580e-17,   8.100059540413098e-01,  -7.820505980342904e-03,   4.460143877694517e-05,   2.423267058175539e-07,
   6.291238286207603e-10,  -1.381510816964093e-10,  -5.336090909770858e-12,   9.441838336386108e-14,   5.828028420737217e-15,  -2.948168756408963e-17,   8.100170117883360e-01,
  -7.820326731630882e-03,   4.460229127439383e-05,   2.419872291796643e-07,   6.096139617809349e-10,  -1.376625664992502e-10,  -5.296494460588542e-12,   9.414852013846070e-14,
   5.767789962161558e-15,  -2.985099431468119e-17,   8.100257143336876e-01,  -7.820185720625011e-03,   4.460295546505782e-05,   2.417203422840563e-07,   5.942938132213909e-10,
  -1.372784343954329e-10,  -5.265429042146311e-12,   9.393538790862128e-14,   5.720575627279836e-15,  -3.013728582738453e-17,   8.100307367588576e-01,  -7.820104363922439e-03,
   4.460333608804233e-05,   2.415664300295637e-07,   5.854659512030294e-10,  -1.370568775261203e-10,  -5.247539462412567e-12,   9.381208740636848e-14,   5.693404743152972e-15,
  -3.030077409053725e-17,   8.100326227324783e-01,  -7.820073818113069e-03,   4.460347850683877e-05,   2.415086558738404e-07,   5.821535872350604e-10,  -1.369737059367503e-10,
  -5.240829086691747e-12,   9.376573084068041e-14,   5.683216418552540e-15,  -3.036183852900463e-17,   8.100329353597608e-01,  -7.820068754942211e-03,   4.460350208795379e-05,
   2.414990801107532e-07,   5.816046518559836e-10,  -1.369599203863428e-10,  -5.239717132817694e-12,   9.375804362870380e-14,   5.681528328238300e-15,  -3.037194360881272e-17,
   1.029580471957461e+00,  -9.737667382273359e-03,   4.399778376433940e-05,   6.515485362031122e-07,  -1.377948663472714e-09,  -2.280766805604014e-10,  -8.008379599036869e-12,
   1.535752387033361e-13,   9.658457733525418e-15,  -5.630699914211178e-17,   1.029586730608386e+00,  -9.737390354226530e-03,   4.399651307263903e-05,   6.512277967891193e-07,
  -1.394602411402613e-09,  -2.276224797795312e-10,  -7.971107321464743e-12,   1.532788526444935e-13,   9.599681333415098e-15,  -5.660905115938446e-17,   1.029597005051431e+00,
  -9.736935665915146e-03,   4.399441688802769e-05,   6.507017163074707e-07,  -1.421885370293771e-09,  -2.268774808645300e-10,  -7.910086129944322e-12,   1.527912241983051e-13,
   9.503537535111507e-15,  -5.709751487283457e-17,   1.029607906831540e+00,  -9.736453339669432e-03,   4.399217891397334e-05,   6.501441361012876e-07,  -1.450757556158677e-09,
  -2.260878574993939e-10,  -7.845564738875142e-12,   1.522723830960449e-13,   9.401991997636343e-15,  -5.760581574319305e-17,   1.029616486445960e+00,  -9.736073842754447e-03,
   4.399040766876709e-05,   6.497057747337489e-07,  -1.473424375037341e-09,  -2.254670564527014e-10,  -7.794949854857989e-12,   1.518630288620085e-13,   9.322414675681390e-15,
  -5.799866412842524e-17,   1.029621437851424e+00,  -9.735854866275609e-03,   4.398938146581797e-05,   6.494529709840545e-07,  -1.486483530972743e-09,  -2.251090355568117e-10,
  -7.765804530539272e-12,   1.516263760149031e-13,   9.276624801102562e-15,  -5.822252037303268e-17,   1.029623297142473e+00,  -9.735772645725926e-03,   4.398899536421517e-05,
   6.493580752714444e-07,  -1.491383161646004e-09,  -2.249746434844054e-10,  -7.754872537805966e-12,   1.515374341306724e-13,   9.259455864681119e-15,  -5.830604122819109e-17,
   1.029623605346001e+00,  -9.735759016877746e-03,   4.398893132268069e-05,   6.493423467742803e-07,  -1.492195123452605e-09,  -2.249523686254809e-10,  -7.753061055507458e-12,
   1.515226867214395e-13,   9.256611218091658e-15,  -5.831985759839603e-17,   1.301953001746786e+00,  -1.180315134773629e-02,   2.331751609089333e-05,   1.683123544039284e-06,
  -4.528877996820573e-09,  -5.575779543788107e-10,  -1.135726168831720e-11,   3.129431558689263e-13,   1.792957687784997e-14,  -1.535921650328859e-16,   1.301956311955953e+00,
  -1.180243555945385e-02,   2.331351680059952e-05,   1.682337847380029e-06,  -4.552305951030687e-09,  -5.566553816361627e-10,  -1.128832072972492e-11,   3.121523954060279e-13,
   1.780829791112959e-14,  -1.537489944375569e-16,   1.301961745767861e+00,  -1.180126071773617e-02,   2.330693711704080e-05,   1.681048942781162e-06,  -4.590661686539047e-09,
  -5.551425394478597e-10,  -1.117548778631193e-11,   3.108537459889525e-13,   1.760998101522616e-14,  -1.539941376647724e-16,   1.301967510874177e+00,  -1.180001444669453e-02,
   2.329993629846010e-05,   1.679682596881666e-06,  -4.631217612939579e-09,  -5.535396218800277e-10,  -1.105623069713073e-11,   3.094751396009347e-13,   1.740061100240117e-14,
  -1.542376447858586e-16,   1.301972047616766e+00,  -1.179903386133905e-02,   2.329441269592612e-05,   1.678608202558819e-06,  -4.663032411815425e-09,  -5.522798010238028e-10,
  -1.096271218100774e-11,   3.083897255719591e-13,   1.723660011773820e-14,  -1.544173639798181e-16,   1.301974665688521e+00,  -1.179846804111696e-02,   2.329121934547968e-05,
   1.677988519955837e-06,  -4.681352169973691e-09,  -5.515534088041546e-10,  -1.090887576410921e-11,   3.077631403602049e-13,   1.714225175124846e-14,  -1.545163381742109e-16,
   1.301975648768135e+00,  -1.179825558790313e-02,   2.329001915865047e-05,   1.677755893139421e-06,  -4.688223645894127e-09,  -5.512807689049774e-10,  -1.088868512324708e-11,
   3.075278196984961e-13,   1.710688064216104e-14,  -1.545526110643547e-16,   1.301975811725945e+00,  -1.179822037168643e-02,   2.328982015503373e-05,   1.677717335615521e-06,
  -4.689362281411222e-09,  -5.512355816711309e-10,  -1.088533957821188e-11,   3.074888102770546e-13,   1.710102041275360e-14,  -1.545585768078220e-16,   1.659808310169710e+00,
  -1.302237271539032e-02,  -9.850410821051602e-05,   4.948996753239943e-06,   4.722454034244760e-08,  -3.992055120597756e-09,  -3.637238855717688e-11,   3.653006198742352e-12,
   3.616700930271290e-14,  -3.453092072969746e-15,   1.659794372526847e+00,  -1.302027961567414e-02,  -9.846421558412405e-05,   4.943405403161627e-06,   4.714854384972777e-08,
  -3.981409262621954e-09,  -3.623335136897151e-11,   3.635967340971029e-12,   3.592070483907453e-14,  -3.428654632169836e-15,   1.659771495664492e+00,  -1.301684515810164e-02,
  -9.839877176153233e-05,   4.934237134769382e-06,   4.702399514046028e-08,  -3.963968746854627e-09,  -3.600579785963642e-11,   3.608084432702314e-12,   3.551824386774141e-14,
  -3.388716245720126e-15,   1.659747227025483e+00,  -1.301320324773378e-02,  -9.832939377115155e-05,   4.924523602398913e-06,   4.689212664850515e-08,  -3.945512354684925e-09,
  -3.576529242333729e-11,   3.578619292400261e-12,   3.509375612310559e-14,  -3.346581696751147e-15,   1.659728131444775e+00,  -1.301033871952720e-02,  -9.827483846002220e-05,
   4.916889635177057e-06,   4.678855301863138e-08,  -3.931022720788930e-09,  -3.557669631155680e-11,   3.555517237992496e-12,   3.476152288811174e-14,  -3.313596890223568e-15,
   1.659717112600750e+00,  -1.300868621499923e-02,  -9.824337175640783e-05,   4.912488180736969e-06,   4.672886170407320e-08,  -3.922674730578412e-09,  -3.546812680281219e-11,
   3.542219438303641e-12,   3.457051966183239e-14,  -3.294630736987781e-15,   1.659712975215510e+00,  -1.300806580983339e-02,  -9.823155914040744e-05,   4.910836194883257e-06,
   4.670646270183316e-08,  -3.919542669491394e-09,  -3.542740938169313e-11,   3.537232557841978e-12,   3.449893465059186e-14,  -3.287521963678500e-15,   1.659712289400523e+00,
  -1.300796297548034e-02,  -9.822960121186158e-05,   4.910562396984233e-06,   4.670275057334910e-08,  -3.919023627484717e-09,  -3.542066260146180e-11,   3.536406257645668e-12,
   3.448707571387721e-14,  -3.286344278700070e-15,   1.895109542680829e-03,  -1.857423470784481e-05,   1.471416824407946e-07,  -4.891423126121807e-10,   4.524413593848003e-12,
  -3.799829768610366e-13,  -9.538261382029071e-16,   3.047351429408106e-16,   2.021985773723974e-18,  -2.666902342508111e-19,   1.895130489769646e-03,  -1.857444541592932e-05,
   1.471455346118167e-07,  -4.896755638289585e-10,   4.522468959646797e-12,  -3.790933032237693e-13,  -9.460920387768956e-16,   3.034144771835233e-16,   2.006321354565538e-18,
  -2.649810091913903e-19,   1.895164878201589e-03,  -1.857479149016324e-05,   1.471518574028810e-07,  -4.905500756332960e-10,   4.519288290064758e-12,  -3.776355831052827e-13,
  -9.334396931004783e-16,   3.012526349266865e-16,   1.980724877799278e-18,  -2.621862716941829e-19,   1.895201367523377e-03,  -1.857515892279931e-05,   1.471585647851807e-07,
  -4.914767699926358e-10,   4.515929302468641e-12,  -3.760926589476656e-13,  -9.200747746613703e-16,   2.989672171828617e-16,   1.953726394933825e-18,  -2.592360507802574e-19,
   1.895230085200656e-03,  -1.857544825419866e-05,   1.471638423838348e-07,  -4.922051938217582e-10,   4.513297279744842e-12,  -3.748811364798433e-13,  -9.095999529384519e-16,
   2.971746918688499e-16,   1.932594766393581e-18,  -2.569251829375229e-19,   1.895246658889807e-03,  -1.857561529709764e-05,   1.471668877306687e-07,  -4.926252253077171e-10,
   4.511782895455123e-12,  -3.741830504155444e-13,  -9.035720932521959e-16,   2.961426340241118e-16,   1.920445750340525e-18,  -2.555959200386727e-19,   1.895252882504381e-03,
  -1.857567803547646e-05,   1.471680312021366e-07,  -4.927828840397646e-10,   4.511215098823264e-12,  -3.739211212125269e-13,  -9.013118484327776e-16,   2.957555472098253e-16,
   1.915892435649533e-18,  -2.550975956066486e-19,   1.895253914159136e-03,  -1.857568843589947e-05,   1.471682207443368e-07,  -4.928090146838014e-10,   4.511121024258547e-12,
  -3.738777137210841e-13,  -9.009373532091933e-16,   2.956914063415856e-16,   1.915138120298436e-18,  -2.550150347873554e-19,   1.709579443757851e-02,  -1.675077032422250e-04,
   1.323904270627004e-06,  -4.301925949730052e-09,   3.954512207583298e-11,  -3.440871833358212e-12,  -8.752445202915485e-15,   2.774179624854837e-15,   1.835185569412813e-17,
  -2.428606298260773e-18,   1.709598290657926e-02,  -1.675095568740950e-04,   1.323937935251140e-06,  -4.306754355327724e-09,   3.952726861474256e-11,  -3.432772676260797e-12,
  -8.682255265329234e-15,   2.762153359642309e-15,   1.820939302534034e-17,  -2.413028600021928e-18,   1.709629231240229e-02,  -1.675126013849215e-04,   1.323993190425038e-06,
  -4.314672713419874e-09,   3.949806601200953e-11,  -3.419502307029621e-12,  -8.567431192877045e-15,   2.742467208341483e-15,   1.797660307141057e-17,  -2.387557748898528e-18,
   1.709662062059210e-02,  -1.675158338483094e-04,   1.324051805853970e-06,  -4.323063503744236e-09,   3.946722452858829e-11,  -3.405456292001485e-12,  -8.446141446363306e-15,
   2.721655818946672e-15,   1.773106440682579e-17,  -2.360669970480783e-18,   1.709687900426422e-02,  -1.675183792624830e-04,   1.324097925975297e-06,  -4.329659002260452e-09,
   3.944305664659340e-11,  -3.394427200520738e-12,  -8.351080832964579e-15,   2.705332835249681e-15,   1.753888349273134e-17,  -2.339609231737981e-18,   1.709702812389735e-02,
  -1.675198488510548e-04,   1.324124538587674e-06,  -4.333462151222787e-09,   3.942915070217957e-11,  -3.388072178811927e-12,  -8.296377415558906e-15,   2.695934792136009e-15,
   1.742839523233177e-17,  -2.327494660183387e-18,   1.709708412006011e-02,  -1.675204008058135e-04,   1.324134531093326e-06,  -4.334889659106306e-09,   3.942393677450930e-11,
  -3.385687708646466e-12,  -8.275865535363912e-15,   2.692409936451960e-15,   1.738698558241305e-17,  -2.322953062141910e-18,   1.709709340223919e-02,  -1.675204923059981e-04,
   1.324136187452260e-06,  -4.335126256676510e-09,   3.942307290749215e-11,  -3.385292548963487e-12,  -8.272466968281982e-15,   2.691825862739660e-15,   1.738012554512403e-17,
  -2.322200624876158e-18,   4.771292867339898e-02,  -4.672092259306461e-04,   3.674991845578423e-06,  -1.136929591838014e-08,   1.030487890501338e-10,  -9.678695534174872e-12,
  -2.526187460769499e-14,   7.887583051898742e-15,   5.185583268498376e-17,  -6.909893250434395e-18,   4.771345182808744e-02,  -4.672141276707934e-04,   3.675079542089685e-06,
  -1.138287548710040e-08,   1.029972084890345e-10,  -9.655668253599476e-12,  -2.506357695721742e-14,   7.853367780218684e-15,   5.145161506728654e-17,  -6.865497076130187e-18,
   4.771431068017712e-02,  -4.672221788159035e-04,   3.675223479016390e-06,  -1.140514508765613e-08,   1.029128321973897e-10,  -9.617938384674531e-12,  -2.473918571263268e-14,
   7.797360060951869e-15,   5.079111518383788e-17,  -6.792906137872404e-18,   4.771522200085824e-02,  -4.672307273331561e-04,   3.675376165067956e-06,  -1.142874301284686e-08,
   1.028237113005872e-10,  -9.578003289053767e-12,  -2.439653481585903e-14,   7.738151379142425e-15,   5.009445475533754e-17,  -6.716277760752481e-18,   4.771593922388124e-02,
  -4.672374591344069e-04,   3.675496299352230e-06,  -1.144729168140393e-08,   1.027538679686685e-10,  -9.546645841389413e-12,  -2.412798760223659e-14,   7.691712542717215e-15,
   4.954919328317859e-17,  -6.656256599147167e-18,   4.771635315086319e-02,  -4.672413458203024e-04,   3.675565619020579e-06,  -1.145798726267919e-08,   1.027136781331521e-10,
  -9.528577529978455e-12,  -2.397345180289141e-14,   7.664975248566986e-15,   4.923571603072561e-17,  -6.621731404636402e-18,   4.771650858523201e-02,  -4.672428056178046e-04,
   3.675591646946986e-06,  -1.146200181874694e-08,   1.026986087463165e-10,  -9.521798115270684e-12,  -2.391550661210902e-14,   7.654947106578570e-15,   4.911822922246571e-17,
  -6.608788391320088e-18,   4.771653435073889e-02,  -4.672430476163970e-04,   3.675595961327172e-06,  -1.146266719706064e-08,   1.026961119552500e-10,  -9.520674615814375e-12,
  -2.390590582351757e-14,   7.653285429949585e-15,   4.909876606595263e-17,  -6.606644036914829e-18,   9.419531194104420e-02,  -9.214636758934524e-04,   7.193117191372705e-06,
  -2.045605968040127e-08,   1.805464079292684e-10,  -1.934587394059314e-11,  -5.238118901045448e-14,   1.602585084370319e-14,   1.043381709902776e-16,  -1.405672091885756e-17,
   9.419633588324779e-02,  -9.214725048296144e-04,   7.193270745380917e-06,  -2.048319627640383e-08,   1.804393087979116e-10,  -1.929908877312993e-11,  -5.198230440332564e-14,
   1.595625340531963e-14,   1.035196580987512e-16,  -1.396616777035043e-17,   9.419801686584116e-02,  -9.214870072394823e-04,   7.193522764534847e-06,  -2.052769772828538e-08,
   1.802640947581699e-10,  -1.922243211696073e-11,  -5.132979207220462e-14,   1.584232873878388e-14,   1.021822188121348e-16,  -1.381810865105266e-17,   9.419980053970289e-02,
  -9.215024066656838e-04,   7.193790088738517e-06,  -2.057485251430069e-08,   1.800790014882219e-10,  -1.914129527971465e-11,  -5.064057109668012e-14,   1.572189423380897e-14,
   1.007715957728848e-16,  -1.366181705102958e-17,   9.420120431590584e-02,  -9.215145342330337e-04,   7.194000411027460e-06,  -2.061191680371380e-08,   1.799339260090209e-10,
  -1.907758596634883e-11,  -5.010041997749386e-14,   1.562743533600646e-14,   9.966755774870453e-17,  -1.353939935777330e-17,   9.420201446881550e-02,  -9.215215365493751e-04,
   7.194121766825752e-06,  -2.063328860159582e-08,   1.798504376770263e-10,  -1.904087642117622e-11,  -4.978959537380260e-14,   1.557305070064427e-14,   9.903284406042741e-17,
  -1.346898331615988e-17,   9.420231869046339e-02,  -9.215241666047374e-04,   7.194167332357581e-06,  -2.064131038692055e-08,   1.798191318208679e-10,  -1.902710263791632e-11,
  -4.967304880912854e-14,   1.555265315831048e-14,   9.879496445166523e-17,  -1.344258545775991e-17,   9.420236911961802e-02,  -9.215246026065477e-04,   7.194174885244831e-06,
  -2.064263992611395e-08,   1.798139447913106e-10,  -1.902482001703871e-11,  -4.965373857021737e-14,   1.554927326154721e-14,   9.875555683230411e-17,  -1.343821195738215e-17,
   1.572627876750149e-01,  -1.536252826027681e-03,   1.186024691163556e-05,  -2.936829555591032e-08,   2.462434059803155e-10,  -3.288001521969085e-11,  -9.312497709859939e-14,
   2.785155449522824e-14,   1.788206411274835e-16,  -2.447887164312532e-17,   1.572644758959132e-01,  -1.536265526753504e-03,   1.186045608857844e-05,  -2.941440152193193e-08,
   2.460526966881240e-10,  -3.279871022652153e-11,  -9.244160052392260e-14,   2.773037082435172e-14,   1.774054148964860e-16,  -2.432058368556763e-17,   1.572672474051717e-01,
  -1.536286391118620e-03,   1.186079937124446e-05,  -2.949000909919697e-08,   2.457406554779320e-10,  -3.266549394742779e-11,  -9.132374047459568e-14,   2.753200641079485e-14,
   1.750930227331413e-16,  -2.406177915903689e-17,   1.572701882198317e-01,  -1.536308548928772e-03,   1.186116346454770e-05,  -2.957012215709932e-08,   2.454109643137399e-10,
  -3.252449253774317e-11,  -9.014304176366124e-14,   2.732231013959558e-14,   1.726541913516475e-16,  -2.378859055737540e-17,   1.572725026775135e-01,  -1.536326001064443e-03,
   1.186144989511416e-05,  -2.963309026920910e-08,   2.451525129277208e-10,  -3.241377754827352e-11,  -8.921774898527289e-14,   2.715784383984520e-14,   1.707454832942520e-16,
  -2.357461600453101e-17,   1.572738384047527e-01,  -1.536336078570459e-03,   1.186161515467770e-05,  -2.966939785206885e-08,   2.450037624970286e-10,  -3.234998334801867e-11,
  -8.868531269819982e-14,   2.706315336653249e-14,   1.696481901383517e-16,  -2.345153719621999e-17,   1.572743399852109e-01,  -1.536339863820355e-03,   1.186167720277006e-05,
  -2.968302556338282e-08,   2.449479820402976e-10,  -3.232604717131996e-11,  -8.848567347570847e-14,   2.702763885017849e-14,   1.692369489136181e-16,  -2.340539723598020e-17,
   1.572744231294357e-01,  -1.536340491334886e-03,   1.186168748768046e-05,  -2.968528422741886e-08,   2.449387396806900e-10,  -3.232208041873146e-11,  -8.845259601421296e-14,
   2.702175406168060e-14,   1.691688221252841e-16,  -2.339775295423522e-17,   2.379732667983802e-01,  -2.320165278626296e-03,   1.763536550906924e-05,  -3.439293083061474e-08,
   2.563656877246205e-10,  -5.100354820506755e-11,  -1.517136018095975e-13,   4.445782190640550e-14,   2.799971827266154e-16,  -3.920149962247483e-17,   2.379757768770830e-01,
  -2.320180214074855e-03,   1.763558264837820e-05,  -3.446441974971933e-08,   2.560544770541776e-10,  -5.087377515822969e-11,  -1.506441002376681e-13,   4.426378811123520e-14,
   2.777554082560733e-16,  -3.894669439956025e-17,   2.379798975996904e-01,  -2.320204754836532e-03,   1.763593892962798e-05,  -3.458164818047223e-08,   2.555452000769367e-10,
  -5.066114641634147e-11,  -1.488946965115574e-13,   4.394618091028935e-14,   2.740926393787553e-16,  -3.853009209064195e-17,   2.379842700350169e-01,  -2.320230824095347e-03,
   1.763631671651167e-05,  -3.470585716702584e-08,   2.550070220014828e-10,  -5.043609342972558e-11,  -1.470470552730131e-13,   4.361043656967549e-14,   2.702297999905808e-16,
  -3.809034930653373e-17,   2.379877111864268e-01,  -2.320251362163153e-03,   1.763661385252877e-05,  -3.480348055512079e-08,   2.545850647373971e-10,  -5.025938198591456e-11,
  -1.455991653821554e-13,   4.334711465191705e-14,   2.672067660580279e-16,  -3.774593142817824e-17,   2.379896971509444e-01,  -2.320263223665886e-03,   1.763678526181903e-05,
  -3.485976897602957e-08,   2.543421816180739e-10,  -5.015756099571688e-11,  -1.447660434693652e-13,   4.319551057485680e-14,   2.654689199581406e-16,  -3.754782521880304e-17,
   2.379904429020225e-01,  -2.320267679399562e-03,   1.763684961379556e-05,  -3.488089602669670e-08,   2.542510967661498e-10,  -5.011935690850331e-11,  -1.444536665104928e-13,
   4.313865046012749e-14,   2.648176248876489e-16,  -3.747355963286085e-17,   2.379905665210254e-01,  -2.320268418086719e-03,   1.763686028032303e-05,  -3.488439762034586e-08,
   2.542360044839605e-10,  -5.011302565332392e-11,  -1.444019102589111e-13,   4.312922870516401e-14,   2.647097310411900e-16,  -3.746125565112599e-17,   3.378354292345342e-01,
  -3.285021359444313e-03,   2.442912488671212e-05,  -2.918921672435984e-08,   1.359773932854772e-10,  -7.493003730163270e-11,  -2.332614802159855e-13,   6.766123911054128e-14,
   4.149641722650520e-16,  -5.997405049977352e-17,   3.378389059064701e-01,  -3.285034191478410e-03,   2.442923828436679e-05,  -2.929418461869941e-08,   1.354981883965061e-10,
  -7.473255643371651e-11,  -2.316774652423886e-13,   6.736446133738595e-14,   4.115920610023296e-16,  -5.958147179905847e-17,   3.378446134375317e-01,  -3.285055289342610e-03,
   2.442942415513426e-05,  -2.946630524121251e-08,   1.347139032540404e-10,  -7.440899389668126e-11,  -2.290866075775476e-13,   6.687868632203316e-14,   4.060827850085591e-16,
  -5.893963398885220e-17,   3.378506695846309e-01,  -3.285077719269294e-03,   2.442962098527394e-05,  -2.964866548003465e-08,   1.338849797538263e-10,  -7.406652937712214e-11,
  -2.263504576869431e-13,   6.636518473221780e-14,   4.002730061881569e-16,  -5.826217442021247e-17,   3.378554358154520e-01,  -3.285095403181072e-03,   2.442977560763260e-05,
  -2.979198653226444e-08,   1.332349693187163e-10,  -7.379762959056057e-11,  -2.242064372287503e-13,   6.596245908391013e-14,   3.957266194270273e-16,  -5.773159198465588e-17,
   3.378581865049584e-01,  -3.285105621507094e-03,   2.442986472958588e-05,  -2.987462087204569e-08,   1.328607782188037e-10,  -7.364269099601109e-11,  -2.229728159163557e-13,
   6.573059918271916e-14,   3.931131702052493e-16,  -5.742641406064239e-17,   3.378592194170704e-01,  -3.285109460969637e-03,   2.442989817431214e-05,  -2.990563595943021e-08,
   1.327204436629913e-10,  -7.358455697417190e-11,  -2.225102834984741e-13,   6.564363934638117e-14,   3.921337475207215e-16,  -5.731201129716156e-17,   3.378593906370827e-01,
  -3.285110097541016e-03,   2.442990371712308e-05,  -2.991077636680521e-08,   1.326971905819319e-10,  -7.357492290408620e-11,  -2.224336492722629e-13,   6.562923008952728e-14,
   3.919714971354592e-16,  -5.729305765696222e-17,   4.590006610141685e-01,  -4.446775645453248e-03,   3.204857913772884e-05,  -2.477256976438396e-09,  -2.483609575834519e-10,
  -1.068280139432675e-10,  -3.416399144280797e-13,   1.006103844185328e-13,   5.942249539181706e-16,  -8.994194259764986e-17,   4.590052213279340e-01,  -4.446777230914140e-03,
   3.204836310924566e-05,  -2.626808709159707e-09,  -2.490634475335616e-10,  -1.065344226614575e-10,  -3.393735096953242e-13,   1.001654638496255e-13,   5.893037177771582e-16,
  -8.934747992109115e-17,   4.590127077984076e-01,  -4.446779879276560e-03,   3.204800803841569e-05,  -2.872023038637011e-09,  -2.502132552425943e-10,  -1.060533958334190e-10,
  -3.356667865501588e-13,   9.943722540685504e-14,   5.812641682745703e-16,  -8.837562293169399e-17,   4.590206514914655e-01,  -4.446782751280062e-03,   3.204763070419972e-05,
  -3.131808500493038e-09,  -2.514286220917000e-10,  -1.055442788266916e-10,  -3.317525603818978e-13,   9.866745012958666e-14,   5.727869833385507e-16,  -8.734989125320028e-17,
   4.590269031973864e-01,  -4.446785056330329e-03,   3.204733332359407e-05,  -3.335967562087565e-09,  -2.523817515591445e-10,  -1.051445328007958e-10,  -3.286856750510750e-13,
   9.806375665137503e-14,   5.661538796091438e-16,  -8.654658958066551e-17,   4.590305111701949e-01,  -4.446786404552497e-03,   3.204716153273407e-05,  -3.453674251456597e-09,
  -2.529304730956274e-10,  -1.049142043811360e-10,  -3.269211637968341e-13,   9.771620253524359e-14,   5.623411546653670e-16,  -8.608456847167959e-17,   4.590318659981740e-01,
  -4.446786914211249e-03,   3.204709699208534e-05,  -3.497852091835067e-09,  -2.531362690371451e-10,  -1.048277841596787e-10,  -3.262596001684869e-13,   9.758585276659115e-14,
   5.609123365467590e-16,  -8.591137297062809e-17,   4.590320905802152e-01,  -4.446786998873173e-03,   3.204708629188952e-05,  -3.505174030902173e-09,  -2.531703692453828e-10,
  -1.048134624824828e-10,  -3.261499907077672e-13,   9.756425387490242e-14,   5.606756422073343e-16,  -8.588267904411179e-17,   6.046060205509698e-01,  -5.826700867708032e-03,
   4.006601166394650e-05,   6.723695626909948e-08,  -1.150159352237080e-09,  -1.510117337363737e-10,  -4.695320270641857e-13,   1.491745619933889e-13,   8.321315188974775e-16,
  -1.352728240490914e-16,   6.046117202528446e-01,  -5.826672908326115e-03,   4.006502415922221e-05,   6.702571990926687e-08,  -1.151124167641228e-09,  -1.505765722213817e-10,
  -4.663617455021821e-13,   1.485057270310121e-13,   8.250682011431244e-16,  -1.343664220039827e-16,   6.046210771337701e-01,  -5.826627072802611e-03,   4.006340242671426e-05,
   6.667938442000326e-08,  -1.152703253740626e-09,  -1.498636132234450e-10,  -4.611772252159732e-13,   1.474110351441215e-13,   8.135306174894023e-16,  -1.328846940738094e-16,
   6.046310053687910e-01,  -5.826578525121577e-03,   4.006168085149647e-05,   6.631249722174757e-08,  -1.154372259490600e-09,  -1.491090469450656e-10,  -4.557031532155690e-13,
   1.462539669716791e-13,   8.013668313662458e-16,  -1.313209662782864e-16,   6.046388188414024e-01,  -5.826540381028927e-03,   4.006032539080150e-05,   6.602418996270838e-08,
  -1.155681063406931e-09,  -1.485165996721720e-10,  -4.514145834760628e-13,   1.453465852802996e-13,   7.918504255539904e-16,  -1.300964336003314e-16,   6.046433281089338e-01,
  -5.826518392636828e-03,   4.005954289907383e-05,   6.585797632724809e-08,  -1.156434515084540e-09,  -1.481752470966894e-10,  -4.489473808450105e-13,   1.448242118853211e-13,
   7.863809058516914e-16,  -1.293921805899489e-16,   6.046450213761136e-01,  -5.826510140558474e-03,   4.005924902244193e-05,   6.579559434063430e-08,  -1.156717087973185e-09,
  -1.480471715996517e-10,  -4.480223960439104e-13,   1.446282997360965e-13,   7.843313051341194e-16,  -1.291281884469229e-16,   6.046453020589838e-01,  -5.826508772910560e-03,
   4.005920030590553e-05,   6.578525536773492e-08,  -1.156763909721405e-09,  -1.480259468307397e-10,  -4.478691442827550e-13,   1.445958373692687e-13,   7.839917788714346e-16,
  -1.290844523122560e-16,   7.794380553563448e-01,  -7.452392206227166e-03,   4.746635250072342e-05,   2.253835933425100e-07,  -3.098251144930495e-09,  -2.176502829703464e-10,
  -5.515133408481189e-13,   2.255821358400482e-13,   1.139470735793324e-15,  -2.097502726034449e-16,   7.794448048342709e-01,  -7.452297058604723e-03,   4.746370072247083e-05,
   2.250793986777676e-07,  -3.099377218259443e-09,  -2.169926250108948e-10,  -5.471791090417285e-13,   2.245458333252054e-13,   1.129457695122647e-15,  -2.083155624037255e-16,
   7.794558849212100e-01,  -7.452140950955500e-03,   4.745934672033720e-05,   2.245806835183481e-07,  -3.101219271505517e-09,  -2.159151867222891e-10,  -5.400921150346097e-13,
   2.228498107702660e-13,   1.113104930779273e-15,  -2.059704394606647e-16,   7.794676413782247e-01,  -7.451975434375565e-03,   4.745472586695127e-05,   2.240524170148829e-07,
  -3.103164915472433e-09,  -2.147749438664569e-10,  -5.326106622503977e-13,   2.210572951078486e-13,   1.095868747817977e-15,  -2.034958732127870e-16,   7.794768935026181e-01,
  -7.451845262881123e-03,   4.745108856621346e-05,   2.236373255464518e-07,  -3.104689709957148e-09,  -2.138797357808233e-10,  -5.267504149189866e-13,   2.196516970670617e-13,
   1.082386905048703e-15,  -2.015583195609249e-16,   7.794822329766671e-01,  -7.451770174784281e-03,   4.744898914289231e-05,   2.233980312012110e-07,  -3.105567124272591e-09,
  -2.133639615632140e-10,  -5.233794190708583e-13,   2.188425465239634e-13,   1.074639458001060e-15,  -2.004440914322070e-16,   7.794842379818805e-01,  -7.451741985337221e-03,
   4.744820073836007e-05,   2.233082234779086e-07,  -3.105896116208251e-09,  -2.131704470648302e-10,  -5.221156644187989e-13,   2.185390888363185e-13,   1.071736471800926e-15,
  -2.000264368107454e-16,   7.794845703391182e-01,  -7.451737312895740e-03,   4.744807004637722e-05,   2.232933391823527e-07,  -3.105950625716803e-09,  -2.131383779059881e-10,
  -5.219062890384838e-13,   2.184888067493928e-13,   1.071255589999153e-15,  -1.999572440589293e-16,   9.913822246920145e-01,  -9.355190460084428e-03,   5.150512808612937e-05,
   5.846068056995280e-07,  -7.350148330230554e-09,  -3.382188021470625e-10,  -1.970732567993978e-13,   3.602129836398956e-13,   1.440303326787164e-15,  -3.509867678299254e-16,
   9.913895416255059e-01,  -9.354942546040610e-03,   5.149885021905628e-05,   5.841343267336443e-07,  -7.350504540993651e-09,  -3.371698652025579e-10,  -1.916131310599162e-13,
   3.584811312033191e-13,   1.426746109792947e-15,  -3.485009342957582e-16,   9.914015529103566e-01,  -9.354535698740753e-03,   5.148854388437247e-05,   5.833597435361302e-07,
  -7.351081041405029e-09,  -3.354515634390583e-10,  -1.826877909392671e-13,   3.556470814015139e-13,   1.404612760979892e-15,  -3.444384016629257e-16,   9.914142969344557e-01,
  -9.354104197467850e-03,   5.147760779777711e-05,   5.825392996439318e-07,  -7.351681535440365e-09,  -3.336333277069231e-10,  -1.732692306900621e-13,   3.526522204621719e-13,
   1.381293971410624e-15,  -3.401526001632771e-16,   9.914243259130920e-01,  -9.353764744858099e-03,   5.146900084757869e-05,   5.818946533039286e-07,  -7.352146030694082e-09,
  -3.322059894687716e-10,  -1.658942123687445e-13,   3.503041149269762e-13,   1.363061827716815e-15,  -3.367975722269559e-16,   9.914301135781148e-01,  -9.353568896657184e-03,
   5.146403353182411e-05,   5.815230345792589e-07,  -7.352410862648557e-09,  -3.313836941351488e-10,  -1.616529028657602e-13,   3.489525216657214e-13,   1.352587547787373e-15,
  -3.348684775641367e-16,   9.914322868557495e-01,  -9.353495364391071e-03,   5.146216824098995e-05,   5.813835672386030e-07,  -7.352509698767000e-09,  -3.310751877008413e-10,
  -1.600630702997350e-13,   3.484456537508729e-13,   1.348663371117566e-15,  -3.341454331260187e-16,   9.914326471050861e-01,  -9.353483175928767e-03,   5.146185904157859e-05,
   5.813604527064478e-07,  -7.352526050063726e-09,  -3.310240627712751e-10,  -1.597996814904958e-13,   3.483616683932674e-13,   1.348013357906019e-15,  -3.340256492937357e-16,
   1.255238439542878e+00,  -1.153797774080500e-02,   4.267495164883004e-05,   1.510667263130240e-06,  -1.740224399759967e-08,  -6.704979430078558e-10,   3.584123223388559e-12,
   6.595312603472842e-13,   3.557515649864911e-16,  -6.999547039825420e-16,   1.255244482709550e+00,  -1.153733611448801e-02,   4.266013627975373e-05,   1.509729224506128e-06,
  -1.739457921644554e-08,  -6.685817111579443e-10,   3.585332884105942e-12,   6.560875729146877e-13,   3.456248532311729e-16,  -6.946173754308799e-16,   1.255254402029087e+00,
  -1.153628306671557e-02,   4.263581918753618e-05,   1.508191230594608e-06,  -1.738199448023772e-08,  -6.654432530253618e-10,   3.587290236382718e-12,   6.504536468679069e-13,
   3.291160767971977e-16,  -6.858976406190234e-16,   1.255264925132895e+00,  -1.153516608956147e-02,   4.261002330744265e-05,   1.506561943995719e-06,  -1.736863873754744e-08,
  -6.621230681939204e-10,   3.589328582538949e-12,   6.445019572688464e-13,   3.117555709200056e-16,  -6.767026393033226e-16,   1.255273205378984e+00,  -1.153428730328270e-02,
   4.258972647318699e-05,   1.505281597860728e-06,  -1.735812600411984e-08,  -6.595172600478000e-10,   3.590904997072132e-12,   6.398369516568738e-13,   2.982054421981985e-16,
  -6.695074234335686e-16,   1.255277983472957e+00,  -1.153378025093649e-02,   4.257801464091538e-05,   1.504543450030064e-06,  -1.735205822723001e-08,  -6.580162753622384e-10,
   3.591803689498303e-12,   6.371522821691841e-13,   2.904303401972124e-16,  -6.653714137260112e-16,   1.255279777581744e+00,  -1.153358986897317e-02,   4.257361708446191e-05,
   1.504266412639593e-06,  -1.734977959021540e-08,  -6.574531839903839e-10,   3.592139067324922e-12,   6.361455953006344e-13,   2.875191798543110e-16,  -6.638214101022719e-16,
   1.255280074974995e+00,  -1.153355831155765e-02,   4.257288814515820e-05,   1.504220497344523e-06,  -1.734940186686086e-08,  -6.573598721802085e-10,   3.592194550870887e-12,
   6.359787980882725e-13,   2.870370594184967e-16,  -6.635646386505161e-16,   1.606528839027078e+00,  -1.356620780462481e-02,  -3.727361753656482e-05,   5.054039201828934e-06,
  -3.288905482532139e-08,  -3.625386196285641e-09,   6.293527333086166e-11,   2.807134038249494e-12,  -8.092939350478449e-14,  -2.139725565637191e-15,   1.606523479742916e+00,
  -1.356406809255230e-02,  -3.730096114742516e-05,   5.048949253469710e-06,  -3.275838809632788e-08,  -3.617166799593706e-09,   6.262445618626571e-11,   2.796482362376119e-12,
  -8.036394578885179e-14,  -2.128113621655643e-15,   1.606514678915215e+00,  -1.356055696326001e-02,  -3.734577063079597e-05,   5.040601663209023e-06,  -3.254435089879742e-08,
  -3.603696136166830e-09,   6.211580490415739e-11,   2.779038466631745e-12,  -7.943970548826582e-14,  -2.109109461400780e-15,   1.606505336897773e+00,  -1.355683349482071e-02,
  -3.739320909472208e-05,   5.031755606197997e-06,  -3.231788291709376e-08,  -3.589433666970648e-09,   6.157826210124060e-11,   2.760586861040901e-12,  -7.846447607286775e-14,
  -2.089024221090013e-15,   1.606497982035034e+00,  -1.355390463299503e-02,  -3.743046544429774e-05,   5.024801943302523e-06,  -3.214011521841399e-08,  -3.578231395115844e-09,
   6.115678328945262e-11,   2.746107045477587e-12,  -7.770090280001763e-14,  -2.073274561481344e-15,   1.606493736340410e+00,  -1.355221494146109e-02,  -3.745193559823553e-05,
   5.020792144355872e-06,  -3.203770756879860e-08,  -3.571775297606064e-09,   6.091416741785528e-11,   2.737767143633343e-12,  -7.726180262734087e-14,  -2.064208141978748e-15,
   1.606492141839731e+00,  -1.355158056110015e-02,  -3.745999195961024e-05,   5.019287047543812e-06,  -3.199928751073987e-08,  -3.569352659398012e-09,   6.082318121224805e-11,
   2.734638577160766e-12,  -7.709721279697493e-14,  -2.060807956538809e-15,   1.606491877517865e+00,  -1.355147540957296e-02,  -3.746132710595921e-05,   5.019037589037161e-06,
  -3.199292068331006e-08,  -3.568951161587490e-09,   6.080810519126716e-11,   2.734120138553248e-12,  -7.706994531069005e-14,  -2.060244556236035e-15,   1.823130679386875e-03,
  -1.741992056130513e-05,   1.414594899004243e-07,  -4.758766043462650e-10,  -2.613800290020233e-12,  -3.022372665171107e-13,   7.020015623282329e-15,   2.166387863100895e-16,
  -6.907852230475306e-18,  -1.654305556674359e-19,   1.823150805791758e-03,  -1.742012522310718e-05,   1.414573410806607e-07,  -4.763013666437317e-10,  -2.599130806547568e-12,
  -3.016029625024682e-13,   6.993351321423206e-15,   2.158153179891448e-16,  -6.866123449718803e-18,  -1.645305536687599e-19,   1.823183846335862e-03,  -1.742046133841249e-05,
   1.414538223986778e-07,  -4.769980357240018e-10,  -2.575089158809592e-12,  -3.005634129159864e-13,   6.949696225948820e-15,   2.144667581023739e-16,  -6.797881742676148e-18,
  -1.630578180229677e-19,   1.823218904626386e-03,  -1.742081815907934e-05,   1.414501009600268e-07,  -4.777363771567109e-10,  -2.549634305293893e-12,  -2.994627627946623e-13,
   6.903535668748112e-15,   2.130403026318630e-16,  -6.725828015216301e-18,  -1.615015887124218e-19,   1.823246495482645e-03,  -1.742109910641752e-05,   1.414471809580772e-07,
  -4.783168206003744e-10,  -2.529641085039371e-12,  -2.985982744400709e-13,   6.867323222002115e-15,   2.119209041321516e-16,  -6.669378147368191e-18,  -1.602814900619124e-19,
   1.823262418624231e-03,  -1.742126129774015e-05,   1.414454992877500e-07,  -4.786515515191884e-10,  -2.518118568240751e-12,  -2.981000534052124e-13,   6.846470765468215e-15,
   2.112761694191314e-16,  -6.636902446262054e-18,  -1.595792117342416e-19,   1.823268397906924e-03,  -1.742132221185352e-05,   1.414448684687007e-07,  -4.787771982645447e-10,
  -2.513794762462471e-12,  -2.979130971474576e-13,   6.838649228513416e-15,   2.110343090401139e-16,  -6.624726856746129e-18,  -1.593158511307469e-19,   1.823269389057809e-03,
  -1.742133230974920e-05,   1.414447639364792e-07,  -4.787980234773118e-10,  -2.513078188684999e-12,  -2.978821133635361e-13,   6.837353159043011e-15,   2.109942300808916e-16,
  -6.622709598878616e-18,  -1.592722138924492e-19,   1.644662750431836e-02,  -1.571173772436255e-04,   1.273842266591406e-06,  -4.204613063412434e-09,  -2.508922785678654e-11,
  -2.734984229085632e-12,   6.381134728146883e-14,   1.970326793583373e-15,  -6.293161254063272e-17,  -1.504290609060427e-18,   1.644680873988113e-02,  -1.571191858546934e-04,
   1.273821598346152e-06,  -4.208456547276747e-09,  -2.495588983242601e-11,  -2.729215218535465e-12,   6.356843499042094e-14,   1.962838877690759e-15,  -6.255127763134055e-17,
  -1.496105470806579e-18,   1.644710626539218e-02,  -1.571221561572240e-04,   1.273787749456518e-06,  -4.214760363808742e-09,  -2.473736451142338e-11,  -2.719760486244632e-12,
   6.317073676632014e-14,   1.950576233448028e-15,  -6.192929368507736e-17,  -1.482711553612322e-18,   1.644742196024675e-02,  -1.571253094734048e-04,   1.273751943646983e-06,
  -4.221441212130089e-09,  -2.450599506140304e-11,  -2.709750038353197e-12,   6.275021446726459e-14,   1.937605280260397e-15,  -6.127256769105112e-17,  -1.468558285345334e-18,
   1.644767041179949e-02,  -1.571277923043224e-04,   1.273723844179195e-06,  -4.226693298203773e-09,  -2.432426942277349e-11,  -2.701887485952751e-12,   6.242031987742199e-14,
   1.927426442522401e-15,  -6.075806308705220e-17,  -1.457461979953181e-18,   1.644781379726573e-02,  -1.571292256571292e-04,   1.273707659419837e-06,  -4.229722066518633e-09,
  -2.421953741220888e-11,  -2.697356146558011e-12,   6.223035466068935e-14,   1.921563786912688e-15,  -6.046206842072858e-17,  -1.451075038560003e-18,   1.644786763978623e-02,
  -1.571297639827549e-04,   1.273701587924971e-06,  -4.230858962183430e-09,  -2.418023695687527e-11,  -2.695655771982601e-12,   6.215910074550460e-14,   1.919364519762390e-15,
  -6.035109605332685e-17,  -1.448679878291268e-18,   1.644787656494689e-02,  -1.571298532225426e-04,   1.273700581806505e-06,  -4.231047395868510e-09,  -2.417372379162005e-11,
  -2.695373973226391e-12,   6.214729360210583e-14,   1.919000076713959e-15,  -6.033271010171111e-17,  -1.448283014880150e-18,   4.590204793635873e-02,  -4.383415377204043e-04,
   3.542165041624477e-06,  -1.122660136560315e-08,  -7.872863276369937e-11,  -7.682012003081215e-12,   1.808956777961788e-13,   5.591085294973493e-15,  -1.791994352348038e-16,
  -4.267005353278230e-18,   4.590255188162085e-02,  -4.383463687115052e-04,   3.542099957025749e-06,  -1.123739552340005e-08,  -7.835067544148421e-11,  -7.665641474252627e-12,
   1.802040004090374e-13,   5.569845571711832e-15,  -1.781153549953080e-16,  -4.243781304622626e-18,   4.590337918299912e-02,  -4.383543028641238e-04,   3.541993340789511e-06,
  -1.125509918271767e-08,  -7.773125264918953e-11,  -7.638812077481672e-12,   1.790715829386482e-13,   5.535062196881385e-15,  -1.763425051599831e-16,  -4.205778105544930e-18,
   4.590425700511724e-02,  -4.383627260939772e-04,   3.541880525864910e-06,  -1.127386146550912e-08,  -7.707542887950373e-11,  -7.610405719126584e-12,   1.778741796953260e-13,
   5.498269715215971e-15,  -1.744706431797017e-16,  -4.165620289126487e-18,   4.590494784953213e-02,  -4.383693584621211e-04,   3.541791966373816e-06,  -1.128861108834027e-08,
  -7.656032668277958e-11,  -7.588094363615031e-12,   1.769348345281930e-13,   5.469397173802383e-15,  -1.730041637626748e-16,  -4.134136101996003e-18,   4.590534654686916e-02,
  -4.383731874303019e-04,   3.541740947640311e-06,  -1.129711681980266e-08,  -7.626346516875275e-11,  -7.575235895270053e-12,   1.763939268634333e-13,   5.452767606566137e-15,
  -1.721605016074267e-16,  -4.116014043835094e-18,   4.590549626121475e-02,  -4.383746254913366e-04,   3.541721806727324e-06,  -1.130030956660704e-08,  -7.615206889636106e-11,
  -7.570410783540163e-12,   1.761910384268981e-13,   5.446529332918395e-15,  -1.718442021007292e-16,  -4.109218105642673e-18,   4.590552107848576e-02,  -4.383748638834815e-04,
   3.541718634750373e-06,  -1.130083874469679e-08,  -7.613360749202592e-11,  -7.569611129965716e-12,   1.761574187723637e-13,   5.445495581630909e-15,  -1.717917974957062e-16,
  -4.108092060030581e-18,   9.062302338512193e-02,  -8.648806064154044e-04,   6.952407209912777e-06,  -2.057774267403353e-08,  -1.826770531373087e-10,  -1.531841076374084e-11,
   3.659808055686106e-13,   1.132427937106096e-14,  -3.649927947898960e-16,  -8.637796489508462e-18,   9.062401245884734e-02,  -8.648894674799592e-04,   6.952255555767838e-06,
  -2.059926256984562e-08,  -1.819124958562194e-10,  -1.528525323821287e-11,   3.645720711853369e-13,   1.128128373717680e-14,  -3.627812351342172e-16,  -8.590767872060886e-18,
   9.062563616858021e-02,  -8.649040209272864e-04,   6.952007057514822e-06,  -2.063455714136876e-08,  -1.806595006690586e-10,  -1.523091185016471e-11,   3.622656947435385e-13,
   1.121087171048242e-14,  -3.591645947943306e-16,  -8.513811306738070e-18,   9.062735902993660e-02,  -8.649194721911900e-04,   6.951744015052544e-06,  -2.067196149660170e-08,
  -1.793328917797996e-10,  -1.517337634707997e-11,   3.598269765214303e-13,   1.113639272933660e-14,  -3.553460117173260e-16,  -8.432491341002010e-18,   9.062871491630003e-02,
  -8.649316388793161e-04,   6.951537457281837e-06,  -2.070136571884333e-08,  -1.782909506357671e-10,  -1.512818588284522e-11,   3.579138479641458e-13,   1.107794613513675e-14,
  -3.523544371594195e-16,  -8.368735346988395e-18,   9.062949741899741e-02,  -8.649386631018820e-04,   6.951418432169175e-06,  -2.071832217480121e-08,  -1.776904692692660e-10,
  -1.510214171833472e-11,   3.568122058595169e-13,   1.104428297915660e-14,  -3.506334039283684e-16,  -8.332037798853664e-18,   9.062979125543903e-02,  -8.649413012564670e-04,
   6.951373771701328e-06,  -2.072468698118359e-08,  -1.774651417652901e-10,  -1.509236869946386e-11,   3.563989929303231e-13,   1.103165487530530e-14,  -3.499881693914898e-16,
  -8.318275865612148e-18,   9.062983996297701e-02,  -8.649417385941528e-04,   6.951366370416693e-06,  -2.072574190649456e-08,  -1.774277989018659e-10,  -1.509074904153608e-11,
   3.563305214679639e-13,   1.102956225836837e-14,  -3.498812668489493e-16,  -8.315995596171966e-18,   1.513053376210354e-01,  -1.442762990785313e-03,   1.151010173459957e-05,
  -3.054453555936540e-08,  -3.707324800495685e-10,  -2.594096744956581e-11,   6.326807772483982e-13,   1.959031334126969e-14,  -6.366680004695757e-16,  -1.493313949347768e-17,
   1.513069749716610e-01,  -1.442776159538645e-03,   1.150979265955925e-05,  -3.058096823395100e-08,  -3.694110271263044e-10,  -2.588360616993228e-11,   6.302236645676840e-13,
   1.951598247169129e-14,  -6.328012446135568e-16,  -1.485181533082978e-17,   1.513096629171857e-01,  -1.442797789308617e-03,   1.150928606918852e-05,  -3.064071985743770e-08,
  -3.672453970403246e-10,  -2.578959749267502e-11,   6.262009119254727e-13,   1.939425421340603e-14,  -6.264778842341384e-16,  -1.471873760382960e-17,   1.513125149937130e-01,
  -1.442820755283444e-03,   1.150874963226908e-05,  -3.070404151969630e-08,  -3.649525817994799e-10,  -2.569006296344518e-11,   6.219473658439357e-13,   1.926549512088261e-14,
  -6.198015537813845e-16,  -1.457811348142796e-17,   1.513147595629748e-01,  -1.442838840563945e-03,   1.150832824514643e-05,  -3.075381856216484e-08,  -3.631517990927673e-10,
  -2.561188483979165e-11,   6.186105645457581e-13,   1.916445286565191e-14,  -6.145712256643360e-16,  -1.446786151447822e-17,   1.513160549357923e-01,  -1.442849282314803e-03,
   1.150808537136862e-05,  -3.078252286550384e-08,  -3.621140029037186e-10,  -2.556682918771735e-11,   6.166891352575671e-13,   1.910625616027503e-14,  -6.115622833927643e-16,
  -1.440440090631663e-17,   1.513165413589006e-01,  -1.442853204123996e-03,   1.150799422972234e-05,  -3.079329727209780e-08,  -3.617245778151949e-10,  -2.554992213941783e-11,
   6.159684317782654e-13,   1.908442476029909e-14,  -6.104342032967602e-16,  -1.438060251734624e-17,   1.513166219903739e-01,  -1.442853854263674e-03,   1.150797912484749e-05,
  -3.079508305507520e-08,  -3.616600396756784e-10,  -2.554712017624538e-11,   6.158490076857299e-13,   1.908080705540988e-14,  -6.102473031495040e-16,  -1.437665926496359e-17,
   2.289721548642041e-01,  -2.180740178641320e-03,   1.721412125410775e-05,  -3.822511366703913e-08,  -6.997091818668766e-10,  -4.002325492437113e-11,   1.004004802870921e-12,
   3.106686605165344e-14,  -1.021732588380645e-15,  -2.366507260043244e-17,   2.289746033827305e-01,  -2.180756696146611e-03,   1.721353566685306e-05,  -3.828130337083872e-08,
  -6.976126754746727e-10,  -3.993228851670046e-11,   1.000062025643778e-12,   3.094907102528057e-14,  -1.015506292390418e-15,  -2.353620765694326e-17,   2.289786229639420e-01,
  -2.180783829465533e-03,   1.721257560968571e-05,  -3.837345507763259e-08,  -6.941769360938887e-10,  -3.978320464247937e-11,   9.936070227825656e-13,   3.075616347875721e-14,
  -1.005324517561072e-15,  -2.332533279266773e-17,   2.289828879712341e-01,  -2.180812643321637e-03,   1.721155865120293e-05,  -3.847110919833139e-08,  -6.905395113486591e-10,
  -3.962535734316556e-11,   9.867817650468707e-13,   3.055211385565735e-14,  -9.945746326278681e-16,  -2.310249713355233e-17,   2.289862444972170e-01,  -2.180835336841097e-03,
   1.721075955514019e-05,  -3.854787241487618e-08,  -6.876827356026249e-10,  -3.950137802568551e-11,   9.814275787622026e-13,   3.039198817597056e-14,  -9.861531973628460e-16,
  -2.292778777330756e-17,   2.289881815910995e-01,  -2.180848440470597e-03,   1.721029888396851e-05,  -3.859213749135686e-08,  -6.860363943041057e-10,  -3.942992613881497e-11,
   9.783445028687306e-13,   3.029976153419335e-14,  -9.813085194543976e-16,  -2.282722494286019e-17,   2.289889089847891e-01,  -2.180853362290193e-03,   1.721012599233406e-05,
  -3.860875257756446e-08,  -6.854186223571222e-10,  -3.940311394009653e-11,   9.771880851014986e-13,   3.026516444179772e-14,  -9.794922181112541e-16,  -2.278951268457594e-17,
   2.289890295604767e-01,  -2.180854178219566e-03,   1.721009733807959e-05,  -3.861150640254583e-08,  -6.853162413096123e-10,  -3.939867042022125e-11,   9.769964612545533e-13,
   3.025943132014148e-14,  -9.791912942478194e-16,  -2.278326397841615e-17,   3.250838949042939e-01,  -3.091065109949318e-03,   2.404323698560768e-05,  -3.866153479861422e-08,
  -1.266036418423193e-09,  -5.832342858801640e-11,   1.519598512502280e-12,   4.684212997097701e-14,  -1.567131827884274e-15,  -3.565964229762812e-17,   3.250873142960814e-01,
  -3.091081904326509e-03,   2.404217392557907e-05,  -3.874337784897116e-08,  -1.262864211028321e-09,  -5.818626920565013e-11,   1.513552023355142e-12,   4.666462596378350e-14,
  -1.557536206880528e-15,  -3.546565265970455e-17,   3.250929276747838e-01,  -3.091109500000671e-03,   2.404043067555683e-05,  -3.887759655819428e-08,  -1.257665743310519e-09,
  -5.796147993113629e-11,   1.503653015302357e-12,   4.637393506779539e-14,  -1.541844982366092e-15,  -3.514820180870035e-17,   3.250988837590736e-01,  -3.091138815078704e-03,
   2.403858357938025e-05,  -3.901982305440401e-08,  -1.252162280773541e-09,  -5.772347682029710e-11,   1.493186385549250e-12,   4.606645335949314e-14,  -1.525278726373463e-15,
  -3.481273736677381e-17,   3.251035711242748e-01,  -3.091161910750749e-03,   2.403713180446525e-05,  -3.913161870812187e-08,  -1.247840069036992e-09,  -5.753653983430700e-11,
   1.484975794120681e-12,   4.582515985226549e-14,  -1.512301111620958e-15,  -3.454971828873688e-17,   3.251062762525572e-01,  -3.091175249550196e-03,   2.403629471738610e-05,
  -3.919608316564699e-08,  -1.245349254801920e-09,  -5.742880403052875e-11,   1.480247979644871e-12,   4.568618320038494e-14,  -1.504835498608277e-15,  -3.439832208520267e-17,
   3.251072920472229e-01,  -3.091180260260323e-03,   2.403598052653336e-05,  -3.922027982135810e-08,  -1.244414612556185e-09,  -5.738837633703237e-11,   1.478474653680334e-12,
   4.563404867171886e-14,  -1.502036618211467e-15,  -3.434154628564085e-17,   3.251074604293118e-01,  -3.091181090955265e-03,   2.403592845247916e-05,  -3.922429021547436e-08,
  -1.244259718254072e-09,  -5.738167635374348e-11,   1.478180805767487e-12,   4.562540939997312e-14,  -1.501572902563930e-15,  -3.433213883719921e-17,   4.417258401532048e-01,
  -4.190733971495100e-03,   3.192568462354357e-05,  -2.303162763331004e-08,  -2.240557544612013e-09,  -8.211020548152681e-11,   2.251942253805036e-12,   6.870777034768778e-14,
  -2.357236536818585e-15,  -5.228388006989188e-17,   4.417303796194083e-01,  -4.190744210698497e-03,   3.192379810953260e-05,  -2.314678163425689e-08,  -2.235858111778048e-09,
  -8.190901957950833e-11,   2.242849328669239e-12,   6.844749287636956e-14,  -2.342703595925473e-15,  -5.200031277803601e-17,   4.417378316982712e-01,  -4.190761055146743e-03,
   3.192070395762512e-05,  -2.333562035169840e-08,  -2.228157102670973e-09,  -8.157929764983172e-11,   2.227963136609523e-12,   6.802124422358340e-14,  -2.318939356993451e-15,
  -5.153625779716104e-17,   4.417457386724318e-01,  -4.190778976130689e-03,   3.191742471402255e-05,  -2.353571423792720e-08,  -2.220004553312417e-09,  -8.123019337797438e-11,
   2.212223741493410e-12,   6.757037050670620e-14,  -2.293850878685016e-15,  -5.104584813134233e-17,   4.417519613163603e-01,  -4.190793114564838e-03,   3.191484674542704e-05,
  -2.369298771703685e-08,  -2.213602050667721e-09,  -8.095599301727572e-11,   2.199877189006862e-12,   6.721654839168395e-14,  -2.274197869596777e-15,  -5.066132919325263e-17,
   4.417555524512202e-01,  -4.190801287962414e-03,   3.191336007587719e-05,  -2.378367264213099e-08,  -2.209912482449859e-09,  -8.079796539078049e-11,   2.192767922358034e-12,
   6.701275798045286e-14,  -2.262892398058171e-15,  -5.043999021431278e-17,   4.417569009439687e-01,  -4.190804359767589e-03,   3.191280202946333e-05,  -2.381771049439156e-08,
  -2.208528040290012e-09,  -8.073866575673332e-11,   2.190101373886052e-12,   6.693630953844450e-14,  -2.258653997268810e-15,  -5.035698365298782e-17,   4.417571244752000e-01,
  -4.190804869101093e-03,   3.191270953650439e-05,  -2.382335195192844e-08,  -2.208298603359248e-09,  -8.072883817202029e-11,   2.189659516197590e-12,   6.692364116867357e-14,
  -2.257951786195684e-15,  -5.034322984374304e-17,   5.819446425960638e-01,  -5.503484693013207e-03,   4.066467143419917e-05,   2.547592687892063e-08,  -3.948588224848866e-09,
  -1.136980622313057e-10,   3.347241559575058e-12,   9.974244190407097e-14,  -3.557352254609900e-15,  -7.589529727141629e-17,   5.819504227776943e-01,  -5.503474379227517e-03,
   4.066133943807800e-05,   2.531658657610616e-08,  -3.941605468487785e-09,  -1.134060036447574e-10,   3.333523810131943e-12,   9.936453816938230e-14,  -3.535197598240746e-15,
  -7.548689403466567e-17,   5.819599115451677e-01,  -5.503457496073025e-03,   4.065587368514034e-05,   2.505530158390060e-08,  -3.930163066567049e-09,  -1.129273514054165e-10,
   3.311066879880483e-12,   9.874564471259119e-14,  -3.498971852111832e-15,  -7.481849736201458e-17,   5.819699794042502e-01,  -5.503439647734856e-03,   4.065007987875081e-05,
   2.477846243461333e-08,  -3.918050176788691e-09,  -1.124205623907525e-10,   3.287323703955063e-12,   9.809098087600462e-14,  -3.460729503794747e-15,  -7.411207492760596e-17,
   5.819779025318705e-01,  -5.503425648741194e-03,   4.064552430201659e-05,   2.456088102670394e-08,  -3.908537777633325e-09,  -1.120225103778176e-10,   3.268699327385072e-12,
   9.757722347324890e-14,  -3.430773911531045e-15,  -7.355813782702789e-17,   5.819824749913793e-01,  -5.503417588772871e-03,   4.064289686308806e-05,   2.443542765617941e-08,
  -3.903056193413676e-09,  -1.117931044395142e-10,   3.257975480670813e-12,   9.728131079306942e-14,  -3.413542427962597e-15,  -7.323925844952984e-17,   5.819841919703804e-01,
  -5.503414565787856e-03,   4.064191054973576e-05,   2.438834079006161e-08,  -3.900999353689653e-09,  -1.117070202159389e-10,   3.253953220872871e-12,   9.717030341586458e-14,
  -3.407082487387723e-15,  -7.311966870869027e-17,   5.819844765829070e-01,  -5.503414064875397e-03,   4.064174707084982e-05,   2.438053663470797e-08,  -3.900658484776310e-09,
  -1.116927536869801e-10,   3.253286718944797e-12,   9.715190819501297e-14,  -3.406012221235065e-15,  -7.309985304500103e-17,   7.504034585297648e-01,  -7.063010550683853e-03,
   4.973339347787717e-05,   1.423996158594824e-07,  -7.080589326471203e-09,  -1.579762541484372e-10,   5.148579315219849e-12,   1.454905495209108e-13,  -5.537018232007396e-15,
  -1.107102360283173e-16,   7.504105239224093e-01,  -7.062950538001478e-03,   4.972740847149959e-05,   1.421783928677478e-07,  -7.069851590662736e-09,  -1.575502454063330e-10,
   5.127238565459290e-12,   1.449389710578825e-13,  -5.502001620212803e-15,  -1.101266772542199e-16,   7.504221223023239e-01,  -7.062852084894464e-03,   4.971758966162396e-05,
   1.418156540545893e-07,  -7.052256403189067e-09,  -1.568520644047196e-10,   5.092303788263237e-12,   1.440356055637740e-13,  -5.444748203632746e-15,  -1.091714541167179e-16,
   7.504344282571972e-01,  -7.062747710100351e-03,   4.970718003211701e-05,   1.414313500407385e-07,  -7.033630695616796e-09,  -1.561128433588864e-10,   5.055370179195166e-12,
   1.430799675262841e-13,  -5.384312094097247e-15,  -1.081616642377261e-16,   7.504441125130289e-01,  -7.062665632825222e-03,   4.969899402465251e-05,   1.411293273494274e-07,
  -7.019004063660971e-09,  -1.555322311210733e-10,   5.026400614306258e-12,   1.423299724983919e-13,  -5.336975146452804e-15,  -1.073696827532893e-16,   7.504497012478988e-01,
  -7.062618290956876e-03,   4.969427229259509e-05,   1.409551949751777e-07,  -7.010575513096394e-09,  -1.551976122237888e-10,   5.009720653135539e-12,   1.418979748849258e-13,
  -5.309746602612823e-15,  -1.069137067217907e-16,   7.504517998283406e-01,  -7.062600518627171e-03,   4.969249972123151e-05,   1.408898388048661e-07,  -7.007412918667275e-09,
  -1.550720470822154e-10,   5.003464511056962e-12,   1.417359139271295e-13,  -5.299539090716297e-15,  -1.067426893752980e-16,   7.504521476957098e-01,  -7.062597572873517e-03,
   4.969220591778512e-05,   1.408790067859181e-07,  -7.006888800454409e-09,  -1.550512374811344e-10,   5.002427853391489e-12,   1.417090583579759e-13,  -5.297847949554061e-15,
  -1.067143516744914e-16,   9.548264932693604e-01,  -8.917586427549598e-03,   5.760000665787492e-05,   4.160056343880324e-07,  -1.336736908131277e-08,  -2.282715709027335e-10,
   8.680893036395564e-12,   2.157802160276484e-13,  -9.314822190759520e-15,  -1.635961761721158e-16,   9.548346674286106e-01,  -8.917409953375071e-03,   5.758869538377321e-05,
   4.156861100374556e-07,  -1.334926310708271e-08,  -2.276397259030736e-10,   8.645020772775073e-12,   2.149637278339455e-13,  -9.254506259608120e-15,  -1.627877458937098e-16,
   9.548480854871939e-01,  -8.917120339803384e-03,   5.757013713617314e-05,   4.151622035964797e-07,  -1.331959390796286e-08,  -2.266041996505288e-10,   8.586302018793630e-12,
   2.136263000521726e-13,  -9.155895551467204e-15,  -1.614637213437708e-16,   9.548623215265438e-01,  -8.916813169613839e-03,   5.755046038640695e-05,   4.146071733103843e-07,
  -1.328818677655206e-08,  -2.255078005775049e-10,   8.524229154585946e-12,   2.122112155322030e-13,  -9.051813960395835e-15,  -1.600631022572371e-16,   9.548735242368654e-01,
  -8.916571520687906e-03,   5.753498551637719e-05,   4.141709942705998e-07,  -1.326352279641168e-08,  -2.246466450687430e-10,   8.475545156326032e-12,   2.111004491939497e-13,
  -8.970299257818978e-15,  -1.589639012380371e-16,   9.548799890882705e-01,  -8.916432098671887e-03,   5.752605900495755e-05,   4.139195201872192e-07,  -1.324931017870353e-08,
  -2.241503424697024e-10,   8.447515716277326e-12,   2.104605700893502e-13,  -8.923414564605462e-15,  -1.583307707343508e-16,   9.548824166188855e-01,  -8.916379751555110e-03,
   5.752270783065115e-05,   4.138251370277513e-07,  -1.324397724883913e-08,  -2.239641056673237e-10,   8.437003035983989e-12,   2.102205092877051e-13,  -8.905838893110243e-15,
  -1.580932582684655e-16,   9.548828190123287e-01,  -8.916371074652905e-03,   5.752215236876035e-05,   4.138094941921584e-07,  -1.324309345289735e-08,  -2.239332410943117e-10,
   8.435261075785506e-12,   2.101807273835499e-13,  -8.902927054942985e-15,  -1.580538995392087e-16,   1.209876187560559e+00,  -1.112975805162809e-02,   5.872152882595703e-05,
   1.135636742199602e-06,  -2.854511425897950e-08,  -3.838237344121432e-10,   1.867890944533049e-11,   3.138470113288819e-13,  -1.901794436933849e-14,  -2.228761531091293e-16,
   1.209884495499390e+00,  -1.112927512406485e-02,   5.869737632529315e-05,   1.135098284374527e-06,  -2.850610754383665e-08,  -3.829037045269736e-10,   1.860573809356142e-11,
   3.127251333892152e-13,  -1.889145420649931e-14,  -2.221359523321805e-16,   1.209898131876831e+00,  -1.112848248463356e-02,   5.865774988498286e-05,   1.134215257575550e-06,
  -2.844218322165684e-08,  -3.813957367628976e-10,   1.848597475291267e-11,   3.108861469084163e-13,  -1.868467498749531e-14,  -2.209185292233676e-16,   1.209912597800557e+00,
  -1.112764165610207e-02,   5.861573547589325e-05,   1.133279572537160e-06,  -2.837450583087376e-08,  -3.797989387875147e-10,   1.835938350988808e-11,   3.089385924205736e-13,
  -1.846645082647957e-14,  -2.196237340745266e-16,   1.209923980150969e+00,  -1.112698008108467e-02,   5.858269327695365e-05,   1.132544105309941e-06,  -2.832135264627794e-08,
  -3.785446170980342e-10,   1.826010700683528e-11,   3.074085769196065e-13,  -1.829556146088235e-14,  -2.186025883850922e-16,   1.209930548163225e+00,  -1.112659833788419e-02,
   5.856363333280578e-05,   1.132120021951452e-06,  -2.829072063051960e-08,  -3.778216713682309e-10,   1.820295313062658e-11,   3.065266664982547e-13,  -1.819727913292043e-14,
  -2.180124250569481e-16,   1.209933014334832e+00,  -1.112645500173655e-02,   5.855647790129770e-05,   1.131960844166854e-06,  -2.827922625955335e-08,  -3.775503771092100e-10,
   1.818151780256198e-11,   3.061957067874089e-13,  -1.816043750931849e-14,  -2.177906559116772e-16,   1.209933423128460e+00,  -1.112643124236294e-02,   5.855529187929596e-05,
   1.131934461848365e-06,  -2.827732133833075e-08,  -3.775054156458259e-10,   1.817796598818586e-11,   3.061408563708369e-13,  -1.815433387526421e-14,  -2.177538862669957e-16,
   1.552032647451596e+00,  -1.363561714262308e-02,   1.814948147190696e-05,   4.050634771328881e-06,  -8.564088167676738e-08,  -1.508243818273103e-09,   9.915091389322448e-11,
  -2.521855877876357e-13,  -8.779979334445737e-14,   1.534009406399602e-15,   1.552035085587846e+00,  -1.363389543975731e-02,   1.807753171591972e-05,   4.048483163330952e-06,
  -8.543328274416551e-08,  -1.508880089500620e-09,   9.880904174143136e-11,  -2.447836512354010e-13,  -8.741430797729494e-14,   1.516848282716646e-15,   1.552039080969863e+00,
  -1.363106965087519e-02,   1.795954138041972e-05,   4.044950344383975e-06,  -8.509299871764152e-08,  -1.509908937805383e-09,   9.824890647059920e-11,  -2.326945736196564e-13,
  -8.678268848776825e-14,   1.488827602793294e-15,   1.552043310582501e+00,  -1.362807217436026e-02,   1.783451671689179e-05,   4.041200935244003e-06,  -8.473264123542725e-08,
  -1.510979369120198e-09,   9.765605706499846e-11,  -2.199516283724119e-13,  -8.611414643453080e-14,   1.459301349140819e-15,   1.552046632222372e+00,  -1.362571379909942e-02,
   1.773624619090732e-05,   4.038249547138908e-06,  -8.444955145700966e-08,  -1.511806471319377e-09,   9.719056411925220e-11,  -2.099838050698103e-13,  -8.558919927992129e-14,
   1.436212419194600e-15,   1.552048546366455e+00,  -1.362435299700130e-02,   1.767958222579290e-05,   4.036546011729182e-06,  -8.428638038825725e-08,  -1.512277680794351e-09,
   9.692235252007262e-11,  -2.042555292484611e-13,  -8.528672282301398e-14,   1.422946611522211e-15,   1.552049264610158e+00,  -1.362384205187730e-02,   1.765831376533572e-05,
   4.035906273730112e-06,  -8.422514685726814e-08,  -1.512453468733152e-09,   9.682171827086090e-11,  -2.021090977819150e-13,  -8.517323080852021e-14,   1.417976344988234e-15,
   1.552049383641038e+00,  -1.362375735802590e-02,   1.765478871049927e-05,   4.035800225710681e-06,  -8.421499857067260e-08,  -1.512482547175505e-09,   9.680504102133515e-11,
  -2.017535381203042e-13,  -8.515442267874266e-14,   1.417153041135584e-15,   1.755676657989468e-03,  -1.631218937024778e-05,   1.353326612271350e-07,  -5.553389401794159e-10,
  -6.627483534054133e-12,  -8.941763225456382e-14,   9.502307104363854e-15,  -4.256108779980859e-17,  -7.561803240857171e-18,   1.179641948613592e-19,   1.755695905670401e-03,
  -1.631242690991955e-05,   1.353271151631586e-07,  -5.554671769102663e-10,  -6.607548702081735e-12,  -8.953572795838643e-14,   9.472854667827449e-15,  -4.198797614290419e-17,
  -7.528998880627458e-18,   1.167920043232072e-19,   1.755727503302228e-03,  -1.631281690954384e-05,   1.353180225935404e-07,  -5.556778159820135e-10,  -6.574867529442171e-12,
  -8.972838338013184e-14,   9.424597510945724e-15,  -4.105138824459632e-17,  -7.475265653574162e-18,   1.148773251976721e-19,   1.755761030083004e-03,  -1.631323078341265e-05,
   1.353083912292381e-07,  -5.559014796386140e-10,  -6.540251468402541e-12,  -8.993115559645490e-14,   9.373520208755969e-15,  -4.006337677376824e-17,  -7.418414065600388e-18,
   1.128587824845087e-19,   1.755787415294120e-03,  -1.631355654352556e-05,   1.353008232692092e-07,  -5.560776189350407e-10,  -6.513052687084133e-12,  -9.008954761466898e-14,
   9.333414102301486e-15,  -3.928997672445930e-17,  -7.373789826627509e-18,   1.112796091631480e-19,   1.755802642498506e-03,  -1.631374456177633e-05,   1.352964604474812e-07,
  -5.561793182201111e-10,  -6.497373452011712e-12,  -9.018048270845937e-14,   9.310304912702580e-15,  -3.884529905368587e-17,  -7.348083666175608e-18,   1.103720044866385e-19,
   1.755808360424197e-03,  -1.631381516747088e-05,   1.352948230705679e-07,  -5.562175159589057e-10,  -6.491489088941851e-12,  -9.021453991739361e-14,   9.301634137391814e-15,
  -3.867863258240615e-17,  -7.338439693699890e-18,   1.100319003822921e-19,   1.755809308250064e-03,  -1.631382687153217e-05,   1.352945516996932e-07,  -5.562238482364734e-10,
  -6.490513847972536e-12,  -9.022018065242419e-14,   9.300197199047138e-15,  -3.865102180156010e-17,  -7.336841539054841e-18,   1.099755607018882e-19,   1.583820557863586e-02,
  -1.471388265521567e-04,   1.219483154861223e-06,  -4.946225153420909e-09,  -6.132676328761906e-11,  -8.005815115085595e-13,   8.634912457784233e-14,  -3.893739410190380e-16,
  -6.879186715890970e-17,   1.076495916975675e-18,   1.583837901682515e-02,  -1.471409422633899e-04,   1.219431816139023e-06,  -4.947373488438129e-09,  -6.114561553435282e-11,
  -8.016621278151469e-13,   8.608118588077094e-14,  -3.841438418301324e-16,  -6.849351202943790e-17,   1.065802789530240e-18,   1.583866373857398e-02,  -1.471444159023178e-04,
   1.219347646105111e-06,  -4.949259743523193e-09,  -6.084864229182228e-11,  -8.034250210103348e-13,   8.564217412010924e-14,  -3.755967183596444e-16,  -6.800480791392314e-17,
   1.048336436450983e-18,   1.583896584341979e-02,  -1.471481021864344e-04,   1.219258485625509e-06,  -4.951262663940353e-09,  -6.053408738713263e-11,  -8.052805285733466e-13,
   8.517750625094451e-14,  -3.665802929488267e-16,  -6.748774055636892e-17,   1.029922620724814e-18,   1.583920359650466e-02,  -1.471510036625119e-04,   1.219188424668442e-06,
  -4.952840023620919e-09,  -6.028693349706260e-11,  -8.067299558530675e-13,   8.481264693365484e-14,  -3.595223603794868e-16,  -6.708188016327896e-17,   1.015516889960893e-18,
   1.583934080644989e-02,  -1.471526783018790e-04,   1.219148034700669e-06,  -4.953750768355750e-09,  -6.014445730012531e-11,  -8.075621044188508e-13,   8.460241444792577e-14,
  -3.554642929176732e-16,  -6.684808044615544e-17,   1.007237430685123e-18,   1.583939232976916e-02,  -1.471533071722292e-04,   1.219132876099100e-06,  -4.954092841183510e-09,
  -6.009098650766181e-11,  -8.078737647649860e-13,   8.452353331716884e-14,  -3.539433164322442e-16,  -6.676036760256727e-17,   1.004134893478360e-18,   1.583940087047680e-02,
  -1.471534114178955e-04,   1.219130363778136e-06,  -4.954149548820578e-09,  -6.008212456355351e-11,  -8.079253837187749e-13,   8.451046097651844e-14,  -3.536913439873727e-16,
  -6.674583222971351e-17,   1.003620945141489e-18,   4.420445976871148e-02,  -4.105744403883614e-04,   3.395696291373761e-06,  -1.343922800235559e-08,  -1.800332737321457e-10,
  -2.199132927064602e-12,   2.446198920464831e-13,  -1.118517797484900e-15,  -1.953142532725990e-16,   3.076060497441998e-18,   4.420494269800215e-02,  -4.105801890442002e-04,
   3.395545473997699e-06,  -1.344238353508588e-08,  -1.795201172871856e-10,  -2.202238356786815e-12,   2.438591498315859e-13,  -1.103572317883923e-15,  -1.944676124359518e-16,
   3.045527621539832e-18,   4.420573548956541e-02,  -4.105896273731023e-04,   3.395298196698606e-06,  -1.344756694922082e-08,  -1.786788523431201e-10,  -2.207304664425283e-12,
   2.426126888904251e-13,  -1.079148055788876e-15,  -1.930808115906657e-16,   2.995654721615647e-18,   4.420657668228761e-02,  -4.105996435019469e-04,   3.395036242506463e-06,
  -1.345307114297478e-08,  -1.777877857113893e-10,  -2.212637377094983e-12,   2.412933823098393e-13,  -1.053382598131310e-15,  -1.916135137382366e-16,   2.943076555916757e-18,
   4.420723869062462e-02,  -4.106075272130822e-04,   3.394830391407213e-06,  -1.345740599277625e-08,  -1.770876543131950e-10,  -2.216803196221583e-12,   2.402574555646961e-13,
  -1.033213669879949e-15,  -1.904617838596941e-16,   2.901943001250232e-18,   4.420762074267084e-02,  -4.106120774439297e-04,   3.394711714164342e-06,  -1.345990892554531e-08,
  -1.766840523275413e-10,  -2.219194957535956e-12,   2.396605525273148e-13,  -1.021617198179964e-15,  -1.897983160109495e-16,   2.878302186361396e-18,   4.420776420589671e-02,
  -4.106137861740205e-04,   3.394667173001237e-06,  -1.346084902913051e-08,  -1.765325821849482e-10,  -2.220090745232890e-12,   2.394365890141372e-13,  -1.017270797461164e-15,
  -1.895494073176024e-16,   2.869443338880034e-18,   4.420778798692102e-02,  -4.106140694243514e-04,   3.394659790895933e-06,  -1.346100487674159e-08,  -1.765074783980310e-10,
  -2.220239111387653e-12,   2.393994733225161e-13,  -1.016550750996338e-15,  -1.895081592734802e-16,   2.867975833796544e-18,   8.727307915264741e-02,  -8.103185227308189e-04,
   6.679604538845586e-06,  -2.539285188841725e-08,  -3.831768359104043e-10,  -4.229642522558107e-12,   4.942912826450619e-13,  -2.310480732681862e-15,  -3.959680383022383e-16,
   6.299785449610304e-18,   8.727402906340805e-02,  -8.103293849640974e-04,   6.679283231083978e-06,  -2.539892473687183e-08,  -3.821399868068031e-10,  -4.236061447676502e-12,
   4.927489704798297e-13,  -2.279870397658074e-15,  -3.942531074327788e-16,   6.237326134470476e-18,   8.727558846359104e-02,  -8.103472189647913e-04,   6.678756386480071e-06,
  -2.540890070265780e-08,  -3.804401919145238e-10,  -4.246534106508798e-12,   4.902219185391814e-13,  -2.229845973728801e-15,  -3.914440187791731e-16,   6.135304260624705e-18,
   8.727724306417059e-02,  -8.103661447833328e-04,   6.678198224622988e-06,  -2.541949463844487e-08,  -3.786397824440566e-10,  -4.257558270991975e-12,   4.875471749805282e-13,
  -2.177074207849479e-15,  -3.884718418473103e-16,   6.027748657811888e-18,   8.727854521202774e-02,  -8.103810413602595e-04,   6.677759571065706e-06,  -2.542783836702109e-08,
  -3.772251674837410e-10,  -4.266170742330580e-12,   4.854469475967293e-13,  -2.135764751082559e-15,  -3.861388586139141e-16,   5.943604713407306e-18,   8.727929669440385e-02,
  -8.103896392112570e-04,   6.677506664948106e-06,  -2.543265619012253e-08,  -3.764096931338938e-10,  -4.271115740879937e-12,   4.842367907904132e-13,  -2.112013058608526e-15,
  -3.847949056969214e-16,   5.895244480587885e-18,   8.727957888112546e-02,  -8.103928679306773e-04,   6.677411743306283e-06,  -2.543446580092631e-08,  -3.761036496071387e-10,
  -4.272967839176070e-12,   4.837827285104551e-13,  -2.103110814944088e-15,  -3.842907022177471e-16,   5.877122618513472e-18,   8.727962565748802e-02,  -8.103934031445689e-04,
   6.677396011170674e-06,  -2.543476579460400e-08,  -3.760529277514684e-10,  -4.273274598070796e-12,   4.837074803641736e-13,  -2.101636023659378e-15,  -3.842071477566831e-16,
   5.874120657134819e-18,   1.457159392153708e-01,  -1.352282482866525e-03,   1.109392807379876e-05,  -3.966124487829863e-08,  -7.066027802879921e-10,  -6.785663243199493e-12,
   8.526863540812325e-13,  -4.114229732716906e-15,  -6.860452002811796e-16,   1.107538266369080e-17,   1.457175167700858e-01,  -1.352299449598586e-03,   1.109333486275495e-05,
  -3.967099720054378e-08,  -7.048142827381277e-10,  -6.797104207873450e-12,   8.500140991286706e-13,  -4.060410194535094e-15,  -6.830778842210381e-16,   1.096575619024500e-17,
   1.457201065221412e-01,  -1.352327306267352e-03,   1.109236210453405e-05,  -3.968701863178989e-08,  -7.018822648459971e-10,  -6.815772035609606e-12,   8.456356442580811e-13,
  -3.972455825324813e-15,  -6.782172981642892e-16,   1.078669126763546e-17,   1.457228543686759e-01,  -1.352356868468850e-03,   1.109133141795526e-05,  -3.970403406040553e-08,
  -6.987767191559270e-10,  -6.835425076450433e-12,   8.410012789275773e-13,  -3.879670052813746e-15,  -6.730744286189305e-16,   1.059791431314460e-17,   1.457250168800654e-01,
  -1.352380137063371e-03,   1.109052133636230e-05,  -3.971743642989903e-08,  -6.963366525098087e-10,  -6.850780288853334e-12,   8.373623319993441e-13,  -3.807037156399349e-15,
  -6.690375147660720e-16,   1.045022889504026e-17,   1.457262648843321e-01,  -1.352393567021926e-03,   1.109005425265756e-05,  -3.972517564762363e-08,  -6.949300495557128e-10,
  -6.859597373944874e-12,   8.352655564451110e-13,  -3.765275153337613e-15,  -6.667119589174346e-16,   1.036534949368989e-17,   1.457267335179341e-01,  -1.352398610331335e-03,
   1.108987893935643e-05,  -3.972808263965242e-08,  -6.944021597219637e-10,  -6.862899841052224e-12,   8.344788256135436e-13,  -3.749622509896949e-15,  -6.658394879266571e-16,
   1.033354296089343e-17,   1.457268112004290e-01,  -1.352399446344004e-03,   1.108984988295394e-05,  -3.972856455939509e-08,  -6.943146704348664e-10,  -6.863446827556970e-12,
   8.343484468996124e-13,  -3.747029410036865e-15,  -6.656949054782065e-16,   1.032827407883579e-17,   2.205213782394429e-01,  -2.045103492038543e-03,   1.666670540218900e-05,
  -5.429281123466862e-08,  -1.210093755312909e-09,  -9.669051250396805e-12,   1.348344623651019e-12,  -6.797690116585587e-15,  -1.090567076968136e-15,   1.796592490174878e-17,
   2.205237479887176e-01,  -2.045126720038989e-03,   1.666568816794870e-05,  -5.430672956901036e-08,  -1.207265888501347e-09,  -9.687979967107528e-12,   1.344096501765384e-12,
  -6.710376083670600e-15,  -1.085859442316920e-15,   1.778849553587400e-17,   2.205276382137164e-01,  -2.045164856893403e-03,   1.666401994253793e-05,  -5.432959766591490e-08,
  -1.202629989956845e-09,  -9.718868968019787e-12,   1.337135983092497e-12,  -6.567681922867197e-15,  -1.078147983371356e-15,   1.749868140387821e-17,   2.205317659046496e-01,
  -2.045205328934831e-03,   1.666225217442307e-05,  -5.435388806589674e-08,  -1.197719769401917e-09,  -9.751393162898424e-12,   1.329768602718669e-12,  -6.417147355049650e-15,
  -1.069988458533960e-15,   1.719314939991008e-17,   2.205350143189349e-01,  -2.045237184912048e-03,   1.666086262991963e-05,  -5.437302317945555e-08,  -1.193861781477175e-09,
  -9.776808431572512e-12,   1.323983641224274e-12,  -6.299307053737385e-15,  -1.063583455649304e-15,   1.695412394956202e-17,   2.205368890022119e-01,  -2.045255571331015e-03,
   1.666006137681252e-05,  -5.438407379325482e-08,  -1.191637816286780e-09,  -9.791403543324276e-12,   1.320650313400704e-12,  -6.231551369092377e-15,  -1.059893646692257e-15,
   1.681674885715633e-17,   2.205375929568424e-01,  -2.045262475937771e-03,   1.665976062680080e-05,  -5.438822479764200e-08,  -1.190803177832515e-09,  -9.796870465862570e-12,
   1.319399614057114e-12,  -6.206156025174470e-15,  -1.058509341816032e-15,   1.676527086530898e-17,   2.205377096469988e-01,  -2.045263620492246e-03,   1.665971077995867e-05,
  -5.438891295923581e-08,  -1.190664850012175e-09,  -9.797775965036575e-12,   1.319192345388820e-12,  -6.201948891780633e-15,  -1.058279939664381e-15,   1.675674332836157e-17,
   3.131008033196852e-01,  -2.900993346292219e-03,   2.342663338776908e-05,  -6.593499029421915e-08,  -1.994201180142746e-09,  -1.250383981978554e-11,   2.028704383928253e-12,
  -1.085847325759126e-14,  -1.650614574840119e-15,   2.795923957155208e-17,   3.131041337263874e-01,  -2.901021559202548e-03,   2.342495471721812e-05,  -6.595303799245320e-08,
  -1.989946859211854e-09,  -1.253413272253910e-11,   2.022274253241910e-12,  -1.072256929871369e-14,  -1.643510882679114e-15,   2.768396576167195e-17,   3.131096009593290e-01,
  -2.901067880889683e-03,   2.342220150916986e-05,  -6.598269647937280e-08,  -1.982972545550747e-09,  -1.258357460025624e-11,   2.011738467306816e-12,  -1.050046312080037e-14,
  -1.631874137627095e-15,   2.723433269117413e-17,   3.131154018869799e-01,  -2.901117039434990e-03,   2.341928367477452e-05,  -6.601420740463498e-08,  -1.975585619638871e-09,
  -1.263564489103120e-11,   2.000586753294874e-12,  -1.026614876094730e-14,  -1.619560760624053e-15,   2.676031506812659e-17,   3.131199670818011e-01,  -2.901155733014873e-03,
   2.341698987854646e-05,  -6.603903621218109e-08,  -1.969781729664198e-09,  -1.267634204634389e-11,   1.991830225509406e-12,  -1.008272139132607e-14,  -1.609894744264160e-15,
   2.638947975241497e-17,   3.131226016786097e-01,  -2.901178066060988e-03,   2.341566710711835e-05,  -6.605337720383964e-08,  -1.966436058879102e-09,  -1.269971625791016e-11,
   1.986784640697424e-12,  -9.977253232490525e-15,  -1.604326182052641e-15,   2.617634986520653e-17,   3.131235909833651e-01,  -2.901186452762492e-03,   2.341517058659333e-05,
  -6.605876461447429e-08,  -1.965180456724654e-09,  -1.270847220104773e-11,   1.984891480249886e-12,  -9.937722722274331e-15,  -1.602236999124982e-15,   2.609648465116400e-17,
   3.131237549741273e-01,  -2.901187843000505e-03,   2.341508829140417e-05,  -6.605965777219508e-08,  -1.964972361219195e-09,  -1.270992250085621e-11,   1.984577741269345e-12,
  -9.931173865953073e-15,  -1.601890785653391e-15,   2.608325465923726e-17,   4.254709670793979e-01,  -3.937146605280441e-03,   3.139091425499731e-05,  -6.859634587984427e-08,
  -3.235359781579717e-09,  -1.454207381736220e-11,   2.976310522875132e-12,  -1.728712075718831e-14,  -2.436125395418514e-15,   4.289208932598204e-17,   4.254754287534347e-01,
  -3.937175965193797e-03,   3.138818706566811e-05,  -6.861744556373771e-08,  -3.229118954111926e-09,  -1.459042545917166e-11,   2.966819330440511e-12,  -1.707858346562510e-14,
  -2.425691604240554e-15,   4.247159227494324e-17,   4.254827530387932e-01,  -3.937224170848748e-03,   3.138371375878314e-05,  -6.865213247820874e-08,  -3.218888154621369e-09,
  -1.466935928598268e-11,   2.951267844051299e-12,  -1.673776662239326e-14,  -2.408598894334514e-15,   4.178475062192880e-17,   4.254905242985995e-01,  -3.937275329759887e-03,
   3.137897241551752e-05,  -6.868900346627626e-08,  -3.208052206402798e-09,  -1.475251359967642e-11,   2.934807016029166e-12,  -1.637820721885313e-14,  -2.390511171840044e-15,
   4.106065941830514e-17,   4.254966400509845e-01,  -3.937315598603710e-03,   3.137524470087017e-05,  -6.871806835194746e-08,  -3.199538516883536e-09,  -1.481752305284412e-11,
   2.921881537058307e-12,  -1.609672796597716e-14,  -2.376311468830854e-15,   4.049418508107309e-17,   4.255001694631336e-01,  -3.937338841153232e-03,   3.137309486474830e-05,
  -6.873486113227531e-08,  -3.194630809284649e-09,  -1.485486800147640e-11,   2.914433712252115e-12,  -1.593487861741492e-14,  -2.368130737359761e-15,   4.016861554237696e-17,
   4.255014947720582e-01,  -3.937347569455693e-03,   3.137228786344207e-05,  -6.874117054669745e-08,  -3.192788994588950e-09,  -1.486885870455715e-11,   2.911639193782513e-12,
  -1.587421536112318e-14,  -2.365061473451067e-15,   4.004661628214780e-17,   4.255017144599049e-01,  -3.937349016322827e-03,   3.137215410637843e-05,  -6.874221660998850e-08,
  -3.192483744306659e-09,  -1.487117614030444e-11,   2.911176079091551e-12,  -1.586416550271343e-14,  -2.364552840497513e-15,   4.002640661516459e-17,   5.605815708853021e-01,
  -5.178159262625084e-03,   4.053240382566509e-05,  -5.083222317083597e-08,  -5.266339954060295e-09,  -1.418045013810222e-11,   4.346753830634035e-12,  -2.827488933539326e-14,
  -3.573854673676113e-15,   6.651384014736462e-17,   5.605873300061237e-01,  -5.178181037794487e-03,   4.052795874666204e-05,  -5.085306842035878e-08,  -5.257226308733184e-09,
  -1.425981332512818e-11,   4.332827432103682e-12,  -2.795139803985642e-14,  -3.558675251883430e-15,   6.586579898524233e-17,   5.605967840863190e-01,  -5.178216791845859e-03,
   4.052066700207747e-05,  -5.088736878422547e-08,  -5.242286104442783e-09,  -1.438941323027963e-11,   4.310008422063609e-12,  -2.742269405204379e-14,  -3.533806151061416e-15,
   6.480727846040403e-17,   5.606068149866245e-01,  -5.178254738622609e-03,   4.051293746315378e-05,  -5.092387180458286e-08,  -5.226462331376383e-09,  -1.452599699051928e-11,
   4.285854630164641e-12,  -2.686489405033400e-14,  -3.507486562728868e-15,   6.369134114499221e-17,   5.606147089168511e-01,  -5.178284609436245e-03,   4.050685974752990e-05,
  -5.095267753973505e-08,  -5.214029862329654e-09,  -1.463281667734739e-11,   4.266888081745388e-12,  -2.642820795227863e-14,  -3.486822454505129e-15,   6.281830881111245e-17,
   5.606192644816416e-01,  -5.178301851076109e-03,   4.050335437065287e-05,  -5.096933292693066e-08,  -5.206863219081363e-09,  -1.469419556758280e-11,   4.255959176511539e-12,
  -2.617710923834730e-14,  -3.474916649549779e-15,   6.231654847718251e-17,   5.606209751081309e-01,  -5.178308325976889e-03,   4.050203848080492e-05,  -5.097559304453151e-08,
  -5.204173655637348e-09,  -1.471719322224028e-11,   4.251858486131554e-12,  -2.608299299544269e-14,  -3.470449653830051e-15,   6.212852546613566e-17,   5.606212586671958e-01,
  -5.178309399310421e-03,   4.050182037506367e-05,  -5.097663105717412e-08,  -5.203727905447897e-09,  -1.472100273856453e-11,   4.251178907931056e-12,  -2.606740104286828e-14,
  -3.469709383293688e-15,   6.209737867150652e-17,   7.229549989179325e-01,  -6.660425347439107e-03,   5.068278273768556e-05,   1.154165975463808e-08,  -8.787559198374267e-09,
  -7.574713096483290e-12,   6.472255354248441e-12,  -4.948252147666467e-14,  -5.315126196879439e-15,   1.076245964808369e-16,   7.229621965172568e-01,  -6.660420462496026e-03,
   5.067535629691614e-05,   1.152970956245927e-08,  -8.773988917358907e-09,  -7.714275547495463e-12,   6.451536188574353e-12,  -4.895881304190074e-14,  -5.292917839345799e-15,
   1.065863465584807e-16,   7.229740117901580e-01,  -6.660412447028750e-03,   5.066317288924436e-05,   1.150995126778498e-08,  -8.751742827132585e-09,  -7.942276522390838e-12,
   6.417585893731325e-12,  -4.810284115071478e-14,  -5.256527221361561e-15,   1.048904131999191e-16,   7.229865476873681e-01,  -6.660403947399571e-03,   5.065025661739093e-05,
   1.148879637334029e-08,  -8.728181065741109e-09,  -8.182694438187661e-12,   6.381648294729235e-12,  -4.719970939369798e-14,  -5.218006411441671e-15,   1.031024344558755e-16,
   7.229964127658309e-01,  -6.660397262075087e-03,   5.064009959162126e-05,   1.147201041252819e-08,  -8.709668970116031e-09,  -8.370815703328483e-12,   6.353427605699487e-12,
  -4.649263398505411e-14,  -5.187757295052087e-15,   1.017036045932536e-16,   7.230021057996024e-01,  -6.660393405424119e-03,   5.063424103683362e-05,   1.146226817014660e-08,
  -8.698997744137036e-09,  -8.478948819933369e-12,   6.337165875499061e-12,  -4.608604328858926e-14,  -5.170326789763700e-15,   1.008996357084836e-16,   7.230042435344776e-01,
  -6.660391957512761e-03,   5.063204170774401e-05,   1.145859953448481e-08,  -8.694992947304901e-09,  -8.519471731404447e-12,   6.331064152514086e-12,  -4.593364296118852e-14,
  -5.163786537921564e-15,   1.005983641587395e-16,   7.230045978916827e-01,  -6.660391717516541e-03,   5.063167716998135e-05,   1.145799086129010e-08,  -8.694329219083731e-09,
  -8.526184653588886e-12,   6.330052953427027e-12,  -4.590839510604126e-14,  -5.162702665381542e-15,   1.005484571184592e-16,   9.201038755315347e-01,  -8.440719876772518e-03,
   6.119887326330679e-05,   1.783302387625072e-07,  -1.554696150508655e-08,   1.624399743505015e-11,   1.021939943499001e-11,  -9.951017489579338e-14,  -8.220005192268699e-15,
   1.918774522317441e-16,   9.201125581317841e-01,  -8.440643670836830e-03,   6.118571983689943e-05,   1.783509830556415e-07,  -1.552552705055195e-08,   1.596145458377258e-11,
   1.018732902703393e-11,  -9.857556347782208e-14,  -8.187011113778908e-15,   1.900612717678111e-16,   9.201268106921485e-01,  -8.440518560603500e-03,   6.116413946588339e-05,
   1.783847536792410e-07,  -1.549038804087773e-08,   1.549960231907266e-11,   1.013477481629533e-11,  -9.704786191006079e-14,  -8.132927326889811e-15,   1.870944074224195e-16,
   9.201419319491663e-01,  -8.440385801062511e-03,   6.114125882157652e-05,   1.784202013783867e-07,  -1.545316950937929e-08,   1.501223486844084e-11,   1.007913911461254e-11,
  -9.543581239207929e-14,  -8.075651046219043e-15,   1.839662252575188e-16,   9.201538311472010e-01,  -8.440281312912433e-03,   6.112326450703507e-05,   1.784478206262184e-07,
  -1.542392654048256e-08,   1.463061821493333e-11,   1.003544637227497e-11,  -9.417358505691227e-14,  -8.030654734028069e-15,   1.815186721732652e-16,   9.201606978818624e-01,
  -8.440221008487420e-03,   6.111288479203478e-05,   1.784636489711715e-07,  -1.540706915607770e-08,   1.441115707461046e-11,   1.001026762051633e-11,  -9.344771252255380e-14,
  -8.004718784984176e-15,   1.801118715476459e-16,   9.201632763097626e-01,  -8.440198363148455e-03,   6.110898807982981e-05,   1.784695716760309e-07,  -1.540074268696212e-08,
   1.432889391340740e-11,   1.000081977306626e-11,  -9.317562758245207e-14,  -7.994985691491849e-15,   1.795846847006253e-16,   9.201637037158589e-01,  -8.440194609336852e-03,
   6.110834219537529e-05,   1.784705523423256e-07,  -1.539969417645245e-08,   1.431526534914820e-11,   9.999254027577896e-12,  -9.313055130037667e-14,  -7.993372614619121e-15,
   1.794973528950530e-16,   1.166371488961811e+00,  -1.061365504293046e-02,   6.943950548185351e-05,   6.435716443566143e-07,  -3.139318091930328e-08,   9.933827069117448e-11,
   1.884312713372658e-11,  -2.719564144444983e-13,  -1.362348967203815e-14,   4.285486074688499e-16,   1.166381317264174e+00,  -1.061337981300396e-02,   6.941292459928248e-05,
   6.437064588702734e-07,  -3.135359018352838e-08,   9.855878673348823e-11,   1.878980690359463e-11,  -2.698632291415115e-13,  -1.357702654847018e-14,   4.247108066514053e-16,
   1.166397449315338e+00,  -1.061292793844055e-02,   6.936931201031642e-05,   6.439269906907511e-07,  -3.128867733389872e-08,   9.728359292336586e-11,   1.870240687778878e-11,
  -2.664409168674284e-13,  -1.350075807845245e-14,   4.184397037526395e-16,   1.166414563003311e+00,  -1.061244841023822e-02,   6.932306858796014e-05,   6.441599234861682e-07,
  -3.121991077605604e-08,   9.593655239466278e-11,   1.860985047054106e-11,  -2.628285339677060e-13,  -1.341984398388345e-14,   4.118252244909088e-16,   1.166428028913076e+00,
  -1.061207097976152e-02,   6.928669857432239e-05,   6.443424711314932e-07,  -3.116587140651228e-08,   9.488078371678826e-11,   1.853713968704911e-11,  -2.599992473952340e-13,
  -1.335617442446542e-14,   4.066481952616342e-16,   1.166435799289970e+00,  -1.061185314154822e-02,   6.926571826249613e-05,   6.444475142543513e-07,  -3.113471637772738e-08,
   9.427322216577545e-11,   1.849522961687769e-11,  -2.583718783578535e-13,  -1.331943394913522e-14,   4.036718609426202e-16,   1.166438716942894e+00,  -1.061177133816855e-02,
   6.925784174800694e-05,   6.444869007212175e-07,  -3.112302342745975e-08,   9.404540574235772e-11,   1.847950193745935e-11,  -2.577618167286922e-13,  -1.330563842336083e-14,
   4.025563742367527e-16,   1.166439200575033e+00,  -1.061175777793117e-02,   6.925653619798993e-05,   6.444934265197006e-07,  -3.112108547386732e-08,   9.400765925221479e-11,
   1.847689537534980e-11,  -2.576607446603965e-13,  -1.330335166538619e-14,   4.023715800107815e-16,   1.498053529320058e+00,  -1.332077011671822e-02,   5.794032033817903e-05,
   2.561020403610179e-06,  -9.396073039595134e-08,   5.319780728403623e-10,   6.323762619713723e-11,  -1.909602137815131e-12,  -1.332087563998357e-14,   1.985739939766736e-15,
   1.498061614860915e+00,  -1.331967426028228e-02,   5.786085315038125e-05,   2.561730744052790e-06,  -9.382642112907349e-08,   5.264294447210244e-10,   6.318094406634762e-11,
  -1.899675675872225e-12,  -1.349649345244621e-14,   1.976548063539789e-15,   1.498074880533357e+00,  -1.331787502620774e-02,   5.773047756627065e-05,   2.562891241287475e-06,
  -9.360602007038887e-08,   5.173417541661649e-10,   6.308739723281428e-11,  -1.883413763595883e-12,  -1.378273259429301e-14,   1.961465194425769e-15,   1.498088945499152e+00,
  -1.331596561751628e-02,   5.759225131339651e-05,   2.564114963100841e-06,  -9.337227934247746e-08,   5.077278938766478e-10,   6.298746873456185e-11,  -1.866204785879461e-12,
  -1.408365674724742e-14,   1.945471017899948e-15,   1.498100006785398e+00,  -1.331446269919676e-02,   5.748354782319647e-05,   2.565072505195521e-06,  -9.318841269044932e-08,
   5.001826149165043e-10,   6.290834330646433e-11,  -1.852694644400249e-12,  -1.431846790982255e-14,   1.932890918053811e-15,   1.498106387298156e+00,  -1.331359525425567e-02,
   5.742084549326851e-05,   2.565622906475494e-06,  -9.308233524236353e-08,   4.958364460732601e-10,   6.286248642731864e-11,  -1.844911067523764e-12,  -1.445317580842626e-14,
   1.925633736332213e-15,   1.498108782644776e+00,  -1.331326950469959e-02,   5.739730630185916e-05,   2.565829169339380e-06,  -9.304250884559542e-08,   4.942059951916572e-10,
   6.284523051304931e-11,  -1.841990787342512e-12,  -1.450360788873167e-14,   1.922909175673685e-15,   1.498109179676149e+00,  -1.331321550623862e-02,   5.739340466873340e-05,
   2.565863338303733e-06,  -9.303590740612505e-08,   4.939358078753675e-10,   6.284236819095023e-11,  -1.841506842576261e-12,  -1.451195971277910e-14,   1.922457571725439e-15,
   1.692548390005632e-03,  -1.525804623573671e-05,   1.280113191502531e-07,  -6.641300483045224e-10,  -6.352381244219829e-12,   1.019995628104889e-13,   5.764419951900748e-15,
  -1.908881255526807e-16,  -1.358841696303366e-18,   1.783127911783302e-19,   1.692566596190017e-03,  -1.525832927214998e-05,   1.280059645082699e-07,  -6.639895792893633e-10,
  -6.340143777006656e-12,   1.014432766329579e-13,   5.758779417108022e-15,  -1.899981775056180e-16,  -1.369867552842101e-18,   1.774330253143672e-19,   1.692596484049454e-03,
  -1.525879387998930e-05,   1.279971815272902e-07,  -6.637595429657563e-10,  -6.320062814709030e-12,   1.005319498171113e-13,   5.749488603115729e-15,  -1.885404232513830e-16,
  -1.387830165092599e-18,   1.759911441363558e-19,   1.692628196646652e-03,  -1.525928680750388e-05,   1.279878723371014e-07,  -6.635162252270527e-10,  -6.298767375336979e-12,
   9.956754954419520e-14,   5.739588465649790e-15,  -1.869980311630728e-16,  -1.406702876127288e-18,   1.744644618516212e-19,   1.692653154097927e-03,  -1.525967470262725e-05,
   1.279805533609743e-07,  -6.633252885235505e-10,  -6.282016470950186e-12,   9.881043218087863e-14,   5.731766862652983e-15,  -1.857873407868913e-16,  -1.421420949339447e-18,
   1.732653247437754e-19,   1.692667557319003e-03,  -1.525989854790883e-05,   1.279763324044282e-07,  -6.632153176691557e-10,  -6.272352697795749e-12,   9.837423383535055e-14,
   5.727240835438298e-15,  -1.850899012478595e-16,  -1.429861163436229e-18,   1.725742311432469e-19,   1.692672965831669e-03,  -1.525998260090721e-05,   1.279747479541043e-07,
  -6.631740645325698e-10,  -6.268724517450021e-12,   9.821057844964723e-14,   5.725539000550684e-15,  -1.848282463286901e-16,  -1.433020386521083e-18,   1.723148987637819e-19,
   1.692673862367946e-03,  -1.525999653372972e-05,   1.279744853383677e-07,  -6.631672284502554e-10,  -6.268123129597326e-12,   9.818345768516921e-14,   5.725256777642694e-15,
  -1.847848859676417e-16,  -1.433543537440398e-18,   1.722719202185194e-19,   1.526876181563700e-02,  -1.376375809971338e-04,   1.154057748427260e-06,  -5.950567928747315e-09,
  -5.859413184762711e-11,   9.378558070099389e-13,   5.229899656228518e-14,  -1.737208729311300e-15,  -1.228354523169420e-17,   1.622625981096687e-18,   1.526892594719939e-02,
  -1.376401168695694e-04,   1.154008346936436e-06,  -5.949275917307429e-09,  -5.848310278241290e-11,   9.327932256088968e-13,   5.224798285191593e-14,  -1.729110118248845e-15,
  -1.238442540966443e-17,   1.614627248151266e-18,   1.526919539075003e-02,  -1.376442795259548e-04,   1.153927314717355e-06,  -5.947160025130410e-09,  -5.830091039050171e-11,
   9.244995326747629e-13,   5.216395227500633e-14,  -1.715844391420368e-15,  -1.254877626108183e-17,   1.601517720416067e-18,   1.526948128442932e-02,  -1.376486958988024e-04,
   1.153841426099619e-06,  -5.944921894597430e-09,  -5.810769885410519e-11,   9.157228339187063e-13,   5.207440625941379e-14,  -1.701808415947862e-15,  -1.272145878082644e-17,
   1.587637042281739e-18,   1.526970627937139e-02,  -1.376521712263365e-04,   1.153773898495718e-06,  -5.943165530769282e-09,  -5.795571922557722e-11,   9.088325497633127e-13,
   5.200365725855982e-14,  -1.690790945539474e-15,  -1.285613033951971e-17,   1.576734320489315e-18,   1.526983612639463e-02,  -1.376541767532705e-04,   1.153734953920864e-06,
  -5.942153923314276e-09,  -5.786804048378086e-11,   9.048628470833238e-13,   5.196271657282092e-14,  -1.684444127404642e-15,  -1.293336033424830e-17,   1.570450760359036e-18,
   1.526988488487318e-02,  -1.376549298197709e-04,   1.153720334934163e-06,  -5.941774437000629e-09,  -5.783512223819336e-11,   9.033734712988493e-13,   5.194732219710774e-14,
  -1.682063021353983e-15,  -1.296226824432307e-17,   1.568092851234668e-18,   1.526989296726941e-02,  -1.376550546498036e-04,   1.153717911896280e-06,  -5.941711551875398e-09,
  -5.782966588417850e-11,   9.031266538153699e-13,   5.194476926626346e-14,  -1.681668434298308e-15,  -1.296705525752768e-17,   1.567702080097110e-18,   4.261540071774948e-02,
  -3.841042913162613e-04,   3.216667982026655e-06,  -1.637439028458245e-08,  -1.709543923869029e-10,   2.719833306871891e-12,   1.476723754585942e-13,  -4.936252445046261e-15,
  -3.441570953221320e-17,   4.609687415368156e-18,   4.261585818329914e-02,  -3.841112686819308e-04,   3.216523789083470e-06,  -1.637064088442714e-08,  -1.706408774010401e-10,
   2.705447999917363e-12,   1.475292995391785e-13,  -4.913244153655241e-15,  -3.470550582636166e-17,   4.587005655173259e-18,   4.261660917251194e-02,  -3.841227220284946e-04,
   3.216287265960055e-06,  -1.636450028151073e-08,  -1.701264156634382e-10,   2.681881493490740e-12,   1.472936032749270e-13,  -4.875555845894630e-15,  -3.517765278440175e-17,
   4.549830749664232e-18,   4.261740601038445e-02,  -3.841348733832884e-04,   3.216036558775234e-06,  -1.635800450238184e-08,  -1.695808369047272e-10,   2.656942517147097e-12,
   1.470424106743865e-13,  -4.835679033089854e-15,  -3.567376199005736e-17,   4.510468239741895e-18,   4.261803311170531e-02,  -3.841444354567143e-04,   3.215839440631859e-06,
  -1.635290665858539e-08,  -1.691516848438415e-10,   2.637363777837206e-12,   1.468439282888074e-13,  -4.804377774663592e-15,  -3.606068706046055e-17,   4.479549945787398e-18,
   4.261839501842214e-02,  -3.841499534732984e-04,   3.215725755929458e-06,  -1.634997034573714e-08,  -1.689041016747147e-10,   2.626083866615321e-12,   1.467290640020846e-13,
  -4.786346044821754e-15,  -3.628258460276217e-17,   4.461730579962103e-18,   4.261853091691264e-02,  -3.841520254597451e-04,   3.215683080561835e-06,  -1.634886881749839e-08,
  -1.688111485520426e-10,   2.621851804393016e-12,   1.466858717232561e-13,  -4.779581153924119e-15,  -3.636564443290676e-17,   4.455043808466607e-18,   4.261855344397567e-02,
  -3.841523689167454e-04,   3.215676007266756e-06,  -1.634868628071939e-08,  -1.687957411292431e-10,   2.621150472331406e-12,   1.466787088449835e-13,  -4.778460103566719e-15,
  -3.637939882741656e-17,   4.453935622014042e-18,   8.413659829196406e-02,  -7.582072114789719e-04,   6.337286614004580e-06,  -3.160035178257332e-08,  -3.606776210749676e-10,
   5.690996799134059e-12,   2.968424784952986e-13,  -1.002112157162738e-14,  -6.828896511923688e-17,   9.354114303662839e-18,   8.413749952234514e-02,  -7.582206746707768e-04,
   6.336982220698352e-06,  -3.159249896999215e-08,  -3.600473735078746e-10,   5.661792827110874e-12,   2.965581012581361e-13,  -9.974428865161268e-15,  -6.888736178020023e-17,
   9.308224146090516e-18,   8.413897900718018e-02,  -7.582427743137942e-04,   6.336482897672308e-06,  -3.157963703697488e-08,  -3.590131652949250e-10,   5.613949837956996e-12,
   2.960895688455858e-13,  -9.897944237808324e-15,  -6.986235537905098e-17,   9.233009157536908e-18,   8.414054881325245e-02,  -7.582662205335659e-04,   6.335953604315825e-06,
  -3.156602988117342e-08,  -3.579163968624455e-10,   5.563320515496167e-12,   2.955901464391456e-13,  -9.817017583639197e-15,  -7.088691791193487e-17,   9.153365304753000e-18,
   8.414178422871840e-02,  -7.582846705118579e-04,   6.335537429080299e-06,  -3.155535014804718e-08,  -3.570536744941946e-10,   5.523573129395245e-12,   2.951954614749664e-13,
  -9.753493812215498e-15,  -7.168605667381346e-17,   9.090805022652381e-18,   8.414249719905703e-02,  -7.582953174264658e-04,   6.335297399065159e-06,  -3.154919834355331e-08,
  -3.565559573381115e-10,   5.500673430210675e-12,   2.949670278759945e-13,  -9.716899450447639e-15,  -7.214437982248740e-17,   9.054748412052468e-18,   8.414276492422547e-02,
  -7.582993152734018e-04,   6.335207294293420e-06,  -3.154689048540033e-08,  -3.563690930549502e-10,   5.492081786410683e-12,   2.948811256809361e-13,  -9.703170455578674e-15,
  -7.231594237069235e-17,   9.041217910411099e-18,   8.414280930338386e-02,  -7.582999779645078e-04,   6.335192359661504e-06,  -3.154650804119103e-08,  -3.563381193913885e-10,
   5.490657989811072e-12,   2.948668796766563e-13,  -9.700895340145099e-15,  -7.234435273507832e-17,   9.038975517222177e-18,   1.404810216144641e-01,  -1.265630440368853e-03,
   1.054908039644367e-05,  -5.101875823678533e-08,  -6.578928321685549e-10,   1.028097643783495e-11,   5.082274350982938e-13,  -1.739993627650749e-14,  -1.145817908248825e-16,
   1.622846802215889e-17,   1.404825217088661e-01,  -1.265652171305179e-03,   1.054852476993224e-05,  -5.100455461246781e-08,  -6.568136782804345e-10,   1.023026792159073e-11,
   5.077490444806643e-13,  -1.731891977778828e-14,  -1.156459117825876e-16,   1.614920331083351e-17,   1.404849843005088e-01,  -1.265687841871778e-03,   1.054761328322300e-05,
  -5.098128868620201e-08,  -6.550428220231132e-10,   1.014719530093132e-11,   5.069606983856329e-13,  -1.718621004341401e-14,  -1.173798873371241e-16,   1.601928148563066e-17,
   1.404875972243807e-01,  -1.265725685288525e-03,   1.054664702772918e-05,  -5.095667180139275e-08,  -6.531648277807137e-10,   1.005928444309169e-11,   5.061201581941614e-13,
  -1.704579113848641e-14,  -1.192022328575118e-16,   1.588170248299630e-17,   1.404896535540665e-01,  -1.265755464055572e-03,   1.054588723270253e-05,  -5.093734883363287e-08,
  -6.516875776991329e-10,   9.990268455901928e-12,   5.054557365044552e-13,  -1.693556738355905e-14,  -1.206237825199711e-16,   1.577362906076780e-17,   1.404908402800488e-01,
  -1.265772648282673e-03,   1.054544900187314e-05,  -5.092621744902295e-08,  -6.508353255596219e-10,   9.950506163787097e-12,   5.050711236332642e-13,  -1.687206989871955e-14,
  -1.214391343349560e-16,   1.571133894198763e-17,   1.404912859032818e-01,  -1.265779100813238e-03,   1.054528449130220e-05,  -5.092204133317126e-08,  -6.505153527637311e-10,
   9.935587904541586e-12,   5.049264786414451e-13,  -1.684824764711914e-14,  -1.217443541080728e-16,   1.568796374849114e-17,   1.404913597714910e-01,  -1.265780170395792e-03,
   1.054525722392952e-05,  -5.092134928415699e-08,  -6.504623156677319e-10,   9.933115668587366e-12,   5.049024901236933e-13,  -1.684429991161427e-14,  -1.217948984310380e-16,
   1.568408978676927e-17,   2.126030349431114e-01,  -1.914708900839931e-03,   1.589800887747360e-05,  -7.356952432677072e-08,  -1.112554651180356e-09,   1.721405861176803e-11,
   7.952415315985621e-13,  -2.775270534632869e-14,  -1.738061096860467e-16,   2.584532342905602e-17,   2.126052954556591e-01,  -1.914740225286253e-03,   1.589706849342779e-05,
  -7.354570847920194e-08,  -1.110865825112241e-09,   1.713317637856178e-11,   7.945130278838780e-13,  -2.762365791551057e-14,  -1.755586426957835e-16,   2.571989095059353e-17,
   2.126090063577715e-01,  -1.914791642245710e-03,   1.589552574023082e-05,  -7.350669325103418e-08,  -1.108094486585588e-09,   1.700067166062454e-11,   7.933121440675756e-13,
  -2.741226777438307e-14,  -1.784147233171211e-16,   2.551428420682198e-17,   2.126129437825761e-01,  -1.914846189857379e-03,   1.589389017209616e-05,  -7.346540683066259e-08,
  -1.105155439442169e-09,   1.686044923350380e-11,   7.920312500400580e-13,  -2.718859389371078e-14,  -1.814168290412920e-16,   2.529654359464060e-17,   2.126160424631326e-01,
  -1.914889112061403e-03,   1.589260399357274e-05,  -7.343299499102346e-08,  -1.102843524570624e-09,   1.675036475997721e-11,   7.910183808725528e-13,  -2.701301512477905e-14,
  -1.837590100125223e-16,   2.512548869077246e-17,   2.126178307348287e-01,  -1.914913880481011e-03,   1.589186212444003e-05,  -7.341432182932454e-08,  -1.101509727570949e-09,
   1.668694147267210e-11,   7.904319190998777e-13,  -2.691186690393373e-14,  -1.851025412861976e-16,   2.502689341916545e-17,   2.126185022415572e-01,  -1.914923180735589e-03,
   1.589158362261839e-05,  -7.340731598016707e-08,  -1.101008959523017e-09,   1.666314591022309e-11,   7.902113358884960e-13,  -2.687391906843490e-14,  -1.856055063943281e-16,
   2.498989336684619e-17,   2.126186135530360e-01,  -1.914924722357784e-03,   1.589153746103872e-05,  -7.340615498253674e-08,  -1.100925954590513e-09,   1.665920253686570e-11,
   7.901747520447609e-13,  -2.686763048195684e-14,  -1.856887986728639e-16,   2.498376131681563e-17,   3.018658747412317e-01,  -2.717290300486203e-03,   2.244377687460111e-05,
  -9.739383677093465e-08,  -1.808048980224671e-09,   2.772644535290047e-11,   1.179160673307251e-12,  -4.222563744324231e-14,  -2.454077420452153e-16,   3.921699972022123e-17,
   3.018690655798278e-01,  -2.717331744529579e-03,   2.244224726740932e-05,  -9.735541624667979e-08,  -1.805544306298406e-09,   2.760337569964816e-11,   1.178125745351574e-12,
  -4.202977770475411e-14,  -2.481890369671345e-16,   3.902843742636486e-17,   3.018743037028955e-01,  -2.717399770021989e-03,   2.243973771134090e-05,  -9.729246802895358e-08,
  -1.801434105308725e-09,   2.740175671812968e-11,   1.176418920240009e-12,  -4.170893711749121e-14,  -2.527223863465692e-16,   3.871932339262968e-17,   3.018798615459062e-01,
  -2.717471934566224e-03,   2.243707697311151e-05,  -9.722584515052998e-08,  -1.797075081588387e-09,   2.718839308051468e-11,   1.174597265222556e-12,  -4.136944393854379e-14,
  -2.574884811603950e-16,   3.839193190613640e-17,   3.018842354452927e-01,  -2.717528717046915e-03,   2.243498447433393e-05,  -9.717353552851850e-08,  -1.793646117412914e-09,
   2.702088659962272e-11,   1.173155991677379e-12,  -4.110294341455835e-14,  -2.612075916896698e-16,   3.813471108485740e-17,   3.018867596471440e-01,  -2.717561482764636e-03,
   2.243377745999048e-05,  -9.714339583993725e-08,  -1.791667842332209e-09,   2.692438020122292e-11,   1.172321162580302e-12,  -4.094941405154246e-14,  -2.633412452818028e-16,
   3.798644009454739e-17,   3.018877074985101e-01,  -2.717573785755789e-03,   2.243332432893101e-05,  -9.713208738251478e-08,  -1.790925102892733e-09,   2.688817222538768e-11,
   1.172007102550704e-12,  -4.089181387759956e-14,  -2.641400545750767e-16,   3.793079623374509e-17,   3.018878646178332e-01,  -2.717575825107234e-03,   2.243324922202920e-05,
  -9.713021333402539e-08,  -1.790801989667810e-09,   2.688217187709007e-11,   1.171955012393869e-12,  -4.088226854724217e-14,  -2.642723422202412e-16,   3.792157422952094e-17,
   4.102181805315390e-01,  -3.690190208584630e-03,   3.025935358592346e-05,  -1.191090218569694e-07,  -2.889306898509699e-09,   4.402971248234671e-11,   1.694671715690665e-12,
  -6.284570760782879e-14,  -3.250819751792011e-16,   5.808164611912458e-17,   4.102224817401379e-01,  -3.690240843241179e-03,   3.025690696181347e-05,  -1.190479068110118e-07,
  -2.885706015765922e-09,   4.384652323201288e-11,   1.693286588954679e-12,  -6.255553011235821e-14,  -3.294567654872255e-16,   5.780627370197568e-17,   4.102295426219981e-01,
  -3.690323949727976e-03,   3.025289264917316e-05,  -1.189477630762353e-07,  -2.879796768061093e-09,   4.354641041376932e-11,   1.691000365360655e-12,  -6.208017199511770e-14,
  -3.365888601208551e-16,   5.735479307965640e-17,   4.102370344262488e-01,  -3.690412107026365e-03,   3.024863616525288e-05,  -1.188417559600714e-07,  -2.873529578110425e-09,
   4.322881164691135e-11,   1.688557847756433e-12,  -6.157715882873512e-14,  -3.440890829574569e-16,   5.687654011837910e-17,   4.102429302715788e-01,  -3.690481469129505e-03,
   3.024528847024997e-05,  -1.187585107997939e-07,  -2.868599431268095e-09,   4.297946997925034e-11,   1.686623574015872e-12,  -6.118228196603658e-14,  -3.499431314985949e-16,
   5.650073698208722e-17,   4.102463327814410e-01,  -3.690521492086567e-03,   3.024335732374104e-05,  -1.187105416544770e-07,  -2.865755017419600e-09,   4.283581432815809e-11,
   1.685502476852882e-12,  -6.095479019567582e-14,  -3.533021725071590e-16,   5.628408895380972e-17,   4.102476104392533e-01,  -3.690536519731965e-03,   3.024263232414629e-05,
  -1.186925426004754e-07,  -2.864687076543030e-09,   4.278191634127511e-11,   1.685080590749666e-12,  -6.086944022474421e-14,  -3.545598580066707e-16,   5.620278006300632e-17,
   4.102478222283493e-01,  -3.690539010706885e-03,   3.024251215379635e-05,  -1.186895597293465e-07,  -2.864510058758444e-09,   4.277298441158387e-11,   1.685010609511628e-12,
  -6.085529622483920e-14,  -3.547681440699771e-16,   5.618930430623753e-17,   5.405115821236606e-01,  -4.857759318213337e-03,   3.942462702749614e-05,  -1.321627161902497e-07,
  -4.626456219495598e-09,   7.040250029965603e-11,   2.401409480920195e-12,  -9.350125909478633e-14,  -3.960875616664819e-16,   8.562520410688532e-17,   5.405171846525160e-01,
  -4.857815395996643e-03,   3.942070567097883e-05,  -1.320648236777358e-07,  -4.621350806216597e-09,   7.012989460093684e-11,   2.399687407832539e-12,  -9.307323456480128e-14,
  -4.030909284897524e-16,   8.522827569803757e-17,   5.405263817119298e-01,  -4.857907427084048e-03,   3.941427127351935e-05,  -1.319043948381638e-07,  -4.612972176364012e-09,
   6.968328583700363e-11,   2.396840616306694e-12,  -9.237202735237638e-14,  -4.145113250576516e-16,   8.457736956940476e-17,   5.405361399615184e-01,  -4.858005038903707e-03,
   3.940744815236400e-05,  -1.317345441571484e-07,  -4.604085532345820e-09,   6.921064479788552e-11,   2.393793256026893e-12,  -9.162998095957128e-14,  -4.265252903915324e-16,
   8.388768823878068e-17,   5.405438193634738e-01,  -4.858081830793332e-03,   3.940208141234441e-05,  -1.316011431289215e-07,  -4.597094410143778e-09,   6.883957414499550e-11,
   2.391375734045034e-12,  -9.104742521652824e-14,  -4.359053656682411e-16,   8.334562080303070e-17,   5.405482511395230e-01,  -4.858126137231469e-03,   3.939898540098830e-05,
  -1.315242638258475e-07,  -4.593060788669734e-09,   6.862578246446678e-11,   2.389972856021127e-12,  -9.071179720688176e-14,  -4.412888306408862e-16,   8.303307167430372e-17,
   5.405499152858322e-01,  -4.858142772536559e-03,   3.939782305213981e-05,  -1.314954154767807e-07,  -4.591546330569305e-09,   6.854556963800450e-11,   2.389444613668483e-12,
  -9.058587443240877e-14,  -4.433047238582028e-16,   8.291576113054277e-17,   5.405501911403382e-01,  -4.858145529960308e-03,   3.939763038853506e-05,  -1.314906345360200e-07,
  -4.591295298387223e-09,   6.853227680385914e-11,   2.389356973654002e-12,  -9.056500667291438e-14,  -4.436385891527135e-16,   8.289631812295007e-17,   6.971217743770477e-01,
  -6.256759543868767e-03,   4.999801162297863e-05,  -1.225953252341019e-07,  -7.579525680951597e-09,   1.161595030542570e-10,   3.410486788966259e-12,  -1.426383867208511e-13,
  -3.968758567824321e-16,   1.282655997760566e-16,   6.971288765303749e-01,  -6.256811311580320e-03,   4.999158100118603e-05,  -1.224335250915913e-07,  -7.572267629831227e-09,
   1.157434599316220e-10,   3.408662946033837e-12,  -1.419965936884137e-13,  -4.086754537156037e-16,   1.276943460930291e-16,   6.971405352099970e-01,  -6.256896247548422e-03,
   4.998102856653212e-05,  -1.221683276539250e-07,  -7.560355305444970e-09,   1.150618341077476e-10,   3.405635531929277e-12,  -1.409450965187536e-13,  -4.279238852665844e-16,
   1.267572354378446e-16,   6.971529050809541e-01,  -6.256986304503155e-03,   4.996983769420230e-05,  -1.218875077242603e-07,  -7.547719433567324e-09,   1.143404444308513e-10,
   3.402378171941831e-12,  -1.398322428966484e-13,  -4.481820209527025e-16,   1.257638463397539e-16,   6.971626395908025e-01,  -6.257057131582731e-03,   4.996103481753498e-05,
  -1.216669167097724e-07,  -7.537777871882584e-09,   1.137740574909989e-10,   3.399782152799374e-12,  -1.389584952481773e-13,  -4.640055851965769e-16,   1.249827479042684e-16,
   6.971682573088698e-01,  -6.257097987965734e-03,   4.995595626820440e-05,  -1.215397757743710e-07,  -7.532041586200029e-09,   1.134477252259026e-10,   3.398270977260038e-12,
  -1.384550693691525e-13,  -4.730898412216814e-16,   1.245322463839886e-16,   6.971703667691245e-01,  -6.257113326296269e-03,   4.995404955560972e-05,  -1.214920645264632e-07,
  -7.529887778513243e-09,   1.133252863390665e-10,   3.397701071703398e-12,  -1.382661849620069e-13,  -4.764920464015063e-16,   1.243631329863804e-16,   6.971707164397849e-01,
  -6.257115868651732e-03,   4.995373350828082e-05,  -1.214841573620916e-07,  -7.529530765930786e-09,   1.133049957266213e-10,   3.397606472904834e-12,  -1.382348829500553e-13,
  -4.770555350166496e-16,   1.243351029000571e-16,   8.873278947254659e-01,  -7.946693102536246e-03,   6.189653874904382e-05,  -5.588643862550955e-08,  -1.311810422274374e-08,
   2.056478956831734e-10,   4.954249283840397e-12,  -2.325546372573778e-13,  -6.857241419093623e-17,   2.006856940551069e-16,   8.873366806546232e-01,  -7.946715949103195e-03,
   6.188539779350542e-05,  -5.559950432713518e-08,  -1.310753812897330e-08,   2.049689503730866e-10,   4.953520972560505e-12,  -2.315485222338484e-13,  -9.070268813870203e-17,
   1.998659506756857e-16,   8.873511030433814e-01,  -7.946753368233438e-03,   6.186711462886340e-05,  -5.512914691753467e-08,  -1.309019353891457e-08,   2.038565106118691e-10,
   4.952262808139900e-12,  -2.298998572976727e-13,  -1.268217219990811e-16,   1.985201513508314e-16,   8.873664047692063e-01,  -7.946792954416146e-03,   6.184772363455766e-05,
  -5.463100019190117e-08,  -1.307179149267828e-08,   2.026790565027031e-10,   4.950843154622827e-12,  -2.281546221446479e-13,  -1.648604366293817e-16,   1.970921048494796e-16,
   8.873784461907291e-01,  -7.946824023310591e-03,   6.183246923200290e-05,  -5.423963489681421e-08,  -1.305731040519990e-08,   2.017545128371717e-10,   4.949664854775481e-12,
  -2.267841000438620e-13,  -1.945904915418509e-16,   1.959682118557561e-16,   8.873853950828565e-01,  -7.946841919478280e-03,   6.182366818804041e-05,  -5.401404211476318e-08,
  -1.304895366889678e-08,   2.012217890414699e-10,   4.948960458217203e-12,  -2.259943423133654e-13,  -2.116657058310070e-16,   1.953195935541114e-16,   8.873880043763416e-01,
  -7.946848633187897e-03,   6.182036379426296e-05,  -5.392938111444339e-08,  -1.304581574299779e-08,   2.010219062107690e-10,   4.948691352984991e-12,  -2.256980067455825e-13,
  -2.180620382085455e-16,   1.950760322591733e-16,   8.873884368996224e-01,  -7.946849745739639e-03,   6.181981606932090e-05,  -5.391535004894028e-08,  -1.304529559279496e-08,
   2.009887812218071e-10,   4.948646502658514e-12,  -2.256488968225000e-13,  -2.191215006142632e-16,   1.950356585798899e-16,   1.125065138336582e+00,  -1.003549165485383e-02,
   7.428499051099272e-05,   1.784646226763589e-07,  -2.569113423335596e-08,   4.261300153543023e-10,   7.599503283985477e-12,  -4.462335501793408e-13,   2.138901957663583e-15,
   3.405026704939484e-16,   1.125075665711003e+00,  -1.003541336301171e-02,   7.426314673300956e-05,   1.790600338653714e-07,  -2.567482532962601e-08,   4.248238407630397e-10,
   7.606949868854649e-12,  -4.445170225894141e-13,   2.086642688706656e-15,   3.394687370775158e-16,   1.125092945868487e+00,  -1.003528465311562e-02,   7.422729672689375e-05,
   1.800361655949467e-07,  -2.564804070264736e-08,   4.226832331548787e-10,   7.619026572558961e-12,  -4.417029314036293e-13,   2.001275519315429e-15,   3.377662752480318e-16,
   1.125111278419123e+00,  -1.003514783596865e-02,   7.418927081703257e-05,   1.810701084414955e-07,  -2.561960542289805e-08,   4.204168925989523e-10,   7.631640314539569e-12,
  -4.387222282640665e-13,   1.911270233031791e-15,   3.359529904021135e-16,   1.125125704038018e+00,  -1.003503998221852e-02,   7.415935416061931e-05,   1.818825192168680e-07,
  -2.559721614725409e-08,   4.186368941060540e-10,   7.641422696958322e-12,  -4.363802190942180e-13,   1.840851321854633e-15,   3.345210352119333e-16,   1.125134028465136e+00,
  -1.003497766644175e-02,   7.414209265631267e-05,   1.823508537140992e-07,  -2.558429065690742e-08,   4.176110734261091e-10,   7.647010470304929e-12,  -4.350301335379166e-13,
   1.800377428826198e-15,   3.336926860991883e-16,   1.125137154204055e+00,  -1.003495425278422e-02,   7.413561154275381e-05,   1.825266190636624e-07,  -2.557943621639659e-08,
   4.172261417205471e-10,   7.649097824531486e-12,  -4.345234531785801e-13,   1.785210452058733e-15,   3.333812685756634e-16,   1.125137672331252e+00,  -1.003495037092525e-02,
   7.413453724513653e-05,   1.825557494697616e-07,  -2.557863148179397e-08,   4.171623482402356e-10,   7.649443258306560e-12,  -4.344394789727566e-13,   1.782697962430566e-15,
   3.333296275101708e-16,   1.445857680428791e+00,  -1.275862266318054e-02,   8.022045184775209e-05,   1.206931269024427e-06,  -7.247961003195911e-08,   1.415963702118448e-09,
   1.252315065690264e-11,  -1.482472948116537e-12,   3.036637020651264e-14,   4.103188129111534e-16,   1.445868972261847e+00,  -1.275810041707090e-02,   8.015872549363015e-05,
   1.208909217868370e-06,  -7.245150264237213e-08,   1.411569014007177e-09,   1.263949319578982e-11,  -1.480258291815880e-12,   3.014138653673575e-14,   4.145607339716592e-16,
   1.445887503310995e+00,  -1.275724246386640e-02,   8.005740947053296e-05,   1.212151835805687e-06,  -7.240518278254093e-08,   1.404359277899896e-09,   1.282984421886081e-11,
  -1.476607259982053e-12,   2.977271219600109e-14,   4.214725105549174e-16,   1.445907157594981e+00,  -1.275633129220580e-02,   7.994992955860643e-05,   1.215586383881738e-06,
  -7.235579377361693e-08,   1.396715807772426e-09,   1.303094707111445e-11,  -1.472712523419248e-12,   2.938243627313073e-14,   4.287359213439291e-16,   1.445922619400215e+00,
  -1.275561360438310e-02,   7.986535988459368e-05,   1.218284962276137e-06,  -7.231675098140901e-08,   1.390705161563983e-09,   1.318858389926850e-11,  -1.469632433196889e-12,
   2.907595164002446e-14,   4.344013525176503e-16,   1.445931540217541e+00,  -1.275519917602503e-02,   7.981656013472198e-05,   1.219840589997856e-06,  -7.229414926223808e-08,
   1.387238230749073e-09,   1.327930606586984e-11,  -1.467848902422815e-12,   2.889934019011490e-14,   4.376506239245621e-16,   1.445934889602018e+00,  -1.275504350934352e-02,
   7.979823668011849e-05,   1.220424408336848e-06,  -7.228564899877397e-08,   1.385936729210252e-09,   1.331332533045785e-11,  -1.467178047392474e-12,   2.883307131838160e-14,
   4.388669151736297e-16,   1.445935444785584e+00,  -1.275501770300469e-02,   7.979519937580285e-05,   1.220521166894617e-06,  -7.228423926811730e-08,   1.385721005993548e-09,
   1.331896198906387e-11,  -1.467066784483487e-12,   2.882208896883083e-14,   4.390683302898406e-16,   1.633511727753393e-03,  -1.426736703438664e-05,   1.195185728301673e-07,
  -7.437678002720707e-10,  -3.364611731560517e-12,   1.765155096178303e-13,   6.297288506333723e-16,  -1.530585485562071e-16,   2.945327308181377e-18,   5.151269361950055e-20,
   1.633528730364293e-03,  -1.426768369206467e-05,   1.195157084158896e-07,  -7.435204271290388e-10,  -3.363133856481889e-12,   1.760624288958193e-13,   6.410320413858180e-16,
  -1.527884918156374e-16,   2.924396629134525e-18,   5.174546722231682e-20,   1.633556642609437e-03,  -1.426820346146834e-05,   1.195110069703637e-07,  -7.431147882851607e-10,
  -3.360690475511549e-12,   1.753192107940837e-13,   6.595282344271826e-16,  -1.523443164038808e-16,   2.890114984580555e-18,   5.212383797368787e-20,   1.633586259261652e-03,
  -1.426875487455151e-05,   1.195060196757046e-07,  -7.426850046813335e-10,  -3.358074520123552e-12,   1.745313980075010e-13,   6.790729445225577e-16,  -1.518718866495479e-16,
   2.853847466490221e-18,   5.252021927064163e-20,   1.633609567435093e-03,  -1.426918876544794e-05,   1.195020955960767e-07,  -7.423472190080819e-10,  -3.355998890643646e-12,
   1.739119645028830e-13,   6.943960558447848e-16,  -1.514992731274856e-16,   2.825382881314478e-18,   5.282849500154617e-20,   1.633623018922547e-03,  -1.426943914268697e-05,
   1.194998313142641e-07,  -7.421524591048308e-10,  -3.354794259405775e-12,   1.735547097738906e-13,   7.032158343044499e-16,  -1.512839083104243e-16,   2.808986728685864e-18,
   5.300493693024393e-20,   1.633628070068071e-03,  -1.426953315622219e-05,   1.194989811261682e-07,  -7.420793593679733e-10,  -3.354340635089313e-12,   1.734206010372614e-13,
   7.065233130650275e-16,  -1.512029759998186e-16,   2.802835728532345e-18,   5.307091531129968e-20,   1.633628907366594e-03,  -1.426954874001557e-05,   1.194988401991372e-07,
  -7.420672438623286e-10,  -3.354265373230768e-12,   1.733983729147139e-13,   7.070713411004224e-16,  -1.511895571153819e-16,   2.801816424402992e-18,   5.308183755558991e-20,
   1.473620400853162e-02,  -1.287048983910424e-04,   1.077820067053923e-06,  -6.686526430489858e-09,  -3.124880629437820e-11,   1.612409158958133e-12,   5.602233670984732e-15,
  -1.390896096621632e-15,   2.683783378383999e-17,   4.667977401133440e-19,   1.473635733674253e-02,  -1.287077450395950e-04,   1.077793460703982e-06,  -6.684266581068681e-09,
  -3.123562983265010e-11,   1.608291758053137e-12,   5.705233072404286e-15,  -1.388448269989507e-15,   2.664734120801850e-17,   4.689306253668807e-19,   1.473660904709912e-02,
  -1.287124175848353e-04,   1.077749790589294e-06,  -6.680560891046438e-09,  -3.121384171235242e-11,   1.601537701224399e-12,   5.873778786999234e-15,  -1.384422127298916e-15,
   2.633533852139645e-17,   4.723977674287741e-19,   1.473687612755147e-02,  -1.287173745806999e-04,   1.077703464846800e-06,  -6.676634597850430e-09,  -3.119051015096390e-11,
   1.594378368340833e-12,   6.051879972612076e-15,  -1.380139765598248e-15,   2.600526018788654e-17,   4.760301678967882e-19,   1.473708631859984e-02,  -1.287212750855331e-04,
   1.077667014701353e-06,  -6.673548731011463e-09,  -3.117199446137494e-11,   1.588749187103926e-12,   6.191512492962468e-15,  -1.376762111569517e-15,   2.574619662470381e-17,
   4.788553389670823e-19,   1.473720762289350e-02,  -1.287235258719687e-04,   1.077645982013244e-06,  -6.671769478272837e-09,  -3.116124723122367e-11,   1.585502583814206e-12,
   6.271883372259309e-15,  -1.374809847712465e-15,   2.559697044533067e-17,   4.804723937858406e-19,   1.473725317365968e-02,  -1.287243710134237e-04,   1.077638084674628e-06,
  -6.671101665097427e-09,  -3.115719993622094e-11,   1.584283850561934e-12,   6.302023065298042e-15,  -1.374076197059331e-15,   2.554098829111929e-17,   4.810770847966446e-19,
   1.473726072434051e-02,  -1.287245111050148e-04,   1.077636775611773e-06,  -6.670990982063121e-09,  -3.115652842736374e-11,   1.584081849113442e-12,   6.307017021918982e-15,
  -1.373954554673746e-15,   2.553171128363878e-17,   4.811771876810711e-19,   4.112914687863045e-02,  -3.591982686641611e-04,   3.006052680070027e-06,  -1.852936566831410e-08,
  -9.237019744790130e-11,   4.615749840785635e-12,   1.517404194964661e-14,  -3.940265081592076e-15,   7.645328785715261e-17,   1.314618398361657e-18,   4.112957450382292e-02,
  -3.592061564197639e-04,   3.005974015220028e-06,  -1.852289550144151e-08,  -9.233433703489679e-11,   4.604085082174185e-12,   1.546748531459652e-14,  -3.933367706931104e-15,
   7.591197299426108e-17,   1.320763665692735e-18,   4.113027651174803e-02,  -3.592191034740363e-04,   3.005844897359541e-06,  -1.851228562690856e-08,  -9.227501955425122e-11,
   4.584950494642598e-12,   1.594767283754941e-14,  -3.922022533215755e-15,   7.502535962744102e-17,   1.330754138815436e-18,   4.113102138549696e-02,  -3.592328386197080e-04,
   3.005707925039406e-06,  -1.850104396461287e-08,  -9.221147317262736e-11,   4.564667632299331e-12,   1.645508929236557e-14,  -3.909954701296659e-15,   7.408736978844578e-17,
   1.341222091732083e-18,   4.113160759714968e-02,  -3.592436463130376e-04,   3.005600150178681e-06,  -1.849220846492075e-08,  -9.216102413285851e-11,   4.548719713253188e-12,
   1.685291105907898e-14,  -3.900435886354708e-15,   7.335117590140124e-17,   1.349364691155497e-18,   4.113194590819053e-02,  -3.592498828676736e-04,   3.005537960487063e-06,
  -1.848711403209568e-08,  -9.213173388803919e-11,   4.539521796519837e-12,   1.708189426429133e-14,  -3.894933877568905e-15,   7.292710917903249e-17,   1.354025685094260e-18,
   4.113207294675196e-02,  -3.592522246092461e-04,   3.005514609399544e-06,  -1.848520191128720e-08,  -9.212070205076421e-11,   4.536069010671111e-12,   1.716776500728310e-14,
  -3.892866215248940e-15,   7.276802007328999e-17,   1.355768717002855e-18,   4.113209400518034e-02,  -3.592526127786928e-04,   3.005510738715510e-06,  -1.848488499680567e-08,
  -9.211887162278838e-11,   4.535496721274817e-12,   1.718199326209879e-14,  -3.892523386188579e-15,   7.274165680377347e-17,   1.356057269062742e-18,   8.120263989355010e-02,
  -7.091131535157799e-04,   5.928203877440611e-06,  -3.616976941170558e-08,  -1.984345055343498e-10,   9.474338595765814e-12,   2.846742579332852e-14,  -7.960832042181196e-15,
   1.558213881849442e-16,   2.630756358743377e-18,   8.120348318057966e-02,  -7.091285482962027e-04,   5.928034833182554e-06,  -3.615648552324627e-08,  -1.983666657037936e-10,
   9.450769442394173e-12,   2.906558973520048e-14,  -7.947017383003049e-15,   1.547224776171275e-16,   2.643502532990026e-18,   8.120486755543688e-02,  -7.091538172679931e-04,
   5.927757363765085e-06,  -3.613470201982580e-08,  -1.982543848047822e-10,   9.412106916609982e-12,   3.004443146082443e-14,  -7.924292695265179e-15,   1.529225579394288e-16,
   2.664227226612647e-18,   8.120633646067979e-02,  -7.091806240975022e-04,   5.927463007493306e-06,  -3.611162084301404e-08,  -1.981340108288531e-10,   9.371123887385371e-12,
   3.107879554630125e-14,  -7.900118352941395e-15,   1.510183023377433e-16,   2.685946531314072e-18,   8.120749247983108e-02,  -7.092017172324015e-04,   5.927231391403273e-06,
  -3.609347957311179e-08,  -1.980383835850793e-10,   9.338899681336573e-12,   3.188976435912514e-14,  -7.881048667250073e-15,   1.495236957058450e-16,   2.702844098769071e-18,
   8.120815963427760e-02,  -7.092138888983692e-04,   5.927097738881152e-06,  -3.608301940227536e-08,  -1.979828382395872e-10,   9.320314362007483e-12,   3.235655691998218e-14,
  -7.870025504233290e-15,   1.486627531817845e-16,   2.712517828306397e-18,   8.120841015611917e-02,  -7.092184591786939e-04,   5.927047554375893e-06,  -3.607909330121981e-08,
  -1.979619130156774e-10,   9.313337640646417e-12,   3.253160924319916e-14,  -7.865882868562125e-15,   1.483397676590685e-16,   2.716135659713547e-18,   8.120845168363242e-02,
  -7.092192167521850e-04,   5.927039235752550e-06,  -3.607844258856518e-08,  -1.979584408069208e-10,   9.312181267999667e-12,   3.256061438847554e-14,  -7.865195992118149e-15,
   1.482862443780401e-16,   2.716734589595108e-18,   1.355831800968494e-01,  -1.183846542204429e-03,   9.882173054809623e-06,  -5.940418003916980e-08,  -3.698508540679825e-10,
   1.669060900441312e-11,   4.377210726678523e-14,  -1.372688848532645e-14,   2.720539000144456e-16,   4.471883646873063e-18,   1.355845857688526e-01,  -1.183871820523827e-03,
   9.881857865340484e-06,  -5.938077089853932e-08,  -3.697450657171306e-10,   1.664996376528152e-11,   4.481668916225347e-14,  -1.370337542912289e-14,   2.701463156587705e-16,
   4.494686689935044e-18,   1.355868933746940e-01,  -1.183913311834214e-03,   9.881340499985115e-06,  -5.934238265345002e-08,  -3.695698062861593e-10,   1.658328919905245e-11,
   4.652608625792754e-14,  -1.366469314840895e-14,   2.670217911086327e-16,   4.531770781553728e-18,   1.355893418790302e-01,  -1.183957327621939e-03,   9.880791629891524e-06,
  -5.930170633222080e-08,  -3.693816851311066e-10,   1.651261197287732e-11,   4.833248860325173e-14,  -1.362353780034581e-14,   2.637160555712303e-16,   4.570644691015089e-18,
   1.355912688330943e-01,  -1.183991961261089e-03,   9.880359735104830e-06,  -5.926973479179239e-08,  -3.692320744094138e-10,   1.645703912128920e-11,   4.974878766038525e-14,
  -1.359106890326493e-14,   2.611213932584528e-16,   4.600895860147468e-18,   1.355923809032538e-01,  -1.184011946200499e-03,   9.880110507917614e-06,  -5.925129979313586e-08,
  -3.691451076424009e-10,   1.642498720791271e-11,   5.056402025671422e-14,  -1.357229881328704e-14,   2.596267560708235e-16,   4.618217397083489e-18,   1.355927984942546e-01,
  -1.184019450212887e-03,   9.880016925889860e-06,  -5.924438036717464e-08,  -3.691123330505252e-10,   1.641295522908840e-11,   5.086974382238825e-14,  -1.356524449640128e-14,
   2.590660328430595e-16,   4.624695959689803e-18,   1.355928677158135e-01,  -1.184020694082339e-03,   9.880001413607098e-06,  -5.924323353676116e-08,  -3.691068939867065e-10,
   1.641096095867297e-11,   5.092040055496212e-14,  -1.356407482843670e-14,   2.589731127900184e-16,   4.625768511825169e-18,   2.051925903478712e-01,  -1.791327201672115e-03,
   1.492236256396222e-05,  -8.784468810419065e-08,  -6.403467310345617e-10,   2.709732260406118e-11,   5.783921119026340e-14,  -2.168292339532437e-14,   4.371294291987555e-16,
   6.918043290075462e-18,   2.051947128118543e-01,  -1.791364570292366e-03,   1.492181662953998e-05,  -8.780666824686000e-08,  -6.402034132414297e-10,   2.703310853413288e-11,
   5.951813033101065e-14,  -2.164648025412432e-14,   4.340892256513557e-16,   6.955883543368247e-18,   2.051981971240765e-01,  -1.791425905326949e-03,   1.492092048451729e-05,
  -8.774431830042495e-08,  -6.399655768843983e-10,   2.692777010048070e-11,   6.226565602683533e-14,  -2.158651708819553e-14,   4.291093769039931e-16,   7.017438300822639e-18,
   2.052018941726787e-01,  -1.791490970780501e-03,   1.491996973492224e-05,  -8.767824957435659e-08,  -6.397097462524509e-10,   2.681610588821431e-11,   6.516919786116430e-14,
  -2.152270804013365e-14,   4.238405086391153e-16,   7.081985736868133e-18,   2.052048037143667e-01,  -1.791542166233423e-03,   1.491922158444998e-05,  -8.762631782225549e-08,
  -6.395059011007873e-10,   2.672830389004274e-11,   6.744577425446767e-14,  -2.147235802173259e-14,   4.197048401059532e-16,   7.132231611637123e-18,   2.052064828457289e-01,
  -1.791571707563208e-03,   1.491878985026475e-05,  -8.759637290890295e-08,  -6.393872557962441e-10,   2.667766307645485e-11,   6.875621779825479e-14,  -2.144324743777964e-14,
   4.173224574328876e-16,   7.161008348811426e-18,   2.052071133720870e-01,  -1.791582799763390e-03,   1.491862773700909e-05,  -8.758513319322778e-08,  -6.393425140873773e-10,
   2.665865289401101e-11,   6.924765778903704e-14,  -2.143230621622519e-14,   4.164286792535039e-16,   7.171772579261762e-18,   2.052072178906363e-01,  -1.791584638408828e-03,
   1.491860086479825e-05,  -8.758327030777962e-08,  -6.393350875321309e-10,   2.665550199799152e-11,   6.932908701003793e-14,  -2.143049203031089e-14,   4.162805665232742e-16,
   7.173554705475085e-18,   2.913477834463349e-01,  -2.542856652334883e-03,   2.112365479095957e-05,  -1.207516228350715e-07,  -1.065946359524861e-09,   4.208570340110564e-11,
   6.433907374208090e-14,  -3.254999081090059e-14,   6.715106484735377e-16,   1.007142376841439e-17,   2.913507876692776e-01,  -2.542907995309164e-03,   2.112274560510168e-05,
  -1.206925450850967e-07,  -1.065778507366285e-09,   4.198928259526626e-11,   6.691929246795257e-14,  -3.249678943488312e-14,   6.668934696352489e-16,   1.013202493070631e-17,
   2.913557194942450e-01,  -2.542992265073873e-03,   2.112125314254630e-05,  -1.205956582131111e-07,  -1.065499020598217e-09,   4.183110817494019e-11,   7.114193693708416e-14,
  -3.240923295562290e-14,   6.593302111702506e-16,   1.023063729413990e-17,   2.913609524150704e-01,  -2.543081657310451e-03,   2.111966967954311e-05,  -1.204929879866353e-07,
  -1.065197133053315e-09,   4.166343071149669e-11,   7.560457245618645e-14,  -3.231603450105124e-14,   6.513275554868574e-16,   1.033408826138627e-17,   2.913650706595815e-01,
  -2.543151991747112e-03,   2.111842359917482e-05,  -1.204122831153840e-07,  -1.064955695268177e-09,   4.153158213186135e-11,   7.910373852279216e-14,  -3.224247515213269e-14,
   6.450457486988248e-16,   1.041465018793683e-17,   2.913674473422731e-01,  -2.543192576025793e-03,   2.111770450759632e-05,  -1.203657456761069e-07,  -1.064814816115731e-09,
   4.145553568661288e-11,   8.111799084419543e-14,  -3.219993821642811e-14,   6.414269395299636e-16,   1.046080249683685e-17,   2.913683398033123e-01,  -2.543207814484529e-03,
   2.111743449024890e-05,  -1.203482777591600e-07,  -1.064761623728430e-09,   4.142698818263938e-11,   8.187338343845733e-14,  -3.218394927600663e-14,   6.400692776970549e-16,
   1.047806870737926e-17,   2.913684877411377e-01,  -2.543210340406428e-03,   2.111738973146806e-05,  -1.203453825898149e-07,  -1.064752790992757e-09,   4.142225648398477e-11,
   8.199854893694442e-14,  -3.218129804288731e-14,   6.398442910729594e-16,   1.048092743225531e-17,   3.959315102640183e-01,  -3.454540199768492e-03,   2.858725313361183e-05,
  -1.566805111159104e-07,  -1.743337119743874e-09,   6.408073584315319e-11,   5.025177335845094e-14,  -4.753882117973657e-14,   1.011949510964059e-15,   1.403670760585259e-17,
   3.959355754485718e-01,  -3.454606772394364e-03,   2.858576548679001e-05,  -1.565905078109046e-07,  -1.743183838139753e-09,   6.393986325774950e-11,   5.414241853907343e-14,
  -4.746435781888932e-14,   1.005104432893803e-15,   1.413302914167575e-17,   3.959422489542780e-01,  -3.454716034642661e-03,   2.858332338281637e-05,  -1.564428972123607e-07,
  -1.742926273942026e-09,   6.370876057859715e-11,   6.050996577201917e-14,  -4.734176747999013e-14,   9.938910244074080e-16,   1.428983152220382e-17,   3.959493298521859e-01,
  -3.454831932994533e-03,   2.858073227192563e-05,  -1.562864671080499e-07,  -1.742644938732482e-09,   6.346376398628228e-11,   6.723985719823425e-14,  -4.721122115477795e-14,
   9.820252148504921e-16,   1.445441578191404e-17,   3.959549024058781e-01,  -3.454923118591711e-03,   2.857869316431502e-05,  -1.561634977387173e-07,  -1.742417718414064e-09,
   6.327111085974455e-11,   7.251711059663203e-14,  -4.710814339413452e-14,   9.727102855744323e-16,   1.458264910119034e-17,   3.959581183753894e-01,  -3.454975732760344e-03,
   2.857751640015297e-05,  -1.560925865856345e-07,  -1.742284261229989e-09,   6.315999140466231e-11,   7.555502757313878e-14,  -4.704852075654377e-14,   9.673438897920310e-16,
   1.465613726236523e-17,   3.959593259925435e-01,  -3.454995487859023e-03,   2.857707452202044e-05,  -1.560659694895510e-07,  -1.742233707995554e-09,   6.311827713482738e-11,
   7.669434343958662e-14,  -4.702610653312643e-14,   9.653305377993851e-16,   1.468363510135624e-17,   3.959595261717723e-01,  -3.454998762441543e-03,   2.857700127484555e-05,
  -1.560615578917684e-07,  -1.742225304940457e-09,   6.311136304091673e-11,   7.688312477245502e-14,  -4.702238972047591e-14,   9.649968899539752e-16,   1.468818811205518e-17,
   5.216996792937472e-01,  -4.549841560813601e-03,   3.744872148467419e-05,  -1.926734844483705e-07,  -2.850901657377263e-09,   9.762925763911320e-11,  -1.352860194670464e-14,
  -6.881322150478641e-14,   1.530156231285681e-15,   1.882357526358228e-17,   5.217050036273353e-01,  -4.549923332953293e-03,   3.744628752465280e-05,  -1.925362719807795e-07,
  -2.850860890978399e-09,   9.742522782125986e-11,  -7.640491068933067e-15,  -6.871265151220760e-14,   1.520054644013877e-15,   1.897951690333238e-17,   5.217137441325994e-01,
  -4.550057533221434e-03,   3.744229183238727e-05,  -1.923112246841620e-07,  -2.850784992654636e-09,   9.709049972753233e-11,   1.996897112991683e-15,  -6.854698734000091e-14,
   1.503504969496224e-15,   1.923350642436637e-17,   5.217230181444729e-01,  -4.550199873122856e-03,   3.743805216096146e-05,  -1.920727162703171e-07,  -2.850692286995584e-09,
   9.673562682952926e-11,   1.218368833376686e-14,  -6.837044475635990e-14,   1.485990332559390e-15,   1.950028002567049e-17,   5.217303165945775e-01,  -4.550311854163859e-03,
   3.743471556804337e-05,  -1.918852145373237e-07,  -2.850610533616588e-09,   9.645655733832720e-11,   2.017239030514289e-14,  -6.823095766647477e-14,   1.472239434241178e-15,
   1.970826286033421e-17,   5.217345285742545e-01,  -4.550376464102677e-03,   3.743278997614889e-05,  -1.917770860197591e-07,  -2.850559833534652e-09,   9.629558816844002e-11,
   2.477147364001674e-14,  -6.815023865939644e-14,   1.464316841363364e-15,   1.982750650168423e-17,   5.217361101958716e-01,  -4.550400722657761e-03,   3.743206690132898e-05,
  -1.917364982566031e-07,  -2.850540130842834e-09,   9.623515916327463e-11,   2.649633101325020e-14,  -6.811988673654991e-14,   1.461344347175385e-15,   1.987213511422560e-17,
   5.217363723713105e-01,  -4.550404743695961e-03,   3.743194704154535e-05,  -1.917297710752100e-07,  -2.850536829812704e-09,   9.622514306262757e-11,   2.678213773860684e-14,
  -6.811485330396341e-14,   1.460851746580537e-15,   1.987952511445120e-17,   6.728827376402217e-01,  -5.864522877210111e-03,   4.788663853210528e-05,  -2.221703578245400e-07,
  -4.753001368849683e-09,   1.522576193455360e-10,  -2.006472301370990e-13,  -1.006236715333471e-13,   2.384605736032240e-15,   2.389866653756794e-17,   6.728895440959849e-01,
  -5.864616970545090e-03,   4.788257845308009e-05,  -2.219562034259357e-07,  -4.753320973851454e-09,   1.519589933019004e-10,  -1.914588355913854e-13,  -1.004941880441200e-13,
   2.369462662853027e-15,   2.416419240431742e-17,   6.729007175771718e-01,  -5.864771374494694e-03,   4.787591301315354e-05,  -2.216049405944432e-07,  -4.753831647055445e-09,
   1.514690345162773e-10,  -1.764179419656698e-13,  -1.002806604256569e-13,   2.344649631219335e-15,   2.459695303800428e-17,   6.729125729368993e-01,  -5.864935120067255e-03,
   4.786884024918808e-05,  -2.212326396689272e-07,  -4.754354506334579e-09,   1.509495377402375e-10,  -1.605172241211794e-13,  -1.000527933917120e-13,   2.318384720980782e-15,
   2.505188572085682e-17,   6.729219027565068e-01,  -5.865063924330490e-03,   4.786327379329679e-05,  -2.209399380147229e-07,  -4.754752268223893e-09,   1.505409723857807e-10,
  -1.480458139196868e-13,  -9.987252621392572e-14,   2.297760221592599e-15,   2.540684524422812e-17,   6.729272870131747e-01,  -5.865138234003004e-03,   4.786006122243405e-05,
  -2.207711348323543e-07,  -4.754976329698810e-09,   1.503052943922885e-10,  -1.408653514917892e-13,  -9.976811748825194e-14,   2.285875924402043e-15,   2.561046982568067e-17,
   6.729293088239704e-01,  -5.865166133151630e-03,   4.785885485887202e-05,  -2.207077703609007e-07,  -4.755059429577745e-09,   1.502168163661914e-10,  -1.381722334401376e-13,
  -9.972884066426415e-14,   2.281416752141339e-15,   2.568670085745522e-17,   6.729296439664076e-01,  -5.865170757577858e-03,   4.785865488625361e-05,  -2.206972679955618e-07,
  -4.755073149870266e-09,   1.502021509969009e-10,  -1.377259802293011e-13,  -9.972232626408953e-14,   2.280677765173158e-15,   2.569932501076208e-17,   8.565226340882055e-01,
  -7.457427655580982e-03,   6.011732179296327e-05,  -2.285562757793362e-07,  -8.320726908169242e-09,   2.516723485788978e-10,  -7.371395962685133e-13,  -1.525820732670321e-13,
   3.999663794327267e-15,   2.581318249021724e-17,   8.565311749218483e-01,  -7.457523980271984e-03,   6.011020940067985e-05,  -2.282019553709620e-07,  -8.322117624088349e-09,
   2.512187164614994e-10,  -7.216926051598744e-13,  -1.524365235483153e-13,   3.975987511723797e-15,   2.631374069149054e-17,   8.565451953502079e-01,  -7.457682004408929e-03,
   6.009853245679309e-05,  -2.276207466588450e-07,  -8.324377137064301e-09,   2.504743288471852e-10,  -6.964016993135086e-13,  -1.521957658250176e-13,   3.937181208786631e-15,
   2.713028949315073e-17,   8.565600711130472e-01,  -7.457849532941390e-03,   6.008614123620708e-05,  -2.270046718717997e-07,  -8.326742675400456e-09,   2.496849170547550e-10,
  -6.696581814379933e-13,  -1.519378479692579e-13,   3.896089364119543e-15,   2.798966270768243e-17,   8.565717776959606e-01,  -7.457981272196216e-03,   6.007638850424994e-05,
  -2.265202756331743e-07,  -8.328581257276692e-09,   2.490639667819774e-10,  -6.486774888293850e-13,  -1.517330957786562e-13,   3.863811289409717e-15,   2.866090424646462e-17,
   8.565785335050117e-01,  -7.458057258793750e-03,   6.007075970280172e-05,  -2.262409045747325e-07,  -8.329633090264236e-09,   2.487057334375539e-10,  -6.365957904241372e-13,
  -1.516142226921325e-13,   3.845207648378979e-15,   2.904625506581653e-17,   8.565810703238903e-01,  -7.458085784447917e-03,   6.006864597369893e-05,  -2.261360326386642e-07,
  -8.330026317690678e-09,   2.485712377394696e-10,  -6.320640303082452e-13,  -1.515694514339150e-13,   3.838226463922414e-15,   2.919057386769807e-17,   8.565814908350505e-01,
  -7.458090512557798e-03,   6.006829558978097e-05,  -2.261186504432365e-07,  -8.330091408681843e-09,   2.485489444456416e-10,  -6.313130918930359e-13,  -1.515620229362643e-13,
   3.837069479047535e-15,   2.921447651608455e-17,   1.086116340006291e+00,  -9.438941413624646e-03,   7.426255772214091e-05,  -1.584915090413999e-07,  -1.627781037318982e-08,
   4.751333961835679e-10,  -2.594749308850884e-12,  -2.516677732821640e-13,   7.954479757207426e-15,   2.221523239005740e-19,   1.086126880104918e+00,  -9.439006712046564e-03,
   7.424862988081463e-05,  -1.578217038221283e-07,  -1.628298365645179e-08,   4.743818722756339e-10,  -2.563880767779554e-12,  -2.516357340911919e-13,   7.914574801471705e-15,
   1.382030495193231e-18,   1.086144181946026e+00,  -9.439113704780830e-03,   7.422576199741818e-05,  -1.567228828435047e-07,  -1.629142925217759e-08,   4.731482132465760e-10,
  -2.513319648270917e-12,  -2.515789129402872e-13,   7.849123150866546e-15,   3.276715507174982e-18,   1.086162538584115e+00,  -9.439226953596671e-03,   7.420149323847515e-05,
  -1.555579989481394e-07,  -1.630032664896264e-08,   4.718393317044649e-10,  -2.459826030506764e-12,  -2.515129001349282e-13,   7.779754387365472e-15,   5.274309088629706e-18,
   1.086176983940947e+00,  -9.439315879293543e-03,   7.418239059282883e-05,  -1.546419894456318e-07,  -1.630728266125818e-08,   4.708093301862490e-10,  -2.417838883450573e-12,
  -2.514568204111498e-13,   7.725219550819041e-15,   6.837163904531056e-18,   1.086185320072084e+00,  -9.439367119227906e-03,   7.417136488207274e-05,  -1.541136471770807e-07,
  -1.631127858335027e-08,   4.702149355778169e-10,  -2.393652395257656e-12,  -2.514228062082088e-13,   7.693770129893619e-15,   7.735410533919484e-18,   1.086188450265091e+00,
  -9.439386345060178e-03,   7.416722439163926e-05,  -1.539153069961556e-07,  -1.631277559270127e-08,   4.699917420919275e-10,  -2.384578652759752e-12,  -2.514097223507216e-13,
   7.681965057098341e-15,   8.072010944558126e-18,   1.086188969133736e+00,  -9.439389531211470e-03,   7.416653803415174e-05,  -1.538824323104997e-07,  -1.631302355890688e-08,
 