//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_8.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot8(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[8] = {7.479188259681809e-02,6.772490876492899e-01,1.905113635031426e+00,3.809476361484904e+00,6.483145428627162e+00,
    1.009332367522134e+01,1.497262708842639e+01,2.198427284096267e+01};
  constexpr double aw[8] = {5.079294790166138e-01,2.806474585285338e-01,8.381004139898594e-02,1.288031153550992e-02,9.322840086241799e-04,
    2.711860092537858e-05,2.320980844865209e-07,2.654807474011186e-10};
  constexpr double x[3072] = {  1.703852336899448e-02, -4.971200157273414e-04,  1.078591009321988e-05, -2.057293770204887e-07,  3.624793455223872e-09,
 -6.019529448575780e-11,  9.491459333242739e-13, -1.422689715448951e-14,  2.015908193162744e-16, -2.666507833952862e-18,  3.194787059818172e-20, -3.225809912631879e-22,
  1.502347811917729e-01, -4.104519277125435e-03,  7.749732598649772e-05, -1.140324378805951e-06,  1.223751710228389e-08, -5.221744856168142e-11, -1.571362617573999e-12,
  5.278085627817340e-14, -9.432749211628103e-16,  1.006518478932882e-17,  3.395621825932339e-21, -3.073885522828818e-21,  4.002480376852924e-01, -9.525922227948885e-03,
  1.287743595810251e-04, -6.685397217184442e-07, -1.492788184545640e-08,  4.229669048342578e-10, -3.599087907944020e-12, -5.780631006518650e-14,  2.228812793341683e-15,
 -2.445515110716872e-17, -2.727995498434328e-19,  1.395451330646858e-20,  7.354259529984234e-01, -1.397342622234178e-02,  8.614272965809309e-05,  1.461830183223913e-06,
 -3.037454224776548e-08, -1.402852495581438e-10,  1.030161405537825e-11, -4.576570764849547e-14, -3.130275118033124e-15,  4.530746422835263e-17,  7.399845640182782e-19,
 -2.441497521494939e-20,  1.111329672470795e+00, -1.500796741792139e-02, -3.478119645675282e-05,  2.216447262404276e-06,  1.358192449422469e-08, -5.766241081962188e-10,
 -5.801184025221333e-12,  1.774525614080738e-13,  2.569260319354875e-15, -5.875067418206600e-17, -1.164754541692170e-18,  1.986323021910227e-20,  1.475093775118596e+00,
 -1.189893747713472e-02, -1.282317723399387e-04,  2.460055848640000e-07,  3.165480722937595e-08,  3.615926572574653e-10, -4.501525508059314e-12, -1.835024722429443e-13,
 -1.148640191065851e-15,  4.924134048936147e-17,  1.179472911680052e-18, -8.965285499598169e-22,  1.772137653075815e+00, -6.263776812924895e-03, -1.119856921513019e-04,
 -1.363145917522438e-06, -6.408588695537449e-09,  1.882333251015419e-10,  6.111000161969132e-12,  9.003345875097289e-14,  2.793881781691531e-16, -2.258738106445554e-17,
 -6.645251537972886e-19, -9.085458545910360e-21,  1.955152136816918e+00, -1.368135049930105e-03, -3.057069605384741e-05, -5.873526885701565e-07, -1.010708182007862e-08,
 -1.565197435607033e-10, -2.134439032861345e-12, -2.381987967011197e-14, -1.585716299722690e-16,  1.544455384005740e-18,  8.940259940412189e-20,  2.283076571773742e-21,
  1.520826309271161e-02, -4.198058797938667e-04,  8.629077225164131e-06, -1.562496225162957e-07,  2.619836917188958e-09, -4.154761258039122e-11,  6.282807254151615e-13,
 -9.091238998118993e-15,  1.254507303372870e-16, -1.642469038673873e-18,  1.999879684299856e-20, -2.213028109790788e-22,  1.349745772018911e-01, -3.536038057664928e-03,
  6.494836863398478e-05, -9.544825929307987e-07,  1.091952660904944e-08, -7.527632228996053e-11, -4.626564597728429e-13,  2.821562404177553e-14, -6.021326973185085e-16,
  8.439586625427019e-18, -6.608818998131432e-20, -4.963560270296426e-22,  3.641490037427423e-01, -8.531267404708085e-03,  1.195815834483083e-04, -8.448205966691577e-07,
 -7.425416541343884e-09,  3.243632621323698e-10, -4.360356964339762e-12, -1.636453637480814e-15,  1.275491752691877e-15, -2.577322181803502e-17,  1.418523949875473e-19,
  5.140199674464230e-21,  6.810097923231093e-01, -1.322250728814940e-02,  1.007180262592168e-04,  9.662067336334292e-07, -3.086318310262541e-08,  8.191664927465333e-11,
  7.891653737408719e-12, -1.162015033536990e-13, -1.219829206782144e-15,  5.431101834703923e-17, -2.335485409225562e-19, -1.700841250953706e-20,  1.050913762564257e+00,
 -1.517704988342990e-02, -7.280082671524487e-06,  2.335762148594271e-06,  1.098329218807562e-09, -6.491640654028470e-10, -5.171328440007316e-14,  2.189307958494297e-13,
 -1.173427928668241e-16, -8.203696878163145e-17,  9.496359804818738e-20,  3.255263580125688e-20,  1.425477834474650e+00, -1.290387069032211e-02, -1.220261081657592e-04,
  8.026697705695950e-07,  3.737675114440506e-08,  1.896990830922208e-10, -9.825433059359328e-12, -1.833228037492426e-13,  1.393473748279112e-15,  8.775246549695889e-17,
  5.340665447829801e-19, -2.952346673284028e-20,  1.745185162428494e+00, -7.226494313479616e-03, -1.288062600316338e-04, -1.426733539596108e-06, -9.717824551435301e-10,
  3.652052056577094e-10,  8.593900858632921e-12,  8.008548873774894e-14, -1.102355878014190e-15, -5.629887402852897e-17, -9.746492026289346e-19, -2.478727397069343e-21,
  1.949141607693404e+00, -1.643899831216245e-03, -3.870216950203155e-05, -7.771286025996449e-07, -1.380640313284972e-08, -2.162414598769931e-10, -2.857808279951120e-12,
 -2.707435345069380e-14, -7.591703801251432e-18,  7.907353851597934e-18,  2.520542389208221e-19,  5.503577448667578e-21,  1.365615881166912e-02, -3.576188766252963e-04,
  6.980600273425572e-06, -1.202396080989626e-07,  1.921184358643411e-09, -2.911945882934317e-11,  4.220371998544568e-13, -5.885943547703721e-15,  7.861391952549343e-17,
 -1.011316679272943e-18,  1.215442018803916e-20, -1.393919408956394e-22,  1.218010969499653e-01, -3.059413315036190e-03,  5.449186255965245e-05, -7.921848318365611e-07,
  9.356825645943414e-09, -7.881509840797858e-11,  9.952176232651848e-14,  1.327673069215580e-14, -3.480595630471110e-16,  5.681189838635895e-18, -6.601234035485832e-20,
  3.210478989941085e-22,  3.318707854877422e-01, -7.616729524955161e-03,  1.089266920416700e-04, -9.173581689018703e-07, -1.967978851837372e-09,  2.229675499412280e-10,
 -3.964468179603742e-12,  2.575180893624414e-14,  4.864781981357323e-16, -1.746902623592166e-17,  2.345974205309068e-19, -1.843126764028981e-22,  6.297930732316823e-01,
 -1.237859430596758e-02,  1.094338758796711e-04,  4.946298372181310e-07, -2.760986555500972e-08,  2.295724587297934e-10,  4.365415581323597e-12, -1.269567874371480e-13,
  4.269490102711030e-16,  3.441174831701806e-17, -6.531578092930534e-19, -2.368236372109529e-21,  9.902657323533017e-01, -1.512385218626465e-02,  2.043143771103889e-05,
  2.251444162838085e-06, -1.141428913273147e-08, -5.799045342164322e-10,  5.602546240796023e-12,  1.713029094308460e-13, -2.683067563313247e-15, -5.284852789300927e-17,
  1.235092240131467e-18,  1.521217261112246e-20,  1.371985554886220e+00, -1.383118799235542e-02, -1.087266709521957e-04,  1.416620970937689e-06,  3.843558944307638e-08,
 -9.967415279349191e-11, -1.384687870310248e-11, -8.705848691497711e-14,  4.557064909027529e-15,  7.617602385959826e-17, -1.229617696925453e-18, -4.484515541288188e-20,
  1.714110307847923e+00, -8.325060606606510e-03, -1.457411646830852e-04, -1.371978706770705e-06,  8.546964893335314e-09,  5.922405520275640e-10,  9.984536736396124e-12,
  4.993214251636704e-15, -3.801918179466037e-15, -9.103150556440524e-17, -5.553903512022887e-19,  2.591615059586337e-20,  1.941881944831262e+00, -1.994928867740180e-03,
 -4.950861470197734e-05, -1.036610355015658e-06, -1.887724086540485e-08, -2.936073621300779e-10, -3.559449381182279e-12, -2.025433122181626e-14,  5.306747650810022e-16,
  2.438696470976015e-17,  6.157546643345128e-19,  1.150616699507322e-20,  1.232891826658635e-02, -3.070639583833393e-04,  5.704580845435729e-06, -9.366075523119425e-08,
  1.428072498920601e-09, -2.071453572770121e-11,  2.875819503052525e-13, -3.869788820310322e-15,  4.965988291673129e-17, -6.281772856791335e-19,  7.467621667174581e-21,
 -7.537404321508300e-23,  1.103785442461418e-01, -2.659076642287538e-03,  4.583259803227060e-05, -6.548502623595019e-07,  7.828754061394293e-09, -7.305263648184088e-11,
  3.426384861075718e-13,  4.934282168179868e-15, -1.869181820187356e-16,  3.400224738413956e-18, -4.665191123921937e-20,  5.190076237796511e-22,  3.030766256630215e-01,
 -6.789577825539797e-03,  9.786061178262859e-05, -9.180706984393054e-07,  1.605162396748282e-09,  1.377144534745611e-10, -3.107416514792818e-12,  3.300893808867934e-14,
  1.826777574100213e-17, -8.887935612062250e-18,  1.846343962386140e-19, -1.565044212102815e-21,  5.820571272231946e-01, -1.148651085843932e-02,  1.128856370255445e-04,
  9.412810553601118e-08, -2.224648010707272e-08,  2.941919291238364e-10,  1.152000679279448e-12, -9.851983653361784e-14,  1.200076044049659e-15,  9.347049210243411e-18,
 -5.368958960167394e-19,  6.311616528432045e-21,  9.302628598921358e-01, -1.485626272141171e-02,  4.599791781253148e-05,  1.984773815943139e-06, -2.133553510844362e-08,
 -3.989812856992145e-10,  8.984157371912481e-12,  6.535978279929434e-14, -3.609138929815266e-15,  1.857050677388419e-18,  1.310673962716801e-18, -1.030955090323569e-20,
  1.315043247653988e+00, -1.462282069862683e-02, -8.816316505380500e-05,  1.997082263865231e-06,  3.301579026287902e-08, -4.426691991668303e-10, -1.391947952267572e-11,
  8.956632877747723e-14,  5.984885768696721e-15, -6.584318759765424e-18, -2.662698386977590e-18, -1.140296436102819e-20,  1.678378510775971e+00, -9.553536239416157e-03,
 -1.609518992850610e-04, -1.127688498300844e-06,  2.271515086312125e-08,  8.166876682133009e-10,  7.914624620339088e-12, -1.703708038558498e-13, -7.083080338453852e-15,
 -7.699976917900026e-17,  1.602075803090919e-18,  7.233202158689187e-20,  1.933023432950301e+00, -2.446366906033476e-03, -6.396938736937696e-05, -1.390410938599585e-06,
 -2.563552813815668e-08, -3.829125710604516e-10, -3.716572141721658e-12,  1.664974046025019e-14,  1.993967064323329e-15,  6.132877969859964e-17,  1.282739657542911e-18,
  1.836311376282991e-20,  1.118532723775232e-02, -2.655638125028243e-04,  4.705196465961591e-06, -7.378477233325282e-08,  1.074871188132169e-09, -1.495222422901995e-11,
  1.984542238939035e-13, -2.590331348686030e-15,  3.177499176850912e-17, -3.793441028424580e-19,  5.346285933563319e-21, -2.487470182248897e-23,  1.004286543573331e-01,
 -2.321827198195182e-03,  3.867928983945900e-05, -5.407956733443015e-07,  6.458069122037544e-09, -6.374592204972733e-11,  4.131608200296745e-13,  5.976998159861855e-16,
 -9.233597402069286e-17,  2.018113384364360e-18, -2.197121405431386e-20,  5.810767055962350e-22,  2.774151718703833e-01, -6.050139167430208e-03,  8.707647899025873e-05,
 -8.740937369875350e-07,  3.687797671084917e-09,  7.404558295787555e-11, -2.213675966912600e-12,  2.977050247777253e-14, -1.843677399086664e-16, -2.753708587799286e-18,
  1.271166111647915e-19, -9.150225825612056e-22,  5.379164616354287e-01, -1.058450605393754e-02,  1.120761761400353e-04, -2.140998534072654e-07, -1.628635066741794e-08,
  2.932541601463739e-10, -1.044422146750403e-12, -5.827307432961781e-14,  1.225846482705111e-15, -5.683444781974491e-18, -2.034282619666090e-19,  7.888733259040526e-21,
  8.717157246234978e-01, -1.439934169044721e-02,  6.754275708652609e-05,  1.591675152839610e-06, -2.707668078982873e-08, -1.740547697449281e-10,  9.273070923512316e-12,
 -4.009105658964905e-14, -2.745400104282104e-15,  4.142516391943441e-17,  6.154806194187900e-19, -1.758403858476343e-20,  1.255304781882296e+00, -1.522407077592940e-02,
 -6.137637330496210e-05,  2.437588778800419e-06,  2.113308721491395e-08, -7.259592465136985e-10, -8.912901229143485e-12,  2.568499640618732e-13,  3.877709820936454e-15,
 -1.045715195074204e-16, -1.773440067051142e-18,  5.073193963237295e-20,  1.637513862670248e+00, -1.088780356365087e-02, -1.717366628735021e-04, -6.253652768964817e-07,
  4.042091556135379e-08,  9.218277650658563e-10, -3.185936291691647e-13, -4.222288031950799e-13, -7.855440821886191e-15,  5.834248978377580e-17,  5.201919142742194e-18,
  7.549611035344492e-20,  1.922098134539648e+00, -3.032446691469116e-03, -8.338294043760347e-05, -1.866373667632735e-06, -3.410065734119873e-08, -4.568718749451795e-10,
 -1.945250891470280e-12,  1.272911359994165e-13,  5.322262357344126e-15,  1.287073642633613e-16,  2.037091800930851e-18,  1.084939806117347e-20,  1.019313225278922e-02,
 -2.311927055125057e-04,  3.913873907072733e-06, -5.874314516292914e-08,  8.181263405612038e-10, -1.095596260775189e-11,  1.383913379062030e-13, -1.752446912163107e-15,
  2.176806644288946e-17, -1.812794258691580e-19,  4.586220389221559e-21, -2.155061805304740e-23,  9.172147030050198e-02, -2.036687863817463e-03,  3.276939213898743e-05,
 -4.471266602882829e-07,  5.282205984743522e-09, -5.390084455367609e-11,  3.985245218807205e-13, -1.315975060437602e-15, -2.964641083529250e-17,  1.610224307498618e-18,
 -3.500856754476013e-22,  3.098037623517659e-22,  2.545429502718669e-01, -5.394385603593808e-03,  7.698164586583588e-05, -8.058577359544336e-07,  4.701234620361922e-09,
  3.019534516222735e-11, -1.471000401086325e-12,  2.319914377830929e-14, -1.999657958068507e-16,  1.694964901612623e-18,  9.684570020048711e-20, -7.359396897032966e-22,
  4.973497042415152e-01, -9.702168867250584e-03,  1.081312943689793e-04, -4.296005788530573e-07, -1.078213774380398e-08,  2.528119547925676e-10, -2.165075691110903e-12,
 -2.324626578021203e-14,  9.526870641941828e-16, -7.576974034942254e-18,  8.280622361271529e-20,  4.326827024341829e-21,  8.153093589008797e-01, -1.379015263999574e-02,
  8.396635940297738e-05,  1.142150338126563e-06, -2.846812179635348e-08,  2.661294156213003e-11,  7.170324317914367e-12, -1.007521084697089e-13, -9.825984194908052e-16,
  5.230131591556240e-17, -1.851115124696002e-20, -1.068522521509844e-20,  1.193618314543629e+00, -1.559349527203730e-02, -3.060612944884908e-05,  2.650591349350834e-06,
  5.113653922628393e-09, -8.433915556084120e-10, -6.185770037648566e-13,  3.120785507010216e-13, -5.255426725424249e-16, -1.209454517606356e-16,  1.056393982875173e-18,
  6.406016353793696e-20,  1.591184672975439e+00, -1.227934333085835e-02, -1.747657061363359e-04,  1.639557728266860e-07,  5.769050285077410e-08,  7.474198421105811e-10,
 -1.502737951482028e-11, -5.947946008380853e-13, -1.444026479378320e-15,  3.047278515759034e-16,  6.126891544262688e-18, -5.984948116430395e-20,  1.908478354595617e+00,
 -3.799074824850567e-03, -1.093585641160430e-04, -2.486001780199722e-06, -4.329654081669114e-08, -4.366881988841733e-10,  4.814034473044668e-12,  3.876888406910181e-13,
  1.142208557956215e-14,  2.057524740906997e-16,  1.289924426453135e-18, -6.304193417000359e-20,  9.326812521480337e-03, -2.024944127783890e-04,  3.280807603585302e-06,
 -4.724094783870573e-08,  6.286320906637230e-10, -8.149505003134398e-12,  9.833128250686482e-14, -1.127627273906791e-15,  1.817306151859084e-17, -3.355968672871365e-20,
  2.249498846362630e-21, -9.610145382275757e-23,  8.406697201376846e-02, -1.794636666994987e-03,  2.787703542868085e-05, -3.707295916415639e-07,  4.296524748362082e-09,
 -4.483171933308027e-11,  3.571857867719175e-13, -1.325576652305551e-15,  2.941854375830992e-17,  1.647117809288026e-18, -4.392353036491392e-21, -5.857457600984674e-22,
  2.341377203683291e-01, -4.815900390643713e-03,  6.777696119769351e-05, -7.275160947298389e-07,  5.001310633725063e-09,  2.044348774417519e-12, -8.969728291168946e-13,
  1.843953549397154e-14, -8.045551518684816e-17,  4.512351952071177e-18,  3.002646234789335e-20, -2.632238878950022e-21,  4.602348219747446e-01, -8.860307007251612e-03,
  1.020982508480877e-04, -5.646503995004967e-07, -6.281398308665139e-09,  1.962622058867116e-10, -2.424034146312523e-12,  3.768567364492380e-15,  7.670665050407953e-16,
 -2.526316356036027e-18,  1.121637762377909e-19, -3.504007818115295e-21,  7.615682055869492e-01, -1.307124562377180e-02,  9.498434931547850e-05,  6.992675402994677e-07,
 -2.645455802484194e-08,  1.630084924486786e-10,  4.186203278027111e-12, -1.030485171545933e-13,  7.853722331419216e-16,  4.328008795259174e-17, -4.267150563867407e-19,
 -9.911510967948998e-21,  1.130956364835297e+00, -1.571099776103351e-02,  1.140556931154687e-06,  2.599549669550673e-06, -1.122027295758500e-08, -7.588882939582868e-10,
  7.315902081428537e-12,  2.384637045343516e-13, -3.567867696672798e-15, -3.740831902728354e-17,  2.627476430410055e-18, -2.246010512176672e-21,  1.539306965452749e+00,
 -1.365292651566133e-02, -1.668455110341155e-04,  1.181383837579854e-06,  6.770490335670618e-08,  1.933188860404855e-10, -3.039099019812715e-11, -4.272109176688413e-13,
  1.271137712066765e-14,  4.321666593111133e-16, -1.320741325580983e-18, -2.686845793179980e-19,  1.891325958811684e+00, -4.805649410639629e-03, -1.436028640671602e-04,
 -3.237815437023959e-06, -4.975244896426309e-08, -1.425732641810694e-10,  2.192503890193240e-11,  8.732202058382967e-13,  1.861300496085567e-14,  1.466574699428604e-16,
 -5.984902369085403e-18, -3.025383860514383e-19,  8.565963533182520e-03, -1.783561322327517e-04,  2.769275080092161e-06, -3.836809398915364e-08,  4.870204238167353e-10,
 -6.103457178165248e-12,  7.478456761135435e-14, -5.581428477896857e-16,  1.729061329756466e-17, -5.793531397679200e-20, -4.134385569962137e-21, -1.847268701780185e-22,
  7.730784623393178e-02, -1.588311919878525e-03,  2.381263813334349e-05, -3.087025286710494e-07,  3.483381321109719e-09, -3.654631070348878e-11,  3.415331824760816e-13,
  4.606951559297847e-16,  7.639026603685048e-17,  6.365812953944078e-19, -5.326019557887486e-20, -1.538077789932179e-21,  2.159051750346517e-01, -4.307248751800314e-03,
  5.952492565238835e-05, -6.481654179034300e-07,  4.867887874764525e-09, -1.342636621649493e-11, -3.921880460920303e-13,  1.842072593802495e-14,  6.834184627134058e-17,
  2.599296117986292e-18, -1.435983616573763e-19, -5.012624249993219e-21,  4.263822083669446e-01, -8.072054600072679e-03,  9.483894202720753e-05, -6.368268315001138e-07,
 -2.915316603416997e-09,  1.420619325967076e-10, -1.984872686385249e-12,  2.727042552181603e-14,  6.966071057626656e-16, -3.616244086335734e-18, -2.213522200766146e-19,
 -1.084069893045432e-20,  7.108463241864432e-01, -1.228472299161043e-02,  1.009586704168150e-04,  3.066219512119968e-07, -2.240313008014571e-08,  2.329916821526529e-10,
  1.857940023125257e-12, -5.724954452183496e-14,  1.913281791804129e-15,  1.548691629621633e-17, -1.015267603886052e-18, -1.669916406957129e-20,  1.068322449735670e+00,
 -1.558122807166238e-02,  3.079366620129093e-05,  2.310172133292713e-06, -2.417079979317921e-08, -5.166363129768410e-10,  1.232806255002876e-11,  1.213262501501591e-13,
 -3.273940146603991e-15,  4.119909716987716e-17,  7.659491930927721e-19, -7.433931080588378e-20,  1.482141558242560e+00, -1.491254829112711e-02, -1.461787516994664e-04,
  2.252899118365607e-06,  6.360380992364740e-08, -6.202380524335577e-10, -3.453430117485842e-11,  1.935941254535018e-13,  2.426154589185900e-14,  1.254139303772151e-16,
 -1.374778225302780e-17, -2.291983950714665e-19,  1.869540541048830e+00, -6.123404751607330e-03, -1.872086497141968e-04, -4.018511783336246e-06, -4.500133801592754e-08,
  7.467973659627534e-10,  5.499559890059495e-11,  1.474586594040435e-12,  1.538459113051280e-14, -4.681222620677986e-16, -2.740686685704466e-17, -6.524435557317613e-19,
  7.894106986126607e-03, -1.579197961686884e-04,  2.351887628145720e-06, -3.145902899748362e-08,  3.819432120510679e-10, -4.437109284963081e-12,  6.626807177239294e-14,
 -8.625809945242617e-17,  1.025256659648702e-17, -3.845237157867361e-19, -1.173011997342714e-20, -1.171424997280603e-22,  7.131340744790578e-02, -1.411733671007568e-03,
  2.041995866427136e-05, -2.583610223091309e-07,  2.836920983615662e-09, -2.791538765700008e-11,  3.883807021856453e-13,  2.724615823190716e-15,  4.425845455783957e-17,
 -2.860082283411550e-18, -1.178018623248576e-19, -9.860279792383300e-22,  1.995811575290863e-01, -3.860860060721641e-03,  5.220423120078666e-05, -5.727584001769083e-07,
  4.548478392054587e-09, -1.636641546671838e-11,  1.578362579428242e-13,  2.055924281641386e-14,  5.008764897650214e-18, -7.508042926567522e-18, -3.487439312584309e-19,
 -3.122828368698063e-21,  3.955621600094437e-01, -7.344503134334214e-03,  8.700333995197897e-05, -6.630276578355618e-07, -4.763895485065760e-10,  1.059015562785720e-10,
 -9.465580145076813e-13,  4.480581395029313e-14,  2.885248260138410e-16, -2.219335829860339e-17, -6.840621391252978e-19, -7.417527293408753e-21,  6.633379554747351e-01,
 -1.146806172478961e-02,  1.026478745560513e-04, -1.254369264465265e-08, -1.739042836612730e-08,  2.654636067645368e-10,  1.131590993638435e-12,  3.604094903348193e-15,
  1.562084674352595e-15, -3.955144029378139e-17, -1.683606894876918e-18, -8.959946232256166e-21,  1.006655629866127e+00, -1.523124084800656e-02,  5.590911200758728e-05,
  1.857813666917216e-06, -3.132475730490808e-08, -1.904208438178222e-10,  1.448440950505763e-11,  3.941095976228352e-14, -2.078916627943062e-15,  2.284947376442205e-18,
 -2.620104315320049e-18, -6.145872358695404e-20,  1.420346556598187e+00, -1.595775862443062e-02, -1.135843559858432e-04,  3.129723573221834e-06,  4.380587923566756e-08,
 -1.296297351604008e-09, -1.841025683724042e-11,  9.218352682378277e-13,  1.730739879682085e-14, -5.279598686770821e-16, -1.606726401102379e-17,  1.538039345008846e-19,
  1.841731068440167e+00, -7.824529016402099e-03, -2.389855719052144e-04, -4.532577317014913e-06, -1.333275634589482e-08,  2.593236664237571e-09,  9.880541761205789e-11,
  1.429276134271408e-12, -2.803599987207151e-14, -2.107238697568327e-15, -5.064079322021141e-17, -7.067184330103814e-20,  7.297805596208563e-03, -1.405170250035606e-04,
  2.008396190278211e-06, -2.597181270017893e-08,  3.090347155319426e-10, -2.854772714406106e-12,  6.568556905234466e-14, -7.511486377806637e-17, -1.245040953459711e-17,
 -8.591537883922823e-19, -8.702796169530078e-21,  3.385887086410865e-22,  6.597459440964891e-02, -1.260042694061435e-03,  1.757526165378559e-05, -2.169030315210629e-07,
  2.378304575523415e-09, -1.764767406755446e-11,  4.622675670045291e-13,  1.546356162632978e-15, -1.464392111976901e-16, -7.549074147049794e-18, -8.639555171186993e-20,
  3.193865161504600e-21,  1.849311720187651e-01, -3.469504009051096e-03,  4.575817580309219e-05, -5.022036842458497e-07,  4.304328052598838e-09, -6.002505062742580e-12,
  6.750305490918968e-13,  1.357619009039135e-14, -5.267730145207772e-16, -2.152707759970264e-17, -2.619015619209884e-19,  9.355838669387790e-21,  3.675258326283872e-01,
 -6.680276213997525e-03,  7.906835755155996e-05, -6.545060304760494e-07,  1.517623229418146e-09,  9.834471885591144e-11,  2.772645004456349e-13,  3.564314542043161e-14,
 -1.032544316193469e-15, -5.029034387477282e-17, -5.247741007766347e-19,  1.966332011288243e-20,  6.191009880027681e-01, -1.065179742031611e-02,  1.010081471773984e-04,
 -2.467263384016438e-07, -1.177951606429900e-08,  2.976919047322061e-10,  1.623879406235539e-12,  1.761819940192593e-14, -1.076762197487601e-15, -1.038987968238566e-16,
 -1.165698002525179e-18,  4.194263865313438e-20,  9.467541519661197e-01, -1.470347866509917e-02,  7.513188943022253e-05,  1.345270845631101e-06, -3.160903657056022e-08,
  1.621791640713430e-10,  1.450157669110943e-11, -4.974651411620047e-14, -4.286633986488635e-15, -1.277082711806444e-16, -2.956535292252716e-18,  6.528008175140652e-20,
  1.354950116108775e+00, -1.670637064853890e-02, -7.272951283320192e-05,  3.608839939210430e-06,  1.578639869751158e-08, -1.387360944678773e-09,  1.152455279972239e-11,
  1.067746139532783e-12, -1.059286155356921e-14, -9.238834813580703e-16, -1.396558570631038e-18,  4.728682235854015e-19,  1.806265908303955e+00, -9.952768399956090e-03,
 -2.924969959446822e-04, -4.191389691145975e-06,  6.461627657116258e-08,  5.259962616749493e-09,  1.122454754422915e-10, -1.035073955816170e-12, -1.341614328673837e-13,
 -3.379713390925465e-15,  1.367097863361222e-17,  3.545959531471161e-18,  6.766011617048166e-03, -1.256162359789728e-04,  1.724790340174332e-06, -2.140027416007552e-08,
  2.671738036536378e-10, -1.378583116077969e-12,  5.311285452850813e-14, -9.924332694355407e-16, -4.389913386478409e-17, -6.691078406144755e-19,  2.440467019630425e-20,
  1.162094635596458e-21,  6.120002605522424e-02, -1.129227932946102e-03,  1.519105759732228e-05, -1.810691753103541e-07,  2.135942086763047e-09, -6.829002302367793e-12,
  3.965722450385902e-13, -7.750647180308046e-15, -4.266215863399726e-16, -5.974379249889119e-18,  2.225472867758421e-19,  1.082176850074511e-20,  1.717487679299727e-01,
 -3.126376538206540e-03,  4.014408634318050e-05, -4.333292971297470e-07,  4.364014254243246e-09,  1.209356716375680e-11,  6.947840829653780e-13, -1.651267024953972e-14,
 -1.331961422118343e-15, -1.717656126140424e-17,  6.503750563681527e-19,  3.208114542064699e-20,  3.420208634828503e-01, -6.078579682407472e-03,  7.142677232337798e-05,
 -6.138776149270106e-07,  3.605156332330386e-09,  1.114808990501838e-10,  5.255190283288801e-13, -2.788633016798064e-14, -2.883210728619697e-15, -3.957122316153453e-17,
  1.436172556705919e-18,  6.962046545726484e-20,  5.780872685339324e-01, -9.858312499191174e-03,  9.712012186401349e-05, -3.853991982235713e-07, -5.431577556083659e-09,
  3.350315554721070e-10,  1.036988102681624e-12, -8.048167746543409e-14, -4.966195659890654e-15, -8.617967483718564e-17,  2.773284383045154e-18,  1.380463293586173e-19,
  8.892329255600253e-01, -1.404608253071958e-02,  8.840686759479690e-05,  8.835716354772312e-07, -2.509837264880498e-08,  4.731410072477990e-10,  1.038413861688636e-11,
 -2.741531420360362e-13, -9.777739508159086e-15, -1.281147977021423e-16,  4.497339399669843e-18,  2.740788080322208e-19,  1.287238694458649e+00, -1.711265337561719e-02,
 -2.874965326049815e-05,  3.663559417721839e-06, -7.099636192187362e-09, -8.203640873839541e-10,  3.185006932640111e-11,  2.296360971068196e-13, -3.937987925830010e-14,
 -5.139488825004746e-16,  2.296269993245272e-17,  6.182839615774277e-19,  1.761492781333705e+00, -1.246749842711395e-02, -3.326956800861319e-04, -2.189481633746373e-06,
  1.914651808237119e-07,  7.021372211483510e-09,  7.788664507973891e-12, -6.784374115355104e-12, -1.966583894394778e-13,  1.490729235165481e-15,  2.462677596806406e-16,
  5.430830044356241e-18,  6.289617224768320e-03, -1.127741598533442e-04,  1.492917079374009e-06, -1.728930965825534e-08,  2.492164548007578e-10, -6.089891310943964e-13,
  3.990122814414041e-15, -2.488790852288717e-15, -3.747956256690051e-17,  1.359053340886718e-18,  7.242655319173695e-20,  4.711882435904904e-22,  5.691322014796582e-02,
 -1.015817322173840e-03,  1.322017351608395e-05, -1.475729030962457e-07,  2.068446573154602e-09, -1.571200828885414e-12, -2.597161616915960e-14, -2.214341675196434e-14,
 -3.608925909645749e-16,  1.273771559229606e-17,  6.710232365263604e-19,  4.464913467494318e-21,  1.598543401717712e-01, -2.824813524255241e-03,  3.537334720733861e-05,
 -3.609129389583550e-07,  4.708752072035645e-09,  1.808393747477502e-11, -4.045640944430544e-13, -6.108897257495761e-14, -1.123477228659410e-15,  3.804949524302884e-17,
  1.989840488450910e-18,  1.368646947938331e-20,  3.188043292435510e-01, -5.535479246709147e-03,  6.448092962792740e-05, -5.381376695450404e-07,  5.840133155289535e-09,
  1.035348023633978e-10, -1.645299610150960e-12, -1.254909285619856e-13, -2.491176225848299e-15,  8.175389920725219e-17,  4.378669278863541e-18,  3.111365648036335e-20,
  5.401772405781810e-01, -9.100815255382817e-03,  9.219646955471076e-05, -4.184631665340018e-07,  1.234213317504902e-09,  3.131298304756218e-10, -3.682051292610454e-12,
 -2.549836321737361e-13, -4.515330392439847e-15,  1.520637449781431e-16,  8.669487056259391e-18,  6.541040783410489e-20,  8.345216589462352e-01, -1.330245143987149e-02,
  9.694767133340890e-05,  5.679576329461283e-07, -1.395942634226106e-08,  5.924919789689253e-10, -1.971875367733901e-12, -6.007096326312033e-13, -8.015750533195049e-15,
  3.095737747020780e-16,  1.657725547731505e-17,  1.458117947496658e-19,  1.218602486871648e+00, -1.716970806291524e-02,  1.412406271346630e-05,  3.459717440959899e-06,
 -1.612324155207627e-08, -1.306470049677712e-10,  1.942604433066679e-11, -1.096869529579060e-12, -3.499770599930357e-14,  9.103538952134685e-16,  4.500218300653284e-17,
  1.300265116637861e-19,  1.706220485099813e+00, -1.517171013605757e-02, -3.361261937560675e-04,  1.931533683717551e-06,  3.151876027215551e-07,  4.344126802190502e-09,
 -2.466807071145462e-10, -1.000829540884265e-11,  6.590775890833213e-14,  1.294054230725800e-14,  2.081071392255384e-16, -1.042032362450388e-17,  5.861187640218301e-03,
 -1.015939399793782e-04,  1.308916118939197e-06, -1.341943679453753e-08,  2.319141317582824e-10, -1.419845619264174e-12, -7.119820874063358e-14, -2.365628351591330e-15,
  5.916287759319755e-17,  3.589302693576031e-18,  7.489764796109198e-21, -3.701624310697415e-21,  5.305104759147306e-02, -9.165805416378434e-04,  1.164610588073353e-05,
 -1.149900445417010e-07,  1.976298585974905e-09, -1.033112223945172e-11, -7.022443294167802e-13, -2.134773047396581e-14,  5.405551974921989e-16,  3.345460441020124e-17,
  7.050952233168894e-20, -3.440881329549101e-20,  1.490954665415595e-01, -2.557848838096457e-03,  3.150294002313684e-05, -2.838400405992997e-07,  4.821171203599611e-09,
 -1.439916214956215e-11, -2.304033632892009e-12, -6.023807503303028e-14,  1.563976780978592e-15,  9.979930606926986e-17,  2.187996860500838e-19, -1.024217440423180e-19,
  2.976556333728155e-01, -5.043736899242505e-03,  5.864175940197539e-05, -4.315853768003272e-07,  7.200760524683330e-09,  1.680503055581054e-11, -5.593456470005860e-12,
 -1.252549580222268e-13,  3.364814660838702e-15,  2.187150097726920e-16,  5.275760628605087e-19, -2.255090315687877e-19,  5.052183662573075e-01, -8.382562208260608e-03,
  8.747735839350567e-05, -3.560490063437566e-07,  5.980699856872851e-09,  1.302234547952662e-10, -1.154585613119489e-11, -2.464629041317385e-13,  6.769209226542470e-15,
  4.265971330836368e-16,  1.176054979689789e-18, -4.477355763631951e-19,  7.829019501576598e-01, -1.250255109561993e-02,  1.027892727698630e-04,  4.307716221820938e-07,
 -4.034397871761328e-09,  3.292777380803679e-10, -1.979018727405419e-11, -5.525881141819991e-13,  1.436361354937055e-14,  8.409340441802845e-16,  2.111776020183863e-18,
 -8.960444488079508e-19,  1.150406260109278e+00, -1.689512802297801e-02,  5.405574641852521e-05,  3.193962681633100e-06, -1.704275779451666e-08, -1.171412554963392e-10,
 -1.965955842706476e-11, -1.367874462340553e-12,  2.618220681425991e-14,  2.204588454921403e-15,  1.108230674033610e-18, -2.325657604661035e-18,  1.640428994737846e+00,
 -1.767819718047398e-02, -2.811018965618346e-04,  7.262787369505657e-06,  3.233439268778516e-07, -4.241769389506164e-09, -4.228644360006426e-10, -8.597706650435397e-14,
  5.203659590227082e-13,  7.008625787697716e-15, -5.590953615309142e-16, -1.665587325881525e-17,  5.474819999167291e-03, -9.170651569754887e-05,  1.168859772814536e-06,
 -1.004602016709201e-08,  1.826559499535470e-10, -3.596894975466441e-12, -9.317805091082673e-14,  1.289314292542104e-15,  1.485612415909819e-16,  1.347997740983548e-19,
 -1.711992567124818e-19, -2.326773338502683e-21,  4.956305357255245e-02, -8.284161340398945e-04,  1.044572482228372e-05, -8.609223819803251e-08,  1.567352911268519e-09,
 -3.135309774218035e-11, -8.922753716676277e-13,  1.238072702379372e-14,  1.374811524524431e-15,  1.313670606947280e-18, -1.594624994440354e-18, -2.172755767299188e-20,
  1.393483414604732e-01, -2.318181977348412e-03,  2.853922466581560e-05, -2.124401589090109e-07,  3.886350435254614e-09, -8.114570464145350e-11, -2.795752891445435e-12,
  3.888663416393589e-14,  4.057858700648194e-15,  4.110742402312484e-18, -4.761341675768742e-18, -6.522728615561340e-20,  2.783888867230048e-01, -4.593386873801265e-03,
  5.413893951384120e-05, -3.218614291156951e-07,  6.002906989142112e-09, -1.404768377690989e-10, -6.508249834902623e-12,  9.016358914744310e-14,  8.840438197349333e-15,
  8.679643624208782e-18, -1.051115629329165e-17, -1.451508340037134e-19,  4.730631184202795e-01, -7.698116061965103e-03,  8.381113153919177e-05, -2.563073197848500e-07,
  5.439638112460895e-09, -1.917752000415942e-10, -1.329558155859225e-11,  1.804466109654816e-13,  1.742723777407488e-14,  1.168205370846711e-17, -2.091670863593099e-17,
 -2.902443202704285e-19,  7.345679863372403e-01, -1.166034549845953e-02,  1.076935965375742e-04,  3.891200997519246e-07, -3.069438086245035e-09, -2.530311185565136e-10,
 -2.467295362478245e-11,  3.181763234314260e-13,  3.499211838584362e-14, -4.839590548715841e-18, -4.231253876150593e-17, -5.675274991902272e-19,  1.083926325235547e+00,
 -1.631440666258224e-02,  9.055733196562696e-05,  2.866479983980779e-06, -2.642226725633636e-08, -8.857736163593504e-10, -3.553672356503714e-11,  5.224319036948344e-13,
  7.836166244456792e-14, -5.536125195240333e-17, -1.059527650775917e-16, -1.112293775512346e-18,  1.565881862962302e+00, -1.950034046678596e-02, -1.674108792592033e-04,
  1.124048098688914e-05,  1.468926706721344e-07, -1.248428233655682e-08, -1.905237163014964e-10,  1.543432671031565e-11,  2.855929114828733e-13, -1.936570944938236e-14,
 -4.452280198792635e-16,  2.400373815848369e-17,  5.125994252053296e-03, -8.279432184050857e-05,  1.063130921063616e-06, -7.799019131846370e-09,  9.389554550400956e-11,
 -4.907449558731622e-12,  4.413950970871118e-16,  4.766982406693403e-15,  3.135759041632746e-17, -5.884546265224183e-18, -5.833139374001576e-20,  6.913178232127507e-21,
  4.641050826506646e-02, -7.486107224104791e-04,  9.539151320180854e-06, -6.699125254234088e-08,  7.784321891959202e-10, -4.405083559652622e-11, -1.356840439068908e-14,
  4.451902490030684e-14,  2.851988840315153e-16, -5.473614806746192e-17, -5.406692779656747e-19,  6.455159227722548e-20,  1.305173990762812e-01, -2.099152372449732e-03,
  2.629929068323813e-05, -1.662650321678640e-07,  1.752076289030777e-09, -1.217359443964954e-10, -1.384616282607006e-13,  1.334426270700821e-13,  8.115430954150001e-16,
 -1.630911959673808e-16, -1.594436591234435e-18,  1.938373929688160e-19,  2.608590628215033e-01, -4.174354059130390e-03,  5.073635386559125e-05, -2.553704799597339e-07,
  1.991303411823302e-09, -2.371446583917293e-10, -5.760213442190949e-13,  2.949254000293751e-13,  1.665033117812833e-15, -3.594765075933258e-16, -3.424451144643905e-18,
  4.324018408016597e-19,  4.435937312231519e-01, -7.038841348427336e-03,  8.108223152285870e-05, -2.144970613318031e-07, -8.721273377470754e-10, -3.928399409327202e-10,
 -1.564824239432584e-12,  5.797058154836150e-13,  2.994805763719903e-15, -7.153584721727820e-16, -6.394248352489841e-18,  8.756051615427569e-19,  6.896773548754407e-01,
 -1.078152357332799e-02,  1.118106644093747e-04,  2.725350287543612e-07, -1.272080194924008e-08, -6.239890830596464e-10, -2.509782473794489e-12,  1.104010999333100e-12,
  5.164512120444105e-15, -1.439341088864449e-15, -1.088963905409690e-17,  1.814200322674253e-18,  1.020323221499436e+00, -1.546114685011347e-02,  1.217090563104076e-04,
  2.265415865995577e-06, -5.013310962663014e-08, -1.311113347082471e-09,  8.075123145932915e-12,  2.199781974702203e-12,  5.921983195829590e-15, -3.337651975945614e-15,
 -1.362245850986817e-17,  4.581232042783192e-18,  1.486086501525330e+00, -2.027994600497350e-02, -2.704118569520547e-05,  1.150134914342764e-05, -1.111714604350142e-07,
 -1.154713060007185e-08,  2.539771236313356e-10,  1.236637173319762e-11, -4.369430423395062e-13, -1.291942460173982e-14,  6.784784116382517e-16,  1.259614152334295e-17,
  4.811260834268748e-03, -7.464531865521314e-05,  9.754429610328273e-07, -7.036428616423752e-09,  6.410070056717258e-12, -3.378307111486684e-12,  1.164758554944339e-13,
  2.542460233687801e-15, -1.483719905939270e-16, -2.337336116972072e-18,  1.953967956141413e-19,  1.704554472912310e-21,  4.356381351563256e-02, -6.753663335337291e-04,
  8.782005907849105e-06, -6.118343942759915e-08, -7.351401148628889e-12, -3.021400626545678e-11,  1.068045110336817e-12,  2.365262723729084e-14, -1.383194196429299e-15,
 -2.152947450593631e-17,  1.822383642889885e-18,  1.562190170870646e-20,  1.225293771145035e-01, -1.896442139313736e-03,  2.439482332703093e-05, -1.566373463710967e-07,
 -4.213022683039961e-10, -8.272466968749091e-11,  3.090963150930408e-12,  7.027791047564877e-14, -4.136156264263469e-15, -6.274608822077226e-17,  5.458688820165682e-18,
  4.490964946890559e-20,  2.449543202548541e-01, -3.780530877102471e-03,  4.771171839366884e-05, -2.594427430737012e-07, -2.240937921999003e-09, -1.578032629094202e-10,
  6.516015800093221e-12,  1.527614627891689e-13, -9.141159483369464e-15, -1.327096985090724e-16,  1.212399728748969e-17,  9.187773091928478e-20,  4.167182740085142e-01,
 -6.401299827243645e-03,  7.817353555668030e-05, -2.879392042844902e-07, -7.834951575381315e-09, -2.484259915211001e-10,  1.223233312851249e-11,  2.906222223681892e-13,
 -1.813287904362474e-14, -2.443368244387151e-16,  2.435240202567624e-17,  1.550120680227529e-19,  6.483548445807642e-01, -9.878334951363241e-03,  1.134656415505532e-04,
 -2.387403442755878e-08, -2.340394352619181e-08, -3.415576545025827e-10,  2.324016538148517e-11,  5.118664007739700e-13, -3.579348750067836e-14, -4.153788028682687e-16,
  4.947027402549384e-17,  1.930429100822791e-19,  9.605764811718244e-01, -1.439419443087039e-02,  1.433051583746190e-04,  1.283982774696935e-06, -6.977146853455073e-08,
 -4.620230371757909e-10,  5.571165558246269e-11,  7.340821241963358e-13, -7.993578603331137e-14, -5.271004296976330e-16,  1.162089190526487e-16, -2.690662596349590e-19,
  1.405345601037179e+00, -1.998939344419169e-02,  9.399939566099887e-05,  8.291995778596864e-06, -2.623793309703953e-07, -3.107927079458884e-09,  3.740264023045152e-10,
 -3.574045066833481e-12, -4.053470597823162e-13,  1.199318509600728e-14,  3.103609025918866e-16, -2.099233673984941e-17,  4.527748910540337e-03, -6.718184910097815e-05,
  8.899252992079541e-07, -7.308422692456769e-09, -3.034102187192582e-11, -2.890255098694106e-13,  1.191714411940785e-13, -2.092451686667855e-15, -1.028130935671697e-16,
  3.928754739192091e-18,  6.303273869285685e-20, -5.535475430903375e-21,  4.099815926959433e-02, -6.080852318955373e-04,  8.032057743036110e-06, -6.461158588472070e-08,
 -3.287070594663910e-10, -1.849761752164768e-12,  1.093095909596280e-12, -1.942571649323264e-14, -9.516468988440941e-16,  3.666921587244081e-17,  5.778217226501586e-19,
 -5.163781018123854e-20,  1.153217294124284e-01, -1.709014112844670e-03,  2.243434010989863e-05, -1.721954273507879e-07, -1.255237071566871e-09, -4.733008604143614e-13,
  3.161607209275988e-12, -5.769990588719271e-14, -2.801376002093214e-15,  1.099668616194520e-16,  1.664744086777487e-18, -1.546870665264179e-19,  2.305747651898908e-01,
 -3.412079864550847e-03,  4.430913404534990e-05, -3.112134705552964e-07, -3.664120597495690e-09,  1.575064974573383e-11,  6.632002387005900e-12, -1.268908165952023e-13,
 -6.020272799799173e-15,  2.444359043844544e-16,  3.438795778327309e-18, -3.432331077835702e-19,  3.923386028226065e-01, -5.792128921797152e-03,  7.385844321277338e-05,
 -4.355471698096151e-07, -9.557761830506511e-09,  7.568884986683322e-11,  1.221896266258820e-11, -2.534993185913645e-13, -1.136326389818273e-14,  4.902898972531701e-16,
  6.018057665742609e-18, -6.863072141277176e-19,  6.106457350291825e-01, -8.978429397717371e-03,  1.108127011652116e-04, -4.201827867020185e-07, -2.417580311659938e-08,
  2.580708105347772e-10,  2.186090278868948e-11, -5.234279453523827e-13, -2.029899515918733e-14,  9.886832500157377e-16,  8.944123709803758e-18, -1.372569651676684e-18,
  9.053630624080790e-01, -1.320531640519906e-02,  1.519519685628378e-04,  1.682230661827370e-07, -6.543580837131877e-08,  8.444973980025759e-10,  4.330876601189334e-11,
 -1.362939925445972e-12, -3.392709845314663e-14,  2.289459200240349e-15,  4.111615623717392e-18, -3.044452212583833e-18,  1.327418908146135e+00, -1.891256160132069e-02,
  1.676993315656993e-04,  4.029600254289659e-06, -2.485865308562497e-07,  3.643961227409300e-09,  1.644803584318617e-10, -8.908331200683147e-12,  5.217819389458932e-14,
  9.234200152193313e-15, -3.067438143176817e-16, -3.155326256909831e-18,  4.272693774642609e-03, -6.042105342350301e-05,  7.995574098557710e-07, -7.709576956584316e-09,
 -1.360550902940254e-11,  1.633268654736621e-12,  3.670317076998217e-14, -3.062980194653509e-15,  3.317284711553640e-17,  2.567291192576493e-18, -9.342352693864969e-20,
 -7.188731687710781e-22,  3.868930116809662e-02, -5.470141981249349e-04,  7.227940565788796e-06, -6.897194980762448e-08, -1.597795256030472e-10,  1.569253499743287e-11,
  3.293474972604024e-13, -2.829822053726453e-14,  3.117453030097694e-16,  2.371165981010224e-17, -8.719399857361423e-19, -6.410630819283597e-21,  1.088310823237952e-01,
 -1.538123428811877e-03,  2.025870149576087e-05, -1.889148826440984e-07, -6.729375422861992e-10,  4.969829329666945e-11,  9.069541267129105e-13, -8.307403885368824e-14,
  9.495421404641613e-16,  6.948807011266164e-17, -2.614462147598948e-18, -1.728731879106154e-20,  2.176104262043324e-01, -3.073468765072659e-03,  4.025721798980481e-05,
 -3.601628356881521e-07, -2.121967454054060e-09,  1.189169098066296e-10,  1.738325588448757e-12, -1.783939575476831e-13,  2.172185699812130e-15,  1.482640789039467e-16,
 -5.808453769784883e-18, -3.101088762535883e-20,  3.703153152322821e-01, -5.224563023418269e-03,  6.780799414670532e-05, -5.633658137599095e-07, -5.827829236218952e-09,
  2.593117679863168e-10,  2.707883153032002e-12, -3.397471114956645e-13,  4.585056734671419e-15,  2.768622827646788e-16, -1.162996170483502e-17, -3.759282144847300e-20,
  5.764645189116591e-01, -8.118123531212378e-03,  1.036964311775701e-04, -7.430770556451385e-07, -1.519423101248303e-08,  5.662063585515686e-10,  3.356722310844825e-12,
 -6.341333635306586e-13,  1.014271707501183e-14,  4.865387721908839e-16, -2.330071867872058e-17,  1.024267456937306e-20,  8.549627550950791e-01, -1.199784402546174e-02,
  1.483904118362072e-04, -7.013962584255972e-07, -4.156756343429946e-08,  1.375114788070999e-09,  1.325312238134678e-12, -1.302289894040812e-12,  2.817841450993808e-14,
  7.895872461272132e-16, -5.236942083652599e-17,  4.228562236550667e-19,  1.254671217282007e+00, -1.743862555169842e-02,  1.950733359548950e-04,  7.714094723565652e-07,
 -1.544697163653953e-07,  5.008778337670261e-09, -2.848520499911466e-11, -4.249132157546260e-12,  1.753166012005218e-13, -1.235968396627160e-15, -1.498182395050276e-16,
  6.191770710513026e-18,  4.043214829360639e-03, -5.439569400478432e-05,  7.068967422703900e-07, -7.644243524212217e-09,  2.180994378167090e-11,  1.664602287013850e-12,
 -2.539122412961646e-14, -1.223959639337815e-15,  6.262402522177593e-17, -5.843684103179899e-19, -4.556603743850546e-20,  1.855178973940264e-21,  3.661162166358901e-02,
 -4.925193716383765e-04,  6.396016550845704e-06, -6.882953559581627e-08,  1.772300774701531e-10,  1.576506684103625e-11, -2.423632155415387e-13, -1.118905141879672e-14,
  5.799892777241429e-16, -5.534200729919711e-18, -4.194348676638740e-19,  1.727489763605041e-20,  1.029882167739300e-01, -1.385225139528982e-03,  1.796179081839713e-05,
 -1.912540586254255e-07,  3.752208053008971e-10,  4.858234019963328e-11, -7.588298400507312e-13, -3.209483578459629e-14,  1.711047430485595e-15, -1.711344240173103e-17,
 -1.220118854569360e-18,  5.153422310998654e-20,  2.059327268850651e-01, -2.769088217869174e-03,  3.581318897592522e-05, -3.743302907615817e-07,  3.247206266903589e-10,
  1.119078181142797e-10, -1.791756657299390e-12, -6.615035986493815e-14,  3.701389839632964e-15, -4.000360298975687e-17, -2.569359098509489e-18,  1.134455956837836e-19,
  3.504574681473343e-01, -4.710323235486978e-03,  6.066279201851292e-05, -6.144392000401946e-07, -6.488959840650942e-10,  2.328255756665551e-10, -3.864426285656198e-12,
 -1.173299924502955e-13,  7.115300297984834e-15, -8.662431301964063e-17, -4.688489122696096e-18,  2.234774866426140e-19,  5.455899970151713e-01, -7.327490298269368e-03,
  9.369415802645991e-05, -8.964451034897018e-07, -4.266847736026567e-09,  4.804813542128405e-10, -8.413356280577071e-12, -1.915001234131219e-13,  1.340242462668945e-14,
 -1.959780385651290e-16, -7.873699842540134e-18,  4.338537150618510e-19,  8.092790621046951e-01, -1.085364606806747e-02,  1.368673508827297e-04, -1.155089679243196e-06,
 -1.611072552896184e-08,  1.084542029683876e-09, -2.076323362824171e-11, -2.847275349605489e-13,  2.744408484817143e-14, -5.426361477863957e-16, -1.122354597688978e-17,
  9.033106014375976e-19,  1.188046739784438e+00, -1.587581226621320e-02,  1.926017746368311e-04, -9.657269509678517e-07, -6.777677877323105e-08,  3.461073153878879e-09,
 -8.105073250486420e-11, -3.479223441787486e-14,  7.894680019037616e-14, -2.914235621614427e-15,  3.088235473968838e-17,  1.673893716749236e-18,  3.836372826417599e-03,
 -4.909923883366299e-05,  6.182281934407200e-07, -7.069978883083734e-09,  4.728621916179948e-11,  8.421000936409088e-13, -3.642180350669966e-14,  2.363223079203904e-16,
  2.599982965814148e-17, -1.069192828651398e-18,  1.143933128446760e-20,  5.807833309260040e-22,  3.473874598501667e-02, -4.445853272614099e-04,  5.596250281331099e-06,
 -6.385949067993752e-08,  4.187353772553602e-10,  8.020633186041404e-12, -3.409126503599997e-13,  2.288445498236583e-15,  2.385969069750206e-16, -9.906263591707502e-18,
  1.081367177070973e-19,  5.315777234245645e-21,  9.772040155572162e-02, -1.250542629407906e-03,  1.573103445254649e-05, -1.786708684931738e-07,  1.120623637503433e-09,
  2.496990621613316e-11, -1.027125184287511e-12,  7.366849463143917e-15,  6.899428183773827e-16, -2.924420324139379e-17,  3.329530650518250e-19,  1.526918501140987e-20,
  1.954012630329529e-01, -2.500309539999459e-03,  3.141750058786944e-05, -3.539771196065444e-07,  2.044494978553914e-09,  5.824682322402812e-11, -2.292191589358778e-12,
  1.810106758313792e-14,  1.441039631703547e-15, -6.329506956729769e-17,  7.718252954293666e-19,  3.142414643869173e-20,  3.325402539556350e-01, -4.254373148103636e-03,
  5.336253196428222e-05, -5.933088458246034e-07,  2.931493732892424e-09,  1.226441858722105e-10, -4.588927085587078e-12,  4.109496657827733e-14,  2.609271980144273e-15,
 -1.215938542547636e-16,  1.645395771673769e-18,  5.498578908253746e-20,  5.177102399351828e-01, -6.621473774696544e-03,  8.280568415775000e-05, -8.998579851923692e-07,
  3.106829356850540e-09,  2.548124291553599e-10, -9.075812050011293e-12,  9.544283052022903e-14,  4.404831628733551e-15, -2.279093047765481e-16,  3.611644440368207e-18,
  8.447457333371376e-20,  7.679623251660816e-01, -9.817068150430772e-03,  1.220840901852597e-04, -1.267583231180966e-06,  3.815462809067611e-10,  5.702852033322691e-10,
 -1.962113178007056e-11,  2.564502831075379e-13,  7.032735082209229e-15, -4.569221856100834e-16,  9.362914754788120e-18,  8.676720535741234e-20,  1.127531786736810e+00,
 -1.439519886272337e-02,  1.764573873643456e-04, -1.598406837699600e-06, -1.698343743743908e-08,  1.703578810774674e-09, -6.021090726287513e-11,  1.132595160952935e-12,
  4.823139392281356e-15, -1.156669214878255e-15,  4.078799254443042e-17, -5.875414470390380e-19,  3.649349680643084e-03, -4.447892242256040e-05,  5.383391655274188e-07,
 -6.222633500206068e-09,  5.627225237958934e-11,  1.098307948995721e-13, -2.312781310276819e-14,  5.701254490355551e-16, -1.134573604686094e-18, -4.171964040157063e-19,
  1.547357036528487e-20, -2.048243886076441e-22,  3.304526477970442e-02, -4.027572237688086e-04,  4.874076992360956e-06, -5.628752726601879e-08,  5.057141971298974e-10,
  1.178408698866897e-12, -2.159149293887645e-13,  5.318915139094314e-15, -1.190907888267267e-17, -3.830648636427978e-18,  1.432569050307717e-19, -1.925173033936896e-21,
  9.295681859568854e-02, -1.132936002909252e-03,  1.370698012742324e-05, -1.579814300327428e-07,  1.399393174823982e-09,  4.429878442619166e-12, -6.469159798049002e-13,
  1.592292100383863e-14, -4.386728851578400e-17, -1.108867152319897e-17,  4.221699787773437e-19, -5.856539637941171e-21,  1.858766813670555e-01, -2.265334068622015e-03,
  2.739544997662504e-05, -3.146931542662757e-07,  2.719277564846965e-09,  1.267832403325257e-11, -1.430262171755088e-12,  3.521104519491331e-14, -1.261311440308244e-16,
 -2.319412948051177e-17,  9.106913429474280e-19, -1.330887905582682e-20,  3.163327958980103e-01, -3.855004341719179e-03,  4.658718551395934e-05, -5.322515747730091e-07,
  4.409738268858549e-09,  3.223553716849670e-11, -2.820934648864884e-12,  6.970093255625770e-14, -3.355604796224328e-16, -4.206517133028694e-17,  1.738511279261066e-18,
 -2.751278267800519e-20,  4.924824599140287e-01, -6.001060632506887e-03,  7.243846600038352e-05, -8.201048289174665e-07,  6.295468278380597e-09,  7.850528795161238e-11,
 -5.443487054407172e-12,  1.361406636479276e-13, -9.068898480516507e-16, -7.109127091137331e-17,  3.216995590259623e-18, -5.753731267520833e-20,  7.305521579415158e-01,
 -8.900421658220897e-03,  1.072106279961827e-04, -1.193088679402164e-06,  7.736320141063269e-09,  1.984021427088651e-10, -1.124146610972010e-11,  2.907213399811630e-13,
 -2.815691194773507e-15, -1.134112724421229e-16,  6.250327963896032e-18, -1.370152517810770e-19,  1.072649145468203e+00, -1.306275005140266e-02,  1.565454704850293e-04,
 -1.665381014655711e-06,  5.169777870124107e-09,  6.279425823799835e-10, -3.066913358507167e-11,  8.807147304463149e-13, -1.421655749503825e-14, -8.289057628191414e-17,
  1.393289688283749e-17, -4.815587166902292e-19,  3.479596111194577e-03, -4.045559230261150e-05,  4.690588381940328e-07, -5.329649016699669e-09,  5.414514689613961e-11,
 -2.678684330006009e-13, -9.192891254812113e-15,  3.931144632255014e-16, -7.478218493028439e-18, -3.598918343931140e-21,  5.398598456185405e-21, -1.907957877875477e-22,
  3.150813781338559e-02, -3.663286492591257e-04,  4.247174598645665e-06, -4.824052571637190e-08,  4.888922884961994e-10, -2.351872103567516e-12, -8.623409907901904e-14,
  3.651771044668112e-15, -6.968641982388586e-17, -1.494534121944641e-20,  4.953682642619306e-20, -1.763980493223668e-21,  8.863291990632685e-02, -1.030480655058171e-03,
  1.194613497246324e-05, -1.355808918547533e-07,  1.366839645696145e-09, -6.170612122381693e-12, -2.607133539786962e-13,  1.083359002067803e-14, -2.081500793993430e-16,
  7.101874601004490e-20,  1.431826952139791e-19, -5.182598984441259e-21,  1.772308119160136e-01, -2.060527339389619e-03,  2.388338815683490e-05, -2.707018931989645e-07,
  2.704625996729669e-09, -1.082386260313599e-11, -5.834337974820076e-13,  2.360272289517919e-14, -4.588439715649753e-16,  5.682473842156757e-19,  2.986703457641018e-19,
 -1.111988676292804e-20,  3.016194540677956e-01, -3.506627228820665e-03,  4.063459130401575e-05, -4.595885488305257e-07,  4.524846811858049e-09, -1.424187518077983e-11,
 -1.166060252366296e-12,  4.565871003574781e-14, -9.048531750267764e-16,  2.339048522629912e-18,  5.389535911558718e-19, -2.103323447059785e-20,  4.695774290297210e-01,
 -5.459126244424071e-03,  6.323374209887336e-05, -7.127002942814069e-07,  6.843752757439157e-09, -1.127603461805300e-11, -2.274627253268740e-12,  8.600412729371962e-14,
 -1.760199733622258e-15,  8.116253287675850e-18,  9.019248870992560e-19, -3.827455549633923e-20,  6.965784307179932e-01, -8.097681403753422e-03,  9.372675779048926e-05,
 -1.049671225743448e-06,  9.602508738220940e-09,  1.377851512024161e-11, -4.697881147530532e-12,  1.723940749220510e-13, -3.742992075797546e-15,  2.955366682958967e-17,
  1.405893515577435e-18, -7.175560924018092e-20,  1.022779266375301e+00, -1.188818591027568e-02,  1.373627606814088e-04, -1.514731598977506e-06,  1.209919614136560e-08,
  1.365880124249843e-10, -1.226559225205079e-11,  4.511007979813898e-13, -1.122932832724373e-14,  1.635587717917218e-16,  8.949764599773064e-19, -1.416810185956988e-19,
  3.324893807231150e-03, -3.694468567641336e-05,  4.100944353519752e-07, -4.514907006395387e-09,  4.733706354242894e-11, -3.824408790317142e-13, -1.340618324914255e-15,
  1.795845475233159e-16, -5.351895242590190e-18,  8.707731221870495e-20,  1.166371219817312e-22, -5.826078797258165e-23,  3.010729402006935e-02, -3.345379699234535e-04,
  3.713389743691503e-06, -4.087666550970127e-08,  4.281754571893821e-10, -3.436617980808837e-12, -1.331882601398425e-14,  1.667932316654388e-15, -4.961177068728088e-17,
  8.109920198754291e-19,  8.651464610344611e-22, -5.339337833293200e-22,  8.469234157618095e-02, -9.410588076813394e-04,  1.044545692369849e-05, -1.149487916876923e-07,
  1.201659141197804e-09, -9.508142317101458e-12, -4.458708485963005e-14,  4.945078336715688e-15, -1.465640730560890e-16,  2.419798986474916e-18,  1.204663787321485e-21,
 -1.539117190121757e-21,  1.693512753032725e-01, -1.881738664683437e-03,  2.088554529731584e-05, -2.297247622810070e-07,  2.393393440779447e-09, -1.847434442705356e-11,
 -1.133644060934836e-13,  1.075457817537413e-14, -3.172798547639119e-16,  5.325916761568379e-18, -2.251859978701202e-21, -3.195110356106656e-21,  2.882098687948811e-01,
 -3.202409590922892e-03,  3.554063942261228e-05, -3.906122969678736e-07,  4.047543499514860e-09, -2.997035897882256e-11, -2.596022835883452e-13,  2.071466838943486e-14,
 -6.084279018324845e-16,  1.048194170268876e-17, -1.892968031658436e-20, -5.717970886005005e-21,  4.487010842560351e-01, -4.985637213490276e-03,  5.532326149366956e-05,
 -6.072609502897298e-07,  6.236307195199774e-09, -4.288580115663889e-11, -5.775682664701902e-13,  3.863160285666848e-14, -1.132937386093831e-15,  2.033846497578512e-17,
 -7.892405324750214e-20, -9.423085028832920e-21,  6.656112318734049e-01, -7.395651323442224e-03,  8.204572518657930e-05, -8.985395221979990e-07,  9.076791739022092e-09,
 -5.333839166959709e-11, -1.339742307366244e-12,  7.560629492509749e-14, -2.235723990209715e-15,  4.307011048277664e-17, -3.100189318507575e-19, -1.418092431354069e-20,
  9.773140189697568e-01, -1.085857766265466e-02,  1.203959712090296e-04, -1.311650613131535e-06,  1.272366500637404e-08, -4.137013448752730e-11, -3.784466834706063e-12,
  1.841158590531037e-13, -5.694492887811141e-15,  1.273463501421348e-16, -1.737936548594835e-18, -6.634522527471688e-21,  3.183350848088128e-03, -3.386835551504223e-05,
  3.602057488942585e-07, -3.819054611087087e-09,  3.968586901818794e-11, -3.707956091343572e-13,  1.745973013053407e-15,  5.580742987301073e-17, -2.538516870667452e-18,
  6.268301362837952e-20, -9.236971973212550e-22, -8.418013786364556e-25,  2.882560722186021e-02, -3.066817377785498e-04,  3.261686536273915e-06, -3.458009311863515e-08,
  3.592147340245323e-10, -3.348908599008958e-12,  1.539444877612698e-14,  5.214963344438305e-16, -2.349697969697125e-17,  5.804051276704943e-19, -8.598427959245122e-21,
 -5.588102574104051e-24,  8.108693969805242e-02, -8.627004745923834e-04,  9.175074885629781e-06, -9.726313435209640e-08,  1.009606243709297e-09, -9.368373902293533e-12,
  4.080425826581331e-14,  1.564459862383833e-15, -6.918900619071295e-17,  1.710662676205927e-18, -2.562878639730290e-20, -2.668030373579345e-24,  1.621419116470990e-01,
 -1.725058697089131e-03,  1.834617691752314e-05, -1.944502274310018e-07,  2.015893387981709e-09, -1.855752590751458e-11,  7.314350521850664e-14,  3.459351059339727e-15,
 -1.489204089952831e-16,  3.689869469273525e-18, -5.631571349301826e-20,  4.389876334016604e-23,  2.759406865731738e-01, -2.935779854818283e-03,  3.122143207790277e-05,
 -3.308234206777499e-07,  3.422872304626419e-09, -3.110655922378416e-11,  1.014389374757000e-13,  6.797473860944405e-15, -2.828148612126809e-16,  7.039685547951861e-18,
 -1.105670384740275e-19,  2.328689295842148e-22,  4.295998602928597e-01, -4.570571895532538e-03,  4.860491700148087e-05, -5.147925174157281e-07,  5.309161143400405e-09,
 -4.722404311316390e-11,  9.895351525006269e-14,  1.294282755713729e-14, -5.177829918017751e-16,  1.301485111271323e-17, -2.137368989333906e-19,  8.738696461518474e-22,
  6.372764372041966e-01, -6.780035912900914e-03,  7.209541506266297e-05, -7.630003652764733e-07,  7.823877505939304e-09, -6.684673528609007e-11, -1.299418329039134e-14,
  2.573566887992144e-14, -9.888904545114353e-16,  2.540782810820051e-17, -4.494635510743505e-19,  3.246627265825378e-21,  9.357111300291582e-01, -9.954995858651687e-03,
  1.058383521007711e-04, -1.118194284573264e-06,  1.131537484884224e-08, -8.716819742913492e-11, -5.861583020450949e-13,  6.203287087192671e-14, -2.319664547188453e-15,
  6.329908745187996e-17, -1.301087606753699e-18,  1.708655470473072e-20,  3.053364987309783e-03, -3.115977635414050e-05,  3.179506942652260e-07, -3.240740883748977e-09,
  3.277605509323652e-11, -3.174853271908649e-13,  2.461007744556480e-15,  3.810344433841946e-18, -9.079351933971444e-19,  2.982324840964814e-20, -6.515090885312160e-22,
  9.028238833187142e-24,  2.764857058337187e-02, -2.821553242415156e-04,  2.879075158286186e-06, -2.934474809388620e-08,  2.967482960316622e-10, -2.872202727036376e-12,
  2.215034949563626e-14,  4.008972947310896e-17, -8.414635446514880e-18,  2.755891633865291e-19, -6.027897082589936e-21,  8.398408525008338e-23,  7.777591642080221e-02,
 -7.937077293087746e-04,  8.098860014681761e-06, -8.254411260071418e-08,  8.345031779069033e-10, -8.063605003785451e-12,  6.150308184352519e-14,  1.463719943066526e-16,
 -2.483555162924085e-17,  8.087478719047382e-19, -1.773802987501883e-20,  2.499701352661535e-22,  1.555211753248925e-01, -1.587102028274071e-03,  1.619443073544790e-05,
 -1.650450909453102e-07,  1.667825679452780e-09, -1.607059461251206e-11,  1.202718610988306e-13,  4.060839691484201e-16, -5.361318595786625e-17,  1.731603142580342e-18,
 -3.816349123514477e-20,  5.480009923599502e-22,  2.646732209291034e-01, -2.701003067625383e-03,  2.756018340006195e-05, -2.808532163008948e-07,  2.836103872124072e-09,
 -2.720596982399927e-11,  1.973554520596252e-13,  9.997609848264444e-16, -1.020855950249065e-16,  3.264265692842119e-18, -7.253754928560715e-20,  1.072075788809616e-21,
  4.120580728919692e-01, -4.205068958267208e-03,  4.290660292444346e-05, -4.371782332063140e-07,  4.409738297811913e-09, -4.199590594616032e-11,  2.887440903340475e-13,
  2.344127657183914e-15, -1.869590664081533e-16,  5.915983693420189e-18, -1.333628992807401e-19,  2.060678176164098e-21,  6.112547036472994e-01, -6.237869243236733e-03,
  6.364686503922593e-05, -6.483404072361754e-07,  6.526873173406246e-09, -6.135790572336299e-11,  3.793020074156750e-13,  5.599615954518956e-15, -3.544790093488880e-16,
  1.113608541159250e-17, -2.579927619195657e-19,  4.288640672498072e-21,  8.975037445693946e-01, -9.159019644432758e-03,  9.344759232588252e-05, -9.513961780791748e-07,
  9.536417001618537e-09, -8.699839663577852e-11,  3.909014386186550e-13,  1.565806504734372e-14, -8.024591249014030e-16,  2.546663490571689e-17, -6.296450696906546e-19,
  1.208453402228204e-20,  2.933578772702679e-03, -2.876327302414421e-05,  2.820091413026465e-07, -2.763924203495119e-09,  2.701228042924589e-11, -2.595929243991335e-13,
  2.290865921582024e-15, -1.234504797446030e-17, -2.122455343270716e-19,  1.112824855545361e-20, -3.057292381397283e-22,  6.110232007375122e-24,  2.656389272001125e-02,
 -2.604547334043635e-04,  2.553623877760707e-06, -2.502750704668189e-08,  2.445874030458143e-10, -2.349873266594982e-12,  2.070349294006270e-14, -1.100099787141306e-16,
 -1.987432753724229e-18,  1.028151746153087e-19, -2.822323661758756e-21,  5.649771768557952e-23,  7.472469885923000e-02, -7.326637159398655e-04,  7.183381358979047e-06,
 -7.040196018036097e-08,  6.879576691338179e-10, -6.605630277190948e-12,  5.799649259114349e-14, -2.988100420732349e-16, -5.984512245261484e-18,  3.015613089608266e-19,
 -8.265315458508078e-21,  1.660358353057638e-22,  1.494199442089860e-01, -1.465038499232842e-03,  1.436390593032056e-05, -1.407733193669062e-07,  1.375407835017212e-09,
 -1.319329236742751e-11,  1.151576213584499e-13, -5.617432062407010e-16, -1.329430093905803e-17,  6.448100861102162e-19, -1.763919002108206e-20,  3.564676389551632e-22,
  2.542898634283901e-01, -2.493270791074924e-03,  2.444510115529010e-05, -2.395670699890710e-07,  2.340104439987249e-09, -2.241190003010230e-11,  1.937990589185834e-13,
 -8.594708850017529e-16, -2.623170667442018e-17,  1.211844566100267e-18, -3.309527846029375e-20,  6.753493002646749e-22,  3.958926895065243e-01, -3.881662559648632e-03,
  3.805733789007031e-05, -3.729528975393453e-07,  3.641655920822411e-09, -3.479030191916017e-11,  2.962696041340890e-13, -1.094988829849825e-15, -5.001340364796282e-17,
  2.181485790374146e-18, -5.957604421609387e-20,  1.235447852279459e-21,  5.872746902782515e-01, -5.758129218005000e-03,  5.645456514653100e-05, -5.531987307116526e-07,
  5.398163327691911e-09, -5.134719869161310e-11,  4.253359533011723e-13, -9.838106740789232e-16, -9.877024809519731e-17,  4.042315179721183e-18, -1.109918726251639e-19,
  2.369456017903072e-21,  8.622940138590524e-01, -8.454640381765915e-03,  8.289086866392143e-05, -8.121173232068365e-07,  7.913819439695265e-09, -7.456062847178665e-11,
  5.783902836464847e-13,  7.000906575592196e-16, -2.300479377096492e-16,  8.839082164062278e-18, -2.487782629162728e-19,  5.667179669278384e-21,  2.822837644805532e-03,
 -2.663289671360073e-05,  2.512732295651955e-07, -2.370402620975801e-09,  2.233956658387909e-11, -2.092299882406802e-13,  1.896235185533383e-15, -1.462769071694487e-17,
  2.305372501864714e-20,  3.197427492751132e-21, -1.150512172768163e-22,  2.800393446031268e-24,  2.556111910445590e-02, -2.411639369476951e-04,  2.275307628084748e-06,
 -2.146423052648464e-08,  2.022841625457314e-10, -1.894389374970161e-12,  1.715905731151659e-14, -1.319275333670335e-16,  1.882828422390762e-19,  2.963390349265876e-20,
 -1.061268116982639e-21,  2.583335184581468e-23,  7.190387908659010e-02, -6.783983992016812e-04,  6.400478564443990e-06, -6.037903624791502e-08,  5.690099813950052e-10,
 -5.327685002571402e-12,  4.819962151646473e-14, -3.679563837825199e-16,  4.069499104750438e-19,  8.745000293130349e-20, -3.102597339403945e-21,  7.554303609426689e-23,
  1.437794168452927e-01, -1.356529367617255e-03,  1.279842792237270e-05, -1.207335355014470e-07,  1.137732857882930e-09, -1.064906143815022e-11,  9.614987602898862e-14,
 -7.252105984147986e-16,  4.022415752648161e-19,  1.886341335260977e-19, -6.600585538463645e-21,  1.608383687567614e-22,  2.446905504841719e-01, -2.308605163011694e-03,
  2.178094759574110e-05, -2.054680406639994e-07,  1.936080724257198e-09, -1.811188673608213e-11,  1.630176759598895e-13, -1.205900102556763e-15, -4.242162705480936e-19,
  3.583569613275008e-19, -1.231678623634071e-20,  3.007158340728766e-22,  3.809479440162922e-01, -3.594165498642943e-03,  3.390975735474134e-05, -3.198794065933596e-07,
  3.013792234387649e-09, -2.817011319683756e-11,  2.522751313253246e-13, -1.806947362093017e-15, -3.444199442432997e-18,  6.525522710431746e-19, -2.195581050812278e-20,
  5.385186395608676e-22,  5.651053777974542e-01, -5.331652447210333e-03,  5.030227368656116e-05, -4.745033650597194e-07,  4.469696567828599e-09, -4.171852062282801e-11,
  3.703441729623239e-13, -2.498224903233363e-15, -1.240598524388952e-17,  1.220094939043602e-18, -4.012305623578469e-20,  9.948977616057390e-22,  8.297428809549904e-01,
 -7.828450953550318e-03,  7.385840976148362e-05, -6.966768157518134e-07,  6.559741442901420e-09, -6.103991165097509e-11,  5.315153243864276e-13, -3.080235711838159e-15,
 -4.237458275101396e-17,  2.652422438314346e-18, -8.571624024833202e-20,  2.191461612374045e-21,  2.720154457527115e-03, -2.473071648682898e-05,  2.248425399496312e-07,
 -2.044110326263170e-09,  1.857767122441193e-11, -1.684720557071160e-13,  1.509160444587776e-15, -1.273462042182171e-17,  7.918688346753271e-20,  4.404818033131789e-22,
 -3.548718906061678e-23,  1.046531688904435e-24,  2.463131105357681e-02, -2.239394779459247e-04,  2.035974944519204e-06, -1.850964437782496e-08,  1.682221292465022e-10,
 -1.525477799006842e-12,  1.366247537745822e-14, -1.151649683254167e-16,  7.110546565858669e-19,  4.197637058056233e-21, -3.276834944876711e-22,  9.643968178103513e-24,
  6.928831265664656e-02, -6.299457006217973e-04,  5.727232969739126e-06, -5.206790032299829e-08,  4.732069555146082e-10, -4.290862424110219e-12,  3.841403012082280e-14,
 -3.230746774669900e-16,  1.964385045903959e-18,  1.306000272859346e-20, -9.598510412123871e-22,  2.813663265365846e-23,  1.385493150062979e-01, -1.259643096535518e-03,
  1.145220694995226e-05, -1.041150931051263e-07,  9.462113087309981e-10, -8.578928024792829e-12,  7.675062006170532e-14, -6.430702380000208e-16,  3.808368171794394e-18,
  3.030898104299929e-20, -2.047347750564317e-21,  5.966748770622393e-23,  2.357897182519573e-01, -2.143719639889640e-03,  1.948989843884803e-05, -1.771874598542390e-07,
  1.610264352538790e-09, -1.459709830784685e-11,  1.304524862642776e-13, -1.086543710827513e-15,  6.161168261024340e-18,  6.286093140556873e-20, -3.830664122445932e-21,
  1.108269307522802e-22,  3.670906307358168e-01, -3.337462666638228e-03,  3.034295482590198e-05, -2.758541817929006e-07,  2.506846787075463e-09, -2.271845159119370e-11,
  2.026904808186733e-13, -1.672199192632986e-15,  8.797191079407972e-18,  1.260989677787891e-19, -6.839030307342695e-21,  1.962666403299917e-22,  5.445491786976379e-01,
 -4.950855056209251e-03,  4.501128830315780e-05, -4.092044186951316e-07,  3.718448845124921e-09, -3.368317117185288e-11,  2.996535188371564e-13, -2.431213383925383e-15,
  1.100408480858886e-17,  2.606756578735508e-19, -1.246276045877421e-20,  3.551658123843797e-22,  7.995602663610780e-01, -7.269328344084783e-03,  6.608989723015044e-05,
 -6.008253927926240e-07,  5.459030411219033e-09, -4.940313217561865e-11,  4.368450281133192e-13, -3.415389697946057e-15,  9.622164890279940e-18,  6.238118785414959e-19,
 -2.611554895665159e-20,  7.453517894318461e-22,  2.624680531439202e-03, -2.302528420880244e-05,  2.019915370023181e-07, -1.771971145381624e-09,  1.554305908825401e-11,
 -1.362379311584415e-13,  1.188934794589556e-15, -1.014766107407006e-17,  7.809666457505091e-20, -3.207545060076249e-22, -7.717346887011931e-24,  3.311436216492798e-25,
  2.376678368757015e-02, -2.084965931299038e-04,  1.829056549410147e-06, -1.604539995882848e-08,  1.407439820414910e-10, -1.233635866667234e-12,  1.076512046772754e-14,
 -9.184837837325069e-17,  7.055123198373076e-19, -2.844229877533572e-21, -7.179507764956578e-23,  3.052021347881471e-24,  6.685638192580191e-02, -5.865045951929514e-04,
  5.145168236762867e-06, -4.513597962383747e-08,  3.959140977419983e-10, -3.470154755850543e-12,  3.027758974734250e-14, -2.581336123287679e-16,  1.974702634101915e-18,
 -7.640913838380074e-21, -2.134152946429405e-22,  8.906147504823132e-24,  1.336864121205065e-01, -1.172778015025799e-03,  1.028830810799572e-05, -9.025412386478372e-08,
  7.916681605274729e-10, -6.938661766487321e-12,  6.052707136758416e-14, -5.153772997155837e-16,  3.915639926921084e-18, -1.407812588639732e-20, -4.650739148872004e-22,
  1.888600120667955e-23,  2.275138022409855e-01, -1.995888590604594e-03,  1.750912398719306e-05, -1.535985809365850e-07,  1.347287524873147e-09, -1.180780282329107e-11,
  1.029650988683279e-13, -8.750049459584301e-16,  6.576087633873475e-18, -2.075173001322881e-20, -8.943660404154946e-22,  3.504952149122232e-23,  3.542062215997259e-01,
 -3.107311057856083e-03,  2.725918188831989e-05, -2.391305860039172e-07,  2.097507418428980e-09, -1.838126397356809e-11,  1.601979360994965e-13, -1.357149895048371e-15,
  1.002221538219031e-17, -2.436582892163374e-20, -1.649127889080517e-21,  6.189081019114443e-23,  5.254362029947159e-01, -4.609443915255361e-03,  4.043677987823854e-05,
 -3.547301431185165e-07,  3.111420298295104e-09, -2.726270666388861e-11,  2.373820540498698e-13, -2.000403035551497e-15,  1.432027242309447e-17, -1.580138599488166e-20,
 -3.112257281645777e-21,  1.110890059983837e-22,  7.714967303434465e-01, -6.768035478780994e-03,  5.937321172611891e-05, -5.208474440298798e-07,  4.568310505779495e-09,
 -4.001673732647834e-11,  3.477722537948360e-13, -2.898148713417048e-15,  1.933115982714335e-17,  4.115609820595099e-20, -6.726725865239643e-21,  2.273324775632910e-22,
  2.535682297030317e-03, -2.149037628419963e-05,  1.821348698945830e-07, -1.543621575805929e-09,  1.308203828893865e-11, -1.108429226382908e-13,  9.377615480171255e-16,
 -7.870461499599606e-18,  6.361041459058359e-20, -4.316819355604793e-22,  3.982093893088005e-25,  8.331691911622012e-26,  2.296089445273571e-02, -1.945978256533403e-04,
  1.649252162753529e-06, -1.397767012837045e-08,  1.184593102724539e-10, -1.003691888848913e-12,  8.491332043605039e-15, -7.125765563929205e-17,  5.755590921417951e-19,
 -3.892450559192665e-21,  3.062760735736351e-24,  7.702987205387910e-25,  6.458940128804297e-02, -5.474071175010837e-04,  4.639375411718882e-06, -3.931942951359124e-08,
  3.332278392723216e-10, -2.823382175088351e-12,  2.388503991080744e-14, -2.003879090525915e-16,  1.616434422157763e-18, -1.085126602983832e-20,  5.372459380569065e-24,
  2.261702985975211e-24,  1.291533443896608e-01, -1.094598471696345e-03,  9.276922106730421e-06, -7.862335051705816e-08,  6.663233776692293e-10, -5.645582866272202e-12,
  4.775661359468250e-14, -4.004945681769739e-16,  3.223533569705415e-18, -2.137169051924963e-20, -6.341298987606122e-26,  4.839474254630664e-24,  2.197992151162270e-01,
 -1.862838983580621e-03,  1.578790063908339e-05, -1.338048754888016e-07,  1.133977851376199e-09, -9.607737602444012e-12,  8.126379190295738e-14, -6.810471091531927e-16,
  5.462949905022652e-18, -3.550423725750344e-20, -2.892084607303515e-23,  9.085211949081954e-24,  3.421957205952923e-01, -2.900171992727713e-03,  2.457948684772309e-05,
 -2.083148534463983e-07,  1.765434187522379e-09, -1.495743076519518e-11,  1.264902861645415e-13, -1.058997832969006e-15,  8.448891131827675e-18, -5.314756092360844e-20,
 -1.161746230318566e-22,  1.625684462816145e-23,  5.076195988943116e-01, -4.302169935799406e-03,  3.646167400440801e-05, -3.090180309797689e-07,  2.618863851772789e-09,
 -2.218707700044380e-11,  1.875747372432922e-13, -1.567727561182259e-15,  1.239290098842622e-17, -7.347230355502741e-20, -3.537333358723408e-22,  2.956652062471580e-23,
  7.453366529983921e-01, -6.316865892798190e-03,  5.353658579822708e-05, -4.537299890506403e-07,  3.845229734999886e-09, -3.257416201329215e-11,  2.752295342208665e-13,
 -2.292336889861392e-15,  1.777240003546319e-17, -9.138149629137287e-20, -1.087834705389783e-21,  6.088170190836404e-23,  2.452522445519048e-03, -2.010399373860830e-05,
  1.647978962750060e-07, -1.350891959956928e-09,  1.107352108336602e-11, -9.076521355241311e-14,  7.436037885920413e-16, -6.075217826311287e-18,  4.896295774438077e-20,
 -3.712923269974922e-22,  2.094433615825014e-24,  9.286310499318548e-27,  2.220787244546058e-02, -1.820439724797385e-04,  1.492263878740653e-06, -1.223248173769002e-08,
  1.002719938117242e-10, -8.218885957980200e-13,  6.733367398606333e-15, -5.500923694175067e-17,  4.432529232145722e-19, -3.357781032696908e-21,  1.881879764207975e-23,
  8.851972488205098e-26,  6.247113709325825e-02, -5.120929070985172e-04,  4.197764618956604e-06, -3.441018625181486e-08,  2.820668198397458e-10, -2.311982153575075e-12,
  1.894078273986961e-14, -1.547267597522875e-16,  1.246210717472032e-18, -9.419821452459194e-21,  5.206426838773683e-23,  2.754534890436636e-25,  1.249176509239283e-01,
 -1.023983970509214e-03,  8.393874651452482e-06, -6.880680714362116e-08,  5.640222376864149e-10, -4.623036683601676e-12,  3.787311641713800e-14, -3.093423993526351e-16,
  2.489723487934244e-18, -1.875088238773505e-20,  1.012086238341724e-22,  6.388199133811657e-25,  2.125907134448374e-01, -1.742663916608170e-03,  1.428508926561115e-05,
 -1.170986431447935e-07,  9.598788966365058e-10, -7.867657825332866e-12,  6.445166973443761e-14, -5.263217807049227e-16,  4.231317913739944e-18, -3.168648355362517e-20,
  1.645555616595785e-22,  1.321453033862094e-24,  3.309731217285601e-01, -2.713076724380493e-03,  2.223982640593629e-05, -1.823057067698166e-07,  1.494391799827223e-09,
 -1.224870794907757e-11,  1.003357844763957e-13, -8.190899084060555e-16,  6.573482150120639e-18, -4.878457034201924e-20,  2.373803792182959e-22,  2.634209791791406e-24,
  4.909717836608664e-01, -4.024629284440476e-03,  3.299097849894805e-05, -2.704356945863899e-07,  2.216805682684339e-09, -1.816971745200728e-11,  1.488249313911640e-13,
 -1.214275103545741e-15,  9.716465012976334e-18, -7.100648635838143e-20,  3.048794504329607e-22,  5.371588205946611e-24,  7.208927054209691e-01, -5.909353628171556e-03,
  4.844057467258592e-05, -3.970799877549439e-07,  3.254921049064733e-09, -2.667784731317844e-11,  2.184758506089756e-13, -1.780646563548296e-15,  1.416392203394269e-17,
 -1.001761697994499e-19,  3.036280412239804e-22,  1.243230600171437e-23,  2.374644647055074e-03, -1.884757332279877e-05,  1.495933360268538e-07, -1.187323200592987e-09,
  9.423767878403119e-12, -7.479470798180138e-14,  5.935411082573707e-16, -4.705785704714708e-18,  3.713188519818214e-20, -2.866619126146360e-22,  2.012610060311498e-24,
 -8.370705210385674e-27,  2.150268003519244e-02, -1.706669413041335e-04,  1.354584840064594e-06, -1.075134793113184e-08,  8.533329792933050e-11, -6.772744766414891e-13,
  5.374570993480659e-15, -4.261081276747057e-17,  3.362058287563209e-19, -2.594669475780517e-21,  1.818652655473210e-23, -7.461815358714276e-26,  6.048741839865437e-02,
 -4.800891176557496e-04,  3.810471058231274e-06, -3.024373129236286e-08,  2.400440573320184e-10, -1.905183898926504e-12,  1.511869243036597e-14, -1.198613070186758e-16,
  9.455887440267696e-19, -7.292391078283795e-21,  5.093361563777882e-23, -2.028763292362517e-25,  1.209509954260519e-01, -9.599890061363689e-04,  7.619440198810205e-06,
 -6.047554134090013e-08,  4.799934490725482e-10, -3.809613068857279e-12,  3.023119369540111e-14, -2.396633202418198e-16,  1.890263514399584e-18, -1.456057293194301e-20,
  1.011012445319908e-22, -3.823714639350795e-25,  2.058400731952599e-01, -1.633754286903253e-03,  1.296712045508597e-05, -1.029201094210965e-07,  8.168752167206847e-10,
 -6.483368211940641e-12,  5.144825704223839e-14, -4.078387625882036e-16,  3.215520007156363e-18, -2.472377223939657e-20,  1.700915567806977e-22, -5.890689912891510e-25,
  3.204633471454245e-01, -2.543520117526476e-03,  2.018793888788798e-05, -1.602317835794788e-07,  1.271756743676609e-09, -1.009364702823177e-11,  8.009608089313198e-14,
 -6.348707097758265e-16,  5.002687611923826e-18, -3.835581490156700e-20,  2.600316634433300e-22, -7.665685869717129e-25,  4.753813854287858e-01, -3.773105810695633e-03,
  2.994717000417858e-05, -2.376908478832613e-07,  1.886547233548909e-09, -1.497305032454923e-11,  1.188125491398647e-13, -9.415957842750709e-16,  7.412735296724460e-18,
 -5.656409158403767e-20,  3.738877708609036e-22, -7.605589925105277e-25,  6.980013606844938e-01, -5.540042311641627e-03,  4.397135851185450e-05, -3.490008860234267e-07,
  2.770010727279923e-09, -2.198473570975659e-11,  1.744422814835338e-13, -1.382017140693099e-15,  1.085990842560360e-17, -8.207358857229808e-20,  5.137151628688910e-22,
  2.167015775643009e-26  };
  constexpr double w[3072] = {  3.651985904515181e-01, -6.708487712289387e-03,  1.397436913178618e-04, -3.017633965178220e-06,  6.479735764103735e-08,
 -1.365633572496841e-09,  2.816529406177995e-11, -5.690123303389180e-13,  1.127613650641323e-14, -2.195844533208196e-16,  4.206885569194064e-18, -7.937276004066660e-20,
  3.324522944994322e-01, -1.565278512482176e-02,  6.965362556344190e-04, -2.697028755397567e-05,  9.445443620263117e-07, -3.062314572127885e-08,  9.320487979610787e-10,
 -2.688119253686918e-11,  7.395917844375616e-13, -1.950969872983403e-14,  4.953464845429590e-16, -1.213565082406707e-17,  2.777632694739530e-01, -2.812491553743615e-02,
  2.026830227281427e-03, -1.170632862601048e-04,  5.808360148537774e-06, -2.565419487366635e-07,  1.030882637087741e-08, -3.824438888457671e-10,  1.323642517641848e-11,
 -4.307235692379495e-13,  1.325733346311994e-14, -3.875083445632204e-16,  2.157060244582594e-01, -3.745446517043880e-02,  3.952490295126601e-03, -3.142501514578439e-04,
  2.055245723228070e-05, -1.157973597707053e-06,  5.781998324230890e-08, -2.607672126547053e-09,  1.076749037120147e-10, -4.112089489110912e-12,  1.463857744613236e-13,
 -4.883376834290206e-15,  1.571652344226569e-01, -3.976293899519744e-02,  5.654254562803772e-03, -5.786432393433818e-04,  4.709928905061865e-05, -3.216880890737887e-06,
  1.905680174783304e-07, -1.001331946836788e-08,  4.742446250079524e-10, -2.049133547006627e-11,  8.153822454824222e-13, -3.007133495287366e-14,  1.066588193932149e-01,
 -3.481547867350267e-02,  6.170201553865759e-03, -7.637961554594785e-04,  7.340638872678239e-05, -5.803481585740037e-06,  3.913810431480826e-07, -2.307998780811765e-08,
  1.211717807482003e-09, -5.741244684853166e-11,  2.481261115763583e-12, -9.853005410061345e-14,  6.391246984223224e-02, -2.447633922579305e-02,  5.028150192651649e-03,
 -7.091360453951634e-04,  7.644786813572762e-05, -6.688847650233548e-06,  4.934549799941226e-07, -3.151303352888117e-08,  1.775983648086787e-09, -8.963247713658810e-11,
  4.098108036514254e-12, -1.710983144922098e-13,  2.650528867917460e-02, -1.102653489426431e-02,  2.454277059107439e-03, -3.719731715386702e-04,  4.274397163101917e-05,
 -3.957301869992967e-06,  3.069177437536954e-07, -2.048909703655188e-08,  1.201049486571189e-09, -6.277205117008353e-11,  2.960571191892193e-12, -1.270589398209625e-13,
  3.403936149284693e-01, -5.719621085325247e-03,  1.089570634668313e-04, -2.167416834345095e-06,  4.313731324434505e-08, -8.463720627992616e-10,  1.629359664458372e-11,
 -3.079420744802642e-13,  5.716686031551797e-15, -1.044630705537979e-16,  1.879459915891059e-18, -3.336887728919460e-20,  2.792459291540316e-01, -1.115790404267262e-02,
  4.466955839536368e-04, -1.575683121405406e-05,  5.063001478401933e-07, -1.514595194678594e-08,  4.273497000016294e-10, -1.147142714649681e-11,  2.947755056601211e-13,
 -7.284915196553560e-15,  1.737730352154551e-16, -4.010438387103261e-18,  1.906038833696781e-01, -1.626716648594936e-02,  1.045686364552716e-03, -5.466643083991590e-05,
  2.481902793135606e-06, -1.011212571622075e-07,  3.772705198932436e-09, -1.306514582379366e-10,  4.240735534758364e-12, -1.299499639942443e-13,  3.780435970011589e-15,
 -1.048000493281706e-16,  1.113112628204974e-01, -1.669841450565901e-02,  1.580371046850606e-03, -1.145336216048776e-04,  6.906807437960667e-06, -3.619360074286776e-07,
  1.692593131230507e-08, -7.191022503775333e-10,  2.811101983428467e-11, -1.020794877336554e-12,  3.468685580673842e-14, -1.108436485315452e-15,  5.782098501550677e-02,
 -1.314063749634122e-02,  1.712297622198218e-03, -1.626676170467083e-04,  1.240986366794373e-05, -8.004272557743415e-07,  4.505453907498765e-08, -2.261016706005121e-09,
  1.027252221226579e-10, -4.274191367404821e-12,  1.643283514976293e-13, -5.873413337540566e-15,  2.777734340182931e-02, -8.493930045881726e-03,  1.421566726546634e-03,
 -1.674709587645836e-04,  1.541496299860622e-05, -1.173273562546869e-06,  7.650500819872236e-08, -4.378158765488391e-09,  2.237592748847214e-10, -1.034864430403071e-11,
  4.375945867409434e-13, -1.703759340930360e-14,  1.239992813605060e-02, -4.607723251887055e-03,  9.202615596720293e-04, -1.265969555093006e-04,  1.335213285026359e-05,
 -1.145895107820275e-06,  8.309995060876630e-08, -5.226563838146986e-09,  2.905607005668798e-10, -1.448571037578124e-11,  6.550286416971318e-13, -2.707667111995815e-14,
  4.267412455405634e-03, -1.759791967814814e-03,  3.882863973201120e-04, -5.837981391094020e-05,  6.660045801442252e-06, -6.125644462636101e-07,  4.722682832073797e-08,
 -3.135704296037747e-09,  1.829032752117541e-10, -9.515979419505826e-12,  4.469373275118285e-13, -1.910750497521503e-14,  3.191087462940291e-01, -4.941428867170902e-03,
  8.659225939713967e-05, -1.593992123469451e-06,  2.951569435120390e-08, -5.411418628783134e-10,  9.755882546967774e-12, -1.731151407644820e-13,  3.018602667615188e-15,
 -5.196824759253841e-17,  8.791348916335635e-19, -1.475106382167149e-20,  2.407319710733173e-01, -8.222828775852642e-03,  2.977690539740290e-04, -9.614840237260352e-06,
  2.845590052424353e-07, -7.879748085016716e-09,  2.066661700112652e-10, -5.175088164676583e-12,  1.244393536712857e-13, -2.885744382624108e-15,  6.475645844218959e-17,
 -1.409249838487018e-18,  1.388958271658833e-01, -9.977548482159431e-03,  5.743103252086658e-04, -2.723033198584299e-05,  1.132705703442586e-06, -4.260663669220531e-08,
  1.476444712481939e-09, -4.773060495205489e-11,  1.452554102354930e-12, -4.189320472341561e-14,  1.151031842819338e-15, -3.023294681065225e-17,  6.317242790697483e-02,
 -8.108981880705702e-03,  6.865461343880733e-04, -4.523675235503403e-05,  2.509169690879716e-06, -1.219938120353866e-07,  5.329873038814308e-09, -2.127728247836015e-10,
  7.854332018784796e-12, -2.704933425374325e-13,  8.750622031174561e-15, -2.671614472949912e-16,  2.383052826859825e-02, -4.794681789954462e-03,  5.677034638218313e-04,
 -4.972671670605559e-05,  3.535062176849056e-06, -2.142070331872031e-07,  1.140239509422570e-08, -5.441240639368860e-10,  2.361836756742029e-11, -9.427117471892768e-13,
  3.489393353222960e-14, -1.204630693617549e-15,  8.007048325972141e-03, -2.262509507589673e-03,  3.540285757281725e-04, -3.937378520178587e-05,  3.447597818780492e-06,
 -2.511536755964420e-07,  1.575382521995003e-08, -8.709274290420040e-10,  4.315519301875993e-11, -1.941106307704396e-12,  8.004417791104634e-14, -3.046580518820651e-15,
  2.559727303203300e-03, -9.155397526334763e-04,  1.765844825495079e-04, -2.356356361994096e-05,  2.420088651812865e-06, -2.029117884016569e-07,  1.441578183584254e-08,
 -8.903057396523358e-10,  4.869762430675480e-11, -2.392767196380899e-12,  1.067954930022922e-13, -4.363057648109564e-15,  7.016333672527803e-04, -2.861740017824015e-04,
  6.246564051617454e-05, -9.300634353606108e-06,  1.051784598926544e-06, -9.598247685549389e-08,  7.347835311143053e-09, -4.847642608104812e-10,  2.811236122164245e-11,
 -1.454897193829980e-12,  6.800225403104849e-14, -2.894375054331456e-15,  3.006177081579756e-01, -4.317921483643303e-03,  6.997784152066601e-05, -1.197073701284269e-06,
  2.069151225035555e-08, -3.557661429809848e-10,  6.021674305118420e-12, -1.007560968573698e-13,  1.651070298527219e-15, -2.694642455372345e-17,  4.298608782907469e-19,
 -6.708353323331634e-21,  2.119696546141195e-01, -6.235230475894864e-03,  2.052634647489308e-04, -6.095409383779097e-06,  1.668016174733664e-07, -4.289332946369917e-09,
  1.048629227206756e-10, -2.455384861052753e-12,  5.536485933268676e-14, -1.206883908337667e-15,  2.551704439198747e-17, -5.243135426842826e-19,  1.064680683267259e-01,
 -6.436205346566348e-03,  3.333546281316948e-04, -1.437388609695970e-05,  5.488778288279521e-07, -1.908715963143730e-08,  6.149376512571598e-10, -1.856883365458510e-11,
  5.299700633862785e-13, -1.438586561552814e-14,  3.732082246285668e-16, -9.283599243168436e-18,  3.904898274566663e-02, -4.254078334738167e-03,  3.220673402831317e-04,
 -1.926886415198159e-05,  9.817532777341204e-07, -4.421839036845205e-08,  1.801819927937582e-09, -6.746544161461901e-11,  2.347146069303781e-12, -7.650472794890588e-14,
  2.351298278168129e-15, -6.843612558085487e-17,  1.098042359786791e-02, -1.928023362036423e-03,  2.059629889320575e-04, -1.653765620599170e-05,  1.090012328470283e-06,
 -6.176711624655787e-08,  3.096091874751228e-09, -1.399299864289545e-10,  5.780860128492225e-12, -2.205498310073595e-13,  7.832465663840657e-15, -2.603204249173829e-16,
  2.578402392885001e-03, -6.628511751915116e-04,  9.595158714937062e-05, -9.989749160587165e-06,  8.262217075033593e-07, -5.725660141357088e-08,  3.436235876132666e-09,
 -1.826337045646756e-10,  8.735975266142948e-12, -3.806611606951763e-13,  1.525330113401082e-14, -5.656992344351342e-16,  5.693098844001894e-04, -1.939814147367976e-04,
  3.583379126895167e-05, -4.607120864402694e-06,  4.581889365612541e-07, -3.735409362551613e-08,  2.589255602411270e-09, -1.564698069230202e-10,  8.394844759374935e-12,
 -4.054382907561092e-13,  1.781876979003452e-14, -7.179720211233681e-16,  1.184030553226819e-04, -4.761981846139740e-05,  1.025513095255905e-05, -1.508614214763151e-06,
  1.687921170514440e-07, -1.525788556614863e-08,  1.158194787668190e-09, -7.583176792062151e-11,  4.367584699503326e-12, -2.246364758779694e-13,  1.044043893272132e-14,
 -4.420952138520415e-16,  2.843819816049807e-01, -3.810424309213098e-03,  5.738758698575258e-05, -9.159420279042870e-07,  1.482031861277159e-08, -2.399201582826334e-10,
  3.815079994022888e-12, -6.061848337055255e-14,  9.317811230947784e-16, -1.433408509993787e-17,  2.282712864271862e-19, -2.902370779348368e-21,  1.899061461674016e-01,
 -4.846066775129295e-03,  1.456872922639708e-04, -3.996361843078134e-06,  1.015000191435276e-07, -2.431509402462093e-09,  5.556474656342933e-11, -1.219483922034411e-12,
  2.584234118975525e-14, -5.305231288532568e-16,  1.058382853195878e-17, -2.057551598166013e-19,  8.514266147073264e-02, -4.334579001176376e-03,  2.031486288476968e-04,
 -7.991458948319144e-06,  2.807991577760291e-07, -9.043746314508811e-09,  2.712730402285224e-10, -7.658944645499447e-12,  2.051574810045157e-13, -5.243697059064251e-15,
  1.284639349195410e-16, -3.026521621429453e-18,  2.602565887784658e-02, -2.390020139427494e-03,  1.620685543806162e-04, -8.802962663074736e-06,  4.118419350967277e-07,
 -1.717270703868318e-08,  6.520579105143363e-10, -2.287376715605045e-11,  7.490242776618964e-13, -2.307332117398892e-14,  6.726229660380851e-16, -1.863169486782892e-17,
  5.628136390016910e-03, -8.506574953124430e-04,  8.156011664019281e-05, -5.975361357614331e-06,  3.636668249658422e-07, -1.919843666201521e-08,  9.029052538726696e-10,
 -3.851396766755588e-11,  1.509259436306313e-12, -5.485845209149695e-14,  1.863289502234615e-15, -5.943806178692356e-17,  9.338848074820620e-04, -2.147150258808687e-04,
  2.844911606564613e-05, -2.749448883187438e-06,  2.132778873892635e-07, -1.397337001639557e-08,  7.979699483419538e-10, -4.057330590564177e-11,  1.865097709843216e-12,
 -7.840805594654107e-14,  3.041590393234899e-15, -1.095382472660077e-16,  1.383632885258139e-04, -4.432466824095837e-05,  7.764073392789231e-06, -9.541014196368920e-07,
  9.127655796824106e-08, -7.195242882896240e-09,  4.842980237968479e-10, -2.851859328493296e-11,  1.495405279662160e-12, -7.076484336744179e-14,  3.053939318158501e-15,
 -1.210631513370872e-16,  2.064611444113025e-05, -8.153369106768821e-06,  1.726025197184733e-06, -2.501124381118358e-07,  2.761695514933474e-08, -2.467615971416868e-09,
  1.853990286249989e-10, -1.202850006357204e-11,  6.871530375795421e-13, -3.508333889214514e-14,  1.619775233172199e-15, -6.817720364193889e-17,  2.699941218595327e-01,
 -3.391592699607530e-03,  4.767535778579409e-05, -7.127512928535161e-07,  1.081565343406033e-08, -1.657759716864661e-10,  2.468937580641008e-12, -3.750633261410219e-14,
  5.551183335151358e-16, -7.149981257724460e-18,  1.424039015376931e-19, -1.326877100009274e-21,  1.725837855144956e-01, -3.848062465741390e-03,  1.060767458983433e-04,
 -2.699075334564066e-06,  6.385701993168147e-08, -1.429367078478748e-09,  3.061944408751359e-11, -6.312948094228796e-13,  1.259918774721965e-14, -2.442610942714079e-16,
  4.597107380489968e-18, -8.483763852017691e-20,  7.053958603039207e-02, -3.028365504145513e-03,  1.292134722292324e-04, -4.653428762607506e-06,  1.508641600839262e-07,
 -4.509241688483621e-09,  1.261591309360354e-10, -3.334642645252906e-12,  8.391685656569763e-14, -2.021767078488752e-15,  4.677847476821183e-17, -1.044371448125642e-18,
  1.851922497792496e-02, -1.425483709283020e-03,  8.689415599768752e-05, -4.288148176663170e-06,  1.843121858937647e-07, -7.115499446621032e-09,  2.517161099750932e-10,
 -8.268556145107357e-12,  2.546670335546976e-13, -7.407493634383329e-15,  2.045914647002216e-16, -5.386922339621572e-18,  3.185326288790955e-03, -4.090983888109297e-04,
  3.510280806686462e-05, -2.338687054908566e-06,  1.310403970419882e-07, -6.425963399547267e-09,  2.827399305699357e-10, -1.135011958815204e-11,  4.207021230906214e-13,
 -1.452763806383056e-14,  4.706110400995054e-16, -1.436887516163850e-17,  3.818012930995581e-04, -7.708313627918858e-05,  9.256116151707250e-06, -8.238018271505544e-07,
  5.953393973099280e-08, -3.665830478041596e-09,  1.981377802578809e-10, -9.590947532476299e-12,  4.218015295457970e-13, -1.703734875460016e-14,  6.373698004599809e-16,
 -2.221036225007237e-17,  3.730563885192228e-05, -1.105237074217828e-05,  1.814313653578591e-06, -2.111382861996132e-07,  1.928333723454708e-08, -1.460431845438137e-09,
  9.492878858855541e-11, -5.421378791673747e-12,  2.766853403374229e-13, -1.278220122657224e-14,  5.399294144832956e-16, -2.099756523292294e-17,  3.753598402790498e-06,
 -1.446871451443082e-06,  2.995962891122462e-07, -4.259164264569738e-08,  4.625918300661143e-09, -4.074473004069499e-10,  3.023071233389462e-11, -1.939742709591406e-12,
  1.097282455239816e-13, -5.553353800405660e-15,  2.543831370704535e-16, -1.063148197198532e-17,  2.571402330338241e-01, -3.041692739767743e-03,  4.006076706391306e-05,
 -5.633291269371981e-07,  8.017113799153490e-09, -1.173175470157446e-10,  1.635958854641885e-12, -2.287145503893807e-14,  3.866769614103426e-16, -2.593624903332708e-18,
  8.276568063566594e-20, -1.679883605151709e-21,  1.587055844734329e-01, -3.113575070761771e-03,  7.898941754585547e-05, -1.871417155001021e-06,  4.139164374259786e-08,
 -8.680727129429661e-10,  1.748198143958287e-11, -3.395148949189813e-13,  6.381043825203994e-15, -1.176057018742047e-16,  2.084345219584793e-18, -3.632859606441597e-20,
  6.018995178634230e-02, -2.182910566297260e-03,  8.533683095044891e-05, -2.823605950051275e-06,  8.471815332839235e-08, -2.354679812239416e-09,  6.157637615589882e-11,
 -1.526608194795098e-12,  3.609967768376773e-14, -8.220074402524989e-16,  1.796201495529059e-17, -3.796929018759473e-19,  1.394049256957925e-02, -8.950446823332919e-04,
  4.931625010927309e-05, -2.214224280232734e-06,  8.754857127728999e-08, -3.131281798800000e-09,  1.032456141718517e-10, -3.176262580648588e-12,  9.197863836579133e-14,
 -2.525692569652818e-15,  6.604670738061686e-17, -1.651518914255301e-18,  1.972753633127266e-03, -2.127054732162745e-04,  1.633091947711611e-05, -9.873053320557590e-07,
  5.083843567129920e-08, -2.311152822324187e-09,  9.494056223127649e-11, -3.579030559527020e-12,  1.251946027178007e-13, -4.097831191740574e-15,  1.263080749482009e-16,
 -3.682430931627890e-18,  1.761424462504501e-04, -3.063956125763983e-05,  3.306865935807874e-06, -2.691279117133351e-07,  1.801138993101814e-08, -1.036735078177272e-09,
  5.277486620633741e-11, -2.420861622247777e-12,  1.014236339225523e-13, -3.920314291501059e-15,  1.409021286314725e-16, -4.734100782081150e-18,  1.132654084721730e-05,
 -3.041431589685045e-06,  4.617740514107307e-07, -5.037023504663908e-08,  4.355017229848883e-09, -3.146433916808112e-10,  1.963052696816245e-11, -1.081508005973909e-12,
  5.347147914774733e-14, -2.401645261843461e-15,  9.893183928281683e-17, -3.762110814789211e-18,  7.202198689484851e-07, -2.686579282968438e-07,  5.404273251512936e-08,
 -7.496857511127275e-09,  7.974400362546124e-10, -6.899202252140830e-11,  5.040134536539193e-12, -3.190474552648374e-13,  1.783413137034935e-14, -8.931021595782147e-16,
  4.052700971170745e-17, -1.679550911769159e-18,  2.455744810601501e-01, -2.746231191288879e-03,  3.399940478153481e-05, -4.518863157287839e-07,  6.018451051669798e-09,
 -8.440856129418404e-11,  1.158354780973195e-12, -1.152122706713482e-14,  3.313938139352244e-16, -1.174891472077900e-18, -2.283298977842753e-20, -3.149260073436186e-21,
  1.473872107638681e-01, -2.561415109062804e-03,  5.999899425217979e-05, -1.328108047680983e-06,  2.756036524227999e-08, -5.429136037769253e-10,  1.029673515343813e-11,
 -1.896310531190780e-13,  3.332081682886653e-15, -5.885756383538541e-17,  1.001949717003858e-18, -1.565833929708289e-20,  5.263749700593198e-02, -1.615826803676211e-03,
  5.825777874259863e-05, -1.777060674778532e-06,  4.951490194685137e-08, -1.282338757645832e-09,  3.138266245985304e-11, -7.333188276125586e-13,  1.623990310855926e-14,
 -3.507994461865171e-16,  7.285900564665495e-18, -1.441078336936480e-19,  1.100938025889486e-02, -5.869981653163670e-04,  2.944943546433482e-05, -1.204995474183372e-06,
  4.391711357704677e-08, -1.456790819348992e-09,  4.479854541257924e-11, -1.292361141100249e-12,  3.516443099369071e-14, -9.119612401503179e-16,  2.258786437961305e-17,
 -5.355533720819994e-19,  1.323921921986619e-03, -1.184705804950014e-04,  8.162701778844871e-06, -4.472565485245781e-07,  2.115070366939932e-08, -8.903887307376531e-10,
  3.410328259970752e-11, -1.205656559052341e-12,  3.973165298431884e-14, -1.230586000383893e-15,  3.602581163615635e-17, -1.000891428768160e-18,  9.132903764217641e-05,
 -1.342484585214139e-05,  1.295010706089352e-06, -9.580837106170783e-08,  5.908974066142589e-09, -3.164848837755159e-10,  1.510779273898817e-11, -6.540593219083421e-13,
  2.600190539655264e-14, -9.581849651963386e-16,  3.296840667773279e-17, -1.064354160367540e-18,  3.923452473053945e-06, -9.322617093048508e-07,  1.291180620767239e-07,
 -1.305914146136789e-08,  1.059453701107731e-09, -7.247058668745657e-11,  4.311475196463532e-12, -2.278287440231831e-13,  1.085676466573441e-14, -4.719317294507233e-16,
  1.888145279020071e-17, -6.995384967439544e-19,  1.482468013674536e-07, -5.284656091281237e-08,  1.023083718091393e-08, -1.374889260391556e-09,  1.424124118224365e-10,
 -1.204672257301306e-11,  8.632372717454291e-13, -5.373899182664657e-14,  2.960435410755206e-15, -1.463655267908356e-16,  6.566835969757244e-18, -2.694195385599884e-19,
  2.351013571417241e-01, -2.494408423997180e-03,  2.910347442042031e-05, -3.676747149776929e-07,  4.588136456332218e-09, -5.933330501392986e-11,  9.749491575897791e-13,
 -2.058229513864696e-15,  2.367992259957364e-16, -5.092297387887948e-18, -1.734670286314278e-19, -3.133560059702326e-21,  1.380101931187167e-01, -2.138422078510630e-03,
  4.638820262767677e-05, -9.621925500999712e-07,  1.879809923697634e-08, -3.491699797761358e-10,  6.209660217091497e-12, -1.103154947391025e-13,  1.798766564781973e-15,
 -2.936811526057535e-17,  5.361300748824716e-19, -6.851277764605030e-21,  4.698799877315854e-02, -1.223309547272819e-03,  4.095587580407423e-05, -1.155130011512229e-06,
  2.999722215979416e-08, -7.267524480924060e-10,  1.656615408952365e-11, -3.698039600479333e-13,  7.632794440240240e-15, -1.541812307306660e-16,  3.170879920998386e-18,
 -5.689256749494794e-20,  9.055356954858994e-03, -3.991847737256957e-04,  1.840443049541703e-05, -6.873417204585266e-07,  2.314981139316718e-08, -7.137818546613572e-10,
  2.045008158597515e-11, -5.554921319563153e-13,  1.418758670612755e-14, -3.468365573647886e-16,  8.182867338112155e-18, -1.831898219753952e-19,  9.532939942499367e-04,
 -6.999680632641742e-05,  4.356372433944721e-06, -2.161710112823751e-07,  9.392461296787396e-09, -3.661148997811054e-10,  1.306017552906759e-11, -4.329172441385908e-13,
  1.342302234270128e-14, -3.928381402376250e-16,  1.091376481784445e-17, -2.884125766062998e-19,  5.283352289206615e-05, -6.434615031872375e-06,  5.538263580413760e-07,
 -3.707084796274764e-08,  2.099478584968850e-09, -1.042621798647639e-10,  4.650537398780042e-12, -1.893768108047237e-13,  7.119536186451395e-15, -2.492941322882109e-16,
  8.184919334861726e-18, -2.530976648912944e-19,  1.565028537832629e-06, -3.200816596993197e-07,  3.991688098556525e-08, -3.703254330051579e-09,  2.794356266862680e-10,
 -1.795996697377813e-11,  1.012056657156040e-12, -5.098902833016143e-14,  2.329355389421476e-15, -9.752222889920819e-17,  3.773001855294575e-18, -1.356508770347597e-19,
  3.345137529441998e-08, -1.118622587957106e-08,  2.057792591931094e-09, -2.653473657354799e-10,  2.656551455050071e-11, -2.184085085122340e-12,  1.527701719675047e-13,
 -9.315367987795498e-15,  5.040545503260638e-16, -2.453377739925338e-17,  1.085697889181928e-18, -4.400591753464367e-20,  2.255630890484595e-01, -2.278063012516188e-03,
  2.509677491854564e-05, -3.024934018460016e-07,  3.634303545774322e-09, -3.599276833442219e-11,  9.850122883391886e-13,  1.036525939742491e-15, -9.498007370419689e-17,
 -1.361031310385150e-17, -2.077744440619077e-19,  3.092902726295299e-21,  1.301321685781160e-01, -1.808871525024265e-03,  3.643967457236342e-05, -7.101371093834011e-07,
  1.308478839001083e-08, -2.315419409017755e-10,  3.794187974342150e-12, -6.605045548528185e-14,  1.065235710753804e-15, -1.289547527588241e-17,  3.034995035987837e-19,
 -4.633509305172620e-21,  4.267248488100274e-02, -9.439295182009628e-04,  2.955581618424072e-05, -7.729345102312636e-07,  1.872305213680556e-08, -4.301789891546387e-10,
  8.946660316702746e-12, -1.940251723677465e-13,  3.873420919407253e-15, -6.574190027944843e-17,  1.471188309387402e-18, -2.625536211346357e-20,  7.708500047471038e-03,
 -2.795796381700373e-04,  1.198148639052480e-05, -4.089765330323179e-07,  1.274564390666070e-08, -3.679379827538252e-10,  9.748485602534409e-12, -2.510410397104910e-13,
  6.066827085121769e-15, -1.370960059775845e-16,  3.136153805096619e-18, -6.680622734144736e-20,  7.295708036815206e-04, -4.343055217357313e-05,  2.468054467385460e-06,
 -1.108296587213713e-07,  4.427422994586746e-09, -1.601660883798063e-10,  5.308243617044090e-12, -1.651849073776752e-13,  4.821178881438301e-15, -1.328719499605179e-16,
  3.508045221852632e-18, -8.810068544488075e-20,  3.377674953529609e-05, -3.338806613866791e-06,  2.573519471251847e-07, -1.552417724587599e-08,  8.054918662771171e-10,
 -3.701218526850116e-11,  1.537831727537519e-12, -5.875929952994280e-14,  2.083396181316545e-15, -6.911097312340443e-17,  2.159589596162113e-18, -6.378179531004724e-20,
  7.216921772244599e-07, -1.231341581975432e-07,  1.368981103296210e-08, -1.153250808224924e-09,  8.028442459283067e-11, -4.813757720583015e-12,  2.552594254214885e-13,
 -1.218953189715010e-14,  5.309670612997374e-16, -2.130452214444806e-17,  7.934352632775618e-19, -2.756728619101387e-20,  8.507045758376737e-09, -2.596372389938676e-09,
  4.463211459653678e-10, -5.454341052479263e-11,  5.228028612330102e-12, -4.146047442932508e-13,  2.813488077562745e-14, -1.671911221594978e-15,  8.848561116012768e-17,
 -4.224976011454926e-18,  1.838615999250081e-19, -7.343615747658263e-21,  2.168307298582632e-01, -2.090866327647175e-03,  2.179615114682186e-05, -2.488215248939381e-07,
  3.149330195022884e-09, -1.284697901048139e-11,  8.890511741172007e-13, -1.094854921079667e-14, -6.657272839507939e-16, -1.511991199514744e-17,  2.468066432499474e-19,
  1.846187574241484e-20,  1.234303444000126e-01, -1.548204303782398e-03,  2.903581615327963e-05, -5.334438362944504e-07,  9.233111435483735e-09, -1.591778858197869e-10,
  2.366511301771649e-12, -3.746701970475837e-14,  7.669623403249382e-16, -5.255151276996909e-18,  6.296768330914077e-20, -6.644584211452264e-21,  3.931732983197472e-02,
 -7.400774842146183e-04,  2.182739338579560e-05, -5.321474364873803e-07,  1.189103817689444e-08, -2.684782564194894e-10,  4.962319580814411e-12, -9.865320061639095e-14,
  2.315129554410813e-15, -2.723295204820094e-17,  4.918451322482299e-19, -2.073224899352523e-20,  6.755051305973779e-03, -2.003789239745359e-04,  8.089996154339985e-06,
 -2.532504207922437e-07,  7.253931423502816e-09, -2.002056093594915e-10,  4.839339103582949e-12, -1.164693838948374e-13,  2.819443833702674e-15, -5.594571421909358e-17,
  1.195169026860082e-18, -2.846266599159928e-20,  5.883420156827444e-04, -2.800686663097311e-05,  1.476195001211462e-06, -6.000282246416432e-08,  2.197787654716214e-09,
 -7.444804024405985e-11,  2.280429498474715e-12, -6.646749371847579e-14,  1.846348678917537e-15, -4.742022509441972e-17,  1.186657942358140e-18, -2.881044789176250e-20,
  2.360803200448759e-05, -1.851601428499757e-06,  1.292004335113099e-07, -7.001283020888947e-09,  3.320427331759963e-10, -1.412915616504978e-11,  5.450894325786275e-13,
 -1.950309890642152e-14,  6.517278430886150e-16, -2.040983945628254e-17,  6.057527200028647e-19, -1.706581461218194e-20,  3.838860233880006e-07, -5.275056561278422e-08,
  5.209113533236082e-09, -3.948578205420564e-10,  2.518332554664903e-11, -1.400194943807870e-12,  6.944510753930679e-14, -3.126149966285232e-15,  1.291825467223159e-16,
 -4.943264722578736e-18,  1.764272590046186e-19, -5.898888171781754e-21,  2.519946517096725e-09, -6.743555149891760e-10,  1.061459530697665e-10, -1.210640598338302e-11,
  1.098074529317429e-12, -8.322148577603997e-14,  5.437515249634324e-15, -3.129437062779936e-16,  1.611562254521253e-17, -7.515555482774065e-19,  3.204338445025709e-20,
 -1.257190660451069e-21,  2.087982847526015e-01, -1.927596641989560e-03,  1.910750377634263e-05, -1.994814070403589e-07,  3.066743537035575e-09,  2.012972668775394e-12,
  2.262823302252234e-13, -3.725873442540716e-14, -8.077033476558655e-16,  1.365312226573755e-17,  1.182965405265368e-18,  1.600530056448762e-20,  1.176648083626085e-01,
 -1.339235149459568e-03,  2.342494831459538e-05, -4.084055587117568e-07,  6.546148578285237e-09, -1.123692831480956e-10,  1.632623849336897e-12, -1.605888230502641e-14,
  5.500399124774608e-16, -8.736361389189690e-18, -2.215933568026872e-19, -4.238777578142268e-21,  3.666989106937730e-02, -5.881371861047791e-04,  1.642470211281819e-05,
 -3.791756647149814e-07,  7.528457977749609e-09, -1.749726300553835e-10,  3.106632749989838e-12, -3.822372914133982e-14,  1.472880110800530e-15, -2.518151699649003e-17,
 -3.432227067760481e-19, -1.366611676339754e-20,  6.066158547399881e-03, -1.461100532050444e-04,  5.633039818679842e-06, -1.638563191847337e-07,  4.192924074935769e-09,
 -1.145859259763296e-10,  2.591676858130258e-12, -5.138365919165685e-14,  1.410415372111851e-15, -2.825321177664060e-17,  2.955721280117501e-19, -1.341100583219215e-20,
  4.960892260720123e-04, -1.857620029053158e-05,  9.261673622428293e-07, -3.430629421386962e-08,  1.134213090169939e-09, -3.667701305890789e-11,  1.043086701069310e-12,
 -2.756518039657530e-14,  7.547172871291828e-16, -1.833187189351197e-17,  4.003427254545173e-19, -1.019117169343576e-20,  1.784079317776162e-05, -1.081377709425239e-06,
  6.961697130976679e-08, -3.389038859966404e-09,  1.458560435088492e-10, -5.785476300817582e-12,  2.069255738328261e-13, -6.883944724142313e-15,  2.179838046336975e-16,
 -6.432109176677941e-18,  1.795775122443186e-19, -4.865363345855295e-21,  2.336792414495059e-07, -2.484063298918304e-08,  2.192749834191303e-09, -1.484673712937655e-10,
  8.616426573185093e-12, -4.426988911877578e-13,  2.042579948352101e-14, -8.622599358451687e-16,  3.366974690184940e-17, -1.222902886032859e-18,  4.163686333120949e-20,
 -1.335037577442216e-21,  8.996706347420550e-10, -1.994770363772712e-10,  2.815305299404230e-11, -2.943593047971281e-12,  2.492472015995119e-13, -1.785844383400396e-14,
  1.113407691458690e-15, -6.159976334152979e-17,  3.067366553621069e-18, -1.389741778949404e-19,  5.779156649406533e-21, -2.218715710897010e-22,  2.013796393709610e-01,
 -1.783474532136338e-03,  1.700934249112806e-05, -1.501944131323500e-07,  3.064898211004154e-09, -7.195631402054532e-12, -1.035815867056857e-12, -4.557109684267110e-14,
  5.710385153206720e-16,  5.927668980297043e-17,  5.878111577947796e-19, -5.199810904417884e-20,  1.126539333018200e-01, -1.169816075651619e-03,  1.908490334457656e-05,
 -3.196387896242601e-07,  4.662976975622644e-09, -7.694984807721856e-11,  1.368917548670273e-12, -5.331979607124101e-15,  6.787684626849697e-17, -1.707144212601134e-17,
 -6.637649471140569e-20,  1.284648706006101e-20,  3.455389185784628e-02, -4.731333576123874e-04,  1.249417734986802e-05, -2.829448093836152e-07,  4.711463292331006e-09,
 -1.088832249689572e-10,  2.536669943789210e-12, -8.910730173324400e-15,  2.554048724137359e-16, -4.149362517882358e-17, -1.767204448931565e-19,  2.584337700554545e-20,
  5.560799438075584e-03, -1.079246723976566e-04,  4.003464502780298e-06, -1.121325798542580e-07,  2.429259401606985e-09, -6.543223786801859e-11,  1.642848752433898e-12,
 -2.111394229468903e-14,  5.076964600758688e-16, -2.329129151090932e-17,  9.023579751258520e-20,  5.246643963646976e-21,  4.343676136555019e-04, -1.255309724602254e-05,
  6.029614856134390e-07, -2.088721898986655e-08,  6.003539637806135e-10, -1.869365206358791e-11,  5.279437504896804e-13, -1.159406675184715e-14,  2.996754613643203e-16,
 -8.649440693231530e-18,  1.398066642363053e-19, -2.411954947312452e-21,  1.441787205666491e-05, -6.547598062062561e-07,  3.985626402598440e-08, -1.764865872608083e-09,
  6.751358728386409e-11, -2.517150693513962e-12,  8.491170685370812e-14, -2.559917418209108e-15,  7.675919961443724e-17, -2.212737518146960e-18,  5.588336832451105e-20,
 -1.418721781129070e-21,  1.607158281991354e-07, -1.261463028875789e-08,  1.014313988921704e-09, -6.124654484020772e-11,  3.199865323286513e-12, -1.519585709450288e-13,
  6.510754833134690e-15, -2.556904751667241e-16,  9.414202577489270e-18, -3.241479088393342e-19,  1.044404273183592e-20, -3.201938320214878e-22,  3.975228036495701e-10,
 -6.772920769246532e-11,  8.448704290668760e-12, -7.945953310276835e-13,  6.187404368556256e-14, -4.143704927100864e-15,  2.440415055016908e-16, -1.286721501231250e-17,
  6.151606478795052e-19, -2.690978687595039e-20,  1.085493869547250e-21, -4.059620748009371e-23,  1.945076250517202e-01, -1.653797097681938e-03,  1.549107577694048e-05,
 -1.040289207305673e-07,  2.588240817193063e-09, -4.330139268493265e-11, -1.734535289612350e-12,  5.779711198653392e-15,  2.417069351887874e-15,  2.168005281659468e-17,
 -2.538843663504736e-18, -5.816861586487371e-20,  1.082573855741710e-01, -1.031316806578585e-03,  1.565173523613925e-05, -2.556116130519532e-07,  3.439321399004121e-09,
 -4.619609002286645e-11,  1.161582624230762e-12, -1.217096351659505e-14, -4.266243915204539e-16, -5.522130567839697e-18,  6.368605643836586e-19,  1.125055890028452e-20,
  3.284137902575271e-02, -3.856241986252605e-04,  9.489761732706529e-06, -2.217607408570051e-07,  3.121343689835590e-09, -5.143476558582596e-11,  2.183497523730795e-12,
 -2.313122185948800e-14, -9.996597656745053e-16, -1.692897287202724e-17,  1.455981449485362e-18,  3.086480689801169e-20,  5.185452250198875e-03, -8.070499760944758e-05,
  2.854345935429780e-06, -8.176883815035441e-08,  1.473355970245636e-09, -3.199517390064438e-11,  1.162154642425081e-12, -1.683580458154576e-14, -1.669148668831037e-16,
 -1.073718024958437e-17,  5.842587999737760e-19,  1.086951048944177e-20,  3.924133002149691e-04, -8.593117734193401e-06,  3.995790755950627e-07, -1.367831624780511e-08,
  3.314004233995728e-10, -9.087564978582571e-12,  2.976882155340715e-13, -6.026827263904732e-15,  7.631923907583134e-17, -3.837960650918946e-18,  1.231811346394740e-19,
  5.718540830088006e-22,  1.232406352750606e-05, -4.054698365130750e-07,  2.380016738176199e-08, -9.968561772589089e-10,  3.291356618136336e-11, -1.122532467898391e-12,
  3.814957953358076e-14, -1.042136076925669e-15,  2.622695406928429e-17, -8.147947665224297e-19,  2.163582136055094e-20, -3.573666655646231e-22,  1.228130491320363e-07,
 -6.755410516908991e-09,  5.083216234179217e-10, -2.780813658223423e-11,  1.282205254184145e-12, -5.603126766238556e-14,  2.261694155723407e-15, -8.177796986850404e-17,
  2.791421335572458e-18, -9.259138989040292e-20,  2.830538177967623e-21, -7.992548588335395e-23,  2.188699951948630e-10, -2.615933946473299e-11,  2.890932244966594e-12,
 -2.409351891359973e-13,  1.694995570886893e-14, -1.049852111676193e-15,  5.787514202987402e-17, -2.878303272791485e-18,  1.310497743794105e-19, -5.502285463954834e-21,
  2.138930087415424e-22, -7.744673436183469e-24,  1.881332773767919e-01, -1.534237470469702e-03,  1.445582803620296e-05, -7.159320284821639e-08,  1.364436115333783e-09,
 -7.430845516786840e-11, -5.295467208693320e-13,  7.344605883060532e-14,  1.134800117925100e-15, -8.754714869653736e-17, -1.709700367660561e-18,  9.932194970445921e-20,
  1.043643593093441e-01, -9.174978543272120e-04,  1.288860301907475e-05, -2.066032700711829e-07,  2.758509921321958e-09, -2.394488407669706e-11,  6.375515842529790e-13,
 -2.371668882737855e-14, -1.403137994468293e-16,  1.944272648846406e-17,  3.397784387122150e-19, -2.395843559413539e-20,  3.143498176427096e-02, -3.195626663930959e-04,
  7.102792682950299e-06, -1.774896622461308e-07,  2.544763662435039e-09, -1.053639597290190e-11,  1.085581716312289e-12, -5.228722271638232e-14, -4.393375730935919e-16,
  4.499007666002925e-17,  9.814108762302397e-19, -5.462340556184017e-20,  4.902600380689395e-03, -6.143401890624652e-05,  1.997883577644449e-06, -6.197291250003421e-08,
  1.070191320362721e-09, -1.054417571490411e-11,  5.933730513460290e-13, -2.334989535888936e-14, -8.632523134352186e-17,  1.423701055813527e-17,  4.279631803512892e-19,
 -1.980899686382491e-20,  3.635064369071342e-04, -5.974463805212194e-06,  2.623656632012425e-07, -9.495439946458248e-09,  2.084360629317407e-10, -3.785126846764743e-12,
  1.492567553376483e-13, -4.831194994995623e-15,  2.689796004406833e-17,  8.526211770914820e-19,  8.447656930538292e-20, -2.874720127462034e-21,  1.101796914731554e-05,
 -2.553915170264978e-07,  1.439421807488472e-08, -6.086059237968086e-10,  1.764999019954995e-11, -4.840471448884414e-13,  1.735061379962244e-14, -5.304952093037328e-16,
  9.444514757889203e-18, -1.904130023056474e-19,  1.021189485814453e-20, -2.542791686649294e-22,  1.022113798170520e-07, -3.744119081189565e-09,  2.685256033753528e-10,
 -1.393845648498457e-11,  5.603940272600305e-13, -2.157373829159981e-14,  8.450222935486570e-16, -2.928610482593463e-17,  8.717015093281627e-19, -2.665128525141246e-20,
  8.666877652336654e-22, -2.314516201332885e-23,  1.470665182488164e-10, -1.119992526259008e-11,  1.119968672090507e-12, -8.299136155058579e-14,  5.159023998655471e-15,
 -2.912461219381699e-16,  1.499504600717989e-17, -6.978483909123591e-19,  2.982387870056908e-20, -1.194311021294067e-21,  4.474643741922602e-23, -1.554053707013546e-24,
  1.822225534655205e-01, -1.421769995997626e-03,  1.367841603664950e-05, -6.160914929013355e-08, -7.436101956181836e-11, -6.138414065433294e-11,  1.523020802176017e-12,
  5.579110564092020e-14, -2.054564964296165e-15, -5.799434092295309e-17,  2.842099287271786e-18,  5.474041205617703e-20,  1.008859004026648e-01, -8.235877949301756e-04,
  1.066045034818351e-05, -1.656930661627933e-07,  2.379122655852260e-09, -1.643415829321098e-11,  2.169548004134674e-14, -1.660309168455394e-14,  5.327696354697481e-16,
  1.109838808744259e-17, -6.476833054348241e-19, -9.885854383835580e-21,  3.025785115955803e-02, -2.705769866994126e-04,  5.213461894649879e-06, -1.375492186458980e-07,
  2.474698448030888e-09, -2.002084183427072e-12, -3.083664109202844e-13, -3.816925707114195e-14,  1.230113620316151e-15,  3.030823989013790e-17, -1.529189790239564e-18,
 -3.054015548435533e-20,  4.684515311149978e-03, -4.814666095186236e-05,  1.351888217509607e-06, -4.598421907540849e-08,  9.494327576936786e-10, -3.917260609224827e-12,
 -9.824446698422135e-15, -1.658375346758672e-14,  4.888261602407361e-16,  1.101381534886375e-17, -5.365109528157962e-19, -1.295509609005581e-20,  3.431585579378146e-04,
 -4.279333317611727e-06,  1.664422176962696e-07, -6.615158067291735e-09,  1.582835721686249e-10, -1.684303293469508e-12,  3.364380078067275e-14, -3.116201399777179e-15,
  8.235733386971640e-17,  1.220316936855755e-18, -6.115095249669205e-20, -2.204398576468144e-21,  1.018642140200195e-05, -1.652616038187370e-07,  8.526714210808126e-09,
 -3.855221898103700e-10,  1.108811384641812e-11, -2.158036225328409e-13,  6.128004952656441e-15, -2.818361661851826e-16,  7.145118163701227e-18, -1.184047920128419e-20,
 -7.581014443970314e-22, -1.776086900254222e-22,  9.065151352137062e-08, -2.139353121974760e-09,  1.437466846933441e-10, -7.553487803226251e-12,  2.785632406401039e-13,
 -8.671506572852371e-15,  3.091355299421736e-16, -1.171121777458538e-17,  3.398445560865374e-19, -7.215504785789995e-21,  2.054317352761772e-22, -8.823097986814276e-24,
  1.154038614580926e-10, -5.162723329298561e-12,  4.760661144209679e-13, -3.260548319092608e-14,  1.775174081677234e-15, -8.804275596039354e-17,  4.209131134539589e-18,
 -1.864839527999896e-19,  7.412457587592562e-21, -2.731247724379109e-22,  9.815732324687325e-24, -3.383744535759108e-25,  1.767495130259436e-01, -1.315398500571122e-03,
  1.289897942919932e-05, -7.025337871369851e-08, -8.535090024487851e-10, -1.460318564459982e-11,  2.018651530659663e-12, -1.992809658876955e-14, -1.999651693099307e-15,
  5.201574826233442e-17,  1.597345669587911e-18, -8.434642843676292e-20,  9.775040385946643e-02, -7.456357672249014e-04,  8.889432600901420e-06, -1.303487858722863e-07,
  2.028833140741701e-09, -1.938311167994401e-11, -1.815421016332084e-13,  1.688117927616630e-15,  4.658708447042908e-16, -1.239132873288645e-17, -3.107766250707863e-19,
  1.856505953067413e-20,  2.924944606745550e-02, -2.348056394277724e-04,  3.797037425178078e-06, -9.895136102690953e-08,  2.299696670564225e-09, -1.722573627759690e-11,
 -7.526461423966332e-13,  5.984068709758645e-15,  1.161849913488166e-15, -2.928524577333759e-17, -8.666689425994218e-19,  4.597748150696534e-20,  4.510419916750111e-03,
 -3.928723269323886e-05,  8.882484589121061e-07, -3.155584266381495e-08,  8.412153246299297e-10, -7.754565085985705e-12, -2.282717620277961e-13,  8.117745070686119e-16,
  4.621440435359152e-16, -1.102286616975271e-17, -3.364889338408830e-19,  1.696829086920972e-20,  3.282591604821007e-04, -3.224669441461757e-06,  1.012186044623386e-07,
 -4.332217918174019e-09,  1.272442626565989e-10, -1.605340770771168e-12, -1.411183904603592e-14, -3.456343353534464e-16,  7.314248406087203e-17, -1.618459792035618e-18,
 -4.673607748532167e-20,  2.238692384009251e-21,  9.636379460279246e-06, -1.128245565880582e-07,  4.842129377681272e-09, -2.368777131398947e-10,  7.733724156309717e-12,
 -1.384731815481297e-13,  1.269999906620651e-15, -7.569556143241025e-17,  5.120345272241360e-18, -1.076947624725810e-19, -1.952932366970819e-21,  9.467320090830031e-23,
  8.391229362682038e-08, -1.287212605368845e-09,  7.517226031206855e-11, -4.172829616216016e-12,  1.582529343613965e-13, -4.157071645479760e-15,  1.022286578604255e-16,
 -3.984334995817216e-18,  1.616997173083078e-19, -3.831789673785341e-21,  2.698966970384435e-23, -3.079413906707368e-25,  1.004333483078779e-10, -2.541767126886989e-12,
  2.109888247402975e-13, -1.418847191406254e-14,  7.094829117550595e-16, -2.983916448888583e-17,  1.237498801376696e-18, -5.287629215977341e-20,  2.094501717027005e-21,
 -7.107107748551455e-23,  2.178185428697592e-24, -7.045770950698302e-26,  1.716886262921753e-01, -1.215817460495314e-03,  1.197211355913373e-05, -8.390845581304298e-08,
 -7.352935704233579e-10,  2.191011550184292e-11,  8.927086537257643e-13, -4.870348230901422e-14,  1.723093185992473e-16,  4.904872903110335e-17, -1.276463877567268e-18,
 -2.539787676723489e-20,  9.490092371553406e-02, -6.802560230706738e-04,  7.506559700804618e-06, -1.011849179663581e-07,  1.608199174769166e-09, -2.194771064541574e-11,
 -7.949909332949359e-16,  8.577241312783270e-15, -2.248515082077116e-17, -1.067350202847396e-17,  2.873720799605751e-19,  4.728554662298836e-21,  2.836429698967252e-02,
 -2.085855059820531e-04,  2.816150933362701e-06, -6.577527406197675e-08,  1.805142334195511e-09, -3.019305233057243e-11, -2.480988066251033e-13,  2.346977606553621e-14,
 -5.177905397607966e-17, -2.741861767490983e-17,  7.046605274354445e-19,  1.392061840933742e-20,  4.365389938410829e-03, -3.348069359285891e-05,  5.843347396842376e-07,
 -1.960231757442845e-08,  6.400403368108371e-10, -1.171222229361615e-11, -6.817993848700065e-14,  8.105053176910414e-15, -1.933398065067867e-18, -1.065398089646847e-17,
  2.639193285227324e-19,  5.611392759797384e-21,  3.166962258730809e-04, -2.590815986256939e-06,  6.032908332939820e-08, -2.570875076551497e-09,  9.207408635927792e-11,
 -1.857473368353662e-12, -1.201893939132871e-15,  8.992427324956785e-16,  5.142549343845215e-18, -1.583897811971648e-18,  3.709232192488387e-20,  8.375917958601677e-22,
  9.247255449223418e-06, -8.355619422631152e-08,  2.654731924941428e-09, -1.340746830019619e-10,  5.176622860711822e-12, -1.188102122273294e-13,  8.064015621754201e-16,
  2.008529192839842e-17,  9.449578648659669e-19, -9.617636364576960e-20,  2.097577752324220e-21,  4.399728886563110e-23,  7.970240852409317e-08, -8.486892485138302e-10,
  3.789700511723377e-11, -2.201576195032491e-12,  9.311911345200719e-14, -2.577205987232869e-15,  4.397780094075314e-17, -7.826071634636761e-19,  4.721153022078064e-20,
 -2.337735283743236e-21,  5.114876944382403e-23,  3.269960031652786e-25,  9.278713362098397e-11, -1.378830863416294e-12,  9.326743287617120e-14, -6.389787500207389e-15,
  3.206835039991626e-16, -1.221391540754939e-17,  4.035153112832339e-19, -1.444222690368622e-20,  5.890665120792832e-22, -2.218734612958566e-23,  6.535003285329314e-25,
 -1.493520755611957e-26,  1.670103016258667e-01, -1.124229486445096e-03,  1.091165363928086e-05, -9.143869585714053e-08, -1.845330217688787e-10,  2.884664990463456e-11,
 -2.039870363260934e-13, -2.552857741712869e-14,  9.630999270134176e-16, -2.159353924599155e-18, -8.976568316095132e-19,  2.721157567683490e-20,  9.229288855314594e-02,
 -6.246559724444810e-04,  6.432450278354416e-06, -7.888993615560151e-08,  1.186884941885409e-09, -1.943753587136670e-11,  1.881980193168460e-13,  4.035776324957929e-15,
 -1.936813481305152e-16,  4.216409027937549e-19,  1.898786009746149e-19, -5.869059635834228e-21,  2.757064577595044e-02, -1.887694470409408e-04,  2.179746934403097e-06,
 -4.183698047966561e-08,  1.190888301381729e-09, -2.915189696679185e-11,  2.792049961093836e-13,  1.186326170437807e-14, -5.009005268529501e-16,  8.425278169449723e-19,
  4.963418395499144e-19, -1.495363339712438e-20,  4.239548771082891e-03, -2.959084699725421e-05,  4.027349148378324e-07, -1.125126817320615e-08,  4.065615854480717e-10,
 -1.090767499394351e-11,  1.160230635184156e-13,  4.120466881713707e-15, -1.811429911230429e-16,  1.296957720220448e-19,  1.921822346960930e-19, -5.676650709544786e-21,
  3.071345130851576e-04, -2.209332865006862e-06,  3.710962891376735e-08, -1.388123053198690e-09,  5.658876277765674e-11, -1.607074929169571e-12,  1.994877205347448e-14,
  4.661764041120759e-16, -2.275225998042644e-17, -3.864279766278280e-20,  2.806117378526091e-20, -8.025301829273788e-22,  8.947076350510723e-06, -6.751856653188888e-08,
  1.468376407820376e-09, -6.898895212071782e-11,  3.045875209656051e-12, -9.186082435881304e-14,  1.397587156169969e-15,  1.262113616377552e-17, -8.790998508785100e-19,
 -9.070427007219651e-21,  1.607424279027858e-21, -4.361980758543309e-23,  7.677771236794385e-08, -6.294327841723237e-10,  1.888747849887987e-11, -1.071910821036686e-12,
  5.095903246497902e-14, -1.677487776637154e-15,  3.339351462576167e-17, -2.252091252459194e-19, -1.099918164654624e-21, -4.740319573115119e-22,  3.316683386436580e-23,
 -8.469088938507716e-25,  8.838075744162547e-11, -8.678768448588418e-13,  4.071796954545714e-14, -2.793964032680692e-15,  1.489381874932218e-16, -5.837069781903941e-18,
  1.726498043312194e-19, -4.382155780800220e-21,  1.359083647814895e-22, -5.759507719848528e-24,  2.265093177479049e-25, -6.356386180167905e-27,  1.626810043892200e-01,
 -1.041334350486363e-03,  9.814331995478753e-06, -9.022503173505438e-08,  3.025206903237769e-10,  1.859356473495319e-11, -5.351171651561825e-13, -6.143218569083525e-16,
  5.126603251751476e-16, -1.634583371006823e-17,  6.958802843081149e-20,  1.231982474335301e-20,  8.989160722604084e-02, -5.766880635864943e-04,  5.587754065273003e-06,
 -6.273795572490147e-08,  8.490461467561387e-10, -1.421091611901259e-11,  2.243233578198418e-13, -9.373575716196931e-16, -1.000672818796993e-16,  3.402270503177718e-18,
 -1.474158697470124e-20, -2.572551520619969e-21,  2.684766672020088e-02, -1.730572374363523e-04,  1.774200719466219e-06, -2.700118323613667e-08,  6.929206994207335e-10,
 -2.014261247390553e-11,  4.115433299539092e-13, -1.095677162648038e-15, -2.636242207743140e-16,  8.753723659070746e-18, -3.566456576644803e-20, -6.788375787387793e-21,
  4.126909726484771e-03, -2.681389210626443e-05,  3.001204282706385e-07, -6.312293950713816e-09,  2.223863311135444e-10, -7.348296477820785e-12,  1.587351143241649e-13,
 -5.939773335681246e-16, -9.559424988814786e-17,  3.245862934505105e-18, -1.197721139314133e-20, -2.628985595283178e-21,  2.988041806066112e-04, -1.965951184592885e-06,
  2.491692243314841e-08, -7.108178214398368e-10,  2.988430207607451e-11, -1.049187291654379e-12,  2.374733658875400e-14, -1.353276553548322e-16, -1.213505990883177e-17,
  4.309524489865491e-19, -1.196935632594284e-21, -3.817166695467914e-22,  8.696253836910436e-06, -5.838197288203415e-08,  8.783778470681147e-10, -3.306751372582800e-11,
  1.556310476381515e-12, -5.720797242729926e-14,  1.374871469929363e-15, -1.202889409572280e-17, -4.963962090205938e-19,  1.947110394325907e-20, -6.316858268371823e-25,
 -2.134002711411388e-23,  7.449726475238954e-08, -5.182020906119246e-10,  9.944211468511732e-12, -4.837609697977230e-13,  2.485307714351840e-14, -9.640792310093673e-16,
  2.544270995202054e-17, -3.477609005751516e-19, -2.775370743811415e-21,  1.774730329970549e-22,  2.919481644280565e-24, -4.036977600836724e-25,  8.539551569730781e-11,
 -6.433199545818354e-13,  1.826826934764115e-14, -1.154561916218215e-15,  6.560952640622577e-17, -2.815472348538217e-18,  8.938145000560841e-20, -2.064673832811034e-21,
  3.694884353495303e-23, -9.201166547603603e-25,  4.642379018847025e-26, -2.134918727169164e-27,  1.586659870141743e-01, -9.670443984488462e-04,  8.770734824587953e-06,
 -8.308663031202171e-08,  5.519792984932073e-10,  6.893346080179645e-12, -4.028518268038215e-13,  7.630179252686272e-15,  5.406353939428018e-17, -8.086591969467202e-18,
  2.397442652573244e-19, -1.855341367281001e-21,  8.766979082128033e-02, -5.347862784377660e-04,  4.907938326742786e-06, -5.114850477475069e-08,  6.151212158296856e-10,
 -9.398966597580893e-12,  1.699250949482450e-13, -2.443258188555012e-15, -4.835399921118247e-18,  1.670397362369594e-18, -5.024574952742574e-20,  3.854436465642208e-22,
  2.618200286826437e-02, -1.599984532554883e-04,  1.505089125728171e-06, -1.862465687150766e-08,  3.825909209075703e-10, -1.131653677373356e-11,  3.057301017636282e-13,
 -5.160679177725037e-15, -1.819566351740319e-17,  4.301270516362905e-18, -1.300055520509997e-19,  1.001673903766309e-21,  4.024048656058642e-03, -2.466530303960860e-05,
  2.415150735212269e-07, -3.733408008181346e-09,  1.108153438326243e-10, -3.983461436761488e-12,  1.152365517020086e-13, -2.029592481750939e-15, -4.481944923687126e-18,
  1.588489392943912e-18, -4.892235777019503e-20,  3.746391980787216e-22,  2.912946400083429e-04, -1.794009096497949e-06,  1.865881041633436e-08, -3.714749839073623e-10,
  1.412380011169764e-11, -5.552131522204841e-13,  1.664972929012930e-14, -3.071161690952642e-16,  1.343087458333069e-20,  2.100596863914939e-19, -6.688489977022518e-21,
  4.999338697059675e-23,  8.474763694433595e-06, -5.259485420583228e-08,  5.986505945517402e-10, -1.566579323092540e-11,  7.081947743471779e-13, -2.943497655403363e-14,
  9.132060539411649e-16, -1.797407642554686e-17,  6.182103852428770e-20,  9.533848097527366e-21, -3.238946007747962e-22,  2.203107817551389e-24,  7.255466043479322e-08,
 -4.563756366860306e-10,  5.986842712347806e-12, -2.106003787632617e-13,  1.086292841282426e-14, -4.742982020440898e-16,  1.543211244618341e-17, -3.365156234249671e-19,
  2.924825487540879e-21,  9.616946536322112e-23, -3.938337269154165e-24,  1.317278593700863e-26,  8.304717860347241e-11, -5.383581414996505e-13,  9.182797730955370e-15,
 -4.562797530643357e-16,  2.666422300220774e-17, -1.251884137405466e-18,  4.487102011729651e-20, -1.190600425654505e-21,  2.155092218381966e-23, -2.159040593881125e-25,
  2.285044533298554e-27, -2.609185162443927e-28,  1.549320485136469e-01, -9.007091099861876e-04,  7.829733894901421e-06, -7.360402471910165e-08,  6.105599848968868e-10,
 -2.240299963652893e-13, -1.968366149771138e-13,  6.324924517643244e-15, -9.370084335616404e-17, -1.048221294090187e-18,  1.050548444020206e-19, -3.028737598641385e-21,
  8.560550447896551e-02, -4.978235485832702e-04,  4.347659334699717e-06, -4.261180807908882e-08,  4.624810291344749e-10, -6.116375860576304e-12,  1.058888874251774e-13,
 -1.976229106142928e-15,  2.521590377349761e-17,  1.922532923271541e-19, -2.213979886615389e-20,  6.347911142212925e-22,  2.556480220979747e-02, -1.487625134134809e-04,
  1.312010701810043e-06, -1.396398707508108e-08,  2.180765877448444e-10, -5.668702392810280e-12,  1.698979374510889e-13, -4.145081885690793e-15,  5.895051948645597e-17,
  4.888574448605200e-19, -5.666374742646672e-20,  1.651785334105174e-21,  3.929003630040990e-03, -2.288741798255406e-05,  2.051578544026271e-07, -2.466508658212191e-09,
  5.429451980611846e-11, -1.875502885385288e-12,  6.256687614910242e-14, -1.588883889839811e-15,  2.349470588029319e-17,  1.570761044041415e-19, -2.111520023232808e-20,
  6.267865215241232e-22,  2.843933836765936e-04, -1.659444859732528e-06,  1.525305744769551e-08, -2.154674087755924e-10,  6.342582899178660e-12, -2.534714141495412e-13,
  8.861091036859244e-15, -2.309130073944451e-16,  3.585572117720250e-18,  1.487791255957464e-20, -2.844560538644188e-21,  8.703441006704008e-23,  8.272993788843326e-06,
 -4.840280465257867e-08,  4.626274045641601e-10, -8.017306403979729e-12,  3.000971861827625e-13, -1.309897863924383e-14,  4.731025661602764e-16, -1.269825272192061e-17,
  2.115939349061349e-19,  9.570351663123914e-23, -1.346906947552300e-22,  4.358886483118930e-24,  7.081230896196051e-08, -4.162402102845950e-10,  4.246401167067613e-12,
 -9.554029499554680e-14,  4.381948748248618e-15, -2.042372852144111e-16,  7.641384567960092e-18, -2.146467168742346e-19,  3.994575772870351e-21, -2.021274285381002e-23,
 -1.587653192778399e-24,  5.901276498716262e-26,  8.101414049122168e-11, -4.811181232496756e-13,  5.602708895470835e-15, -1.814631134419385e-16,  1.006868726163002e-17,
 -5.039947740263786e-19,  2.006951495551642e-20, -6.197250685871342e-22,  1.415398194689399e-23, -2.037526860097238e-25,  4.141369751193005e-28,  4.696668857877232e-29,
  1.514491261496588e-01, -8.414398944499928e-04,  7.004269418957759e-06, -6.407367632813109e-08,  5.713710113559414e-10, -3.173488516155655e-12, -6.295800309001903e-14,
  3.305735942056314e-15, -8.289974623328782e-17,  1.044763512603931e-18,  1.361940343384368e-20, -1.153972951611658e-21,  8.368070069631077e-02, -4.649703322678372e-04,
  3.877078902993376e-06, -3.606979407713355e-08,  3.615648781328070e-10, -4.146360234769504e-12,  6.195668981623620e-14, -1.181607223867471e-15,  2.189229176007838e-17,
 -2.496633731912557e-19, -2.868747601431969e-21,  2.455192268434188e-22,  2.498975703887995e-02, -1.388847394115723e-04,  1.162256118486060e-06, -1.119575277539111e-08,
  1.372011124041739e-10, -2.766917424804277e-12,  8.050874845701218e-14, -2.290219682177625e-15,  5.052570340552256e-17, -6.281604696744436e-19, -6.858217187335529e-21,
  6.264839161347008e-22,  3.840566703347088e-03, -2.135216895626165e-05,  1.797608735273390e-07, -1.829867838319677e-09,  2.864088215089842e-11, -8.221978722720769e-13,
  2.857072634127259e-14, -8.624897063007239e-16,  1.954174865873349e-17, -2.525132793191190e-19, -2.300342112942443e-21,  2.343954623156701e-22,  2.779852876173926e-04,
 -1.546357822934275e-06,  1.314103048746778e-08, -1.449516907633051e-10,  2.942900345058160e-12, -1.055488789925856e-13,  3.964498199882898e-15, -1.230392844226031e-16,
  2.847888909935581e-18, -3.873429168053437e-20, -2.491852003768824e-22,  3.183915250329873e-23,  8.086268663172301e-06, -4.502143706273766e-08,  3.882844284659295e-10,
 -4.802040673466735e-12,  1.267223067247642e-13, -5.271605982584481e-15,  2.073827121801400e-16, -6.586080218838329e-18,  1.567128678801245e-19, -2.295816272248011e-21,
 -6.040365443051141e-24,  1.535532744929285e-24,  6.920937324163272e-08, -3.859178780833866e-10,  3.413081767426048e-12, -4.993827772429748e-14,  1.714887752440327e-15,
 -7.951806605550266e-17,  3.250184214521267e-18, -1.063202892677675e-19,  2.644797958666334e-21, -4.346433537061460e-23,  1.256351099083488e-25,  1.922532109171525e-26,
  7.916855908648090e-11, -4.428898886631994e-13,  4.129793235975310e-15, -7.989651721020525e-17,  3.636416942488282e-18, -1.859401901256814e-19,  8.000533709969125e-21,
 -2.772017982423097e-22,  7.562991865638601e-24, -1.529279371231228e-25,  1.816666049126685e-27,  8.698552421005028e-30,  1.481907778243962e-01, -7.883310837774330e-04,
  6.287950503639804e-06, -5.549505246401384e-08,  4.988940983609441e-10, -3.837004025779309e-12, -1.586425380480158e-15,  1.284820979684437e-15, -4.412385409370897e-17,
  9.527253054761784e-19, -1.086036026968704e-20, -1.361288512749480e-22,  8.188024245648737e-02, -4.355925335299284e-04,  3.476449161083268e-06, -3.087731745467773e-08,
  2.911997924488542e-10, -2.985927564192351e-12,  3.726724109268544e-14, -6.309756370943457e-16,  1.268656970851910e-17, -2.280274593420649e-19,  2.394823924280673e-21,
  3.051164777409751e-23,  2.445201118421258e-02, -1.300903873956658e-04,  1.039540030415016e-06, -9.357051551339564e-09,  9.684286626773502e-11, -1.443225829183935e-12,
  3.548694134583398e-14, -1.047511616161347e-15,  2.765196138521323e-17, -5.581660334284712e-19,  6.337390338395704e-21,  7.051732738055825e-23,  3.757904742855693e-03,
 -1.999516897891471e-05,  1.601104006031219e-07, -1.472959243809385e-09,  1.742633942634484e-11, -3.642650903286455e-13,  1.177409725223142e-14, -3.852320467734762e-16,
  1.053343403132586e-17, -2.169031544397045e-19,  2.558340984166774e-21,  2.379378824912816e-23,  2.720000510847431e-04, -1.447518759376698e-06,  1.162842139692720e-08,
 -1.105861907600236e-10,  1.552031702633546e-12, -4.274694856467120e-14,  1.584254933207252e-15, -5.410508439878553e-17,  1.507492990044425e-18, -3.163964309381756e-20,
  3.928988288000108e-22,  2.636056769910717e-24,  7.912070486706996e-06, -4.211772028117111e-08,  3.400731051991436e-10, -3.400991078597714e-12,  5.873186194711291e-14,
 -2.016112714251986e-15,  8.100931692602578e-17, -2.843774004131654e-18,  8.072682931871754e-20, -1.739736514939868e-21,  2.327525918979382e-23,  7.176531112543799e-26,
  6.771704420846101e-08, -3.606415325834683e-10,  2.937307883064985e-12, -3.184274853007131e-14,  7.069570920230498e-16, -2.905339205118414e-17,  1.236843678004592e-18,
 -4.459847404355564e-20,  1.300467387199177e-21, -2.926625212946301e-23,  4.389480846365969e-25, -9.263760119767468e-28,  7.745809938621101e-11, -4.129236332345238e-13,
  3.425046517506163e-15, -4.323868731044610e-17,  1.330646458181584e-18, -6.429915265992834e-20,  2.900456078942868e-21, -1.091605284585893e-22,  3.360700836982581e-24,
 -8.268871573913391e-26,  1.518818169695155e-27, -1.578358421322473e-29,  1.451340270041136e-01, -7.405613383745786e-04,  5.667391918133437e-06, -4.811900017543919e-08,
  4.239857070710540e-10, -3.574387011837904e-12,  1.914792318249130e-14,  3.332316250017415e-16, -1.804778664680261e-17,  5.049694338503799e-19, -9.826463642771355e-21,
  1.062815420310797e-22,  8.019125503471210e-02, -4.091880948045093e-04,  3.132048611922027e-06, -2.665254459325711e-08,  2.392017535276480e-10, -2.264536034269327e-12,
  2.418862972017863e-14, -3.367771952890802e-16,  6.301084156338955e-18, -1.283575061666843e-19,  2.217620454647619e-21, -2.227485371537655e-23,  2.394760576077643e-02,
 -1.221988004001090e-04,  9.357262944500276e-07, -8.000600168874370e-09,  7.456406070087917e-11, -8.602568855863638e-13,  1.588811017007802e-14, -4.330539525939055e-16,
  1.230271624967874e-17, -3.004659214667983e-19,  5.626648668212809e-21, -6.079429826628136e-23,  3.680379956588932e-03, -1.878071750993184e-05,  1.439085788013239e-07,
 -1.240134210022121e-09,  1.226199757113806e-11, -1.795223599514366e-13,  4.678005300565301e-15, -1.527517311011526e-16,  4.608523731214958e-18, -1.151375797792019e-19,
  2.191442600362839e-21, -2.455071075109503e-23,  2.663881507666245e-04, -1.359431128718018e-06,  1.042766253234863e-08, -9.095673123305731e-11,  9.787111912188120e-13,
 -1.839527252535412e-14,  5.953790703526799e-16, -2.102574762017108e-17,  6.508895649747878e-19, -1.649710314533181e-20,  3.195709389188490e-22, -3.760515992741119e-24,
  7.748801535932896e-06, -3.954690158564699e-08,  3.038482000614216e-10, -2.700722236241531e-12,  3.268855805512164e-14, -7.869659884266411e-16,  2.940298201037874e-17,
 -1.086109688495250e-18,  3.426179736049499e-20, -8.827346734415154e-22,  1.753887602241271e-23, -2.215938652321482e-25,  6.631927919571475e-08, -3.385147157884848e-10,
  2.608130672289432e-12, -2.391841714863268e-14,  3.421825244197093e-16, -1.050835237329886e-17,  4.354151756061456e-19, -1.664718325671993e-20,  5.365759313969221e-22,
 -1.417641141481583e-23,  2.936713360912285e-25, -4.136296127971733e-27,  7.585832716026211e-11, -3.873143262423837e-13,  3.001356154658789e-15, -2.930597286081089e-17,
  5.457443384418747e-19, -2.157999354003707e-20,  9.774890343491933e-22, -3.893048884470723e-23,  1.303879526459068e-24, -3.627157296066239e-26,  8.181097023624796e-28,
 -1.395032730002669e-29,  1.422589587433931e-01, -6.974218501203720e-04,  5.128394590147189e-06, -4.187997329601686e-08,  3.575741192234378e-10, -3.053811508346403e-12,
  2.264014528740730e-14, -1.977204776768494e-17, -5.771247294569276e-18,  2.086388446862787e-19, -5.116515855454598e-21,  9.214823486716647e-23,  7.860267739575112e-02,
 -3.853492167665808e-04,  2.833781142734877e-06, -2.315894558786530e-08,  1.990541989772853e-10, -1.778088615553703e-12,  1.699749338537385e-14, -1.939721736490977e-16,
  3.028208296674372e-18, -6.022863833015757e-20,  1.209874907498205e-21, -2.007202724444142e-23,  2.347320119091950e-02, -1.150779280327024e-04,  8.463669956121769e-07,
 -6.927934322348785e-09,  6.038262855009373e-11, -5.885373830790619e-13,  7.926422094437445e-15, -1.744153965300068e-16,  4.870544087161075e-18, -1.303182813564851e-19,
  2.957383764451734e-21, -5.203705462202274e-23,  3.607469764844615e-03, -1.768587945558903e-05,  1.301020476765174e-07, -1.067763626472093e-09,  9.519732703700695e-12,
 -1.051890649631376e-13,  1.950530916722575e-15, -5.684295795198413e-17,  1.775837570614031e-18, -4.929448257427545e-20,  1.136673000803968e-21, -2.028151976153045e-23,
  2.611107004228411e-04, -1.280133302603766e-06,  9.420053334620059e-09, -7.762826838130899e-11,  7.161405900212942e-13, -9.285868841927482e-15,  2.246703407839604e-16,
 -7.558480251987035e-18,  2.471685221454348e-19, -6.979277159287409e-21,  1.628676722462213e-22, -2.954077482224262e-24,  7.595281481827197e-06, -3.723784990351708e-08,
  2.741588174038352e-10, -2.273721452247948e-12,  2.207445457372675e-14, -3.473279856547634e-16,  1.041983926074885e-17, -3.815600792337212e-19,  1.282154601091243e-20,
 -3.673308045439460e-22,  8.701466851938879e-24, -1.616741003760522e-25,  6.500524679714634e-08, -3.187176284177047e-10,  2.348502172741654e-12, -1.968593683572981e-14,
  2.070533719719826e-16, -4.110616841617173e-18,  1.471392023954742e-19, -5.714091042430114e-21,  1.965826299418035e-22, -5.738614885609885e-24,  1.392105516975244e-25,
 -2.691213758040453e-27,  7.435503916195672e-11, -3.645877845563939e-13,  2.691123925257628e-15, -2.305146563125379e-17,  2.804273957235551e-19, -7.494343886794961e-21,
  3.139303433494929e-22, -1.286457875920518e-23,  4.573419439414621e-25, -1.383248279895876e-26,  3.523627021051156e-28, -7.379446518102564e-30,  1.395482742059852e-01,
 -6.583121241321519e-04,  4.658240893035261e-06, -3.661836169647480e-08,  3.018037225664822e-10, -2.532251528857903e-12,  2.039032945738519e-14, -1.166897889675160e-16,
 -1.095356959990027e-18,  7.103100945965988e-20, -2.099013338541157e-21,  4.669924557958285e-23,  7.710493399170416e-02, -3.637390214105036e-04,  2.573876636363984e-06,
 -2.023808015989632e-08,  1.671810734079249e-10, -1.426082500057829e-12,  1.265439321970250e-14, -1.239743903729380e-16,  1.544727850683986e-18, -2.659371948538495e-20,
  5.419829428874922e-22, -1.057264395144982e-23,  2.302592691108159e-02, -1.086239433917847e-04,  7.686696819491551e-07, -6.047034091007855e-09,  5.019391467847099e-11,
 -4.429156916760041e-13,  4.658685656734274e-15, -7.479332250543012e-17,  1.828808737491870e-18, -4.992275388194066e-20,  1.250385273555895e-21, -2.653275382271617e-23,
  3.538730192551191e-03, -1.669387200526265e-05,  1.181403520500756e-07, -9.301785158267575e-10,  7.782401208648467e-12, -7.241983799479151e-14,  9.411082226121257e-16,
 -2.119040644131419e-17,  6.333555366963896e-19, -1.853511041167119e-20,  4.754495540528533e-22, -1.021167395420719e-23,  2.561352467356399e-04, -1.208316754726743e-06,
  8.551920356081623e-09, -6.742124296726607e-11,  5.709803567707130e-13, -5.732640508588415e-15,  9.362488798803039e-17, -2.637513636127151e-18,  8.617490077199284e-20,
 -2.593913841504964e-21,  6.737152802512442e-23, -1.462181193692442e-24,  7.450551693689477e-06, -3.514816852886655e-08,  2.487998686369725e-10, -1.965448950891899e-12,
  1.695876173635280e-14, -1.892246198670366e-16,  3.898634183600082e-18, -1.279554162163849e-19,  4.395471843188360e-21, -1.347417030900836e-22,  3.542323978070237e-24,
 -7.795929407272241e-26,  6.376652875191610e-08, -3.008234446455189e-10,  2.129934061432547e-12, -1.688263053263120e-14,  1.501816401238272e-16, -1.946021229015483e-18,
  5.062198628125320e-20, -1.856499446716397e-21,  6.609462286329768e-23, -2.063044358689411e-24,  5.516892615170241e-26, -1.241800295922564e-27,  7.293808949238356e-11,
 -3.440982240945919e-13,  2.437532984300311e-15, -1.945212595817289e-17,  1.836097906048269e-19, -3.005634872332445e-21,  9.992095995761928e-23, -4.020430258871417e-24,
  1.485116773826029e-25, -4.769305505712297e-27,  1.318421137839758e-28, -3.107546779019044e-30,  1.369868855968953e-01, -6.227254697271577e-04,  4.246205401823570e-06,
 -3.216923025347015e-08,  2.557754522541765e-10, -2.084180671652376e-12,  1.692145187320026e-14, -1.236176914598825e-16,  3.553441441559142e-19,  1.853548969253167e-20,
 -7.278642762761951e-22,  1.885445259110213e-23,  7.568968330616228e-02, -3.440760288393726e-04,  2.346178290225527e-06, -1.777594462140090e-08,  1.414408972524535e-10,
 -1.159201829659074e-12,  9.756428906184903e-15, -8.645720907797256e-17,  8.848453617850540e-19, -1.214975141252679e-20,  2.239555078046675e-22, -4.550058935790113e-24,
  2.260328871060152e-02, -1.027518277077001e-04,  7.006495431339653e-07, -5.309334382125211e-09,  4.231227749515690e-11, -3.509904830479406e-13,  3.170878783442180e-15,
 -3.731868744490407e-17,  7.010921270273942e-19, -1.786292197397992e-20,  4.658741568386804e-22, -1.092659888392957e-23,  3.473777108901917e-03, -1.579138390769813e-05,
  1.076810315795503e-07, -8.161873578754937e-10,  6.521445489095807e-12, -5.516760276981032e-14,  5.529423365879201e-16, -8.675938316277068e-18,  2.197847750056660e-19,
 -6.408778833199489e-21,  1.747283326257679e-22, -4.166173197266553e-24,  2.514338950665612e-04, -1.142990330539514e-06,  7.794234286680971e-09, -5.910114053687612e-11,
  4.741186691578708e-13, -4.130683657047458e-15,  4.741692719380261e-17, -9.606591960479354e-19,  2.864320356801185e-20, -8.826154728026544e-22,  2.451564201171105e-23,
 -5.903022461025338e-25,  7.313796611721735e-06, -3.324775799806403e-08,  2.267313537717726e-10, -1.720282052985802e-12,  1.388594458321027e-14, -1.264072841078818e-16,
  1.717101762234895e-18, -4.323863384191484e-20,  1.422921428514341e-21, -4.523311462909310e-23,  1.273405561451865e-24, -3.099023717707161e-26,  6.259608505925135e-08,
 -2.845560910264755e-10,  1.940649793323085e-12, -1.473919880855971e-14,  1.201917905198732e-16, -1.171602021065748e-18,  1.958738926112434e-20, -5.937741520687926e-22,
  2.090634321962517e-23, -6.806877441885357e-25,  1.945339925316187e-26, -4.809606838408761e-28,  7.159928411927204e-11, -3.254855993147972e-13,  2.220087236526490e-15,
 -1.689530805289322e-17,  1.405756625453914e-19, -1.549401956633092e-21,  3.400319876923786e-23, -1.219779480883879e-24,  4.547565386485895e-26, -1.523148245069763e-27,
  4.466274421705837e-29, -1.139176698187543e-30,  1.345615723575917e-01, -5.902334089643996e-04,  3.883421853063061e-06, -2.838937386910105e-08,  2.178812613079270e-10,
 -1.717866011034765e-12,  1.368757850179398e-14, -1.058512582123612e-16,  6.562764133478050e-19,  1.554069984782979e-21, -2.099529764983268e-22,  6.536791815386580e-24,
  7.434961916131860e-02, -3.261230591344934e-04,  2.145719298300240e-06, -1.568641032062652e-08,  1.204173370294102e-10, -9.512483905272612e-13,  7.676657163337261e-15,
 -6.373994586945607e-17,  5.698277883212585e-19, -6.203786324226031e-21,  9.328942560806089e-23, -1.784109540795342e-24,  2.220310385945993e-02, -9.739047871695854e-05,
  6.407803739523708e-07, -4.684677768386965e-09,  3.597982273879005e-11, -2.853791683947185e-13,  2.364366758165537e-15, -2.235639901430816e-17,  3.013636351107168e-19,
 -6.331384451254787e-21,  1.608390285825230e-22, -3.969174683170965e-24,  3.412274838676903e-03, -1.496741834549320e-05,  9.847857068248824e-08, -7.200206254225430e-10,
  5.534475742446019e-12, -4.419002227663011e-14,  3.816436661641625e-16, -4.282334611501887e-18,  7.983327717232863e-20, -2.120606080729486e-21,  5.890828501432253e-23,
 -1.497221453385760e-24,  2.469823240483461e-04, -1.083350266600825e-06,  7.127988824115554e-09, -5.212192000832308e-11,  4.011380632132958e-13, -3.235568529507578e-15,
  2.967298615436273e-17, -4.052109160812595e-19,  9.565100790881061e-21, -2.837335288153805e-22,  8.165281357345503e-24, -2.102862408624289e-25,  7.184307635049322e-06,
 -3.151288304663294e-08,  2.073439061916838e-10, -1.516428348737811e-12,  1.169313809184672e-14, -9.579006489423185e-17,  9.560616296341186e-19, -1.612930372458875e-20,
  4.519255559784060e-22, -1.426997412687340e-23,  4.192645523061233e-25, -1.091366025880205e-26,  6.148783489886388e-08, -2.697073203527173e-10,  1.774614588035848e-12,
 -1.298258160909426e-14,  1.004253231541213e-16, -8.435732449540646e-19,  9.511696364656655e-21, -2.006967278570548e-22,  6.398772135140372e-24, -2.108094243792362e-25,
  6.303668477356269e-27, -1.662669455644151e-28,  7.033163025506361e-11, -3.084997542118119e-13,  2.029934016614444e-15, -1.485886017793374e-17,  1.156548652996954e-19,
 -1.019153205505838e-21,  1.395997298314193e-23, -3.770942099925727e-25,  1.338873498143574e-26, -4.583688810588229e-28,  1.403255376816744e-29, -3.789863676657126e-31,
  1.322606962429511e-01, -5.604719604064331e-04,  3.562587342338977e-06, -2.516124846751811e-08,  1.865812007930080e-10, -1.422551476852941e-12,  1.101731756405464e-14,
 -8.512338277172597e-17,  6.141382689582495e-19, -2.796675567322426e-21, -4.040852505083597e-23,  1.958379200848971e-24,  7.307831067874601e-02, -3.096788826592508e-04,
  1.968445466997211e-06, -1.390249446010933e-08,  1.031000609463482e-10, -7.865486695941383e-13,  6.118020578967837e-15, -4.848650170282168e-17,  3.985446209153408e-19,
 -3.641590683635060e-21,  4.267824316323115e-23, -6.900532138064842e-25,  2.182345166344633e-02, -9.247972847708509e-05,  5.878394010910132e-07, -4.151773684921818e-09,
  3.079385920306147e-11, -2.352298589484245e-13,  1.846321904998621e-15, -1.539674481752159e-17,  1.564382041254549e-19, -2.414110591719445e-21,  5.394707037986613e-23,
 -1.331373459826383e-24,  3.353928141388241e-03, -1.421270951221880e-05,  9.034197891561025e-08, -6.380780939023821e-10,  4.733800310841769e-12, -3.623777552260778e-14,
  2.886429322085398e-16, -2.599269022335502e-18,  3.357036685797892e-20, -7.096374355628910e-22,  1.883769779173278e-23, -4.936277435404102e-25,  2.427591573860483e-04,
 -1.028723782275209e-06,  6.539015634105354e-09, -4.618604558676980e-11,  3.427748472209413e-13, -2.632548182260528e-15,  2.143825638003045e-17, -2.142325763038574e-19,
  3.500562589735609e-21, -8.956494116244525e-23,  2.558635360269142e-24, -6.865302658868540e-26,  7.061462664403583e-06, -2.992387798644202e-08,  1.902097641632517e-10,
 -1.343547100106132e-12,  9.976998094397544e-15, -7.700869705101015e-17,  6.481992664420656e-19, -7.412538668411698e-21,  1.505335044637820e-22, -4.353533005916990e-24,
  1.295007384547522e-25, -3.526584148857077e-27,  6.043644973910535e-08, -2.561074615876123e-10,  1.627943474193548e-12, -1.149991443816269e-14,  8.547665704643769e-17,
 -6.651632786174108e-19,  5.895711628837780e-21, -8.027588627218623e-23,  1.988639427925467e-24, -6.263714147704052e-26,  1.916701391239001e-27, -5.292875810249311e-29,
  6.912902340897677e-11, -2.929434949510047e-13,  1.862108815133099e-15, -1.315612477581961e-17,  9.796431477274316e-20, -7.744636173994452e-22,  7.534212113087070e-24,
 -1.305890016524732e-25,  3.912341805917892e-27, -1.320477919295402e-28,  4.156163350100746e-30, -1.171532897758507e-31,  1.300739664531664e-01, -5.331303243124759e-04,
  3.277669688361974e-06, -2.238996260286451e-08,  1.605923206227402e-10, -1.184617306358449e-12,  8.892427213825282e-15, -6.726229045178478e-17,  4.996733746664236e-19,
 -3.260146268371125e-21,  6.554469494497137e-24,  4.624184669466332e-25,  7.187007176279857e-02, -2.945717413543154e-04,  1.811018657736111e-06, -1.237120048313277e-08,
  8.873441777705751e-11, -6.546771450979049e-13,  4.921291228337557e-15, -3.755097234109315e-17,  2.922737062709262e-19, -2.392869104843636e-21,  2.265104207647301e-23,
 -2.863966959593384e-25,  2.146263401745881e-02, -8.796826507243419e-05,  5.408264965248037e-07, -3.694438412973234e-09,  2.650008853966442e-11, -1.955935889007891e-13,
  1.474648033376666e-15, -1.145739676330635e-17,  9.749516256007507e-20, -1.088233298786112e-21,  1.880063684015368e-23, -4.288098100439866e-25,  3.298476029165787e-03,
 -1.351936658664870e-05,  8.311672598915175e-08, -5.677817622368532e-10,  4.072967169857027e-12, -3.008160817001037e-14,  2.278947926279641e-16, -1.822526063978742e-18,
  1.757628576170774e-20, -2.623043599571333e-22,  5.958908401483906e-24, -1.536883274222768e-25,  2.387455029349535e-04, -9.785391817951310e-07,  6.016037450191625e-09,
 -4.109674424542049e-11,  2.948381277654191e-13, -2.179751228950653e-15,  1.663572231874669e-17, -1.387954808052151e-19,  1.562167674226058e-21, -2.965338298388763e-23,
  7.770849326213398e-25, -2.105616423486485e-26,  6.944712082477943e-06, -2.846408826822039e-08,  1.749967303545572e-10, -1.195453599970014e-12,  8.577888344099445e-15,
 -6.351363206196045e-17,  4.901983012238015e-19, -4.346602618256669e-21,  5.853669537308904e-23, -1.346810855771133e-24,  3.839193234709905e-26, -1.069028172370392e-27,
  5.943722454371945e-08, -2.436136244837820e-10,  1.497734329804347e-12, -1.023168316049182e-14,  7.343623346812516e-17, -5.450978057529527e-19,  4.283603781617189e-21,
 -4.156347488157437e-23,  6.870786815245015e-25, -1.846436742909668e-26,  5.568804376056584e-28, -1.582221507334923e-29,  6.798607944491920e-11, -2.786525907845845e-13,
  1.713157683089648e-15, -1.170382069293886e-17,  8.404504166521626e-20, -6.268289102139619e-22,  5.096501092329727e-24, -5.739362969108929e-26,  1.211742021747508e-27,
 -3.723423425845379e-29,  1.176332192551302e-30, -3.417461153685878e-32,  1.279922456184258e-01, -5.079417322327842e-04,  3.023661039740963e-06, -1.999903771177413e-08,
  1.388904929974402e-10, -9.920982267590056e-13,  7.215828673232110e-15, -5.307119523127412e-17,  3.903148140148149e-19, -2.759076500034758e-21,  1.545978672923139e-23,
  3.466291396655707e-26,  7.071985369715578e-02, -2.806542290710130e-04,  1.670670523550886e-06, -1.105012021162055e-08,  7.674196440668789e-11, -5.482003087081735e-13,
  3.988973894299864e-15, -2.942278962096409e-17,  2.199200583784314e-19, -1.684334100378525e-21,  1.384448679769415e-23, -1.372881710445338e-25,  2.111914320296463e-02,
 -8.381206344624711e-05,  4.989140975313132e-07, -3.299912180257819e-09,  2.291783164933179e-11, -1.637309660308233e-13,  1.192486057959679e-15, -8.849015322010994e-18,
  6.835766563932408e-20, -6.038033254903718e-22,  7.482158799442836e-24, -1.398983228488946e-25,  3.245686785089126e-03, -1.288062233141331e-05,  7.667541358629837e-08,
 -5.071464748671249e-10,  3.522192792025875e-12, -2.516830326831695e-14,  1.835833485989584e-16, -1.375743563856051e-18,  1.118474410310476e-20, -1.183666175766897e-22,
  2.000865719620704e-24, -4.669871300592834e-26,  2.349245884740173e-04, -9.323065084162271e-07,  5.549809223386232e-09, -3.670763195473445e-11,  2.549465538548129e-13,
 -1.822290075615506e-15,  1.332294557202581e-17, -1.013305105515213e-19,  8.852039259229577e-22, -1.142376266043404e-23,  2.401898983078299e-25, -6.214445556738046e-27,
  6.833567994242244e-06, -2.711925559200320e-08,  1.614348110679893e-10, -1.067768405803920e-12,  7.416341345922604e-15, -5.303378143084217e-17,  3.891042603536812e-19,
 -3.025888500087241e-21,  2.914314687346294e-23, -4.610321442538965e-25,  1.130648728057477e-26, -3.098834851660353e-28,  5.848598333778672e-08, -2.321036900457880e-10,
  1.381661351574533e-12, -9.138690827485145e-15,  6.347877721871003e-17, -4.542609491744947e-19,  3.351894340999615e-21, -2.699223059488030e-23,  2.971546730110455e-25,
 -5.769084200420025e-27,  1.584384113952137e-28, -4.512123551433261e-30,  6.689802118287712e-11, -2.654871645034021e-13,  1.580386647029041e-15, -1.045322754133728e-17,
  7.261982710223815e-20, -5.203902821572211e-22,  3.881657155351792e-24, -3.330471831361262e-26,  4.470691160647841e-28, -1.074563453644504e-29,  3.235149308680949e-31,
 -9.522937932561380e-33  };
  int offset = -8;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 8;
    if (std::isnan(t)) {
      fill_n(rr+offset, 8, 0.5);
      fill_n(ww+offset, 8, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 8; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=8; ++j) {
        const int boxof = it*96+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
