/*
 * Decompiled with CFR 0.152.
 */
package yuku.snappy.codec;

import yuku.snappy.codec.Snappy;

class SnappyImplNative
extends Snappy {
    private long nativeObj = SnappyImplNative.nativeSetup();

    @Override
    public String getImplementationName() {
        return "native";
    }

    private static native long nativeSetup();

    private static native int nativeCompress(long var0, byte[] var2, int var3, byte[] var4, int var5, int var6);

    private static native int nativeDecompress(long var0, byte[] var2, int var3, byte[] var4, int var5, int var6);

    @Override
    public int compress(byte[] in, int inOffset, byte[] out, int outOffset, int len) {
        int ret = SnappyImplNative.nativeCompress(this.nativeObj, in, inOffset, out, outOffset, len);
        if (ret == -2) {
            throw new IllegalArgumentException("SNAPPY_BUFFER_TOO_SMALL");
        }
        return ret;
    }

    @Override
    public int decompress(byte[] in, int inOffset, byte[] out, int outOffset, int len) {
        int ret = SnappyImplNative.nativeDecompress(this.nativeObj, in, inOffset, out, outOffset, len);
        if (ret == -1) {
            throw new IllegalArgumentException("SNAPPY_INVALID_INPUT");
        }
        if (ret == -2) {
            throw new IllegalArgumentException("SNAPPY_BUFFER_TOO_SMALL");
        }
        int res = this.uncompressedLength(in, inOffset, len);
        return res;
    }

    static {
        System.loadLibrary("snappy");
    }
}

