#include "Bdef.h"

void cgpk4amxamn(MatInf)
MATINFO  *MatInf;
/*
 * Packs the distance and max/min matrices for the max or min operation
 */
{
   int m, n, lda, ldd, i, j;
   SCOMPLEX *A;
   unsigned short *Ad;

   m = MatInf->M;
   n = MatInf->N;
   A = (SCOMPLEX *) MatInf->A;
   lda = MatInf->lda;
   Ad = (unsigned short *) MatInf->B;
   ldd = (MatInf->ldb) * (sizeof(int) / sizeof(short));
   j = pvm_initsend(PvmDataDefault);
   Mpvmerror(j, "pvm_initsend", __LINE__, __FILE__);

   for (j=0; j < n; j++)
   {
/*
 *    Pack in column of max/min's
 */
      i = pvm_pkcplx((float *) A, m, 1);
      Mpvmerror(i, "pvm_pkcplx", __LINE__, __FILE__);
/*
 *    Pack in corresponding column of distances
 */
      i = pvm_pkshort((short *) Ad, m, 1);
      Mpvmerror(i, "pvm_pkshort", __LINE__, __FILE__);
/*
 *    Update pointers to max/min and distance
 */
      A += lda;
      Ad += ldd;
   }
}
