# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from threading import Thread
from gobject import timeout_add, idle_add
from gtk.gdk import threads_enter, threads_leave
from time import sleep

from modules.explorer.playlist import Playlist
from modules.explorer.musicdb import MusicDatabase

class LightweightView(object):
    ref = None
    ref2 = None

    def __new__(cls, *args, **kws):
        # Singleton
        if cls.ref is None:
            cls.ref = super(LightweightView, cls).__new__(cls, args, kws)
        return cls.ref

    def __init__(self, glade_file, config, userconf):
        self.config = config
        self.glade_file = glade_file

        # Start the playlist
        self.playlist = Playlist(glade_file, config, userconf)

        # Add all songs to the playlist
        self.reload_database()

    def reload_database(self, force_scan=False):
        pbar = self.glade_file.get_widget('progressbar1')
        pbar.set_text(_('Opening folder…'))
        pbar.show()

        thread = Thread(group=None, target=self.add_songs_to_playlist,
                        name='artists', args=(pbar, force_scan))
        self.thread_name = thread

        thread.start()

    def timeout_progress(self, pbar):
        if self.thread_name.isAlive():
            pbar.pulse()
            return True
        else:
            pbar.hide()

    def add_songs_to_playlist(self, pbar, force_scan):
        """This function is called at the start-up and add songs."""
        threads_enter()

        # Call database
        musicdb = MusicDatabase(self.config, pbar)

        if self.config['scan'] or force_scan:
            musicdb.scan()

        pbar.set_text(_('Loading music…'))
        self.database = musicdb.load()

        sleep(1)

        timeout_add(100, self.timeout_progress, pbar)
        self.playlist.clear_playlist()
        idle_add(self.playlist.add_songs, self.database)

        threads_leave()