#ifndef PART_H
#define PART_H

#include <string>
#include <vector>

class PartPrivate;

struct PartInfo {
    std::string name;
    std::string desc;
    std::string cfgname;
    int cfglineno;
};

class Part {
    public:
        Part();
        virtual ~Part();
        static std::vector<PartInfo> getAvailableParts();
        static Part * locatePart(const std::string & name);

        std::string get_signature();

        Part * clone();

        void * getPointer();

    protected:
    private:
        PartPrivate * priv;
};



#endif // PART_H
