//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/CompoundItem.h
//! @brief     Defines class CompoundItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_COMPOUNDITEM_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_COMPOUNDITEM_H

#include "GUI/Model/Sample/ItemWithParticles.h"
#include "GUI/Model/Sample/ItemWithParticlesCatalog.h"
#include "Sample/Particle/Compound.h"
#include <memory>

class MaterialModel;

class CompoundItem : public ItemWithParticles {
public:
    CompoundItem(const MaterialModel* materials);

    void writeTo(QXmlStreamWriter* w) const override;
    void readFrom(QXmlStreamReader* r) override;

    std::unique_ptr<Compound> createCompound() const;

    QVector<ItemWithParticles*> itemsWithParticles() const;
    SelectionProperty<ItemWithParticlesCatalog>&
    addItemWithParticleSelection(ItemWithParticles* particle);
    void removeItemWithParticle(ItemWithParticles* particle);

    QVector<ItemWithParticles*> containedItemsWithParticles() const override;

    bool isExpandCompound() const { return m_expandCompound; }
    void setExpandCompound(bool b) { m_expandCompound = b; }

private:
    SelectionVector<ItemWithParticlesCatalog> m_particles;
    const MaterialModel* m_materialModel;
    bool m_expandCompound = true;
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_COMPOUNDITEM_H
