{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetSize: TVector3;
    procedure SetSize(const Value: TVector3);
    function GetManifold: boolean;
    procedure SetManifold(const Value: boolean);
  public
    property Size: TVector3 read GetSize write SetSize;
    property Manifold: boolean read GetManifold write SetManifold;

{$endif read_interface}

{$ifdef read_implementation}

{ TTeapotNode ----------------------------------------------- }

function TTeapotNode.GetSize: TVector3;
begin
  Result := FdSize.Value;
end;

procedure TTeapotNode.SetSize(const Value: TVector3);
begin
  FdSize.Send(Value);
end;

function TTeapotNode.GetManifold: boolean;
begin
  Result := FdManifold.Value;
end;

procedure TTeapotNode.SetManifold(const Value: boolean);
begin
  FdManifold.Send(Value);
end;

{$endif read_implementation}
