{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetSize: TVector3;
    procedure SetSize(const Value: TVector3);
    function GetManifold: Boolean;
    procedure SetManifold(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdSize: TSFVec3f;
    { X3D field "size". } { }
    public property FdSize: TSFVec3f read FFdSize;
    { X3D field "size". } { }
    property Size: TVector3 read GetSize write SetSize;

    strict private FFdSolid: TSFBool;
    { X3D field "solid". } { }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdManifold: TSFBool;
    { X3D field "manifold". } { }
    public property FdManifold: TSFBool read FFdManifold;
    { X3D field "manifold". } { }
    property Manifold: Boolean read GetManifold write SetManifold;

    strict private FFdTexCoord: TSFNode;
    { X3D field "texCoord". } { }
    public property FdTexCoord: TSFNode read FFdTexCoord;

{$endif read_interface}

{$ifdef read_implementation}

{ TTeapotNode ----------------------------------------------- }

function TTeapotNode.GetSize: TVector3;
begin
  Result := FdSize.Value;
end;

procedure TTeapotNode.SetSize(const Value: TVector3);
begin
  FdSize.Send(Value);
end;

function TTeapotNode.GetManifold: Boolean;
begin
  Result := FdManifold.Value;
end;

procedure TTeapotNode.SetManifold(const Value: Boolean);
begin
  FdManifold.Send(Value);
end;

class function TTeapotNode.ClassX3DType: String;
begin
  Result := 'Teapot';
end;

procedure TTeapotNode.CreateNode;
begin
  inherited;

  FFdSize := TSFVec3f.Create(Self, False, 'size', Vector3(3, 3, 3));
   FdSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSize);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSolid);

  FFdManifold := TSFBool.Create(Self, False, 'manifold', false);
   FdManifold.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdManifold);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TTextureCoordinateGeneratorNode, TProjectedTextureCoordinateNode, TMultiGeneratedTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTexCoord);
end;

{$endif read_implementation}
