{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetFractionIncreasing: Boolean;
    procedure SetFractionIncreasing(const Value: Boolean);
    function GetDetectAffectedFields: Boolean;
    procedure SetDetectAffectedFields(const Value: Boolean);
  public
    { X3D field "enabled". } { }
    property Enabled: Boolean read GetEnabled write SetEnabled;
    { X3D field "fractionIncreasing". } { }
    property FractionIncreasing: Boolean read GetFractionIncreasing write SetFractionIncreasing;
    { X3D field "detectAffectedFields". } { }
    property DetectAffectedFields: Boolean read GetDetectAffectedFields write SetDetectAffectedFields;

{$endif read_interface}

{$ifdef read_implementation}

{ TTimeSensorNode ----------------------------------------------- }

function TTimeSensorNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TTimeSensorNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TTimeSensorNode.GetFractionIncreasing: Boolean;
begin
  Result := FdFractionIncreasing.Value;
end;

procedure TTimeSensorNode.SetFractionIncreasing(const Value: Boolean);
begin
  FdFractionIncreasing.Send(Value);
end;

function TTimeSensorNode.GetDetectAffectedFields: Boolean;
begin
  Result := FdDetectAffectedFields.Value;
end;

procedure TTimeSensorNode.SetDetectAffectedFields(const Value: Boolean);
begin
  FdDetectAffectedFields.Send(Value);
end;

{$endif read_implementation}
