{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetSize: Single;
    procedure SetSize(const Value: Single);
    function GetBlending: Boolean;
    procedure SetBlending(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdSize: TSFFloat;
    { Internal wrapper for property @link(Size). This wrapper API may change, we advise to access simpler @link(Size) instead. }
    public property FdSize: TSFFloat read FFdSize;
    {  }
    property Size: Single read GetSize write SetSize;

    strict private FFdFamily: TSFEnum;
    { Internal wrapper for property @link(Family). This wrapper API may change, we advise to access simpler @link(Family) instead. }
    public property FdFamily: TSFEnum read FFdFamily;

    strict private FFdStyle: TSFBitMask;
    { Internal wrapper for property @link(Style). This wrapper API may change, we advise to access simpler @link(Style) instead. }
    public property FdStyle: TSFBitMask read FFdStyle;

    strict private FFdBlending: TSFBool;
    { Internal wrapper for property @link(Blending). This wrapper API may change, we advise to access simpler @link(Blending) instead. }
    public property FdBlending: TSFBool read FFdBlending;
    {  }
    property Blending: Boolean read GetBlending write SetBlending;

{$endif read_interface}

{$ifdef read_implementation}

{ TFontStyleNode_1 ----------------------------------------------- }

function TFontStyleNode_1.GetSize: Single;
begin
  Result := FdSize.Value;
end;

procedure TFontStyleNode_1.SetSize(const Value: Single);
begin
  FdSize.Send(Value);
end;

function TFontStyleNode_1.GetBlending: Boolean;
begin
  Result := FdBlending.Value;
end;

procedure TFontStyleNode_1.SetBlending(const Value: Boolean);
begin
  FdBlending.Send(Value);
end;

class function TFontStyleNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TFontStyleNode_1.ClassX3DType: String;
begin
  Result := 'FontStyle';
end;

procedure TFontStyleNode_1.CreateNode;
begin
  inherited;

  FFdSize := TSFFloat.Create(Self, True, 'size', 10);
   FdSize.ChangeAlways := chGeometryVRML1State;
   FdSize.MustBeNonnegative := true;
  AddField(FFdSize);

  {$warnings off} // using deprecated FSFAMILY_SERIF in deprecated VRML 1 node
  FFdFamily := TSFEnum.Create(Self, True, 'family', @FamilyNames1, Ord(High(FamilyNames1)) + 1, FSFAMILY_SERIF);
  {$warnings on}
   FdFamily.ChangeAlways := chGeometryVRML1State;
  AddField(FFdFamily);

  FFdStyle := TSFBitMask.Create(Self, True, 'style', ['BOLD', 'ITALIC'], 'NONE', '', [false, false]);
   FdStyle.ChangeAlways := chGeometryVRML1State;
  AddField(FFdStyle);

  FFdBlending := TSFBool.Create(Self, True, 'blending', true);
   FdBlending.ChangeAlways := chGeometryVRML1State;
  AddField(FFdBlending);
end;

{$endif read_implementation}
