{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetConvex: Boolean;
    procedure SetConvex(const Value: Boolean);
    function GetCreaseAngle: Single;
    procedure SetCreaseAngle(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

{$ifndef CASTLE_SLIM_NODES}
    strict private FEventSet_colorIndex: TMFInt32Event;
    {  }
    public property EventSet_colorIndex: TMFInt32Event read FEventSet_colorIndex;
{$endif not CASTLE_SLIM_NODES}

{$ifndef CASTLE_SLIM_NODES}
    strict private FEventSet_coordIndex: TMFInt32Event;
    {  }
    public property EventSet_coordIndex: TMFInt32Event read FEventSet_coordIndex;
{$endif not CASTLE_SLIM_NODES}

{$ifndef CASTLE_SLIM_NODES}
    strict private FEventSet_normalIndex: TMFInt32Event;
    {  }
    public property EventSet_normalIndex: TMFInt32Event read FEventSet_normalIndex;
{$endif not CASTLE_SLIM_NODES}

{$ifndef CASTLE_SLIM_NODES}
    strict private FEventSet_texCoordIndex: TMFInt32Event;
    {  }
    public property EventSet_texCoordIndex: TMFInt32Event read FEventSet_texCoordIndex;
{$endif not CASTLE_SLIM_NODES}

    strict private FFdColorIndex: TMFInt32;
    { Internal wrapper for property @link(ColorIndex). This wrapper API may change, we advise to access simpler @link(ColorIndex) instead. }
    public property FdColorIndex: TMFInt32 read FFdColorIndex;
    {  }
    procedure SetColorIndex(const Value: array of LongInt); overload;
    {  }
    procedure SetColorIndex(const Value: TLongIntList); overload;

    strict private FFdConvex: TSFBool;
    { Internal wrapper for property @link(Convex). This wrapper API may change, we advise to access simpler @link(Convex) instead. }
    public property FdConvex: TSFBool read FFdConvex;
    {  }
    property Convex: Boolean read GetConvex write SetConvex;

    strict private FFdCoordIndex: TMFInt32;
    { Internal wrapper for property @link(CoordIndex). This wrapper API may change, we advise to access simpler @link(CoordIndex) instead. }
    public property FdCoordIndex: TMFInt32 read FFdCoordIndex;
    {  }
    procedure SetCoordIndex(const Value: array of LongInt); overload;
    {  }
    procedure SetCoordIndex(const Value: TLongIntList); overload;

    strict private FFdCreaseAngle: TSFFloat;
    { Internal wrapper for property @link(CreaseAngle). This wrapper API may change, we advise to access simpler @link(CreaseAngle) instead. }
    public property FdCreaseAngle: TSFFloat read FFdCreaseAngle;
    {  }
    property CreaseAngle: Single read GetCreaseAngle write SetCreaseAngle;

    strict private FFdNormalIndex: TMFInt32;
    { Internal wrapper for property @link(NormalIndex). This wrapper API may change, we advise to access simpler @link(NormalIndex) instead. }
    public property FdNormalIndex: TMFInt32 read FFdNormalIndex;
    {  }
    procedure SetNormalIndex(const Value: array of LongInt); overload;
    {  }
    procedure SetNormalIndex(const Value: TLongIntList); overload;

    strict private FFdTexCoordIndex: TMFInt32;
    { Internal wrapper for property @link(TexCoordIndex). This wrapper API may change, we advise to access simpler @link(TexCoordIndex) instead. }
    public property FdTexCoordIndex: TMFInt32 read FFdTexCoordIndex;
    {  }
    procedure SetTexCoordIndex(const Value: array of LongInt); overload;
    {  }
    procedure SetTexCoordIndex(const Value: TLongIntList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TIndexedFaceSetNode ----------------------------------------------- }

procedure TIndexedFaceSetNode.SetColorIndex(const Value: array of LongInt);
begin
  FdColorIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetColorIndex(const Value: TLongIntList);
begin
  FdColorIndex.Send(Value);
end;

function TIndexedFaceSetNode.GetConvex: Boolean;
begin
  Result := FdConvex.Value;
end;

procedure TIndexedFaceSetNode.SetConvex(const Value: Boolean);
begin
  FdConvex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

function TIndexedFaceSetNode.GetCreaseAngle: Single;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TIndexedFaceSetNode.SetCreaseAngle(const Value: Single);
begin
  FdCreaseAngle.Send(Value);
end;

procedure TIndexedFaceSetNode.SetNormalIndex(const Value: array of LongInt);
begin
  FdNormalIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetNormalIndex(const Value: TLongIntList);
begin
  FdNormalIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetTexCoordIndex(const Value: array of LongInt);
begin
  FdTexCoordIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetTexCoordIndex(const Value: TLongIntList);
begin
  FdTexCoordIndex.Send(Value);
end;

class function TIndexedFaceSetNode.ClassX3DType: String;
begin
  Result := 'IndexedFaceSet';
end;

procedure TIndexedFaceSetNode.CreateNode;
begin
  inherited;

{$ifndef CASTLE_SLIM_NODES}
  FEventSet_colorIndex := TMFInt32Event.Create(Self, 'set_colorIndex', true);
  AddEvent(FEventSet_colorIndex);
{$endif not CASTLE_SLIM_NODES}

{$ifndef CASTLE_SLIM_NODES}
  FEventSet_coordIndex := TMFInt32Event.Create(Self, 'set_coordIndex', true);
  AddEvent(FEventSet_coordIndex);
{$endif not CASTLE_SLIM_NODES}

{$ifndef CASTLE_SLIM_NODES}
  FEventSet_normalIndex := TMFInt32Event.Create(Self, 'set_normalIndex', true);
  AddEvent(FEventSet_normalIndex);
{$endif not CASTLE_SLIM_NODES}

{$ifndef CASTLE_SLIM_NODES}
  FEventSet_texCoordIndex := TMFInt32Event.Create(Self, 'set_texCoordIndex', true);
  AddEvent(FEventSet_texCoordIndex);
{$endif not CASTLE_SLIM_NODES}

  FFdColorIndex := TMFInt32.Create(Self, False, 'colorIndex', []);
   FdColorIndex.ChangeAlways := chGeometry;
  AddField(FFdColorIndex);

  FFdConvex := TSFBool.Create(Self, False, 'convex', true);
   FdConvex.ChangeAlways := chGeometry;
  AddField(FFdConvex);

  FFdCoordIndex := TMFInt32.Create(Self, False, 'coordIndex', []);
   FdCoordIndex.ChangeAlways := chGeometry;
  AddField(FFdCoordIndex);

  FFdCreaseAngle := TSFFloat.Create(Self, False, 'creaseAngle', 0);
   FdCreaseAngle.ChangeAlways := chGeometry;
   FdCreaseAngle.Angle := true;
   FdCreaseAngle.MustBeNonnegative := true;
  AddField(FFdCreaseAngle);

  FFdNormalIndex := TMFInt32.Create(Self, False, 'normalIndex', []);
   FdNormalIndex.ChangeAlways := chGeometry;
  AddField(FFdNormalIndex);

  FFdTexCoordIndex := TMFInt32.Create(Self, False, 'texCoordIndex', []);
   FdTexCoordIndex.ChangeAlways := chGeometry;
  AddField(FFdTexCoordIndex);
end;

{$endif read_implementation}
