{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetFogImmune: Boolean;
    procedure SetFogImmune(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdAmbientColor: TMFColor;
    { Internal wrapper for property @link(AmbientColor). This wrapper API may change, we advise to access simpler @link(AmbientColor) instead. }
    public property FdAmbientColor: TMFColor read FFdAmbientColor;
    {  }
    procedure SetAmbientColor(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetAmbientColor(const Value: TVector3List); overload;

    strict private FFdDiffuseColor: TMFColor;
    { Internal wrapper for property @link(DiffuseColor). This wrapper API may change, we advise to access simpler @link(DiffuseColor) instead. }
    public property FdDiffuseColor: TMFColor read FFdDiffuseColor;
    {  }
    procedure SetDiffuseColor(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetDiffuseColor(const Value: TVector3List); overload;

    strict private FFdSpecularColor: TMFColor;
    { Internal wrapper for property @link(SpecularColor). This wrapper API may change, we advise to access simpler @link(SpecularColor) instead. }
    public property FdSpecularColor: TMFColor read FFdSpecularColor;
    {  }
    procedure SetSpecularColor(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetSpecularColor(const Value: TVector3List); overload;

    strict private FFdEmissiveColor: TMFColor;
    { Internal wrapper for property @link(EmissiveColor). This wrapper API may change, we advise to access simpler @link(EmissiveColor) instead. }
    public property FdEmissiveColor: TMFColor read FFdEmissiveColor;
    {  }
    procedure SetEmissiveColor(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetEmissiveColor(const Value: TVector3List); overload;

    strict private FFdShininess: TMFFloat;
    { Internal wrapper for property @link(Shininess). This wrapper API may change, we advise to access simpler @link(Shininess) instead. }
    public property FdShininess: TMFFloat read FFdShininess;
    {  }
    procedure SetShininess(const Value: array of Single); overload;
    {  }
    procedure SetShininess(const Value: TSingleList); overload;

    strict private FFdTransparency: TMFFloat;
    { Internal wrapper for property @link(Transparency). This wrapper API may change, we advise to access simpler @link(Transparency) instead. }
    public property FdTransparency: TMFFloat read FFdTransparency;
    {  }
    procedure SetTransparency(const Value: array of Single); overload;
    {  }
    procedure SetTransparency(const Value: TSingleList); overload;

    strict private FFdMirror: TMFFloat;
    { Internal wrapper for property @link(Mirror). This wrapper API may change, we advise to access simpler @link(Mirror) instead. }
    public property FdMirror: TMFFloat read FFdMirror;
    {  }
    procedure SetMirror(const Value: array of Single); overload;
    {  }
    procedure SetMirror(const Value: TSingleList); overload;

    strict private FFdReflSpecular: TMFColor;
    { Internal wrapper for property @link(ReflSpecular). This wrapper API may change, we advise to access simpler @link(ReflSpecular) instead. }
    public property FdReflSpecular: TMFColor read FFdReflSpecular;
    {  }
    procedure SetReflSpecular(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetReflSpecular(const Value: TVector3List); overload;

    strict private FFdReflDiffuse: TMFColor;
    { Internal wrapper for property @link(ReflDiffuse). This wrapper API may change, we advise to access simpler @link(ReflDiffuse) instead. }
    public property FdReflDiffuse: TMFColor read FFdReflDiffuse;
    {  }
    procedure SetReflDiffuse(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetReflDiffuse(const Value: TVector3List); overload;

    strict private FFdTransSpecular: TMFColor;
    { Internal wrapper for property @link(TransSpecular). This wrapper API may change, we advise to access simpler @link(TransSpecular) instead. }
    public property FdTransSpecular: TMFColor read FFdTransSpecular;
    {  }
    procedure SetTransSpecular(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetTransSpecular(const Value: TVector3List); overload;

    strict private FFdTransDiffuse: TMFColor;
    { Internal wrapper for property @link(TransDiffuse). This wrapper API may change, we advise to access simpler @link(TransDiffuse) instead. }
    public property FdTransDiffuse: TMFColor read FFdTransDiffuse;
    {  }
    procedure SetTransDiffuse(const Value: array of TCastleColorRGB); overload;
    {  }
    procedure SetTransDiffuse(const Value: TVector3List); overload;

    strict private FFdReflSpecularExp: TMFFloat;
    { Internal wrapper for property @link(ReflSpecularExp). This wrapper API may change, we advise to access simpler @link(ReflSpecularExp) instead. }
    public property FdReflSpecularExp: TMFFloat read FFdReflSpecularExp;
    {  }
    procedure SetReflSpecularExp(const Value: array of Single); overload;
    {  }
    procedure SetReflSpecularExp(const Value: TSingleList); overload;

    strict private FFdTransSpecularExp: TMFFloat;
    { Internal wrapper for property @link(TransSpecularExp). This wrapper API may change, we advise to access simpler @link(TransSpecularExp) instead. }
    public property FdTransSpecularExp: TMFFloat read FFdTransSpecularExp;
    {  }
    procedure SetTransSpecularExp(const Value: array of Single); overload;
    {  }
    procedure SetTransSpecularExp(const Value: TSingleList); overload;

    strict private FFdFogImmune: TSFBool;
    { Internal wrapper for property @link(FogImmune). This wrapper API may change, we advise to access simpler @link(FogImmune) instead. }
    public property FdFogImmune: TSFBool read FFdFogImmune;
    {  }
    property FogImmune: Boolean read GetFogImmune write SetFogImmune;

{$endif read_interface}

{$ifdef read_implementation}

{ TMaterialNode_1 ----------------------------------------------- }

procedure TMaterialNode_1.SetAmbientColor(const Value: array of TCastleColorRGB);
begin
  FdAmbientColor.Send(Value);
end;

procedure TMaterialNode_1.SetAmbientColor(const Value: TVector3List);
begin
  FdAmbientColor.Send(Value);
end;

procedure TMaterialNode_1.SetDiffuseColor(const Value: array of TCastleColorRGB);
begin
  FdDiffuseColor.Send(Value);
end;

procedure TMaterialNode_1.SetDiffuseColor(const Value: TVector3List);
begin
  FdDiffuseColor.Send(Value);
end;

procedure TMaterialNode_1.SetSpecularColor(const Value: array of TCastleColorRGB);
begin
  FdSpecularColor.Send(Value);
end;

procedure TMaterialNode_1.SetSpecularColor(const Value: TVector3List);
begin
  FdSpecularColor.Send(Value);
end;

procedure TMaterialNode_1.SetEmissiveColor(const Value: array of TCastleColorRGB);
begin
  FdEmissiveColor.Send(Value);
end;

procedure TMaterialNode_1.SetEmissiveColor(const Value: TVector3List);
begin
  FdEmissiveColor.Send(Value);
end;

procedure TMaterialNode_1.SetShininess(const Value: array of Single);
begin
  FdShininess.Send(Value);
end;

procedure TMaterialNode_1.SetShininess(const Value: TSingleList);
begin
  FdShininess.Send(Value);
end;

procedure TMaterialNode_1.SetTransparency(const Value: array of Single);
begin
  FdTransparency.Send(Value);
end;

procedure TMaterialNode_1.SetTransparency(const Value: TSingleList);
begin
  FdTransparency.Send(Value);
end;

procedure TMaterialNode_1.SetMirror(const Value: array of Single);
begin
  FdMirror.Send(Value);
end;

procedure TMaterialNode_1.SetMirror(const Value: TSingleList);
begin
  FdMirror.Send(Value);
end;

procedure TMaterialNode_1.SetReflSpecular(const Value: array of TCastleColorRGB);
begin
  FdReflSpecular.Send(Value);
end;

procedure TMaterialNode_1.SetReflSpecular(const Value: TVector3List);
begin
  FdReflSpecular.Send(Value);
end;

procedure TMaterialNode_1.SetReflDiffuse(const Value: array of TCastleColorRGB);
begin
  FdReflDiffuse.Send(Value);
end;

procedure TMaterialNode_1.SetReflDiffuse(const Value: TVector3List);
begin
  FdReflDiffuse.Send(Value);
end;

procedure TMaterialNode_1.SetTransSpecular(const Value: array of TCastleColorRGB);
begin
  FdTransSpecular.Send(Value);
end;

procedure TMaterialNode_1.SetTransSpecular(const Value: TVector3List);
begin
  FdTransSpecular.Send(Value);
end;

procedure TMaterialNode_1.SetTransDiffuse(const Value: array of TCastleColorRGB);
begin
  FdTransDiffuse.Send(Value);
end;

procedure TMaterialNode_1.SetTransDiffuse(const Value: TVector3List);
begin
  FdTransDiffuse.Send(Value);
end;

procedure TMaterialNode_1.SetReflSpecularExp(const Value: array of Single);
begin
  FdReflSpecularExp.Send(Value);
end;

procedure TMaterialNode_1.SetReflSpecularExp(const Value: TSingleList);
begin
  FdReflSpecularExp.Send(Value);
end;

procedure TMaterialNode_1.SetTransSpecularExp(const Value: array of Single);
begin
  FdTransSpecularExp.Send(Value);
end;

procedure TMaterialNode_1.SetTransSpecularExp(const Value: TSingleList);
begin
  FdTransSpecularExp.Send(Value);
end;

function TMaterialNode_1.GetFogImmune: Boolean;
begin
  Result := FdFogImmune.Value;
end;

procedure TMaterialNode_1.SetFogImmune(const Value: Boolean);
begin
  FdFogImmune.Send(Value);
end;

class function TMaterialNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TMaterialNode_1.ClassX3DType: String;
begin
  Result := 'Material';
end;

procedure TMaterialNode_1.CreateNode;
begin
  inherited;

  FFdAmbientColor := TMFColor.Create(Self, True, 'ambientColor', [TPhongMaterialInfo.DefaultAmbientColor]);
   FdAmbientColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAmbientColor);

  FFdDiffuseColor := TMFColor.Create(Self, True, 'diffuseColor', [TPhongMaterialInfo.DefaultDiffuseColor]);
   FdDiffuseColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseColor);

  FFdSpecularColor := TMFColor.Create(Self, True, 'specularColor', [TPhongMaterialInfo.DefaultSpecularColor]);
   FdSpecularColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularColor);

  FFdEmissiveColor := TMFColor.Create(Self, True, 'emissiveColor', [TPhongMaterialInfo.DefaultEmissiveColor]);
   FdEmissiveColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveColor);

  FFdShininess := TMFFloat.Create(Self, True, 'shininess', [TPhongMaterialInfo.DefaultShininess]);
   FdShininess.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShininess);

  FFdTransparency := TMFFloat.Create(Self, True, 'transparency', [TMaterialInfo.DefaultTransparency]);
   FdTransparency.ChangeAlways := chAlphaChannel;
  AddField(FFdTransparency);

  FFdMirror := TMFFloat.Create(Self, True, 'mirror', [0.0]);
   FdMirror.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMirror);

  FFdReflSpecular := TMFColor.Create(Self, True, 'reflSpecular', []);
   FdReflSpecular.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReflSpecular);

  FFdReflDiffuse := TMFColor.Create(Self, True, 'reflDiffuse', []);
   FdReflDiffuse.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReflDiffuse);

  FFdTransSpecular := TMFColor.Create(Self, True, 'transSpecular', []);
   FdTransSpecular.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransSpecular);

  FFdTransDiffuse := TMFColor.Create(Self, True, 'transDiffuse', []);
   FdTransDiffuse.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransDiffuse);

  FFdReflSpecularExp := TMFFloat.Create(Self, True, 'reflSpecularExp', [TPhongMaterialInfo.DefaultReflSpecularExp]);
   FdReflSpecularExp.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReflSpecularExp);

  FFdTransSpecularExp := TMFFloat.Create(Self, True, 'transSpecularExp', [TPhongMaterialInfo.DefaultTransSpecularExp]);
   FdTransSpecularExp.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransSpecularExp);

  FFdFogImmune := TSFBool.Create(Self, True, 'fogImmune', false);
   FdFogImmune.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFogImmune);
end;

{$endif read_implementation}
