{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetDisplayed: Boolean;
    procedure SetDisplayed(const Value: Boolean);
    function GetRetainUserOffsets: Boolean;
    procedure SetRetainUserOffsets(const Value: Boolean);
    function GetSize: TVector3;
    procedure SetSize(const Value: TVector3);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdCenter: TSFVec3f;
    { Internal wrapper for property @link(Center). This wrapper API may change, we advise to access simpler @link(Center) instead. }
    public property FdCenter: TSFVec3f read FFdCenter;
    {  }
    property Center: TVector3 read GetCenter write SetCenter;

    strict private FFdChildren: TMFNode;
    { Internal wrapper for property @link(Children). This wrapper API may change, we advise to access simpler @link(Children) instead. }
    public property FdChildren: TMFNode read FFdChildren;

    strict private FFdDescription: TSFString;
    { Internal wrapper for property @link(Description). This wrapper API may change, we advise to access simpler @link(Description) instead. }
    public property FdDescription: TSFString read FFdDescription;
    {  }
    property Description: String read GetDescription write SetDescription;

    strict private FFdDisplayed: TSFBool;
    { Internal wrapper for property @link(Displayed). This wrapper API may change, we advise to access simpler @link(Displayed) instead. }
    public property FdDisplayed: TSFBool read FFdDisplayed;
    {  }
    property Displayed: Boolean read GetDisplayed write SetDisplayed;

    strict private FFdRetainUserOffsets: TSFBool;
    { Internal wrapper for property @link(RetainUserOffsets). This wrapper API may change, we advise to access simpler @link(RetainUserOffsets) instead. }
    public property FdRetainUserOffsets: TSFBool read FFdRetainUserOffsets;
    {  }
    property RetainUserOffsets: Boolean read GetRetainUserOffsets write SetRetainUserOffsets;

    strict private FFdSize: TSFVec3f;
    { Internal wrapper for property @link(Size). This wrapper API may change, we advise to access simpler @link(Size) instead. }
    public property FdSize: TSFVec3f read FFdSize;
    {  }
    property Size: TVector3 read GetSize write SetSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TViewpointGroupNode ----------------------------------------------- }

function TViewpointGroupNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure TViewpointGroupNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function TViewpointGroupNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TViewpointGroupNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function TViewpointGroupNode.GetDisplayed: Boolean;
begin
  Result := FdDisplayed.Value;
end;

procedure TViewpointGroupNode.SetDisplayed(const Value: Boolean);
begin
  FdDisplayed.Send(Value);
end;

function TViewpointGroupNode.GetRetainUserOffsets: Boolean;
begin
  Result := FdRetainUserOffsets.Value;
end;

procedure TViewpointGroupNode.SetRetainUserOffsets(const Value: Boolean);
begin
  FdRetainUserOffsets.Send(Value);
end;

function TViewpointGroupNode.GetSize: TVector3;
begin
  Result := FdSize.Value;
end;

procedure TViewpointGroupNode.SetSize(const Value: TVector3);
begin
  FdSize.Send(Value);
end;

class function TViewpointGroupNode.ClassX3DType: String;
begin
  Result := 'ViewpointGroup';
end;

procedure TViewpointGroupNode.CreateNode;
begin
  inherited;

  FFdCenter := TSFVec3f.Create(Self, True, 'center', Vector3(0, 0, 0));
   FdCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCenter);

  FFdChildren := TMFNode.Create(Self, True, 'children', [TAbstractViewpointNode, TViewpointGroupNode]);
   FdChildren.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdChildren);

  FFdDescription := TSFString.Create(Self, True, 'description', '');
   FdDescription.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDescription);

  FFdDisplayed := TSFBool.Create(Self, True, 'displayed', true);
   FdDisplayed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplayed);

  FFdRetainUserOffsets := TSFBool.Create(Self, True, 'retainUserOffsets', false);
   FdRetainUserOffsets.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRetainUserOffsets);

  FFdSize := TSFVec3f.Create(Self, True, 'size', Vector3(0, 0, 0));
   FdSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSize);
end;

{$endif read_implementation}
