/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 - 2014 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

/**
   \file cdw_mkudffs.c
*/

#define _GNU_SOURCE /* asprintf() */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdbool.h>

#include "gettext.h"
#include "cdw_thread.h"
#include "cdw_string.h"
#include "cdw_graftpoints.h"
#include "cdw_debug.h"
#include "cdw_ext_tools.h"
#include "cdw_mkudffs.h"
#include "cdw_mkudffs_options.h"
#include "cdw_mkudffs_helpers.h"
#include "cdw_file_manager.h"


extern const char *cdw_mkudffs_option_blocksize[];
extern const char *cdw_mkudffs_option_udfrev[];
extern const char *cdw_mkudffs_option_strategy[];
extern const char *cdw_mkudffs_option_spartable[];
extern const char *cdw_mkudffs_option_media_type[];
extern const char *cdw_mkudffs_option_space[];
extern const char *cdw_mkudffs_option_ad[];
extern const char *cdw_mkudffs_option_encoding[];





/**

   \param task - variable describing current task
   \param disc - variable describing current disc

*/
cdw_rv_t cdw_mkudffs_run_task(cdw_task_t *task)
{

	cdw_assert (task->id == CDW_TASK_CREATE_IMAGE_UDF,
		    "ERROR: incorrect task id is not CDW_TASK_CREATE_IMAGE_UDF: %lld\n", task->id);
	cdw_assert (task->create_image.tool.id == CDW_TOOL_MKUDFFS,
		    "ERROR: incorrect tool id is not CDW_TOOL_MKUDFFS in \"create image\" task: %lld\n", task->create_image.tool.id);
	cdw_assert (task->create_image.tool.label,
		    "ERROR: \"create image\" tool fullpath is not initialized (is NULL)\n");



	cdw_udf_t *udf = &(task->create_image.udf);

	/* I'm using the explicit tool's name. Even if there are more
	   instances, I will use the default one. Instances of mkudffs
	   are not configurable. */
	char *command = cdw_string_concat("mkudffs ",
					  udf->mkudffs_blocksize != CDW_MKUDFFS_BLOCKSIZE_UNSPECIFIED ? " --blocksize=" : "",
					  udf->mkudffs_blocksize != CDW_MKUDFFS_BLOCKSIZE_UNSPECIFIED ? cdw_mkudffs_option_blocksize[udf->mkudffs_blocksize] : "",
					  udf->mkudffs_blocksize != CDW_MKUDFFS_BLOCKSIZE_UNSPECIFIED ? " " : "",

					  udf->mkudffs_udfrev != CDW_MKUDFFS_UDFREV_UNSPECIFIED ? " --udfrev=" : "",
					  udf->mkudffs_udfrev != CDW_MKUDFFS_UDFREV_UNSPECIFIED ? cdw_mkudffs_option_udfrev[udf->mkudffs_udfrev] : "",
					  udf->mkudffs_udfrev != CDW_MKUDFFS_UDFREV_UNSPECIFIED ? " " : "",

					  udf->mkudffs_strategy != CDW_MKUDFFS_STRATEGY_UNSPECIFIED ? " --strategy=" : "",
					  udf->mkudffs_strategy != CDW_MKUDFFS_STRATEGY_UNSPECIFIED ? cdw_mkudffs_option_strategy[udf->mkudffs_strategy] : "",
					  udf->mkudffs_strategy != CDW_MKUDFFS_STRATEGY_UNSPECIFIED ? " " : "",

					  udf->mkudffs_spartable != CDW_MKUDFFS_SPARTABLE_UNSPECIFIED ? " --spartable=" : "",
					  udf->mkudffs_spartable != CDW_MKUDFFS_SPARTABLE_UNSPECIFIED ? cdw_mkudffs_option_spartable[udf->mkudffs_spartable] : "",
					  udf->mkudffs_spartable != CDW_MKUDFFS_SPARTABLE_UNSPECIFIED ? " " : "",

					  udf->mkudffs_media_type != CDW_MKUDFFS_MEDIA_TYPE_UNSPECIFIED ? " --media-type=" : "",
					  udf->mkudffs_media_type != CDW_MKUDFFS_MEDIA_TYPE_UNSPECIFIED ? cdw_mkudffs_option_media_type[udf->mkudffs_media_type] : "",
					  udf->mkudffs_media_type != CDW_MKUDFFS_MEDIA_TYPE_UNSPECIFIED ? " " : "",

					  udf->mkudffs_space != CDW_MKUDFFS_SPACE_UNSPECIFIED ? " --space=" : "",
					  udf->mkudffs_space != CDW_MKUDFFS_SPACE_UNSPECIFIED ? cdw_mkudffs_option_space[udf->mkudffs_space] : "",
					  udf->mkudffs_space != CDW_MKUDFFS_SPACE_UNSPECIFIED ? " " : "",

					  udf->mkudffs_ad != CDW_MKUDFFS_AD_UNSPECIFIED ? " --ad=" : "",
					  udf->mkudffs_ad != CDW_MKUDFFS_AD_UNSPECIFIED ? cdw_mkudffs_option_ad[udf->mkudffs_ad] : "",
					  udf->mkudffs_ad != CDW_MKUDFFS_AD_UNSPECIFIED ? " " : "",

					  udf->mkudffs_encoding != CDW_MKUDFFS_ENCODING_UNSPECIFIED ? " --" : "",
					  udf->mkudffs_encoding != CDW_MKUDFFS_ENCODING_UNSPECIFIED ? cdw_mkudffs_option_encoding[udf->mkudffs_encoding] : "",
					  udf->mkudffs_encoding != CDW_MKUDFFS_ENCODING_UNSPECIFIED ? " " : "",

					  udf->mkudffs_noefe ? " --noefe " : "",

					  strlen(udf->mkudffs_lvid) ? " --lvid=\"" : "",
					  strlen(udf->mkudffs_lvid) ? udf->mkudffs_lvid : "",
					  strlen(udf->mkudffs_lvid) ? "\"" : "",

					  strlen(udf->mkudffs_vid) ? " --vid=\"" : "",
					  strlen(udf->mkudffs_vid) ? udf->mkudffs_vid : "",
					  strlen(udf->mkudffs_vid) ? "\"" : "",

					  strlen(udf->mkudffs_vsid) ? " --vsid=\"" : "",
					  strlen(udf->mkudffs_vsid) ? udf->mkudffs_vsid : "",
					  strlen(udf->mkudffs_vsid) ? "\"" : "",

					  strlen(udf->mkudffs_fsid) ? " --fsid=\"" : "",
					  strlen(udf->mkudffs_fsid) ? udf->mkudffs_fsid : "",
					  strlen(udf->mkudffs_fsid) ? "\"" : "",

					  " ", strlen(udf->mkudffs_other_options) ? udf->mkudffs_other_options : " ",

					  /* Path may contain spaces, so use opening and closing quotes. */
					  " \"", task->image_file_fullpath, "\" ", (char *) NULL);
	if (!command) {
		cdw_vdm ("ERROR: failed to get command for creating UDF file system\n");
		return CDW_ERROR;
	} else {
		cdw_vdm ("INFO: created command string \"%s\"\n", command);
		int rv = cdw_thread_run_command(command, task);
		free(command);
		command = (char *) NULL;

		cdw_vdm ("INFO: exit status of \"mkudffs\" is %d\n", task->tool_status.child_exit_status);

		if (rv == 0
		    && task->tool_status.mkudffs_general == CDW_TOOL_STATUS_OK
		    && task->tool_status.mkudffs == CDW_TOOL_STATUS_OK
		    && task->tool_status.child_exit_status == 0) {

			return CDW_OK;
		} else {
			return CDW_ERROR;
		}
	}
}
