/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *
 * License: GPL-2+
 *
 * Initial version: 2008-12-02
 *
 * An expression parser
 */

#ifndef CNAUX_EXPRPARSER_H
#define CNAUX_EXPRPARSER_H

#include <cmath>
#include <cstring>
#include <string>
#include <list>

namespace Stilton {

using namespace std;
using namespace Stilton;


enum TExprParserError {
	EXPARSE_OK = 0,
	EXPARSE_EMPTY,
	EXPARSE_UNBALANCED,
	EXPARSE_BAD,
	EXPARSE_UNASSOC,
	EXPARSE_UNDEFVAR,
	EXPARSE_NONLVAL,
	EXPARSE_VARLISTNULL
};


#define STILTON_MAX_VAR_LEN	32

struct SVariable {
	char name[STILTON_MAX_VAR_LEN];
	double value;
	SVariable( const char *inname, double invalue = NAN)
	      : value (invalue)
		{
			strncpy( name, inname, STILTON_MAX_VAR_LEN-1);
		}
	bool operator== ( const SVariable &rv) const
		{
			return strcmp( name, rv.name /*, STILTON_MAX_VAR_LEN */ ) == 0;
		}
	bool operator< ( const SVariable &rv) const
		{
			return strcmp( name, rv.name /*, STILTON_MAX_VAR_LEN */ ) == -1;
		}
};

extern const char *const __exparse_error_strings[];

class CExpression {

    public:
	TExprParserError status;

	CExpression()
	      : status (EXPARSE_OK), silent (false), eol_comment_delim ('#'), toplevel_op (' '), _parsed_value (NAN)
		{}
	const char *error_string() const
		{	return __exparse_error_strings[status];		}

	double operator() ( const char *str, list<SVariable> *varlist = nullptr)
		{	return ( _do_parse( str, _parsed_value, varlist) == EXPARSE_OK )
				? _parsed_value : NAN;				}
	int operator() ( const char *str, double& parsed, list<SVariable> *varlist = nullptr)
		{	_do_parse( str, parsed, varlist);
			return status;						}

	bool	silent;
	char	eol_comment_delim;
	char	toplevel_op;

	const char *status_s() const
		{	return __exparse_error_strings[status];		}

    private:
	double	_parsed_value;
	string	_var;
//	string	_source_str;
	TExprParserError _do_parse( const char *str, double& parsed, list<SVariable>*);
};


}

#endif

// EOF
