/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef SOC_MEDIATEK_MT8195_DEVAPC_H
#define SOC_MEDIATEK_MT8195_DEVAPC_H

#include <device/mmio.h>
#include <soc/addressmap.h>

void dapc_init(void);

enum devapc_ao_offset {
	SYS0_D0_APC_0 = 0x0,
	SYS1_D0_APC_0 = 0x1000,
	SYS2_D0_APC_0 = 0x2000,
	DOM_REMAP_0_0 = 0x800,
	DOM_REMAP_1_0 = 0x810,
	DOM_REMAP_1_1 = 0x814,
	DOM_REMAP_2_0 = 0x820,
	MAS_DOM_0 = 0x0900,
	MAS_SEC_0 = 0x0A00,
	AO_APC_CON = 0x0F00,
};

/******************************************************************************
 * STRUCTURE DEFINITION
 ******************************************************************************/
/* Common */
enum trans_type {
	NON_SECURE_TRANS = 0,
	SECURE_TRANS,
};

enum devapc_perm_type {
	NO_PROTECTION = 0,
	SEC_RW_ONLY,
	SEC_RW_NS_R,
	FORBIDDEN,
	PERM_NUM,
};

enum domain_id {
	DOMAIN_0 = 0,
	DOMAIN_1,
	DOMAIN_2,
	DOMAIN_3,
	DOMAIN_4,
	DOMAIN_5,
	DOMAIN_6,
	DOMAIN_7,
	DOMAIN_8,
	DOMAIN_9,
	DOMAIN_10,
	DOMAIN_11,
	DOMAIN_12,
	DOMAIN_13,
	DOMAIN_14,
	DOMAIN_15,
};

struct apc_infra_peri_dom_16 {
	unsigned char d_permission[16];
};

struct apc_infra_peri_dom_8 {
	unsigned char d_permission[8];
};

struct apc_infra_peri_dom_4 {
	unsigned char d_permission[4];
};

#define DAPC_PERM_ATTR_4(DEV_NAME, PERM_ATTR0, PERM_ATTR1, \
			 PERM_ATTR2, PERM_ATTR3) \
	(unsigned char)PERM_ATTR0, (unsigned char)PERM_ATTR1, \
	(unsigned char)PERM_ATTR2, (unsigned char)PERM_ATTR3,

#define DAPC_PERM_ATTR_8(DEV_NAME, PERM_ATTR0, PERM_ATTR1, \
			 PERM_ATTR2, PERM_ATTR3, PERM_ATTR4, PERM_ATTR5, \
			 PERM_ATTR6, PERM_ATTR7) \
	DAPC_PERM_ATTR_4(DEV_NAME, PERM_ATTR0, PERM_ATTR1, \
			 PERM_ATTR2, PERM_ATTR3) \
	DAPC_PERM_ATTR_4(DEV_NAME, PERM_ATTR4, PERM_ATTR5, \
			 PERM_ATTR6, PERM_ATTR7)

#define DAPC_PERM_ATTR_16(DEV_NAME, PERM_ATTR0, PERM_ATTR1, \
			  PERM_ATTR2, PERM_ATTR3, PERM_ATTR4, PERM_ATTR5, \
			  PERM_ATTR6, PERM_ATTR7, PERM_ATTR8, PERM_ATTR9, \
			  PERM_ATTR10, PERM_ATTR11, PERM_ATTR12, PERM_ATTR13, \
			  PERM_ATTR14, PERM_ATTR15) \
	DAPC_PERM_ATTR_8(DEV_NAME, PERM_ATTR0, PERM_ATTR1, \
			 PERM_ATTR2, PERM_ATTR3, \
			 PERM_ATTR4, PERM_ATTR5, \
			 PERM_ATTR6, PERM_ATTR7) \
	DAPC_PERM_ATTR_8(DEV_NAME, PERM_ATTR8, PERM_ATTR9, \
			 PERM_ATTR10, PERM_ATTR11, \
			 PERM_ATTR12, PERM_ATTR13, \
			 PERM_ATTR14, PERM_ATTR15)

#define FORBIDDEN3 FORBIDDEN, FORBIDDEN, FORBIDDEN
#define FORBIDDEN7 FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, \
		    FORBIDDEN, FORBIDDEN
#define FORBIDDEN12 FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, \
		    FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, \
		    FORBIDDEN, FORBIDDEN
#define FORBIDDEN13 FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, \
		    FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, \
		    FORBIDDEN, FORBIDDEN, FORBIDDEN
#define FORBIDDEN15 FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, \
		    FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, \
		    FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN, FORBIDDEN

enum devapc_sys_dom_num {
	DOM_NUM_INFRA_AO_SYS0 = 16,
	DOM_NUM_INFRA_AO_SYS1 = 4,
	DOM_NUM_INFRA_AO_SYS2 = 4,
	DOM_NUM_PERI_AO_SYS0 = 16,
	DOM_NUM_PERI_AO_SYS1 = 8,
	DOM_NUM_PERI2_AO_SYS0 = 16,
	DOM_NUM_PERI_PAR_AO_SYS0 = 16,
};

enum devapc_cfg_index {
	DEVAPC_DEBUGSYS_INDEX = 17,
};

/* PERM_ATTR MACRO */
#define DAPC_INFRA_AO_SYS0_ATTR(...)	{ { DAPC_PERM_ATTR_16(__VA_ARGS__) } }
#define DAPC_INFRA_AO_SYS1_ATTR(...)	{ { DAPC_PERM_ATTR_4(__VA_ARGS__) } }
#define DAPC_INFRA_AO_SYS2_ATTR(...)	{ { DAPC_PERM_ATTR_4(__VA_ARGS__) } }
#define DAPC_PERI_AO_SYS0_ATTR(...)	{ { DAPC_PERM_ATTR_16(__VA_ARGS__) } }
#define DAPC_PERI_AO_SYS1_ATTR(...)	{ { DAPC_PERM_ATTR_8(__VA_ARGS__) } }
#define DAPC_PERI2_AO_SYS0_ATTR(...)	{ { DAPC_PERM_ATTR_16(__VA_ARGS__) } }
#define DAPC_PERI_PAR_AO_SYS0_ATTR(...)	{ { DAPC_PERM_ATTR_16(__VA_ARGS__) } }

/******************************************************************************
 * Variable DEFINITION
 ******************************************************************************/
#define MOD_NO_IN_1_DEVAPC		16

/******************************************************************************
 * Bit Field DEFINITION
 ******************************************************************************/
/* INFRA */
DEFINE_BIT(CPU_EB_SEC, 1)

DEFINE_BITFIELD(CPU_EB_DOM, 11, 8)	/* 1 */

/* PERI_PAR */
DEFINE_BIT(SSUSB_SEC, 21)
DEFINE_BIT(SSUSB2_SEC, 0)
DEFINE_BIT(SSUSB_P1_0_SEC, 1)
DEFINE_BIT(SSUSB_P1_1_SEC, 2)
DEFINE_BIT(SSUSB_P2_SEC, 3)
DEFINE_BIT(SSUSB_P3_SEC, 4)

/* Domain Remap */
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_0,  3,  0)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_1,  7,  4)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_2, 11,  8)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_3, 15, 12)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_4, 19, 16)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_5, 23, 20)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_6, 27, 24)
DEFINE_BITFIELD(FOUR_BIT_DOM_REMAP_7, 31, 28)

DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_0,  2,  0)
DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_1,  5,  3)
DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_2,  8,  6)
DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_3, 11,  9)
DEFINE_BITFIELD(THREE_BIT_DOM_REMAP_4, 14, 12)

DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_0, 1, 0)
DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_1, 3, 2)
DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_2, 5, 4)
DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_3, 7, 6)
DEFINE_BITFIELD(TWO_BIT_DOM_REMAP_4, 9, 8)

#endif /* SOC_MEDIATEK_MT8195_DEVAPC_H */
