#include "roundrobin"

unsigned Roundrobin::target(struct in_addr clientip,
			    BackendVector const &targetlist) {
    // No back ends? Don't even try. One back end? Always that one.
    if (targetlist.size() == 0)
	throw Error("Round robin dispatcher: no backends\n");

    if (config.debug())
	for (unsigned i = 0; i < targetlist.size(); i++) {
	    unsigned backend_index = targetlist[i];
	    _debugmsg(Mstr("Round robin dispatcher: target ") +
		      Mstr(i) + Mstr(" is ") +
		      balancer.backend(backend_index).description() + "\n");
	}

    if (targetlist.size() == 1)
	return (targetlist[0]);
    
    static int prev_run_index = -1;

    unsigned first_try_val = 0;
    bool first_try_set = false;
    while (true) {
	// See where we will start
	unsigned cur_val;
	
	if (prev_run_index == -1) {
	    cur_val = 0;
	} else {
	    if (! first_try_set) {
		first_try_set = true;
		first_try_val = prev_run_index;
	    }
	    cur_val = prev_run_index + 1;
	    cur_val %= targetlist.size();
	    if (cur_val == first_try_val)
		throw Error("Round robin dispatcher: no backends\n");
	}
	
	// Store for next time 'round
	lock (&prev_run_index);
	prev_run_index = cur_val;
	unlock (&prev_run_index);

	if (! balancer.backend(targetlist[cur_val]).available())
	    continue;

	// Done.
	return (targetlist[cur_val]);
    }
}
