/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_pcie_cfg.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:12p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:54 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_pcie_cfg.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:12p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_PCIE_CFG_H__
#define BCHP_PCIE_CFG_H__

/***************************************************************************
 *PCIE_CFG - PCIE Config related registers
 ***************************************************************************/
#define BCHP_PCIE_CFG_DEVICE_VENDOR_ID           0x00500000 /* DEVICE_VENDOR_ID Register */
#define BCHP_PCIE_CFG_STATUS_COMMAND             0x00500004 /* STATUS_COMMAND Register */
#define BCHP_PCIE_CFG_PCI_CLASSCODE_AND_REVISION_ID 0x00500008 /* PCI_CLASSCODE_AND_REVISION_ID Register */
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE 0x0050000c /* BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE Register */
#define BCHP_PCIE_CFG_BASE_ADDRESS_1             0x00500010 /* BASE_ADDRESS_1 Register */
#define BCHP_PCIE_CFG_BASE_ADDRESS_2             0x00500014 /* BASE_ADDRESS_2 Register */
#define BCHP_PCIE_CFG_BASE_ADDRESS_3             0x00500018 /* BASE_ADDRESS_3 Register */
#define BCHP_PCIE_CFG_BASE_ADDRESS_4             0x0050001c /* BASE_ADDRESS_4 Register */
#define BCHP_PCIE_CFG_CARDBUS_CIS_POINTER        0x00500028 /* CARDBUS_CIS_POINTER Register */
#define BCHP_PCIE_CFG_SUBSYSTEM_DEVICE_VENDOR_ID 0x0050002c /* SUBSYSTEM_DEVICE_VENDOR_ID Register */
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS 0x00500030 /* EXPANSION_ROM_BASE_ADDRESS Register */
#define BCHP_PCIE_CFG_CAPABILITIES_POINTER       0x00500034 /* CAPABILITIES_POINTER Register */
#define BCHP_PCIE_CFG_INTERRUPT                  0x0050003c /* INTERRUPT Register */
#define BCHP_PCIE_CFG_VPD_CAPABILITIES           0x00500040 /* VPD_CAPABILITIES Register */
#define BCHP_PCIE_CFG_VPD_DATA                   0x00500044 /* VPD_DATA Register */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY 0x00500048 /* POWER_MANAGEMENT_CAPABILITY Register */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS 0x0050004c /* POWER_MANAGEMENT_CONTROL_STATUS Register */
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER      0x00500050 /* MSI_CAPABILITY_HEADER Register */
#define BCHP_PCIE_CFG_MSI_LOWER_ADDRESS          0x00500054 /* MSI_LOWER_ADDRESS Register */
#define BCHP_PCIE_CFG_MSI_UPPER_ADDRESS_REGISTER 0x00500058 /* MSI_UPPER_ADDRESS_REGISTER Register */
#define BCHP_PCIE_CFG_MSI_DATA                   0x0050005c /* MSI_DATA Register */
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER 0x00500060 /* BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER Register */
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES 0x00500064 /* RESET_COUNTERS_INITIAL_VALUES Register */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL 0x00500068 /* MISCELLANEOUS_HOST_CONTROL Register */
#define BCHP_PCIE_CFG_SPARE                      0x0050006c /* SPARE Register */
#define BCHP_PCIE_CFG_PCI_STATE                  0x00500070 /* PCI_STATE Register */
#define BCHP_PCIE_CFG_CLOCK_CONTROL              0x00500074 /* CLOCK_CONTROL Register */
#define BCHP_PCIE_CFG_REGISTER_BASE              0x00500078 /* REGISTER_BASE Register */
#define BCHP_PCIE_CFG_MEMORY_BASE                0x0050007c /* MEMORY_BASE Register */
#define BCHP_PCIE_CFG_REGISTER_DATA              0x00500080 /* REGISTER_DATA Register */
#define BCHP_PCIE_CFG_MEMORY_DATA                0x00500084 /* MEMORY_DATA Register */
#define BCHP_PCIE_CFG_EXPANSION_ROM_BAR_SIZE     0x00500088 /* EXPANSION_ROM_BAR_SIZE Register */
#define BCHP_PCIE_CFG_EXPANSION_ROM_ADDRESS      0x0050008c /* EXPANSION_ROM_ADDRESS Register */
#define BCHP_PCIE_CFG_EXPANSION_ROM_DATA         0x00500090 /* EXPANSION_ROM_DATA Register */
#define BCHP_PCIE_CFG_VPD_INTERFACE              0x00500094 /* VPD_INTERFACE Register */
#define BCHP_PCIE_CFG_UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_UPPER 0x00500098 /* UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_UPPER Register */
#define BCHP_PCIE_CFG_UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_LOWER 0x0050009c /* UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_LOWER Register */
#define BCHP_PCIE_CFG_UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_UPPER 0x005000a0 /* UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_UPPER Register */
#define BCHP_PCIE_CFG_UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_LOWER 0x005000a4 /* UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_LOWER Register */
#define BCHP_PCIE_CFG_UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_UPPER 0x005000a8 /* UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_UPPER Register */
#define BCHP_PCIE_CFG_UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_LOWER 0x005000ac /* UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_LOWER Register */
#define BCHP_PCIE_CFG_INT_MAILBOX_UPPER          0x005000b0 /* INT_MAILBOX_UPPER Register */
#define BCHP_PCIE_CFG_INT_MAILBOX_LOWER          0x005000b4 /* INT_MAILBOX_LOWER Register */
#define BCHP_PCIE_CFG_PRODUCT_ID_AND_ASIC_REVISION 0x005000bc /* PRODUCT_ID_AND_ASIC_REVISION Register */
#define BCHP_PCIE_CFG_FUNCTION_EVENT             0x005000c0 /* FUNCTION_EVENT Register */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK        0x005000c4 /* FUNCTION_EVENT_MASK Register */
#define BCHP_PCIE_CFG_FUNCTION_PRESENT           0x005000c8 /* FUNCTION_PRESENT Register */
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES          0x005000cc /* PCIE_CAPABILITIES Register */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES        0x005000d0 /* DEVICE_CAPABILITIES Register */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL      0x005000d4 /* DEVICE_STATUS_CONTROL Register */
#define BCHP_PCIE_CFG_LINK_CAPABILITY            0x005000d8 /* LINK_CAPABILITY Register */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL        0x005000dc /* LINK_STATUS_CONTROL Register */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_2      0x005000f0 /* DEVICE_CAPABILITIES_2 Register */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_2    0x005000f4 /* DEVICE_STATUS_CONTROL_2 Register */
#define BCHP_PCIE_CFG_LINK_CAPABILITIES_2        0x005000f8 /* LINK_CAPABILITIES_2 Register */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_2      0x005000fc /* LINK_STATUS_CONTROL_2 Register */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER 0x00500100 /* ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER Register */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS 0x00500104 /* UNCORRECTABLE_ERROR_STATUS Register */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK   0x00500108 /* UNCORRECTABLE_ERROR_MASK Register */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY 0x0050010c /* UNCORRECTABLE_ERROR_SEVERITY Register */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS   0x00500110 /* CORRECTABLE_ERROR_STATUS Register */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK     0x00500114 /* CORRECTABLE_ERROR_MASK Register */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL 0x00500118 /* ADVANCED_ERROR_CAPABILITIES_AND_CONTROL Register */
#define BCHP_PCIE_CFG_HEADER_LOG_1               0x0050011c /* HEADER_LOG_1 Register */
#define BCHP_PCIE_CFG_HEADER_LOG_2               0x00500120 /* HEADER_LOG_2 Register */
#define BCHP_PCIE_CFG_HEADER_LOG_3               0x00500124 /* HEADER_LOG_3 Register */
#define BCHP_PCIE_CFG_HEADER_LOG_4               0x00500128 /* HEADER_LOG_4 Register */
#define BCHP_PCIE_CFG_VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER 0x0050013c /* VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER Register */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY         0x00500140 /* PORT_VC_CAPABILITY Register */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_2       0x00500144 /* PORT_VC_CAPABILITY_2 Register */
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL     0x00500148 /* PORT_VC_STATUS_CONTROL Register */
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY     0x0050014c /* VC_RESOURCE_CAPABILITY Register */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL        0x00500150 /* VC_RESOURCE_CONTROL Register */
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS         0x00500154 /* VC_RESOURCE_STATUS Register */
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER 0x00500160 /* DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER Register */
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_LOWER_DW  0x00500164 /* DEVICE_SERIAL_NO_LOWER_DW Register */
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_UPPER_DW  0x00500168 /* DEVICE_SERIAL_NO_UPPER_DW Register */
#define BCHP_PCIE_CFG_POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER 0x0050016c /* POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER Register */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_SELECT 0x00500170 /* POWER_BUDGETING_DATA_SELECT Register */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA       0x00500174 /* POWER_BUDGETING_DATA Register */
#define BCHP_PCIE_CFG_POWER_BUDGETING_CAPABILITY 0x00500178 /* POWER_BUDGETING_CAPABILITY Register */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1 0x0050017c /* FIRMWARE_POWER_BUDGETING_2_1 Register */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3 0x00500180 /* FIRMWARE_POWER_BUDGETING_4_3 Register */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5 0x00500184 /* FIRMWARE_POWER_BUDGETING_6_5 Register */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7 0x00500188 /* FIRMWARE_POWER_BUDGETING_8_7 Register */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING 0x0050018c /* PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING Register */

/***************************************************************************
 *DEVICE_VENDOR_ID - DEVICE_VENDOR_ID Register
 ***************************************************************************/
/* PCIE_CFG :: DEVICE_VENDOR_ID :: DEVICE_ID [31:16] */
#define BCHP_PCIE_CFG_DEVICE_VENDOR_ID_DEVICE_ID_MASK              0xffff0000
#define BCHP_PCIE_CFG_DEVICE_VENDOR_ID_DEVICE_ID_SHIFT             16

/* PCIE_CFG :: DEVICE_VENDOR_ID :: VENDOR_ID [15:00] */
#define BCHP_PCIE_CFG_DEVICE_VENDOR_ID_VENDOR_ID_MASK              0x0000ffff
#define BCHP_PCIE_CFG_DEVICE_VENDOR_ID_VENDOR_ID_SHIFT             0

/***************************************************************************
 *STATUS_COMMAND - STATUS_COMMAND Register
 ***************************************************************************/
/* PCIE_CFG :: STATUS_COMMAND :: DETECTED_PARITY_ERROR [31:31] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_DETECTED_PARITY_ERROR_MASK    0x80000000
#define BCHP_PCIE_CFG_STATUS_COMMAND_DETECTED_PARITY_ERROR_SHIFT   31

/* PCIE_CFG :: STATUS_COMMAND :: SIGNALED_SYSTEM_ERROR [30:30] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_SIGNALED_SYSTEM_ERROR_MASK    0x40000000
#define BCHP_PCIE_CFG_STATUS_COMMAND_SIGNALED_SYSTEM_ERROR_SHIFT   30

/* PCIE_CFG :: STATUS_COMMAND :: RECEIVED_MASTER_ABORT [29:29] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_RECEIVED_MASTER_ABORT_MASK    0x20000000
#define BCHP_PCIE_CFG_STATUS_COMMAND_RECEIVED_MASTER_ABORT_SHIFT   29

/* PCIE_CFG :: STATUS_COMMAND :: RECEIVED_TARGET_ABORT [28:28] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_RECEIVED_TARGET_ABORT_MASK    0x10000000
#define BCHP_PCIE_CFG_STATUS_COMMAND_RECEIVED_TARGET_ABORT_SHIFT   28

/* PCIE_CFG :: STATUS_COMMAND :: SIGNALED_TARGET_ABORT [27:27] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_SIGNALED_TARGET_ABORT_MASK    0x08000000
#define BCHP_PCIE_CFG_STATUS_COMMAND_SIGNALED_TARGET_ABORT_SHIFT   27

/* PCIE_CFG :: STATUS_COMMAND :: DEVSEL_TIMING [26:25] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_DEVSEL_TIMING_MASK            0x06000000
#define BCHP_PCIE_CFG_STATUS_COMMAND_DEVSEL_TIMING_SHIFT           25

/* PCIE_CFG :: STATUS_COMMAND :: MASTER_DATA_PARITY_ERROR [24:24] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_MASTER_DATA_PARITY_ERROR_MASK 0x01000000
#define BCHP_PCIE_CFG_STATUS_COMMAND_MASTER_DATA_PARITY_ERROR_SHIFT 24

/* PCIE_CFG :: STATUS_COMMAND :: FAST_BACK_TO_BACK_CAPABLE [23:23] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_FAST_BACK_TO_BACK_CAPABLE_MASK 0x00800000
#define BCHP_PCIE_CFG_STATUS_COMMAND_FAST_BACK_TO_BACK_CAPABLE_SHIFT 23

/* PCIE_CFG :: STATUS_COMMAND :: RESERVED_0 [22:22] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_RESERVED_0_MASK               0x00400000
#define BCHP_PCIE_CFG_STATUS_COMMAND_RESERVED_0_SHIFT              22

/* PCIE_CFG :: STATUS_COMMAND :: CAPABLE_66MHZ [21:21] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_CAPABLE_66MHZ_MASK            0x00200000
#define BCHP_PCIE_CFG_STATUS_COMMAND_CAPABLE_66MHZ_SHIFT           21

/* PCIE_CFG :: STATUS_COMMAND :: CAPABILITIES_LIST [20:20] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_CAPABILITIES_LIST_MASK        0x00100000
#define BCHP_PCIE_CFG_STATUS_COMMAND_CAPABILITIES_LIST_SHIFT       20

/* PCIE_CFG :: STATUS_COMMAND :: INTERRUPT_STATUS [19:19] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_INTERRUPT_STATUS_MASK         0x00080000
#define BCHP_PCIE_CFG_STATUS_COMMAND_INTERRUPT_STATUS_SHIFT        19

/* PCIE_CFG :: STATUS_COMMAND :: RESERVED_1 [18:16] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_RESERVED_1_MASK               0x00070000
#define BCHP_PCIE_CFG_STATUS_COMMAND_RESERVED_1_SHIFT              16

/* PCIE_CFG :: STATUS_COMMAND :: RESERVED_2 [15:11] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_RESERVED_2_MASK               0x0000f800
#define BCHP_PCIE_CFG_STATUS_COMMAND_RESERVED_2_SHIFT              11

/* PCIE_CFG :: STATUS_COMMAND :: INTERRUPT_DISABLE [10:10] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_INTERRUPT_DISABLE_MASK        0x00000400
#define BCHP_PCIE_CFG_STATUS_COMMAND_INTERRUPT_DISABLE_SHIFT       10

/* PCIE_CFG :: STATUS_COMMAND :: FAST_BACK_TO_BACK_ENABLE [09:09] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_FAST_BACK_TO_BACK_ENABLE_MASK 0x00000200
#define BCHP_PCIE_CFG_STATUS_COMMAND_FAST_BACK_TO_BACK_ENABLE_SHIFT 9

/* PCIE_CFG :: STATUS_COMMAND :: SYSTEM_ERROR_ENABLE [08:08] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_SYSTEM_ERROR_ENABLE_MASK      0x00000100
#define BCHP_PCIE_CFG_STATUS_COMMAND_SYSTEM_ERROR_ENABLE_SHIFT     8

/* PCIE_CFG :: STATUS_COMMAND :: STEPPING_CONTROL [07:07] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_STEPPING_CONTROL_MASK         0x00000080
#define BCHP_PCIE_CFG_STATUS_COMMAND_STEPPING_CONTROL_SHIFT        7

/* PCIE_CFG :: STATUS_COMMAND :: PARITY_ERROR_ENABLE [06:06] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_PARITY_ERROR_ENABLE_MASK      0x00000040
#define BCHP_PCIE_CFG_STATUS_COMMAND_PARITY_ERROR_ENABLE_SHIFT     6

/* PCIE_CFG :: STATUS_COMMAND :: VGA_PALETTE_SNOOP [05:05] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_VGA_PALETTE_SNOOP_MASK        0x00000020
#define BCHP_PCIE_CFG_STATUS_COMMAND_VGA_PALETTE_SNOOP_SHIFT       5

/* PCIE_CFG :: STATUS_COMMAND :: MEMORY_WRITE_AND_INVALIDATE [04:04] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_MEMORY_WRITE_AND_INVALIDATE_MASK 0x00000010
#define BCHP_PCIE_CFG_STATUS_COMMAND_MEMORY_WRITE_AND_INVALIDATE_SHIFT 4

/* PCIE_CFG :: STATUS_COMMAND :: SPECIAL_CYCLES [03:03] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_SPECIAL_CYCLES_MASK           0x00000008
#define BCHP_PCIE_CFG_STATUS_COMMAND_SPECIAL_CYCLES_SHIFT          3

/* PCIE_CFG :: STATUS_COMMAND :: BUS_MASTER [02:02] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_BUS_MASTER_MASK               0x00000004
#define BCHP_PCIE_CFG_STATUS_COMMAND_BUS_MASTER_SHIFT              2

/* PCIE_CFG :: STATUS_COMMAND :: MEMORY_SPACE [01:01] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_MEMORY_SPACE_MASK             0x00000002
#define BCHP_PCIE_CFG_STATUS_COMMAND_MEMORY_SPACE_SHIFT            1

/* PCIE_CFG :: STATUS_COMMAND :: I_O_SPACE [00:00] */
#define BCHP_PCIE_CFG_STATUS_COMMAND_I_O_SPACE_MASK                0x00000001
#define BCHP_PCIE_CFG_STATUS_COMMAND_I_O_SPACE_SHIFT               0

/***************************************************************************
 *PCI_CLASSCODE_AND_REVISION_ID - PCI_CLASSCODE_AND_REVISION_ID Register
 ***************************************************************************/
/* PCIE_CFG :: PCI_CLASSCODE_AND_REVISION_ID :: PCI_CLASSCODE [31:08] */
#define BCHP_PCIE_CFG_PCI_CLASSCODE_AND_REVISION_ID_PCI_CLASSCODE_MASK 0xffffff00
#define BCHP_PCIE_CFG_PCI_CLASSCODE_AND_REVISION_ID_PCI_CLASSCODE_SHIFT 8

/* PCIE_CFG :: PCI_CLASSCODE_AND_REVISION_ID :: REVISION_ID [07:00] */
#define BCHP_PCIE_CFG_PCI_CLASSCODE_AND_REVISION_ID_REVISION_ID_MASK 0x000000ff
#define BCHP_PCIE_CFG_PCI_CLASSCODE_AND_REVISION_ID_REVISION_ID_SHIFT 0

/***************************************************************************
 *BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE - BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE Register
 ***************************************************************************/
/* PCIE_CFG :: BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE :: BIST [31:24] */
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE_BIST_MASK 0xff000000
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE_BIST_SHIFT 24

/* PCIE_CFG :: BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE :: HEADER_TYPE [23:16] */
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE_HEADER_TYPE_MASK 0x00ff0000
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE_HEADER_TYPE_SHIFT 16

/* PCIE_CFG :: BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE :: LATENCY_TIMER [15:08] */
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE_LATENCY_TIMER_MASK 0x0000ff00
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE_LATENCY_TIMER_SHIFT 8

/* PCIE_CFG :: BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE :: CACHE_LINE_SIZE [07:00] */
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE_CACHE_LINE_SIZE_MASK 0x000000ff
#define BCHP_PCIE_CFG_BIST_HEADER_TYPE_LATENCY_TIMER_CACHE_LINE_SIZE_CACHE_LINE_SIZE_SHIFT 0

/***************************************************************************
 *BASE_ADDRESS_1 - BASE_ADDRESS_1 Register
 ***************************************************************************/
/* PCIE_CFG :: BASE_ADDRESS_1 :: BASE_ADDRESS [31:16] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_BASE_ADDRESS_MASK             0xffff0000
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_BASE_ADDRESS_SHIFT            16

/* PCIE_CFG :: BASE_ADDRESS_1 :: RESERVED_0 [15:04] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_RESERVED_0_MASK               0x0000fff0
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_RESERVED_0_SHIFT              4

/* PCIE_CFG :: BASE_ADDRESS_1 :: PREFETCHABLE [03:03] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_PREFETCHABLE_MASK             0x00000008
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_PREFETCHABLE_SHIFT            3

/* PCIE_CFG :: BASE_ADDRESS_1 :: TYPE [02:01] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_TYPE_MASK                     0x00000006
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_TYPE_SHIFT                    1

/* PCIE_CFG :: BASE_ADDRESS_1 :: MEMORY_SPACE_INDICATOR [00:00] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_MEMORY_SPACE_INDICATOR_MASK   0x00000001
#define BCHP_PCIE_CFG_BASE_ADDRESS_1_MEMORY_SPACE_INDICATOR_SHIFT  0

/***************************************************************************
 *BASE_ADDRESS_2 - BASE_ADDRESS_2 Register
 ***************************************************************************/
/* PCIE_CFG :: BASE_ADDRESS_2 :: EXTENDED_BASE_ADDRESS [31:00] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_2_EXTENDED_BASE_ADDRESS_MASK    0xffffffff
#define BCHP_PCIE_CFG_BASE_ADDRESS_2_EXTENDED_BASE_ADDRESS_SHIFT   0

/***************************************************************************
 *BASE_ADDRESS_3 - BASE_ADDRESS_3 Register
 ***************************************************************************/
/* PCIE_CFG :: BASE_ADDRESS_3 :: BASE_ADDRESS [31:16] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_BASE_ADDRESS_MASK             0xffff0000
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_BASE_ADDRESS_SHIFT            16

/* PCIE_CFG :: BASE_ADDRESS_3 :: RESERVED_0 [15:04] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_RESERVED_0_MASK               0x0000fff0
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_RESERVED_0_SHIFT              4

/* PCIE_CFG :: BASE_ADDRESS_3 :: PREFETCHABLE [03:03] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_PREFETCHABLE_MASK             0x00000008
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_PREFETCHABLE_SHIFT            3

/* PCIE_CFG :: BASE_ADDRESS_3 :: TYPE [02:01] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_TYPE_MASK                     0x00000006
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_TYPE_SHIFT                    1

/* PCIE_CFG :: BASE_ADDRESS_3 :: MEMORY_SPACE_INDICATOR [00:00] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_MEMORY_SPACE_INDICATOR_MASK   0x00000001
#define BCHP_PCIE_CFG_BASE_ADDRESS_3_MEMORY_SPACE_INDICATOR_SHIFT  0

/***************************************************************************
 *BASE_ADDRESS_4 - BASE_ADDRESS_4 Register
 ***************************************************************************/
/* PCIE_CFG :: BASE_ADDRESS_4 :: EXTENDED_BASE_ADDRESS [31:00] */
#define BCHP_PCIE_CFG_BASE_ADDRESS_4_EXTENDED_BASE_ADDRESS_MASK    0xffffffff
#define BCHP_PCIE_CFG_BASE_ADDRESS_4_EXTENDED_BASE_ADDRESS_SHIFT   0

/***************************************************************************
 *CARDBUS_CIS_POINTER - CARDBUS_CIS_POINTER Register
 ***************************************************************************/
/* PCIE_CFG :: CARDBUS_CIS_POINTER :: CARDBUS_CIS_POINTER [31:00] */
#define BCHP_PCIE_CFG_CARDBUS_CIS_POINTER_CARDBUS_CIS_POINTER_MASK 0xffffffff
#define BCHP_PCIE_CFG_CARDBUS_CIS_POINTER_CARDBUS_CIS_POINTER_SHIFT 0

/***************************************************************************
 *SUBSYSTEM_DEVICE_VENDOR_ID - SUBSYSTEM_DEVICE_VENDOR_ID Register
 ***************************************************************************/
/* PCIE_CFG :: SUBSYSTEM_DEVICE_VENDOR_ID :: SUBSYSTEM_DEVICE_ID [31:16] */
#define BCHP_PCIE_CFG_SUBSYSTEM_DEVICE_VENDOR_ID_SUBSYSTEM_DEVICE_ID_MASK 0xffff0000
#define BCHP_PCIE_CFG_SUBSYSTEM_DEVICE_VENDOR_ID_SUBSYSTEM_DEVICE_ID_SHIFT 16

/* PCIE_CFG :: SUBSYSTEM_DEVICE_VENDOR_ID :: SUBSYSTEM_VENDOR_ID [15:00] */
#define BCHP_PCIE_CFG_SUBSYSTEM_DEVICE_VENDOR_ID_SUBSYSTEM_VENDOR_ID_MASK 0x0000ffff
#define BCHP_PCIE_CFG_SUBSYSTEM_DEVICE_VENDOR_ID_SUBSYSTEM_VENDOR_ID_SHIFT 0

/***************************************************************************
 *EXPANSION_ROM_BASE_ADDRESS - EXPANSION_ROM_BASE_ADDRESS Register
 ***************************************************************************/
/* PCIE_CFG :: EXPANSION_ROM_BASE_ADDRESS :: ROM_BASE_ADDRESS [31:16] */
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS_ROM_BASE_ADDRESS_MASK 0xffff0000
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS_ROM_BASE_ADDRESS_SHIFT 16

/* PCIE_CFG :: EXPANSION_ROM_BASE_ADDRESS :: ROM_SIZE_INDICATION [15:11] */
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS_ROM_SIZE_INDICATION_MASK 0x0000f800
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS_ROM_SIZE_INDICATION_SHIFT 11

/* PCIE_CFG :: EXPANSION_ROM_BASE_ADDRESS :: RESERVED_0 [10:01] */
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS_RESERVED_0_MASK   0x000007fe
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS_RESERVED_0_SHIFT  1

/* PCIE_CFG :: EXPANSION_ROM_BASE_ADDRESS :: EXPANSION_ROM_ENABLE [00:00] */
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS_EXPANSION_ROM_ENABLE_MASK 0x00000001
#define BCHP_PCIE_CFG_EXPANSION_ROM_BASE_ADDRESS_EXPANSION_ROM_ENABLE_SHIFT 0

/***************************************************************************
 *CAPABILITIES_POINTER - CAPABILITIES_POINTER Register
 ***************************************************************************/
/* PCIE_CFG :: CAPABILITIES_POINTER :: CAPABILITIES_POINTER [31:00] */
#define BCHP_PCIE_CFG_CAPABILITIES_POINTER_CAPABILITIES_POINTER_MASK 0xffffffff
#define BCHP_PCIE_CFG_CAPABILITIES_POINTER_CAPABILITIES_POINTER_SHIFT 0

/***************************************************************************
 *INTERRUPT - INTERRUPT Register
 ***************************************************************************/
/* PCIE_CFG :: INTERRUPT :: RESERVED_0 [31:16] */
#define BCHP_PCIE_CFG_INTERRUPT_RESERVED_0_MASK                    0xffff0000
#define BCHP_PCIE_CFG_INTERRUPT_RESERVED_0_SHIFT                   16

/* PCIE_CFG :: INTERRUPT :: INTERRUPT_PIN [15:08] */
#define BCHP_PCIE_CFG_INTERRUPT_INTERRUPT_PIN_MASK                 0x0000ff00
#define BCHP_PCIE_CFG_INTERRUPT_INTERRUPT_PIN_SHIFT                8

/* PCIE_CFG :: INTERRUPT :: INTERRUPT_LINE [07:00] */
#define BCHP_PCIE_CFG_INTERRUPT_INTERRUPT_LINE_MASK                0x000000ff
#define BCHP_PCIE_CFG_INTERRUPT_INTERRUPT_LINE_SHIFT               0

/***************************************************************************
 *VPD_CAPABILITIES - VPD_CAPABILITIES Register
 ***************************************************************************/
/* PCIE_CFG :: VPD_CAPABILITIES :: RESERVED_0 [31:00] */
#define BCHP_PCIE_CFG_VPD_CAPABILITIES_RESERVED_0_MASK             0xffffffff
#define BCHP_PCIE_CFG_VPD_CAPABILITIES_RESERVED_0_SHIFT            0

/***************************************************************************
 *VPD_DATA - VPD_DATA Register
 ***************************************************************************/
/* PCIE_CFG :: VPD_DATA :: RESERVED_0 [31:00] */
#define BCHP_PCIE_CFG_VPD_DATA_RESERVED_0_MASK                     0xffffffff
#define BCHP_PCIE_CFG_VPD_DATA_RESERVED_0_SHIFT                    0

/***************************************************************************
 *POWER_MANAGEMENT_CAPABILITY - POWER_MANAGEMENT_CAPABILITY Register
 ***************************************************************************/
/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: PME_SUPPORT [31:27] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_PME_SUPPORT_MASK 0xf8000000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_PME_SUPPORT_SHIFT 27

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: D2_SUPPORT [26:26] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_D2_SUPPORT_MASK  0x04000000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_D2_SUPPORT_SHIFT 26

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: D1_SUPPORT [25:25] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_D1_SUPPORT_MASK  0x02000000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_D1_SUPPORT_SHIFT 25

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: AUX_CURRENT [24:22] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_AUX_CURRENT_MASK 0x01c00000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_AUX_CURRENT_SHIFT 22

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: DSI [21:21] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_DSI_MASK         0x00200000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_DSI_SHIFT        21

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: RESERVED_0 [20:20] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_RESERVED_0_MASK  0x00100000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_RESERVED_0_SHIFT 20

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: PME_CLOCK [19:19] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_PME_CLOCK_MASK   0x00080000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_PME_CLOCK_SHIFT  19

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: VERSION [18:16] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_VERSION_MASK     0x00070000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_VERSION_SHIFT    16

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: NEXT_POINTER [15:08] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_NEXT_POINTER_MASK 0x0000ff00
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_NEXT_POINTER_SHIFT 8

/* PCIE_CFG :: POWER_MANAGEMENT_CAPABILITY :: CAPABILITY_ID [07:00] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_CAPABILITY_ID_MASK 0x000000ff
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CAPABILITY_CAPABILITY_ID_SHIFT 0

/***************************************************************************
 *POWER_MANAGEMENT_CONTROL_STATUS - POWER_MANAGEMENT_CONTROL_STATUS Register
 ***************************************************************************/
/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: PM_DATA [31:24] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_PM_DATA_MASK 0xff000000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_PM_DATA_SHIFT 24

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: RESERVED_0 [23:16] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_RESERVED_0_MASK 0x00ff0000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_RESERVED_0_SHIFT 16

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: PME_STATUS [15:15] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_PME_STATUS_MASK 0x00008000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_PME_STATUS_SHIFT 15

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: DATA_SCALE [14:13] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_DATA_SCALE_MASK 0x00006000
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_DATA_SCALE_SHIFT 13

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: DATA_SELECT [12:09] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_DATA_SELECT_MASK 0x00001e00
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_DATA_SELECT_SHIFT 9

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: PME_ENABLE [08:08] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_PME_ENABLE_MASK 0x00000100
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_PME_ENABLE_SHIFT 8

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: RESERVED_1 [07:04] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_RESERVED_1_MASK 0x000000f0
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_RESERVED_1_SHIFT 4

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: NO_SOFT_RESET [03:03] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_NO_SOFT_RESET_MASK 0x00000008
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_NO_SOFT_RESET_SHIFT 3

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: RESERVED_2 [02:02] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_RESERVED_2_MASK 0x00000004
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_RESERVED_2_SHIFT 2

/* PCIE_CFG :: POWER_MANAGEMENT_CONTROL_STATUS :: POWER_STATE [01:00] */
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_POWER_STATE_MASK 0x00000003
#define BCHP_PCIE_CFG_POWER_MANAGEMENT_CONTROL_STATUS_POWER_STATE_SHIFT 0

/***************************************************************************
 *MSI_CAPABILITY_HEADER - MSI_CAPABILITY_HEADER Register
 ***************************************************************************/
/* PCIE_CFG :: MSI_CAPABILITY_HEADER :: MSI_CONTROL [31:24] */
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_MSI_CONTROL_MASK       0xff000000
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_MSI_CONTROL_SHIFT      24

/* PCIE_CFG :: MSI_CAPABILITY_HEADER :: ADDRESS_CAPABLE_64_BIT [23:23] */
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_ADDRESS_CAPABLE_64_BIT_MASK 0x00800000
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_ADDRESS_CAPABLE_64_BIT_SHIFT 23

/* PCIE_CFG :: MSI_CAPABILITY_HEADER :: MULTIPLE_MESSAGE_ENABLE [22:20] */
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_MULTIPLE_MESSAGE_ENABLE_MASK 0x00700000
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_MULTIPLE_MESSAGE_ENABLE_SHIFT 20

/* PCIE_CFG :: MSI_CAPABILITY_HEADER :: MULTIPLE_MESSAGE_CAPABLE [19:17] */
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_MULTIPLE_MESSAGE_CAPABLE_MASK 0x000e0000
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_MULTIPLE_MESSAGE_CAPABLE_SHIFT 17

/* PCIE_CFG :: MSI_CAPABILITY_HEADER :: MSI_ENABLE [16:16] */
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_MSI_ENABLE_MASK        0x00010000
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_MSI_ENABLE_SHIFT       16

/* PCIE_CFG :: MSI_CAPABILITY_HEADER :: NEXT_POINTER [15:08] */
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_NEXT_POINTER_MASK      0x0000ff00
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_NEXT_POINTER_SHIFT     8

/* PCIE_CFG :: MSI_CAPABILITY_HEADER :: CAPABILITY_ID [07:00] */
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_CAPABILITY_ID_MASK     0x000000ff
#define BCHP_PCIE_CFG_MSI_CAPABILITY_HEADER_CAPABILITY_ID_SHIFT    0

/***************************************************************************
 *MSI_LOWER_ADDRESS - MSI_LOWER_ADDRESS Register
 ***************************************************************************/
/* PCIE_CFG :: MSI_LOWER_ADDRESS :: MSI_LOWER_ADDRESS [31:02] */
#define BCHP_PCIE_CFG_MSI_LOWER_ADDRESS_MSI_LOWER_ADDRESS_MASK     0xfffffffc
#define BCHP_PCIE_CFG_MSI_LOWER_ADDRESS_MSI_LOWER_ADDRESS_SHIFT    2

/* PCIE_CFG :: MSI_LOWER_ADDRESS :: RESERVED_0 [01:00] */
#define BCHP_PCIE_CFG_MSI_LOWER_ADDRESS_RESERVED_0_MASK            0x00000003
#define BCHP_PCIE_CFG_MSI_LOWER_ADDRESS_RESERVED_0_SHIFT           0

/***************************************************************************
 *MSI_UPPER_ADDRESS_REGISTER - MSI_UPPER_ADDRESS_REGISTER Register
 ***************************************************************************/
/* PCIE_CFG :: MSI_UPPER_ADDRESS_REGISTER :: MSI_UPPER_ADDRESS [31:00] */
#define BCHP_PCIE_CFG_MSI_UPPER_ADDRESS_REGISTER_MSI_UPPER_ADDRESS_MASK 0xffffffff
#define BCHP_PCIE_CFG_MSI_UPPER_ADDRESS_REGISTER_MSI_UPPER_ADDRESS_SHIFT 0

/***************************************************************************
 *MSI_DATA - MSI_DATA Register
 ***************************************************************************/
/* PCIE_CFG :: MSI_DATA :: RESERVED_0 [31:16] */
#define BCHP_PCIE_CFG_MSI_DATA_RESERVED_0_MASK                     0xffff0000
#define BCHP_PCIE_CFG_MSI_DATA_RESERVED_0_SHIFT                    16

/* PCIE_CFG :: MSI_DATA :: MSI_DATA [15:00] */
#define BCHP_PCIE_CFG_MSI_DATA_MSI_DATA_MASK                       0x0000ffff
#define BCHP_PCIE_CFG_MSI_DATA_MSI_DATA_SHIFT                      0

/***************************************************************************
 *BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER - BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER Register
 ***************************************************************************/
/* PCIE_CFG :: BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER :: RESERVED_0 [31:24] */
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER_RESERVED_0_MASK 0xff000000
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER_RESERVED_0_SHIFT 24

/* PCIE_CFG :: BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER :: VENDOR_SPECIFIC_CAPABILITY_LENGTH [23:16] */
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER_VENDOR_SPECIFIC_CAPABILITY_LENGTH_MASK 0x00ff0000
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER_VENDOR_SPECIFIC_CAPABILITY_LENGTH_SHIFT 16

/* PCIE_CFG :: BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER :: NEXT_POINTER [15:08] */
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER_NEXT_POINTER_MASK 0x0000ff00
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER_NEXT_POINTER_SHIFT 8

/* PCIE_CFG :: BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER :: CAPABILITY_ID [07:00] */
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER_CAPABILITY_ID_MASK 0x000000ff
#define BCHP_PCIE_CFG_BROADCOM_VENDOR_SPECIFIC_CAPABILITY_HEADER_CAPABILITY_ID_SHIFT 0

/***************************************************************************
 *RESET_COUNTERS_INITIAL_VALUES - RESET_COUNTERS_INITIAL_VALUES Register
 ***************************************************************************/
/* PCIE_CFG :: RESET_COUNTERS_INITIAL_VALUES :: POR_RESET_COUNTER [31:28] */
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_POR_RESET_COUNTER_MASK 0xf0000000
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_POR_RESET_COUNTER_SHIFT 28

/* PCIE_CFG :: RESET_COUNTERS_INITIAL_VALUES :: HOT_RESET_COUNTER [27:24] */
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_HOT_RESET_COUNTER_MASK 0x0f000000
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_HOT_RESET_COUNTER_SHIFT 24

/* PCIE_CFG :: RESET_COUNTERS_INITIAL_VALUES :: GRC_RESET_COUNTER [23:16] */
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_GRC_RESET_COUNTER_MASK 0x00ff0000
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_GRC_RESET_COUNTER_SHIFT 16

/* PCIE_CFG :: RESET_COUNTERS_INITIAL_VALUES :: PERST_RESET_COUNTER [15:08] */
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_PERST_RESET_COUNTER_MASK 0x0000ff00
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_PERST_RESET_COUNTER_SHIFT 8

/* PCIE_CFG :: RESET_COUNTERS_INITIAL_VALUES :: LINKDOWN_RESET_COUNTER [07:00] */
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_LINKDOWN_RESET_COUNTER_MASK 0x000000ff
#define BCHP_PCIE_CFG_RESET_COUNTERS_INITIAL_VALUES_LINKDOWN_RESET_COUNTER_SHIFT 0

/***************************************************************************
 *MISCELLANEOUS_HOST_CONTROL - MISCELLANEOUS_HOST_CONTROL Register
 ***************************************************************************/
/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: PRODUCT_ID [31:24] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_PRODUCT_ID_MASK   0xff000000
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_PRODUCT_ID_SHIFT  24

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ASIC_REVISION_ID [23:16] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ASIC_REVISION_ID_MASK 0x00ff0000
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ASIC_REVISION_ID_SHIFT 16

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ENABLE_TLP_MINOR_ERROR_TOLERANCE [15:15] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_TLP_MINOR_ERROR_TOLERANCE_MASK 0x00008000
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_TLP_MINOR_ERROR_TOLERANCE_SHIFT 15

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: LOG_HEADER_OVERFLOW [14:14] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_LOG_HEADER_OVERFLOW_MASK 0x00004000
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_LOG_HEADER_OVERFLOW_SHIFT 14

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: BOUNDARY_CHECK [13:13] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_BOUNDARY_CHECK_MASK 0x00002000
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_BOUNDARY_CHECK_SHIFT 13

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: BYTE_ENABLE_RULE_CHECK [12:12] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_BYTE_ENABLE_RULE_CHECK_MASK 0x00001000
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_BYTE_ENABLE_RULE_CHECK_SHIFT 12

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: INTERRUPT_CHECK [11:11] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_INTERRUPT_CHECK_MASK 0x00000800
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_INTERRUPT_CHECK_SHIFT 11

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: RCB_CHECK [10:10] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_RCB_CHECK_MASK    0x00000400
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_RCB_CHECK_SHIFT   10

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ENABLE_TAGGED_STATUS_MODE [09:09] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_TAGGED_STATUS_MODE_MASK 0x00000200
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_TAGGED_STATUS_MODE_SHIFT 9

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: MASK_INTERRUPT_MODE [08:08] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_MASK_INTERRUPT_MODE_MASK 0x00000100
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_MASK_INTERRUPT_MODE_SHIFT 8

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ENABLE_INDIRECT_ACCESS [07:07] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_INDIRECT_ACCESS_MASK 0x00000080
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_INDIRECT_ACCESS_SHIFT 7

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ENABLE_REGISTER_WORD_SWAP [06:06] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_REGISTER_WORD_SWAP_MASK 0x00000040
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_REGISTER_WORD_SWAP_SHIFT 6

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ENABLE_CLOCK_CONTROL_REGISTER_READ_WRITE_CAPABILITY [05:05] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_CLOCK_CONTROL_REGISTER_READ_WRITE_CAPABILITY_MASK 0x00000020
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_CLOCK_CONTROL_REGISTER_READ_WRITE_CAPABILITY_SHIFT 5

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ENABLE_PCI_STATE_REGISTER_READ_WRITE_CAPABILITY [04:04] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_PCI_STATE_REGISTER_READ_WRITE_CAPABILITY_MASK 0x00000010
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_PCI_STATE_REGISTER_READ_WRITE_CAPABILITY_SHIFT 4

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ENABLE_ENDIAN_WORD_SWAP [03:03] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_ENDIAN_WORD_SWAP_MASK 0x00000008
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_ENDIAN_WORD_SWAP_SHIFT 3

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: ENABLE_ENDIAN_BYTE_SWAP [02:02] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_ENDIAN_BYTE_SWAP_MASK 0x00000004
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_ENABLE_ENDIAN_BYTE_SWAP_SHIFT 2

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: MASK_INTERRUPT [01:01] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_MASK_INTERRUPT_MASK 0x00000002
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_MASK_INTERRUPT_SHIFT 1

/* PCIE_CFG :: MISCELLANEOUS_HOST_CONTROL :: CLEAR_INTERRUPT [00:00] */
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_CLEAR_INTERRUPT_MASK 0x00000001
#define BCHP_PCIE_CFG_MISCELLANEOUS_HOST_CONTROL_CLEAR_INTERRUPT_SHIFT 0

/***************************************************************************
 *SPARE - SPARE Register
 ***************************************************************************/
/* PCIE_CFG :: SPARE :: UNUSED_0 [31:16] */
#define BCHP_PCIE_CFG_SPARE_UNUSED_0_MASK                          0xffff0000
#define BCHP_PCIE_CFG_SPARE_UNUSED_0_SHIFT                         16

/* PCIE_CFG :: SPARE :: RESERVED_0 [15:15] */
#define BCHP_PCIE_CFG_SPARE_RESERVED_0_MASK                        0x00008000
#define BCHP_PCIE_CFG_SPARE_RESERVED_0_SHIFT                       15

/* PCIE_CFG :: SPARE :: UNUSED_1 [14:02] */
#define BCHP_PCIE_CFG_SPARE_UNUSED_1_MASK                          0x00007ffc
#define BCHP_PCIE_CFG_SPARE_UNUSED_1_SHIFT                         2

/* PCIE_CFG :: SPARE :: BAR2_TARGET_WORD_SWAP [01:01] */
#define BCHP_PCIE_CFG_SPARE_BAR2_TARGET_WORD_SWAP_MASK             0x00000002
#define BCHP_PCIE_CFG_SPARE_BAR2_TARGET_WORD_SWAP_SHIFT            1

/* PCIE_CFG :: SPARE :: BAR2_TARGET_BYTE_SWAP [00:00] */
#define BCHP_PCIE_CFG_SPARE_BAR2_TARGET_BYTE_SWAP_MASK             0x00000001
#define BCHP_PCIE_CFG_SPARE_BAR2_TARGET_BYTE_SWAP_SHIFT            0

/***************************************************************************
 *PCI_STATE - PCI_STATE Register
 ***************************************************************************/
/* PCIE_CFG :: PCI_STATE :: RESERVED_0 [31:16] */
#define BCHP_PCIE_CFG_PCI_STATE_RESERVED_0_MASK                    0xffff0000
#define BCHP_PCIE_CFG_PCI_STATE_RESERVED_0_SHIFT                   16

/* PCIE_CFG :: PCI_STATE :: CONFIG_RETRY [15:15] */
#define BCHP_PCIE_CFG_PCI_STATE_CONFIG_RETRY_MASK                  0x00008000
#define BCHP_PCIE_CFG_PCI_STATE_CONFIG_RETRY_SHIFT                 15

/* PCIE_CFG :: PCI_STATE :: RESERVED_1 [14:12] */
#define BCHP_PCIE_CFG_PCI_STATE_RESERVED_1_MASK                    0x00007000
#define BCHP_PCIE_CFG_PCI_STATE_RESERVED_1_SHIFT                   12

/* PCIE_CFG :: PCI_STATE :: MAX_PCI_TARGET_RETRY [11:09] */
#define BCHP_PCIE_CFG_PCI_STATE_MAX_PCI_TARGET_RETRY_MASK          0x00000e00
#define BCHP_PCIE_CFG_PCI_STATE_MAX_PCI_TARGET_RETRY_SHIFT         9

/* PCIE_CFG :: PCI_STATE :: FLAT_VIEW [08:08] */
#define BCHP_PCIE_CFG_PCI_STATE_FLAT_VIEW_MASK                     0x00000100
#define BCHP_PCIE_CFG_PCI_STATE_FLAT_VIEW_SHIFT                    8

/* PCIE_CFG :: PCI_STATE :: VPD_AVAILABLE [07:07] */
#define BCHP_PCIE_CFG_PCI_STATE_VPD_AVAILABLE_MASK                 0x00000080
#define BCHP_PCIE_CFG_PCI_STATE_VPD_AVAILABLE_SHIFT                7

/* PCIE_CFG :: PCI_STATE :: PCI_EXPANSION_ROM_RETRY [06:06] */
#define BCHP_PCIE_CFG_PCI_STATE_PCI_EXPANSION_ROM_RETRY_MASK       0x00000040
#define BCHP_PCIE_CFG_PCI_STATE_PCI_EXPANSION_ROM_RETRY_SHIFT      6

/* PCIE_CFG :: PCI_STATE :: PCI_EXPANSION_ROM_DESIRED [05:05] */
#define BCHP_PCIE_CFG_PCI_STATE_PCI_EXPANSION_ROM_DESIRED_MASK     0x00000020
#define BCHP_PCIE_CFG_PCI_STATE_PCI_EXPANSION_ROM_DESIRED_SHIFT    5

/* PCIE_CFG :: PCI_STATE :: RESERVED_2 [04:00] */
#define BCHP_PCIE_CFG_PCI_STATE_RESERVED_2_MASK                    0x0000001f
#define BCHP_PCIE_CFG_PCI_STATE_RESERVED_2_SHIFT                   0

/***************************************************************************
 *CLOCK_CONTROL - CLOCK_CONTROL Register
 ***************************************************************************/
/* PCIE_CFG :: CLOCK_CONTROL :: PL_CLOCK_DISABLE [31:31] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_PL_CLOCK_DISABLE_MASK          0x80000000
#define BCHP_PCIE_CFG_CLOCK_CONTROL_PL_CLOCK_DISABLE_SHIFT         31

/* PCIE_CFG :: CLOCK_CONTROL :: DLL_CLOCK_DISABLE [30:30] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_DLL_CLOCK_DISABLE_MASK         0x40000000
#define BCHP_PCIE_CFG_CLOCK_CONTROL_DLL_CLOCK_DISABLE_SHIFT        30

/* PCIE_CFG :: CLOCK_CONTROL :: TL_CLOCK_DISABLE [29:29] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_TL_CLOCK_DISABLE_MASK          0x20000000
#define BCHP_PCIE_CFG_CLOCK_CONTROL_TL_CLOCK_DISABLE_SHIFT         29

/* PCIE_CFG :: CLOCK_CONTROL :: PCI_EXPRESS_CLOCK_TO_CORE_CLOCK [28:28] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_PCI_EXPRESS_CLOCK_TO_CORE_CLOCK_MASK 0x10000000
#define BCHP_PCIE_CFG_CLOCK_CONTROL_PCI_EXPRESS_CLOCK_TO_CORE_CLOCK_SHIFT 28

/* PCIE_CFG :: CLOCK_CONTROL :: UNUSED_0 [27:21] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_UNUSED_0_MASK                  0x0fe00000
#define BCHP_PCIE_CFG_CLOCK_CONTROL_UNUSED_0_SHIFT                 21

/* PCIE_CFG :: CLOCK_CONTROL :: SELECT_FINAL_ALT_CLOCK_SOURCE [20:20] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_SELECT_FINAL_ALT_CLOCK_SOURCE_MASK 0x00100000
#define BCHP_PCIE_CFG_CLOCK_CONTROL_SELECT_FINAL_ALT_CLOCK_SOURCE_SHIFT 20

/* PCIE_CFG :: CLOCK_CONTROL :: UNUSED_1 [19:13] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_UNUSED_1_MASK                  0x000fe000
#define BCHP_PCIE_CFG_CLOCK_CONTROL_UNUSED_1_SHIFT                 13

/* PCIE_CFG :: CLOCK_CONTROL :: SELECT_ALT_CLOCK [12:12] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_SELECT_ALT_CLOCK_MASK          0x00001000
#define BCHP_PCIE_CFG_CLOCK_CONTROL_SELECT_ALT_CLOCK_SHIFT         12

/* PCIE_CFG :: CLOCK_CONTROL :: UNUSED_2 [11:08] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_UNUSED_2_MASK                  0x00000f00
#define BCHP_PCIE_CFG_CLOCK_CONTROL_UNUSED_2_SHIFT                 8

/* PCIE_CFG :: CLOCK_CONTROL :: UNUSED_3 [07:00] */
#define BCHP_PCIE_CFG_CLOCK_CONTROL_UNUSED_3_MASK                  0x000000ff
#define BCHP_PCIE_CFG_CLOCK_CONTROL_UNUSED_3_SHIFT                 0

/***************************************************************************
 *REGISTER_BASE - REGISTER_BASE Register
 ***************************************************************************/
/* PCIE_CFG :: REGISTER_BASE :: RESERVED_0 [31:18] */
#define BCHP_PCIE_CFG_REGISTER_BASE_RESERVED_0_MASK                0xfffc0000
#define BCHP_PCIE_CFG_REGISTER_BASE_RESERVED_0_SHIFT               18

/* PCIE_CFG :: REGISTER_BASE :: REGISTER_BASE_REGISTER [17:02] */
#define BCHP_PCIE_CFG_REGISTER_BASE_REGISTER_BASE_REGISTER_MASK    0x0003fffc
#define BCHP_PCIE_CFG_REGISTER_BASE_REGISTER_BASE_REGISTER_SHIFT   2

/* PCIE_CFG :: REGISTER_BASE :: RESERVED_1 [01:00] */
#define BCHP_PCIE_CFG_REGISTER_BASE_RESERVED_1_MASK                0x00000003
#define BCHP_PCIE_CFG_REGISTER_BASE_RESERVED_1_SHIFT               0

/***************************************************************************
 *MEMORY_BASE - MEMORY_BASE Register
 ***************************************************************************/
/* PCIE_CFG :: MEMORY_BASE :: RESERVED_0 [31:24] */
#define BCHP_PCIE_CFG_MEMORY_BASE_RESERVED_0_MASK                  0xff000000
#define BCHP_PCIE_CFG_MEMORY_BASE_RESERVED_0_SHIFT                 24

/* PCIE_CFG :: MEMORY_BASE :: MEMORY_BASE_REGISTER [23:02] */
#define BCHP_PCIE_CFG_MEMORY_BASE_MEMORY_BASE_REGISTER_MASK        0x00fffffc
#define BCHP_PCIE_CFG_MEMORY_BASE_MEMORY_BASE_REGISTER_SHIFT       2

/* PCIE_CFG :: MEMORY_BASE :: RESERVED_1 [01:00] */
#define BCHP_PCIE_CFG_MEMORY_BASE_RESERVED_1_MASK                  0x00000003
#define BCHP_PCIE_CFG_MEMORY_BASE_RESERVED_1_SHIFT                 0

/***************************************************************************
 *REGISTER_DATA - REGISTER_DATA Register
 ***************************************************************************/
/* PCIE_CFG :: REGISTER_DATA :: REGISTER_DATA_REGISTER [31:00] */
#define BCHP_PCIE_CFG_REGISTER_DATA_REGISTER_DATA_REGISTER_MASK    0xffffffff
#define BCHP_PCIE_CFG_REGISTER_DATA_REGISTER_DATA_REGISTER_SHIFT   0

/***************************************************************************
 *MEMORY_DATA - MEMORY_DATA Register
 ***************************************************************************/
/* PCIE_CFG :: MEMORY_DATA :: MEMORY_DATA_REGISTER [31:00] */
#define BCHP_PCIE_CFG_MEMORY_DATA_MEMORY_DATA_REGISTER_MASK        0xffffffff
#define BCHP_PCIE_CFG_MEMORY_DATA_MEMORY_DATA_REGISTER_SHIFT       0

/***************************************************************************
 *EXPANSION_ROM_BAR_SIZE - EXPANSION_ROM_BAR_SIZE Register
 ***************************************************************************/
/* PCIE_CFG :: EXPANSION_ROM_BAR_SIZE :: RESERVED_0 [31:04] */
#define BCHP_PCIE_CFG_EXPANSION_ROM_BAR_SIZE_RESERVED_0_MASK       0xfffffff0
#define BCHP_PCIE_CFG_EXPANSION_ROM_BAR_SIZE_RESERVED_0_SHIFT      4

/* PCIE_CFG :: EXPANSION_ROM_BAR_SIZE :: BAR_SIZE [03:00] */
#define BCHP_PCIE_CFG_EXPANSION_ROM_BAR_SIZE_BAR_SIZE_MASK         0x0000000f
#define BCHP_PCIE_CFG_EXPANSION_ROM_BAR_SIZE_BAR_SIZE_SHIFT        0

/***************************************************************************
 *EXPANSION_ROM_ADDRESS - EXPANSION_ROM_ADDRESS Register
 ***************************************************************************/
/* PCIE_CFG :: EXPANSION_ROM_ADDRESS :: ROM_CTL_ADDR [31:00] */
#define BCHP_PCIE_CFG_EXPANSION_ROM_ADDRESS_ROM_CTL_ADDR_MASK      0xffffffff
#define BCHP_PCIE_CFG_EXPANSION_ROM_ADDRESS_ROM_CTL_ADDR_SHIFT     0

/***************************************************************************
 *EXPANSION_ROM_DATA - EXPANSION_ROM_DATA Register
 ***************************************************************************/
/* PCIE_CFG :: EXPANSION_ROM_DATA :: ROM_DATA [31:00] */
#define BCHP_PCIE_CFG_EXPANSION_ROM_DATA_ROM_DATA_MASK             0xffffffff
#define BCHP_PCIE_CFG_EXPANSION_ROM_DATA_ROM_DATA_SHIFT            0

/***************************************************************************
 *VPD_INTERFACE - VPD_INTERFACE Register
 ***************************************************************************/
/* PCIE_CFG :: VPD_INTERFACE :: RESERVED_0 [31:01] */
#define BCHP_PCIE_CFG_VPD_INTERFACE_RESERVED_0_MASK                0xfffffffe
#define BCHP_PCIE_CFG_VPD_INTERFACE_RESERVED_0_SHIFT               1

/* PCIE_CFG :: VPD_INTERFACE :: VPD_REQUEST [00:00] */
#define BCHP_PCIE_CFG_VPD_INTERFACE_VPD_REQUEST_MASK               0x00000001
#define BCHP_PCIE_CFG_VPD_INTERFACE_VPD_REQUEST_SHIFT              0

/***************************************************************************
 *UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_UPPER - UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_UPPER Register
 ***************************************************************************/
/* PCIE_CFG :: UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_UPPER :: UNDI_RECEIVE_BD_STANDARD_RING_PRODUCER_INDEX [31:00] */
#define BCHP_PCIE_CFG_UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_UPPER_UNDI_RECEIVE_BD_STANDARD_RING_PRODUCER_INDEX_MASK 0xffffffff
#define BCHP_PCIE_CFG_UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_UPPER_UNDI_RECEIVE_BD_STANDARD_RING_PRODUCER_INDEX_SHIFT 0

/***************************************************************************
 *UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_LOWER - UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_LOWER Register
 ***************************************************************************/
/* PCIE_CFG :: UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_LOWER :: UNDI_RECEIVE_BD_STANDARD_RING_PRODUCER_INDEX [31:00] */
#define BCHP_PCIE_CFG_UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_LOWER_UNDI_RECEIVE_BD_STANDARD_RING_PRODUCER_INDEX_MASK 0xffffffff
#define BCHP_PCIE_CFG_UNDI_RECEIVE_BD_STANDARD_PRODUCER_RING_PRODUCER_INDEX_MAILBOX_LOWER_UNDI_RECEIVE_BD_STANDARD_RING_PRODUCER_INDEX_SHIFT 0

/***************************************************************************
 *UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_UPPER - UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_UPPER Register
 ***************************************************************************/
/* PCIE_CFG :: UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_UPPER :: UNDI_RECEIVE_RETURN_C_IDX [31:00] */
#define BCHP_PCIE_CFG_UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_UPPER_UNDI_RECEIVE_RETURN_C_IDX_MASK 0xffffffff
#define BCHP_PCIE_CFG_UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_UPPER_UNDI_RECEIVE_RETURN_C_IDX_SHIFT 0

/***************************************************************************
 *UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_LOWER - UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_LOWER Register
 ***************************************************************************/
/* PCIE_CFG :: UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_LOWER :: UNDI_RECEIVE_RETURN_C_IDX [31:00] */
#define BCHP_PCIE_CFG_UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_LOWER_UNDI_RECEIVE_RETURN_C_IDX_MASK 0xffffffff
#define BCHP_PCIE_CFG_UNDI_RECEIVE_RETURN_RING_CONSUMER_INDEX_LOWER_UNDI_RECEIVE_RETURN_C_IDX_SHIFT 0

/***************************************************************************
 *UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_UPPER - UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_UPPER Register
 ***************************************************************************/
/* PCIE_CFG :: UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_UPPER :: UNDI_SEND_BD_NIC_P_IDX [31:00] */
#define BCHP_PCIE_CFG_UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_UPPER_UNDI_SEND_BD_NIC_P_IDX_MASK 0xffffffff
#define BCHP_PCIE_CFG_UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_UPPER_UNDI_SEND_BD_NIC_P_IDX_SHIFT 0

/***************************************************************************
 *UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_LOWER - UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_LOWER Register
 ***************************************************************************/
/* PCIE_CFG :: UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_LOWER :: UNDI_SEND_BD_NIC_P_IDX [31:00] */
#define BCHP_PCIE_CFG_UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_LOWER_UNDI_SEND_BD_NIC_P_IDX_MASK 0xffffffff
#define BCHP_PCIE_CFG_UNDI_SEND_BD_PRODUCER_INDEX_MAILBOX_LOWER_UNDI_SEND_BD_NIC_P_IDX_SHIFT 0

/***************************************************************************
 *INT_MAILBOX_UPPER - INT_MAILBOX_UPPER Register
 ***************************************************************************/
/* PCIE_CFG :: INT_MAILBOX_UPPER :: INDIRECT_INTERRUPT_MAIL_BOX [31:00] */
#define BCHP_PCIE_CFG_INT_MAILBOX_UPPER_INDIRECT_INTERRUPT_MAIL_BOX_MASK 0xffffffff
#define BCHP_PCIE_CFG_INT_MAILBOX_UPPER_INDIRECT_INTERRUPT_MAIL_BOX_SHIFT 0

/***************************************************************************
 *INT_MAILBOX_LOWER - INT_MAILBOX_LOWER Register
 ***************************************************************************/
/* PCIE_CFG :: INT_MAILBOX_LOWER :: INDIRECT_INTERRUPT_MAIL_BOX [31:00] */
#define BCHP_PCIE_CFG_INT_MAILBOX_LOWER_INDIRECT_INTERRUPT_MAIL_BOX_MASK 0xffffffff
#define BCHP_PCIE_CFG_INT_MAILBOX_LOWER_INDIRECT_INTERRUPT_MAIL_BOX_SHIFT 0

/***************************************************************************
 *PRODUCT_ID_AND_ASIC_REVISION - PRODUCT_ID_AND_ASIC_REVISION Register
 ***************************************************************************/
/* PCIE_CFG :: PRODUCT_ID_AND_ASIC_REVISION :: RESERVED_0 [31:28] */
#define BCHP_PCIE_CFG_PRODUCT_ID_AND_ASIC_REVISION_RESERVED_0_MASK 0xf0000000
#define BCHP_PCIE_CFG_PRODUCT_ID_AND_ASIC_REVISION_RESERVED_0_SHIFT 28

/* PCIE_CFG :: PRODUCT_ID_AND_ASIC_REVISION :: PRODUCT_ID [27:08] */
#define BCHP_PCIE_CFG_PRODUCT_ID_AND_ASIC_REVISION_PRODUCT_ID_MASK 0x0fffff00
#define BCHP_PCIE_CFG_PRODUCT_ID_AND_ASIC_REVISION_PRODUCT_ID_SHIFT 8

/* PCIE_CFG :: PRODUCT_ID_AND_ASIC_REVISION :: ASIC_REVISION_ID [07:00] */
#define BCHP_PCIE_CFG_PRODUCT_ID_AND_ASIC_REVISION_ASIC_REVISION_ID_MASK 0x000000ff
#define BCHP_PCIE_CFG_PRODUCT_ID_AND_ASIC_REVISION_ASIC_REVISION_ID_SHIFT 0

/***************************************************************************
 *FUNCTION_EVENT - FUNCTION_EVENT Register
 ***************************************************************************/
/* PCIE_CFG :: FUNCTION_EVENT :: RESERVED_0 [31:16] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_RESERVED_0_MASK               0xffff0000
#define BCHP_PCIE_CFG_FUNCTION_EVENT_RESERVED_0_SHIFT              16

/* PCIE_CFG :: FUNCTION_EVENT :: INTA_EVENT [15:15] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_INTA_EVENT_MASK               0x00008000
#define BCHP_PCIE_CFG_FUNCTION_EVENT_INTA_EVENT_SHIFT              15

/* PCIE_CFG :: FUNCTION_EVENT :: RESERVED_1 [14:05] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_RESERVED_1_MASK               0x00007fe0
#define BCHP_PCIE_CFG_FUNCTION_EVENT_RESERVED_1_SHIFT              5

/* PCIE_CFG :: FUNCTION_EVENT :: GWAKE_EVENT [04:04] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_GWAKE_EVENT_MASK              0x00000010
#define BCHP_PCIE_CFG_FUNCTION_EVENT_GWAKE_EVENT_SHIFT             4

/* PCIE_CFG :: FUNCTION_EVENT :: RESERVED_2 [03:00] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_RESERVED_2_MASK               0x0000000f
#define BCHP_PCIE_CFG_FUNCTION_EVENT_RESERVED_2_SHIFT              0

/***************************************************************************
 *FUNCTION_EVENT_MASK - FUNCTION_EVENT_MASK Register
 ***************************************************************************/
/* PCIE_CFG :: FUNCTION_EVENT_MASK :: RESERVED_0 [31:16] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_RESERVED_0_MASK          0xffff0000
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_RESERVED_0_SHIFT         16

/* PCIE_CFG :: FUNCTION_EVENT_MASK :: INTA_MASK [15:15] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_INTA_MASK_MASK           0x00008000
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_INTA_MASK_SHIFT          15

/* PCIE_CFG :: FUNCTION_EVENT_MASK :: WAKE_UP_MASK [14:14] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_WAKE_UP_MASK_MASK        0x00004000
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_WAKE_UP_MASK_SHIFT       14

/* PCIE_CFG :: FUNCTION_EVENT_MASK :: RESERVED_1 [13:05] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_RESERVED_1_MASK          0x00003fe0
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_RESERVED_1_SHIFT         5

/* PCIE_CFG :: FUNCTION_EVENT_MASK :: GWAKE_MASK [04:04] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_GWAKE_MASK_MASK          0x00000010
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_GWAKE_MASK_SHIFT         4

/* PCIE_CFG :: FUNCTION_EVENT_MASK :: RESERVED_2 [03:00] */
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_RESERVED_2_MASK          0x0000000f
#define BCHP_PCIE_CFG_FUNCTION_EVENT_MASK_RESERVED_2_SHIFT         0

/***************************************************************************
 *FUNCTION_PRESENT - FUNCTION_PRESENT Register
 ***************************************************************************/
/* PCIE_CFG :: FUNCTION_PRESENT :: RESERVED_0 [31:16] */
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_RESERVED_0_MASK             0xffff0000
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_RESERVED_0_SHIFT            16

/* PCIE_CFG :: FUNCTION_PRESENT :: INTA_STATUS [15:15] */
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_INTA_STATUS_MASK            0x00008000
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_INTA_STATUS_SHIFT           15

/* PCIE_CFG :: FUNCTION_PRESENT :: RESERVED_1 [14:05] */
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_RESERVED_1_MASK             0x00007fe0
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_RESERVED_1_SHIFT            5

/* PCIE_CFG :: FUNCTION_PRESENT :: PME_STATUS [04:04] */
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_PME_STATUS_MASK             0x00000010
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_PME_STATUS_SHIFT            4

/* PCIE_CFG :: FUNCTION_PRESENT :: RESERVED_2 [03:00] */
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_RESERVED_2_MASK             0x0000000f
#define BCHP_PCIE_CFG_FUNCTION_PRESENT_RESERVED_2_SHIFT            0

/***************************************************************************
 *PCIE_CAPABILITIES - PCIE_CAPABILITIES Register
 ***************************************************************************/
/* PCIE_CFG :: PCIE_CAPABILITIES :: RESERVED_0 [31:30] */
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_RESERVED_0_MASK            0xc0000000
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_RESERVED_0_SHIFT           30

/* PCIE_CFG :: PCIE_CAPABILITIES :: INTERRUPT_MESSAGE_NUMBER [29:25] */
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_INTERRUPT_MESSAGE_NUMBER_MASK 0x3e000000
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_INTERRUPT_MESSAGE_NUMBER_SHIFT 25

/* PCIE_CFG :: PCIE_CAPABILITIES :: SLOT_IMPLEMENTED [24:24] */
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_SLOT_IMPLEMENTED_MASK      0x01000000
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_SLOT_IMPLEMENTED_SHIFT     24

/* PCIE_CFG :: PCIE_CAPABILITIES :: DEVICE_PORT_TYPE [23:20] */
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_DEVICE_PORT_TYPE_MASK      0x00f00000
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_DEVICE_PORT_TYPE_SHIFT     20

/* PCIE_CFG :: PCIE_CAPABILITIES :: CAPABILITY_VERSION [19:16] */
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_CAPABILITY_VERSION_MASK    0x000f0000
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_CAPABILITY_VERSION_SHIFT   16

/* PCIE_CFG :: PCIE_CAPABILITIES :: NEXT_POINTER [15:08] */
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_NEXT_POINTER_MASK          0x0000ff00
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_NEXT_POINTER_SHIFT         8

/* PCIE_CFG :: PCIE_CAPABILITIES :: CAPABILITY_ID [07:00] */
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_CAPABILITY_ID_MASK         0x000000ff
#define BCHP_PCIE_CFG_PCIE_CAPABILITIES_CAPABILITY_ID_SHIFT        0

/***************************************************************************
 *DEVICE_CAPABILITIES - DEVICE_CAPABILITIES Register
 ***************************************************************************/
/* PCIE_CFG :: DEVICE_CAPABILITIES :: RESERVED_0 [31:28] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_RESERVED_0_MASK          0xf0000000
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_RESERVED_0_SHIFT         28

/* PCIE_CFG :: DEVICE_CAPABILITIES :: CAPTURED_SLOT_POWER_LIMIT_SCALE [27:26] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_CAPTURED_SLOT_POWER_LIMIT_SCALE_MASK 0x0c000000
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_CAPTURED_SLOT_POWER_LIMIT_SCALE_SHIFT 26

/* PCIE_CFG :: DEVICE_CAPABILITIES :: CAPTURED_SLOT_POWER_LIMIT_VALUE [25:18] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_CAPTURED_SLOT_POWER_LIMIT_VALUE_MASK 0x03fc0000
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_CAPTURED_SLOT_POWER_LIMIT_VALUE_SHIFT 18

/* PCIE_CFG :: DEVICE_CAPABILITIES :: RESERVED_1 [17:16] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_RESERVED_1_MASK          0x00030000
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_RESERVED_1_SHIFT         16

/* PCIE_CFG :: DEVICE_CAPABILITIES :: ROLE_BASED_ERROR_SUPPORT [15:15] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ROLE_BASED_ERROR_SUPPORT_MASK 0x00008000
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ROLE_BASED_ERROR_SUPPORT_SHIFT 15

/* PCIE_CFG :: DEVICE_CAPABILITIES :: POWER_INDICATOR_PRESENT [14:14] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_POWER_INDICATOR_PRESENT_MASK 0x00004000
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_POWER_INDICATOR_PRESENT_SHIFT 14

/* PCIE_CFG :: DEVICE_CAPABILITIES :: ATTENTION_INDICATOR_PRESENT [13:13] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ATTENTION_INDICATOR_PRESENT_MASK 0x00002000
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ATTENTION_INDICATOR_PRESENT_SHIFT 13

/* PCIE_CFG :: DEVICE_CAPABILITIES :: ATTENTION_BUTTON_PRESENT [12:12] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ATTENTION_BUTTON_PRESENT_MASK 0x00001000
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ATTENTION_BUTTON_PRESENT_SHIFT 12

/* PCIE_CFG :: DEVICE_CAPABILITIES :: ENDPOINT_L1_ACCEPTABLE_LATENCY [11:09] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ENDPOINT_L1_ACCEPTABLE_LATENCY_MASK 0x00000e00
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ENDPOINT_L1_ACCEPTABLE_LATENCY_SHIFT 9

/* PCIE_CFG :: DEVICE_CAPABILITIES :: ENDPOINT_L0S_ACCEPTABLE_LATENCY [08:06] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ENDPOINT_L0S_ACCEPTABLE_LATENCY_MASK 0x000001c0
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_ENDPOINT_L0S_ACCEPTABLE_LATENCY_SHIFT 6

/* PCIE_CFG :: DEVICE_CAPABILITIES :: EXTENDED_TAG_FIELD_SUPPORTED [05:05] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_EXTENDED_TAG_FIELD_SUPPORTED_MASK 0x00000020
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_EXTENDED_TAG_FIELD_SUPPORTED_SHIFT 5

/* PCIE_CFG :: DEVICE_CAPABILITIES :: PHANTOM_FUNCTIONS_SUPPORTED [04:03] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_PHANTOM_FUNCTIONS_SUPPORTED_MASK 0x00000018
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_PHANTOM_FUNCTIONS_SUPPORTED_SHIFT 3

/* PCIE_CFG :: DEVICE_CAPABILITIES :: MAX_PAYLOAD_SIZE_SUPPORTED [02:00] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_MAX_PAYLOAD_SIZE_SUPPORTED_MASK 0x00000007
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_MAX_PAYLOAD_SIZE_SUPPORTED_SHIFT 0

/***************************************************************************
 *DEVICE_STATUS_CONTROL - DEVICE_STATUS_CONTROL Register
 ***************************************************************************/
/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: RESERVED_0 [31:22] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_RESERVED_0_MASK        0xffc00000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_RESERVED_0_SHIFT       22

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: TRANSACTION_PENDING [21:21] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_TRANSACTION_PENDING_MASK 0x00200000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_TRANSACTION_PENDING_SHIFT 21

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: AUX_POWER_DETECTED [20:20] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_AUX_POWER_DETECTED_MASK 0x00100000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_AUX_POWER_DETECTED_SHIFT 20

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: UNSUPPORTED_REQUEST_DETECTED [19:19] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_UNSUPPORTED_REQUEST_DETECTED_MASK 0x00080000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_UNSUPPORTED_REQUEST_DETECTED_SHIFT 19

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: FATAL_ERROR_DETECTED [18:18] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_FATAL_ERROR_DETECTED_MASK 0x00040000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_FATAL_ERROR_DETECTED_SHIFT 18

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: NON_FATAL_ERROR_DETECTED [17:17] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_NON_FATAL_ERROR_DETECTED_MASK 0x00020000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_NON_FATAL_ERROR_DETECTED_SHIFT 17

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: CORRECTABLE_ERROR_DETECTED [16:16] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_CORRECTABLE_ERROR_DETECTED_MASK 0x00010000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_CORRECTABLE_ERROR_DETECTED_SHIFT 16

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: RESERVED_1 [15:15] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_RESERVED_1_MASK        0x00008000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_RESERVED_1_SHIFT       15

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: MAX_READ_REQUEST_SIZE [14:12] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_MAX_READ_REQUEST_SIZE_MASK 0x00007000
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_MAX_READ_REQUEST_SIZE_SHIFT 12

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: ENABLE_NO_SNOOP [11:11] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_ENABLE_NO_SNOOP_MASK   0x00000800
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_ENABLE_NO_SNOOP_SHIFT  11

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: AUX_POWER_PM_ENABLE [10:10] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_AUX_POWER_PM_ENABLE_MASK 0x00000400
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_AUX_POWER_PM_ENABLE_SHIFT 10

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: PHANTOM_FUNCTIONS_ENABLE [09:09] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_PHANTOM_FUNCTIONS_ENABLE_MASK 0x00000200
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_PHANTOM_FUNCTIONS_ENABLE_SHIFT 9

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: EXTENDED_TAG_FIELD_ENABLE [08:08] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_EXTENDED_TAG_FIELD_ENABLE_MASK 0x00000100
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_EXTENDED_TAG_FIELD_ENABLE_SHIFT 8

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: MAX_PAYLOAD_SIZE [07:05] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_MAX_PAYLOAD_SIZE_MASK  0x000000e0
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_MAX_PAYLOAD_SIZE_SHIFT 5

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: ENABLED_RELAXED_ORDERING [04:04] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_ENABLED_RELAXED_ORDERING_MASK 0x00000010
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_ENABLED_RELAXED_ORDERING_SHIFT 4

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: UNSUPPORTED_REQUEST_REPORTING_ENABLE [03:03] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_UNSUPPORTED_REQUEST_REPORTING_ENABLE_MASK 0x00000008
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_UNSUPPORTED_REQUEST_REPORTING_ENABLE_SHIFT 3

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: FATAL_ERROR_REPORTING_ENABLED [02:02] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_FATAL_ERROR_REPORTING_ENABLED_MASK 0x00000004
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_FATAL_ERROR_REPORTING_ENABLED_SHIFT 2

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: NON_FATAL_ERROR_REPORTING_ENABLED [01:01] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_NON_FATAL_ERROR_REPORTING_ENABLED_MASK 0x00000002
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_NON_FATAL_ERROR_REPORTING_ENABLED_SHIFT 1

/* PCIE_CFG :: DEVICE_STATUS_CONTROL :: CORRECTABLE_ERROR_REPORTING_ENABLED [00:00] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_CORRECTABLE_ERROR_REPORTING_ENABLED_MASK 0x00000001
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_CORRECTABLE_ERROR_REPORTING_ENABLED_SHIFT 0

/***************************************************************************
 *LINK_CAPABILITY - LINK_CAPABILITY Register
 ***************************************************************************/
/* PCIE_CFG :: LINK_CAPABILITY :: PORT_NUMBER [31:24] */
#define BCHP_PCIE_CFG_LINK_CAPABILITY_PORT_NUMBER_MASK             0xff000000
#define BCHP_PCIE_CFG_LINK_CAPABILITY_PORT_NUMBER_SHIFT            24

/* PCIE_CFG :: LINK_CAPABILITY :: RESERVED_0 [23:19] */
#define BCHP_PCIE_CFG_LINK_CAPABILITY_RESERVED_0_MASK              0x00f80000
#define BCHP_PCIE_CFG_LINK_CAPABILITY_RESERVED_0_SHIFT             19

/* PCIE_CFG :: LINK_CAPABILITY :: CLOCK_POWER_MANAGEMENT [18:18] */
#define BCHP_PCIE_CFG_LINK_CAPABILITY_CLOCK_POWER_MANAGEMENT_MASK  0x00040000
#define BCHP_PCIE_CFG_LINK_CAPABILITY_CLOCK_POWER_MANAGEMENT_SHIFT 18

/* PCIE_CFG :: LINK_CAPABILITY :: L1_EXIT_LATENCY [17:15] */
#define BCHP_PCIE_CFG_LINK_CAPABILITY_L1_EXIT_LATENCY_MASK         0x00038000
#define BCHP_PCIE_CFG_LINK_CAPABILITY_L1_EXIT_LATENCY_SHIFT        15

/* PCIE_CFG :: LINK_CAPABILITY :: L0S_EXIT_LATENCY [14:12] */
#define BCHP_PCIE_CFG_LINK_CAPABILITY_L0S_EXIT_LATENCY_MASK        0x00007000
#define BCHP_PCIE_CFG_LINK_CAPABILITY_L0S_EXIT_LATENCY_SHIFT       12

/* PCIE_CFG :: LINK_CAPABILITY :: ACTIVE_STATE_POWER_MANAGEMENT_SUPPORT [11:10] */
#define BCHP_PCIE_CFG_LINK_CAPABILITY_ACTIVE_STATE_POWER_MANAGEMENT_SUPPORT_MASK 0x00000c00
#define BCHP_PCIE_CFG_LINK_CAPABILITY_ACTIVE_STATE_POWER_MANAGEMENT_SUPPORT_SHIFT 10

/* PCIE_CFG :: LINK_CAPABILITY :: MAXIMUM_LINK_WIDTH [09:04] */
#define BCHP_PCIE_CFG_LINK_CAPABILITY_MAXIMUM_LINK_WIDTH_MASK      0x000003f0
#define BCHP_PCIE_CFG_LINK_CAPABILITY_MAXIMUM_LINK_WIDTH_SHIFT     4

/* PCIE_CFG :: LINK_CAPABILITY :: MAXIMUM_LINK_SPEED [03:00] */
#define BCHP_PCIE_CFG_LINK_CAPABILITY_MAXIMUM_LINK_SPEED_MASK      0x0000000f
#define BCHP_PCIE_CFG_LINK_CAPABILITY_MAXIMUM_LINK_SPEED_SHIFT     0

/***************************************************************************
 *LINK_STATUS_CONTROL - LINK_STATUS_CONTROL Register
 ***************************************************************************/
/* PCIE_CFG :: LINK_STATUS_CONTROL :: RESERVED_0 [31:29] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_0_MASK          0xe0000000
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_0_SHIFT         29

/* PCIE_CFG :: LINK_STATUS_CONTROL :: SLOT_CLOCK_CONFIGURATION [28:28] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_SLOT_CLOCK_CONFIGURATION_MASK 0x10000000
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_SLOT_CLOCK_CONFIGURATION_SHIFT 28

/* PCIE_CFG :: LINK_STATUS_CONTROL :: RESERVED_1 [27:26] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_1_MASK          0x0c000000
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_1_SHIFT         26

/* PCIE_CFG :: LINK_STATUS_CONTROL :: NEGOTIATED_LINK_WIDTH [25:20] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_NEGOTIATED_LINK_WIDTH_MASK 0x03f00000
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_NEGOTIATED_LINK_WIDTH_SHIFT 20

/* PCIE_CFG :: LINK_STATUS_CONTROL :: LINK_SPEED [19:16] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_LINK_SPEED_MASK          0x000f0000
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_LINK_SPEED_SHIFT         16

/* PCIE_CFG :: LINK_STATUS_CONTROL :: RESERVED_2 [15:09] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_2_MASK          0x0000fe00
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_2_SHIFT         9

/* PCIE_CFG :: LINK_STATUS_CONTROL :: CLOCK_REQUEST_ENABLE [08:08] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_CLOCK_REQUEST_ENABLE_MASK 0x00000100
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_CLOCK_REQUEST_ENABLE_SHIFT 8

/* PCIE_CFG :: LINK_STATUS_CONTROL :: EXTENDED_SYNCH [07:07] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_EXTENDED_SYNCH_MASK      0x00000080
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_EXTENDED_SYNCH_SHIFT     7

/* PCIE_CFG :: LINK_STATUS_CONTROL :: COMMON_CLOCK_CONFIGURATION [06:06] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_COMMON_CLOCK_CONFIGURATION_MASK 0x00000040
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_COMMON_CLOCK_CONFIGURATION_SHIFT 6

/* PCIE_CFG :: LINK_STATUS_CONTROL :: RESERVED_3 [05:05] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_3_MASK          0x00000020
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_3_SHIFT         5

/* PCIE_CFG :: LINK_STATUS_CONTROL :: RESERVED_4 [04:04] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_4_MASK          0x00000010
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_4_SHIFT         4

/* PCIE_CFG :: LINK_STATUS_CONTROL :: READ_COMPLETION_BOUNDARY [03:03] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_READ_COMPLETION_BOUNDARY_MASK 0x00000008
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_READ_COMPLETION_BOUNDARY_SHIFT 3

/* PCIE_CFG :: LINK_STATUS_CONTROL :: RESERVED_5 [02:02] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_5_MASK          0x00000004
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_RESERVED_5_SHIFT         2

/* PCIE_CFG :: LINK_STATUS_CONTROL :: ACTIVE_STATE_POWER_MANAGEMENT_CONTROL [01:00] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_ACTIVE_STATE_POWER_MANAGEMENT_CONTROL_MASK 0x00000003
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_ACTIVE_STATE_POWER_MANAGEMENT_CONTROL_SHIFT 0

/***************************************************************************
 *DEVICE_CAPABILITIES_2 - DEVICE_CAPABILITIES_2 Register
 ***************************************************************************/
/* PCIE_CFG :: DEVICE_CAPABILITIES_2 :: RESERVED_0 [31:05] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_2_RESERVED_0_MASK        0xffffffe0
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_2_RESERVED_0_SHIFT       5

/* PCIE_CFG :: DEVICE_CAPABILITIES_2 :: CPL_DISABLE_SUPPORTED [04:04] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_2_CPL_DISABLE_SUPPORTED_MASK 0x00000010
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_2_CPL_DISABLE_SUPPORTED_SHIFT 4

/* PCIE_CFG :: DEVICE_CAPABILITIES_2 :: CPL_TIMEOUT_RANGE_SUPPORTED [03:00] */
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_2_CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0x0000000f
#define BCHP_PCIE_CFG_DEVICE_CAPABILITIES_2_CPL_TIMEOUT_RANGE_SUPPORTED_SHIFT 0

/***************************************************************************
 *DEVICE_STATUS_CONTROL_2 - DEVICE_STATUS_CONTROL_2 Register
 ***************************************************************************/
/* PCIE_CFG :: DEVICE_STATUS_CONTROL_2 :: RESERVED_0 [31:05] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_2_RESERVED_0_MASK      0xffffffe0
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_2_RESERVED_0_SHIFT     5

/* PCIE_CFG :: DEVICE_STATUS_CONTROL_2 :: CPL_TIMEOUT_DISABLE [04:04] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_2_CPL_TIMEOUT_DISABLE_MASK 0x00000010
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_2_CPL_TIMEOUT_DISABLE_SHIFT 4

/* PCIE_CFG :: DEVICE_STATUS_CONTROL_2 :: CPL_TIMEOUT_VALUE [03:00] */
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_2_CPL_TIMEOUT_VALUE_MASK 0x0000000f
#define BCHP_PCIE_CFG_DEVICE_STATUS_CONTROL_2_CPL_TIMEOUT_VALUE_SHIFT 0

/***************************************************************************
 *LINK_CAPABILITIES_2 - LINK_CAPABILITIES_2 Register
 ***************************************************************************/
/* PCIE_CFG :: LINK_CAPABILITIES_2 :: RESERVED_0 [31:00] */
#define BCHP_PCIE_CFG_LINK_CAPABILITIES_2_RESERVED_0_MASK          0xffffffff
#define BCHP_PCIE_CFG_LINK_CAPABILITIES_2_RESERVED_0_SHIFT         0

/***************************************************************************
 *LINK_STATUS_CONTROL_2 - LINK_STATUS_CONTROL_2 Register
 ***************************************************************************/
/* PCIE_CFG :: LINK_STATUS_CONTROL_2 :: RESERVED_0 [31:00] */
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_2_RESERVED_0_MASK        0xffffffff
#define BCHP_PCIE_CFG_LINK_STATUS_CONTROL_2_RESERVED_0_SHIFT       0

/***************************************************************************
 *ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER - ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER Register
 ***************************************************************************/
/* PCIE_CFG :: ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER :: NEXT_CAPABILITY_OFFSET [31:20] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER_NEXT_CAPABILITY_OFFSET_MASK 0xfff00000
#define BCHP_PCIE_CFG_ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER_NEXT_CAPABILITY_OFFSET_SHIFT 20

/* PCIE_CFG :: ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER :: CAPABILITY_VERSION [19:16] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER_CAPABILITY_VERSION_MASK 0x000f0000
#define BCHP_PCIE_CFG_ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER_CAPABILITY_VERSION_SHIFT 16

/* PCIE_CFG :: ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER :: PCIE_EXTENDED_CAPABILITY_ID [15:00] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER_PCIE_EXTENDED_CAPABILITY_ID_MASK 0x0000ffff
#define BCHP_PCIE_CFG_ADVANCED_ERROR_REPORTING_ENHANCED_CAPABILITY_HEADER_PCIE_EXTENDED_CAPABILITY_ID_SHIFT 0

/***************************************************************************
 *UNCORRECTABLE_ERROR_STATUS - UNCORRECTABLE_ERROR_STATUS Register
 ***************************************************************************/
/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: RESERVED_0 [31:21] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_RESERVED_0_MASK   0xffe00000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_RESERVED_0_SHIFT  21

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: UNSUPPORTED_REQUEST_ERROR_STATUS [20:20] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_UNSUPPORTED_REQUEST_ERROR_STATUS_MASK 0x00100000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_UNSUPPORTED_REQUEST_ERROR_STATUS_SHIFT 20

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: ECRC_ERROR_STATUS [19:19] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_ECRC_ERROR_STATUS_MASK 0x00080000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_ECRC_ERROR_STATUS_SHIFT 19

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: MALFORMED_TLP_STATUS [18:18] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_MALFORMED_TLP_STATUS_MASK 0x00040000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_MALFORMED_TLP_STATUS_SHIFT 18

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: RECEIVER_OVERFLOW_STATUS [17:17] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_RECEIVER_OVERFLOW_STATUS_MASK 0x00020000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_RECEIVER_OVERFLOW_STATUS_SHIFT 17

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: UNEXPECTED_COMPLETION_STATUS [16:16] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_UNEXPECTED_COMPLETION_STATUS_MASK 0x00010000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_UNEXPECTED_COMPLETION_STATUS_SHIFT 16

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: COMPLETER_ABORT_STATUS [15:15] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_COMPLETER_ABORT_STATUS_MASK 0x00008000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_COMPLETER_ABORT_STATUS_SHIFT 15

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: COMPLETION_TIMEOUT_STATUS [14:14] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_COMPLETION_TIMEOUT_STATUS_MASK 0x00004000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_COMPLETION_TIMEOUT_STATUS_SHIFT 14

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: FLOW_CONTROL_PROTOCOL_ERROR_STATUS [13:13] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_FLOW_CONTROL_PROTOCOL_ERROR_STATUS_MASK 0x00002000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_FLOW_CONTROL_PROTOCOL_ERROR_STATUS_SHIFT 13

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: POISONED_TLP_STATUS [12:12] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_POISONED_TLP_STATUS_MASK 0x00001000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_POISONED_TLP_STATUS_SHIFT 12

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: RESERVED_1 [11:05] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_RESERVED_1_MASK   0x00000fe0
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_RESERVED_1_SHIFT  5

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: DATA_LINK_PROTOCOL_ERROR_STATUS [04:04] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_DATA_LINK_PROTOCOL_ERROR_STATUS_MASK 0x00000010
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_DATA_LINK_PROTOCOL_ERROR_STATUS_SHIFT 4

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: RESERVED_2 [03:01] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_RESERVED_2_MASK   0x0000000e
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_RESERVED_2_SHIFT  1

/* PCIE_CFG :: UNCORRECTABLE_ERROR_STATUS :: TRAINING_ERROR_STATUS [00:00] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_TRAINING_ERROR_STATUS_MASK 0x00000001
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_STATUS_TRAINING_ERROR_STATUS_SHIFT 0

/***************************************************************************
 *UNCORRECTABLE_ERROR_MASK - UNCORRECTABLE_ERROR_MASK Register
 ***************************************************************************/
/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: RESERVED_0 [31:21] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_RESERVED_0_MASK     0xffe00000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_RESERVED_0_SHIFT    21

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: UNSUPPORTED_REQUEST_ERROR_MASK [20:20] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_UNSUPPORTED_REQUEST_ERROR_MASK_MASK 0x00100000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_UNSUPPORTED_REQUEST_ERROR_MASK_SHIFT 20

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: ECRC_ERROR_MASK [19:19] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_ECRC_ERROR_MASK_MASK 0x00080000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_ECRC_ERROR_MASK_SHIFT 19

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: MALFORMED_TLP_MASK [18:18] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_MALFORMED_TLP_MASK_MASK 0x00040000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_MALFORMED_TLP_MASK_SHIFT 18

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: RECEIVER_OVERFLOW_MASK [17:17] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_RECEIVER_OVERFLOW_MASK_MASK 0x00020000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_RECEIVER_OVERFLOW_MASK_SHIFT 17

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: UNEXPECTED_COMPLETION_MASK [16:16] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_UNEXPECTED_COMPLETION_MASK_MASK 0x00010000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_UNEXPECTED_COMPLETION_MASK_SHIFT 16

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: COMPLETER_ABORT_MASK [15:15] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_COMPLETER_ABORT_MASK_MASK 0x00008000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_COMPLETER_ABORT_MASK_SHIFT 15

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: COMPLETION_TIMEOUT_MASK [14:14] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_COMPLETION_TIMEOUT_MASK_MASK 0x00004000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_COMPLETION_TIMEOUT_MASK_SHIFT 14

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: FLOW_CONTROL_PROTOCOL_ERROR_MASK [13:13] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_FLOW_CONTROL_PROTOCOL_ERROR_MASK_MASK 0x00002000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_FLOW_CONTROL_PROTOCOL_ERROR_MASK_SHIFT 13

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: POISONED_TLP_MASK [12:12] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_POISONED_TLP_MASK_MASK 0x00001000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_POISONED_TLP_MASK_SHIFT 12

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: RESERVED_1 [11:05] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_RESERVED_1_MASK     0x00000fe0
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_RESERVED_1_SHIFT    5

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: DATA_LINK_PROTOCOL_ERROR_MASK [04:04] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_DATA_LINK_PROTOCOL_ERROR_MASK_MASK 0x00000010
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_DATA_LINK_PROTOCOL_ERROR_MASK_SHIFT 4

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: RESERVED_2 [03:01] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_RESERVED_2_MASK     0x0000000e
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_RESERVED_2_SHIFT    1

/* PCIE_CFG :: UNCORRECTABLE_ERROR_MASK :: TRAINING_ERROR_MASK [00:00] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_TRAINING_ERROR_MASK_MASK 0x00000001
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_MASK_TRAINING_ERROR_MASK_SHIFT 0

/***************************************************************************
 *UNCORRECTABLE_ERROR_SEVERITY - UNCORRECTABLE_ERROR_SEVERITY Register
 ***************************************************************************/
/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: RESERVED_0 [31:21] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_RESERVED_0_MASK 0xffe00000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_RESERVED_0_SHIFT 21

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: UNSUPPORTED_REQUEST_ERROR_SEVERITY [20:20] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_UNSUPPORTED_REQUEST_ERROR_SEVERITY_MASK 0x00100000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_UNSUPPORTED_REQUEST_ERROR_SEVERITY_SHIFT 20

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: ECRC_ERROR_SEVERITY [19:19] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_ECRC_ERROR_SEVERITY_MASK 0x00080000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_ECRC_ERROR_SEVERITY_SHIFT 19

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: MALFORMED_TLP_SEVERITY [18:18] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_MALFORMED_TLP_SEVERITY_MASK 0x00040000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_MALFORMED_TLP_SEVERITY_SHIFT 18

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: RECEIVER_OVERFLOW_ERROR_SEVERITY [17:17] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_RECEIVER_OVERFLOW_ERROR_SEVERITY_MASK 0x00020000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_RECEIVER_OVERFLOW_ERROR_SEVERITY_SHIFT 17

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: UNEXPECTED_COMPLETION_ERROR_SEVERITY [16:16] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_UNEXPECTED_COMPLETION_ERROR_SEVERITY_MASK 0x00010000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_UNEXPECTED_COMPLETION_ERROR_SEVERITY_SHIFT 16

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: COMPLETER_ABORT_ERROR_SEVERITY [15:15] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_COMPLETER_ABORT_ERROR_SEVERITY_MASK 0x00008000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_COMPLETER_ABORT_ERROR_SEVERITY_SHIFT 15

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: COMPLETION_TIMEOUT_ERROR_SEVERITY [14:14] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_COMPLETION_TIMEOUT_ERROR_SEVERITY_MASK 0x00004000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_COMPLETION_TIMEOUT_ERROR_SEVERITY_SHIFT 14

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY [13:13] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY_MASK 0x00002000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY_SHIFT 13

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: POISONED_TLP_SEVERITY [12:12] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_POISONED_TLP_SEVERITY_MASK 0x00001000
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_POISONED_TLP_SEVERITY_SHIFT 12

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: RESERVED_1 [11:05] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_RESERVED_1_MASK 0x00000fe0
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_RESERVED_1_SHIFT 5

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: DATA_LINK_PROTOCOL_ERROR_SEVERITY [04:04] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_DATA_LINK_PROTOCOL_ERROR_SEVERITY_MASK 0x00000010
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_DATA_LINK_PROTOCOL_ERROR_SEVERITY_SHIFT 4

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: RESERVED_2 [03:01] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_RESERVED_2_MASK 0x0000000e
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_RESERVED_2_SHIFT 1

/* PCIE_CFG :: UNCORRECTABLE_ERROR_SEVERITY :: TRAINING_ERROR_SEVERITY [00:00] */
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_TRAINING_ERROR_SEVERITY_MASK 0x00000001
#define BCHP_PCIE_CFG_UNCORRECTABLE_ERROR_SEVERITY_TRAINING_ERROR_SEVERITY_SHIFT 0

/***************************************************************************
 *CORRECTABLE_ERROR_STATUS - CORRECTABLE_ERROR_STATUS Register
 ***************************************************************************/
/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: RESERVED_0 [31:14] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_RESERVED_0_MASK     0xffffc000
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_RESERVED_0_SHIFT    14

/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: ADVISORY_NON_FATAL_ERROR_STATUS [13:13] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_ADVISORY_NON_FATAL_ERROR_STATUS_MASK 0x00002000
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_ADVISORY_NON_FATAL_ERROR_STATUS_SHIFT 13

/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: REPLAY_TIMER_TIMEOUT_STATUS [12:12] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x00001000
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_REPLAY_TIMER_TIMEOUT_STATUS_SHIFT 12

/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: RESERVED_1 [11:09] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_RESERVED_1_MASK     0x00000e00
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_RESERVED_1_SHIFT    9

/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: REPLAY_NUM_ROLLOVER_STATUS [08:08] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_REPLAY_NUM_ROLLOVER_STATUS_MASK 0x00000100
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_REPLAY_NUM_ROLLOVER_STATUS_SHIFT 8

/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: BAD_DLLP_STATUS [07:07] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_BAD_DLLP_STATUS_MASK 0x00000080
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_BAD_DLLP_STATUS_SHIFT 7

/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: BAD_TLP_STATUS [06:06] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_BAD_TLP_STATUS_MASK 0x00000040
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_BAD_TLP_STATUS_SHIFT 6

/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: RESERVED_2 [05:01] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_RESERVED_2_MASK     0x0000003e
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_RESERVED_2_SHIFT    1

/* PCIE_CFG :: CORRECTABLE_ERROR_STATUS :: RECEIVER_ERROR_STATUS [00:00] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_RECEIVER_ERROR_STATUS_MASK 0x00000001
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_STATUS_RECEIVER_ERROR_STATUS_SHIFT 0

/***************************************************************************
 *CORRECTABLE_ERROR_MASK - CORRECTABLE_ERROR_MASK Register
 ***************************************************************************/
/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: RESERVED_0 [31:14] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_RESERVED_0_MASK       0xffffc000
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_RESERVED_0_SHIFT      14

/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: ADVISORY_NON_FATAL_ERROR_MASK [13:13] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_ADVISORY_NON_FATAL_ERROR_MASK_MASK 0x00002000
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_ADVISORY_NON_FATAL_ERROR_MASK_SHIFT 13

/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: REPLAY_TIMER_TIMEOUT_MASK [12:12] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_REPLAY_TIMER_TIMEOUT_MASK_MASK 0x00001000
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_REPLAY_TIMER_TIMEOUT_MASK_SHIFT 12

/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: RESERVED_1 [11:09] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_RESERVED_1_MASK       0x00000e00
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_RESERVED_1_SHIFT      9

/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: REPLAY_NUM_ROLLOVER_MASK [08:08] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_REPLAY_NUM_ROLLOVER_MASK_MASK 0x00000100
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_REPLAY_NUM_ROLLOVER_MASK_SHIFT 8

/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: BAD_DLLP_MASK [07:07] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_BAD_DLLP_MASK_MASK    0x00000080
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_BAD_DLLP_MASK_SHIFT   7

/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: BAD_TLP_MASK [06:06] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_BAD_TLP_MASK_MASK     0x00000040
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_BAD_TLP_MASK_SHIFT    6

/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: RESERVED_2 [05:01] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_RESERVED_2_MASK       0x0000003e
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_RESERVED_2_SHIFT      1

/* PCIE_CFG :: CORRECTABLE_ERROR_MASK :: RECEIVER_ERROR_MASK [00:00] */
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_RECEIVER_ERROR_MASK_MASK 0x00000001
#define BCHP_PCIE_CFG_CORRECTABLE_ERROR_MASK_RECEIVER_ERROR_MASK_SHIFT 0

/***************************************************************************
 *ADVANCED_ERROR_CAPABILITIES_AND_CONTROL - ADVANCED_ERROR_CAPABILITIES_AND_CONTROL Register
 ***************************************************************************/
/* PCIE_CFG :: ADVANCED_ERROR_CAPABILITIES_AND_CONTROL :: RESERVED_0 [31:09] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_RESERVED_0_MASK 0xfffffe00
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_RESERVED_0_SHIFT 9

/* PCIE_CFG :: ADVANCED_ERROR_CAPABILITIES_AND_CONTROL :: ECRC_CHECK_ENABLE [08:08] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_ECRC_CHECK_ENABLE_MASK 0x00000100
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_ECRC_CHECK_ENABLE_SHIFT 8

/* PCIE_CFG :: ADVANCED_ERROR_CAPABILITIES_AND_CONTROL :: ECRC_CHECK_CAPABLE [07:07] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_ECRC_CHECK_CAPABLE_MASK 0x00000080
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_ECRC_CHECK_CAPABLE_SHIFT 7

/* PCIE_CFG :: ADVANCED_ERROR_CAPABILITIES_AND_CONTROL :: ECRC_GENERATION_ENABLE [06:06] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_ECRC_GENERATION_ENABLE_MASK 0x00000040
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_ECRC_GENERATION_ENABLE_SHIFT 6

/* PCIE_CFG :: ADVANCED_ERROR_CAPABILITIES_AND_CONTROL :: ECRC_GENERATION_CAPABLE [05:05] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_ECRC_GENERATION_CAPABLE_MASK 0x00000020
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_ECRC_GENERATION_CAPABLE_SHIFT 5

/* PCIE_CFG :: ADVANCED_ERROR_CAPABILITIES_AND_CONTROL :: FIRST_ERROR_POINTER [04:00] */
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_FIRST_ERROR_POINTER_MASK 0x0000001f
#define BCHP_PCIE_CFG_ADVANCED_ERROR_CAPABILITIES_AND_CONTROL_FIRST_ERROR_POINTER_SHIFT 0

/***************************************************************************
 *HEADER_LOG_1 - HEADER_LOG_1 Register
 ***************************************************************************/
/* PCIE_CFG :: HEADER_LOG_1 :: HEADER_BYTE_0 [31:24] */
#define BCHP_PCIE_CFG_HEADER_LOG_1_HEADER_BYTE_0_MASK              0xff000000
#define BCHP_PCIE_CFG_HEADER_LOG_1_HEADER_BYTE_0_SHIFT             24

/* PCIE_CFG :: HEADER_LOG_1 :: HEADER_BYTE_1 [23:16] */
#define BCHP_PCIE_CFG_HEADER_LOG_1_HEADER_BYTE_1_MASK              0x00ff0000
#define BCHP_PCIE_CFG_HEADER_LOG_1_HEADER_BYTE_1_SHIFT             16

/* PCIE_CFG :: HEADER_LOG_1 :: HEADER_BYTE_2 [15:08] */
#define BCHP_PCIE_CFG_HEADER_LOG_1_HEADER_BYTE_2_MASK              0x0000ff00
#define BCHP_PCIE_CFG_HEADER_LOG_1_HEADER_BYTE_2_SHIFT             8

/* PCIE_CFG :: HEADER_LOG_1 :: HEADER_BYTE_3 [07:00] */
#define BCHP_PCIE_CFG_HEADER_LOG_1_HEADER_BYTE_3_MASK              0x000000ff
#define BCHP_PCIE_CFG_HEADER_LOG_1_HEADER_BYTE_3_SHIFT             0

/***************************************************************************
 *HEADER_LOG_2 - HEADER_LOG_2 Register
 ***************************************************************************/
/* PCIE_CFG :: HEADER_LOG_2 :: HEADER_BYTE_4 [31:24] */
#define BCHP_PCIE_CFG_HEADER_LOG_2_HEADER_BYTE_4_MASK              0xff000000
#define BCHP_PCIE_CFG_HEADER_LOG_2_HEADER_BYTE_4_SHIFT             24

/* PCIE_CFG :: HEADER_LOG_2 :: HEADER_BYTE_5 [23:16] */
#define BCHP_PCIE_CFG_HEADER_LOG_2_HEADER_BYTE_5_MASK              0x00ff0000
#define BCHP_PCIE_CFG_HEADER_LOG_2_HEADER_BYTE_5_SHIFT             16

/* PCIE_CFG :: HEADER_LOG_2 :: HEADER_BYTE_6 [15:08] */
#define BCHP_PCIE_CFG_HEADER_LOG_2_HEADER_BYTE_6_MASK              0x0000ff00
#define BCHP_PCIE_CFG_HEADER_LOG_2_HEADER_BYTE_6_SHIFT             8

/* PCIE_CFG :: HEADER_LOG_2 :: HEADER_BYTE_7 [07:00] */
#define BCHP_PCIE_CFG_HEADER_LOG_2_HEADER_BYTE_7_MASK              0x000000ff
#define BCHP_PCIE_CFG_HEADER_LOG_2_HEADER_BYTE_7_SHIFT             0

/***************************************************************************
 *HEADER_LOG_3 - HEADER_LOG_3 Register
 ***************************************************************************/
/* PCIE_CFG :: HEADER_LOG_3 :: HEADER_BYTE_8 [31:24] */
#define BCHP_PCIE_CFG_HEADER_LOG_3_HEADER_BYTE_8_MASK              0xff000000
#define BCHP_PCIE_CFG_HEADER_LOG_3_HEADER_BYTE_8_SHIFT             24

/* PCIE_CFG :: HEADER_LOG_3 :: HEADER_BYTE_9 [23:16] */
#define BCHP_PCIE_CFG_HEADER_LOG_3_HEADER_BYTE_9_MASK              0x00ff0000
#define BCHP_PCIE_CFG_HEADER_LOG_3_HEADER_BYTE_9_SHIFT             16

/* PCIE_CFG :: HEADER_LOG_3 :: HEADER_BYTE_10 [15:08] */
#define BCHP_PCIE_CFG_HEADER_LOG_3_HEADER_BYTE_10_MASK             0x0000ff00
#define BCHP_PCIE_CFG_HEADER_LOG_3_HEADER_BYTE_10_SHIFT            8

/* PCIE_CFG :: HEADER_LOG_3 :: HEADER_BYTE_11 [07:00] */
#define BCHP_PCIE_CFG_HEADER_LOG_3_HEADER_BYTE_11_MASK             0x000000ff
#define BCHP_PCIE_CFG_HEADER_LOG_3_HEADER_BYTE_11_SHIFT            0

/***************************************************************************
 *HEADER_LOG_4 - HEADER_LOG_4 Register
 ***************************************************************************/
/* PCIE_CFG :: HEADER_LOG_4 :: HEADER_BYTE_12 [31:24] */
#define BCHP_PCIE_CFG_HEADER_LOG_4_HEADER_BYTE_12_MASK             0xff000000
#define BCHP_PCIE_CFG_HEADER_LOG_4_HEADER_BYTE_12_SHIFT            24

/* PCIE_CFG :: HEADER_LOG_4 :: HEADER_BYTE_13 [23:16] */
#define BCHP_PCIE_CFG_HEADER_LOG_4_HEADER_BYTE_13_MASK             0x00ff0000
#define BCHP_PCIE_CFG_HEADER_LOG_4_HEADER_BYTE_13_SHIFT            16

/* PCIE_CFG :: HEADER_LOG_4 :: HEADER_BYTE_14 [15:08] */
#define BCHP_PCIE_CFG_HEADER_LOG_4_HEADER_BYTE_14_MASK             0x0000ff00
#define BCHP_PCIE_CFG_HEADER_LOG_4_HEADER_BYTE_14_SHIFT            8

/* PCIE_CFG :: HEADER_LOG_4 :: HEADER_BYTE_15 [07:00] */
#define BCHP_PCIE_CFG_HEADER_LOG_4_HEADER_BYTE_15_MASK             0x000000ff
#define BCHP_PCIE_CFG_HEADER_LOG_4_HEADER_BYTE_15_SHIFT            0

/***************************************************************************
 *VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER - VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER Register
 ***************************************************************************/
/* PCIE_CFG :: VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER :: NEXT_CAPABILITY_OFFSET [31:20] */
#define BCHP_PCIE_CFG_VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER_NEXT_CAPABILITY_OFFSET_MASK 0xfff00000
#define BCHP_PCIE_CFG_VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER_NEXT_CAPABILITY_OFFSET_SHIFT 20

/* PCIE_CFG :: VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER :: CAPABILITY_VERSION [19:16] */
#define BCHP_PCIE_CFG_VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER_CAPABILITY_VERSION_MASK 0x000f0000
#define BCHP_PCIE_CFG_VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER_CAPABILITY_VERSION_SHIFT 16

/* PCIE_CFG :: VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER :: PCIE_EXTENDED_CAPABILITY_ID [15:00] */
#define BCHP_PCIE_CFG_VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER_PCIE_EXTENDED_CAPABILITY_ID_MASK 0x0000ffff
#define BCHP_PCIE_CFG_VIRTUAL_CHANNEL_ENHANCED_CAPABILITY_HEADER_PCIE_EXTENDED_CAPABILITY_ID_SHIFT 0

/***************************************************************************
 *PORT_VC_CAPABILITY - PORT_VC_CAPABILITY Register
 ***************************************************************************/
/* PCIE_CFG :: PORT_VC_CAPABILITY :: RESERVED_0 [31:12] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_RESERVED_0_MASK           0xfffff000
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_RESERVED_0_SHIFT          12

/* PCIE_CFG :: PORT_VC_CAPABILITY :: PORT_ARBITRATION_TABLE_ENTRY_SIZE [11:10] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_PORT_ARBITRATION_TABLE_ENTRY_SIZE_MASK 0x00000c00
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_PORT_ARBITRATION_TABLE_ENTRY_SIZE_SHIFT 10

/* PCIE_CFG :: PORT_VC_CAPABILITY :: REFERENCE_CLOCK [09:08] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_REFERENCE_CLOCK_MASK      0x00000300
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_REFERENCE_CLOCK_SHIFT     8

/* PCIE_CFG :: PORT_VC_CAPABILITY :: RESERVED_1 [07:07] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_RESERVED_1_MASK           0x00000080
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_RESERVED_1_SHIFT          7

/* PCIE_CFG :: PORT_VC_CAPABILITY :: LOW_PRIORITY_EXTENDED_VC_COUNT [06:04] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_LOW_PRIORITY_EXTENDED_VC_COUNT_MASK 0x00000070
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_LOW_PRIORITY_EXTENDED_VC_COUNT_SHIFT 4

/* PCIE_CFG :: PORT_VC_CAPABILITY :: RESERVED_2 [03:03] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_RESERVED_2_MASK           0x00000008
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_RESERVED_2_SHIFT          3

/* PCIE_CFG :: PORT_VC_CAPABILITY :: EXTENDED_VC_COUNT [02:00] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_EXTENDED_VC_COUNT_MASK    0x00000007
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_EXTENDED_VC_COUNT_SHIFT   0

/***************************************************************************
 *PORT_VC_CAPABILITY_2 - PORT_VC_CAPABILITY_2 Register
 ***************************************************************************/
/* PCIE_CFG :: PORT_VC_CAPABILITY_2 :: VC_ARBITRATION_TABLE_OFFSET [31:24] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_2_VC_ARBITRATION_TABLE_OFFSET_MASK 0xff000000
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_2_VC_ARBITRATION_TABLE_OFFSET_SHIFT 24

/* PCIE_CFG :: PORT_VC_CAPABILITY_2 :: RESERVED_0 [23:08] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_2_RESERVED_0_MASK         0x00ffff00
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_2_RESERVED_0_SHIFT        8

/* PCIE_CFG :: PORT_VC_CAPABILITY_2 :: VC_ARBITRATION_CAPABILITY [07:00] */
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_2_VC_ARBITRATION_CAPABILITY_MASK 0x000000ff
#define BCHP_PCIE_CFG_PORT_VC_CAPABILITY_2_VC_ARBITRATION_CAPABILITY_SHIFT 0

/***************************************************************************
 *PORT_VC_STATUS_CONTROL - PORT_VC_STATUS_CONTROL Register
 ***************************************************************************/
/* PCIE_CFG :: PORT_VC_STATUS_CONTROL :: RESERVED_0 [31:17] */
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_RESERVED_0_MASK       0xfffe0000
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_RESERVED_0_SHIFT      17

/* PCIE_CFG :: PORT_VC_STATUS_CONTROL :: VC_ARBITRATION_TABLE_STATUS [16:16] */
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_VC_ARBITRATION_TABLE_STATUS_MASK 0x00010000
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_VC_ARBITRATION_TABLE_STATUS_SHIFT 16

/* PCIE_CFG :: PORT_VC_STATUS_CONTROL :: RESERVED_1 [15:04] */
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_RESERVED_1_MASK       0x0000fff0
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_RESERVED_1_SHIFT      4

/* PCIE_CFG :: PORT_VC_STATUS_CONTROL :: VC_ARBITRATION_SELECT [03:01] */
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_VC_ARBITRATION_SELECT_MASK 0x0000000e
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_VC_ARBITRATION_SELECT_SHIFT 1

/* PCIE_CFG :: PORT_VC_STATUS_CONTROL :: LOAD_VC_ARBITRATION_TABLE [00:00] */
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_LOAD_VC_ARBITRATION_TABLE_MASK 0x00000001
#define BCHP_PCIE_CFG_PORT_VC_STATUS_CONTROL_LOAD_VC_ARBITRATION_TABLE_SHIFT 0

/***************************************************************************
 *VC_RESOURCE_CAPABILITY - VC_RESOURCE_CAPABILITY Register
 ***************************************************************************/
/* PCIE_CFG :: VC_RESOURCE_CAPABILITY :: PORT_ARBITRATION_TABLE_OFFSET [31:24] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_PORT_ARBITRATION_TABLE_OFFSET_MASK 0xff000000
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_PORT_ARBITRATION_TABLE_OFFSET_SHIFT 24

/* PCIE_CFG :: VC_RESOURCE_CAPABILITY :: RESERVED_0 [23:23] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_RESERVED_0_MASK       0x00800000
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_RESERVED_0_SHIFT      23

/* PCIE_CFG :: VC_RESOURCE_CAPABILITY :: MAXIMUM_TIME_SLOTS [22:16] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_MAXIMUM_TIME_SLOTS_MASK 0x007f0000
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_MAXIMUM_TIME_SLOTS_SHIFT 16

/* PCIE_CFG :: VC_RESOURCE_CAPABILITY :: REJECT_SNOOP_TRANSACTIONS [15:15] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_REJECT_SNOOP_TRANSACTIONS_MASK 0x00008000
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_REJECT_SNOOP_TRANSACTIONS_SHIFT 15

/* PCIE_CFG :: VC_RESOURCE_CAPABILITY :: ADVANCED_PACKET_SWITCHING [14:14] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_ADVANCED_PACKET_SWITCHING_MASK 0x00004000
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_ADVANCED_PACKET_SWITCHING_SHIFT 14

/* PCIE_CFG :: VC_RESOURCE_CAPABILITY :: RESERVED_1 [13:08] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_RESERVED_1_MASK       0x00003f00
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_RESERVED_1_SHIFT      8

/* PCIE_CFG :: VC_RESOURCE_CAPABILITY :: PORT_ARBITRATION_CAPABILITY [07:00] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_PORT_ARBITRATION_CAPABILITY_MASK 0x000000ff
#define BCHP_PCIE_CFG_VC_RESOURCE_CAPABILITY_PORT_ARBITRATION_CAPABILITY_SHIFT 0

/***************************************************************************
 *VC_RESOURCE_CONTROL - VC_RESOURCE_CONTROL Register
 ***************************************************************************/
/* PCIE_CFG :: VC_RESOURCE_CONTROL :: VC_ENABLE [31:31] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_VC_ENABLE_MASK           0x80000000
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_VC_ENABLE_SHIFT          31

/* PCIE_CFG :: VC_RESOURCE_CONTROL :: RESERVED_0 [30:27] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_RESERVED_0_MASK          0x78000000
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_RESERVED_0_SHIFT         27

/* PCIE_CFG :: VC_RESOURCE_CONTROL :: VC_ID [26:24] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_VC_ID_MASK               0x07000000
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_VC_ID_SHIFT              24

/* PCIE_CFG :: VC_RESOURCE_CONTROL :: RESERVED_1 [23:20] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_RESERVED_1_MASK          0x00f00000
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_RESERVED_1_SHIFT         20

/* PCIE_CFG :: VC_RESOURCE_CONTROL :: PORT_ARBITRATION_SELECT [19:17] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_PORT_ARBITRATION_SELECT_MASK 0x000e0000
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_PORT_ARBITRATION_SELECT_SHIFT 17

/* PCIE_CFG :: VC_RESOURCE_CONTROL :: LOAD_PORT_ARBITRATION_TABLE [16:16] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_LOAD_PORT_ARBITRATION_TABLE_MASK 0x00010000
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_LOAD_PORT_ARBITRATION_TABLE_SHIFT 16

/* PCIE_CFG :: VC_RESOURCE_CONTROL :: RESERVED_2 [15:08] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_RESERVED_2_MASK          0x0000ff00
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_RESERVED_2_SHIFT         8

/* PCIE_CFG :: VC_RESOURCE_CONTROL :: TC_VC_MAP [07:00] */
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_TC_VC_MAP_MASK           0x000000ff
#define BCHP_PCIE_CFG_VC_RESOURCE_CONTROL_TC_VC_MAP_SHIFT          0

/***************************************************************************
 *VC_RESOURCE_STATUS - VC_RESOURCE_STATUS Register
 ***************************************************************************/
/* PCIE_CFG :: VC_RESOURCE_STATUS :: RESERVED_0 [31:18] */
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS_RESERVED_0_MASK           0xfffc0000
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS_RESERVED_0_SHIFT          18

/* PCIE_CFG :: VC_RESOURCE_STATUS :: VC_NEGOTIATION_PENDING [17:17] */
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS_VC_NEGOTIATION_PENDING_MASK 0x00020000
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS_VC_NEGOTIATION_PENDING_SHIFT 17

/* PCIE_CFG :: VC_RESOURCE_STATUS :: PORT_ARBITRATION_TABLE_STATUS [16:16] */
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS_PORT_ARBITRATION_TABLE_STATUS_MASK 0x00010000
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS_PORT_ARBITRATION_TABLE_STATUS_SHIFT 16

/* PCIE_CFG :: VC_RESOURCE_STATUS :: RESERVED_1 [15:00] */
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS_RESERVED_1_MASK           0x0000ffff
#define BCHP_PCIE_CFG_VC_RESOURCE_STATUS_RESERVED_1_SHIFT          0

/***************************************************************************
 *DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER - DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER Register
 ***************************************************************************/
/* PCIE_CFG :: DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER :: NEXT_CAPABILITY_OFFSET [31:20] */
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER_NEXT_CAPABILITY_OFFSET_MASK 0xfff00000
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER_NEXT_CAPABILITY_OFFSET_SHIFT 20

/* PCIE_CFG :: DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER :: CAPABILITY_VERSION [19:16] */
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER_CAPABILITY_VERSION_MASK 0x000f0000
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER_CAPABILITY_VERSION_SHIFT 16

/* PCIE_CFG :: DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER :: PCIE_EXTENDED_CAPABILITY_ID [15:00] */
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER_PCIE_EXTENDED_CAPABILITY_ID_MASK 0x0000ffff
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_ENHANCED_CAPABILITY_HEADER_PCIE_EXTENDED_CAPABILITY_ID_SHIFT 0

/***************************************************************************
 *DEVICE_SERIAL_NO_LOWER_DW - DEVICE_SERIAL_NO_LOWER_DW Register
 ***************************************************************************/
/* PCIE_CFG :: DEVICE_SERIAL_NO_LOWER_DW :: SERIAL_NO_LOWER [31:00] */
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_LOWER_DW_SERIAL_NO_LOWER_MASK 0xffffffff
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_LOWER_DW_SERIAL_NO_LOWER_SHIFT 0

/***************************************************************************
 *DEVICE_SERIAL_NO_UPPER_DW - DEVICE_SERIAL_NO_UPPER_DW Register
 ***************************************************************************/
/* PCIE_CFG :: DEVICE_SERIAL_NO_UPPER_DW :: SERIAL_NO_UPPER [31:00] */
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_UPPER_DW_SERIAL_NO_UPPER_MASK 0xffffffff
#define BCHP_PCIE_CFG_DEVICE_SERIAL_NO_UPPER_DW_SERIAL_NO_UPPER_SHIFT 0

/***************************************************************************
 *POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER - POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER Register
 ***************************************************************************/
/* PCIE_CFG :: POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER :: NEXT_CAPABILITY_OFFSET [31:20] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER_NEXT_CAPABILITY_OFFSET_MASK 0xfff00000
#define BCHP_PCIE_CFG_POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER_NEXT_CAPABILITY_OFFSET_SHIFT 20

/* PCIE_CFG :: POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER :: CAPABILITY_VERSION [19:16] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER_CAPABILITY_VERSION_MASK 0x000f0000
#define BCHP_PCIE_CFG_POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER_CAPABILITY_VERSION_SHIFT 16

/* PCIE_CFG :: POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER :: PCIE_EXTENDED_CAPABILITY_ID [15:00] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER_PCIE_EXTENDED_CAPABILITY_ID_MASK 0x0000ffff
#define BCHP_PCIE_CFG_POWER_BUDGETING_ENHANCED_CAPABILITY_HEADER_PCIE_EXTENDED_CAPABILITY_ID_SHIFT 0

/***************************************************************************
 *POWER_BUDGETING_DATA_SELECT - POWER_BUDGETING_DATA_SELECT Register
 ***************************************************************************/
/* PCIE_CFG :: POWER_BUDGETING_DATA_SELECT :: RESERVED_0 [31:08] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_SELECT_RESERVED_0_MASK  0xffffff00
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_SELECT_RESERVED_0_SHIFT 8

/* PCIE_CFG :: POWER_BUDGETING_DATA_SELECT :: DATA_SELECT [07:00] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_SELECT_DATA_SELECT_MASK 0x000000ff
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_SELECT_DATA_SELECT_SHIFT 0

/***************************************************************************
 *POWER_BUDGETING_DATA - POWER_BUDGETING_DATA Register
 ***************************************************************************/
/* PCIE_CFG :: POWER_BUDGETING_DATA :: RESERVED_0 [31:21] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_RESERVED_0_MASK         0xffe00000
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_RESERVED_0_SHIFT        21

/* PCIE_CFG :: POWER_BUDGETING_DATA :: POWER_RAIL [20:18] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_POWER_RAIL_MASK         0x001c0000
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_POWER_RAIL_SHIFT        18

/* PCIE_CFG :: POWER_BUDGETING_DATA :: TYPE [17:15] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_TYPE_MASK               0x00038000
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_TYPE_SHIFT              15

/* PCIE_CFG :: POWER_BUDGETING_DATA :: PM_STATE [14:13] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_PM_STATE_MASK           0x00006000
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_PM_STATE_SHIFT          13

/* PCIE_CFG :: POWER_BUDGETING_DATA :: PM_SUB_STATE [12:10] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_PM_SUB_STATE_MASK       0x00001c00
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_PM_SUB_STATE_SHIFT      10

/* PCIE_CFG :: POWER_BUDGETING_DATA :: DATA_SCALE [09:08] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_DATA_SCALE_MASK         0x00000300
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_DATA_SCALE_SHIFT        8

/* PCIE_CFG :: POWER_BUDGETING_DATA :: BASE_POWER [07:00] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_BASE_POWER_MASK         0x000000ff
#define BCHP_PCIE_CFG_POWER_BUDGETING_DATA_BASE_POWER_SHIFT        0

/***************************************************************************
 *POWER_BUDGETING_CAPABILITY - POWER_BUDGETING_CAPABILITY Register
 ***************************************************************************/
/* PCIE_CFG :: POWER_BUDGETING_CAPABILITY :: RESERVED_0 [31:01] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_CAPABILITY_RESERVED_0_MASK   0xfffffffe
#define BCHP_PCIE_CFG_POWER_BUDGETING_CAPABILITY_RESERVED_0_SHIFT  1

/* PCIE_CFG :: POWER_BUDGETING_CAPABILITY :: LOM_CONFIGURATION [00:00] */
#define BCHP_PCIE_CFG_POWER_BUDGETING_CAPABILITY_LOM_CONFIGURATION_MASK 0x00000001
#define BCHP_PCIE_CFG_POWER_BUDGETING_CAPABILITY_LOM_CONFIGURATION_SHIFT 0

/***************************************************************************
 *FIRMWARE_POWER_BUDGETING_2_1 - FIRMWARE_POWER_BUDGETING_2_1 Register
 ***************************************************************************/
/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_2_1 :: POWER_RAIL_2 [31:29] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_POWER_RAIL_2_MASK 0xe0000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_POWER_RAIL_2_SHIFT 29

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_2_1 :: TYPE_2 [28:26] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_TYPE_2_MASK     0x1c000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_TYPE_2_SHIFT    26

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_2_1 :: PM_STATE_2 [25:24] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_PM_STATE_2_MASK 0x03000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_PM_STATE_2_SHIFT 24

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_2_1 :: BASE_POWER_2 [23:16] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_BASE_POWER_2_MASK 0x00ff0000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_BASE_POWER_2_SHIFT 16

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_2_1 :: POWER_RAIL_1 [15:13] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_POWER_RAIL_1_MASK 0x0000e000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_POWER_RAIL_1_SHIFT 13

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_2_1 :: TYPE_1 [12:10] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_TYPE_1_MASK     0x00001c00
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_TYPE_1_SHIFT    10

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_2_1 :: PM_STATE_1 [09:08] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_PM_STATE_1_MASK 0x00000300
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_PM_STATE_1_SHIFT 8

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_2_1 :: BASE_POWER_1 [07:00] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_BASE_POWER_1_MASK 0x000000ff
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_2_1_BASE_POWER_1_SHIFT 0

/***************************************************************************
 *FIRMWARE_POWER_BUDGETING_4_3 - FIRMWARE_POWER_BUDGETING_4_3 Register
 ***************************************************************************/
/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_4_3 :: POWER_RAIL_4 [31:29] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_POWER_RAIL_4_MASK 0xe0000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_POWER_RAIL_4_SHIFT 29

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_4_3 :: TYPE_4 [28:26] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_TYPE_4_MASK     0x1c000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_TYPE_4_SHIFT    26

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_4_3 :: PM_STATE_4 [25:24] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_PM_STATE_4_MASK 0x03000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_PM_STATE_4_SHIFT 24

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_4_3 :: BASE_POWER_4 [23:16] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_BASE_POWER_4_MASK 0x00ff0000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_BASE_POWER_4_SHIFT 16

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_4_3 :: POWER_RAIL_3 [15:13] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_POWER_RAIL_3_MASK 0x0000e000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_POWER_RAIL_3_SHIFT 13

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_4_3 :: TYPE_3 [12:10] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_TYPE_3_MASK     0x00001c00
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_TYPE_3_SHIFT    10

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_4_3 :: PM_STATE_3 [09:08] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_PM_STATE_3_MASK 0x00000300
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_PM_STATE_3_SHIFT 8

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_4_3 :: BASE_POWER_3 [07:00] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_BASE_POWER_3_MASK 0x000000ff
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_4_3_BASE_POWER_3_SHIFT 0

/***************************************************************************
 *FIRMWARE_POWER_BUDGETING_6_5 - FIRMWARE_POWER_BUDGETING_6_5 Register
 ***************************************************************************/
/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_6_5 :: POWER_RAIL_6 [31:29] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_POWER_RAIL_6_MASK 0xe0000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_POWER_RAIL_6_SHIFT 29

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_6_5 :: TYPE_6 [28:26] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_TYPE_6_MASK     0x1c000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_TYPE_6_SHIFT    26

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_6_5 :: PM_STATE_6 [25:24] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_PM_STATE_6_MASK 0x03000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_PM_STATE_6_SHIFT 24

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_6_5 :: BASE_POWER_6 [23:16] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_BASE_POWER_6_MASK 0x00ff0000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_BASE_POWER_6_SHIFT 16

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_6_5 :: POWER_RAIL_5 [15:13] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_POWER_RAIL_5_MASK 0x0000e000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_POWER_RAIL_5_SHIFT 13

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_6_5 :: TYPE_5 [12:10] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_TYPE_5_MASK     0x00001c00
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_TYPE_5_SHIFT    10

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_6_5 :: PM_STATE_5 [09:08] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_PM_STATE_5_MASK 0x00000300
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_PM_STATE_5_SHIFT 8

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_6_5 :: BASE_POWER_5 [07:00] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_BASE_POWER_5_MASK 0x000000ff
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_6_5_BASE_POWER_5_SHIFT 0

/***************************************************************************
 *FIRMWARE_POWER_BUDGETING_8_7 - FIRMWARE_POWER_BUDGETING_8_7 Register
 ***************************************************************************/
/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_8_7 :: POWER_RAIL_8 [31:29] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_POWER_RAIL_8_MASK 0xe0000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_POWER_RAIL_8_SHIFT 29

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_8_7 :: TYPE_8 [28:26] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_TYPE_8_MASK     0x1c000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_TYPE_8_SHIFT    26

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_8_7 :: PM_STATE_8 [25:24] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_PM_STATE_8_MASK 0x03000000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_PM_STATE_8_SHIFT 24

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_8_7 :: BASE_POWER_8 [23:16] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_BASE_POWER_8_MASK 0x00ff0000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_BASE_POWER_8_SHIFT 16

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_8_7 :: POWER_RAIL_7 [15:13] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_POWER_RAIL_7_MASK 0x0000e000
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_POWER_RAIL_7_SHIFT 13

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_8_7 :: TYPE_7 [12:10] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_TYPE_7_MASK     0x00001c00
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_TYPE_7_SHIFT    10

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_8_7 :: PM_STATE_7 [09:08] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_PM_STATE_7_MASK 0x00000300
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_PM_STATE_7_SHIFT 8

/* PCIE_CFG :: FIRMWARE_POWER_BUDGETING_8_7 :: BASE_POWER_7 [07:00] */
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_BASE_POWER_7_MASK 0x000000ff
#define BCHP_PCIE_CFG_FIRMWARE_POWER_BUDGETING_8_7_BASE_POWER_7_SHIFT 0

/***************************************************************************
 *PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING - PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING Register
 ***************************************************************************/
/* PCIE_CFG :: PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING :: UNUSED_0 [31:07] */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_UNUSED_0_MASK 0xffffff80
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_UNUSED_0_SHIFT 7

/* PCIE_CFG :: PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING :: D3HOT_MEMORY_READ_ADVISORY_NON_FATAL [06:06] */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_D3HOT_MEMORY_READ_ADVISORY_NON_FATAL_MASK 0x00000040
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_D3HOT_MEMORY_READ_ADVISORY_NON_FATAL_SHIFT 6

/* PCIE_CFG :: PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING :: RETRY_POISON_ENABLE [05:05] */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_RETRY_POISON_ENABLE_MASK 0x00000020
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_RETRY_POISON_ENABLE_SHIFT 5

/* PCIE_CFG :: PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING :: POISON_ADVISORY_NON_FATAL_ENABLE [04:04] */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_POISON_ADVISORY_NON_FATAL_ENABLE_MASK 0x00000010
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_POISON_ADVISORY_NON_FATAL_ENABLE_SHIFT 4

/* PCIE_CFG :: PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING :: UNEXPECTED_ADVISORY_NON_FATAL_ENABLE [03:03] */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_UNEXPECTED_ADVISORY_NON_FATAL_ENABLE_MASK 0x00000008
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_UNEXPECTED_ADVISORY_NON_FATAL_ENABLE_SHIFT 3

/* PCIE_CFG :: PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING :: NON_POSTED_CFG_ADVISORY_NON_FATAL_ENABLE [02:02] */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_NON_POSTED_CFG_ADVISORY_NON_FATAL_ENABLE_MASK 0x00000004
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_NON_POSTED_CFG_ADVISORY_NON_FATAL_ENABLE_SHIFT 2

/* PCIE_CFG :: PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING :: NP_MEMORY_READ_ADVISORY_NON_FATAL_ENABLE [01:01] */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_NP_MEMORY_READ_ADVISORY_NON_FATAL_ENABLE_MASK 0x00000002
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_NP_MEMORY_READ_ADVISORY_NON_FATAL_ENABLE_SHIFT 1

/* PCIE_CFG :: PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING :: COMPLETION_ABORT_MEMORY_READ_ADVISORY_NON_FATAL_ENABLE [00:00] */
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_COMPLETION_ABORT_MEMORY_READ_ADVISORY_NON_FATAL_ENABLE_MASK 0x00000001
#define BCHP_PCIE_CFG_PCIE_1_1_ADVISORY_NON_FATAL_ERROR_MASKING_COMPLETION_ABORT_MEMORY_READ_ADVISORY_NON_FATAL_ENABLE_SHIFT 0

#endif /* #ifndef BCHP_PCIE_CFG_H__ */

/* End of File */
