/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/macros/exceptionless_block_annotation.t.cpp
 *
 * @brief [LEVEL: beta] testing @ref
 * DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER and @ref
 * DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT
 *
 * $Id: exceptionless_block_annotation.t.cpp,v 1.14 2005/06/23 09:54:21 esdentem Exp $
 *
 * @author Christian Schallhart
 */

#include <diagnostics/unittest.hpp>

// component
#include <diagnostics/macros/exceptionless_block_annotation.hpp>

// backdoor
#include <diagnostics/unittest/test_system/current_test_logger.hpp>

// used component
#include <diagnostics/frame/logging_config.hpp>
#include <diagnostics/util/to_string.hpp>

// test support
#include <diagnostics/util/dummy_logger.ts.hpp>
#include <diagnostics/util/assert_record.ts.hpp>

#define TEST_COMPONENT_NAME exceptionless_block_annotation
#define TEST_COMPONENT_NAMESPACE diagnostics


DIAGNOSTICS_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;
using namespace unittest;
using ::diagnostics::unittest::internal::Current_Test_Logger;

#define STR_WHAT(e) (::std::string("EXCEPTION=\"") + e.name() + "\" WHAT=\"" + e.what() +"\"")

#define STR_WHAT_INT(e) (::std::string("EXCEPTION=\"int\" WHAT=\"") + ::diagnostics::internal::to_string(e)+"\"")

#define TEST_CASE(EXPLICIT_TE) \
{ \
    Dummy_Logger * logger=new Dummy_Logger; \
    Dummy_Logger::Records_t & records(logger->records()); \
    typedef Dummy_Logger::Records_t::iterator Iter_t; \
 \
    Logging_Config::register_logger(logger); \
 \
    Iter_t current(records.begin());  \
    TEST_ASSERT(current->type()==TYPE_LOG_OPEN); \
    ++current; \
 \
    TEST_NO_IMPLICIT_LOGGING_ENTER; \
    DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
    DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_PROD,10,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
    TEST_NO_IMPLICIT_LOGGING_EXIT; \
 \
    TEST_ASSERT(current==records.end()); \
     \
    if(rethrow) { \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
	throw Test_Exception("what"); \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_PROD,20,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT;	 \
	TEST_THROWING_BLOCK_EXIT1(Test_Exception,::std::string("what").c_str()); \
 \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
	throw 5; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_DEBUG,30,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT;	 \
	TEST_THROWING_BLOCK_EXIT(int); \
 \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
	throw 5; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_AUDIT,40,rethrow,EXPLICIT_TE,int,STR_WHAT_INT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT;	 \
	TEST_THROWING_BLOCK_EXIT(int); \
	 \
	TEST_THROWING_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
	throw Test_Exception("what1"); \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_TEST,50,rethrow,EXPLICIT_TE,int,STR_WHAT_INT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT;	 \
	TEST_THROWING_BLOCK_EXIT1(Test_Exception,::std::string("what1").c_str()); \
    } \
    else { \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
	throw Test_Exception("what"); \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_PROD,20,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT;	 \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
 \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
	throw 5; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_DEBUG,30,rethrow,EXPLICIT_TE, ::diagnostics::Exception,STR_WHAT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT;	 \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
 \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
	throw 5; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_AUDIT,40,rethrow,EXPLICIT_TE,int,STR_WHAT_INT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT;	 \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
	 \
	TEST_EXCEPTIONLESS_BLOCK_ENTER; \
	TEST_NO_IMPLICIT_LOGGING_ENTER; \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_ENTER; \
	throw Test_Exception("what1"); \
	DIAGNOSTICS_BASE_EXCEPTIONLESS_BLOCK_EXIT(LEVEL_TEST,50,rethrow,EXPLICIT_TE,int,STR_WHAT_INT); \
	TEST_NO_IMPLICIT_LOGGING_EXIT;	 \
	TEST_EXCEPTIONLESS_BLOCK_EXIT; \
    } \
    Logging_Config::unregister_logger(logger); \
 \
    current=records.begin();  \
    TEST_ASSERT(current->type()==TYPE_LOG_OPEN); \
    ++current; \
     \
    TEST_ASSERT_RECORD1(LEVEL_PROD,TYPE_UNEXPECTED_EXCEPTION,20,"EXCEPTION=\"Test_Exception\" WHAT=\"what\""); \
    ++current; \
    TEST_ASSERT_RECORD1(LEVEL_DEBUG,TYPE_UNEXPECTED_EXCEPTION,30,"Unknown Exception"); \
    ++current; \
    TEST_ASSERT_RECORD1(LEVEL_AUDIT,TYPE_UNEXPECTED_EXCEPTION,40,"EXCEPTION=\"int\" WHAT=\"5\""); \
    ++current; \
    if(EXPLICIT_TE==1) \
	TEST_ASSERT_RECORD1(LEVEL_TEST,TYPE_UNEXPECTED_EXCEPTION,50,"EXCEPTION=\"Test_Exception\" WHAT=\"what1\""); \
    else  \
	TEST_ASSERT_RECORD1(LEVEL_TEST,TYPE_UNEXPECTED_EXCEPTION,50,"Unknown Exception"); \
    ++current; \
 \
    TEST_ASSERT(current->type()==TYPE_LOG_CLOSE); \
    TEST_ASSERT(current+1==records.end());  \
    delete logger; \
 \
} 


void no_explicit_te(bool const rethrow)
    TEST_CASE(0)
void explicit_te(bool const rethrow)
    TEST_CASE(1)


void no_explicit_te_rethrow(Test_Data & data)
{
    no_explicit_te(true);
}

void no_explicit_te_norethrow(Test_Data & data)
{
    no_explicit_te(false);
}

void explicit_te_rethrow(Test_Data & data)
{
    explicit_te(true);
}

void explicit_te_norethrow(Test_Data & data)
{
    explicit_te(false);
}

TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&no_explicit_te_rethrow,LEVEL_PROD);
TEST_NORMAL_CASE(&no_explicit_te_norethrow,LEVEL_PROD);
TEST_NORMAL_CASE(&explicit_te_rethrow,LEVEL_PROD);
TEST_NORMAL_CASE(&explicit_te_norethrow,LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;

// vim:ts=4:sw=4
